// -w240 -h180 +a0.3
camera { location  <-5, 5, -30> look_at <0, 0, 0> angle 25}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}


#declare Fx = function(u,v)   {u}
#declare Fy = function(u,v,a) {a*pow(u,4) +u*u*v - v*v}
#declare Fz = function(u,v)   {v}


parametric {
  function {Fx(u,v)}
  function {Fy(u,v,-0.1)}
  function {Fz(u,v)}
      <-10,-10>,<10,10>
  contained_by{box{-4,4}}
  precompute 18, x,y,z
    pigment {rgb 0.9}
    finish {
      phong 0.5
      phong_size 10
      }
  no_shadow
}
