//Cosinus

camera { location  <0, 0, -30> look_at <0, 0, 0> angle 8}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}


#declare Fx = function(u,v){ u }
#declare Fy = function(u,v){ v }
#declare Fz = function(u,v){ sin(pi*(u*u + v*v))/4 }

#include "param.inc"


object {Parametric(Fx,Fy,Fz,<-1.5,-1.5>,<1.5,1.5>,100,100,"")
  pigment {uv_mapping checker rgb 0.95 rgb 0.85 scale 0.15}
  finish {phong 0.5 phong_size 10 ambient 0.3}
  rotate <20,20,0>
}
