// Breather Surface

camera { location  <30, 10, -30> look_at <0, 0, 0> angle 15}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

#declare aa = 0.45;  // Values from 0.4 to 0.6 produce sensible results

#declare w1 = 1 - aa * aa;
#declare w = sqrt(w1);
#declare d = function(u,v){ aa * (pow((w * cosh(aa * u)),2) + pow((aa * sin(w * v)),2))}


#declare Fx = function(u,v){ -u + (2 * w1 * cosh(aa * u) * sinh(aa * u) / d(u,v)) }
#declare Fy = function(u,v){2 * w * cosh(aa * u) * (-(w * cos(v) * cos(w * v)) - (sin(v) * sin(w * v))) / d(u,v)}
#declare Fz = function(u,v){2 * w * cosh(aa * u) * (-(w * sin(v) * cos(w * v)) + (cos(v) * sin(w * v))) / d(u,v)}

#include "param.inc"

object {Parametric(Fx,Fy,Fz,<-20,0>,<20,12.5/aa/aa>,200,200,"")
  pigment {uv_mapping checker rgb 0.9 rgb 0.8 scale 0.6}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
