
camera { location  <0, 0, -2.1> look_at <0, 0, 0>}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 rgb <.3,.3,.8>] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

#declare R = function(u,v){
    max(abs(sin(4*u)), 0.9-0.2*abs(cos(8*u)))
    *cos(v)*cos(v)
}

#declare Fx= function(u,v){R(u,v)*cos(u)*cos(v)}
#declare Fy= function(u,v){R(u,v)*sin(u)*cos(v)}
#declare Fz= function(u,v){R(u,v)*sin(v)*0.5}

#include "param.inc"

object{
    Parametric(
       Fx, Fy, Fz,
       <0,0>,<pi,2*pi>,
       150,70,""
    )
  pigment {rgb 1}
  finish {phong 0.5 phong_size 10}
  normal {bumps 0.1 scale 0.01}
  no_shadow
}
sphere {-0.2*z,0.2
  scale <1,1,0.5>
  pigment {rgb 1}
  finish {phong 0.5 phong_size 10}
  normal {bumps 0.1 scale 0.01}
  no_shadow
}

