#declare R=2;

camera { location  <2*R, 2*R, -4*R> look_at <0, -2.5, 0> angle 40}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------
                                
                                

#declare Fx = function(u,v) {sin(u)}
#declare Fz = function(u,v) {cos(u+v)}
#declare Fy = function(u,v) {-abs(v)/2}
                        
#include "param.inc"

object {Parametric(Fx,Fy,Fz,<-pi,-16>,<pi,16>,50,250,"")
  pigment {rgb 0.9}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
      
