#declare R=2;

camera { location  <4*R, 2*R, -4*R> look_at <0, 0.3, 0> angle 20}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------
                                
                                
//Dini's surface
//Dini's surface of constant negative curvature. Looks like a flower


#declare A=1;
#declare B=0.2;

#declare Fx = function(u,v) {A*cos(u)*sin(v)}
#declare Fy = function(u,v) {A*sin(u)*sin(v)}

// For some reason, "param.inc" seems to attempt to evaluate this outside the
// valid range for ln(tan(v/2)) so we need to add the abs()
#declare Fz = function(u,v) {A*(cos(v)+ln(abs(tan(v/2)))) + B*u}

#declare Umin=-2*pi;
#declare Umax= 4*pi;
#declare Vmin=0.001;
#declare Vmax=2.1;

#declare Iter_U = 100;
#declare Iter_V = 30;

#include "param.inc"

object {Parametric(Fx,Fy,Fz,<-2*pi,0.001>,<4*pi,2.1>,100,30,"")
  pigment {rgb 0.9}
  finish {phong 0.5 phong_size 10}
  no_shadow 
  rotate x*90
}
      
