#declare R=2.05;

camera { location  <1*R, 1*R, -4*R> look_at <0, 0, 0> angle 30}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------
                                
//Bohemian Dome 


//Okay - take a deep breath.
//If you rotate a circle which is parallell to a plane in a circle that is perpendicular
// to the same plane, the resulting envelope is a Bohemian dome.



#declare A=0.5;
#declare B=1.5;
#declare C=1.0;                                
                                

#declare Fx = function(u,v) {A*cos(u)}
#declare Fy = function(u,v) {B*cos(v)+A*sin(u)}
#declare Fz = function(u,v) {C*sin(v)}

#declare Umin=0;
#declare Umax=2*pi;
#declare Vmin=0;
#declare Vmax=2*pi;

#declare Iter_U = 10;
#declare Iter_V = 30;

#include "paramx.inc"
Parametric()


object {Lynks
  pigment {rgb 0.9}
  finish {phong 0.5 phong_size 10}
  no_shadow
  rotate <0,90,90>
}

object {Surface
  pigment {rgb <0.9,0.7,0.3>}
  finish {phong 0.5 phong_size 10}
  no_shadow
  rotate <0,90,90>
}
