#include "functions.inc"

#declare R=10;
#declare R1=R+0.01;
#declare Box = 0;

camera { location  <0*R, 1*R, -4*R> look_at <0, 0, 0> angle 13}

sky_sphere { pigment {
    function {abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------

isosurface {
  function { f_klein_bottle(x,y,z,-1)}
        max_gradient 29300
        #if (Box=0)
           contained_by{sphere {0,R}} open
        #else
          contained_by{box {<-R,-R,-0>,R}} open
        #end
        pigment {rgbt <.9,.9,.9,.5>}
        finish {phong 0.5 phong_size 10}
}
