#include "functions.inc"

#declare R=3;
#declare R1=R+0.01;
#declare Box = 0;

camera { location  <2*R, 1*R, -4*R> look_at <0, 0, 0> angle 30}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}

// ----------------------------------------

isosurface {
  function { f_folium_surface_2d(x,y,z,0.01,1,1,1,0,0)}
        max_gradient 2
        #if (Box=0)
           contained_by{sphere {0,R}} open
        #else
          contained_by{box {<-R,-R,-0>,R}} open
        #end
        pigment {rgb .9}
        finish {phong 0.5 phong_size 10}
}
      
#if (Box=0)
  sphere {0,R pigment {rgbt <1,0,0,0.9>}}
#else
  box {<-R,-R,-0.01>,R1 pigment {rgbt <1,0,0,0.9>}}
#end
