// -w240 -h180 +a0.3
#include "functions.inc"

camera { location  <-5, 2, -4> look_at <0, -0.5, 0> angle 20}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] } 
  }
}

light_source {<-100,200,-100> colour rgb 0.6}
light_source {<0,-200,-100> colour rgb 0.6}

#declare R = 1.2;

// ----------------------------------------

#declare  F = function {y
         +f_noise3d(x*2, 0, z*2)
}

isosurface {
  function { abs(F(x,y,z))-0.1 }
        max_gradient 2
        contained_by{box{-R,R}}
        pigment {rgb 1}
        finish {phong 0.5 phong_size 10}
}
