
#declare R=5;
#declare R1=R+0.01;
#declare Box = 0;

camera { location  <1*R, 2*R, -4*R> look_at <0, 0, 0> angle 32}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------

#declare F = function {x*y*y -y*z -x*z*z }

isosurface {
  function { F(x,y,z)}
        max_gradient 30
        #if (Box=0)
           contained_by{sphere {0,R}}  open
        #else
          contained_by{box {<-R,-R,-0>,R}} open
        #end
        pigment {rgb 0.9}
        finish {phong 0.5 phong_size 10}
        no_shadow
}
      
#if (Box=0)
  sphere {0,R pigment {rgbt <1,0,0,0.9>}}
#else
  box {<-R,-R,-0.01>,R1 pigment {rgbt <1,0,0,0.9>}}
#end
