
#declare V1=<-0.8,-0.8,-0.8>;
#declare V2=<0.6,1.7,0.2>;

camera { location  <2, 4, -8> look_at <0, 0.5, 0> angle 20}
//camera { location  <-8, 0, 0> look_at <0, 0.5, 0> angle 40 orthographic}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------


#declare Fx = function {1 -u*u +u*u*sin(v)*sin(v)}
#declare Fy = function {u*u*sin(v)*sin(v)  +2*u*u*sin(v)*cos(v)}
#declare Fz = function {sqrt((1-u*u)/2)*u*(sin(v)+cos(v))}



parametric {
  function {Fx(u,v,0)}
  function {Fy(u,v,0)}
  function {Fz(u,v,0)}
      <0,0>,<1,2*pi>
  contained_by{box{V1,V2}}
  max_gradient 10
  accuracy 0.00001
  precompute 20, x,y,z
  pigment {rgb 0.9}
  finish {phong 0.5 phong_size 10}
  no_shadow
  rotate y*100
}
      

 // box {V1,V2 pigment {rgbt <1,0,0,0.9>}}
