// -w240 -h180 +a0.3
#include "functions.inc"

camera { location  <0, 0, -4> look_at <0, 0, 0> angle 40}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] } 
  }
}

light_source {<-100,200,-100> colour rgb 1}

#declare R = 1.1;

// ----------------------------------------

#declare  S = function {x*x + y*y + z*z - 1}

isosurface {
  function { S(x,y,z) + 
  f_noise3d(x*10, y*10, z*10)*0.3 }
        max_gradient 7
        contained_by{sphere{0,R}}
        pigment {rgb .9}
        finish {phong 0.5 phong_size 10}
}
      

sphere {0,R pigment {rgbt <1,0,0,0.9>}}
