#include "functions.inc"

#declare R=1.5;
#declare R1=R+0.01;
#declare Box = 1;

camera { location  <-3*R, 2*R, -4*R> look_at <0, -0.3, 0> angle 20}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<-100,200,-100> colour rgb 1}

// ----------------------------------------

isosurface {
  function { f_odd(x,y,z,-1)}
        max_gradient 20
        #if (Box=0)
           contained_by{sphere {0,R}}
        #else
          contained_by{box {<-R,0,-R>,R}}
        #end
        pigment {rgb .9}
        finish {phong 0.5 phong_size 10}
        scale <1,-1,1>
}
      
#if (Box=0)
  sphere {0,R pigment {rgbt <1,0,0,0.9>}}
#else
//  box {<-R,-0.01,-R>,R1 pigment {rgbt <1,0,0,0.9>}
//        scale <1,-1,1>                             }
#end
