
camera { location  <4, 0, -5> look_at <0, 0.25, 0> angle 17}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1.2}

// ----------------------------------------


// This spline describes the path along the object
// From control points 0 to 1

#declare USpline =
   spline {
     natural_spline
    0,    < -1, 0.5, 0.0>,
    0.25, < -0.5, 0.2, 0.4>,
    0.5,  < 0.01, 0.2, 0.2>,
    0.75, < 0.5, 0.4, 0.4>,
    1,    < 1, 0.0,-0.6>,
   }

// This spline describes the cross section of the object
// For a closed shape the spline should have the same values at control points 0 and 1 
// The z coordinate is not used
#declare VSpline =
  spline {
    natural_spline
   -0.25,  < 0,-1,0>,
    0,     < 1, 0,0>,
    0.25,  < 0, 1,0>,
    0.5,   <-1, 0,0>,
    0.75,  < 0,-1,0>,
    1,     < 1, 0,0>
    1.25,  < 0, 1,0>,
  }

// This spline describes how the width varies 
#declare WSpline = spline {
  cubic_spline
    -1, 0.1,  // Control Pont
    0.0, 0.15,
    0.8, 0.1,
    1.0, 0.15,
    2.0, 0.2  // Control Point
 }

#declare Upoints = 50;  // Number of points along
#declare Vpoints = 50;  // Number of points around
#declare Filename = ""

#include "SweepSpline.inc"
object {
  SweepSpline(USpline, VSpline, WSpline, Upoints, Vpoints, Filename)
        pigment {rgb <1,1,1>}
        finish {phong 0.5 phong_size 10}
}


// FOr some surfaces the previous version of SweepSpline might 
// possibly look a little better. The new version has a completely
// different algorithm for finding the normals. To use the old
// version use 
//    #include "SweepSplineV2.inc"
// instead



#declare ctr = 0;
#while (ctr < 1)
  sphere {<USpline(ctr).x, USpline(ctr).y, USpline(ctr).z> ,.04  pigment { rgb <1,1,0> }}
  #declare ctr = ctr + 0.002;
#end
