// Running a prism along a curved spline

#version 3.5;

camera { location  <3, 0, -5> look_at <0, 0.25, 0> angle 24}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-500> colour rgb 1}

// The curved open spline 
#declare S = function {
   spline {
     natural_spline
      -1, < 0, 0.5, 0.0>,
    -0.5, < 0, 0.2, 0.4>,
    0.01, < 0, 0.2, 0.2>,
     0.5, < 0, 0.4, 0.4>,
       1, < 0, 0.0, 0.0>
   }
 }

// The closed spline (prism) ("P" pointed star)
#declare P=5;   //Number of points
#declare R1=0.5;//Outer radius
#declare R2=0.2;//Inner radius 

#declare H=pi/P;
#declare A=H*2;
#declare I=1;
#declare S2 = function {
  spline {
    cubic_spline 
    #while (I<P+3)
      I,     <0, sin(I*A)*R1, cos(I*A)*R1>,
      I+0.5, <0, sin(I*A+H)*R2, cos(I*A+H)*R2>,
      #declare I=I+1;
    #end    
  }
}

#declare Fx = function(x,y) {u}
#declare Fy = function(x,y) {S(u).y + S2(v).y}
#declare Fz = function(x,y) {S(u).z + S2(v).z}

#include "param.inc"

object {Parametric(Fx,Fy,Fz,<-1,2>,<1,P+2>,50,50,"")
        pigment {rgb .9}
        finish {phong 0.5 phong_size 10 ambient 0.2}
} 

