
#declare R=2;

camera { location  <1*R, 2*R, -4*R> look_at <0, 0, 0> angle 40}

sky_sphere { pigment {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------
                                
                                
#declare Turns=3;
#declare r1 = 0.3;
#declare r2 = 1.0;
#declare Flute = 0.04;
#declare Freq  = 24;


#declare Fx = function {r1*sin(u*Turns) + r2*cos(v) + Flute*sin(Freq*v)}
#declare Fy = function {u}
#declare Fz = function {r1*cos(u*Turns) + r2*sin(v) + Flute*sin(Freq*v)}
                        
#declare U1 = -1*pi;
#declare U2 =  1*pi;
#declare V1 = -1*pi;                       
#declare V2 =  1*pi;

parametric {
  function {Fx(u,v,0)}
  function {Fy(u,v,0)}
  function {Fz(u,v,0)}
      <U1,V1>,<U2,V2>
  contained_by{box{<-R,-R,-R>,<R,R,R>}}
  accuracy 0.001
  max_gradient 1
  precompute 18, x,y,z
  pigment {rgb 0.9}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
      
