#declare R=1.1;

camera { location  <1*R, 2*R, -4*R> look_at <0, 0, 0> angle 40}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------


#declare F1 = function {u*v*sin(15*v)}
#declare F2 = function {u*v*cos(15*v)}



parametric {
  function {F1(u,v,0)}
  function {v}
  function {F2(u,v,0)}
      <0,-1>,<1,1>
  contained_by{box{<-R,-R,-R>,<R,R,R>}}
  precompute 18, x,y,z
  pigment {rgb 0.9}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
