var GLOBAL_Symbols = null;

function PrintSymbols()
{
  var tfreq = document.getElementById("dec-text").value.length;

  var table = document.getElementById("symbols");
  table.innerHTML = "";
  PrintSymbolHeader(table);

  var list = GLOBAL_Symbols;
  var tbits = 0;
  while (list != null)
  {
    PrintSymbol(table, list.Data, tfreq);
    tbits = tbits + list.Data.Code.length * list.Data.Freq;
    list = list.Next;
  }

  PrintSymbolFooter(table, tfreq, tbits);
}

function PrintSymbolHeader(table)
{
  var row = document.createElement("tr");
  PrintHeaderCell(row, "Character");
  PrintHeaderCell(row, "Count");
  PrintHeaderCell(row, "Pr");
  PrintHeaderCell(row, "Log<sub>2</sub>(Pr)");
  PrintHeaderCell(row, "Code");
  PrintHeaderCell(row, "Bits");
  PrintHeaderCell(row, "Error");
  PrintHeaderCell(row, "Count \u00D7 Bits");
  table.appendChild(row);
}

function PrintSymbol(table, leaf, tfreq)
{
  var prob = leaf.Freq / tfreq;
  var lprob = Math.log(prob) / Math.log(2);

  var row = document.createElement("tr");
  row.id = "symbol-" + leaf.ID;
  PrintCell(row, "center", EscapeChar(leaf.Symbol));
  PrintCell(row,  "right", leaf.Freq);
  PrintCell(row,   "left", Decimal( prob, false));
  PrintCell(row,   "left", Decimal(lprob,  true));
  PrintCell(row,   "left", "<code>[" + leaf.Code + "]</code>");
  PrintCell(row,  "right", leaf.Code.length);
  PrintCell(row,   "left", Decimal(leaf.Code.length - Math.abs(lprob), true));
  PrintCell(row,  "right", leaf.Freq * leaf.Code.length);
  table.appendChild(row);
}

function PrintSymbolFooter(table, tfreq, tbits)
{
  var row = document.createElement("tr");
  PrintHeaderCell(row, "Total");
  PrintCell(row,  "right", tfreq);
  PrintCell(row,   "left", Decimal(1, false));
  PrintCell(row,   "left", "");
  PrintCell(row,   "left", ""); row.children[4].id = "next-code";
  PrintCell(row,  "right", "");
  PrintCell(row,   "left", "");
  PrintCell(row,  "right", tbits);
  table.appendChild(row);
}

function PrintHeaderCell(row, content)
{
  var cell = document.createElement("th");
  cell.innerHTML = content;
  row.appendChild(cell);
}

function PrintCell(row, align, content)
{
  var cell = document.createElement("td");
  cell.setAttribute("align", align);
  cell.innerHTML = content;
  row.appendChild(cell);
}

function EscapeChar(c)
{
  return "<code>[" + c + "]</code>";
}

function RowsSetClass(tree, class_name)
{
  var dom = document.getElementById("symbol-" + tree.ID);
  if (dom != null) dom.setAttribute("class", class_name);
  if (!tree.IsLeaf)
  {
    RowsSetClass(tree.Child0, class_name);
    RowsSetClass(tree.Child1, class_name);
  }
}
