var GLOBAL_EncIndex = null;
var GLOBAL_DecIndex = null;
var GLOBAL_EncEOF = false;
var GLOBAL_DecEOF = false;

function ResetEnc()
{
  GLOBAL_EncIndex = 0;
  var dom  = document.getElementById("enc-text");
  var text = dom.value;
  GLOBAL_EncEOF = GLOBAL_EncIndex >= text.length;
  dom.setSelectionRange(0, 0);
}

function ResetDec()
{
  GLOBAL_DecIndex = 0;
  var dom  = document.getElementById("dec-text");
  var text = dom.value;
  GLOBAL_DecEOF = GLOBAL_DecIndex >= text.length;
  dom.setSelectionRange(0, 0);
}

function GetEncChar()
{
  if (GLOBAL_EncIndex == null) Error("GetEncChar(): GLOBAL_EncIndex is null.");
  if (GLOBAL_EncEOF)           Error("GetEncChar(): End of input.");

  var dom  = document.getElementById("enc-text");
  var text = dom.value;

  var c = text[GLOBAL_EncIndex];
  GLOBAL_EncIndex++;
  GLOBAL_EncEOF = GLOBAL_EncIndex >= text.length;
  dom.setSelectionRange(0, GLOBAL_EncIndex);
  return c;
}

function GetDecChar()
{
  if (GLOBAL_DecIndex == null) Error("GetDecChar(): GLOBAL_DecIndex is null.");
  if (GLOBAL_DecEOF)           Error("GetDecChar(): End of input.");

  var dom  = document.getElementById("dec-text");
  var text = dom.value;

  var c = text[GLOBAL_DecIndex];
  GLOBAL_DecIndex++;
  GLOBAL_DecEOF = GLOBAL_DecIndex >= text.length;
  dom.setSelectionRange(0, GLOBAL_DecIndex);
  return c;
}

function PeekEncChar(index)
{
  if (GLOBAL_EncIndex == null) Error("PeekEncChar(): GLOBAL_EncIndex is null.");

  var text = document.getElementById("enc-text").value;
  if (GLOBAL_EncIndex + index >= text.length) Error("PeekEncChar(): Index out of range.");
  return text[GLOBAL_EncIndex + index];
}

function PeekDecChar(index)
{
  if (GLOBAL_DecIndex == null) Error("PeekDecChar(): GLOBAL_DecIndex is null.");

  var text = document.getElementById("dec-text").value;
  if (GLOBAL_DecIndex + index >= text.length) Error("PeekDecChar(): Index out of range.");
  return text[GLOBAL_DecIndex + index];
}

function WriteEnc(txt)
{
  var dom = document.getElementById("enc-text");
  var i0 = dom.value.length;
  dom.value = dom.value + txt;
  var i1 = dom.value.length;
  dom.setSelectionRange(i0, i1);
}

function WriteDec(txt)
{
  var dom = document.getElementById("dec-text");
  var i0 = dom.value.length;
  dom.value = dom.value + txt;
  var i1 = dom.value.length;
  dom.setSelectionRange(i0, i1);
}
