var GLOBAL_Steps = null;

function StepInfo(title, fn)
{
  this.Title    = title;
  this.StepFn   = fn;
  this.NextStep = null;

  this.Copy     = StepInfo_Copy;
  this.GetTitle = StepInfo_GetTitle;
  this.DoStep   = StepInfo_DoStep;
  this.DoneStep = StepInfo_DoneStep;
}

function StepInfo_Sub(title, sub)
{
  this.Title    = title;
  this.NextStep = null;
  this.SubStep  = sub;

  this.Copy     = StepInfo_Sub_Copy;
  this.GetTitle = StepInfo_Sub_GetTitle;
  this.DoStep   = StepInfo_Sub_DoStep;
  this.DoneStep = StepInfo_DoneStep;
}

function StepInfo_While(title, predicate, sub)
{
  this.Title    = title;
  this.NextStep = null;
  this.Pred     = predicate;
  this.SubStep  = sub;
  this.SubLoop  = sub;

  this.Copy     = StepInfo_While_Copy;
  this.GetTitle = StepInfo_Sub_GetTitle;
  this.DoStep   = StepInfo_While_DoStep;
  this.DoneStep = StepInfo_DoneStep;
}

//-------------------------------------------------------//

function StepInfo_Copy()
{
  var out = new StepInfo(this.Title, this.StepFn);
  out.NextStep = this.NextStep;
  return out;
}

function StepInfo_Sub_Copy()
{
  var out = new StepInfo_Sub(this.Title, this.SubStep);
  out.NextStep = this.NextStep;
  return out;
}

function StepInfo_While_Copy()
{
  var out = new StepInfo_While(this.Title, this.Pred, this.SubStep);
  out.NextStep = this.NextStep;
  out.SubLoop  = this.SubLoop;
  return out;
}

//-------------------------------------------------------//

function StepInfo_GetTitle(n)
{
  if (n == 0) return this.Title;
  return null;
}

function StepInfo_Sub_GetTitle(n)
{
  if (n == 0) return this.Title;
  if (this.SubStep == null) return null;
  return this.SubStep.GetTitle(n-1);
}

//-------------------------------------------------------//

function StepInfo_DoStep(n)
{
  if (n == 0) return this.StepFn();
  Error("StepInfo_DoStep(" + n + "): Invalid depth.");
}

function StepInfo_Sub_DoStep(n)
{
  if (n == 0)
  {
    var out = this.Copy();
    while (out.SubStep != null) out.SubStep = out.SubStep.DoStep(0);
    return this.NextStep;
  }

  if (this.SubStep == null) Error("StepInfo_Sub_DoStep(" + n + "): Invalid depth.");

  var out = this.Copy();
  out.SubStep = out.SubStep.DoStep(n-1);
  if (out.SubStep == null) return this.NextStep;
  else                     return out;
}

function StepInfo_While_DoStep(n)
{
  if (n == 0)
  {
    var out = this.Copy();
    while (out.SubStep != null) out.SubStep = out.SubStep.DoStep(0);

    if (this.Pred())
    {
      out.SubStep = out.SubLoop;
      return out;
    }
    else return this.NextStep;
  }

  if (this.SubStep == null) Error("StepInfo_While_DoStep(" + n + "): Invalid depth.");

  var out = this.Copy();
  out.SubStep = out.SubStep.DoStep(n-1);
  if (out.SubStep != null) return out;
  if (this.Pred())
  {
    out.SubStep = out.SubLoop;
    return out;
  }
  else return this.NextStep;
}

//-------------------------------------------------------//

function StepInfo_DoneStep()
{
  return this.NextStep;
}

/////////////////////////////////////////////////////////////////////

function DisableUI()
{
  document.getElementById("dec-text"    ).readOnly = true;
  document.getElementById("enc-text"    ).readOnly = true;
  document.getElementById("cmd-enc"     ).disabled = true;
  document.getElementById("cmd-dec"     ).disabled = true;
  document.getElementById("cmd-step-enc").disabled = true;
  document.getElementById("cmd-step-dec").disabled = true;
  document.getElementById("cmd-step1"   ).disabled = true;
  document.getElementById("cmd-step2"   ).disabled = true;
  document.getElementById("cmd-step3"   ).disabled = true;
  document.getElementById("cmd-abort"   ).disabled = true;
}

function UpdateUI()
{
  var step = null;
  var dom  = null;

  if (GLOBAL_Steps != null)
  {
    step = GLOBAL_Steps.GetTitle(0);
    dom  = document.getElementById("cmd-step1");
    if (step == null) dom.value = Minus();
    else              dom.value = step;
    dom.disabled = (step == null);

    step = GLOBAL_Steps.GetTitle(1);
    dom = document.getElementById("cmd-step2");
    if (step == null) dom.value = Minus();
    else              dom.value = step;
    dom.disabled = (step == null);

    step = GLOBAL_Steps.GetTitle(2);
    dom = document.getElementById("cmd-step3");
    if (step == null) dom.value = Minus();
    else              dom.value = step;
    dom.disabled = (step == null);
  }
  else
  {
    document.getElementById("cmd-step1").value = Minus();
    document.getElementById("cmd-step2").value = Minus();
    document.getElementById("cmd-step3").value = Minus();
  }

  dom = document.getElementById("cmd-abort");
  if (GLOBAL_Steps != null)
  {
    dom.value    = "Abort";
    dom.disabled = false;
  }
  else
  {
    dom.value    = Minus();
    dom.disabled = true;

    document.getElementById("dec-text"    ).readOnly = false;
    document.getElementById("enc-text"    ).readOnly = false;
    document.getElementById("cmd-enc"     ).disabled = false;
    document.getElementById("cmd-dec"     ).disabled = false;
    document.getElementById("cmd-step-enc").disabled = false;
    document.getElementById("cmd-step-dec").disabled = false;
  }
}

/////////////////////////////////////////////////////////////////////

function CMD_Init()
{
  PrintStatsDec();
  PrintStatsEnc();
  PrintStatsFinal();
  PrintSymbols();
  DrawForest();
  UpdateUI();
}

function CMD_Compress()
{
  DisableUI();
  UI_InitCompress();
  while (GLOBAL_Steps != null) GLOBAL_Steps = GLOBAL_Steps.DoStep(0);
  UpdateUI();
}

function CMD_StepCompress()
{
  DisableUI();
  UI_InitCompress();
  UpdateUI();
}

function CMD_Decompress() {alert("Decompress: Not implemented.");}
function CMD_StepDecompress() {alert("Step Decompress: Not implemented.");}

function CMD_Step(n)
{
  DisableUI();
  if (GLOBAL_Steps != null) GLOBAL_Steps = GLOBAL_Steps.DoStep(n-1);
  UpdateUI();
}

function CMD_Abort()
{
  DisableUI();
  GLOBAL_Steps = null;
  UpdateUI();

  GLOBAL_Symbols = null; // Free memory.
  GLOBAL_Forest  = null; // Free memory.
  GLOBAL_NodeID  = 0;
}
