function Heap(compare)
{
  this.Compare   = compare;
  this.Root      = null;
  this.Size      = 0;
  this.Insert    = Heap_Insert;
  this.GetMin    = Heap_GetMin;
  this.DeleteMin = Heap_DeleteMin;
}

function HeapNode(x, c0, c1)
{
  this.Data   = x;
  this.Child0 = c0;
  this.Child1 = c1;
  this.Insert = HeapNode_Insert;
  this.Delete = HeapNode_Delete;
}

function Heap_Insert(x)
{
  var out = new Heap(this.Compare);

  if (this.Root == null) out.Root = new HeapNode(x, null, null);
  else                   out.Root = this.Root.Insert(this.Compare, x);

  out.Size = this.Size + 1;
  return out;
}

function HeapNode_Insert(compare, x)
{
  var min = x;
  var max = this.Data;

  if (compare(this.Data, x))
  {
    min = this.Data;
    max = x;
  }

  if (this.Child0 == null) return new HeapNode(min, this.Child1, new HeapNode(max, null, null))
  else                     return new HeapNode(min, this.Child1, this.Child0.Insert(compare, max));
}

function Heap_GetMin()
{
  if (this.Root == null) return null;
  return this.Root.Data;
}

function Heap_DeleteMin()
{
  if (this.Root == null) return this;

  var out  = new Heap(this.Compare);
  out.Root = this.Root.Delete(this.Compare);
  out.Size = this.Size - 1;
  return out;
}

function HeapNode_Delete(compare)
{
  if (this.Child0 == null) return this.Child1;
  if (this.Child1 == null) return this.Child0;

  if (compare(this.Child0.Data, this.Child1.Data)) return new HeapNode(this.Child0.Data, this.Child1, this.Child0.Delete(compare));
  else                                             return new HeapNode(this.Child1.Data, this.Child0, this.Child1.Delete(compare));
}

function DefaultCompare(x, y) {return x < y;}
