// MESH.FX
//
// FX file for rendering meshes, including single rendering and multi-rendering
// with VS constant instancing


// data from code

float4x4 mWorldViewProj : WORLDVIEWPROJECTION;
float3   lightPos1;
float3   camPos;
float4   gridCol1 = float4( 0.2 , 0.42 , 0.2 , 0 );
float4   gridCol2 = float4( 0.12 , 0.12 , 0.1 , 0 );
float wavyAmount;
float gridThickness;
float zoomX=0 , zoomY=0;

float ambient = 0.2;



// Vertex Shader
struct VS_INPUT
{
	float3 pos    : POSITION;
	float2 tex    : TEXCOORD0;
	float3 normal : TEXCOORD1;
};


struct VS_OUTPUT
{
	float4 pos      : POSITION;
	float2 tex      : TEXCOORD0;
	float3 worldPos : TEXCOORD1;
	float3 normal   : TEXCOORD2;
};


VS_OUTPUT VS_GridLines( VS_INPUT vs_in )
{
	VS_OUTPUT Out = (VS_OUTPUT)0;
	
	Out.worldPos = vs_in.pos;
	Out.pos = mul( float4( vs_in.pos , 1.0 ) , mWorldViewProj );
    Out.tex = vs_in.tex / 2 + float2(zoomY*(abs(vs_in.normal.y+vs_in.normal.z)),zoomX*(abs(vs_in.normal.x+vs_in.normal.y))); // a grid line every 2 metres
    Out.normal = vs_in.normal;
	
	return Out;
}



// Write an RGB image to the FP format
float4 PS_GridLines(VS_OUTPUT ps_in) : COLOR
{
	float4 pixel , surfaceColour;
	float gl1 , gl2 , gl3;
	

	
	float lightDist , brightness , diffuse;
	
	float3 pixelToLight;
	
	gl1 = step( gridThickness , frac( ps_in.tex.x + wavyAmount*sin(ps_in.tex.y)) );
	gl2 = step( gridThickness , frac( ps_in.tex.y + wavyAmount*sin(ps_in.tex.x)) );
	gl3 = clamp( gl1 + gl2  , 0.0 , 1.0 );

	surfaceColour = lerp( gridCol2 , gridCol1 , gl3 );
	
	pixel = float4(0,0,0,0);
	
	// light 1 diffuse
	
	// find distance to light for 1/r2 attenuation
	lightDist = distance( lightPos1 , ps_in.worldPos );
	brightness = 200 / (lightDist*lightDist);
	
	// find normal for diffuse lighting
	pixelToLight = normalize( lightPos1 - ps_in.worldPos );
	diffuse = dot( pixelToLight , ps_in.normal );
	
	pixel += surfaceColour * (diffuse * brightness + ambient);

/*
	// specular lighting
	float3 reflection;
	float specular;
		
	reflection = reflect( normalize( ps_in.worldPos - camPos ) ,  ps_in.normal );
	
	specular = pow( dot( reflection , pixelToLight ) , 20 );

	pixel += specular;
*/
	

	
		
	return pixel;

}



// FX file info

technique GridLines
{
	pass P0
	{
		ZEnable = true;
		ZWriteEnable = true;
		
		AlphaBlendEnable = false;
		AlphaTestEnable = false;
		
		VertexShader = compile vs_2_0 VS_GridLines();
		PixelShader = compile ps_2_0 PS_GridLines();
	}
}

