global_settings {
  assumed_gamma 1
  max_trace_level 15
}

background { rgb 3/4 } 

// primary light ( front, right )
light_source {
  vrotate (<0, 500, -500>, <0, -60, 0>), rgb 1
}

// shadow light ( front, left )
light_source {
  vrotate (<0, 500, -500>, <0, 60, 0>), rgb 1/4
}

// back light ( rear )
light_source {
  vrotate (<0, 500, -500>, <0, 180, 0>), rgb 1/2
}

camera {
  right x*image_width/image_height
  location <0, 1/2, -2>
  look_at <0, 1/2, 0>
}

// image cylinder
cylinder {
  0, y, 1/2
  open
  pigment {
    image_map { png "colors.png" once interpolate 2}
    scale <0.5/pi, 1, 1>
    warp {
      cylindrical 
      orientation z 
      dist_exp 1 
    }
  }
  rotate y * 150
}

// blue cylinder
cylinder {
  0, y, 1/2
  scale 0.99999
  pigment { rgb <0, 0, 1> }
}

