
/**********************************************************************************
 Persistence of Vision Ray Tracer Scene Description File
 File name   :      .pov
 Version     : 3.6.1c / MegaPOV 1.21
 Description : 
               
 Date        : 2000
 Author      : Lance Purple
 E-mail      : http://objects.povworld.org/cat/Engineering/
 
 Copyright (C) 2000. All rights reserved.
 Use and/or modification of this scene is free, except for commercial purposes.
 Commercial distribution is not allowed without written permission from the author.
**********************************************************************************/

// Render settings (right-click on a line below):
// +w500 +h500 +a0.3 +am2

#default {pigment {rgb <1,0,0>}}
#default {finish {ambient 0 diffuse 0.5}}


#include "pylon.inc"

// grassy field
light_source { 1000*MILES*y White  rotate -30*z rotate -30*y }

plane
{ y 0  
  pigment
  { granite
    color_map
    { [ 0.00 Green ]
      [ 0.33 Green*0.7 + Brown*0.2 ]
      [ 0.67 Green*0.5 + White*0.5 ]
      [ 1.00 Green ]
    }
    scale 2000*FEET
  }
  normal { bumps scale 0.1*FEET }
}

background { SkyBlue }

camera { location 90*FEET*y  look_at  < 0,90,20>*FEET }


#local nTowers = 6;
#local towerSpan = 200*FEET;
#while (nTowers > -1)

   union
   { object { TransmissionTower }
     LinesConnecting ( <0,0,0>, <0,0,towerSpan>, 10*FEET )
   
     translate towerSpan*z
     translate < 0, 0, -400*FEET> + 200*FEET*nTowers*z
     rotate 41*y
     translate < 0, 0, 80>*FEET
    }
   
   #local nTowers = nTowers - 1;
#end
        