// Persistence of Vision Ray Tracer Scene Description File
// File: Catenary.pov
// Desc: Testing Catenary include file
// Date: 2005.07.30    
// Auth: PM 2Ring
//
// Catenary parameter calculations thanks to Zdislav V. Kovarik
// See Catenary.inc for details.
//                
// For instructions, please see "Catenary.txt" 
//
//-------------------------------------------------------------------------
//
// -f -A0.5 +AM2 +R1
// +A0.15 +AM2 +R3
//

#include "finish.inc"
#include "metals.inc"

//Chain making macro
#include "Catenary.inc"

global_settings {                               
  assumed_gamma 1.0
  max_trace_level 10
} 

//-------------------------------------------------------------------------

//Simple chain macro. Parameters: Start point,End Point. Make sure other items are declared before calling!
#macro ChainQ(Start, End)
  Chain(Link, Start, End, Slack, Overlap, Alternate, AltPhase, Twist, StartSkip, EndSkip, OddLinks)
#end 

//Chain terminal post
#macro Terminal(Pos)
union{
  sphere{Pos, PostRad*1.75}
  cylinder{Pos*<1,0,1>, Pos-0.35*PostRad*y, PostRad}

  pigment{rgb <.2, .5, 1>} 
  finish{Glossy}
} 
#end 

//Chain, with terminal at start
#macro TermChain(Start, End)
  Terminal(Start)
  ChainQ(Start, End)
#end 

//Link object
#declare Torus = torus {.75, .175 scale 0.15*<1, 1, .65> texture{T_Gold_3D}}

//--- The scene -----------------------------------------------------------

#declare Rad = 2.0;               //Scene size control             
#declare PostRad= 0.150;          //Post radius            

//Chain parameters                                                           
#declare Link = Torus;            //Link object  

#declare Slack = 1.10;            //Slackness of the chain. (Length of chain) / (straight distance between points)
#declare Overlap = 1.65;          //Link overlap           
#declare Twist = 0;               //Chain twist (in cycles)

#declare Alternate = 1;           //Rotate Alternate links by 90*x
#declare AltPhase = 1;            //First link rotated by 90*x
#declare StartSkip = 2;           //Skip first 2 links
#declare EndSkip = StartSkip;     //Skip last 2 links
#declare OddLinks = 1;            //Use an odd number of links

//Some points to connect  
#declare V1 = < 1.5*Rad, 1.5*Rad, 2>;
#declare V2 = < 0, 1.25*Rad, 4>;
#declare V3 = <-1.5*Rad, 1.0*Rad, 1>;
#declare V4 = < 0, 0.75*Rad, 0>;

TermChain(V1, V2)
TermChain(V2, V3)
TermChain(V3, V4) 
TermChain(V4, V1) 

//Simple room with checkered floor
#declare WS = 5*Rad;
box{<-1, -2/WS, -2>, <1, 3, 2> scale WS inverse pigment{gradient y scale 3.001*WS}finish{Shiny}}
box{<-1, -1/WS, -2>, <1, 0, 2> scale WS pigment{checker rgb 1,rgb .05}finish{Glossy diffuse 0.80}}  

camera {
  location <0.25, 3.5, -5.5> * Rad 
  look_at  y*1.6
  
  right x*image_width/image_height up y
  direction z
  
  angle 32 
} 

light_source {
  <1, 9, -3>*Rad rgb 1.75 
  spotlight point_at z*2 falloff 15 radius 4 
}  

//-------------------------------------------------------------------------

