// contains macros to make blocks with letters of the alphabet on them.

// Anyway, the bottom of the blocks is on the y=0 plane, and the
// blocks are 1x1x1 cubes.

#macro BlankBlock(Letter,OffSet,Pigment)
  #ifndef(BlockSeed)
    #declare BlockSeed=seed(0);
  #end
  union {
    box { <-.45,.95,-.50>,< .45,1.00,.50> }
    box { <-.45,.00,-.50>,< .45,0.05,.50> }
    box { <-.50,.05,-.50>,<-.45,0.95,.50> }
    box { < .45,.05,-.50>,< .50,0.95,.50> }
    box { <-.46,.04,-.47>,< .46,0.96,.47> }
    intersection {
      cylinder { <-.45,.95,-.51>,<-.45,.95,.51>,.05 }
      box { <-.5,.95,-.5>,<-.45,1,.5> } }
    intersection {
      cylinder { <-.45,.05,-.51>,<-.45,.05,.51>,.05 }
      box { <-.5,0,-.5>,<-.45,.05,.5> } }
    intersection {
      cylinder { < .45,.95,-.51>,< .45,.95,.51>,.05 }
      box { <.45,.95,-.5>,<.5,1,.5> } }
    intersection {
      cylinder { < .45,.05,-.51>,< .45,.05,.51>,.05 }
      box { <.45,0,-.5>,<.5,.05,.5> } }

    text { ttf "timrom.ttf",Letter,.1,0
      rotate y*180
      translate <OffSet,0,.5>
      scale <17/19,17/19,1>
      translate y*.196 }
    text { ttf "timrom.ttf",Letter,.1,0
      translate <-OffSet,0,-.5>
      scale <17/19,17/19,1>
      translate y*.196 }
    pigment { gradient z
      pigment_map {
        [.48 wood frequency 10 scale <1,1,10> turbulence .05 ramp_wave
          color_map { [.5, rgb <1,.7,.4> ] [1, rgb <.7,.4,.1> ] }
        ]
        [.48 Pigment ]
      }
      translate vrotate(x*7,z*360*rand(BlockSeed)) 
    }
  }
#end

#macro BlockA(Pigment) BlankBlock("A",.369,Pigment) #end
#macro BlockB(Pigment) BlankBlock("B",.300,Pigment) #end
#macro BlockC(Pigment) BlankBlock("C",.310,Pigment) #end
#macro BlockD(Pigment) BlankBlock("D",.342,Pigment) #end
#macro BlockE(Pigment) BlankBlock("E",.293,Pigment) #end
#macro BlockF(Pigment) BlankBlock("F",.256,Pigment) #end
#macro BlockG(Pigment) BlankBlock("G",.347,Pigment) #end
#macro BlockH(Pigment) BlankBlock("H",.355,Pigment) #end
#macro BlockI(Pigment) BlankBlock("I",.148,Pigment) #end
#macro BlockJ(Pigment) BlankBlock("J",.191,Pigment) #end
#macro BlockK(Pigment) BlankBlock("K",.370,Pigment) #end
#macro BlockL(Pigment) BlankBlock("L",.295,Pigment) #end
#macro BlockM(Pigment) BlankBlock("M",.442,Pigment) #end
#macro BlockN(Pigment) BlankBlock("N",.361,Pigment) #end
#macro BlockO(Pigment) BlankBlock("O",.341,Pigment) #end
#macro BlockP(Pigment) BlankBlock("P",.262,Pigment) #end
#macro BlockQ(Pigment) BlankBlock("Q",.337,Pigment) #end
#macro BlockR(Pigment) BlankBlock("R",.341,Pigment) #end
#macro BlockS(Pigment) BlankBlock("S",.240,Pigment) #end
#macro BlockT(Pigment) BlankBlock("T",.284,Pigment) #end
#macro BlockU(Pigment) BlankBlock("U",.363,Pigment) #end
#macro BlockV(Pigment) BlankBlock("V",.361,Pigment) #end
#macro BlockW(Pigment) BlankBlock("W",.475,Pigment) #end
#macro BlockX(Pigment) BlankBlock("X",.367,Pigment) #end
#macro BlockY(Pigment) BlankBlock("Y",.355,Pigment) #end
#macro BlockZ(Pigment) BlankBlock("Z",.294,Pigment) #end
