
// ============================================================================
// Photon Permutations Chart (POV-Ray SDL)
// Renders two 16x16 grids (Target=NO and Target=YES) showing shoot/effective status
// ----------------------------------------------------------------------------
#declare S_CANVAS_W = 64; #declare S_CANVAS_H = 40; #declare S_THICK = 0.02;
#declare S_CELL = 1.50;   #declare S_GAP  = 0.10;   #declare S_FONT = "cyrvetic";

camera { orthographic location < 0, 0, -8 > look_at < 0, 0, 0 > right x * S_CANVAS_W up y * S_CANVAS_H }
light_source { < -S_CANVAS_W, S_CANVAS_H, -20 > rgb 1 }

#declare TEX_RED  = texture { pigment { rgb < 1, 0.85, 0.85 > } finish { specular 0.2 roughness 0.03 } };
#declare TEX_YEL  = texture { pigment { rgb < 1, 0.97, 0.80 > } finish { specular 0.2 roughness 0.03 } };
#declare TEX_GRN  = texture { pigment { rgb < 0.82, 1.00, 0.82 > } finish { specular 0.2 roughness 0.03 } };
#declare TEX_TXT  = pigment { rgb < 0, 0, 0 > };

#macro M_EFF( S ) #local S_RES = ( S = 1 ? 1 : 0 ); S_RES #end

#macro M_Cell( V_POS, S_TGT, S_LR, S_LF, S_OR, S_OF )
	#local S_EFF_R = M_EFF( S_LR ) & M_EFF( S_OR );
	#local S_EFF_F = M_EFF( S_LF ) & M_EFF( S_OF );
	#local S_SHOOT = S_TGT & ( S_EFF_R | S_EFF_F );
	#local TEX = ( S_SHOOT ? TEX_GRN : ( ( S_EFF_R | S_EFF_F ) ? TEX_YEL : TEX_RED ) );
	box { < -S_CELL/2, -S_CELL/2, -S_THICK/2 >, < S_CELL/2, S_CELL/2, S_THICK/2 > texture { TEX } translate V_POS }
	text { ttf S_FONT concat( "R:", ( S_EFF_R ? "✓" : "×" ), "\nF:", ( S_EFF_F ? "✓" : "×" ), "\nS:", ( S_SHOOT ? "✓" : "×" ) ) 0.20, 0
		pigment { TEX_TXT } translate < V_POS.x - S_CELL*0.35, V_POS.y - S_CELL*0.25, 0 > }
#end

#macro M_LabelTop( V_POS, S_LR, S_LF )
	#local S_LR_STR = ( S_LR = 0 ? "—" : S_LR = 1 ? "on" : S_LR = 2 ? "off" : "on+off" );
	#local S_LF_STR = ( S_LF = 0 ? "—" : S_LF = 1 ? "on" : S_LF = 2 ? "off" : "on+off" );
	text { ttf S_FONT concat( "L R:", S_LR_STR, "\nL F:", S_LF_STR ) 0.20, 0 pigment { TEX_TXT } translate < V_POS.x - S_CELL*0.45, V_POS.y - 0.60, 0 > }
#end

#macro M_LabelLeft( V_POS, S_OR, S_OF )
	#local S_OR_STR = ( S_OR = 0 ? "—" : S_OR = 1 ? "on" : S_OR = 2 ? "off" : "on+off" );
	#local S_OF_STR = ( S_OF = 0 ? "—" : S_OF = 1 ? "on" : S_OF = 2 ? "off" : "on+off" );
	text { ttf S_FONT concat( "O R:", S_OR_STR, "\nO F:", S_OF_STR ) 0.20, 0 pigment { TEX_TXT } translate < V_POS.x - 1.20, V_POS.y - 0.40, 0 > }
#end

#macro M_Grid( V_ORIGIN, S_TGT )
	#for ( LR, 0, 3 ) #for ( LF, 0, 3 ) #for ( OR, 0, 3 ) #for ( OF, 0, 3 )
		#local COL = LR*4 + LF; #local ROW = OR*4 + OF;
		#local V_POS = < V_ORIGIN.x + COL*( S_CELL + S_GAP ), V_ORIGIN.y + ROW*( S_CELL + S_GAP ), 0 >;
		M_Cell( V_POS, S_TGT, LR, LF, OR, OF )
		#if ( ROW = 0 ) M_LabelTop( < V_POS.x, V_POS.y - ( S_CELL + S_GAP ), 0 >, LR, LF ) #end
		#if ( COL = 0 ) M_LabelLeft( < V_POS.x - ( S_CELL + S_GAP ), V_POS.y, 0 >, OR, OF ) #end
	#end #end #end #end
#end

text { ttf S_FONT "Target = NO" 0.35, 0 pigment { TEX_TXT } translate < 6, 38, 0 > }
text { ttf S_FONT "Target = YES" 0.35, 0 pigment { TEX_TXT } translate < 40, 38, 0 > }

M_Grid( <  4, 6, 0 >, 0 )
M_Grid( < 36, 6, 0 >, 1 )

// ***end of code***
