#######################################################
#           SkUp2Ray.rb v.5.1 - giu 2025
#  SketchUp 8 and Make17 Converter to Pov-Ray script
#          (c)Arch.G.M.S. - Milan, Italy
#######################################################
require 'sketchup.rb'
RatioPovCamera = 0.0254
RatioPovX10000 = 254

def pov_export(mode)
  model=Sketchup.active_model
  ss=model.selection
  $levelcolor=[]
  $levelalpha=[]
  $vertexes=[]
  $level=1
  $ii=0
  $iii=0
  $group_count=0
  $component_count=0
  $face_count=0
  $mode=mode
  entities=model.entities
  model.start_operation("export_pov",1,false,false)
  if mode==0 then
     file_type="pov"
  else
     file_type="inc"
  end
  export_ents=model.entities
  if (export_ents.length>0) then
     out_name=UI.savepanel("Save as POV-Ray script",".","SenzaTitolo."+file_type)
     est_ptr=out_name.length - 4
     tmp_name=out_name.downcase
     jj=tmp_name.index("."+file_type,est_ptr) 
     if (est_ptr==jj) then
       $pov_file=File.new(out_name,"w")
       nfile=out_name
     else
       $pov_file=File.new(out_name+"."+file_type,"w")
       nfile=out_name+"."+file_type
     end
     model=Sketchup.active_model
     $povStatus=" Wait a while on large files "
     Sketchup.set_status_text($povStatus)
     $pov_file.puts("/*")
     for np in 0..256 do
       $levelcolor[np]="---"
     end
     for np in 0..256 do
       $levelalpha[np]="---"
     end
     $level=1
     t=Time.now
     $pov_file.puts(t.strftime("   %d/%m/%Y %H:%M:%S")+"  "+nfile)
     $pov_file.puts("                        _____________________________________________________________")
     $pov_file.puts("                        created by SkUp2Ray vers. 5.1 giu.2025")
     $pov_file.puts("                        [POV-Ray Objects Writer!] (c)arch.G.M.S. - Milan Italy\n*/\n ")
     $pov_file.puts(" \n#version 3.7 ;")


     $pov_file.puts("#local SkUpLight = finish{ambient 0.21 diffuse 0.78 reflection 0.01}")
     $pov_file.puts("// la riga precedente fornisce un'illuminazione generica, i valori possono essere adattati all'occorrenza (con somma=1.00)")
     view = Sketchup.active_model.active_view 
     x = view.camera.eye.x.to_f * RatioPovCamera
     y = view.camera.eye.y.to_f * RatioPovCamera
     z = view.camera.eye.z.to_f * RatioPovCamera
     x1= view.camera.target.x.to_f * RatioPovCamera
     y1= view.camera.target.y.to_f * RatioPovCamera
     z1= view.camera.target.z.to_f * RatioPovCamera
     sunX=x * 2
     sunY=y * 4
     sunZ=z * 3
     if mode==0 then
       $pov_file.puts("sky_sphere {pigment {function{abs(y)} color_map{[0 color rgb<.27,.6,.92>] [1 color rgb 1]}}}")
       $pov_file.puts("global_settings {max_trace_level 20}")
       $pov_file.puts("global_settings {assumed_gamma 2.5}\n ")
       $pov_file.puts("camera {angle 63")
       $pov_file.puts("location<"+x.to_s+","+z.to_s+","+y.to_s+">\n  right<1.3333,0,0> direction<0,0,1>")
       $pov_file.puts("look_at<"+x1.to_s+","+z1.to_s+","+y1.to_s+">\n}\n ")
     else
       $pov_file.puts("#declare OBJ = union{")
     end
     $findother=0
     pov_find_faces(export_ents, Geom::Transformation.new(),model.active_layer.name)
     if mode==1 then
       $pov_file.puts("}")
     end
     $pov_file.puts("light_source{<"+sunX.to_s+","+sunZ.to_s+","+sunY.to_s+"> colour rgb 1}")
     t=Time.now
     $pov_file.puts(t.strftime("//Ending at %d/%m/%Y %H:%M:%S"))
     $pov_file.close
     $povStatus=" Done.   "
     Sketchup.set_status_text($povStatus)
     UI.messagebox($povStatus)
  end
  model.commit_operation
end

def pov_find_faces(entities,tform,layername)
  entities.each do |entity|
    if entity.is_a?(Sketchup::Face)
      pov_write_face(entity, tform)

    elsif entity.is_a?(Sketchup::Group)

      if entity.material
        if entity.material.color
          $levelcolor[$level]=entity.material.color
        else
          $levelcolor[$level]=$levelcolor[$level-1]
        end

        if entity.material.alpha
          $levelalpha[$level]=entity.material.alpha.to_s
        else
          $levelalpha[$level]=$levelalpha[$level-1]
        end
      else
        $levelcolor[$level]=$levelcolor[$level-1]
        $levelalpha[$level]=$levelalpha[$level-1]
      end

      $level+=1
      pov_find_faces(entity.entities,tform * entity.transformation,entity.name)
    elsif entity.is_a?(Sketchup::ComponentInstance)

      if entity.material
        if entity.material.color
          $levelcolor[$level]=entity.material.color
        else
          $levelcolor[$level]=$levelcolor[$level-1]
        end
        if entity.material.alpha
          $levelalpha[$level]=entity.material.alpha.to_s
        else
          $levelalpha[$level]=$levelalpha[$level-1]
        end
      else
        $levelcolor[$level]=$levelcolor[$level-1]
        $levelalpha[$level]=$levelalpha[$level-1]
      end

      $level+=1
      pov_find_faces(entity.definition.entities,tform * entity.transformation,entity.name)
    end  
  end
  $level=$level-1
  #UI.messagebox($level.to_s)
end

def pov_write_face(face,tform)
  mesh=face.mesh 7
  mesh.transform! tform
#---------------------------------------
  emptycolor=0
  if face.material then
    $facecol=face.material.color

  #UI.messagebox($facecol.to_s)


    $colr=$facecol.red.to_s
    $colg=$facecol.green.to_s
    $colb=$facecol.blue.to_s
    $alph=face.material.alpha.to_s
  elsif $levelcolor[$level-1]!="---"
    $facecol=$levelcolor[$level-1]


  #UI.messagebox($facecol.to_s)

    $colr=$facecol.red.to_s
    $colg=$facecol.green.to_s
    $colb=$facecol.blue.to_s
    if $levelalpha[$level-1]!="---"
      $alph=$levelalpha[$level-1]
    else
      $alph="1.0"
    end
  else
    emptycolor=1
    $colr="255"
    $colg="255"
    $colb="255"
    $alph="1.0"
  end
#---------------------------------------
  inimesh=0
  numpol=mesh.count_polygons
  if numpol>0 then
    global_vertex=""
    for np in 1..numpol do
      vertices=mesh.polygon_at np

      numvrtx=vertices.length - 1
      for eachvrtx in 0..numvrtx do
          x = mesh.point_at((vertices[eachvrtx]).abs).x * RatioPovX10000
          y = mesh.point_at((vertices[eachvrtx]).abs).y * RatioPovX10000
          z = mesh.point_at((vertices[eachvrtx]).abs).z * RatioPovX10000

          x = (x.to_i).to_f / 10000
          y = (y.to_i).to_f / 10000
          z = (z.to_i).to_f / 10000
          
          $vertexes[eachvrtx]=x.to_s+","+z.to_s+","+y.to_s
          global_vertex=global_vertex+"<"+$vertexes[eachvrtx]+">"
      end
      if $vertexes[0]!=$vertexes[1]
        if $vertexes[1]!=$vertexes[2]
          if $vertexes[2]!=$vertexes[0]
               if inimesh==0
                  $pov_file.puts("mesh{")
                  inimesh=1
               end
               $pov_file.puts(" triangle{"+global_vertex+"}")
          end
        end
      end
      global_vertex=""
      $ii=$ii + 1
      if ($ii==100) then
        $iii=$iii + 1
        $ii=0
        $povStatus = $povStatus+"."
        Sketchup.set_status_text($povStatus)
      end
      if ($iii==100) then
        $iii=0
        $povStatus=" Wait "
      end
    end
    if inimesh==1
      if emptycolor==1
        if $alph=="1.0"
          objpigm=" pigment{color rgb 1}"
        else
          objpigm=" pigment{color rgbft 1}"
        end
      else
        if $alph=="1.0"
          objpigm=" pigment{color rgb<"+$colr+"/255,"+$colg+"/255,"+$colb+"/255>}"
        else
          objpigm=" pigment{color rgbft<"+$colr+"/255,"+$colg+"/255,"+$colb+"/255,"+$alph+">}"
        end
      end

=begin
      objpigm=objpigm.sub("255/255","1")
      objpigm=objpigm.sub("255/255","1")
      objpigm=objpigm.sub("255/255","1")
      objpigm=objpigm.sub("<0/255","<0")
      objpigm=objpigm.sub("<0/255","<0")
      objpigm=objpigm.sub("<0/255","<0")
      objpigm=objpigm.sub(",0/255",",0")
      objpigm=objpigm.sub(",0/255",",0")
      objpigm=objpigm.sub(",0/255",",0")

=end

      $pov_file.puts(objpigm+" finish{SkUpLight}}")
      inimesh=0
    end
  end
end #def
if(not file_loaded?("SkUp2Ray.rb"))
   add_separator_to_menu("Files")
   UI.menu("Files").add_item("Export POV-Ray surfaces  (filetype POV, full scene)") {pov_export(0)}
   UI.menu("Files").add_item("Export POV-Ray surfaces  (filetype INC, object to include)") {pov_export(1)}
   UI.menu("Plugins").add_item("SkUp8 Ray parser"){UI.messagebox(" \nSkUp2Ray\n________\n\nPovRay surfaces exporter v.5.1\n(c)2025 Arch.G.M.S. - Milan, Italy    \n ")}
end
file_loaded("SkUp2Ray.rb")
