######################################
#       STL2SkUp.rb v.5.1 - 2025
#   STL importer to Google SketchUp
#    (c)Arch.G.M.S. - Milan, Italy
######################################
require 'sketchup.rb'
$RatioSTL = 39.3700787

def stlread()
        $Counter=0
	pts=[]
	model=Sketchup.active_model 
	model.start_operation("Import STL")
	inp_name=UI.openpanel "Import STL here",nil,"*.stl"
	file=File.new(inp_name.to_s,"r")
	$stlStatus="Reading file "+inp_name.to_s+", wait a while "
	lines = file.read.count("\n")
	totfacce = (lines - 2) / 7
	x = totfacce.floor   #restituisce il numero delle facce
	file.close

	file=File.new(inp_name.to_s,"r")
	line=file.gets.chomp
  	line.downcase!
	if line.include?("solid")                          # ok  un STL ASCII
		Sketchup.set_status_text($stlStatus)
		entities=model.entities
		ent=entities
		for i in 1..x do
			line=file.gets.chomp #facet normals
			line=file.gets.chomp #tag open xyz

			line=file.gets.chomp
			p3=line.split
			x2=(p3[1]).to_f * $RatioSTL
			y2=(p3[2]).to_f * $RatioSTL
			z2=(p3[3]).to_f * $RatioSTL

			line=file.gets.chomp
			p2=line.split
			x1=(p2[1]).to_f * $RatioSTL
			y1=(p2[2]).to_f * $RatioSTL
			z1=(p2[3]).to_f * $RatioSTL

			line=file.gets.chomp
			p1=line.split
			x0=(p1[1]).to_f * $RatioSTL
			y0=(p1[2]).to_f * $RatioSTL
			z0=(p1[3]).to_f * $RatioSTL

			pts[0] = [x0, y0, z0]
			pts[1] = [x1, y1, z1]
			pts[2] = [x2, y2, z2]

			line=file.gets.chomp #tag close xyz
			line=file.gets.chomp

			if line.length > 13 # c' l'attributo colore! 
				colore=line.split
				actcolor = colore[2]
				if actcolor[0,3] == "HEX"
					flagt = 0
					transpar = actcolor.split('T')
					if transpar[1]
						trasvalue = transpar[1].to_f
						trasvaluefloat = trasvalue / 255
						flagt=1
						actcolor = transpar[0]
					else
						flagt=0
					end
					intcol = actcolor[3,actcolor.length-3].to_i
				else
					intcol = actcolor.to_i
				end
				if intcol == 0
					intcol = (16777215).to_i
				elsif intcol == 1
					intcol = (255).to_i
				elsif intcol == 2
					intcol = (65535).to_i
				elsif intcol == 3
					intcol = (65280).to_i
				elsif intcol == 4
					intcol = (16776960).to_i
				elsif intcol == 5
					intcol = (16711680).to_i
				elsif intcol == 6
					intcol = (16711935).to_i
				elsif intcol == 7
					intcol = (16777215).to_i
				end

			else
				intcol = (16777215).to_i
			end

			esacol = intcol.to_s(16)

			dista = pts[0].distance(pts[1])
			dist  = dista.to_f
			if dist > 0.0000001
				dista = pts[1].distance(pts[2])
				dist=dista.to_f
				if dist > 0.0000001
					dista = pts[2].distance(pts[0])
					dist=dista.to_f
					if dist > 0.0000001
						#metodo alternativo, se non si vuol scalare subito gli xyz dell'STL
						#pts[0].transform! Geom::Transformation.scaling $RatioSTL
						#pts[1].transform! Geom::Transformation.scaling $RatioSTL
						#pts[2].transform! Geom::Transformation.scaling $RatioSTL
						if esacol.length == 1
							esacol = "00000" + esacol
						elsif esacol.length == 2
							esacol = "0000" + esacol
						elsif esacol.length == 3
							esacol = "000" + esacol
						elsif esacol.length == 4
							esacol = "00" + esacol
						elsif esacol.length == 5
							esacol = "0" + esacol
						end
						esacol = esacol[0,6]
						revcol = esacol[4,2] + esacol[2,2] + esacol[0,2]
						mat = revcol.hex


						color_from_rgb = Sketchup::Color.new(mat)
						if (pts[0].vector_to(pts[1]).parallel? pts[1].vector_to(pts[2]))==false
							if (pts[1].vector_to(pts[2]).parallel? pts[2].vector_to(pts[0]))==false
								nu=ent.add_face pts[0..2]
								nu.material=color_from_rgb 
								nu.back_material=color_from_rgb
								if flagt == 1
									nu.material.alpha = trasvaluefloat
								end
								Sketchup.set_status_text("Loaded "+$Counter.to_s+" faces of "+x.to_s)
                						$Counter=$Counter+1
							end
						end
					end 
				end
			end
		end
		file.close
		doneStatus ="STL Ready. Faces " + $Counter.to_s
		Sketchup.set_status_text(doneStatus)
		UI.messagebox(doneStatus)
		Sketchup.send_action( "viewZoomExtents:" )
	else
		file.close
		doneStatus = "ASCII STL required (no binary)."
		Sketchup.set_status_text(doneStatus)
		UI.messagebox(doneStatus)
	end
	model.commit_operation
end
if(not file_loaded?("STL2SkUp.rb"))
	add_separator_to_menu("Files")
	UI.menu("Files").add_item("Import ASCII STL"){stlread()}
	UI.menu("Plugins").add_item("STL2SkUp - STL Importer"){UI.messagebox(" \nSTL2SkUp\n\nSTL Importer\nVers.5.1\n(c)2025 Arch.G.M.S. - Milan Italy          ")}
end
file_loaded("STL2SkUp.rb")
