
// ADD for compatibility

#declare Color256       = rgb 1;
#declare WHITE          = rgb 1;
#declare BLACK          = rgb 0;
#declare SILVER         = rgb<.96,.96,.91>;
#declare SILVERDARK     = rgb<.75,.75,.72>;
#declare ALUMINIUM      = SILVER;

#declare POLIBLACK      = texture {pigment{rgb<0,0,0>} finish{ reflection .15
                          phong .6 phong_size 200 ambient (0.4 * AmbientFact) diffuse .6}}
#declare POLIRED        = texture {pigment{rgb<.5,.02,.03>} finish{ reflection .15
                          phong .6 phong_size 200 ambient (0.4 * AmbientFact) diffuse .6}}                          
#declare POLIBLUE       = texture {pigment{rgb<.04,0,.4>} finish{ reflection .15
                          phong .6 phong_size 200 ambient (0.4 * AmbientFact) diffuse .6}}                               
#declare POLIYELLOW     = texture {pigment{rgb<.85,.85,0>} finish{ reflection .15
                          phong .6 phong_size 200 ambient (0.4 * AmbientFact) diffuse .6}}                      
#declare POLIGREEN      = texture {pigment{rgb<.0,.26,.17>} finish{ reflection .04
                          phong .6 phong_size 200 ambient (0.2 * AmbientFact) diffuse .4}}
#declare POLIBEIGE      = texture {pigment{rgb<.93,.92,.8>} finish{ reflection .15
                          phong .6 phong_size 200 ambient (0.4 * AmbientFact) diffuse .6}}
#declare POLIWHITE      = texture {pigment{rgb<1,1,1>} finish{ reflection .1 ambient (0.6 * AmbientFact) diffuse .6}}                      
#declare DEMIBLUE       = texture {pigment{rgbft<.17,.36,.5,.7,.4>} normal{bumps.2 scale.06}
                          finish {reflection .2 phong 250 phong_size 200}}                   
#declare DEMIRED        = texture {pigment{rgbft<1,.02,0,.5,0>} normal{bumps.2 scale.06}
                          finish {reflection .2 phong 250 phong_size 200}}                     
#declare LITEMIRROR     = texture{pigment{rgb 0} finish{ambient 0 diffuse .7 reflection .97}}

#declare STORM          = sky_sphere {pigment {bozo color_map
                          {[0,.2 color rgb<.65,.65,.70> color rgb<.55 ,.55 ,.60 >]
                          [.2,1 color rgb<.55,.55,.60> color rgb<.210,.210,.215>]}
                          turbulence .55 omega .7 scale<1.5,.6,3>} translate<0,-.45,0>}


//________________________________________________________________________________________________________________
// STARTING SHAPES


/* 2009~2025 AIveicle.INC POW! v.3.7 include Arch. Giovanni Seregni Milano */

#declare BikeTelaio = union {
 cylinder {<-.7252,1.0072,-.0135>,<-1.0373,.3300,-.0922>,.015}
 cylinder {<-.7252,1.0072,.0135>,<-1.0373,.33,.0922>,.015}
 cylinder {<-.7571,1.1353,.0>,<-.5355,.2873,0>,.015}
 cylinder {<.0762,.8155,0>,<-.5435,.3215,0>,.015}
 cylinder {<0,1.141,0>,<.0867,.7467,0>,.015}
 cylinder {<.2487,.338,-.0567>,<.145,.4723,-.052>,.015}
 sphere {<.145,.4723,-.052>,.015}
 cylinder {<.145,.4723,-.052>,<.084,.7467,-.0424>,.015}
 cylinder {<.2487,.338,.0567>,<.145,.4723,.052>,.015}
 sphere {<.145,.4723,.052>,.015}
 cylinder {<.145,.4723,.052>,<.084,.7467,.0424>,.015}
 cylinder {<-.7281,1.0005,0>,<.0218,1.0004,0>,.015}
 cylinder {<-1.0416,.3203,-.0999>,<-.5453,.3203,-.0124>,.015}
 cylinder {<-1.0416,.3203,.0999>,<-.5453,.3203,.0124>,.015}
}


#declare Gomma = union { 
 object { 
 union { #declare CountG = 0; 
 #while (CountG < 20)
 cylinder {<0,.34,0>,<0,-.34,0>,.003 rotate <0,0,CountG*9>}
 #declare CountG = CountG + 1;
 #end 
 } pigment {colour ALUMINIUM} finish {ambient (0.4 * AmbientFact) diffuse .4 reflection .4 metallic .5 phong 50}
 } 
 torus { .33,.02 pigment {color BLACK} finish{ambient (0.6 * AmbientFact) diffuse .7} rotate<90,0,0>}
 torus { .32,.015 pigment {colour ALUMINIUM}
 finish {ambient (0.4 * AmbientFact) diffuse .4 reflection .4 metallic .5 phong 50} rotate<90,0,0>}
} 

#declare BIKEBASE = union { 
object { Gomma translate<.25,.35,0>} 
object { Gomma translate<-1.03,.35,0>} 
object { union {
 cylinder {<.1322,1.1278,-.182>,<.1322,1.1278,.1865>,.015}
 cylinder {<-.0006,1.1311,0>,<.1444,1.1142,0>,.015} 
 mesh {
 triangle {<.0987,.7699,.0208><.0995,.7654,.0553><.1057,.7302,.0649>}
 triangle {<.1057,.7302,.0649><.0987,.7699,-.0195><.0987,.7699,.0208>}
 triangle {<.0987,.7699,-.0195><.0995,.7654,-.0598><.1057,.73,-.0657>}
 triangle {<.1057,.73,-.0657><.1057,.7302,.0649><.0987,.7699,-.0195>}
 triangle {<.0995,.7654,-.0598><.0666,.7596,-.0598><.0728,.7241,-.0657>}
 triangle {<.0728,.7241,-.0657><.1057,.73,-.0657><.0995,.7654,-.0598>}
 triangle {<.0955,.7878,-.0162><.0956,.7875,.017><.0987,.7699,.0208>}
 triangle {<.0987,.7699,.0208><.0987,.7699,-.0195><.0955,.7878,-.0162>}
 triangle {<.0955,.7878,-.0162><.0627,.7819,-.0162><.0658,.764,-.0195>}
 triangle {<.0658,.764,-.0195><.0987,.7699,-.0195><.0955,.7878,-.0162>}
 triangle {<.0658,.764,-.0195><.0666,.7596,-.0598><.0995,.7654,-.0598>}
 triangle {<.0995,.7654,-.0598><.0987,.7699,-.0195><.0658,.764,-.0195>}
 triangle {<.0995,.7654,.0553><.0666,.7596,.0553><.0728,.7244,.0649>}
 triangle {<.0728,.7244,.0649><.1057,.7302,.0649><.0995,.7654,.0553>}
 triangle {<.0987,.7699,.0208><.0658,.764,.0208><.0666,.7596,.0553>}
 triangle {<.0666,.7596,.0553><.0995,.7654,.0553><.0987,.7699,.0208>}
 triangle {<.0956,.7875,.017><.0627,.7817,.017><.0658,.764,.0208>}
 triangle {<.0658,.764,.0208><.0987,.7699,.0208><.0956,.7875,.017>}
 triangle {<.0658,.764,.0208><.0666,.7596,.0553><.0728,.7244,.0649>}
 triangle {<.0728,.7244,.0649><.0658,.764,-.0195><.0658,.764,.0208>}
 triangle {<.0658,.764,-.0195><.0666,.7596,-.0598><.0728,.7241,-.0657>}
 triangle {<.0728,.7241,-.0657><.0728,.7244,.0649><.0658,.764,-.0195>}
 triangle {<.0627,.7819,-.0162><.0627,.7817,.017><.0658,.764,.0208>}
 triangle {<.0658,.764,.0208><.0658,.764,-.0195><.0627,.7819,-.0162>}
 }
 cylinder {<-.5417,.3258,-.0738>,<-.5417,.1273,-.0738>,.0125}
 cylinder {<-.5417,.5203,.0323>,<-.5417,.3218,.0323>,.0125}
 cylinder {<-.5461,.1335,-.2263>,<-.5461,.1335,-.0846>,.0125}
 cylinder {<-.5161,.1335,-.2263>,<-.5161,.1335,-.0846>,.0125}
 cylinder {<-.5761,.1335,-.2263>,<-.5761,.1335,-.0846>,.0125}
 cylinder {<-.5385,.5241,.0419>,<-.5385,.5241,.1836>,.0125}
 cylinder {<-.5085,.5241,.0419>,<-.5085,.5241,.1836>,.0125}
 cylinder {<-.5685,.5241,.0419>,<-.5685,.5241,.1836>,.0125}
 } pigment {colour ALUMINIUM}
 finish {ambient (0.4 * AmbientFact) diffuse .4 reflection .4 metallic .5 phong 50}
} 
 object {
 union {
 difference{torus{.1,.015}plane{<0,0,1>,0}scale<-1,1,1>rotate<0,90,0> translate<.1322,-.1865,1.0278>rotate<270,0,0,>} //manubrio
 difference{torus{.1,.015}plane{<0,0,1>,0}scale<-1,1,1>rotate<0,90,0> translate<.1322,.1820,1.0278>rotate<270,0,0,>} //manubrio
 cylinder {<.25,.35,-.0715>,<.25,.35,.0715>,.018} //asse anteriore
 cylinder {<-1.03,.35,-.0715>,<-1.03,.35,.0715>,.018} //asse posteriore
 cylinder {<0,-.0100,0>,<0,.0100,0>,.0461 rotate<0,0,90> rotate<0,90,0> translate<-.5463,.3197,-.0532>}//marce avanti
 cylinder {<0,-.0100,0>,<0,.0100,0>,.0943 open rotate<0,0,90> rotate<0,90,0> translate<-.5463,.3197,-.0532>}//base catena avanti
 cylinder {<0,-.005,0>,<0,.005,0>,.05 rotate<0,0,90> rotate<0,270,0> translate<-1.03,.35,-.035>} //marce dietro
 mesh { triangle {<-.5463,.414,-.0632><-1.03,.4,-.04><-1.03,.4,-.03>} //catena alta
 triangle {<-1.03,.4,-.03><-.5463,.414,-.0432><-.5463,.414,-.0632>}} 
 cylinder {<0,-.005,0>,<0,.005,0>,.0186 rotate<0,0,90> rotate<0,270,0> translate<-1.03,.2441,-.035>}//rapporti
 cylinder {<0,-.005,0>,<0,.005,0>,.0186 rotate<0,0,90> rotate<0,270,0> translate<-1.03,.2814,-.035>}//rapporti
 polygon { 5 <-1.0302,.2255,-.04><-.5465,.2255,-.0581> <-.5461,.2255,-.0482><-1.0298,.2255,-.03><-1.0302,.2255,-.04>} //catena
 } pigment {color BLACK} finish {ambient (0.6 * AmbientFact) diffuse .7}
 } 

 union { mesh { triangle {<-.8438,1.2039,-.0761><-.8748,1.1741,-.0841><-.6582,1.137,-.0199>}
 triangle {<-.8438,1.2039,-.0761><-.8748,1.1741,-.0841><-.8622,1.2039,-.0808>}
 triangle {<-.8438,1.2039,-.0761><-.6582,1.137,-.0199><-.6389,1.1718,-.0164>}
 triangle {<-.8748,1.1741,-.0841><-.809,1.1259,-.0671><-.6582,1.137,-.0199>}
 triangle {<-.8622,1.2039,.0765><-.8748,1.1741,.0797><-.8439,1.2039,.0717>}
 triangle {<-.6582,1.137,.0155><-.8748,1.1741,.0797><-.809,1.1259,.0627>}
 triangle {<-.8439,1.2039,.0717><-.8748,1.1741,.0797><-.6582,1.137,.0155>}
 triangle {<-.8439,1.2039,.0717><-.6582,1.137,.0155><-.6389,1.1718,.0121>}
 triangle {<-.6389,1.1718,-.0164><-.6582,1.137,-.0199><-.6186,1.1374,-.0129>}
 triangle {<-.6389,1.1718,.0121><-.6582,1.137,.0155><-.6186,1.1374,.0085>} 
 triangle {<-.6389,1.1718,-.0164><-.6186,1.1374,-.0129><-.6186,1.1374,.0085>}
 triangle {<-.6186,1.1374,.0085><-.6389,1.1718,.0121><-.6389,1.1718,-.0164>}
 triangle {<-.8438,1.2039,-.0761><-.6389,1.1718,-.0164><-.6389,1.1718,.0121>}
 triangle {<-.6389,1.1718,.0121><-.8439,1.2039,.0717><-.8438,1.2039,-.0761>}
 triangle {<-.8622,1.2039,.0765><-.8748,1.1741,.0797><-.8748,1.1741,-.0841>}
 triangle {<-.8748,1.1741,-.0841><-.8622,1.2039,-.0808><-.8622,1.2039,.0765>}
 triangle {<-.8748,1.1741,.0797><-.809,1.1259,.0627><-.809,1.1259,-.0671>}
 triangle {<-.809,1.1259,-.0671><-.8748,1.1741,-.0841><-.8748,1.1741,.0797>}
 } 
 polygon { 5, <-.8622,1.2039,.0765><-.8439,1.2039,.0717><-.8438,1.2039,-.0761><-.8622,1.2039,-.0808><-.8622,1.2039,.0765>}
 
 }pigment {color BLACK} finish {ambient (0.6 * AmbientFact) diffuse 0.7}
 } 


#declare BIKERED = union {object {BikeTelaio texture {POLIRED}} object {BIKEBASE}}
#declare BIKEBLUE = union {object {BikeTelaio texture {POLIBLUE}} object {BIKEBASE}}
#declare BIKEBLACK = union {object {BikeTelaio texture {POLIBLACK}} object {BIKEBASE}}
#declare BIKEWHITE = union {object {BikeTelaio texture {POLIWHITE}} object {BIKEBASE}}
#declare BIKEGREEN = union {object {BikeTelaio texture {POLIGREEN}} object {BIKEBASE}}
#declare BIKEYELLOW = union {object {BikeTelaio texture {POLIYELLOW}} object {BIKEBASE}}
#declare BIKEBEIGE = union {object {BikeTelaio texture {POLIBEIGE}} object {BIKEBASE}}
 
#declare BIKEMI = union { 
object { Gomma translate<.25,.35,0>} 
object { Gomma translate<-1.03,.35,0>} 
}
//end BIKE

// ____________________________________________________________________________________________________________ INI CAR (pseudo AUDI)


#declare AUDISpec = mesh {
 smooth_triangle {<-.755,.869,.49>,<-1.724342,-3.634171,-3.899596><-.729,.816,.384>,<-1.572104,6.696702,-3.622605><-.729,.922,.384>,<-4.856054,-4.472136,-3.427176>}
 smooth_triangle {<-.755,.922,.384>,<.545199,-8.917607,-4.458801><-.755,.869,.49>,<-1.724342,-3.634171,-3.899596><-.729,.922,.384>,<-4.856054,-4.472136,-3.427176>}
 smooth_triangle {<-.755,.922,.384>,<.545199,-8.917607,-4.458801><-.861,.922,.358>,<2.703509,-8.481939,-3.885597><-.755,.869,.49>,<-1.724342,-3.634171,-3.899596>}
 smooth_triangle {<-.861,.922,.358>,<2.703509,-8.481939,-3.885597><-.835,.869,.49>,<1.635009,.241688,-3.653701><-.755,.869,.49>,<-1.724342,-3.634171,-3.899596>}
 smooth_triangle {<-.861,.922,.358>,<2.703509,-8.481939,-3.885597><-.887,.869,.437>,<4.273409,.455786,-3.561895><-.835,.869,.49>,<1.635009,.241688,-3.653701>}
 smooth_triangle {<-.861,.922,.358>,<2.703509,-8.481939,-3.885597><-.914,.895,.331>,<7.367723,-4.807634,-2.206855><-.887,.869,.437>,<4.273409,.455786,-3.561895>}
 smooth_triangle {<-.914,.895,.331>,<7.367723,-4.807634,-2.206855><-.914,.869,.384>,<7.012467,2.014297,-2.534588><-.887,.869,.437>,<4.273409,.455786,-3.561895>}
 smooth_triangle {<-.914,.895,.331>,<7.367723,-4.807634,-2.206855><-.914,.842,.331>,<7.778372,3.704051,-1.88697><-.914,.869,.384>,<7.012467,2.014297,-2.534588>}
 smooth_triangle {<-.914,.842,.331>,<7.778372,3.704051,-1.88697><-.914,.869,.384>,<7.012467,2.014297,-2.534588><-.861,.816,.358>,<4.184665,7.754443,-4.036034>}
 smooth_triangle {<-.887,.869,.437>,<4.273409,.455786,-3.561895><-.861,.816,.358>,<4.184665,7.754443,-4.036034><-.729,.816,.384>,<-1.572104,6.696702,-3.622605>}
 smooth_triangle {<-.887,.869,.437>,<4.273409,.455786,-3.561895><-.835,.869,.49>,<1.635009,.241688,-3.653701><-.729,.816,.384>,<-1.572104,6.696702,-3.622605>}
 smooth_triangle {<-.755,.869,.49>,<-1.724342,-3.634171,-3.899596><-.729,.816,.384>,<-1.572104,6.696702,-3.622605><-.835,.869,.49>,<1.635009,.241688,-3.653701>}
 smooth_triangle {<-.914,.869,.384>,<7.012467,2.014297,-2.534588><-.861,.816,.358>,<4.184665,7.754443,-4.036034><-.887,.869,.437>,<4.273409,.455786,-3.561895>}
}


#declare AUDICarr = union { 
mesh {
 smooth_triangle {<-.696,.864,-.36>,<9.529588,-2.358476,-.592202><-.84,.336,-.6>,<8.433989,-.972519,-3.958995><-.84,.336,-.096>,<9.852034,-1.175823,.147171>}
 smooth_triangle {<-.696,.336,-1.5360>,<6.659262,-.501952,7.376583><-.7920,.2880,-1.4400>,<5.060344,-.657888,8.346447><-.7920,.1680,-1.4400>,<5.116674,0,8.278951>}
 smooth_triangle {<-.792,.168,-1.4400>,<5.116674,0,8.278951><-.6960,.1680,-1.5360>,<6.535534,0,7.535534><-.6960,.3360,-1.5360>,<6.659262,-.501952,7.376583>}
 smooth_triangle {<-.864,.312,1.6080>,<6.462965,-.635411,-6.336123><-.8640,.1680,1.6080>,<7.378645,0,-5.270463><-.7920,.1680,1.6320>,<6.324551,0,-6.324556>}
 smooth_triangle {<-.792,.168,1.6320>,<6.324551,0,-6.324556><-.7920,.3120,1.6320>,<6.301083,-.006221,-6.344637><-.8640,.3120,1.6080>,<6.462965,-.635411,-6.336123>}
 smooth_triangle {<-.744,.336,1.7760>,<8.397731,.124994,-4.965433><-.7920,.3120,1.6320>,<6.301083,-.006221,-6.344637><-.7920,.1680,1.6320>,<6.324551,0,-6.324556>}
 smooth_triangle {<-.792,.168,1.6320>,<6.324551,0,-6.324556><-.7440,.1680,1.7760>,<8.278951,0,-5.116672><-.7440,.3360,1.7760>,<8.397731,.124994,-4.965433>}
 smooth_triangle {<-.84,.336,-.6000>,<8.433989,-.972519,-3.958995><-.8880,.3120,-.6480>,<8.496904,-.50642,-3.140102><-.8880,.1680,-.6480>,<8.535532,0,-3.535536>}
 smooth_triangle {<-.888,.168,-.6480>,<8.535532,0,-3.535536><-.84,.168,-.6>,<9.023687,0,-2.357024><-.8400,.3360,-.6000>,<8.433989,-.972519,-3.958995>}
 smooth_triangle {<-.84,.336,.7920>,<8.539985,-.578484,3.782691><-.8880,.2880,.8400>,<8.923871,-.215666,2.708208><-.8880,.1680,.8400>,<8.535532,0,3.535536>}
 smooth_triangle {<-.888,.168,.8400>,<8.535532,0,3.535536><-.8400,.1680,.7920>,<9.023687,0,2.357024><-.8400,.3360,.7920>,<8.539985,-.578484,3.782691>}
 smooth_triangle {<-.864,.288,-1.4160>,<6.781205,-.427743,5.806536><-.8640,.1680,-1.4160>,<7.37865,0,5.270461><-.7920,.1680,-1.4400>,<5.116674,0,8.278951>}
 smooth_triangle {<-.792,.168,-1.4400>,<5.116674,0,8.278951><-.7920,.2880,-1.44>,<5.060344,-.657888,8.346447><-.8640,.2880,-1.4160>,<6.781205,-.427743,5.806536>}
 smooth_triangle {<-.336,1.2,-.4320>,<1.551407,-9.455778,1.650735><-.3120,1.1760,-.5280>,<2.180145,-9.316516,1.863603><0,1.1760,-.5280>,<.075273,-9.557555,2.916374>}
 smooth_triangle {<0,1.1760,-.5280>,<.075273,-9.557555,2.916374><0,1.2,-.4560>,<.007092,-9.793038,1.405292><-.3360,1.2000,-.4320>,<1.551407,-9.455778,1.650735>}
 smooth_triangle {<-.576,1.176,.408>,<6.627222,-6.520643,-.129202><-.72,.84,.744>,<7.893038,-5.912434,-.602197><-.624,1.104,.312>,<8.439861,-5.27299,-.26519>}
 smooth_triangle {<-.696,.864,.84>,<5.70024,-6.81279,-1.414069><-.72,.84,.744>,<7.893038,-5.912434,-.602197><-.576,1.176,.408>,<6.627222,-6.520643,-.129202>}
 smooth_triangle {<-.312,1.176,-.528>,<2.180145,-9.316516,1.863603><-.504,1.128,-.504>,<5.724639,-7.402631,1.213222><-.504,1.128,-.408>,<4.739333,-8.26937,1.006724>}
 smooth_triangle {<-.336,1.2,-.432>,<1.551407,-9.455778,1.650735><-.504,1.128,-.408>,<4.739333,-8.26937,1.006724><-.312,1.176,-.528>,<2.180145,-9.316516,1.863603>}
 smooth_triangle {<0,1.2240,0>,<0,-9.958234,.09193><-.2640,1.2,0>,<.724017,-9.964189,.074512><0,1.2,-.4560>,<.007092,-9.793038,1.405292>}
 smooth_triangle {<-.3360,1.2000,-.4320>,<1.551407,-9.455778,1.650735><-.2640,1.2,0>,<.724017,-9.964189,.074512><0,1.2,-.4560>,<.007092,-9.793038,1.405292>}
 smooth_triangle {<-.576,1.176,.408>,<6.627222,-6.520643,-.129202><-.624,1.104,.312>,<8.439861,-5.27299,-.26519><-.6,1.128,.168>,<7.830866,-5.850233,1.212272>}
 smooth_triangle {<-.5760,1.1760,.4080>,<6.627222,-6.520643,-.129202><-.6000,1.1280,.1680>,<7.830866,-5.850233,1.212272><-.5280,1.1760,0>,<4.420814,-7.864534,.794042>}
 smooth_triangle {<-.5280,1.1760,0>,<4.420814,-7.864534,.794042><-.6,1.1280,.1680>,<7.830866,-5.850233,1.212272><-.5520,1.1280,0>,<7.342303,-5.904128,1.349279>}
 smooth_triangle {<-.5280,1.1760,0>,<4.420814,-7.864534,.794042><-.5520,1.1280,0>,<7.342303,-5.904128,1.349279><-.5040,1.1280,-.4080>,<4.739333,-8.26937,1.006724>}
 smooth_triangle {<-.5040,1.1280,-.4080>,<4.739333,-8.26937,1.006724><-.5520,1.104,-.4080>,<5.603539,-7.833131,1.018618><-.5520,1.1280,0>,<7.342303,-5.904128,1.349279>}
 smooth_triangle {<-.504,1.128,-.408>,<4.739333,-8.26937,1.006724><-.552,1.104,-.408>,<5.603539,-7.833131,1.018618><-.504,1.128,-.504>,<5.724639,-7.402631,1.213222>}
 smooth_triangle {<-.504,1.128,-.504>,<5.724639,-7.402631,1.213222><-.528,1.008,-.696>,<7.919195,-5.624855,2.356346><-.48,1.008,-.864>,<7.641836,-5.741682,2.792942>}
 smooth_triangle {<-.552,1.104,-.408>,<5.603539,-7.833131,1.018618><-.528,1.008,-.696>,<7.919195,-5.624855,2.356346><-.504,1.128,-.504>,<5.724639,-7.402631,1.213222>}
 smooth_triangle {<-.48,1.008,-.864>,<7.641836,-5.741682,2.792942><-.528,.936,-.888>,<6.036633,-6.905983,3.123109><-.528,1.008,-.696>,<7.919195,-5.624855,2.356346>}
 smooth_triangle {<-.48,1.008,-.864>,<7.641836,-5.741682,2.792942><-.528,.936,-.888>,<6.036633,-6.905983,3.123109><-.432,.864,-1.176>,<3.277093,-8.644044,2.900662>}
 smooth_triangle {<-.528,.936,-.888>,<6.036633,-6.905983,3.123109><-.552,.864,-1.056>,<4.571049,-8.361252,1.532299><-.432,.864,-1.176>,<3.277093,-8.644044,2.900662>}
 smooth_triangle {<-.3360,1.2,-.4320>,<1.551407,-9.455778,1.650735><-.5280,1.1760,0>,<4.420814,-7.864534,.794042><-.5040,1.1280,-.4080>,<4.739333,-8.26937,1.006724>}
 smooth_triangle {<-.2640,1.2,0>,<.724017,-9.964189,.074512><-.5280,1.1760,0>,<4.420814,-7.864534,.794042><-.3360,1.2000,-.4320>,<1.551407,-9.455778,1.650735>}
 smooth_triangle {<-.2640,1.2,.4080>,<.644412,-9.967687,-.124248><-.5760,1.1760,.4080>,<6.627222,-6.520643,-.129202><-.5280,1.1760,0>,<4.420814,-7.864534,.794042>}
 smooth_triangle {<-.2640,1.2,.4080>,<.644412,-9.967687,-.124248><-.5280,1.1760,0>,<4.420814,-7.864534,.794042><-.2640,1.2000,0>,<.724017,-9.964189,.074512>}
 smooth_triangle {<0,1.2240,0>,<0,-9.958234,.09193><-.2640,1.2000,0>,<.724017,-9.964189,.074512><-.2640,1.2000,.4080>,<.644412,-9.967687,-.124248>}
 smooth_triangle {<0,.7440,1.6800>,<0,-9.741026,-2.222873><-.3360,.7440,1.6560>,<.815928,-9.628872,-2.417346><0,.6960,1.8480>,<0,-8.762947,-4.185144>}
 smooth_triangle {<-.3360,.7440,1.6560>,<.815928,-9.628872,-2.417346><-.3360,.6960,1.8240>,<.593539,-8.094158,-4.754879><0,.6960,1.8480>,<0,-8.762947,-4.185144>}
 smooth_triangle {<-.504,.72,1.776>,<.222194,-7.233128,-4.599452><-.528,.72,1.608>,<.373302,-9.72483,-1.062215><-.336,.696,1.824>,<.593539,-8.094158,-4.754879>}
 smooth_triangle {<-.336,.744,1.656>,<.815928,-9.628872,-2.417346><-.528,.72,1.608>,<.373302,-9.72483,-1.062215><-.336,.696,1.824>,<.593539,-8.094158,-4.754879>}
 smooth_triangle {<-.552,.744,1.368>,<1.823016,-9.502904,-1.286914><-.528,.72,1.608>,<.373302,-9.72483,-1.062215><-.336,.792,1.416>,<1.17484,-9.699463,-1.819507>}
 smooth_triangle {<-.336,.792,1.416>,<1.17484,-9.699463,-1.819507><-.528,.72,1.608>,<.373302,-9.72483,-1.062215><-.336,.744,1.656>,<.815928,-9.628872,-2.417346>}
 smooth_triangle {<0,.7920,1.4400>,<0,-9.804845,-1.960969><0,.7440,1.6800>,<0,-9.741026,-2.222873><-.3360,.7920,1.4160>,<1.17484,-9.699463,-1.819507>}
 smooth_triangle {<-.6,.864,.984>,<3.166351,-8.622485,-1.617962><-.552,.744,1.368>,<1.823016,-9.502904,-1.286914><-.336,.864,1.056>,<.520932,-9.796803,-1.269531>}
 smooth_triangle {<-.336,.864,1.056>,<.520932,-9.796803,-1.269531><-.552,.744,1.368>,<1.823016,-9.502904,-1.286914><-.336,.792,1.416>,<1.17484,-9.699463,-1.819507>}
 smooth_triangle {<0,.8640,1.0800>,<0,-9.934948,-.653657><0,.7920,1.4400>,<0,-9.804845,-1.960969><-.3360,.8640,1.0560>,<.520932,-9.796803,-1.269531>}
 smooth_triangle {<-.5280,.8640,.9600>,<0,-10,0><-.3360,.8640,1.0560>,<.520932,-9.796803,-1.269531><-.6000,.8640,.9840>,<3.166351,-8.622485,-1.617962>}
 smooth_triangle {<-.1920,.8640,1.0080>,<0,-10,0><-.3360,.8640,1.0560>,<.520932,-9.796803,-1.269531><-.5280,.8640,.9600>,<0,-10,0>}
 smooth_triangle {<-.1920,.8640,1.0080>,<0,-10,0><.0000,.8640,1.0800>,<0,-9.934948,-.653657><-.3360,.8640,1.0560>,<.520932,-9.796803,-1.269531>}
 smooth_triangle {<.0000,.8640,1.0320>,<0,-10,0><.0000,.8640,1.0800>,<0,-9.934948,-.653657><-.1920,.8640,1.0080>,<0,-10,0>}
 smooth_triangle {<-.3360,.7920,1.4160>,<1.17484,-9.699463,-1.819507><-.3360,.7440,1.6560>,<.815928,-9.628872,-2.417346><.0000,.7440,1.6800>,<0,-9.741026,-2.222873>}
 smooth_triangle {<-.3360,.8640,1.0560>,<.520932,-9.796803,-1.269531><-.3360,.7920,1.4160>,<1.17484,-9.699463,-1.819507><.0000,.7920,1.4400>,<0,-9.804845,-1.960969>}
 smooth_triangle {<-.576,.72,1.752>,<.095153,-9.793872,-.397836><-.504,.72,1.776>,<.222194,-7.233128,-4.599452><-.528,.72,1.608>,<.373302,-9.72483,-1.062215>}
 smooth_triangle {<-.552,.744,1.368>,<1.823016,-9.502904,-1.286914><-.576,.72,1.752>,<.095153,-9.793872,-.397836><-.528,.72,1.608>,<.373302,-9.72483,-1.062215>}
 smooth_triangle {<-.576,.72,1.752>,<.095153,-9.793872,-.397836><-.672,.696,1.728>,<2.915429,-9.551188,-.301683><-.552,.744,1.368>,<1.823016,-9.502904,-1.286914>}
 smooth_triangle {<-.672,.696,1.728>,<2.915429,-9.551188,-.301683><-.744,.672,1.656>,<3.620083,-9.311959,.085399><-.552,.744,1.368>,<1.823016,-9.502904,-1.286914>}
 smooth_triangle {<-.552,.744,1.368>,<1.823016,-9.502904,-1.286914><-.792,.648,1.56>,<4.83257,-6.587946,-2.921261><-.744,.672,1.656>,<3.620083,-9.311959,.085399>}
 smooth_triangle {<-.6,.864,.984>,<3.166351,-8.622485,-1.617962><-.792,.648,1.56>,<4.83257,-6.587946,-2.921261><-.552,.744,1.368>,<1.823016,-9.502904,-1.286914>}
 smooth_triangle {<-.6960,.8640,.8400>,<5.70024,-6.81279,-1.414069><-.5280,.8640,.9600>,<0,-10,0><-.6000,.8640,.9840>,<3.166351,-8.622485,-1.617962>}
 smooth_triangle {<-.72,.84,.744>,<7.893038,-5.912434,-.602197><-.84,.72,.792>,<8.309262,-3.450141,-.453537><-.696,.864,.84>,<5.70024,-6.81279,-1.414069>}
 smooth_triangle {<-.72,.864,.408>,<9.001547,-2.898954,.617769><-.84,.72,.792>,<8.309262,-3.450141,-.453537><-.72,.84,.744>,<7.893038,-5.912434,-.602197>}
 smooth_triangle {<-.72,.864,.408>,<9.001547,-2.898954,.617769><-.84,.336,.792>,<8.539985,-.578484,3.782691><-.84,.72,.792>,<8.309262,-3.450141,-.453537>}
 smooth_triangle {<-.72,.8640,.4080>,<9.001547,-2.898954,.617769><-.8400,.3360,.3840>,<9.875664,-1.108105,0><-.8400,.3360,.7920>,<8.539985,-.578484,3.782691>}
 smooth_triangle {<-.72,.8640,-.0960>,<9.738631,-2.213324,.294341><-.8400,.3360,.3840>,<9.875664,-1.108105,0><-.7200,.8640,.4080>,<9.001547,-2.898954,.617769>}
 smooth_triangle {<-.72,.8640,-.0960>,<9.738631,-2.213324,.294341><-.8400,.3360,-.0960>,<9.852034,-1.175823,.147171><-.8400,.3360,.3840>,<9.875664,-1.108105,0>}
 smooth_triangle {<-.72,.864,-.096>,<9.738631,-2.213324,.294341><-.84,.336,-.096>,<9.852034,-1.175823,.147171><-.696,.864,-.36>,<9.529588,-2.358476,-.592202>}
 smooth_triangle {<-.552,.864,-1.056>,<4.571049,-8.361252,1.532299><-.792,.648,-1.272>,<4.762715,-7.413235,3.294515><-.6,.864,-.936>,<4.15908,-8.571146,2.493951>}
 smooth_triangle {<-.552,.864,-1.056>,<4.571049,-8.361252,1.532299><-.792,.648,-1.272>,<4.762715,-7.413235,3.294515><-.744,.72,-1.344>,<5.898172,-7.700186,-.082023>}
 smooth_triangle {<-.432,.864,-1.176>,<3.277093,-8.644044,2.900662><-.672,.744,-1.416>,<3.045768,-9.234233,2.062822><-.552,.864,-1.056>,<4.571049,-8.361252,1.532299>}
 smooth_triangle {<-.552,.864,-1.056>,<4.571049,-8.361252,1.532299><-.744,.72,-1.344>,<5.898172,-7.700186,-.082023><-.672,.744,-1.416>,<3.045768,-9.234233,2.062822>}
 smooth_triangle {<-.432,.864,-1.176>,<3.277093,-8.644044,2.900662><-.672,.744,-1.416>,<3.045768,-9.234233,2.062822><-.504,.768,-1.488>,<1.33944,-8.497173,4.234365>}
 smooth_triangle {<-.288,.864,-1.248>,<.93238,-9.493334,2.958192><-.504,.768,-1.488>,<1.33944,-8.497173,4.234365><-.432,.864,-1.176>,<3.277093,-8.644044,2.900662>}
 smooth_triangle {<-.624,.6,-1.56>,<4.986191,-1.319487,8.339048><-.72,.576,-1.464>,<6.840304,-1.965368,6.530412><-.696,.336,-1.536>,<6.659262,-.501952,7.376583>}
 smooth_triangle {<-.624,.6,-1.56>,<4.986191,-1.319487,8.339048><-.696,.336,-1.536>,<6.659262,-.501952,7.376583><-.6,.336,-1.608>,<4.616733,-.448745,8.747582>}
 smooth_triangle {<-.48,.6,-1.608>,<2.763821,-3.27775,8.863598><-.48,.336,-1.656>,<2.415392,-.659585,9.572801><-.624,.6,-1.56>,<4.986191,-1.319487,8.339048>}
 smooth_triangle {<-.624,.6,-1.56>,<4.986191,-1.319487,8.339048><-.6,.336,-1.608>,<4.616733,-.448745,8.747582><-.48,.336,-1.656>,<2.415392,-.659585,9.572801>}
 smooth_triangle {<-.504,.768,-1.488>,<1.33944,-8.497173,4.234365><-.48,.6,-1.608>,<2.763821,-3.27775,8.863598><-.288,.696,-1.608>,<1.164398,-6.810043,6.592034>}
 smooth_triangle {<-.288,.696,-1.608>,<1.164398,-6.810043,6.592034><-.48,.6,-1.608>,<2.763821,-3.27775,8.863598><-.288,.552,-1.68>,<1.274127,-1.188661,9.605173>}
 smooth_triangle {<-.288,.552,-1.68>,<1.274127,-1.188661,9.605173><-.48,.336,-1.656>,<2.415392,-.659585,9.572801><-.264,.336,-1.68>,<.441708,.024538,9.975386>}
 smooth_triangle {<-.48,.6,-1.608>,<2.763821,-3.27775,8.863598><-.48,.336,-1.656>,<2.415392,-.659585,9.572801><-.288,.552,-1.68>,<1.274127,-1.188661,9.605173>}
 smooth_triangle {<-.336,.696,1.824>,<.593539,-8.094158,-4.754879><-.504,.72,1.776>,<.222194,-7.233128,-4.599452><-.408,.648,1.848>,<1.02368,-6.465769,-7.50346>}
 smooth_triangle {<-.336,.696,1.824>,<.593539,-8.094158,-4.754879><-.408,.648,1.848>,<1.02368,-6.465769,-7.50346><-.192,.648,1.896>,<.841406,-7.315529,-6.559826>}
 smooth_triangle {<-.3360,.6960,1.8240>,<.593539,-8.094158,-4.754879><-.1920,.6480,1.8960>,<.841406,-7.315529,-6.559826><.0000,.6480,1.8960>,<0,-7.691285,-6.304532>}
 smooth_triangle {<.0000,.6960,1.8480>,<0,-8.762947,-4.185144><-.3360,.6960,1.8240>,<.593539,-8.094158,-4.754879><.0000,.6480,1.8960>,<0,-7.691285,-6.304532>}
 smooth_triangle {<-.384,.48,1.968>,<-1.055092,-3.431636,-8.349508><-.408,.336,1.992>,<1.950054,-.493895,-9.579366><-.192,.48,2.016>,<1.740802,-.990534,-9.723992>}
 smooth_triangle {<-.456,.528,1.968>,<-.231344,-3.030293,-7.825187><-.408,.336,1.992>,<1.950054,-.493895,-9.579366><-.384,.48,1.968>,<-1.055092,-3.431636,-8.349508>}
 smooth_triangle {<-.456,.528,1.968>,<-.231344,-3.030293,-7.825187><-.552,.336,1.92>,<4.760488,.000001,-8.785982><-.408,.336,1.992>,<1.950054,-.493895,-9.579366>}
 smooth_triangle {<-.456,.5280,1.9680>,<-.231344,-3.030293,-7.825187><-.5520,.3360,1.9200>,<4.760488,.000001,-8.785982><-.5520,.5280,1.9200>,<4.808548,0,-8.7596>}
 smooth_triangle {<-.696,.864,.84>,<5.70024,-6.81279,-1.414069><-.84,.72,.792>,<8.309262,-3.450141,-.453537><-.6,.864,.984>,<3.166351,-8.622485,-1.617962>}
 smooth_triangle {<-.6,.864,.984>,<3.166351,-8.622485,-1.617962><-.84,.72,.792>,<8.309262,-3.450141,-.453537><-.84,.672,1.056>,<6.259048,-6.4266,1.642085>}
 smooth_triangle {<-.84,.72,1.2>,<5.757403,-7.686087,-.283448><-.84,.672,1.056>,<6.259048,-6.4266,1.642085><-.6,.864,.984>,<3.166351,-8.622485,-1.617962>}
 smooth_triangle {<-.84,.72,1.2>,<5.757403,-7.686087,-.283448><-.84,.672,1.368>,<5.233465,-7.75011,-2.855517><-.6,.864,.984>,<3.166351,-8.622485,-1.617962>}
 smooth_triangle {<-.84,.672,1.368>,<5.233465,-7.75011,-2.855517><-.792,.648,1.56>,<4.83257,-6.587946,-2.921261><-.6,.864,.984>,<3.166351,-8.622485,-1.617962>}
 smooth_triangle {<-.84,.672,1.368>,<5.233465,-7.75011,-2.855517><-.84,.6,1.512>,<5.251953,-4.296139,-5.7205><-.792,.648,1.56>,<4.83257,-6.587946,-2.921261>}
 smooth_triangle {<-.792,.648,1.56>,<4.83257,-6.587946,-2.921261><-.84,.6,1.512>,<5.251953,-4.296139,-5.7205><-.792,.528,1.56>,<4.309806,-4.040712,-5.421338>}
 smooth_triangle {<-.84,.6,1.512>,<5.251953,-4.296139,-5.7205><-.816,.48,1.608>,<6.068067,-2.494357,-5.439466><-.792,.528,1.56>,<4.309806,-4.040712,-5.421338>}
 smooth_triangle {<-.84,.72,.792>,<8.309262,-3.450141,-.453537><-.84,.576,.912>,<7.068174,-3.8364,3.324252><-.84,.672,1.056>,<6.259048,-6.4266,1.642085>}
 smooth_triangle {<-.84,.72,.792>,<8.309262,-3.450141,-.453537><-.84,.456,.816>,<8.105399,-1.975988,3.756284><-.84,.576,.912>,<7.068174,-3.8364,3.324252>}
 smooth_triangle {<-.696,.336,-1.536>,<6.659262,-.501952,7.376583><-.792,.288,-1.44>,<5.060344,-.657888,8.346447><-.72,.576,-1.464>,<6.840304,-1.965368,6.530412>}
 smooth_triangle {<-.72,.576,-1.464>,<6.840304,-1.965368,6.530412><-.816,.456,-1.416>,<5.628977,-3.254637,7.094249><-.792,.288,-1.44>,<5.060344,-.657888,8.346447>}
 smooth_triangle {<-.768,.576,-1.368>,<5.601627,-5.455939,5.775406><-.816,.456,-1.416>,<5.628977,-3.254637,7.094249><-.72,.576,-1.464>,<6.840304,-1.965368,6.530412>}
 smooth_triangle {<-.84,.576,-1.32>,<5.150104,-5.947823,6.00539><-.816,.456,-1.416>,<5.628977,-3.254637,7.094249><-.768,.576,-1.368>,<5.601627,-5.455939,5.775406>}
 smooth_triangle {<-.792,.648,-1.272>,<4.762715,-7.413235,3.294515><-.84,.576,-1.32>,<5.150104,-5.947823,6.00539><-.768,.576,-1.368>,<5.601627,-5.455939,5.775406>}
 smooth_triangle {<-.84,.672,-1.2>,<4.813039,-7.69367,3.475209><-.84,.576,-1.32>,<5.150104,-5.947823,6.00539><-.792,.648,-1.272>,<4.762715,-7.413235,3.294515>}
 smooth_triangle {<-.6,.864,-.936>,<4.15908,-8.571146,2.493951><-.84,.672,-1.2>,<4.813039,-7.69367,3.475209><-.792,.648,-1.272>,<4.762715,-7.413235,3.294515>}
 smooth_triangle {<-.6,.864,-.936>,<4.15908,-8.571146,2.493951><-.84,.672,-1.2>,<4.813039,-7.69367,3.475209><-.84,.72,-1.032>,<5.697816,-7.803333,-.147592>}
 smooth_triangle {<-.624,.864,-.816>,<5.964174,-7.742115,.175162><-.84,.672,-.888>,<5.988627,-7.026928,-2.269787><-.696,.864,-.576>,<8.402106,-4.410507,-.859973>}
 smooth_triangle {<-.696,.864,-.576>,<8.402106,-4.410507,-.859973><-.84,.672,-.888>,<5.988627,-7.026928,-2.269787><-.84,.6,-.744>,<7.027881,-4.827477,-4.356848>}
 smooth_triangle {<-.696,.864,-.576>,<8.402106,-4.410507,-.859973><-.84,.6,-.744>,<7.027881,-4.827477,-4.356848><-.84,.48,-.648>,<7.651265,-2.663862,-4.660882>}
 smooth_triangle {<-.696,.864,-.576>,<8.402106,-4.410507,-.859973><-.84,.48,-.648>,<7.651265,-2.663862,-4.660882><-.696,.864,-.36>,<9.529588,-2.358476,-.592202>}
 smooth_triangle {<-.624,.864,-.816>,<5.964174,-7.742115,.175162><-.84,.72,-1.032>,<5.697816,-7.803333,-.147592><-.84,.672,-.888>,<5.988627,-7.026928,-2.269787>}
 smooth_triangle {<-.624,.864,-.816>,<5.964174,-7.742115,.175162><-.84,.72,-1.032>,<5.697816,-7.803333,-.147592><-.6,.864,-.936>,<4.15908,-8.571146,2.493951>}
 smooth_triangle {<-.816,.456,-1.416>,<5.628977,-3.254637,7.094249><-.864,.432,-1.392>,<7.419739,-1.236771,5.070837><-.792,.288,-1.44>,<5.060344,-.657888,8.346447>}
 smooth_triangle {<-.864,.432,-1.392>,<7.419739,-1.236771,5.070837><-.864,.288,-1.416>,<6.781205,-.427743,5.806536><-.792,.288,-1.44>,<5.060344,-.657888,8.346447>}
 smooth_triangle {<-.84,.576,-1.32>,<5.150104,-5.947823,6.00539><-.888,.552,-1.296>,<7.822319,-2.450307,3.466394><-.816,.456,-1.416>,<5.628977,-3.254637,7.094249>}
 smooth_triangle {<-.888,.552,-1.296>,<7.822319,-2.450307,3.466394><-.864,.432,-1.392>,<7.419739,-1.236771,5.070837><-.816,.456,-1.416>,<5.628977,-3.254637,7.094249>}
 smooth_triangle {<-.84,.672,-1.2>,<4.813039,-7.69367,3.475209><-.888,.648,-1.176>,<8.310884,-2.665897,1.455871><-.84,.576,-1.32>,<5.150104,-5.947823,6.00539>}
 smooth_triangle {<-.888,.648,-1.176>,<8.310884,-2.665897,1.455871><-.888,.552,-1.296>,<7.822319,-2.450307,3.466394><-.84,.576,-1.32>,<5.150104,-5.947823,6.00539>}
 smooth_triangle {<-.84,.72,-1.032>,<5.697816,-7.803333,-.147592><-.888,.672,-1.032>,<5.56297,-3.214736,.319261><-.84,.672,-1.2>,<4.813039,-7.69367,3.475209>}
 smooth_triangle {<-.888,.672,-1.032>,<5.56297,-3.214736,.319261><-.888,.648,-1.176>,<8.310884,-2.665897,1.455871><-.84,.672,-1.2>,<4.813039,-7.69367,3.475209>}
 smooth_triangle {<-.84,.72,-1.032>,<5.697816,-7.803333,-.147592><-.888,.648,-.888>,<7.892675,-3.353572,-1.250889><-.84,.672,-.888>,<5.988627,-7.026928,-2.269787>}
 smooth_triangle {<-.888,.672,-1.032>,<5.56297,-3.214736,.319261><-.888,.648,-.888>,<7.892675,-3.353572,-1.250889><-.84,.72,-1.032>,<5.697816,-7.803333,-.147592>}
 smooth_triangle {<-.84,.672,-.888>,<5.988627,-7.026928,-2.269787><-.888,.576,-.768>,<8.157662,-2.552492,-1.853917><-.84,.6,-.744>,<7.027881,-4.827477,-4.356848>}
 smooth_triangle {<-.888,.648,-.888>,<7.892675,-3.353572,-1.250889><-.888,.576,-.768>,<8.157662,-2.552492,-1.853917><-.84,.672,-.888>,<5.988627,-7.026928,-2.269787>}
 smooth_triangle {<-.84,.6,-.744>,<7.027881,-4.827477,-4.356848><-.888,.456,-.672>,<7.747844,-1.941162,-3.55453><-.84,.48,-.648>,<7.651265,-2.663862,-4.660882>}
 smooth_triangle {<-.888,.576,-.768>,<8.157662,-2.552492,-1.853917><-.888,.456,-.672>,<7.747844,-1.941162,-3.55453><-.84,.6,-.744>,<7.027881,-4.827477,-4.356848>}
 smooth_triangle {<-.84,.48,-.648>,<7.651265,-2.663862,-4.660882><-.888,.312,-.648>,<8.496904,-.50642,-3.140102><-.84,.336,-.6>,<8.433989,-.972519,-3.958995>}
 smooth_triangle {<-.888,.456,-.672>,<7.747844,-1.941162,-3.55453><-.888,.312,-.648>,<8.496904,-.50642,-3.140102><-.84,.48,-.648>,<7.651265,-2.663862,-4.660882>}
 smooth_triangle {<-.84,.456,.816>,<8.105399,-1.975988,3.756284><-.888,.432,.864>,<8.903629,-.835322,2.69466><-.84,.336,.792>,<8.539985,-.578484,3.782691>}
 smooth_triangle {<-.888,.432,.864>,<8.903629,-.835322,2.69466><-.888,.288,.84>,<8.923871,-.215666,2.708208><-.84,.336,.792>,<8.539985,-.578484,3.782691>}
 smooth_triangle {<-.84,.576,.912>,<7.068174,-3.8364,3.324252><-.888,.552,.936>,<8.420506,-2.133625,2.460824><-.84,.456,.816>,<8.105399,-1.975988,3.756284>}
 smooth_triangle {<-.888,.552,.936>,<8.420506,-2.133625,2.460824><-.888,.432,.864>,<8.903629,-.835322,2.69466><-.84,.456,.816>,<8.105399,-1.975988,3.756284>}
 smooth_triangle {<-.84,.672,1.056>,<6.259048,-6.4266,1.642085><-.888,.648,1.056>,<7.71632,-3.273929,1.672416><-.84,.576,.912>,<7.068174,-3.8364,3.324252>}
 smooth_triangle {<-.888,.648,1.056>,<7.71632,-3.273929,1.672416><-.888,.552,.936>,<8.420506,-2.133625,2.460824><-.84,.576,.912>,<7.068174,-3.8364,3.324252>}
 smooth_triangle {<-.84,.72,1.2>,<5.757403,-7.686087,-.283448><-.888,.672,1.2>,<8.541024,-2.843933,.324771><-.84,.672,1.056>,<6.259048,-6.4266,1.642085>}
 smooth_triangle {<-.888,.672,1.2>,<8.541024,-2.843933,.324771><-.888,.648,1.056>,<7.71632,-3.273929,1.672416><-.84,.672,1.056>,<6.259048,-6.4266,1.642085>}
 smooth_triangle {<-.84,.72,1.2>,<5.757403,-7.686087,-.283448><-.888,.648,1.344>,<7.975197,-3.771529,-1.203524><-.84,.672,1.368>,<5.233465,-7.75011,-2.855517>}
 smooth_triangle {<-.888,.672,1.2>,<8.541024,-2.843933,.324771><-.888,.648,1.344>,<7.975197,-3.771529,-1.203524><-.84,.72,1.2>,<5.757403,-7.686087,-.283448>}
 smooth_triangle {<-.84,.672,1.368>,<5.233465,-7.75011,-2.855517><-.888,.576,1.488>,<8.257349,-2.3096,-2.304434><-.84,.6,1.512>,<5.251953,-4.296139,-5.7205>}
 smooth_triangle {<-.888,.648,1.344>,<7.975197,-3.771529,-1.203524><-.888,.576,1.488>,<8.257349,-2.3096,-2.304434><-.84,.672,1.368>,<5.233465,-7.75011,-2.855517>}
 smooth_triangle {<-.84,.6,1.512>,<5.251953,-4.296139,-5.7205><-.864,.456,1.56>,<8.207479,-1.774794,-4.887484><-.816,.48,1.608>,<6.068067,-2.494357,-5.439466>}
 smooth_triangle {<-.888,.576,1.488>,<8.257349,-2.3096,-2.304434><-.864,.456,1.56>,<8.207479,-1.774794,-4.887484><-.84,.6,1.512>,<5.251953,-4.296139,-5.7205>}
 smooth_triangle {<-.816,.48,1.608>,<6.068067,-2.494357,-5.439466><-.864,.312,1.608>,<6.462965,-.635411,-6.336123><-.792,.312,1.632>,<6.301083,-.006221,-6.344637>}
 smooth_triangle {<-.864,.456,1.56>,<8.207479,-1.774794,-4.887484><-.864,.312,1.608>,<6.462965,-.635411,-6.336123><-.816,.48,1.608>,<6.068067,-2.494357,-5.439466>}
 smooth_triangle {<-.792,.528,1.56>,<4.309806,-4.040712,-5.421338><-.816,.48,1.608>,<6.068067,-2.494357,-5.439466><-.744,.528,1.776>,<8.080293,-1.920716,-4.261075>}
 smooth_triangle {<-.744,.336,1.776>,<8.397731,.124994,-4.965433><-.816,.48,1.608>,<6.068067,-2.494357,-5.439466><-.792,.312,1.632>,<6.301083,-.006221,-6.344637>}
 smooth_triangle {<-.744,.528,1.776>,<8.080293,-1.920716,-4.261075><-.816,.48,1.608>,<6.068067,-2.494357,-5.439466><-.744,.336,1.776>,<8.397731,.124994,-4.965433>}
 smooth_triangle {<-.552,.3360,1.9200>,<4.760488,.000001,-8.785982><-.5520,.1680,1.9200>,<4.808545,0,-8.759602><-.4080,.1680,1.9920>,<3.349531,0,-9.275793>}
 smooth_triangle {<-.408,.1680,1.9920>,<3.349531,0,-9.275793><-.4080,.3360,1.9920>,<1.950054,-.493895,-9.579366><-.5520,.3360,1.9200>,<4.760488,.000001,-8.785982>}
 smooth_triangle {<-.696,.3360,-1.5360>,<6.659262,-.501952,7.376583><-.6960,.1680,-1.5360>,<6.535534,0,7.535534><-.6000,.1680,-1.6080>,<5.23797,0,8.428254>}
 smooth_triangle {<-.6,.1680,-1.6080>,<5.23797,0,8.428254><-.6000,.3360,-1.6080>,<4.616733,-.448745,8.747582><-.6960,.3360,-1.5360>,<6.659262,-.501952,7.376583>}
 smooth_triangle {<-.264,.2160,-1.6800>,<.736208,0,9.959226><-.4800,.1920,-1.6560>,<2.84404,0,9.502791><-.4800,.3360,-1.6560>,<2.415392,-.659585,9.572801>}
 smooth_triangle {<-.48,.3360,-1.6560>,<2.415392,-.659585,9.572801><-.2640,.3360,-1.6800>,<.441708,.024538,9.975386><-.2640,.2160,-1.6800>,<.736208,0,9.959226>}
 smooth_triangle {<-.48,.1920,-1.6560>,<2.84404,0,9.502791><-.6000,.1680,-1.6080>,<5.23797,0,8.428254><-.6000,.3360,-1.6080>,<4.616733,-.448745,8.747582>}
 smooth_triangle {<-.6,.3360,-1.6080>,<4.616733,-.448745,8.747582><-.4800,.3360,-1.6560>,<2.415392,-.659585,9.572801><-.4800,.1920,-1.6560>,<2.84404,0,9.502791>}
 smooth_triangle {<-.84,.72,.792>,<8.309262,-3.450141,-.453537><-.84,.336,.792>,<8.539985,-.578484,3.782691><-.84,.456,.816>,<8.105399,-1.975988,3.756284>}
 smooth_triangle {<-.84,.48,-.648>,<7.651265,-2.663862,-4.660882><-.84,.336,-.6>,<8.433989,-.972519,-3.958995><-.696,.864,-.36>,<9.529588,-2.358476,-.592202>}
 smooth_triangle {<-.288,.8640,-1.2480>,<.93238,-9.493334,2.958192><-.5040,.7680,-1.4880>,<1.33944,-8.497173,4.234365><.0000,.8640,-1.2960>,<0,-9.023632,4.212549>}
 smooth_triangle {<0,.8640,-1.2960>,<0,-9.023632,4.212549><-.5040,.7680,-1.4880>,<1.33944,-8.497173,4.234365><-.2880,.6960,-1.6080>,<1.164398,-6.810043,6.592034>}
 smooth_triangle {<-.84,.3360,.7920>,<8.539985,-.578484,3.782691><-.8400,.3360,.3840>,<9.875664,-1.108105,0><-.8400,.1680,.7920>,<9.023687,0,2.357024>}
 smooth_triangle {<-.84,.3360,.3840>,<9.875664,-1.108105,0><-.8400,.3360,-.0960>,<9.852034,-1.175823,.147171><-.8400,.1680,.0960>,<10,0,0>}
 smooth_triangle {<-.84,.3360,-.6000>,<8.433989,-.972519,-3.958995><-.8400,.1680,-.6000>,<9.023687,0,-2.357024><-.8400,.3360,-.0960>,<9.852034,-1.175823,.147171>}
 smooth_triangle {<-.84,.3360,-.0960>,<9.852034,-1.175823,.147171><-.8400,.1680,-.6000>,<9.023687,0,-2.357024><-.8400,.1680,.0960>,<10,0,0>}
 smooth_triangle {<-.84,.3360,.3840>,<9.875664,-1.108105,0><-.8400,.1680,.0960>,<10,0,0><-.8400,.1680,.7920>,<9.023687,0,2.357024>}
 smooth_triangle {<-.888,.6720,1.2>,<8.541024,-2.843933,.324771><-.8880,.6480,1.0560>,<7.71632,-3.273929,1.672416><-.8880,.5980,1.1100>,<10,0,0>}
 smooth_triangle {<-.888,.5980,1.1100>,<10,0,0><-.8880,.6120,1.1700>,<10,0,0><-.8880,.6720,1.2>,<8.541024,-2.843933,.324771>}
 smooth_triangle {<-.888,.6720,1.2>,<8.541024,-2.843933,.324771><-.8880,.6142,1.2300>,<10,0,0><-.8880,.6047,1.2900>,<10,0,0>}
 smooth_triangle {<-.888,.6047,1.2900>,<10,0,0><-.8880,.6480,1.3440>,<7.975197,-3.771529,-1.203524><-.8880,.6720,1.2>,<8.541024,-2.843933,.324771>}
 smooth_triangle {<-.888,.6480,1.0560>,<7.71632,-3.273929,1.672416><-.8880,.5520,.9360>,<8.420506,-2.133625,2.460824><-.8880,.5438,1.0080>,<10,0,0>}
 smooth_triangle {<-.888,.5438,1.0080>,<10,0,0><-.8880,.5753,1.0560>,<10,0,0><-.8880,.6480,1.0560>,<7.71632,-3.273929,1.672416>}
 smooth_triangle {<-.888,.5820,1.3500>,<10,0,0><-.8880,.5460,1.4100>,<10,0,0><-.8880,.5760,1.4880>,<8.257349,-2.3096,-2.304434>}
 smooth_triangle {<-.888,.5760,1.4880>,<8.257349,-2.3096,-2.304434><-.8880,.6480,1.3440>,<7.975197,-3.771529,-1.203524><-.8880,.5820,1.3500>,<10,0,0>}
 smooth_triangle {<-.888,.5760,1.4880>,<8.257349,-2.3096,-2.304434><-.8880,.5040,1.4580>,<10,0,0><-.8880,.4560,1.4940>,<9.562645,-.557494,-2.265204>}
 smooth_triangle {<-.888,.456,1.494>,<9.562645,-.557494,-2.265204><-.864,.456,1.56>,<8.207479,-1.774794,-4.887484><-.888,.576,1.488>,<8.257349,-2.3096,-2.304434>}
 smooth_triangle {<-.864,.456,1.56>,<8.207479,-1.774794,-4.887484><-.888,.402,1.518>,<9.182011,-1.163215,-3.751304><-.888,.372,1.524>,<9.310867,-.750943,-3.510837>}
 smooth_triangle {<-.888,.372,1.524>,<9.310867,-.750943,-3.510837><-.864,.312,1.608>,<6.462965,-.635411,-6.336123><-.864,.456,1.56>,<8.207479,-1.774794,-4.887484>}
 smooth_triangle {<-.888,.5520,.9360>,<8.420506,-2.133625,2.460824><-.8880,.4320,.8640>,<8.903629,-.835322,2.69466><-.8880,.4380,.9300>,<10,0,0>}
 smooth_triangle {<-.888,.4380,.9300>,<10,0,0><-.8880,.4980,.9660>,<10,0,0><-.8880,.5520,.9360>,<8.420506,-2.133625,2.460824>}
 smooth_triangle {<-.888,.4320,.8640>,<8.903629,-.835322,2.69466><-.8880,.2880,.8400>,<8.923871,-.215666,2.708208><-.8880,.3480,.9>,<10,0,0>}
 smooth_triangle {<-.888,.3480,.9>,<10,0,0><-.8880,.3780,.9060>,<10,0,0><-.8880,.4320,.8640>,<8.903629,-.835322,2.69466>}
 smooth_triangle {<-.888,.2280,.8880>,<10,0,0><-.8880,.1680,.8400>,<8.535532,0,3.535536><-.8880,.1680,.8880>,<10,0,0>}
 smooth_triangle {<-.888,.2880,.8400>,<8.923871,-.215666,2.708208><-.8880,.1680,.8400>,<8.535532,0,3.535536><-.8880,.2280,.8880>,<10,0,0>}
 smooth_triangle {<-.888,.2400,1.5360>,<9.511271,-.08852,-3.081901><-.8880,.1680,1.5360>,<9.486834,0,-3.162275><-.8640,.1680,1.6080>,<7.378645,0,-5.270463>}
 smooth_triangle {<-.888,.4020,-.7320>,<10,0,0><-.8880,.3420,-.7080>,<10,0,0><-.8880,.3120,-.6480>,<8.496904,-.50642,-3.140102>}
 smooth_triangle {<-.888,.3120,-.6480>,<8.496904,-.50642,-3.140102><-.8880,.4560,-.6720>,<7.747844,-1.941162,-3.55453><-.8880,.4020,-.7320>,<10,0,0>}
 smooth_triangle {<-.888,.3120,-.6480>,<8.496904,-.50642,-3.140102><-.8880,.2760,-.6960>,<10,0,0><-.8880,.1680,-.6480>,<8.535532,0,-3.535536>}
 smooth_triangle {<-.888,.2760,-.6960>,<10,0,0><-.8880,.1680,-.6960>,<10,0,0><-.8880,.1680,-.6480>,<8.535532,0,-3.535536>}
 smooth_triangle {<-.888,.3420,-.7080>,<10,0,0><-.8880,.2760,-.6960>,<10,0,0><-.8880,.3120,-.6480>,<8.496904,-.50642,-3.140102>}
 smooth_triangle {<-.888,.5760,-.7680>,<8.157662,-2.552492,-1.853917><-.8880,.5460,-.8400>,<10,0,0><-.8880,.5040,-.7980>,<10,0,0>}
 smooth_triangle {<-.888,.4560,-.7620>,<10,0,0><-.8880,.4020,-.7320>,<10,0,0><-.8880,.4560,-.6720>,<7.747844,-1.941162,-3.55453>}
 smooth_triangle {<-.888,.5760,-.7680>,<8.157662,-2.552492,-1.853917><-.8880,.5040,-.7980>,<10,0,0><-.8880,.4560,-.7620>,<10,0,0>}
 smooth_triangle {<-.888,.4560,-.7620>,<10,0,0><-.8880,.4560,-.6720>,<7.747844,-1.941162,-3.55453><-.8880,.5760,-.7680>,<8.157662,-2.552492,-1.853917>}
 smooth_triangle {<-.888,.6480,-.8880>,<7.892675,-3.353572,-1.250889><-.8880,.6060,-.9420>,<10,0,0><-.8880,.5820,-.8880>,<10,0,0>}
 smooth_triangle {<-.8880,.6720,-1.0320>,<5.56297,-3.214736,.319261><-.8880,.6188,-1.0620>,<5,0,0><-.8880,.6180,-1.0020>,<5,0,0>}
 smooth_triangle {<-.8880,.5820,-.8880>,<10,0,0><-.8880,.5460,-.8400>,<10,0,0><-.8880,.5760,-.7680>,<8.157662,-2.552492,-1.853917>}
 smooth_triangle {<-.8880,.5760,-.7680>,<8.157662,-2.552492,-1.853917><-.8880,.6480,-.8880>,<7.892675,-3.353572,-1.250889><-.8880,.5820,-.8880>,<10,0,0>}
 smooth_triangle {<-.8880,.6720,-1.0320>,<5.56297,-3.214736,.319261><-.8880,.6188,-1.0620>,<5,0,0><-.8880,.6180,-1.0020>,<5,0,0>}
 smooth_triangle {<-.8880,.6480,-1.1760>,<8.310884,-2.665897,1.455871><-.8880,.5843,-1.1808>,<10,0,0><-.8880,.6083,-1.1220>,<10,0,0>}
 smooth_triangle {<-.8880,.6480,-1.1760>,<8.310884,-2.665897,1.455871><-.8880,.6083,-1.1220>,<10,0,0><-.8880,.6188,-1.0620>,<5,0,0>}
 smooth_triangle {<-.8880,.6188,-1.0620>,<5,0,0><-.8880,.6720,-1.0320>,<5.56297,-3.214736,.319261><-.8880,.6480,-1.1760>,<8.310884,-2.665897,1.455871>}
 smooth_triangle {<-.8880,.6180,-1.0020>,<5,0,0><-.8880,.6060,-.9420>,<10,0,0><-.8880,.6480,-.8880>,<7.892675,-3.353572,-1.250889>}
 smooth_triangle {<-.8880,.6480,-.8880>,<7.892675,-3.353572,-1.250889><-.8880,.6720,-1.0320>,<5.56297,-3.214736,.319261><-.8880,.6180,-1.0020>,<5,0,0>}
 smooth_triangle {<-.8880,.5520,-1.2960>,<7.822319,-2.450307,3.466394><-.8880,.4980,-1.2803>,<9.784252,-.233368,1.523942><-.8880,.5468,-1.2383>,<10,0,0>}
 smooth_triangle {<-.8880,.6480,-1.1760>,<8.310884,-2.665897,1.455871><-.8880,.5520,-1.2960>,<7.822319,-2.450307,3.466394><-.8880,.5468,-1.2383>,<10,0,0>}
 smooth_triangle {<-.8880,.5468,-1.2383>,<10,0,0><-.8880,.5843,-1.1808>,<10,0,0><-.8880,.6480,-1.1760>,<8.310884,-2.665897,1.455871>}
 smooth_triangle {<-.864,.432,-1.392>,<7.419739,-1.236771,5.070837><-.888,.378,-1.326>,<9.517111,-.673724,2.986049><-.888,.438,-1.3068>,<9.550837,-1.053208,2.764546>}
 smooth_triangle {<-.888,.498,-1.2803>,<9.784252,-.233368,1.523942><-.888,.438,-1.3068>,<9.550837,-1.053208,2.764546><-.864,.432,-1.392>,<7.419739,-1.236771,5.070837>}
 smooth_triangle {<-.864,.432,-1.392>,<7.419739,-1.236771,5.070837><-.888,.552,-1.296>,<7.822319,-2.450307,3.466394><-.888,.498,-1.2803>,<9.784252,-.233368,1.523942>}
 smooth_triangle {<-.888,.348,-1.332>,<9.510788,-.462579,3.04778><-.888,.228,-1.344>,<9.509109,-.097986,3.088046><-.864,.288,-1.416>,<6.781205,-.427743,5.806536>}
 smooth_triangle {<-.864,.288,-1.416>,<6.781205,-.427743,5.806536><-.888,.348,-1.332>,<9.510788,-.462579,3.04778><-.888,.378,-1.326>,<9.517111,-.673724,2.986049>}
 smooth_triangle {<-.888,.378,-1.326>,<9.517111,-.673724,2.986049><-.864,.432,-1.392>,<7.419739,-1.236771,5.070837><-.864,.288,-1.416>,<6.781205,-.427743,5.806536>}
 smooth_triangle {<-.8640,.2880,-1.4160>,<6.781205,-.427743,5.806536><-.8880,.2280,-1.3440>,<9.509109,-.097986,3.088046><-.8640,.1680,-1.4160>,<7.37865,0,5.270461>}
 smooth_triangle {<-.8880,.2280,-1.3440>,<9.509109,-.097986,3.088046><-.8880,.1680,-1.3440>,<9.486834,0,3.162275><-.8640,.1680,-1.4160>,<7.37865,0,5.270461>}
 smooth_triangle {<-.8880,.3480,.9>,<10,0,0><-.8880,.2880,.8400>,<8.923871,-.215666,2.708208><-.8880,.2280,.8880>,<10,0,0>}
 smooth_triangle {<-.8880,.4380,.9300>,<10,0,0><-.8880,.4320,.8640>,<8.903629,-.835322,2.69466><-.8880,.3780,.9060>,<10,0,0>}
 smooth_triangle {<-.8880,.5520,.9360>,<8.420506,-2.133625,2.460824><-.8880,.4980,.9660>,<10,0,0><-.8880,.5438,1.0080>,<10,0,0>}
 smooth_triangle {<-.8880,.6480,1.0560>,<7.71632,-3.273929,1.672416><-.8880,.5753,1.0560>,<10,0,0><-.8880,.5980,1.1100>,<10,0,0>}
 smooth_triangle {<-.8880,.6720,1.2>,<8.541024,-2.843933,.324771><-.8880,.6120,1.1700>,<10,0,0><-.8880,.6142,1.2300>,<10,0,0>}
 smooth_triangle {<-.8880,.6480,1.3440>,<7.975197,-3.771529,-1.203524><-.8880,.6047,1.2900>,<10,0,0><-.8880,.5820,1.3500>,<10,0,0>}
 smooth_triangle {<-.8880,.5460,1.4100>,<10,0,0><-.8880,.5040,1.4580>,<10,0,0><-.8880,.5760,1.4880>,<8.257349,-2.3096,-2.304434>}
 smooth_triangle {<-.888,.456,1.494>,<9.562645,-.557494,-2.265204><-.888,.402,1.518>,<9.182011,-1.163215,-3.751304><-.864,.456,1.56>,<8.207479,-1.774794,-4.887484>}
 smooth_triangle {<-.888,.372,1.524>,<9.310867,-.750943,-3.510837><-.888,.24,1.536>,<9.511271,-.08852,-3.081901><-.864,.312,1.608>,<6.462965,-.635411,-6.336123>}
 smooth_triangle {<-.4080,.3360,1.9920>,<1.950054,-.493895,-9.579366><-.4080,.1680,1.9920>,<3.349531,0,-9.275793><-.1920,.1680,2.0160>,<.736212,0,-9.959225>}
 smooth_triangle {<-.1920,.3360,2.0160>,<.552159,0,-9.969419><-.4080,.3360,1.9920>,<1.950054,-.493895,-9.579366><-.1920,.1680,2.0160>,<.736212,0,-9.959225>}
 smooth_triangle {<-.1920,.48,2.0160>,<1.740802,-.990534,-9.723992><-.4080,.3360,1.9920>,<1.950054,-.493895,-9.579366><-.1920,.3360,2.0160>,<.552159,0,-9.969419>}
 smooth_triangle {<-.6720,.528,1.8480>,<6.10801,0,-7.823><-.5520,.3360,1.9200>,<4.760488,.000001,-8.785982><-.5520,.5280,1.9200>,<4.808548,0,-8.7596>}
 smooth_triangle {<-.5520,.336,1.9200>,<4.760488,.000001,-8.785982><-.6720,.1680,1.8480>,<6.10801,0,-7.823><-.6720,.5280,1.8480>,<6.10801,0,-7.823>}
 smooth_triangle {<-.5520,.336,1.9200>,<4.760488,.000001,-8.785982><-.6720,.1680,1.8480>,<6.10801,0,-7.823><-.5520,.1680,1.9200>,<4.808545,0,-8.759602>}
 smooth_triangle {<-.6720,.528,1.8480>,<6.10801,0,-7.823><-.7440,.3360,1.7760>,<8.397731,.124994,-4.965433><-.6720,.1680,1.8480>,<6.10801,0,-7.823>}
 smooth_triangle {<-.7440,.336,1.7760>,<8.397731,.124994,-4.965433><-.7440,.1680,1.7760>,<8.278951,0,-5.116672><-.6720,.1680,1.8480>,<6.10801,0,-7.823>}
 smooth_triangle {<-.7440,.528,1.7760>,<8.080293,-1.920716,-4.261075><-.7440,.3360,1.7760>,<8.397731,.124994,-4.965433><-.6720,.5280,1.8480>,<6.10801,0,-7.823>}
 smooth_triangle {<.7440,.528,1.7760>,<-8.080293,-1.920716,-4.261075><.7440,.3360,1.7760>,<-8.397731,.124994,-4.965433><.6720,.5280,1.8480>,<-6.10801,0,-7.823>}
 smooth_triangle {<.7440,.336,1.7760>,<-8.397731,.124994,-4.965433><.6720,.1680,1.8480>,<-6.10801,0,-7.823><.7440,.1680,1.7760>,<-8.278951,0,-5.116672>}
 smooth_triangle {<.6720,.528,1.8480>,<-6.10801,0,-7.823><.6720,.1680,1.8480>,<-6.10801,0,-7.823><.7440,.3360,1.7760>,<-8.397731,.124994,-4.965433>}
 smooth_triangle {<.5520,.336,1.9200>,<-4.808546,.000001,-8.759602><.5520,.1680,1.9200>,<-4.696409,0,-8.821158><.6720,.1680,1.8480>,<-6.10801,0,-7.823>}
 smooth_triangle {<.5520,.336,1.9200>,<-4.808546,.000001,-8.759602><.6720,.1680,1.8480>,<-6.10801,0,-7.823><.6720,.5280,1.8480>,<-6.10801,0,-7.823>}
 smooth_triangle {<.6720,.528,1.8480>,<-6.10801,0,-7.823><.5520,.3360,1.9200>,<-4.808546,.000001,-8.759602><.5520,.5280,1.9200>,<-4.808548,0,-8.7596>}
 smooth_triangle {<.1920,.48,2.0160>,<-1.740802,-.990534,-9.723992><.1920,.3360,2.0160>,<-.736212,0,-9.959225><.4080,.3360,1.9920>,<-2.265315,-.432158,-9.499979>}
 smooth_triangle {<.1920,.3360,2.0160>,<-.736212,0,-9.959225><.1920,.1680,2.0160>,<-.552159,0,-9.969419><.4080,.3360,1.9920>,<-2.265315,-.432158,-9.499979>}
 smooth_triangle {<.4080,.3360,1.9920>,<-2.265315,-.432158,-9.499979><.1920,.1680,2.0160>,<-.552159,0,-9.969419><.4080,.1680,1.9920>,<-2.788228,0,-9.441554>}
 smooth_triangle {<.888,.372,1.524>,<-9.310867,-.750943,-3.510837><.864,.312,1.608>,<-7.013081,-.741313,-5.811005><.888,.24,1.536>,<-9.511271,-.08852,-3.081901>}
 smooth_triangle {<.888,.456,1.494>,<-9.562645,-.557494,-2.265204><.864,.456,1.56>,<-8.207479,-1.774794,-4.887484><.888,.402,1.518>,<-9.182011,-1.163215,-3.751304>}
 smooth_triangle {<.8880,.5460,1.4100>,<-10,0,0><.8880,.5040,1.4580>,<-10,0,0><.8880,.5760,1.4880>,<-8.257349,-2.3096,-2.304434>}
 smooth_triangle {<.8880,.6480,1.3440>,<-7.975197,-3.771529,-1.203524><.8880,.6047,1.2900>,<-10,0,0><.8880,.5820,1.3500>,<-10,0,0>}
 smooth_triangle {<.8880,.6720,1.2>,<-8.541024,-2.843933,.324771><.8880,.6120,1.1700>,<-10,0,0><.8880,.6142,1.2300>,<-10,0,0>}
 smooth_triangle {<.8880,.6480,1.0560>,<-7.71632,-3.273929,1.672416><.8880,.5753,1.0560>,<-10,0,0><.8880,.5980,1.1100>,<-10,0,0>}
 smooth_triangle {<.8880,.5520,.9360>,<-8.420506,-2.133625,2.460824><.8880,.4980,.9660>,<-10,0,0><.8880,.5438,1.0080>,<-10,0,0>}
 smooth_triangle {<.8880,.4380,.9300>,<-10,0,0><.8880,.4320,.8640>,<-8.903629,-.835322,2.69466><.8880,.3780,.9060>,<-10,0,0>}
 smooth_triangle {<.8880,.3480,.9>,<-10,0,0><.8880,.2880,.8400>,<-8.923871,-.215666,2.708208><.8880,.2280,.8880>,<-10,0,0>}
 smooth_triangle {<.8880,.2280,-1.3440>,<-9.509109,-.097986,3.088046><.8640,.1680,-1.4160>,<-6.324558,0,6.324553><.8880,.1680,-1.3440>,<-9.486834,0,3.162275>}
 smooth_triangle {<.8640,.2880,-1.4160>,<-7.384358,-.499034,5.193154><.8640,.1680,-1.4160>,<-6.324558,0,6.324553><.8880,.2280,-1.3440>,<-9.509109,-.097986,3.088046>}
 smooth_triangle {<.864,.288,-1.416>,<-7.384358,-.499034,5.193154><.888,.348,-1.332>,<-9.510788,-.462579,3.04778><.888,.378,-1.326>,<-9.517111,-.673724,2.986049>}
 smooth_triangle {<.888,.378,-1.326>,<-9.517111,-.673724,2.986049><.864,.432,-1.392>,<-7.033807,-1.369279,5.608561><.864,.288,-1.416>,<-7.384358,-.499034,5.193154>}
 smooth_triangle {<.888,.348,-1.332>,<-9.510788,-.462579,3.04778><.864,.288,-1.416>,<-7.384358,-.499034,5.193154><.888,.228,-1.344>,<-9.509109,-.097986,3.088046>}
 smooth_triangle {<.888,.552,-1.296>,<-8.104116,-2.211981,3.103517><.864,.432,-1.392>,<-7.033807,-1.369279,5.608561><.888,.438,-1.3068>,<-9.729623,-.380349,1.828557>}
 smooth_triangle {<.8880,.4380,-1.3068>,<-9.729623,-.380349,1.828557><.8880,.4980,-1.2803>,<-10,0,0><.8880,.5520,-1.2960>,<-8.104116,-2.211981,3.103517>}
 smooth_triangle {<.864,.432,-1.392>,<-7.033807,-1.369279,5.608561><.888,.378,-1.326>,<-9.517111,-.673724,2.986049><.888,.438,-1.3068>,<-9.729623,-.380349,1.828557>}
 smooth_triangle {<.8880,.6480,-1.1760>,<-8.310884,-2.665897,1.455871><.8880,.5520,-1.2960>,<-8.104116,-2.211981,3.103517><.8880,.5468,-1.2383>,<-10,0,0>}
 smooth_triangle {<.8880,.5468,-1.2383>,<-10,0,0><.8880,.5843,-1.1808>,<-10,0,0><.8880,.6480,-1.1760>,<-8.310884,-2.665897,1.455871>}
 smooth_triangle {<.8880,.5520,-1.2960>,<-8.104116,-2.211981,3.103517><.8880,.4980,-1.2803>,<-10,0,0><.8880,.5468,-1.2383>,<-10,0,0>}
 smooth_triangle {<.8880,.6180,-1.0020>,<-10,0,0><.8880,.6060,-.9420>,<-10,0,0><.8880,.6480,-.8880>,<-7.892675,-3.353572,-1.250889>}
 smooth_triangle {<.8880,.6480,-.8880>,<-7.892675,-3.353572,-1.250889><.8880,.6720,-1.0320>,<-8.420113,-3.214736,.319261><.8880,.6180,-1.0020>,<-10,0,0>}
 smooth_triangle {<.8880,.6480,-1.1760>,<-8.310884,-2.665897,1.455871><.8880,.6083,-1.1220>,<-10,0,0><.8880,.6188,-1.0620>,<-10,0,0>}
 smooth_triangle {<.8880,.6188,-1.0620>,<-10,0,0><.8880,.6720,-1.0320>,<-8.420113,-3.214736,.319261><.8880,.6480,-1.1760>,<-8.310884,-2.665897,1.455871>}
 smooth_triangle {<.8880,.6480,-1.1760>,<-8.310884,-2.665897,1.455871><.8880,.5843,-1.1808>,<-10,0,0><.8880,.6083,-1.1220>,<-10,0,0>}
 smooth_triangle {<.8880,.6720,-1.0320>,<-8.420113,-3.214736,.319261><.8880,.6188,-1.0620>,<-10,0,0><.8880,.6180,-1.0020>,<-10,0,0>}
 smooth_triangle {<.8880,.5820,-.8880>,<-10,0,0><.8880,.5460,-.8400>,<-10,0,0><.8880,.5760,-.7680>,<-8.157662,-2.552492,-1.853917>}
 smooth_triangle {<.8880,.5760,-.7680>,<-8.157662,-2.552492,-1.853917><.8880,.6480,-.8880>,<-7.892675,-3.353572,-1.250889><.8880,.5820,-.8880>,<-10,0,0>}
 smooth_triangle {<.8880,.6720,-1.0320>,<-8.420113,-3.214736,.319261><.8880,.6188,-1.0620>,<-10,0,0><.8880,.6180,-1.0020>,<-10,0,0>}
 smooth_triangle {<.8880,.6480,-.8880>,<-7.892675,-3.353572,-1.250889><.8880,.6060,-.9420>,<-10,0,0><.8880,.5820,-.8880>,<-10,0,0>}
 smooth_triangle {<.8880,.5760,-.7680>,<-8.157662,-2.552492,-1.853917><.8880,.5040,-.7980>,<-10,0,0><.8880,.4560,-.7620>,<-10,0,0>}
 smooth_triangle {<.8880,.4560,-.7620>,<-10,0,0><.8880,.4560,-.6720>,<-7.747844,-1.941162,-3.55453><.8880,.5760,-.7680>,<-8.157662,-2.552492,-1.853917>}
 smooth_triangle {<.8880,.4560,-.7620>,<-10,0,0><.8880,.4020,-.7320>,<-10,0,0><.8880,.4560,-.6720>,<-7.747844,-1.941162,-3.55453>}
 smooth_triangle {<.8880,.5760,-.7680>,<-8.157662,-2.552492,-1.853917><.8880,.5460,-.8400>,<-10,0,0><.8880,.5040,-.7980>,<-10,0,0>}
 smooth_triangle {<.8880,.3420,-.7080>,<-10,0,0><.8880,.2760,-.6960>,<-10,0,0><.8880,.3120,-.6480>,<-8.496904,-.50642,-3.140102>}
 smooth_triangle {<.8880,.2760,-.6960>,<-10,0,0><.8880,.1680,-.6960>,<-10,0,0><.8880,.1680,-.6480>,<-8.535532,0,-3.535536>}
 smooth_triangle {<.8880,.3120,-.6480>,<-8.496904,-.50642,-3.140102><.8880,.2760,-.6960>,<-10,0,0><.8880,.1680,-.6480>,<-8.535532,0,-3.535536>}
 smooth_triangle {<.8880,.4020,-.7320>,<-10,0,0><.8880,.3420,-.7080>,<-10,0,0><.8880,.3120,-.6480>,<-8.496904,-.50642,-3.140102>}
 smooth_triangle {<.8880,.3120,-.6480>,<-8.496904,-.50642,-3.140102><.8880,.4560,-.6720>,<-7.747844,-1.941162,-3.55453><.8880,.4020,-.7320>,<-10,0,0>}
 smooth_triangle {<.8880,.2400,1.5360>,<-9.511271,-.08852,-3.081901><.8640,.1680,1.6080>,<-6.324551,0,-6.324556><.8880,.1680,1.5360>,<-9.486834,0,-3.162275>}
 smooth_triangle {<.8880,.2880,.8400>,<-8.923871,-.215666,2.708208><.8880,.1680,.8400>,<-8.535532,0,3.535536><.8880,.2280,.8880>,<-10,0,0>}
 smooth_triangle {<.8880,.2280,.8880>,<-10,0,0><.8880,.1680,.8400>,<-8.535532,0,3.535536><.8880,.1680,.8880>,<-10,0,0>}
 smooth_triangle {<.8880,.4320,.8640>,<-8.903629,-.835322,2.69466><.8880,.2880,.8400>,<-8.923871,-.215666,2.708208><.8880,.3480,.9>,<-10,0,0>}
 smooth_triangle {<.8880,.3480,.9>,<-10,0,0><.8880,.3780,.9060>,<-10,0,0><.8880,.4320,.8640>,<-8.903629,-.835322,2.69466>}
 smooth_triangle {<.8880,.5520,.9360>,<-8.420506,-2.133625,2.460824><.8880,.4320,.8640>,<-8.903629,-.835322,2.69466><.8880,.4380,.9300>,<-10,0,0>}
 smooth_triangle {<.8880,.4380,.9300>,<-10,0,0><.8880,.4980,.9660>,<-10,0,0><.8880,.5520,.9360>,<-8.420506,-2.133625,2.460824>}
 smooth_triangle {<.864,.456,1.56>,<-8.207479,-1.774794,-4.887484><.888,.402,1.518>,<-9.182011,-1.163215,-3.751304><.888,.372,1.524>,<-9.310867,-.750943,-3.510837>}
 smooth_triangle {<.888,.372,1.524>,<-9.310867,-.750943,-3.510837><.864,.312,1.608>,<-7.013081,-.741313,-5.811005><.864,.456,1.56>,<-8.207479,-1.774794,-4.887484>}
 smooth_triangle {<.8880,.5760,1.4880>,<-8.257349,-2.3096,-2.304434><.8880,.5040,1.4580>,<-10,0,0><.8880,.4560,1.4940>,<-9.562645,-.557494,-2.265204>}
 smooth_triangle {<.888,.456,1.494>,<-9.562645,-.557494,-2.265204><.864,.456,1.56>,<-8.207479,-1.774794,-4.887484><.888,.576,1.488>,<-8.257349,-2.3096,-2.304434>}
 smooth_triangle {<.8880,.5820,1.3500>,<-10,0,0><.8880,.5460,1.4100>,<-10,0,0><.8880,.5760,1.4880>,<-8.257349,-2.3096,-2.304434>}
 smooth_triangle {<.8880,.5760,1.4880>,<-8.257349,-2.3096,-2.304434><.8880,.6480,1.3440>,<-7.975197,-3.771529,-1.203524><.8880,.5820,1.3500>,<-10,0,0>}
 smooth_triangle {<.8880,.6480,1.0560>,<-7.71632,-3.273929,1.672416><.8880,.5520,.9360>,<-8.420506,-2.133625,2.460824><.8880,.5438,1.0080>,<-10,0,0>}
 smooth_triangle {<.8880,.5438,1.0080>,<-10,0,0><.8880,.5753,1.0560>,<-10,0,0><.8880,.6480,1.0560>,<-7.71632,-3.273929,1.672416>}
 smooth_triangle {<.8880,.6720,1.2>,<-8.541024,-2.843933,.324771><.8880,.6142,1.2300>,<-10,0,0><.8880,.6047,1.2900>,<-10,0,0>}
 smooth_triangle {<.8880,.6047,1.29>,<-10,0,0><.8880,.6480,1.3440>,<-7.975197,-3.771529,-1.203524><.8880,.6720,1.2>,<-8.541024,-2.843933,.324771>}
 smooth_triangle {<.8880,.6720,1.2>,<-8.541024,-2.843933,.324771><.8880,.6480,1.0560>,<-7.71632,-3.273929,1.672416><.8880,.5980,1.1100>,<-10,0,0>}
 smooth_triangle {<.8880,.5980,1.1100>,<-10,0,0><.8880,.6120,1.1700>,<-10,0,0><.8880,.6720,1.2>,<-8.541024,-2.843933,.324771>}
 smooth_triangle {<.8400,.3360,.3840>,<-9.875664,-1.108105,0><.8400,.1680,.0960>,<-10,0,0><.8400,.1680,.7920>,<-9.023687,0,2.357024>}
 smooth_triangle {<.8400,.3360,-.0960>,<-9.852034,-1.175823,.147171><.8400,.1680,-.6>,<-9.023687,0,-2.357024><.8400,.1680,.0960>,<-10,0,0>}
 smooth_triangle {<.8400,.3360,-.6>,<-8.433989,-.972519,-3.958995><.8400,.1680,-.6>,<-9.023687,0,-2.357024><.8400,.3360,-.0960>,<-9.852034,-1.175823,.147171>}
 smooth_triangle {<.8400,.3360,.3840>,<-9.875664,-1.108105,0><.8400,.3360,-.0960>,<-9.852034,-1.175823,.147171><.8400,.1680,.0960>,<-10,0,0>}
 smooth_triangle {<.8400,.3360,.7920>,<-8.539985,-.578484,3.782691><.8400,.3360,.3840>,<-9.875664,-1.108105,0><.8400,.1680,.7920>,<-9.023687,0,2.357024>}
 smooth_triangle {<0,.8640,-1.2960>,<0,-9.023632,4.212549><.2880,.6960,-1.6080>,<-1.164398,-6.810043,6.592034><.5040,.7680,-1.4880>,<-1.33944,-8.497173,4.234365>}
 smooth_triangle {<.2880,.8640,-1.2480>,<-.93238,-9.493334,2.958192><0,.8640,-1.2960>,<0,-9.023632,4.212549><.5040,.7680,-1.4880>,<-1.33944,-8.497173,4.234365>}
 smooth_triangle {<.84,.48,-.648>,<-7.651265,-2.663862,-4.660882><.696,.864,-.36>,<-9.529588,-2.358476,-.592202><.84,.336,-.6>,<-8.433989,-.972519,-3.958995>}
 smooth_triangle {<.84,.72,.792>,<-8.309262,-3.450141,-.453537><.84,.336,.792>,<-8.539985,-.578484,3.782691><.84,.456,.816>,<-8.105399,-1.975988,3.756284>}
 smooth_triangle {<.4800,.1920,-1.6560>,<-2.84404,0,9.502791><.6,.1680,-1.6080>,<-4.856954,0,8.642383><.6,.3360,-1.6080>,<-4.847278,-.373954,8.622985>}
 smooth_triangle {<.6,.3360,-1.6080>,<-4.847278,-.373954,8.622985><.4800,.3360,-1.6560>,<-2.415392,-.659585,9.572801><.4800,.1920,-1.6560>,<-2.84404,0,9.502791>}
 smooth_triangle {<.2640,.2160,-1.6800>,<-.552156,0,9.969419><.4800,.1920,-1.6560>,<-2.84404,0,9.502791><.4800,.3360,-1.6560>,<-2.415392,-.659585,9.572801>}
 smooth_triangle {<.4800,.3360,-1.6560>,<-2.415392,-.659585,9.572801><.2640,.3360,-1.6800>,<-.441708,.024538,9.975386><.2640,.2160,-1.6800>,<-.552156,0,9.969419>}
 smooth_triangle {<.6,.3360,-1.6080>,<-4.847278,-.373954,8.622985><.6,.1680,-1.6080>,<-4.856954,0,8.642383><.6960,.1680,-1.5360>,<-6.357024,0,7.690355>}
 smooth_triangle {<.6960,.1680,-1.5360>,<-6.357024,0,7.690355><.6960,.3360,-1.5360>,<-6.769138,-.585611,7.27268><.6000,.3360,-1.6080>,<-4.847278,-.373954,8.622985>}
 smooth_triangle {<.4080,.3360,1.9920>,<-2.265315,-.432158,-9.499979><.4080,.1680,1.9920>,<-2.788228,0,-9.441554><.5520,.1680,1.9200>,<-4.696409,0,-8.821158>}
 smooth_triangle {<.5520,.1680,1.9200>,<-4.696409,0,-8.821158><.5520,.3360,1.9200>,<-4.808546,.000001,-8.759602><.4080,.3360,1.9920>,<-2.265315,-.432158,-9.499979>}
 smooth_triangle {<.744,.528,1.776>,<-8.080293,-1.920716,-4.261075><.744,.336,1.776>,<-8.397731,.124994,-4.965433><.816,.48,1.608>,<-6.068067,-2.494357,-5.439466>}
 smooth_triangle {<.744,.336,1.776>,<-8.397731,.124994,-4.965433><.792,.312,1.632>,<-5.67332,-.004976,-6.973077><.816,.48,1.608>,<-6.068067,-2.494357,-5.439466>}
 smooth_triangle {<.792,.528,1.56>,<-4.309806,-4.040712,-5.421338><.744,.528,1.776>,<-8.080293,-1.920716,-4.261075><.816,.48,1.608>,<-6.068067,-2.494357,-5.439466>}
 smooth_triangle {<.864,.456,1.56>,<-8.207479,-1.774794,-4.887484><.816,.48,1.608>,<-6.068067,-2.494357,-5.439466><.864,.312,1.608>,<-7.013081,-.741313,-5.811005>}
 smooth_triangle {<.816,.48,1.608>,<-6.068067,-2.494357,-5.439466><.792,.312,1.632>,<-5.67332,-.004976,-6.973077><.864,.312,1.608>,<-7.013081,-.741313,-5.811005>}
 smooth_triangle {<.888,.576,1.488>,<-8.257349,-2.3096,-2.304434><.84,.6,1.512>,<-5.251953,-4.296139,-5.7205><.864,.456,1.56>,<-8.207479,-1.774794,-4.887484>}
 smooth_triangle {<.84,.6,1.512>,<-5.251953,-4.296139,-5.7205><.816,.48,1.608>,<-6.068067,-2.494357,-5.439466><.864,.456,1.56>,<-8.207479,-1.774794,-4.887484>}
 smooth_triangle {<.888,.648,1.344>,<-7.975197,-3.771529,-1.203524><.84,.672,1.368>,<-5.233465,-7.75011,-2.855517><.888,.576,1.488>,<-8.257349,-2.3096,-2.304434>}
 smooth_triangle {<.84,.672,1.368>,<-5.233465,-7.75011,-2.855517><.84,.6,1.512>,<-5.251953,-4.296139,-5.7205><.888,.576,1.488>,<-8.257349,-2.3096,-2.304434>}
 smooth_triangle {<.888,.672,1.2>,<-8.541024,-2.843933,.324771><.84,.72,1.2>,<-5.757403,-7.686087,-.283448><.888,.648,1.344>,<-7.975197,-3.771529,-1.203524>}
 smooth_triangle {<.84,.72,1.2>,<-5.757403,-7.686087,-.283448><.84,.672,1.368>,<-5.233465,-7.75011,-2.855517><.888,.648,1.344>,<-7.975197,-3.771529,-1.203524>}
 smooth_triangle {<.888,.672,1.2>,<-8.541024,-2.843933,.324771><.84,.672,1.056>,<-6.259048,-6.4266,1.642085><.888,.648,1.056>,<-7.71632,-3.273929,1.672416>}
 smooth_triangle {<.84,.72,1.2>,<-5.757403,-7.686087,-.283448><.84,.672,1.056>,<-6.259048,-6.4266,1.642085><.888,.672,1.2>,<-8.541024,-2.843933,.324771>}
 smooth_triangle {<.888,.648,1.056>,<-7.71632,-3.273929,1.672416><.84,.576,.912>,<-7.068174,-3.8364,3.324252><.888,.552,.936>,<-8.420506,-2.133625,2.460824>}
 smooth_triangle {<.84,.672,1.056>,<-6.259048,-6.4266,1.642085><.84,.576,.912>,<-7.068174,-3.8364,3.324252><.888,.648,1.056>,<-7.71632,-3.273929,1.672416>}
 smooth_triangle {<.888,.552,.936>,<-8.420506,-2.133625,2.460824><.84,.456,.816>,<-8.105399,-1.975988,3.756284><.888,.432,.864>,<-8.903629,-.835322,2.69466>}
 smooth_triangle {<.84,.576,.912>,<-7.068174,-3.8364,3.324252><.84,.456,.816>,<-8.105399,-1.975988,3.756284><.888,.552,.936>,<-8.420506,-2.133625,2.460824>}
 smooth_triangle {<.888,.432,.864>,<-8.903629,-.835322,2.69466><.84,.336,.792>,<-8.539985,-.578484,3.782691><.888,.288,.84>,<-8.923871,-.215666,2.708208>}
 smooth_triangle {<.84,.456,.816>,<-8.105399,-1.975988,3.756284><.84,.336,.792>,<-8.539985,-.578484,3.782691><.888,.432,.864>,<-8.903629,-.835322,2.69466>}
 smooth_triangle {<.888,.456,-.672>,<-7.747844,-1.941162,-3.55453><.84,.48,-.648>,<-7.651265,-2.663862,-4.660882><.888,.312,-.648>,<-8.496904,-.50642,-3.140102>}
 smooth_triangle {<.84,.48,-.648>,<-7.651265,-2.663862,-4.660882><.84,.336,-.6>,<-8.433989,-.972519,-3.958995><.888,.312,-.648>,<-8.496904,-.50642,-3.140102>}
 smooth_triangle {<.888,.576,-.768>,<-8.157662,-2.552492,-1.853917><.84,.6,-.744>,<-7.027881,-4.827477,-4.356848><.888,.456,-.672>,<-7.747844,-1.941162,-3.55453>}
 smooth_triangle {<.84,.6,-.744>,<-7.027881,-4.827477,-4.356848><.84,.48,-.648>,<-7.651265,-2.663862,-4.660882><.888,.456,-.672>,<-7.747844,-1.941162,-3.55453>}
 smooth_triangle {<.888,.648,-.888>,<-7.892675,-3.353572,-1.250889><.84,.672,-.888>,<-5.988627,-7.026928,-2.269787><.888,.576,-.768>,<-8.157662,-2.552492,-1.853917>}
 smooth_triangle {<.84,.672,-.888>,<-5.988627,-7.026928,-2.269787><.84,.6,-.744>,<-7.027881,-4.827477,-4.356848><.888,.576,-.768>,<-8.157662,-2.552492,-1.853917>}
 smooth_triangle {<.888,.672,-1.032>,<-8.420113,-3.214736,.319261><.84,.72,-1.032>,<-5.697816,-7.803333,-.147592><.888,.648,-.888>,<-7.892675,-3.353572,-1.250889>}
 smooth_triangle {<.84,.72,-1.032>,<-5.697816,-7.803333,-.147592><.84,.672,-.888>,<-5.988627,-7.026928,-2.269787><.888,.648,-.888>,<-7.892675,-3.353572,-1.250889>}
 smooth_triangle {<.888,.672,-1.032>,<-8.420113,-3.214736,.319261><.84,.672,-1.2>,<-4.813039,-7.69367,3.475209><.888,.648,-1.176>,<-8.310884,-2.665897,1.455871>}
 smooth_triangle {<.84,.72,-1.032>,<-5.697816,-7.803333,-.147592><.84,.672,-1.2>,<-4.813039,-7.69367,3.475209><.888,.672,-1.032>,<-8.420113,-3.214736,.319261>}
 smooth_triangle {<.888,.648,-1.176>,<-8.310884,-2.665897,1.455871><.84,.576,-1.32>,<-5.150104,-5.947823,6.00539><.888,.552,-1.296>,<-8.104116,-2.211981,3.103517>}
 smooth_triangle {<.84,.672,-1.2>,<-4.813039,-7.69367,3.475209><.84,.576,-1.32>,<-5.150104,-5.947823,6.00539><.888,.648,-1.176>,<-8.310884,-2.665897,1.455871>}
 smooth_triangle {<.888,.552,-1.296>,<-8.104116,-2.211981,3.103517><.816,.456,-1.416>,<-5.628977,-3.254637,7.094249><.864,.432,-1.392>,<-7.033807,-1.369279,5.608561>}
 smooth_triangle {<.84,.576,-1.32>,<-5.150104,-5.947823,6.00539><.816,.456,-1.416>,<-5.628977,-3.254637,7.094249><.888,.552,-1.296>,<-8.104116,-2.211981,3.103517>}
 smooth_triangle {<.864,.432,-1.392>,<-7.033807,-1.369279,5.608561><.792,.288,-1.44>,<-4.789192,-.563904,8.509359><.864,.288,-1.416>,<-7.384358,-.499034,5.193154>}
 smooth_triangle {<.816,.456,-1.416>,<-5.628977,-3.254637,7.094249><.792,.288,-1.44>,<-4.789192,-.563904,8.509359><.864,.432,-1.392>,<-7.033807,-1.369279,5.608561>}
 smooth_triangle {<.624,.864,-.816>,<-5.964174,-7.742115,.175162><.6,.864,-.936>,<-4.15908,-8.571146,2.493951><.84,.72,-1.032>,<-5.697816,-7.803333,-.147592>}
 smooth_triangle {<.624,.864,-.816>,<-5.964174,-7.742115,.175162><.84,.72,-1.032>,<-5.697816,-7.803333,-.147592><.84,.672,-.888>,<-5.988627,-7.026928,-2.269787>}
 smooth_triangle {<.696,.864,-.576>,<-8.402106,-4.410507,-.859973><.84,.48,-.648>,<-7.651265,-2.663862,-4.660882><.696,.864,-.36>,<-9.529588,-2.358476,-.592202>}
 smooth_triangle {<.696,.864,-.576>,<-8.402106,-4.410507,-.859973><.84,.6,-.744>,<-7.027881,-4.827477,-4.356848><.84,.48,-.648>,<-7.651265,-2.663862,-4.660882>}
 smooth_triangle {<.696,.864,-.576>,<-8.402106,-4.410507,-.859973><.84,.672,-.888>,<-5.988627,-7.026928,-2.269787><.84,.6,-.744>,<-7.027881,-4.827477,-4.356848>}
 smooth_triangle {<.624,.864,-.816>,<-5.964174,-7.742115,.175162><.696,.864,-.576>,<-8.402106,-4.410507,-.859973><.84,.672,-.888>,<-5.988627,-7.026928,-2.269787>}
 smooth_triangle {<.6,.864,-.936>,<-4.15908,-8.571146,2.493951><.84,.672,-1.2>,<-4.813039,-7.69367,3.475209><.84,.72,-1.032>,<-5.697816,-7.803333,-.147592>}
 smooth_triangle {<.6,.864,-.936>,<-4.15908,-8.571146,2.493951><.792,.648,-1.272>,<-4.762715,-7.413235,3.294515><.84,.672,-1.2>,<-4.813039,-7.69367,3.475209>}
 smooth_triangle {<.84,.672,-1.2>,<-4.813039,-7.69367,3.475209><.792,.648,-1.272>,<-4.762715,-7.413235,3.294515><.84,.576,-1.32>,<-5.150104,-5.947823,6.00539>}
 smooth_triangle {<.792,.648,-1.272>,<-4.762715,-7.413235,3.294515><.768,.576,-1.368>,<-5.601627,-5.455939,5.775406><.84,.576,-1.32>,<-5.150104,-5.947823,6.00539>}
 smooth_triangle {<.84,.576,-1.32>,<-5.150104,-5.947823,6.00539><.816,.456,-1.416>,<-5.628977,-3.254637,7.094249><.768,.576,-1.368>,<-5.601627,-5.455939,5.775406>}
 smooth_triangle {<.768,.576,-1.368>,<-5.601627,-5.455939,5.775406><.816,.456,-1.416>,<-5.628977,-3.254637,7.094249><.72,.576,-1.464>,<-6.840304,-1.965368,6.530412>}
 smooth_triangle {<.72,.576,-1.464>,<-6.840304,-1.965368,6.530412><.792,.288,-1.44>,<-4.789192,-.563904,8.509359><.816,.456,-1.416>,<-5.628977,-3.254637,7.094249>}
 smooth_triangle {<.696,.336,-1.536>,<-6.769138,-.585611,7.27268><.72,.576,-1.464>,<-6.840304,-1.965368,6.530412><.792,.288,-1.44>,<-4.789192,-.563904,8.509359>}
 smooth_triangle {<.84,.72,.792>,<-8.309262,-3.450141,-.453537><.84,.456,.816>,<-8.105399,-1.975988,3.756284><.84,.576,.912>,<-7.068174,-3.8364,3.324252>}
 smooth_triangle {<.84,.72,.792>,<-8.309262,-3.450141,-.453537><.84,.576,.912>,<-7.068174,-3.8364,3.324252><.84,.672,1.056>,<-6.259048,-6.4266,1.642085>}
 smooth_triangle {<.84,.6,1.512>,<-5.251953,-4.296139,-5.7205><.792,.528,1.56>,<-4.309806,-4.040712,-5.421338><.816,.48,1.608>,<-6.068067,-2.494357,-5.439466>}
 smooth_triangle {<.792,.648,1.56>,<-4.83257,-6.587946,-2.921261><.792,.528,1.56>,<-4.309806,-4.040712,-5.421338><.84,.6,1.512>,<-5.251953,-4.296139,-5.7205>}
 smooth_triangle {<.84,.672,1.368>,<-5.233465,-7.75011,-2.855517><.792,.648,1.56>,<-4.83257,-6.587946,-2.921261><.84,.6,1.512>,<-5.251953,-4.296139,-5.7205>}
 smooth_triangle {<.84,.672,1.368>,<-5.233465,-7.75011,-2.855517><.6,.864,.984>,<-3.166351,-8.622485,-1.617962><.792,.648,1.56>,<-4.83257,-6.587946,-2.921261>}
 smooth_triangle {<.84,.72,1.2>,<-5.757403,-7.686087,-.283448><.6,.864,.984>,<-3.166351,-8.622485,-1.617962><.84,.672,1.368>,<-5.233465,-7.75011,-2.855517>}
 smooth_triangle {<.84,.72,1.2>,<-5.757403,-7.686087,-.283448><.6,.864,.984>,<-3.166351,-8.622485,-1.617962><.84,.672,1.056>,<-6.259048,-6.4266,1.642085>}
 smooth_triangle {<.6,.864,.984>,<-3.166351,-8.622485,-1.617962><.84,.72,.792>,<-8.309262,-3.450141,-.453537><.84,.672,1.056>,<-6.259048,-6.4266,1.642085>}
 smooth_triangle {<.696,.864,.84>,<-5.70024,-6.81279,-1.414069><.84,.72,.792>,<-8.309262,-3.450141,-.453537><.6,.864,.984>,<-3.166351,-8.622485,-1.617962>}
 smooth_triangle {<.4560,.5280,1.9680>,<.231344,-3.030293,-7.825187><.5520,.3360,1.9200>,<-4.808546,.000001,-8.759602><.5520,.5280,1.9200>,<-4.808548,0,-8.7596>}
 smooth_triangle {<.456,.528,1.968>,<.231344,-3.030293,-7.825187><.408,.336,1.992>,<-2.265315,-.432158,-9.499979><.552,.336,1.92>,<-4.808546,.000001,-8.759602>}
 smooth_triangle {<.456,.528,1.968>,<.231344,-3.030293,-7.825187><.384,.48,1.968>,<1.055092,-3.431636,-8.349508><.408,.336,1.992>,<-2.265315,-.432158,-9.499979>}
 smooth_triangle {<.384,.48,1.968>,<1.055092,-3.431636,-8.349508><.408,.336,1.992>,<-2.265315,-.432158,-9.499979><.192,.48,2.016>,<-1.740802,-.990534,-9.723992>}
 smooth_triangle {<.0000,.6960,1.8480>,<0,-8.762947,-4.185144><.0000,.6480,1.8960>,<0,-7.691285,-6.304532><.3360,.6960,1.8240>,<-.593539,-8.094158,-4.754879>}
 smooth_triangle {<.3360,.6960,1.8240>,<-.593539,-8.094158,-4.754879><.0000,.6480,1.8960>,<0,-7.691285,-6.304532><.1920,.6480,1.8960>,<-.841406,-7.315529,-6.559826>}
 smooth_triangle {<.336,.696,1.824>,<-.593539,-8.094158,-4.754879><.192,.648,1.896>,<-.841406,-7.315529,-6.559826><.408,.648,1.848>,<-1.02368,-6.465769,-7.50346>}
 smooth_triangle {<.336,.696,1.824>,<-.593539,-8.094158,-4.754879><.408,.648,1.848>,<-1.02368,-6.465769,-7.50346><.504,.72,1.776>,<-.222194,-7.233128,-4.599452>}
 smooth_triangle {<.48,.6,-1.608>,<-2.763821,-3.27775,8.863598><.288,.552,-1.68>,<-1.592659,-1.485827,9.506466><.48,.336,-1.656>,<-2.415392,-.659585,9.572801>}
 smooth_triangle {<.288,.552,-1.68>,<-1.592659,-1.485827,9.506466><.264,.336,-1.68>,<-.441708,.024538,9.975386><.48,.336,-1.656>,<-2.415392,-.659585,9.572801>}
 smooth_triangle {<.288,.696,-1.608>,<-1.164398,-6.810043,6.592034><.288,.552,-1.68>,<-1.592659,-1.485827,9.506466><.48,.6,-1.608>,<-2.763821,-3.27775,8.863598>}
 smooth_triangle {<.504,.768,-1.488>,<-1.33944,-8.497173,4.234365><.288,.696,-1.608>,<-1.164398,-6.810043,6.592034><.48,.6,-1.608>,<-2.763821,-3.27775,8.863598>}
 smooth_triangle {<.624,.6,-1.56>,<-4.986191,-1.319487,8.339048><.48,.336,-1.656>,<-2.415392,-.659585,9.572801><.6,.336,-1.608>,<-4.847278,-.373954,8.622985>}
 smooth_triangle {<.48,.6,-1.608>,<-2.763821,-3.27775,8.863598><.48,.336,-1.656>,<-2.415392,-.659585,9.572801><.624,.6,-1.56>,<-4.986191,-1.319487,8.339048>}
 smooth_triangle {<.624,.6,-1.56>,<-4.986191,-1.319487,8.339048><.6,.336,-1.608>,<-4.847278,-.373954,8.622985><.696,.336,-1.536>,<-6.769138,-.585611,7.27268>}
 smooth_triangle {<.624,.6,-1.56>,<-4.986191,-1.319487,8.339048><.696,.336,-1.536>,<-6.769138,-.585611,7.27268><.72,.576,-1.464>,<-6.840304,-1.965368,6.530412>}
 smooth_triangle {<.288,.864,-1.248>,<-.93238,-9.493334,2.958192><.504,.768,-1.488>,<-1.33944,-8.497173,4.234365><.432,.864,-1.176>,<-3.277093,-8.644044,2.900662>}
 smooth_triangle {<.432,.864,-1.176>,<-3.277093,-8.644044,2.900662><.504,.768,-1.488>,<-1.33944,-8.497173,4.234365><.672,.744,-1.416>,<-3.045768,-9.234233,2.062822>}
 smooth_triangle {<.552,.864,-1.056>,<-4.571049,-8.361252,1.532299><.672,.744,-1.416>,<-3.045768,-9.234233,2.062822><.744,.72,-1.344>,<-5.898172,-7.700186,-.082023>}
 smooth_triangle {<.432,.864,-1.176>,<-3.277093,-8.644044,2.900662><.672,.744,-1.416>,<-3.045768,-9.234233,2.062822><.552,.864,-1.056>,<-4.571049,-8.361252,1.532299>}
 smooth_triangle {<.552,.864,-1.056>,<-4.571049,-8.361252,1.532299><.744,.72,-1.344>,<-5.898172,-7.700186,-.082023><.792,.648,-1.272>,<-4.762715,-7.413235,3.294515>}
 smooth_triangle {<.552,.864,-1.056>,<-4.571049,-8.361252,1.532299><.792,.648,-1.272>,<-4.762715,-7.413235,3.294515><.6,.864,-.936>,<-4.15908,-8.571146,2.493951>}
 smooth_triangle {<.72,.864,-.096>,<-9.738631,-2.213324,.294341><.696,.864,-.36>,<-9.529588,-2.358476,-.592202><.84,.336,-.096>,<-9.852034,-1.175823,.147171>}
 smooth_triangle {<.7200,.8640,-.0960>,<-9.738631,-2.213324,.294341><.8400,.3360,-.0960>,<-9.852034,-1.175823,.147171><.8400,.3360,.3840>,<-9.875664,-1.108105,0>}
 smooth_triangle {<.7200,.8640,-.0960>,<-9.738631,-2.213324,.294341><.8400,.3360,.3840>,<-9.875664,-1.108105,0><.7200,.8640,.4080>,<-9.001547,-2.898954,.617769>}
 smooth_triangle {<.7200,.8640,.4080>,<-9.001547,-2.898954,.617769><.8400,.3360,.3840>,<-9.875664,-1.108105,0><.8400,.3360,.7920>,<-8.539985,-.578484,3.782691>}
 smooth_triangle {<.72,.864,.408>,<-9.001547,-2.898954,.617769><.84,.336,.792>,<-8.539985,-.578484,3.782691><.84,.72,.792>,<-8.309262,-3.450141,-.453537>}
 smooth_triangle {<.72,.864,.408>,<-9.001547,-2.898954,.617769><.72,.84,.744>,<-7.893038,-5.912434,-.602197><.84,.72,.792>,<-8.309262,-3.450141,-.453537>}
 smooth_triangle {<.72,.84,.744>,<-7.893038,-5.912434,-.602197><.696,.864,.84>,<-5.70024,-6.81279,-1.414069><.84,.72,.792>,<-8.309262,-3.450141,-.453537>}
 smooth_triangle {<.6960,.8640,.8400>,<-5.70024,-6.81279,-1.414069><.5280,.8640,.9600>,<0,-10,0><.6000,.8640,.9840>,<-3.166351,-8.622485,-1.617962>}
 smooth_triangle {<.6,.864,.984>,<-3.166351,-8.622485,-1.617962><.552,.744,1.368>,<-1.823016,-9.502904,-1.286914><.792,.648,1.56>,<-4.83257,-6.587946,-2.921261>}
 smooth_triangle {<.552,.744,1.368>,<-1.823016,-9.502904,-1.286914><.744,.672,1.656>,<-3.620083,-9.311959,.085399><.792,.648,1.56>,<-4.83257,-6.587946,-2.921261>}
 smooth_triangle {<.672,.696,1.728>,<-2.915429,-9.551188,-.301683><.552,.744,1.368>,<-1.823016,-9.502904,-1.286914><.744,.672,1.656>,<-3.620083,-9.311959,.085399>}
 smooth_triangle {<.576,.72,1.752>,<-.095153,-9.793872,-.397836><.552,.744,1.368>,<-1.823016,-9.502904,-1.286914><.672,.696,1.728>,<-2.915429,-9.551188,-.301683>}
 smooth_triangle {<.552,.744,1.368>,<-1.823016,-9.502904,-1.286914><.528,.72,1.608>,<-.373302,-9.72483,-1.062215><.576,.72,1.752>,<-.095153,-9.793872,-.397836>}
 smooth_triangle {<.576,.72,1.752>,<-.095153,-9.793872,-.397836><.504,.72,1.776>,<-.222194,-7.233128,-4.599452><.528,.72,1.608>,<-.373302,-9.72483,-1.062215>}
 smooth_triangle {<.3360,.8640,1.0560>,<-.520932,-9.796803,-1.269531><.0000,.7920,1.4400>,<0,-9.804845,-1.960969><.3360,.7920,1.4160>,<-1.17484,-9.699463,-1.819507>}
 smooth_triangle {<.3360,.7920,1.4160>,<-1.17484,-9.699463,-1.819507><.0000,.7440,1.6800>,<0,-9.741026,-2.222873><.3360,.7440,1.6560>,<-.815928,-9.628872,-2.417346>}
 smooth_triangle {<.0000,.8640,1.0320>,<0,-10,0><.0000,.8640,1.0800>,<0,-9.934948,-.653657><.1920,.8640,1.0080>,<0,-10,0>}
 smooth_triangle {<.1920,.8640,1.0080>,<0,-10,0><.0000,.8640,1.0800>,<0,-9.934948,-.653657><.3360,.8640,1.0560>,<-.520932,-9.796803,-1.269531>}
 smooth_triangle {<.1920,.8640,1.0080>,<0,-10,0><.3360,.8640,1.0560>,<-.520932,-9.796803,-1.269531><.5280,.8640,.9600>,<0,-10,0>}
 smooth_triangle {<.5280,.8640,.9600>,<0,-10,0><.3360,.8640,1.0560>,<-.520932,-9.796803,-1.269531><.6000,.8640,.9840>,<-3.166351,-8.622485,-1.617962>}
 smooth_triangle {<.0000,.8640,1.0800>,<0,-9.934948,-.653657><.0000,.7920,1.4400>,<0,-9.804845,-1.960969><.3360,.8640,1.0560>,<-.520932,-9.796803,-1.269531>}
 smooth_triangle {<.336,.864,1.056>,<-.520932,-9.796803,-1.269531><.336,.792,1.416>,<-1.17484,-9.699463,-1.819507><.552,.744,1.368>,<-1.823016,-9.502904,-1.286914>}
 smooth_triangle {<.6,.864,.984>,<-3.166351,-8.622485,-1.617962><.336,.864,1.056>,<-.520932,-9.796803,-1.269531><.552,.744,1.368>,<-1.823016,-9.502904,-1.286914>}
 smooth_triangle {<.0000,.7920,1.4400>,<0,-9.804845,-1.960969><.0000,.7440,1.6800>,<0,-9.741026,-2.222873><.3360,.7920,1.4160>,<-1.17484,-9.699463,-1.819507>}
 smooth_triangle {<.336,.792,1.416>,<-1.17484,-9.699463,-1.819507><.336,.744,1.656>,<-.815928,-9.628872,-2.417346><.528,.72,1.608>,<-.373302,-9.72483,-1.062215>}
 smooth_triangle {<.552,.744,1.368>,<-1.823016,-9.502904,-1.286914><.336,.792,1.416>,<-1.17484,-9.699463,-1.819507><.528,.72,1.608>,<-.373302,-9.72483,-1.062215>}
 smooth_triangle {<.336,.744,1.656>,<-.815928,-9.628872,-2.417346><.336,.696,1.824>,<-.593539,-8.094158,-4.754879><.528,.72,1.608>,<-.373302,-9.72483,-1.062215>}
 smooth_triangle {<.504,.72,1.776>,<-.222194,-7.233128,-4.599452><.336,.696,1.824>,<-.593539,-8.094158,-4.754879><.528,.72,1.608>,<-.373302,-9.72483,-1.062215>}
 smooth_triangle {<.3360,.744,1.6560>,<-.815928,-9.628872,-2.417346><.0000,.6960,1.8480>,<0,-8.762947,-4.185144><.3360,.6960,1.8240>,<-.593539,-8.094158,-4.754879>}
 smooth_triangle {<.0000,.744,1.6800>,<0,-9.741026,-2.222873><.0000,.6960,1.8480>,<0,-8.762947,-4.185144><.3360,.7440,1.6560>,<-.815928,-9.628872,-2.417346>}
 smooth_triangle {<.0000,1.224,0>,<0,-9.958234,.09193><.2640,1.2000,0>,<-.724017,-9.964189,.074512><.2640,1.2000,.4080>,<-.644412,-9.967687,-.124248>}
 smooth_triangle {<.2640,1.2,.4080>,<-.644412,-9.967687,-.124248><.2640,1.2000,0>,<-.724017,-9.964189,.074512><.5280,1.1760,0>,<-4.420814,-7.864534,.794042>}
 smooth_triangle {<.2640,1.2,.4080>,<-.644412,-9.967687,-.124248><.5280,1.1760,0>,<-4.420814,-7.864534,.794042><.5760,1.1760,.4080>,<-6.627222,-6.520643,-.129202>}
 smooth_triangle {<.2640,1.2,0>,<-.724017,-9.964189,.074512><.5280,1.1760,0>,<-4.420814,-7.864534,.794042><.3360,1.2000,-.4320>,<-1.851759,-9.447659,1.356797>}
 smooth_triangle {<.3360,1.2,-.4320>,<-1.851759,-9.447659,1.356797><.5040,1.1280,-.4080>,<-4.739333,-8.26937,1.006724><.5280,1.1760,0>,<-4.420814,-7.864534,.794042>}
 smooth_triangle {<.528,.936,-.888>,<-6.036633,-6.905983,3.123109><.432,.864,-1.176>,<-3.277093,-8.644044,2.900662><.552,.864,-1.056>,<-4.571049,-8.361252,1.532299>}
 smooth_triangle {<.48,1.008,-.864>,<-7.641836,-5.741682,2.792942><.432,.864,-1.176>,<-3.277093,-8.644044,2.900662><.528,.936,-.888>,<-6.036633,-6.905983,3.123109>}
 smooth_triangle {<.48,1.008,-.864>,<-7.641836,-5.741682,2.792942><.528,.936,-.888>,<-6.036633,-6.905983,3.123109><.528,1.008,-.696>,<-7.919195,-5.624855,2.356346>}
 smooth_triangle {<.552,1.104,-.408>,<-5.603539,-7.833131,1.018618><.504,1.128,-.504>,<-5.724639,-7.402631,1.213222><.528,1.008,-.696>,<-7.919195,-5.624855,2.356346>}
 smooth_triangle {<.504,1.128,-.504>,<-5.724639,-7.402631,1.213222><.48,1.008,-.864>,<-7.641836,-5.741682,2.792942><.528,1.008,-.696>,<-7.919195,-5.624855,2.356346>}
 smooth_triangle {<.504,1.128,-.408>,<-4.739333,-8.26937,1.006724><.504,1.128,-.504>,<-5.724639,-7.402631,1.213222><.552,1.104,-.408>,<-5.603539,-7.833131,1.018618>}
 smooth_triangle {<.5040,1.1280,-.4080>,<-4.739333,-8.26937,1.006724><.5520,1.1040,-.4080>,<-5.603539,-7.833131,1.018618><.5520,1.1280,0>,<-7.342303,-5.904128,1.349279>}
 smooth_triangle {<.5280,1.1760,0>,<-4.420814,-7.864534,.794042><.5040,1.1280,-.4080>,<-4.739333,-8.26937,1.006724><.5520,1.1280,0>,<-7.342303,-5.904128,1.349279>}
 smooth_triangle {<.5280,1.1760,0>,<-4.420814,-7.864534,.794042><.5520,1.1280,0>,<-7.342303,-5.904128,1.349279><.6000,1.1280,.1680>,<-7.830866,-5.850233,1.212272>}
 smooth_triangle {<.5760,1.1760,.4080>,<-6.627222,-6.520643,-.129202><.5280,1.1760,0>,<-4.420814,-7.864534,.794042><.6000,1.1280,.1680>,<-7.830866,-5.850233,1.212272>}
 smooth_triangle {<.576,1.176,.408>,<-6.627222,-6.520643,-.129202><.6,1.128,.168>,<-7.830866,-5.850233,1.212272><.624,1.104,.312>,<-8.439861,-5.27299,-.26519>}
 smooth_triangle {<.3360,1.2000,-.4320>,<-1.851759,-9.447659,1.356797><.2640,1.2000,0>,<-.724017,-9.964189,.074512><.0000,1.2000,-.4560>,<.007092,-9.793038,1.405292>}
 smooth_triangle {<.0000,1.2240,0>,<0,-9.958234,.09193><.0000,1.2000,-.4560>,<.007092,-9.793038,1.405292><.2640,1.2000,0>,<-.724017,-9.964189,.074512>}
 smooth_triangle {<.336,1.2,-.432>,<-1.851759,-9.447659,1.356797><.312,1.176,-.528>,<-1.679152,-9.356106,2.198537><.504,1.128,-.408>,<-4.739333,-8.26937,1.006724>}
 smooth_triangle {<.312,1.176,-.528>,<-1.679152,-9.356106,2.198537><.504,1.128,-.504>,<-5.724639,-7.402631,1.213222><.504,1.128,-.408>,<-4.739333,-8.26937,1.006724>}
 smooth_triangle {<.696,.864,.84>,<-5.70024,-6.81279,-1.414069><.576,1.176,.408>,<-6.627222,-6.520643,-.129202><.72,.84,.744>,<-7.893038,-5.912434,-.602197>}
 smooth_triangle {<.576,1.176,.408>,<-6.627222,-6.520643,-.129202><.624,1.104,.312>,<-8.439861,-5.27299,-.26519><.72,.84,.744>,<-7.893038,-5.912434,-.602197>}
 smooth_triangle {<0,1.2,-.456>,<.007092,-9.793038,1.405292><0,1.176,-.528>,<.075273,-9.557555,2.916374><.312,1.176,-.528>,<-1.679152,-9.356106,2.198537>}
 smooth_triangle {<.312,1.176,-.528>,<-1.679152,-9.356106,2.198537><.336,1.2,-.432>,<-1.851759,-9.447659,1.356797><0,1.2,-.456>,<.007092,-9.793038,1.405292>}
 smooth_triangle {<.7920,.2880,-1.4400>,<-4.789192,-.563904,8.509359><.7920,.1680,-1.4400>,<-5.768138,0,7.876324><.8640,.1680,-1.4160>,<-6.324558,0,6.324553>}
 smooth_triangle {<.8640,.1680,-1.4160>,<-6.324558,0,6.324553><.8640,.2880,-1.4160>,<-7.384358,-.499034,5.193154><.7920,.2880,-1.4400>,<-4.789192,-.563904,8.509359>}
 smooth_triangle {<.8400,.3360,.7920>,<-8.539985,-.578484,3.782691><.8880,.2880,.8400>,<-8.923871,-.215666,2.708208><.8880,.1680,.8400>,<-8.535532,0,3.535536>}
 smooth_triangle {<.8880,.1680,.8400>,<-8.535532,0,3.535536><.8400,.1680,.7920>,<-9.023687,0,2.357024><.8400,.3360,.7920>,<-8.539985,-.578484,3.782691>}
 smooth_triangle {<.8400,.3360,-.6000>,<-8.433989,-.972519,-3.958995><.8880,.3120,-.6480>,<-8.496904,-.50642,-3.140102><.8880,.1680,-.6480>,<-8.535532,0,-3.535536>}
 smooth_triangle {<.8880,.1680,-.6480>,<-8.535532,0,-3.535536><.8400,.1680,-.6000>,<-9.023687,0,-2.357024><.8400,.3360,-.6000>,<-8.433989,-.972519,-3.958995>}
 smooth_triangle {<.7440,.3360,1.7760>,<-8.397731,.124994,-4.965433><.7920,.3120,1.6320>,<-5.67332,-.004976,-6.973077><.7920,.1680,1.6320>,<-7.378645,0,-5.270463>}
 smooth_triangle {<.7920,.1680,1.6320>,<-7.378645,0,-5.270463><.7440,.1680,1.7760>,<-8.278951,0,-5.116672><.7440,.3360,1.7760>,<-8.397731,.124994,-4.965433>}
 smooth_triangle {<.7920,.3120,1.6320>,<-5.67332,-.004976,-6.973077><.7920,.1680,1.6320>,<-7.378645,0,-5.270463><.8640,.1680,1.6080>,<-6.324551,0,-6.324556>}
 smooth_triangle {<.8640,.1680,1.6080>,<-6.324551,0,-6.324556><.8640,.3120,1.6080>,<-7.013081,-.741313,-5.811005><.7920,.3120,1.6320>,<-5.67332,-.004976,-6.973077>}
 smooth_triangle {<.6960,.3360,-1.5360>,<-6.769138,-.585611,7.27268><.7920,.2880,-1.4400>,<-4.789192,-.563904,8.509359><.7920,.1680,-1.4400>,<-5.768138,0,7.876324>}
 smooth_triangle {<.7920,.1680,-1.44>,<-5.768138,0,7.876324><.6960,.1680,-1.5360>,<-6.357024,0,7.690355><.6960,.3360,-1.5360>,<-6.769138,-.585611,7.27268>}
 smooth_triangle {<.696,.864,-.36>,<-9.529588,-2.358476,-.592202><.84,.336,-.6>,<-8.433989,-.972519,-3.958995><.84,.336,-.096>,<-9.852034,-1.175823,.147171>}
 smooth_triangle {<-.2640,.3360,-1.68>,<.441708,.024538,9.975386><-.2640,.2160,-1.6800>,<.736208,0,9.959226><.2640,.2160,-1.6800>,<-.552156,0,9.969419>}
 smooth_triangle {<.2640,.2160,-1.68>,<-.552156,0,9.969419><.2640,.3360,-1.6800>,<-.441708,.024538,9.975386><-.2640,.3360,-1.6800>,<.441708,.024538,9.975386>}
 smooth_triangle {<-.288,.552,-1.68>,<1.274127,-1.188661,9.605173><-.264,.336,-1.68>,<.441708,.024538,9.975386><.264,.336,-1.68>,<-.441708,.024538,9.975386>}
 smooth_triangle {<.264,.336,-1.68>,<-.441708,.024538,9.975386><.288,.552,-1.68>,<-1.592659,-1.485827,9.506466><-.288,.552,-1.68>,<1.274127,-1.188661,9.605173>}
 smooth_triangle {<.0000,.8640,-1.296>,<0,-9.023632,4.212549><-.2880,.6960,-1.6080>,<1.164398,-6.810043,6.592034><.2880,.6960,-1.6080>,<-1.164398,-6.810043,6.592034>}
 smooth_triangle {<-.2640,1.2000,.408>,<.644412,-9.967687,-.124248><.0000,1.2240,0>,<0,-9.958234,.09193><.2640,1.2000,.4080>,<-.644412,-9.967687,-.124248>}
 smooth_triangle {<-.1920,.3360,2.016>,<.552159,0,-9.969419><-.1920,.1680,2.0160>,<.736212,0,-9.959225><.1920,.1680,2.0160>,<-.552159,0,-9.969419>}
 smooth_triangle {<.1920,.1680,2.016>,<-.552159,0,-9.969419><.1920,.3360,2.0160>,<-.736212,0,-9.959225><-.1920,.3360,2.0160>,<.552159,0,-9.969419>}
 smooth_triangle {<-.8640,.3120,1.608>,<6.462965,-.635411,-6.336123><-.8880,.2400,1.5360>,<9.511271,-.08852,-3.081901><-.8640,.1680,1.6080>,<7.378645,0,-5.270463>}
 smooth_triangle {<.8640,.3120,1.608>,<-7.013081,-.741313,-5.811005><.8640,.1680,1.6080>,<-6.324551,0,-6.324556><.8880,.2400,1.5360>,<-9.511271,-.08852,-3.081901>}
 smooth_triangle {<.456,.528,1.968>,<.231344,-3.030293,-7.825187><.384,.48,1.968>,<1.055092,-3.431636,-8.349508><.432,.552,1.92>,<1.046902,-5.753647,-6.189135>}
 smooth_triangle {<.432,.6,1.896>,<-2.98808,-5.328369,-7.121217><.432,.552,1.92>,<1.046902,-5.753647,-6.189135><.504,.72,1.776>,<-.222194,-7.233128,-4.599452>}
 smooth_triangle {<.504,.72,1.776>,<-.222194,-7.233128,-4.599452><.432,.552,1.92>,<1.046902,-5.753647,-6.189135><.456,.528,1.968>,<.231344,-3.030293,-7.825187>}
 smooth_triangle {<.408,.648,1.848>,<-1.02368,-6.465769,-7.50346><.432,.6,1.896>,<-2.98808,-5.328369,-7.121217><.504,.72,1.776>,<-.222194,-7.233128,-4.599452>}
 smooth_triangle {<-.408,.648,1.848>,<1.02368,-6.465769,-7.50346><-.504,.72,1.776>,<.222194,-7.233128,-4.599452><-.432,.6,1.896>,<2.98808,-5.328369,-7.121217>}
 smooth_triangle {<-.504,.72,1.776>,<.222194,-7.233128,-4.599452><-.456,.528,1.968>,<-.231344,-3.030293,-7.825187><-.432,.552,1.92>,<-1.046902,-5.753647,-6.189135>}
 smooth_triangle {<-.432,.6,1.896>,<2.98808,-5.328369,-7.121217><-.504,.72,1.776>,<.222194,-7.233128,-4.599452><-.432,.552,1.92>,<-1.046902,-5.753647,-6.189135>}
 smooth_triangle {<-.456,.528,1.968>,<-.231344,-3.030293,-7.825187><-.432,.552,1.92>,<-1.046902,-5.753647,-6.189135><-.384,.48,1.968>,<-1.055092,-3.431636,-8.349508>}
 }
 object {AUDISpec}
 object {AUDISpec scale <-1,1,1>}
}

#declare AUDIVetri = mesh {
 smooth_triangle {<.0000,1.1760,-.5280>,<0,-9.417419,3.363364><.0000,1.0560,-.8640>,<0,-9.233868,3.781379><-.3120,1.1760,-.5280>,<1.169943,-9.196522,3.601388>}
 smooth_triangle {<-.312,1.176,-.528>,<1.169943,-9.196522,3.601388><-.504,1.128,-.504>,<2.672611,-9.086883,3.207135><-.48,1.008,-.864>,<1.862549,-8.995872,3.879855>}
 smooth_triangle {<-.312,1.032,-.864>,<.934855,-9.115482,3.992612><-.48,1.008,-.864>,<1.862549,-8.995872,3.879855><-.312,1.176,-.528>,<1.169943,-9.196522,3.601388>}
 smooth_triangle {<-.48,1.008,-.864>,<1.862549,-8.995872,3.879855><-.432,.864,-1.176>,<2.182179,-8.728716,4.364358><-.288,.864,-1.248>,<1.382697,-8.969574,4.146992>}
 smooth_triangle {<-.312,1.032,-.864>,<.934855,-9.115482,3.992612><-.48,1.008,-.864>,<1.862549,-8.995872,3.879855><-.288,.864,-1.248>,<1.382697,-8.969574,4.146992>}
 smooth_triangle {<-.3120,1.0320,-.8640>,<.934855,-9.115482,3.992612><-.2880,.8640,-1.2480>,<1.382697,-8.969574,4.146992><.0000,.8640,-1.2960>,<0,-9.120481,4.042873>}
 smooth_triangle {<.0000,1.0560,-.8640>,<0,-9.233868,3.781379><-.3120,1.0320,-.8640>,<.934855,-9.115482,3.992612><.0000,.8640,-1.2960>,<0,-9.120481,4.042873>}
 smooth_triangle {<.0000,1.0560,-.8640>,<0,-9.233868,3.781379><-.3120,1.0320,-.8640>,<.934855,-9.115482,3.992612><-.3120,1.1760,-.5280>,<1.169943,-9.196522,3.601388>}
 smooth_triangle {<-.624,1.104,.312>,<-9.306602,3.576233,-.366023><-.72,.864,.408>,<-9.238956,3.763499,-.244015><-.6,1.128,.168>,<-8.769011,4.427749,-1.080687>}
 smooth_triangle {<-.72,.864,.408>,<-9.238956,3.763499,-.244015><-.72,.84,.744>,<-9.243362,3.806092,.271864><-.624,1.104,.312>,<-9.306602,3.576233,-.366023>}
 smooth_triangle {<-.5520,1.1280,0>,<-8.239084,5.48145,-1.097121><-.7200,.8640,-.0960>,<-8.407833,5.161303,-.997151><-.6000,1.1280,.1680>,<-8.769011,4.427749,-1.080687>}
 smooth_triangle {<-.6,1.128,.168>,<-8.769011,4.427749,-1.080687><-.72,.864,-.096>,<-8.407833,5.161303,-.997151><-.72,.864,.408>,<-9.238956,3.763499,-.244015>}
 smooth_triangle {<-.5520,1.1280,0>,<-8.239084,5.48145,-1.097121><-.6960,.8640,-.3600>,<-8.48622,5.263488,-.351071><-.5520,1.1040,-.4080>,<-8.15913,5.505412,-.999866>}
 smooth_triangle {<-.5520,1.1280,0>,<-8.239084,5.48145,-1.097121><-.7200,.8640,-.0960>,<-8.407833,5.161303,-.997151><-.6960,.8640,-.3600>,<-8.48622,5.263488,-.351071>}
 smooth_triangle {<-.552,1.104,-.408>,<-8.15913,5.505412,-.999866><-.696,.864,-.576>,<-7.692536,6.0052,-1.619659><-.696,.864,-.36>,<-8.48622,5.263488,-.351071>}
 smooth_triangle {<-.552,1.104,-.408>,<-8.15913,5.505412,-.999866><-.696,.864,-.576>,<-7.692536,6.0052,-1.619659><-.528,1.008,-.696>,<-6.960686,6.715212,-2.31277>}
 smooth_triangle {<-.528,1.008,-.696>,<-6.960686,6.715212,-2.31277><-.696,.864,-.576>,<-7.692536,6.0052,-1.619659><-.624,.864,-.816>,<-7.395376,6.462715,-1.838956>}
 smooth_triangle {<-.528,1.008,-.696>,<-6.960686,6.715212,-2.31277><-.6,.864,-.936>,<-6.451505,7.202838,-2.265961><-.528,.936,-.888>,<-5.880702,7.64046,-2.639631>}
 smooth_triangle {<-.528,1.008,-.696>,<-6.960686,6.715212,-2.31277><-.624,.864,-.816>,<-7.395376,6.462715,-1.838956><-.6,.864,-.936>,<-6.451505,7.202838,-2.265961>}
 smooth_triangle {<-.528,.936,-.888>,<-5.880702,7.64046,-2.639631><-.6,.864,-.936>,<-6.451505,7.202838,-2.265961><-.552,.864,-1.056>,<-6.014449,7.618308,-2.405781>}
 smooth_triangle {<-.264,1.2,.408>,<.497083,-8.702448,-4.891405><-.528,.864,.96>,<1.610324,-8.454824,-4.911539><-.192,.864,1.008>,<.661036,-8.671863,-4.935567>}
 smooth_triangle {<-.2640,1.2000,.4080>,<.497083,-8.702448,-4.891405><-.1920,.8640,1.0080>,<.661036,-8.671863,-4.935567><.0000,.8640,1.0320>,<0,-8.71939,-4.868975>}
 smooth_triangle {<-.264,1.2,.408>,<.497083,-8.702448,-4.891405><-.576,1.176,.408>,<2.062759,-8.34874,-4.898223><-.528,.864,.96>,<1.610324,-8.454824,-4.911539>}
 smooth_triangle {<-.576,1.176,.408>,<2.062759,-8.34874,-4.898223><-.696,.864,.84>,<3.459258,-8.036122,-4.842961><-.528,.864,.96>,<1.610324,-8.454824,-4.911539>}
 smooth_triangle {<.576,1.176,.408>,<-2.062759,-8.34874,-4.898223><.528,.864,.96>,<-1.610324,-8.454824,-4.911539><.696,.864,.84>,<-3.459258,-8.036122,-4.842961>}
 smooth_triangle {<.264,1.2,.408>,<-.497083,-8.702448,-4.891405><.528,.864,.96>,<-1.610324,-8.454824,-4.911539><.576,1.176,.408>,<-2.062759,-8.34874,-4.898223>}
 smooth_triangle {<.2640,1.2000,.4080>,<-.497083,-8.702448,-4.891405><.0000,.8640,1.0320>,<0,-8.71939,-4.868975><.1920,.8640,1.0080>,<-.661036,-8.671863,-4.935567>}
 smooth_triangle {<.264,1.2,.408>,<-.497083,-8.702448,-4.891405><.192,.864,1.008>,<-.661036,-8.671863,-4.935567><.528,.864,.96>,<-1.610324,-8.454824,-4.911539>}
 smooth_triangle {<.528,.936,-.888>,<5.880702,7.64046,-2.639631><.552,.864,-1.056>,<6.014449,7.618308,-2.405781><.6,.864,-.936>,<6.451505,7.202838,-2.265961>}
 smooth_triangle {<.528,1.008,-.696>,<6.960686,6.715212,-2.31277><.6,.864,-.936>,<6.451505,7.202838,-2.265961><.624,.864,-.816>,<7.395376,6.462715,-1.838956>}
 smooth_triangle {<.528,1.008,-.696>,<6.960686,6.715212,-2.31277><.528,.936,-.888>,<5.880702,7.64046,-2.639631><.6,.864,-.936>,<6.451505,7.202838,-2.265961>}
 smooth_triangle {<.528,1.008,-.696>,<6.960686,6.715212,-2.31277><.624,.864,-.816>,<7.395376,6.462715,-1.838956><.696,.864,-.576>,<7.692536,6.0052,-1.619659>}
 smooth_triangle {<.552,1.104,-.408>,<8.15913,5.505412,-.999866><.528,1.008,-.696>,<6.960686,6.715212,-2.31277><.696,.864,-.576>,<7.692536,6.0052,-1.619659>}
 smooth_triangle {<.552,1.104,-.408>,<8.15913,5.505412,-.999866><.696,.864,-.576>,<7.692536,6.0052,-1.619659><.696,.864,-.36>,<8.48622,5.263488,-.351071>}
 smooth_triangle {<.5520,1.1280,0>,<8.239084,5.48145,-1.097121><.6960,.8640,-.3600>,<8.48622,5.263488,-.351071><.7200,.8640,-.0960>,<8.407833,5.161303,-.997151>}
 smooth_triangle {<.5520,1.1280,0>,<8.239084,5.48145,-1.097121><.5520,1.1040,-.4080>,<8.15913,5.505412,-.999866><.6960,.8640,-.3600>,<8.48622,5.263488,-.351071>}
 smooth_triangle {<.6,1.128,.168>,<8.769011,4.427749,-1.080687><.72,.864,-.096>,<8.407833,5.161303,-.997151><.72,.864,.408>,<9.238956,3.763499,-.244015>}
 smooth_triangle {<.5520,1.1280,0>,<8.239084,5.48145,-1.097121><.7200,.8640,-.0960>,<8.407833,5.161303,-.997151><.6000,1.1280,.1680>,<8.769011,4.427749,-1.080687>}
 smooth_triangle {<.72,.864,.408>,<9.238956,3.763499,-.244015><.624,1.104,.312>,<9.306602,3.576233,-.366023><.72,.84,.744>,<9.243362,3.806092,.271864>}
 smooth_triangle {<.624,1.104,.312>,<9.306602,3.576233,-.366023><.6,1.128,.168>,<8.769011,4.427749,-1.080687><.72,.864,.408>,<9.238956,3.763499,-.244015>}
 smooth_triangle {<.0000,1.0560,-.8640>,<0,-9.233868,3.781379><.3120,1.0320,-.8640>,<-.934855,-9.115482,3.992612><.3120,1.1760,-.5280>,<-1.169943,-9.196522,3.601388>}
 smooth_triangle {<.0000,1.0560,-.8640>,<0,-9.233868,3.781379><.0000,.8640,-1.2960>,<0,-9.120481,4.042873><.3120,1.0320,-.8640>,<-.934855,-9.115482,3.992612>}
 smooth_triangle {<.3120,1.0320,-.8640>,<-.934855,-9.115482,3.992612><.0000,.8640,-1.2960>,<0,-9.120481,4.042873><.2880,.8640,-1.2480>,<-1.382697,-8.969574,4.146992>}
 smooth_triangle {<.312,1.032,-.864>,<-.934855,-9.115482,3.992612><.288,.864,-1.248>,<-1.382697,-8.969574,4.146992><.48,1.008,-.864>,<-1.862549,-8.995872,3.879855>}
 smooth_triangle {<.48,1.008,-.864>,<-1.862549,-8.995872,3.879855><.288,.864,-1.248>,<-1.382697,-8.969574,4.146992><.432,.864,-1.176>,<-2.182179,-8.728716,4.364358>}
 smooth_triangle {<.312,1.032,-.864>,<-.934855,-9.115482,3.992612><.312,1.176,-.528>,<-1.169943,-9.196522,3.601388><.48,1.008,-.864>,<-1.862549,-8.995872,3.879855>}
 smooth_triangle {<.312,1.176,-.528>,<-1.169943,-9.196522,3.601388><.48,1.008,-.864>,<-1.862549,-8.995872,3.879855><.504,1.128,-.504>,<-2.672611,-9.086883,3.207135>}
 smooth_triangle {<.0000,1.1760,-.5280>,<0,-9.417419,3.363364><.0000,1.0560,-.8640>,<0,-9.233868,3.781379><.3120,1.1760,-.5280>,<-1.169943,-9.196522,3.601388>}
 smooth_triangle {<-.2640,1.2000,.4080>,<.497083,-8.702448,-4.891405><.0000,.8640,1.0320>,<0,-8.71939,-4.868975><.2640,1.2000,.4080>,<-.497083,-8.702448,-4.891405>}
 texture {DEMIBLUE}
}

#declare FARIBACK = mesh {
 smooth_triangle {<-.672,.744,-1.416>,<-2.212012,-7.714123,-5.914888><-.744,.72,-1.344>,<-2.192302,-7.185939,-6.444199><-.48,.6,-1.3>,<-2.199075,1.827975,-3.087315>}
 smooth_triangle {<-.504,.768,-1.488>,<-5.798377,-4.434629,-3.22264><-.672,.744,-1.416>,<-2.212012,-7.714123,-5.914888><-.48,.6,-1.3>,<-2.199075,1.827975,-3.087315>}
 smooth_triangle {<-.792,.648,-1.272>,<-.471969,.832882,-6.686876><-.744,.72,-1.344>,<-2.192302,-7.185939,-6.444199><-.48,.6,-1.3>,<-2.199075,1.827975,-3.087315>}
 smooth_triangle {<-.5040,.7680,-1.4880>,<-5.798377,-4.434629,-3.22264><-.4800,.6000,-1.6080>,<-4.949748,4.292892,0><-.4800,.6000,-1.3000>,<-2.199075,1.827975,-3.087315>}
 smooth_triangle {<-.792,.648,-1.272>,<-.471969,.832882,-6.686876><-.768,.576,-1.368>,<-.014434,9.01495,-3.120618><-.48,.6,-1.3>,<-2.199075,1.827975,-3.087315>}
 smooth_triangle {<-.48,.6,-1.3>,<-2.199075,1.827975,-3.087315><-.768,.576,-1.368>,<-.014434,9.01495,-3.120618><-.72,.576,-1.464>,<-1.162571,9.900249,.252504>}
 smooth_triangle {<-.48,.6,-1.3>,<-2.199075,1.827975,-3.087315><-.72,.576,-1.464>,<-1.162571,9.900249,.252504><-.624,.6,-1.56>,<-.791187,9.917521,.438196>}
 smooth_triangle {<-.4800,.6000,-1.3000>,<-2.199075,1.827975,-3.087315><-.6240,.6000,-1.5600>,<-.791187,9.917521,.438196><-.4800,.6000,-1.6080>,<-4.949748,4.292892,0>}
 pigment {colour ALUMINIUM}
 finish {ambient (0.4 * AmbientFact) diffuse.4 reflection .5 metallic .5 phong 50}
} 

#declare MIRR = mesh {
 triangle {<-.914,.895,.331><-.914,.842,.331><-.861,.816,.358>}
 triangle {<-.861,.816,.358><-.861,.922,.358><-.914,.895,.331>}
 triangle {<-.861,.922,.358><-.861,.816,.358><-.729,.816,.384>}
 triangle {<-.729,.816,.384><-.755,.922,.384><-.861,.922,.358>}
 triangle {<-.729,.922,.384><-.729,.816,.384><-.755,.922,.384>}
 texture {LITEMIRROR}
} 

#declare GLS_POS = mesh {
 smooth_triangle {<-.672,.744,-1.416>,<-6.016974,4.434603,-6.371154><-.744,.72,-1.344>,<-8.286777,2.683949,-4.707066><-.72,.576,-1.464>,<-7.630138,3.217385,-5.449193>}
 smooth_triangle {<-.744,.72,-1.344>,<-8.286777,2.683949,-4.707066><-.768,.576,-1.368>,<-8.853834,2.160012,-4.106238><-.72,.576,-1.464>,<-7.630138,3.217385,-5.449193>}
 smooth_triangle {<-.792,.648,-1.272>,<-8.978953,2.137845,-3.848119><-.768,.576,-1.368>,<-8.853834,2.160012,-4.106238><-.744,.72,-1.344>,<-8.286777,2.683949,-4.707066>}
 smooth_triangle {<-.624,.6,-1.56>,<-4.523626,4.972404,-7.074193><-.72,.576,-1.464>,<-7.630138,3.217385,-5.449193><-.672,.744,-1.416>,<-6.016974,4.434603,-6.371154>}
 smooth_triangle {<-.504,.768,-1.488>,<-3.28092,5.589528,-7.574039><-.672,.744,-1.416>,<-6.016974,4.434603,-6.371154><-.624,.6,-1.56>,<-4.523626,4.972404,-7.074193>}
 smooth_triangle {<-.504,.768,-1.488>,<-3.28092,5.589528,-7.574039><-.624,.6,-1.56>,<-4.523626,4.972404,-7.074193><-.48,.6,-1.608>,<-2.672617,5.345224,-8.017837>}
 texture {DEMIRED}
}

#declare TELAIO = union {
 mesh {
 smooth_triangle {<-.6260,.1680,1.6320>,<0,10,0><-.6260,.1680,-1.4400>,<0,10,0><.6260,.1680,-1.4400>,<0,10,0>}
 smooth_triangle {<.6260,.1680,-1.4400>,<0,10,0><.6260,.1680,1.6320>,<0,10,0><-.6260,.1680,1.6320>,<0,10,0>}
 smooth_triangle {<-.1920,.1680,2.0160>,<0,10,0><-.4080,.1680,1.9920>,<0,10,0><.4080,.1680,1.9920>,<0,10,0>}
 smooth_triangle {<.4080,.1680,1.9920>,<0,10,0><.1920,.1680,2.0160>,<0,10,0><-.1920,.1680,2.0160>,<0,10,0>}
 smooth_triangle {<-.4080,.1680,1.9920>,<0,10,0><-.5520,.1680,1.9200>,<0,10,0><.5520,.1680,1.9200>,<0,10,0>}
 smooth_triangle {<.5520,.1680,1.9200>,<0,10,0><.4080,.1680,1.9920>,<0,10,0><-.4080,.1680,1.9920>,<0,10,0>}
 smooth_triangle {<-.5520,.1680,1.9200>,<0,10,0><-.6720,.1680,1.8480>,<0,10,0><.6720,.1680,1.8480>,<0,10,0>}
 smooth_triangle {<.6720,.1680,1.8480>,<0,10,0><.5520,.1680,1.9200>,<0,10,0><-.5520,.1680,1.9200>,<0,10,0>}
 smooth_triangle {<-.6720,.1680,1.8480>,<0,10,0><-.7440,.1680,1.7760>,<0,10,0><.7440,.1680,1.7760>,<0,10,0>}
 smooth_triangle {<.7440,.1680,1.7760>,<0,10,0><.6720,.1680,1.8480>,<0,10,0><-.6720,.1680,1.8480>,<0,10,0>}
 smooth_triangle {<-.7440,.1680,1.7760>,<0,10,0><-.7920,.1680,1.6320>,<0,10,0><.7920,.1680,1.6320>,<0,10,0>}
 smooth_triangle {<.7920,.1680,1.6320>,<0,10,0><.7440,.1680,1.7760>,<0,10,0><-.7440,.1680,1.7760>,<0,10,0>}
 smooth_triangle {<-.2640,.2160,-1.6800>,<0,-7.071057,-7.071079><-.4800,.1920,-1.6560>,<0,-8.319866,-5.338452><.4800,.1920,-1.6560>,<0,-7.695462,-6.204765>}
 smooth_triangle {<.4800,.1920,-1.6560>,<0,-7.695462,-6.204765><.2640,.2160,-1.6800>,<0,-7.071057,-7.071079><-.2640,.2160,-1.6800>,<0,-7.071057,-7.071079>}
 smooth_triangle {<-.4800,.1920,-1.6560>,<0,-8.319866,-5.338452><-.6000,.1680,-1.6080>,<0,-9.472136,-2.236069><.6000,.1680,-1.6080>,<0,-9.472136,-2.236069>}
 smooth_triangle {<.6000,.1680,-1.6080>,<0,-9.472136,-2.236069><.4800,.1920,-1.6560>,<0,-7.695462,-6.204765><-.4800,.1920,-1.6560>,<0,-8.319866,-5.338452>}
 smooth_triangle {<-.6960,.1680,-1.5360>,<0,-10,0><-.6000,.1680,-1.6080>,<0,-9.472136,-2.236069><.6000,.1680,-1.6080>,<0,-9.472136,-2.236069>}
 smooth_triangle {<.6000,.1680,-1.6080>,<0,-9.472136,-2.236069><.6960,.1680,-1.5360>,<0,-10,0><-.6960,.1680,-1.5360>,<0,-10,0>}
 smooth_triangle {<-.7920,.1680,-1.4400>,<0,-10,0><-.6960,.1680,-1.5360>,<0,-10,0><.6960,.1680,-1.5360>,<0,-10,0>}
 smooth_triangle {<.6960,.1680,-1.5360>,<0,-10,0><.7920,.1680,-1.4400>,<0,-10,0><-.7920,.1680,-1.4400>,<0,-10,0>}
 smooth_triangle {<-.4800,.9600,-.7920>,<-3.333333,3.858482,1.725168><-.4800,.9120,-.8880>,<-5,4.472136,-2.236067><.4800,.9120,-.8880>,<3.333333,5.962849,-2.981422>}
 smooth_triangle {<.4800,.9120,-.8880>,<3.333333,5.962849,-2.981422><.4800,.9600,-.7920>,<5,2.893862,1.293876><-.4800,.9600,-.7920>,<-3.333333,3.858482,1.725168>}
 smooth_triangle {<-.4800,.9600,-.7920>,<-3.333333,3.858482,1.725168><-.4800,.4320,-.6480>,<-5,1.315587,4.823819><.4800,.4320,-.6480>,<3.333333,1.754116,6.431759>}
 smooth_triangle {<.4800,.4320,-.6480>,<3.333333,1.754116,6.431759><.4800,.9600,-.7920>,<5,2.893862,1.293876><-.4800,.9600,-.7920>,<-3.333333,3.858482,1.725168>}
 smooth_triangle {<-.4800,.9600,-.7920>,<-3.333333,3.858482,1.725168><-.4800,.9120,-.8880>,<-5,4.472136,-2.236067><-.4800,.3600,-.6720>,<-10,0,0>}
 smooth_triangle {<-.4800,.3600,-.6720>,<-10,0,0><-.4800,.4320,-.6480>,<-5,1.315587,4.823819><-.4800,.9600,-.7920>,<-3.333333,3.858482,1.725168>}
 smooth_triangle {<-.48,.888,-.384>,<-3.964435,1.451691,-4.629665><-.552,.288,-.24>,<-4.953822,-.687463,-5.341339><-.096,.288,-.24>,<4.954937,-.620919,-5.197049>}
 smooth_triangle {<-.096,.288,-.24>,<4.954937,-.620919,-5.197049><-.168,.888,-.384>,<2.483151,4.548392,-3.713923><-.48,.888,-.384>,<-3.964435,1.451691,-4.629665>}
 smooth_triangle {<-.48,.912,-.288>,<-1.982906,5.186177,2.825629><-.48,.888,-.384>,<-3.964435,1.451691,-4.629665><-.168,.888,-.384>,<2.483151,4.548392,-3.713923>}
 smooth_triangle {<-.168,.888,-.384>,<2.483151,4.548392,-3.713923><-.168,.912,-.288>,<4.954937,3.629096,1.470459><-.48,.912,-.288>,<-1.982906,5.186177,2.825629>}
 smooth_triangle {<-.48,.912,-.288>,<-1.982906,5.186177,2.825629><-.552,.384,-.144>,<-6.607391,1.618554,2.790804><-.096,.384,-.144>,<3.295715,2.107228,6.078647>}
 smooth_triangle {<-.096,.384,-.144>,<3.295715,2.107228,6.078647><-.168,.912,-.288>,<4.954937,3.629096,1.470459><-.48,.912,-.288>,<-1.982906,5.186177,2.825629>}
 smooth_triangle {<-.168,.912,-.288>,<4.954937,3.629096,1.470459><-.168,.888,-.384>,<2.483151,4.548392,-3.713923><-.096,.288,-.24>,<4.954937,-.620919,-5.197049>}
 smooth_triangle {<-.096,.288,-.24>,<4.954937,-.620919,-5.197049><-.096,.384,-.144>,<3.295715,2.107228,6.078647><-.168,.912,-.288>,<4.954937,3.629096,1.470459>}
 smooth_triangle {<-.552,.384,-.144>,<-6.607391,1.618554,2.790804><-.552,.288,-.24>,<-4.953822,-.687463,-5.341339><-.48,.888,-.384>,<-3.964435,1.451691,-4.629665>}
 smooth_triangle {<-.48,.888,-.384>,<-3.964435,1.451691,-4.629665><-.48,.912,-.288>,<-1.982906,5.186177,2.825629><-.552,.384,-.144>,<-6.607391,1.618554,2.790804>}
 smooth_triangle {<.4800,.9600,-.7920>,<5,2.893862,1.293876><.4800,.9120,-.8880>,<3.333333,5.962849,-2.981422><.4800,.3600,-.6720>,<10,0,0>}
 smooth_triangle {<.4800,.3600,-.6720>,<10,0,0><.4800,.4320,-.6480>,<3.333333,1.754116,6.431759><.4800,.9600,-.7920>,<5,2.893862,1.293876>}
 smooth_triangle {<.48,.912,-.288>,<4.954937,3.629096,1.470459><.48,.888,-.384>,<2.483151,4.548392,-3.713923><.552,.288,-.24>,<4.954937,-.620919,-5.197049>}
 smooth_triangle {<.552,.288,-.24>,<4.954937,-.620919,-5.197049><.552,.384,-.144>,<3.295715,2.107228,6.078647><.48,.912,-.288>,<4.954937,3.629096,1.470459>}
 smooth_triangle {<.096,.384,-.144>,<-6.607391,1.618554,2.790804><.096,.288,-.24>,<-4.953822,-.687463,-5.341339><.168,.888,-.384>,<-3.964435,1.451691,-4.629665>}
 smooth_triangle {<.168,.888,-.384>,<-3.964435,1.451691,-4.629665><.168,.912,-.288>,<-1.982906,5.186177,2.825629><.096,.384,-.144>,<-6.607391,1.618554,2.790804>}
 smooth_triangle {<-.8400,.1680,.7920>,<0,6.896007,-3.325434><-.8400,.1680,-.6000>,<0,10,0><.8400,.1680,-.6000>,<0,10,0>}
 smooth_triangle {<.8400,.1680,-.6000>,<0,10,0><.8400,.1680,.7920>,<0,5.34401,-4.988152><-.8400,.1680,.7920>,<0,6.896007,-3.325434>}
 smooth_triangle {<.168,.912,-.288>,<-1.982906,5.186177,2.825629><.096,.384,-.144>,<-6.607391,1.618554,2.790804><.552,.384,-.144>,<3.295715,2.107228,6.078647>}
 smooth_triangle {<.552,.384,-.144>,<3.295715,2.107228,6.078647><.48,.912,-.288>,<4.954937,3.629096,1.470459><.168,.912,-.288>,<-1.982906,5.186177,2.825629>}
 smooth_triangle {<.168,.912,-.288>,<-1.982906,5.186177,2.825629><.168,.888,-.384>,<-3.964435,1.451691,-4.629665><.48,.888,-.384>,<2.483151,4.548392,-3.713923>}
 smooth_triangle {<.48,.888,-.384>,<2.483151,4.548392,-3.713923><.48,.912,-.288>,<4.954937,3.629096,1.470459><.168,.912,-.288>,<-1.982906,5.186177,2.825629>}
 smooth_triangle {<.168,.888,-.384>,<-3.964435,1.451691,-4.629665><.096,.288,-.24>,<-4.953822,-.687463,-5.341339><.552,.288,-.24>,<4.954937,-.620919,-5.197049>}
 smooth_triangle {<.552,.288,-.24>,<4.954937,-.620919,-5.197049><.48,.888,-.384>,<2.483151,4.548392,-3.713923><.168,.888,-.384>,<-3.964435,1.451691,-4.629665>}
 smooth_triangle {<-.1100,1.1700,.3800>,<0,-1.414214,-9.899495><-.1200,1.1000,.3900>,<0,-1.414214,-9.899495><.1200,1.1000,.3900>,<0,-1.414214,-9.899495>}
 smooth_triangle {<.1200,1.1000,.3900>,<0,-1.414214,-9.899495><.1100,1.1700,.3800>,<0,-1.414214,-9.899495><-.1100,1.1700,.3800>,<0,-1.414214,-9.899495>}
 smooth_triangle {<.1878,.9118,.9883>,<1.768036,6.443751,7.4399><.5894,.8949,.9075>,<1.768035,6.44376,7.439893><.5913,.8796,.9203>,<1.768036,6.443751,7.4399>}
 smooth_triangle {<.5913,.8796,.9203>,<1.768036,6.443751,7.4399><.1897,.8965,1.0011>,<1.768036,6.443743,7.439908><.1878,.9118,.9883>,<1.768036,6.443751,7.4399>}
 smooth_triangle {<.3958,.9023,.9562>,<-1.767122,-6.438585,-7.444508><.1285,.882,1.0373>,<-1.777826,-6.412351,-7.464656><.1333,.8667,1.0493>,<-1.767122,-6.438585,-7.444508>}
 smooth_triangle {<.1333,.8667,1.0493>,<-1.767122,-6.438585,-7.444508><.4006,.8871,.9683>,<-1.756418,-6.46482,-7.424358><.3958,.9023,.9562>,<-1.767122,-6.438585,-7.444508>}
 smooth_triangle {<-.1205,.9023,.9989>,<.277791,-6.42625,-7.65677><-.3997,.882,1.0058>,<.278229,-6.428574,-7.654804><-.3983,.8667,1.0187>,<.277791,-6.42625,-7.65677>}
 smooth_triangle {<-.3983,.8667,1.0187>,<.277791,-6.42625,-7.65677><-.1191,.8871,1.0117>,<.277354,-6.423927,-7.658736><-.1205,.9023,.9989>,<.277791,-6.42625,-7.65677>}
 smooth_triangle {<-.3311,.8965,.9872>,<.279,-6.431268,-7.652513><.0775,.8796,1.0163>,<.279,-6.431259,-7.65252><.0791,.8949,1.0035>,<.279,-6.431268,-7.652513>}
 smooth_triangle {<.0791,.8949,1.0035>,<.279,-6.431268,-7.652513><-.3295,.9118,.9744>,<.279,-6.431276,-7.652505><-.3311,.8965,.9872>,<.279,-6.431268,-7.652513>}
 smooth_triangle {<.1920,.8640,1.0080>,<-1.254963,3.2546,-9.371523><.0000,.1680,.7920>,<0,3.142985,-8.895353><.5280,.8640,.9600>,<-3.118927,4.32327,-8.108352>}
 smooth_triangle {<.6960,.8640,.8400>,<-2.450737,3.03137,-8.419184><.0000,.1680,.7920>,<0,3.142985,-8.895353><.8400,.1680,.7920>,<0,5.34401,-4.988152>}
 smooth_triangle {<.5280,.8640,.9600>,<-3.118927,4.32327,-8.108352><.0000,.1680,.7920>,<0,3.142985,-8.895353><.6960,.8640,.8400>,<-2.450737,3.03137,-8.419184>}
 smooth_triangle {<.0000,.8640,1.0320>,<0,3.23738,-9.388406><.0000,.1680,.7920>,<0,3.142985,-8.895353><.1920,.8640,1.0080>,<-1.254963,3.2546,-9.371523>}
 smooth_triangle {<.0000,.8640,1.0320>,<0,3.23738,-9.388406><.0000,.1680,.7920>,<0,3.142985,-8.895353><-.1920,.8640,1.0080>,<1.254963,3.2546,-9.371523>}
 smooth_triangle {<-.5280,.8640,.9600>,<3.118927,4.32327,-8.108352><.0000,.1680,.7920>,<0,3.142985,-8.895353><-.6960,.8640,.8400>,<2.450737,3.03137,-8.419184>}
 smooth_triangle {<-.6960,.8640,.8400>,<2.450737,3.03137,-8.419184><.0000,.1680,.7920>,<0,3.142985,-8.895353><-.8400,.1680,.7920>,<0,6.896007,-3.325434>}
 smooth_triangle {<-.1920,.8640,1.0080>,<1.254963,3.2546,-9.371523><-.5280,.8640,.9600>,<3.118927,4.32327,-8.108352><.0000,.1680,.7920>,<0,3.142985,-8.895353>}
 }
 cylinder {<0,0,0>,<0,.24,0>,1 scale<.312,1,.312> rotate<0,90,0> translate<-1.224,.648,.288> rotate<270,0,0,> rotate<0,90,0>}
 cylinder {<0,0,0>,<0,.24,0>,1 scale<-.312,1,.312> rotate<0,270,0> translate<1.224,.648,.288> rotate<270,0,0,> rotate<0,270,0>}
 cylinder {<0,0,0>,<0,.24,0>,1 scale<-.312,1,.312> rotate<0,270,0> translate<-1.032,.648,.288> rotate<270,0,0,> rotate<0,270,0>}
 cylinder {<0,0,0>,<0,.24,0>,1 scale<.312,1,.312> rotate<0,90,0> translate<1.032,.648,.288> rotate<270,0,0,> rotate<0,90,0>}
 //cappelliera
 polygon {5, <-.594,.864,-.936><-.5465,.864,-1.0548><.5465,.864,-1.0548><.594,.864,-.936><-.594,.864,-.936>}
 polygon {5, <-.5465,.864,-1.0548><-.4277,.864,-1.1736><.4277,.864,-1.1736><.5465,.864,-1.0548><-.5465,.864,-1.0548>}
 polygon {5, <-.4277,.864,-1.1736><-.2851,.864,-1.2449><.2851,.864,-1.2449><.4277,.864,-1.1736><-.4277,.864,-1.1736>}
 polygon {5, <-.6178,.864,-.8172><-.594,.864,-.936><.594,.864,-.936><.6178,.864,-.8172><-.6178,.864,-.8172>}
 triangle {<.2851,.864,-1.2449><0,.864,-1.2924><-.2851,.864,-1.2449>}
 pigment {color BLACK} finish{ambient (0.6 * AmbientFact) diffuse 0.7}
}

#declare MOZZI = union {
 cylinder {<0,0,0>,<0,.01,0>,1 scale<.075,1,.075> rotate<0,90,0> translate<1.224,.907,.288> rotate<270,0,0,> rotate<0,270,0>}
 cylinder {<0,0,0>,<0,.01,0>,1 scale<-.075,1,.075> rotate<0,270,0> translate<-1.224,.907,.288> rotate<270,0,0,> rotate<0,90,0>}
 cylinder {<0,0,0>,<0,.01,0>,1 scale<-.075,1,.075> rotate<0,270,0> translate<1.032,.907,.288> rotate<270,0,0,> rotate<0,90,0>}
 cylinder {<0,0,0>,<0,.01,0>,1 scale<.075,1,.075> rotate<0,90,0> translate<-1.032,.907,.288> rotate<270,0,0,> rotate<0,270,0>}
 pigment {colour ALUMINIUM} finish {ambient (0.4 * AmbientFact) diffuse 0.4 reflection 0.4 metallic 0.5 phong 50}
}

#declare FAROANT = mesh {
 smooth_triangle {<-.5520,.5280,1.9200>,<0,10,0><-.6720,.5280,1.8480>,<0,10,0><-.5600,.5280,1.5600>,<-1.921086,1.022614,3.607864>}
 smooth_triangle {<-.5600,.5280,1.5600>,<-1.921086,1.022614,3.607864><-.4560,.5280,1.9680>,<-4.845018,5.02375,1.235004><-.5520,.5280,1.9200>,<0,10,0>}
 smooth_triangle {<-.7440,.5280,1.7760>,<0,10,0><-.6720,.5280,1.8480>,<0,10,0><-.5600,.5280,1.5600>,<-1.921086,1.022614,3.607864>}
 smooth_triangle {<-.5600,.5280,1.5600>,<-1.921086,1.022614,3.607864><-.7920,.5280,1.5600>,<0,5,5><-.7440,.5280,1.7760>,<0,10,0>}
 smooth_triangle {<-.7920,.6480,1.5600>,<-2.093403,-4.047246,7.058511><-.7920,.5280,1.5600>,<0,5,5><-.5600,.5280,1.5600>,<-1.921086,1.022614,3.607864>}
 smooth_triangle {<-.504,.72,1.776>,<-5.977096,-3.466816,4.63123><-.56,.528,1.56>,<-1.921086,1.022614,3.607864><-.456,.528,1.968>,<-4.845018,5.02375,1.235004>}
 smooth_triangle {<-.576,.72,1.752>,<-1.132074,-7.026099,6.93176><-.56,.528,1.56>,<-1.921086,1.022614,3.607864><-.504,.72,1.776>,<-5.977096,-3.466816,4.63123>}
 smooth_triangle {<-.792,.648,1.56>,<-2.093403,-4.047246,7.058511><-.744,.672,1.656>,<-3.628336,-7.884581,4.872554><-.56,.528,1.56>,<-1.921086,1.022614,3.607864>}
 smooth_triangle {<-.744,.672,1.656>,<-3.628336,-7.884581,4.872554><-.56,.528,1.56>,<-1.921086,1.022614,3.607864><-.672,.696,1.728>,<-1.534929,-7.372869,6.349578>}
 smooth_triangle {<-.672,.696,1.728>,<-1.534929,-7.372869,6.349578><-.56,.528,1.56>,<-1.921086,1.022614,3.607864><-.576,.72,1.752>,<-1.132074,-7.026099,6.93176>}
 pigment {colour WHITE}   
 finish {ambient ((0.1 * AmbientFact) + ByNight) diffuse 0.1 reflection .1}
}

#declare GLS_ANT = mesh {
 smooth_triangle {<-.576,.72,1.752>,<3.338754,-5.782268,-7.398884><-.552,.528,1.92>,<3.415049,-6.007248,-7.185586><-.504,.72,1.776>,<3.001256,-6.182444,-7.242845>}
 smooth_triangle {<-.504,.72,1.776>,<3.001256,-6.182444,-7.242845><-.552,.528,1.92>,<3.415049,-6.007248,-7.185586><-.456,.528,1.968>,<3.521811,-6.163154,-7.043606>}
 smooth_triangle {<-.576,.72,1.752>,<3.338754,-5.782268,-7.398884><-.672,.696,1.728>,<5.195144,-4.791424,-6.707993><-.672,.528,1.848>,<5.181251,-5.079109,-6.644783>}
 smooth_triangle {<-.576,.72,1.752>,<3.338754,-5.782268,-7.398884><-.672,.528,1.848>,<5.181251,-5.079109,-6.644783><-.552,.528,1.92>,<3.415049,-6.007248,-7.185586>}
 smooth_triangle {<-.672,.696,1.728>,<5.195144,-4.791424,-6.707993><-.744,.672,1.656>,<7.331168,-4.069082,-5.155874><-.672,.528,1.848>,<5.181251,-5.079109,-6.644783>}
 smooth_triangle {<-.744,.672,1.656>,<7.331168,-4.069082,-5.155874><-.744,.528,1.776>,<8.219337,-2.704204,-3.968146><-.672,.528,1.848>,<5.181251,-5.079109,-6.644783>}
 smooth_triangle {<-.744,.672,1.656>,<7.331168,-4.069082,-5.155874><-.792,.648,1.56>,<9.282969,-1.517941,-2.90618><-.744,.528,1.776>,<8.219337,-2.704204,-3.968146>}
 smooth_triangle {<-.7920,.6480,1.5600>,<9.282969,-1.517941,-2.90618><-.7920,.5280,1.5600>,<9.761871,0,-2.169303><-.7440,.5280,1.7760>,<8.219337,-2.704204,-3.968146>}
 texture {pigment{rgbft<.58,.58,.62,.99,.99>} finish {reflection .4}}
}

#declare SILV_SX = mesh {
 smooth_triangle {<-.9120,.2170,1.2470>,<-3.333333,-2.992244,.975782><-.9120,.1260,1.3420>,<-4,2.133415,-3.172335><-.8620,.1260,1.3420>,<0,-1.832887,-6.102313>}
 smooth_triangle {<-.8620,.1260,1.3420>,<0,-1.832887,-6.102313><-.8620,.2170,1.2470>,<0,-4.488365,1.463673><-.9120,.2170,1.2470>,<-3.333333,-2.992244,.975782>}
 smooth_triangle {<-.9120,.2880,1.2990>,<-1.428571,0,2.71175><-.9120,.2260,1.4140>,<-6,2.078915,-1.02537><-.8620,.2260,1.4140>,<0,5.197288,-2.563425>}
 smooth_triangle {<-.8620,.2260,1.4140>,<0,5.197288,-2.563425><-.8620,.2880,1.2990>,<0,-5.281351,4.745562><-.9120,.2880,1.2990>,<-1.428571,0,2.71175>}
 smooth_triangle {<-.9120,.2880,1.2990>,<-1.428571,0,2.71175><-.9120,.2650,1.2950>,<-10,0,0><-.9120,.2260,1.4140>,<-6,2.078915,-1.02537>}
 smooth_triangle {<-.9120,.2170,1.2470>,<-3.333333,-2.992244,.975782><-.9120,.2270,1.2680>,<-10,0,0><-.9120,.1260,1.3420>,<-4,2.133415,-3.172335>}
 smooth_triangle {<-.9120,.4500,1.3420>,<-2.222222,2.215732,-3.571304><-.9120,.3590,1.2470>,<-1.666667,2.699699,-.665009><-.8620,.3590,1.2470>,<0,5.399399,-1.330018>}
 smooth_triangle {<-.8620,.3590,1.2470>,<0,5.399399,-1.330018><-.8620,.4500,1.3420>,<0,-.861403,-5.694768><-.9120,.4500,1.3420>,<-2.222222,2.215732,-3.571304>}
 smooth_triangle {<-.9120,.3500,1.4140>,<-2,-3.839365,-.076258><-.9120,.2880,1.2990>,<-1.428571,0,2.71175><-.8620,.2880,1.2990>,<0,-5.281351,4.745562>}
 smooth_triangle {<-.8620,.2880,1.2990>,<0,-5.281351,4.745562><-.8620,.3500,1.4140>,<0,-6.398942,-.127096><-.9120,.3500,1.4140>,<-2,-3.839365,-.076258>}
 smooth_triangle {<-.9120,.3500,1.4140>,<-2,-3.839365,-.076258><-.9120,.3110,1.2950>,<-3.333333,0,0><-.9120,.2880,1.2990>,<-1.428571,0,2.71175>}
 smooth_triangle {<-.9120,.4500,1.3420>,<-2.222222,2.215732,-3.571304><-.9120,.3590,1.2470>,<-1.666667,2.699699,-.665009><-.9120,.3490,1.2680>,<-5,0,0>}
 smooth_triangle {<-.9120,.4500,1.1060>,<-4.285714,-3.263054,-.552403><-.9120,.3320,1.1630>,<-5,1.388605,-1.905631><-.8620,.3320,1.1630>,<0,2.777211,-3.811262>}
 smooth_triangle {<-.8620,.3320,1.1630>,<0,2.777211,-3.811262><-.8620,.4500,1.1060>,<0,-5.710344,-.966705><-.9120,.4500,1.1060>,<-4.285714,-3.263054,-.552403>}
 smooth_triangle {<-.9120,.4880,1.2240>,<-3.333333,-2.705715,2.750807><-.9120,.3590,1.2470>,<-1.666667,2.699699,-.665009><-.8620,.3590,1.2470>,<0,5.399399,-1.330018>}
 smooth_triangle {<-.8620,.3590,1.2470>,<0,5.399399,-1.330018><-.8620,.4880,1.2240>,<0,-4.058573,4.12621><-.9120,.4880,1.2240>,<-3.333333,-2.705715,2.750807>}
 smooth_triangle {<-.9120,.4880,1.2240>,<-3.333333,-2.705715,2.750807><-.9120,.3630,1.2240>,<-10,0,0><-.9120,.3590,1.2470>,<-1.666667,2.699699,-.665009>}
 smooth_triangle {<-.9120,.4500,1.1060>,<-4.285714,-3.263054,-.552403><-.9120,.3320,1.1630>,<-5,1.388605,-1.905631><-.9120,.3490,1.1800>,<-10,0,0>}
 smooth_triangle {<-.9120,.4500,1.3420>,<-2.222222,2.215732,-3.571304><-.9120,.3590,1.2470>,<-1.666667,2.699699,-.665009><-.9120,.3490,1.2680>,<-5,0,0>}
 smooth_triangle {<-.9120,.3500,1.4140>,<-2,-3.839365,-.076258><-.9120,.3110,1.2950>,<-3.333333,0,0><-.9120,.2880,1.2990>,<-1.428571,0,2.71175>}
 smooth_triangle {<-.9120,.3500,1.4140>,<-2,-3.839365,-.076258><-.9120,.2880,1.2990>,<-1.428571,0,2.71175><-.8620,.2880,1.2990>,<0,-5.281351,4.745562>}
 smooth_triangle {<-.8620,.2880,1.2990>,<0,-5.281351,4.745562><-.8620,.3500,1.4140>,<0,-6.398942,-.127096><-.9120,.3500,1.4140>,<-2,-3.839365,-.076258>}
 smooth_triangle {<-.9120,.4500,1.3420>,<-2.222222,2.215732,-3.571304><-.9120,.3590,1.2470>,<-1.666667,2.699699,-.665009><-.8620,.3590,1.2470>,<0,5.399399,-1.330018>}
 smooth_triangle {<-.8620,.3590,1.2470>,<0,5.399399,-1.330018><-.8620,.4500,1.3420>,<0,-.861403,-5.694768><-.9120,.4500,1.3420>,<-2.222222,2.215732,-3.571304>}
 smooth_triangle {<-.9120,.2440,1.1630>,<-3.333333,-1.851474,-2.540841><-.9120,.1260,1.1060>,<-5,2.855172,-.483353><-.9120,.2270,1.1800>,<-10,0,0>}
 smooth_triangle {<-.9120,.2170,1.2470>,<-3.333333,-2.992244,.975782><-.9120,.0880,1.2240>,<-6,1.623429,1.650485><-.9120,.2130,1.2240>,<-10,0,0>}
 smooth_triangle {<-.9120,.2170,1.2470>,<-3.333333,-2.992244,.975782><-.9120,.0880,1.2240>,<-6,1.623429,1.650485><-.8620,.0880,1.2240>,<0,4.058573,4.126212>}
 smooth_triangle {<-.8620,.0880,1.2240>,<0,4.058573,4.126212><-.8620,.2170,1.2470>,<0,-4.488365,1.463673><-.9120,.2170,1.2470>,<-3.333333,-2.992244,.975782>}
 smooth_triangle {<-.9120,.2440,1.1630>,<-3.333333,-1.851474,-2.540841><-.9120,.1260,1.1060>,<-5,2.855172,-.483353><-.8620,.1260,1.1060>,<0,5.710344,-.966705>}
 smooth_triangle {<-.8620,.1260,1.1060>,<0,5.710344,-.966705><-.8620,.2440,1.1630>,<0,-2.777211,-3.811262><-.9120,.2440,1.1630>,<-3.333333,-1.851474,-2.540841>}
 smooth_triangle {<-.9120,.2440,1.1630>,<-3.333333,-1.851474,-2.540841><-.9120,.2260,1.0340>,<-5,-.159963,3.211751><-.8620,.2260,1.0340>,<0,-5.111987,3.902732>}
 smooth_triangle {<-.8620,.2260,1.0340>,<0,-5.111987,3.902732><-.8620,.2440,1.1630>,<0,-2.777211,-3.811262><-.9120,.2440,1.1630>,<-3.333333,-1.851474,-2.540841>}
 smooth_triangle {<-.9120,.3500,1.0340>,<-4,3.067192,2.341639><-.9120,.3320,1.1630>,<-5,1.388605,-1.905631><-.8620,.3320,1.1630>,<0,2.777211,-3.811262>}
 smooth_triangle {<-.8620,.3320,1.1630>,<0,2.777211,-3.811262><-.8620,.3500,1.0340>,<0,.319926,6.423502><-.9120,.3500,1.0340>,<-4,3.067192,2.341639>}
 smooth_triangle {<-.9120,.3500,1.0340>,<-4,3.067192,2.341639><-.9120,.3110,1.1530>,<-10,0,0><-.9120,.3320,1.1630>,<-5,1.388605,-1.905631>}
 smooth_triangle {<-.9120,.2440,1.1630>,<-3.333333,-1.851474,-2.540841><-.9120,.2260,1.0340>,<-5,-.159963,3.211751><-.9120,.2650,1.1530>,<-10,0,0>}
 smooth_triangle {<-.9120,.5280,1.2240>,<-4.285714,5.640603,0><-.9120,.5160,1.2980>,<-5,4.617674,1.775216><-.8620,.5160,1.2980>,<0,9.553202,2.575574>}
 smooth_triangle {<-.8620,.5160,1.2980>,<0,9.553202,2.575574><-.8620,.5280,1.2240>,<0,9.871055,0><-.9120,.5280,1.2240>,<-4.285714,5.640603,0>}
 smooth_triangle {<-.9120,.5160,1.2980>,<-5,4.617674,1.775216><-.9120,.4820,1.3650>,<-4,4.611926,3.733486><-.8620,.4820,1.3650>,<0,8.302019,5.373884>}
 smooth_triangle {<-.8620,.4820,1.3650>,<0,8.302019,5.373884><-.8620,.5160,1.2980>,<0,9.553202,2.575574><-.9120,.5160,1.2980>,<-5,4.617674,1.775216>}
 smooth_triangle {<-.9120,.4820,1.3650>,<-4,4.611926,3.733486><-.9120,.4290,1.4180>,<-5,2.686944,4.151009><-.8620,.4290,1.4180>,<0,6.222477,7.686544>}
 smooth_triangle {<-.8620,.4290,1.4180>,<0,6.222477,7.686544><-.8620,.4820,1.3650>,<0,8.302019,5.373884><-.9120,.4820,1.3650>,<-4,4.611926,3.733486>}
 smooth_triangle {<-.9120,.4290,1.4180>,<-5,2.686944,4.151009><-.9120,.3620,1.4520>,<-5,1.287786,4.7766><-.8620,.3620,1.4520>,<0,3.550435,9.235347>}
 smooth_triangle {<-.8620,.3620,1.4520>,<0,3.550435,9.235347><-.8620,.4290,1.4180>,<0,6.222477,7.686544><-.9120,.4290,1.4180>,<-5,2.686944,4.151009>}
 smooth_triangle {<-.9120,.3620,1.4520>,<-5,1.287786,4.7766><-.9120,.2880,1.4640>,<-5.714286,-.228673,4.230453><-.8620,.2880,1.4640>,<0,.533569,9.871056>}
 smooth_triangle {<-.8620,.2880,1.4640>,<0,.533569,9.871056><-.8620,.3620,1.4520>,<0,3.550435,9.235347><-.9120,.3620,1.4520>,<-5,1.287786,4.7766>}
 smooth_triangle {<-.9120,.4880,1.2240>,<-3.333333,-2.705715,2.750807><-.9120,.4780,1.2860>,<-5,-4.626826,-1.7561><-.8620,.4780,1.2860>,<0,-9.563031,-2.552263>}
 smooth_triangle {<-.8620,.4780,1.2860>,<0,-9.563031,-2.552263><-.8620,.4880,1.2240>,<0,-4.058573,4.12621><-.9120,.4880,1.2240>,<-3.333333,-2.705715,2.750807>}
 smooth_triangle {<-.9120,.4780,1.2860>,<-5,-4.626826,-1.7561><-.9120,.4500,1.3420>,<-2.222222,2.215732,-3.571304><-.8620,.4500,1.3420>,<0,-.861403,-5.694768>}
 smooth_triangle {<-.8620,.4500,1.3420>,<0,-.861403,-5.694768><-.8620,.4780,1.2860>,<0,-9.563031,-2.552263><-.9120,.4780,1.2860>,<-5,-4.626826,-1.7561>}
 smooth_triangle {<-.9120,.3500,1.4140>,<-2,-3.839365,-.076258><-.9120,.2880,1.4240>,<-4,.318465,-5.923447><-.8620,.2880,1.4240>,<0,-.530774,-9.872412>}
 smooth_triangle {<-.8620,.2880,1.4240>,<0,-.530774,-9.872412><-.8620,.3500,1.4140>,<0,-6.398942,-.127096><-.9120,.3500,1.4140>,<-2,-3.839365,-.076258>}
 smooth_triangle {<-.9120,.3500,1.4140>,<-2,-3.839365,-.076258><-.9120,.3620,1.4520>,<-5,1.287786,4.7766><-.9120,.2880,1.4640>,<-5.714286,-.228673,4.230453>}
 smooth_triangle {<-.9120,.2880,1.4640>,<-5.714286,-.228673,4.230453><-.9120,.2880,1.4240>,<-4,.318465,-5.923447><-.9120,.3500,1.4140>,<-2,-3.839365,-.076258>}
 smooth_triangle {<-.9120,.5280,1.2240>,<-4.285714,5.640603,0><-.9120,.4880,1.2240>,<-3.333333,-2.705715,2.750807><-.9120,.4780,1.2860>,<-5,-4.626826,-1.7561>}
 smooth_triangle {<-.9120,.4780,1.2860>,<-5,-4.626826,-1.7561><-.9120,.5160,1.2980>,<-5,4.617674,1.775216><-.9120,.5280,1.2240>,<-4.285714,5.640603,0>}
 smooth_triangle {<-.9120,.5160,1.2980>,<-5,4.617674,1.775216><-.9120,.4780,1.2860>,<-5,-4.626826,-1.7561><-.9120,.4500,1.3420>,<-2.222222,2.215732,-3.571304>}
 smooth_triangle {<-.9120,.4500,1.3420>,<-2.222222,2.215732,-3.571304><-.9120,.4820,1.3650>,<-4,4.611926,3.733486><-.9120,.5160,1.2980>,<-5,4.617674,1.775216>}
 smooth_triangle {<-.9120,.0980,1.2860>,<-5,4.781516,-1.276131><-.9120,.0600,1.2980>,<-5,-4.776601,1.287786><-.9120,.0940,1.3650>,<-5,-4.151009,2.686943>}
 smooth_triangle {<-.9120,.0940,1.3650>,<-5,-4.151009,2.686943><-.9120,.1260,1.3420>,<-4,2.133415,-3.172335><-.9120,.0980,1.2860>,<-5,4.781516,-1.276131>}
 smooth_triangle {<-.9120,.0880,1.2240>,<-6,1.623429,1.650485><-.9120,.0480,1.2240>,<-6,-3.948422,0><-.9120,.0600,1.2980>,<-5,-4.776601,1.287786>}
 smooth_triangle {<-.9120,.0600,1.2980>,<-5,-4.776601,1.287786><-.9120,.0980,1.2860>,<-5,4.781516,-1.276131><-.9120,.0880,1.2240>,<-6,1.623429,1.650485>}
 smooth_triangle {<-.9120,.2260,1.4140>,<-6,2.078915,-1.02537><-.9120,.2140,1.4520>,<-5,-1.775218,4.617673><-.9120,.2880,1.4640>,<-5.714286,-.228673,4.230453>}
 smooth_triangle {<-.9120,.2880,1.4640>,<-5.714286,-.228673,4.230453><-.9120,.2880,1.4240>,<-4,.318465,-5.923447><-.9120,.2260,1.4140>,<-6,2.078915,-1.02537>}
 smooth_triangle {<-.9120,.2880,1.4240>,<-4,.318465,-5.923447><-.9120,.2260,1.4140>,<-6,2.078915,-1.02537><-.8620,.2260,1.4140>,<0,5.197288,-2.563425>}
 smooth_triangle {<-.8620,.2260,1.4140>,<0,5.197288,-2.563425><-.8620,.2880,1.4240>,<0,-.530774,-9.872412><-.9120,.2880,1.4240>,<-4,.318465,-5.923447>}
 smooth_triangle {<-.9120,.1260,1.3420>,<-4,2.133415,-3.172335><-.9120,.0980,1.2860>,<-5,4.781516,-1.276131><-.8620,.0980,1.2860>,<0,9.253652,-3.512199>}
 smooth_triangle {<-.8620,.0980,1.2860>,<0,9.253652,-3.512199><-.8620,.1260,1.3420>,<0,-1.832887,-6.102313><-.9120,.1260,1.3420>,<-4,2.133415,-3.172335>}
 smooth_triangle {<-.9120,.0980,1.2860>,<-5,4.781516,-1.276131><-.9120,.0880,1.2240>,<-6,1.623429,1.650485><-.8620,.0880,1.2240>,<0,4.058573,4.126212>}
 smooth_triangle {<-.8620,.0880,1.2240>,<0,4.058573,4.126212><-.8620,.0980,1.2860>,<0,9.253652,-3.512199><-.9120,.0980,1.2860>,<-5,4.781516,-1.276131>}
 smooth_triangle {<-.9120,.2880,1.4640>,<-5.714286,-.228673,4.230453><-.9120,.2140,1.4520>,<-5,-1.775218,4.617673><-.8620,.2140,1.4520>,<0,-2.575571,9.553201>}
 smooth_triangle {<-.8620,.2140,1.4520>,<0,-2.575571,9.553201><-.8620,.2880,1.4640>,<0,.533569,9.871056><-.9120,.2880,1.4640>,<-5.714286,-.228673,4.230453>}
 smooth_triangle {<-.9120,.2140,1.4520>,<-5,-1.775218,4.617673><-.9120,.1470,1.4180>,<-5,-3.111238,3.843272><-.8620,.1470,1.4180>,<0,-5.373888,8.302018>}
 smooth_triangle {<-.8620,.1470,1.4180>,<0,-5.373888,8.302018><-.8620,.2140,1.4520>,<0,-2.575571,9.553201><-.9120,.2140,1.4520>,<-5,-1.775218,4.617673>}
 smooth_triangle {<-.9120,.1470,1.4180>,<-5,-3.111238,3.843272><-.9120,.0940,1.3650>,<-5,-4.151009,2.686943><-.8620,.0940,1.3650>,<0,-7.686542,6.222478>}
 smooth_triangle {<-.8620,.0940,1.3650>,<0,-7.686542,6.222478><-.8620,.1470,1.4180>,<0,-5.373888,8.302018><-.9120,.1470,1.4180>,<-5,-3.111238,3.843272>}
 smooth_triangle {<-.9120,.0940,1.3650>,<-5,-4.151009,2.686943><-.9120,.0600,1.2980>,<-5,-4.776601,1.287786><-.8620,.0600,1.2980>,<0,-9.235348,3.550433>}
 smooth_triangle {<-.8620,.0600,1.2980>,<0,-9.235348,3.550433><-.8620,.0940,1.3650>,<0,-7.686542,6.222478><-.9120,.0940,1.3650>,<-5,-4.151009,2.686943>}
 smooth_triangle {<-.9120,.0600,1.2980>,<-5,-4.776601,1.287786><-.9120,.0480,1.2240>,<-6,-3.948422,0><-.8620,.0480,1.2240>,<0,-9.871055,0>}
 smooth_triangle {<-.8620,.0480,1.2240>,<0,-9.871055,0><-.8620,.0600,1.2980>,<0,-9.235348,3.550433><-.9120,.0600,1.2980>,<-5,-4.776601,1.287786>}
 smooth_triangle {<-.9120,.0600,1.1500>,<-4,-5.731921,-1.545343><-.9120,.0480,1.2240>,<-6,-3.948422,0><-.8620,.0480,1.2240>,<0,-9.871055,0>}
 smooth_triangle {<-.8620,.0480,1.2240>,<0,-9.871055,0><-.8620,.0600,1.1500>,<0,-9.235348,-3.550433><-.9120,.0600,1.1500>,<-4,-5.731921,-1.545343>}
 smooth_triangle {<-.9120,.0940,1.0830>,<-5.714286,-3.558008,-2.303094><-.9120,.0600,1.1500>,<-4,-5.731921,-1.545343><-.8620,.0600,1.1500>,<0,-9.235348,-3.550433>}
 smooth_triangle {<-.8620,.0600,1.1500>,<0,-9.235348,-3.550433><-.8620,.0940,1.0830>,<0,-7.686542,-6.222478><-.9120,.0940,1.0830>,<-5.714286,-3.558008,-2.303094>}
 smooth_triangle {<-.9120,.1470,1.0300>,<-5,-3.111238,-3.843272><-.9120,.0940,1.0830>,<-5.714286,-3.558008,-2.303094><-.8620,.0940,1.0830>,<0,-7.686542,-6.222478>}
 smooth_triangle {<-.8620,.0940,1.0830>,<0,-7.686542,-6.222478><-.8620,.1470,1.0300>,<0,-5.373884,-8.30202><-.9120,.1470,1.0300>,<-5,-3.111238,-3.843272>}
 smooth_triangle {<-.9120,.2140,.9960>,<-5,-1.775216,-4.617674><-.9120,.1470,1.0300>,<-5,-3.111238,-3.843272><-.8620,.1470,1.0300>,<0,-5.373884,-8.30202>}
 smooth_triangle {<-.8620,.1470,1.0300>,<0,-5.373884,-8.30202><-.8620,.2140,.9960>,<0,-2.575569,-9.553202><-.9120,.2140,.9960>,<-5,-1.775216,-4.617674>}
 smooth_triangle {<-.9120,.2880,.9840>,<-4,-.320142,-5.922633><-.9120,.2140,.9960>,<-5,-1.775216,-4.617674><-.8620,.2140,.9960>,<0,-2.575569,-9.553202>}
 smooth_triangle {<-.8620,.2140,.9960>,<0,-2.575569,-9.553202><-.8620,.2880,.9840>,<0,.533569,-9.871056><-.9120,.2880,.9840>,<-4,-.320142,-5.922633>}
 smooth_triangle {<-.9120,.1700,1.0620>,<-5,3.102376,3.847737><-.9120,.1260,1.1060>,<-5,2.855172,-.483353><-.8620,.1260,1.1060>,<0,5.710344,-.966705>}
 smooth_triangle {<-.8620,.1260,1.1060>,<0,5.710344,-.966705><-.8620,.1700,1.0620>,<0,5.338444,8.319873><-.9120,.1700,1.0620>,<-5,3.102376,3.847737>}
 smooth_triangle {<-.9120,.2260,1.0340>,<-5,-.159963,3.211751><-.9120,.1700,1.0620>,<-5,3.102376,3.847737><-.8620,.1700,1.0620>,<0,5.338444,8.319873>}
 smooth_triangle {<-.8620,.1700,1.0620>,<0,5.338444,8.319873><-.8620,.2260,1.0340>,<0,-5.111987,3.902732><-.9120,.2260,1.0340>,<-5,-.159963,3.211751>}
 smooth_triangle {<-.9120,.2260,1.0340>,<-5,-.159963,3.211751><-.9120,.2140,.9960>,<-5,-1.775216,-4.617674><-.9120,.1470,1.0300>,<-5,-3.111238,-3.843272>}
 smooth_triangle {<-.9120,.1470,1.0300>,<-5,-3.111238,-3.843272><-.9120,.1700,1.0620>,<-5,3.102376,3.847737><-.9120,.2260,1.0340>,<-5,-.159963,3.211751>}
 smooth_triangle {<-.9120,.1700,1.0620>,<-5,3.102376,3.847737><-.9120,.1470,1.0300>,<-5,-3.111238,-3.843272><-.9120,.0940,1.0830>,<-5.714286,-3.558008,-2.303094>}
 smooth_triangle {<-.9120,.0940,1.0830>,<-5.714286,-3.558008,-2.303094><-.9120,.1260,1.1060>,<-5,2.855172,-.483353><-.9120,.1700,1.0620>,<-5,3.102376,3.847737>}
 smooth_triangle {<-.9120,.4290,1.0300>,<-5,2.686942,-4.15101><-.9120,.4060,1.0620>,<-5,-2.669222,4.159936><-.9120,.4500,1.1060>,<-4.285714,-3.263054,-.552403>}
 smooth_triangle {<-.9120,.4500,1.1060>,<-4.285714,-3.263054,-.552403><-.9120,.4820,1.0830>,<-5,3.843271,-3.111238><-.9120,.4290,1.0300>,<-5,2.686942,-4.15101>}
 smooth_triangle {<-.9120,.3620,.9960>,<-5.714286,1.103815,-4.094229><-.9120,.3500,1.0340>,<-4,3.067192,2.341639><-.9120,.4060,1.0620>,<-5,-2.669222,4.159936>}
 smooth_triangle {<-.9120,.4060,1.0620>,<-5,-2.669222,4.159936><-.9120,.4290,1.0300>,<-5,2.686942,-4.15101><-.9120,.3620,.9960>,<-5.714286,1.103815,-4.094229>}
 smooth_triangle {<-.9120,.4060,1.0620>,<-5,-2.669222,4.159936><-.9120,.3500,1.0340>,<-4,3.067192,2.341639><-.8620,.3500,1.0340>,<0,.319926,6.423502>}
 smooth_triangle {<-.8620,.3500,1.0340>,<0,.319926,6.423502><-.8620,.4060,1.0620>,<0,-6.204752,7.695474><-.9120,.4060,1.0620>,<-5,-2.669222,4.159936>}
 smooth_triangle {<-.9120,.4500,1.1060>,<-4.285714,-3.263054,-.552403><-.9120,.4060,1.0620>,<-5,-2.669222,4.159936><-.8620,.4060,1.0620>,<0,-6.204752,7.695474>}
 smooth_triangle {<-.8620,.4060,1.0620>,<0,-6.204752,7.695474><-.8620,.4500,1.1060>,<0,-5.710344,-.966705><-.9120,.4500,1.1060>,<-4.285714,-3.263054,-.552403>}
 smooth_triangle {<-.9120,.3620,.9960>,<-5.714286,1.103815,-4.094229><-.9120,.2880,.9840>,<-4,-.320142,-5.922633><-.8620,.2880,.9840>,<0,.533569,-9.871056>}
 smooth_triangle {<-.8620,.2880,.9840>,<0,.533569,-9.871056><-.8620,.3620,.9960>,<0,3.550431,-9.235349><-.9120,.3620,.9960>,<-5.714286,1.103815,-4.094229>}
 smooth_triangle {<-.9120,.4290,1.0300>,<-5,2.686942,-4.15101><-.9120,.3620,.9960>,<-5.714286,1.103815,-4.094229><-.8620,.3620,.9960>,<0,3.550431,-9.235349>}
 smooth_triangle {<-.8620,.3620,.9960>,<0,3.550431,-9.235349><-.8620,.4290,1.0300>,<0,6.222475,-7.686545><-.9120,.4290,1.0300>,<-5,2.686942,-4.15101>}
 smooth_triangle {<-.9120,.4820,1.0830>,<-5,3.843271,-3.111238><-.9120,.4290,1.0300>,<-5,2.686942,-4.15101><-.8620,.4290,1.0300>,<0,6.222475,-7.686545>}
 smooth_triangle {<-.8620,.4290,1.0300>,<0,6.222475,-7.686545><-.8620,.4820,1.0830>,<0,8.302019,-5.373884><-.9120,.4820,1.0830>,<-5,3.843271,-3.111238>}
 smooth_triangle {<-.9120,.5160,1.1500>,<-5,4.617674,-1.775216><-.9120,.4820,1.0830>,<-5,3.843271,-3.111238><-.8620,.4820,1.0830>,<0,8.302019,-5.373884>}
 smooth_triangle {<-.8620,.4820,1.0830>,<0,8.302019,-5.373884><-.8620,.5160,1.1500>,<0,9.553202,-2.575574><-.9120,.5160,1.1500>,<-5,4.617674,-1.775216>}
 smooth_triangle {<-.9120,.5280,1.2240>,<-4.285714,5.640603,0><-.9120,.5160,1.1500>,<-5,4.617674,-1.775216><-.8620,.5160,1.1500>,<0,9.553202,-2.575574>}
 smooth_triangle {<-.8620,.5160,1.1500>,<0,9.553202,-2.575574><-.8620,.5280,1.2240>,<0,9.871055,0><-.9120,.5280,1.2240>,<-4.285714,5.640603,0>}
 smooth_triangle {<-.9120,.5160,1.1500>,<-5,4.617674,-1.775216><-.9120,.3560,1.2020>,<-10,0,0><-.9120,.3630,1.2240>,<-10,0,0>}
 smooth_triangle {<-.9120,.3630,1.2240>,<-10,0,0><-.9120,.5280,1.2240>,<-4.285714,5.640603,0><-.9120,.5160,1.1500>,<-5,4.617674,-1.775216>}
 smooth_triangle {<-.9120,.4820,1.0830>,<-5,3.843271,-3.111238><-.9120,.3490,1.1800>,<-10,0,0><-.9120,.3560,1.2020>,<-10,0,0>}
 smooth_triangle {<-.9120,.3560,1.2020>,<-10,0,0><-.9120,.5160,1.1500>,<-5,4.617674,-1.775216><-.9120,.4820,1.0830>,<-5,3.843271,-3.111238>}
 smooth_triangle {<-.9120,.3620,.9960>,<-5.714286,1.103815,-4.094229><-.9120,.3110,1.1530>,<-10,0,0><-.9120,.2880,1.1530>,<-10,0,0>}
 smooth_triangle {<-.9120,.2880,1.1530>,<-10,0,0><-.9120,.2880,.9840>,<-4,-.320142,-5.922633><-.9120,.3620,.9960>,<-5.714286,1.103815,-4.094229>}
 smooth_triangle {<-.9120,.2880,1.1530>,<-10,0,0><-.9120,.2880,.9840>,<-4,-.320142,-5.922633><-.9120,.2140,.9960>,<-5,-1.775216,-4.617674>}
 smooth_triangle {<-.9120,.2140,.9960>,<-5,-1.775216,-4.617674><-.9120,.2650,1.1530>,<-10,0,0><-.9120,.2880,1.1530>,<-10,0,0>}
 smooth_triangle {<-.9120,.3490,1.2680>,<-5,0,0><-.9120,.3300,1.2820>,<-10,0,0><-.9120,.4290,1.4180>,<-5,2.686944,4.151009>}
 smooth_triangle {<-.9120,.4290,1.4180>,<-5,2.686944,4.151009><-.9120,.4820,1.3650>,<-4,4.611926,3.733486><-.9120,.3490,1.2680>,<-5,0,0>}
 smooth_triangle {<-.9120,.3300,1.2820>,<-10,0,0><-.9120,.3110,1.2950>,<-3.333333,0,0><-.9120,.3620,1.4520>,<-5,1.287786,4.7766>}
 smooth_triangle {<-.9120,.3620,1.4520>,<-5,1.287786,4.7766><-.9120,.4290,1.4180>,<-5,2.686944,4.151009><-.9120,.3300,1.2820>,<-10,0,0>}
 smooth_triangle {<-.9120,.2460,1.2820>,<-10,0,0><-.9120,.1470,1.4180>,<-5,-3.111238,3.843272><-.9120,.2140,1.4520>,<-5,-1.775218,4.617673>}
 smooth_triangle {<-.9120,.2140,1.4520>,<-5,-1.775218,4.617673><-.9120,.2650,1.2950>,<-10,0,0><-.9120,.2460,1.2820>,<-10,0,0>}
 smooth_triangle {<-.9120,.2270,1.2680>,<-10,0,0><-.9120,.0940,1.3650>,<-5,-4.151009,2.686943><-.9120,.1470,1.4180>,<-5,-3.111238,3.843272>}
 smooth_triangle {<-.9120,.1470,1.4180>,<-5,-3.111238,3.843272><-.9120,.2460,1.2820>,<-10,0,0><-.9120,.2270,1.2680>,<-10,0,0>}
 smooth_triangle {<-.9120,.2200,1.2020>,<-10,0,0><-.9120,.2130,1.2240>,<-10,0,0><-.9120,.0480,1.2240>,<-6,-3.948422,0>}
 smooth_triangle {<-.9120,.0480,1.2240>,<-6,-3.948422,0><-.9120,.0600,1.1500>,<-4,-5.731921,-1.545343><-.9120,.2200,1.2020>,<-10,0,0>}
 smooth_triangle {<-.9120,.0940,1.0830>,<-5.714286,-3.558008,-2.303094><-.9120,.0600,1.1500>,<-4,-5.731921,-1.545343><-.9120,.2200,1.2020>,<-10,0,0>}
 smooth_triangle {<-.9120,.2200,1.2020>,<-10,0,0><-.9120,.2270,1.1800>,<-10,0,0><-.9120,.0940,1.0830>,<-5.714286,-3.558008,-2.303094>}
 smooth_triangle {<-.9120,.0940,-1.1730>,<5.714286,3.558008,2.303094><-.9120,.0600,-1.1060>,<4,5.731921,1.545343><-.9120,.2200,-1.0540>,<10,0,0>}
 smooth_triangle {<-.9120,.2200,-1.0540>,<10,0,0><-.9120,.2270,-1.0760>,<10,0,0><-.9120,.0940,-1.1730>,<5.714286,3.558008,2.303094>}
 smooth_triangle {<-.9120,.2200,-1.0540>,<10,0,0><-.9120,.2130,-1.0320>,<10,0,0><-.9120,.0480,-1.0320>,<6,3.948422,0>}
 smooth_triangle {<-.9120,.0480,-1.0320>,<6,3.948422,0><-.9120,.0600,-1.1060>,<4,5.731921,1.545343><-.9120,.2200,-1.0540>,<10,0,0>}
 smooth_triangle {<-.9120,.2270,-.9880>,<10,0,0><-.9120,.0940,-.8910>,<5,4.151009,-2.686943><-.9120,.1470,-.8380>,<5,3.111238,-3.843272>}
 smooth_triangle {<-.9120,.1470,-.8380>,<5,3.111238,-3.843272><-.9120,.2460,-.9740>,<10,0,0><-.9120,.2270,-.9880>,<10,0,0>}
 smooth_triangle {<-.9120,.2460,-.9740>,<10,0,0><-.9120,.1470,-.8380>,<5,3.111238,-3.843272><-.9120,.2140,-.8040>,<5,1.775217,-4.617674>}
 smooth_triangle {<-.9120,.2140,-.8040>,<5,1.775217,-4.617674><-.9120,.2650,-.9610>,<1,0,0><-.9120,.2460,-.9740>,<10,0,0>}
 smooth_triangle {<-.9120,.3300,-.9740>,<10,0,0><-.9120,.3110,-.9610>,<3.333333,0,0><-.9120,.3620,-.8040>,<5,-1.287787,-4.776601>}
 smooth_triangle {<-.9120,.3620,-.8040>,<5,-1.287787,-4.776601><-.9120,.4290,-.8380>,<5,-2.686942,-4.15101><-.9120,.3300,-.9740>,<10,0,0>}
 smooth_triangle {<-.9120,.3490,-.9880>,<5,0,0><-.9120,.3300,-.9740>,<10,0,0><-.9120,.4290,-.8380>,<5,-2.686942,-4.15101>}
 smooth_triangle {<-.9120,.4290,-.8380>,<5,-2.686942,-4.15101><-.9120,.4820,-.8910>,<4,-4.611926,-3.733486><-.9120,.3490,-.9880>,<5,0,0>}
 smooth_triangle {<-.9120,.2880,-1.1030>,<10,0,0><-.9120,.2880,-1.2720>,<4,.320142,5.922633><-.9120,.2140,-1.2600>,<5,1.775218,4.617673>}
 smooth_triangle {<-.9120,.2140,-1.2600>,<5,1.775218,4.617673><-.9120,.2650,-1.1030>,<10,0,0><-.9120,.2880,-1.1030>,<10,0,0>}
 smooth_triangle {<-.9120,.3620,-1.2600>,<5.714286,-1.103816,4.094229><-.9120,.3110,-1.1030>,<10,0,0><-.9120,.2880,-1.1030>,<10,0,0>}
 smooth_triangle {<-.9120,.2880,-1.1030>,<10,0,0><-.9120,.2880,-1.2720>,<4,.320142,5.922633><-.9120,.3620,-1.2600>,<5.714286,-1.103816,4.094229>}
 smooth_triangle {<-.9120,.4820,-1.1730>,<5,-3.843271,3.111238><-.9120,.3490,-1.0760>,<10,0,0><-.9120,.3560,-1.0540>,<10,0,0>}
 smooth_triangle {<-.9120,.3560,-1.0540>,<10,0,0><-.9120,.5160,-1.1060>,<5,-4.617674,1.775216><-.9120,.4820,-1.1730>,<5,-3.843271,3.111238>}
 smooth_triangle {<-.9120,.5160,-1.1060>,<5,-4.617674,1.775216><-.9120,.3560,-1.0540>,<10,0,0><-.9120,.3630,-1.0320>,<10,0,0>}
 smooth_triangle {<-.9120,.3630,-1.0320>,<10,0,0><-.9120,.5280,-1.0320>,<4.285714,-5.640603,0><-.9120,.5160,-1.1060>,<5,-4.617674,1.775216>}
 smooth_triangle {<-.9120,.5280,-1.0320>,<4.285714,-5.640603,0><-.9120,.5160,-1.1060>,<5,-4.617674,1.775216><-.8620,.5160,-1.1060>,<0,-9.553202,2.575574>}
 smooth_triangle {<-.8620,.5160,-1.1060>,<0,-9.553202,2.575574><-.8620,.5280,-1.0320>,<0,-9.871054,-.000001><-.9120,.5280,-1.0320>,<4.285714,-5.640603,0>}
 smooth_triangle {<-.9120,.5160,-1.1060>,<5,-4.617674,1.775216><-.9120,.4820,-1.1730>,<5,-3.843271,3.111238><-.8620,.4820,-1.1730>,<0,-8.302019,5.373884>}
 smooth_triangle {<-.8620,.4820,-1.1730>,<0,-8.302019,5.373884><-.8620,.5160,-1.1060>,<0,-9.553202,2.575574><-.9120,.5160,-1.1060>,<5,-4.617674,1.775216>}
 smooth_triangle {<-.9120,.4820,-1.1730>,<5,-3.843271,3.111238><-.9120,.4290,-1.2260>,<5,-2.686944,4.151009><-.8620,.4290,-1.2260>,<0,-6.222477,7.686544>}
 smooth_triangle {<-.8620,.4290,-1.2260>,<0,-6.222477,7.686544><-.8620,.4820,-1.1730>,<0,-8.302019,5.373884><-.9120,.4820,-1.1730>,<5,-3.843271,3.111238>}
 smooth_triangle {<-.9120,.4290,-1.2260>,<5,-2.686944,4.151009><-.9120,.3620,-1.2600>,<5.714286,-1.103816,4.094229><-.8620,.3620,-1.2600>,<0,-3.550435,9.235347>}
 smooth_triangle {<-.8620,.3620,-1.2600>,<0,-3.550435,9.235347><-.8620,.4290,-1.2260>,<0,-6.222477,7.686544><-.9120,.4290,-1.2260>,<5,-2.686944,4.151009>}
 smooth_triangle {<-.9120,.3620,-1.2600>,<5.714286,-1.103816,4.094229><-.9120,.2880,-1.2720>,<4,.320142,5.922633><-.8620,.2880,-1.2720>,<0,-.533569,9.871056>}
 smooth_triangle {<-.8620,.2880,-1.2720>,<0,-.533569,9.871056><-.8620,.3620,-1.2600>,<0,-3.550435,9.235347><-.9120,.3620,-1.2600>,<5.714286,-1.103816,4.094229>}
 smooth_triangle {<-.9120,.4500,-1.1500>,<4.285714,3.263054,.552406><-.9120,.4060,-1.1940>,<5,2.669224,-4.159935><-.8620,.4060,-1.1940>,<0,6.204759,-7.695467>}
 smooth_triangle {<-.8620,.4060,-1.1940>,<0,6.204759,-7.695467><-.8620,.4500,-1.1500>,<0,5.710345,.966711><-.9120,.4500,-1.1500>,<4.285714,3.263054,.552406>}
 smooth_triangle {<-.9120,.4060,-1.1940>,<5,2.669224,-4.159935><-.9120,.3500,-1.2220>,<4,-3.067192,-2.341639><-.8620,.3500,-1.2220>,<0,-.319926,-6.423502>}
 smooth_triangle {<-.8620,.3500,-1.2220>,<0,-.319926,-6.423502><-.8620,.4060,-1.1940>,<0,6.204759,-7.695467><-.9120,.4060,-1.1940>,<5,2.669224,-4.159935>}
 smooth_triangle {<-.9120,.3620,-1.2600>,<5.714286,-1.103816,4.094229><-.9120,.3500,-1.2220>,<4,-3.067192,-2.341639><-.9120,.4060,-1.1940>,<5,2.669224,-4.159935>}
 smooth_triangle {<-.9120,.4060,-1.1940>,<5,2.669224,-4.159935><-.9120,.4290,-1.2260>,<5,-2.686944,4.151009><-.9120,.3620,-1.2600>,<5.714286,-1.103816,4.094229>}
 smooth_triangle {<-.9120,.4290,-1.2260>,<5,-2.686944,4.151009><-.9120,.4060,-1.1940>,<5,2.669224,-4.159935><-.9120,.4500,-1.1500>,<4.285714,3.263054,.552406>}
 smooth_triangle {<-.9120,.4500,-1.1500>,<4.285714,3.263054,.552406><-.9120,.4820,-1.1730>,<5,-3.843271,3.111238><-.9120,.4290,-1.2260>,<5,-2.686944,4.151009>}
 smooth_triangle {<-.9120,.1700,-1.1940>,<5,-3.102379,-3.847734><-.9120,.1470,-1.2260>,<5,3.111238,3.843272><-.9120,.0940,-1.1730>,<5.714286,3.558008,2.303094>}
 smooth_triangle {<-.9120,.0940,-1.1730>,<5.714286,3.558008,2.303094><-.9120,.1260,-1.1500>,<5,-2.855173,.483356><-.9120,.1700,-1.1940>,<5,-3.102379,-3.847734>}
 smooth_triangle {<-.9120,.2260,-1.2220>,<5,.159963,-3.211751><-.9120,.2140,-1.2600>,<5,1.775218,4.617673><-.9120,.1470,-1.2260>,<5,3.111238,3.843272>}
 smooth_triangle {<-.9120,.1470,-1.2260>,<5,3.111238,3.843272><-.9120,.1700,-1.1940>,<5,-3.102379,-3.847734><-.9120,.2260,-1.2220>,<5,.159963,-3.211751>}
 smooth_triangle {<-.9120,.2260,-1.2220>,<5,.159963,-3.211751><-.9120,.1700,-1.1940>,<5,-3.102379,-3.847734><-.8620,.1700,-1.1940>,<0,-5.338448,-8.31987>}
 smooth_triangle {<-.8620,.1700,-1.1940>,<0,-5.338448,-8.31987><-.8620,.2260,-1.2220>,<0,5.111987,-3.902732><-.9120,.2260,-1.2220>,<5,.159963,-3.211751>}
 smooth_triangle {<-.9120,.1700,-1.1940>,<5,-3.102379,-3.847734><-.9120,.1260,-1.1500>,<5,-2.855173,.483356><-.8620,.1260,-1.1500>,<0,-5.710345,.966711>}
 smooth_triangle {<-.8620,.1260,-1.1500>,<0,-5.710345,.966711><-.8620,.1700,-1.1940>,<0,-5.338448,-8.31987><-.9120,.1700,-1.1940>,<5,-3.102379,-3.847734>}
 smooth_triangle {<-.9120,.2880,-1.2720>,<4,.320142,5.922633><-.9120,.2140,-1.2600>,<5,1.775218,4.617673><-.8620,.2140,-1.2600>,<0,2.575571,9.553201>}
 smooth_triangle {<-.8620,.2140,-1.2600>,<0,2.575571,9.553201><-.8620,.2880,-1.2720>,<0,-.533569,9.871056><-.9120,.2880,-1.2720>,<4,.320142,5.922633>}
 smooth_triangle {<-.9120,.2140,-1.2600>,<5,1.775218,4.617673><-.9120,.1470,-1.2260>,<5,3.111238,3.843272><-.8620,.1470,-1.2260>,<0,5.373888,8.302018>}
 smooth_triangle {<-.8620,.1470,-1.2260>,<0,5.373888,8.302018><-.8620,.2140,-1.2600>,<0,2.575571,9.553201><-.9120,.2140,-1.2600>,<5,1.775218,4.617673>}
 smooth_triangle {<-.9120,.1470,-1.2260>,<5,3.111238,3.843272><-.9120,.0940,-1.1730>,<5.714286,3.558008,2.303094><-.8620,.0940,-1.1730>,<0,7.686542,6.222478>}
 smooth_triangle {<-.8620,.0940,-1.1730>,<0,7.686542,6.222478><-.8620,.1470,-1.2260>,<0,5.373888,8.302018><-.9120,.1470,-1.2260>,<5,3.111238,3.843272>}
 smooth_triangle {<-.9120,.0940,-1.1730>,<5.714286,3.558008,2.303094><-.9120,.0600,-1.1060>,<4,5.731921,1.545343><-.8620,.0600,-1.1060>,<0,9.235348,3.550433>}
 smooth_triangle {<-.8620,.0600,-1.1060>,<0,9.235348,3.550433><-.8620,.0940,-1.1730>,<0,7.686542,6.222478><-.9120,.0940,-1.1730>,<5.714286,3.558008,2.303094>}
 smooth_triangle {<-.9120,.0600,-1.1060>,<4,5.731921,1.545343><-.9120,.0480,-1.0320>,<6,3.948422,0><-.8620,.0480,-1.0320>,<0,9.871055,-.000001>}
 smooth_triangle {<-.8620,.0480,-1.0320>,<0,9.871055,-.000001><-.8620,.0600,-1.1060>,<0,9.235348,3.550433><-.9120,.0600,-1.1060>,<4,5.731921,1.545343>}
 smooth_triangle {<-.9120,.0600,-.9580>,<5,4.776601,-1.287786><-.9120,.0480,-1.0320>,<6,3.948422,0><-.8620,.0480,-1.0320>,<0,9.871055,-.000001>}
 smooth_triangle {<-.8620,.0480,-1.0320>,<0,9.871055,-.000001><-.8620,.0600,-.9580>,<0,9.235348,-3.550433><-.9120,.0600,-.9580>,<5,4.776601,-1.287786>}
 smooth_triangle {<-.9120,.0940,-.8910>,<5,4.151009,-2.686943><-.9120,.0600,-.9580>,<5,4.776601,-1.287786><-.8620,.0600,-.9580>,<0,9.235348,-3.550433>}
 smooth_triangle {<-.8620,.0600,-.9580>,<0,9.235348,-3.550433><-.8620,.0940,-.8910>,<0,7.686542,-6.222478><-.9120,.0940,-.8910>,<5,4.151009,-2.686943>}
 smooth_triangle {<-.9120,.1470,-.8380>,<5,3.111238,-3.843272><-.9120,.0940,-.8910>,<5,4.151009,-2.686943><-.8620,.0940,-.8910>,<0,7.686542,-6.222478>}
 smooth_triangle {<-.8620,.0940,-.8910>,<0,7.686542,-6.222478><-.8620,.1470,-.8380>,<0,5.373884,-8.30202><-.9120,.1470,-.8380>,<5,3.111238,-3.843272>}
 smooth_triangle {<-.9120,.2140,-.8040>,<5,1.775217,-4.617674><-.9120,.1470,-.8380>,<5,3.111238,-3.843272><-.8620,.1470,-.8380>,<0,5.373884,-8.30202>}
 smooth_triangle {<-.8620,.1470,-.8380>,<0,5.373884,-8.30202><-.8620,.2140,-.8040>,<0,2.575574,-9.553202><-.9120,.2140,-.8040>,<5,1.775217,-4.617674>}
 smooth_triangle {<-.9120,.2880,-.7920>,<5.714286,.228674,-4.230452><-.9120,.2140,-.8040>,<5,1.775217,-4.617674><-.8620,.2140,-.8040>,<0,2.575574,-9.553202>}
 smooth_triangle {<-.8620,.2140,-.8040>,<0,2.575574,-9.553202><-.8620,.2880,-.7920>,<0,-.533571,-9.871055><-.9120,.2880,-.7920>,<5.714286,.228674,-4.230452>}
 smooth_triangle {<-.9120,.0980,-.9700>,<5,-4.781516,1.276131><-.9120,.0880,-1.0320>,<6,-1.623429,-1.650484><-.8620,.0880,-1.0320>,<0,-4.058573,-4.12621>}
 smooth_triangle {<-.8620,.0880,-1.0320>,<0,-4.058573,-4.12621><-.8620,.0980,-.9700>,<0,-9.253653,3.512197><-.9120,.0980,-.9700>,<5,-4.781516,1.276131>}
 smooth_triangle {<-.9120,.1260,-.9140>,<4,-2.133417,3.172334><-.9120,.0980,-.9700>,<5,-4.781516,1.276131><-.8620,.0980,-.9700>,<0,-9.253653,3.512197>}
 smooth_triangle {<-.8620,.0980,-.9700>,<0,-9.253653,3.512197><-.8620,.1260,-.9140>,<0,1.832884,6.102313><-.9120,.1260,-.9140>,<4,-2.133417,3.172334>}
 smooth_triangle {<-.9120,.2880,-.8320>,<4,-.318465,5.923447><-.9120,.2260,-.8420>,<2,1.441986,2.923594><-.8620,.2260,-.8420>,<0,3.604965,7.308987>}
 smooth_triangle {<-.8620,.2260,-.8420>,<0,3.604965,7.308987><-.8620,.2880,-.8320>,<0,.530774,9.872412><-.9120,.2880,-.8320>,<4,-.318465,5.923447>}
 smooth_triangle {<-.9120,.2260,-.8420>,<2,1.441986,2.923594><-.9120,.2140,-.8040>,<5,1.775217,-4.617674><-.9120,.2880,-.7920>,<5.714286,.228674,-4.230452>}
 smooth_triangle {<-.9120,.2880,-.7920>,<5.714286,.228674,-4.230452><-.9120,.2880,-.8320>,<4,-.318465,5.923447><-.9120,.2260,-.8420>,<2,1.441986,2.923594>}
 smooth_triangle {<-.9120,.0880,-1.0320>,<6,-1.623429,-1.650484><-.9120,.0480,-1.0320>,<6,3.948422,0><-.9120,.0600,-.9580>,<5,4.776601,-1.287786>}
 smooth_triangle {<-.9120,.0600,-.9580>,<5,4.776601,-1.287786><-.9120,.0980,-.9700>,<5,-4.781516,1.276131><-.9120,.0880,-1.0320>,<6,-1.623429,-1.650484>}
 smooth_triangle {<-.9120,.0980,-.9700>,<5,-4.781516,1.276131><-.9120,.0600,-.9580>,<5,4.776601,-1.287786><-.9120,.0940,-.8910>,<5,4.151009,-2.686943>}
 smooth_triangle {<-.9120,.0940,-.8910>,<5,4.151009,-2.686943><-.9120,.1260,-.9140>,<4,-2.133417,3.172334><-.9120,.0980,-.9700>,<5,-4.781516,1.276131>}
 smooth_triangle {<-.9120,.5160,-.9580>,<5,-4.617674,-1.775216><-.9120,.4780,-.9700>,<5,4.626826,1.756099><-.9120,.4500,-.9140>,<2.222222,-2.215731,3.571305>}
 smooth_triangle {<-.9120,.4500,-.9140>,<2.222222,-2.215731,3.571305><-.9120,.4820,-.8910>,<4,-4.611926,-3.733486><-.9120,.5160,-.9580>,<5,-4.617674,-1.775216>}
 smooth_triangle {<-.9120,.5280,-1.0320>,<4.285714,-5.640603,0><-.9120,.4880,-1.0320>,<3.333333,2.705715,-2.750806><-.9120,.4780,-.9700>,<5,4.626826,1.756099>}
 smooth_triangle {<-.9120,.4780,-.9700>,<5,4.626826,1.756099><-.9120,.5160,-.9580>,<5,-4.617674,-1.775216><-.9120,.5280,-1.0320>,<4.285714,-5.640603,0>}
 smooth_triangle {<-.9120,.3500,-.8420>,<2,.318465,1.974482><-.9120,.3620,-.8040>,<5,-1.287787,-4.776601><-.9120,.2880,-.7920>,<5.714286,.228674,-4.230452>}
 smooth_triangle {<-.9120,.2880,-.7920>,<5.714286,.228674,-4.230452><-.9120,.2880,-.8320>,<4,-.318465,5.923447><-.9120,.3500,-.8420>,<2,.318465,1.974482>}
 smooth_triangle {<-.9120,.3500,-.8420>,<2,.318465,1.974482><-.9120,.2880,-.8320>,<4,-.318465,5.923447><-.8620,.2880,-.8320>,<0,.530774,9.872412>}
 smooth_triangle {<-.8620,.2880,-.8320>,<0,.530774,9.872412><-.8620,.3500,-.8420>,<0,.530774,3.290804><-.9120,.3500,-.8420>,<2,.318465,1.974482>}
 smooth_triangle {<-.9120,.4780,-.9700>,<5,4.626826,1.756099><-.9120,.4500,-.9140>,<2.222222,-2.215731,3.571305><-.8620,.4500,-.9140>,<0,.861405,5.694768>}
 smooth_triangle {<-.8620,.4500,-.9140>,<0,.861405,5.694768><-.8620,.4780,-.9700>,<0,9.563032,2.552264><-.9120,.4780,-.9700>,<5,4.626826,1.756099>}
 smooth_triangle {<-.9120,.4880,-1.0320>,<3.333333,2.705715,-2.750806><-.9120,.4780,-.9700>,<5,4.626826,1.756099><-.8620,.4780,-.9700>,<0,9.563032,2.552264>}
 smooth_triangle {<-.8620,.4780,-.9700>,<0,9.563032,2.552264><-.8620,.4880,-1.0320>,<0,4.058573,-4.126208><-.9120,.4880,-1.0320>,<3.333333,2.705715,-2.750806>}
 smooth_triangle {<-.9120,.3620,-.8040>,<5,-1.287787,-4.776601><-.9120,.2880,-.7920>,<5.714286,.228674,-4.230452><-.8620,.2880,-.7920>,<0,-.533571,-9.871055>}
 smooth_triangle {<-.8620,.2880,-.7920>,<0,-.533571,-9.871055><-.8620,.3620,-.8040>,<0,-3.550434,-9.235348><-.9120,.3620,-.8040>,<5,-1.287787,-4.776601>}
 smooth_triangle {<-.9120,.4290,-.8380>,<5,-2.686942,-4.15101><-.9120,.3620,-.8040>,<5,-1.287787,-4.776601><-.8620,.3620,-.8040>,<0,-3.550434,-9.235348>}
 smooth_triangle {<-.8620,.3620,-.8040>,<0,-3.550434,-9.235348><-.8620,.4290,-.8380>,<0,-6.222475,-7.686545><-.9120,.4290,-.8380>,<5,-2.686942,-4.15101>}
 smooth_triangle {<-.9120,.4820,-.8910>,<4,-4.611926,-3.733486><-.9120,.4290,-.8380>,<5,-2.686942,-4.15101><-.8620,.4290,-.8380>,<0,-6.222475,-7.686545>}
 smooth_triangle {<-.8620,.4290,-.8380>,<0,-6.222475,-7.686545><-.8620,.4820,-.8910>,<0,-8.302019,-5.373884><-.9120,.4820,-.8910>,<4,-4.611926,-3.733486>}
 smooth_triangle {<-.9120,.5160,-.9580>,<5,-4.617674,-1.775216><-.9120,.4820,-.8910>,<4,-4.611926,-3.733486><-.8620,.4820,-.8910>,<0,-8.302019,-5.373884>}
 smooth_triangle {<-.8620,.4820,-.8910>,<0,-8.302019,-5.373884><-.8620,.5160,-.9580>,<0,-9.553201,-2.575574><-.9120,.5160,-.9580>,<5,-4.617674,-1.775216>}
 smooth_triangle {<-.9120,.5280,-1.0320>,<4.285714,-5.640603,0><-.9120,.5160,-.9580>,<5,-4.617674,-1.775216><-.8620,.5160,-.9580>,<0,-9.553201,-2.575574>}
 smooth_triangle {<-.8620,.5160,-.9580>,<0,-9.553201,-2.575574><-.8620,.5280,-1.0320>,<0,-9.871054,-.000001><-.9120,.5280,-1.0320>,<4.285714,-5.640603,0>}
 smooth_triangle {<-.9120,.2440,-1.0930>,<3.333333,1.851476,2.540842><-.9120,.2260,-1.2220>,<5,.159963,-3.211751><-.9120,.2650,-1.1030>,<10,0,0>}
 smooth_triangle {<-.9120,.3500,-1.2220>,<4,-3.067192,-2.341639><-.9120,.3110,-1.1030>,<10,0,0><-.9120,.3320,-1.0930>,<5,-1.388607,1.905632>}
 smooth_triangle {<-.9120,.3500,-1.2220>,<4,-3.067192,-2.341639><-.9120,.3320,-1.0930>,<5,-1.388607,1.905632><-.8620,.3320,-1.0930>,<0,-2.777215,3.811263>}
 smooth_triangle {<-.8620,.3320,-1.0930>,<0,-2.777215,3.811263><-.8620,.3500,-1.2220>,<0,-.319926,-6.423502><-.9120,.3500,-1.2220>,<4,-3.067192,-2.341639>}
 smooth_triangle {<-.9120,.2440,-1.0930>,<3.333333,1.851476,2.540842><-.9120,.2260,-1.2220>,<5,.159963,-3.211751><-.8620,.2260,-1.2220>,<0,5.111987,-3.902732>}
 smooth_triangle {<-.8620,.2260,-1.2220>,<0,5.111987,-3.902732><-.8620,.2440,-1.0930>,<0,2.777215,3.811263><-.9120,.2440,-1.0930>,<3.333333,1.851476,2.540842>}
 smooth_triangle {<-.9120,.2440,-1.0930>,<3.333333,1.851476,2.540842><-.9120,.1260,-1.1500>,<5,-2.855173,.483356><-.8620,.1260,-1.1500>,<0,-5.710345,.966711>}
 smooth_triangle {<-.8620,.1260,-1.1500>,<0,-5.710345,.966711><-.8620,.2440,-1.0930>,<0,2.777215,3.811263><-.9120,.2440,-1.0930>,<3.333333,1.851476,2.540842>}
 smooth_triangle {<-.9120,.2170,-1.0090>,<3.333333,2.992243,-.975781><-.9120,.0880,-1.0320>,<6,-1.623429,-1.650484><-.8620,.0880,-1.0320>,<0,-4.058573,-4.12621>}
 smooth_triangle {<-.8620,.0880,-1.0320>,<0,-4.058573,-4.12621><-.8620,.2170,-1.0090>,<0,4.488364,-1.463672><-.9120,.2170,-1.0090>,<3.333333,2.992243,-.975781>}
 smooth_triangle {<-.9120,.2170,-1.0090>,<3.333333,2.992243,-.975781><-.9120,.0880,-1.0320>,<6,-1.623429,-1.650484><-.9120,.2130,-1.0320>,<10,0,0>}
 smooth_triangle {<-.9120,.2440,-1.0930>,<3.333333,1.851476,2.540842><-.9120,.1260,-1.1500>,<5,-2.855173,.483356><-.9120,.2270,-1.0760>,<10,0,0>}
 smooth_triangle {<-.9120,.4500,-.9140>,<2.222222,-2.215731,3.571305><-.9120,.3590,-1.0090>,<1.666667,-2.699698,.66501><-.8620,.3590,-1.0090>,<0,-5.399397,1.33002>}
 smooth_triangle {<-.8620,.3590,-1.0090>,<0,-5.399397,1.33002><-.8620,.4500,-.9140>,<0,.861405,5.694768><-.9120,.4500,-.9140>,<2.222222,-2.215731,3.571305>}
 smooth_triangle {<-.9120,.3500,-.8420>,<2,.318465,1.974482><-.9120,.2880,-.9570>,<-1.428571,2.514929,1.355875><-.8620,.2880,-.9570>,<0,1.760451,.949112>}
 smooth_triangle {<-.8620,.2880,-.9570>,<0,1.760451,.949112><-.8620,.3500,-.8420>,<0,.530774,3.290804><-.9120,.3500,-.8420>,<2,.318465,1.974482>}
 smooth_triangle {<-.9120,.3500,-.8420>,<2,.318465,1.974482><-.9120,.3110,-.9610>,<3.333333,0,0><-.9120,.2880,-.9570>,<-1.428571,2.514929,1.355875>}
 smooth_triangle {<-.9120,.4500,-.9140>,<2.222222,-2.215731,3.571305><-.9120,.3590,-1.0090>,<1.666667,-2.699698,.66501><-.9120,.3490,-.9880>,<5,0,0>}
 smooth_triangle {<-.9120,.4500,-1.1500>,<4.285714,3.263054,.552406><-.9120,.3320,-1.0930>,<5,-1.388607,1.905632><-.9120,.3490,-1.0760>,<10,0,0>}
 smooth_triangle {<-.9120,.4880,-1.0320>,<3.333333,2.705715,-2.750806><-.9120,.3630,-1.0320>,<10,0,0><-.9120,.3590,-1.0090>,<1.666667,-2.699698,.66501>}
 smooth_triangle {<-.9120,.4880,-1.0320>,<3.333333,2.705715,-2.750806><-.9120,.3590,-1.0090>,<1.666667,-2.699698,.66501><-.8620,.3590,-1.0090>,<0,-5.399397,1.33002>}
 smooth_triangle {<-.8620,.3590,-1.0090>,<0,-5.399397,1.33002><-.8620,.4880,-1.0320>,<0,4.058573,-4.126208><-.9120,.4880,-1.0320>,<3.333333,2.705715,-2.750806>}
 smooth_triangle {<-.9120,.4500,-1.1500>,<4.285714,3.263054,.552406><-.9120,.3320,-1.0930>,<5,-1.388607,1.905632><-.8620,.3320,-1.0930>,<0,-2.777215,3.811263>}
 smooth_triangle {<-.8620,.3320,-1.0930>,<0,-2.777215,3.811263><-.8620,.4500,-1.1500>,<0,5.710345,.966711><-.9120,.4500,-1.1500>,<4.285714,3.263054,.552406>}
 smooth_triangle {<-.9120,.4500,-.9140>,<2.222222,-2.215731,3.571305><-.9120,.3590,-1.0090>,<1.666667,-2.699698,.66501><-.9120,.3490,-.9880>,<5,0,0>}
 smooth_triangle {<-.9120,.3500,-.8420>,<2,.318465,1.974482><-.9120,.3110,-.9610>,<3.333333,0,0><-.9120,.2880,-.9570>,<-1.428571,2.514929,1.355875>}
 smooth_triangle {<-.9120,.3500,-.8420>,<2,.318465,1.974482><-.9120,.2880,-.9570>,<-1.428571,2.514929,1.355875><-.8620,.2880,-.9570>,<0,1.760451,.949112>}
 smooth_triangle {<-.8620,.2880,-.9570>,<0,1.760451,.949112><-.8620,.3500,-.8420>,<0,.530774,3.290804><-.9120,.3500,-.8420>,<2,.318465,1.974482>}
 smooth_triangle {<-.9120,.4500,-.9140>,<2.222222,-2.215731,3.571305><-.9120,.3590,-1.0090>,<1.666667,-2.699698,.66501><-.8620,.3590,-1.0090>,<0,-5.399397,1.33002>}
 smooth_triangle {<-.8620,.3590,-1.0090>,<0,-5.399397,1.33002><-.8620,.4500,-.9140>,<0,.861405,5.694768><-.9120,.4500,-.9140>,<2.222222,-2.215731,3.571305>}
 smooth_triangle {<-.9120,.2170,-1.0090>,<3.333333,2.992243,-.975781><-.9120,.2270,-.9880>,<10,0,0><-.9120,.1260,-.9140>,<4,-2.133417,3.172334>}
 smooth_triangle {<-.9120,.2880,-.9570>,<-1.428571,2.514929,1.355875><-.9120,.2650,-.9610>,<1,0,0><-.9120,.2260,-.8420>,<2,1.441986,2.923594>}
 smooth_triangle {<-.9120,.2880,-.9570>,<-1.428571,2.514929,1.355875><-.9120,.2260,-.8420>,<2,1.441986,2.923594><-.8620,.2260,-.8420>,<0,3.604965,7.308987>}
 smooth_triangle {<-.8620,.2260,-.8420>,<0,3.604965,7.308987><-.8620,.2880,-.9570>,<0,1.760451,.949112><-.9120,.2880,-.9570>,<-1.428571,2.514929,1.355875>}
 smooth_triangle {<-.9120,.2170,-1.0090>,<3.333333,2.992243,-.975781><-.9120,.1260,-.9140>,<4,-2.133417,3.172334><-.8620,.1260,-.9140>,<0,1.832884,6.102313>}
 smooth_triangle {<-.8620,.1260,-.9140>,<0,1.832884,6.102313><-.8620,.2170,-1.0090>,<0,4.488364,-1.463672><-.9120,.2170,-1.0090>,<3.333333,2.992243,-.975781>}
 pigment {colour ALUMINIUM} finish {ambient (0.4 * AmbientFact) diffuse 0.4 reflection 0.4 metallic 0.5 phong 50}
}

#declare MASK = mesh {
 smooth_triangle {<-.192,.648,1.896>,<.949697,-5.716323,-8.093117><-.192,.48,2.016>,<.99675,-5.75405,-8.05567><.192,.48,2.016>,<-.6645,-5.773494,-8.082891>}
 smooth_triangle {<.192,.48,2.016>,<-.6645,-5.773494,-8.082891><.192,.648,1.896>,<-1.266262,-5.684304,-8.078378><-.192,.648,1.896>,<.949697,-5.716323,-8.093117>}
 smooth_triangle {<.192,.648,1.896>,<-1.266262,-5.684304,-8.078378><.192,.48,2.016>,<-.6645,-5.773494,-8.082891><.384,.48,1.968>,<-1.021858,-5.702137,-8.054464>}
 smooth_triangle {<.408,.648,1.848>,<1.864869,-4.914671,-7.618683><.384,.48,1.968>,<-1.021858,-5.702137,-8.054464><.192,.648,1.896>,<-1.266262,-5.684304,-8.078378>}
 smooth_triangle {<-.408,.648,1.848>,<-1.864869,-4.914671,-7.618683><-.384,.48,1.968>,<1.021858,-5.702137,-8.054464><-.192,.648,1.896>,<.949697,-5.716323,-8.093117>}
 smooth_triangle {<-.192,.648,1.896>,<.949697,-5.716323,-8.093117><-.384,.48,1.968>,<1.021858,-5.702137,-8.054464><-.192,.48,2.016>,<.99675,-5.75405,-8.05567>}
 smooth_triangle {<.408,.648,1.848>,<1.864869,-4.914671,-7.618683><.432,.6,1.896>,<6.666678,-3.333319,-6.666662><.432,.552,1.92>,<3.699946,-4.599601,-7.366128>}
 smooth_triangle {<.432,.552,1.92>,<3.699946,-4.599601,-7.366128><.384,.48,1.968>,<-1.021858,-5.702137,-8.054464><.408,.648,1.848>,<1.864869,-4.914671,-7.618683>}
 smooth_triangle {<-.432,.552,1.92>,<-3.699946,-4.599601,-7.366128><-.408,.648,1.848>,<-1.864869,-4.914671,-7.618683><-.384,.48,1.968>,<1.021858,-5.702137,-8.054464>}
 smooth_triangle {<-.408,.648,1.848>,<-1.864869,-4.914671,-7.618683><-.432,.6,1.896>,<-6.666678,-3.333319,-6.666662><-.432,.552,1.92>,<-3.699946,-4.599601,-7.366128>}
 pigment {colour SILVERDARK} finish {ambient (0.4 * AmbientFact) diffuse.4}
}

#declare TARGHE = union {
 mesh {
 triangle {<-.288,.696,-1.608><-.288,.552,-1.68><.288,.552,-1.68>}
 triangle {<.288,.552,-1.68><.288,.696,-1.608><-.288,.696,-1.608>}
 pigment {color Color256} finish {ambient (0.5 * AmbientFact) diffuse .7}
 }
 polygon { 5, <-.192,.48,2.016><-.192,.336,2.016><.192,.336,2.016><.192,.48,2.016><-.192,.48,2.016>
 pigment {color Color256} finish {ambient (0.5 * AmbientFact) diffuse .7}
 }
}
 
 
#declare Fari = union {
 cone {<0,-.02,0>,0,<0,.02,0>,.002 open rotate<90,0,0> translate< .6,.58,1.64> 
 pigment {colour ALUMINIUM} finish {ambient ((0.1 * AmbientFact) + ByNight) diffuse .6}}
 cone {<0,-.02,0>,0,<0,.02,0>,.002 open rotate<90,0,0> translate< -.6,.58,1.64>
 pigment {colour ALUMINIUM} finish {ambient ((0.1 * AmbientFact) + ByNight) diffuse .6}}
 light_source {< .6,.58,1.65> colour rgb (1 * ByNight)}
 light_source {<-.6,.58,1.65> colour rgb (1 * ByNight)} 
}
 

#declare MIXCAR = union {
 object {Fari}   
 object {FARIBACK} object {FARIBACK scale <-1,1,1>} 
 object {AUDIVetri}
 object {GLS_POS} object {GLS_POS scale <-1,1,1>}                    
 object {GLS_ANT} object {GLS_ANT scale <-1,1,1>}                                    
 object {MIRR} object {MIRR scale <-1,1,1>}
 object {TELAIO}
 object {MOZZI}
 object {FAROANT} object {FAROANT scale <-1,1,1>}   //riflettore
 object {SILV_SX} object {SILV_SX scale <-1,1,1>}
 object {MASK}
 object {TARGHE}
}
 
// ________________________________________________________________________________________ AUDI

#declare CARRED    = union {object {AUDICarr texture {POLIRED}}    object {MIXCAR}}
#declare CARBLUE   = union {object {AUDICarr texture {POLIBLUE}}   object {MIXCAR}} 
#declare CARYELLOW = union {object {AUDICarr texture {POLIYELLOW}} object {MIXCAR}} 
#declare CARBLACK  = union {object {AUDICarr texture {POLIBLACK}}  object {MIXCAR}} 
#declare CARGREEN  = union {object {AUDICarr texture {POLIGREEN}}  object {MIXCAR}}
#declare CARBEIGE  = union {object {AUDICarr texture {POLIBEIGE}}  object {MIXCAR}}
#declare CARWHITE  = union {object {AUDICarr texture {POLIWHITE}}  object {MIXCAR}}

// ________________________________________________________________________________________ END CAR
