/*
Crackle City
by Tek

This code has been expanded, but I've tried to leave in place a lot of the tricks I've used so you can see how they work.

This is version 7 of the scene, the code for all the earlier versions is provided in comments after this code
*/

#version 3.8;

global_settings {assumed_gamma 1}

#local A = function{ pigment { crackle solid } }
#local B = function{ pigment { crackle } }

#local Scale = 1/9;
//scale the isosurface to fit inside the unit sphere
//(the default container object).

#local MaxGradient = 99;
//bound the isosurface calculations, this number comprimises between
//precision and speed, and since speed isn't an issue I've used the
//largest 2 digit number. In truth it looks okay at about 30ish.

isosurface{
    function{
        max(
            2+y/Scale-A(x/Scale,0,z/Scale).x*4, //horizontal roofs of buildings
            .2-B(x/Scale,0,z/Scale).x    //walls of buildings.
            //.2 is the gap between buildings.
        )/MaxGradient   //adjust values to fit default max_gradient == 1
    }
    finish{
    	reflection{0,1}	//the falloff made the buildings look a lot more solid.
    }
}

fog{
    rgb <1,1.2,1.33>
    /*
    other Good fog colours.
    These completely define the appearance of the scene:
    rgb 1.2-x/3
    rgb 1.2-y/4
    rgb 1+x/2+y/6  //nice sunset feeling
    rgb 1+y/4
    rgb 1+z/4
    rgb 1-y/9-z/3
    */
    distance .7
    fog_type 2
    fog_alt.1
}

sky_sphere{
    pigment{agate}
    //the default version of this pigment is in shades orange,
    //this interacts with the fog colour and reflects on the buildings
}

//a distant hill, it will be black (default pigment)
//but the fog will shade it blue.
sphere {
    <5.4,-3.6,5.4>, 5
}



/*
old versions of the scene, I recommend looking at v1.
*/

/*
// v1 - angular and kinda grey
#macro C()function{pigment{crackle metric 1#end#local A=C()solid
}}#local B=C()}}isosurface{function{max(2+y-A(x,0,z).x*4,.3-B(x,
0,z).x)/8}contained_by{box{-9,9}}pigment{rgb 1}}global_settings{
radiosity{}ambient_light 0}plane{y,-1}sky_sphere{pigment{agate}}
*/

/*
// v2 - removed metric. less structured, but more room for other code so scaled sky to get nice sunset effect.
#macro C()function{pigment{crackle#end#local A=C()solid}}#local 
B=C()}}isosurface{function{max(2+y-A(x,0,z).x*4,.2-B(x,0,z).x)/8
}contained_by{box{-9,9}}pigment{rgb 1}}global_settings{radiosity
{}ambient_light 0}plane{y,-1}sky_sphere{pigment{agate scale 2}}
*/

/*
// v3 - optimisation of v2
#macro C()function{pigment{crackle#end#local A=C()solid}}#local 
B=C()}}isosurface{function{max(2+y*9-A(x*9,0,z*9).x*4,.2-B(x*9,0
,z*9).x)/45}pigment{rgb 1}}global_settings{radiosity{}
ambient_light 0}sky_sphere{pigment{agate scale 2}}
*/

/*
// stylised v3 - reflective buildings tinting toward a colour
// (posted on povray.binaries.images)
#macro C()function{pigment{crackle#end#local A=C()solid}}#local 
B=C()}}isosurface{function{max(2+y*9-A(x*9,0,z*9).x*4,.2-B(x*9,0
,z*9).x)/80}pigment{rgb z+y}finish{reflection{.8 metallic.1}
ambient 0}}sky_sphere{pigment{agate scale 2}}
*/

/*
// stylised v3 - nice up shot with clean chrome look
#macro C()function{pigment{crackle#end#local A=C()solid}}#local 
B=C()}}isosurface{function{max(1+y*3-A(3+x*3,0,z*3).x*4,.2-B(3+x
*3,0,z*3).x)/40}pigment{rgb z+y}finish{reflection{.8 metallic.1}
ambient 0}rotate x*30}sky_sphere{pigment{planar rotate 10}} //rotate the planar gradient so different faces are different brightnesses.
*/

/*
//v4, optimised up shot.
#macro C()function{pigment{crackle#end#local A=C()solid}}#local 
B=C()}}isosurface{function{max(1+y*3-A(3+x*3,0,z*3).x*4,.2-B(3+x
*3,0,z*3).x)/20}finish{reflection{.8-x*.08}}rotate x*30} //coloured reflections!
sky_sphere{pigment{planar}}
*/

/*
//v5, more stuff happening (fog, really nice chrome/glass style)
#macro C()function{pigment{crackle#end#local A=C()solid}}#local 
B=C()}}isosurface{function{max(2+y*9-A(x*9,0,z*9).x*4,.2-B(x*9,0
,z*9).x)/70}finish{reflection{0,1}}}background{rgb z/3+.3}
fog{rgb 1.2-x/3distance.7fog_type 2fog_alt.1}
*/

/*
//v6, some pattern changes, looks like a chemical cloud in the sky, I like :)
#macro C()function{pigment{crackle#end#local A=C()solid}}#local 
B=C()}}isosurface{function{max(2+y*9-A(x*9,0,z*9).x*4,.2-B(x*9,0
,z*9).x)/50}finish{reflection{0,1}}}fog{rgb<1,1.2,1.3>distance.7
fog_type 2fog_alt.1}sky_sphere{pigment{agate}}
*/

/*
//v7 final version. tweaked and added a hill
#macro C()function{pigment{crackle#end#local A=C()solid}}#local 
B=C()}}isosurface{function{max(2+y*9-A(x*9,0,z*9).x*4,.2-B(x*9,0
,z*9).x)/99}finish{reflection{0,1}}}fog{rgb 1+y/5+z/3distance.7
fog_type 2fog_alt.1}sky_sphere{pigment{agate}}sphere{9*(.6-y),5}
*/

/*
256 chars:
0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef
0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef
0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef
0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef
*/



/*
Well, since you've bothered to read all the way down here, here's a few notes I made on tricks for making code short:

x,y,z are equivalent to red,green,blue
x+y is shorter than <1,1,0> and == 1-z
use #macro *()<text>#end to replace repeated text if it makes it shorter ((length of text - 3)*(occurences-1) > 15)
	e.g. "sphere{" becomes shorter if there are 6 or more:
																"sphere{sphere{sphere{sphere{sphere{sphere{"
														 vs "#macro S()sphere{#end S()S()S()S()S()S()"
likewise, #default{<stuff>} is only useful if stuff is repeated such that ((length of <stuff>)*(occurences-1) > 10)
BUT can often be simplified by using union{} of everything with one <stuff> at the end (depending on how you override it)
#local is shorter than #declare
scenes dependant upon my own functions will often be shorter than ones dependant on pov functions, because I can use 1 character names!
identifier <value>, if <value> is less than one, lose the space, thus: "rgb <0.3,0.3,0.3>" => "rgb.3"
"max_gradient 10" is equivalent to wrapping the function with "("...")/10"
pov's default finish is {diffuse 0.7 ambient 0.3} so if you want something fully white you can just do rgb 4 and not specify a finish (because 0.3*4 > 1).
in some contexts, rgb is not needed before colours, e.g. light_source{y,1} = white light at <0,1,0>
stuff not to put in scenes:
	- camera{blah} scene will be 4:3 which is pov's default aspect ratio, camera sits at 0 looking along z.
*/

