/*---------------------------------------------------------------------------------------------------

                           Demonstration scene to the POVRay include file
    
                                          "geodesic.inc"               
                                          
                                               v2.0
                                          
                            Uwe Zimmermann, Stockholm, Sweden 1999
                                                         
----------------------------------------------------------------------------------------------------*/

global_settings
{
  assumed_gamma 1.0
}                                                                 

#include "colors.inc" 
#include "glass.inc"
#include "metals.inc"


#local zoom=1.5;

// ----------------------------------------
camera
{
  location  <10, 3, 10>
  direction 1.5*z
  right     4/3*x*1/zoom
  up            y*1/zoom
  look_at   <0.0, 0.0,  0.0>  
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color rgb <0.5,0.4,1>] [1.0 color blue 0.6] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color rgb <1,1,1>  // light's color
  translate <20, 20, -10>
}

light_source
{
  0*x // light's position (translated below)
  color rgb <1,1,1>*0.5  // light's color
  translate <20, -10, -10>
}

light_source
{
  0*x // light's position (translated below)
  color rgb <0.6,0.6,0.6>  // light's color
  translate <-20, 20, 10>
}
   
#default{ texture{ finish  { ambient       .1
                             diffuse       .6
                             phong         .75
                             phong_size  50
                           } 
                 }   
        }                                  
        
//------------------------------------------------------------------------------------------  
//------------------------------------------------------------------------------------------  
 
//------------------------------------------------------------------------------------------  
// Let the game begin...
//
//
   
  #include "geodesic.inc"
//------------------------------------------------------------------------------------------  
                             
//------------------------------------------------------------------------------------------  
// calculate the vertex positions - for later use!
                          
  #declare symmetry     = 5;   // use icosahedron
  #declare freq         = 1;   // don't subdivide faces into triangles                       
  #declare mode         = 1;   // use planar subdivision - doesn't matter here though

  #declare vertex_array_5_1 = geodesic(symmetry, freq, mode)  

  #declare symmetry     = 5;   // use icosahedron
  #declare freq         = 4;   // subdivide faces into 4^2=16 triangles                       
  #declare mode         = 1;   // use planar subdivision

  #declare vertex_array_5_4 = geodesic(symmetry, freq, mode)  

  #declare symmetry     = 5;   // use icosahedron
  #declare freq         = 7;   // subdivide faces into 7^2=49 triangles                       
  #declare mode         = 1;   // use planar subdivision

  #declare vertex_array_5_7 = geodesic(symmetry, freq, mode)  

  #declare symmetry     = 3;    // use tetrahedron
  #declare freq         = 15;   // subdivide faces into 15^2=225 triangles                       
  #declare mode         = 2;   // use planar subdivision

  #declare vertex_array_3_15 = geodesic(symmetry, freq, mode)  

  #declare symmetry     = 4;    // use octahedron
  #declare freq         = 10;   // subdivide faces into 10^2=100 triangles                       
  #declare mode         = 2;   // use planar subdivision

  #declare vertex_array_4_10 = geodesic(symmetry, freq, mode)  
  
//------------------------------------------------------------------------------------------  
                   
//------------------------------------------------------------------------------------------  
// first definition block for the sub-macros:
//                          
//      small red spheres at the corners

  #macro do_corner(position)
    sphere { position 0.1 }
  #end                                                          

  #macro do_edge( corner_1, corner_2 )
  #end

  #macro do_face( corner_1, corner_2, corner_3 )
  #end
//------------------------------------------------------------------------------------------  

//------------------------------------------------------------------------------------------  
                                     
  object { difference { sphere { <0,0,0> 0.93 }                                                                                               
                        geodesic_sphere ( 3, 15, vertex_array_3_15 )
                      }
           texture { pigment { color Goldenrod } 
                   } 
           translate <0,1,0>        
         }          

  //---------------------------------

  object { difference { sphere { <0,0,0> 0.93 }                                                                                               
                        geodesic_sphere ( 5, 7, vertex_array_5_7 )
                      }
           texture { pigment { color Turquoise } 
                   }
           translate <-1,-1,2>        
         }          
                      
  //---------------------------------

  object { difference { sphere { <0,0,0> 0.93 }                                                                                               
                        geodesic_sphere ( 4, 10, vertex_array_4_10 )
                      }
           texture { pigment { color SpringGreen } 
                   }
           translate <-5,1,0>        
         }          

  //---------------------------------
  // objects placed on the faces - small glas pyramides
  
  #macro do_face( corner_1, corner_2, corner_3 ) 
    #local v_M=(corner_1+corner_2+corner_3)/3;      // crossing point of the "Mittelsenkrechten"
    #local r_o=vlength(corner_1-v_M);               // radius of the outer circle
    #local c_4=(r_o+1)*v_M; 
    object { mesh { triangle {corner_1, corner_2, c_4} 
                    triangle {corner_2, corner_3, c_4} 
                    triangle {corner_3, corner_1, c_4} 
                    triangle {corner_1, corner_2, corner_3} 
                  }
             texture  { T_Ruby_Glass }                     
             interior { I_Glass }
           }  
  #end

  #macro do_edge( corner_1, corner_2 )
  #end
                        
  #macro do_corner(position)
  #end                                                          
                              
                                           
  object { geodesic_sphere ( 5, 1, vertex_array_5_1 ) 
           translate <-2,0,-7>
         }

  object { geodesic_sphere ( 5, 7, vertex_array_5_7 ) 
           translate <-1,-2.5,-8>
         }
  
  //---------------------------------     
  // displaying spheres on the faces - radius of the spheres is equal to inner radius of the faces
                        
  #macro do_face( corner_1, corner_2, corner_3 ) 
    #local v1=(corner_2-corner_1);
    #local v2=(corner_3-corner_1);
    #local v3=(corner_3-corner_2);
    #local A =vlength(vcross(v1,v2))/2;                // area of the triangle
    #local s =(vlength(v1)+vlength(v2)+vlength(v3))/2; // half sum of the triangle sides
    #local r_i=A/s;                                    // radius of the inner circle
    #local bis_a=vnormalize(vnormalize(v1)+vnormalize(v2)); // bisection of the angle at corner_1
    #local cos_a2=vdot(bis_a, vnormalize(v1));         // cos of the half angle at corner_1
    #local W = corner_1+r_i/sin(acos(cos_a2))*bis_a;   // crossing point of the angular bisections
    sphere { W r_i
             texture { pigment { color Orange } }
           }  
  #end                                                                                               
  
               
  #macro do_edge( corner_1, corner_2 )    
    cylinder { corner_1, corner_2, 0.02
               texture { pigment { color Green}}
             }
  #end
                        
  #macro do_corner(position)
  #end                                                          
                              
                                           
  object { geodesic_sphere ( 5, 1, vertex_array_5_1 ) 
           translate <-6,2,-10>
         }

  object { geodesic_sphere ( 5, 4, vertex_array_5_4 ) 
           translate <-10,2,-6>
         }

  //---------------------------------     
  // this - most realistic? - golf ball contains 482 dimples of different size at corners and faces 
  //                     of a frequency 4 icosahedron based geodesic shape
             
  #macro do_face( corner_1, corner_2, corner_3 ) 
    #local v1=(corner_2-corner_1);
    #local v2=(corner_3-corner_1);
    #local v3=(corner_3-corner_2);
    #local A =vlength(vcross(v1,v2))/2;                // area of the triangle
    #local s =(vlength(v1)+vlength(v2)+vlength(v3))/2; // half sum of the triangle sides
    #local r_i=A/s;                                    // radius of the inner circle
    #local bis_a=vnormalize(v1+v2);                    // bisection of the angle at corner_1
    #local cos_a2=vdot(bis_a, vnormalize(v1));         // cos of the half angle at corner_1
    #local W = corner_1+r_i/sin(acos(cos_a2))*bis_a;   // crossing point of the angular bisections
    sphere { W r_i }  
  #end                                                                                               
  
  #macro do_edge( corner_1, corner_2 )    
  #end
                        
  #macro do_corner(position)
    sphere { position 0.1 }  
  #end                                                          
                              
  object { difference { sphere { <0,0,0> 0.93 }                                                                                               
                        geodesic_sphere ( 5, 4, vertex_array_5_4 )
                      }
           texture { pigment { color Cyan } } 
           translate <+3,-0.5,2>        
         }          

//------------------------------------------------------------------------------------------  
                                                                        
                                          
//------------------------------------------------------------------------------------------  
/*

           ______ _        __                         __  __  __   _   
          /  _/ /( )___   / /  ___ __ _____  ___  ___/ / / /_/ /  (_)__
         _/ // __//(_-<  / _ \/ -_) // / _ \/ _ \/ _  / / __/ _ \/ (_-<
        /___/\__/ /___/ /_.__/\__/\_, /\___/_//_/\_,_/  \__/_//_/_/___/
                                 /___/                                 
                      _      __           __                 __  __             
           ___  ___  (_)__  / /_  _    __/ /  ___ _______    \ \/ /__  __ ______
          / _ \/ _ \/ / _ \/ __/ | |/|/ / _ \/ -_) __/ -_)    \  / _ \/ // / __/
         / .__/\___/_/_//_/\__/  |__,__/_//_/\__/_/  \__/     /_/\___/\_,_/_/   
        /_/                                                                     
                 __             __                      __           __         ______
           ___  / /  ___ ____  / /____ ____ __ __  ___ / /____ _____/ /____    / / / /
          / _ \/ _ \/ _ `/ _ \/ __/ _ `(_-</ // / (_-</ __/ _ `/ __/ __(_-<   /_/_/_/ 
         / .__/_//_/\_,_/_//_/\__/\_,_/___/\_, / /___/\__/\_,_/_/  \__/___/  (_|_|_)  
        /_/                               /___/                                       
                                                                
                                                                                             */                                                                                           