// 
//
//  using  geodesic.inc  make 3 arrays :: Vectors, Faces and Edges and Save to file
// 
//  12:47:56 PM  Monday March 01,2021 
// Vers: 3.7
// Auth: Leroy Whetstone 
// Email whetstoneleroy@gmail.com
// screen size 640*480

//====================================================================
#version 3.7;
global_settings {assumed_gamma 1 max_trace_level 20}

#include "colors.inc"
#include "geodesic.inc"

//-------------- Change ----------------------------------------------------------------------------  

  #declare symmetry     = 4;  //  use 3,4,5
  #declare freq         = 5;  //  >= 1 frame_number;   // subdivide faces into triangles                       
  #declare mode         = 1;   // 1,2 1=planar 2=spherical subdivision

  #declare FileName="";//TestData2.inc

  #declare Remark="A very big Boy";

//--------------End of Changes ----------------------------------------------------------------------------  

  #declare ArrayPrefix="Data"; // prefix for 'Vectors' & 'Faces' & 'Edges' array's names


camera{ location <0,0,-10>
        look_at <0,0,0>
        right x*image_width/image_height
        }
 light_source{<0,10,-20> color White parallel point_at 0}
 light_source{<0,-10,-20> color White parallel point_at 0}

sky_sphere {pigment{gradient y color_map { [0.0 color rgb <0.6,0.4,1>] [1.0 color blue 0.6] } }}
   
#default{ texture{ finish  { ambient       .1
                             diffuse       .6
                             phong         .75
                             phong_size  50
                           } 
                 }   
        }                                  
        
 
//-----------Let the game begin --------------------------------------------------------------------------  
   
//  #include "LR_Mod_geodesic.inc"
  #include "geodesic.inc" 
  
//------------------------------------------------------------------------------------------  
#declare Tc=freq*freq;
#if(symmetry=3) #declare Vc=2*Tc+2; #declare Fc=4*Tc;#declare Ec=6*Tc; #end
#if(symmetry=4) #declare Vc=4*Tc+2; #declare Fc=8*Tc;#declare Ec=12*Tc; #end
#if(symmetry=5) #declare Vc=10*Tc+2; #declare Fc=20*Tc;#declare Ec=30*Tc; #end
#debug concat("symmetry = ",str(symmetry,0,0),"\n")                             
#debug concat("Vc =",str(Vc,0,0),"  ")                             
#debug concat("Fc =",str(Fc,0,0),"  ")                             
#debug concat("Ec =",str(Ec,0,0),"\n")                             


//---------------------Save it---------------------------------------------------------------------  
// calculate the vertex positions

  #declare vertex_array = geodesic(symmetry, freq, mode)  

  #declare Lt=dimension_size(vertex_array,1);
  #declare Lu=dimension_size(vertex_array,2);

  #declare C=0;
  #for(i,0,Lt-1)
   #for(j,0,Lu-1)
    #ifdef(vertex_array[i][j]) #declare C=C+1; #end
    #end
   #end
   #debug concat("Def vertexes =",str(C,0,0)," in "str(Lt,0,0),"*",str(Lu,0,0)" array \n") 

  #declare Mpnts=array[C];
  #declare D=0;
  #for(i,0,Lt-1)
   #for(j,0,Lu-1)
    #ifdef(vertex_array[i][j]) 
       //#if(C=2) #debug concat("I,J = ",str(i,0,0),",",str(j,0,0)"\n") #end
      #declare Mpnts[D]=vertex_array[i][j]; #declare D=D+1; 
      //sphere{vertex_array[i][j]*2,.05 pigment{rgb<1,0,0>}}
    //#debug concat("K =<",vstr(3,Mpnts[D-1],",",0,4),">\n")
    #end
   #end
  #end
 //kill doubles
 #declare K=C; 
 #for(D,0,C-1)
  #if(vlength(Mpnts[D]))
   #for(E,C-1,D+1,-1)
    #if(vlength(Mpnts[D]-Mpnts[E])=0) #declare Mpnts[E]=<0,0,0>; #declare K=K-1;#end
   #end
  #end
 #end

 #declare Npnts=array[K];//#debug concat("K =",str(K,0,0),"\n")

 //recount
 #declare K=0;
 #for(D,0,C-1)
  #if(vlength(Mpnts[D])) #declare Npnts[K]=Mpnts[D];  #declare K=K+1;
     //#debug concat("K =<",vstr(3,Mpnts[D],",",0,4),">\n") 
  #end
 #end 
 //#debug concat("K =",str(K,0,0),"\n")

 //Save
 #if(strlen(FileName)) 
  #fopen Mfile FileName write
   #write(Mfile,"\n//",Remark,"\n")
   #write(Mfile,"//GEO data :: symmetry=",symmetry," freq=",freq," mode=",mode,"\n\n") 
  #write(Mfile,"#declare ",ArrayPrefix,"_Vectors = array[",K,"]{\n  ") 
   #declare Ew=0;
   #for(D,0,K-1)
      //#if(vlength(Mpnts[D])=1)
       #if(D<K-1) #write(Mfile,"<",vstr(3,Npnts[D],",",3,4),">,") 
       #else      #write(Mfile,"<",vstr(3,Npnts[D],",",3,4),">\n") 
       #end
      #declare Ew=Ew+1;#if(Ew=4) #write(Mfile,"\n  ") #declare Ew=0; #end
      //#end 
   #end   
  #write(Mfile,"}\n") 
//  #fclose Mfile
 
  //#debug concat("D =",str(D,0,0),"\n") 
  
 #end


//---------------------Show IT---------------------------------------------------------------------  
// first definition block for the sub-macros:
//                          
//      small red spheres at the corners

  #macro do_corner(position)
    sphere { position 0.03 texture { pigment { color rgb <1,0,0> } } }
  #end                                                          

//      blue cylinders at the edges ( between each pair of corners )
  #declare EdgeR=array[Ec][2];
  #macro do_edge( corner_1, corner_2 )
   #declare EdgeR[EC][0]=corner_1;
   #declare EdgeR[EC][1]=corner_2;
   #declare EC=EC+1;
   // cylinder { corner_1, corner_2, 0.02 texture { pigment { color rgb <0,0,1> } } }
  #end


//  Make Face Array using the geodesic_sphere macro  
  
  #declare FaceR=array[Fc][3];

  #macro do_face( corner_1, corner_2, corner_3 )
    //#if(mod(FC,3)=0) 
     triangle { corner_1, corner_2, corner_3 texture { pigment { color rgb <0.5,0.7,0.2> } } }
      #declare FaceR[FC][0]=corner_1;
      #declare FaceR[FC][1]=corner_2;
      #declare FaceR[FC][2]=corner_3;
     //#debug concat(str(FC,0,0),", <",vstr(3,corner_1,",",3,3),"> ")
     //#debug concat(", <",vstr(3,corner_2,",",3,3),"> ")
     //#debug concat(", <",vstr(3,corner_3,",",3,3),">\n")
    //#end
    #declare FC=FC+1;
  #end

//------------------------------------------------------------------------------------------  

//------------------------------------------------------------------------------------------  
// let's do the geodesic sphere  & blow it up by a factor of two

  #declare FC=0;#declare EC=0;                                                                                            
  object { geodesic_sphere ( symmetry, freq, vertex_array ) rotate -y*0 scale <2,2,2> }                                                                                               
  //#debug concat("\nFaces =",str(FC,0,0),"\n") 
    

//----------------------------Save Face----------------------------------------------

#macro CkVec(V1,V2,V3)
 #local Test=0;
 #local i=0;
 #while(Test<3)
  #if(vlength(V1-Npnts[i])=0) #local a1=i; #local Test=Test+1; #end
  #if(vlength(V2-Npnts[i])=0) #local a2=i; #local Test=Test+1; #end
  #if(vlength(V3-Npnts[i])=0) #local a3=i; #local Test=Test+1; #end
  #local i=i+1; //#debug concat("I =",str(i,0,0),"\n")
 #end
 #local Out=<a1,a2,a3>;
 Out
#end

#declare Face=array[Fc];
#for(n,0,Fc-1)
  #declare Face[n]=CkVec(FaceR[n][0],FaceR[n][1],FaceR[n][2]);
#end  

 #if(strlen(FileName)) 
  #write(Mfile,"\n#declare ",ArrayPrefix,"_Faces = array[",Fc,"]{\n") 
  #declare Ew=0;
   #for(n,0,Fc-1)
      //#if(vlength(Mpnts[D])=1)
       #if(n<Fc-1) #write(Mfile,"<",vstr(3,Face[n],",",0,0),">,") 
       #else      #write(Mfile,"<",vstr(3,Face[n],",",0,0),">\n") 
       #end
      #declare Ew=Ew+1;#if(Ew=6) #write(Mfile,"\n  ") #declare Ew=0; #end
      //#end 
   #end   
  #write(Mfile,"}\n") 
//  #fclose Mfile
 
 #end
/*
#for(n,0,Fc-1)
  #debug concat("VI= <",vstr(3,Face[n],",",0,0),">\n")
#end  
*/

#macro CkVec2(V1,V2)
 #local Test=0;
 #local i=0;
 #while(Test<2)
  #if(vlength(V1-Npnts[i])=0) #local a1=i; #local Test=Test+1; #end
  #if(vlength(V2-Npnts[i])=0) #local a2=i; #local Test=Test+1; #end
  #local i=i+1; //#debug concat("I =",str(i,0,0),"\n")
 #end
 #local Out=<a1,a2>;
 Out
#end

#declare Edge=array[Ec];

#for(n,0,Ec-1)
  #declare Edge[n]=CkVec2(EdgeR[n][0],EdgeR[n][1]);
#end  

 #if(strlen(FileName)) 
  #write(Mfile,"\n#declare ",ArrayPrefix,"_Edges = array[",Ec,"]{\n  ") 
  #declare Ew=0;
   #for(n,0,Ec-1)
      //#if(vlength(Mpnts[D])=1)
       #if(n<Ec-1) #write(Mfile,"<",vstr(2,Edge[n],",",0,0),">,") 
       #else      #write(Mfile,"<",vstr(2,Edge[n],",",0,0),">\n") 
       #end
      #declare Ew=Ew+1;#if(Ew=10) #write(Mfile,"\n  ") #declare Ew=0; #end
      //#end 
   #end   
  #write(Mfile,"}\n") 
//  #fclose Mfile
 
 #end

//-------------------------Junk-----------------------------------------------------------------  
//  #declare i=(3*freq+1)*(5*freq);
//  #debug concat("I =",str(i,0,0),"\n") 
  //LR_Save_Pnts("TestData.inc")
  
  
//         T= freq^2
//symmetry  3        4       5 
//vertex   2*T+2   4*T+2   10*T+2
//faces    20*T    8*T     4*T
//Edgs     30*T    12*T    6*T
                              
                              
  