/*---------------------------------------------------------------------------------------------------

                           Demonstration scene to the POVRay include file
    
                                          "geodesic.inc"               
                                          
                                               v2.0
                                          
                                                         Uwe Zimmermann, Stockholm, Sweden 1999
                                                         
----------------------------------------------------------------------------------------------------*/

global_settings
{
  assumed_gamma 1.0
}

#local zoom=1.5;

// ----------------------------------------
camera
{
  location  <0, 0, -15>
  direction 1.5*z
  right     4/3*x*1/zoom
  up            y*1/zoom
  look_at   <0.0, 0.0,  0.0>  
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color rgb <0.6,0.4,1>] [1.0 color blue 0.6] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color rgb <1,1,1>  // light's color
  translate <20, 20, -40>
}

light_source
{
  0*x // light's position (translated below)
  color rgb <0.6,0.6,0.6>  // light's color
  translate <-20, -20, -30>
}
   
#default{ texture{ finish  { ambient       .1
                             diffuse       .6
                             phong         .75
                             phong_size  50
                           } 
                 }   
        }                                  
        
//------------------------------------------------------------------------------------------  
//------------------------------------------------------------------------------------------  
 
//------------------------------------------------------------------------------------------  
// Let the game begin...
//
//
   
  #include "geodesic.inc"
//------------------------------------------------------------------------------------------  
// the clock value determines the frequency of subdivision                                    
  
//#declare freq=int(clock+0.01); 
#declare freq=5; 

//------------------------------------------------------------------------------------------  
// calculate the vertex positions

  #declare symmetry_a   = 3;      // use tetrahedron
  #declare freq_a       = freq;   // subdivide faces

  #declare vertex_array_a1 = geodesic(symmetry_a, freq_a, 1)  
  #declare vertex_array_a2 = geodesic(symmetry_a, freq_a, 2)  

  #declare symmetry_b   = 4;      // use tetrahedron
  #declare freq_b       = freq;   // subdivide faces

  #declare vertex_array_b1 = geodesic(symmetry_b, freq_b, 1)  
  #declare vertex_array_b2 = geodesic(symmetry_b, freq_b, 2)  

  #declare symmetry_c   = 5;      // use tetrahedron
  #declare freq_c       = freq;   // subdivide faces

  #declare vertex_array_c1 = geodesic(symmetry_c, freq_c, 1)  
  #declare vertex_array_c2 = geodesic(symmetry_c, freq_c, 2)  
//------------------------------------------------------------------------------------------  
  
//------------------------------------------------------------------------------------------  
// first definition block for the sub-macros:
//                          
//      small red spheres at the corners

  #macro do_corner(position)
    sphere { position 0.02 texture { pigment { color rgb <1,0,0> } } }
  #end                                                          

//      blue cylinders at the edges ( between each pair of corners )
  
  #macro do_edge( corner_1, corner_2 )       
    cylinder { corner_1, corner_2, 0.01 texture { pigment { color rgb <0,0,1> } } }
  #end

//      transparent, slightly greenish faces
  
  #macro do_face( corner_1, corner_2, corner_3 )
    //triangle { corner_1, corner_2, corner_3 texture { pigment { color rgbf <0.4,0.9,0.4,0.8> } } }
  #end
//------------------------------------------------------------------------------------------  

//------------------------------------------------------------------------------------------  
// let's get our first geodesic sphere
//      blow it up by a factor of two (i.e. the radius of the sphere will be 2 afterwards)
//      and shift it by the vector <2,2,2> from the origin
                                                                                              
  object { geodesic_sphere ( symmetry_a, freq_a, vertex_array_a1 ) scale 1 translate <-2.5,1.5,0> }       
  object { geodesic_sphere ( symmetry_a, freq_a, vertex_array_a2 ) scale 1 translate <-2.5,-1.5,0> }                                                                                               
                                  
  object { geodesic_sphere ( symmetry_b, freq_b, vertex_array_b1 ) scale 1 translate <0,1.5,0> }       
  object { geodesic_sphere ( symmetry_b, freq_b, vertex_array_b2 ) scale 1 translate <0,-1.5,0> }                                                                                               

  object { geodesic_sphere ( symmetry_c, freq_c, vertex_array_c1 ) scale 1 translate <2.5,1.5,0> }       
  object { geodesic_sphere ( symmetry_c, freq_c, vertex_array_c2 ) scale 1 translate <2.5,-1.5,0> }                                                                                               
  
  text { ttf "arial.ttf" concat("mode=1, freq=",str(freq,5,0)) 1, 0
         texture { pigment { color rgb <1,0.7,0> } }
         scale <0.5,0.5,0.5>
         translate <-3,2.8,0>
       }
  text { ttf "arial.ttf" concat("mode=2, freq=",str(freq,5,0)) 1, 0
         texture { pigment { color rgb <1,0.7,0> } }
         scale <0.5,0.5,0.5>
         translate <-3,-0.2,0>
       }
//--------------------
  text { ttf "arial.ttf" "3" 1, 0
         texture { pigment { color rgb <1,1,1> }
                   finish  { ambient 1 }
                 }  
         scale <0.5,0.5,0.1>
         translate <-2.7,1.3,0>
       }
  text { ttf "arial.ttf" "4" 1, 0
         texture { pigment { color rgb <1,1,1> }
                   finish  { ambient 1 }
                 }  
         scale <0.5,0.5,0.1>
         translate <-0.2,1.3,0>
       }
  text { ttf "arial.ttf" "5" 1, 0
         texture { pigment { color rgb <1,1,1> }
                   finish  { ambient 1 }
                 }  
         scale <0.5,0.5,0.1>
         translate <2.3,1.3,0>
       }
//--------------------
  text { ttf "arial.ttf" "3" 1, 0
         texture { pigment { color rgb <1,1,1> }
                   finish  { ambient 1 }
                 }  
         scale <0.5,0.5,0.1>
         translate <-2.7,-1.7,0>
       }
  text { ttf "arial.ttf" "4" 1, 0
         texture { pigment { color rgb <1,1,1> }
                   finish  { ambient 1 }
                 }  
         scale <0.5,0.5,0.1>
         translate <-0.2,-1.7,0>
       }
  text { ttf "arial.ttf" "5" 1, 0
         texture { pigment { color rgb <1,1,1> }
                   finish  { ambient 1 }
                 }  
         scale <0.5,0.5,0.1>
         translate <2.3,-1.7,0>
       }

//------------------------------------------------------------------------------------------  
                                                                        
                                          
//------------------------------------------------------------------------------------------  
/*

           ______ _        __                         __  __  __   _   
          /  _/ /( )___   / /  ___ __ _____  ___  ___/ / / /_/ /  (_)__
         _/ // __//(_-<  / _ \/ -_) // / _ \/ _ \/ _  / / __/ _ \/ (_-<
        /___/\__/ /___/ /_.__/\__/\_, /\___/_//_/\_,_/  \__/_//_/_/___/
                                 /___/                                 
                      _      __           __                 __  __             
           ___  ___  (_)__  / /_  _    __/ /  ___ _______    \ \/ /__  __ ______
          / _ \/ _ \/ / _ \/ __/ | |/|/ / _ \/ -_) __/ -_)    \  / _ \/ // / __/
         / .__/\___/_/_//_/\__/  |__,__/_//_/\__/_/  \__/     /_/\___/\_,_/_/   
        /_/                                                                     
                 __             __                      __           __         ______
           ___  / /  ___ ____  / /____ ____ __ __  ___ / /____ _____/ /____    / / / /
          / _ \/ _ \/ _ `/ _ \/ __/ _ `(_-</ // / (_-</ __/ _ `/ __/ __(_-<   /_/_/_/ 
         / .__/_//_/\_,_/_//_/\__/\_,_/___/\_, / /___/\__/\_,_/_/  \__/___/  (_|_|_)  
        /_/                               /___/                                       
                                                                
                                                                                             */                                                                                           