/*---------------------------------------------------------------------------------------------------

                           Demonstration scene to the POVRay include file
    
                                          "geodesic.inc"               
                                          
                                               v2.0
                                          
                                                         Uwe Zimmermann, Stockholm, Sweden 1999
                                                         
----------------------------------------------------------------------------------------------------*/

global_settings
{
  assumed_gamma 1.0
}

#local zoom=1.5;

// ----------------------------------------
camera
{
  location  <10, 0, -15>
  direction 1.5*z
  right     4/3*x*1/zoom
  up            y*1/zoom
  look_at   <0.0, 0.0,  0.0>  
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color rgb <0.6,0.4,1>] [1.0 color blue 0.6] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color rgb <1,1,1>  // light's color
  translate <20, 20, -10>
}

light_source
{
  0*x // light's position (translated below)
  color rgb <0.6,0.6,0.6>  // light's color
  translate <-20, 20, 10>
}
   
#default{ texture{ finish  { ambient       .1
                             diffuse       .6
                             phong         .75
                             phong_size  50
                           } 
                 }   
        }                                  
        
//------------------------------------------------------------------------------------------  
//------------------------------------------------------------------------------------------  
 
//------------------------------------------------------------------------------------------  
// Let the game begin...
//
//
   
  #include "geodesic.inc"
//------------------------------------------------------------------------------------------  
                             
//------------------------------------------------------------------------------------------  
// calculate the vertex positions

  #declare symmetry     = 4;   // use octahedron
  #declare freq         = 5;   // subdivide faces into 5^2=25 triangles                       
  #declare mode         = 2;   // use spherical subdivision

  #declare vertex_array = geodesic(symmetry, freq, mode)  
//------------------------------------------------------------------------------------------  
  
//------------------------------------------------------------------------------------------  
// first definition block for the sub-macros:
//                          
//      small red spheres at the corners

  #macro do_corner(position)
    sphere { position 0.03 texture { pigment { color rgb <1,0,0> } } }
  #end                                                          

//      blue cylinders at the edges ( between each pair of corners )
  
  #macro do_edge( corner_1, corner_2 )
    cylinder { corner_1, corner_2, 0.02 texture { pigment { color rgb <0,0,1> } } }
  #end

//      transparent, slightly greenish faces
  
  #macro do_face( corner_1, corner_2, corner_3 )
    triangle { corner_1, corner_2, corner_3 texture { pigment { color rgbf <0.4,0.9,0.4,0.8> } } }
  #end
//------------------------------------------------------------------------------------------  

//------------------------------------------------------------------------------------------  
// let's get our first geodesic sphere
//      blow it up by a factor of two (i.e. the radius of the sphere will be 2 afterwards)
//      and shift it by the vector <2,2,2> from the origin
                                                                                              
  object { geodesic_sphere ( symmetry, freq, vertex_array ) scale <2,2,2> translate <2,2,2> }                                                                                               
//------------------------------------------------------------------------------------------  
                                                                        
//------------------------------------------------------------------------------------------  
// second definition block for the sub-macros:
//                          
//      just use yellow faces for the creation of a mesh object (predefine the mesh texture)

  #declare mesh_texture = texture { pigment { color rgb <1,1,0> } }                                                                        
  #macro do_face( corner_1, corner_2, corner_3 )
    triangle { corner_1, corner_2, corner_3 texture { mesh_texture } }
  #end
//------------------------------------------------------------------------------------------  

//------------------------------------------------------------------------------------------  
// our first geodesic mesh
//      blow it up by a factor of two (i.e. the radius of the sphere will be 2 afterwards)
//      and shift it by the vector <-2,-2,-2> from the origin

  object { geodesic_mesh ( symmetry, freq, vertex_array ) scale <2,2,2> translate <-2,-2,2> }                                                                                               
//------------------------------------------------------------------------------------------  

//------------------------------------------------------------------------------------------  
// third definition block for the sub-macros:
//                          
//      let's do something weird with these corners

  #macro do_corner(position)
    cylinder { <0,0,0> position 0.01 texture { pigment { color rgb <1,0,0> } } }
    sphere   { 0.5*position 0.03 texture { pigment { color rgb <1,1,0> } } }
  #end                                                          
  
//      no objects at the edges, please

  #macro do_edge( corner_1, corner_2 )
  #end
  
//      and no objects on the faces, either

  #macro do_face( corner_1, corner_2, corner_3 )
  #end
//------------------------------------------------------------------------------------------  

//------------------------------------------------------------------------------------------  
// here comes the third object for our scene
//      blow it up by a factor of two (i.e. the radius of the sphere will be 2 afterwards)
//      and shift it by the vector <-2,2,-2> from the origin
                                                                                              
  object { geodesic_sphere ( symmetry, freq, vertex_array ) scale <2,2,2> translate <-2,2,-2> }                                                                                               
//------------------------------------------------------------------------------------------  
                                                                                           
//------------------------------------------------------------------------------------------  
// fourth definition block for the sub-macros:
//                          
//      no corners

  #macro do_corner(position)
  #end                                                          
  
//      no objects at the edges, please

  #macro do_edge( corner_1, corner_2 )
  #end
  
//      but colorful faces
                                                  
  #declare rnd=seed(1);
  #macro do_face( corner_1, corner_2, corner_3 )
    triangle { corner_1, corner_2, corner_3 texture { pigment { color rgb <int(rand(rnd)+0.5), int(rand(rnd)+0.5), int(rand(rnd)+0.5)> } } }
  #end
//------------------------------------------------------------------------------------------  


//------------------------------------------------------------------------------------------  
// here we show other possible spheres

  #declare vertex_array = geodesic(3,1,1)  
  object { geodesic_sphere ( 3,1, vertex_array ) translate <-4,-2,-2> }                                                                                               

  #declare vertex_array = geodesic(4,1,1)  
  object { geodesic_sphere ( 4,1, vertex_array ) translate <0,3,0> }                                                                                               

  #declare vertex_array = geodesic(5,1,1)  
  object { geodesic_sphere ( 5,1, vertex_array ) translate <-3,-3,-1> }                                                                                               

  #declare vertex_array = geodesic(3,2,1)  
  object { geodesic_sphere ( 3,2, vertex_array ) translate <3,-1,3> }                                                                                               

  #declare vertex_array = geodesic(4,2,1)  
  object { geodesic_sphere ( 4,2, vertex_array ) translate 2/3*<3,-4,4> }                                                                                               

  #declare vertex_array = geodesic(5,2,1)  
  object { geodesic_sphere ( 5,2, vertex_array ) translate <-5,0,-1> }                                                                                               
//------------------------------------------------------------------------------------------  
                                       
//------------------------------------------------------------------------------------------  
// finally something special

  #macro do_edge( corner_1, corner_2 )
    cylinder { corner_1, corner_2, 0.002 texture { pigment { color rgb <0,0.5,0> } } }
  #end

  #macro do_face( corner_1, corner_2, corner_3 )
    #if (rand(rnd)>0.5)
      triangle { corner_1, corner_2, corner_3 texture { pigment { color rgb <0,0,0> }
                                                        finish { reflection 1.0 ambient 0 diffuse 0 } } } 
    #end  
  #end  
  
  #declare vertex_array = geodesic(5,11,1)  
  object { geodesic_sphere ( 5,11, vertex_array ) scale <35,35,35> }                                                                                               
                                                     
//------------------------------------------------------------------------------------------  
                                          
                                          
//------------------------------------------------------------------------------------------  
/*

           ______ _        __                         __  __  __   _   
          /  _/ /( )___   / /  ___ __ _____  ___  ___/ / / /_/ /  (_)__
         _/ // __//(_-<  / _ \/ -_) // / _ \/ _ \/ _  / / __/ _ \/ (_-<
        /___/\__/ /___/ /_.__/\__/\_, /\___/_//_/\_,_/  \__/_//_/_/___/
                                 /___/                                 
                      _      __           __                 __  __             
           ___  ___  (_)__  / /_  _    __/ /  ___ _______    \ \/ /__  __ ______
          / _ \/ _ \/ / _ \/ __/ | |/|/ / _ \/ -_) __/ -_)    \  / _ \/ // / __/
         / .__/\___/_/_//_/\__/  |__,__/_//_/\__/_/  \__/     /_/\___/\_,_/_/   
        /_/                                                                     
                 __             __                      __           __         ______
           ___  / /  ___ ____  / /____ ____ __ __  ___ / /____ _____/ /____    / / / /
          / _ \/ _ \/ _ `/ _ \/ __/ _ `(_-</ // / (_-</ __/ _ `/ __/ __(_-<   /_/_/_/ 
         / .__/_//_/\_,_/_//_/\__/\_,_/___/\_, / /___/\__/\_,_/_/  \__/___/  (_|_|_)  
        /_/                               /___/                                       
                                                                
                                                                                             */                                                                                           