// Created by 3DCrafter
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
 
background { color rgb <0.00E+00, 0.00E+00, 0.00E+00> }
 
camera {
  location <1.070625E+02, 1.685153E+01, -3.854065E+01>
  direction <-9.971004E-01, -7.42429E-02, 1.669604E-02>
  up <-7.427786E-02, 9.972365E-01, -1.482988E-03>
  right <2.205306E-02, 3.625112E-03, 1.333146E+00>
  sky <-7.427786E-02, 9.972365E-01, -1.482988E-03>
  look_at <1.060654E+02, 1.677728E+01, -3.852395E+01>
  angle 5.31301E+01
}  

// adding a photon{} block to global_settings activates photon mapping.
// photons also need to be adjusted for light sources and objects.
global_settings {
  photons {
    spacing 0.01                 // specify the density of photons
    //count 100000               // alternatively use a total number of photons

    //gather min, max            // amount of photons gathered during render [20, 100]
    //media max_steps [,factor]  // media photons
    //jitter 1.0                 // jitter phor photon rays
    //max_trace_level 5          // optional separate max_trace_level
    //adc_bailout 1/255          // see global adc_bailout
    //save_file "filename"       // save photons to file
    //load_file "filename"       // load photons from file
    //autostop 0                 // photon autostop option
    //radius 10                  // manually specified search radius
    // (---Adaptive Search Radius---)
    //steps 1
    //expand_thresholds 0.2, 40
  }
}

#default{ finish{ ambient 0 diffuse 1 }} 

// radiosity (global illumination) settings
global_settings {
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 1600                     // higher -> higher quality (1..1600) [35]
    nearest_count 10              // higher -> higher quality (1..10) [5]
    error_bound 1.0               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 0.5                 // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    //normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
}
                    
                    

                    
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.6
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.6;

#include "colors.inc"

global_settings {
  assumed_gamma 3.0
}



// ----------------------------------------

light_source {
  <200,50,150>       // light's position
  color rgb 1.3       // light's color
  photons {           // photon block for a light source
    refraction on
    reflection on
  }
}



// ----------------------------------------  

// ----------------------------------------

light_source {
  <-200,-50,250>       // light's position
  color rgb 1.3       // light's color
  photons {           // photon block for a light source
    refraction on
    reflection on
  }
} 

// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <25, 20, -45>
  // light_source { ...
  // put this inside a light_source to add light fading
  fade_distance 12
  fade_power 2
  shadowless

}    

// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <25, 20, 45>
  // light_source { ...
  // put this inside a light_source to add light fading
  fade_distance 11
  fade_power 2
  shadowless

}
 
#declare Tex0 =
texture {
   pigment {rgbf <0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00>}
   finish {ambient 0.00E+00 diffuse 4.80E-01 brilliance 1.00E+00 reflection 2.00E-01}
}
 
// ReflectivePlane
mesh2 {
 
   vertex_vectors { 
      8, 
      <2.483158E+03, -4.999638E-04, 2.491244E+03>,
      <2.483158E+03, 5.000234E-04, 2.491244E+03>,
      <-2.516842E+03, 5.000234E-04, 2.491242E+03>,
      <-2.516842E+03, -4.999638E-04, 2.491242E+03>,
      <-2.51684E+03, -4.999638E-04, -2.508758E+03>,
      <-2.51684E+03, 5.000234E-04, -2.508758E+03>,
      <2.48316E+03, 5.000234E-04, -2.508756E+03>,
      <2.48316E+03, -4.999638E-04, -2.508756E+03>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex0}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
#declare Tex1 =
texture {
   pigment {rgbf <8.431373E-01, 7.843137E-01, 9.254902E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// Rail1
mesh2 {
 
   vertex_vectors { 
      8, 
      <-1.107968E+00, 1.0498E+00, 3.909459E+01>,
      <-1.107968E+00, 1.4566E+00, 3.909459E+01>,
      <-1.600072E+00, 1.4566E+00, 3.909459E+01>,
      <-1.600072E+00, 1.0498E+00, 3.909459E+01>,
      <-1.600019E+00, 1.0498E+00, -1.215335E+02>,
      <-1.600019E+00, 1.4566E+00, -1.215335E+02>,
      <-1.107916E+00, 1.4566E+00, -1.215335E+02>,
      <-1.107916E+00, 1.0498E+00, -1.215335E+02>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, 2.847209E-16, 1.00E+00>,
      <3.258414E-07, -2.847209E-16, -1.00E+00>,
      <-1.00E+00, 1.104932E-16, -3.258414E-07>,
      <1.00E+00, -1.104932E-16, 3.258414E-07>,
      <-1.104933E-16, 1.00E+00, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex1}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Rail2
mesh2 {
 
   vertex_vectors { 
      8, 
      <4.092433E+00, 1.0498E+00, 3.909459E+01>,
      <4.092433E+00, 1.4566E+00, 3.909459E+01>,
      <3.60033E+00, 1.4566E+00, 3.909459E+01>,
      <3.60033E+00, 1.0498E+00, 3.909459E+01>,
      <3.600382E+00, 1.0498E+00, -1.215335E+02>,
      <3.600382E+00, 1.4566E+00, -1.215335E+02>,
      <4.092485E+00, 1.4566E+00, -1.215335E+02>,
      <4.092485E+00, 1.0498E+00, -1.215335E+02>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, 2.847209E-16, 1.00E+00>,
      <3.258414E-07, -2.847209E-16, -1.00E+00>,
      <-1.00E+00, 1.104932E-16, -3.258414E-07>,
      <1.00E+00, -1.104932E-16, 3.258414E-07>,
      <-1.104933E-16, 1.00E+00, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex1}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
#declare Tex2 =
texture {
   pigment {rgbf <8.901961E-01, 8.196079E-01, 8.392157E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// Tie1
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868511E+00, 4.698E-01, 3.810314E+01>,
      <5.868511E+00, 1.0498E+00, 3.810314E+01>,
      <-3.131495E+00, 1.0498E+00, 3.810314E+01>,
      <-3.131495E+00, 4.698001E-01, 3.810314E+01>,
      <-3.131494E+00, 4.698001E-01, 3.727314E+01>,
      <-3.131494E+00, 1.0498E+00, 3.727314E+01>,
      <5.868511E+00, 1.0498E+00, 3.727314E+01>,
      <5.868511E+00, 4.698E-01, 3.727314E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie2
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.86851E+00, 4.698001E-01, 3.610314E+01>,
      <5.86851E+00, 1.0498E+00, 3.610314E+01>,
      <-3.131494E+00, 1.0498E+00, 3.610314E+01>,
      <-3.131494E+00, 4.698001E-01, 3.610314E+01>,
      <-3.131494E+00, 4.698001E-01, 3.527314E+01>,
      <-3.131494E+00, 1.0498E+00, 3.527314E+01>,
      <5.86851E+00, 1.0498E+00, 3.527314E+01>,
      <5.86851E+00, 4.698001E-01, 3.527314E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie3
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868512E+00, 4.698001E-01, 3.410314E+01>,
      <5.868512E+00, 1.0498E+00, 3.410314E+01>,
      <-3.131493E+00, 1.0498E+00, 3.410314E+01>,
      <-3.131493E+00, 4.698001E-01, 3.410314E+01>,
      <-3.131493E+00, 4.698001E-01, 3.327314E+01>,
      <-3.131493E+00, 1.0498E+00, 3.327314E+01>,
      <5.868513E+00, 1.0498E+00, 3.327314E+01>,
      <5.868513E+00, 4.698001E-01, 3.327314E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie4
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868511E+00, 4.698001E-01, 3.210314E+01>,
      <5.868511E+00, 1.0498E+00, 3.210314E+01>,
      <-3.131493E+00, 1.0498E+00, 3.210314E+01>,
      <-3.131493E+00, 4.698E-01, 3.210314E+01>,
      <-3.131492E+00, 4.698E-01, 3.127314E+01>,
      <-3.131492E+00, 1.0498E+00, 3.127314E+01>,
      <5.868511E+00, 1.0498E+00, 3.127315E+01>,
      <5.868511E+00, 4.698E-01, 3.127315E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie5
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868512E+00, 4.698E-01, 3.010315E+01>,
      <5.868512E+00, 1.0498E+00, 3.010315E+01>,
      <-3.131492E+00, 1.0498E+00, 3.010314E+01>,
      <-3.131492E+00, 4.698001E-01, 3.010314E+01>,
      <-3.131492E+00, 4.698001E-01, 2.927314E+01>,
      <-3.131492E+00, 1.0498E+00, 2.927314E+01>,
      <5.868512E+00, 1.0498E+00, 2.927315E+01>,
      <5.868512E+00, 4.698001E-01, 2.927315E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie6
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868511E+00, 4.698001E-01, 2.810315E+01>,
      <5.868511E+00, 1.0498E+00, 2.810315E+01>,
      <-3.131491E+00, 1.0498E+00, 2.810314E+01>,
      <-3.131491E+00, 4.698001E-01, 2.810314E+01>,
      <-3.131491E+00, 4.698001E-01, 2.727315E+01>,
      <-3.131491E+00, 1.0498E+00, 2.727315E+01>,
      <5.868511E+00, 1.0498E+00, 2.727315E+01>,
      <5.868511E+00, 4.698001E-01, 2.727315E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie7
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868513E+00, 4.698001E-01, 2.610315E+01>,
      <5.868513E+00, 1.0498E+00, 2.610315E+01>,
      <-3.131491E+00, 1.0498E+00, 2.610315E+01>,
      <-3.131491E+00, 4.698001E-01, 2.610315E+01>,
      <-3.13149E+00, 4.698E-01, 2.527315E+01>,
      <-3.13149E+00, 1.0498E+00, 2.527315E+01>,
      <5.868513E+00, 1.0498E+00, 2.527315E+01>,
      <5.868513E+00, 4.698001E-01, 2.527315E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie8
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868512E+00, 4.698E-01, 2.410315E+01>,
      <5.868512E+00, 1.0498E+00, 2.410315E+01>,
      <-3.13149E+00, 1.0498E+00, 2.410315E+01>,
      <-3.13149E+00, 4.698E-01, 2.410315E+01>,
      <-3.13149E+00, 4.698001E-01, 2.327315E+01>,
      <-3.13149E+00, 1.0498E+00, 2.327315E+01>,
      <5.868512E+00, 1.0498E+00, 2.327315E+01>,
      <5.868512E+00, 4.698E-01, 2.327315E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie9
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868515E+00, 4.698001E-01, 2.210316E+01>,
      <5.868515E+00, 1.0498E+00, 2.210316E+01>,
      <-3.13149E+00, 1.0498E+00, 2.210315E+01>,
      <-3.13149E+00, 4.698001E-01, 2.210315E+01>,
      <-3.131489E+00, 4.698001E-01, 2.127315E+01>,
      <-3.131489E+00, 1.0498E+00, 2.127315E+01>,
      <5.868515E+00, 1.0498E+00, 2.127315E+01>,
      <5.868515E+00, 4.698001E-01, 2.127315E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie10
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868513E+00, 4.698001E-01, 2.010316E+01>,
      <5.868513E+00, 1.0498E+00, 2.010316E+01>,
      <-3.131489E+00, 1.0498E+00, 2.010315E+01>,
      <-3.131489E+00, 4.698001E-01, 2.010315E+01>,
      <-3.131489E+00, 4.698001E-01, 1.927315E+01>,
      <-3.131489E+00, 1.0498E+00, 1.927315E+01>,
      <5.868514E+00, 1.0498E+00, 1.927316E+01>,
      <5.868514E+00, 4.698001E-01, 1.927316E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie11
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868515E+00, 4.698001E-01, 1.810316E+01>,
      <5.868515E+00, 1.0498E+00, 1.810316E+01>,
      <-3.131488E+00, 1.0498E+00, 1.810316E+01>,
      <-3.131488E+00, 4.698E-01, 1.810316E+01>,
      <-3.131488E+00, 4.698E-01, 1.727315E+01>,
      <-3.131488E+00, 1.0498E+00, 1.727315E+01>,
      <5.868516E+00, 1.0498E+00, 1.727316E+01>,
      <5.868516E+00, 4.698001E-01, 1.727316E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie12
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868515E+00, 4.698E-01, 1.610316E+01>,
      <5.868515E+00, 1.0498E+00, 1.610316E+01>,
      <-3.131488E+00, 1.0498E+00, 1.610316E+01>,
      <-3.131488E+00, 4.698001E-01, 1.610316E+01>,
      <-3.131487E+00, 4.698001E-01, 1.527316E+01>,
      <-3.131487E+00, 1.0498E+00, 1.527316E+01>,
      <5.868515E+00, 1.0498E+00, 1.527316E+01>,
      <5.868515E+00, 4.698E-01, 1.527316E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie13
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868515E+00, 4.698001E-01, 1.410316E+01>,
      <5.868515E+00, 1.0498E+00, 1.410316E+01>,
      <-3.131487E+00, 1.0498E+00, 1.410316E+01>,
      <-3.131487E+00, 4.698001E-01, 1.410316E+01>,
      <-3.131487E+00, 4.698001E-01, 1.327316E+01>,
      <-3.131487E+00, 1.0498E+00, 1.327316E+01>,
      <5.868515E+00, 1.0498E+00, 1.327316E+01>,
      <5.868515E+00, 4.698001E-01, 1.327316E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie14
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868514E+00, 4.698001E-01, 1.210316E+01>,
      <5.868514E+00, 1.0498E+00, 1.210316E+01>,
      <-3.131486E+00, 1.0498E+00, 1.210316E+01>,
      <-3.131486E+00, 4.698001E-01, 1.210316E+01>,
      <-3.131486E+00, 4.698001E-01, 1.127316E+01>,
      <-3.131486E+00, 1.0498E+00, 1.127316E+01>,
      <5.868514E+00, 1.0498E+00, 1.127316E+01>,
      <5.868514E+00, 4.698001E-01, 1.127316E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie15
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868516E+00, 4.698001E-01, 1.010317E+01>,
      <5.868516E+00, 1.0498E+00, 1.010317E+01>,
      <-3.131485E+00, 1.0498E+00, 1.010316E+01>,
      <-3.131485E+00, 4.698E-01, 1.010316E+01>,
      <-3.131485E+00, 4.698001E-01, 9.273161E+00>,
      <-3.131485E+00, 1.0498E+00, 9.273161E+00>,
      <5.868516E+00, 1.0498E+00, 9.273165E+00>,
      <5.868516E+00, 4.698E-01, 9.273165E+00>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie16
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868515E+00, 4.698E-01, 8.103167E+00>,
      <5.868515E+00, 1.0498E+00, 8.103167E+00>,
      <-3.131485E+00, 1.0498E+00, 8.103163E+00>,
      <-3.131485E+00, 4.698001E-01, 8.103163E+00>,
      <-3.131485E+00, 4.698001E-01, 7.273165E+00>,
      <-3.131485E+00, 1.0498E+00, 7.273165E+00>,
      <5.868515E+00, 1.0498E+00, 7.273168E+00>,
      <5.868515E+00, 4.698001E-01, 7.273168E+00>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie1
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868546E+00, 4.698001E-01, -8.989674E+01>,
      <5.868546E+00, 1.0498E+00, -8.989674E+01>,
      <-3.131455E+00, 1.0498E+00, -8.989674E+01>,
      <-3.131455E+00, 4.698001E-01, -8.989674E+01>,
      <-3.131454E+00, 4.698001E-01, -9.072675E+01>,
      <-3.131454E+00, 1.0498E+00, -9.072675E+01>,
      <5.868546E+00, 1.0498E+00, -9.072675E+01>,
      <5.868546E+00, 4.698001E-01, -9.072675E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie2
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868536E+00, 4.698001E-01, -9.189674E+01>,
      <5.868536E+00, 1.0498E+00, -9.189674E+01>,
      <-3.131464E+00, 1.0498E+00, -9.189674E+01>,
      <-3.131464E+00, 4.698E-01, -9.189674E+01>,
      <-3.131463E+00, 4.698E-01, -9.272674E+01>,
      <-3.131463E+00, 1.0498E+00, -9.272674E+01>,
      <5.868537E+00, 1.0498E+00, -9.272674E+01>,
      <5.868537E+00, 4.698001E-01, -9.272674E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie3
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868531E+00, 4.698E-01, -9.389674E+01>,
      <5.868531E+00, 1.0498E+00, -9.389674E+01>,
      <-3.13147E+00, 1.0498E+00, -9.389674E+01>,
      <-3.13147E+00, 4.698001E-01, -9.389674E+01>,
      <-3.13147E+00, 4.698001E-01, -9.472674E+01>,
      <-3.13147E+00, 1.0498E+00, -9.472674E+01>,
      <5.868532E+00, 1.0498E+00, -9.472674E+01>,
      <5.868532E+00, 4.698001E-01, -9.472674E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie4
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868523E+00, 4.698001E-01, -9.589674E+01>,
      <5.868523E+00, 1.0498E+00, -9.589674E+01>,
      <-3.131477E+00, 1.0498E+00, -9.589674E+01>,
      <-3.131477E+00, 4.698001E-01, -9.589674E+01>,
      <-3.131477E+00, 4.698001E-01, -9.672674E+01>,
      <-3.131477E+00, 1.0498E+00, -9.672674E+01>,
      <5.868523E+00, 1.0498E+00, -9.672674E+01>,
      <5.868523E+00, 4.698001E-01, -9.672674E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie5
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868515E+00, 4.698001E-01, -9.789674E+01>,
      <5.868515E+00, 1.0498E+00, -9.789674E+01>,
      <-3.131485E+00, 1.0498E+00, -9.789674E+01>,
      <-3.131485E+00, 4.698001E-01, -9.789674E+01>,
      <-3.131484E+00, 4.698E-01, -9.872674E+01>,
      <-3.131484E+00, 1.0498E+00, -9.872674E+01>,
      <5.868516E+00, 1.0498E+00, -9.872674E+01>,
      <5.868516E+00, 4.698001E-01, -9.872674E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie6
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868507E+00, 4.698001E-01, -9.989674E+01>,
      <5.868507E+00, 1.0498E+00, -9.989674E+01>,
      <-3.131491E+00, 1.0498E+00, -9.989674E+01>,
      <-3.131491E+00, 4.698E-01, -9.989674E+01>,
      <-3.131491E+00, 4.698001E-01, -1.007267E+02>,
      <-3.131491E+00, 1.0498E+00, -1.007267E+02>,
      <5.868507E+00, 1.0498E+00, -1.007267E+02>,
      <5.868507E+00, 4.698E-01, -1.007267E+02>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie7
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868502E+00, 4.698E-01, -1.018967E+02>,
      <5.868502E+00, 1.0498E+00, -1.018967E+02>,
      <-3.131498E+00, 1.0498E+00, -1.018967E+02>,
      <-3.131498E+00, 4.698001E-01, -1.018967E+02>,
      <-3.131498E+00, 4.698001E-01, -1.027267E+02>,
      <-3.131498E+00, 1.0498E+00, -1.027267E+02>,
      <5.868502E+00, 1.0498E+00, -1.027267E+02>,
      <5.868502E+00, 4.698001E-01, -1.027267E+02>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie8
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868493E+00, 4.698001E-01, -1.038967E+02>,
      <5.868493E+00, 1.0498E+00, -1.038967E+02>,
      <-3.131505E+00, 1.0498E+00, -1.038967E+02>,
      <-3.131505E+00, 4.698001E-01, -1.038967E+02>,
      <-3.131505E+00, 4.698001E-01, -1.047267E+02>,
      <-3.131505E+00, 1.0498E+00, -1.047267E+02>,
      <5.868493E+00, 1.0498E+00, -1.047267E+02>,
      <5.868493E+00, 4.698001E-01, -1.047267E+02>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie9
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868488E+00, 4.698001E-01, -1.058967E+02>,
      <5.868488E+00, 1.0498E+00, -1.058967E+02>,
      <-3.131512E+00, 1.0498E+00, -1.058967E+02>,
      <-3.131512E+00, 4.698001E-01, -1.058967E+02>,
      <-3.131512E+00, 4.698E-01, -1.067267E+02>,
      <-3.131512E+00, 1.0498E+00, -1.067267E+02>,
      <5.868488E+00, 1.0498E+00, -1.067267E+02>,
      <5.868488E+00, 4.698001E-01, -1.067267E+02>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie10
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868479E+00, 4.698E-01, -1.078967E+02>,
      <5.868479E+00, 1.0498E+00, -1.078967E+02>,
      <-3.131519E+00, 1.0498E+00, -1.078967E+02>,
      <-3.131519E+00, 4.698001E-01, -1.078967E+02>,
      <-3.131519E+00, 4.698001E-01, -1.087267E+02>,
      <-3.131519E+00, 1.0498E+00, -1.087267E+02>,
      <5.868479E+00, 1.0498E+00, -1.087267E+02>,
      <5.868479E+00, 4.698E-01, -1.087267E+02>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie11
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868474E+00, 4.698001E-01, -1.098967E+02>,
      <5.868474E+00, 1.0498E+00, -1.098967E+02>,
      <-3.131526E+00, 1.0498E+00, -1.098967E+02>,
      <-3.131526E+00, 4.698001E-01, -1.098967E+02>,
      <-3.131526E+00, 4.698001E-01, -1.107267E+02>,
      <-3.131526E+00, 1.0498E+00, -1.107267E+02>,
      <5.868474E+00, 1.0498E+00, -1.107267E+02>,
      <5.868474E+00, 4.698001E-01, -1.107267E+02>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie12
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868465E+00, 4.698001E-01, -1.118967E+02>,
      <5.868465E+00, 1.0498E+00, -1.118967E+02>,
      <-3.131533E+00, 1.0498E+00, -1.118967E+02>,
      <-3.131533E+00, 4.698001E-01, -1.118967E+02>,
      <-3.131533E+00, 4.698001E-01, -1.127267E+02>,
      <-3.131533E+00, 1.0498E+00, -1.127267E+02>,
      <5.868465E+00, 1.0498E+00, -1.127267E+02>,
      <5.868465E+00, 4.698001E-01, -1.127267E+02>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie13
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868458E+00, 4.698001E-01, -1.138967E+02>,
      <5.868458E+00, 1.0498E+00, -1.138967E+02>,
      <-3.13154E+00, 1.0498E+00, -1.138967E+02>,
      <-3.13154E+00, 4.698E-01, -1.138967E+02>,
      <-3.13154E+00, 4.698E-01, -1.147267E+02>,
      <-3.13154E+00, 1.0498E+00, -1.147267E+02>,
      <5.868458E+00, 1.0498E+00, -1.147267E+02>,
      <5.868458E+00, 4.698E-01, -1.147267E+02>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie14
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868449E+00, 4.698E-01, -1.158967E+02>,
      <5.868449E+00, 1.0498E+00, -1.158967E+02>,
      <-3.131547E+00, 1.0498E+00, -1.158967E+02>,
      <-3.131547E+00, 4.698001E-01, -1.158967E+02>,
      <-3.131547E+00, 4.698001E-01, -1.167267E+02>,
      <-3.131547E+00, 1.0498E+00, -1.167267E+02>,
      <5.868449E+00, 1.0498E+00, -1.167267E+02>,
      <5.868449E+00, 4.698001E-01, -1.167267E+02>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie15
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868444E+00, 4.698001E-01, -1.178967E+02>,
      <5.868444E+00, 1.0498E+00, -1.178967E+02>,
      <-3.131554E+00, 1.0498E+00, -1.178967E+02>,
      <-3.131554E+00, 4.698001E-01, -1.178967E+02>,
      <-3.131554E+00, 4.698001E-01, -1.187267E+02>,
      <-3.131554E+00, 1.0498E+00, -1.187267E+02>,
      <5.868444E+00, 1.0498E+00, -1.187267E+02>,
      <5.868444E+00, 4.698001E-01, -1.187267E+02>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie16
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868435E+00, 4.698001E-01, -1.198967E+02>,
      <5.868435E+00, 1.0498E+00, -1.198967E+02>,
      <-3.131561E+00, 1.0498E+00, -1.198967E+02>,
      <-3.131561E+00, 4.698001E-01, -1.198967E+02>,
      <-3.131561E+00, 4.698E-01, -1.207267E+02>,
      <-3.131561E+00, 1.0498E+00, -1.207267E+02>,
      <5.868435E+00, 1.0498E+00, -1.207267E+02>,
      <5.868435E+00, 4.698001E-01, -1.207267E+02>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie1
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868534E+00, 4.698E-01, -5.789677E+01>,
      <5.868534E+00, 1.0498E+00, -5.789677E+01>,
      <-3.131468E+00, 1.0498E+00, -5.789677E+01>,
      <-3.131468E+00, 4.698001E-01, -5.789677E+01>,
      <-3.131468E+00, 4.698001E-01, -5.872678E+01>,
      <-3.131468E+00, 1.0498E+00, -5.872678E+01>,
      <5.868534E+00, 1.0498E+00, -5.872678E+01>,
      <5.868534E+00, 4.698E-01, -5.872678E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie2
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868533E+00, 4.698001E-01, -5.989677E+01>,
      <5.868533E+00, 1.0498E+00, -5.989677E+01>,
      <-3.131467E+00, 1.0498E+00, -5.989677E+01>,
      <-3.131467E+00, 4.698001E-01, -5.989677E+01>,
      <-3.131467E+00, 4.698001E-01, -6.072677E+01>,
      <-3.131467E+00, 1.0498E+00, -6.072677E+01>,
      <5.868533E+00, 1.0498E+00, -6.072677E+01>,
      <5.868533E+00, 4.698001E-01, -6.072677E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie3
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868535E+00, 4.698001E-01, -6.189677E+01>,
      <5.868535E+00, 1.0498E+00, -6.189677E+01>,
      <-3.131467E+00, 1.0498E+00, -6.189677E+01>,
      <-3.131467E+00, 4.698001E-01, -6.189677E+01>,
      <-3.131466E+00, 4.698001E-01, -6.272677E+01>,
      <-3.131466E+00, 1.0498E+00, -6.272677E+01>,
      <5.868536E+00, 1.0498E+00, -6.272677E+01>,
      <5.868536E+00, 4.698001E-01, -6.272677E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie4
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868534E+00, 4.698001E-01, -6.389677E+01>,
      <5.868534E+00, 1.0498E+00, -6.389677E+01>,
      <-3.131466E+00, 1.0498E+00, -6.389677E+01>,
      <-3.131466E+00, 4.698E-01, -6.389677E+01>,
      <-3.131466E+00, 4.698E-01, -6.472677E+01>,
      <-3.131466E+00, 1.0498E+00, -6.472677E+01>,
      <5.868534E+00, 1.0498E+00, -6.472677E+01>,
      <5.868534E+00, 4.698E-01, -6.472677E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie5
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868535E+00, 4.698E-01, -6.589677E+01>,
      <5.868535E+00, 1.0498E+00, -6.589677E+01>,
      <-3.131465E+00, 1.0498E+00, -6.589677E+01>,
      <-3.131465E+00, 4.698001E-01, -6.589677E+01>,
      <-3.131465E+00, 4.698001E-01, -6.672677E+01>,
      <-3.131465E+00, 1.0498E+00, -6.672677E+01>,
      <5.868535E+00, 1.0498E+00, -6.672677E+01>,
      <5.868535E+00, 4.698001E-01, -6.672677E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie6
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868534E+00, 4.698001E-01, -6.789677E+01>,
      <5.868534E+00, 1.0498E+00, -6.789677E+01>,
      <-3.131465E+00, 1.0498E+00, -6.789677E+01>,
      <-3.131465E+00, 4.698001E-01, -6.789677E+01>,
      <-3.131464E+00, 4.698001E-01, -6.872677E+01>,
      <-3.131464E+00, 1.0498E+00, -6.872677E+01>,
      <5.868534E+00, 1.0498E+00, -6.872676E+01>,
      <5.868534E+00, 4.698001E-01, -6.872676E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie7
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868536E+00, 4.698001E-01, -6.989676E+01>,
      <5.868536E+00, 1.0498E+00, -6.989676E+01>,
      <-3.131464E+00, 1.0498E+00, -6.989677E+01>,
      <-3.131464E+00, 4.698001E-01, -6.989677E+01>,
      <-3.131464E+00, 4.698E-01, -7.072677E+01>,
      <-3.131464E+00, 1.0498E+00, -7.072677E+01>,
      <5.868536E+00, 1.0498E+00, -7.072676E+01>,
      <5.868536E+00, 4.698001E-01, -7.072676E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie8
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868535E+00, 4.698E-01, -7.189676E+01>,
      <5.868535E+00, 1.0498E+00, -7.189676E+01>,
      <-3.131463E+00, 1.0498E+00, -7.189677E+01>,
      <-3.131463E+00, 4.698E-01, -7.189677E+01>,
      <-3.131463E+00, 4.698001E-01, -7.272676E+01>,
      <-3.131463E+00, 1.0498E+00, -7.272676E+01>,
      <5.868535E+00, 1.0498E+00, -7.272676E+01>,
      <5.868535E+00, 4.698E-01, -7.272676E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie9
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868537E+00, 4.698001E-01, -7.389676E+01>,
      <5.868537E+00, 1.0498E+00, -7.389676E+01>,
      <-3.131463E+00, 1.0498E+00, -7.389676E+01>,
      <-3.131463E+00, 4.698001E-01, -7.389676E+01>,
      <-3.131463E+00, 4.698001E-01, -7.472676E+01>,
      <-3.131463E+00, 1.0498E+00, -7.472676E+01>,
      <5.868537E+00, 1.0498E+00, -7.472676E+01>,
      <5.868537E+00, 4.698001E-01, -7.472676E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie10
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868536E+00, 4.698001E-01, -7.589676E+01>,
      <5.868536E+00, 1.0498E+00, -7.589676E+01>,
      <-3.131462E+00, 1.0498E+00, -7.589676E+01>,
      <-3.131462E+00, 4.698001E-01, -7.589676E+01>,
      <-3.131462E+00, 4.698001E-01, -7.672675E+01>,
      <-3.131462E+00, 1.0498E+00, -7.672675E+01>,
      <5.868536E+00, 1.0498E+00, -7.672675E+01>,
      <5.868536E+00, 4.698001E-01, -7.672675E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie11
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868538E+00, 4.698001E-01, -7.789675E+01>,
      <5.868538E+00, 1.0498E+00, -7.789675E+01>,
      <-3.131461E+00, 1.0498E+00, -7.789675E+01>,
      <-3.131461E+00, 4.698E-01, -7.789675E+01>,
      <-3.131461E+00, 4.698E-01, -7.872675E+01>,
      <-3.131461E+00, 1.0498E+00, -7.872675E+01>,
      <5.868539E+00, 1.0498E+00, -7.872675E+01>,
      <5.868539E+00, 4.698001E-01, -7.872675E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie12
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868537E+00, 4.698E-01, -7.989675E+01>,
      <5.868537E+00, 1.0498E+00, -7.989675E+01>,
      <-3.131461E+00, 1.0498E+00, -7.989675E+01>,
      <-3.131461E+00, 4.698001E-01, -7.989675E+01>,
      <-3.13146E+00, 4.698001E-01, -8.072675E+01>,
      <-3.13146E+00, 1.0498E+00, -8.072675E+01>,
      <5.868537E+00, 1.0498E+00, -8.072675E+01>,
      <5.868537E+00, 4.698E-01, -8.072675E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie13
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868538E+00, 4.698001E-01, -8.189675E+01>,
      <5.868538E+00, 1.0498E+00, -8.189675E+01>,
      <-3.13146E+00, 1.0498E+00, -8.189675E+01>,
      <-3.13146E+00, 4.698001E-01, -8.189675E+01>,
      <-3.13146E+00, 4.698001E-01, -8.272675E+01>,
      <-3.13146E+00, 1.0498E+00, -8.272675E+01>,
      <5.868538E+00, 1.0498E+00, -8.272675E+01>,
      <5.868538E+00, 4.698001E-01, -8.272675E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie14
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868536E+00, 4.698001E-01, -8.389675E+01>,
      <5.868536E+00, 1.0498E+00, -8.389675E+01>,
      <-3.131459E+00, 1.0498E+00, -8.389675E+01>,
      <-3.131459E+00, 4.698001E-01, -8.389675E+01>,
      <-3.131459E+00, 4.698001E-01, -8.472675E+01>,
      <-3.131459E+00, 1.0498E+00, -8.472675E+01>,
      <5.868537E+00, 1.0498E+00, -8.472675E+01>,
      <5.868537E+00, 4.698001E-01, -8.472675E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie15
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868539E+00, 4.698001E-01, -8.589675E+01>,
      <5.868539E+00, 1.0498E+00, -8.589675E+01>,
      <-3.131459E+00, 1.0498E+00, -8.589675E+01>,
      <-3.131459E+00, 4.698E-01, -8.589675E+01>,
      <-3.131459E+00, 4.698001E-01, -8.672675E+01>,
      <-3.131459E+00, 1.0498E+00, -8.672675E+01>,
      <5.868539E+00, 1.0498E+00, -8.672675E+01>,
      <5.868539E+00, 4.698E-01, -8.672675E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie16
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868538E+00, 4.698E-01, -8.789675E+01>,
      <5.868538E+00, 1.0498E+00, -8.789675E+01>,
      <-3.131458E+00, 1.0498E+00, -8.789675E+01>,
      <-3.131458E+00, 4.698001E-01, -8.789675E+01>,
      <-3.131458E+00, 4.698001E-01, -8.872675E+01>,
      <-3.131458E+00, 1.0498E+00, -8.872675E+01>,
      <5.868538E+00, 1.0498E+00, -8.872675E+01>,
      <5.868538E+00, 4.698001E-01, -8.872675E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie1
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.874035E+00, 4.705781E-01, 6.101114E+00>,
      <5.874035E+00, 1.050578E+00, 6.101114E+00>,
      <-3.125969E+00, 1.050578E+00, 6.10111E+00>,
      <-3.125969E+00, 4.705781E-01, 6.10111E+00>,
      <-3.125969E+00, 4.705781E-01, 5.271109E+00>,
      <-3.125969E+00, 1.050578E+00, 5.271109E+00>,
      <5.874035E+00, 1.050578E+00, 5.271112E+00>,
      <5.874035E+00, 4.705781E-01, 5.271112E+00>
   }
 
   normal_vectors { 
      6, 
      <-3.258413E-07, -3.166495E-08, 1.00E+00>,
      <3.258413E-07, -3.166499E-08, -1.00E+00>,
      <-1.00E+00, -3.166494E-08, -3.258414E-07>,
      <1.00E+00, -3.1665E-08, 3.258414E-07>,
      <-2.802847E-14, 9.999999E-01, 2.124322E-14>,
      <2.802847E-14, -1.00E+00, -2.124322E-14>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie2
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.874033E+00, 4.705781E-01, 4.101114E+00>,
      <5.874033E+00, 1.050578E+00, 4.101114E+00>,
      <-3.125968E+00, 1.050578E+00, 4.10111E+00>,
      <-3.125968E+00, 4.705781E-01, 4.10111E+00>,
      <-3.125968E+00, 4.705781E-01, 3.271113E+00>,
      <-3.125968E+00, 1.050578E+00, 3.271112E+00>,
      <5.874034E+00, 1.050578E+00, 3.271116E+00>,
      <5.874034E+00, 4.705781E-01, 3.271116E+00>
   }
 
   normal_vectors { 
      6, 
      <-3.258413E-07, -3.166495E-08, 1.00E+00>,
      <3.258413E-07, -3.166499E-08, -1.00E+00>,
      <-1.00E+00, -3.166494E-08, -3.258414E-07>,
      <1.00E+00, -3.1665E-08, 3.258414E-07>,
      <-2.802847E-14, 9.999999E-01, 2.124322E-14>,
      <2.802847E-14, -1.00E+00, -2.124322E-14>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie3
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.874036E+00, 4.705781E-01, 2.101118E+00>,
      <5.874036E+00, 1.050578E+00, 2.101118E+00>,
      <-3.125968E+00, 1.050578E+00, 2.101114E+00>,
      <-3.125968E+00, 4.705781E-01, 2.101115E+00>,
      <-3.125968E+00, 4.705781E-01, 1.271113E+00>,
      <-3.125968E+00, 1.050578E+00, 1.271112E+00>,
      <5.874036E+00, 1.050578E+00, 1.271116E+00>,
      <5.874036E+00, 4.705781E-01, 1.271116E+00>
   }
 
   normal_vectors { 
      6, 
      <-3.258413E-07, -3.166495E-08, 1.00E+00>,
      <3.258413E-07, -3.166499E-08, -1.00E+00>,
      <-1.00E+00, -3.166494E-08, -3.258414E-07>,
      <1.00E+00, -3.1665E-08, 3.258414E-07>,
      <-2.802847E-14, 9.999999E-01, 2.124322E-14>,
      <2.802847E-14, -1.00E+00, -2.124322E-14>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie4
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.874033E+00, 4.705781E-01, 1.011176E-01>,
      <5.874033E+00, 1.050578E+00, 1.011176E-01>,
      <-3.125967E+00, 1.050578E+00, 1.011147E-01>,
      <-3.125967E+00, 4.705781E-01, 1.011147E-01>,
      <-3.125967E+00, 4.705781E-01, -7.288833E-01>,
      <-3.125967E+00, 1.050578E+00, -7.288833E-01>,
      <5.874033E+00, 1.050578E+00, -7.288803E-01>,
      <5.874033E+00, 4.705781E-01, -7.288803E-01>
   }
 
   normal_vectors { 
      6, 
      <-3.258413E-07, -3.166495E-08, 1.00E+00>,
      <3.258413E-07, -3.166499E-08, -1.00E+00>,
      <-1.00E+00, -3.166494E-08, -3.258414E-07>,
      <1.00E+00, -3.1665E-08, 3.258414E-07>,
      <-2.802847E-14, 9.999999E-01, 2.124322E-14>,
      <2.802847E-14, -1.00E+00, -2.124322E-14>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie5
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.874035E+00, 4.705781E-01, -1.898878E+00>,
      <5.874035E+00, 1.050578E+00, -1.898879E+00>,
      <-3.125967E+00, 1.050578E+00, -1.898882E+00>,
      <-3.125967E+00, 4.705781E-01, -1.898881E+00>,
      <-3.125966E+00, 4.705781E-01, -2.728883E+00>,
      <-3.125966E+00, 1.050578E+00, -2.728884E+00>,
      <5.874036E+00, 1.050578E+00, -2.72888E+00>,
      <5.874036E+00, 4.705781E-01, -2.728879E+00>
   }
 
   normal_vectors { 
      6, 
      <-3.258413E-07, -3.166495E-08, 1.00E+00>,
      <3.258413E-07, -3.166499E-08, -1.00E+00>,
      <-1.00E+00, -3.166494E-08, -3.258414E-07>,
      <1.00E+00, -3.1665E-08, 3.258414E-07>,
      <-2.802847E-14, 9.999999E-01, 2.124322E-14>,
      <2.802847E-14, -1.00E+00, -2.124322E-14>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie6
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.874034E+00, 4.705781E-01, -3.898878E+00>,
      <5.874034E+00, 1.050578E+00, -3.898879E+00>,
      <-3.125966E+00, 1.050578E+00, -3.898882E+00>,
      <-3.125966E+00, 4.705781E-01, -3.898881E+00>,
      <-3.125966E+00, 4.705781E-01, -4.728879E+00>,
      <-3.125966E+00, 1.050578E+00, -4.72888E+00>,
      <5.874034E+00, 1.050578E+00, -4.728877E+00>,
      <5.874034E+00, 4.705781E-01, -4.728876E+00>
   }
 
   normal_vectors { 
      6, 
      <-3.258413E-07, -3.166495E-08, 1.00E+00>,
      <3.258413E-07, -3.166499E-08, -1.00E+00>,
      <-1.00E+00, -3.166494E-08, -3.258414E-07>,
      <1.00E+00, -3.1665E-08, 3.258414E-07>,
      <-2.802847E-14, 9.999999E-01, 2.124322E-14>,
      <2.802847E-14, -1.00E+00, -2.124322E-14>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie7
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.874037E+00, 4.705781E-01, -5.898874E+00>,
      <5.874037E+00, 1.050578E+00, -5.898874E+00>,
      <-3.125965E+00, 1.050578E+00, -5.898877E+00>,
      <-3.125965E+00, 4.705781E-01, -5.898877E+00>,
      <-3.125965E+00, 4.705781E-01, -6.728878E+00>,
      <-3.125965E+00, 1.050578E+00, -6.728878E+00>,
      <5.874037E+00, 1.050578E+00, -6.728876E+00>,
      <5.874037E+00, 4.705781E-01, -6.728876E+00>
   }
 
   normal_vectors { 
      6, 
      <-3.258413E-07, -3.166495E-08, 1.00E+00>,
      <3.258413E-07, -3.166499E-08, -1.00E+00>,
      <-1.00E+00, -3.166494E-08, -3.258414E-07>,
      <1.00E+00, -3.1665E-08, 3.258414E-07>,
      <-2.802847E-14, 9.999999E-01, 2.124322E-14>,
      <2.802847E-14, -1.00E+00, -2.124322E-14>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie8
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.874035E+00, 4.70578E-01, -7.898874E+00>,
      <5.874035E+00, 1.050578E+00, -7.898874E+00>,
      <-3.125964E+00, 1.050578E+00, -7.898877E+00>,
      <-3.125964E+00, 4.70578E-01, -7.898877E+00>,
      <-3.125964E+00, 4.70578E-01, -8.728875E+00>,
      <-3.125964E+00, 1.050578E+00, -8.728875E+00>,
      <5.874036E+00, 1.050578E+00, -8.728871E+00>,
      <5.874036E+00, 4.705781E-01, -8.728871E+00>
   }
 
   normal_vectors { 
      6, 
      <-3.258413E-07, -3.166495E-08, 1.00E+00>,
      <3.258413E-07, -3.166499E-08, -1.00E+00>,
      <-1.00E+00, -3.166494E-08, -3.258414E-07>,
      <1.00E+00, -3.1665E-08, 3.258414E-07>,
      <-2.802847E-14, 9.999999E-01, 2.124322E-14>,
      <2.802847E-14, -1.00E+00, -2.124322E-14>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie9
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.874038E+00, 4.70578E-01, -9.89887E+00>,
      <5.874038E+00, 1.050578E+00, -9.89887E+00>,
      <-3.125964E+00, 1.050578E+00, -9.898873E+00>,
      <-3.125964E+00, 4.70578E-01, -9.898873E+00>,
      <-3.125964E+00, 4.70578E-01, -1.072888E+01>,
      <-3.125964E+00, 1.050578E+00, -1.072888E+01>,
      <5.874038E+00, 1.050578E+00, -1.072887E+01>,
      <5.874038E+00, 4.70578E-01, -1.072887E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258413E-07, -3.166495E-08, 1.00E+00>,
      <3.258413E-07, -3.166499E-08, -1.00E+00>,
      <-1.00E+00, -3.166494E-08, -3.258414E-07>,
      <1.00E+00, -3.1665E-08, 3.258414E-07>,
      <-2.802847E-14, 9.999999E-01, 2.124322E-14>,
      <2.802847E-14, -1.00E+00, -2.124322E-14>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie10
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.874037E+00, 4.70578E-01, -1.189887E+01>,
      <5.874037E+00, 1.050578E+00, -1.189887E+01>,
      <-3.125963E+00, 1.050578E+00, -1.189887E+01>,
      <-3.125963E+00, 4.70578E-01, -1.189887E+01>,
      <-3.125963E+00, 4.70578E-01, -1.272887E+01>,
      <-3.125963E+00, 1.050578E+00, -1.272887E+01>,
      <5.874037E+00, 1.050578E+00, -1.272887E+01>,
      <5.874037E+00, 4.70578E-01, -1.272887E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258413E-07, -3.166495E-08, 1.00E+00>,
      <3.258413E-07, -3.166499E-08, -1.00E+00>,
      <-1.00E+00, -3.166494E-08, -3.258414E-07>,
      <1.00E+00, -3.1665E-08, 3.258414E-07>,
      <-2.802847E-14, 9.999999E-01, 2.124322E-14>,
      <2.802847E-14, -1.00E+00, -2.124322E-14>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie11
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.874039E+00, 4.70578E-01, -1.389887E+01>,
      <5.874039E+00, 1.050578E+00, -1.389887E+01>,
      <-3.125962E+00, 1.050578E+00, -1.389887E+01>,
      <-3.125962E+00, 4.705781E-01, -1.389887E+01>,
      <-3.125962E+00, 4.70578E-01, -1.472887E+01>,
      <-3.125962E+00, 1.050578E+00, -1.472887E+01>,
      <5.87404E+00, 1.050578E+00, -1.472887E+01>,
      <5.87404E+00, 4.70578E-01, -1.472887E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258413E-07, -3.166495E-08, 1.00E+00>,
      <3.258413E-07, -3.166499E-08, -1.00E+00>,
      <-1.00E+00, -3.166494E-08, -3.258414E-07>,
      <1.00E+00, -3.1665E-08, 3.258414E-07>,
      <-2.802847E-14, 9.999999E-01, 2.124322E-14>,
      <2.802847E-14, -1.00E+00, -2.124322E-14>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie12
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.874038E+00, 4.705781E-01, -1.589887E+01>,
      <5.874038E+00, 1.050578E+00, -1.589887E+01>,
      <-3.125962E+00, 1.050578E+00, -1.589887E+01>,
      <-3.125962E+00, 4.705781E-01, -1.589887E+01>,
      <-3.125962E+00, 4.705781E-01, -1.672887E+01>,
      <-3.125962E+00, 1.050578E+00, -1.672887E+01>,
      <5.874038E+00, 1.050578E+00, -1.672886E+01>,
      <5.874038E+00, 4.705781E-01, -1.672886E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258413E-07, -3.166495E-08, 1.00E+00>,
      <3.258413E-07, -3.166499E-08, -1.00E+00>,
      <-1.00E+00, -3.166494E-08, -3.258414E-07>,
      <1.00E+00, -3.1665E-08, 3.258414E-07>,
      <-2.802847E-14, 9.999999E-01, 2.124322E-14>,
      <2.802847E-14, -1.00E+00, -2.124322E-14>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie13
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.874039E+00, 4.705781E-01, -1.789886E+01>,
      <5.874039E+00, 1.050578E+00, -1.789886E+01>,
      <-3.125961E+00, 1.050578E+00, -1.789887E+01>,
      <-3.125961E+00, 4.705781E-01, -1.789887E+01>,
      <-3.125961E+00, 4.705781E-01, -1.872887E+01>,
      <-3.125961E+00, 1.050578E+00, -1.872887E+01>,
      <5.874039E+00, 1.050578E+00, -1.872886E+01>,
      <5.874039E+00, 4.705781E-01, -1.872886E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258413E-07, -3.166495E-08, 1.00E+00>,
      <3.258413E-07, -3.166499E-08, -1.00E+00>,
      <-1.00E+00, -3.166494E-08, -3.258414E-07>,
      <1.00E+00, -3.1665E-08, 3.258414E-07>,
      <-2.802847E-14, 9.999999E-01, 2.124322E-14>,
      <2.802847E-14, -1.00E+00, -2.124322E-14>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie14
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.874037E+00, 4.705781E-01, -1.989886E+01>,
      <5.874037E+00, 1.050578E+00, -1.989886E+01>,
      <-3.125961E+00, 1.050578E+00, -1.989887E+01>,
      <-3.125961E+00, 4.705781E-01, -1.989887E+01>,
      <-3.12596E+00, 4.705781E-01, -2.072886E+01>,
      <-3.12596E+00, 1.050578E+00, -2.072886E+01>,
      <5.874038E+00, 1.050578E+00, -2.072886E+01>,
      <5.874038E+00, 4.705781E-01, -2.072886E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258413E-07, -3.166495E-08, 1.00E+00>,
      <3.258413E-07, -3.166499E-08, -1.00E+00>,
      <-1.00E+00, -3.166494E-08, -3.258414E-07>,
      <1.00E+00, -3.1665E-08, 3.258414E-07>,
      <-2.802847E-14, 9.999999E-01, 2.124322E-14>,
      <2.802847E-14, -1.00E+00, -2.124322E-14>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie15
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.87404E+00, 4.705781E-01, -2.189886E+01>,
      <5.87404E+00, 1.050578E+00, -2.189886E+01>,
      <-3.12596E+00, 1.050578E+00, -2.189886E+01>,
      <-3.12596E+00, 4.705781E-01, -2.189886E+01>,
      <-3.12596E+00, 4.705781E-01, -2.272886E+01>,
      <-3.12596E+00, 1.050578E+00, -2.272886E+01>,
      <5.87404E+00, 1.050578E+00, -2.272886E+01>,
      <5.87404E+00, 4.705781E-01, -2.272886E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258413E-07, -3.166495E-08, 1.00E+00>,
      <3.258413E-07, -3.166499E-08, -1.00E+00>,
      <-1.00E+00, -3.166494E-08, -3.258414E-07>,
      <1.00E+00, -3.1665E-08, 3.258414E-07>,
      <-2.802847E-14, 9.999999E-01, 2.124322E-14>,
      <2.802847E-14, -1.00E+00, -2.124322E-14>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie16
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.874039E+00, 4.705781E-01, -2.389886E+01>,
      <5.874039E+00, 1.050578E+00, -2.389886E+01>,
      <-3.125959E+00, 1.050578E+00, -2.389886E+01>,
      <-3.125959E+00, 4.705781E-01, -2.389886E+01>,
      <-3.125959E+00, 4.705781E-01, -2.472886E+01>,
      <-3.125959E+00, 1.050578E+00, -2.472886E+01>,
      <5.874039E+00, 1.050578E+00, -2.472886E+01>,
      <5.874039E+00, 4.705781E-01, -2.472886E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258413E-07, -3.166495E-08, 1.00E+00>,
      <3.258413E-07, -3.166499E-08, -1.00E+00>,
      <-1.00E+00, -3.166494E-08, -3.258414E-07>,
      <1.00E+00, -3.1665E-08, 3.258414E-07>,
      <-2.802847E-14, 9.999999E-01, 2.124322E-14>,
      <2.802847E-14, -1.00E+00, -2.124322E-14>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie1
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868523E+00, 4.698001E-01, -2.590163E+01>,
      <5.868523E+00, 1.0498E+00, -2.590163E+01>,
      <-3.13148E+00, 1.0498E+00, -2.590163E+01>,
      <-3.13148E+00, 4.698001E-01, -2.590163E+01>,
      <-3.131479E+00, 4.698001E-01, -2.673163E+01>,
      <-3.131479E+00, 1.0498E+00, -2.673163E+01>,
      <5.868523E+00, 1.0498E+00, -2.673163E+01>,
      <5.868523E+00, 4.698001E-01, -2.673163E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie2
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868521E+00, 4.698001E-01, -2.790162E+01>,
      <5.868521E+00, 1.0498E+00, -2.790162E+01>,
      <-3.131479E+00, 1.0498E+00, -2.790163E+01>,
      <-3.131479E+00, 4.698E-01, -2.790163E+01>,
      <-3.131479E+00, 4.698E-01, -2.873163E+01>,
      <-3.131479E+00, 1.0498E+00, -2.873163E+01>,
      <5.868522E+00, 1.0498E+00, -2.873162E+01>,
      <5.868522E+00, 4.698001E-01, -2.873162E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie3
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868524E+00, 4.698E-01, -2.990162E+01>,
      <5.868524E+00, 1.0498E+00, -2.990162E+01>,
      <-3.131478E+00, 1.0498E+00, -2.990162E+01>,
      <-3.131478E+00, 4.698001E-01, -2.990162E+01>,
      <-3.131478E+00, 4.698001E-01, -3.073162E+01>,
      <-3.131478E+00, 1.0498E+00, -3.073162E+01>,
      <5.868524E+00, 1.0498E+00, -3.073162E+01>,
      <5.868524E+00, 4.698001E-01, -3.073162E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie4
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868523E+00, 4.698001E-01, -3.190162E+01>,
      <5.868523E+00, 1.0498E+00, -3.190162E+01>,
      <-3.131477E+00, 1.0498E+00, -3.190162E+01>,
      <-3.131477E+00, 4.698001E-01, -3.190162E+01>,
      <-3.131477E+00, 4.698001E-01, -3.273162E+01>,
      <-3.131477E+00, 1.0498E+00, -3.273162E+01>,
      <5.868523E+00, 1.0498E+00, -3.273162E+01>,
      <5.868523E+00, 4.698001E-01, -3.273162E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie5
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868523E+00, 4.698001E-01, -3.390162E+01>,
      <5.868523E+00, 1.0498E+00, -3.390162E+01>,
      <-3.131477E+00, 1.0498E+00, -3.390162E+01>,
      <-3.131477E+00, 4.698001E-01, -3.390162E+01>,
      <-3.131476E+00, 4.698E-01, -3.473162E+01>,
      <-3.131476E+00, 1.0498E+00, -3.473162E+01>,
      <5.868524E+00, 1.0498E+00, -3.473162E+01>,
      <5.868524E+00, 4.698001E-01, -3.473162E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie6
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868522E+00, 4.698001E-01, -3.590162E+01>,
      <5.868522E+00, 1.0498E+00, -3.590162E+01>,
      <-3.131476E+00, 1.0498E+00, -3.590162E+01>,
      <-3.131476E+00, 4.698E-01, -3.590162E+01>,
      <-3.131476E+00, 4.698001E-01, -3.673162E+01>,
      <-3.131476E+00, 1.0498E+00, -3.673162E+01>,
      <5.868522E+00, 1.0498E+00, -3.673161E+01>,
      <5.868522E+00, 4.698E-01, -3.673161E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie7
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868525E+00, 4.698E-01, -3.790161E+01>,
      <5.868525E+00, 1.0498E+00, -3.790161E+01>,
      <-3.131475E+00, 1.0498E+00, -3.790162E+01>,
      <-3.131475E+00, 4.698001E-01, -3.790162E+01>,
      <-3.131475E+00, 4.698001E-01, -3.873162E+01>,
      <-3.131475E+00, 1.0498E+00, -3.873162E+01>,
      <5.868525E+00, 1.0498E+00, -3.873161E+01>,
      <5.868525E+00, 4.698001E-01, -3.873161E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie8
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868523E+00, 4.698001E-01, -3.990161E+01>,
      <5.868523E+00, 1.0498E+00, -3.990161E+01>,
      <-3.131475E+00, 1.0498E+00, -3.990162E+01>,
      <-3.131475E+00, 4.698001E-01, -3.990162E+01>,
      <-3.131474E+00, 4.698001E-01, -4.073161E+01>,
      <-3.131474E+00, 1.0498E+00, -4.073161E+01>,
      <5.868524E+00, 1.0498E+00, -4.073161E+01>,
      <5.868524E+00, 4.698001E-01, -4.073161E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie9
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868526E+00, 4.698001E-01, -4.190161E+01>,
      <5.868526E+00, 1.0498E+00, -4.190161E+01>,
      <-3.131474E+00, 1.0498E+00, -4.190161E+01>,
      <-3.131474E+00, 4.698001E-01, -4.190161E+01>,
      <-3.131474E+00, 4.698E-01, -4.273161E+01>,
      <-3.131474E+00, 1.0498E+00, -4.273161E+01>,
      <5.868526E+00, 1.0498E+00, -4.273161E+01>,
      <5.868526E+00, 4.698001E-01, -4.273161E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie10
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868525E+00, 4.698E-01, -4.390161E+01>,
      <5.868525E+00, 1.0498E+00, -4.390161E+01>,
      <-3.131474E+00, 1.0498E+00, -4.390161E+01>,
      <-3.131474E+00, 4.698001E-01, -4.390161E+01>,
      <-3.131473E+00, 4.698001E-01, -4.473161E+01>,
      <-3.131473E+00, 1.0498E+00, -4.473161E+01>,
      <5.868525E+00, 1.0498E+00, -4.473161E+01>,
      <5.868525E+00, 4.698E-01, -4.473161E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie11
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868527E+00, 4.698001E-01, -4.590161E+01>,
      <5.868527E+00, 1.0498E+00, -4.590161E+01>,
      <-3.131473E+00, 1.0498E+00, -4.590161E+01>,
      <-3.131473E+00, 4.698001E-01, -4.590161E+01>,
      <-3.131473E+00, 4.698001E-01, -4.673161E+01>,
      <-3.131473E+00, 1.0498E+00, -4.673161E+01>,
      <5.868527E+00, 1.0498E+00, -4.673161E+01>,
      <5.868527E+00, 4.698001E-01, -4.673161E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie12
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868526E+00, 4.698001E-01, -4.790161E+01>,
      <5.868526E+00, 1.0498E+00, -4.790161E+01>,
      <-3.131472E+00, 1.0498E+00, -4.790161E+01>,
      <-3.131472E+00, 4.698001E-01, -4.790161E+01>,
      <-3.131472E+00, 4.698001E-01, -4.873161E+01>,
      <-3.131472E+00, 1.0498E+00, -4.873161E+01>,
      <5.868526E+00, 1.0498E+00, -4.873161E+01>,
      <5.868526E+00, 4.698001E-01, -4.873161E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie13
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868526E+00, 4.698001E-01, -4.99016E+01>,
      <5.868526E+00, 1.0498E+00, -4.99016E+01>,
      <-3.131472E+00, 1.0498E+00, -4.99016E+01>,
      <-3.131472E+00, 4.698E-01, -4.99016E+01>,
      <-3.131471E+00, 4.698E-01, -5.073161E+01>,
      <-3.131471E+00, 1.0498E+00, -5.073161E+01>,
      <5.868527E+00, 1.0498E+00, -5.073161E+01>,
      <5.868527E+00, 4.698E-01, -5.073161E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie14
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868525E+00, 4.698001E-01, -5.19016E+01>,
      <5.868525E+00, 1.0498E+00, -5.19016E+01>,
      <-3.131473E+00, 1.0498E+00, -5.19016E+01>,
      <-3.131473E+00, 4.698001E-01, -5.19016E+01>,
      <-3.131473E+00, 4.698001E-01, -5.27316E+01>,
      <-3.131473E+00, 1.0498E+00, -5.27316E+01>,
      <5.868526E+00, 1.0498E+00, -5.27316E+01>,
      <5.868526E+00, 4.698001E-01, -5.27316E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie15
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868528E+00, 4.698001E-01, -5.39016E+01>,
      <5.868528E+00, 1.0498E+00, -5.39016E+01>,
      <-3.13147E+00, 1.0498E+00, -5.39016E+01>,
      <-3.13147E+00, 4.698001E-01, -5.39016E+01>,
      <-3.13147E+00, 4.698001E-01, -5.473161E+01>,
      <-3.13147E+00, 1.0498E+00, -5.473161E+01>,
      <5.868528E+00, 1.0498E+00, -5.47316E+01>,
      <5.868528E+00, 4.698001E-01, -5.47316E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Tie16
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.868526E+00, 4.698001E-01, -5.59016E+01>,
      <5.868526E+00, 1.0498E+00, -5.59016E+01>,
      <-3.13147E+00, 1.0498E+00, -5.59016E+01>,
      <-3.13147E+00, 4.698001E-01, -5.59016E+01>,
      <-3.131469E+00, 4.698E-01, -5.67316E+01>,
      <-3.131469E+00, 1.0498E+00, -5.67316E+01>,
      <5.868527E+00, 1.0498E+00, -5.673159E+01>,
      <5.868527E+00, 4.698001E-01, -5.673159E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104933E-16, 9.999999E-01, 2.847209E-16>,
      <1.104933E-16, -1.00E+00, -2.847209E-16>
   }
 
   texture_list { 
      1, 
      texture {Tex2}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
#declare Tex3 =
texture {
   pigment {rgbf <8.901961E-01, 8.54902E-01, 8.117647E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// FrontShelf
mesh2 {
 
   vertex_vectors { 
      24, 
      <5.128731E+00, 7.985627E+00, -2.685604E+01>,
      <5.128731E+00, 8.185627E+00, -2.685604E+01>,
      <-2.391269E+00, 8.185627E+00, -2.685605E+01>,
      <-2.391269E+00, 7.985627E+00, -2.685605E+01>,
      <-2.391268E+00, 7.985627E+00, -2.907371E+01>,
      <-2.391268E+00, 8.185627E+00, -2.906606E+01>,
      <5.128732E+00, 8.185627E+00, -2.906605E+01>,
      <5.128732E+00, 7.985627E+00, -2.906605E+01>,
      <-2.579269E+00, 7.985627E+00, -2.685619E+01>,
      <-2.579269E+00, 8.185627E+00, -2.685605E+01>,
      <-2.579268E+00, 8.185627E+00, -2.906606E+01>,
      <-2.579268E+00, 7.985627E+00, -2.907385E+01>,
      <5.316732E+00, 7.985627E+00, -2.906605E+01>,
      <5.316732E+00, 8.185627E+00, -2.906605E+01>,
      <5.316731E+00, 8.185627E+00, -2.685604E+01>,
      <5.316731E+00, 7.985627E+00, -2.685604E+01>,
      <5.316731E+00, 6.692549E+00, -2.685604E+01>,
      <5.128731E+00, 6.692549E+00, -2.685604E+01>,
      <-2.391269E+00, 6.692549E+00, -2.685605E+01>,
      <-2.579269E+00, 6.692549E+00, -2.685605E+01>,
      <5.128732E+00, 6.692549E+00, -2.896605E+01>,
      <5.316732E+00, 6.692549E+00, -2.896605E+01>,
      <-2.579268E+00, 6.692549E+00, -2.896606E+01>,
      <-2.391268E+00, 6.692549E+00, -2.896606E+01>
   }
 
   normal_vectors { 
      13, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <4.450541E-04, 2.88612E-02, -9.995834E-01>,
      <1.700087E-04, -1.934243E-02, -9.998129E-01>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <3.811323E-04, 3.859384E-02, -9.992549E-01>,
      <3.83001E-04, -2.225409E-02, -9.997523E-01>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <3.255988E-07, -3.858014E-02, -9.992555E-01>,
      <3.248714E-07, -7.710284E-02, -9.970232E-01>,
      <3.834514E-04, -8.301963E-02, -9.965478E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex3}
   }
 
   face_indices { 
      44, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <6, 7, 4>, 0,
      <6, 4, 5>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0,
      <8, 9, 10>, 0,
      <8, 10, 11>, 0,
      <8, 3, 2>, 0,
      <8, 2, 9>, 0,
      <9, 2, 5>, 0,
      <9, 5, 10>, 0,
      <10, 5, 4>, 0,
      <10, 4, 11>, 0,
      <12, 13, 14>, 0,
      <12, 14, 15>, 0,
      <12, 7, 6>, 0,
      <12, 6, 13>, 0,
      <13, 6, 1>, 0,
      <13, 1, 14>, 0,
      <14, 1, 0>, 0,
      <14, 0, 15>, 0,
      <16, 15, 0>, 0,
      <16, 0, 17>, 0,
      <18, 3, 8>, 0,
      <18, 8, 19>, 0,
      <20, 7, 12>, 0,
      <20, 12, 21>, 0,
      <11, 4, 23>, 0,
      <11, 23, 22>, 0,
      <21, 12, 15>, 0,
      <21, 15, 16>, 0,
      <17, 0, 7>, 0,
      <17, 7, 20>, 0,
      <16, 17, 20>, 0,
      <16, 20, 21>, 0,
      <23, 4, 3>, 0,
      <23, 3, 18>, 0,
      <19, 8, 11>, 0,
      <19, 11, 22>, 0,
      <22, 23, 18>, 0,
      <22, 18, 19>, 0
   }
 
   normal_indices { 
      44, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 3, 1>,
      <1, 1, 2>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <0, 0, 0>,
      <0, 0, 0>,
      <4, 4, 4>,
      <4, 4, 4>,
      <7, 2, 1>,
      <7, 1, 8>,
      <9, 9, 9>,
      <9, 9, 9>,
      <10, 3, 1>,
      <10, 1, 1>,
      <4, 4, 4>,
      <4, 4, 4>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <11, 3, 10>,
      <11, 10, 11>,
      <8, 1, 12>,
      <8, 12, 12>,
      <9, 9, 9>,
      <9, 9, 9>,
      <6, 6, 6>,
      <6, 6, 6>,
      <5, 5, 5>,
      <5, 5, 5>,
      <9, 9, 9>,
      <9, 9, 9>,
      <6, 6, 6>,
      <6, 6, 6>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
#declare Tex4 =
texture {
   pigment {rgbf <8.54902E-01, 8.823529E-01, 7.568628E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// StepFwdPort
mesh2 {
 
   vertex_vectors { 
      48, 
      <5.550765E+00, 2.584428E+00, -2.783686E+01>,
      <5.550765E+00, 2.684428E+00, -2.783686E+01>,
      <6.355212E+00, 2.684428E+00, -2.783687E+01>,
      <6.355212E+00, 2.584428E+00, -2.783687E+01>,
      <6.355213E+00, 2.584428E+00, -2.873686E+01>,
      <6.355215E+00, 2.684428E+00, -2.873693E+01>,
      <5.550766E+00, 2.684428E+00, -2.873694E+01>,
      <5.550766E+00, 2.584428E+00, -2.873685E+01>,
      <5.550765E+00, 2.584428E+00, -2.774686E+01>,
      <5.550765E+00, 2.684428E+00, -2.774686E+01>,
      <6.355214E+00, 2.684428E+00, -2.774685E+01>,
      <6.355214E+00, 2.584428E+00, -2.774685E+01>,
      <6.355213E+00, 2.584428E+00, -2.882686E+01>,
      <6.355213E+00, 2.684428E+00, -2.882694E+01>,
      <5.550766E+00, 2.684428E+00, -2.882693E+01>,
      <5.550766E+00, 2.584428E+00, -2.882686E+01>,
      <6.355213E+00, 3.084428E+00, -2.882694E+01>,
      <6.355215E+00, 3.084428E+00, -2.873693E+01>,
      <5.550766E+00, 3.084428E+00, -2.873694E+01>,
      <5.550766E+00, 3.084428E+00, -2.882693E+01>,
      <5.550765E+00, 3.084428E+00, -2.774686E+01>,
      <5.550765E+00, 3.084428E+00, -2.783686E+01>,
      <6.355212E+00, 3.084428E+00, -2.783687E+01>,
      <6.355214E+00, 3.084428E+00, -2.774685E+01>,
      <5.550765E+00, 3.384428E+00, -2.792186E+01>,
      <5.550765E+00, 3.384428E+00, -2.801186E+01>,
      <6.355212E+00, 3.384428E+00, -2.801186E+01>,
      <6.355214E+00, 3.384428E+00, -2.792186E+01>,
      <6.355213E+00, 3.384428E+00, -2.865194E+01>,
      <6.355213E+00, 3.384428E+00, -2.856193E+01>,
      <5.550766E+00, 3.384428E+00, -2.856193E+01>,
      <5.550766E+00, 3.384428E+00, -2.865194E+01>,
      <6.055212E+00, 4.084428E+00, -2.865194E+01>,
      <6.055213E+00, 4.084428E+00, -2.856193E+01>,
      <5.550766E+00, 4.084428E+00, -2.856193E+01>,
      <5.550766E+00, 4.084428E+00, -2.865194E+01>,
      <5.550765E+00, 4.084428E+00, -2.792186E+01>,
      <5.550765E+00, 4.084428E+00, -2.801186E+01>,
      <6.055211E+00, 4.084428E+00, -2.801186E+01>,
      <6.055211E+00, 4.084428E+00, -2.792186E+01>,
      <6.25031E+00, 3.51394E+00, -2.801186E+01>,
      <6.25031E+00, 3.60394E+00, -2.801186E+01>,
      <5.550765E+00, 3.60394E+00, -2.801186E+01>,
      <5.550765E+00, 3.51394E+00, -2.801186E+01>,
      <5.550766E+00, 3.51394E+00, -2.856193E+01>,
      <5.550766E+00, 3.60394E+00, -2.856193E+01>,
      <6.25031E+00, 3.60394E+00, -2.856193E+01>,
      <6.25031E+00, 3.51394E+00, -2.856193E+01>
   }
 
   normal_vectors { 
      12, 
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <-2.351973E-06, -2.609787E-01, 9.653445E-01>,
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <-3.432617E-06, -2.609811E-01, -9.65344E-01>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <9.795786E-01, 2.010617E-01, -1.461853E-05>,
      <2.441756E-06, 2.609797E-01, 9.653443E-01>,
      <3.512847E-06, 2.6098E-01, -9.653443E-01>,
      <9.191456E-01, 3.93918E-01, -1.013557E-05>
   }
 
   texture_list { 
      1, 
      texture {Tex4}
   }
 
   face_indices { 
      72, 
      <1, 2, 5>, 0,
      <1, 5, 6>, 0,
      <3, 0, 7>, 0,
      <3, 7, 4>, 0,
      <11, 8, 0>, 0,
      <11, 0, 3>, 0,
      <15, 12, 4>, 0,
      <15, 4, 7>, 0,
      <16, 17, 5>, 0,
      <16, 5, 13>, 0,
      <17, 18, 6>, 0,
      <17, 6, 5>, 0,
      <18, 19, 14>, 0,
      <18, 14, 6>, 0,
      <20, 21, 1>, 0,
      <20, 1, 9>, 0,
      <21, 22, 2>, 0,
      <21, 2, 1>, 0,
      <22, 23, 10>, 0,
      <22, 10, 2>, 0,
      <24, 25, 21>, 0,
      <24, 21, 20>, 0,
      <25, 26, 22>, 0,
      <25, 22, 21>, 0,
      <26, 27, 23>, 0,
      <26, 23, 22>, 0,
      <27, 24, 20>, 0,
      <27, 20, 23>, 0,
      <28, 29, 17>, 0,
      <28, 17, 16>, 0,
      <29, 30, 18>, 0,
      <29, 18, 17>, 0,
      <30, 31, 19>, 0,
      <30, 19, 18>, 0,
      <31, 28, 16>, 0,
      <31, 16, 19>, 0,
      <32, 33, 29>, 0,
      <32, 29, 28>, 0,
      <33, 34, 30>, 0,
      <33, 30, 29>, 0,
      <34, 35, 31>, 0,
      <34, 31, 30>, 0,
      <35, 32, 28>, 0,
      <35, 28, 31>, 0,
      <36, 37, 25>, 0,
      <36, 25, 24>, 0,
      <37, 38, 26>, 0,
      <37, 26, 25>, 0,
      <38, 39, 27>, 0,
      <38, 27, 26>, 0,
      <39, 36, 24>, 0,
      <39, 24, 27>, 0,
      <35, 34, 33>, 0,
      <35, 33, 32>, 0,
      <37, 36, 39>, 0,
      <37, 39, 38>, 0,
      <13, 10, 11>, 0,
      <11, 12, 13>, 0,
      <9, 14, 15>, 0,
      <15, 8, 9>, 0,
      <20, 8, 11>, 0,
      <11, 23, 20>, 0,
      <16, 12, 15>, 0,
      <15, 19, 16>, 0,
      <43, 42, 45>, 0,
      <43, 45, 44>, 0,
      <47, 46, 41>, 0,
      <47, 41, 40>, 0,
      <41, 46, 45>, 0,
      <41, 45, 42>, 0,
      <43, 44, 47>, 0,
      <43, 47, 40>, 0
   }
 
   normal_indices { 
      72, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 4>,
      <3, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>,
      <5, 5, 5>,
      <5, 5, 5>,
      <6, 6, 7>,
      <6, 7, 7>,
      <2, 2, 2>,
      <2, 2, 2>,
      <5, 5, 5>,
      <5, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <8, 8, 2>,
      <8, 2, 2>,
      <9, 9, 9>,
      <9, 9, 9>,
      <8, 8, 2>,
      <8, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <5, 5, 5>,
      <5, 5, 5>,
      <10, 10, 10>,
      <10, 10, 10>,
      <11, 11, 8>,
      <11, 8, 8>,
      <4, 4, 3>,
      <4, 3, 3>,
      <5, 5, 5>,
      <5, 5, 5>,
      <7, 7, 10>,
      <7, 10, 10>,
      <5, 5, 5>,
      <5, 5, 5>,
      <7, 7, 6>,
      <7, 6, 6>,
      <11, 11, 8>,
      <11, 8, 8>,
      <4, 4, 9>,
      <4, 9, 9>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <2, 2, 2>,
      <2, 2, 2>,
      <5, 5, 5>,
      <5, 5, 5>,
      <9, 4, 4>,
      <4, 9, 9>,
      <10, 7, 7>,
      <7, 10, 10>,
      <5, 5, 5>,
      <5, 5, 5>,
      <2, 2, 2>,
      <2, 2, 2>,
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>
   }
}
 
// StepFwdStar
mesh2 {
 
   vertex_vectors { 
      48, 
      <-2.813302E+00, 2.584428E+00, -2.783686E+01>,
      <-2.813302E+00, 2.684428E+00, -2.783686E+01>,
      <-3.617749E+00, 2.684428E+00, -2.783687E+01>,
      <-3.617749E+00, 2.584428E+00, -2.783687E+01>,
      <-3.617749E+00, 2.584428E+00, -2.873686E+01>,
      <-3.617751E+00, 2.684428E+00, -2.873693E+01>,
      <-2.813302E+00, 2.684428E+00, -2.873694E+01>,
      <-2.813302E+00, 2.584428E+00, -2.873686E+01>,
      <-2.813302E+00, 2.584428E+00, -2.774687E+01>,
      <-2.813302E+00, 2.684428E+00, -2.774687E+01>,
      <-3.617751E+00, 2.684428E+00, -2.774686E+01>,
      <-3.617751E+00, 2.584428E+00, -2.774686E+01>,
      <-3.617749E+00, 2.584428E+00, -2.882687E+01>,
      <-3.617749E+00, 2.684428E+00, -2.882694E+01>,
      <-2.813302E+00, 2.684428E+00, -2.882694E+01>,
      <-2.813302E+00, 2.584428E+00, -2.882686E+01>,
      <-3.617749E+00, 3.084428E+00, -2.882694E+01>,
      <-3.617751E+00, 3.084428E+00, -2.873693E+01>,
      <-2.813302E+00, 3.084428E+00, -2.873694E+01>,
      <-2.813302E+00, 3.084428E+00, -2.882694E+01>,
      <-2.813302E+00, 3.084428E+00, -2.774687E+01>,
      <-2.813302E+00, 3.084428E+00, -2.783686E+01>,
      <-3.617749E+00, 3.084428E+00, -2.783687E+01>,
      <-3.617751E+00, 3.084428E+00, -2.774686E+01>,
      <-2.813302E+00, 3.384428E+00, -2.792186E+01>,
      <-2.813302E+00, 3.384428E+00, -2.801187E+01>,
      <-3.617749E+00, 3.384428E+00, -2.801187E+01>,
      <-3.617751E+00, 3.384428E+00, -2.792186E+01>,
      <-3.617749E+00, 3.384428E+00, -2.865194E+01>,
      <-3.617749E+00, 3.384428E+00, -2.856194E+01>,
      <-2.813302E+00, 3.384428E+00, -2.856194E+01>,
      <-2.813302E+00, 3.384428E+00, -2.865194E+01>,
      <-3.317748E+00, 4.084428E+00, -2.865194E+01>,
      <-3.31775E+00, 4.084428E+00, -2.856194E+01>,
      <-2.813302E+00, 4.084428E+00, -2.856194E+01>,
      <-2.813302E+00, 4.084428E+00, -2.865194E+01>,
      <-2.813302E+00, 4.084428E+00, -2.792186E+01>,
      <-2.813302E+00, 4.084428E+00, -2.801187E+01>,
      <-3.317748E+00, 4.084428E+00, -2.801187E+01>,
      <-3.317748E+00, 4.084428E+00, -2.792186E+01>,
      <-3.512847E+00, 3.51394E+00, -2.801187E+01>,
      <-3.512847E+00, 3.60394E+00, -2.801187E+01>,
      <-2.813302E+00, 3.60394E+00, -2.801187E+01>,
      <-2.813302E+00, 3.51394E+00, -2.801187E+01>,
      <-2.813302E+00, 3.51394E+00, -2.856194E+01>,
      <-2.813302E+00, 3.60394E+00, -2.856194E+01>,
      <-3.512847E+00, 3.60394E+00, -2.856194E+01>,
      <-3.512847E+00, 3.51394E+00, -2.856194E+01>
   }
 
   normal_vectors { 
      12, 
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.988061E-06, -2.609788E-01, 9.653445E-01>,
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <4.326901E-06, -2.609812E-01, -9.653439E-01>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <-9.795785E-01, 2.010621E-01, -1.578605E-05>,
      <-3.107276E-06, 2.609794E-01, 9.653444E-01>,
      <-2.920171E-06, 2.609798E-01, -9.653443E-01>,
      <-9.191465E-01, 3.939159E-01, -1.073454E-05>
   }
 
   texture_list { 
      1, 
      texture {Tex4}
   }
 
   face_indices { 
      72, 
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0,
      <11, 3, 0>, 0,
      <11, 0, 8>, 0,
      <15, 7, 4>, 0,
      <15, 4, 12>, 0,
      <16, 13, 5>, 0,
      <16, 5, 17>, 0,
      <17, 5, 6>, 0,
      <17, 6, 18>, 0,
      <18, 6, 14>, 0,
      <18, 14, 19>, 0,
      <20, 9, 1>, 0,
      <20, 1, 21>, 0,
      <21, 1, 2>, 0,
      <21, 2, 22>, 0,
      <22, 2, 10>, 0,
      <22, 10, 23>, 0,
      <24, 20, 21>, 0,
      <24, 21, 25>, 0,
      <25, 21, 22>, 0,
      <25, 22, 26>, 0,
      <26, 22, 23>, 0,
      <26, 23, 27>, 0,
      <27, 23, 20>, 0,
      <27, 20, 24>, 0,
      <28, 16, 17>, 0,
      <28, 17, 29>, 0,
      <29, 17, 18>, 0,
      <29, 18, 30>, 0,
      <30, 18, 19>, 0,
      <30, 19, 31>, 0,
      <31, 19, 16>, 0,
      <31, 16, 28>, 0,
      <32, 28, 29>, 0,
      <32, 29, 33>, 0,
      <33, 29, 30>, 0,
      <33, 30, 34>, 0,
      <34, 30, 31>, 0,
      <34, 31, 35>, 0,
      <35, 31, 28>, 0,
      <35, 28, 32>, 0,
      <36, 24, 25>, 0,
      <36, 25, 37>, 0,
      <37, 25, 26>, 0,
      <37, 26, 38>, 0,
      <38, 26, 27>, 0,
      <38, 27, 39>, 0,
      <39, 27, 24>, 0,
      <39, 24, 36>, 0,
      <35, 32, 33>, 0,
      <35, 33, 34>, 0,
      <37, 38, 39>, 0,
      <37, 39, 36>, 0,
      <11, 10, 13>, 0,
      <13, 12, 11>, 0,
      <15, 14, 9>, 0,
      <9, 8, 15>, 0,
      <11, 8, 20>, 0,
      <20, 23, 11>, 0,
      <15, 12, 16>, 0,
      <16, 19, 15>, 0,
      <43, 44, 45>, 0,
      <43, 45, 42>, 0,
      <47, 40, 41>, 0,
      <47, 41, 46>, 0,
      <41, 42, 45>, 0,
      <41, 45, 46>, 0,
      <43, 40, 47>, 0,
      <43, 47, 44>, 0
   }
 
   normal_indices { 
      72, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 4, 4>,
      <3, 4, 3>,
      <5, 5, 5>,
      <5, 5, 5>,
      <5, 5, 5>,
      <5, 5, 5>,
      <6, 7, 7>,
      <6, 7, 6>,
      <2, 2, 2>,
      <2, 2, 2>,
      <5, 5, 5>,
      <5, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <8, 2, 2>,
      <8, 2, 8>,
      <9, 9, 9>,
      <9, 9, 9>,
      <8, 2, 2>,
      <8, 2, 8>,
      <3, 3, 3>,
      <3, 3, 3>,
      <5, 5, 5>,
      <5, 5, 5>,
      <10, 10, 10>,
      <10, 10, 10>,
      <11, 8, 8>,
      <11, 8, 11>,
      <4, 3, 3>,
      <4, 3, 4>,
      <5, 5, 5>,
      <5, 5, 5>,
      <7, 10, 10>,
      <7, 10, 7>,
      <5, 5, 5>,
      <5, 5, 5>,
      <7, 6, 6>,
      <7, 6, 7>,
      <11, 8, 8>,
      <11, 8, 11>,
      <4, 9, 9>,
      <4, 9, 4>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <2, 2, 2>,
      <2, 2, 2>,
      <5, 5, 5>,
      <5, 5, 5>,
      <4, 4, 9>,
      <9, 9, 4>,
      <7, 7, 10>,
      <10, 10, 7>,
      <5, 5, 5>,
      <5, 5, 5>,
      <2, 2, 2>,
      <2, 2, 2>,
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>
   }
}
 
// StepAftPort
mesh2 {
 
   vertex_vectors { 
      48, 
      <5.550752E+00, 2.584428E+00, 1.304977E+01>,
      <5.550752E+00, 2.684428E+00, 1.304977E+01>,
      <6.355199E+00, 2.684428E+00, 1.304977E+01>,
      <6.355199E+00, 2.584428E+00, 1.304977E+01>,
      <6.355199E+00, 2.584428E+00, 1.214977E+01>,
      <6.355201E+00, 2.684428E+00, 1.21497E+01>,
      <5.550752E+00, 2.684428E+00, 1.21497E+01>,
      <5.550752E+00, 2.584428E+00, 1.214978E+01>,
      <5.550752E+00, 2.584428E+00, 1.313977E+01>,
      <5.550752E+00, 2.684428E+00, 1.313977E+01>,
      <6.355201E+00, 2.684428E+00, 1.313978E+01>,
      <6.355201E+00, 2.584428E+00, 1.313978E+01>,
      <6.355199E+00, 2.584428E+00, 1.205977E+01>,
      <6.355199E+00, 2.684428E+00, 1.205969E+01>,
      <5.550752E+00, 2.684428E+00, 1.20597E+01>,
      <5.550752E+00, 2.584428E+00, 1.205977E+01>,
      <6.355199E+00, 3.084428E+00, 1.205969E+01>,
      <6.355201E+00, 3.084428E+00, 1.21497E+01>,
      <5.550752E+00, 3.084428E+00, 1.21497E+01>,
      <5.550752E+00, 3.084428E+00, 1.20597E+01>,
      <5.550752E+00, 3.084428E+00, 1.313977E+01>,
      <5.550752E+00, 3.084428E+00, 1.304977E+01>,
      <6.355199E+00, 3.084428E+00, 1.304977E+01>,
      <6.355201E+00, 3.084428E+00, 1.313978E+01>,
      <5.550752E+00, 3.384428E+00, 1.296478E+01>,
      <5.550752E+00, 3.384428E+00, 1.287477E+01>,
      <6.355199E+00, 3.384428E+00, 1.287477E+01>,
      <6.355201E+00, 3.384428E+00, 1.296477E+01>,
      <6.355199E+00, 3.384428E+00, 1.22347E+01>,
      <6.355199E+00, 3.384428E+00, 1.23247E+01>,
      <5.550752E+00, 3.384428E+00, 1.23247E+01>,
      <5.550752E+00, 3.384428E+00, 1.223469E+01>,
      <6.055198E+00, 4.084428E+00, 1.22347E+01>,
      <6.0552E+00, 4.084428E+00, 1.23247E+01>,
      <5.550752E+00, 4.084428E+00, 1.23247E+01>,
      <5.550752E+00, 4.084428E+00, 1.223469E+01>,
      <5.550752E+00, 4.084428E+00, 1.296478E+01>,
      <5.550752E+00, 4.084428E+00, 1.287477E+01>,
      <6.055198E+00, 4.084428E+00, 1.287477E+01>,
      <6.055198E+00, 4.084428E+00, 1.296477E+01>,
      <6.250297E+00, 3.51394E+00, 1.287477E+01>,
      <6.250297E+00, 3.60394E+00, 1.287477E+01>,
      <5.550752E+00, 3.60394E+00, 1.287477E+01>,
      <5.550752E+00, 3.51394E+00, 1.287477E+01>,
      <5.550752E+00, 3.51394E+00, 1.23247E+01>,
      <5.550752E+00, 3.60394E+00, 1.23247E+01>,
      <6.250297E+00, 3.60394E+00, 1.23247E+01>,
      <6.250297E+00, 3.51394E+00, 1.23247E+01>
   }
 
   normal_vectors { 
      12, 
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <-2.351973E-06, -2.609787E-01, 9.653445E-01>,
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <-3.048847E-06, -2.609811E-01, -9.65344E-01>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <9.795789E-01, 2.010603E-01, -1.461858E-05>,
      <2.883744E-06, 2.609797E-01, 9.653443E-01>,
      <3.512848E-06, 2.609794E-01, -9.653444E-01>,
      <9.191443E-01, 3.939209E-01, -1.013556E-05>
   }
 
   texture_list { 
      1, 
      texture {Tex4}
   }
 
   face_indices { 
      72, 
      <1, 2, 5>, 0,
      <1, 5, 6>, 0,
      <3, 0, 7>, 0,
      <3, 7, 4>, 0,
      <11, 8, 0>, 0,
      <11, 0, 3>, 0,
      <15, 12, 4>, 0,
      <15, 4, 7>, 0,
      <16, 17, 5>, 0,
      <16, 5, 13>, 0,
      <17, 18, 6>, 0,
      <17, 6, 5>, 0,
      <18, 19, 14>, 0,
      <18, 14, 6>, 0,
      <20, 21, 1>, 0,
      <20, 1, 9>, 0,
      <21, 22, 2>, 0,
      <21, 2, 1>, 0,
      <22, 23, 10>, 0,
      <22, 10, 2>, 0,
      <24, 25, 21>, 0,
      <24, 21, 20>, 0,
      <25, 26, 22>, 0,
      <25, 22, 21>, 0,
      <26, 27, 23>, 0,
      <26, 23, 22>, 0,
      <27, 24, 20>, 0,
      <27, 20, 23>, 0,
      <28, 29, 17>, 0,
      <28, 17, 16>, 0,
      <29, 30, 18>, 0,
      <29, 18, 17>, 0,
      <30, 31, 19>, 0,
      <30, 19, 18>, 0,
      <31, 28, 16>, 0,
      <31, 16, 19>, 0,
      <32, 33, 29>, 0,
      <32, 29, 28>, 0,
      <33, 34, 30>, 0,
      <33, 30, 29>, 0,
      <34, 35, 31>, 0,
      <34, 31, 30>, 0,
      <35, 32, 28>, 0,
      <35, 28, 31>, 0,
      <36, 37, 25>, 0,
      <36, 25, 24>, 0,
      <37, 38, 26>, 0,
      <37, 26, 25>, 0,
      <38, 39, 27>, 0,
      <38, 27, 26>, 0,
      <39, 36, 24>, 0,
      <39, 24, 27>, 0,
      <35, 34, 33>, 0,
      <35, 33, 32>, 0,
      <37, 36, 39>, 0,
      <37, 39, 38>, 0,
      <13, 10, 11>, 0,
      <11, 12, 13>, 0,
      <9, 14, 15>, 0,
      <15, 8, 9>, 0,
      <20, 8, 11>, 0,
      <11, 23, 20>, 0,
      <16, 12, 15>, 0,
      <15, 19, 16>, 0,
      <43, 42, 45>, 0,
      <43, 45, 44>, 0,
      <47, 46, 41>, 0,
      <47, 41, 40>, 0,
      <41, 46, 45>, 0,
      <41, 45, 42>, 0,
      <43, 44, 47>, 0,
      <43, 47, 40>, 0
   }
 
   normal_indices { 
      72, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 4>,
      <3, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>,
      <5, 5, 5>,
      <5, 5, 5>,
      <6, 6, 7>,
      <6, 7, 7>,
      <2, 2, 2>,
      <2, 2, 2>,
      <5, 5, 5>,
      <5, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <8, 8, 2>,
      <8, 2, 2>,
      <9, 9, 9>,
      <9, 9, 9>,
      <8, 8, 2>,
      <8, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <5, 5, 5>,
      <5, 5, 5>,
      <10, 10, 10>,
      <10, 10, 10>,
      <11, 11, 8>,
      <11, 8, 8>,
      <4, 4, 3>,
      <4, 3, 3>,
      <5, 5, 5>,
      <5, 5, 5>,
      <7, 7, 10>,
      <7, 10, 10>,
      <5, 5, 5>,
      <5, 5, 5>,
      <7, 7, 6>,
      <7, 6, 6>,
      <11, 11, 8>,
      <11, 8, 8>,
      <4, 4, 9>,
      <4, 9, 9>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <2, 2, 2>,
      <2, 2, 2>,
      <5, 5, 5>,
      <5, 5, 5>,
      <9, 4, 4>,
      <4, 9, 9>,
      <10, 7, 7>,
      <7, 10, 10>,
      <5, 5, 5>,
      <5, 5, 5>,
      <2, 2, 2>,
      <2, 2, 2>,
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>
   }
}
 
// StepAftStar
mesh2 {
 
   vertex_vectors { 
      48, 
      <-2.813315E+00, 2.584428E+00, 1.304977E+01>,
      <-2.813315E+00, 2.684428E+00, 1.304977E+01>,
      <-3.617763E+00, 2.684428E+00, 1.304976E+01>,
      <-3.617763E+00, 2.584428E+00, 1.304976E+01>,
      <-3.617762E+00, 2.584428E+00, 1.214977E+01>,
      <-3.617764E+00, 2.684428E+00, 1.21497E+01>,
      <-2.813315E+00, 2.684428E+00, 1.21497E+01>,
      <-2.813315E+00, 2.584428E+00, 1.214978E+01>,
      <-2.813315E+00, 2.584428E+00, 1.313977E+01>,
      <-2.813315E+00, 2.684428E+00, 1.313977E+01>,
      <-3.617764E+00, 2.684428E+00, 1.313977E+01>,
      <-3.617764E+00, 2.584428E+00, 1.313977E+01>,
      <-3.617762E+00, 2.584428E+00, 1.205977E+01>,
      <-3.617762E+00, 2.684428E+00, 1.205969E+01>,
      <-2.813315E+00, 2.684428E+00, 1.20597E+01>,
      <-2.813315E+00, 2.584428E+00, 1.205977E+01>,
      <-3.617762E+00, 3.084428E+00, 1.205969E+01>,
      <-3.617764E+00, 3.084428E+00, 1.21497E+01>,
      <-2.813315E+00, 3.084428E+00, 1.21497E+01>,
      <-2.813315E+00, 3.084428E+00, 1.20597E+01>,
      <-2.813315E+00, 3.084428E+00, 1.313977E+01>,
      <-2.813315E+00, 3.084428E+00, 1.304977E+01>,
      <-3.617763E+00, 3.084428E+00, 1.304976E+01>,
      <-3.617764E+00, 3.084428E+00, 1.313977E+01>,
      <-2.813315E+00, 3.384428E+00, 1.296477E+01>,
      <-2.813315E+00, 3.384428E+00, 1.287477E+01>,
      <-3.617763E+00, 3.384428E+00, 1.287477E+01>,
      <-3.617764E+00, 3.384428E+00, 1.296477E+01>,
      <-3.617762E+00, 3.384428E+00, 1.223469E+01>,
      <-3.617762E+00, 3.384428E+00, 1.232469E+01>,
      <-2.813315E+00, 3.384428E+00, 1.23247E+01>,
      <-2.813315E+00, 3.384428E+00, 1.223469E+01>,
      <-3.317761E+00, 4.084428E+00, 1.223469E+01>,
      <-3.317763E+00, 4.084428E+00, 1.23247E+01>,
      <-2.813315E+00, 4.084428E+00, 1.23247E+01>,
      <-2.813315E+00, 4.084428E+00, 1.223469E+01>,
      <-2.813315E+00, 4.084428E+00, 1.296477E+01>,
      <-2.813315E+00, 4.084428E+00, 1.287477E+01>,
      <-3.317761E+00, 4.084428E+00, 1.287477E+01>,
      <-3.317761E+00, 4.084428E+00, 1.296477E+01>,
      <-3.51286E+00, 3.51394E+00, 1.287477E+01>,
      <-3.51286E+00, 3.60394E+00, 1.287477E+01>,
      <-2.813315E+00, 3.60394E+00, 1.287477E+01>,
      <-2.813315E+00, 3.51394E+00, 1.287477E+01>,
      <-2.813315E+00, 3.51394E+00, 1.23247E+01>,
      <-2.813315E+00, 3.60394E+00, 1.23247E+01>,
      <-3.51286E+00, 3.60394E+00, 1.23247E+01>,
      <-3.51286E+00, 3.51394E+00, 1.23247E+01>
   }
 
   normal_vectors { 
      12, 
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.988061E-06, -2.609788E-01, 9.653445E-01>,
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <3.943132E-06, -2.609812E-01, -9.653439E-01>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <-9.795788E-01, 2.010607E-01, -1.57861E-05>,
      <-3.549264E-06, 2.609794E-01, 9.653444E-01>,
      <-2.920171E-06, 2.609796E-01, -9.653443E-01>,
      <-9.191452E-01, 3.939188E-01, -1.073452E-05>
   }
 
   texture_list { 
      1, 
      texture {Tex4}
   }
 
   face_indices { 
      72, 
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0,
      <11, 3, 0>, 0,
      <11, 0, 8>, 0,
      <15, 7, 4>, 0,
      <15, 4, 12>, 0,
      <16, 13, 5>, 0,
      <16, 5, 17>, 0,
      <17, 5, 6>, 0,
      <17, 6, 18>, 0,
      <18, 6, 14>, 0,
      <18, 14, 19>, 0,
      <20, 9, 1>, 0,
      <20, 1, 21>, 0,
      <21, 1, 2>, 0,
      <21, 2, 22>, 0,
      <22, 2, 10>, 0,
      <22, 10, 23>, 0,
      <24, 20, 21>, 0,
      <24, 21, 25>, 0,
      <25, 21, 22>, 0,
      <25, 22, 26>, 0,
      <26, 22, 23>, 0,
      <26, 23, 27>, 0,
      <27, 23, 20>, 0,
      <27, 20, 24>, 0,
      <28, 16, 17>, 0,
      <28, 17, 29>, 0,
      <29, 17, 18>, 0,
      <29, 18, 30>, 0,
      <30, 18, 19>, 0,
      <30, 19, 31>, 0,
      <31, 19, 16>, 0,
      <31, 16, 28>, 0,
      <32, 28, 29>, 0,
      <32, 29, 33>, 0,
      <33, 29, 30>, 0,
      <33, 30, 34>, 0,
      <34, 30, 31>, 0,
      <34, 31, 35>, 0,
      <35, 31, 28>, 0,
      <35, 28, 32>, 0,
      <36, 24, 25>, 0,
      <36, 25, 37>, 0,
      <37, 25, 26>, 0,
      <37, 26, 38>, 0,
      <38, 26, 27>, 0,
      <38, 27, 39>, 0,
      <39, 27, 24>, 0,
      <39, 24, 36>, 0,
      <35, 32, 33>, 0,
      <35, 33, 34>, 0,
      <37, 38, 39>, 0,
      <37, 39, 36>, 0,
      <11, 10, 13>, 0,
      <13, 12, 11>, 0,
      <15, 14, 9>, 0,
      <9, 8, 15>, 0,
      <11, 8, 20>, 0,
      <20, 23, 11>, 0,
      <15, 12, 16>, 0,
      <16, 19, 15>, 0,
      <43, 44, 45>, 0,
      <43, 45, 42>, 0,
      <47, 40, 41>, 0,
      <47, 41, 46>, 0,
      <41, 42, 45>, 0,
      <41, 45, 46>, 0,
      <43, 40, 47>, 0,
      <43, 47, 44>, 0
   }
 
   normal_indices { 
      72, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 4, 4>,
      <3, 4, 3>,
      <5, 5, 5>,
      <5, 5, 5>,
      <5, 5, 5>,
      <5, 5, 5>,
      <6, 7, 7>,
      <6, 7, 6>,
      <2, 2, 2>,
      <2, 2, 2>,
      <5, 5, 5>,
      <5, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <8, 2, 2>,
      <8, 2, 8>,
      <9, 9, 9>,
      <9, 9, 9>,
      <8, 2, 2>,
      <8, 2, 8>,
      <3, 3, 3>,
      <3, 3, 3>,
      <5, 5, 5>,
      <5, 5, 5>,
      <10, 10, 10>,
      <10, 10, 10>,
      <11, 8, 8>,
      <11, 8, 11>,
      <4, 3, 3>,
      <4, 3, 4>,
      <5, 5, 5>,
      <5, 5, 5>,
      <7, 10, 10>,
      <7, 10, 7>,
      <5, 5, 5>,
      <5, 5, 5>,
      <7, 6, 6>,
      <7, 6, 7>,
      <11, 8, 8>,
      <11, 8, 11>,
      <4, 9, 9>,
      <4, 9, 4>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <2, 2, 2>,
      <2, 2, 2>,
      <5, 5, 5>,
      <5, 5, 5>,
      <4, 4, 9>,
      <9, 9, 4>,
      <7, 7, 10>,
      <10, 10, 7>,
      <5, 5, 5>,
      <5, 5, 5>,
      <2, 2, 2>,
      <2, 2, 2>,
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>
   }
}
 
#declare Tex5 =
texture {
   pigment {rgbf <9.215686E-01, 9.254902E-01, 9.137255E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// SoleBar
mesh2 {
 
   vertex_vectors { 
      10, 
      <2.233867E+00, 5.084142E+00, 1.214437E+01>,
      <4.32401E-01, 5.084142E+00, 1.214437E+01>,
      <4.32401E-01, 4.384142E+00, 1.214437E+01>,
      <2.233867E+00, 4.384142E+00, 1.214437E+01>,
      <2.23388E+00, 5.084142E+00, -2.765684E+01>,
      <2.23388E+00, 4.384142E+00, -2.765684E+01>,
      <4.324121E-01, 4.384142E+00, -2.765684E+01>,
      <4.324121E-01, 5.084142E+00, -2.765684E+01>,
      <4.324141E-01, 5.084142E+00, -2.225401E+01>,
      <2.305047E+00, 5.084142E+00, -2.225401E+01>
   }
 
   normal_vectors { 
      5, 
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <9.992193E-01, -3.950744E-02, 3.25587E-07>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <-3.258414E-07, 0.00E+00, 1.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex5}
   }
 
   face_indices { 
      10, 
      <5, 3, 2>, 0,
      <5, 2, 6>, 0,
      <7, 6, 2>, 0,
      <2, 1, 7>, 0,
      <0, 3, 5>, 0,
      <5, 4, 0>, 0,
      <5, 6, 7>, 0,
      <5, 7, 4>, 0,
      <3, 0, 1>, 0,
      <3, 1, 2>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
#declare Tex6 =
texture {
   pigment {rgbf <1.00E+00, 1.00E+00, 1.00E+00, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.00E-01 brilliance 1.00E+00 specular 6.25E-02 roughness 1.25E-01}
}
 
// SoleDeck3
mesh2 {
 
   vertex_vectors { 
      4, 
      <6.250311E+00, 5.084144E+00, 1.054437E+01>,
      <-3.512877E+00, 5.084144E+00, 1.054126E+01>,
      <-3.512876E+00, 5.084142E+00, 9.544369E+00>,
      <6.250315E+00, 5.084142E+00, 9.544374E+00>
   }
 
   normal_vectors { 
      1, 
      <0.00E+00, 1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex6}
   }
 
   face_indices { 
      2, 
      <0, 3, 2>, 0,
      <0, 2, 1>, 0
   }
 
   normal_indices { 
      2, 
      <0, 0, 0>,
      <0, 0, 0>
   }
}
 
// SoleDeck2
mesh2 {
 
   vertex_vectors { 
      4, 
      <6.050326E+00, 5.084142E+00, -2.2254E+01>,
      <-3.312865E+00, 5.084142E+00, -2.225401E+01>,
      <-3.313276E+00, 5.084142E+00, -2.486323E+01>,
      <6.050327E+00, 5.084142E+00, -2.485684E+01>
   }
 
   normal_vectors { 
      1, 
      <0.00E+00, 1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex6}
   }
 
   face_indices { 
      2, 
      <0, 3, 2>, 0,
      <0, 2, 1>, 0
   }
 
   normal_indices { 
      2, 
      <0, 0, 0>,
      <0, 0, 0>
   }
}
 
// SoleDeck1
mesh2 {
 
   vertex_vectors { 
      4, 
      <6.250326E+00, 5.084142E+00, -2.485684E+01>,
      <-3.513277E+00, 5.084142E+00, -2.486323E+01>,
      <-3.513277E+00, 5.084144E+00, -2.622872E+01>,
      <6.250327E+00, 5.084144E+00, -2.622233E+01>
   }
 
   normal_vectors { 
      1, 
      <0.00E+00, 1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex6}
   }
 
   face_indices { 
      2, 
      <0, 3, 2>, 0,
      <0, 2, 1>, 0
   }
 
   normal_indices { 
      2, 
      <0, 0, 0>,
      <0, 0, 0>
   }
}
 
#declare Tex7 =
texture {
   pigment {rgbf <8.00E-01, 7.843137E-01, 9.764706E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// Body
mesh2 {
 
   vertex_vectors { 
      180, 
      <6.168512E+00, 4.923059E+00, 1.15888E+01>,
      <6.168508E+00, 1.295892E+01, 1.15888E+01>,
      <-3.431487E+00, 1.295892E+01, 1.158879E+01>,
      <-3.431487E+00, 4.923059E+00, 1.158879E+01>,
      <-3.431474E+00, 4.923058E+00, -2.759872E+01>,
      <-3.431474E+00, 1.295892E+01, -2.759871E+01>,
      <6.168525E+00, 1.295892E+01, -2.759871E+01>,
      <6.168525E+00, 4.923058E+00, -2.759872E+01>,
      <6.368513E+00, 1.295892E+01, 1.15888E+01>,
      <6.368513E+00, 4.923061E+00, 1.15888E+01>,
      <-3.631487E+00, 4.92306E+00, 1.158879E+01>,
      <-3.631487E+00, 1.295892E+01, 1.158879E+01>,
      <6.168519E+00, 1.295892E+01, -9.520212E+00>,
      <-3.431484E+00, 1.295892E+01, -9.520216E+00>,
      <-3.431481E+00, 4.923061E+00, -1.819371E+01>,
      <6.168521E+00, 4.923061E+00, -1.81937E+01>,
      <-3.431474E+00, 5.139661E+00, -2.759871E+01>,
      <-3.431481E+00, 5.139661E+00, -1.819371E+01>,
      <6.168521E+00, 5.139661E+00, -1.81937E+01>,
      <6.168525E+00, 5.139661E+00, -2.759871E+01>,
      <-3.631482E+00, 1.295892E+01, -6.176214E+00>,
      <-3.431481E+00, 1.295892E+01, -6.176214E+00>,
      <6.368518E+00, 1.295892E+01, -6.176211E+00>,
      <6.168521E+00, 1.295892E+01, -6.176211E+00>,
      <6.368515E+00, 1.328382E+01, -6.698706E+00>,
      <6.168519E+00, 1.328382E+01, -9.520212E+00>,
      <6.168518E+00, 1.328382E+01, -6.69871E+00>,
      <-3.431481E+00, 1.328382E+01, -6.698713E+00>,
      <-3.431484E+00, 1.328382E+01, -9.520216E+00>,
      <-3.631485E+00, 1.328382E+01, -6.698713E+00>,
      <-3.331482E+00, 1.360872E+01, -6.959959E+00>,
      <-3.331485E+00, 1.360872E+01, -9.520212E+00>,
      <-3.331483E+00, 1.360872E+01, -2.644921E+01>,
      <-3.53148E+00, 1.360872E+01, -2.644921E+01>,
      <-3.531487E+00, 1.360872E+01, -6.959962E+00>,
      <6.268524E+00, 1.360872E+01, -6.959956E+00>,
      <6.268523E+00, 1.360872E+01, -2.644921E+01>,
      <6.068526E+00, 1.360872E+01, -2.644921E+01>,
      <6.068521E+00, 1.360872E+01, -9.520212E+00>,
      <6.06852E+00, 1.360872E+01, -6.95996E+00>,
      <6.118515E+00, 1.393362E+01, -7.168959E+00>,
      <6.118521E+00, 1.393362E+01, -2.624021E+01>,
      <5.918524E+00, 1.393362E+01, -2.624021E+01>,
      <5.918519E+00, 1.393362E+01, -9.520208E+00>,
      <5.918518E+00, 1.393362E+01, -7.168959E+00>,
      <-3.181488E+00, 1.393362E+01, -7.168962E+00>,
      <-3.18148E+00, 1.393362E+01, -9.520212E+00>,
      <-3.181474E+00, 1.393362E+01, -2.624021E+01>,
      <-3.381479E+00, 1.393362E+01, -2.624021E+01>,
      <-3.381485E+00, 1.393362E+01, -7.168962E+00>,
      <-2.881485E+00, 1.436682E+01, -7.795965E+00>,
      <-2.881484E+00, 1.436682E+01, -9.520215E+00>,
      <-2.881479E+00, 1.436682E+01, -2.571771E+01>,
      <-3.081476E+00, 1.436682E+01, -2.571771E+01>,
      <-3.081486E+00, 1.436682E+01, -7.795965E+00>,
      <5.818516E+00, 1.436682E+01, -7.795962E+00>,
      <5.818526E+00, 1.436682E+01, -2.571771E+01>,
      <5.618521E+00, 1.436682E+01, -2.571771E+01>,
      <5.618524E+00, 1.436682E+01, -9.520209E+00>,
      <5.618515E+00, 1.436682E+01, -7.795962E+00>,
      <6.368529E+00, 1.328382E+01, -2.702396E+01>,
      <6.168524E+00, 1.328382E+01, -2.702396E+01>,
      <-3.429384E+00, 1.328382E+01, -2.703731E+01>,
      <-3.629388E+00, 1.328382E+01, -2.70373E+01>,
      <-3.427589E+00, 1.315402E+01, -9.673864E+00>,
      <6.17241E+00, 1.315402E+01, -9.673861E+00>,
      <6.172417E+00, 5.334761E+00, -1.834736E+01>,
      <-3.427586E+00, 5.33476E+00, -1.834736E+01>,
      <-3.431484E+00, 1.350941E+01, -9.281782E+00>,
      <-3.431484E+00, 1.331431E+01, -9.125994E+00>,
      <6.168519E+00, 1.331431E+01, -9.125994E+00>,
      <6.168519E+00, 1.350941E+01, -9.281778E+00>,
      <-3.335479E+00, 1.386481E+01, -8.887564E+00>,
      <-3.335479E+00, 1.366971E+01, -8.731771E+00>,
      <6.072518E+00, 1.366971E+01, -8.731768E+00>,
      <6.072518E+00, 1.386481E+01, -8.887564E+00>,
      <-3.10028E+00, 1.422021E+01, -8.493345E+00>,
      <-3.100281E+00, 1.402511E+01, -8.337553E+00>,
      <5.837319E+00, 1.402511E+01, -8.337549E+00>,
      <5.837319E+00, 1.42202E+01, -8.493341E+00>,
      <-2.653404E+00, 1.45756E+01, -8.099126E+00>,
      <-2.653404E+00, 1.43805E+01, -7.943334E+00>,
      <5.390438E+00, 1.438051E+01, -7.943335E+00>,
      <5.390435E+00, 1.45756E+01, -8.099132E+00>,
      <-1.439018E+00, 1.49953E+01, -7.628324E+00>,
      <-1.439018E+00, 1.480021E+01, -7.472531E+00>,
      <4.176052E+00, 1.480021E+01, -7.472529E+00>,
      <4.176052E+00, 1.49953E+01, -7.628329E+00>,
      <-3.431475E+00, 5.139659E+00, -2.493397E+01>,
      <-3.431475E+00, 1.295892E+01, -2.493396E+01>,
      <6.168524E+00, 1.295892E+01, -2.493395E+01>,
      <6.168524E+00, 5.139659E+00, -2.493396E+01>,
      <-1.081476E+00, 5.13966E+00, -2.493396E+01>,
      <-1.081475E+00, 5.139662E+00, -2.759872E+01>,
      <-1.081475E+00, 1.295892E+01, -2.759871E+01>,
      <-1.081476E+00, 1.295892E+01, -2.493396E+01>,
      <3.818521E+00, 1.295892E+01, -2.493396E+01>,
      <3.818522E+00, 1.295892E+01, -2.759871E+01>,
      <3.818522E+00, 5.139659E+00, -2.759871E+01>,
      <3.818525E+00, 5.139658E+00, -2.493396E+01>,
      <3.668524E+00, 5.139658E+00, -2.493396E+01>,
      <3.818525E+00, 5.139656E+00, -2.477722E+01>,
      <6.168524E+00, 5.139661E+00, -2.477721E+01>,
      <6.168524E+00, 1.295892E+01, -2.477721E+01>,
      <3.668524E+00, 1.295892E+01, -2.477721E+01>,
      <3.668524E+00, 5.139656E+00, -2.477722E+01>,
      <-9.314747E-01, 5.139658E+00, -2.493396E+01>,
      <-9.314747E-01, 1.295892E+01, -2.493396E+01>,
      <-1.081476E+00, 1.295892E+01, -2.477721E+01>,
      <-3.431475E+00, 1.295892E+01, -2.477721E+01>,
      <-3.431475E+00, 5.139661E+00, -2.477721E+01>,
      <-1.081476E+00, 5.139661E+00, -2.477721E+01>,
      <-9.314747E-01, 5.139661E+00, -2.477721E+01>,
      <-9.314747E-01, 1.295892E+01, -2.477721E+01>,
      <6.168524E+00, 1.328382E+01, -2.477721E+01>,
      <6.168524E+00, 1.328382E+01, -2.493395E+01>,
      <6.068521E+00, 1.360872E+01, -2.477721E+01>,
      <6.068521E+00, 1.360872E+01, -2.493395E+01>,
      <-3.431475E+00, 1.328382E+01, -2.493396E+01>,
      <-3.431475E+00, 1.328382E+01, -2.477721E+01>,
      <-3.331476E+00, 1.360872E+01, -2.493397E+01>,
      <-3.331476E+00, 1.360872E+01, -2.477721E+01>,
      <-3.231474E+00, 1.393362E+01, -2.493396E+01>,
      <-3.231474E+00, 1.393362E+01, -2.477721E+01>,
      <5.968523E+00, 1.393362E+01, -2.477721E+01>,
      <5.968523E+00, 1.393362E+01, -2.493395E+01>,
      <-1.081476E+00, 1.436682E+01, -2.493396E+01>,
      <-2.881479E+00, 1.436682E+01, -2.493396E+01>,
      <-2.881479E+00, 1.436682E+01, -2.477721E+01>,
      <-1.081476E+00, 1.436682E+01, -2.477721E+01>,
      <-9.314747E-01, 1.436682E+01, -2.477721E+01>,
      <3.668524E+00, 1.436682E+01, -2.477721E+01>,
      <5.619284E+00, 1.436682E+01, -2.477721E+01>,
      <5.619284E+00, 1.436682E+01, -2.493395E+01>,
      <3.818518E+00, 1.436682E+01, -2.493396E+01>,
      <-9.314747E-01, 1.436682E+01, -2.493396E+01>,
      <6.368522E+00, 1.295892E+01, -2.73897E+01>,
      <6.168525E+00, 1.295892E+01, -2.73897E+01>,
      <-3.631479E+00, 1.295892E+01, -2.738971E+01>,
      <-3.431474E+00, 1.295892E+01, -2.738971E+01>,
      <6.368526E+00, 4.923059E+00, -2.73897E+01>,
      <6.368526E+00, 1.328382E+01, -2.718071E+01>,
      <6.168525E+00, 1.328382E+01, -2.718071E+01>,
      <6.168525E+00, 1.312137E+01, -2.733747E+01>,
      <6.368522E+00, 1.312137E+01, -2.733747E+01>,
      <-3.430101E+00, 1.328382E+01, -2.718072E+01>,
      <-3.630105E+00, 1.328382E+01, -2.718072E+01>,
      <-3.631185E+00, 1.312137E+01, -2.733747E+01>,
      <-3.431184E+00, 1.312137E+01, -2.733747E+01>,
      <-3.430898E+00, 1.328382E+01, -2.718072E+01>,
      <-3.630899E+00, 1.328382E+01, -2.718072E+01>,
      <-3.631479E+00, 4.923059E+00, -2.738971E+01>,
      <-1.081475E+00, 1.295892E+01, -2.738971E+01>,
      <3.668525E+00, 1.295892E+01, -2.738971E+01>,
      <-9.314739E-01, 1.295892E+01, -2.738971E+01>,
      <3.818522E+00, 1.295892E+01, -2.738971E+01>,
      <-9.314739E-01, 5.13966E+00, -2.744196E+01>,
      <-9.314739E-01, 1.295892E+01, -2.744196E+01>,
      <3.668525E+00, 1.295892E+01, -2.744196E+01>,
      <3.668525E+00, 5.139659E+00, -2.744196E+01>,
      <-1.081475E+00, 1.436682E+01, -2.723297E+01>,
      <-9.314739E-01, 1.436682E+01, -2.723297E+01>,
      <-1.081475E+00, 1.420437E+01, -2.738971E+01>,
      <-9.314739E-01, 1.420437E+01, -2.738971E+01>,
      <3.668525E+00, 1.436682E+01, -2.723296E+01>,
      <3.818522E+00, 1.436682E+01, -2.723296E+01>,
      <3.818522E+00, 1.420437E+01, -2.738971E+01>,
      <3.668525E+00, 1.420437E+01, -2.738971E+01>,
      <6.368513E+00, 4.923058E+00, 1.185005E+01>,
      <6.368513E+00, 1.295892E+01, 1.185005E+01>,
      <6.118509E+00, 4.923061E+00, 1.21113E+01>,
      <6.118513E+00, 1.295892E+01, 1.21113E+01>,
      <-3.631487E+00, 1.295892E+01, 1.185004E+01>,
      <-3.631487E+00, 4.92306E+00, 1.185004E+01>,
      <-3.381491E+00, 4.923059E+00, 1.211129E+01>,
      <-3.381488E+00, 1.295892E+01, 1.211129E+01>,
      <-3.524783E-02, 1.531682E+01, -7.245404E+00>,
      <-3.524788E-02, 1.512172E+01, -7.089612E+00>,
      <2.772285E+00, 1.512172E+01, -7.089611E+00>,
      <2.772285E+00, 1.531682E+01, -7.245403E+00>
   }
 
   normal_vectors { 
      108, 
      <4.095457E-07, -1.00E+00, 2.043463E-07>,
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <-8.476294E-07, 1.373139E-05, -1.00E+00>,
      <3.928326E-01, 1.491336E-05, -9.1961E-01>,
      <-3.928339E-01, 1.492974E-05, -9.196094E-01>,
      <1.027098E-06, 9.615633E-01, 2.745835E-01>,
      <1.166068E-06, 1.00E+00, -1.195084E-06>,
      <6.913953E-07, 9.832556E-01, 1.82232E-01>,
      <-9.888765E-01, -1.487392E-01, -4.643641E-08>,
      <-1.00E+00, -1.71527E-06, -9.570044E-09>,
      <-6.227066E-06, 7.485384E-01, 6.630915E-01>,
      <9.888771E-01, -1.487349E-01, -4.886834E-07>,
      <1.00E+00, 1.904326E-06, -6.263217E-07>,
      <9.999999E-01, -2.972187E-04, 5.568084E-06>,
      <-9.411722E-07, 7.485408E-01, 6.630888E-01>,
      <9.33926E-01, -3.574665E-01, -9.019698E-08>,
      <9.339875E-01, -3.573056E-01, 1.466547E-05>,
      <-1.752696E-06, 5.846393E-01, 8.112934E-01>,
      <-9.339247E-01, -3.574699E-01, -4.151752E-07>,
      <8.682604E-01, 4.961087E-01, 2.503751E-07>,
      <9.339251E-01, 3.574688E-01, 2.262174E-07>,
      <-2.156452E-05, 6.632011E-01, -7.484412E-01>,
      <-7.452403E-06, 7.2701E-01, -6.866269E-01>,
      <-8.682615E-01, -4.961069E-01, -1.841189E-07>,
      <-6.505961E-06, 6.953571E-01, 7.186644E-01>,
      <8.682617E-01, -4.961064E-01, 8.834606E-07>,
      <9.34049E-01, -3.571448E-01, 2.942149E-05>,
      <-3.428812E-06, 7.303575E-01, -6.830651E-01>,
      <-8.682607E-01, 4.961082E-01, -3.298778E-07>,
      <-9.340528E-01, 3.571351E-01, -2.558353E-05>,
      <-9.700826E-08, 9.546544E-01, 2.977162E-01>,
      <1.1054E-07, 9.406981E-01, -3.392448E-01>,
      <8.221097E-01, -5.693292E-01, 1.600119E-06>,
      <-8.221104E-01, 5.693281E-01, -2.923397E-07>,
      <8.221096E-01, 5.693292E-01, 3.412634E-07>,
      <-8.221108E-01, -5.693276E-01, -1.304239E-07>,
      <-1.981885E-06, 9.670924E-01, -2.544255E-01>,
      <-4.687416E-06, 9.683265E-01, -2.496873E-01>,
      <2.067218E-07, 7.418313E-01, -6.705865E-01>,
      <1.946124E-07, 7.427354E-01, -6.69585E-01>,
      <9.999557E-01, -5.622651E-03, 7.545921E-03>,
      <9.999813E-01, -4.542944E-03, 4.092162E-03>,
      <9.999253E-01, -9.07776E-03, 8.184059E-03>,
      <2.506186E-07, -6.390768E-01, -7.691429E-01>,
      <-9.999253E-01, 9.082397E-03, -8.18841E-03>,
      <-9.999813E-01, 4.542219E-03, -4.094545E-03>,
      <-9.999557E-01, 5.625501E-03, -7.550045E-03>,
      <-9.96163E-01, 5.858856E-02, 6.501266E-02>,
      <-2.41338E-07, -7.427354E-01, 6.69585E-01>,
      <9.958146E-01, 5.638966E-02, 7.192736E-02>,
      <-9.558663E-01, 1.889221E-01, 2.250066E-01>,
      <9.558665E-01, 1.889208E-01, 2.250073E-01>,
      <-8.479283E-01, 3.408747E-01, 4.059827E-01>,
      <8.479288E-01, 3.408787E-01, 4.059785E-01>,
      <-6.247151E-01, 5.021076E-01, 5.980126E-01>,
      <-2.989289E-08, -7.445953E-01, 6.675162E-01>,
      <6.247156E-01, 5.021143E-01, 5.980064E-01>,
      <-1.361588E-07, 7.44595E-01, -6.675165E-01>,
      <-9.998683E-01, 0.00E+00, 1.62313E-02>,
      <9.995121E-01, 0.00E+00, 3.123508E-02>,
      <-9.280376E-01, 1.174663E-06, -3.724865E-01>,
      <9.999999E-01, -4.467803E-04, 8.665287E-06>,
      <9.28037E-01, -4.138246E-06, -3.724881E-01>,
      <-2.592617E-01, -3.363837E-07, 9.658071E-01>,
      <9.692333E-01, 6.722406E-07, -2.461439E-01>,
      <2.592656E-01, 2.913511E-07, 9.658061E-01>,
      <9.88876E-01, 1.487424E-01, -6.030289E-06>,
      <9.557538E-01, 2.941677E-01, -5.28164E-06>,
      <-9.888771E-01, 1.487348E-01, 6.030217E-06>,
      <-9.557533E-01, 2.941696E-01, 1.925746E-06>,
      <-8.827671E-01, 4.698108E-01, -3.610262E-08>,
      <8.830176E-01, 4.693399E-01, -1.990483E-06>,
      <-4.31016E-01, 9.023443E-01, -4.807831E-06>,
      <4.314909E-01, 9.021173E-01, 1.938365E-06>,
      <3.928213E-01, 5.846815E-07, 9.196148E-01>,
      <-9.692344E-01, -7.103062E-07, -2.461394E-01>,
      <-3.928147E-01, -4.908088E-07, 9.196177E-01>,
      <-9.280299E-01, -8.344946E-07, 3.725058E-01>,
      <9.280324E-01, 9.796399E-07, 3.724996E-01>,
      <7.135271E-01, 8.065413E-06, -7.006276E-01>,
      <8.521835E-01, 9.5821E-02, -5.143944E-01>,
      <-6.872289E-06, 9.20426E-01, -3.909168E-01>,
      <-2.430976E-06, 5.135641E-01, -8.580512E-01>,
      <3.967446E-01, 1.680994E-01, -9.024059E-01>,
      <3.101984E-07, 3.061229E-01, -9.51992E-01>,
      <-9.557549E-01, -2.941642E-01, -2.70687E-07>,
      <-6.044609E-07, 8.565698E-01, -5.160313E-01>,
      <-8.390363E-08, 5.782971E-01, -8.158262E-01>,
      <-3.967466E-01, 1.680996E-01, -9.024049E-01>,
      <9.559604E-01, -2.934959E-01, 5.843363E-05>,
      <9.999996E-01, -8.933182E-04, 1.675211E-05>,
      <-9.559653E-01, 2.934797E-01, -5.068616E-05>,
      <-9.692353E-01, 3.126153E-04, -2.461361E-01>,
      <-9.999999E-01, 4.389024E-04, -7.293726E-06>,
      <-9.999996E-01, 8.77756E-04, -1.430423E-05>,
      <-2.344595E-07, -6.944395E-01, 7.195511E-01>,
      <2.344539E-07, 6.944573E-01, -7.19534E-01>,
      <-7.135279E-01, 1.215028E-05, -7.006268E-01>,
      <-8.521596E-01, 9.6093E-02, -5.143833E-01>,
      <1.584916E-05, 3.744156E-01, -9.27261E-01>,
      <-3.990764E-01, 5.896003E-01, 7.022175E-01>,
      <-1.214669E-07, 7.562323E-01, -6.543032E-01>,
      <-1.578428E-07, -7.56232E-01, 6.543036E-01>,
      <3.990762E-01, 5.896088E-01, 7.022105E-01>,
      <-1.702532E-01, 6.33639E-01, 7.546624E-01>,
      <1.702537E-01, 6.336443E-01, 7.546579E-01>,
      <-2.095259E-07, -7.658408E-01, 6.430302E-01>,
      <-1.693022E-08, 7.658417E-01, -6.430292E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex7}
   }
 
   face_indices { 
      337, 
      <4, 7, 15>, 0,
      <4, 15, 14>, 0,
      <0, 3, 14>, 0,
      <0, 14, 15>, 0,
      <17, 14, 15>, 0,
      <17, 15, 18>, 0,
      <19, 7, 4>, 0,
      <19, 4, 16>, 0,
      <20, 11, 2>, 0,
      <20, 2, 21>, 0,
      <13, 2, 1>, 0,
      <1, 12, 13>, 0,
      <23, 1, 8>, 0,
      <23, 8, 22>, 0,
      <25, 12, 23>, 0,
      <25, 23, 26>, 0,
      <26, 23, 22>, 0,
      <26, 22, 24>, 0,
      <27, 21, 13>, 0,
      <27, 13, 28>, 0,
      <29, 20, 21>, 0,
      <29, 21, 27>, 0,
      <30, 27, 28>, 0,
      <30, 28, 31>, 0,
      <34, 29, 27>, 0,
      <34, 27, 30>, 0,
      <38, 25, 26>, 0,
      <38, 26, 39>, 0,
      <39, 26, 24>, 0,
      <39, 24, 35>, 0,
      <40, 35, 36>, 0,
      <40, 36, 41>, 0,
      <41, 36, 37>, 0,
      <41, 37, 42>, 0,
      <42, 37, 38>, 0,
      <42, 38, 43>, 0,
      <43, 38, 39>, 0,
      <43, 39, 44>, 0,
      <44, 39, 35>, 0,
      <44, 35, 40>, 0,
      <45, 30, 31>, 0,
      <45, 31, 46>, 0,
      <46, 31, 32>, 0,
      <46, 32, 47>, 0,
      <47, 32, 33>, 0,
      <47, 33, 48>, 0,
      <48, 33, 34>, 0,
      <48, 34, 49>, 0,
      <49, 34, 30>, 0,
      <49, 30, 45>, 0,
      <54, 50, 52>, 0,
      <52, 53, 54>, 0,
      <59, 55, 56>, 0,
      <56, 57, 59>, 0,
      <50, 45, 46>, 0,
      <50, 46, 51>, 0,
      <51, 46, 47>, 0,
      <51, 47, 52>, 0,
      <52, 47, 48>, 0,
      <52, 48, 53>, 0,
      <53, 48, 49>, 0,
      <53, 49, 54>, 0,
      <54, 49, 45>, 0,
      <54, 45, 50>, 0,
      <55, 40, 41>, 0,
      <55, 41, 56>, 0,
      <56, 41, 42>, 0,
      <56, 42, 57>, 0,
      <57, 42, 43>, 0,
      <57, 43, 58>, 0,
      <58, 43, 44>, 0,
      <58, 44, 59>, 0,
      <59, 44, 40>, 0,
      <59, 40, 55>, 0,
      <37, 36, 60>, 0,
      <37, 60, 61>, 0,
      <33, 32, 62>, 0,
      <33, 62, 63>, 0,
      <64, 65, 66>, 0,
      <64, 66, 67>, 0,
      <65, 12, 18>, 0,
      <65, 18, 66>, 0,
      <66, 18, 17>, 0,
      <66, 17, 67>, 0,
      <67, 17, 13>, 0,
      <67, 13, 64>, 0,
      <64, 13, 69>, 0,
      <64, 69, 68>, 0,
      <69, 13, 12>, 0,
      <69, 12, 70>, 0,
      <65, 71, 70>, 0,
      <65, 70, 12>, 0,
      <71, 65, 64>, 0,
      <71, 64, 68>, 0,
      <72, 68, 69>, 0,
      <72, 69, 73>, 0,
      <73, 69, 70>, 0,
      <73, 70, 74>, 0,
      <74, 70, 71>, 0,
      <74, 71, 75>, 0,
      <75, 71, 68>, 0,
      <75, 68, 72>, 0,
      <76, 72, 73>, 0,
      <76, 73, 77>, 0,
      <77, 73, 74>, 0,
      <77, 74, 78>, 0,
      <78, 74, 75>, 0,
      <78, 75, 79>, 0,
      <79, 75, 72>, 0,
      <79, 72, 76>, 0,
      <80, 76, 77>, 0,
      <80, 77, 81>, 0,
      <81, 77, 78>, 0,
      <81, 78, 82>, 0,
      <82, 78, 79>, 0,
      <82, 79, 83>, 0,
      <83, 79, 76>, 0,
      <83, 76, 80>, 0,
      <6, 7, 19>, 0,
      <5, 16, 4>, 0,
      <17, 16, 4>, 0,
      <4, 14, 17>, 0,
      <89, 13, 17>, 0,
      <89, 17, 88>, 0,
      <19, 18, 15>, 0,
      <15, 7, 19>, 0,
      <19, 16, 17>, 0,
      <17, 18, 19>, 0,
      <91, 18, 12>, 0,
      <91, 12, 90>, 0,
      <92, 88, 16>, 0,
      <92, 16, 93>, 0,
      <93, 16, 5>, 0,
      <93, 5, 94>, 0,
      <97, 6, 19>, 0,
      <97, 19, 98>, 0,
      <98, 19, 91>, 0,
      <98, 91, 99>, 0,
      <101, 99, 91>, 0,
      <101, 91, 102>, 0,
      <102, 91, 90>, 0,
      <102, 90, 103>, 0,
      <105, 100, 99>, 0,
      <105, 99, 101>, 0,
      <113, 109, 110>, 0,
      <110, 112, 113>, 0,
      <109, 89, 88>, 0,
      <109, 88, 110>, 0,
      <110, 88, 92>, 0,
      <110, 92, 111>, 0,
      <111, 92, 106>, 0,
      <111, 106, 112>, 0,
      <112, 106, 107>, 0,
      <112, 107, 113>, 0,
      <105, 102, 103>, 0,
      <103, 104, 105>, 0,
      <114, 103, 90>, 0,
      <114, 90, 115>, 0,
      <116, 114, 115>, 0,
      <116, 115, 117>, 0,
      <118, 89, 109>, 0,
      <118, 109, 119>, 0,
      <120, 118, 119>, 0,
      <120, 119, 121>, 0,
      <122, 120, 121>, 0,
      <122, 121, 123>, 0,
      <124, 116, 117>, 0,
      <124, 117, 125>, 0,
      <130, 126, 127>, 0,
      <127, 128, 130>, 0,
      <127, 122, 123>, 0,
      <127, 123, 128>, 0,
      <131, 132, 133>, 0,
      <131, 133, 134>, 0,
      <132, 124, 125>, 0,
      <132, 125, 133>, 0,
      <128, 123, 121>, 0,
      <128, 121, 119>, 0,
      <128, 119, 109>, 0,
      <128, 109, 108>, 0,
      <128, 108, 129>, 0,
      <134, 133, 125>, 0,
      <134, 125, 115>, 0,
      <134, 115, 90>, 0,
      <90, 96, 134>, 0,
      <132, 131, 104>, 0,
      <132, 104, 103>, 0,
      <132, 103, 114>, 0,
      <114, 124, 132>, 0,
      <96, 104, 131>, 0,
      <96, 131, 134>, 0,
      <108, 113, 130>, 0,
      <108, 130, 129>, 0,
      <126, 95, 89>, 0,
      <126, 89, 118>, 0,
      <126, 118, 122>, 0,
      <122, 127, 126>, 0,
      <130, 113, 95>, 0,
      <130, 95, 126>, 0,
      <130, 113, 107>, 0,
      <130, 107, 135>, 0,
      <126, 95, 113>, 0,
      <126, 113, 130>, 0,
      <131, 104, 96>, 0,
      <131, 96, 134>, 0,
      <9, 140, 136>, 0,
      <136, 8, 9>, 0,
      <7, 6, 136>, 0,
      <7, 136, 140>, 0,
      <140, 9, 0>, 0,
      <0, 7, 140>, 0,
      <136, 6, 137>, 0,
      <141, 142, 61>, 0,
      <141, 61, 60>, 0,
      <143, 144, 136>, 0,
      <143, 136, 137>, 0,
      <142, 141, 144>, 0,
      <142, 144, 143>, 0,
      <36, 35, 24>, 0,
      <60, 36, 24>, 0,
      <24, 141, 60>, 0,
      <144, 141, 24>, 0,
      <144, 24, 22>, 0,
      <144, 22, 136>, 0,
      <38, 37, 61>, 0,
      <61, 142, 25>, 0,
      <61, 25, 38>, 0,
      <143, 137, 12>, 0,
      <143, 12, 25>, 0,
      <25, 142, 143>, 0,
      <145, 146, 63>, 0,
      <145, 63, 62>, 0,
      <147, 148, 139>, 0,
      <147, 139, 138>, 0,
      <146, 145, 148>, 0,
      <146, 148, 147>, 0,
      <32, 31, 28>, 0,
      <28, 149, 62>, 0,
      <28, 62, 32>, 0,
      <139, 148, 149>, 0,
      <139, 149, 28>, 0,
      <28, 13, 139>, 0,
      <34, 33, 63>, 0,
      <63, 146, 29>, 0,
      <63, 29, 34>, 0,
      <147, 138, 20>, 0,
      <147, 20, 29>, 0,
      <29, 150, 147>, 0,
      <148, 145, 149>, 0,
      <146, 147, 150>, 0,
      <151, 10, 11>, 0,
      <11, 138, 151>, 0,
      <5, 4, 151>, 0,
      <5, 151, 138>, 0,
      <5, 138, 139>, 0,
      <10, 151, 4>, 0,
      <4, 3, 10>, 0,
      <95, 94, 5>, 0,
      <5, 89, 95>, 0,
      <97, 96, 90>, 0,
      <90, 6, 97>, 0,
      <107, 106, 156>, 0,
      <156, 157, 107>, 0,
      <93, 94, 157>, 0,
      <93, 157, 156>, 0,
      <106, 92, 93>, 0,
      <106, 93, 156>, 0,
      <157, 94, 152>, 0,
      <157, 152, 154>, 0,
      <104, 158, 159>, 0,
      <159, 105, 104>, 0,
      <97, 98, 159>, 0,
      <97, 159, 158>, 0,
      <97, 158, 153>, 0,
      <97, 153, 155>, 0,
      <159, 98, 99>, 0,
      <159, 99, 100>, 0,
      <161, 160, 126>, 0,
      <126, 130, 161>, 0,
      <152, 162, 163>, 0,
      <152, 163, 154>, 0,
      <160, 161, 163>, 0,
      <160, 163, 162>, 0,
      <95, 126, 160>, 0,
      <95, 160, 162>, 0,
      <95, 162, 152>, 0,
      <135, 107, 154>, 0,
      <135, 154, 163>, 0,
      <135, 163, 161>, 0,
      <164, 131, 134>, 0,
      <164, 134, 165>, 0,
      <166, 155, 153>, 0,
      <166, 153, 167>, 0,
      <164, 165, 166>, 0,
      <164, 166, 167>, 0,
      <104, 131, 164>, 0,
      <104, 164, 167>, 0,
      <104, 167, 153>, 0,
      <134, 96, 155>, 0,
      <134, 155, 166>, 0,
      <134, 166, 165>, 0,
      <168, 9, 8>, 0,
      <168, 8, 169>, 0,
      <168, 169, 171>, 0,
      <168, 171, 170>, 0,
      <172, 11, 10>, 0,
      <172, 10, 173>, 0,
      <174, 170, 171>, 0,
      <174, 171, 175>, 0,
      <172, 173, 174>, 0,
      <172, 174, 175>, 0,
      <170, 174, 173>, 0,
      <170, 173, 10>, 0,
      <170, 10, 9>, 0,
      <9, 168, 170>, 0,
      <175, 171, 169>, 0,
      <175, 169, 8>, 0,
      <175, 8, 11>, 0,
      <11, 172, 175>, 0,
      <84, 80, 81>, 0,
      <84, 81, 85>, 0,
      <87, 83, 80>, 0,
      <87, 80, 84>, 0,
      <85, 81, 82>, 0,
      <85, 82, 86>, 0,
      <83, 87, 86>, 0,
      <83, 86, 82>, 0,
      <176, 177, 178>, 0,
      <176, 178, 179>, 0,
      <176, 84, 85>, 0,
      <176, 85, 177>, 0,
      <177, 85, 86>, 0,
      <177, 86, 178>, 0,
      <178, 86, 87>, 0,
      <178, 87, 179>, 0,
      <179, 87, 84>, 0,
      <179, 84, 176>, 0
   }
 
   normal_indices { 
      337, 
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 3, 4>,
      <2, 4, 2>,
      <5, 6, 6>,
      <5, 6, 7>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 6, 6>,
      <7, 6, 5>,
      <8, 9, 9>,
      <8, 9, 8>,
      <10, 7, 5>,
      <10, 5, 10>,
      <11, 12, 13>,
      <11, 13, 11>,
      <14, 5, 7>,
      <14, 7, 14>,
      <15, 11, 11>,
      <15, 11, 16>,
      <17, 14, 14>,
      <17, 14, 17>,
      <18, 8, 8>,
      <18, 8, 18>,
      <17, 10, 10>,
      <17, 10, 17>,
      <19, 20, 20>,
      <19, 20, 19>,
      <21, 22, 22>,
      <21, 22, 21>,
      <23, 18, 18>,
      <23, 18, 23>,
      <23, 18, 18>,
      <23, 18, 23>,
      <24, 17, 17>,
      <24, 17, 24>,
      <25, 15, 16>,
      <25, 16, 25>,
      <25, 16, 26>,
      <25, 26, 25>,
      <21, 27, 27>,
      <21, 27, 21>,
      <28, 29, 29>,
      <28, 29, 28>,
      <24, 17, 17>,
      <24, 17, 24>,
      <30, 30, 31>,
      <31, 31, 30>,
      <30, 30, 31>,
      <31, 31, 30>,
      <32, 25, 25>,
      <32, 25, 32>,
      <32, 25, 25>,
      <32, 25, 32>,
      <31, 21, 21>,
      <31, 21, 31>,
      <33, 28, 28>,
      <33, 28, 33>,
      <30, 24, 24>,
      <30, 24, 30>,
      <34, 19, 19>,
      <34, 19, 34>,
      <31, 21, 21>,
      <31, 21, 31>,
      <35, 23, 23>,
      <35, 23, 35>,
      <35, 23, 23>,
      <35, 23, 35>,
      <30, 24, 24>,
      <30, 24, 30>,
      <22, 22, 36>,
      <22, 36, 36>,
      <27, 27, 37>,
      <27, 37, 37>,
      <38, 38, 39>,
      <38, 39, 39>,
      <40, 40, 41>,
      <40, 41, 42>,
      <43, 43, 43>,
      <43, 43, 43>,
      <44, 45, 46>,
      <44, 46, 46>,
      <46, 46, 47>,
      <46, 47, 47>,
      <48, 48, 48>,
      <48, 48, 48>,
      <40, 49, 49>,
      <40, 49, 40>,
      <38, 38, 38>,
      <38, 38, 38>,
      <50, 47, 47>,
      <50, 47, 50>,
      <48, 48, 48>,
      <48, 48, 48>,
      <51, 49, 49>,
      <51, 49, 51>,
      <39, 38, 38>,
      <39, 38, 39>,
      <52, 50, 50>,
      <52, 50, 52>,
      <48, 48, 48>,
      <48, 48, 48>,
      <53, 51, 51>,
      <53, 51, 53>,
      <39, 39, 39>,
      <39, 39, 39>,
      <54, 52, 52>,
      <54, 52, 54>,
      <55, 48, 48>,
      <55, 48, 55>,
      <56, 53, 53>,
      <56, 53, 56>,
      <57, 39, 39>,
      <57, 39, 57>,
      <58, 58, 58>,
      <59, 59, 59>,
      <45, 9, 60>,
      <60, 9, 45>,
      <61, 13, 12>,
      <61, 12, 12>,
      <12, 41, 12>,
      <12, 62, 12>,
      <6, 6, 6>,
      <6, 6, 6>,
      <9, 9, 9>,
      <9, 9, 9>,
      <0, 0, 0>,
      <0, 0, 0>,
      <3, 2, 4>,
      <3, 4, 3>,
      <4, 3, 2>,
      <4, 2, 4>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <12, 12, 12>,
      <12, 12, 12>,
      <0, 0, 0>,
      <0, 0, 0>,
      <63, 1, 1>,
      <1, 1, 63>,
      <9, 9, 9>,
      <9, 9, 9>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <12, 12, 12>,
      <12, 12, 64>,
      <1, 1, 1>,
      <1, 65, 1>,
      <66, 12, 12>,
      <66, 12, 66>,
      <67, 66, 66>,
      <67, 66, 67>,
      <68, 9, 9>,
      <68, 9, 68>,
      <69, 68, 68>,
      <69, 68, 69>,
      <70, 69, 69>,
      <70, 69, 70>,
      <71, 67, 67>,
      <71, 67, 71>,
      <6, 6, 72>,
      <72, 72, 6>,
      <72, 70, 70>,
      <72, 70, 72>,
      <6, 73, 73>,
      <6, 73, 6>,
      <73, 71, 71>,
      <73, 71, 73>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <4, 2, 2>,
      <4, 2, 2>,
      <4, 2, 2>,
      <2, 4, 4>,
      <1, 74, 65>,
      <1, 65, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <4, 75, 60>,
      <4, 60, 4>,
      <1, 63, 76>,
      <1, 76, 1>,
      <3, 3, 2>,
      <3, 2, 2>,
      <3, 2, 2>,
      <2, 2, 3>,
      <62, 64, 3>,
      <62, 3, 3>,
      <62, 64, 12>,
      <62, 12, 12>,
      <77, 77, 63>,
      <77, 63, 76>,
      <74, 65, 78>,
      <74, 78, 78>,
      <12, 62, 64>,
      <64, 12, 12>,
      <79, 3, 80>,
      <79, 80, 62>,
      <0, 0, 0>,
      <0, 0, 0>,
      <6, 6, 6>,
      <81, 81, 36>,
      <81, 36, 36>,
      <82, 82, 83>,
      <82, 83, 84>,
      <81, 81, 82>,
      <81, 82, 82>,
      <20, 20, 66>,
      <67, 20, 66>,
      <66, 66, 67>,
      <12, 66, 66>,
      <12, 66, 12>,
      <12, 12, 64>,
      <18, 18, 85>,
      <85, 8, 8>,
      <85, 8, 18>,
      <9, 9, 9>,
      <9, 9, 8>,
      <8, 8, 9>,
      <81, 86, 37>,
      <81, 37, 37>,
      <87, 82, 84>,
      <87, 84, 88>,
      <86, 81, 82>,
      <86, 82, 87>,
      <26, 16, 11>,
      <11, 11, 89>,
      <11, 89, 26>,
      <90, 90, 11>,
      <90, 11, 11>,
      <11, 13, 90>,
      <29, 29, 91>,
      <91, 91, 68>,
      <91, 68, 29>,
      <94, 92, 93>,
      <94, 93, 68>,
      <68, 68, 94>,
      <95, 95, 95>,
      <86, 87, 96>,
      <60, 9, 9>,
      <9, 92, 60>,
      <4, 97, 60>,
      <4, 60, 98>,
      <6, 6, 6>,
      <0, 0, 0>,
      <0, 0, 0>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <12, 12, 62>,
      <62, 62, 12>,
      <3, 3, 62>,
      <3, 62, 62>,
      <0, 0, 0>,
      <0, 0, 0>,
      <6, 6, 6>,
      <6, 6, 6>,
      <75, 60, 60>,
      <60, 9, 75>,
      <4, 4, 60>,
      <4, 60, 60>,
      <6, 6, 6>,
      <6, 6, 6>,
      <0, 0, 0>,
      <0, 0, 0>,
      <81, 81, 6>,
      <6, 6, 81>,
      <2, 99, 99>,
      <2, 99, 2>,
      <81, 81, 99>,
      <81, 99, 99>,
      <77, 77, 9>,
      <77, 9, 9>,
      <77, 9, 9>,
      <12, 12, 12>,
      <12, 12, 12>,
      <12, 12, 12>,
      <81, 6, 6>,
      <81, 6, 81>,
      <99, 2, 2>,
      <99, 2, 99>,
      <81, 81, 99>,
      <81, 99, 99>,
      <75, 60, 9>,
      <75, 9, 9>,
      <75, 9, 9>,
      <78, 78, 12>,
      <78, 12, 12>,
      <78, 12, 12>,
      <78, 12, 12>,
      <78, 12, 78>,
      <78, 78, 74>,
      <78, 74, 74>,
      <77, 9, 9>,
      <77, 9, 77>,
      <76, 74, 74>,
      <76, 74, 76>,
      <77, 77, 76>,
      <77, 76, 76>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <100, 54, 54>,
      <100, 54, 100>,
      <101, 57, 57>,
      <101, 57, 101>,
      <102, 55, 55>,
      <102, 55, 102>,
      <56, 103, 103>,
      <56, 103, 56>,
      <104, 104, 105>,
      <104, 105, 105>,
      <104, 100, 100>,
      <104, 100, 104>,
      <106, 102, 102>,
      <106, 102, 106>,
      <105, 103, 103>,
      <105, 103, 105>,
      <107, 101, 101>,
      <107, 101, 107>
   }
}
 
// FrameFront
mesh2 {
 
   vertex_vectors { 
      8, 
      <-3.513274E+00, 4.102202E+00, -2.76096E+01>,
      <-3.513274E+00, 5.102202E+00, -2.76096E+01>,
      <6.250329E+00, 5.102201E+00, -2.760321E+01>,
      <6.250329E+00, 4.102139E+00, -2.759871E+01>,
      <-3.513274E+00, 4.102204E+00, -2.897509E+01>,
      <-3.513274E+00, 5.102204E+00, -2.897509E+01>,
      <6.250329E+00, 5.102203E+00, -2.896871E+01>,
      <6.250329E+00, 4.102203E+00, -2.896871E+01>
   }
 
   normal_vectors { 
      6, 
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <0.00E+00, 1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex5}
   }
 
   face_indices { 
      12, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <0, 4, 7>, 0,
      <0, 7, 3>, 0,
      <7, 6, 2>, 0,
      <7, 2, 3>, 0,
      <0, 1, 5>, 0,
      <0, 5, 4>, 0,
      <2, 6, 5>, 0,
      <2, 5, 1>, 0
   }
 
   normal_indices { 
      12, 
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <0, 0, 0>,
      <0, 0, 0>,
      <4, 4, 4>,
      <4, 4, 4>,
      <1, 1, 1>,
      <1, 1, 1>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// FrameAft
mesh2 {
 
   vertex_vectors { 
      24, 
      <2.233863E+00, 5.102202E+00, 1.211473E+01>,
      <4.323992E-01, 5.102202E+00, 1.211473E+01>,
      <-3.512879E+00, 5.102202E+00, 1.211473E+01>,
      <-3.512879E+00, 4.102202E+00, 1.211473E+01>,
      <6.250312E+00, 5.102201E+00, 1.211474E+01>,
      <6.250309E+00, 4.102139E+00, 1.211474E+01>,
      <2.229758E+00, 3.702202E+00, 1.3113E+01>,
      <2.233863E+00, 5.102204E+00, 1.3113E+01>,
      <4.256125E-01, 5.102204E+00, 1.311162E+01>,
      <4.256125E-01, 3.702202E+00, 1.311162E+01>,
      <4.256128E-01, 3.702202E+00, 1.211473E+01>,
      <2.233863E+00, 3.702202E+00, 1.211473E+01>,
      <2.733928E+00, 4.102202E+00, 1.211473E+01>,
      <2.733928E+00, 5.102204E+00, 1.211473E+01>,
      <2.738212E+00, 5.102204E+00, 1.311633E+01>,
      <2.733924E+00, 4.102202E+00, 1.311474E+01>,
      <-7.438753E-02, 4.102202E+00, 1.311162E+01>,
      <-7.438753E-02, 5.102204E+00, 1.311162E+01>,
      <-7.438721E-02, 5.102204E+00, 1.211473E+01>,
      <-7.438721E-02, 4.102202E+00, 1.211473E+01>,
      <-3.512879E+00, 4.102202E+00, 1.311162E+01>,
      <-3.512879E+00, 5.102204E+00, 1.311162E+01>,
      <6.250308E+00, 5.102203E+00, 1.311474E+01>,
      <6.250308E+00, 4.102201E+00, 1.311474E+01>
   }
 
   normal_vectors { 
      8, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <-3.310068E-01, -9.436284E-01, -8.224816E-08>,
      <3.300343E-01, -9.439687E-01, 6.786758E-04>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <0.00E+00, 1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex5}
   }
 
   face_indices { 
      36, 
      <6, 7, 8>, 0,
      <6, 8, 9>, 0,
      <9, 10, 11>, 0,
      <9, 11, 6>, 0,
      <12, 11, 0>, 0,
      <12, 0, 13>, 0,
      <15, 14, 7>, 0,
      <15, 7, 6>, 0,
      <11, 12, 15>, 0,
      <11, 15, 6>, 0,
      <16, 9, 8>, 0,
      <16, 8, 17>, 0,
      <18, 1, 10>, 0,
      <18, 10, 19>, 0,
      <19, 10, 9>, 0,
      <19, 9, 16>, 0,
      <20, 16, 17>, 0,
      <20, 17, 21>, 0,
      <2, 18, 19>, 0,
      <2, 19, 3>, 0,
      <3, 19, 16>, 0,
      <3, 16, 20>, 0,
      <5, 12, 13>, 0,
      <5, 13, 4>, 0,
      <15, 23, 22>, 0,
      <15, 22, 14>, 0,
      <23, 15, 12>, 0,
      <23, 12, 5>, 0,
      <10, 1, 0>, 0,
      <10, 0, 11>, 0,
      <5, 4, 22>, 0,
      <5, 22, 23>, 0,
      <20, 21, 2>, 0,
      <20, 2, 3>, 0,
      <22, 4, 2>, 0,
      <22, 2, 21>, 0
   }
 
   normal_indices { 
      36, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 2>,
      <1, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <0, 0, 0>,
      <0, 0, 0>,
      <2, 2, 2>,
      <2, 2, 2>,
      <0, 0, 0>,
      <0, 0, 0>,
      <3, 3, 3>,
      <3, 3, 3>,
      <1, 1, 1>,
      <1, 1, 1>,
      <0, 0, 0>,
      <0, 0, 0>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 1, 1>,
      <4, 1, 4>,
      <3, 3, 3>,
      <3, 3, 3>,
      <0, 0, 0>,
      <0, 0, 0>,
      <4, 2, 2>,
      <4, 2, 4>,
      <3, 3, 3>,
      <3, 3, 3>,
      <5, 5, 5>,
      <5, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>
   }
}
 
#declare Tex8 =
texture {
   pigment {rgbf <8.431373E-01, 9.686275E-01, 8.705882E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// BodyTrough
mesh2 {
 
   vertex_vectors { 
      8, 
      <2.872618E+00, 6.73966E+00, -7.854085E+00>,
      <-1.273821E-01, 6.73966E+00, -7.854086E+00>,
      <-1.273759E-01, 6.73966E+00, -2.685408E+01>,
      <2.872624E+00, 6.73966E+00, -2.685408E+01>,
      <6.222624E+00, 8.23966E+00, -2.685408E+01>,
      <6.222618E+00, 8.23966E+00, -7.854084E+00>,
      <-3.477382E+00, 8.23966E+00, -7.854087E+00>,
      <-3.477376E+00, 8.23966E+00, -2.685408E+01>
   }
 
   normal_vectors { 
      4, 
      <-2.089443E-01, 9.779276E-01, -6.808268E-08>,
      <2.089443E-01, 9.779276E-01, 6.808268E-08>,
      <-4.086647E-01, 9.126846E-01, -1.331599E-07>,
      <4.086647E-01, 9.126846E-01, 1.331599E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex8}
   }
 
   face_indices { 
      6, 
      <0, 3, 2>, 0,
      <0, 2, 1>, 0,
      <4, 3, 0>, 0,
      <4, 0, 5>, 0,
      <6, 1, 2>, 0,
      <6, 2, 7>, 0
   }
 
   normal_indices { 
      6, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 0, 0>,
      <2, 0, 2>,
      <3, 1, 1>,
      <3, 1, 3>
   }
}
 
#declare Tex9 =
texture {
   pigment {rgbf <7.882353E-01, 7.803922E-01, 7.607843E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// Light
mesh2 {
 
   vertex_vectors { 
      20, 
      <1.372611E+00, 1.100703E+01, 1.211327E+01>,
      <1.078719E+00, 1.110253E+01, 1.211327E+01>,
      <8.970827E-01, 1.135253E+01, 1.211327E+01>,
      <8.970827E-01, 1.166154E+01, 1.211327E+01>,
      <1.078719E+00, 1.191154E+01, 1.211327E+01>,
      <1.372611E+00, 1.200703E+01, 1.211327E+01>,
      <1.666503E+00, 1.191154E+01, 1.211327E+01>,
      <1.84814E+00, 1.166154E+01, 1.211327E+01>,
      <1.84814E+00, 1.135253E+01, 1.211327E+01>,
      <1.666503E+00, 1.110253E+01, 1.211327E+01>,
      <1.372611E+00, 1.100703E+01, 1.281327E+01>,
      <1.078719E+00, 1.110253E+01, 1.281327E+01>,
      <8.970824E-01, 1.135253E+01, 1.281327E+01>,
      <8.970824E-01, 1.166154E+01, 1.281327E+01>,
      <1.078719E+00, 1.191154E+01, 1.281327E+01>,
      <1.372611E+00, 1.200703E+01, 1.281327E+01>,
      <1.666503E+00, 1.191154E+01, 1.281327E+01>,
      <1.84814E+00, 1.166154E+01, 1.281327E+01>,
      <1.84814E+00, 1.135253E+01, 1.281327E+01>,
      <1.666503E+00, 1.110253E+01, 1.281327E+01>
   }
 
   normal_vectors { 
      12, 
      <-5.30863E-14, -1.00E+00, 1.629207E-07>,
      <-5.877853E-01, -8.090169E-01, -5.971918E-08>,
      <-9.510565E-01, -3.090169E-01, -2.595483E-07>,
      <-9.510565E-01, 3.090172E-01, -3.602388E-07>,
      <-5.877849E-01, 8.090172E-01, -3.233303E-07>,
      <5.30863E-14, 1.00E+00, -1.629207E-07>,
      <5.877854E-01, 8.090168E-01, 5.971923E-08>,
      <9.510567E-01, 3.090165E-01, 2.595484E-07>,
      <9.510564E-01, -3.090175E-01, 3.602389E-07>,
      <5.87785E-01, -8.090172E-01, 3.233303E-07>,
      <-3.258414E-07, 1.629207E-07, 1.00E+00>,
      <3.258414E-07, -1.629207E-07, -1.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex9}
   }
 
   face_indices { 
      36, 
      <0, 10, 11>, 0,
      <0, 11, 1>, 0,
      <1, 11, 12>, 0,
      <1, 12, 2>, 0,
      <2, 12, 13>, 0,
      <2, 13, 3>, 0,
      <3, 13, 14>, 0,
      <3, 14, 4>, 0,
      <4, 14, 15>, 0,
      <4, 15, 5>, 0,
      <5, 15, 16>, 0,
      <5, 16, 6>, 0,
      <6, 16, 17>, 0,
      <6, 17, 7>, 0,
      <7, 17, 18>, 0,
      <7, 18, 8>, 0,
      <8, 18, 19>, 0,
      <8, 19, 9>, 0,
      <9, 19, 10>, 0,
      <9, 10, 0>, 0,
      <10, 19, 18>, 0,
      <10, 18, 17>, 0,
      <10, 17, 16>, 0,
      <10, 16, 15>, 0,
      <10, 15, 14>, 0,
      <10, 14, 13>, 0,
      <10, 13, 12>, 0,
      <10, 12, 11>, 0,
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <0, 3, 4>, 0,
      <0, 4, 5>, 0,
      <0, 5, 6>, 0,
      <0, 6, 7>, 0,
      <0, 7, 8>, 0,
      <0, 8, 9>, 0
   }
 
   normal_indices { 
      36, 
      <0, 0, 1>,
      <0, 1, 1>,
      <1, 1, 2>,
      <1, 2, 2>,
      <2, 2, 3>,
      <2, 3, 3>,
      <3, 3, 4>,
      <3, 4, 4>,
      <4, 4, 5>,
      <4, 5, 5>,
      <5, 5, 6>,
      <5, 6, 6>,
      <6, 6, 7>,
      <6, 7, 7>,
      <7, 7, 8>,
      <7, 8, 8>,
      <8, 8, 9>,
      <8, 9, 9>,
      <9, 9, 0>,
      <9, 0, 0>,
      <10, 10, 10>,
      <10, 10, 10>,
      <10, 10, 10>,
      <10, 10, 10>,
      <10, 10, 10>,
      <10, 10, 10>,
      <10, 10, 10>,
      <10, 10, 10>,
      <11, 11, 11>,
      <11, 11, 11>,
      <11, 11, 11>,
      <11, 11, 11>,
      <11, 11, 11>,
      <11, 11, 11>,
      <11, 11, 11>,
      <11, 11, 11>
   }
}
 
#declare Tex10 =
texture {
   pigment {rgbf <9.607843E-01, 7.568628E-01, 9.019608E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// LightFrame
mesh2 {
 
   vertex_vectors { 
      8, 
      <1.922611E+00, 1.095703E+01, 1.231327E+01>,
      <1.922611E+00, 1.205703E+01, 1.231327E+01>,
      <8.226121E-01, 1.205703E+01, 1.231327E+01>,
      <8.226121E-01, 1.095703E+01, 1.231327E+01>,
      <8.226122E-01, 1.095703E+01, 1.211327E+01>,
      <8.226122E-01, 1.205703E+01, 1.211327E+01>,
      <1.922611E+00, 1.205703E+01, 1.211327E+01>,
      <1.922611E+00, 1.095703E+01, 1.211327E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex10}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
#declare Tex11 =
texture {
   pigment {rgbf <9.803922E-01, 9.882353E-01, 9.411765E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// LadderSidePort
mesh2 {
 
   vertex_vectors { 
      48, 
      <-5.362265E-01, 6.603677E+00, 1.085045E+01>,
      <-5.362265E-01, 6.10925E+00, 1.085045E+01>,
      <-5.362266E-01, 5.709249E+00, 1.114106E+01>,
      <-5.362286E-01, 5.556463E+00, 1.161129E+01>,
      <-5.362288E-01, 5.709249E+00, 1.208152E+01>,
      <-5.362289E-01, 6.10925E+00, 1.237214E+01>,
      <-3.762266E-01, 6.603677E+00, 1.085045E+01>,
      <-3.762266E-01, 6.10925E+00, 1.085045E+01>,
      <-3.762267E-01, 5.709249E+00, 1.114106E+01>,
      <-3.762288E-01, 5.556463E+00, 1.161129E+01>,
      <-3.762289E-01, 5.709249E+00, 1.208152E+01>,
      <-3.76229E-01, 6.10925E+00, 1.237214E+01>,
      <-5.36229E-01, 6.047446E+00, 1.256235E+01>,
      <-3.762291E-01, 6.047446E+00, 1.256235E+01>,
      <-5.362288E-01, 5.547446E+00, 1.219908E+01>,
      <-3.76229E-01, 5.547446E+00, 1.219908E+01>,
      <-5.362286E-01, 5.356463E+00, 1.161129E+01>,
      <-3.762288E-01, 5.356463E+00, 1.161129E+01>,
      <-5.362265E-01, 5.547446E+00, 1.102351E+01>,
      <-3.762267E-01, 5.547446E+00, 1.102351E+01>,
      <-5.362264E-01, 6.047446E+00, 1.066023E+01>,
      <-3.762266E-01, 6.047446E+00, 1.066024E+01>,
      <-5.362245E-01, 6.603677E+00, 1.065045E+01>,
      <-3.762246E-01, 6.603677E+00, 1.065045E+01>,
      <-5.36227E-01, 1.370368E+01, 1.237214E+01>,
      <-5.362269E-01, 1.410368E+01, 1.208152E+01>,
      <-5.362267E-01, 1.425646E+01, 1.161129E+01>,
      <-5.362266E-01, 1.410368E+01, 1.114106E+01>,
      <-5.362265E-01, 1.370368E+01, 1.085044E+01>,
      <-5.362265E-01, 1.290925E+01, 1.085044E+01>,
      <-3.762271E-01, 1.370368E+01, 1.237214E+01>,
      <-3.76227E-01, 1.410368E+01, 1.208152E+01>,
      <-3.762269E-01, 1.425646E+01, 1.161129E+01>,
      <-3.762267E-01, 1.410368E+01, 1.114106E+01>,
      <-3.762266E-01, 1.370368E+01, 1.085044E+01>,
      <-3.762266E-01, 1.290925E+01, 1.085044E+01>,
      <-5.362264E-01, 1.376548E+01, 1.066023E+01>,
      <-3.762266E-01, 1.376548E+01, 1.066023E+01>,
      <-3.762265E-01, 1.290925E+01, 1.065044E+01>,
      <-5.362264E-01, 1.290925E+01, 1.065044E+01>,
      <-5.362265E-01, 1.426548E+01, 1.102351E+01>,
      <-3.762267E-01, 1.426548E+01, 1.102351E+01>,
      <-5.362267E-01, 1.445646E+01, 1.161129E+01>,
      <-3.762269E-01, 1.445646E+01, 1.161129E+01>,
      <-5.362269E-01, 1.426548E+01, 1.219907E+01>,
      <-3.762271E-01, 1.426548E+01, 1.219907E+01>,
      <-5.36227E-01, 1.376548E+01, 1.256235E+01>,
      <-3.762272E-01, 1.376548E+01, 1.256235E+01>
   }
 
   normal_vectors { 
      19, 
      <-2.562665E-06, -8.090176E-01, 5.877844E-01>,
      <3.135799E-07, -3.090178E-01, 9.510562E-01>,
      <2.918807E-07, -2.04814E-01, 9.78801E-01>,
      <-9.77524E-07, -1.00E+00, -7.432083E-13>,
      <2.817264E-06, -8.090179E-01, -5.87784E-01>,
      <3.163305E-06, -3.173734E-01, -9.483006E-01>,
      <1.621263E-06, -1.759392E-02, -9.998452E-01>,
      <1.00E+00, -9.77524E-07, 1.303366E-06>,
      <-1.00E+00, 9.77524E-07, -1.303366E-06>,
      <9.77524E-07, 1.00E+00, 7.432083E-13>,
      <-1.303366E-06, 5.30863E-13, 1.00E+00>,
      <-6.479466E-06, 3.090182E-01, 9.510561E-01>,
      <-1.534964E-06, 8.090176E-01, 5.877844E-01>,
      <4.267846E-06, 8.09018E-01, -5.877838E-01>,
      <2.114815E-06, 3.090187E-01, -9.51056E-01>,
      <4.717137E-07, 3.144491E-01, -9.492743E-01>,
      <1.303366E-06, -5.30863E-13, -1.00E+00>,
      <1.029884E-06, 2.048145E-01, 9.788008E-01>,
      <7.184409E-07, -3.090183E-01, -9.510561E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex11}
   }
 
   face_indices { 
      92, 
      <14, 15, 13>, 0,
      <14, 13, 12>, 0,
      <16, 17, 15>, 0,
      <16, 15, 14>, 0,
      <18, 19, 17>, 0,
      <18, 17, 16>, 0,
      <20, 21, 19>, 0,
      <20, 19, 18>, 0,
      <22, 23, 21>, 0,
      <22, 21, 20>, 0,
      <15, 10, 11>, 0,
      <15, 11, 13>, 0,
      <12, 5, 4>, 0,
      <12, 4, 14>, 0,
      <17, 9, 10>, 0,
      <17, 10, 15>, 0,
      <14, 4, 3>, 0,
      <14, 3, 16>, 0,
      <19, 8, 9>, 0,
      <19, 9, 17>, 0,
      <16, 3, 2>, 0,
      <16, 2, 18>, 0,
      <21, 7, 8>, 0,
      <21, 8, 19>, 0,
      <18, 2, 1>, 0,
      <18, 1, 20>, 0,
      <22, 0, 6>, 0,
      <22, 6, 23>, 0,
      <23, 6, 7>, 0,
      <23, 7, 21>, 0,
      <20, 1, 0>, 0,
      <20, 0, 22>, 0,
      <6, 0, 1>, 0,
      <6, 1, 7>, 0,
      <1, 2, 8>, 0,
      <1, 8, 7>, 0,
      <10, 9, 3>, 0,
      <10, 3, 4>, 0,
      <2, 3, 9>, 0,
      <2, 9, 8>, 0,
      <11, 10, 4>, 0,
      <11, 4, 5>, 0,
      <36, 37, 38>, 0,
      <36, 38, 39>, 0,
      <40, 41, 37>, 0,
      <40, 37, 36>, 0,
      <42, 43, 41>, 0,
      <42, 41, 40>, 0,
      <44, 45, 43>, 0,
      <44, 43, 42>, 0,
      <46, 47, 45>, 0,
      <46, 45, 44>, 0,
      <37, 34, 35>, 0,
      <37, 35, 38>, 0,
      <38, 35, 29>, 0,
      <38, 29, 39>, 0,
      <39, 29, 28>, 0,
      <39, 28, 36>, 0,
      <41, 33, 34>, 0,
      <41, 34, 37>, 0,
      <36, 28, 27>, 0,
      <36, 27, 40>, 0,
      <43, 32, 33>, 0,
      <43, 33, 41>, 0,
      <40, 27, 26>, 0,
      <40, 26, 42>, 0,
      <45, 31, 32>, 0,
      <45, 32, 43>, 0,
      <42, 26, 25>, 0,
      <42, 25, 44>, 0,
      <47, 30, 31>, 0,
      <47, 31, 45>, 0,
      <44, 25, 24>, 0,
      <44, 24, 46>, 0,
      <24, 25, 31>, 0,
      <24, 31, 30>, 0,
      <33, 32, 26>, 0,
      <33, 26, 27>, 0,
      <25, 26, 32>, 0,
      <25, 32, 31>, 0,
      <35, 34, 28>, 0,
      <35, 28, 29>, 0,
      <34, 33, 27>, 0,
      <34, 27, 28>, 0,
      <46, 24, 5>, 0,
      <46, 5, 12>, 0,
      <47, 46, 12>, 0,
      <13, 11, 30>, 0,
      <13, 30, 47>, 0,
      <12, 13, 47>, 0,
      <11, 5, 24>, 0,
      <11, 24, 30>, 0
   }
 
   normal_indices { 
      92, 
      <0, 0, 1>,
      <0, 1, 2>,
      <3, 3, 0>,
      <3, 0, 0>,
      <4, 4, 3>,
      <4, 3, 3>,
      <5, 5, 4>,
      <5, 4, 4>,
      <6, 6, 5>,
      <6, 5, 5>,
      <7, 7, 7>,
      <7, 7, 7>,
      <8, 8, 8>,
      <8, 8, 8>,
      <7, 7, 7>,
      <7, 7, 7>,
      <8, 8, 8>,
      <8, 8, 8>,
      <7, 7, 7>,
      <7, 7, 7>,
      <8, 8, 8>,
      <8, 8, 8>,
      <7, 7, 7>,
      <7, 7, 7>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 9, 9>,
      <9, 9, 9>,
      <7, 7, 7>,
      <7, 7, 7>,
      <8, 8, 8>,
      <8, 8, 8>,
      <10, 10, 11>,
      <10, 11, 11>,
      <11, 12, 12>,
      <11, 12, 11>,
      <13, 9, 9>,
      <13, 9, 13>,
      <12, 9, 9>,
      <12, 9, 12>,
      <14, 13, 13>,
      <14, 13, 14>,
      <15, 15, 16>,
      <15, 16, 16>,
      <13, 13, 15>,
      <13, 15, 15>,
      <9, 9, 13>,
      <9, 13, 13>,
      <12, 12, 9>,
      <12, 9, 9>,
      <11, 17, 12>,
      <11, 12, 12>,
      <7, 7, 7>,
      <7, 7, 7>,
      <3, 3, 3>,
      <3, 3, 3>,
      <8, 8, 8>,
      <8, 8, 8>,
      <7, 7, 7>,
      <7, 7, 7>,
      <8, 8, 8>,
      <8, 8, 8>,
      <7, 7, 7>,
      <7, 7, 7>,
      <8, 8, 8>,
      <8, 8, 8>,
      <7, 7, 7>,
      <7, 7, 7>,
      <8, 8, 8>,
      <8, 8, 8>,
      <7, 7, 7>,
      <7, 7, 7>,
      <8, 8, 8>,
      <8, 8, 8>,
      <18, 4, 4>,
      <18, 4, 18>,
      <0, 3, 3>,
      <0, 3, 0>,
      <4, 3, 3>,
      <4, 3, 4>,
      <10, 1, 1>,
      <10, 1, 10>,
      <1, 0, 0>,
      <1, 0, 1>,
      <8, 8, 8>,
      <8, 8, 8>,
      <17, 11, 2>,
      <7, 7, 7>,
      <7, 7, 7>,
      <2, 1, 17>,
      <14, 14, 18>,
      <14, 18, 18>
   }
}
 
// LadderSideStar
mesh2 {
 
   vertex_vectors { 
      24, 
      <-2.036229E+00, 5.556463E+00, 1.161129E+01>,
      <-2.036229E+00, 5.709249E+00, 1.208152E+01>,
      <-2.036229E+00, 6.10925E+00, 1.237214E+01>,
      <-1.876229E+00, 5.556463E+00, 1.161129E+01>,
      <-1.876229E+00, 5.709249E+00, 1.208152E+01>,
      <-1.876229E+00, 6.10925E+00, 1.237214E+01>,
      <-2.036229E+00, 6.047446E+00, 1.256235E+01>,
      <-1.876229E+00, 6.047446E+00, 1.256235E+01>,
      <-2.036229E+00, 5.547446E+00, 1.219908E+01>,
      <-1.876229E+00, 5.547446E+00, 1.219908E+01>,
      <-2.036229E+00, 5.356463E+00, 1.161129E+01>,
      <-1.876229E+00, 5.356463E+00, 1.161129E+01>,
      <-1.876219E+00, 1.255089E+01, 1.161129E+01>,
      <-1.876221E+00, 1.239811E+01, 1.208152E+01>,
      <-1.876221E+00, 1.199811E+01, 1.237214E+01>,
      <-2.036219E+00, 1.255089E+01, 1.161129E+01>,
      <-2.036221E+00, 1.239811E+01, 1.208152E+01>,
      <-2.036221E+00, 1.199811E+01, 1.237214E+01>,
      <-1.876221E+00, 1.205991E+01, 1.256235E+01>,
      <-2.036221E+00, 1.205991E+01, 1.256235E+01>,
      <-1.876221E+00, 1.255991E+01, 1.219908E+01>,
      <-2.036221E+00, 1.255991E+01, 1.219908E+01>,
      <-1.876219E+00, 1.275089E+01, 1.161129E+01>,
      <-2.036219E+00, 1.275089E+01, 1.161129E+01>
   }
 
   normal_vectors { 
      16, 
      <-2.491195E-06, -8.090177E-01, 5.877843E-01>,
      <2.093859E-07, -3.090181E-01, 9.510561E-01>,
      <3.754945E-07, -2.048143E-01, 9.788008E-01>,
      <-4.457473E-06, -9.510566E-01, 3.090169E-01>,
      <1.00E+00, -9.77524E-07, 1.303366E-06>,
      <-1.00E+00, 9.77524E-07, -1.303366E-06>,
      <4.168819E-06, 8.090178E-01, -5.877841E-01>,
      <4.982006E-06, 9.510564E-01, -3.090174E-01>,
      <1.736095E-06, 3.090186E-01, -9.51056E-01>,
      <6.013032E-06, 8.09018E-01, 5.877839E-01>,
      <2.767258E-06, 3.090185E-01, 9.51056E-01>,
      <2.070828E-06, 2.048145E-01, 9.788008E-01>,
      <6.853175E-06, 9.510565E-01, 3.090169E-01>,
      <-6.362583E-06, -8.090175E-01, -5.877845E-01>,
      <-8.061498E-06, -9.510563E-01, -3.090177E-01>,
      <-1.937937E-06, -3.090183E-01, -9.510561E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex11}
   }
 
   face_indices { 
      40, 
      <8, 9, 7>, 0,
      <8, 7, 6>, 0,
      <10, 11, 9>, 0,
      <10, 9, 8>, 0,
      <9, 4, 5>, 0,
      <9, 5, 7>, 0,
      <6, 2, 1>, 0,
      <6, 1, 8>, 0,
      <11, 3, 4>, 0,
      <11, 4, 9>, 0,
      <8, 1, 0>, 0,
      <8, 0, 10>, 0,
      <4, 3, 0>, 0,
      <4, 0, 1>, 0,
      <5, 4, 1>, 0,
      <5, 1, 2>, 0,
      <20, 21, 19>, 0,
      <20, 19, 18>, 0,
      <22, 23, 21>, 0,
      <22, 21, 20>, 0,
      <21, 16, 17>, 0,
      <21, 17, 19>, 0,
      <18, 14, 13>, 0,
      <18, 13, 20>, 0,
      <23, 15, 16>, 0,
      <23, 16, 21>, 0,
      <20, 13, 12>, 0,
      <20, 12, 22>, 0,
      <16, 15, 12>, 0,
      <16, 12, 13>, 0,
      <17, 16, 13>, 0,
      <17, 13, 14>, 0,
      <5, 2, 17>, 0,
      <5, 17, 14>, 0,
      <19, 17, 2>, 0,
      <19, 2, 6>, 0,
      <7, 5, 14>, 0,
      <7, 14, 18>, 0,
      <6, 7, 18>, 0,
      <18, 19, 6>, 0
   }
 
   normal_indices { 
      40, 
      <0, 0, 1>,
      <0, 1, 2>,
      <3, 3, 0>,
      <3, 0, 0>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>,
      <6, 7, 7>,
      <6, 7, 6>,
      <8, 6, 6>,
      <8, 6, 8>,
      <9, 9, 10>,
      <9, 10, 11>,
      <12, 12, 9>,
      <12, 9, 9>,
      <5, 5, 5>,
      <5, 5, 5>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>,
      <4, 4, 4>,
      <4, 4, 4>,
      <13, 14, 14>,
      <13, 14, 13>,
      <15, 13, 13>,
      <15, 13, 15>,
      <8, 8, 15>,
      <8, 15, 15>,
      <5, 5, 5>,
      <5, 5, 5>,
      <4, 4, 4>,
      <4, 4, 4>,
      <2, 1, 11>,
      <11, 10, 2>
   }
}
 
#declare Tex12 =
texture {
   pigment {rgbf <8.588235E-01, 8.313726E-01, 8.27451E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// LadderRungs
mesh2 {
 
   vertex_vectors { 
      48, 
      <-4.76218E-01, 1.155368E+01, 1.254467E+01>,
      <-4.76218E-01, 1.164207E+01, 1.245628E+01>,
      <-1.87622E+00, 1.164207E+01, 1.245628E+01>,
      <-1.87622E+00, 1.155368E+01, 1.254467E+01>,
      <-1.87622E+00, 1.146529E+01, 1.245628E+01>,
      <-1.87622E+00, 1.155368E+01, 1.23679E+01>,
      <-4.76218E-01, 1.155368E+01, 1.23679E+01>,
      <-4.76218E-01, 1.146529E+01, 1.245628E+01>,
      <-4.76218E-01, 1.055368E+01, 1.254467E+01>,
      <-4.76218E-01, 1.064207E+01, 1.245628E+01>,
      <-1.87622E+00, 1.064207E+01, 1.245628E+01>,
      <-1.87622E+00, 1.055368E+01, 1.254467E+01>,
      <-1.87622E+00, 1.046529E+01, 1.245628E+01>,
      <-1.87622E+00, 1.055368E+01, 1.23679E+01>,
      <-4.76218E-01, 1.055368E+01, 1.23679E+01>,
      <-4.76218E-01, 1.046529E+01, 1.245628E+01>,
      <-4.76218E-01, 9.553678E+00, 1.254467E+01>,
      <-4.76218E-01, 9.642066E+00, 1.245628E+01>,
      <-1.87622E+00, 9.642066E+00, 1.245628E+01>,
      <-1.87622E+00, 9.553678E+00, 1.254467E+01>,
      <-1.87622E+00, 9.465289E+00, 1.245628E+01>,
      <-1.87622E+00, 9.553678E+00, 1.23679E+01>,
      <-4.76218E-01, 9.553678E+00, 1.23679E+01>,
      <-4.76218E-01, 9.465289E+00, 1.245628E+01>,
      <-4.76218E-01, 8.553678E+00, 1.254467E+01>,
      <-4.76218E-01, 8.642066E+00, 1.245628E+01>,
      <-1.87622E+00, 8.642066E+00, 1.245628E+01>,
      <-1.87622E+00, 8.553678E+00, 1.254467E+01>,
      <-1.87622E+00, 8.465289E+00, 1.245628E+01>,
      <-1.87622E+00, 8.553678E+00, 1.23679E+01>,
      <-4.76218E-01, 8.553678E+00, 1.23679E+01>,
      <-4.76218E-01, 8.465289E+00, 1.245628E+01>,
      <-4.76218E-01, 7.553678E+00, 1.254467E+01>,
      <-4.76218E-01, 7.642066E+00, 1.245628E+01>,
      <-1.87622E+00, 7.642066E+00, 1.245628E+01>,
      <-1.87622E+00, 7.553678E+00, 1.254467E+01>,
      <-1.87622E+00, 7.465289E+00, 1.245628E+01>,
      <-1.87622E+00, 7.553678E+00, 1.23679E+01>,
      <-4.76218E-01, 7.553678E+00, 1.23679E+01>,
      <-4.76218E-01, 7.465289E+00, 1.245628E+01>,
      <-4.76218E-01, 6.553678E+00, 1.254467E+01>,
      <-4.76218E-01, 6.642066E+00, 1.245628E+01>,
      <-1.87622E+00, 6.642066E+00, 1.245628E+01>,
      <-1.87622E+00, 6.553678E+00, 1.254467E+01>,
      <-1.87622E+00, 6.465289E+00, 1.245628E+01>,
      <-1.87622E+00, 6.553678E+00, 1.23679E+01>,
      <-4.76218E-01, 6.553678E+00, 1.23679E+01>,
      <-4.76218E-01, 6.465289E+00, 1.245628E+01>
   }
 
   normal_vectors { 
      8, 
      <-2.304047E-07, 7.071067E-01, 7.071069E-01>,
      <2.304047E-07, -7.071067E-01, -7.071069E-01>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <2.304047E-07, 7.071066E-01, -7.071069E-01>,
      <-2.304047E-07, -7.071067E-01, 7.071069E-01>,
      <-2.304046E-07, 7.07107E-01, 7.071065E-01>,
      <2.304046E-07, -7.071068E-01, -7.071068E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex12}
   }
 
   face_indices { 
      72, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0,
      <8, 9, 10>, 0,
      <8, 10, 11>, 0,
      <12, 13, 14>, 0,
      <12, 14, 15>, 0,
      <11, 10, 13>, 0,
      <11, 13, 12>, 0,
      <15, 14, 9>, 0,
      <15, 9, 8>, 0,
      <9, 14, 13>, 0,
      <9, 13, 10>, 0,
      <11, 12, 15>, 0,
      <11, 15, 8>, 0,
      <16, 17, 18>, 0,
      <16, 18, 19>, 0,
      <20, 21, 22>, 0,
      <20, 22, 23>, 0,
      <19, 18, 21>, 0,
      <19, 21, 20>, 0,
      <23, 22, 17>, 0,
      <23, 17, 16>, 0,
      <17, 22, 21>, 0,
      <17, 21, 18>, 0,
      <19, 20, 23>, 0,
      <19, 23, 16>, 0,
      <24, 25, 26>, 0,
      <24, 26, 27>, 0,
      <28, 29, 30>, 0,
      <28, 30, 31>, 0,
      <27, 26, 29>, 0,
      <27, 29, 28>, 0,
      <31, 30, 25>, 0,
      <31, 25, 24>, 0,
      <25, 30, 29>, 0,
      <25, 29, 26>, 0,
      <27, 28, 31>, 0,
      <27, 31, 24>, 0,
      <32, 33, 34>, 0,
      <32, 34, 35>, 0,
      <36, 37, 38>, 0,
      <36, 38, 39>, 0,
      <35, 34, 37>, 0,
      <35, 37, 36>, 0,
      <39, 38, 33>, 0,
      <39, 33, 32>, 0,
      <33, 38, 37>, 0,
      <33, 37, 34>, 0,
      <35, 36, 39>, 0,
      <35, 39, 32>, 0,
      <40, 41, 42>, 0,
      <40, 42, 43>, 0,
      <44, 45, 46>, 0,
      <44, 46, 47>, 0,
      <43, 42, 45>, 0,
      <43, 45, 44>, 0,
      <47, 46, 41>, 0,
      <47, 41, 40>, 0,
      <41, 46, 45>, 0,
      <41, 45, 42>, 0,
      <43, 44, 47>, 0,
      <43, 47, 40>, 0
   }
 
   normal_indices { 
      72, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>,
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>,
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
#declare Tex13 =
texture {
   pigment {rgbf <9.607843E-01, 7.607843E-01, 8.039216E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// SlideBack
mesh2 {
 
   vertex_vectors { 
      12, 
      <6.169905E+00, 1.295892E+01, -7.964142E+00>,
      <6.169905E+00, 1.328892E+01, -7.964142E+00>,
      <-3.432871E+00, 1.328892E+01, -7.964145E+00>,
      <-3.432871E+00, 1.295892E+01, -7.964145E+00>,
      <6.078678E+00, 1.360892E+01, -7.964142E+00>,
      <-3.341644E+00, 1.360892E+01, -7.964145E+00>,
      <5.937374E+00, 1.393392E+01, -7.964142E+00>,
      <-3.20034E+00, 1.393392E+01, -7.964145E+00>,
      <5.617525E+00, 1.436687E+01, -7.96414E+00>,
      <5.617554E+00, 1.436687E+01, -8.264142E+00>,
      <-2.880476E+00, 1.436687E+01, -8.264142E+00>,
      <-2.880476E+00, 1.436687E+01, -7.964143E+00>
   }
 
   normal_vectors { 
      2, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <0.00E+00, 1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex13}
   }
 
   face_indices { 
      10, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <5, 2, 1>, 0,
      <5, 1, 4>, 0,
      <7, 5, 4>, 0,
      <7, 4, 6>, 0,
      <8, 9, 10>, 0,
      <8, 10, 11>, 0,
      <11, 7, 6>, 0,
      <11, 6, 8>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <0, 0, 0>,
      <0, 0, 0>
   }
}
 
#declare Tex14 =
texture {
   pigment {rgbf <8.352941E-01, 9.058824E-01, 9.058824E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// SlideBracePort
mesh2 {
 
   vertex_vectors { 
      8, 
      <3.578518E+00, 1.271289E+01, -7.714141E+00>,
      <3.578518E+00, 1.461289E+01, -7.714141E+00>,
      <3.158516E+00, 1.461289E+01, -7.714141E+00>,
      <3.158516E+00, 1.271289E+01, -7.714141E+00>,
      <3.158516E+00, 1.271289E+01, -7.964141E+00>,
      <3.158516E+00, 1.461289E+01, -7.964141E+00>,
      <3.578518E+00, 1.461289E+01, -7.964141E+00>,
      <3.578518E+00, 1.271289E+01, -7.964141E+00>
   }
 
   normal_vectors { 
      3, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.00E+00, 0.00E+00, 3.258414E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex14}
   }
 
   face_indices { 
      6, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0
   }
 
   normal_indices { 
      6, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>
   }
}
 
// SlideBraceStar
mesh2 {
 
   vertex_vectors { 
      8, 
      <-8.410681E-01, 1.271289E+01, -7.714143E+00>,
      <-8.410681E-01, 1.461289E+01, -7.714143E+00>,
      <-4.210662E-01, 1.461289E+01, -7.714142E+00>,
      <-4.210662E-01, 1.271289E+01, -7.714142E+00>,
      <-4.210661E-01, 1.271289E+01, -7.964142E+00>,
      <-4.210661E-01, 1.461289E+01, -7.964142E+00>,
      <-8.41068E-01, 1.461289E+01, -7.964143E+00>,
      <-8.41068E-01, 1.271289E+01, -7.964143E+00>
   }
 
   normal_vectors { 
      3, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex14}
   }
 
   face_indices { 
      6, 
      <0, 3, 2>, 0,
      <0, 2, 1>, 0,
      <3, 4, 5>, 0,
      <3, 5, 2>, 0,
      <7, 0, 1>, 0,
      <7, 1, 6>, 0
   }
 
   normal_indices { 
      6, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>
   }
}
 
#declare Tex15 =
texture {
   pigment {rgbf <8.588235E-01, 7.960784E-01, 7.843137E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// CouplerPocketAft
mesh2 {
 
   vertex_vectors { 
      8, 
      <1.788716E+00, 3.743679E+00, 1.341633E+01>,
      <1.788716E+00, 4.443679E+00, 1.341633E+01>,
      <9.487161E-01, 4.443679E+00, 1.341633E+01>,
      <9.487161E-01, 3.743679E+00, 1.341633E+01>,
      <9.487162E-01, 3.743679E+00, 1.311633E+01>,
      <9.487162E-01, 4.443679E+00, 1.311633E+01>,
      <1.788716E+00, 4.443679E+00, 1.311633E+01>,
      <1.788716E+00, 3.743679E+00, 1.311633E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex15}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
#declare Tex16 =
texture {
   pigment {rgbf <8.431373E-01, 8.039216E-01, 8.078431E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// WaterHatch
mesh2 {
 
   vertex_vectors { 
      20, 
      <-2.5539E+00, 1.330892E+01, 6.02029E+00>,
      <-2.458409E+00, 1.330892E+01, 6.569868E+00>,
      <-2.208409E+00, 1.330892E+01, 6.909529E+00>,
      <5.100608E+00, 1.330892E+01, 6.909531E+00>,
      <5.350608E+00, 1.330892E+01, 6.56987E+00>,
      <5.4461E+00, 1.330892E+01, 6.020293E+00>,
      <5.350608E+00, 1.330892E+01, 5.470714E+00>,
      <5.100608E+00, 1.330892E+01, 5.131053E+00>,
      <-2.208409E+00, 1.330892E+01, 5.131051E+00>,
      <-2.458409E+00, 1.330892E+01, 5.470711E+00>,
      <-2.5539E+00, 1.295892E+01, 6.02029E+00>,
      <-2.458409E+00, 1.295892E+01, 6.569868E+00>,
      <-2.208409E+00, 1.295892E+01, 6.909529E+00>,
      <5.100608E+00, 1.295892E+01, 6.909531E+00>,
      <5.350608E+00, 1.295892E+01, 6.56987E+00>,
      <5.4461E+00, 1.295892E+01, 6.020293E+00>,
      <5.350608E+00, 1.295892E+01, 5.470714E+00>,
      <5.100608E+00, 1.295892E+01, 5.131053E+00>,
      <-2.208409E+00, 1.295892E+01, 5.131051E+00>,
      <-2.458409E+00, 1.295892E+01, 5.470711E+00>
   }
 
   normal_vectors { 
      12, 
      <-1.00E+00, 0.00E+00, -1.629207E-07>,
      <-8.09017E-01, 0.00E+00, 5.877852E-01>,
      <-3.090171E-01, 0.00E+00, 9.510565E-01>,
      <3.09017E-01, 0.00E+00, 9.510565E-01>,
      <8.090171E-01, 0.00E+00, 5.877851E-01>,
      <1.00E+00, 0.00E+00, 1.629207E-07>,
      <8.090169E-01, 0.00E+00, -5.877853E-01>,
      <3.090167E-01, 0.00E+00, -9.510566E-01>,
      <-3.090173E-01, 0.00E+00, -9.510564E-01>,
      <-8.090171E-01, 0.00E+00, -5.877851E-01>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <0.00E+00, 1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex16}
   }
 
   face_indices { 
      36, 
      <0, 10, 11>, 0,
      <0, 11, 1>, 0,
      <1, 11, 12>, 0,
      <1, 12, 2>, 0,
      <2, 12, 13>, 0,
      <2, 13, 3>, 0,
      <3, 13, 14>, 0,
      <3, 14, 4>, 0,
      <4, 14, 15>, 0,
      <4, 15, 5>, 0,
      <5, 15, 16>, 0,
      <5, 16, 6>, 0,
      <6, 16, 17>, 0,
      <6, 17, 7>, 0,
      <7, 17, 18>, 0,
      <7, 18, 8>, 0,
      <8, 18, 19>, 0,
      <8, 19, 9>, 0,
      <9, 19, 10>, 0,
      <9, 10, 0>, 0,
      <10, 19, 18>, 0,
      <10, 18, 17>, 0,
      <10, 17, 16>, 0,
      <10, 16, 15>, 0,
      <10, 15, 14>, 0,
      <10, 14, 13>, 0,
      <10, 13, 12>, 0,
      <10, 12, 11>, 0,
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <0, 3, 4>, 0,
      <0, 4, 5>, 0,
      <0, 5, 6>, 0,
      <0, 6, 7>, 0,
      <0, 7, 8>, 0,
      <0, 8, 9>, 0
   }
 
   normal_indices { 
      36, 
      <0, 0, 1>,
      <0, 1, 1>,
      <1, 1, 2>,
      <1, 2, 2>,
      <2, 2, 3>,
      <2, 3, 3>,
      <3, 3, 4>,
      <3, 4, 4>,
      <4, 4, 5>,
      <4, 5, 5>,
      <5, 5, 6>,
      <5, 6, 6>,
      <6, 6, 7>,
      <6, 7, 7>,
      <7, 7, 8>,
      <7, 8, 8>,
      <8, 8, 9>,
      <8, 9, 9>,
      <9, 9, 0>,
      <9, 0, 0>,
      <10, 10, 10>,
      <10, 10, 10>,
      <10, 10, 10>,
      <10, 10, 10>,
      <10, 10, 10>,
      <10, 10, 10>,
      <10, 10, 10>,
      <10, 10, 10>,
      <11, 11, 11>,
      <11, 11, 11>,
      <11, 11, 11>,
      <11, 11, 11>,
      <11, 11, 11>,
      <11, 11, 11>,
      <11, 11, 11>,
      <11, 11, 11>
   }
}
 
#declare Tex17 =
texture {
   pigment {rgbf <1.00E+00, 1.00E+00, 1.00E+00, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// SlideLadder
mesh2 {
 
   vertex_vectors { 
      16, 
      <1.868517E+00, 1.448326E+01, -7.848516E+00>,
      <1.768517E+00, 1.457413E+01, -7.806772E+00>,
      <1.868517E+00, 1.4665E+01, -7.765032E+00>,
      <1.968517E+00, 1.457413E+01, -7.806772E+00>,
      <1.868517E+00, 1.425529E+01, -7.352228E+00>,
      <1.768517E+00, 1.433297E+01, -7.281775E+00>,
      <1.868517E+00, 1.441065E+01, -7.211317E+00>,
      <1.968517E+00, 1.433297E+01, -7.281775E+00>,
      <1.868517E+00, 1.364004E+01, -6.993334E+00>,
      <1.768516E+00, 1.367413E+01, -6.897448E+00>,
      <1.868517E+00, 1.370822E+01, -6.801561E+00>,
      <1.968517E+00, 1.367413E+01, -6.897448E+00>,
      <1.868517E+00, 1.275869E+01, -6.855574E+00>,
      <1.768516E+00, 1.277413E+01, -6.756773E+00>,
      <1.868517E+00, 1.278957E+01, -6.657972E+00>,
      <1.968517E+00, 1.277413E+01, -6.756773E+00>
   }
 
   normal_vectors { 
      28, 
      <-7.071058E-01, -6.4256E-01, -2.951577E-01>,
      <-7.2372E-01, -5.111632E-01, -4.636179E-01>,
      <-9.486822E-01, -2.873632E-01, -1.320015E-01>,
      <-7.071064E-01, 6.425591E-01, 2.951581E-01>,
      <-9.486837E-01, 2.873608E-01, 1.319964E-01>,
      <-7.237235E-01, 5.111611E-01, 4.636148E-01>,
      <7.071061E-01, 6.42559E-01, 2.951593E-01>,
      <7.23723E-01, 5.111611E-01, 4.636156E-01>,
      <9.486835E-01, 2.873608E-01, 1.319975E-01>,
      <7.071059E-01, -6.425599E-01, -2.951579E-01>,
      <9.486824E-01, -2.87363E-01, -1.320009E-01>,
      <7.237205E-01, -5.111629E-01, -4.636174E-01>,
      <-9.486822E-01, -1.593402E-01, -2.731534E-01>,
      <-7.132612E-01, -2.347732E-01, -6.60409E-01>,
      <-9.486834E-01, 1.593379E-01, 2.731506E-01>,
      <-7.132646E-01, 2.347719E-01, 6.604057E-01>,
      <9.486833E-01, 1.593379E-01, 2.731513E-01>,
      <7.132644E-01, 2.347719E-01, 6.604059E-01>,
      <9.486824E-01, -1.5934E-01, -2.731526E-01>,
      <7.132621E-01, -2.34773E-01, -6.604081E-01>,
      <-9.48682E-01, -4.88364E-02, -3.124381E-01>,
      <-7.071052E-01, -1.091987E-01, -6.986257E-01>,
      <-9.486837E-01, 4.883419E-02, 3.124331E-01>,
      <-7.071055E-01, 1.091989E-01, 6.986254E-01>,
      <9.486835E-01, 4.883433E-02, 3.124335E-01>,
      <7.071055E-01, 1.091989E-01, 6.986254E-01>,
      <9.486823E-01, -4.883618E-02, -3.124371E-01>,
      <7.071059E-01, -1.091986E-01, -6.98625E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      24, 
      <1, 0, 4>, 0,
      <1, 4, 5>, 0,
      <2, 1, 5>, 0,
      <2, 5, 6>, 0,
      <3, 2, 6>, 0,
      <3, 6, 7>, 0,
      <0, 3, 7>, 0,
      <0, 7, 4>, 0,
      <5, 4, 8>, 0,
      <5, 8, 9>, 0,
      <6, 5, 9>, 0,
      <6, 9, 10>, 0,
      <7, 6, 10>, 0,
      <7, 10, 11>, 0,
      <4, 7, 11>, 0,
      <4, 11, 8>, 0,
      <9, 8, 12>, 0,
      <9, 12, 13>, 0,
      <10, 9, 13>, 0,
      <10, 13, 14>, 0,
      <11, 10, 14>, 0,
      <11, 14, 15>, 0,
      <8, 11, 15>, 0,
      <8, 15, 12>, 0
   }
 
   normal_indices { 
      24, 
      <0, 0, 1>,
      <0, 1, 2>,
      <3, 3, 4>,
      <3, 4, 5>,
      <6, 6, 7>,
      <6, 7, 8>,
      <9, 9, 10>,
      <9, 10, 11>,
      <12, 1, 13>,
      <12, 13, 12>,
      <5, 14, 14>,
      <5, 14, 15>,
      <16, 7, 17>,
      <16, 17, 16>,
      <11, 18, 18>,
      <11, 18, 19>,
      <20, 13, 21>,
      <20, 21, 21>,
      <15, 22, 23>,
      <15, 23, 23>,
      <24, 17, 25>,
      <24, 25, 25>,
      <19, 26, 27>,
      <19, 27, 27>
   }
}
 
// SlideLadder
mesh2 {
 
   vertex_vectors { 
      16, 
      <8.685171E-01, 1.448326E+01, -7.848516E+00>,
      <7.685167E-01, 1.457413E+01, -7.806772E+00>,
      <8.68517E-01, 1.4665E+01, -7.765032E+00>,
      <9.685175E-01, 1.457413E+01, -7.806772E+00>,
      <8.685169E-01, 1.425529E+01, -7.352228E+00>,
      <7.685165E-01, 1.433297E+01, -7.281775E+00>,
      <8.685169E-01, 1.441065E+01, -7.211317E+00>,
      <9.685173E-01, 1.433297E+01, -7.281775E+00>,
      <8.685168E-01, 1.364004E+01, -6.993334E+00>,
      <7.685164E-01, 1.367413E+01, -6.897448E+00>,
      <8.685167E-01, 1.370822E+01, -6.801561E+00>,
      <9.685172E-01, 1.367413E+01, -6.897448E+00>,
      <8.685167E-01, 1.275869E+01, -6.855574E+00>,
      <7.685164E-01, 1.277413E+01, -6.756773E+00>,
      <8.685167E-01, 1.278957E+01, -6.657972E+00>,
      <9.685171E-01, 1.277413E+01, -6.756773E+00>
   }
 
   normal_vectors { 
      28, 
      <-7.071058E-01, -6.4256E-01, -2.951577E-01>,
      <-7.2372E-01, -5.111632E-01, -4.636179E-01>,
      <-9.486822E-01, -2.873632E-01, -1.320015E-01>,
      <-7.071064E-01, 6.425591E-01, 2.951581E-01>,
      <-9.486837E-01, 2.873608E-01, 1.319964E-01>,
      <-7.237235E-01, 5.111612E-01, 4.636148E-01>,
      <7.07106E-01, 6.42559E-01, 2.951593E-01>,
      <7.23723E-01, 5.111611E-01, 4.636155E-01>,
      <9.486835E-01, 2.873608E-01, 1.319974E-01>,
      <7.071058E-01, -6.425599E-01, -2.951579E-01>,
      <9.486824E-01, -2.87363E-01, -1.320009E-01>,
      <7.237205E-01, -5.111629E-01, -4.636175E-01>,
      <-9.486822E-01, -1.593402E-01, -2.731534E-01>,
      <-7.132612E-01, -2.347732E-01, -6.60409E-01>,
      <-9.486834E-01, 1.593379E-01, 2.731506E-01>,
      <-7.132646E-01, 2.34772E-01, 6.604057E-01>,
      <9.486833E-01, 1.593379E-01, 2.731512E-01>,
      <7.132643E-01, 2.347719E-01, 6.604061E-01>,
      <9.486824E-01, -1.5934E-01, -2.731526E-01>,
      <7.132621E-01, -2.34773E-01, -6.604081E-01>,
      <-9.48682E-01, -4.883635E-02, -3.124381E-01>,
      <-7.071052E-01, -1.091987E-01, -6.986257E-01>,
      <-9.486837E-01, 4.883423E-02, 3.124331E-01>,
      <-7.071055E-01, 1.091989E-01, 6.986254E-01>,
      <9.486835E-01, 4.883432E-02, 3.124337E-01>,
      <7.071053E-01, 1.091988E-01, 6.986257E-01>,
      <9.486823E-01, -4.883619E-02, -3.124371E-01>,
      <7.071059E-01, -1.091986E-01, -6.98625E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      24, 
      <1, 0, 4>, 0,
      <1, 4, 5>, 0,
      <2, 1, 5>, 0,
      <2, 5, 6>, 0,
      <3, 2, 6>, 0,
      <3, 6, 7>, 0,
      <0, 3, 7>, 0,
      <0, 7, 4>, 0,
      <5, 4, 8>, 0,
      <5, 8, 9>, 0,
      <6, 5, 9>, 0,
      <6, 9, 10>, 0,
      <7, 6, 10>, 0,
      <7, 10, 11>, 0,
      <4, 7, 11>, 0,
      <4, 11, 8>, 0,
      <9, 8, 12>, 0,
      <9, 12, 13>, 0,
      <10, 9, 13>, 0,
      <10, 13, 14>, 0,
      <11, 10, 14>, 0,
      <11, 14, 15>, 0,
      <8, 11, 15>, 0,
      <8, 15, 12>, 0
   }
 
   normal_indices { 
      24, 
      <0, 0, 1>,
      <0, 1, 2>,
      <3, 3, 4>,
      <3, 4, 5>,
      <6, 6, 7>,
      <6, 7, 8>,
      <9, 9, 10>,
      <9, 10, 11>,
      <12, 1, 13>,
      <12, 13, 12>,
      <5, 14, 14>,
      <5, 14, 15>,
      <16, 7, 17>,
      <16, 17, 16>,
      <11, 18, 18>,
      <11, 18, 19>,
      <20, 13, 21>,
      <20, 21, 21>,
      <15, 22, 23>,
      <15, 23, 23>,
      <24, 17, 25>,
      <24, 25, 25>,
      <19, 26, 27>,
      <19, 27, 27>
   }
}
 
// SlideLadder
mesh2 {
 
   vertex_vectors { 
      8, 
      <1.868517E+00, 1.443297E+01, -7.281775E+00>,
      <1.868517E+00, 1.433297E+01, -7.181772E+00>,
      <1.868517E+00, 1.423297E+01, -7.281775E+00>,
      <1.868517E+00, 1.433297E+01, -7.381773E+00>,
      <8.685169E-01, 1.443297E+01, -7.281775E+00>,
      <8.685169E-01, 1.433297E+01, -7.181772E+00>,
      <8.685169E-01, 1.423297E+01, -7.281775E+00>,
      <8.685169E-01, 1.433297E+01, -7.381773E+00>
   }
 
   normal_vectors { 
      4, 
      <-2.304023E-07, 7.071139E-01, 7.070997E-01>,
      <-2.304023E-07, -7.071139E-01, 7.070997E-01>,
      <2.304067E-07, -7.071004E-01, -7.071132E-01>,
      <2.304067E-07, 7.071004E-01, -7.071132E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      8, 
      <1, 0, 4>, 0,
      <1, 4, 5>, 0,
      <2, 1, 5>, 0,
      <2, 5, 6>, 0,
      <3, 2, 6>, 0,
      <3, 6, 7>, 0,
      <0, 3, 7>, 0,
      <0, 7, 4>, 0
   }
 
   normal_indices { 
      8, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>
   }
}
 
// SlideLadder
mesh2 {
 
   vertex_vectors { 
      8, 
      <8.685168E-01, 1.377413E+01, -6.897448E+00>,
      <8.685168E-01, 1.367413E+01, -6.99745E+00>,
      <8.685168E-01, 1.357413E+01, -6.897448E+00>,
      <8.685167E-01, 1.367413E+01, -6.797449E+00>,
      <1.868517E+00, 1.377413E+01, -6.897448E+00>,
      <1.868517E+00, 1.367413E+01, -6.99745E+00>,
      <1.868517E+00, 1.357413E+01, -6.897448E+00>,
      <1.868517E+00, 1.367413E+01, -6.797449E+00>
   }
 
   normal_vectors { 
      4, 
      <2.304026E-07, 7.071132E-01, -7.071004E-01>,
      <2.304026E-07, -7.071132E-01, -7.071004E-01>,
      <-2.30407E-07, -7.070997E-01, 7.071139E-01>,
      <-2.30407E-07, 7.070997E-01, 7.071139E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      8, 
      <1, 0, 4>, 0,
      <1, 4, 5>, 0,
      <2, 1, 5>, 0,
      <2, 5, 6>, 0,
      <3, 2, 6>, 0,
      <3, 6, 7>, 0,
      <0, 3, 7>, 0,
      <0, 7, 4>, 0
   }
 
   normal_indices { 
      8, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>
   }
}
 
#declare Tex18 =
texture {
   pigment {rgbf <8.078431E-01, 9.960784E-01, 9.529412E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// CouplerPlateAft
mesh2 {
 
   vertex_vectors { 
      8, 
      <1.908717E+00, 3.602202E+00, 1.361633E+01>,
      <1.908717E+00, 4.502202E+00, 1.361633E+01>,
      <8.287152E-01, 4.502202E+00, 1.361633E+01>,
      <8.287152E-01, 3.602202E+00, 1.361633E+01>,
      <8.287153E-01, 3.602202E+00, 1.341633E+01>,
      <8.287153E-01, 4.502202E+00, 1.341633E+01>,
      <1.908717E+00, 4.502202E+00, 1.341633E+01>,
      <1.908717E+00, 3.602202E+00, 1.341633E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex18}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
#declare Tex19 =
texture {
   pigment {rgbf <8.352941E-01, 8.980392E-01, 8.039216E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// Latch2
mesh2 {
 
   vertex_vectors { 
      8, 
      <1.7961E+00, 1.330892E+01, 6.762469E+00>,
      <1.6911E+00, 1.344892E+01, 6.762469E+00>,
      <1.201099E+00, 1.344892E+01, 6.762469E+00>,
      <1.096099E+00, 1.330892E+01, 6.762469E+00>,
      <1.096099E+00, 1.330892E+01, 6.562469E+00>,
      <1.201099E+00, 1.344892E+01, 6.562469E+00>,
      <1.6911E+00, 1.344892E+01, 6.562469E+00>,
      <1.7961E+00, 1.330892E+01, 6.562469E+00>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex19}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Latch3
mesh2 {
 
   vertex_vectors { 
      8, 
      <-4.539002E-01, 1.330892E+01, 6.762469E+00>,
      <-5.588997E-01, 1.344892E+01, 6.762469E+00>,
      <-1.048901E+00, 1.344892E+01, 6.762468E+00>,
      <-1.153901E+00, 1.330892E+01, 6.762468E+00>,
      <-1.153901E+00, 1.330892E+01, 6.562468E+00>,
      <-1.048901E+00, 1.344892E+01, 6.562468E+00>,
      <-5.588996E-01, 1.344892E+01, 6.562468E+00>,
      <-4.539001E-01, 1.330892E+01, 6.562468E+00>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex19}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Latch1
mesh2 {
 
   vertex_vectors { 
      8, 
      <4.0461E+00, 1.330892E+01, 6.76247E+00>,
      <3.9411E+00, 1.344892E+01, 6.76247E+00>,
      <3.451099E+00, 1.344892E+01, 6.76247E+00>,
      <3.346099E+00, 1.330892E+01, 6.76247E+00>,
      <3.346099E+00, 1.330892E+01, 6.562469E+00>,
      <3.451099E+00, 1.344892E+01, 6.562469E+00>,
      <3.9411E+00, 1.344892E+01, 6.562469E+00>,
      <4.0461E+00, 1.330892E+01, 6.562469E+00>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex19}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
#declare Tex20 =
texture {
   pigment {rgbf <7.529412E-01, 8.745098E-01, 7.568628E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// ShelfStepPort
mesh2 {
 
   vertex_vectors { 
      24, 
      <5.806733E+00, 7.264088E+00, -2.796495E+01>,
      <5.806733E+00, 7.364088E+00, -2.796495E+01>,
      <5.316731E+00, 7.364088E+00, -2.796495E+01>,
      <5.316731E+00, 7.264088E+00, -2.796495E+01>,
      <5.316732E+00, 7.264088E+00, -2.876495E+01>,
      <5.316732E+00, 7.364088E+00, -2.876495E+01>,
      <5.806734E+00, 7.364088E+00, -2.876495E+01>,
      <5.806734E+00, 7.264088E+00, -2.876495E+01>,
      <5.316732E+00, 7.264088E+00, -2.886495E+01>,
      <5.316732E+00, 7.364088E+00, -2.886495E+01>,
      <5.806734E+00, 7.364088E+00, -2.886495E+01>,
      <5.806734E+00, 7.264088E+00, -2.886495E+01>,
      <5.806733E+00, 7.264088E+00, -2.786495E+01>,
      <5.806733E+00, 7.364088E+00, -2.786495E+01>,
      <5.316731E+00, 7.364088E+00, -2.786495E+01>,
      <5.316731E+00, 7.264088E+00, -2.786495E+01>,
      <5.806733E+00, 7.614088E+00, -2.776495E+01>,
      <5.806733E+00, 7.614088E+00, -2.786495E+01>,
      <5.316731E+00, 7.614088E+00, -2.786495E+01>,
      <5.316731E+00, 7.614088E+00, -2.776495E+01>,
      <5.316732E+00, 7.614088E+00, -2.896495E+01>,
      <5.316732E+00, 7.614088E+00, -2.886495E+01>,
      <5.806734E+00, 7.614088E+00, -2.886495E+01>,
      <5.806734E+00, 7.614088E+00, -2.896495E+01>
   }
 
   normal_vectors { 
      12, 
      <-1.00E+00, 1.104932E-16, -3.258414E-07>,
      <1.00E+00, -1.104932E-16, 3.258414E-07>,
      <-1.104933E-16, 1.00E+00, 1.370987E-16>,
      <1.104933E-16, -1.00E+00, -1.370987E-16>,
      <3.258414E-07, -1.370987E-16, -1.00E+00>,
      <3.199621E-07, -1.891055E-01, -9.819568E-01>,
      <-3.258414E-07, 1.370987E-16, 1.00E+00>,
      <-3.199622E-07, -1.891047E-01, 9.81957E-01>,
      <3.025366E-07, 3.713868E-01, -9.284782E-01>,
      <-3.025368E-07, -3.713852E-01, 9.284788E-01>,
      <-3.025368E-07, 3.713852E-01, 9.284788E-01>,
      <3.025366E-07, -3.713868E-01, -9.284782E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex20}
   }
 
   face_indices { 
      44, 
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0,
      <8, 9, 10>, 0,
      <8, 10, 11>, 0,
      <8, 4, 5>, 0,
      <8, 5, 9>, 0,
      <10, 6, 7>, 0,
      <10, 7, 11>, 0,
      <11, 7, 4>, 0,
      <11, 4, 8>, 0,
      <12, 13, 14>, 0,
      <12, 14, 15>, 0,
      <12, 0, 1>, 0,
      <12, 1, 13>, 0,
      <14, 2, 3>, 0,
      <14, 3, 15>, 0,
      <15, 3, 0>, 0,
      <15, 0, 12>, 0,
      <16, 17, 18>, 0,
      <16, 18, 19>, 0,
      <16, 13, 1>, 0,
      <16, 1, 17>, 0,
      <17, 1, 2>, 0,
      <17, 2, 18>, 0,
      <18, 2, 14>, 0,
      <18, 14, 19>, 0,
      <19, 14, 13>, 0,
      <19, 13, 16>, 0,
      <20, 21, 22>, 0,
      <20, 22, 23>, 0,
      <20, 9, 5>, 0,
      <20, 5, 21>, 0,
      <21, 5, 6>, 0,
      <21, 6, 22>, 0,
      <22, 6, 10>, 0,
      <22, 10, 23>, 0,
      <23, 10, 9>, 0,
      <23, 9, 20>, 0
   }
 
   normal_indices { 
      44, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 5, 5>,
      <4, 5, 4>,
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <3, 3, 3>,
      <3, 3, 3>,
      <6, 7, 7>,
      <6, 7, 6>,
      <1, 1, 1>,
      <1, 1, 1>,
      <0, 0, 0>,
      <0, 0, 0>,
      <3, 3, 3>,
      <3, 3, 3>,
      <2, 2, 2>,
      <2, 2, 2>,
      <1, 1, 1>,
      <1, 1, 1>,
      <8, 8, 8>,
      <8, 8, 8>,
      <0, 0, 0>,
      <0, 0, 0>,
      <9, 7, 7>,
      <9, 7, 9>,
      <2, 2, 2>,
      <2, 2, 2>,
      <0, 0, 0>,
      <0, 0, 0>,
      <10, 10, 10>,
      <10, 10, 10>,
      <1, 1, 1>,
      <1, 1, 1>,
      <11, 5, 5>,
      <11, 5, 11>
   }
}
 
// ShelfStepStar
mesh2 {
 
   vertex_vectors { 
      24, 
      <-3.06927E+00, 7.264088E+00, -2.796495E+01>,
      <-3.06927E+00, 7.364088E+00, -2.796495E+01>,
      <-2.579268E+00, 7.364088E+00, -2.796495E+01>,
      <-2.579268E+00, 7.264088E+00, -2.796495E+01>,
      <-2.579268E+00, 7.264088E+00, -2.876495E+01>,
      <-2.579268E+00, 7.364088E+00, -2.876495E+01>,
      <-3.06927E+00, 7.364088E+00, -2.876495E+01>,
      <-3.06927E+00, 7.264088E+00, -2.876495E+01>,
      <-2.579268E+00, 7.264088E+00, -2.886495E+01>,
      <-2.579268E+00, 7.364088E+00, -2.886495E+01>,
      <-3.06927E+00, 7.364088E+00, -2.886495E+01>,
      <-3.06927E+00, 7.264088E+00, -2.886495E+01>,
      <-3.06927E+00, 7.264088E+00, -2.786495E+01>,
      <-3.06927E+00, 7.364088E+00, -2.786495E+01>,
      <-2.579268E+00, 7.364088E+00, -2.786495E+01>,
      <-2.579268E+00, 7.264088E+00, -2.786495E+01>,
      <-3.06927E+00, 7.614088E+00, -2.776495E+01>,
      <-3.06927E+00, 7.614088E+00, -2.786495E+01>,
      <-2.579268E+00, 7.614088E+00, -2.786495E+01>,
      <-2.579268E+00, 7.614088E+00, -2.776495E+01>,
      <-2.579268E+00, 7.614088E+00, -2.896495E+01>,
      <-2.579268E+00, 7.614088E+00, -2.886495E+01>,
      <-3.06927E+00, 7.614088E+00, -2.886495E+01>,
      <-3.06927E+00, 7.614088E+00, -2.896495E+01>
   }
 
   normal_vectors { 
      12, 
      <1.00E+00, 1.104932E-16, 3.258414E-07>,
      <-1.00E+00, -1.104932E-16, -3.258414E-07>,
      <1.104932E-16, 1.00E+00, 1.370987E-16>,
      <-1.104932E-16, -1.00E+00, -1.370987E-16>,
      <3.258414E-07, -1.370987E-16, -1.00E+00>,
      <3.199621E-07, -1.891055E-01, -9.819568E-01>,
      <-3.258414E-07, 1.370987E-16, 1.00E+00>,
      <-3.199622E-07, -1.891047E-01, 9.81957E-01>,
      <3.025366E-07, 3.713868E-01, -9.284782E-01>,
      <-3.025368E-07, -3.713852E-01, 9.284788E-01>,
      <-3.025368E-07, 3.713852E-01, 9.284788E-01>,
      <3.025366E-07, -3.713868E-01, -9.284782E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex20}
   }
 
   face_indices { 
      44, 
      <3, 4, 5>, 0,
      <3, 5, 2>, 0,
      <7, 0, 1>, 0,
      <7, 1, 6>, 0,
      <1, 2, 5>, 0,
      <1, 5, 6>, 0,
      <3, 0, 7>, 0,
      <3, 7, 4>, 0,
      <8, 11, 10>, 0,
      <8, 10, 9>, 0,
      <8, 9, 5>, 0,
      <8, 5, 4>, 0,
      <10, 11, 7>, 0,
      <10, 7, 6>, 0,
      <11, 8, 4>, 0,
      <11, 4, 7>, 0,
      <12, 15, 14>, 0,
      <12, 14, 13>, 0,
      <12, 13, 1>, 0,
      <12, 1, 0>, 0,
      <14, 15, 3>, 0,
      <14, 3, 2>, 0,
      <15, 12, 0>, 0,
      <15, 0, 3>, 0,
      <16, 19, 18>, 0,
      <16, 18, 17>, 0,
      <16, 17, 1>, 0,
      <16, 1, 13>, 0,
      <17, 18, 2>, 0,
      <17, 2, 1>, 0,
      <18, 19, 14>, 0,
      <18, 14, 2>, 0,
      <19, 16, 13>, 0,
      <19, 13, 14>, 0,
      <20, 23, 22>, 0,
      <20, 22, 21>, 0,
      <20, 21, 5>, 0,
      <20, 5, 9>, 0,
      <21, 22, 6>, 0,
      <21, 6, 5>, 0,
      <22, 23, 10>, 0,
      <22, 10, 6>, 0,
      <23, 20, 9>, 0,
      <23, 9, 10>, 0
   }
 
   normal_indices { 
      44, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 5>,
      <4, 5, 5>,
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <3, 3, 3>,
      <3, 3, 3>,
      <6, 6, 7>,
      <6, 7, 7>,
      <1, 1, 1>,
      <1, 1, 1>,
      <0, 0, 0>,
      <0, 0, 0>,
      <3, 3, 3>,
      <3, 3, 3>,
      <2, 2, 2>,
      <2, 2, 2>,
      <1, 1, 1>,
      <1, 1, 1>,
      <8, 8, 8>,
      <8, 8, 8>,
      <0, 0, 0>,
      <0, 0, 0>,
      <9, 9, 7>,
      <9, 7, 7>,
      <2, 2, 2>,
      <2, 2, 2>,
      <0, 0, 0>,
      <0, 0, 0>,
      <10, 10, 10>,
      <10, 10, 10>,
      <1, 1, 1>,
      <1, 1, 1>,
      <11, 11, 5>,
      <11, 5, 5>
   }
}
 
#declare Tex21 =
texture {
   pigment {rgbf <9.921569E-01, 9.215686E-01, 8.117647E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// Hinge3
mesh2 {
 
   vertex_vectors { 
      12, 
      <2.271101E+00, 1.310892E+01, 5.984917E+00>,
      <2.271101E+00, 1.340892E+01, 5.984917E+00>,
      <2.121099E+00, 1.340892E+01, 5.984917E+00>,
      <2.121099E+00, 1.310892E+01, 5.984917E+00>,
      <2.121099E+00, 1.310892E+01, 4.984917E+00>,
      <2.121099E+00, 1.340892E+01, 4.984917E+00>,
      <2.271101E+00, 1.340892E+01, 4.984917E+00>,
      <2.271101E+00, 1.310892E+01, 4.984917E+00>,
      <2.121099E+00, 1.330892E+01, 4.984917E+00>,
      <2.271101E+00, 1.330892E+01, 4.984917E+00>,
      <2.271101E+00, 1.340892E+01, 5.084918E+00>,
      <2.121099E+00, 1.340892E+01, 5.084918E+00>
   }
 
   normal_vectors { 
      8, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <3.010382E-07, 3.826834E-01, -9.238795E-01>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <1.246941E-07, 9.238795E-01, -3.826835E-01>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.00E+00, 0.00E+00, 3.258414E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex21}
   }
 
   face_indices { 
      16, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0,
      <4, 8, 9>, 0,
      <4, 9, 7>, 0,
      <1, 10, 11>, 0,
      <1, 11, 2>, 0,
      <9, 8, 11>, 0,
      <9, 11, 10>, 0,
      <3, 2, 11>, 0,
      <3, 11, 8>, 0,
      <3, 8, 4>, 0,
      <7, 9, 10>, 0,
      <7, 10, 1>, 0,
      <7, 1, 0>, 0
   }
 
   normal_indices { 
      16, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 3, 3>,
      <2, 3, 2>,
      <4, 5, 5>,
      <4, 5, 4>,
      <3, 3, 5>,
      <3, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>
   }
}
 
// Hinge4
mesh2 {
 
   vertex_vectors { 
      12, 
      <7.711005E-01, 1.310892E+01, 5.984917E+00>,
      <7.711005E-01, 1.340892E+01, 5.984917E+00>,
      <6.210989E-01, 1.340892E+01, 5.984916E+00>,
      <6.210989E-01, 1.310892E+01, 5.984916E+00>,
      <6.210993E-01, 1.310892E+01, 4.984916E+00>,
      <6.210993E-01, 1.340892E+01, 4.984916E+00>,
      <7.711008E-01, 1.340892E+01, 4.984917E+00>,
      <7.711008E-01, 1.310892E+01, 4.984917E+00>,
      <6.210993E-01, 1.330892E+01, 4.984916E+00>,
      <7.711008E-01, 1.330892E+01, 4.984917E+00>,
      <7.711008E-01, 1.340892E+01, 5.084917E+00>,
      <6.210992E-01, 1.340892E+01, 5.084917E+00>
   }
 
   normal_vectors { 
      8, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <3.010382E-07, 3.826834E-01, -9.238795E-01>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <1.246941E-07, 9.238795E-01, -3.826835E-01>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.00E+00, 0.00E+00, 3.258414E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex21}
   }
 
   face_indices { 
      16, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0,
      <4, 8, 9>, 0,
      <4, 9, 7>, 0,
      <1, 10, 11>, 0,
      <1, 11, 2>, 0,
      <9, 8, 11>, 0,
      <9, 11, 10>, 0,
      <3, 2, 11>, 0,
      <3, 11, 8>, 0,
      <3, 8, 4>, 0,
      <7, 9, 10>, 0,
      <7, 10, 1>, 0,
      <7, 1, 0>, 0
   }
 
   normal_indices { 
      16, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 3, 3>,
      <2, 3, 2>,
      <4, 5, 5>,
      <4, 5, 4>,
      <3, 3, 5>,
      <3, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>
   }
}
 
// Hinge5
mesh2 {
 
   vertex_vectors { 
      12, 
      <2.110048E-02, 1.310892E+01, 5.984916E+00>,
      <2.110048E-02, 1.340892E+01, 5.984916E+00>,
      <-1.28901E-01, 1.340892E+01, 5.984916E+00>,
      <-1.28901E-01, 1.310892E+01, 5.984916E+00>,
      <-1.289007E-01, 1.310892E+01, 4.984916E+00>,
      <-1.289007E-01, 1.340892E+01, 4.984916E+00>,
      <2.11008E-02, 1.340892E+01, 4.984916E+00>,
      <2.11008E-02, 1.310892E+01, 4.984916E+00>,
      <-1.289007E-01, 1.330892E+01, 4.984916E+00>,
      <2.11008E-02, 1.330892E+01, 4.984916E+00>,
      <2.110077E-02, 1.340892E+01, 5.084917E+00>,
      <-1.289008E-01, 1.340892E+01, 5.084917E+00>
   }
 
   normal_vectors { 
      8, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <3.010382E-07, 3.826834E-01, -9.238795E-01>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <1.246941E-07, 9.238795E-01, -3.826835E-01>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.00E+00, 0.00E+00, 3.258414E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex21}
   }
 
   face_indices { 
      16, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0,
      <4, 8, 9>, 0,
      <4, 9, 7>, 0,
      <1, 10, 11>, 0,
      <1, 11, 2>, 0,
      <9, 8, 11>, 0,
      <9, 11, 10>, 0,
      <3, 2, 11>, 0,
      <3, 11, 8>, 0,
      <3, 8, 4>, 0,
      <7, 9, 10>, 0,
      <7, 10, 1>, 0,
      <7, 1, 0>, 0
   }
 
   normal_indices { 
      16, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 3, 3>,
      <2, 3, 2>,
      <4, 5, 5>,
      <4, 5, 4>,
      <3, 3, 5>,
      <3, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>
   }
}
 
// Hinge6
mesh2 {
 
   vertex_vectors { 
      12, 
      <-1.478899E+00, 1.310892E+01, 5.984916E+00>,
      <-1.478899E+00, 1.340892E+01, 5.984916E+00>,
      <-1.628901E+00, 1.340892E+01, 5.984916E+00>,
      <-1.628901E+00, 1.310892E+01, 5.984916E+00>,
      <-1.628901E+00, 1.310892E+01, 4.984916E+00>,
      <-1.628901E+00, 1.340892E+01, 4.984916E+00>,
      <-1.478899E+00, 1.340892E+01, 4.984916E+00>,
      <-1.478899E+00, 1.310892E+01, 4.984916E+00>,
      <-1.628901E+00, 1.330892E+01, 4.984916E+00>,
      <-1.478899E+00, 1.330892E+01, 4.984916E+00>,
      <-1.478899E+00, 1.340892E+01, 5.084916E+00>,
      <-1.628901E+00, 1.340892E+01, 5.084916E+00>
   }
 
   normal_vectors { 
      8, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <3.010382E-07, 3.826834E-01, -9.238795E-01>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <1.246941E-07, 9.238795E-01, -3.826835E-01>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.00E+00, 0.00E+00, 3.258414E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex21}
   }
 
   face_indices { 
      16, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0,
      <4, 8, 9>, 0,
      <4, 9, 7>, 0,
      <1, 10, 11>, 0,
      <1, 11, 2>, 0,
      <9, 8, 11>, 0,
      <9, 11, 10>, 0,
      <3, 2, 11>, 0,
      <3, 11, 8>, 0,
      <3, 8, 4>, 0,
      <7, 9, 10>, 0,
      <7, 10, 1>, 0,
      <7, 1, 0>, 0
   }
 
   normal_indices { 
      16, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 3, 3>,
      <2, 3, 2>,
      <4, 5, 5>,
      <4, 5, 4>,
      <3, 3, 5>,
      <3, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>
   }
}
 
// Hinge1
mesh2 {
 
   vertex_vectors { 
      12, 
      <4.521101E+00, 1.310892E+01, 5.984918E+00>,
      <4.521101E+00, 1.340892E+01, 5.984918E+00>,
      <4.371099E+00, 1.340892E+01, 5.984918E+00>,
      <4.371099E+00, 1.310892E+01, 5.984918E+00>,
      <4.371099E+00, 1.310892E+01, 4.984918E+00>,
      <4.371099E+00, 1.340892E+01, 4.984918E+00>,
      <4.521101E+00, 1.340892E+01, 4.984918E+00>,
      <4.521101E+00, 1.310892E+01, 4.984918E+00>,
      <4.371099E+00, 1.330892E+01, 4.984918E+00>,
      <4.521101E+00, 1.330892E+01, 4.984918E+00>,
      <4.521101E+00, 1.340892E+01, 5.084918E+00>,
      <4.371099E+00, 1.340892E+01, 5.084918E+00>
   }
 
   normal_vectors { 
      8, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <3.010382E-07, 3.826834E-01, -9.238795E-01>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <1.246941E-07, 9.238795E-01, -3.826835E-01>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.00E+00, 0.00E+00, 3.258414E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex21}
   }
 
   face_indices { 
      16, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0,
      <4, 8, 9>, 0,
      <4, 9, 7>, 0,
      <1, 10, 11>, 0,
      <1, 11, 2>, 0,
      <9, 8, 11>, 0,
      <9, 11, 10>, 0,
      <3, 2, 11>, 0,
      <3, 11, 8>, 0,
      <3, 8, 4>, 0,
      <7, 9, 10>, 0,
      <7, 10, 1>, 0,
      <7, 1, 0>, 0
   }
 
   normal_indices { 
      16, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 3, 3>,
      <2, 3, 2>,
      <4, 5, 5>,
      <4, 5, 4>,
      <3, 3, 5>,
      <3, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>
   }
}
 
// Hinge2
mesh2 {
 
   vertex_vectors { 
      12, 
      <3.021101E+00, 1.310892E+01, 5.984917E+00>,
      <3.021101E+00, 1.340892E+01, 5.984917E+00>,
      <2.871099E+00, 1.340892E+01, 5.984917E+00>,
      <2.871099E+00, 1.310892E+01, 5.984917E+00>,
      <2.871099E+00, 1.310892E+01, 4.984917E+00>,
      <2.871099E+00, 1.340892E+01, 4.984917E+00>,
      <3.021101E+00, 1.340892E+01, 4.984917E+00>,
      <3.021101E+00, 1.310892E+01, 4.984917E+00>,
      <2.871099E+00, 1.330892E+01, 4.984917E+00>,
      <3.021101E+00, 1.330892E+01, 4.984917E+00>,
      <3.021101E+00, 1.340892E+01, 5.084918E+00>,
      <2.871099E+00, 1.340892E+01, 5.084918E+00>
   }
 
   normal_vectors { 
      8, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <3.010382E-07, 3.826834E-01, -9.238795E-01>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <1.246941E-07, 9.238795E-01, -3.826835E-01>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.00E+00, 0.00E+00, 3.258414E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex21}
   }
 
   face_indices { 
      16, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0,
      <4, 8, 9>, 0,
      <4, 9, 7>, 0,
      <1, 10, 11>, 0,
      <1, 11, 2>, 0,
      <9, 8, 11>, 0,
      <9, 11, 10>, 0,
      <3, 2, 11>, 0,
      <3, 11, 8>, 0,
      <3, 8, 4>, 0,
      <7, 9, 10>, 0,
      <7, 10, 1>, 0,
      <7, 1, 0>, 0
   }
 
   normal_indices { 
      16, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 3, 3>,
      <2, 3, 2>,
      <4, 5, 5>,
      <4, 5, 4>,
      <3, 3, 5>,
      <3, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>
   }
}
 
// CouplerPocketFwd
mesh2 {
 
   vertex_vectors { 
      8, 
      <1.872528E+00, 4.252172E+00, -2.927509E+01>,
      <1.872528E+00, 4.952171E+00, -2.927509E+01>,
      <8.645282E-01, 4.952171E+00, -2.927509E+01>,
      <8.645282E-01, 4.252172E+00, -2.927509E+01>,
      <8.645281E-01, 4.252172E+00, -2.897509E+01>,
      <8.645281E-01, 4.952171E+00, -2.897509E+01>,
      <1.872527E+00, 4.952171E+00, -2.897509E+01>,
      <1.872527E+00, 4.252172E+00, -2.897509E+01>
   }
 
   normal_vectors { 
      6, 
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex15}
   }
 
   face_indices { 
      12, 
      <0, 3, 2>, 0,
      <0, 2, 1>, 0,
      <4, 7, 6>, 0,
      <4, 6, 5>, 0,
      <3, 4, 5>, 0,
      <3, 5, 2>, 0,
      <7, 0, 1>, 0,
      <7, 1, 6>, 0,
      <1, 2, 5>, 0,
      <1, 5, 6>, 0,
      <3, 0, 7>, 0,
      <3, 7, 4>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// CouplerPlateFwd
mesh2 {
 
   vertex_vectors { 
      8, 
      <2.016529E+00, 4.110695E+00, -2.947509E+01>,
      <2.016529E+00, 5.010695E+00, -2.947509E+01>,
      <7.205272E-01, 5.010695E+00, -2.947509E+01>,
      <7.205272E-01, 4.110695E+00, -2.947509E+01>,
      <7.205272E-01, 4.110695E+00, -2.927509E+01>,
      <7.205272E-01, 5.010695E+00, -2.927509E+01>,
      <2.016529E+00, 5.010695E+00, -2.927509E+01>,
      <2.016529E+00, 4.110695E+00, -2.927509E+01>
   }
 
   normal_vectors { 
      6, 
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex18}
   }
 
   face_indices { 
      12, 
      <0, 3, 2>, 0,
      <0, 2, 1>, 0,
      <4, 7, 6>, 0,
      <4, 6, 5>, 0,
      <3, 4, 5>, 0,
      <3, 5, 2>, 0,
      <7, 0, 1>, 0,
      <7, 1, 6>, 0,
      <1, 2, 5>, 0,
      <1, 5, 6>, 0,
      <3, 0, 7>, 0,
      <3, 7, 4>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
#declare Tex22 =
texture {
   pigment {rgbf <9.607843E-01, 8.039216E-01, 8.117647E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// Bar
mesh2 {
 
   vertex_vectors { 
      8, 
      <1.718526E+00, 4.410695E+00, -2.947509E+01>,
      <1.718526E+00, 4.710695E+00, -2.947509E+01>,
      <1.01853E+00, 4.710695E+00, -2.947509E+01>,
      <1.01853E+00, 4.410695E+00, -2.947509E+01>,
      <1.018531E+00, 4.410695E+00, -3.347509E+01>,
      <1.018531E+00, 4.710695E+00, -3.347509E+01>,
      <1.718528E+00, 4.710695E+00, -3.347509E+01>,
      <1.718528E+00, 4.410695E+00, -3.347509E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex22}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
#declare Tex23 =
texture {
   pigment {rgbf <9.529412E-01, 9.294118E-01, 8.431373E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// Door
mesh2 {
 
   vertex_vectors { 
      8, 
      <3.68258E+00, 5.058149E+00, -2.685408E+01>,
      <3.68258E+00, 1.415815E+01, -2.685408E+01>,
      <-9.374213E-01, 1.415815E+01, -2.685408E+01>,
      <-9.374213E-01, 5.058149E+00, -2.685408E+01>,
      <-9.374194E-01, 5.058149E+00, -2.699409E+01>,
      <-9.374194E-01, 1.415815E+01, -2.699409E+01>,
      <3.68258E+00, 1.415815E+01, -2.699408E+01>,
      <3.68258E+00, 5.058149E+00, -2.699408E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <0.00E+00, 9.999999E-01, 0.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex23}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
#declare Tex24 =
texture {
   pigment {rgbf <8.313726E-01, 9.764706E-01, 9.215686E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// Door_CenterPost
mesh2 {
 
   vertex_vectors { 
      8, 
      <1.492623E+00, 8.185627E+00, -2.680408E+01>,
      <1.492623E+00, 1.423063E+01, -2.680408E+01>,
      <1.252627E+00, 1.423063E+01, -2.680408E+01>,
      <1.252627E+00, 8.185627E+00, -2.680408E+01>,
      <1.252627E+00, 8.185627E+00, -2.704408E+01>,
      <1.252633E+00, 1.423063E+01, -2.704408E+01>,
      <1.492625E+00, 1.423063E+01, -2.704408E+01>,
      <1.492625E+00, 8.185627E+00, -2.704408E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -1.862645E-09, 1.00E+00>,
      <3.258414E-07, -1.862645E-09, -1.00E+00>,
      <-1.00E+00, -1.862645E-09, -3.258414E-07>,
      <1.00E+00, -1.862645E-09, 3.258414E-07>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex24}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Door_PortHinge
mesh2 {
 
   vertex_vectors { 
      12, 
      <3.543192E+00, 1.423063E+01, -2.707406E+01>,
      <3.673098E+00, 1.423063E+01, -2.699906E+01>,
      <3.673098E+00, 1.423063E+01, -2.684906E+01>,
      <3.543192E+00, 1.423063E+01, -2.677406E+01>,
      <3.413289E+00, 1.423063E+01, -2.684906E+01>,
      <3.413287E+00, 1.423063E+01, -2.699906E+01>,
      <3.543192E+00, 8.185627E+00, -2.707406E+01>,
      <3.673098E+00, 8.185627E+00, -2.699906E+01>,
      <3.673098E+00, 8.185627E+00, -2.684906E+01>,
      <3.543192E+00, 8.185627E+00, -2.677406E+01>,
      <3.413289E+00, 8.185627E+00, -2.684906E+01>,
      <3.413287E+00, 8.185627E+00, -2.699906E+01>
   }
 
   normal_vectors { 
      11, 
      <5.000182E-01, -3.166497E-08, -8.660149E-01>,
      <8.660308E-01, -3.166497E-08, -4.999908E-01>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <4.999789E-01, -3.166497E-08, 8.660376E-01>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <-4.999792E-01, -3.166497E-08, 8.660374E-01>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <-8.660303E-01, -3.166497E-08, -4.999914E-01>,
      <-5.000173E-01, -3.166497E-08, -8.660154E-01>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <0.00E+00, 9.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex24}
   }
 
   face_indices { 
      20, 
      <0, 1, 7>, 0,
      <0, 7, 6>, 0,
      <1, 2, 8>, 0,
      <1, 8, 7>, 0,
      <2, 3, 9>, 0,
      <2, 9, 8>, 0,
      <3, 4, 10>, 0,
      <3, 10, 9>, 0,
      <4, 5, 11>, 0,
      <4, 11, 10>, 0,
      <5, 0, 6>, 0,
      <5, 6, 11>, 0,
      <6, 7, 8>, 0,
      <6, 8, 9>, 0,
      <6, 9, 10>, 0,
      <6, 10, 11>, 0,
      <0, 5, 4>, 0,
      <0, 4, 3>, 0,
      <0, 3, 2>, 0,
      <0, 2, 1>, 0
   }
 
   normal_indices { 
      20, 
      <0, 1, 1>,
      <0, 1, 0>,
      <1, 2, 2>,
      <1, 2, 1>,
      <3, 4, 4>,
      <3, 4, 3>,
      <4, 5, 5>,
      <4, 5, 4>,
      <6, 7, 7>,
      <6, 7, 6>,
      <7, 8, 8>,
      <7, 8, 7>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>,
      <10, 10, 10>,
      <10, 10, 10>,
      <10, 10, 10>,
      <10, 10, 10>
   }
}
 
// Door_StarHinge
mesh2 {
 
   vertex_vectors { 
      12, 
      <-7.983125E-01, 1.423063E+01, -2.70741E+01>,
      <-9.282107E-01, 1.423063E+01, -2.699906E+01>,
      <-9.282107E-01, 1.423063E+01, -2.684906E+01>,
      <-7.983069E-01, 1.423063E+01, -2.677406E+01>,
      <-6.683993E-01, 1.423063E+01, -2.684906E+01>,
      <-6.684012E-01, 1.423063E+01, -2.699906E+01>,
      <-7.983049E-01, 8.185627E+00, -2.707406E+01>,
      <-9.282107E-01, 8.185627E+00, -2.699906E+01>,
      <-9.282107E-01, 8.185627E+00, -2.684906E+01>,
      <-7.983069E-01, 8.185627E+00, -2.677406E+01>,
      <-6.683993E-01, 8.185627E+00, -2.684906E+01>,
      <-6.684012E-01, 8.185627E+00, -2.699906E+01>
   }
 
   normal_vectors { 
      11, 
      <-5.001227E-01, -3.966549E-06, -8.659545E-01>,
      <-8.660607E-01, -2.303378E-06, -4.999387E-01>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <-4.999786E-01, -3.166497E-08, 8.660377E-01>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <4.999784E-01, -3.166497E-08, 8.660379E-01>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <8.660547E-01, -1.851961E-06, -4.999493E-01>,
      <5.001011E-01, -3.184615E-06, -8.65967E-01>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <0.00E+00, 9.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex24}
   }
 
   face_indices { 
      20, 
      <0, 6, 7>, 0,
      <0, 7, 1>, 0,
      <1, 7, 8>, 0,
      <1, 8, 2>, 0,
      <2, 8, 9>, 0,
      <2, 9, 3>, 0,
      <3, 9, 10>, 0,
      <3, 10, 4>, 0,
      <4, 10, 11>, 0,
      <4, 11, 5>, 0,
      <5, 11, 6>, 0,
      <5, 6, 0>, 0,
      <6, 11, 10>, 0,
      <6, 10, 9>, 0,
      <6, 9, 8>, 0,
      <6, 8, 7>, 0,
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <0, 3, 4>, 0,
      <0, 4, 5>, 0
   }
 
   normal_indices { 
      20, 
      <0, 0, 1>,
      <0, 1, 1>,
      <1, 1, 2>,
      <1, 2, 2>,
      <3, 3, 4>,
      <3, 4, 4>,
      <4, 4, 5>,
      <4, 5, 5>,
      <6, 6, 7>,
      <6, 7, 7>,
      <7, 7, 8>,
      <7, 8, 8>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>,
      <10, 10, 10>,
      <10, 10, 10>,
      <10, 10, 10>,
      <10, 10, 10>
   }
}
 
// BrakeCylinder
mesh2 {
 
   vertex_vectors { 
      88, 
      <4.704862E+00, 3.47001E+00, -6.519982E+00>,
      <5.093771E+00, 3.631102E+00, -6.519982E+00>,
      <5.254858E+00, 4.02001E+00, -6.519982E+00>,
      <5.093771E+00, 4.408919E+00, -6.519982E+00>,
      <4.704862E+00, 4.57001E+00, -6.519982E+00>,
      <4.315954E+00, 4.408918E+00, -6.519982E+00>,
      <4.154867E+00, 4.02001E+00, -6.519982E+00>,
      <4.315954E+00, 3.631102E+00, -6.519982E+00>,
      <4.704863E+00, 3.47001E+00, -7.941361E+00>,
      <5.093771E+00, 3.631102E+00, -7.941361E+00>,
      <5.254858E+00, 4.02001E+00, -7.941361E+00>,
      <5.093771E+00, 4.408919E+00, -7.941361E+00>,
      <4.704863E+00, 4.57001E+00, -7.941361E+00>,
      <4.315954E+00, 4.408919E+00, -7.941361E+00>,
      <4.154867E+00, 4.02001E+00, -7.941361E+00>,
      <4.315954E+00, 3.631102E+00, -7.941361E+00>,
      <4.704863E+00, 3.886732E+00, -8.550519E+00>,
      <4.610617E+00, 3.925768E+00, -8.550519E+00>,
      <4.571585E+00, 4.02001E+00, -8.550519E+00>,
      <4.610617E+00, 4.114253E+00, -8.550519E+00>,
      <4.704863E+00, 4.15329E+00, -8.550519E+00>,
      <4.799109E+00, 4.114253E+00, -8.550519E+00>,
      <4.838141E+00, 4.02001E+00, -8.550519E+00>,
      <4.799109E+00, 3.925768E+00, -8.550519E+00>,
      <4.704863E+00, 3.886731E+00, -9.159684E+00>,
      <4.610617E+00, 3.925767E+00, -9.159684E+00>,
      <4.571585E+00, 4.02001E+00, -9.159684E+00>,
      <4.610617E+00, 4.114253E+00, -9.159684E+00>,
      <4.704863E+00, 4.153289E+00, -9.159684E+00>,
      <4.799109E+00, 4.114253E+00, -9.159684E+00>,
      <4.838141E+00, 4.02001E+00, -9.159684E+00>,
      <4.799109E+00, 3.925767E+00, -9.159684E+00>,
      <4.904867E+00, 3.82001E+00, -6.150792E+00>,
      <4.904867E+00, 4.22001E+00, -6.150792E+00>,
      <4.504858E+00, 4.22001E+00, -6.150792E+00>,
      <4.504858E+00, 3.82001E+00, -6.150792E+00>,
      <4.504858E+00, 3.82001E+00, -6.519982E+00>,
      <4.504858E+00, 4.22001E+00, -6.519982E+00>,
      <4.904867E+00, 4.22001E+00, -6.519982E+00>,
      <4.904867E+00, 3.82001E+00, -6.519982E+00>,
      <4.079863E+00, 4.02001E+00, -6.60278E+00>,
      <4.262922E+00, 4.444275E+00, -6.60278E+00>,
      <4.704863E+00, 4.62001E+00, -6.60278E+00>,
      <5.146803E+00, 4.444275E+00, -6.60278E+00>,
      <5.329863E+00, 4.02001E+00, -6.60278E+00>,
      <5.146803E+00, 3.595746E+00, -6.60278E+00>,
      <4.704863E+00, 3.420011E+00, -6.60278E+00>,
      <4.262922E+00, 3.595746E+00, -6.60278E+00>,
      <4.079862E+00, 4.02001E+00, -6.502782E+00>,
      <4.262922E+00, 4.444275E+00, -6.502782E+00>,
      <4.704862E+00, 4.62001E+00, -6.502782E+00>,
      <5.146802E+00, 4.444275E+00, -6.502781E+00>,
      <5.329862E+00, 4.02001E+00, -6.502781E+00>,
      <5.146802E+00, 3.595746E+00, -6.502781E+00>,
      <4.704862E+00, 3.420011E+00, -6.502782E+00>,
      <4.262922E+00, 3.595746E+00, -6.502782E+00>,
      <4.091589E+00, 4.014784E+00, -7.934178E+00>,
      <4.274649E+00, 4.439049E+00, -7.934178E+00>,
      <4.716589E+00, 4.614784E+00, -7.934178E+00>,
      <5.158529E+00, 4.439049E+00, -7.934178E+00>,
      <5.341589E+00, 4.014784E+00, -7.934178E+00>,
      <5.158529E+00, 3.59052E+00, -7.934178E+00>,
      <4.716589E+00, 3.414784E+00, -7.934178E+00>,
      <4.274649E+00, 3.59052E+00, -7.934178E+00>,
      <4.091589E+00, 4.014785E+00, -7.83418E+00>,
      <4.274649E+00, 4.439049E+00, -7.83418E+00>,
      <4.716589E+00, 4.614784E+00, -7.83418E+00>,
      <5.158529E+00, 4.439049E+00, -7.834179E+00>,
      <5.341589E+00, 4.014785E+00, -7.834179E+00>,
      <5.158529E+00, 3.59052E+00, -7.834179E+00>,
      <4.716589E+00, 3.414784E+00, -7.83418E+00>,
      <4.274649E+00, 3.59052E+00, -7.83418E+00>,
      <4.710725E+00, 3.887397E+00, -6.563664E+00>,
      <4.618801E+00, 3.925473E+00, -6.563664E+00>,
      <4.580726E+00, 4.017397E+00, -6.563664E+00>,
      <4.618801E+00, 4.109321E+00, -6.563664E+00>,
      <4.710725E+00, 4.147397E+00, -6.563664E+00>,
      <4.80265E+00, 4.109321E+00, -6.563664E+00>,
      <4.840724E+00, 4.017397E+00, -6.563664E+00>,
      <4.80265E+00, 3.925473E+00, -6.563664E+00>,
      <4.710725E+00, 3.887397E+00, -5.563664E+00>,
      <4.618801E+00, 3.925473E+00, -5.563664E+00>,
      <4.580726E+00, 4.017397E+00, -5.563664E+00>,
      <4.618801E+00, 4.109321E+00, -5.563664E+00>,
      <4.710725E+00, 4.147397E+00, -5.563664E+00>,
      <4.80265E+00, 4.109321E+00, -5.563664E+00>,
      <4.840724E+00, 4.017397E+00, -5.563664E+00>,
      <4.80265E+00, 3.925473E+00, -5.563664E+00>
   }
 
   normal_vectors { 
      26, 
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <3.726742E-07, -9.54242E-01, -2.990357E-01>,
      <6.747551E-01, -6.747469E-01, -2.990356E-01>,
      <7.071103E-01, -7.071033E-01, 2.304058E-07>,
      <9.542429E-01, -1.400907E-07, -2.990325E-01>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <6.74755E-01, 6.74747E-01, -2.990355E-01>,
      <7.0711E-01, 7.071036E-01, 3.444975E-07>,
      <-1.777978E-07, 9.54242E-01, -2.990354E-01>,
      <0.00E+00, 9.999999E-01, 0.00E+00>,
      <-6.747548E-01, 6.74747E-01, -2.990356E-01>,
      <-7.071101E-01, 7.071034E-01, -6.331182E-08>,
      <-9.542427E-01, 6.842038E-08, -2.99033E-01>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <-6.747546E-01, -6.747472E-01, -2.990359E-01>,
      <-7.071101E-01, -7.071036E-01, -2.84319E-07>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-7.071163E-01, -7.070974E-01, 2.906867E-07>,
      <7.071174E-01, 7.07096E-01, -3.231745E-07>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <-6.968269E-01, 7.172393E-01, -2.27055E-07>,
      <6.968272E-01, 7.17239E-01, 2.270551E-07>,
      <6.96827E-01, -7.172393E-01, 1.051266E-06>,
      <-6.968272E-01, -7.172391E-01, 6.200804E-07>,
      <-7.071105E-01, -7.071031E-01, -2.304059E-07>,
      <7.071105E-01, 7.07103E-01, 2.304059E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex4}
   }
 
   face_indices { 
      144, 
      <0, 8, 9>, 0,
      <0, 9, 1>, 0,
      <1, 9, 10>, 0,
      <1, 10, 2>, 0,
      <2, 10, 11>, 0,
      <2, 11, 3>, 0,
      <3, 11, 12>, 0,
      <3, 12, 4>, 0,
      <4, 12, 13>, 0,
      <4, 13, 5>, 0,
      <5, 13, 14>, 0,
      <5, 14, 6>, 0,
      <6, 14, 15>, 0,
      <6, 15, 7>, 0,
      <7, 15, 8>, 0,
      <7, 8, 0>, 0,
      <16, 8, 15>, 0,
      <16, 15, 17>, 0,
      <17, 15, 14>, 0,
      <17, 14, 18>, 0,
      <18, 14, 13>, 0,
      <18, 13, 19>, 0,
      <19, 13, 12>, 0,
      <19, 12, 20>, 0,
      <20, 12, 11>, 0,
      <20, 11, 21>, 0,
      <21, 11, 10>, 0,
      <21, 10, 22>, 0,
      <22, 10, 9>, 0,
      <22, 9, 23>, 0,
      <23, 9, 8>, 0,
      <23, 8, 16>, 0,
      <24, 25, 26>, 0,
      <24, 26, 27>, 0,
      <24, 27, 28>, 0,
      <24, 28, 29>, 0,
      <24, 29, 30>, 0,
      <24, 30, 31>, 0,
      <24, 16, 17>, 0,
      <24, 17, 25>, 0,
      <25, 17, 18>, 0,
      <25, 18, 26>, 0,
      <26, 18, 19>, 0,
      <26, 19, 27>, 0,
      <27, 19, 20>, 0,
      <27, 20, 28>, 0,
      <28, 20, 21>, 0,
      <28, 21, 29>, 0,
      <29, 21, 22>, 0,
      <29, 22, 30>, 0,
      <30, 22, 23>, 0,
      <30, 23, 31>, 0,
      <31, 23, 16>, 0,
      <31, 16, 24>, 0,
      <32, 33, 34>, 0,
      <32, 34, 35>, 0,
      <36, 37, 38>, 0,
      <36, 38, 39>, 0,
      <35, 34, 37>, 0,
      <35, 37, 36>, 0,
      <39, 38, 33>, 0,
      <39, 33, 32>, 0,
      <33, 38, 37>, 0,
      <33, 37, 34>, 0,
      <35, 36, 39>, 0,
      <35, 39, 32>, 0,
      <40, 48, 49>, 0,
      <40, 49, 41>, 0,
      <41, 49, 50>, 0,
      <41, 50, 42>, 0,
      <42, 50, 51>, 0,
      <42, 51, 43>, 0,
      <43, 51, 52>, 0,
      <43, 52, 44>, 0,
      <44, 52, 53>, 0,
      <44, 53, 45>, 0,
      <45, 53, 54>, 0,
      <45, 54, 46>, 0,
      <46, 54, 55>, 0,
      <46, 55, 47>, 0,
      <47, 55, 48>, 0,
      <47, 48, 40>, 0,
      <48, 55, 54>, 0,
      <48, 54, 53>, 0,
      <48, 53, 52>, 0,
      <48, 52, 51>, 0,
      <48, 51, 50>, 0,
      <48, 50, 49>, 0,
      <40, 41, 42>, 0,
      <40, 42, 43>, 0,
      <40, 43, 44>, 0,
      <40, 44, 45>, 0,
      <40, 45, 46>, 0,
      <40, 46, 47>, 0,
      <56, 64, 65>, 0,
      <56, 65, 57>, 0,
      <57, 65, 66>, 0,
      <57, 66, 58>, 0,
      <58, 66, 67>, 0,
      <58, 67, 59>, 0,
      <59, 67, 68>, 0,
      <59, 68, 60>, 0,
      <60, 68, 69>, 0,
      <60, 69, 61>, 0,
      <61, 69, 70>, 0,
      <61, 70, 62>, 0,
      <62, 70, 71>, 0,
      <62, 71, 63>, 0,
      <63, 71, 64>, 0,
      <63, 64, 56>, 0,
      <64, 71, 70>, 0,
      <64, 70, 69>, 0,
      <64, 69, 68>, 0,
      <64, 68, 67>, 0,
      <64, 67, 66>, 0,
      <64, 66, 65>, 0,
      <56, 57, 58>, 0,
      <56, 58, 59>, 0,
      <56, 59, 60>, 0,
      <56, 60, 61>, 0,
      <56, 61, 62>, 0,
      <56, 62, 63>, 0,
      <72, 80, 81>, 0,
      <72, 81, 73>, 0,
      <73, 81, 82>, 0,
      <73, 82, 74>, 0,
      <74, 82, 83>, 0,
      <74, 83, 75>, 0,
      <75, 83, 84>, 0,
      <75, 84, 76>, 0,
      <76, 84, 85>, 0,
      <76, 85, 77>, 0,
      <77, 85, 86>, 0,
      <77, 86, 78>, 0,
      <78, 86, 87>, 0,
      <78, 87, 79>, 0,
      <79, 87, 80>, 0,
      <79, 80, 72>, 0,
      <80, 87, 86>, 0,
      <80, 86, 85>, 0,
      <80, 85, 84>, 0,
      <80, 84, 83>, 0,
      <80, 83, 82>, 0,
      <80, 82, 81>, 0
   }
 
   normal_indices { 
      144, 
      <0, 1, 2>,
      <0, 2, 3>,
      <3, 2, 4>,
      <3, 4, 5>,
      <5, 4, 6>,
      <5, 6, 7>,
      <7, 6, 8>,
      <7, 8, 9>,
      <9, 8, 10>,
      <9, 10, 11>,
      <11, 10, 12>,
      <11, 12, 13>,
      <13, 12, 14>,
      <13, 14, 15>,
      <15, 14, 1>,
      <15, 1, 0>,
      <1, 1, 14>,
      <1, 14, 14>,
      <14, 14, 12>,
      <14, 12, 12>,
      <12, 12, 10>,
      <12, 10, 10>,
      <10, 10, 8>,
      <10, 8, 8>,
      <8, 8, 6>,
      <8, 6, 6>,
      <6, 6, 4>,
      <6, 4, 4>,
      <4, 4, 2>,
      <4, 2, 2>,
      <2, 2, 1>,
      <2, 1, 1>,
      <16, 16, 16>,
      <16, 16, 16>,
      <16, 16, 16>,
      <16, 16, 16>,
      <16, 16, 16>,
      <16, 16, 16>,
      <0, 1, 14>,
      <0, 14, 17>,
      <17, 14, 12>,
      <17, 12, 13>,
      <13, 12, 10>,
      <13, 10, 11>,
      <11, 10, 8>,
      <11, 8, 9>,
      <9, 8, 6>,
      <9, 6, 18>,
      <18, 6, 4>,
      <18, 4, 5>,
      <5, 4, 2>,
      <5, 2, 3>,
      <3, 2, 1>,
      <3, 1, 0>,
      <19, 19, 19>,
      <19, 19, 19>,
      <16, 16, 16>,
      <16, 16, 16>,
      <13, 13, 13>,
      <13, 13, 13>,
      <5, 5, 5>,
      <5, 5, 5>,
      <9, 9, 9>,
      <9, 9, 9>,
      <0, 0, 0>,
      <0, 0, 0>,
      <13, 13, 20>,
      <13, 20, 20>,
      <20, 20, 9>,
      <20, 9, 9>,
      <9, 9, 21>,
      <9, 21, 21>,
      <21, 21, 5>,
      <21, 5, 5>,
      <5, 5, 22>,
      <5, 22, 22>,
      <22, 22, 0>,
      <22, 0, 0>,
      <0, 0, 23>,
      <0, 23, 23>,
      <23, 23, 13>,
      <23, 13, 13>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <16, 16, 16>,
      <16, 16, 16>,
      <16, 16, 16>,
      <16, 16, 16>,
      <16, 16, 16>,
      <16, 16, 16>,
      <13, 13, 20>,
      <13, 20, 20>,
      <20, 20, 9>,
      <20, 9, 9>,
      <9, 9, 21>,
      <9, 21, 21>,
      <21, 21, 5>,
      <21, 5, 5>,
      <5, 5, 22>,
      <5, 22, 22>,
      <22, 22, 0>,
      <22, 0, 0>,
      <0, 0, 23>,
      <0, 23, 23>,
      <23, 23, 13>,
      <23, 13, 13>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <16, 16, 16>,
      <16, 16, 16>,
      <16, 16, 16>,
      <16, 16, 16>,
      <16, 16, 16>,
      <16, 16, 16>,
      <0, 0, 24>,
      <0, 24, 24>,
      <24, 24, 13>,
      <24, 13, 13>,
      <13, 13, 11>,
      <13, 11, 11>,
      <11, 11, 9>,
      <11, 9, 9>,
      <9, 9, 25>,
      <9, 25, 25>,
      <25, 25, 5>,
      <25, 5, 5>,
      <5, 5, 3>,
      <5, 3, 3>,
      <3, 3, 0>,
      <3, 0, 0>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>
   }
}
 
#declare Tex25 =
texture {
   pigment {rgbf <8.392157E-01, 8.901961E-01, 9.098039E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// Brake_SupportCtr
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.652246E+00, 4.623059E+00, -6.262551E+00>,
      <5.652246E+00, 4.923059E+00, -6.262551E+00>,
      <2.252245E+00, 4.923059E+00, -6.262552E+00>,
      <2.252245E+00, 4.623059E+00, -6.262552E+00>,
      <2.252245E+00, 4.623059E+00, -8.162554E+00>,
      <2.252245E+00, 4.923059E+00, -8.162554E+00>,
      <5.652247E+00, 4.923059E+00, -8.162553E+00>,
      <5.652247E+00, 4.623059E+00, -8.162553E+00>
   }
 
   normal_vectors { 
      4, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex25}
   }
 
   face_indices { 
      8, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0
   }
 
   normal_indices { 
      8, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>
   }
}
 
// Brake_ArmFwd
mesh2 {
 
   vertex_vectors { 
      16, 
      <4.730027E+00, 3.936671E+00, -9.005061E+00>,
      <4.730027E+00, 4.096671E+00, -9.005061E+00>,
      <1.441104E+00, 4.096671E+00, -1.020213E+01>,
      <1.441104E+00, 3.936671E+00, -1.020213E+01>,
      <1.54371E+00, 3.936671E+00, -1.048404E+01>,
      <1.54371E+00, 4.096671E+00, -1.048404E+01>,
      <4.832633E+00, 4.096671E+00, -9.286967E+00>,
      <4.832633E+00, 3.936671E+00, -9.286967E+00>,
      <4.757456E+00, 4.096671E+00, -9.314328E+00>,
      <4.757456E+00, 3.936671E+00, -9.314328E+00>,
      <4.805272E+00, 3.936671E+00, -9.211791E+00>,
      <4.805272E+00, 4.096671E+00, -9.211791E+00>,
      <3.218987E+00, 3.936671E+00, -1.008712E+01>,
      <3.218987E+00, 4.096671E+00, -1.008712E+01>,
      <3.017161E+00, 3.936671E+00, -9.415658E+00>,
      <3.017161E+00, 4.096671E+00, -9.415658E+00>
   }
 
   normal_vectors { 
      11, 
      <-9.396922E-01, -3.166497E-08, -3.420214E-01>,
      <9.990481E-01, -3.166497E-08, -4.362187E-02>,
      <9.396904E-01, -3.166497E-08, 3.420261E-01>,
      <7.173389E-01, -3.166497E-08, -6.967244E-01>,
      <3.420211E-01, -3.166497E-08, -9.396923E-01>,
      <2.305431E-01, -3.166497E-08, -9.730621E-01>,
      <-3.420205E-01, -3.166497E-08, 9.396924E-01>,
      <-4.465075E-01, -3.166497E-08, 8.947799E-01>,
      <-2.331095E-01, -3.166497E-08, 9.724504E-01>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <0.00E+00, 9.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex3}
   }
 
   face_indices { 
      24, 
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <10, 11, 1>, 0,
      <10, 1, 0>, 0,
      <9, 8, 11>, 0,
      <9, 11, 10>, 0,
      <13, 8, 9>, 0,
      <13, 9, 12>, 0,
      <12, 4, 5>, 0,
      <12, 5, 13>, 0,
      <15, 2, 3>, 0,
      <15, 3, 14>, 0,
      <14, 0, 1>, 0,
      <14, 1, 15>, 0,
      <12, 9, 10>, 0,
      <12, 10, 0>, 0,
      <12, 0, 14>, 0,
      <14, 3, 4>, 0,
      <14, 4, 12>, 0,
      <13, 5, 2>, 0,
      <13, 2, 15>, 0,
      <15, 1, 11>, 0,
      <15, 11, 8>, 0,
      <15, 8, 13>, 0
   }
 
   normal_indices { 
      24, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 2>,
      <1, 2, 2>,
      <3, 3, 1>,
      <3, 1, 1>,
      <4, 3, 3>,
      <4, 3, 4>,
      <4, 5, 5>,
      <4, 5, 4>,
      <6, 7, 7>,
      <6, 7, 6>,
      <6, 8, 8>,
      <6, 8, 6>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>,
      <10, 10, 10>,
      <10, 10, 10>,
      <10, 10, 10>,
      <10, 10, 10>,
      <10, 10, 10>
   }
}
 
// Brake_SupportFwd
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.652247E+00, 4.623059E+00, -9.384717E+00>,
      <5.652247E+00, 4.923059E+00, -9.384717E+00>,
      <2.252246E+00, 4.923059E+00, -9.384718E+00>,
      <2.252246E+00, 4.623059E+00, -9.384718E+00>,
      <2.252246E+00, 4.623059E+00, -1.014472E+01>,
      <2.252246E+00, 4.923059E+00, -1.014472E+01>,
      <5.652247E+00, 4.923059E+00, -1.014472E+01>,
      <5.652247E+00, 4.623059E+00, -1.014472E+01>
   }
 
   normal_vectors { 
      4, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex25}
   }
 
   face_indices { 
      8, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0,
      <1, 0, 7>, 0,
      <1, 7, 6>, 0
   }
 
   normal_indices { 
      8, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>
   }
}
 
// Brake_SupportAft
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.652246E+00, 4.623059E+00, -4.58288E+00>,
      <5.652246E+00, 4.923059E+00, -4.58288E+00>,
      <2.252244E+00, 4.923059E+00, -4.582881E+00>,
      <2.252244E+00, 4.623059E+00, -4.582881E+00>,
      <2.252244E+00, 4.623059E+00, -5.342884E+00>,
      <2.252244E+00, 4.923059E+00, -5.342884E+00>,
      <5.652246E+00, 4.923059E+00, -5.342883E+00>,
      <5.652246E+00, 4.623059E+00, -5.342883E+00>
   }
 
   normal_vectors { 
      4, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex25}
   }
 
   face_indices { 
      8, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0,
      <1, 0, 7>, 0,
      <1, 7, 6>, 0
   }
 
   normal_indices { 
      8, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>
   }
}
 
#declare Tex26 =
texture {
   pigment {rgbf <8.235294E-01, 9.764706E-01, 8.823529E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// Brake_PinFwd
mesh2 {
 
   vertex_vectors { 
      8, 
      <3.257001E+00, 3.703379E+00, -9.714076E+00>,
      <3.255614E+00, 4.703379E+00, -9.709695E+00>,
      <3.074351E+00, 4.703379E+00, -9.625171E+00>,
      <3.075738E+00, 3.703379E+00, -9.629552E+00>,
      <2.991214E+00, 3.703379E+00, -9.810815E+00>,
      <2.989829E+00, 4.703379E+00, -9.806432E+00>,
      <3.17109E+00, 4.703379E+00, -9.890958E+00>,
      <3.172477E+00, 3.703379E+00, -9.895339E+00>
   }
 
   normal_vectors { 
      5, 
      <4.226149E-01, -3.384637E-03, 9.06303E-01>,
      <-4.226205E-01, 3.385908E-03, -9.063004E-01>,
      <-9.063048E-01, -3.107888E-03, 4.226132E-01>,
      <9.063038E-01, 3.108265E-03, -4.226153E-01>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex26}
   }
 
   face_indices { 
      10, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Brake_ArmAft
mesh2 {
 
   vertex_vectors { 
      20, 
      <4.832632E+00, 3.936671E+00, -5.429448E+00>,
      <4.832632E+00, 4.096671E+00, -5.429448E+00>,
      <1.543708E+00, 4.096671E+00, -4.232378E+00>,
      <1.543708E+00, 3.936671E+00, -4.232378E+00>,
      <1.441102E+00, 3.936671E+00, -4.514284E+00>,
      <1.441102E+00, 4.096671E+00, -4.514284E+00>,
      <4.730026E+00, 4.096671E+00, -5.711354E+00>,
      <4.730026E+00, 3.936671E+00, -5.711354E+00>,
      <4.654851E+00, 4.096671E+00, -5.683991E+00>,
      <4.654851E+00, 3.936671E+00, -5.683991E+00>,
      <4.757389E+00, 3.936671E+00, -5.636178E+00>,
      <4.757389E+00, 4.096671E+00, -5.636178E+00>,
      <2.979572E+00, 3.936671E+00, -5.287078E+00>,
      <2.979572E+00, 4.096671E+00, -5.287078E+00>,
      <3.256574E+00, 3.936671E+00, -4.642974E+00>,
      <3.256574E+00, 4.096671E+00, -4.642974E+00>,
      <4.805271E+00, 4.096671E+00, -5.504624E+00>,
      <4.805271E+00, 3.936671E+00, -5.504624E+00>,
      <4.761049E+00, 3.936671E+00, -5.393727E+00>,
      <4.761049E+00, 4.096671E+00, -5.393727E+00>
   }
 
   normal_vectors { 
      11, 
      <-9.396924E-01, -3.166497E-08, 3.420208E-01>,
      <1.016717E-01, -3.166497E-08, -9.94818E-01>,
      <7.372758E-01, -3.166497E-08, -6.755919E-01>,
      <-3.420198E-01, -3.166497E-08, -9.396928E-01>,
      <-4.488668E-01, -3.166497E-08, -8.935986E-01>,
      <3.420199E-01, -3.166497E-08, 9.396927E-01>,
      <2.331089E-01, -3.166497E-08, 9.724506E-01>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <0.00E+00, 9.999999E-01, 0.00E+00>,
      <9.998847E-01, -3.166497E-08, 1.518648E-02>,
      <7.359753E-01, -3.166497E-08, 6.770083E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex3}
   }
 
   face_indices { 
      28, 
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <9, 8, 11>, 0,
      <9, 11, 10>, 0,
      <13, 8, 9>, 0,
      <13, 9, 12>, 0,
      <12, 4, 5>, 0,
      <12, 5, 13>, 0,
      <15, 2, 3>, 0,
      <15, 3, 14>, 0,
      <14, 3, 4>, 0,
      <14, 4, 12>, 0,
      <13, 5, 2>, 0,
      <13, 2, 15>, 0,
      <10, 11, 16>, 0,
      <10, 16, 17>, 0,
      <14, 18, 19>, 0,
      <14, 19, 15>, 0,
      <17, 16, 19>, 0,
      <17, 19, 18>, 0,
      <12, 9, 10>, 0,
      <12, 10, 17>, 0,
      <12, 17, 18>, 0,
      <12, 18, 14>, 0,
      <15, 19, 16>, 0,
      <15, 16, 11>, 0,
      <15, 11, 8>, 0,
      <15, 8, 13>, 0
   }
 
   normal_indices { 
      28, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 2>,
      <1, 2, 2>,
      <3, 1, 1>,
      <3, 1, 3>,
      <3, 4, 4>,
      <3, 4, 3>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 7, 7>,
      <7, 7, 7>,
      <8, 8, 8>,
      <8, 8, 8>,
      <2, 2, 9>,
      <2, 9, 9>,
      <5, 10, 10>,
      <5, 10, 5>,
      <9, 9, 10>,
      <9, 10, 10>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <8, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>
   }
}
 
// Brake_PinAft
mesh2 {
 
   vertex_vectors { 
      8, 
      <3.173906E+00, 3.703379E+00, -4.830865E+00>,
      <3.169658E+00, 4.703379E+00, -4.829113E+00>,
      <2.988395E+00, 4.703379E+00, -4.913637E+00>,
      <2.992643E+00, 3.703379E+00, -4.91539E+00>,
      <3.077167E+00, 3.703379E+00, -5.096653E+00>,
      <3.072919E+00, 4.703379E+00, -5.094896E+00>,
      <3.254182E+00, 4.703379E+00, -5.010375E+00>,
      <3.25843E+00, 3.703379E+00, -5.012128E+00>
   }
 
   normal_vectors { 
      5, 
      <-4.226153E-01, -3.383762E-03, 9.063029E-01>,
      <4.226076E-01, 3.385427E-03, -9.063065E-01>,
      <-9.06302E-01, -3.108163E-03, -4.226193E-01>,
      <9.063036E-01, 3.108755E-03, 4.226159E-01>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex26}
   }
 
   face_indices { 
      10, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Brake_PinInAft
mesh2 {
 
   vertex_vectors { 
      8, 
      <1.838351E+00, 3.843379E+00, -4.341253E+00>,
      <1.834104E+00, 4.263379E+00, -4.3395E+00>,
      <1.652841E+00, 4.263379E+00, -4.424025E+00>,
      <1.657088E+00, 3.843379E+00, -4.425777E+00>,
      <1.741613E+00, 3.843379E+00, -4.60704E+00>,
      <1.737365E+00, 4.263379E+00, -4.605284E+00>,
      <1.918628E+00, 4.263379E+00, -4.520763E+00>,
      <1.922875E+00, 3.843379E+00, -4.522516E+00>
   }
 
   normal_vectors { 
      5, 
      <-4.22604E-01, -8.056402E-03, 9.062787E-01>,
      <4.225963E-01, 8.060288E-03, -9.062822E-01>,
      <-9.062815E-01, -7.400075E-03, -4.226099E-01>,
      <9.062833E-01, 7.401769E-03, 4.226059E-01>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex26}
   }
 
   face_indices { 
      10, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Brake_PinInFwd
mesh2 {
 
   vertex_vectors { 
      8, 
      <1.917552E+00, 3.843379E+00, -1.01941E+01>,
      <1.916165E+00, 4.263379E+00, -1.018972E+01>,
      <1.73899E+00, 4.263379E+00, -1.010727E+01>,
      <1.736289E+00, 3.843379E+00, -1.010958E+01>,
      <1.651767E+00, 3.843379E+00, -1.029084E+01>,
      <1.654468E+00, 4.263379E+00, -1.028853E+01>,
      <1.831641E+00, 4.263379E+00, -1.037098E+01>,
      <1.833028E+00, 3.843379E+00, -1.037536E+01>
   }
 
   normal_vectors { 
      5, 
      <4.222603E-01, -7.884934E-03, 9.064403E-01>,
      <-4.222722E-01, 7.884988E-03, -9.064348E-01>,
      <-9.063044E-01, 3.499945E-03, 4.226109E-01>,
      <9.062836E-01, 7.400454E-03, -4.226052E-01>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex26}
   }
 
   face_indices { 
      10, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <7, 4, 5>, 0,
      <7, 5, 6>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
#declare Tex27 =
texture {
   pigment {rgbf <1.00E+00, 1.00E+00, 1.00E+00, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// Brake_PipeTie
mesh2 {
 
   vertex_vectors { 
      8, 
      <3.125102E+00, 3.91827E+00, -4.932588E+00>,
      <3.035102E+00, 3.82827E+00, -4.932588E+00>,
      <3.125102E+00, 3.73827E+00, -4.932588E+00>,
      <3.215102E+00, 3.82827E+00, -4.932588E+00>,
      <3.125104E+00, 3.91827E+00, -9.772588E+00>,
      <3.035104E+00, 3.82827E+00, -9.772588E+00>,
      <3.125104E+00, 3.73827E+00, -9.772588E+00>,
      <3.215104E+00, 3.82827E+00, -9.772588E+00>
   }
 
   normal_vectors { 
      4, 
      <-7.071054E-01, 7.071081E-01, -2.304042E-07>,
      <-7.071064E-01, -7.071072E-01, -2.304045E-07>,
      <7.071068E-01, -7.071068E-01, 2.304046E-07>,
      <7.071058E-01, 7.071077E-01, 2.304043E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex27}
   }
 
   face_indices { 
      8, 
      <1, 0, 4>, 0,
      <1, 4, 5>, 0,
      <2, 1, 5>, 0,
      <2, 5, 6>, 0,
      <3, 2, 6>, 0,
      <3, 6, 7>, 0,
      <0, 3, 7>, 0,
      <0, 7, 4>, 0
   }
 
   normal_indices { 
      8, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>
   }
}
 
// Brake_Pipe_aft
mesh2 {
 
   vertex_vectors { 
      8, 
      <1.79335E+00, 4.278263E+00, 5.352041E-01>,
      <1.703349E+00, 4.188262E+00, 5.352041E-01>,
      <1.79335E+00, 4.098263E+00, 5.352041E-01>,
      <1.88335E+00, 4.188262E+00, 5.352041E-01>,
      <1.793351E+00, 4.278263E+00, -4.464796E+00>,
      <1.703351E+00, 4.188262E+00, -4.464796E+00>,
      <1.793351E+00, 4.098263E+00, -4.464796E+00>,
      <1.883351E+00, 4.188262E+00, -4.464796E+00>
   }
 
   normal_vectors { 
      4, 
      <-7.071066E-01, 7.071069E-01, -2.304046E-07>,
      <-7.071061E-01, -7.071075E-01, -2.304044E-07>,
      <7.071058E-01, -7.071079E-01, 2.304043E-07>,
      <7.071066E-01, 7.071069E-01, 2.304046E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex27}
   }
 
   face_indices { 
      8, 
      <1, 0, 4>, 0,
      <1, 4, 5>, 0,
      <2, 1, 5>, 0,
      <2, 5, 6>, 0,
      <3, 2, 6>, 0,
      <3, 6, 7>, 0,
      <0, 3, 7>, 0,
      <0, 7, 4>, 0
   }
 
   normal_indices { 
      8, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>
   }
}
 
// Brake_PipeFwd
mesh2 {
 
   vertex_vectors { 
      8, 
      <1.77387E+00, 4.277584E+00, -1.027857E+01>,
      <1.683869E+00, 4.187584E+00, -1.027857E+01>,
      <1.77387E+00, 4.097584E+00, -1.027857E+01>,
      <1.86387E+00, 4.187584E+00, -1.027857E+01>,
      <1.773871E+00, 4.277584E+00, -1.527857E+01>,
      <1.683871E+00, 4.187584E+00, -1.527857E+01>,
      <1.773871E+00, 4.097584E+00, -1.527857E+01>,
      <1.863871E+00, 4.187584E+00, -1.527857E+01>
   }
 
   normal_vectors { 
      4, 
      <-7.071061E-01, 7.071074E-01, -2.304044E-07>,
      <-7.071069E-01, -7.071068E-01, -2.304047E-07>,
      <7.071069E-01, -7.071068E-01, 2.304047E-07>,
      <7.071061E-01, 7.071074E-01, 2.304044E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex27}
   }
 
   face_indices { 
      8, 
      <1, 0, 4>, 0,
      <1, 4, 5>, 0,
      <2, 1, 5>, 0,
      <2, 5, 6>, 0,
      <3, 2, 6>, 0,
      <3, 6, 7>, 0,
      <0, 3, 7>, 0,
      <0, 7, 4>, 0
   }
 
   normal_indices { 
      8, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>
   }
}
 
// Brake_BrackFwd
mesh2 {
 
   vertex_vectors { 
      8, 
      <1.92387E+00, 4.046552E+00, -1.17137E+01>,
      <1.92387E+00, 4.546552E+00, -1.17137E+01>,
      <1.62387E+00, 4.546552E+00, -1.17137E+01>,
      <1.62387E+00, 4.046552E+00, -1.17137E+01>,
      <1.62387E+00, 4.046552E+00, -1.19137E+01>,
      <1.62387E+00, 4.546552E+00, -1.19137E+01>,
      <1.92387E+00, 4.546552E+00, -1.19137E+01>,
      <1.92387E+00, 4.046552E+00, -1.19137E+01>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <0.00E+00, 9.999999E-01, 0.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex25}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Brake_BrackAft
mesh2 {
 
   vertex_vectors { 
      8, 
      <1.923144E+00, 4.046552E+00, -2.864673E+00>,
      <1.923144E+00, 4.546552E+00, -2.864673E+00>,
      <1.623145E+00, 4.546552E+00, -2.864674E+00>,
      <1.623145E+00, 4.046552E+00, -2.864674E+00>,
      <1.623145E+00, 4.046552E+00, -3.064674E+00>,
      <1.623145E+00, 4.546552E+00, -3.064674E+00>,
      <1.923144E+00, 4.546552E+00, -3.064674E+00>,
      <1.923144E+00, 4.046552E+00, -3.064674E+00>
   }
 
   normal_vectors { 
      6, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <0.00E+00, 9.999999E-01, 0.00E+00>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex25}
   }
 
   face_indices { 
      12, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Brake_PinOutAft
mesh2 {
 
   vertex_vectors { 
      8, 
      <4.716541E+00, 3.843379E+00, -5.407765E+00>,
      <4.71195E+00, 4.263379E+00, -5.407571E+00>,
      <4.570526E+00, 4.263379E+00, -5.548993E+00>,
      <4.575117E+00, 3.843379E+00, -5.549188E+00>,
      <4.716539E+00, 3.843379E+00, -5.69061E+00>,
      <4.711948E+00, 4.263379E+00, -5.690412E+00>,
      <4.853372E+00, 4.263379E+00, -5.548993E+00>,
      <4.857963E+00, 3.843379E+00, -5.549188E+00>
   }
 
   normal_vectors { 
      5, 
      <-7.070791E-01, -8.056586E-03, 7.070886E-01>,
      <7.070742E-01, 8.059661E-03, -7.070935E-01>,
      <-7.070825E-01, -7.398016E-03, -7.070925E-01>,
      <7.070872E-01, 7.401516E-03, 7.070876E-01>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex26}
   }
 
   face_indices { 
      10, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Brake_PinOutFwd
mesh2 {
 
   vertex_vectors { 
      8, 
      <4.846924E+00, 3.843379E+00, -9.170461E+00>,
      <4.847121E+00, 4.263379E+00, -9.165872E+00>,
      <4.70883E+00, 4.263379E+00, -9.027791E+00>,
      <4.705502E+00, 3.843379E+00, -9.029042E+00>,
      <4.564082E+00, 3.843379E+00, -9.170463E+00>,
      <4.567412E+00, 4.263379E+00, -9.169213E+00>,
      <4.705698E+00, 4.263379E+00, -9.307294E+00>,
      <4.705502E+00, 3.843379E+00, -9.311885E+00>
   }
 
   normal_vectors { 
      5, 
      <7.068141E-01, -7.883986E-03, 7.073554E-01>,
      <-7.068263E-01, 7.885542E-03, -7.073432E-01>,
      <-7.071073E-01, 3.500005E-03, 7.070976E-01>,
      <7.070902E-01, 7.396857E-03, -7.070847E-01>,
      <0.00E+00, -1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex26}
   }
 
   face_indices { 
      10, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <7, 4, 5>, 0,
      <7, 5, 6>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <3, 4, 7>, 0,
      <3, 7, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
#declare Tex28 =
texture {
   pigment {image_map { tga "T-BOGIES.TGA" interpolate 2}}
   finish {ambient 4.472136E-01 diffuse 6.40E-01 brilliance 1.00E+00 specular 6.25E-02 roughness 1.25E-01}
}
 
// Bogie
mesh2 {
 
   vertex_vectors { 
      40, 
      <4.526458E-01, 4.658734E+00, -1.857279E+01>,
      <2.20461E+00, 4.658734E+00, -1.857279E+01>,
      <2.204611E+00, 4.658734E+00, -2.147016E+01>,
      <4.526467E-01, 4.658734E+00, -2.147016E+01>,
      <4.526458E-01, 3.615475E+00, -1.857279E+01>,
      <4.526467E-01, 3.615475E+00, -2.147016E+01>,
      <2.204611E+00, 3.615475E+00, -2.147016E+01>,
      <2.20461E+00, 3.615475E+00, -1.857279E+01>,
      <1.928628E+00, 3.483734E+00, -1.657529E+01>,
      <1.928628E+00, 4.658734E+00, -1.657529E+01>,
      <7.28627E-01, 4.658734E+00, -1.657529E+01>,
      <7.28627E-01, 3.483734E+00, -1.657529E+01>,
      <7.286277E-01, 3.483734E+00, -1.857279E+01>,
      <7.286277E-01, 4.658734E+00, -1.857279E+01>,
      <1.928628E+00, 4.658734E+00, -1.857279E+01>,
      <1.928628E+00, 3.483734E+00, -1.857279E+01>,
      <-1.671373E+00, 3.659985E+00, -1.677505E+01>,
      <-1.671373E+00, 4.482484E+00, -1.677505E+01>,
      <-1.671373E+00, 4.482484E+00, -1.837305E+01>,
      <-1.671373E+00, 3.659985E+00, -1.837305E+01>,
      <4.328628E+00, 3.659985E+00, -1.837304E+01>,
      <4.328628E+00, 4.482484E+00, -1.837304E+01>,
      <4.328628E+00, 4.482484E+00, -1.677504E+01>,
      <4.328628E+00, 3.659985E+00, -1.677504E+01>,
      <1.928629E+00, 3.483734E+00, -2.147016E+01>,
      <1.928629E+00, 4.658734E+00, -2.147016E+01>,
      <7.286286E-01, 4.658734E+00, -2.147016E+01>,
      <7.286286E-01, 3.483734E+00, -2.147016E+01>,
      <7.286293E-01, 3.483734E+00, -2.346766E+01>,
      <7.286293E-01, 4.658734E+00, -2.346766E+01>,
      <1.92863E+00, 4.658734E+00, -2.346766E+01>,
      <1.92863E+00, 3.483734E+00, -2.346766E+01>,
      <-1.671371E+00, 3.659985E+00, -2.166991E+01>,
      <-1.671371E+00, 4.482484E+00, -2.166991E+01>,
      <-1.671371E+00, 4.482484E+00, -2.326791E+01>,
      <-1.671371E+00, 3.659985E+00, -2.326791E+01>,
      <4.328629E+00, 3.659985E+00, -2.326791E+01>,
      <4.328629E+00, 4.482484E+00, -2.326791E+01>,
      <4.328629E+00, 4.482484E+00, -2.166991E+01>,
      <4.328629E+00, 3.659985E+00, -2.166991E+01>
   }
 
   normal_vectors { 
      20, 
      <-4.280104E-16, 9.999999E-01, 4.31381E-16>,
      <4.280104E-16, -1.00E+00, -4.31381E-16>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <3.535034E-02, -3.166497E-08, 9.993749E-01>,
      <-3.535097E-02, -3.166497E-08, 9.993749E-01>,
      <-3.534954E-02, -3.166497E-08, -9.99375E-01>,
      <3.53502E-02, -3.166497E-08, -9.99375E-01>,
      <3.120436E-02, 9.99513E-01, 1.016767E-08>,
      <-3.120436E-02, 9.99513E-01, -1.016767E-08>,
      <-3.120436E-02, -9.995131E-01, -1.016767E-08>,
      <3.120436E-02, -9.995131E-01, 1.016767E-08>,
      <-7.065744E-02, -3.166497E-08, 9.975007E-01>,
      <-6.237834E-02, 9.980525E-01, -2.032544E-08>,
      <-7.065522E-02, -3.166497E-08, -9.975008E-01>,
      <-6.237833E-02, -9.980527E-01, -2.032544E-08>,
      <7.065588E-02, -3.166497E-08, -9.975008E-01>,
      <6.237834E-02, 9.980525E-01, 2.032544E-08>,
      <7.065681E-02, -3.166497E-08, 9.975007E-01>,
      <6.237832E-02, -9.980527E-01, 2.032544E-08>
   }
 
   uv_vectors { 
      40, 
      <-1.26E-01, 1.847E-01>,
      <-2.459E-01, 1.847E-01>,
      <-1.26E-01, 1.31E-01>,
      <-2.459E-01, 1.31E-01>,
      <-1.9794E-01, 1.31E-01>,
      <-1.9794E-01, 1.847E-01>,
      <-1.7396E-01, 1.847E-01>,
      <-1.7396E-01, 1.31E-01>,
      <-1.26E-01, 1.390551E-01>,
      <-1.26E-01, 1.76645E-01>,
      <-2.459E-01, 1.390551E-01>,
      <-2.459E-01, 1.76645E-01>,
      <-6.919007E-01, 9.938E-01>,
      <-5.901992E-01, 9.938E-01>,
      <-6.919007E-01, 6.523212E-01>,
      <-5.901992E-01, 6.523212E-01>,
      <-6.062199E-01, 6.092E-01>,
      <-6.062199E-01, 9.938E-01>,
      <-6.7588E-01, 9.938E-01>,
      <-6.7588E-01, 6.092E-01>,
      <-8.152E-01, 6.6689E-01>,
      <-8.152E-01, 9.3611E-01>,
      <-4.668999E-01, 6.6689E-01>,
      <-4.668999E-01, 9.3611E-01>,
      <-5.901992E-01, 7.206622E-01>,
      <-6.919007E-01, 7.206622E-01>,
      <-6.919007E-01, 8.823378E-01>,
      <-5.901992E-01, 8.823378E-01>,
      <-6.7588E-01, 7.206622E-01>,
      <-6.062199E-01, 7.206622E-01>,
      <-4.669E-01, 6.203462E-01>,
      <-4.669E-01, 7.09516E-01>,
      <-8.151999E-01, 7.095159E-01>,
      <-8.151999E-01, 6.203461E-01>,
      <-6.7588E-01, 8.823378E-01>,
      <-6.062199E-01, 8.823378E-01>,
      <-4.669E-01, 8.934841E-01>,
      <-4.669001E-01, 9.826539E-01>,
      <-8.152E-01, 9.826537E-01>,
      <-8.151999E-01, 8.934839E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      64, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <4, 0, 3>, 0,
      <4, 3, 5>, 0,
      <6, 2, 1>, 0,
      <6, 1, 7>, 0,
      <8, 9, 10>, 0,
      <8, 10, 11>, 0,
      <12, 13, 14>, 0,
      <12, 14, 15>, 0,
      <9, 14, 13>, 0,
      <9, 13, 10>, 0,
      <11, 12, 15>, 0,
      <11, 15, 8>, 0,
      <16, 17, 18>, 0,
      <16, 18, 19>, 0,
      <16, 11, 10>, 0,
      <16, 10, 17>, 0,
      <17, 10, 13>, 0,
      <17, 13, 18>, 0,
      <18, 13, 12>, 0,
      <18, 12, 19>, 0,
      <19, 12, 11>, 0,
      <19, 11, 16>, 0,
      <20, 21, 22>, 0,
      <20, 22, 23>, 0,
      <20, 15, 14>, 0,
      <20, 14, 21>, 0,
      <21, 14, 9>, 0,
      <21, 9, 22>, 0,
      <22, 9, 8>, 0,
      <22, 8, 23>, 0,
      <23, 8, 15>, 0,
      <23, 15, 20>, 0,
      <24, 25, 26>, 0,
      <24, 26, 27>, 0,
      <28, 29, 30>, 0,
      <28, 30, 31>, 0,
      <25, 30, 29>, 0,
      <25, 29, 26>, 0,
      <27, 28, 31>, 0,
      <27, 31, 24>, 0,
      <32, 33, 34>, 0,
      <32, 34, 35>, 0,
      <32, 27, 26>, 0,
      <32, 26, 33>, 0,
      <33, 26, 29>, 0,
      <33, 29, 34>, 0,
      <34, 29, 28>, 0,
      <34, 28, 35>, 0,
      <35, 28, 27>, 0,
      <35, 27, 32>, 0,
      <36, 37, 38>, 0,
      <36, 38, 39>, 0,
      <36, 31, 30>, 0,
      <36, 30, 37>, 0,
      <37, 30, 25>, 0,
      <37, 25, 38>, 0,
      <38, 25, 24>, 0,
      <38, 24, 39>, 0,
      <39, 24, 31>, 0,
      <39, 31, 36>, 0
   }
 
   normal_indices { 
      64, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 5>,
      <4, 5, 5>,
      <6, 6, 7>,
      <6, 7, 7>,
      <8, 8, 9>,
      <8, 9, 9>,
      <10, 10, 11>,
      <10, 11, 11>,
      <2, 2, 2>,
      <2, 2, 2>,
      <12, 5, 5>,
      <12, 5, 12>,
      <13, 9, 9>,
      <13, 9, 13>,
      <14, 6, 6>,
      <14, 6, 14>,
      <15, 10, 10>,
      <15, 10, 15>,
      <3, 3, 3>,
      <3, 3, 3>,
      <16, 7, 7>,
      <16, 7, 16>,
      <17, 8, 8>,
      <17, 8, 17>,
      <18, 4, 4>,
      <18, 4, 18>,
      <19, 11, 11>,
      <19, 11, 19>,
      <4, 4, 5>,
      <4, 5, 5>,
      <6, 6, 7>,
      <6, 7, 7>,
      <8, 8, 9>,
      <8, 9, 9>,
      <10, 10, 11>,
      <10, 11, 11>,
      <2, 2, 2>,
      <2, 2, 2>,
      <12, 5, 5>,
      <12, 5, 12>,
      <13, 9, 9>,
      <13, 9, 13>,
      <14, 6, 6>,
      <14, 6, 14>,
      <15, 10, 10>,
      <15, 10, 15>,
      <3, 3, 3>,
      <3, 3, 3>,
      <16, 7, 7>,
      <16, 7, 16>,
      <17, 8, 8>,
      <17, 8, 17>,
      <18, 4, 4>,
      <18, 4, 18>,
      <19, 11, 11>,
      <19, 11, 19>
   }
 
   uv_indices { 
      64, 
      <24, 25, 26>,
      <24, 26, 27>,
      <14, 14, 15>,
      <14, 15, 15>,
      <14, 12, 12>,
      <14, 12, 14>,
      <15, 13, 13>,
      <15, 13, 15>,
      <16, 17, 18>,
      <16, 18, 19>,
      <19, 18, 17>,
      <19, 17, 16>,
      <19, 28, 29>,
      <19, 29, 16>,
      <19, 19, 16>,
      <19, 16, 16>,
      <20, 21, 21>,
      <20, 21, 20>,
      <20, 19, 18>,
      <20, 18, 21>,
      <30, 16, 29>,
      <30, 29, 31>,
      <21, 18, 19>,
      <21, 19, 20>,
      <20, 19, 19>,
      <20, 19, 20>,
      <22, 23, 23>,
      <22, 23, 22>,
      <22, 16, 17>,
      <22, 17, 23>,
      <32, 28, 19>,
      <32, 19, 33>,
      <23, 17, 16>,
      <23, 16, 22>,
      <22, 16, 16>,
      <22, 16, 22>,
      <16, 17, 18>,
      <16, 18, 19>,
      <19, 18, 17>,
      <19, 17, 16>,
      <34, 18, 17>,
      <34, 17, 35>,
      <19, 19, 16>,
      <19, 16, 16>,
      <20, 21, 21>,
      <20, 21, 20>,
      <20, 19, 18>,
      <20, 18, 21>,
      <36, 35, 17>,
      <36, 17, 37>,
      <21, 18, 19>,
      <21, 19, 20>,
      <20, 19, 19>,
      <20, 19, 20>,
      <22, 23, 23>,
      <22, 23, 22>,
      <22, 16, 17>,
      <22, 17, 23>,
      <38, 18, 34>,
      <38, 34, 39>,
      <23, 17, 16>,
      <23, 16, 22>,
      <22, 16, 16>,
      <22, 16, 22>
   }
   uv_mapping
}
 
// AxleCap4
mesh2 {
 
   vertex_vectors { 
      16, 
      <-2.111731E+00, 2.243096E+00, -2.443693E+01>,
      <-2.552746E+00, 2.243096E+00, -2.443693E+01>,
      <-2.552746E+00, 2.243096E+00, -2.549443E+01>,
      <-2.111731E+00, 2.243096E+00, -2.549443E+01>,
      <-2.111731E+00, 2.946877E+00, -2.443693E+01>,
      <-2.344615E+00, 2.940076E+00, -2.443693E+01>,
      <-2.111731E+00, 3.394596E+00, -2.477768E+01>,
      <-2.1918E+00, 3.394596E+00, -2.477768E+01>,
      <-2.344614E+00, 2.940076E+00, -2.549443E+01>,
      <-2.111731E+00, 2.946877E+00, -2.549443E+01>,
      <-2.111731E+00, 3.394596E+00, -2.515368E+01>,
      <-2.191797E+00, 3.394596E+00, -2.515368E+01>,
      <-2.552746E+00, 2.638586E+00, -2.443693E+01>,
      <-2.552746E+00, 2.638586E+00, -2.549494E+01>,
      <-2.111731E+00, 2.641987E+00, -2.443693E+01>,
      <-2.111731E+00, 2.641987E+00, -2.549443E+01>
   }
 
   normal_vectors { 
      11, 
      <4.280104E-16, -1.00E+00, -4.31381E-16>,
      <-5.894302E-03, 3.186715E-01, 9.478469E-01>,
      <-6.238163E-03, 8.955734E-01, 4.4487E-01>,
      <-6.238354E-03, 8.955733E-01, -4.448702E-01>,
      <-5.556979E-03, 3.189495E-01, -9.477554E-01>,
      <-9.425033E-01, 3.341967E-01, -3.071066E-07>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-8.633783E-01, 5.04557E-01, -9.944127E-07>,
      <-9.300555E-01, 3.67419E-01, -1.712646E-06>
   }
 
   uv_vectors { 
      32, 
      <-3.32E-01, 7.800042E-03>,
      <-3.662E-01, 7.800042E-03>,
      <-3.662E-01, 2.636737E-02>,
      <-3.662E-01, 2.61603E-02>,
      <-3.5518E-01, 4.000002E-02>,
      <-3.32E-01, 2.61603E-02>,
      <-3.32E-01, 2.636737E-02>,
      <-3.4302E-01, 4.000002E-02>,
      <-3.662E-01, 1.698017E-02>,
      <-2.196466E-01, 8.262624E-03>,
      <-1.905533E-01, 8.262624E-03>,
      <-2.196465E-01, 1.66088E-02>,
      <-2.196465E-01, 2.495497E-02>,
      <-2.106276E-01, 3.753743E-02>,
      <-1.995721E-01, 3.753743E-02>,
      <-1.905532E-01, 2.495497E-02>,
      <-3.32E-01, 1.698017E-02>,
      <-1.905532E-01, 1.66088E-02>,
      <-3.662E-01, 1.70837E-02>,
      <-3.32E-01, 1.70837E-02>,
      <-8.377002E-01, 5.168E-01>,
      <-9.824305E-01, 5.168E-01>,
      <-8.377002E-01, 5.954258E-01>,
      <-8.377002E-01, 5.961931E-01>,
      <-8.843356E-01, 6.467E-01>,
      <-9.357951E-01, 6.467E-01>,
      <-9.824305E-01, 5.961931E-01>,
      <-9.824305E-01, 5.954258E-01>,
      <-9.825002E-01, 5.61415E-01>,
      <-8.377002E-01, 5.61415E-01>,
      <-8.377002E-01, 5.617986E-01>,
      <-9.824305E-01, 5.617986E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      22, 
      <1, 2, 3>, 0,
      <1, 3, 0>, 0,
      <7, 5, 4>, 0,
      <7, 4, 6>, 0,
      <6, 10, 11>, 0,
      <6, 11, 7>, 0,
      <11, 10, 9>, 0,
      <11, 9, 8>, 0,
      <13, 2, 1>, 0,
      <13, 1, 12>, 0,
      <14, 4, 5>, 0,
      <14, 5, 12>, 0,
      <12, 1, 0>, 0,
      <12, 0, 14>, 0,
      <8, 9, 15>, 0,
      <8, 15, 13>, 0,
      <13, 15, 3>, 0,
      <13, 3, 2>, 0,
      <5, 7, 11>, 0,
      <5, 11, 8>, 0,
      <8, 13, 12>, 0,
      <8, 12, 5>, 0
   }
 
   normal_indices { 
      22, 
      <0, 0, 0>,
      <0, 0, 0>,
      <2, 1, 1>,
      <2, 1, 2>,
      <2, 3, 3>,
      <2, 3, 2>,
      <3, 3, 4>,
      <3, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <4, 4, 8>,
      <4, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 10, 10>,
      <9, 10, 9>,
      <9, 5, 5>,
      <9, 5, 9>
   }
 
   uv_indices { 
      22, 
      <20, 21, 21>,
      <20, 21, 20>,
      <24, 22, 23>,
      <24, 23, 24>,
      <24, 25, 25>,
      <24, 25, 24>,
      <25, 25, 26>,
      <25, 26, 27>,
      <28, 21, 20>,
      <28, 20, 29>,
      <30, 23, 22>,
      <30, 22, 29>,
      <29, 20, 20>,
      <29, 20, 30>,
      <27, 26, 31>,
      <27, 31, 28>,
      <28, 31, 21>,
      <28, 21, 21>,
      <22, 24, 25>,
      <22, 25, 27>,
      <27, 28, 29>,
      <27, 29, 22>
   }
   uv_mapping
}
 
// AxleCap5
mesh2 {
 
   vertex_vectors { 
      16, 
      <-2.111733E+00, 2.243096E+00, -1.950165E+01>,
      <-2.552748E+00, 2.243096E+00, -1.950165E+01>,
      <-2.552747E+00, 2.243096E+00, -2.055916E+01>,
      <-2.111732E+00, 2.243096E+00, -2.055916E+01>,
      <-2.111733E+00, 2.946877E+00, -1.950165E+01>,
      <-2.344616E+00, 2.940076E+00, -1.950165E+01>,
      <-2.111732E+00, 3.394596E+00, -1.984241E+01>,
      <-2.191801E+00, 3.394596E+00, -1.984241E+01>,
      <-2.344616E+00, 2.940076E+00, -2.055916E+01>,
      <-2.111732E+00, 2.946877E+00, -2.055916E+01>,
      <-2.111732E+00, 3.394596E+00, -2.02184E+01>,
      <-2.191799E+00, 3.394596E+00, -2.02184E+01>,
      <-2.552748E+00, 2.638586E+00, -1.950165E+01>,
      <-2.552747E+00, 2.638586E+00, -2.055967E+01>,
      <-2.111733E+00, 2.641987E+00, -1.950165E+01>,
      <-2.111732E+00, 2.641987E+00, -2.055916E+01>
   }
 
   normal_vectors { 
      11, 
      <4.280104E-16, -1.00E+00, -4.31381E-16>,
      <-5.894406E-03, 3.186716E-01, 9.478468E-01>,
      <-6.238272E-03, 8.955734E-01, 4.448698E-01>,
      <-6.23791E-03, 8.955733E-01, -4.448701E-01>,
      <-5.556765E-03, 3.189494E-01, -9.477555E-01>,
      <-9.425033E-01, 3.341968E-01, -3.071065E-07>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-8.633782E-01, 5.045572E-01, -9.944126E-07>,
      <-9.300554E-01, 3.674192E-01, -1.712646E-06>
   }
 
   uv_vectors { 
      32, 
      <-3.32E-01, 7.800042E-03>,
      <-3.662E-01, 7.800042E-03>,
      <-3.662E-01, 2.636737E-02>,
      <-3.662E-01, 2.61603E-02>,
      <-3.5518E-01, 4.000002E-02>,
      <-3.32E-01, 2.61603E-02>,
      <-3.32E-01, 2.636737E-02>,
      <-3.4302E-01, 4.000002E-02>,
      <-3.662E-01, 1.698017E-02>,
      <-2.196466E-01, 8.262624E-03>,
      <-1.905533E-01, 8.262624E-03>,
      <-2.196465E-01, 1.66088E-02>,
      <-2.196465E-01, 2.495497E-02>,
      <-2.106276E-01, 3.753743E-02>,
      <-1.995721E-01, 3.753743E-02>,
      <-1.905532E-01, 2.495497E-02>,
      <-3.32E-01, 1.698017E-02>,
      <-1.905532E-01, 1.66088E-02>,
      <-3.662E-01, 1.70837E-02>,
      <-3.32E-01, 1.70837E-02>,
      <-8.377E-01, 5.168E-01>,
      <-9.824304E-01, 5.168E-01>,
      <-8.377E-01, 5.954258E-01>,
      <-8.377E-01, 5.961931E-01>,
      <-8.843354E-01, 6.467E-01>,
      <-9.357949E-01, 6.467E-01>,
      <-9.824304E-01, 5.961931E-01>,
      <-9.824304E-01, 5.954258E-01>,
      <-9.825E-01, 5.61415E-01>,
      <-8.377E-01, 5.61415E-01>,
      <-8.377E-01, 5.617986E-01>,
      <-9.824304E-01, 5.617986E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      22, 
      <1, 2, 3>, 0,
      <1, 3, 0>, 0,
      <7, 5, 4>, 0,
      <7, 4, 6>, 0,
      <6, 10, 11>, 0,
      <6, 11, 7>, 0,
      <11, 10, 9>, 0,
      <11, 9, 8>, 0,
      <13, 2, 1>, 0,
      <13, 1, 12>, 0,
      <14, 4, 5>, 0,
      <14, 5, 12>, 0,
      <12, 1, 0>, 0,
      <12, 0, 14>, 0,
      <8, 9, 15>, 0,
      <8, 15, 13>, 0,
      <13, 15, 3>, 0,
      <13, 3, 2>, 0,
      <5, 7, 11>, 0,
      <5, 11, 8>, 0,
      <8, 13, 12>, 0,
      <8, 12, 5>, 0
   }
 
   normal_indices { 
      22, 
      <0, 0, 0>,
      <0, 0, 0>,
      <2, 1, 1>,
      <2, 1, 2>,
      <2, 3, 3>,
      <2, 3, 2>,
      <3, 3, 4>,
      <3, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <4, 4, 8>,
      <4, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 10, 10>,
      <9, 10, 9>,
      <9, 5, 5>,
      <9, 5, 9>
   }
 
   uv_indices { 
      22, 
      <20, 21, 21>,
      <20, 21, 20>,
      <24, 22, 23>,
      <24, 23, 24>,
      <24, 25, 25>,
      <24, 25, 24>,
      <25, 25, 26>,
      <25, 26, 27>,
      <28, 21, 20>,
      <28, 20, 29>,
      <30, 23, 22>,
      <30, 22, 29>,
      <29, 20, 20>,
      <29, 20, 30>,
      <27, 26, 31>,
      <27, 31, 28>,
      <28, 31, 21>,
      <28, 21, 21>,
      <22, 24, 25>,
      <22, 25, 27>,
      <27, 28, 29>,
      <27, 29, 22>
   }
   uv_mapping
}
 
// AxleCap6
mesh2 {
 
   vertex_vectors { 
      16, 
      <-2.111734E+00, 2.243096E+00, -1.454588E+01>,
      <-2.552749E+00, 2.243096E+00, -1.454588E+01>,
      <-2.552749E+00, 2.243096E+00, -1.560339E+01>,
      <-2.111734E+00, 2.243096E+00, -1.560339E+01>,
      <-2.111734E+00, 2.946877E+00, -1.454588E+01>,
      <-2.344618E+00, 2.940076E+00, -1.454588E+01>,
      <-2.111734E+00, 3.394596E+00, -1.488664E+01>,
      <-2.191803E+00, 3.394596E+00, -1.488664E+01>,
      <-2.344617E+00, 2.940076E+00, -1.560339E+01>,
      <-2.111734E+00, 2.946877E+00, -1.560339E+01>,
      <-2.111734E+00, 3.394596E+00, -1.526264E+01>,
      <-2.191801E+00, 3.394596E+00, -1.526264E+01>,
      <-2.552749E+00, 2.638586E+00, -1.454588E+01>,
      <-2.552749E+00, 2.638586E+00, -1.56039E+01>,
      <-2.111734E+00, 2.641987E+00, -1.454588E+01>,
      <-2.111734E+00, 2.641987E+00, -1.560339E+01>
   }
 
   normal_vectors { 
      11, 
      <4.280104E-16, -1.00E+00, -4.31381E-16>,
      <-5.894301E-03, 3.186715E-01, 9.478469E-01>,
      <-6.238161E-03, 8.955734E-01, 4.448698E-01>,
      <-6.237912E-03, 8.955733E-01, -4.448703E-01>,
      <-5.558199E-03, 3.189483E-01, -9.477558E-01>,
      <-9.425033E-01, 3.341968E-01, -3.071065E-07>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-8.633782E-01, 5.045571E-01, -9.94413E-07>,
      <-9.300555E-01, 3.674192E-01, -1.712647E-06>
   }
 
   uv_vectors { 
      32, 
      <-3.32E-01, 7.800042E-03>,
      <-3.662E-01, 7.800042E-03>,
      <-3.662E-01, 2.636737E-02>,
      <-3.662E-01, 2.61603E-02>,
      <-3.5518E-01, 4.000002E-02>,
      <-3.32E-01, 2.61603E-02>,
      <-3.32E-01, 2.636737E-02>,
      <-3.4302E-01, 4.000002E-02>,
      <-3.662E-01, 1.698017E-02>,
      <-2.196466E-01, 8.262624E-03>,
      <-1.905533E-01, 8.262624E-03>,
      <-2.196465E-01, 1.66088E-02>,
      <-2.196465E-01, 2.495497E-02>,
      <-2.106276E-01, 3.753743E-02>,
      <-1.995721E-01, 3.753743E-02>,
      <-1.905532E-01, 2.495497E-02>,
      <-3.32E-01, 1.698017E-02>,
      <-1.905532E-01, 1.66088E-02>,
      <-3.662E-01, 1.70837E-02>,
      <-3.32E-01, 1.70837E-02>,
      <-8.377E-01, 5.168E-01>,
      <-9.824304E-01, 5.168E-01>,
      <-8.377E-01, 5.954258E-01>,
      <-8.377E-01, 5.961931E-01>,
      <-8.843354E-01, 6.467E-01>,
      <-9.357949E-01, 6.467E-01>,
      <-9.824304E-01, 5.961931E-01>,
      <-9.824304E-01, 5.954258E-01>,
      <-9.825E-01, 5.61415E-01>,
      <-8.377E-01, 5.61415E-01>,
      <-8.377E-01, 5.617986E-01>,
      <-9.824304E-01, 5.617986E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      22, 
      <1, 2, 3>, 0,
      <1, 3, 0>, 0,
      <7, 5, 4>, 0,
      <7, 4, 6>, 0,
      <6, 10, 11>, 0,
      <6, 11, 7>, 0,
      <11, 10, 9>, 0,
      <11, 9, 8>, 0,
      <13, 2, 1>, 0,
      <13, 1, 12>, 0,
      <14, 4, 5>, 0,
      <14, 5, 12>, 0,
      <12, 1, 0>, 0,
      <12, 0, 14>, 0,
      <8, 9, 15>, 0,
      <8, 15, 13>, 0,
      <13, 15, 3>, 0,
      <13, 3, 2>, 0,
      <5, 7, 11>, 0,
      <5, 11, 8>, 0,
      <8, 13, 12>, 0,
      <8, 12, 5>, 0
   }
 
   normal_indices { 
      22, 
      <0, 0, 0>,
      <0, 0, 0>,
      <2, 1, 1>,
      <2, 1, 2>,
      <2, 3, 3>,
      <2, 3, 2>,
      <3, 3, 4>,
      <3, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <4, 4, 8>,
      <4, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 10, 10>,
      <9, 10, 9>,
      <9, 5, 5>,
      <9, 5, 9>
   }
 
   uv_indices { 
      22, 
      <20, 21, 21>,
      <20, 21, 20>,
      <24, 22, 23>,
      <24, 23, 24>,
      <24, 25, 25>,
      <24, 25, 24>,
      <25, 25, 26>,
      <25, 26, 27>,
      <28, 21, 20>,
      <28, 20, 29>,
      <30, 23, 22>,
      <30, 22, 29>,
      <29, 20, 20>,
      <29, 20, 30>,
      <27, 26, 31>,
      <27, 31, 28>,
      <28, 31, 21>,
      <28, 21, 21>,
      <22, 24, 25>,
      <22, 25, 27>,
      <27, 28, 29>,
      <27, 29, 22>
   }
   uv_mapping
}
 
// TruckFrameP
mesh2 {
 
   vertex_vectors { 
      76, 
      <4.753748E+00, 4.560828E+00, -2.003231E+01>,
      <4.187973E+00, 4.56175E+00, -2.003231E+01>,
      <4.743519E+00, 2.068395E+00, -2.002733E+01>,
      <4.17775E+00, 2.069316E+00, -2.002733E+01>,
      <4.743506E+00, 2.064746E+00, -2.089038E+01>,
      <4.177735E+00, 2.065668E+00, -2.089038E+01>,
      <4.745667E+00, 2.5911E+00, -2.089339E+01>,
      <4.179892E+00, 2.592021E+00, -2.089339E+01>,
      <4.74754E+00, 3.047194E+00, -2.130782E+01>,
      <4.181759E+00, 3.048117E+00, -2.130782E+01>,
      <4.748684E+00, 3.326682E+00, -2.18241E+01>,
      <4.182913E+00, 3.327603E+00, -2.18241E+01>,
      <4.748668E+00, 3.322262E+00, -2.300505E+01>,
      <4.182893E+00, 3.323184E+00, -2.300505E+01>,
      <4.747514E+00, 3.041656E+00, -2.36631E+01>,
      <4.181741E+00, 3.042578E+00, -2.366311E+01>,
      <4.745624E+00, 2.58004E+00, -2.4012E+01>,
      <4.179845E+00, 2.580961E+00, -2.4012E+01>,
      <4.74341E+00, 2.040997E+00, -2.408074E+01>,
      <4.177639E+00, 2.041919E+00, -2.408074E+01>,
      <4.743391E+00, 2.036054E+00, -2.57567E+01>,
      <4.177618E+00, 2.036975E+00, -2.57567E+01>,
      <4.744402E+00, 2.282681E+00, -2.575721E+01>,
      <4.178625E+00, 2.283601E+00, -2.575721E+01>,
      <4.746E+00, 2.672192E+00, -2.586553E+01>,
      <4.180225E+00, 2.673113E+00, -2.586553E+01>,
      <4.747133E+00, 2.948522E+00, -2.611299E+01>,
      <4.181364E+00, 2.949444E+00, -2.611299E+01>,
      <4.74824E+00, 3.218226E+00, -2.650075E+01>,
      <4.182467E+00, 3.219148E+00, -2.650075E+01>,
      <4.748234E+00, 3.215935E+00, -2.708746E+01>,
      <4.182459E+00, 3.216857E+00, -2.708746E+01>,
      <4.750811E+00, 3.844833E+00, -2.708959E+01>,
      <4.185038E+00, 3.845754E+00, -2.70896E+01>,
      <4.751814E+00, 4.088362E+00, -2.689243E+01>,
      <4.186039E+00, 4.089283E+00, -2.689243E+01>,
      <4.75342E+00, 4.480934E+00, -2.59272E+01>,
      <4.187653E+00, 4.481855E+00, -2.59272E+01>,
      <4.753681E+00, 4.543828E+00, -2.494333E+01>,
      <4.187906E+00, 4.54475E+00, -2.494333E+01>,
      <4.743505E+00, 2.064746E+00, -1.916428E+01>,
      <4.177734E+00, 2.065668E+00, -1.916428E+01>,
      <4.745666E+00, 2.5911E+00, -1.916127E+01>,
      <4.179891E+00, 2.592021E+00, -1.916127E+01>,
      <4.747539E+00, 3.047194E+00, -1.874684E+01>,
      <4.181758E+00, 3.048117E+00, -1.874685E+01>,
      <4.748683E+00, 3.326682E+00, -1.823056E+01>,
      <4.182912E+00, 3.327603E+00, -1.823056E+01>,
      <4.748666E+00, 3.322262E+00, -1.704961E+01>,
      <4.182891E+00, 3.323184E+00, -1.704961E+01>,
      <4.747512E+00, 3.041656E+00, -1.639156E+01>,
      <4.181739E+00, 3.042578E+00, -1.639156E+01>,
      <4.745621E+00, 2.58004E+00, -1.604266E+01>,
      <4.179842E+00, 2.580961E+00, -1.604267E+01>,
      <4.743407E+00, 2.040997E+00, -1.597393E+01>,
      <4.177636E+00, 2.041919E+00, -1.597393E+01>,
      <4.743387E+00, 2.036054E+00, -1.429796E+01>,
      <4.177614E+00, 2.036975E+00, -1.429796E+01>,
      <4.744398E+00, 2.282681E+00, -1.429745E+01>,
      <4.178621E+00, 2.283601E+00, -1.429745E+01>,
      <4.745996E+00, 2.672192E+00, -1.418913E+01>,
      <4.180222E+00, 2.673113E+00, -1.418913E+01>,
      <4.747129E+00, 2.948522E+00, -1.394167E+01>,
      <4.18136E+00, 2.949444E+00, -1.394168E+01>,
      <4.748236E+00, 3.218226E+00, -1.355391E+01>,
      <4.182463E+00, 3.219148E+00, -1.355391E+01>,
      <4.74823E+00, 3.215935E+00, -1.296721E+01>,
      <4.182455E+00, 3.216857E+00, -1.296721E+01>,
      <4.750806E+00, 3.844833E+00, -1.296507E+01>,
      <4.185033E+00, 3.845754E+00, -1.296507E+01>,
      <4.75181E+00, 4.088362E+00, -1.316224E+01>,
      <4.186035E+00, 4.089283E+00, -1.316224E+01>,
      <4.753416E+00, 4.480934E+00, -1.412747E+01>,
      <4.187649E+00, 4.481855E+00, -1.412747E+01>,
      <4.753678E+00, 4.543828E+00, -1.511133E+01>,
      <4.187903E+00, 4.54475E+00, -1.511133E+01>
   }
 
   normal_vectors { 
      36, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <4.280104E-16, -1.00E+00, -4.31381E-16>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-5.0329E-04, -3.631432E-01, -9.317332E-01>,
      <-1.091414E-03, -7.870983E-01, -6.168266E-01>,
      <-1.344556E-03, -9.698404E-01, -2.437375E-01>,
      <-1.357506E-03, -9.793831E-01, 2.020077E-01>,
      <-1.092242E-03, -7.879433E-01, 6.157469E-01>,
      <-5.232947E-04, -3.774295E-01, 9.260382E-01>,
      <-1.754982E-04, -1.264971E-01, 9.919669E-01>,
      <-1.884342E-04, -1.362277E-01, -9.906775E-01>,
      <-6.654162E-04, -4.801098E-01, -8.772082E-01>,
      <-1.038604E-03, -7.490952E-01, -6.624616E-01>,
      <-1.323382E-03, -9.547687E-01, -2.973469E-01>,
      <4.605429E-04, 3.321596E-01, -9.432231E-01>,
      <1.113081E-03, 8.031384E-01, -5.957914E-01>,
      <1.351296E-03, 9.747795E-01, -2.23166E-01>,
      <1.386167E-03, 9.994329E-01, -3.364427E-02>,
      <-4.280104E-16, 9.999999E-01, 4.31381E-16>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <-5.038435E-04, -3.631432E-01, 9.317332E-01>,
      <-1.091711E-03, -7.870983E-01, 6.168266E-01>,
      <-1.344605E-03, -9.698404E-01, 2.437374E-01>,
      <-1.357315E-03, -9.793829E-01, -2.020083E-01>,
      <-1.091947E-03, -7.87943E-01, -6.157473E-01>,
      <-5.229198E-04, -3.774298E-01, -9.260381E-01>,
      <-1.750795E-04, -1.264975E-01, -9.919669E-01>,
      <-1.888265E-04, -1.362255E-01, 9.906778E-01>,
      <-6.670168E-04, -4.801101E-01, 8.77208E-01>,
      <-1.040969E-03, -7.490939E-01, 6.624631E-01>,
      <-1.32454E-03, -9.547687E-01, 2.973469E-01>,
      <4.59924E-04, 3.321639E-01, 9.432216E-01>,
      <1.112564E-03, 8.031428E-01, 5.957854E-01>,
      <1.351036E-03, 9.747793E-01, 2.231669E-01>,
      <1.386146E-03, 9.99433E-01, 3.364081E-02>
   }
 
   uv_vectors { 
      414, 
      <-2.046E-01, 9.50455E-04>,
      <-2.044556E-01, 7.419997E-02>,
      <-6.747044E-01, 1.152495E-01>,
      <-4.011471E-01, 1.145969E-01>,
      <-3.606242E-01, 6.020861E-02>,
      <-1.579244E-01, 2.517338E-02>,
      <-1.453434E-01, 7.10662E-02>,
      <-3.173649E-03, 2.092282E-01>,
      <-2.607399E-02, 2.379216E-01>,
      <-1.381813E-01, 2.841752E-01>,
      <-2.524532E-01, 2.915855E-01>,
      <-7.20838E-01, 6.151171E-02>,
      <-6.197401E-01, 1.511789E-01>,
      <-4.645773E-01, 1.506583E-01>,
      <-1.246028E-01, 1.036236E-01>,
      <-7.156575E-02, 1.404006E-01>,
      <-3.421843E-03, 1.401306E-01>,
      <-5.641788E-01, 5.883074E-01>,
      <-6.759159E-01, 5.810612E-01>,
      <-6.970152E-01, 4.04516E-01>,
      <-6.689128E-01, 3.726806E-01>,
      <-6.566107E-01, 3.278061E-01>,
      <-6.565531E-01, 2.993928E-01>,
      <-4.662144E-01, 2.999625E-01>,
      <-4.584077E-01, 3.620643E-01>,
      <-4.18784E-01, 4.152457E-01>,
      <-3.440497E-01, 4.475738E-01>,
      <-2.09929E-01, 4.480829E-01>,
      <-1.512954E-01, 4.158841E-01>,
      <-1.042293E-01, 3.633384E-01>,
      <-5.871534E-03, 3.031187E-01>,
      <-5.305231E-03, 5.902659E-01>,
      <-8.165E-01, 9.252285E-01>,
      <-8.125838E-01, 9.57226E-01>,
      <-4.76269E-01, 9.570976E-01>,
      <-4.801807E-01, 9.251E-01>,
      <-8.094193E-01, 9.875E-01>,
      <-4.731E-01, 9.873715E-01>,
      <-8.056706E-01, 9.251E-01>,
      <-8.165004E-01, 9.865987E-01>,
      <-4.839258E-01, 9.875E-01>,
      <-4.731004E-01, 9.260013E-01>,
      <-8.138481E-01, 9.251E-01>,
      <-8.165005E-01, 9.87354E-01>,
      <-4.757576E-01, 9.875E-01>,
      <-4.731005E-01, 9.252461E-01>,
      <-8.143413E-01, 9.251E-01>,
      <-8.158955E-01, 9.667082E-01>,
      <-4.746559E-01, 9.667693E-01>,
      <-4.752599E-01, 9.875E-01>,
      <-8.149452E-01, 9.667693E-01>,
      <-4.737057E-01, 9.667083E-01>,
      <-4.752599E-01, 9.251E-01>,
      <-8.143413E-01, 9.875E-01>,
      <-4.79441E-01, 9.71815E-01>,
      <-8.15111E-01, 9.717873E-01>,
      <-4.779892E-01, 9.608642E-01>,
      <-8.13658E-01, 9.608366E-01>,
      <-4.764569E-01, 9.525719E-01>,
      <-8.121303E-01, 9.525443E-01>,
      <-4.750684E-01, 9.473768E-01>,
      <-8.107361E-01, 9.473491E-01>,
      <-6.093669E-01, 9.875E-01>,
      <-4.731E-01, 9.358639E-01>,
      <-6.802346E-01, 9.251E-01>,
      <-8.165E-01, 9.767362E-01>,
      <-6.511039E-01, 9.925E-01>,
      <-4.656E-01, 9.366999E-01>,
      <-6.221966E-01, 9.263E-01>,
      <-8.077E-01, 9.821002E-01>,
      <-6.366501E-01, 9.924985E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.656E-01, 9.26301E-01>,
      <-6.366501E-01, 9.263001E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.077E-01, 9.925001E-01>,
      <-4.656E-01, 9.820999E-01>,
      <-6.511061E-01, 9.263E-01>,
      <-8.076999E-01, 9.367001E-01>,
      <-6.221933E-01, 9.925E-01>,
      <-8.047949E-01, 9.263E-01>,
      <-4.685062E-01, 9.925E-01>,
      <-8.053998E-01, 9.334068E-01>,
      <-4.662043E-01, 9.334333E-01>,
      <-8.063581E-01, 9.472352E-01>,
      <-4.671637E-01, 9.472617E-01>,
      <-8.070373E-01, 9.611779E-01>,
      <-4.678464E-01, 9.612043E-01>,
      <-8.077005E-01, 9.783284E-01>,
      <-4.685073E-01, 9.783549E-01>,
      <-8.045977E-01, 9.263E-01>,
      <-8.058926E-01, 9.445296E-01>,
      <-4.668931E-01, 9.445614E-01>,
      <-8.070148E-01, 9.703102E-01>,
      <-4.680119E-01, 9.70342E-01>,
      <-4.687034E-01, 9.925E-01>,
      <-4.656E-01, 9.810792E-01>,
      <-6.013628E-01, 9.263E-01>,
      <-8.077E-01, 9.377209E-01>,
      <-6.719353E-01, 9.925E-01>,
      <-8.070968E-01, 9.366705E-01>,
      <-4.679013E-01, 9.36632E-01>,
      <-4.685073E-01, 9.263E-01>,
      <-8.061374E-01, 9.554002E-01>,
      <-4.669431E-01, 9.553617E-01>,
      <-8.054547E-01, 9.72515E-01>,
      <-4.662638E-01, 9.724765E-01>,
      <-8.047938E-01, 9.925E-01>,
      <-5.472026E-01, 9.925E-01>,
      <-4.656E-01, 9.45287E-01>,
      <-7.260988E-01, 9.263E-01>,
      <-8.076999E-01, 9.73513E-01>,
      <-8.064069E-01, 9.445614E-01>,
      <-4.674074E-01, 9.445295E-01>,
      <-4.687022E-01, 9.263E-01>,
      <-8.05288E-01, 9.70342E-01>,
      <-4.662851E-01, 9.703102E-01>,
      <-8.045966E-01, 9.925E-01>,
      <-4.662919E-01, 9.678896E-01>,
      <-8.052427E-01, 9.679187E-01>,
      <-4.674243E-01, 9.449727E-01>,
      <-8.063785E-01, 9.450018E-01>,
      <-7.89536E-01, 5.358341E-01>,
      <-8.119286E-01, 5.077778E-01>,
      <-8.116856E-01, 4.483239E-01>,
      <-7.410533E-01, 4.395881E-01>,
      <-9.688789E-02, 3.026984E-01>,
      <-8.208482E-01, 2.935884E-01>,
      <-8.21427E-01, 1.00E-03>,
      <-7.211874E-01, 1.00E-03>,
      <-3.526406E-01, 1.00E-03>,
      <-1.579831E-01, 1.00E-03>,
      <-8.152E-01, 9.215873E-01>,
      <-6.40607E-01, 9.202015E-01>,
      <-6.405473E-01, 9.949143E-01>,
      <-8.151404E-01, 9.963001E-01>,
      <-4.656E-01, 9.935129E-01>,
      <-4.656596E-01, 9.188001E-01>,
      <-1.874804E-03, 3.024706E-01>,
      <-9.998667E-02, 3.625397E-01>,
      <-1.469352E-01, 4.14954E-01>,
      <-2.054224E-01, 4.470723E-01>,
      <-3.392073E-01, 4.465645E-01>,
      <-4.137549E-01, 4.143173E-01>,
      <-4.532796E-01, 3.612688E-01>,
      <-4.610668E-01, 2.993222E-01>,
      <-9.464604E-02, 3.021559E-01>,
      <-6.559296E-01, 2.98754E-01>,
      <-6.559871E-01, 3.270963E-01>,
      <-6.682582E-01, 3.718586E-01>,
      <-6.962906E-01, 4.036143E-01>,
      <-7.462181E-01, 4.416088E-01>,
      <-8.106839E-01, 4.483452E-01>,
      <-8.10926E-01, 5.06618E-01>,
      <-7.885892E-01, 5.346041E-01>,
      <-2.530497E-01, 2.93377E-01>,
      <-1.399122E-01, 2.860404E-01>,
      <-2.891767E-02, 2.40246E-01>,
      <-6.244719E-03, 2.118375E-01>,
      <-6.489635E-03, 1.384754E-01>,
      <-7.395738E-02, 1.387428E-01>,
      <-1.185479E-01, 1.072811E-01>,
      <-1.470027E-01, 7.504681E-02>,
      <-1.594592E-01, 2.960964E-02>,
      <-1.595172E-01, 8.400737E-04>,
      <-3.522428E-01, 1.416883E-03>,
      <-3.601472E-01, 6.429716E-02>,
      <-4.002675E-01, 1.181454E-01>,
      <-4.75939E-01, 1.508787E-01>,
      <-6.117408E-01, 1.513942E-01>,
      <-6.7111E-01, 1.187916E-01>,
      <-7.187657E-01, 6.558718E-02>,
      <-7.191114E-01, 4.187306E-03>,
      <-8.183562E-01, 4.612735E-03>,
      <-8.177832E-01, 2.953604E-01>,
      <-1.31005E-03, 5.938998E-01>,
      <-6.702439E-01, 5.847182E-01>,
      <-5.587863E-01, 5.919462E-01>,
      <-6.366501E-01, 9.924985E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.656E-01, 9.26301E-01>,
      <-6.366501E-01, 9.263001E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.064069E-01, 9.445614E-01>,
      <-4.674074E-01, 9.445295E-01>,
      <-4.687022E-01, 9.263E-01>,
      <-8.064069E-01, 9.445614E-01>,
      <-8.05288E-01, 9.70342E-01>,
      <-4.662851E-01, 9.703102E-01>,
      <-4.674074E-01, 9.445295E-01>,
      <-8.05288E-01, 9.70342E-01>,
      <-8.045966E-01, 9.925E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.662851E-01, 9.703102E-01>,
      <-6.093669E-01, 9.875E-01>,
      <-4.731E-01, 9.358639E-01>,
      <-6.802346E-01, 9.251E-01>,
      <-8.165E-01, 9.767362E-01>,
      <-4.79441E-01, 9.71815E-01>,
      <-4.779892E-01, 9.608642E-01>,
      <-8.13658E-01, 9.608366E-01>,
      <-8.15111E-01, 9.717873E-01>,
      <-4.779892E-01, 9.608642E-01>,
      <-4.764569E-01, 9.525719E-01>,
      <-8.121303E-01, 9.525443E-01>,
      <-8.13658E-01, 9.608366E-01>,
      <-4.764569E-01, 9.525719E-01>,
      <-4.750684E-01, 9.473768E-01>,
      <-8.107361E-01, 9.473491E-01>,
      <-8.121303E-01, 9.525443E-01>,
      <-6.511039E-01, 9.925E-01>,
      <-4.656E-01, 9.366999E-01>,
      <-6.221966E-01, 9.263E-01>,
      <-8.077E-01, 9.821002E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.070968E-01, 9.366705E-01>,
      <-4.679013E-01, 9.36632E-01>,
      <-4.685073E-01, 9.263E-01>,
      <-8.070968E-01, 9.366705E-01>,
      <-8.061374E-01, 9.554002E-01>,
      <-4.669431E-01, 9.553617E-01>,
      <-4.679013E-01, 9.36632E-01>,
      <-8.061374E-01, 9.554002E-01>,
      <-8.054547E-01, 9.72515E-01>,
      <-4.662638E-01, 9.724765E-01>,
      <-4.669431E-01, 9.553617E-01>,
      <-8.054547E-01, 9.72515E-01>,
      <-8.047938E-01, 9.925E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.662638E-01, 9.724765E-01>,
      <-5.472026E-01, 9.925E-01>,
      <-4.656E-01, 9.45287E-01>,
      <-7.260988E-01, 9.263E-01>,
      <-8.076999E-01, 9.73513E-01>,
      <-8.165E-01, 9.252285E-01>,
      <-8.149452E-01, 9.667693E-01>,
      <-4.737057E-01, 9.667083E-01>,
      <-4.752599E-01, 9.251E-01>,
      <-8.149452E-01, 9.667693E-01>,
      <-8.143413E-01, 9.875E-01>,
      <-4.731E-01, 9.873715E-01>,
      <-4.737057E-01, 9.667083E-01>,
      <-8.165E-01, 9.252285E-01>,
      <-8.125838E-01, 9.57226E-01>,
      <-4.76269E-01, 9.570976E-01>,
      <-4.801807E-01, 9.251E-01>,
      <-8.125838E-01, 9.57226E-01>,
      <-8.094193E-01, 9.875E-01>,
      <-4.731E-01, 9.873715E-01>,
      <-4.76269E-01, 9.570976E-01>,
      <-8.152E-01, 9.215873E-01>,
      <-6.40607E-01, 9.202015E-01>,
      <-6.405473E-01, 9.949143E-01>,
      <-8.151404E-01, 9.963001E-01>,
      <-8.208482E-01, 2.935884E-01>,
      <-8.21427E-01, 1.00E-03>,
      <-7.211874E-01, 1.00E-03>,
      <-7.20838E-01, 6.151171E-02>,
      <-6.747044E-01, 1.152495E-01>,
      <-6.197401E-01, 1.511789E-01>,
      <-4.645773E-01, 1.506583E-01>,
      <-4.011471E-01, 1.145969E-01>,
      <-3.606242E-01, 6.020861E-02>,
      <-3.526406E-01, 1.00E-03>,
      <-1.579831E-01, 1.00E-03>,
      <-1.579244E-01, 2.517338E-02>,
      <-1.453434E-01, 7.10662E-02>,
      <-1.246028E-01, 1.036236E-01>,
      <-7.156575E-02, 1.404006E-01>,
      <-3.421843E-03, 1.401306E-01>,
      <-3.173649E-03, 2.092282E-01>,
      <-2.607399E-02, 2.379216E-01>,
      <-1.381813E-01, 2.841752E-01>,
      <-2.524532E-01, 2.915855E-01>,
      <-2.530497E-01, 2.93377E-01>,
      <-1.399122E-01, 2.860404E-01>,
      <-2.891767E-02, 2.40246E-01>,
      <-6.244719E-03, 2.118375E-01>,
      <-6.489635E-03, 1.384754E-01>,
      <-7.395738E-02, 1.387428E-01>,
      <-1.185479E-01, 1.072811E-01>,
      <-1.470027E-01, 7.504681E-02>,
      <-1.594592E-01, 2.960964E-02>,
      <-1.595172E-01, 8.400737E-04>,
      <-3.522428E-01, 1.416883E-03>,
      <-3.601472E-01, 6.429716E-02>,
      <-4.002675E-01, 1.181454E-01>,
      <-4.75939E-01, 1.508787E-01>,
      <-6.117408E-01, 1.513942E-01>,
      <-6.7111E-01, 1.187916E-01>,
      <-7.187657E-01, 6.558718E-02>,
      <-7.191114E-01, 4.187306E-03>,
      <-8.183562E-01, 4.612735E-03>,
      <-8.177832E-01, 2.953604E-01>,
      <-2.044556E-01, 7.419997E-02>,
      <-2.046E-01, 9.50455E-04>,
      <-2.046E-01, 9.50455E-04>,
      <-2.044556E-01, 7.419997E-02>,
      <-6.366501E-01, 9.263001E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.077E-01, 9.925001E-01>,
      <-6.366501E-01, 9.924985E-01>,
      <-8.045977E-01, 9.263E-01>,
      <-8.058926E-01, 9.445296E-01>,
      <-4.668931E-01, 9.445614E-01>,
      <-4.656E-01, 9.26301E-01>,
      <-8.058926E-01, 9.445296E-01>,
      <-8.070148E-01, 9.703102E-01>,
      <-4.680119E-01, 9.70342E-01>,
      <-4.668931E-01, 9.445614E-01>,
      <-8.070148E-01, 9.703102E-01>,
      <-8.077E-01, 9.925001E-01>,
      <-4.687034E-01, 9.925E-01>,
      <-4.680119E-01, 9.70342E-01>,
      <-4.656E-01, 9.810792E-01>,
      <-6.013628E-01, 9.263E-01>,
      <-8.077E-01, 9.377209E-01>,
      <-6.719353E-01, 9.925E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.662919E-01, 9.678896E-01>,
      <-8.052427E-01, 9.679187E-01>,
      <-8.045966E-01, 9.925E-01>,
      <-4.662919E-01, 9.678896E-01>,
      <-4.674243E-01, 9.449727E-01>,
      <-8.063785E-01, 9.450018E-01>,
      <-8.052427E-01, 9.679187E-01>,
      <-4.674243E-01, 9.449727E-01>,
      <-4.687022E-01, 9.263E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.063785E-01, 9.450018E-01>,
      <-4.656E-01, 9.820999E-01>,
      <-6.511061E-01, 9.263E-01>,
      <-8.076999E-01, 9.367001E-01>,
      <-6.221933E-01, 9.925E-01>,
      <-8.047949E-01, 9.263E-01>,
      <-8.053998E-01, 9.334068E-01>,
      <-4.662043E-01, 9.334333E-01>,
      <-4.656E-01, 9.26301E-01>,
      <-8.053998E-01, 9.334068E-01>,
      <-8.063581E-01, 9.472352E-01>,
      <-4.671637E-01, 9.472617E-01>,
      <-4.662043E-01, 9.334333E-01>,
      <-8.063581E-01, 9.472352E-01>,
      <-8.070373E-01, 9.611779E-01>,
      <-4.678464E-01, 9.612043E-01>,
      <-4.671637E-01, 9.472617E-01>,
      <-8.070373E-01, 9.611779E-01>,
      <-8.077005E-01, 9.783284E-01>,
      <-4.685073E-01, 9.783549E-01>,
      <-4.678464E-01, 9.612043E-01>,
      <-8.077005E-01, 9.783284E-01>,
      <-8.077E-01, 9.925001E-01>,
      <-4.685062E-01, 9.925E-01>,
      <-4.685073E-01, 9.783549E-01>,
      <-8.143413E-01, 9.251E-01>,
      <-8.158955E-01, 9.667082E-01>,
      <-4.746559E-01, 9.667693E-01>,
      <-4.731005E-01, 9.252461E-01>,
      <-8.158955E-01, 9.667082E-01>,
      <-8.165005E-01, 9.87354E-01>,
      <-4.752599E-01, 9.875E-01>,
      <-4.746559E-01, 9.667693E-01>,
      <-8.138481E-01, 9.251E-01>,
      <-8.165005E-01, 9.87354E-01>,
      <-4.757576E-01, 9.875E-01>,
      <-4.731005E-01, 9.252461E-01>,
      <-8.056706E-01, 9.251E-01>,
      <-8.165004E-01, 9.865987E-01>,
      <-4.839258E-01, 9.875E-01>,
      <-4.731004E-01, 9.260013E-01>,
      <-4.656E-01, 9.935129E-01>,
      <-6.405473E-01, 9.949143E-01>,
      <-6.40607E-01, 9.202015E-01>,
      <-4.656596E-01, 9.188001E-01>,
      <-5.641788E-01, 5.883074E-01>,
      <-6.759159E-01, 5.810612E-01>,
      <-7.89536E-01, 5.358341E-01>,
      <-8.119286E-01, 5.077778E-01>,
      <-8.116856E-01, 4.483239E-01>,
      <-7.410533E-01, 4.395881E-01>,
      <-6.970152E-01, 4.04516E-01>,
      <-6.689128E-01, 3.726806E-01>,
      <-6.566107E-01, 3.278061E-01>,
      <-6.565531E-01, 2.993928E-01>,
      <-4.662144E-01, 2.999625E-01>,
      <-4.584077E-01, 3.620643E-01>,
      <-4.18784E-01, 4.152457E-01>,
      <-3.440497E-01, 4.475738E-01>,
      <-2.09929E-01, 4.480829E-01>,
      <-1.512954E-01, 4.158841E-01>,
      <-1.042293E-01, 3.633384E-01>,
      <-9.688789E-02, 3.026984E-01>,
      <-5.871534E-03, 3.031187E-01>,
      <-5.305231E-03, 5.902659E-01>,
      <-1.31005E-03, 5.938998E-01>,
      <-1.874804E-03, 3.024706E-01>,
      <-9.464604E-02, 3.021559E-01>,
      <-9.998667E-02, 3.625397E-01>,
      <-1.469352E-01, 4.14954E-01>,
      <-2.054224E-01, 4.470723E-01>,
      <-3.392073E-01, 4.465645E-01>,
      <-4.137549E-01, 4.143173E-01>,
      <-4.532796E-01, 3.612688E-01>,
      <-4.610668E-01, 2.993222E-01>,
      <-6.559296E-01, 2.98754E-01>,
      <-6.559871E-01, 3.270963E-01>,
      <-6.682582E-01, 3.718586E-01>,
      <-6.962906E-01, 4.036143E-01>,
      <-7.462181E-01, 4.416088E-01>,
      <-8.106839E-01, 4.483452E-01>,
      <-8.10926E-01, 5.06618E-01>,
      <-7.885892E-01, 5.346041E-01>,
      <-6.702439E-01, 5.847182E-01>,
      <-5.587863E-01, 5.919462E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      152, 
      <1, 3, 2>, 0,
      <1, 2, 0>, 0,
      <3, 5, 4>, 0,
      <3, 4, 2>, 0,
      <5, 7, 6>, 0,
      <5, 6, 4>, 0,
      <7, 9, 8>, 0,
      <7, 8, 6>, 0,
      <9, 11, 10>, 0,
      <9, 10, 8>, 0,
      <11, 13, 12>, 0,
      <11, 12, 10>, 0,
      <13, 15, 14>, 0,
      <13, 14, 12>, 0,
      <15, 17, 16>, 0,
      <15, 16, 14>, 0,
      <17, 19, 18>, 0,
      <17, 18, 16>, 0,
      <19, 21, 20>, 0,
      <19, 20, 18>, 0,
      <21, 23, 22>, 0,
      <21, 22, 20>, 0,
      <23, 25, 24>, 0,
      <23, 24, 22>, 0,
      <25, 27, 26>, 0,
      <25, 26, 24>, 0,
      <27, 29, 28>, 0,
      <27, 28, 26>, 0,
      <29, 31, 30>, 0,
      <29, 30, 28>, 0,
      <31, 33, 32>, 0,
      <31, 32, 30>, 0,
      <33, 35, 34>, 0,
      <33, 34, 32>, 0,
      <35, 37, 36>, 0,
      <35, 36, 34>, 0,
      <37, 39, 38>, 0,
      <37, 38, 36>, 0,
      <39, 1, 0>, 0,
      <39, 0, 38>, 0,
      <0, 2, 4>, 0,
      <0, 4, 6>, 0,
      <0, 6, 8>, 0,
      <0, 8, 10>, 0,
      <0, 10, 12>, 0,
      <16, 18, 20>, 0,
      <16, 20, 22>, 0,
      <16, 22, 24>, 0,
      <16, 24, 26>, 0,
      <16, 26, 28>, 0,
      <28, 30, 32>, 0,
      <28, 32, 34>, 0,
      <28, 34, 36>, 0,
      <28, 36, 38>, 0,
      <28, 38, 0>, 0,
      <28, 0, 12>, 0,
      <28, 12, 14>, 0,
      <14, 16, 28>, 0,
      <1, 39, 37>, 0,
      <1, 37, 35>, 0,
      <1, 35, 33>, 0,
      <1, 33, 31>, 0,
      <1, 31, 29>, 0,
      <1, 29, 27>, 0,
      <1, 27, 25>, 0,
      <23, 21, 19>, 0,
      <23, 19, 17>, 0,
      <23, 17, 15>, 0,
      <23, 15, 13>, 0,
      <7, 5, 3>, 0,
      <7, 3, 1>, 0,
      <25, 23, 13>, 0,
      <9, 7, 1>, 0,
      <1, 25, 13>, 0,
      <1, 13, 11>, 0,
      <11, 9, 1>, 0,
      <0, 2, 3>, 0,
      <0, 3, 1>, 0,
      <2, 40, 41>, 0,
      <2, 41, 3>, 0,
      <40, 42, 43>, 0,
      <40, 43, 41>, 0,
      <42, 44, 45>, 0,
      <42, 45, 43>, 0,
      <44, 46, 47>, 0,
      <44, 47, 45>, 0,
      <46, 48, 49>, 0,
      <46, 49, 47>, 0,
      <48, 50, 51>, 0,
      <48, 51, 49>, 0,
      <50, 52, 53>, 0,
      <50, 53, 51>, 0,
      <52, 54, 55>, 0,
      <52, 55, 53>, 0,
      <54, 56, 57>, 0,
      <54, 57, 55>, 0,
      <56, 58, 59>, 0,
      <56, 59, 57>, 0,
      <58, 60, 61>, 0,
      <58, 61, 59>, 0,
      <60, 62, 63>, 0,
      <60, 63, 61>, 0,
      <62, 64, 65>, 0,
      <62, 65, 63>, 0,
      <64, 66, 67>, 0,
      <64, 67, 65>, 0,
      <66, 68, 69>, 0,
      <66, 69, 67>, 0,
      <68, 70, 71>, 0,
      <68, 71, 69>, 0,
      <70, 72, 73>, 0,
      <70, 73, 71>, 0,
      <72, 74, 75>, 0,
      <72, 75, 73>, 0,
      <74, 0, 1>, 0,
      <74, 1, 75>, 0,
      <0, 74, 72>, 0,
      <0, 72, 70>, 0,
      <0, 70, 68>, 0,
      <0, 68, 66>, 0,
      <0, 66, 64>, 0,
      <0, 64, 62>, 0,
      <0, 62, 60>, 0,
      <58, 56, 54>, 0,
      <58, 54, 52>, 0,
      <58, 52, 50>, 0,
      <58, 50, 48>, 0,
      <42, 40, 2>, 0,
      <42, 2, 0>, 0,
      <60, 58, 48>, 0,
      <44, 42, 0>, 0,
      <0, 60, 48>, 0,
      <0, 48, 46>, 0,
      <46, 44, 0>, 0,
      <1, 3, 41>, 0,
      <1, 41, 43>, 0,
      <1, 43, 45>, 0,
      <1, 45, 47>, 0,
      <1, 47, 49>, 0,
      <53, 55, 57>, 0,
      <53, 57, 59>, 0,
      <53, 59, 61>, 0,
      <53, 61, 63>, 0,
      <53, 63, 65>, 0,
      <65, 67, 69>, 0,
      <65, 69, 71>, 0,
      <65, 71, 73>, 0,
      <65, 73, 75>, 0,
      <65, 75, 1>, 0,
      <65, 1, 49>, 0,
      <65, 49, 51>, 0,
      <51, 53, 65>, 0
   }
 
   normal_indices { 
      152, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 3, 3>,
      <2, 3, 2>,
      <3, 4, 4>,
      <3, 4, 3>,
      <4, 5, 5>,
      <4, 5, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <6, 7, 7>,
      <6, 7, 6>,
      <7, 8, 8>,
      <7, 8, 7>,
      <8, 9, 9>,
      <8, 9, 8>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 10, 10>,
      <2, 10, 2>,
      <10, 11, 11>,
      <10, 11, 10>,
      <11, 12, 12>,
      <11, 12, 11>,
      <12, 13, 13>,
      <12, 13, 12>,
      <13, 1, 1>,
      <13, 1, 13>,
      <2, 14, 14>,
      <2, 14, 2>,
      <14, 15, 15>,
      <14, 15, 14>,
      <15, 16, 16>,
      <15, 16, 15>,
      <16, 17, 17>,
      <16, 17, 16>,
      <17, 18, 18>,
      <17, 18, 17>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <2, 2, 2>,
      <2, 2, 2>,
      <1, 1, 1>,
      <1, 1, 1>,
      <0, 21, 21>,
      <0, 21, 0>,
      <21, 22, 22>,
      <21, 22, 21>,
      <22, 23, 23>,
      <22, 23, 22>,
      <23, 24, 24>,
      <23, 24, 23>,
      <24, 25, 25>,
      <24, 25, 24>,
      <25, 26, 26>,
      <25, 26, 25>,
      <26, 27, 27>,
      <26, 27, 26>,
      <1, 1, 1>,
      <1, 1, 1>,
      <0, 28, 28>,
      <0, 28, 0>,
      <28, 29, 29>,
      <28, 29, 28>,
      <29, 30, 30>,
      <29, 30, 29>,
      <30, 31, 31>,
      <30, 31, 30>,
      <31, 1, 1>,
      <31, 1, 31>,
      <0, 32, 32>,
      <0, 32, 0>,
      <32, 33, 33>,
      <32, 33, 32>,
      <33, 34, 34>,
      <33, 34, 33>,
      <34, 35, 35>,
      <34, 35, 34>,
      <35, 18, 18>,
      <35, 18, 35>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>
   }
 
   uv_indices { 
      152, 
      <127, 128, 128>,
      <127, 128, 127>,
      <178, 179, 180>,
      <178, 180, 181>,
      <182, 183, 184>,
      <182, 184, 185>,
      <186, 187, 188>,
      <186, 188, 189>,
      <190, 191, 192>,
      <190, 192, 193>,
      <194, 195, 196>,
      <194, 196, 197>,
      <198, 199, 200>,
      <198, 200, 201>,
      <202, 203, 204>,
      <202, 204, 205>,
      <206, 207, 208>,
      <206, 208, 209>,
      <210, 211, 212>,
      <210, 212, 213>,
      <214, 215, 216>,
      <214, 216, 217>,
      <218, 219, 220>,
      <218, 220, 221>,
      <222, 223, 224>,
      <222, 224, 225>,
      <226, 227, 228>,
      <226, 228, 229>,
      <230, 231, 232>,
      <230, 232, 233>,
      <234, 235, 236>,
      <234, 236, 237>,
      <238, 239, 240>,
      <238, 240, 241>,
      <242, 243, 244>,
      <242, 244, 245>,
      <246, 247, 248>,
      <246, 248, 249>,
      <250, 251, 252>,
      <250, 252, 253>,
      <254, 255, 256>,
      <254, 256, 257>,
      <254, 257, 258>,
      <254, 258, 259>,
      <254, 259, 260>,
      <262, 263, 264>,
      <262, 264, 265>,
      <262, 265, 266>,
      <262, 266, 267>,
      <262, 267, 268>,
      <268, 269, 270>,
      <268, 270, 271>,
      <268, 271, 272>,
      <268, 272, 273>,
      <268, 273, 254>,
      <268, 254, 260>,
      <268, 260, 261>,
      <261, 262, 268>,
      <293, 274, 275>,
      <293, 275, 276>,
      <293, 276, 277>,
      <293, 277, 278>,
      <293, 278, 279>,
      <293, 279, 280>,
      <293, 280, 281>,
      <282, 283, 284>,
      <282, 284, 285>,
      <282, 285, 286>,
      <282, 286, 287>,
      <290, 291, 292>,
      <290, 292, 293>,
      <281, 282, 287>,
      <289, 290, 293>,
      <293, 281, 287>,
      <293, 287, 288>,
      <288, 289, 293>,
      <294, 295, 296>,
      <294, 296, 297>,
      <298, 299, 300>,
      <298, 300, 301>,
      <302, 303, 304>,
      <302, 304, 305>,
      <306, 307, 308>,
      <306, 308, 309>,
      <310, 311, 312>,
      <310, 312, 313>,
      <314, 315, 316>,
      <314, 316, 317>,
      <318, 319, 320>,
      <318, 320, 321>,
      <322, 323, 324>,
      <322, 324, 325>,
      <326, 327, 328>,
      <326, 328, 329>,
      <330, 331, 332>,
      <330, 332, 333>,
      <334, 335, 336>,
      <334, 336, 337>,
      <338, 339, 340>,
      <338, 340, 341>,
      <342, 343, 344>,
      <342, 344, 345>,
      <346, 347, 348>,
      <346, 348, 349>,
      <350, 351, 352>,
      <350, 352, 353>,
      <354, 355, 356>,
      <354, 356, 357>,
      <358, 359, 360>,
      <358, 360, 361>,
      <362, 363, 364>,
      <362, 364, 365>,
      <366, 367, 368>,
      <366, 368, 369>,
      <370, 371, 372>,
      <370, 372, 373>,
      <393, 374, 375>,
      <393, 375, 376>,
      <393, 376, 377>,
      <393, 377, 378>,
      <393, 378, 379>,
      <393, 379, 380>,
      <393, 380, 381>,
      <382, 383, 384>,
      <382, 384, 385>,
      <382, 385, 386>,
      <382, 386, 387>,
      <390, 391, 392>,
      <390, 392, 393>,
      <381, 382, 387>,
      <389, 390, 393>,
      <393, 381, 387>,
      <393, 387, 388>,
      <388, 389, 393>,
      <394, 395, 396>,
      <394, 396, 397>,
      <394, 397, 398>,
      <394, 398, 399>,
      <394, 399, 400>,
      <402, 403, 404>,
      <402, 404, 405>,
      <402, 405, 406>,
      <402, 406, 407>,
      <402, 407, 408>,
      <408, 409, 410>,
      <408, 410, 411>,
      <408, 411, 412>,
      <408, 412, 413>,
      <408, 413, 394>,
      <408, 394, 400>,
      <408, 400, 401>,
      <401, 402, 408>
   }
   uv_mapping
}
 
// AxleCap1
mesh2 {
 
   vertex_vectors { 
      16, 
      <4.75375E+00, 2.243096E+00, -2.549442E+01>,
      <5.194765E+00, 2.243096E+00, -2.549442E+01>,
      <5.194765E+00, 2.243096E+00, -2.443692E+01>,
      <4.753749E+00, 2.243096E+00, -2.443692E+01>,
      <4.75375E+00, 2.946877E+00, -2.549442E+01>,
      <4.986633E+00, 2.940076E+00, -2.549442E+01>,
      <4.75375E+00, 3.394596E+00, -2.515367E+01>,
      <4.833818E+00, 3.394596E+00, -2.515367E+01>,
      <4.986633E+00, 2.940076E+00, -2.443692E+01>,
      <4.753749E+00, 2.946877E+00, -2.443692E+01>,
      <4.753749E+00, 3.394596E+00, -2.477767E+01>,
      <4.833816E+00, 3.394596E+00, -2.477767E+01>,
      <5.194765E+00, 2.638586E+00, -2.549442E+01>,
      <5.194765E+00, 2.638586E+00, -2.443641E+01>,
      <4.75375E+00, 2.641987E+00, -2.549442E+01>,
      <4.753749E+00, 2.641987E+00, -2.443692E+01>
   }
 
   normal_vectors { 
      11, 
      <4.280104E-16, -1.00E+00, -4.31381E-16>,
      <5.894721E-03, 3.186714E-01, -9.478469E-01>,
      <6.238607E-03, 8.955734E-01, -4.4487E-01>,
      <6.237905E-03, 8.955734E-01, 4.448698E-01>,
      <5.556739E-03, 3.189497E-01, 9.477553E-01>,
      <9.425034E-01, 3.341965E-01, 3.071066E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <8.633783E-01, 5.04557E-01, 9.944129E-07>,
      <9.300555E-01, 3.674191E-01, 1.712646E-06>
   }
 
   uv_vectors { 
      32, 
      <-3.32E-01, 7.800042E-03>,
      <-3.662E-01, 7.800042E-03>,
      <-3.662E-01, 2.636737E-02>,
      <-3.662E-01, 2.61603E-02>,
      <-3.5518E-01, 4.000002E-02>,
      <-3.32E-01, 2.61603E-02>,
      <-3.32E-01, 2.636737E-02>,
      <-3.4302E-01, 4.000002E-02>,
      <-3.662E-01, 1.698017E-02>,
      <-2.196466E-01, 8.262624E-03>,
      <-1.905533E-01, 8.262624E-03>,
      <-2.196465E-01, 1.66088E-02>,
      <-2.196465E-01, 2.495497E-02>,
      <-2.106276E-01, 3.753743E-02>,
      <-1.995721E-01, 3.753743E-02>,
      <-1.905532E-01, 2.495497E-02>,
      <-3.32E-01, 1.698017E-02>,
      <-1.905532E-01, 1.66088E-02>,
      <-3.662E-01, 1.70837E-02>,
      <-3.32E-01, 1.70837E-02>,
      <-8.377002E-01, 5.168E-01>,
      <-9.824305E-01, 5.168E-01>,
      <-8.377002E-01, 5.954258E-01>,
      <-8.377002E-01, 5.961931E-01>,
      <-8.843356E-01, 6.467E-01>,
      <-9.357951E-01, 6.467E-01>,
      <-9.824305E-01, 5.961931E-01>,
      <-9.824305E-01, 5.954258E-01>,
      <-9.825002E-01, 5.61415E-01>,
      <-8.377002E-01, 5.61415E-01>,
      <-8.377002E-01, 5.617986E-01>,
      <-9.824305E-01, 5.617986E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      22, 
      <1, 2, 3>, 0,
      <1, 3, 0>, 0,
      <7, 5, 4>, 0,
      <7, 4, 6>, 0,
      <6, 10, 11>, 0,
      <6, 11, 7>, 0,
      <11, 10, 9>, 0,
      <11, 9, 8>, 0,
      <13, 2, 1>, 0,
      <13, 1, 12>, 0,
      <14, 4, 5>, 0,
      <14, 5, 12>, 0,
      <12, 1, 0>, 0,
      <12, 0, 14>, 0,
      <8, 9, 15>, 0,
      <8, 15, 13>, 0,
      <13, 15, 3>, 0,
      <13, 3, 2>, 0,
      <5, 7, 11>, 0,
      <5, 11, 8>, 0,
      <8, 13, 12>, 0,
      <8, 12, 5>, 0
   }
 
   normal_indices { 
      22, 
      <0, 0, 0>,
      <0, 0, 0>,
      <2, 1, 1>,
      <2, 1, 2>,
      <2, 3, 3>,
      <2, 3, 2>,
      <3, 3, 4>,
      <3, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <4, 4, 8>,
      <4, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 10, 10>,
      <9, 10, 9>,
      <9, 5, 5>,
      <9, 5, 9>
   }
 
   uv_indices { 
      22, 
      <20, 21, 21>,
      <20, 21, 20>,
      <24, 22, 23>,
      <24, 23, 24>,
      <24, 25, 25>,
      <24, 25, 24>,
      <25, 25, 26>,
      <25, 26, 27>,
      <28, 21, 20>,
      <28, 20, 29>,
      <30, 23, 22>,
      <30, 22, 29>,
      <29, 20, 20>,
      <29, 20, 30>,
      <27, 26, 31>,
      <27, 31, 28>,
      <28, 31, 21>,
      <28, 21, 21>,
      <22, 24, 25>,
      <22, 25, 27>,
      <27, 28, 29>,
      <27, 29, 22>
   }
   uv_mapping
}
 
// AxleCap2
mesh2 {
 
   vertex_vectors { 
      16, 
      <4.753748E+00, 2.243096E+00, -2.055915E+01>,
      <5.194763E+00, 2.243096E+00, -2.055915E+01>,
      <5.194763E+00, 2.243096E+00, -1.950165E+01>,
      <4.753748E+00, 2.243096E+00, -1.950165E+01>,
      <4.753748E+00, 2.946877E+00, -2.055915E+01>,
      <4.986631E+00, 2.940076E+00, -2.055915E+01>,
      <4.753748E+00, 3.394596E+00, -2.02184E+01>,
      <4.833817E+00, 3.394596E+00, -2.02184E+01>,
      <4.986631E+00, 2.940076E+00, -1.950165E+01>,
      <4.753748E+00, 2.946877E+00, -1.950165E+01>,
      <4.753748E+00, 3.394596E+00, -1.98424E+01>,
      <4.833815E+00, 3.394596E+00, -1.98424E+01>,
      <5.194763E+00, 2.638586E+00, -2.055915E+01>,
      <5.194763E+00, 2.638586E+00, -1.950114E+01>,
      <4.753748E+00, 2.641987E+00, -2.055915E+01>,
      <4.753748E+00, 2.641987E+00, -1.950165E+01>
   }
 
   normal_vectors { 
      11, 
      <4.280104E-16, -1.00E+00, -4.31381E-16>,
      <5.894302E-03, 3.186716E-01, -9.478469E-01>,
      <6.238162E-03, 8.955734E-01, -4.448699E-01>,
      <6.23802E-03, 8.955734E-01, 4.448701E-01>,
      <5.559804E-03, 3.18947E-01, 9.477562E-01>,
      <9.425034E-01, 3.341966E-01, 3.071066E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <8.633783E-01, 5.045571E-01, 9.944126E-07>,
      <9.300554E-01, 3.674191E-01, 1.712646E-06>
   }
 
   uv_vectors { 
      32, 
      <-3.32E-01, 7.800042E-03>,
      <-3.662E-01, 7.800042E-03>,
      <-3.662E-01, 2.636737E-02>,
      <-3.662E-01, 2.61603E-02>,
      <-3.5518E-01, 4.000002E-02>,
      <-3.32E-01, 2.61603E-02>,
      <-3.32E-01, 2.636737E-02>,
      <-3.4302E-01, 4.000002E-02>,
      <-3.662E-01, 1.698017E-02>,
      <-2.196466E-01, 8.262624E-03>,
      <-1.905533E-01, 8.262624E-03>,
      <-2.196465E-01, 1.66088E-02>,
      <-2.196465E-01, 2.495497E-02>,
      <-2.106276E-01, 3.753743E-02>,
      <-1.995721E-01, 3.753743E-02>,
      <-1.905532E-01, 2.495497E-02>,
      <-3.32E-01, 1.698017E-02>,
      <-1.905532E-01, 1.66088E-02>,
      <-3.662E-01, 1.70837E-02>,
      <-3.32E-01, 1.70837E-02>,
      <-8.377E-01, 5.168E-01>,
      <-9.824304E-01, 5.168E-01>,
      <-8.377E-01, 5.954258E-01>,
      <-8.377E-01, 5.961931E-01>,
      <-8.843354E-01, 6.467E-01>,
      <-9.357949E-01, 6.467E-01>,
      <-9.824304E-01, 5.961931E-01>,
      <-9.824304E-01, 5.954258E-01>,
      <-9.825E-01, 5.61415E-01>,
      <-8.377E-01, 5.61415E-01>,
      <-8.377E-01, 5.617986E-01>,
      <-9.824304E-01, 5.617986E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      22, 
      <1, 2, 3>, 0,
      <1, 3, 0>, 0,
      <7, 5, 4>, 0,
      <7, 4, 6>, 0,
      <6, 10, 11>, 0,
      <6, 11, 7>, 0,
      <11, 10, 9>, 0,
      <11, 9, 8>, 0,
      <13, 2, 1>, 0,
      <13, 1, 12>, 0,
      <14, 4, 5>, 0,
      <14, 5, 12>, 0,
      <12, 1, 0>, 0,
      <12, 0, 14>, 0,
      <8, 9, 15>, 0,
      <8, 15, 13>, 0,
      <13, 15, 3>, 0,
      <13, 3, 2>, 0,
      <5, 7, 11>, 0,
      <5, 11, 8>, 0,
      <8, 13, 12>, 0,
      <8, 12, 5>, 0
   }
 
   normal_indices { 
      22, 
      <0, 0, 0>,
      <0, 0, 0>,
      <2, 1, 1>,
      <2, 1, 2>,
      <2, 3, 3>,
      <2, 3, 2>,
      <3, 3, 4>,
      <3, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <4, 4, 8>,
      <4, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 10, 10>,
      <9, 10, 9>,
      <9, 5, 5>,
      <9, 5, 9>
   }
 
   uv_indices { 
      22, 
      <20, 21, 21>,
      <20, 21, 20>,
      <24, 22, 23>,
      <24, 23, 24>,
      <24, 25, 25>,
      <24, 25, 24>,
      <25, 25, 26>,
      <25, 26, 27>,
      <28, 21, 20>,
      <28, 20, 29>,
      <30, 23, 22>,
      <30, 22, 29>,
      <29, 20, 20>,
      <29, 20, 30>,
      <27, 26, 31>,
      <27, 31, 28>,
      <28, 31, 21>,
      <28, 21, 21>,
      <22, 24, 25>,
      <22, 25, 27>,
      <27, 28, 29>,
      <27, 29, 22>
   }
   uv_mapping
}
 
// AxleCap3
mesh2 {
 
   vertex_vectors { 
      16, 
      <4.753747E+00, 2.243096E+00, -1.560338E+01>,
      <5.194762E+00, 2.243096E+00, -1.560338E+01>,
      <5.194761E+00, 2.243096E+00, -1.454588E+01>,
      <4.753746E+00, 2.243096E+00, -1.454588E+01>,
      <4.753747E+00, 2.946877E+00, -1.560338E+01>,
      <4.98663E+00, 2.940076E+00, -1.560338E+01>,
      <4.753747E+00, 3.394596E+00, -1.526263E+01>,
      <4.833815E+00, 3.394596E+00, -1.526263E+01>,
      <4.986629E+00, 2.940076E+00, -1.454588E+01>,
      <4.753746E+00, 2.946877E+00, -1.454588E+01>,
      <4.753746E+00, 3.394596E+00, -1.488663E+01>,
      <4.833813E+00, 3.394596E+00, -1.488663E+01>,
      <5.194762E+00, 2.638586E+00, -1.560338E+01>,
      <5.194761E+00, 2.638586E+00, -1.454537E+01>,
      <4.753747E+00, 2.641987E+00, -1.560338E+01>,
      <4.753746E+00, 2.641987E+00, -1.454588E+01>
   }
 
   normal_vectors { 
      11, 
      <4.280104E-16, -1.00E+00, -4.31381E-16>,
      <5.894302E-03, 3.186716E-01, -9.478469E-01>,
      <6.238162E-03, 8.955734E-01, -4.448699E-01>,
      <6.237909E-03, 8.955734E-01, 4.448701E-01>,
      <5.558379E-03, 3.189483E-01, 9.477558E-01>,
      <9.425034E-01, 3.341965E-01, 3.071066E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <8.633783E-01, 5.045571E-01, 9.944126E-07>,
      <9.300554E-01, 3.674192E-01, 1.712646E-06>
   }
 
   uv_vectors { 
      32, 
      <-3.32E-01, 7.800042E-03>,
      <-3.662E-01, 7.800042E-03>,
      <-3.662E-01, 2.636737E-02>,
      <-3.662E-01, 2.61603E-02>,
      <-3.5518E-01, 4.000002E-02>,
      <-3.32E-01, 2.61603E-02>,
      <-3.32E-01, 2.636737E-02>,
      <-3.4302E-01, 4.000002E-02>,
      <-3.662E-01, 1.698017E-02>,
      <-2.196466E-01, 8.262624E-03>,
      <-1.905533E-01, 8.262624E-03>,
      <-2.196465E-01, 1.66088E-02>,
      <-2.196465E-01, 2.495497E-02>,
      <-2.106276E-01, 3.753743E-02>,
      <-1.995721E-01, 3.753743E-02>,
      <-1.905532E-01, 2.495497E-02>,
      <-3.32E-01, 1.698017E-02>,
      <-1.905532E-01, 1.66088E-02>,
      <-3.662E-01, 1.70837E-02>,
      <-3.32E-01, 1.70837E-02>,
      <-8.377E-01, 5.168E-01>,
      <-9.824304E-01, 5.168E-01>,
      <-8.377E-01, 5.954258E-01>,
      <-8.377E-01, 5.961931E-01>,
      <-8.843354E-01, 6.467E-01>,
      <-9.357949E-01, 6.467E-01>,
      <-9.824304E-01, 5.961931E-01>,
      <-9.824304E-01, 5.954258E-01>,
      <-9.825E-01, 5.61415E-01>,
      <-8.377E-01, 5.61415E-01>,
      <-8.377E-01, 5.617986E-01>,
      <-9.824304E-01, 5.617986E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      22, 
      <1, 2, 3>, 0,
      <1, 3, 0>, 0,
      <7, 5, 4>, 0,
      <7, 4, 6>, 0,
      <6, 10, 11>, 0,
      <6, 11, 7>, 0,
      <11, 10, 9>, 0,
      <11, 9, 8>, 0,
      <13, 2, 1>, 0,
      <13, 1, 12>, 0,
      <14, 4, 5>, 0,
      <14, 5, 12>, 0,
      <12, 1, 0>, 0,
      <12, 0, 14>, 0,
      <8, 9, 15>, 0,
      <8, 15, 13>, 0,
      <13, 15, 3>, 0,
      <13, 3, 2>, 0,
      <5, 7, 11>, 0,
      <5, 11, 8>, 0,
      <8, 13, 12>, 0,
      <8, 12, 5>, 0
   }
 
   normal_indices { 
      22, 
      <0, 0, 0>,
      <0, 0, 0>,
      <2, 1, 1>,
      <2, 1, 2>,
      <2, 3, 3>,
      <2, 3, 2>,
      <3, 3, 4>,
      <3, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <4, 4, 8>,
      <4, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 10, 10>,
      <9, 10, 9>,
      <9, 5, 5>,
      <9, 5, 9>
   }
 
   uv_indices { 
      22, 
      <20, 21, 21>,
      <20, 21, 20>,
      <24, 22, 23>,
      <24, 23, 24>,
      <24, 25, 25>,
      <24, 25, 24>,
      <25, 25, 26>,
      <25, 26, 27>,
      <28, 21, 20>,
      <28, 20, 29>,
      <30, 23, 22>,
      <30, 22, 29>,
      <29, 20, 20>,
      <29, 20, 30>,
      <27, 26, 31>,
      <27, 31, 28>,
      <28, 31, 21>,
      <28, 21, 21>,
      <22, 24, 25>,
      <22, 25, 27>,
      <27, 28, 29>,
      <27, 29, 22>
   }
   uv_mapping
}
 
// Brakes
mesh2 {
 
   vertex_vectors { 
      208, 
      <3.780668E+00, 2.329011E+00, -1.838018E+01>,
      <3.778587E+00, 3.011019E+00, -1.838478E+01>,
      <3.978588E+00, 3.011019E+00, -1.838478E+01>,
      <3.980669E+00, 2.329011E+00, -1.838018E+01>,
      <3.978589E+00, 2.87606E+00, -1.819396E+01>,
      <3.778589E+00, 2.87606E+00, -1.819396E+01>,
      <3.980668E+00, 2.446511E+00, -1.818936E+01>,
      <3.780668E+00, 2.446511E+00, -1.818936E+01>,
      <3.980669E+00, 2.329011E+00, -1.826268E+01>,
      <3.780668E+00, 2.329011E+00, -1.826268E+01>,
      <3.778587E+00, 3.598519E+00, -1.785185E+01>,
      <3.778589E+00, 3.598519E+00, -1.756561E+01>,
      <3.978589E+00, 3.598519E+00, -1.756561E+01>,
      <3.978587E+00, 3.598519E+00, -1.785185E+01>,
      <3.978589E+00, 2.329011E+00, -1.674405E+01>,
      <3.98067E+00, 3.011019E+00, -1.673945E+01>,
      <3.780669E+00, 3.011019E+00, -1.673945E+01>,
      <3.778588E+00, 2.329011E+00, -1.674405E+01>,
      <3.780667E+00, 2.87606E+00, -1.693028E+01>,
      <3.980668E+00, 2.87606E+00, -1.693028E+01>,
      <3.778588E+00, 2.446511E+00, -1.693488E+01>,
      <3.978589E+00, 2.446511E+00, -1.693488E+01>,
      <3.778588E+00, 2.329011E+00, -1.686156E+01>,
      <3.978589E+00, 2.329011E+00, -1.686156E+01>,
      <3.98067E+00, 3.598519E+00, -1.727239E+01>,
      <3.980668E+00, 3.598519E+00, -1.755863E+01>,
      <3.780668E+00, 3.598519E+00, -1.755863E+01>,
      <3.780669E+00, 3.598519E+00, -1.727239E+01>,
      <4.029627E+00, 2.122621E+00, -1.627165E+01>,
      <4.029627E+00, 3.062621E+00, -1.627165E+01>,
      <3.729628E+00, 3.062621E+00, -1.627165E+01>,
      <3.729628E+00, 2.122621E+00, -1.627165E+01>,
      <3.729629E+00, 2.945121E+00, -1.674165E+01>,
      <4.029628E+00, 2.945121E+00, -1.674165E+01>,
      <4.029628E+00, 3.062621E+00, -1.662415E+01>,
      <3.729628E+00, 3.062621E+00, -1.662415E+01>,
      <3.729628E+00, 2.122621E+00, -1.662415E+01>,
      <4.029628E+00, 2.122621E+00, -1.662415E+01>,
      <3.729629E+00, 2.240121E+00, -1.674165E+01>,
      <4.029628E+00, 2.240121E+00, -1.674165E+01>,
      <3.729629E+00, 2.122621E+00, -1.885259E+01>,
      <3.729629E+00, 3.062621E+00, -1.885259E+01>,
      <4.029628E+00, 3.062621E+00, -1.885259E+01>,
      <4.029628E+00, 2.122621E+00, -1.885259E+01>,
      <4.029628E+00, 2.945121E+00, -1.838259E+01>,
      <3.729629E+00, 2.945121E+00, -1.838259E+01>,
      <3.729629E+00, 3.062621E+00, -1.850009E+01>,
      <4.029628E+00, 3.062621E+00, -1.850009E+01>,
      <4.029628E+00, 2.122621E+00, -1.850009E+01>,
      <3.729629E+00, 2.122621E+00, -1.850009E+01>,
      <4.029628E+00, 2.240121E+00, -1.838259E+01>,
      <3.729629E+00, 2.240121E+00, -1.838259E+01>,
      <4.029629E+00, 2.122621E+00, -2.119122E+01>,
      <4.029629E+00, 3.062621E+00, -2.119122E+01>,
      <3.72963E+00, 3.062621E+00, -2.119122E+01>,
      <3.72963E+00, 2.122621E+00, -2.119122E+01>,
      <3.72963E+00, 2.945121E+00, -2.166121E+01>,
      <4.029629E+00, 2.945121E+00, -2.166121E+01>,
      <4.029629E+00, 3.062621E+00, -2.154372E+01>,
      <3.72963E+00, 3.062621E+00, -2.154372E+01>,
      <3.72963E+00, 2.122621E+00, -2.154372E+01>,
      <4.029629E+00, 2.122621E+00, -2.154372E+01>,
      <3.72963E+00, 2.240121E+00, -2.166121E+01>,
      <4.029629E+00, 2.240121E+00, -2.166121E+01>,
      <3.97859E+00, 2.329011E+00, -2.166362E+01>,
      <3.980671E+00, 3.011019E+00, -2.165902E+01>,
      <3.780671E+00, 3.011019E+00, -2.165902E+01>,
      <3.77859E+00, 2.329011E+00, -2.166362E+01>,
      <3.780669E+00, 2.87606E+00, -2.184985E+01>,
      <3.980669E+00, 2.87606E+00, -2.184985E+01>,
      <3.77859E+00, 2.446511E+00, -2.185444E+01>,
      <3.97859E+00, 2.446511E+00, -2.185444E+01>,
      <3.77859E+00, 2.329011E+00, -2.178112E+01>,
      <3.97859E+00, 2.329011E+00, -2.178112E+01>,
      <3.980672E+00, 3.598519E+00, -2.219195E+01>,
      <3.98067E+00, 3.598519E+00, -2.247819E+01>,
      <3.780669E+00, 3.598519E+00, -2.247819E+01>,
      <3.780671E+00, 3.598519E+00, -2.219195E+01>,
      <3.729631E+00, 2.122621E+00, -2.377215E+01>,
      <3.729631E+00, 3.062621E+00, -2.377215E+01>,
      <4.02963E+00, 3.062621E+00, -2.377215E+01>,
      <4.02963E+00, 2.122621E+00, -2.377215E+01>,
      <4.02963E+00, 2.945121E+00, -2.330215E+01>,
      <3.72963E+00, 2.945121E+00, -2.330215E+01>,
      <3.729631E+00, 3.062621E+00, -2.341965E+01>,
      <4.02963E+00, 3.062621E+00, -2.341965E+01>,
      <4.02963E+00, 2.122621E+00, -2.341965E+01>,
      <3.729631E+00, 2.122621E+00, -2.341965E+01>,
      <4.02963E+00, 2.240121E+00, -2.330215E+01>,
      <3.72963E+00, 2.240121E+00, -2.330215E+01>,
      <3.780669E+00, 2.329011E+00, -2.329975E+01>,
      <3.778588E+00, 3.011019E+00, -2.330434E+01>,
      <3.978589E+00, 3.011019E+00, -2.330434E+01>,
      <3.98067E+00, 2.329011E+00, -2.329975E+01>,
      <3.978591E+00, 2.87606E+00, -2.311352E+01>,
      <3.77859E+00, 2.87606E+00, -2.311352E+01>,
      <3.98067E+00, 2.446511E+00, -2.310892E+01>,
      <3.780669E+00, 2.446511E+00, -2.310892E+01>,
      <3.98067E+00, 2.329011E+00, -2.318225E+01>,
      <3.780669E+00, 2.329011E+00, -2.318224E+01>,
      <3.778588E+00, 3.598519E+00, -2.277141E+01>,
      <3.77859E+00, 3.598519E+00, -2.248518E+01>,
      <3.978591E+00, 3.598519E+00, -2.248518E+01>,
      <3.978589E+00, 3.598519E+00, -2.277141E+01>,
      <-1.321333E+00, 2.329011E+00, -1.838018E+01>,
      <-1.323414E+00, 3.011019E+00, -1.838478E+01>,
      <-1.123414E+00, 3.011019E+00, -1.838478E+01>,
      <-1.121333E+00, 2.329011E+00, -1.838018E+01>,
      <-1.123412E+00, 2.87606E+00, -1.819396E+01>,
      <-1.323413E+00, 2.87606E+00, -1.819396E+01>,
      <-1.121333E+00, 2.446511E+00, -1.818936E+01>,
      <-1.321334E+00, 2.446511E+00, -1.818936E+01>,
      <-1.121333E+00, 2.329011E+00, -1.826268E+01>,
      <-1.321334E+00, 2.329011E+00, -1.826268E+01>,
      <-1.323415E+00, 3.598519E+00, -1.785185E+01>,
      <-1.323413E+00, 3.598519E+00, -1.756561E+01>,
      <-1.123412E+00, 3.598519E+00, -1.756561E+01>,
      <-1.123414E+00, 3.598519E+00, -1.785185E+01>,
      <-1.123412E+00, 2.329011E+00, -1.674405E+01>,
      <-1.121331E+00, 3.011019E+00, -1.673945E+01>,
      <-1.321332E+00, 3.011019E+00, -1.673945E+01>,
      <-1.323413E+00, 2.329011E+00, -1.674405E+01>,
      <-1.321334E+00, 2.87606E+00, -1.693028E+01>,
      <-1.121333E+00, 2.87606E+00, -1.693028E+01>,
      <-1.323413E+00, 2.446511E+00, -1.693488E+01>,
      <-1.123412E+00, 2.446511E+00, -1.693488E+01>,
      <-1.323413E+00, 2.329011E+00, -1.686156E+01>,
      <-1.123412E+00, 2.329011E+00, -1.686156E+01>,
      <-1.121331E+00, 3.598519E+00, -1.727239E+01>,
      <-1.121333E+00, 3.598519E+00, -1.755863E+01>,
      <-1.321334E+00, 3.598519E+00, -1.755863E+01>,
      <-1.321332E+00, 3.598519E+00, -1.727239E+01>,
      <-1.072374E+00, 2.122621E+00, -1.627165E+01>,
      <-1.072374E+00, 3.062621E+00, -1.627165E+01>,
      <-1.372373E+00, 3.062621E+00, -1.627165E+01>,
      <-1.372373E+00, 2.122621E+00, -1.627165E+01>,
      <-1.372373E+00, 2.945121E+00, -1.674165E+01>,
      <-1.072374E+00, 2.945121E+00, -1.674165E+01>,
      <-1.072374E+00, 3.062621E+00, -1.662415E+01>,
      <-1.372373E+00, 3.062621E+00, -1.662415E+01>,
      <-1.372373E+00, 2.122621E+00, -1.662415E+01>,
      <-1.072374E+00, 2.122621E+00, -1.662415E+01>,
      <-1.372373E+00, 2.240121E+00, -1.674165E+01>,
      <-1.072374E+00, 2.240121E+00, -1.674165E+01>,
      <-1.372372E+00, 2.122621E+00, -1.885259E+01>,
      <-1.372372E+00, 3.062621E+00, -1.885259E+01>,
      <-1.072373E+00, 3.062621E+00, -1.885259E+01>,
      <-1.072373E+00, 2.122621E+00, -1.885259E+01>,
      <-1.072373E+00, 2.945121E+00, -1.838259E+01>,
      <-1.372372E+00, 2.945121E+00, -1.838259E+01>,
      <-1.372372E+00, 3.062621E+00, -1.850009E+01>,
      <-1.072373E+00, 3.062621E+00, -1.850009E+01>,
      <-1.072373E+00, 2.122621E+00, -1.850009E+01>,
      <-1.372372E+00, 2.122621E+00, -1.850009E+01>,
      <-1.072373E+00, 2.240121E+00, -1.838259E+01>,
      <-1.372372E+00, 2.240121E+00, -1.838259E+01>,
      <-1.072372E+00, 2.122621E+00, -2.119122E+01>,
      <-1.072372E+00, 3.062621E+00, -2.119122E+01>,
      <-1.372371E+00, 3.062621E+00, -2.119122E+01>,
      <-1.372371E+00, 2.122621E+00, -2.119122E+01>,
      <-1.372371E+00, 2.945121E+00, -2.166121E+01>,
      <-1.072372E+00, 2.945121E+00, -2.166121E+01>,
      <-1.072372E+00, 3.062621E+00, -2.154372E+01>,
      <-1.372371E+00, 3.062621E+00, -2.154372E+01>,
      <-1.372371E+00, 2.122621E+00, -2.154372E+01>,
      <-1.072372E+00, 2.122621E+00, -2.154372E+01>,
      <-1.372371E+00, 2.240121E+00, -2.166121E+01>,
      <-1.072372E+00, 2.240121E+00, -2.166121E+01>,
      <-1.123411E+00, 2.329011E+00, -2.166362E+01>,
      <-1.12133E+00, 3.011019E+00, -2.165902E+01>,
      <-1.321331E+00, 3.011019E+00, -2.165902E+01>,
      <-1.323411E+00, 2.329011E+00, -2.166362E+01>,
      <-1.321332E+00, 2.87606E+00, -2.184985E+01>,
      <-1.121332E+00, 2.87606E+00, -2.184985E+01>,
      <-1.323411E+00, 2.446511E+00, -2.185444E+01>,
      <-1.123411E+00, 2.446511E+00, -2.185444E+01>,
      <-1.323411E+00, 2.329011E+00, -2.178112E+01>,
      <-1.123411E+00, 2.329011E+00, -2.178112E+01>,
      <-1.12133E+00, 3.598519E+00, -2.219195E+01>,
      <-1.121331E+00, 3.598519E+00, -2.247819E+01>,
      <-1.321332E+00, 3.598519E+00, -2.247819E+01>,
      <-1.32133E+00, 3.598519E+00, -2.219195E+01>,
      <-1.37237E+00, 2.122621E+00, -2.377215E+01>,
      <-1.37237E+00, 3.062621E+00, -2.377215E+01>,
      <-1.072371E+00, 3.062621E+00, -2.377215E+01>,
      <-1.072371E+00, 2.122621E+00, -2.377215E+01>,
      <-1.072371E+00, 2.945121E+00, -2.330215E+01>,
      <-1.372371E+00, 2.945121E+00, -2.330215E+01>,
      <-1.372371E+00, 3.062621E+00, -2.341965E+01>,
      <-1.072371E+00, 3.062621E+00, -2.341965E+01>,
      <-1.072371E+00, 2.122621E+00, -2.341965E+01>,
      <-1.372371E+00, 2.122621E+00, -2.341965E+01>,
      <-1.072371E+00, 2.240121E+00, -2.330215E+01>,
      <-1.372371E+00, 2.240121E+00, -2.330215E+01>,
      <-1.321332E+00, 2.329011E+00, -2.329975E+01>,
      <-1.323413E+00, 3.011019E+00, -2.330434E+01>,
      <-1.123412E+00, 3.011019E+00, -2.330434E+01>,
      <-1.121331E+00, 2.329011E+00, -2.329975E+01>,
      <-1.12341E+00, 2.87606E+00, -2.311352E+01>,
      <-1.323411E+00, 2.87606E+00, -2.311352E+01>,
      <-1.121331E+00, 2.446511E+00, -2.310892E+01>,
      <-1.321332E+00, 2.446511E+00, -2.310892E+01>,
      <-1.121331E+00, 2.329011E+00, -2.318225E+01>,
      <-1.321332E+00, 2.329011E+00, -2.318224E+01>,
      <-1.323413E+00, 3.598519E+00, -2.277141E+01>,
      <-1.323411E+00, 3.598519E+00, -2.248518E+01>,
      <-1.12341E+00, 3.598519E+00, -2.248518E+01>,
      <-1.123412E+00, 3.598519E+00, -2.277141E+01>
   }
 
   normal_vectors { 
      26, 
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <3.043768E-07, 3.569444E-01, -9.341256E-01>,
      <3.684282E-06, -2.701963E-01, 9.628053E-01>,
      <-3.057987E-07, -3.453078E-01, 9.384894E-01>,
      <4.280104E-16, -1.00E+00, -4.31381E-16>,
      <4.230317E-06, -8.744729E-01, 4.850746E-01>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.319806E-07, 9.142964E-01, -4.050456E-01>,
      <-4.280104E-16, 9.999999E-01, 4.31381E-16>,
      <-2.458613E-07, -6.562509E-01, 7.545428E-01>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <-3.043767E-07, 3.569452E-01, 9.341253E-01>,
      <3.137212E-07, -2.70203E-01, -9.628034E-01>,
      <3.057987E-07, -3.453079E-01, -9.384894E-01>,
      <1.580554E-07, -8.744762E-01, -4.850685E-01>,
      <-1.319809E-07, 9.142961E-01, 4.050463E-01>,
      <2.458612E-07, -6.562511E-01, -7.545427E-01>,
      <1.246938E-07, 9.238798E-01, -3.826826E-01>,
      <3.010381E-07, 3.826842E-01, -9.238791E-01>,
      <1.246939E-07, -9.238799E-01, -3.826828E-01>,
      <3.010381E-07, -3.826841E-01, -9.238793E-01>,
      <-1.246924E-07, 9.238816E-01, 3.826783E-01>,
      <-3.010375E-07, 3.826886E-01, 9.238774E-01>,
      <-1.246925E-07, -9.238816E-01, 3.826786E-01>,
      <-3.010375E-07, -3.826883E-01, 9.238775E-01>
   }
 
   uv_vectors { 
      293, 
      <-2.870832E-01, 2.00517E-01>,
      <-2.866292E-01, 2.402044E-01>,
      <-3.022715E-01, 2.323509E-01>,
      <-3.027897E-01, 2.073545E-01>,
      <-2.966274E-01, 2.00517E-01>,
      <-2.568087E-01, 1.885E-01>,
      <-2.569676E-01, 2.432E-01>,
      <-2.826042E-01, 2.432E-01>,
      <-2.917815E-01, 2.363624E-01>,
      <-2.916605E-01, 1.953375E-01>,
      <-2.824453E-01, 1.885E-01>,
      <-2.897405E-01, 1.953298E-01>,
      <-2.897405E-01, 2.36342E-01>,
      <-2.540077E-01, 1.88517E-01>,
      <-2.540244E-01, 2.432E-01>,
      <-2.811793E-01, 2.431831E-01>,
      <-2.811772E-01, 1.885E-01>,
      <-2.920796E-01, 2.005062E-01>,
      <-2.918376E-01, 2.401814E-01>,
      <-3.05342E-01, 2.323212E-01>,
      <-3.055632E-01, 2.073324E-01>,
      <-3.004656E-01, 2.005006E-01>,
      <-2.826931E-01, 1.885E-01>,
      <-2.918977E-01, 1.953375E-01>,
      <-2.568102E-01, 2.432E-01>,
      <-2.569697E-01, 1.885E-01>,
      <-3.025332E-01, 2.323369E-01>,
      <-2.867925E-01, 2.401903E-01>,
      <-2.98243E-01, 2.005029E-01>,
      <-2.904445E-01, 2.401903E-01>,
      <-2.907769E-01, 2.005029E-01>,
      <-2.809801E-01, 1.885E-01>,
      <-2.886077E-01, 1.953375E-01>,
      <-2.88656E-01, 2.363625E-01>,
      <-2.810414E-01, 2.432E-01>,
      <-2.83767E-01, 2.432E-01>,
      <-2.921331E-01, 2.363625E-01>,
      <-2.920739E-01, 1.953375E-01>,
      <-2.836906E-01, 1.885E-01>,
      <-2.899423E-01, 2.00517E-01>,
      <-2.895832E-01, 2.402044E-01>,
      <-2.979359E-01, 2.00517E-01>,
      <-2.898375E-01, 2.00517E-01>,
      <-2.977242E-01, 2.00517E-01>,
      <-2.77679E-01, 2.432E-01>,
      <-2.852388E-01, 2.363625E-01>,
      <-2.853488E-01, 1.953375E-01>,
      <-2.778236E-01, 1.885E-01>,
      <-2.838095E-01, 1.885E-01>,
      <-2.921899E-01, 1.953375E-01>,
      <-2.776135E-01, 1.885E-01>,
      <-2.851501E-01, 1.953375E-01>,
      <-2.894589E-01, 2.401903E-01>,
      <-3.033977E-01, 1.914E-01>,
      <-3.033048E-01, 2.158E-01>,
      <-2.933024E-01, 2.158E-01>,
      <-2.934205E-01, 1.914E-01>,
      <-2.935308E-01, 1.914E-01>,
      <-3.031693E-01, 1.914E-01>,
      <-3.031693E-01, 2.158E-01>,
      <-2.935308E-01, 2.158E-01>,
      <-2.933036E-01, 1.914E-01>,
      <-3.032923E-01, 1.914E-01>,
      <-2.934076E-01, 2.158E-01>,
      <-2.710937E-01, 2.119E-01>,
      <-2.710937E-01, 2.344E-01>,
      <-2.602062E-01, 2.344E-01>,
      <-2.602062E-01, 2.119E-01>,
      <-2.696328E-01, 2.119E-01>,
      <-2.696328E-01, 2.344E-01>,
      <-2.616671E-01, 2.344E-01>,
      <-2.616671E-01, 2.119E-01>,
      <-2.604513E-01, 2.119E-01>,
      <-2.708487E-01, 2.119E-01>,
      <-2.708487E-01, 2.344E-01>,
      <-2.604513E-01, 2.344E-01>,
      <-2.672777E-01, 1.943298E-01>,
      <-2.671208E-01, 2.35342E-01>,
      <-3.008191E-01, 2.353759E-01>,
      <-3.009888E-01, 1.943637E-01>,
      <-2.814578E-01, 1.875E-01>,
      <-2.889387E-01, 1.943375E-01>,
      <-2.889851E-01, 2.353625E-01>,
      <-2.815191E-01, 2.422E-01>,
      <-2.578042E-01, 2.422E-01>,
      <-2.577541E-01, 1.875E-01>,
      <-2.983882E-01, 1.995029E-01>,
      <-3.028474E-01, 2.063405E-01>,
      <-3.025168E-01, 2.313369E-01>,
      <-2.907402E-01, 2.391903E-01>,
      <-2.910652E-01, 1.995029E-01>,
      <-2.968236E-01, 1.995029E-01>,
      <-2.871597E-01, 2.391903E-01>,
      <-2.87433E-01, 1.995029E-01>,
      <-2.831362E-01, 1.875E-01>,
      <-2.921662E-01, 1.943375E-01>,
      <-2.920486E-01, 2.353624E-01>,
      <-2.829806E-01, 2.422E-01>,
      <-2.577541E-01, 2.422E-01>,
      <-2.579097E-01, 1.875E-01>,
      <-2.902485E-01, 1.99517E-01>,
      <-2.898951E-01, 2.392044E-01>,
      <-2.980875E-01, 1.99517E-01>,
      <-2.841897E-01, 2.422E-01>,
      <-2.923954E-01, 2.353625E-01>,
      <-2.923362E-01, 1.943375E-01>,
      <-2.841152E-01, 1.875E-01>,
      <-2.782199E-01, 2.422E-01>,
      <-2.856349E-01, 2.353625E-01>,
      <-2.857417E-01, 1.943375E-01>,
      <-2.783645E-01, 1.875E-01>,
      <-2.901455E-01, 1.99517E-01>,
      <-3.026463E-01, 2.313509E-01>,
      <-2.978779E-01, 1.99517E-01>,
      <-2.579076E-01, 2.422E-01>,
      <-2.919319E-01, 1.943375E-01>,
      <-2.828943E-01, 1.875E-01>,
      <-2.869989E-01, 2.392044E-01>,
      <-3.02339E-01, 2.31351E-01>,
      <-2.897745E-01, 2.391903E-01>,
      <-2.781572E-01, 1.875E-01>,
      <-2.855501E-01, 1.943375E-01>,
      <-2.842312E-01, 1.875E-01>,
      <-2.924508E-01, 1.943375E-01>,
      <-3.039145E-01, 1.807E-01>,
      <-2.704007E-01, 1.318E-01>,
      <-2.614856E-01, 1.409348E-01>,
      <-2.878132E-01, 1.807E-01>,
      <-2.751589E-01, 1.807E-01>,
      <-3.039145E-01, 1.409348E-01>,
      <-2.931169E-01, 1.318E-01>,
      <-2.614856E-01, 1.807E-01>,
      <-2.775854E-01, 1.807E-01>,
      <-2.949989E-01, 1.318E-01>,
      <-2.722836E-01, 1.318E-01>,
      <-2.902416E-01, 1.807E-01>,
      <-3.251603E-01, 1.777E-01>,
      <-3.251603E-01, 1.328E-01>,
      <-3.632395E-01, 1.328E-01>,
      <-3.632395E-01, 1.777E-01>,
      <-3.586777E-01, 1.777E-01>,
      <-3.586777E-01, 1.328E-01>,
      <-3.297222E-01, 1.328E-01>,
      <-3.297222E-01, 1.777E-01>,
      <-3.297222E-01, 1.549796E-01>,
      <-3.584057E-01, 1.549796E-01>,
      <-3.584057E-01, 1.328E-01>,
      <-3.632962E-01, 1.328E-01>,
      <-2.944577E-01, 1.914E-01>,
      <-2.944577E-01, 2.119E-01>,
      <-3.012422E-01, 2.119E-01>,
      <-3.012422E-01, 1.914E-01>,
      <-2.744908E-01, 2.158E-01>,
      <-2.744908E-01, 2.354E-01>,
      <-2.597093E-01, 2.354E-01>,
      <-2.597093E-01, 2.158E-01>,
      <-2.725074E-01, 2.354E-01>,
      <-2.725074E-01, 2.158E-01>,
      <-2.616927E-01, 2.158E-01>,
      <-2.616927E-01, 2.354E-01>,
      <-2.854056E-01, 1.797E-01>,
      <-2.586418E-01, 1.368448E-01>,
      <-2.67663E-01, 1.27E-01>,
      <-3.019583E-01, 1.797E-01>,
      <-2.586418E-01, 1.797E-01>,
      <-2.908235E-01, 1.27E-01>,
      <-3.019583E-01, 1.368448E-01>,
      <-2.724729E-01, 1.797E-01>,
      <-2.929372E-01, 1.27E-01>,
      <-2.751923E-01, 1.797E-01>,
      <-2.881289E-01, 1.797E-01>,
      <-2.697774E-01, 1.27E-01>,
      <-3.073763E-01, 1.797E-01>,
      <-2.683928E-01, 1.299E-01>,
      <-2.580239E-01, 1.392028E-01>,
      <-2.886475E-01, 1.797E-01>,
      <-2.739303E-01, 1.797E-01>,
      <-3.073763E-01, 1.392028E-01>,
      <-2.948157E-01, 1.299E-01>,
      <-2.580239E-01, 1.797E-01>,
      <-2.705862E-01, 1.299E-01>,
      <-2.914728E-01, 1.797E-01>,
      <-2.767513E-01, 1.797E-01>,
      <-2.97007E-01, 1.299E-01>,
      <-2.94078E-01, 1.934E-01>,
      <-2.93995E-01, 2.148E-01>,
      <-3.016295E-01, 2.148E-01>,
      <-3.017049E-01, 1.934E-01>,
      <-1.831359E-01, 8.28275E-01>,
      <-2.059E-01, 8.557749E-01>,
      <-2.044722E-01, 9.56309E-01>,
      <-1.452293E-01, 9.878951E-01>,
      <-1.466572E-01, 8.28275E-01>,
      <-1.094349E-01, 7.80E-01>,
      <-1.459129E-01, 8.075E-01>,
      <-1.459129E-01, 9.725E-01>,
      <-1.094349E-01, 9.999999E-01>,
      <-5.680246E-08, 9.999999E-01>,
      <-5.680246E-08, 7.80E-01>,
      <6.951416E-09, 9.999999E-01>,
      <-1.491213E-01, 8.282881E-01>,
      <-1.481163E-01, 9.878594E-01>,
      <-2.04895E-01, 9.562462E-01>,
      <-1.840821E-01, 8.282653E-01>,
      <-1.398458E-01, 8.074688E-01>,
      <-1.398458E-01, 9.724176E-01>,
      <-1.922984E-01, 9.725538E-01>,
      <-1.922984E-01, 8.07605E-01>,
      <-1.048841E-01, 9.999318E-01>,
      <-1.048841E-01, 7.80E-01>,
      <-1.398458E-01, 9.724177E-01>,
      <-1.922975E-01, 8.07605E-01>,
      <-1.481163E-01, 9.878594E-01>,
      <-2.04895E-01, 9.562462E-01>,
      <-1.840821E-01, 8.282653E-01>,
      <-1.522E-01, 7.865E-01>,
      <-1.522E-01, 8.602E-01>,
      <-1.947E-01, 8.602E-01>,
      <-1.947E-01, 7.865E-01>,
      <-1.522E-01, 8.602E-01>,
      <-1.947E-01, 8.602E-01>,
      <-9.80E-01, 2.359E-01>,
      <-9.80E-01, 1.859999E-02>,
      <-8.489E-01, 1.859999E-02>,
      <-8.489E-01, 2.359E-01>,
      <-9.80E-01, 1.859998E-02>,
      <-9.799988E-01, 1.859999E-02>,
      <-9.80E-01, 1.859998E-02>,
      <-9.80E-01, 1.859999E-02>,
      <-9.80E-01, 1.859999E-02>,
      <-9.875E-01, 4.806E-01>,
      <-8.65846E-01, 2.609E-01>,
      <-8.289E-01, 3.019411E-01>,
      <-9.320811E-01, 4.806E-01>,
      <-8.843188E-01, 4.806E-01>,
      <-9.875E-01, 3.019411E-01>,
      <-9.50554E-01, 2.609E-01>,
      <-8.289E-01, 4.806E-01>,
      <-8.289E-01, 3.019411E-01>,
      <-9.50554E-01, 2.609E-01>,
      <-9.50554E-01, 2.609E-01>,
      <-1.859999E-02, 8.801E-01>,
      <-1.859999E-02, 9.788E-01>,
      <-9.48E-02, 9.788E-01>,
      <-9.48E-02, 8.801E-01>,
      <-1.859999E-02, 9.788E-01>,
      <-9.48E-02, 8.801E-01>,
      <-1.859999E-02, 9.788E-01>,
      <-9.48E-02, 8.801E-01>,
      <-1.859999E-02, 9.788E-01>,
      <-9.48E-02, 8.801E-01>,
      <-1.859999E-02, 9.788E-01>,
      <-9.48E-02, 8.801E-01>,
      <-1.859999E-02, 9.788E-01>,
      <-9.48E-02, 8.801E-01>,
      <-9.48E-02, 8.801E-01>,
      <-1.859999E-02, 9.788E-01>,
      <-9.48E-02, 8.801E-01>,
      <-1.859999E-02, 9.788E-01>,
      <-1.547E-01, 8.714E-01>,
      <-1.947001E-01, 8.714E-01>,
      <-1.947001E-01, 8.412189E-01>,
      <-1.547E-01, 8.412189E-01>,
      <-1.881713E-01, 8.314894E-01>,
      <-1.881713E-01, 8.136888E-01>,
      <-1.615046E-01, 8.136883E-01>,
      <-1.615046E-01, 8.314894E-01>,
      <-1.881713E-01, 7.902E-01>,
      <-1.615046E-01, 7.902E-01>,
      <-1.547E-01, 7.902E-01>,
      <-1.551111E-01, 8.714E-01>,
      <-1.94289E-01, 7.902E-01>,
      <-1.947001E-01, 7.902E-01>,
      <-1.763408E-01, 7.902E-01>,
      <-1.763408E-01, 8.714E-01>,
      <-1.547E-01, 8.056884E-01>,
      <-1.947001E-01, 8.056884E-01>,
      <-1.947001E-01, 7.902E-01>,
      <-1.547E-01, 8.274691E-01>,
      <-1.947001E-01, 8.274696E-01>,
      <-1.551111E-01, 8.714E-01>,
      <-1.547E-01, 8.099973E-01>,
      <-1.94289E-01, 8.099974E-01>,
      <-1.947001E-01, 8.395845E-01>,
      <-1.551127E-01, 8.395845E-01>,
      <-1.947001E-01, 8.602017E-01>,
      <-1.551127E-01, 8.602014E-01>,
      <-1.947001E-01, 7.902E-01>,
      <-1.547E-01, 8.220153E-01>,
      <-1.551127E-01, 8.714E-01>,
      <-1.942874E-01, 8.220153E-01>,
      <-1.547E-01, 8.013983E-01>,
      <-1.942874E-01, 8.013985E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      352, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <6, 4, 5>, 0,
      <6, 5, 7>, 0,
      <3, 8, 9>, 0,
      <3, 9, 0>, 0,
      <6, 7, 9>, 0,
      <6, 9, 8>, 0,
      <8, 3, 2>, 0,
      <8, 2, 4>, 0,
      <4, 6, 8>, 0,
      <0, 9, 7>, 0,
      <0, 7, 5>, 0,
      <5, 1, 0>, 0,
      <10, 11, 12>, 0,
      <10, 12, 13>, 0,
      <10, 1, 5>, 0,
      <10, 5, 11>, 0,
      <11, 5, 4>, 0,
      <11, 4, 12>, 0,
      <12, 4, 2>, 0,
      <12, 2, 13>, 0,
      <13, 2, 1>, 0,
      <13, 1, 10>, 0,
      <14, 15, 16>, 0,
      <14, 16, 17>, 0,
      <20, 18, 19>, 0,
      <20, 19, 21>, 0,
      <17, 22, 23>, 0,
      <17, 23, 14>, 0,
      <20, 21, 23>, 0,
      <20, 23, 22>, 0,
      <22, 17, 16>, 0,
      <22, 16, 18>, 0,
      <18, 20, 22>, 0,
      <14, 23, 21>, 0,
      <14, 21, 19>, 0,
      <19, 15, 14>, 0,
      <24, 25, 26>, 0,
      <24, 26, 27>, 0,
      <24, 15, 19>, 0,
      <24, 19, 25>, 0,
      <25, 19, 18>, 0,
      <25, 18, 26>, 0,
      <26, 18, 16>, 0,
      <26, 16, 27>, 0,
      <27, 16, 15>, 0,
      <27, 15, 24>, 0,
      <28, 29, 30>, 0,
      <28, 30, 31>, 0,
      <29, 34, 35>, 0,
      <29, 35, 30>, 0,
      <33, 32, 35>, 0,
      <33, 35, 34>, 0,
      <31, 36, 37>, 0,
      <31, 37, 28>, 0,
      <38, 32, 33>, 0,
      <38, 33, 39>, 0,
      <37, 36, 38>, 0,
      <37, 38, 39>, 0,
      <31, 30, 35>, 0,
      <31, 35, 32>, 0,
      <31, 32, 38>, 0,
      <31, 38, 36>, 0,
      <37, 39, 33>, 0,
      <37, 33, 34>, 0,
      <37, 34, 29>, 0,
      <37, 29, 28>, 0,
      <40, 41, 42>, 0,
      <40, 42, 43>, 0,
      <41, 46, 47>, 0,
      <41, 47, 42>, 0,
      <45, 44, 47>, 0,
      <45, 47, 46>, 0,
      <43, 48, 49>, 0,
      <43, 49, 40>, 0,
      <50, 44, 45>, 0,
      <50, 45, 51>, 0,
      <49, 48, 50>, 0,
      <49, 50, 51>, 0,
      <43, 42, 47>, 0,
      <43, 47, 44>, 0,
      <43, 44, 50>, 0,
      <43, 50, 48>, 0,
      <49, 51, 45>, 0,
      <49, 45, 46>, 0,
      <49, 46, 41>, 0,
      <49, 41, 40>, 0,
      <52, 53, 54>, 0,
      <52, 54, 55>, 0,
      <53, 58, 59>, 0,
      <53, 59, 54>, 0,
      <57, 56, 59>, 0,
      <57, 59, 58>, 0,
      <55, 60, 61>, 0,
      <55, 61, 52>, 0,
      <62, 56, 57>, 0,
      <62, 57, 63>, 0,
      <61, 60, 62>, 0,
      <61, 62, 63>, 0,
      <55, 54, 59>, 0,
      <55, 59, 56>, 0,
      <55, 56, 62>, 0,
      <55, 62, 60>, 0,
      <61, 63, 57>, 0,
      <61, 57, 58>, 0,
      <61, 58, 53>, 0,
      <61, 53, 52>, 0,
      <64, 65, 66>, 0,
      <64, 66, 67>, 0,
      <70, 68, 69>, 0,
      <70, 69, 71>, 0,
      <67, 72, 73>, 0,
      <67, 73, 64>, 0,
      <70, 71, 73>, 0,
      <70, 73, 72>, 0,
      <72, 67, 66>, 0,
      <72, 66, 68>, 0,
      <68, 70, 72>, 0,
      <64, 73, 71>, 0,
      <64, 71, 69>, 0,
      <69, 65, 64>, 0,
      <74, 75, 76>, 0,
      <74, 76, 77>, 0,
      <74, 65, 69>, 0,
      <74, 69, 75>, 0,
      <75, 69, 68>, 0,
      <75, 68, 76>, 0,
      <76, 68, 66>, 0,
      <76, 66, 77>, 0,
      <77, 66, 65>, 0,
      <77, 65, 74>, 0,
      <78, 79, 80>, 0,
      <78, 80, 81>, 0,
      <79, 84, 85>, 0,
      <79, 85, 80>, 0,
      <83, 82, 85>, 0,
      <83, 85, 84>, 0,
      <81, 86, 87>, 0,
      <81, 87, 78>, 0,
      <88, 82, 83>, 0,
      <88, 83, 89>, 0,
      <87, 86, 88>, 0,
      <87, 88, 89>, 0,
      <81, 80, 85>, 0,
      <81, 85, 82>, 0,
      <81, 82, 88>, 0,
      <81, 88, 86>, 0,
      <87, 89, 83>, 0,
      <87, 83, 84>, 0,
      <87, 84, 79>, 0,
      <87, 79, 78>, 0,
      <90, 91, 92>, 0,
      <90, 92, 93>, 0,
      <96, 94, 95>, 0,
      <96, 95, 97>, 0,
      <93, 98, 99>, 0,
      <93, 99, 90>, 0,
      <96, 97, 99>, 0,
      <96, 99, 98>, 0,
      <98, 93, 92>, 0,
      <98, 92, 94>, 0,
      <94, 96, 98>, 0,
      <90, 99, 97>, 0,
      <90, 97, 95>, 0,
      <95, 91, 90>, 0,
      <100, 101, 102>, 0,
      <100, 102, 103>, 0,
      <100, 91, 95>, 0,
      <100, 95, 101>, 0,
      <101, 95, 94>, 0,
      <101, 94, 102>, 0,
      <102, 94, 92>, 0,
      <102, 92, 103>, 0,
      <103, 92, 91>, 0,
      <103, 91, 100>, 0,
      <104, 105, 106>, 0,
      <104, 106, 107>, 0,
      <110, 108, 109>, 0,
      <110, 109, 111>, 0,
      <107, 112, 113>, 0,
      <107, 113, 104>, 0,
      <110, 111, 113>, 0,
      <110, 113, 112>, 0,
      <112, 107, 106>, 0,
      <112, 106, 108>, 0,
      <108, 110, 112>, 0,
      <104, 113, 111>, 0,
      <104, 111, 109>, 0,
      <109, 105, 104>, 0,
      <114, 115, 116>, 0,
      <114, 116, 117>, 0,
      <114, 105, 109>, 0,
      <114, 109, 115>, 0,
      <115, 109, 108>, 0,
      <115, 108, 116>, 0,
      <116, 108, 106>, 0,
      <116, 106, 117>, 0,
      <117, 106, 105>, 0,
      <117, 105, 114>, 0,
      <118, 119, 120>, 0,
      <118, 120, 121>, 0,
      <124, 122, 123>, 0,
      <124, 123, 125>, 0,
      <121, 126, 127>, 0,
      <121, 127, 118>, 0,
      <124, 125, 127>, 0,
      <124, 127, 126>, 0,
      <126, 121, 120>, 0,
      <126, 120, 122>, 0,
      <122, 124, 126>, 0,
      <118, 127, 125>, 0,
      <118, 125, 123>, 0,
      <123, 119, 118>, 0,
      <128, 129, 130>, 0,
      <128, 130, 131>, 0,
      <128, 119, 123>, 0,
      <128, 123, 129>, 0,
      <129, 123, 122>, 0,
      <129, 122, 130>, 0,
      <130, 122, 120>, 0,
      <130, 120, 131>, 0,
      <131, 120, 119>, 0,
      <131, 119, 128>, 0,
      <132, 133, 134>, 0,
      <132, 134, 135>, 0,
      <133, 138, 139>, 0,
      <133, 139, 134>, 0,
      <137, 136, 139>, 0,
      <137, 139, 138>, 0,
      <135, 140, 141>, 0,
      <135, 141, 132>, 0,
      <142, 136, 137>, 0,
      <142, 137, 143>, 0,
      <141, 140, 142>, 0,
      <141, 142, 143>, 0,
      <135, 134, 139>, 0,
      <135, 139, 136>, 0,
      <135, 136, 142>, 0,
      <135, 142, 140>, 0,
      <141, 143, 137>, 0,
      <141, 137, 138>, 0,
      <141, 138, 133>, 0,
      <141, 133, 132>, 0,
      <144, 145, 146>, 0,
      <144, 146, 147>, 0,
      <145, 150, 151>, 0,
      <145, 151, 146>, 0,
      <149, 148, 151>, 0,
      <149, 151, 150>, 0,
      <147, 152, 153>, 0,
      <147, 153, 144>, 0,
      <154, 148, 149>, 0,
      <154, 149, 155>, 0,
      <153, 152, 154>, 0,
      <153, 154, 155>, 0,
      <147, 146, 151>, 0,
      <147, 151, 148>, 0,
      <147, 148, 154>, 0,
      <147, 154, 152>, 0,
      <153, 155, 149>, 0,
      <153, 149, 150>, 0,
      <153, 150, 145>, 0,
      <153, 145, 144>, 0,
      <156, 157, 158>, 0,
      <156, 158, 159>, 0,
      <157, 162, 163>, 0,
      <157, 163, 158>, 0,
      <161, 160, 163>, 0,
      <161, 163, 162>, 0,
      <159, 164, 165>, 0,
      <159, 165, 156>, 0,
      <166, 160, 161>, 0,
      <166, 161, 167>, 0,
      <165, 164, 166>, 0,
      <165, 166, 167>, 0,
      <159, 158, 163>, 0,
      <159, 163, 160>, 0,
      <159, 160, 166>, 0,
      <159, 166, 164>, 0,
      <165, 167, 161>, 0,
      <165, 161, 162>, 0,
      <165, 162, 157>, 0,
      <165, 157, 156>, 0,
      <168, 169, 170>, 0,
      <168, 170, 171>, 0,
      <174, 172, 173>, 0,
      <174, 173, 175>, 0,
      <171, 176, 177>, 0,
      <171, 177, 168>, 0,
      <174, 175, 177>, 0,
      <174, 177, 176>, 0,
      <176, 171, 170>, 0,
      <176, 170, 172>, 0,
      <172, 174, 176>, 0,
      <168, 177, 175>, 0,
      <168, 175, 173>, 0,
      <173, 169, 168>, 0,
      <178, 179, 180>, 0,
      <178, 180, 181>, 0,
      <178, 169, 173>, 0,
      <178, 173, 179>, 0,
      <179, 173, 172>, 0,
      <179, 172, 180>, 0,
      <180, 172, 170>, 0,
      <180, 170, 181>, 0,
      <181, 170, 169>, 0,
      <181, 169, 178>, 0,
      <182, 183, 184>, 0,
      <182, 184, 185>, 0,
      <183, 188, 189>, 0,
      <183, 189, 184>, 0,
      <187, 186, 189>, 0,
      <187, 189, 188>, 0,
      <185, 190, 191>, 0,
      <185, 191, 182>, 0,
      <192, 186, 187>, 0,
      <192, 187, 193>, 0,
      <191, 190, 192>, 0,
      <191, 192, 193>, 0,
      <185, 184, 189>, 0,
      <185, 189, 186>, 0,
      <185, 186, 192>, 0,
      <185, 192, 190>, 0,
      <191, 193, 187>, 0,
      <191, 187, 188>, 0,
      <191, 188, 183>, 0,
      <191, 183, 182>, 0,
      <194, 195, 196>, 0,
      <194, 196, 197>, 0,
      <200, 198, 199>, 0,
      <200, 199, 201>, 0,
      <197, 202, 203>, 0,
      <197, 203, 194>, 0,
      <200, 201, 203>, 0,
      <200, 203, 202>, 0,
      <202, 197, 196>, 0,
      <202, 196, 198>, 0,
      <198, 200, 202>, 0,
      <194, 203, 201>, 0,
      <194, 201, 199>, 0,
      <199, 195, 194>, 0,
      <204, 205, 206>, 0,
      <204, 206, 207>, 0,
      <204, 195, 199>, 0,
      <204, 199, 205>, 0,
      <205, 199, 198>, 0,
      <205, 198, 206>, 0,
      <206, 198, 196>, 0,
      <206, 196, 207>, 0,
      <207, 196, 195>, 0,
      <207, 195, 204>, 0
   }
 
   normal_indices { 
      352, 
      <0, 1, 1>,
      <0, 1, 0>,
      <2, 3, 3>,
      <2, 3, 2>,
      <4, 5, 5>,
      <4, 5, 4>,
      <2, 2, 5>,
      <2, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <8, 9, 9>,
      <8, 9, 8>,
      <7, 7, 7>,
      <7, 7, 7>,
      <10, 3, 3>,
      <10, 3, 10>,
      <6, 6, 6>,
      <6, 6, 6>,
      <8, 1, 1>,
      <8, 1, 8>,
      <11, 12, 12>,
      <11, 12, 11>,
      <13, 14, 14>,
      <13, 14, 13>,
      <4, 15, 15>,
      <4, 15, 4>,
      <13, 13, 15>,
      <13, 15, 15>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <16, 9, 9>,
      <16, 9, 16>,
      <6, 6, 6>,
      <6, 6, 6>,
      <17, 14, 14>,
      <17, 14, 17>,
      <7, 7, 7>,
      <7, 7, 7>,
      <16, 12, 12>,
      <16, 12, 16>,
      <11, 11, 11>,
      <11, 11, 11>,
      <9, 18, 18>,
      <9, 18, 9>,
      <19, 19, 18>,
      <19, 18, 18>,
      <4, 20, 20>,
      <4, 20, 4>,
      <21, 19, 19>,
      <21, 19, 21>,
      <20, 20, 21>,
      <20, 21, 21>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <0, 0, 0>,
      <0, 0, 0>,
      <9, 22, 22>,
      <9, 22, 9>,
      <23, 23, 22>,
      <23, 22, 22>,
      <4, 24, 24>,
      <4, 24, 4>,
      <25, 23, 23>,
      <25, 23, 25>,
      <24, 24, 25>,
      <24, 25, 25>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <11, 11, 11>,
      <11, 11, 11>,
      <9, 18, 18>,
      <9, 18, 9>,
      <19, 19, 18>,
      <19, 18, 18>,
      <4, 20, 20>,
      <4, 20, 4>,
      <21, 19, 19>,
      <21, 19, 21>,
      <20, 20, 21>,
      <20, 21, 21>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <11, 12, 12>,
      <11, 12, 11>,
      <13, 14, 14>,
      <13, 14, 13>,
      <4, 15, 15>,
      <4, 15, 4>,
      <13, 13, 15>,
      <13, 15, 15>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <16, 9, 9>,
      <16, 9, 16>,
      <6, 6, 6>,
      <6, 6, 6>,
      <17, 14, 14>,
      <17, 14, 17>,
      <7, 7, 7>,
      <7, 7, 7>,
      <16, 12, 12>,
      <16, 12, 16>,
      <0, 0, 0>,
      <0, 0, 0>,
      <9, 22, 22>,
      <9, 22, 9>,
      <23, 23, 22>,
      <23, 22, 22>,
      <4, 24, 24>,
      <4, 24, 4>,
      <25, 23, 23>,
      <25, 23, 25>,
      <24, 24, 25>,
      <24, 25, 25>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <0, 1, 1>,
      <0, 1, 0>,
      <2, 3, 3>,
      <2, 3, 2>,
      <4, 5, 5>,
      <4, 5, 4>,
      <2, 2, 5>,
      <2, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <8, 9, 9>,
      <8, 9, 8>,
      <7, 7, 7>,
      <7, 7, 7>,
      <10, 3, 3>,
      <10, 3, 10>,
      <6, 6, 6>,
      <6, 6, 6>,
      <8, 1, 1>,
      <8, 1, 8>,
      <0, 1, 1>,
      <0, 1, 0>,
      <2, 3, 3>,
      <2, 3, 2>,
      <4, 5, 5>,
      <4, 5, 4>,
      <2, 2, 5>,
      <2, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <8, 9, 9>,
      <8, 9, 8>,
      <7, 7, 7>,
      <7, 7, 7>,
      <10, 3, 3>,
      <10, 3, 10>,
      <6, 6, 6>,
      <6, 6, 6>,
      <8, 1, 1>,
      <8, 1, 8>,
      <11, 12, 12>,
      <11, 12, 11>,
      <13, 14, 14>,
      <13, 14, 13>,
      <4, 15, 15>,
      <4, 15, 4>,
      <13, 13, 15>,
      <13, 15, 15>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <16, 9, 9>,
      <16, 9, 16>,
      <6, 6, 6>,
      <6, 6, 6>,
      <17, 14, 14>,
      <17, 14, 17>,
      <7, 7, 7>,
      <7, 7, 7>,
      <16, 12, 12>,
      <16, 12, 16>,
      <11, 11, 11>,
      <11, 11, 11>,
      <9, 18, 18>,
      <9, 18, 9>,
      <19, 19, 18>,
      <19, 18, 18>,
      <4, 20, 20>,
      <4, 20, 4>,
      <21, 19, 19>,
      <21, 19, 21>,
      <20, 20, 21>,
      <20, 21, 21>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <0, 0, 0>,
      <0, 0, 0>,
      <9, 22, 22>,
      <9, 22, 9>,
      <23, 23, 22>,
      <23, 22, 22>,
      <4, 24, 24>,
      <4, 24, 4>,
      <25, 23, 23>,
      <25, 23, 25>,
      <24, 24, 25>,
      <24, 25, 25>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <11, 11, 11>,
      <11, 11, 11>,
      <9, 18, 18>,
      <9, 18, 9>,
      <19, 19, 18>,
      <19, 18, 18>,
      <4, 20, 20>,
      <4, 20, 4>,
      <21, 19, 19>,
      <21, 19, 21>,
      <20, 20, 21>,
      <20, 21, 21>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <11, 12, 12>,
      <11, 12, 11>,
      <13, 14, 14>,
      <13, 14, 13>,
      <4, 15, 15>,
      <4, 15, 4>,
      <13, 13, 15>,
      <13, 15, 15>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <16, 9, 9>,
      <16, 9, 16>,
      <6, 6, 6>,
      <6, 6, 6>,
      <17, 14, 14>,
      <17, 14, 17>,
      <7, 7, 7>,
      <7, 7, 7>,
      <16, 12, 12>,
      <16, 12, 16>,
      <0, 0, 0>,
      <0, 0, 0>,
      <9, 22, 22>,
      <9, 22, 9>,
      <23, 23, 22>,
      <23, 22, 22>,
      <4, 24, 24>,
      <4, 24, 4>,
      <25, 23, 23>,
      <25, 23, 25>,
      <24, 24, 25>,
      <24, 25, 25>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <0, 1, 1>,
      <0, 1, 0>,
      <2, 3, 3>,
      <2, 3, 2>,
      <4, 5, 5>,
      <4, 5, 4>,
      <2, 2, 5>,
      <2, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <8, 9, 9>,
      <8, 9, 8>,
      <7, 7, 7>,
      <7, 7, 7>,
      <10, 3, 3>,
      <10, 3, 10>,
      <6, 6, 6>,
      <6, 6, 6>,
      <8, 1, 1>,
      <8, 1, 8>
   }
 
   uv_indices { 
      352, 
      <187, 186, 185>,
      <187, 185, 184>,
      <269, 270, 260>,
      <269, 260, 271>,
      <272, 273, 274>,
      <272, 274, 260>,
      <269, 259, 274>,
      <269, 274, 273>,
      <188, 192, 191>,
      <188, 191, 190>,
      <190, 189, 188>,
      <192, 188, 189>,
      <192, 189, 190>,
      <190, 191, 192>,
      <221, 222, 223>,
      <221, 223, 224>,
      <234, 235, 239>,
      <234, 239, 237>,
      <221, 228, 223>,
      <221, 223, 224>,
      <230, 231, 232>,
      <230, 232, 233>,
      <221, 222, 223>,
      <221, 223, 224>,
      <184, 185, 186>,
      <184, 186, 187>,
      <269, 280, 260>,
      <269, 260, 271>,
      <269, 278, 279>,
      <269, 279, 277>,
      <259, 260, 279>,
      <259, 279, 278>,
      <203, 200, 201>,
      <203, 201, 202>,
      <202, 189, 203>,
      <192, 188, 189>,
      <192, 189, 190>,
      <190, 191, 192>,
      <223, 224, 221>,
      <223, 221, 222>,
      <234, 235, 236>,
      <234, 236, 237>,
      <221, 229, 223>,
      <221, 223, 224>,
      <230, 231, 238>,
      <230, 238, 233>,
      <221, 222, 223>,
      <221, 223, 224>,
      <241, 249, 243>,
      <241, 243, 250>,
      <241, 253, 243>,
      <241, 243, 254>,
      <73, 72, 75>,
      <73, 75, 74>,
      <241, 258, 243>,
      <241, 243, 257>,
      <204, 205, 206>,
      <204, 206, 207>,
      <277, 269, 259>,
      <277, 259, 260>,
      <198, 199, 208>,
      <198, 208, 205>,
      <198, 205, 204>,
      <198, 204, 209>,
      <193, 194, 195>,
      <193, 195, 196>,
      <193, 196, 197>,
      <193, 197, 198>,
      <241, 242, 243>,
      <241, 243, 244>,
      <243, 255, 241>,
      <243, 241, 256>,
      <72, 73, 74>,
      <72, 74, 75>,
      <243, 257, 241>,
      <243, 241, 258>,
      <269, 259, 260>,
      <269, 260, 272>,
      <272, 269, 259>,
      <272, 259, 260>,
      <198, 197, 196>,
      <198, 196, 195>,
      <198, 195, 194>,
      <198, 194, 193>,
      <193, 194, 195>,
      <193, 195, 196>,
      <193, 196, 199>,
      <193, 199, 198>,
      <241, 247, 243>,
      <241, 243, 248>,
      <241, 253, 243>,
      <241, 243, 254>,
      <72, 73, 74>,
      <72, 74, 75>,
      <241, 256, 243>,
      <241, 243, 255>,
      <215, 219, 220>,
      <215, 220, 218>,
      <287, 269, 259>,
      <287, 259, 260>,
      <198, 199, 196>,
      <198, 196, 195>,
      <198, 195, 194>,
      <198, 194, 193>,
      <193, 194, 195>,
      <193, 195, 196>,
      <193, 196, 197>,
      <193, 197, 198>,
      <187, 186, 185>,
      <187, 185, 184>,
      <288, 289, 260>,
      <288, 260, 290>,
      <269, 291, 292>,
      <269, 292, 271>,
      <288, 290, 292>,
      <288, 292, 291>,
      <188, 192, 191>,
      <188, 191, 190>,
      <190, 189, 188>,
      <192, 188, 189>,
      <192, 189, 190>,
      <190, 191, 192>,
      <223, 224, 221>,
      <223, 221, 226>,
      <234, 235, 236>,
      <234, 236, 237>,
      <221, 228, 223>,
      <221, 223, 224>,
      <230, 231, 238>,
      <230, 238, 233>,
      <221, 226, 223>,
      <221, 223, 224>,
      <241, 245, 243>,
      <241, 243, 246>,
      <243, 255, 241>,
      <243, 241, 256>,
      <73, 72, 75>,
      <73, 75, 74>,
      <243, 255, 241>,
      <243, 241, 256>,
      <215, 216, 217>,
      <215, 217, 218>,
      <259, 260, 261>,
      <259, 261, 262>,
      <198, 199, 196>,
      <198, 196, 195>,
      <198, 195, 194>,
      <198, 194, 193>,
      <193, 194, 195>,
      <193, 195, 196>,
      <193, 196, 199>,
      <193, 199, 198>,
      <184, 185, 186>,
      <184, 186, 187>,
      <269, 270, 260>,
      <269, 260, 271>,
      <263, 264, 265>,
      <263, 265, 266>,
      <267, 268, 265>,
      <267, 265, 264>,
      <188, 192, 191>,
      <188, 191, 190>,
      <190, 189, 188>,
      <192, 188, 189>,
      <192, 189, 190>,
      <190, 191, 192>,
      <221, 225, 223>,
      <221, 223, 224>,
      <234, 235, 240>,
      <234, 240, 237>,
      <221, 228, 223>,
      <221, 223, 224>,
      <230, 231, 232>,
      <230, 232, 233>,
      <221, 225, 223>,
      <221, 223, 224>,
      <187, 186, 185>,
      <187, 185, 184>,
      <283, 271, 269>,
      <283, 269, 284>,
      <260, 285, 286>,
      <260, 286, 280>,
      <283, 284, 286>,
      <283, 286, 285>,
      <188, 192, 191>,
      <188, 191, 190>,
      <190, 189, 188>,
      <192, 188, 189>,
      <192, 189, 190>,
      <190, 191, 192>,
      <221, 222, 223>,
      <221, 223, 224>,
      <234, 235, 239>,
      <234, 239, 237>,
      <221, 228, 223>,
      <221, 223, 224>,
      <230, 231, 232>,
      <230, 232, 233>,
      <221, 222, 223>,
      <221, 223, 224>,
      <184, 185, 186>,
      <184, 186, 187>,
      <288, 289, 260>,
      <288, 260, 290>,
      <269, 291, 292>,
      <269, 292, 271>,
      <288, 290, 292>,
      <288, 292, 291>,
      <188, 192, 191>,
      <188, 191, 190>,
      <190, 189, 188>,
      <192, 188, 189>,
      <192, 189, 190>,
      <190, 191, 192>,
      <223, 224, 221>,
      <223, 221, 222>,
      <234, 235, 236>,
      <234, 236, 237>,
      <221, 228, 223>,
      <221, 223, 224>,
      <230, 231, 238>,
      <230, 238, 233>,
      <221, 222, 223>,
      <221, 223, 224>,
      <241, 249, 243>,
      <241, 243, 250>,
      <241, 253, 243>,
      <241, 243, 254>,
      <73, 72, 75>,
      <73, 75, 74>,
      <241, 258, 243>,
      <241, 243, 257>,
      <215, 219, 220>,
      <215, 220, 218>,
      <287, 269, 259>,
      <287, 259, 260>,
      <198, 199, 196>,
      <198, 196, 195>,
      <198, 195, 194>,
      <198, 194, 193>,
      <193, 194, 195>,
      <193, 195, 196>,
      <193, 196, 199>,
      <193, 199, 198>,
      <241, 242, 243>,
      <241, 243, 244>,
      <243, 255, 241>,
      <243, 241, 256>,
      <72, 73, 74>,
      <72, 74, 75>,
      <243, 257, 241>,
      <243, 241, 258>,
      <215, 219, 220>,
      <215, 220, 218>,
      <277, 269, 259>,
      <277, 259, 260>,
      <198, 197, 196>,
      <198, 196, 195>,
      <198, 195, 194>,
      <198, 194, 193>,
      <193, 194, 195>,
      <193, 195, 196>,
      <193, 196, 197>,
      <193, 197, 198>,
      <241, 249, 243>,
      <241, 243, 250>,
      <241, 251, 243>,
      <241, 243, 252>,
      <72, 73, 74>,
      <72, 74, 75>,
      <68, 69, 70>,
      <68, 70, 71>,
      <215, 219, 220>,
      <215, 220, 218>,
      <287, 269, 259>,
      <287, 259, 260>,
      <198, 197, 196>,
      <198, 196, 195>,
      <198, 195, 194>,
      <198, 194, 193>,
      <193, 194, 195>,
      <193, 195, 196>,
      <193, 196, 197>,
      <193, 197, 198>,
      <187, 186, 185>,
      <187, 185, 184>,
      <288, 289, 260>,
      <288, 260, 290>,
      <269, 291, 292>,
      <269, 292, 271>,
      <288, 290, 292>,
      <288, 292, 291>,
      <188, 192, 191>,
      <188, 191, 190>,
      <190, 189, 188>,
      <192, 188, 189>,
      <192, 189, 190>,
      <190, 191, 192>,
      <223, 224, 221>,
      <223, 221, 226>,
      <234, 235, 236>,
      <234, 236, 237>,
      <221, 227, 223>,
      <221, 223, 224>,
      <230, 231, 232>,
      <230, 232, 233>,
      <221, 227, 223>,
      <221, 223, 224>,
      <241, 247, 243>,
      <241, 243, 248>,
      <243, 255, 241>,
      <243, 241, 256>,
      <73, 72, 75>,
      <73, 75, 74>,
      <243, 255, 241>,
      <243, 241, 256>,
      <215, 216, 217>,
      <215, 217, 218>,
      <287, 269, 259>,
      <287, 259, 260>,
      <198, 199, 208>,
      <198, 208, 210>,
      <198, 210, 204>,
      <198, 204, 209>,
      <193, 194, 195>,
      <193, 195, 196>,
      <193, 196, 197>,
      <193, 197, 198>,
      <184, 185, 186>,
      <184, 186, 187>,
      <269, 289, 260>,
      <269, 260, 271>,
      <287, 273, 274>,
      <287, 274, 260>,
      <269, 259, 274>,
      <269, 274, 273>,
      <214, 200, 212>,
      <214, 212, 213>,
      <213, 189, 214>,
      <192, 188, 189>,
      <192, 189, 190>,
      <190, 191, 192>,
      <221, 226, 223>,
      <221, 223, 224>,
      <234, 235, 236>,
      <234, 236, 237>,
      <221, 227, 223>,
      <221, 223, 224>,
      <230, 231, 232>,
      <230, 232, 233>,
      <221, 226, 223>,
      <221, 223, 224>
   }
   uv_mapping
}
 
// BrakePis
mesh2 {
 
   vertex_vectors { 
      104, 
      <-6.658733E-01, 2.190568E+00, -1.756773E+01>,
      <-1.012282E+00, 2.425568E+00, -1.756773E+01>,
      <-1.012282E+00, 2.895568E+00, -1.756773E+01>,
      <-6.658733E-01, 3.130568E+00, -1.756773E+01>,
      <-3.194645E-01, 2.895568E+00, -1.756773E+01>,
      <-3.194645E-01, 2.425568E+00, -1.756773E+01>,
      <-6.658738E-01, 2.359768E+00, -1.639273E+01>,
      <-8.875744E-01, 2.510168E+00, -1.639273E+01>,
      <-8.875744E-01, 2.810968E+00, -1.639273E+01>,
      <-6.658738E-01, 2.961369E+00, -1.639273E+01>,
      <-4.441731E-01, 2.810968E+00, -1.639273E+01>,
      <-4.441731E-01, 2.510168E+00, -1.639273E+01>,
      <-6.65873E-01, 2.359768E+00, -1.874273E+01>,
      <-8.875737E-01, 2.510168E+00, -1.874273E+01>,
      <-8.875737E-01, 2.810968E+00, -1.874273E+01>,
      <-6.65873E-01, 2.961368E+00, -1.874273E+01>,
      <-4.441723E-01, 2.810968E+00, -1.874273E+01>,
      <-4.441723E-01, 2.510168E+00, -1.874273E+01>,
      <-2.158727E-01, 2.073068E+00, -1.739148E+01>,
      <-2.158727E-01, 3.248068E+00, -1.739148E+01>,
      <-1.115874E+00, 3.248068E+00, -1.739148E+01>,
      <-1.115874E+00, 2.073068E+00, -1.739148E+01>,
      <-1.115874E+00, 2.073068E+00, -1.774398E+01>,
      <-1.115874E+00, 3.248068E+00, -1.774398E+01>,
      <-2.158726E-01, 3.248068E+00, -1.774398E+01>,
      <-2.158726E-01, 2.073068E+00, -1.774398E+01>,
      <-6.658717E-01, 2.190568E+00, -2.250103E+01>,
      <-1.012281E+00, 2.425568E+00, -2.250103E+01>,
      <-1.012281E+00, 2.895568E+00, -2.250103E+01>,
      <-6.658717E-01, 3.130568E+00, -2.250103E+01>,
      <-3.194629E-01, 2.895568E+00, -2.250103E+01>,
      <-3.194629E-01, 2.425568E+00, -2.250103E+01>,
      <-6.658722E-01, 2.359768E+00, -2.132602E+01>,
      <-8.875728E-01, 2.510168E+00, -2.132602E+01>,
      <-8.875728E-01, 2.810968E+00, -2.132602E+01>,
      <-6.658722E-01, 2.961369E+00, -2.132602E+01>,
      <-4.441715E-01, 2.810968E+00, -2.132602E+01>,
      <-4.441715E-01, 2.510168E+00, -2.132602E+01>,
      <-6.658714E-01, 2.359768E+00, -2.367603E+01>,
      <-8.875721E-01, 2.510168E+00, -2.367603E+01>,
      <-8.875721E-01, 2.810968E+00, -2.367603E+01>,
      <-6.658714E-01, 2.961368E+00, -2.367603E+01>,
      <-4.441707E-01, 2.810968E+00, -2.367603E+01>,
      <-4.441707E-01, 2.510168E+00, -2.367603E+01>,
      <-2.158711E-01, 2.073068E+00, -2.232477E+01>,
      <-2.158711E-01, 3.248068E+00, -2.232477E+01>,
      <-1.115873E+00, 3.248068E+00, -2.232477E+01>,
      <-1.115873E+00, 2.073068E+00, -2.232477E+01>,
      <-1.115873E+00, 2.073068E+00, -2.267728E+01>,
      <-1.115873E+00, 3.248068E+00, -2.267728E+01>,
      <-2.158709E-01, 3.248068E+00, -2.267728E+01>,
      <-2.158709E-01, 2.073068E+00, -2.267728E+01>,
      <3.328084E+00, 2.190568E+00, -1.756773E+01>,
      <2.981675E+00, 2.425568E+00, -1.756773E+01>,
      <2.981675E+00, 2.895568E+00, -1.756773E+01>,
      <3.328084E+00, 3.130568E+00, -1.756773E+01>,
      <3.674493E+00, 2.895568E+00, -1.756773E+01>,
      <3.674493E+00, 2.425568E+00, -1.756773E+01>,
      <3.328084E+00, 2.359768E+00, -1.639273E+01>,
      <3.106383E+00, 2.510168E+00, -1.639273E+01>,
      <3.106383E+00, 2.810968E+00, -1.639273E+01>,
      <3.328084E+00, 2.961369E+00, -1.639273E+01>,
      <3.549784E+00, 2.810968E+00, -1.639273E+01>,
      <3.549784E+00, 2.510168E+00, -1.639273E+01>,
      <3.328084E+00, 2.359768E+00, -1.874273E+01>,
      <3.106384E+00, 2.510168E+00, -1.874273E+01>,
      <3.106384E+00, 2.810968E+00, -1.874273E+01>,
      <3.328084E+00, 2.961368E+00, -1.874273E+01>,
      <3.549785E+00, 2.810968E+00, -1.874273E+01>,
      <3.549785E+00, 2.510168E+00, -1.874273E+01>,
      <3.778085E+00, 2.073068E+00, -1.739148E+01>,
      <3.778085E+00, 3.248068E+00, -1.739148E+01>,
      <2.878083E+00, 3.248068E+00, -1.739148E+01>,
      <2.878083E+00, 2.073068E+00, -1.739148E+01>,
      <2.878083E+00, 2.073068E+00, -1.774398E+01>,
      <2.878083E+00, 3.248068E+00, -1.774398E+01>,
      <3.778085E+00, 3.248068E+00, -1.774398E+01>,
      <3.778085E+00, 2.073068E+00, -1.774398E+01>,
      <3.328086E+00, 2.190568E+00, -2.250103E+01>,
      <2.981677E+00, 2.425568E+00, -2.250103E+01>,
      <2.981677E+00, 2.895568E+00, -2.250103E+01>,
      <3.328086E+00, 3.130568E+00, -2.250103E+01>,
      <3.674495E+00, 2.895568E+00, -2.250103E+01>,
      <3.674495E+00, 2.425568E+00, -2.250103E+01>,
      <3.328085E+00, 2.359768E+00, -2.132602E+01>,
      <3.106385E+00, 2.510168E+00, -2.132602E+01>,
      <3.106385E+00, 2.810968E+00, -2.132602E+01>,
      <3.328085E+00, 2.961369E+00, -2.132602E+01>,
      <3.549786E+00, 2.810968E+00, -2.132602E+01>,
      <3.549786E+00, 2.510168E+00, -2.132602E+01>,
      <3.328086E+00, 2.359768E+00, -2.367603E+01>,
      <3.106385E+00, 2.510168E+00, -2.367603E+01>,
      <3.106385E+00, 2.810968E+00, -2.367603E+01>,
      <3.328086E+00, 2.961368E+00, -2.367603E+01>,
      <3.549787E+00, 2.810968E+00, -2.367603E+01>,
      <3.549787E+00, 2.510168E+00, -2.367603E+01>,
      <3.778086E+00, 2.073068E+00, -2.232477E+01>,
      <3.778086E+00, 3.248068E+00, -2.232477E+01>,
      <2.878085E+00, 3.248068E+00, -2.232477E+01>,
      <2.878085E+00, 2.073068E+00, -2.232477E+01>,
      <2.878085E+00, 2.073068E+00, -2.267728E+01>,
      <2.878085E+00, 3.248068E+00, -2.267728E+01>,
      <3.778087E+00, 3.248068E+00, -2.267728E+01>,
      <3.778087E+00, 2.073068E+00, -2.267728E+01>
   }
 
   normal_vectors { 
      42, 
      <-1.887737E-01, -9.808913E-01, 4.708302E-02>,
      <-2.009061E-07, -9.897905E-01, 1.425303E-01>,
      <-8.571844E-01, -4.948941E-01, 1.425299E-01>,
      <-7.550917E-01, -6.539264E-01, 4.708286E-02>,
      <-9.438635E-01, -3.269632E-01, 4.708263E-02>,
      <-8.571844E-01, 4.948942E-01, 1.425298E-01>,
      <-9.438635E-01, 3.269632E-01, 4.708256E-02>,
      <-7.550917E-01, 6.539263E-01, 4.708278E-02>,
      <1.42347E-07, 9.897904E-01, 1.4253E-01>,
      <-1.887736E-01, 9.808913E-01, 4.708283E-02>,
      <1.887739E-01, 9.808912E-01, 4.708295E-02>,
      <8.571843E-01, 4.948941E-01, 1.425303E-01>,
      <7.550918E-01, 6.539261E-01, 4.708321E-02>,
      <9.438635E-01, 3.269631E-01, 4.708315E-02>,
      <8.571842E-01, -4.948943E-01, 1.425304E-01>,
      <9.438635E-01, -3.269633E-01, 4.708327E-02>,
      <7.550915E-01, -6.539266E-01, 4.708334E-02>,
      <1.887733E-01, -9.808914E-01, 4.708313E-02>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.766723E-07, -9.897906E-01, -1.425298E-01>,
      <-1.887738E-01, -9.808913E-01, -4.708271E-02>,
      <-7.550917E-01, -6.539264E-01, -4.708297E-02>,
      <-8.571842E-01, -4.948943E-01, -1.425301E-01>,
      <-9.438635E-01, -3.269633E-01, -4.708293E-02>,
      <-9.438635E-01, 3.269632E-01, -4.708294E-02>,
      <-8.571842E-01, 4.948942E-01, -1.425301E-01>,
      <-7.550917E-01, 6.539263E-01, -4.708306E-02>,
      <-1.887735E-01, 9.808913E-01, -4.708281E-02>,
      <2.00906E-07, 9.897904E-01, -1.425299E-01>,
      <1.887739E-01, 9.808912E-01, -4.708272E-02>,
      <7.550918E-01, 6.539261E-01, -4.708258E-02>,
      <8.571844E-01, 4.948941E-01, -1.425295E-01>,
      <9.438635E-01, 3.269631E-01, -4.708231E-02>,
      <9.438635E-01, -3.269634E-01, -4.708231E-02>,
      <8.571842E-01, -4.948945E-01, -1.425295E-01>,
      <7.550915E-01, -6.539266E-01, -4.708247E-02>,
      <1.887734E-01, -9.808914E-01, -4.708258E-02>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-4.280104E-16, 9.999999E-01, 4.31381E-16>,
      <4.280104E-16, -1.00E+00, -4.31381E-16>
   }
 
   uv_vectors { 
      274, 
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <-1.441447E-01, 1.2916E-01>,
      <-1.476822E-01, 1.380304E-01>,
      <-1.467621E-01, 1.459152E-01>,
      <-1.426424E-01, 1.4148E-01>,
      <-1.467621E-01, 1.616848E-01>,
      <-1.426424E-01, 1.661201E-01>,
      <-1.476822E-01, 1.695696E-01>,
      <-1.441447E-01, 1.7844E-01>,
      <-1.486642E-01, 1.616848E-01>,
      <-1.459154E-01, 1.6612E-01>,
      <-1.486642E-01, 1.459152E-01>,
      <-1.459154E-01, 1.4148E-01>,
      <-1.383663E-01, 1.380304E-01>,
      <-1.375538E-01, 1.459152E-01>,
      <-1.375538E-01, 1.616848E-01>,
      <-1.383663E-01, 1.695696E-01>,
      <-1.393299E-01, 1.616848E-01>,
      <-1.393299E-01, 1.459152E-01>,
      <-1.471163E-01, 1.23E-01>,
      <-1.471163E-01, 1.846E-01>,
      <-1.428835E-01, 1.846E-01>,
      <-1.428835E-01, 1.23E-01>,
      <-1.415543E-01, 1.23E-01>,
      <-1.415543E-01, 1.846E-01>,
      <-1.458302E-01, 1.846E-01>,
      <-1.458302E-01, 1.23E-01>,
      <-2.318553E-01, 1.2916E-01>,
      <-2.376337E-01, 1.380304E-01>,
      <-2.384462E-01, 1.459152E-01>,
      <-2.333577E-01, 1.4148E-01>,
      <-2.384462E-01, 1.616848E-01>,
      <-2.333577E-01, 1.661201E-01>,
      <-2.376337E-01, 1.695696E-01>,
      <-2.318553E-01, 1.7844E-01>,
      <-2.366701E-01, 1.616848E-01>,
      <-2.300846E-01, 1.6612E-01>,
      <-2.366701E-01, 1.459152E-01>,
      <-2.300846E-01, 1.4148E-01>,
      <-2.283177E-01, 1.380304E-01>,
      <-2.292379E-01, 1.459152E-01>,
      <-2.292379E-01, 1.616848E-01>,
      <-2.283177E-01, 1.695696E-01>,
      <-2.273358E-01, 1.616848E-01>,
      <-2.273358E-01, 1.459152E-01>,
      <-2.301699E-01, 1.23E-01>,
      <-2.301699E-01, 1.846E-01>,
      <-2.344457E-01, 1.846E-01>,
      <-2.344457E-01, 1.23E-01>,
      <-2.331165E-01, 1.23E-01>,
      <-2.331165E-01, 1.846E-01>,
      <-2.288837E-01, 1.846E-01>,
      <-2.288837E-01, 1.23E-01>,
      <-1.727553E-01, 1.2916E-01>,
      <-1.692178E-01, 1.380304E-01>,
      <-1.682357E-01, 1.459152E-01>,
      <-1.709846E-01, 1.4148E-01>,
      <-1.682357E-01, 1.616848E-01>,
      <-1.709846E-01, 1.661201E-01>,
      <-1.692178E-01, 1.695696E-01>,
      <-1.727553E-01, 1.7844E-01>,
      <-1.701379E-01, 1.616848E-01>,
      <-1.742576E-01, 1.6612E-01>,
      <-1.701379E-01, 1.459152E-01>,
      <-1.742576E-01, 1.4148E-01>,
      <-1.785337E-01, 1.380304E-01>,
      <-1.7757E-01, 1.459152E-01>,
      <-1.7757E-01, 1.616848E-01>,
      <-1.785337E-01, 1.695696E-01>,
      <-1.793462E-01, 1.616848E-01>,
      <-1.793462E-01, 1.459152E-01>,
      <-1.740165E-01, 1.23E-01>,
      <-1.740165E-01, 1.846E-01>,
      <-1.697837E-01, 1.846E-01>,
      <-1.697837E-01, 1.23E-01>,
      <-1.710699E-01, 1.23E-01>,
      <-1.710699E-01, 1.846E-01>,
      <-1.753457E-01, 1.846E-01>,
      <-1.753457E-01, 1.23E-01>,
      <-2.032447E-01, 1.2916E-01>,
      <-1.974663E-01, 1.380304E-01>,
      <-1.984299E-01, 1.459152E-01>,
      <-2.050154E-01, 1.4148E-01>,
      <-1.984299E-01, 1.616848E-01>,
      <-2.050154E-01, 1.661201E-01>,
      <-1.974663E-01, 1.695696E-01>,
      <-2.032447E-01, 1.7844E-01>,
      <-1.966538E-01, 1.616848E-01>,
      <-2.017424E-01, 1.6612E-01>,
      <-1.966538E-01, 1.459152E-01>,
      <-2.017424E-01, 1.4148E-01>,
      <-2.067822E-01, 1.380304E-01>,
      <-2.077643E-01, 1.459152E-01>,
      <-2.077643E-01, 1.616848E-01>,
      <-2.067822E-01, 1.695696E-01>,
      <-2.05862E-01, 1.616848E-01>,
      <-2.05862E-01, 1.459152E-01>,
      <-2.006543E-01, 1.23E-01>,
      <-2.006543E-01, 1.846E-01>,
      <-2.049301E-01, 1.846E-01>,
      <-2.049301E-01, 1.23E-01>,
      <-2.062163E-01, 1.23E-01>,
      <-2.062163E-01, 1.846E-01>,
      <-2.019835E-01, 1.846E-01>,
      <-2.019835E-01, 1.23E-01>,
      <-2.349674E-01, 1.73512E-01>,
      <-1.6415E-01, 1.846E-01>,
      <-1.34075E-01, 1.691999E-01>,
      <-2.165477E-01, 1.63656E-01>,
      <-1.34075E-01, 1.384E-01>,
      <-2.165477E-01, 1.43944E-01>,
      <-1.6415E-01, 1.23E-01>,
      <-2.349674E-01, 1.34088E-01>,
      <-2.419251E-01, 1.846E-01>,
      <-1.534707E-01, 1.73512E-01>,
      <-1.410326E-01, 1.63656E-01>,
      <-2.189276E-01, 1.691999E-01>,
      <-1.410326E-01, 1.43944E-01>,
      <-2.189276E-01, 1.384E-01>,
      <-1.534707E-01, 1.34088E-01>,
      <-2.419251E-01, 1.23E-01>,
      <-2.361122E-01, 1.73512E-01>,
      <-1.352198E-01, 1.846E-01>,
      <-1.352198E-01, 1.23E-01>,
      <-2.361122E-01, 1.34088E-01>,
      <-1.6415E-01, 1.846E-01>,
      <-1.34075E-01, 1.384E-01>,
      <-2.165477E-01, 1.43944E-01>,
      <-1.6415E-01, 1.23E-01>,
      <-2.349674E-01, 1.34088E-01>,
      <-1.534707E-01, 1.73512E-01>,
      <-1.410326E-01, 1.43944E-01>,
      <-2.189276E-01, 1.384E-01>,
      <-1.534707E-01, 1.34088E-01>,
      <-1.6415E-01, 1.846E-01>,
      <-1.34075E-01, 1.384E-01>,
      <-2.165477E-01, 1.43944E-01>,
      <-1.6415E-01, 1.23E-01>,
      <-2.349674E-01, 1.34088E-01>,
      <-2.225293E-01, 1.73512E-01>,
      <-1.34075E-01, 1.846E-01>,
      <-1.570725E-01, 1.691999E-01>,
      <-2.349674E-01, 1.63656E-01>,
      <-1.570725E-01, 1.384E-01>,
      <-2.349674E-01, 1.43944E-01>,
      <-1.34075E-01, 1.23E-01>,
      <-2.225293E-01, 1.34088E-01>,
      <-2.1185E-01, 1.846E-01>,
      <-1.410326E-01, 1.73512E-01>,
      <-1.594535E-01, 1.63656E-01>,
      <-2.419251E-01, 1.691999E-01>,
      <-1.594535E-01, 1.43944E-01>,
      <-2.419251E-01, 1.384E-01>,
      <-1.410326E-01, 1.34088E-01>,
      <-2.1185E-01, 1.23E-01>,
      <-1.350578E-01, 1.23E-01>,
      <-2.231417E-01, 1.267712E-01>,
      <-2.343971E-01, 1.466167E-01>,
      <-1.521848E-01, 1.540088E-01>,
      <-2.270997E-01, 1.661951E-01>,
      <-1.384602E-01, 1.846001E-01>,
      <-2.225302E-01, 1.34088E-01>,
      <-2.349674E-01, 1.43944E-01>,
      <-2.349674E-01, 1.63656E-01>,
      <-1.570725E-01, 1.692E-01>,
      <-2.225302E-01, 1.73512E-01>,
      <-1.34075E-01, 1.846E-01>,
      <-2.1185E-01, 1.23E-01>,
      <-2.41925E-01, 1.384E-01>,
      <-1.594535E-01, 1.43944E-01>,
      <-2.41925E-01, 1.692E-01>,
      <-1.594535E-01, 1.63656E-01>,
      <-2.1185E-01, 1.846E-01>,
      <-1.410326E-01, 1.73512E-01>,
      <-1.534707E-01, 1.34088E-01>,
      <-2.189275E-01, 1.384E-01>,
      <-1.410326E-01, 1.43944E-01>,
      <-1.534707E-01, 1.73512E-01>,
      <-1.641508E-01, 1.23E-01>,
      <-2.349674E-01, 1.34088E-01>,
      <-2.165468E-01, 1.43944E-01>,
      <-1.34075E-01, 1.384E-01>,
      <-1.641508E-01, 1.846E-01>,
      <-3.045952E-01, 1.289E-01>,
      <-3.045952E-01, 1.836E-01>,
      <-2.579048E-01, 1.836E-01>,
      <-2.579048E-01, 1.289E-01>,
      <-2.976465E-01, 1.289E-01>,
      <-2.976465E-01, 1.836E-01>,
      <-2.648535E-01, 1.836E-01>,
      <-2.648535E-01, 1.289E-01>,
      <-2.579048E-01, 1.289E-01>,
      <-2.976465E-01, 1.289E-01>,
      <-2.648535E-01, 1.289E-01>,
      <-3.206885E-01, 1.309E-01>,
      <-3.206885E-01, 1.836E-01>,
      <-3.639115E-01, 1.836E-01>,
      <-3.639115E-01, 1.309E-01>,
      <-2.660337E-01, 1.299E-01>,
      <-2.660337E-01, 1.797E-01>,
      <-2.993664E-01, 1.797E-01>,
      <-2.993664E-01, 1.299E-01>,
      <-8.364E-01, 2.646E-01>,
      <-8.364E-01, 4.694E-01>,
      <-9.90E-01, 4.694E-01>,
      <-9.90E-01, 2.646E-01>,
      <-8.364E-01, 2.646E-01>,
      <-8.364E-01, 4.694E-01>,
      <-9.90E-01, 4.694E-01>,
      <-9.90E-01, 2.646E-01>,
      <-8.364E-01, 2.646E-01>,
      <-8.364E-01, 4.694E-01>,
      <-9.900001E-01, 4.694E-01>,
      <-9.900001E-01, 2.646E-01>,
      <-8.364001E-01, 2.646E-01>,
      <-8.364001E-01, 4.694E-01>,
      <-9.900001E-01, 4.694E-01>,
      <-9.900001E-01, 2.646E-01>,
      <-8.364E-01, 2.646E-01>,
      <-8.364E-01, 4.694E-01>,
      <-9.900001E-01, 4.694E-01>,
      <-9.900001E-01, 2.646E-01>,
      <-8.364E-01, 2.646E-01>,
      <-8.364E-01, 4.694E-01>,
      <-9.900001E-01, 4.694E-01>,
      <-9.900001E-01, 2.646E-01>,
      <-8.389E-01, 3.109998E-02>,
      <-8.389E-01, 2.121999E-01>,
      <-9.675E-01, 2.121999E-01>,
      <-9.675E-01, 3.109998E-02>,
      <-9.675E-01, 2.121999E-01>,
      <-9.675E-01, 2.121999E-01>,
      <-9.675E-01, 2.121999E-01>,
      <-2.395033E-02, 7.715E-01>,
      <-2.022001E-01, 7.4117E-01>,
      <-1.948081E-01, 7.1421E-01>,
      <-1.240002E-02, 7.293749E-01>,
      <-1.948081E-01, 6.6029E-01>,
      <-1.240002E-02, 6.45125E-01>,
      <-2.022001E-01, 6.3333E-01>,
      <-2.395033E-02, 6.03E-01>,
      <-1.240003E-02, 7.4117E-01>,
      <-1.906493E-01, 7.715E-01>,
      <-2.022E-01, 7.293749E-01>,
      <-1.979241E-02, 7.142099E-01>,
      <-2.022E-01, 6.45125E-01>,
      <-1.979241E-02, 6.602899E-01>,
      <-1.906493E-01, 6.03E-01>,
      <-1.240003E-02, 6.3333E-01>,
      <-1.906493E-01, 6.03E-01>,
      <-1.906497E-01, 6.03E-01>,
      <-6.485498E-01, 7.553E-01>,
      <-5.63E-01, 7.937E-01>,
      <-5.63E-01, 8.704999E-01>,
      <-6.485498E-01, 9.089E-01>,
      <-7.341E-01, 8.705E-01>,
      <-7.341E-01, 7.937E-01>,
      <-6.485498E-01, 7.553E-01>,
      <-5.63E-01, 7.936999E-01>,
      <-5.63E-01, 8.705E-01>,
      <-6.485498E-01, 9.089E-01>,
      <-7.341E-01, 7.936999E-01>,
      <-6.4855E-01, 7.553E-01>,
      <-5.63E-01, 7.936999E-01>,
      <-5.63E-01, 8.705E-01>,
      <-6.4855E-01, 9.089E-01>,
      <-7.341E-01, 7.936999E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      176, 
      <0, 6, 7>, 0,
      <0, 7, 1>, 0,
      <1, 7, 8>, 0,
      <1, 8, 2>, 0,
      <2, 8, 9>, 0,
      <2, 9, 3>, 0,
      <3, 9, 10>, 0,
      <3, 10, 4>, 0,
      <4, 10, 11>, 0,
      <4, 11, 5>, 0,
      <5, 11, 6>, 0,
      <5, 6, 0>, 0,
      <6, 11, 10>, 0,
      <6, 10, 9>, 0,
      <6, 9, 8>, 0,
      <6, 8, 7>, 0,
      <12, 13, 14>, 0,
      <12, 14, 15>, 0,
      <12, 15, 16>, 0,
      <12, 16, 17>, 0,
      <12, 0, 1>, 0,
      <12, 1, 13>, 0,
      <13, 1, 2>, 0,
      <13, 2, 14>, 0,
      <14, 2, 3>, 0,
      <14, 3, 15>, 0,
      <15, 3, 4>, 0,
      <15, 4, 16>, 0,
      <16, 4, 5>, 0,
      <16, 5, 17>, 0,
      <17, 5, 0>, 0,
      <17, 0, 12>, 0,
      <18, 19, 20>, 0,
      <18, 20, 21>, 0,
      <22, 23, 24>, 0,
      <22, 24, 25>, 0,
      <21, 20, 23>, 0,
      <21, 23, 22>, 0,
      <25, 24, 19>, 0,
      <25, 19, 18>, 0,
      <19, 24, 23>, 0,
      <19, 23, 20>, 0,
      <21, 22, 25>, 0,
      <21, 25, 18>, 0,
      <26, 32, 33>, 0,
      <26, 33, 27>, 0,
      <27, 33, 34>, 0,
      <27, 34, 28>, 0,
      <28, 34, 35>, 0,
      <28, 35, 29>, 0,
      <29, 35, 36>, 0,
      <29, 36, 30>, 0,
      <30, 36, 37>, 0,
      <30, 37, 31>, 0,
      <31, 37, 32>, 0,
      <31, 32, 26>, 0,
      <32, 37, 36>, 0,
      <32, 36, 35>, 0,
      <32, 35, 34>, 0,
      <32, 34, 33>, 0,
      <38, 39, 40>, 0,
      <38, 40, 41>, 0,
      <38, 41, 42>, 0,
      <38, 42, 43>, 0,
      <38, 26, 27>, 0,
      <38, 27, 39>, 0,
      <39, 27, 28>, 0,
      <39, 28, 40>, 0,
      <40, 28, 29>, 0,
      <40, 29, 41>, 0,
      <41, 29, 30>, 0,
      <41, 30, 42>, 0,
      <42, 30, 31>, 0,
      <42, 31, 43>, 0,
      <43, 31, 26>, 0,
      <43, 26, 38>, 0,
      <44, 45, 46>, 0,
      <44, 46, 47>, 0,
      <48, 49, 50>, 0,
      <48, 50, 51>, 0,
      <47, 46, 49>, 0,
      <47, 49, 48>, 0,
      <51, 50, 45>, 0,
      <51, 45, 44>, 0,
      <45, 50, 49>, 0,
      <45, 49, 46>, 0,
      <47, 48, 51>, 0,
      <47, 51, 44>, 0,
      <52, 58, 59>, 0,
      <52, 59, 53>, 0,
      <53, 59, 60>, 0,
      <53, 60, 54>, 0,
      <54, 60, 61>, 0,
      <54, 61, 55>, 0,
      <55, 61, 62>, 0,
      <55, 62, 56>, 0,
      <56, 62, 63>, 0,
      <56, 63, 57>, 0,
      <57, 63, 58>, 0,
      <57, 58, 52>, 0,
      <58, 63, 62>, 0,
      <58, 62, 61>, 0,
      <58, 61, 60>, 0,
      <58, 60, 59>, 0,
      <64, 65, 66>, 0,
      <64, 66, 67>, 0,
      <64, 67, 68>, 0,
      <64, 68, 69>, 0,
      <64, 52, 53>, 0,
      <64, 53, 65>, 0,
      <65, 53, 54>, 0,
      <65, 54, 66>, 0,
      <66, 54, 55>, 0,
      <66, 55, 67>, 0,
      <67, 55, 56>, 0,
      <67, 56, 68>, 0,
      <68, 56, 57>, 0,
      <68, 57, 69>, 0,
      <69, 57, 52>, 0,
      <69, 52, 64>, 0,
      <70, 71, 72>, 0,
      <70, 72, 73>, 0,
      <74, 75, 76>, 0,
      <74, 76, 77>, 0,
      <73, 72, 75>, 0,
      <73, 75, 74>, 0,
      <77, 76, 71>, 0,
      <77, 71, 70>, 0,
      <71, 76, 75>, 0,
      <71, 75, 72>, 0,
      <73, 74, 77>, 0,
      <73, 77, 70>, 0,
      <78, 84, 85>, 0,
      <78, 85, 79>, 0,
      <79, 85, 86>, 0,
      <79, 86, 80>, 0,
      <80, 86, 87>, 0,
      <80, 87, 81>, 0,
      <81, 87, 88>, 0,
      <81, 88, 82>, 0,
      <82, 88, 89>, 0,
      <82, 89, 83>, 0,
      <83, 89, 84>, 0,
      <83, 84, 78>, 0,
      <84, 89, 88>, 0,
      <84, 88, 87>, 0,
      <84, 87, 86>, 0,
      <84, 86, 85>, 0,
      <90, 91, 92>, 0,
      <90, 92, 93>, 0,
      <90, 93, 94>, 0,
      <90, 94, 95>, 0,
      <90, 78, 79>, 0,
      <90, 79, 91>, 0,
      <91, 79, 80>, 0,
      <91, 80, 92>, 0,
      <92, 80, 81>, 0,
      <92, 81, 93>, 0,
      <93, 81, 82>, 0,
      <93, 82, 94>, 0,
      <94, 82, 83>, 0,
      <94, 83, 95>, 0,
      <95, 83, 78>, 0,
      <95, 78, 90>, 0,
      <96, 97, 98>, 0,
      <96, 98, 99>, 0,
      <100, 101, 102>, 0,
      <100, 102, 103>, 0,
      <99, 98, 101>, 0,
      <99, 101, 100>, 0,
      <103, 102, 97>, 0,
      <103, 97, 96>, 0,
      <97, 102, 101>, 0,
      <97, 101, 98>, 0,
      <99, 100, 103>, 0,
      <99, 103, 96>, 0
   }
 
   normal_indices { 
      176, 
      <0, 1, 2>,
      <0, 2, 3>,
      <4, 2, 5>,
      <4, 5, 6>,
      <7, 5, 8>,
      <7, 8, 9>,
      <10, 8, 11>,
      <10, 11, 12>,
      <13, 11, 14>,
      <13, 14, 15>,
      <16, 14, 1>,
      <16, 1, 17>,
      <18, 18, 18>,
      <18, 18, 18>,
      <18, 18, 18>,
      <18, 18, 18>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <20, 21, 22>,
      <20, 22, 23>,
      <23, 24, 25>,
      <23, 25, 26>,
      <26, 27, 28>,
      <26, 28, 29>,
      <29, 30, 31>,
      <29, 31, 32>,
      <32, 33, 34>,
      <32, 34, 35>,
      <35, 36, 37>,
      <35, 37, 20>,
      <18, 18, 18>,
      <18, 18, 18>,
      <19, 19, 19>,
      <19, 19, 19>,
      <38, 38, 38>,
      <38, 38, 38>,
      <39, 39, 39>,
      <39, 39, 39>,
      <40, 40, 40>,
      <40, 40, 40>,
      <41, 41, 41>,
      <41, 41, 41>,
      <0, 1, 2>,
      <0, 2, 3>,
      <4, 2, 5>,
      <4, 5, 6>,
      <7, 5, 8>,
      <7, 8, 9>,
      <10, 8, 11>,
      <10, 11, 12>,
      <13, 11, 14>,
      <13, 14, 15>,
      <16, 14, 1>,
      <16, 1, 17>,
      <18, 18, 18>,
      <18, 18, 18>,
      <18, 18, 18>,
      <18, 18, 18>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <20, 21, 22>,
      <20, 22, 23>,
      <23, 24, 25>,
      <23, 25, 26>,
      <26, 27, 28>,
      <26, 28, 29>,
      <29, 30, 31>,
      <29, 31, 32>,
      <32, 33, 34>,
      <32, 34, 35>,
      <35, 36, 37>,
      <35, 37, 20>,
      <18, 18, 18>,
      <18, 18, 18>,
      <19, 19, 19>,
      <19, 19, 19>,
      <38, 38, 38>,
      <38, 38, 38>,
      <39, 39, 39>,
      <39, 39, 39>,
      <40, 40, 40>,
      <40, 40, 40>,
      <41, 41, 41>,
      <41, 41, 41>,
      <0, 1, 2>,
      <0, 2, 3>,
      <4, 2, 5>,
      <4, 5, 6>,
      <7, 5, 8>,
      <7, 8, 9>,
      <10, 8, 11>,
      <10, 11, 12>,
      <13, 11, 14>,
      <13, 14, 15>,
      <16, 14, 1>,
      <16, 1, 17>,
      <18, 18, 18>,
      <18, 18, 18>,
      <18, 18, 18>,
      <18, 18, 18>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <20, 21, 22>,
      <20, 22, 23>,
      <23, 24, 25>,
      <23, 25, 26>,
      <26, 27, 28>,
      <26, 28, 29>,
      <29, 30, 31>,
      <29, 31, 32>,
      <32, 33, 34>,
      <32, 34, 35>,
      <35, 36, 37>,
      <35, 37, 20>,
      <18, 18, 18>,
      <18, 18, 18>,
      <19, 19, 19>,
      <19, 19, 19>,
      <38, 38, 38>,
      <38, 38, 38>,
      <39, 39, 39>,
      <39, 39, 39>,
      <40, 40, 40>,
      <40, 40, 40>,
      <41, 41, 41>,
      <41, 41, 41>,
      <0, 1, 2>,
      <0, 2, 3>,
      <4, 2, 5>,
      <4, 5, 6>,
      <7, 5, 8>,
      <7, 8, 9>,
      <10, 8, 11>,
      <10, 11, 12>,
      <13, 11, 14>,
      <13, 14, 15>,
      <16, 14, 1>,
      <16, 1, 17>,
      <18, 18, 18>,
      <18, 18, 18>,
      <18, 18, 18>,
      <18, 18, 18>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <20, 21, 22>,
      <20, 22, 23>,
      <23, 24, 25>,
      <23, 25, 26>,
      <26, 27, 28>,
      <26, 28, 29>,
      <29, 30, 31>,
      <29, 31, 32>,
      <32, 33, 34>,
      <32, 34, 35>,
      <35, 36, 37>,
      <35, 37, 20>,
      <18, 18, 18>,
      <18, 18, 18>,
      <19, 19, 19>,
      <19, 19, 19>,
      <38, 38, 38>,
      <38, 38, 38>,
      <39, 39, 39>,
      <39, 39, 39>,
      <40, 40, 40>,
      <40, 40, 40>,
      <41, 41, 41>,
      <41, 41, 41>
   }
 
   uv_indices { 
      176, 
      <257, 255, 253>,
      <257, 253, 252>,
      <252, 253, 251>,
      <252, 251, 250>,
      <250, 251, 248>,
      <250, 248, 249>,
      <240, 241, 242>,
      <240, 242, 243>,
      <243, 242, 244>,
      <243, 244, 245>,
      <245, 244, 246>,
      <245, 246, 247>,
      <258, 259, 260>,
      <258, 260, 261>,
      <258, 261, 262>,
      <258, 262, 263>,
      <269, 270, 271>,
      <269, 271, 272>,
      <269, 272, 262>,
      <269, 262, 273>,
      <246, 247, 245>,
      <246, 245, 244>,
      <244, 245, 243>,
      <244, 243, 242>,
      <242, 243, 240>,
      <242, 240, 241>,
      <248, 249, 250>,
      <248, 250, 251>,
      <251, 250, 252>,
      <251, 252, 253>,
      <253, 252, 254>,
      <253, 254, 255>,
      <233, 234, 239>,
      <233, 239, 236>,
      <233, 234, 238>,
      <233, 238, 236>,
      <213, 214, 215>,
      <213, 215, 216>,
      <225, 226, 227>,
      <225, 227, 228>,
      <225, 226, 227>,
      <225, 227, 228>,
      <217, 218, 219>,
      <217, 219, 220>,
      <257, 255, 253>,
      <257, 253, 252>,
      <252, 253, 251>,
      <252, 251, 250>,
      <250, 251, 248>,
      <250, 248, 249>,
      <240, 241, 242>,
      <240, 242, 243>,
      <243, 242, 244>,
      <243, 244, 245>,
      <245, 244, 246>,
      <245, 246, 247>,
      <258, 259, 260>,
      <258, 260, 261>,
      <258, 261, 262>,
      <258, 262, 263>,
      <264, 265, 266>,
      <264, 266, 267>,
      <264, 267, 262>,
      <264, 262, 268>,
      <246, 247, 245>,
      <246, 245, 244>,
      <244, 245, 243>,
      <244, 243, 242>,
      <242, 243, 240>,
      <242, 240, 241>,
      <248, 249, 250>,
      <248, 250, 251>,
      <251, 250, 252>,
      <251, 252, 253>,
      <253, 252, 256>,
      <253, 256, 255>,
      <233, 234, 239>,
      <233, 239, 236>,
      <233, 234, 237>,
      <233, 237, 236>,
      <209, 210, 211>,
      <209, 211, 212>,
      <217, 218, 219>,
      <217, 219, 220>,
      <217, 218, 219>,
      <217, 219, 220>,
      <209, 210, 211>,
      <209, 211, 212>,
      <257, 255, 253>,
      <257, 253, 252>,
      <252, 253, 251>,
      <252, 251, 250>,
      <250, 251, 248>,
      <250, 248, 249>,
      <240, 241, 242>,
      <240, 242, 243>,
      <243, 242, 244>,
      <243, 244, 245>,
      <245, 244, 246>,
      <245, 246, 247>,
      <258, 259, 260>,
      <258, 260, 261>,
      <258, 261, 262>,
      <258, 262, 263>,
      <264, 265, 266>,
      <264, 266, 267>,
      <264, 267, 262>,
      <264, 262, 268>,
      <246, 247, 245>,
      <246, 245, 244>,
      <244, 245, 243>,
      <244, 243, 242>,
      <242, 243, 240>,
      <242, 240, 241>,
      <248, 249, 250>,
      <248, 250, 251>,
      <251, 250, 252>,
      <251, 252, 253>,
      <253, 252, 254>,
      <253, 254, 255>,
      <233, 234, 239>,
      <233, 239, 236>,
      <233, 234, 239>,
      <233, 239, 236>,
      <213, 214, 215>,
      <213, 215, 216>,
      <229, 230, 231>,
      <229, 231, 232>,
      <229, 230, 231>,
      <229, 231, 232>,
      <213, 214, 215>,
      <213, 215, 216>,
      <257, 255, 253>,
      <257, 253, 252>,
      <252, 253, 251>,
      <252, 251, 250>,
      <250, 251, 248>,
      <250, 248, 249>,
      <240, 241, 242>,
      <240, 242, 243>,
      <243, 242, 244>,
      <243, 244, 245>,
      <245, 244, 246>,
      <245, 246, 247>,
      <258, 259, 260>,
      <258, 260, 261>,
      <258, 261, 262>,
      <258, 262, 263>,
      <269, 270, 271>,
      <269, 271, 272>,
      <269, 272, 262>,
      <269, 262, 273>,
      <246, 247, 245>,
      <246, 245, 244>,
      <244, 245, 243>,
      <244, 243, 242>,
      <242, 243, 240>,
      <242, 240, 241>,
      <248, 249, 250>,
      <248, 250, 251>,
      <251, 250, 252>,
      <251, 252, 253>,
      <253, 252, 256>,
      <253, 256, 255>,
      <233, 234, 239>,
      <233, 239, 236>,
      <233, 234, 235>,
      <233, 235, 236>,
      <213, 214, 215>,
      <213, 215, 216>,
      <221, 222, 223>,
      <221, 223, 224>,
      <221, 222, 223>,
      <221, 223, 224>,
      <213, 214, 215>,
      <213, 215, 216>
   }
   uv_mapping
}
 
// Shock_Cyl_b21
mesh2 {
 
   vertex_vectors { 
      12, 
      <4.465685E+00, 3.393224E+00, -2.663008E+01>,
      <4.24918E+00, 3.393224E+00, -2.648321E+01>,
      <4.24918E+00, 3.393224E+00, -2.618946E+01>,
      <4.465685E+00, 3.393224E+00, -2.604258E+01>,
      <4.68219E+00, 3.393224E+00, -2.618946E+01>,
      <4.68219E+00, 3.393224E+00, -2.648321E+01>,
      <4.465685E+00, 2.218224E+00, -2.663008E+01>,
      <4.24918E+00, 2.218224E+00, -2.648321E+01>,
      <4.24918E+00, 2.218224E+00, -2.618946E+01>,
      <4.465685E+00, 2.218224E+00, -2.604258E+01>,
      <4.68219E+00, 2.218224E+00, -2.618946E+01>,
      <4.68219E+00, 2.218224E+00, -2.648321E+01>
   }
 
   normal_vectors { 
      10, 
      <-5.000014E-01, -3.166497E-08, -8.660246E-01>,
      <-8.660257E-01, -3.166497E-08, -4.999994E-01>,
      <-8.660261E-01, -3.166497E-08, 4.999989E-01>,
      <-5.00002E-01, -3.166497E-08, 8.660242E-01>,
      <5.000013E-01, -3.166497E-08, 8.660247E-01>,
      <8.660257E-01, -3.166497E-08, 4.999995E-01>,
      <8.66026E-01, -3.166497E-08, -4.99999E-01>,
      <5.000018E-01, -3.166497E-08, -8.660244E-01>,
      <4.280104E-16, -1.00E+00, -4.31381E-16>,
      <-4.280104E-16, 9.999999E-01, 4.31381E-16>
   }
 
   uv_vectors { 
      25, 
      <0.00E+00, 0.00E+00>,
      <-1.09625E-01, 1.865001E-01>,
      <-1.09625E-01, 1.152E-01>,
      <-1.205416E-01, 1.152E-01>,
      <-1.205416E-01, 1.865001E-01>,
      <-6.595832E-02, 1.152E-01>,
      <-6.595832E-02, 1.865001E-01>,
      <-7.687497E-02, 1.152E-01>,
      <-7.687497E-02, 1.865001E-01>,
      <-8.779162E-02, 1.152E-01>,
      <-8.779162E-02, 1.865001E-01>,
      <-9.870833E-02, 1.152E-01>,
      <-9.870833E-02, 1.865001E-01>,
      <-3.888E-01, 1.00E+00>,
      <-3.888E-01, 7.091E-01>,
      <-4.266666E-01, 7.091E-01>,
      <-4.266666E-01, 1.00E+00>,
      <-2.373334E-01, 7.091E-01>,
      <-2.373334E-01, 1.00E+00>,
      <-2.751999E-01, 7.091E-01>,
      <-2.751999E-01, 1.00E+00>,
      <-3.130665E-01, 7.091E-01>,
      <-3.130665E-01, 1.00E+00>,
      <-3.509334E-01, 7.091E-01>,
      <-3.509334E-01, 1.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      20, 
      <0, 6, 7>, 0,
      <0, 7, 1>, 0,
      <1, 7, 8>, 0,
      <1, 8, 2>, 0,
      <2, 8, 9>, 0,
      <2, 9, 3>, 0,
      <3, 9, 10>, 0,
      <3, 10, 4>, 0,
      <4, 10, 11>, 0,
      <4, 11, 5>, 0,
      <5, 11, 6>, 0,
      <5, 6, 0>, 0,
      <6, 11, 10>, 0,
      <6, 10, 9>, 0,
      <6, 9, 8>, 0,
      <6, 8, 7>, 0,
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <0, 3, 4>, 0,
      <0, 4, 5>, 0
   }
 
   normal_indices { 
      20, 
      <0, 0, 1>,
      <0, 1, 1>,
      <1, 1, 2>,
      <1, 2, 2>,
      <2, 2, 3>,
      <2, 3, 3>,
      <4, 4, 5>,
      <4, 5, 5>,
      <5, 5, 6>,
      <5, 6, 6>,
      <6, 6, 7>,
      <6, 7, 7>,
      <8, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>
   }
 
   uv_indices { 
      20, 
      <13, 14, 15>,
      <13, 15, 16>,
      <16, 15, 17>,
      <16, 17, 18>,
      <18, 17, 19>,
      <18, 19, 20>,
      <20, 19, 21>,
      <20, 21, 22>,
      <22, 21, 23>,
      <22, 23, 24>,
      <24, 23, 14>,
      <24, 14, 13>,
      <14, 23, 21>,
      <14, 21, 19>,
      <14, 19, 17>,
      <14, 17, 15>,
      <13, 16, 18>,
      <13, 18, 20>,
      <13, 20, 22>,
      <13, 22, 24>
   }
   uv_mapping
}
 
// Shock_Cube_b21
mesh2 {
 
   vertex_vectors { 
      24, 
      <4.565684E+00, 2.210607E+00, -2.670857E+01>,
      <4.565684E+00, 3.268107E+00, -2.670857E+01>,
      <4.365687E+00, 3.268107E+00, -2.670857E+01>,
      <4.365687E+00, 2.210607E+00, -2.670857E+01>,
      <4.365687E+00, 2.210607E+00, -2.69349E+01>,
      <4.365687E+00, 3.268107E+00, -2.69349E+01>,
      <4.565684E+00, 3.268107E+00, -2.69349E+01>,
      <4.565684E+00, 2.210607E+00, -2.69349E+01>,
      <4.365685E+00, 2.02356E+00, -2.65824E+01>,
      <4.365685E+00, 2.02356E+00, -2.69349E+01>,
      <4.565686E+00, 2.02356E+00, -2.69349E+01>,
      <4.565685E+00, 2.02356E+00, -2.65824E+01>,
      <4.565685E+00, 2.02356E+00, -2.62299E+01>,
      <4.565683E+00, 2.210607E+00, -2.62299E+01>,
      <4.365686E+00, 2.210607E+00, -2.62299E+01>,
      <4.365685E+00, 2.02356E+00, -2.62299E+01>,
      <4.365685E+00, 2.02356E+00, -2.68174E+01>,
      <4.565686E+00, 2.02356E+00, -2.68174E+01>,
      <4.365687E+00, 2.14106E+00, -2.69349E+01>,
      <4.565684E+00, 2.14106E+00, -2.69349E+01>,
      <4.565683E+00, 2.14106E+00, -2.62299E+01>,
      <4.365686E+00, 2.14106E+00, -2.62299E+01>,
      <4.365685E+00, 2.02356E+00, -2.63474E+01>,
      <4.565685E+00, 2.02356E+00, -2.63474E+01>
   }
 
   normal_vectors { 
      10, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-4.280104E-16, 9.999999E-01, 4.31381E-16>,
      <4.280104E-16, -1.00E+00, -4.31381E-16>,
      <1.246954E-07, -9.238779E-01, -3.826876E-01>,
      <3.010387E-07, -3.826793E-01, -9.238812E-01>,
      <-3.010387E-07, -3.826795E-01, 9.238812E-01>,
      <-1.246954E-07, -9.23878E-01, 3.826874E-01>
   }
 
   uv_vectors { 
      92, 
      <0.00E+00, 0.00E+00>,
      <-2.781919E-01, 4.623127E-02>,
      <-2.781919E-01, 6.449997E-02>,
      <-2.832E-01, 4.623127E-02>,
      <-2.832E-01, 6.449997E-02>,
      <-2.676E-01, 4.623127E-02>,
      <-2.754E-01, 4.299998E-02>,
      <-2.806001E-01, 4.299998E-02>,
      <-2.832E-01, 4.502982E-02>,
      <-2.676E-01, 4.502982E-02>,
      <-2.702E-01, 4.299998E-02>,
      <-2.04565E-01, 1.769602E-02>,
      <-2.04565E-01, 3.52E-02>,
      <-2.08E-01, 1.769602E-02>,
      <-2.08E-01, 3.52E-02>,
      <-1.973E-01, 1.769602E-02>,
      <-2.0265E-01, 1.459998E-02>,
      <-2.062167E-01, 1.459998E-02>,
      <-2.08E-01, 1.654488E-02>,
      <-1.973E-01, 1.654488E-02>,
      <-1.990833E-01, 1.459998E-02>,
      <-2.795769E-01, 1.318E-01>,
      <-2.932338E-01, 1.807E-01>,
      <-3.003542E-01, 1.807E-01>,
      <-3.003542E-01, 1.625181E-01>,
      <-2.979939E-01, 1.318E-01>,
      <-2.588001E-01, 1.807E-01>,
      <-2.611606E-01, 1.318E-01>,
      <-2.588001E-01, 1.625181E-01>,
      <-2.588001E-01, 1.318E-01>,
      <-3.003542E-01, 1.318E-01>,
      <-3.218501E-01, 1.328E-01>,
      <-3.218501E-01, 1.777E-01>,
      <-3.665498E-01, 1.777E-01>,
      <-3.665498E-01, 1.328E-01>,
      <-3.207791E-01, 1.328E-01>,
      <-3.207791E-01, 1.777E-01>,
      <-3.676208E-01, 1.777E-01>,
      <-3.676208E-01, 1.328E-01>,
      <-3.206382E-01, 1.777E-01>,
      <-3.677617E-01, 1.777E-01>,
      <-3.677617E-01, 1.363867E-01>,
      <-3.206382E-01, 1.363867E-01>,
      <-3.665498E-01, 1.328E-01>,
      <-3.25088E-01, 1.552498E-01>,
      <-3.25088E-01, 1.702168E-01>,
      <-3.633119E-01, 1.702168E-01>,
      <-3.633119E-01, 1.552498E-01>,
      <-3.207791E-01, 1.777E-01>,
      <-3.676208E-01, 1.777E-01>,
      <-3.25088E-01, 1.402832E-01>,
      <-3.633119E-01, 1.402832E-01>,
      <-3.676208E-01, 1.328E-01>,
      <-3.207791E-01, 1.328E-01>,
      <-3.258846E-01, 1.648718E-01>,
      <-3.243587E-01, 1.777E-01>,
      <-3.640411E-01, 1.777E-01>,
      <-3.625149E-01, 1.648718E-01>,
      <-3.666089E-01, 1.342221E-01>,
      <-3.21791E-01, 1.342221E-01>,
      <-2.62165E-01, 1.299E-01>,
      <-2.62165E-01, 1.797E-01>,
      <-3.104998E-01, 1.797E-01>,
      <-3.104998E-01, 1.299E-01>,
      <-2.649105E-01, 1.299E-01>,
      <-2.62165E-01, 1.611837E-01>,
      <-2.704474E-01, 1.797E-01>,
      <-2.863327E-01, 1.299E-01>,
      <-3.104998E-01, 1.611837E-01>,
      <-3.077542E-01, 1.299E-01>,
      <-8.427014E-01, 4.931485E-02>,
      <-8.427014E-01, 2.371E-01>,
      <-9.874986E-01, 2.371E-01>,
      <-9.874986E-01, 4.931485E-02>,
      <-9.875E-01, 1.609999E-02>,
      <-8.427E-01, 1.609999E-02>,
      <-9.874986E-01, 3.696501E-02>,
      <-8.427014E-01, 3.696501E-02>,
      <-9.925E-01, 2.954225E-01>,
      <-9.925E-01, 4.906E-01>,
      <-9.399793E-01, 4.906E-01>,
      <-9.399793E-01, 2.954225E-01>,
      <-9.652339E-01, 2.609E-01>,
      <-9.925E-01, 2.825865E-01>,
      <-9.106995E-01, 2.609E-01>,
      <-8.289E-01, 2.825865E-01>,
      <-8.561661E-01, 2.609E-01>,
      <-8.289E-01, 2.954225E-01>,
      <-8.439E-01, 1.120002E-02>,
      <-8.439E-01, 2.371E-01>,
      <-9.80E-01, 2.371E-01>,
      <-9.80E-01, 1.120002E-02>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      36, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <13, 0, 3>, 0,
      <13, 3, 14>, 0,
      <8, 16, 17>, 0,
      <8, 17, 11>, 0,
      <18, 4, 7>, 0,
      <18, 7, 19>, 0,
      <17, 16, 18>, 0,
      <17, 18, 19>, 0,
      <8, 3, 4>, 0,
      <8, 4, 18>, 0,
      <8, 18, 16>, 0,
      <17, 19, 7>, 0,
      <17, 7, 0>, 0,
      <17, 0, 11>, 0,
      <20, 13, 14>, 0,
      <20, 14, 21>, 0,
      <22, 8, 11>, 0,
      <22, 11, 23>, 0,
      <20, 21, 22>, 0,
      <20, 22, 23>, 0,
      <20, 23, 11>, 0,
      <20, 11, 0>, 0,
      <20, 0, 13>, 0,
      <14, 3, 8>, 0,
      <14, 8, 22>, 0,
      <14, 22, 21>, 0
   }
 
   normal_indices { 
      36, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <6, 6, 7>,
      <6, 7, 7>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <8, 0, 0>,
      <8, 0, 8>,
      <9, 5, 5>,
      <9, 5, 9>,
      <8, 8, 9>,
      <8, 9, 9>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 2>
   }
 
   uv_indices { 
      36, 
      <88, 89, 90>,
      <88, 90, 91>,
      <73, 72, 71>,
      <73, 71, 70>,
      <73, 72, 72>,
      <73, 72, 73>,
      <78, 79, 80>,
      <78, 80, 81>,
      <71, 71, 72>,
      <71, 72, 72>,
      <88, 89, 90>,
      <88, 90, 91>,
      <74, 74, 75>,
      <74, 75, 75>,
      <76, 73, 70>,
      <76, 70, 77>,
      <75, 74, 76>,
      <75, 76, 77>,
      <74, 73, 73>,
      <74, 73, 76>,
      <74, 76, 74>,
      <82, 83, 78>,
      <82, 78, 81>,
      <82, 81, 84>,
      <88, 89, 90>,
      <88, 90, 91>,
      <74, 74, 75>,
      <74, 75, 75>,
      <77, 76, 74>,
      <77, 74, 75>,
      <85, 86, 84>,
      <85, 84, 81>,
      <85, 81, 87>,
      <73, 73, 74>,
      <73, 74, 74>,
      <73, 74, 76>
   }
   uv_mapping
}
 
// Shock_Cyl_b22
mesh2 {
 
   vertex_vectors { 
      12, 
      <4.465681E+00, 3.393224E+00, -1.3346E+01>,
      <4.682186E+00, 3.393224E+00, -1.349287E+01>,
      <4.682186E+00, 3.393224E+00, -1.378662E+01>,
      <4.465681E+00, 3.393224E+00, -1.39335E+01>,
      <4.249176E+00, 3.393224E+00, -1.378662E+01>,
      <4.249176E+00, 3.393224E+00, -1.349287E+01>,
      <4.465681E+00, 2.218224E+00, -1.3346E+01>,
      <4.682186E+00, 2.218224E+00, -1.349287E+01>,
      <4.682186E+00, 2.218224E+00, -1.378662E+01>,
      <4.465681E+00, 2.218224E+00, -1.39335E+01>,
      <4.249176E+00, 2.218224E+00, -1.378662E+01>,
      <4.249176E+00, 2.218224E+00, -1.349287E+01>
   }
 
   normal_vectors { 
      10, 
      <5.000013E-01, -3.166497E-08, 8.660247E-01>,
      <8.660257E-01, -3.166497E-08, 4.999995E-01>,
      <8.66026E-01, -3.166497E-08, -4.99999E-01>,
      <5.000018E-01, -3.166497E-08, -8.660244E-01>,
      <-5.000014E-01, -3.166497E-08, -8.660246E-01>,
      <-8.660257E-01, -3.166497E-08, -4.999994E-01>,
      <-8.660261E-01, -3.166497E-08, 4.999989E-01>,
      <-5.00002E-01, -3.166497E-08, 8.660242E-01>,
      <4.280104E-16, -1.00E+00, -4.31381E-16>,
      <-4.280104E-16, 9.999999E-01, 4.31381E-16>
   }
 
   uv_vectors { 
      25, 
      <0.00E+00, 0.00E+00>,
      <-7.687497E-02, 1.865001E-01>,
      <-7.687497E-02, 1.152E-01>,
      <-8.779162E-02, 1.152E-01>,
      <-8.779162E-02, 1.865001E-01>,
      <-9.870833E-02, 1.152E-01>,
      <-9.870833E-02, 1.865001E-01>,
      <-1.09625E-01, 1.152E-01>,
      <-1.09625E-01, 1.865001E-01>,
      <-1.205416E-01, 1.152E-01>,
      <-1.205416E-01, 1.865001E-01>,
      <-6.595832E-02, 1.152E-01>,
      <-6.595832E-02, 1.865001E-01>,
      <-2.751999E-01, 1.00E+00>,
      <-2.751999E-01, 7.091E-01>,
      <-3.130665E-01, 7.091E-01>,
      <-3.130665E-01, 1.00E+00>,
      <-3.509334E-01, 7.091E-01>,
      <-3.509334E-01, 1.00E+00>,
      <-3.888E-01, 7.091E-01>,
      <-3.888E-01, 1.00E+00>,
      <-4.266666E-01, 7.091E-01>,
      <-4.266666E-01, 1.00E+00>,
      <-2.373334E-01, 7.091E-01>,
      <-2.373334E-01, 1.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      20, 
      <0, 6, 7>, 0,
      <0, 7, 1>, 0,
      <1, 7, 8>, 0,
      <1, 8, 2>, 0,
      <2, 8, 9>, 0,
      <2, 9, 3>, 0,
      <3, 9, 10>, 0,
      <3, 10, 4>, 0,
      <4, 10, 11>, 0,
      <4, 11, 5>, 0,
      <5, 11, 6>, 0,
      <5, 6, 0>, 0,
      <6, 11, 10>, 0,
      <6, 10, 9>, 0,
      <6, 9, 8>, 0,
      <6, 8, 7>, 0,
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <0, 3, 4>, 0,
      <0, 4, 5>, 0
   }
 
   normal_indices { 
      20, 
      <0, 0, 1>,
      <0, 1, 1>,
      <1, 1, 2>,
      <1, 2, 2>,
      <2, 2, 3>,
      <2, 3, 3>,
      <4, 4, 5>,
      <4, 5, 5>,
      <5, 5, 6>,
      <5, 6, 6>,
      <6, 6, 7>,
      <6, 7, 7>,
      <8, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>
   }
 
   uv_indices { 
      20, 
      <13, 14, 15>,
      <13, 15, 16>,
      <16, 15, 17>,
      <16, 17, 18>,
      <18, 17, 19>,
      <18, 19, 20>,
      <20, 19, 21>,
      <20, 21, 22>,
      <22, 21, 23>,
      <22, 23, 24>,
      <24, 23, 14>,
      <24, 14, 13>,
      <14, 23, 21>,
      <14, 21, 19>,
      <14, 19, 17>,
      <14, 17, 15>,
      <13, 16, 18>,
      <13, 18, 20>,
      <13, 20, 22>,
      <13, 22, 24>
   }
   uv_mapping
}
 
// Shock_Cube_b22
mesh2 {
 
   vertex_vectors { 
      24, 
      <4.365682E+00, 2.210607E+00, -1.32675E+01>,
      <4.365682E+00, 3.268107E+00, -1.32675E+01>,
      <4.565679E+00, 3.268107E+00, -1.32675E+01>,
      <4.565679E+00, 2.210607E+00, -1.32675E+01>,
      <4.565679E+00, 2.210607E+00, -1.304118E+01>,
      <4.565679E+00, 3.268107E+00, -1.304118E+01>,
      <4.365682E+00, 3.268107E+00, -1.304118E+01>,
      <4.365682E+00, 2.210607E+00, -1.304118E+01>,
      <4.565681E+00, 2.02356E+00, -1.339368E+01>,
      <4.565681E+00, 2.02356E+00, -1.304118E+01>,
      <4.36568E+00, 2.02356E+00, -1.304118E+01>,
      <4.36568E+00, 2.02356E+00, -1.339368E+01>,
      <4.365681E+00, 2.02356E+00, -1.374618E+01>,
      <4.365683E+00, 2.210607E+00, -1.374618E+01>,
      <4.56568E+00, 2.210607E+00, -1.374618E+01>,
      <4.565681E+00, 2.02356E+00, -1.374618E+01>,
      <4.565681E+00, 2.02356E+00, -1.315868E+01>,
      <4.36568E+00, 2.02356E+00, -1.315868E+01>,
      <4.565679E+00, 2.14106E+00, -1.304118E+01>,
      <4.365682E+00, 2.14106E+00, -1.304118E+01>,
      <4.365683E+00, 2.14106E+00, -1.374618E+01>,
      <4.56568E+00, 2.14106E+00, -1.374618E+01>,
      <4.565681E+00, 2.02356E+00, -1.362868E+01>,
      <4.365681E+00, 2.02356E+00, -1.362868E+01>
   }
 
   normal_vectors { 
      10, 
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <-4.280104E-16, 9.999999E-01, 4.31381E-16>,
      <4.280104E-16, -1.00E+00, -4.31381E-16>,
      <-1.246952E-07, -9.238783E-01, 3.826867E-01>,
      <-3.010386E-07, -3.826802E-01, 9.238809E-01>,
      <3.010386E-07, -3.826802E-01, -9.238809E-01>,
      <1.246952E-07, -9.238783E-01, -3.826867E-01>
   }
 
   uv_vectors { 
      94, 
      <0.00E+00, 0.00E+00>,
      <-2.726081E-01, 4.623127E-02>,
      <-2.726081E-01, 6.449997E-02>,
      <-2.676E-01, 4.623127E-02>,
      <-2.676E-01, 6.449997E-02>,
      <-2.832E-01, 4.623127E-02>,
      <-2.754001E-01, 4.299998E-02>,
      <-2.702E-01, 4.299998E-02>,
      <-2.676E-01, 4.502982E-02>,
      <-2.832E-01, 4.502982E-02>,
      <-2.806001E-01, 4.299998E-02>,
      <-2.00735E-01, 1.769602E-02>,
      <-2.00735E-01, 3.52E-02>,
      <-1.973E-01, 1.769602E-02>,
      <-1.973E-01, 3.52E-02>,
      <-2.08E-01, 1.769602E-02>,
      <-2.0265E-01, 1.459998E-02>,
      <-1.990833E-01, 1.459998E-02>,
      <-1.973E-01, 1.654488E-02>,
      <-2.08E-01, 1.654488E-02>,
      <-2.062167E-01, 1.459998E-02>,
      <-2.650457E-01, 1.318E-01>,
      <-2.650457E-01, 1.807E-01>,
      <-3.065999E-01, 1.807E-01>,
      <-3.065999E-01, 1.318E-01>,
      <-2.674062E-01, 1.318E-01>,
      <-2.650457E-01, 1.625181E-01>,
      <-2.721663E-01, 1.807E-01>,
      <-2.858232E-01, 1.318E-01>,
      <-3.065999E-01, 1.625181E-01>,
      <-3.042395E-01, 1.318E-01>,
      <-3.633119E-01, 1.552501E-01>,
      <-3.633119E-01, 1.402832E-01>,
      <-3.25088E-01, 1.402832E-01>,
      <-3.25088E-01, 1.552501E-01>,
      <-3.676208E-01, 1.328E-01>,
      <-3.207791E-01, 1.328E-01>,
      <-3.633119E-01, 1.702168E-01>,
      <-3.25088E-01, 1.702168E-01>,
      <-3.207791E-01, 1.777E-01>,
      <-3.676208E-01, 1.777E-01>,
      <-3.218501E-01, 1.328E-01>,
      <-3.218501E-01, 1.777E-01>,
      <-3.665498E-01, 1.777E-01>,
      <-3.665498E-01, 1.328E-01>,
      <-3.673387E-01, 1.35506E-01>,
      <-3.210612E-01, 1.35506E-01>,
      <-3.210618E-01, 1.777E-01>,
      <-3.67338E-01, 1.777E-01>,
      <-3.258846E-01, 1.648718E-01>,
      <-3.243587E-01, 1.777E-01>,
      <-3.640411E-01, 1.777E-01>,
      <-3.625149E-01, 1.648718E-01>,
      <-3.666089E-01, 1.342221E-01>,
      <-3.21791E-01, 1.342221E-01>,
      <-3.255043E-01, 1.299E-01>,
      <-3.255043E-01, 1.787E-01>,
      <-3.658957E-01, 1.787E-01>,
      <-3.658957E-01, 1.299E-01>,
      <-2.790673E-01, 1.299E-01>,
      <-2.949527E-01, 1.797E-01>,
      <-3.032351E-01, 1.797E-01>,
      <-3.032351E-01, 1.611837E-01>,
      <-3.004895E-01, 1.299E-01>,
      <-2.549002E-01, 1.797E-01>,
      <-2.576458E-01, 1.299E-01>,
      <-2.549002E-01, 1.611837E-01>,
      <-2.549002E-01, 1.299E-01>,
      <-3.032351E-01, 1.299E-01>,
      <-3.638663E-01, 1.768E-01>,
      <-3.638663E-01, 1.279E-01>,
      <-3.216336E-01, 1.279E-01>,
      <-3.216336E-01, 1.768E-01>,
      <-8.427014E-01, 4.931485E-02>,
      <-8.427014E-01, 2.371E-01>,
      <-9.874986E-01, 2.371E-01>,
      <-9.874986E-01, 4.931485E-02>,
      <-9.875E-01, 1.609999E-02>,
      <-8.427E-01, 1.609999E-02>,
      <-9.874986E-01, 3.696501E-02>,
      <-8.427014E-01, 3.696501E-02>,
      <-9.925E-01, 2.954225E-01>,
      <-9.925E-01, 4.906E-01>,
      <-9.399793E-01, 4.906E-01>,
      <-9.399793E-01, 2.954225E-01>,
      <-9.652339E-01, 2.609E-01>,
      <-9.925E-01, 2.825865E-01>,
      <-9.106995E-01, 2.609E-01>,
      <-8.289E-01, 2.825865E-01>,
      <-8.561661E-01, 2.609E-01>,
      <-8.289E-01, 2.954225E-01>,
      <-8.814207E-01, 2.954225E-01>,
      <-8.814207E-01, 4.906E-01>,
      <-8.289E-01, 4.906E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      36, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <13, 0, 3>, 0,
      <13, 3, 14>, 0,
      <8, 16, 17>, 0,
      <8, 17, 11>, 0,
      <18, 4, 7>, 0,
      <18, 7, 19>, 0,
      <17, 16, 18>, 0,
      <17, 18, 19>, 0,
      <8, 3, 4>, 0,
      <8, 4, 18>, 0,
      <8, 18, 16>, 0,
      <17, 19, 7>, 0,
      <17, 7, 0>, 0,
      <17, 0, 11>, 0,
      <20, 13, 14>, 0,
      <20, 14, 21>, 0,
      <22, 8, 11>, 0,
      <22, 11, 23>, 0,
      <20, 21, 22>, 0,
      <20, 22, 23>, 0,
      <20, 23, 11>, 0,
      <20, 11, 0>, 0,
      <20, 0, 13>, 0,
      <14, 3, 8>, 0,
      <14, 8, 22>, 0,
      <14, 22, 21>, 0
   }
 
   normal_indices { 
      36, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <6, 6, 7>,
      <6, 7, 7>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <8, 0, 0>,
      <8, 0, 8>,
      <9, 5, 5>,
      <9, 5, 9>,
      <8, 8, 9>,
      <8, 9, 9>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 2>
   }
 
   uv_indices { 
      36, 
      <73, 74, 75>,
      <73, 75, 76>,
      <76, 75, 74>,
      <76, 74, 73>,
      <91, 92, 93>,
      <91, 93, 90>,
      <81, 82, 83>,
      <81, 83, 84>,
      <74, 74, 75>,
      <74, 75, 75>,
      <73, 73, 76>,
      <73, 76, 76>,
      <77, 77, 78>,
      <77, 78, 78>,
      <79, 76, 73>,
      <79, 73, 80>,
      <78, 77, 79>,
      <78, 79, 80>,
      <87, 91, 90>,
      <87, 90, 88>,
      <87, 88, 89>,
      <85, 86, 81>,
      <85, 81, 84>,
      <85, 84, 87>,
      <80, 73, 76>,
      <80, 76, 79>,
      <77, 77, 78>,
      <77, 78, 78>,
      <80, 79, 77>,
      <80, 77, 78>,
      <88, 89, 87>,
      <88, 87, 84>,
      <88, 84, 90>,
      <81, 91, 87>,
      <81, 87, 85>,
      <81, 85, 86>
   }
   uv_mapping
}
 
// Shock_Cyl_b23
mesh2 {
 
   vertex_vectors { 
      12, 
      <-1.823663E+00, 3.393224E+00, -2.663008E+01>,
      <-2.040169E+00, 3.393224E+00, -2.648321E+01>,
      <-2.040169E+00, 3.393224E+00, -2.618946E+01>,
      <-1.823664E+00, 3.393224E+00, -2.604259E+01>,
      <-1.607159E+00, 3.393224E+00, -2.618946E+01>,
      <-1.607158E+00, 3.393224E+00, -2.648321E+01>,
      <-1.823663E+00, 2.218224E+00, -2.663008E+01>,
      <-2.040169E+00, 2.218224E+00, -2.648321E+01>,
      <-2.040169E+00, 2.218224E+00, -2.618946E+01>,
      <-1.823664E+00, 2.218224E+00, -2.604259E+01>,
      <-1.607159E+00, 2.218224E+00, -2.618946E+01>,
      <-1.607158E+00, 2.218224E+00, -2.648321E+01>
   }
 
   normal_vectors { 
      10, 
      <-5.000013E-01, -3.166497E-08, -8.660247E-01>,
      <-8.660257E-01, -3.166497E-08, -4.999995E-01>,
      <-8.66026E-01, -3.166497E-08, 4.99999E-01>,
      <-5.000018E-01, -3.166497E-08, 8.660244E-01>,
      <5.000014E-01, -3.166497E-08, 8.660246E-01>,
      <8.660257E-01, -3.166497E-08, 4.999994E-01>,
      <8.660261E-01, -3.166497E-08, -4.999989E-01>,
      <5.00002E-01, -3.166497E-08, -8.660242E-01>,
      <4.280104E-16, -1.00E+00, -4.31381E-16>,
      <-4.280104E-16, 9.999999E-01, 4.31381E-16>
   }
 
   uv_vectors { 
      25, 
      <0.00E+00, 0.00E+00>,
      <-7.687497E-02, 1.865001E-01>,
      <-7.687497E-02, 1.152E-01>,
      <-8.779162E-02, 1.152E-01>,
      <-8.779162E-02, 1.865001E-01>,
      <-9.870833E-02, 1.152E-01>,
      <-9.870833E-02, 1.865001E-01>,
      <-1.09625E-01, 1.152E-01>,
      <-1.09625E-01, 1.865001E-01>,
      <-1.205416E-01, 1.152E-01>,
      <-1.205416E-01, 1.865001E-01>,
      <-6.595832E-02, 1.152E-01>,
      <-6.595832E-02, 1.865001E-01>,
      <-2.751999E-01, 1.00E+00>,
      <-2.751999E-01, 7.091E-01>,
      <-3.130665E-01, 7.091E-01>,
      <-3.130665E-01, 1.00E+00>,
      <-3.509334E-01, 7.091E-01>,
      <-3.509334E-01, 1.00E+00>,
      <-3.888E-01, 7.091E-01>,
      <-3.888E-01, 1.00E+00>,
      <-4.266666E-01, 7.091E-01>,
      <-4.266666E-01, 1.00E+00>,
      <-2.373334E-01, 7.091E-01>,
      <-2.373334E-01, 1.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      20, 
      <0, 6, 7>, 0,
      <0, 7, 1>, 0,
      <1, 7, 8>, 0,
      <1, 8, 2>, 0,
      <2, 8, 9>, 0,
      <2, 9, 3>, 0,
      <3, 9, 10>, 0,
      <3, 10, 4>, 0,
      <4, 10, 11>, 0,
      <4, 11, 5>, 0,
      <5, 11, 6>, 0,
      <5, 6, 0>, 0,
      <6, 11, 10>, 0,
      <6, 10, 9>, 0,
      <6, 9, 8>, 0,
      <6, 8, 7>, 0,
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <0, 3, 4>, 0,
      <0, 4, 5>, 0
   }
 
   normal_indices { 
      20, 
      <0, 0, 1>,
      <0, 1, 1>,
      <1, 1, 2>,
      <1, 2, 2>,
      <2, 2, 3>,
      <2, 3, 3>,
      <4, 4, 5>,
      <4, 5, 5>,
      <5, 5, 6>,
      <5, 6, 6>,
      <6, 6, 7>,
      <6, 7, 7>,
      <8, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>
   }
 
   uv_indices { 
      20, 
      <13, 14, 15>,
      <13, 15, 16>,
      <16, 15, 17>,
      <16, 17, 18>,
      <18, 17, 19>,
      <18, 19, 20>,
      <20, 19, 21>,
      <20, 21, 22>,
      <22, 21, 23>,
      <22, 23, 24>,
      <24, 23, 14>,
      <24, 14, 13>,
      <14, 23, 21>,
      <14, 21, 19>,
      <14, 19, 17>,
      <14, 17, 15>,
      <13, 16, 18>,
      <13, 18, 20>,
      <13, 20, 22>,
      <13, 22, 24>
   }
   uv_mapping
}
 
// Shock_Cube_b23
mesh2 {
 
   vertex_vectors { 
      24, 
      <-1.723665E+00, 2.210607E+00, -2.670858E+01>,
      <-1.723665E+00, 3.268107E+00, -2.670858E+01>,
      <-1.923662E+00, 3.268107E+00, -2.670858E+01>,
      <-1.923662E+00, 2.210607E+00, -2.670858E+01>,
      <-1.923662E+00, 2.210607E+00, -2.69349E+01>,
      <-1.923662E+00, 3.268107E+00, -2.69349E+01>,
      <-1.723665E+00, 3.268107E+00, -2.69349E+01>,
      <-1.723665E+00, 2.210607E+00, -2.69349E+01>,
      <-1.923664E+00, 2.02356E+00, -2.65824E+01>,
      <-1.923664E+00, 2.02356E+00, -2.69349E+01>,
      <-1.723663E+00, 2.02356E+00, -2.69349E+01>,
      <-1.723663E+00, 2.02356E+00, -2.65824E+01>,
      <-1.723663E+00, 2.02356E+00, -2.622991E+01>,
      <-1.723665E+00, 2.210607E+00, -2.622991E+01>,
      <-1.923662E+00, 2.210607E+00, -2.622991E+01>,
      <-1.923664E+00, 2.02356E+00, -2.622991E+01>,
      <-1.923664E+00, 2.02356E+00, -2.681741E+01>,
      <-1.723663E+00, 2.02356E+00, -2.681741E+01>,
      <-1.923662E+00, 2.14106E+00, -2.69349E+01>,
      <-1.723665E+00, 2.14106E+00, -2.69349E+01>,
      <-1.723665E+00, 2.14106E+00, -2.622991E+01>,
      <-1.923662E+00, 2.14106E+00, -2.622991E+01>,
      <-1.923664E+00, 2.02356E+00, -2.634741E+01>,
      <-1.723663E+00, 2.02356E+00, -2.634741E+01>
   }
 
   normal_vectors { 
      10, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-4.280104E-16, 9.999999E-01, 4.31381E-16>,
      <4.280104E-16, -1.00E+00, -4.31381E-16>,
      <1.246954E-07, -9.238779E-01, -3.826876E-01>,
      <3.010387E-07, -3.826793E-01, -9.238812E-01>,
      <-3.010386E-07, -3.8268E-01, 9.238809E-01>,
      <-1.246952E-07, -9.238782E-01, 3.826869E-01>
   }
 
   uv_vectors { 
      87, 
      <0.00E+00, 0.00E+00>,
      <-2.00735E-01, 1.769602E-02>,
      <-2.00735E-01, 3.52E-02>,
      <-1.973E-01, 1.769602E-02>,
      <-1.973E-01, 3.52E-02>,
      <-2.08E-01, 1.769602E-02>,
      <-2.0265E-01, 1.459998E-02>,
      <-1.990833E-01, 1.459998E-02>,
      <-1.973E-01, 1.654488E-02>,
      <-2.08E-01, 1.654488E-02>,
      <-2.062167E-01, 1.459998E-02>,
      <-2.588001E-01, 1.318E-01>,
      <-2.588001E-01, 1.807E-01>,
      <-3.003542E-01, 1.807E-01>,
      <-3.003542E-01, 1.318E-01>,
      <-2.890204E-01, 1.506661E-01>,
      <-2.959947E-01, 1.806999E-01>,
      <-3.041812E-01, 1.806999E-01>,
      <-3.033229E-01, 1.695328E-01>,
      <-2.986461E-01, 1.506661E-01>,
      <-2.79395E-01, 1.506661E-01>,
      <-2.890203E-01, 1.318E-01>,
      <-2.726424E-01, 1.318E-01>,
      <-2.738599E-01, 1.806999E-01>,
      <-2.747181E-01, 1.695328E-01>,
      <-3.25088E-01, 1.552498E-01>,
      <-3.25088E-01, 1.702168E-01>,
      <-3.633119E-01, 1.702168E-01>,
      <-3.633119E-01, 1.552498E-01>,
      <-3.207791E-01, 1.777E-01>,
      <-3.676208E-01, 1.777E-01>,
      <-3.25088E-01, 1.402832E-01>,
      <-3.633119E-01, 1.402832E-01>,
      <-3.676208E-01, 1.328E-01>,
      <-3.207791E-01, 1.328E-01>,
      <-3.218501E-01, 1.328E-01>,
      <-3.218501E-01, 1.777E-01>,
      <-3.665498E-01, 1.777E-01>,
      <-3.665498E-01, 1.328E-01>,
      <-3.258846E-01, 1.648718E-01>,
      <-3.243587E-01, 1.777E-01>,
      <-3.640411E-01, 1.777E-01>,
      <-3.625149E-01, 1.648718E-01>,
      <-3.666089E-01, 1.342221E-01>,
      <-3.21791E-01, 1.342221E-01>,
      <-2.62165E-01, 1.299E-01>,
      <-2.62165E-01, 1.797E-01>,
      <-3.104998E-01, 1.797E-01>,
      <-3.104998E-01, 1.299E-01>,
      <-2.62165E-01, 1.373846E-01>,
      <-2.704474E-01, 1.797E-01>,
      <-2.704474E-01, 1.373846E-01>,
      <-2.649105E-01, 1.299E-01>,
      <-2.62165E-01, 1.346017E-01>,
      <-2.863327E-01, 1.299E-01>,
      <-3.104998E-01, 1.346017E-01>,
      <-3.077542E-01, 1.299E-01>,
      <-3.104998E-01, 1.373846E-01>,
      <-8.427014E-01, 4.931485E-02>,
      <-8.427014E-01, 2.371E-01>,
      <-9.874986E-01, 2.371E-01>,
      <-9.874986E-01, 4.931485E-02>,
      <-9.875E-01, 1.609999E-02>,
      <-8.427E-01, 1.609999E-02>,
      <-9.874986E-01, 3.696501E-02>,
      <-8.427014E-01, 3.696501E-02>,
      <-8.814207E-01, 2.954225E-01>,
      <-8.814207E-01, 4.906E-01>,
      <-8.289E-01, 4.906E-01>,
      <-8.289E-01, 2.954225E-01>,
      <-9.107005E-01, 2.609E-01>,
      <-8.289E-01, 2.825865E-01>,
      <-8.561661E-01, 2.609E-01>,
      <-9.925E-01, 2.954225E-01>,
      <-9.652339E-01, 2.609E-01>,
      <-9.925E-01, 2.825865E-01>,
      <-9.925E-01, 4.906E-01>,
      <-9.399793E-01, 4.906E-01>,
      <-9.399793E-01, 2.954225E-01>,
      <-9.652339E-01, 2.609E-01>,
      <-8.561661E-01, 2.609E-01>,
      <-8.439E-01, 1.12E-02>,
      <-8.439E-01, 2.371E-01>,
      <-9.80E-01, 2.371E-01>,
      <-9.80E-01, 1.12E-02>,
      <-8.439E-01, 1.120001E-02>,
      <-8.439E-01, 2.371E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      36, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <13, 0, 3>, 0,
      <13, 3, 14>, 0,
      <8, 16, 17>, 0,
      <8, 17, 11>, 0,
      <18, 4, 7>, 0,
      <18, 7, 19>, 0,
      <17, 16, 18>, 0,
      <17, 18, 19>, 0,
      <8, 3, 4>, 0,
      <8, 4, 18>, 0,
      <8, 18, 16>, 0,
      <17, 19, 7>, 0,
      <17, 7, 0>, 0,
      <17, 0, 11>, 0,
      <20, 13, 14>, 0,
      <20, 14, 21>, 0,
      <22, 8, 11>, 0,
      <22, 11, 23>, 0,
      <20, 21, 22>, 0,
      <20, 22, 23>, 0,
      <20, 23, 11>, 0,
      <20, 11, 0>, 0,
      <20, 0, 13>, 0,
      <14, 3, 8>, 0,
      <14, 8, 22>, 0,
      <14, 22, 21>, 0
   }
 
   normal_indices { 
      36, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <6, 6, 7>,
      <6, 7, 7>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <8, 0, 0>,
      <8, 0, 8>,
      <9, 5, 5>,
      <9, 5, 9>,
      <8, 8, 9>,
      <8, 9, 9>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 2>
   }
 
   uv_indices { 
      36, 
      <81, 82, 83>,
      <81, 83, 84>,
      <61, 60, 59>,
      <61, 59, 58>,
      <66, 67, 68>,
      <66, 68, 69>,
      <73, 76, 77>,
      <73, 77, 78>,
      <85, 86, 83>,
      <85, 83, 84>,
      <85, 86, 83>,
      <85, 83, 84>,
      <62, 62, 63>,
      <62, 63, 63>,
      <64, 61, 58>,
      <64, 58, 65>,
      <63, 62, 64>,
      <63, 64, 65>,
      <70, 66, 69>,
      <70, 69, 71>,
      <70, 71, 72>,
      <79, 75, 73>,
      <79, 73, 78>,
      <79, 78, 70>,
      <65, 58, 61>,
      <65, 61, 64>,
      <62, 62, 63>,
      <62, 63, 63>,
      <65, 64, 62>,
      <65, 62, 63>,
      <71, 80, 70>,
      <71, 70, 78>,
      <71, 78, 69>,
      <73, 66, 70>,
      <73, 70, 74>,
      <73, 74, 75>
   }
   uv_mapping
}
 
// Shock_Cyl_b24
mesh2 {
 
   vertex_vectors { 
      12, 
      <-1.823668E+00, 3.393224E+00, -1.3346E+01>,
      <-1.607163E+00, 3.393224E+00, -1.349288E+01>,
      <-1.607163E+00, 3.393224E+00, -1.378663E+01>,
      <-1.823668E+00, 3.393224E+00, -1.39335E+01>,
      <-2.040173E+00, 3.393224E+00, -1.378663E+01>,
      <-2.040173E+00, 3.393224E+00, -1.349288E+01>,
      <-1.823668E+00, 2.218224E+00, -1.3346E+01>,
      <-1.607163E+00, 2.218224E+00, -1.349288E+01>,
      <-1.607163E+00, 2.218224E+00, -1.378663E+01>,
      <-1.823668E+00, 2.218224E+00, -1.39335E+01>,
      <-2.040173E+00, 2.218224E+00, -1.378663E+01>,
      <-2.040173E+00, 2.218224E+00, -1.349288E+01>
   }
 
   normal_vectors { 
      10, 
      <5.000014E-01, -3.166497E-08, 8.660246E-01>,
      <8.660257E-01, -3.166497E-08, 4.999994E-01>,
      <8.660261E-01, -3.166497E-08, -4.999989E-01>,
      <5.00002E-01, -3.166497E-08, -8.660242E-01>,
      <-5.000013E-01, -3.166497E-08, -8.660247E-01>,
      <-8.660257E-01, -3.166497E-08, -4.999995E-01>,
      <-8.66026E-01, -3.166497E-08, 4.99999E-01>,
      <-5.000018E-01, -3.166497E-08, 8.660244E-01>,
      <4.280104E-16, -1.00E+00, -4.31381E-16>,
      <-4.280104E-16, 9.999999E-01, 4.31381E-16>
   }
 
   uv_vectors { 
      25, 
      <0.00E+00, 0.00E+00>,
      <-1.09625E-01, 1.865001E-01>,
      <-1.09625E-01, 1.152E-01>,
      <-1.205416E-01, 1.152E-01>,
      <-1.205416E-01, 1.865001E-01>,
      <-6.595832E-02, 1.152E-01>,
      <-6.595832E-02, 1.865001E-01>,
      <-7.687497E-02, 1.152E-01>,
      <-7.687497E-02, 1.865001E-01>,
      <-8.779162E-02, 1.152E-01>,
      <-8.779162E-02, 1.865001E-01>,
      <-9.870833E-02, 1.152E-01>,
      <-9.870833E-02, 1.865001E-01>,
      <-3.888E-01, 1.00E+00>,
      <-3.888E-01, 7.091E-01>,
      <-4.266666E-01, 7.091E-01>,
      <-4.266666E-01, 1.00E+00>,
      <-2.373334E-01, 7.091E-01>,
      <-2.373334E-01, 1.00E+00>,
      <-2.751999E-01, 7.091E-01>,
      <-2.751999E-01, 1.00E+00>,
      <-3.130665E-01, 7.091E-01>,
      <-3.130665E-01, 1.00E+00>,
      <-3.509334E-01, 7.091E-01>,
      <-3.509334E-01, 1.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      20, 
      <0, 6, 7>, 0,
      <0, 7, 1>, 0,
      <1, 7, 8>, 0,
      <1, 8, 2>, 0,
      <2, 8, 9>, 0,
      <2, 9, 3>, 0,
      <3, 9, 10>, 0,
      <3, 10, 4>, 0,
      <4, 10, 11>, 0,
      <4, 11, 5>, 0,
      <5, 11, 6>, 0,
      <5, 6, 0>, 0,
      <6, 11, 10>, 0,
      <6, 10, 9>, 0,
      <6, 9, 8>, 0,
      <6, 8, 7>, 0,
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <0, 3, 4>, 0,
      <0, 4, 5>, 0
   }
 
   normal_indices { 
      20, 
      <0, 0, 1>,
      <0, 1, 1>,
      <1, 1, 2>,
      <1, 2, 2>,
      <2, 2, 3>,
      <2, 3, 3>,
      <4, 4, 5>,
      <4, 5, 5>,
      <5, 5, 6>,
      <5, 6, 6>,
      <6, 6, 7>,
      <6, 7, 7>,
      <8, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>
   }
 
   uv_indices { 
      20, 
      <13, 14, 15>,
      <13, 15, 16>,
      <16, 15, 17>,
      <16, 17, 18>,
      <18, 17, 19>,
      <18, 19, 20>,
      <20, 19, 21>,
      <20, 21, 22>,
      <22, 21, 23>,
      <22, 23, 24>,
      <24, 23, 14>,
      <24, 14, 13>,
      <14, 23, 21>,
      <14, 21, 19>,
      <14, 19, 17>,
      <14, 17, 15>,
      <13, 16, 18>,
      <13, 18, 20>,
      <13, 20, 22>,
      <13, 22, 24>
   }
   uv_mapping
}
 
// Shock_Cube_b24
mesh2 {
 
   vertex_vectors { 
      24, 
      <-1.923666E+00, 2.210607E+00, -1.326751E+01>,
      <-1.923666E+00, 3.268107E+00, -1.326751E+01>,
      <-1.723669E+00, 3.268107E+00, -1.326751E+01>,
      <-1.723669E+00, 2.210607E+00, -1.326751E+01>,
      <-1.723669E+00, 2.210607E+00, -1.304118E+01>,
      <-1.723669E+00, 3.268107E+00, -1.304118E+01>,
      <-1.923666E+00, 3.268107E+00, -1.304118E+01>,
      <-1.923666E+00, 2.210607E+00, -1.304118E+01>,
      <-1.723667E+00, 2.02356E+00, -1.339368E+01>,
      <-1.723668E+00, 2.02356E+00, -1.304118E+01>,
      <-1.923668E+00, 2.02356E+00, -1.304118E+01>,
      <-1.923668E+00, 2.02356E+00, -1.339368E+01>,
      <-1.923668E+00, 2.02356E+00, -1.374618E+01>,
      <-1.923666E+00, 2.210607E+00, -1.374618E+01>,
      <-1.723669E+00, 2.210607E+00, -1.374618E+01>,
      <-1.723667E+00, 2.02356E+00, -1.374618E+01>,
      <-1.723668E+00, 2.02356E+00, -1.315868E+01>,
      <-1.923668E+00, 2.02356E+00, -1.315868E+01>,
      <-1.723669E+00, 2.14106E+00, -1.304118E+01>,
      <-1.923666E+00, 2.14106E+00, -1.304118E+01>,
      <-1.923666E+00, 2.14106E+00, -1.374618E+01>,
      <-1.723669E+00, 2.14106E+00, -1.374618E+01>,
      <-1.723667E+00, 2.02356E+00, -1.362868E+01>,
      <-1.923668E+00, 2.02356E+00, -1.362868E+01>
   }
 
   normal_vectors { 
      10, 
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <-4.280104E-16, 9.999999E-01, 4.31381E-16>,
      <4.280104E-16, -1.00E+00, -4.31381E-16>,
      <-1.246954E-07, -9.238779E-01, 3.826876E-01>,
      <-3.010387E-07, -3.826793E-01, 9.238812E-01>,
      <3.010386E-07, -3.8268E-01, -9.238809E-01>,
      <1.246952E-07, -9.238782E-01, -3.826869E-01>
   }
 
   uv_vectors { 
      114, 
      <0.00E+00, 0.00E+00>,
      <-2.04565E-01, 1.769602E-02>,
      <-2.04565E-01, 3.52E-02>,
      <-2.08E-01, 1.769602E-02>,
      <-2.08E-01, 3.52E-02>,
      <-1.973E-01, 1.769602E-02>,
      <-2.0265E-01, 1.459998E-02>,
      <-2.062167E-01, 1.459998E-02>,
      <-2.08E-01, 1.654488E-02>,
      <-1.973E-01, 1.654488E-02>,
      <-1.990833E-01, 1.459998E-02>,
      <-2.650457E-01, 1.318E-01>,
      <-2.650457E-01, 1.807E-01>,
      <-3.065999E-01, 1.807E-01>,
      <-3.065999E-01, 1.318E-01>,
      <-2.697666E-01, 1.318E-01>,
      <-2.650457E-01, 1.625181E-01>,
      <-2.792866E-01, 1.807E-01>,
      <-3.065999E-01, 1.625181E-01>,
      <-3.037514E-01, 1.318E-01>,
      <-2.815267E-01, 1.318E-01>,
      <-2.674062E-01, 1.318E-01>,
      <-2.721663E-01, 1.807E-01>,
      <-2.858232E-01, 1.318E-01>,
      <-3.042395E-01, 1.318E-01>,
      <-3.633119E-01, 1.552501E-01>,
      <-3.633119E-01, 1.402832E-01>,
      <-3.25088E-01, 1.402832E-01>,
      <-3.25088E-01, 1.552501E-01>,
      <-3.676208E-01, 1.328E-01>,
      <-3.207791E-01, 1.328E-01>,
      <-3.633119E-01, 1.702168E-01>,
      <-3.25088E-01, 1.702168E-01>,
      <-3.207791E-01, 1.777E-01>,
      <-3.676208E-01, 1.777E-01>,
      <-3.218501E-01, 1.328E-01>,
      <-3.218501E-01, 1.777E-01>,
      <-3.665498E-01, 1.777E-01>,
      <-3.665498E-01, 1.328E-01>,
      <-3.676208E-01, 1.328E-01>,
      <-3.258846E-01, 1.648718E-01>,
      <-3.243587E-01, 1.777E-01>,
      <-3.640411E-01, 1.777E-01>,
      <-3.625149E-01, 1.648718E-01>,
      <-3.666089E-01, 1.342221E-01>,
      <-3.21791E-01, 1.342221E-01>,
      <-2.559001E-01, 1.27E-01>,
      <-2.559001E-01, 1.797E-01>,
      <-2.983236E-01, 1.797E-01>,
      <-2.983236E-01, 1.27E-01>,
      <-2.771116E-01, 1.27E-01>,
      <-2.910541E-01, 1.797E-01>,
      <-2.983236E-01, 1.601051E-01>,
      <-2.959139E-01, 1.27E-01>,
      <-2.583099E-01, 1.27E-01>,
      <-2.559001E-01, 1.601051E-01>,
      <-3.255043E-01, 1.299E-01>,
      <-3.255043E-01, 1.787E-01>,
      <-3.658957E-01, 1.787E-01>,
      <-3.658957E-01, 1.299E-01>,
      <-3.638663E-01, 1.768E-01>,
      <-3.638663E-01, 1.279E-01>,
      <-3.216336E-01, 1.279E-01>,
      <-3.216336E-01, 1.768E-01>,
      <-9.340202E-01, 4.931485E-02>,
      <-9.340202E-01, 2.371E-01>,
      <-9.685799E-01, 2.371E-01>,
      <-9.685799E-01, 4.931485E-02>,
      <-9.587148E-01, 4.931485E-02>,
      <-9.587148E-01, 2.371E-01>,
      <-9.438852E-01, 2.371E-01>,
      <-9.438852E-01, 4.931485E-02>,
      <-8.863148E-01, 4.931485E-02>,
      <-8.714852E-01, 4.931485E-02>,
      <-8.427004E-01, 1.609999E-02>,
      <-9.61985E-01, 1.609999E-02>,
      <-9.406151E-01, 1.609999E-02>,
      <-9.150996E-01, 1.609999E-02>,
      <-9.587148E-01, 3.696501E-02>,
      <-9.438852E-01, 3.696501E-02>,
      <-8.863148E-01, 3.696501E-02>,
      <-8.714852E-01, 3.696501E-02>,
      <-8.68215E-01, 1.609999E-02>,
      <-8.89585E-01, 1.609999E-02>,
      <-8.427014E-01, 4.931485E-02>,
      <-8.427014E-01, 2.371E-01>,
      <-9.874986E-01, 2.371E-01>,
      <-9.874986E-01, 4.931485E-02>,
      <-9.875E-01, 1.609999E-02>,
      <-9.874986E-01, 3.696501E-02>,
      <-8.427014E-01, 3.696501E-02>,
      <-9.925E-01, 2.954225E-01>,
      <-9.925E-01, 4.906E-01>,
      <-9.761403E-01, 4.906E-01>,
      <-9.761403E-01, 2.954225E-01>,
      <-9.288717E-01, 4.906E-01>,
      <-9.288717E-01, 2.954225E-01>,
      <-9.516005E-01, 2.609E-01>,
      <-9.761403E-01, 2.825865E-01>,
      <-9.025195E-01, 2.609E-01>,
      <-8.289003E-01, 2.825865E-01>,
      <-8.534395E-01, 2.609E-01>,
      <-8.289003E-01, 2.954225E-01>,
      <-8.814207E-01, 2.954225E-01>,
      <-8.814207E-01, 4.906E-01>,
      <-8.289E-01, 4.906E-01>,
      <-9.107005E-01, 2.609E-01>,
      <-8.561661E-01, 2.609E-01>,
      <-9.652339E-01, 2.609E-01>,
      <-9.925E-01, 2.825865E-01>,
      <-8.439E-01, 1.12E-02>,
      <-8.439E-01, 2.371E-01>,
      <-9.80E-01, 2.371E-01>,
      <-9.80E-01, 1.12E-02>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      36, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <13, 0, 3>, 0,
      <13, 3, 14>, 0,
      <8, 16, 17>, 0,
      <8, 17, 11>, 0,
      <18, 4, 7>, 0,
      <18, 7, 19>, 0,
      <17, 16, 18>, 0,
      <17, 18, 19>, 0,
      <8, 3, 4>, 0,
      <8, 4, 18>, 0,
      <8, 18, 16>, 0,
      <17, 19, 7>, 0,
      <17, 7, 0>, 0,
      <17, 0, 11>, 0,
      <20, 13, 14>, 0,
      <20, 14, 21>, 0,
      <22, 8, 11>, 0,
      <22, 11, 23>, 0,
      <20, 21, 22>, 0,
      <20, 22, 23>, 0,
      <20, 23, 11>, 0,
      <20, 11, 0>, 0,
      <20, 0, 13>, 0,
      <14, 3, 8>, 0,
      <14, 8, 22>, 0,
      <14, 22, 21>, 0
   }
 
   normal_indices { 
      36, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <6, 6, 7>,
      <6, 7, 7>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <8, 0, 0>,
      <8, 0, 8>,
      <9, 5, 5>,
      <9, 5, 9>,
      <8, 8, 9>,
      <8, 9, 9>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 2>
   }
 
   uv_indices { 
      36, 
      <84, 85, 86>,
      <84, 86, 87>,
      <110, 111, 112>,
      <110, 112, 113>,
      <103, 104, 105>,
      <103, 105, 102>,
      <94, 93, 95>,
      <94, 95, 96>,
      <85, 85, 86>,
      <85, 86, 86>,
      <84, 84, 87>,
      <84, 87, 87>,
      <88, 88, 74>,
      <88, 74, 74>,
      <89, 87, 84>,
      <89, 84, 90>,
      <74, 88, 89>,
      <74, 89, 90>,
      <106, 103, 102>,
      <106, 102, 100>,
      <106, 100, 107>,
      <97, 98, 94>,
      <97, 94, 96>,
      <97, 96, 99>,
      <90, 84, 87>,
      <90, 87, 89>,
      <88, 88, 74>,
      <88, 74, 74>,
      <90, 89, 88>,
      <90, 88, 74>,
      <100, 101, 99>,
      <100, 99, 96>,
      <100, 96, 102>,
      <91, 103, 106>,
      <91, 106, 108>,
      <91, 108, 109>
   }
   uv_mapping
}
 
// TruckFrameP
mesh2 {
 
   vertex_vectors { 
      76, 
      <-2.111734E+00, 4.560828E+00, -2.001809E+01>,
      <-1.545959E+00, 4.56175E+00, -2.001808E+01>,
      <-2.101505E+00, 2.068395E+00, -2.002307E+01>,
      <-1.535736E+00, 2.069316E+00, -2.002306E+01>,
      <-2.101492E+00, 2.064746E+00, -1.916002E+01>,
      <-1.535721E+00, 2.065668E+00, -1.916001E+01>,
      <-2.103653E+00, 2.5911E+00, -1.915701E+01>,
      <-1.537878E+00, 2.592021E+00, -1.915701E+01>,
      <-2.105526E+00, 3.047194E+00, -1.874259E+01>,
      <-1.539746E+00, 3.048117E+00, -1.874258E+01>,
      <-2.106671E+00, 3.326682E+00, -1.822631E+01>,
      <-1.5409E+00, 3.327603E+00, -1.82263E+01>,
      <-2.106654E+00, 3.322262E+00, -1.704535E+01>,
      <-1.540879E+00, 3.323184E+00, -1.704535E+01>,
      <-2.105502E+00, 3.041656E+00, -1.63873E+01>,
      <-1.539729E+00, 3.042578E+00, -1.638729E+01>,
      <-2.103612E+00, 2.58004E+00, -1.603841E+01>,
      <-1.537834E+00, 2.580961E+00, -1.60384E+01>,
      <-2.101398E+00, 2.040997E+00, -1.596966E+01>,
      <-1.535627E+00, 2.041919E+00, -1.596966E+01>,
      <-2.101379E+00, 2.036054E+00, -1.42937E+01>,
      <-1.535606E+00, 2.036975E+00, -1.42937E+01>,
      <-2.10239E+00, 2.282681E+00, -1.429319E+01>,
      <-1.536613E+00, 2.283601E+00, -1.429319E+01>,
      <-2.103989E+00, 2.672192E+00, -1.418487E+01>,
      <-1.538214E+00, 2.673113E+00, -1.418487E+01>,
      <-2.105122E+00, 2.948522E+00, -1.393741E+01>,
      <-1.539353E+00, 2.949444E+00, -1.393742E+01>,
      <-2.106228E+00, 3.218226E+00, -1.354966E+01>,
      <-1.540455E+00, 3.219148E+00, -1.354966E+01>,
      <-2.106223E+00, 3.215935E+00, -1.296294E+01>,
      <-1.540448E+00, 3.216857E+00, -1.296294E+01>,
      <-2.108799E+00, 3.844833E+00, -1.296081E+01>,
      <-1.543026E+00, 3.845754E+00, -1.296081E+01>,
      <-2.109802E+00, 4.088362E+00, -1.315798E+01>,
      <-1.544028E+00, 4.089283E+00, -1.315798E+01>,
      <-2.111408E+00, 4.480934E+00, -1.412321E+01>,
      <-1.545641E+00, 4.481855E+00, -1.412321E+01>,
      <-2.111669E+00, 4.543828E+00, -1.510707E+01>,
      <-1.545894E+00, 4.54475E+00, -1.510707E+01>,
      <-2.101492E+00, 2.064746E+00, -2.088612E+01>,
      <-1.535721E+00, 2.065668E+00, -2.088612E+01>,
      <-2.103653E+00, 2.5911E+00, -2.088913E+01>,
      <-1.537878E+00, 2.592021E+00, -2.088913E+01>,
      <-2.105525E+00, 3.047194E+00, -2.130356E+01>,
      <-1.539745E+00, 3.048117E+00, -2.130355E+01>,
      <-2.10667E+00, 3.326682E+00, -2.181984E+01>,
      <-1.540899E+00, 3.327603E+00, -2.181984E+01>,
      <-2.106652E+00, 3.322262E+00, -2.300079E+01>,
      <-1.540877E+00, 3.323184E+00, -2.300079E+01>,
      <-2.105496E+00, 3.041656E+00, -2.365885E+01>,
      <-1.539723E+00, 3.042578E+00, -2.365884E+01>,
      <-2.103606E+00, 2.58004E+00, -2.400774E+01>,
      <-1.537827E+00, 2.580961E+00, -2.400773E+01>,
      <-2.101391E+00, 2.040997E+00, -2.407648E+01>,
      <-1.53562E+00, 2.041919E+00, -2.407647E+01>,
      <-2.101372E+00, 2.036054E+00, -2.575244E+01>,
      <-1.535599E+00, 2.036975E+00, -2.575244E+01>,
      <-2.102383E+00, 2.282681E+00, -2.575295E+01>,
      <-1.536606E+00, 2.283601E+00, -2.575294E+01>,
      <-2.103981E+00, 2.672192E+00, -2.586127E+01>,
      <-1.538206E+00, 2.673113E+00, -2.586126E+01>,
      <-2.105114E+00, 2.948522E+00, -2.610873E+01>,
      <-1.539345E+00, 2.949444E+00, -2.610872E+01>,
      <-2.10622E+00, 3.218226E+00, -2.649648E+01>,
      <-1.540447E+00, 3.219148E+00, -2.649648E+01>,
      <-2.106214E+00, 3.215935E+00, -2.70832E+01>,
      <-1.540439E+00, 3.216857E+00, -2.708319E+01>,
      <-2.108791E+00, 3.844833E+00, -2.708533E+01>,
      <-1.543018E+00, 3.845754E+00, -2.708533E+01>,
      <-2.109794E+00, 4.088362E+00, -2.688816E+01>,
      <-1.544019E+00, 4.089283E+00, -2.688816E+01>,
      <-2.111401E+00, 4.480934E+00, -2.592293E+01>,
      <-1.545633E+00, 4.481855E+00, -2.592293E+01>,
      <-2.111662E+00, 4.543828E+00, -2.493907E+01>,
      <-1.545887E+00, 4.54475E+00, -2.493906E+01>
   }
 
   normal_vectors { 
      36, 
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <4.280104E-16, -1.00E+00, -4.31381E-16>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <5.002359E-04, -3.631424E-01, 9.317335E-01>,
      <1.089283E-03, -7.870986E-01, 6.168263E-01>,
      <1.343633E-03, -9.698402E-01, 2.437382E-01>,
      <1.3575E-03, -9.793831E-01, -2.020077E-01>,
      <1.092291E-03, -7.879434E-01, -6.157468E-01>,
      <5.234679E-04, -3.774298E-01, -9.260381E-01>,
      <1.75726E-04, -1.264974E-01, -9.91967E-01>,
      <1.88181E-04, -1.362275E-01, 9.906776E-01>,
      <6.66446E-04, -4.801075E-01, 8.772094E-01>,
      <1.040539E-03, -7.490928E-01, 6.624643E-01>,
      <1.324347E-03, -9.547682E-01, 2.973481E-01>,
      <-4.605403E-04, 3.321613E-01, 9.432225E-01>,
      <-1.113014E-03, 8.031416E-01, 5.95787E-01>,
      <-1.351239E-03, 9.747794E-01, 2.231661E-01>,
      <-1.386171E-03, 9.994329E-01, 3.36444E-02>,
      <-4.280104E-16, 9.999999E-01, 4.31381E-16>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <5.070681E-04, -3.631439E-01, -9.317329E-01>,
      <1.093837E-03, -7.870981E-01, -6.16827E-01>,
      <1.34542E-03, -9.698406E-01, -2.437364E-01>,
      <1.356644E-03, -9.793829E-01, 2.020084E-01>,
      <1.088387E-03, -7.879429E-01, 6.157473E-01>,
      <5.16388E-04, -3.774298E-01, 9.260381E-01>,
      <1.680178E-04, -1.264973E-01, 9.91967E-01>,
      <1.925518E-04, -1.362256E-01, -9.906778E-01>,
      <6.701155E-04, -4.801121E-01, -8.772069E-01>,
      <1.042313E-03, -7.490943E-01, -6.624627E-01>,
      <1.324541E-03, -9.547682E-01, -2.973482E-01>,
      <-4.555282E-04, 3.321632E-01, -9.432219E-01>,
      <-1.109362E-03, 8.031414E-01, -5.957873E-01>,
      <-1.350384E-03, 9.747794E-01, -2.231665E-01>,
      <-1.386032E-03, 9.99433E-01, -3.364085E-02>
   }
 
   uv_vectors { 
      414, 
      <-2.046E-01, 9.50455E-04>,
      <-2.044556E-01, 7.419997E-02>,
      <-6.747044E-01, 1.152495E-01>,
      <-4.011471E-01, 1.145969E-01>,
      <-3.606242E-01, 6.020861E-02>,
      <-1.579244E-01, 2.517338E-02>,
      <-1.453434E-01, 7.10662E-02>,
      <-3.173649E-03, 2.092282E-01>,
      <-2.607399E-02, 2.379216E-01>,
      <-1.381813E-01, 2.841752E-01>,
      <-2.524532E-01, 2.915855E-01>,
      <-7.20838E-01, 6.151171E-02>,
      <-6.197401E-01, 1.511789E-01>,
      <-4.645773E-01, 1.506583E-01>,
      <-1.246028E-01, 1.036236E-01>,
      <-7.156575E-02, 1.404006E-01>,
      <-3.421843E-03, 1.401306E-01>,
      <-5.641788E-01, 5.883074E-01>,
      <-6.759159E-01, 5.810612E-01>,
      <-6.970152E-01, 4.04516E-01>,
      <-6.689128E-01, 3.726806E-01>,
      <-6.566107E-01, 3.278061E-01>,
      <-6.565531E-01, 2.993928E-01>,
      <-4.662144E-01, 2.999625E-01>,
      <-4.584077E-01, 3.620643E-01>,
      <-4.18784E-01, 4.152457E-01>,
      <-3.440497E-01, 4.475738E-01>,
      <-2.09929E-01, 4.480829E-01>,
      <-1.512954E-01, 4.158841E-01>,
      <-1.042293E-01, 3.633384E-01>,
      <-5.871534E-03, 3.031187E-01>,
      <-5.305231E-03, 5.902659E-01>,
      <-8.165E-01, 9.252285E-01>,
      <-8.125838E-01, 9.57226E-01>,
      <-4.76269E-01, 9.570976E-01>,
      <-4.801807E-01, 9.251E-01>,
      <-8.094193E-01, 9.875E-01>,
      <-4.731E-01, 9.873715E-01>,
      <-8.056706E-01, 9.251E-01>,
      <-8.165004E-01, 9.865987E-01>,
      <-4.839258E-01, 9.875E-01>,
      <-4.731004E-01, 9.260013E-01>,
      <-8.138481E-01, 9.251E-01>,
      <-8.165005E-01, 9.87354E-01>,
      <-4.757576E-01, 9.875E-01>,
      <-4.731005E-01, 9.252461E-01>,
      <-8.143413E-01, 9.251E-01>,
      <-8.158955E-01, 9.667082E-01>,
      <-4.746559E-01, 9.667693E-01>,
      <-4.752599E-01, 9.875E-01>,
      <-8.149452E-01, 9.667693E-01>,
      <-4.737057E-01, 9.667083E-01>,
      <-4.752599E-01, 9.251E-01>,
      <-8.143413E-01, 9.875E-01>,
      <-4.79441E-01, 9.71815E-01>,
      <-8.15111E-01, 9.717873E-01>,
      <-4.779892E-01, 9.608642E-01>,
      <-8.13658E-01, 9.608366E-01>,
      <-4.764569E-01, 9.525719E-01>,
      <-8.121303E-01, 9.525443E-01>,
      <-4.750684E-01, 9.473768E-01>,
      <-8.107361E-01, 9.473491E-01>,
      <-6.093669E-01, 9.875E-01>,
      <-4.731E-01, 9.358639E-01>,
      <-6.802346E-01, 9.251E-01>,
      <-8.165E-01, 9.767362E-01>,
      <-6.511039E-01, 9.925E-01>,
      <-4.656E-01, 9.366999E-01>,
      <-6.221966E-01, 9.263E-01>,
      <-8.077E-01, 9.821002E-01>,
      <-6.366501E-01, 9.924985E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.656E-01, 9.26301E-01>,
      <-6.366501E-01, 9.263001E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.077E-01, 9.925001E-01>,
      <-4.656E-01, 9.820999E-01>,
      <-6.511061E-01, 9.263E-01>,
      <-8.076999E-01, 9.367001E-01>,
      <-6.221933E-01, 9.925E-01>,
      <-8.047949E-01, 9.263E-01>,
      <-4.685062E-01, 9.925E-01>,
      <-8.053998E-01, 9.334068E-01>,
      <-4.662043E-01, 9.334333E-01>,
      <-8.063581E-01, 9.472352E-01>,
      <-4.671637E-01, 9.472617E-01>,
      <-8.070373E-01, 9.611779E-01>,
      <-4.678464E-01, 9.612043E-01>,
      <-8.077005E-01, 9.783284E-01>,
      <-4.685073E-01, 9.783549E-01>,
      <-8.045977E-01, 9.263E-01>,
      <-8.058926E-01, 9.445296E-01>,
      <-4.668931E-01, 9.445614E-01>,
      <-8.070148E-01, 9.703102E-01>,
      <-4.680119E-01, 9.70342E-01>,
      <-4.687034E-01, 9.925E-01>,
      <-4.656E-01, 9.810792E-01>,
      <-6.013628E-01, 9.263E-01>,
      <-8.077E-01, 9.377209E-01>,
      <-6.719353E-01, 9.925E-01>,
      <-8.070968E-01, 9.366705E-01>,
      <-4.679013E-01, 9.36632E-01>,
      <-4.685073E-01, 9.263E-01>,
      <-8.061374E-01, 9.554002E-01>,
      <-4.669431E-01, 9.553617E-01>,
      <-8.054547E-01, 9.72515E-01>,
      <-4.662638E-01, 9.724765E-01>,
      <-8.047938E-01, 9.925E-01>,
      <-5.472026E-01, 9.925E-01>,
      <-4.656E-01, 9.45287E-01>,
      <-7.260988E-01, 9.263E-01>,
      <-8.076999E-01, 9.73513E-01>,
      <-8.064069E-01, 9.445614E-01>,
      <-4.674074E-01, 9.445295E-01>,
      <-4.687022E-01, 9.263E-01>,
      <-8.05288E-01, 9.70342E-01>,
      <-4.662851E-01, 9.703102E-01>,
      <-8.045966E-01, 9.925E-01>,
      <-4.662919E-01, 9.678896E-01>,
      <-8.052427E-01, 9.679187E-01>,
      <-4.674243E-01, 9.449727E-01>,
      <-8.063785E-01, 9.450018E-01>,
      <-7.89536E-01, 5.358341E-01>,
      <-8.119286E-01, 5.077778E-01>,
      <-8.116856E-01, 4.483239E-01>,
      <-7.410533E-01, 4.395881E-01>,
      <-9.688789E-02, 3.026984E-01>,
      <-8.208482E-01, 2.935884E-01>,
      <-8.21427E-01, 1.00E-03>,
      <-7.211874E-01, 1.00E-03>,
      <-3.526406E-01, 1.00E-03>,
      <-1.579831E-01, 1.00E-03>,
      <-8.152E-01, 9.215873E-01>,
      <-6.40607E-01, 9.202015E-01>,
      <-6.405473E-01, 9.949143E-01>,
      <-8.151404E-01, 9.963001E-01>,
      <-4.656E-01, 9.935129E-01>,
      <-4.656596E-01, 9.188001E-01>,
      <-1.874804E-03, 3.024706E-01>,
      <-9.998667E-02, 3.625397E-01>,
      <-1.469352E-01, 4.14954E-01>,
      <-2.054224E-01, 4.470723E-01>,
      <-3.392073E-01, 4.465645E-01>,
      <-4.137549E-01, 4.143173E-01>,
      <-4.532796E-01, 3.612688E-01>,
      <-4.610668E-01, 2.993222E-01>,
      <-9.464604E-02, 3.021559E-01>,
      <-6.559296E-01, 2.98754E-01>,
      <-6.559871E-01, 3.270963E-01>,
      <-6.682582E-01, 3.718586E-01>,
      <-6.962906E-01, 4.036143E-01>,
      <-7.462181E-01, 4.416088E-01>,
      <-8.106839E-01, 4.483452E-01>,
      <-8.10926E-01, 5.06618E-01>,
      <-7.885892E-01, 5.346041E-01>,
      <-2.530497E-01, 2.93377E-01>,
      <-1.399122E-01, 2.860404E-01>,
      <-2.891767E-02, 2.40246E-01>,
      <-6.244719E-03, 2.118375E-01>,
      <-6.489635E-03, 1.384754E-01>,
      <-7.395738E-02, 1.387428E-01>,
      <-1.185479E-01, 1.072811E-01>,
      <-1.470027E-01, 7.504681E-02>,
      <-1.594592E-01, 2.960964E-02>,
      <-1.595172E-01, 8.400737E-04>,
      <-3.522428E-01, 1.416883E-03>,
      <-3.601472E-01, 6.429716E-02>,
      <-4.002675E-01, 1.181454E-01>,
      <-4.75939E-01, 1.508787E-01>,
      <-6.117408E-01, 1.513942E-01>,
      <-6.7111E-01, 1.187916E-01>,
      <-7.187657E-01, 6.558718E-02>,
      <-7.191114E-01, 4.187306E-03>,
      <-8.183562E-01, 4.612735E-03>,
      <-8.177832E-01, 2.953604E-01>,
      <-1.31005E-03, 5.938998E-01>,
      <-6.702439E-01, 5.847182E-01>,
      <-5.587863E-01, 5.919462E-01>,
      <-6.366501E-01, 9.924985E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.656E-01, 9.26301E-01>,
      <-6.366501E-01, 9.263001E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.064069E-01, 9.445614E-01>,
      <-4.674074E-01, 9.445295E-01>,
      <-4.687022E-01, 9.263E-01>,
      <-8.064069E-01, 9.445614E-01>,
      <-8.05288E-01, 9.70342E-01>,
      <-4.662851E-01, 9.703102E-01>,
      <-4.674074E-01, 9.445295E-01>,
      <-8.05288E-01, 9.70342E-01>,
      <-8.045966E-01, 9.925E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.662851E-01, 9.703102E-01>,
      <-6.093669E-01, 9.875E-01>,
      <-4.731E-01, 9.358639E-01>,
      <-6.802346E-01, 9.251E-01>,
      <-8.165E-01, 9.767362E-01>,
      <-4.79441E-01, 9.71815E-01>,
      <-4.779892E-01, 9.608642E-01>,
      <-8.13658E-01, 9.608366E-01>,
      <-8.15111E-01, 9.717873E-01>,
      <-4.779892E-01, 9.608642E-01>,
      <-4.764569E-01, 9.525719E-01>,
      <-8.121303E-01, 9.525443E-01>,
      <-8.13658E-01, 9.608366E-01>,
      <-4.764569E-01, 9.525719E-01>,
      <-4.750684E-01, 9.473768E-01>,
      <-8.107361E-01, 9.473491E-01>,
      <-8.121303E-01, 9.525443E-01>,
      <-6.511039E-01, 9.925E-01>,
      <-4.656E-01, 9.366999E-01>,
      <-6.221966E-01, 9.263E-01>,
      <-8.077E-01, 9.821002E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.070968E-01, 9.366705E-01>,
      <-4.679013E-01, 9.36632E-01>,
      <-4.685073E-01, 9.263E-01>,
      <-8.070968E-01, 9.366705E-01>,
      <-8.061374E-01, 9.554002E-01>,
      <-4.669431E-01, 9.553617E-01>,
      <-4.679013E-01, 9.36632E-01>,
      <-8.061374E-01, 9.554002E-01>,
      <-8.054547E-01, 9.72515E-01>,
      <-4.662638E-01, 9.724765E-01>,
      <-4.669431E-01, 9.553617E-01>,
      <-8.054547E-01, 9.72515E-01>,
      <-8.047938E-01, 9.925E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.662638E-01, 9.724765E-01>,
      <-5.472026E-01, 9.925E-01>,
      <-4.656E-01, 9.45287E-01>,
      <-7.260988E-01, 9.263E-01>,
      <-8.076999E-01, 9.73513E-01>,
      <-8.165E-01, 9.252285E-01>,
      <-8.149452E-01, 9.667693E-01>,
      <-4.737057E-01, 9.667083E-01>,
      <-4.752599E-01, 9.251E-01>,
      <-8.149452E-01, 9.667693E-01>,
      <-8.143413E-01, 9.875E-01>,
      <-4.731E-01, 9.873715E-01>,
      <-4.737057E-01, 9.667083E-01>,
      <-8.165E-01, 9.252285E-01>,
      <-8.125838E-01, 9.57226E-01>,
      <-4.76269E-01, 9.570976E-01>,
      <-4.801807E-01, 9.251E-01>,
      <-8.125838E-01, 9.57226E-01>,
      <-8.094193E-01, 9.875E-01>,
      <-4.731E-01, 9.873715E-01>,
      <-4.76269E-01, 9.570976E-01>,
      <-8.152E-01, 9.215873E-01>,
      <-6.40607E-01, 9.202015E-01>,
      <-6.405473E-01, 9.949143E-01>,
      <-8.151404E-01, 9.963001E-01>,
      <-8.208482E-01, 2.935884E-01>,
      <-8.21427E-01, 1.00E-03>,
      <-7.211874E-01, 1.00E-03>,
      <-7.20838E-01, 6.151171E-02>,
      <-6.747044E-01, 1.152495E-01>,
      <-6.197401E-01, 1.511789E-01>,
      <-4.645773E-01, 1.506583E-01>,
      <-4.011471E-01, 1.145969E-01>,
      <-3.606242E-01, 6.020861E-02>,
      <-3.526406E-01, 1.00E-03>,
      <-1.579831E-01, 1.00E-03>,
      <-1.579244E-01, 2.517338E-02>,
      <-1.453434E-01, 7.10662E-02>,
      <-1.246028E-01, 1.036236E-01>,
      <-7.156575E-02, 1.404006E-01>,
      <-3.421843E-03, 1.401306E-01>,
      <-3.173649E-03, 2.092282E-01>,
      <-2.607399E-02, 2.379216E-01>,
      <-1.381813E-01, 2.841752E-01>,
      <-2.524532E-01, 2.915855E-01>,
      <-2.530497E-01, 2.93377E-01>,
      <-1.399122E-01, 2.860404E-01>,
      <-2.891767E-02, 2.40246E-01>,
      <-6.244719E-03, 2.118375E-01>,
      <-6.489635E-03, 1.384754E-01>,
      <-7.395738E-02, 1.387428E-01>,
      <-1.185479E-01, 1.072811E-01>,
      <-1.470027E-01, 7.504681E-02>,
      <-1.594592E-01, 2.960964E-02>,
      <-1.595172E-01, 8.400737E-04>,
      <-3.522428E-01, 1.416883E-03>,
      <-3.601472E-01, 6.429716E-02>,
      <-4.002675E-01, 1.181454E-01>,
      <-4.75939E-01, 1.508787E-01>,
      <-6.117408E-01, 1.513942E-01>,
      <-6.7111E-01, 1.187916E-01>,
      <-7.187657E-01, 6.558718E-02>,
      <-7.191114E-01, 4.187306E-03>,
      <-8.183562E-01, 4.612735E-03>,
      <-8.177832E-01, 2.953604E-01>,
      <-2.044556E-01, 7.419997E-02>,
      <-2.046E-01, 9.50455E-04>,
      <-2.046E-01, 9.50455E-04>,
      <-2.044556E-01, 7.419997E-02>,
      <-6.366501E-01, 9.263001E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.077E-01, 9.925001E-01>,
      <-6.366501E-01, 9.924985E-01>,
      <-8.045977E-01, 9.263E-01>,
      <-8.058926E-01, 9.445296E-01>,
      <-4.668931E-01, 9.445614E-01>,
      <-4.656E-01, 9.26301E-01>,
      <-8.058926E-01, 9.445296E-01>,
      <-8.070148E-01, 9.703102E-01>,
      <-4.680119E-01, 9.70342E-01>,
      <-4.668931E-01, 9.445614E-01>,
      <-8.070148E-01, 9.703102E-01>,
      <-8.077E-01, 9.925001E-01>,
      <-4.687034E-01, 9.925E-01>,
      <-4.680119E-01, 9.70342E-01>,
      <-4.656E-01, 9.810792E-01>,
      <-6.013628E-01, 9.263E-01>,
      <-8.077E-01, 9.377209E-01>,
      <-6.719353E-01, 9.925E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.662919E-01, 9.678896E-01>,
      <-8.052427E-01, 9.679187E-01>,
      <-8.045966E-01, 9.925E-01>,
      <-4.662919E-01, 9.678896E-01>,
      <-4.674243E-01, 9.449727E-01>,
      <-8.063785E-01, 9.450018E-01>,
      <-8.052427E-01, 9.679187E-01>,
      <-4.674243E-01, 9.449727E-01>,
      <-4.687022E-01, 9.263E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.063785E-01, 9.450018E-01>,
      <-4.656E-01, 9.820999E-01>,
      <-6.511061E-01, 9.263E-01>,
      <-8.076999E-01, 9.367001E-01>,
      <-6.221933E-01, 9.925E-01>,
      <-8.047949E-01, 9.263E-01>,
      <-8.053998E-01, 9.334068E-01>,
      <-4.662043E-01, 9.334333E-01>,
      <-4.656E-01, 9.26301E-01>,
      <-8.053998E-01, 9.334068E-01>,
      <-8.063581E-01, 9.472352E-01>,
      <-4.671637E-01, 9.472617E-01>,
      <-4.662043E-01, 9.334333E-01>,
      <-8.063581E-01, 9.472352E-01>,
      <-8.070373E-01, 9.611779E-01>,
      <-4.678464E-01, 9.612043E-01>,
      <-4.671637E-01, 9.472617E-01>,
      <-8.070373E-01, 9.611779E-01>,
      <-8.077005E-01, 9.783284E-01>,
      <-4.685073E-01, 9.783549E-01>,
      <-4.678464E-01, 9.612043E-01>,
      <-8.077005E-01, 9.783284E-01>,
      <-8.077E-01, 9.925001E-01>,
      <-4.685062E-01, 9.925E-01>,
      <-4.685073E-01, 9.783549E-01>,
      <-8.143413E-01, 9.251E-01>,
      <-8.158955E-01, 9.667082E-01>,
      <-4.746559E-01, 9.667693E-01>,
      <-4.731005E-01, 9.252461E-01>,
      <-8.158955E-01, 9.667082E-01>,
      <-8.165005E-01, 9.87354E-01>,
      <-4.752599E-01, 9.875E-01>,
      <-4.746559E-01, 9.667693E-01>,
      <-8.138481E-01, 9.251E-01>,
      <-8.165005E-01, 9.87354E-01>,
      <-4.757576E-01, 9.875E-01>,
      <-4.731005E-01, 9.252461E-01>,
      <-8.056706E-01, 9.251E-01>,
      <-8.165004E-01, 9.865987E-01>,
      <-4.839258E-01, 9.875E-01>,
      <-4.731004E-01, 9.260013E-01>,
      <-4.656E-01, 9.935129E-01>,
      <-6.405473E-01, 9.949143E-01>,
      <-6.40607E-01, 9.202015E-01>,
      <-4.656596E-01, 9.188001E-01>,
      <-5.641788E-01, 5.883074E-01>,
      <-6.759159E-01, 5.810612E-01>,
      <-7.89536E-01, 5.358341E-01>,
      <-8.119286E-01, 5.077778E-01>,
      <-8.116856E-01, 4.483239E-01>,
      <-7.410533E-01, 4.395881E-01>,
      <-6.970152E-01, 4.04516E-01>,
      <-6.689128E-01, 3.726806E-01>,
      <-6.566107E-01, 3.278061E-01>,
      <-6.565531E-01, 2.993928E-01>,
      <-4.662144E-01, 2.999625E-01>,
      <-4.584077E-01, 3.620643E-01>,
      <-4.18784E-01, 4.152457E-01>,
      <-3.440497E-01, 4.475738E-01>,
      <-2.09929E-01, 4.480829E-01>,
      <-1.512954E-01, 4.158841E-01>,
      <-1.042293E-01, 3.633384E-01>,
      <-9.688789E-02, 3.026984E-01>,
      <-5.871534E-03, 3.031187E-01>,
      <-5.305231E-03, 5.902659E-01>,
      <-1.31005E-03, 5.938998E-01>,
      <-1.874804E-03, 3.024706E-01>,
      <-9.464604E-02, 3.021559E-01>,
      <-9.998667E-02, 3.625397E-01>,
      <-1.469352E-01, 4.14954E-01>,
      <-2.054224E-01, 4.470723E-01>,
      <-3.392073E-01, 4.465645E-01>,
      <-4.137549E-01, 4.143173E-01>,
      <-4.532796E-01, 3.612688E-01>,
      <-4.610668E-01, 2.993222E-01>,
      <-6.559296E-01, 2.98754E-01>,
      <-6.559871E-01, 3.270963E-01>,
      <-6.682582E-01, 3.718586E-01>,
      <-6.962906E-01, 4.036143E-01>,
      <-7.462181E-01, 4.416088E-01>,
      <-8.106839E-01, 4.483452E-01>,
      <-8.10926E-01, 5.06618E-01>,
      <-7.885892E-01, 5.346041E-01>,
      <-6.702439E-01, 5.847182E-01>,
      <-5.587863E-01, 5.919462E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      152, 
      <1, 3, 2>, 0,
      <1, 2, 0>, 0,
      <3, 5, 4>, 0,
      <3, 4, 2>, 0,
      <5, 7, 6>, 0,
      <5, 6, 4>, 0,
      <7, 9, 8>, 0,
      <7, 8, 6>, 0,
      <9, 11, 10>, 0,
      <9, 10, 8>, 0,
      <11, 13, 12>, 0,
      <11, 12, 10>, 0,
      <13, 15, 14>, 0,
      <13, 14, 12>, 0,
      <15, 17, 16>, 0,
      <15, 16, 14>, 0,
      <17, 19, 18>, 0,
      <17, 18, 16>, 0,
      <19, 21, 20>, 0,
      <19, 20, 18>, 0,
      <21, 23, 22>, 0,
      <21, 22, 20>, 0,
      <23, 25, 24>, 0,
      <23, 24, 22>, 0,
      <25, 27, 26>, 0,
      <25, 26, 24>, 0,
      <27, 29, 28>, 0,
      <27, 28, 26>, 0,
      <29, 31, 30>, 0,
      <29, 30, 28>, 0,
      <31, 33, 32>, 0,
      <31, 32, 30>, 0,
      <33, 35, 34>, 0,
      <33, 34, 32>, 0,
      <35, 37, 36>, 0,
      <35, 36, 34>, 0,
      <37, 39, 38>, 0,
      <37, 38, 36>, 0,
      <39, 1, 0>, 0,
      <39, 0, 38>, 0,
      <0, 2, 4>, 0,
      <0, 4, 6>, 0,
      <0, 6, 8>, 0,
      <0, 8, 10>, 0,
      <0, 10, 12>, 0,
      <16, 18, 20>, 0,
      <16, 20, 22>, 0,
      <16, 22, 24>, 0,
      <16, 24, 26>, 0,
      <16, 26, 28>, 0,
      <28, 30, 32>, 0,
      <28, 32, 34>, 0,
      <28, 34, 36>, 0,
      <28, 36, 38>, 0,
      <28, 38, 0>, 0,
      <28, 0, 12>, 0,
      <28, 12, 14>, 0,
      <14, 16, 28>, 0,
      <1, 39, 37>, 0,
      <1, 37, 35>, 0,
      <1, 35, 33>, 0,
      <1, 33, 31>, 0,
      <1, 31, 29>, 0,
      <1, 29, 27>, 0,
      <1, 27, 25>, 0,
      <23, 21, 19>, 0,
      <23, 19, 17>, 0,
      <23, 17, 15>, 0,
      <23, 15, 13>, 0,
      <7, 5, 3>, 0,
      <7, 3, 1>, 0,
      <25, 23, 13>, 0,
      <9, 7, 1>, 0,
      <1, 25, 13>, 0,
      <1, 13, 11>, 0,
      <11, 9, 1>, 0,
      <0, 2, 3>, 0,
      <0, 3, 1>, 0,
      <2, 40, 41>, 0,
      <2, 41, 3>, 0,
      <40, 42, 43>, 0,
      <40, 43, 41>, 0,
      <42, 44, 45>, 0,
      <42, 45, 43>, 0,
      <44, 46, 47>, 0,
      <44, 47, 45>, 0,
      <46, 48, 49>, 0,
      <46, 49, 47>, 0,
      <48, 50, 51>, 0,
      <48, 51, 49>, 0,
      <50, 52, 53>, 0,
      <50, 53, 51>, 0,
      <52, 54, 55>, 0,
      <52, 55, 53>, 0,
      <54, 56, 57>, 0,
      <54, 57, 55>, 0,
      <56, 58, 59>, 0,
      <56, 59, 57>, 0,
      <58, 60, 61>, 0,
      <58, 61, 59>, 0,
      <60, 62, 63>, 0,
      <60, 63, 61>, 0,
      <62, 64, 65>, 0,
      <62, 65, 63>, 0,
      <64, 66, 67>, 0,
      <64, 67, 65>, 0,
      <66, 68, 69>, 0,
      <66, 69, 67>, 0,
      <68, 70, 71>, 0,
      <68, 71, 69>, 0,
      <70, 72, 73>, 0,
      <70, 73, 71>, 0,
      <72, 74, 75>, 0,
      <72, 75, 73>, 0,
      <74, 0, 1>, 0,
      <74, 1, 75>, 0,
      <0, 74, 72>, 0,
      <0, 72, 70>, 0,
      <0, 70, 68>, 0,
      <0, 68, 66>, 0,
      <0, 66, 64>, 0,
      <0, 64, 62>, 0,
      <0, 62, 60>, 0,
      <58, 56, 54>, 0,
      <58, 54, 52>, 0,
      <58, 52, 50>, 0,
      <58, 50, 48>, 0,
      <42, 40, 2>, 0,
      <42, 2, 0>, 0,
      <60, 58, 48>, 0,
      <44, 42, 0>, 0,
      <0, 60, 48>, 0,
      <0, 48, 46>, 0,
      <46, 44, 0>, 0,
      <1, 3, 41>, 0,
      <1, 41, 43>, 0,
      <1, 43, 45>, 0,
      <1, 45, 47>, 0,
      <1, 47, 49>, 0,
      <53, 55, 57>, 0,
      <53, 57, 59>, 0,
      <53, 59, 61>, 0,
      <53, 61, 63>, 0,
      <53, 63, 65>, 0,
      <65, 67, 69>, 0,
      <65, 69, 71>, 0,
      <65, 71, 73>, 0,
      <65, 73, 75>, 0,
      <65, 75, 1>, 0,
      <65, 1, 49>, 0,
      <65, 49, 51>, 0,
      <51, 53, 65>, 0
   }
 
   normal_indices { 
      152, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 3, 3>,
      <2, 3, 2>,
      <3, 4, 4>,
      <3, 4, 3>,
      <4, 5, 5>,
      <4, 5, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <6, 7, 7>,
      <6, 7, 6>,
      <7, 8, 8>,
      <7, 8, 7>,
      <8, 9, 9>,
      <8, 9, 8>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 10, 10>,
      <2, 10, 2>,
      <10, 11, 11>,
      <10, 11, 10>,
      <11, 12, 12>,
      <11, 12, 11>,
      <12, 13, 13>,
      <12, 13, 12>,
      <13, 1, 1>,
      <13, 1, 13>,
      <2, 14, 14>,
      <2, 14, 2>,
      <14, 15, 15>,
      <14, 15, 14>,
      <15, 16, 16>,
      <15, 16, 15>,
      <16, 17, 17>,
      <16, 17, 16>,
      <17, 18, 18>,
      <17, 18, 17>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <2, 2, 2>,
      <2, 2, 2>,
      <1, 1, 1>,
      <1, 1, 1>,
      <0, 21, 21>,
      <0, 21, 0>,
      <21, 22, 22>,
      <21, 22, 21>,
      <22, 23, 23>,
      <22, 23, 22>,
      <23, 24, 24>,
      <23, 24, 23>,
      <24, 25, 25>,
      <24, 25, 24>,
      <25, 26, 26>,
      <25, 26, 25>,
      <26, 27, 27>,
      <26, 27, 26>,
      <1, 1, 1>,
      <1, 1, 1>,
      <0, 28, 28>,
      <0, 28, 0>,
      <28, 29, 29>,
      <28, 29, 28>,
      <29, 30, 30>,
      <29, 30, 29>,
      <30, 31, 31>,
      <30, 31, 30>,
      <31, 1, 1>,
      <31, 1, 31>,
      <0, 32, 32>,
      <0, 32, 0>,
      <32, 33, 33>,
      <32, 33, 32>,
      <33, 34, 34>,
      <33, 34, 33>,
      <34, 35, 35>,
      <34, 35, 34>,
      <35, 18, 18>,
      <35, 18, 35>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>
   }
 
   uv_indices { 
      152, 
      <127, 128, 128>,
      <127, 128, 127>,
      <178, 179, 180>,
      <178, 180, 181>,
      <182, 183, 184>,
      <182, 184, 185>,
      <186, 187, 188>,
      <186, 188, 189>,
      <190, 191, 192>,
      <190, 192, 193>,
      <194, 195, 196>,
      <194, 196, 197>,
      <198, 199, 200>,
      <198, 200, 201>,
      <202, 203, 204>,
      <202, 204, 205>,
      <206, 207, 208>,
      <206, 208, 209>,
      <210, 211, 212>,
      <210, 212, 213>,
      <214, 215, 216>,
      <214, 216, 217>,
      <218, 219, 220>,
      <218, 220, 221>,
      <222, 223, 224>,
      <222, 224, 225>,
      <226, 227, 228>,
      <226, 228, 229>,
      <230, 231, 232>,
      <230, 232, 233>,
      <234, 235, 236>,
      <234, 236, 237>,
      <238, 239, 240>,
      <238, 240, 241>,
      <242, 243, 244>,
      <242, 244, 245>,
      <246, 247, 248>,
      <246, 248, 249>,
      <250, 251, 252>,
      <250, 252, 253>,
      <254, 255, 256>,
      <254, 256, 257>,
      <254, 257, 258>,
      <254, 258, 259>,
      <254, 259, 260>,
      <262, 263, 264>,
      <262, 264, 265>,
      <262, 265, 266>,
      <262, 266, 267>,
      <262, 267, 268>,
      <268, 269, 270>,
      <268, 270, 271>,
      <268, 271, 272>,
      <268, 272, 273>,
      <268, 273, 254>,
      <268, 254, 260>,
      <268, 260, 261>,
      <261, 262, 268>,
      <293, 274, 275>,
      <293, 275, 276>,
      <293, 276, 277>,
      <293, 277, 278>,
      <293, 278, 279>,
      <293, 279, 280>,
      <293, 280, 281>,
      <282, 283, 284>,
      <282, 284, 285>,
      <282, 285, 286>,
      <282, 286, 287>,
      <290, 291, 292>,
      <290, 292, 293>,
      <281, 282, 287>,
      <289, 290, 293>,
      <293, 281, 287>,
      <293, 287, 288>,
      <288, 289, 293>,
      <294, 295, 296>,
      <294, 296, 297>,
      <298, 299, 300>,
      <298, 300, 301>,
      <302, 303, 304>,
      <302, 304, 305>,
      <306, 307, 308>,
      <306, 308, 309>,
      <310, 311, 312>,
      <310, 312, 313>,
      <314, 315, 316>,
      <314, 316, 317>,
      <318, 319, 320>,
      <318, 320, 321>,
      <322, 323, 324>,
      <322, 324, 325>,
      <326, 327, 328>,
      <326, 328, 329>,
      <330, 331, 332>,
      <330, 332, 333>,
      <334, 335, 336>,
      <334, 336, 337>,
      <338, 339, 340>,
      <338, 340, 341>,
      <342, 343, 344>,
      <342, 344, 345>,
      <346, 347, 348>,
      <346, 348, 349>,
      <350, 351, 352>,
      <350, 352, 353>,
      <354, 355, 356>,
      <354, 356, 357>,
      <358, 359, 360>,
      <358, 360, 361>,
      <362, 363, 364>,
      <362, 364, 365>,
      <366, 367, 368>,
      <366, 368, 369>,
      <370, 371, 372>,
      <370, 372, 373>,
      <393, 374, 375>,
      <393, 375, 376>,
      <393, 376, 377>,
      <393, 377, 378>,
      <393, 378, 379>,
      <393, 379, 380>,
      <393, 380, 381>,
      <382, 383, 384>,
      <382, 384, 385>,
      <382, 385, 386>,
      <382, 386, 387>,
      <390, 391, 392>,
      <390, 392, 393>,
      <381, 382, 387>,
      <389, 390, 393>,
      <393, 381, 387>,
      <393, 387, 388>,
      <388, 389, 393>,
      <394, 395, 396>,
      <394, 396, 397>,
      <394, 397, 398>,
      <394, 398, 399>,
      <394, 399, 400>,
      <402, 403, 404>,
      <402, 404, 405>,
      <402, 405, 406>,
      <402, 406, 407>,
      <402, 407, 408>,
      <408, 409, 410>,
      <408, 410, 411>,
      <408, 411, 412>,
      <408, 412, 413>,
      <408, 413, 394>,
      <408, 394, 400>,
      <408, 400, 401>,
      <401, 402, 408>
   }
   uv_mapping
}
 
#declare Tex29 =
texture {
   pigment {image_map { tga "T-AlphaWheels.TGA" interpolate 2}}
   finish {ambient 4.472136E-01 diffuse 6.40E-01 brilliance 1.00E+00 specular 6.25E-02 roughness 1.25E-01}
}
 
// Rim-Outer
mesh2 {
 
   vertex_vectors { 
      64, 
      <-1.025371E+00, 2.95635E+00, -2.643604E+01>,
      <-1.41937E+00, 2.95635E+00, -2.643604E+01>,
      <-1.025371E+00, 3.24862E+00, -2.640726E+01>,
      <-1.41937E+00, 3.24862E+00, -2.640726E+01>,
      <-1.025371E+00, 3.529657E+00, -2.632201E+01>,
      <-1.41937E+00, 3.529657E+00, -2.632201E+01>,
      <-1.025371E+00, 3.788663E+00, -2.618356E+01>,
      <-1.41937E+00, 3.788663E+00, -2.618356E+01>,
      <-1.025371E+00, 4.015684E+00, -2.599725E+01>,
      <-1.41937E+00, 4.015684E+00, -2.599725E+01>,
      <-1.025371E+00, 4.201995E+00, -2.577023E+01>,
      <-1.41937E+00, 4.201995E+00, -2.577023E+01>,
      <-1.025371E+00, 4.340436E+00, -2.551123E+01>,
      <-1.41937E+00, 4.340436E+00, -2.551123E+01>,
      <-1.025371E+00, 4.425689E+00, -2.523019E+01>,
      <-1.419371E+00, 4.425689E+00, -2.523019E+01>,
      <-1.025372E+00, 4.454475E+00, -2.493792E+01>,
      <-1.419371E+00, 4.454475E+00, -2.493792E+01>,
      <-1.025372E+00, 4.425689E+00, -2.464565E+01>,
      <-1.419371E+00, 4.425689E+00, -2.464565E+01>,
      <-1.025372E+00, 4.340436E+00, -2.436461E+01>,
      <-1.419371E+00, 4.340436E+00, -2.436461E+01>,
      <-1.025372E+00, 4.201995E+00, -2.41056E+01>,
      <-1.419371E+00, 4.201995E+00, -2.41056E+01>,
      <-1.025372E+00, 4.015684E+00, -2.387858E+01>,
      <-1.419371E+00, 4.015684E+00, -2.387858E+01>,
      <-1.025372E+00, 3.788663E+00, -2.369227E+01>,
      <-1.419371E+00, 3.788663E+00, -2.369227E+01>,
      <-1.025372E+00, 3.529657E+00, -2.355383E+01>,
      <-1.419371E+00, 3.529657E+00, -2.355383E+01>,
      <-1.025372E+00, 3.24862E+00, -2.346858E+01>,
      <-1.419371E+00, 3.24862E+00, -2.346858E+01>,
      <-1.025372E+00, 2.95635E+00, -2.343979E+01>,
      <-1.419371E+00, 2.95635E+00, -2.343979E+01>,
      <-1.025372E+00, 2.66408E+00, -2.346858E+01>,
      <-1.419371E+00, 2.66408E+00, -2.346858E+01>,
      <-1.025372E+00, 2.383042E+00, -2.355383E+01>,
      <-1.419371E+00, 2.383042E+00, -2.355383E+01>,
      <-1.025372E+00, 2.124036E+00, -2.369227E+01>,
      <-1.419371E+00, 2.124036E+00, -2.369227E+01>,
      <-1.025372E+00, 1.897016E+00, -2.387858E+01>,
      <-1.419371E+00, 1.897015E+00, -2.387858E+01>,
      <-1.025372E+00, 1.710705E+00, -2.41056E+01>,
      <-1.419371E+00, 1.710705E+00, -2.41056E+01>,
      <-1.025372E+00, 1.572263E+00, -2.436461E+01>,
      <-1.419371E+00, 1.572263E+00, -2.436461E+01>,
      <-1.025372E+00, 1.487011E+00, -2.464565E+01>,
      <-1.419371E+00, 1.487011E+00, -2.464565E+01>,
      <-1.025372E+00, 1.458225E+00, -2.493792E+01>,
      <-1.419371E+00, 1.458225E+00, -2.493792E+01>,
      <-1.025371E+00, 1.487011E+00, -2.523019E+01>,
      <-1.419371E+00, 1.487011E+00, -2.523019E+01>,
      <-1.025371E+00, 1.572263E+00, -2.551123E+01>,
      <-1.41937E+00, 1.572263E+00, -2.551123E+01>,
      <-1.025371E+00, 1.710705E+00, -2.577023E+01>,
      <-1.41937E+00, 1.710705E+00, -2.577023E+01>,
      <-1.025371E+00, 1.897015E+00, -2.599725E+01>,
      <-1.41937E+00, 1.897015E+00, -2.599725E+01>,
      <-1.025371E+00, 2.124036E+00, -2.618356E+01>,
      <-1.41937E+00, 2.124036E+00, -2.618356E+01>,
      <-1.025371E+00, 2.383042E+00, -2.632201E+01>,
      <-1.41937E+00, 2.383042E+00, -2.632201E+01>,
      <-1.025371E+00, 2.66408E+00, -2.640726E+01>,
      <-1.41937E+00, 2.66408E+00, -2.640726E+01>
   }
 
   normal_vectors { 
      32, 
      <3.195804E-07, 1.950906E-01, -9.807853E-01>,
      <3.258414E-07, 2.067536E-07, -1.00E+00>,
      <3.010385E-07, 3.826814E-01, -9.238805E-01>,
      <2.709268E-07, 5.555722E-01, -8.314685E-01>,
      <2.304045E-07, 7.071075E-01, -7.071063E-01>,
      <1.810278E-07, 8.314698E-01, -5.555702E-01>,
      <1.246948E-07, 9.238788E-01, -3.826857E-01>,
      <6.356854E-08, 9.807855E-01, -1.950904E-01>,
      <1.67539E-15, 1.00E+00, 2.065869E-15>,
      <-6.356848E-08, 9.807855E-01, 1.950902E-01>,
      <-1.246948E-07, 9.238788E-01, 3.826855E-01>,
      <-1.810277E-07, 8.314698E-01, 5.555701E-01>,
      <-2.304045E-07, 7.071075E-01, 7.071063E-01>,
      <-2.709268E-07, 5.555721E-01, 8.314685E-01>,
      <-3.010385E-07, 3.826814E-01, 9.238805E-01>,
      <-3.195804E-07, 1.950907E-01, 9.807853E-01>,
      <-3.258414E-07, 2.067536E-07, 1.00E+00>,
      <-3.195804E-07, -1.950902E-01, 9.807853E-01>,
      <-3.010385E-07, -3.826809E-01, 9.238805E-01>,
      <-2.709268E-07, -5.555718E-01, 8.314685E-01>,
      <-2.304045E-07, -7.071071E-01, 7.071064E-01>,
      <-1.810278E-07, -8.314694E-01, 5.555703E-01>,
      <-1.246947E-07, -9.238786E-01, 3.826851E-01>,
      <-6.356841E-08, -9.807852E-01, 1.950901E-01>,
      <-1.67539E-15, -9.999998E-01, -2.065869E-15>,
      <6.356843E-08, -9.807851E-01, -1.950901E-01>,
      <1.246947E-07, -9.238786E-01, -3.826851E-01>,
      <1.810278E-07, -8.314694E-01, -5.555703E-01>,
      <2.304045E-07, -7.071071E-01, -7.071064E-01>,
      <2.709268E-07, -5.555717E-01, -8.314685E-01>,
      <3.010385E-07, -3.826809E-01, -9.238805E-01>,
      <3.195804E-07, -1.950902E-01, -9.807853E-01>
   }
 
   uv_vectors { 
      63, 
      <0.00E+00, 0.00E+00>,
      <-5.92646E-02, 1.175001E-01>,
      <-3.073543E-02, 1.175001E-01>,
      <-3.073543E-02, 1.855E-01>,
      <-5.92646E-02, 1.855E-01>,
      <-2.999997E-02, 1.855E-01>,
      <-5.999994E-02, 1.855E-01>,
      <-5.999994E-02, 1.175E-01>,
      <-2.999997E-02, 1.175E-01>,
      <-5.999994E-02, 1.175E-01>,
      <-2.999997E-02, 1.175E-01>,
      <-2.999997E-02, 1.515003E-01>,
      <-5.999994E-02, 1.515003E-01>,
      <-6.00E-02, 1.174999E-01>,
      <-3.000015E-02, 1.174999E-01>,
      <-5.999994E-02, 1.175006E-01>,
      <-2.999997E-02, 1.175E-01>,
      <-6.000012E-02, 1.174999E-01>,
      <-3.000009E-02, 1.174999E-01>,
      <-6.000012E-02, 1.175E-01>,
      <-3.000009E-02, 1.175E-01>,
      <-5.999994E-02, 1.175E-01>,
      <-2.999997E-02, 1.175E-01>,
      <-3.000009E-02, 1.175E-01>,
      <-6.000006E-02, 1.175E-01>,
      <-3.000009E-02, 1.175E-01>,
      <-6.000006E-02, 1.175E-01>,
      <-3.000009E-02, 1.174999E-01>,
      <-6.000006E-02, 1.174999E-01>,
      <-9.956321E-01, 6.754004E-01>,
      <-9.956321E-01, 5.006004E-01>,
      <-9.988E-01, 5.006004E-01>,
      <-9.988E-01, 6.754004E-01>,
      <-9.862515E-01, 6.754004E-01>,
      <-9.862515E-01, 5.006004E-01>,
      <-9.710175E-01, 6.754004E-01>,
      <-9.710175E-01, 5.006004E-01>,
      <-9.505165E-01, 6.754004E-01>,
      <-9.505165E-01, 5.006004E-01>,
      <-9.255355E-01, 6.754004E-01>,
      <-9.255355E-01, 5.006004E-01>,
      <-8.970354E-01, 6.754004E-01>,
      <-8.970354E-01, 5.006004E-01>,
      <-8.661107E-01, 6.754004E-01>,
      <-8.661107E-01, 5.006004E-01>,
      <-8.3395E-01, 6.754004E-01>,
      <-8.3395E-01, 5.006004E-01>,
      <-8.017893E-01, 6.754004E-01>,
      <-8.017893E-01, 5.006004E-01>,
      <-7.708645E-01, 6.754004E-01>,
      <-7.708645E-01, 5.006004E-01>,
      <-7.423645E-01, 6.754004E-01>,
      <-7.423645E-01, 5.006004E-01>,
      <-7.173835E-01, 6.754004E-01>,
      <-7.173835E-01, 5.006004E-01>,
      <-6.968824E-01, 6.754004E-01>,
      <-6.968824E-01, 5.006004E-01>,
      <-6.816484E-01, 6.754004E-01>,
      <-6.816484E-01, 5.006004E-01>,
      <-6.722679E-01, 6.754004E-01>,
      <-6.722679E-01, 5.006004E-01>,
      <-6.691E-01, 6.754004E-01>,
      <-6.691E-01, 5.006004E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      64, 
      <3, 2, 0>, 0,
      <3, 0, 1>, 0,
      <5, 4, 2>, 0,
      <5, 2, 3>, 0,
      <7, 6, 4>, 0,
      <7, 4, 5>, 0,
      <9, 8, 6>, 0,
      <9, 6, 7>, 0,
      <11, 10, 8>, 0,
      <11, 8, 9>, 0,
      <13, 12, 10>, 0,
      <13, 10, 11>, 0,
      <15, 14, 12>, 0,
      <15, 12, 13>, 0,
      <17, 16, 14>, 0,
      <17, 14, 15>, 0,
      <19, 18, 16>, 0,
      <19, 16, 17>, 0,
      <21, 20, 18>, 0,
      <21, 18, 19>, 0,
      <23, 22, 20>, 0,
      <23, 20, 21>, 0,
      <25, 24, 22>, 0,
      <25, 22, 23>, 0,
      <27, 26, 24>, 0,
      <27, 24, 25>, 0,
      <29, 28, 26>, 0,
      <29, 26, 27>, 0,
      <31, 30, 28>, 0,
      <31, 28, 29>, 0,
      <33, 32, 30>, 0,
      <33, 30, 31>, 0,
      <35, 34, 32>, 0,
      <35, 32, 33>, 0,
      <37, 36, 34>, 0,
      <37, 34, 35>, 0,
      <39, 38, 36>, 0,
      <39, 36, 37>, 0,
      <41, 40, 38>, 0,
      <41, 38, 39>, 0,
      <43, 42, 40>, 0,
      <43, 40, 41>, 0,
      <45, 44, 42>, 0,
      <45, 42, 43>, 0,
      <47, 46, 44>, 0,
      <47, 44, 45>, 0,
      <49, 48, 46>, 0,
      <49, 46, 47>, 0,
      <51, 50, 48>, 0,
      <51, 48, 49>, 0,
      <53, 52, 50>, 0,
      <53, 50, 51>, 0,
      <55, 54, 52>, 0,
      <55, 52, 53>, 0,
      <57, 56, 54>, 0,
      <57, 54, 55>, 0,
      <59, 58, 56>, 0,
      <59, 56, 57>, 0,
      <61, 60, 58>, 0,
      <61, 58, 59>, 0,
      <63, 62, 60>, 0,
      <63, 60, 61>, 0,
      <1, 0, 62>, 0,
      <1, 62, 63>, 0
   }
 
   normal_indices { 
      64, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 2, 0>,
      <2, 0, 0>,
      <3, 3, 2>,
      <3, 2, 2>,
      <4, 4, 3>,
      <4, 3, 3>,
      <5, 5, 4>,
      <5, 4, 4>,
      <6, 6, 5>,
      <6, 5, 5>,
      <7, 7, 6>,
      <7, 6, 6>,
      <8, 8, 7>,
      <8, 7, 7>,
      <9, 9, 8>,
      <9, 8, 8>,
      <10, 10, 9>,
      <10, 9, 9>,
      <11, 11, 10>,
      <11, 10, 10>,
      <12, 12, 11>,
      <12, 11, 11>,
      <13, 13, 12>,
      <13, 12, 12>,
      <14, 14, 13>,
      <14, 13, 13>,
      <15, 15, 14>,
      <15, 14, 14>,
      <16, 16, 15>,
      <16, 15, 15>,
      <17, 17, 16>,
      <17, 16, 16>,
      <18, 18, 17>,
      <18, 17, 17>,
      <19, 19, 18>,
      <19, 18, 18>,
      <20, 20, 19>,
      <20, 19, 19>,
      <21, 21, 20>,
      <21, 20, 20>,
      <22, 22, 21>,
      <22, 21, 21>,
      <23, 23, 22>,
      <23, 22, 22>,
      <24, 24, 23>,
      <24, 23, 23>,
      <25, 25, 24>,
      <25, 24, 24>,
      <26, 26, 25>,
      <26, 25, 25>,
      <27, 27, 26>,
      <27, 26, 26>,
      <28, 28, 27>,
      <28, 27, 27>,
      <29, 29, 28>,
      <29, 28, 28>,
      <30, 30, 29>,
      <30, 29, 29>,
      <31, 31, 30>,
      <31, 30, 30>,
      <1, 1, 31>,
      <1, 31, 31>
   }
 
   uv_indices { 
      64, 
      <29, 30, 31>,
      <29, 31, 32>,
      <33, 34, 30>,
      <33, 30, 29>,
      <35, 36, 34>,
      <35, 34, 33>,
      <37, 38, 36>,
      <37, 36, 35>,
      <39, 40, 38>,
      <39, 38, 37>,
      <41, 42, 40>,
      <41, 40, 39>,
      <43, 44, 42>,
      <43, 42, 41>,
      <45, 46, 44>,
      <45, 44, 43>,
      <47, 48, 46>,
      <47, 46, 45>,
      <49, 50, 48>,
      <49, 48, 47>,
      <51, 52, 50>,
      <51, 50, 49>,
      <53, 54, 52>,
      <53, 52, 51>,
      <55, 56, 54>,
      <55, 54, 53>,
      <57, 58, 56>,
      <57, 56, 55>,
      <59, 60, 58>,
      <59, 58, 57>,
      <61, 62, 60>,
      <61, 60, 59>,
      <59, 60, 62>,
      <59, 62, 61>,
      <57, 58, 60>,
      <57, 60, 59>,
      <55, 56, 58>,
      <55, 58, 57>,
      <53, 54, 56>,
      <53, 56, 55>,
      <51, 52, 54>,
      <51, 54, 53>,
      <49, 50, 52>,
      <49, 52, 51>,
      <47, 48, 50>,
      <47, 50, 49>,
      <45, 46, 48>,
      <45, 48, 47>,
      <43, 44, 46>,
      <43, 46, 45>,
      <41, 42, 44>,
      <41, 44, 43>,
      <39, 40, 42>,
      <39, 42, 41>,
      <37, 38, 40>,
      <37, 40, 39>,
      <35, 36, 38>,
      <35, 38, 37>,
      <33, 34, 36>,
      <33, 36, 35>,
      <29, 30, 34>,
      <29, 34, 33>,
      <32, 31, 30>,
      <32, 30, 29>
   }
   uv_mapping
}
 
// Faces
mesh2 {
 
   vertex_vectors { 
      8, 
      <-1.419371E+00, 1.458225E+00, -2.343979E+01>,
      <-1.41937E+00, 1.458225E+00, -2.643604E+01>,
      <-1.41937E+00, 4.454475E+00, -2.643604E+01>,
      <-1.419371E+00, 4.454475E+00, -2.343979E+01>,
      <-1.025371E+00, 4.454475E+00, -2.643604E+01>,
      <-1.025372E+00, 4.454475E+00, -2.343979E+01>,
      <-1.025372E+00, 1.458225E+00, -2.343979E+01>,
      <-1.025371E+00, 1.458225E+00, -2.643604E+01>
   }
 
   normal_vectors { 
      2, 
      <-1.00E+00, 2.067536E-07, -3.258414E-07>,
      <1.00E+00, 2.067536E-07, 3.258414E-07>
   }
 
   uv_vectors { 
      12, 
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <-1.00E+00, 2.50E-01>,
      <-7.50E-01, 2.50E-01>,
      <-7.50E-01, 0.00E+00>,
      <-1.00E+00, 0.00E+00>,
      <-1.00E+00, 0.00E+00>,
      <-5.00E-01, 5.00E-01>,
      <-1.00E+00, 5.00E-01>,
      <-1.00E+00, 0.00E+00>,
      <-5.00E-01, 0.00E+00>,
      <0.00E+00, 5.00E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      4, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0
   }
 
   normal_indices { 
      4, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>
   }
 
   uv_indices { 
      4, 
      <7, 8, 9>,
      <7, 9, 10>,
      <11, 7, 10>,
      <11, 10, 0>
   }
   uv_mapping
}
 
// Flange
mesh2 {
 
   vertex_vectors { 
      4, 
      <-1.025372E+00, 1.265476E+00, -2.324705E+01>,
      <-1.025371E+00, 1.265476E+00, -2.662879E+01>,
      <-1.025371E+00, 4.647224E+00, -2.662879E+01>,
      <-1.025372E+00, 4.647224E+00, -2.324705E+01>
   }
 
   normal_vectors { 
      1, 
      <-1.00E+00, 2.067536E-07, -3.258414E-07>
   }
 
   uv_vectors { 
      9, 
      <0.00E+00, 0.00E+00>,
      <-1.00E+00, 2.50E-01>,
      <-7.50E-01, 2.50E-01>,
      <-7.50E-01, 0.00E+00>,
      <-1.00E+00, 0.00E+00>,
      <-5.000001E-01, 5.00E-01>,
      <-1.00E+00, 5.00E-01>,
      <-1.00E+00, 0.00E+00>,
      <-5.000001E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      2, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0
   }
 
   normal_indices { 
      2, 
      <0, 0, 0>,
      <0, 0, 0>
   }
 
   uv_indices { 
      2, 
      <5, 6, 7>,
      <5, 7, 8>
   }
   uv_mapping
}
 
// Rim-Outer
mesh2 {
 
   vertex_vectors { 
      64, 
      <3.682629E+00, 1.458225E+00, -2.493792E+01>,
      <4.07663E+00, 1.458225E+00, -2.493792E+01>,
      <3.682629E+00, 1.487011E+00, -2.464565E+01>,
      <4.07663E+00, 1.487011E+00, -2.464565E+01>,
      <3.682628E+00, 1.572263E+00, -2.43646E+01>,
      <4.07663E+00, 1.572263E+00, -2.43646E+01>,
      <3.682628E+00, 1.710704E+00, -2.41056E+01>,
      <4.076629E+00, 1.710705E+00, -2.41056E+01>,
      <3.682628E+00, 1.897015E+00, -2.387858E+01>,
      <4.076629E+00, 1.897015E+00, -2.387858E+01>,
      <3.682628E+00, 2.124036E+00, -2.369227E+01>,
      <4.076629E+00, 2.124036E+00, -2.369227E+01>,
      <3.682628E+00, 2.383042E+00, -2.355383E+01>,
      <4.076629E+00, 2.383042E+00, -2.355383E+01>,
      <3.682628E+00, 2.66408E+00, -2.346858E+01>,
      <4.076629E+00, 2.66408E+00, -2.346858E+01>,
      <3.682628E+00, 2.95635E+00, -2.343979E+01>,
      <4.076629E+00, 2.95635E+00, -2.343979E+01>,
      <3.682628E+00, 3.24862E+00, -2.346858E+01>,
      <4.076629E+00, 3.24862E+00, -2.346858E+01>,
      <3.682628E+00, 3.529657E+00, -2.355383E+01>,
      <4.076629E+00, 3.529657E+00, -2.355383E+01>,
      <3.682628E+00, 3.788663E+00, -2.369227E+01>,
      <4.076629E+00, 3.788663E+00, -2.369227E+01>,
      <3.682628E+00, 4.015684E+00, -2.387858E+01>,
      <4.076629E+00, 4.015684E+00, -2.387858E+01>,
      <3.682628E+00, 4.201995E+00, -2.41056E+01>,
      <4.076629E+00, 4.201995E+00, -2.41056E+01>,
      <3.682628E+00, 4.340437E+00, -2.43646E+01>,
      <4.07663E+00, 4.340436E+00, -2.43646E+01>,
      <3.682629E+00, 4.425689E+00, -2.464565E+01>,
      <4.07663E+00, 4.425689E+00, -2.464565E+01>,
      <3.682629E+00, 4.454475E+00, -2.493792E+01>,
      <4.07663E+00, 4.454475E+00, -2.493792E+01>,
      <3.682629E+00, 4.425689E+00, -2.523019E+01>,
      <4.07663E+00, 4.425689E+00, -2.523019E+01>,
      <3.682629E+00, 4.340437E+00, -2.551123E+01>,
      <4.07663E+00, 4.340436E+00, -2.551123E+01>,
      <3.682629E+00, 4.201995E+00, -2.577023E+01>,
      <4.07663E+00, 4.201995E+00, -2.577023E+01>,
      <3.682629E+00, 4.015685E+00, -2.599725E+01>,
      <4.07663E+00, 4.015684E+00, -2.599725E+01>,
      <3.682629E+00, 3.788664E+00, -2.618356E+01>,
      <4.07663E+00, 3.788664E+00, -2.618356E+01>,
      <3.682629E+00, 3.529657E+00, -2.632201E+01>,
      <4.07663E+00, 3.529657E+00, -2.632201E+01>,
      <3.682629E+00, 3.24862E+00, -2.640725E+01>,
      <4.07663E+00, 3.24862E+00, -2.640725E+01>,
      <3.682629E+00, 2.95635E+00, -2.643604E+01>,
      <4.07663E+00, 2.95635E+00, -2.643604E+01>,
      <3.682629E+00, 2.66408E+00, -2.640725E+01>,
      <4.07663E+00, 2.66408E+00, -2.640725E+01>,
      <3.682629E+00, 2.383042E+00, -2.632201E+01>,
      <4.07663E+00, 2.383042E+00, -2.632201E+01>,
      <3.682629E+00, 2.124036E+00, -2.618356E+01>,
      <4.07663E+00, 2.124036E+00, -2.618356E+01>,
      <3.682629E+00, 1.897015E+00, -2.599725E+01>,
      <4.07663E+00, 1.897015E+00, -2.599725E+01>,
      <3.682629E+00, 1.710704E+00, -2.577023E+01>,
      <4.07663E+00, 1.710705E+00, -2.577023E+01>,
      <3.682629E+00, 1.572263E+00, -2.551123E+01>,
      <4.07663E+00, 1.572263E+00, -2.551123E+01>,
      <3.682629E+00, 1.487011E+00, -2.523019E+01>,
      <4.07663E+00, 1.487011E+00, -2.523019E+01>
   }
 
   normal_vectors { 
      32, 
      <2.40907E-07, -9.807851E-01, 1.950902E-01>,
      <-1.67539E-15, -9.999998E-01, -2.065869E-15>,
      <1.834552E-07, -9.238785E-01, 3.826854E-01>,
      <6.338081E-08, -8.314694E-01, 5.555703E-01>,
      <-5.072556E-08, -7.071071E-01, 7.071063E-01>,
      <-1.221962E-07, -5.555717E-01, 8.314685E-01>,
      <-1.943313E-07, -3.826808E-01, 9.238805E-01>,
      <-2.706134E-07, -1.950902E-01, 9.807853E-01>,
      <-3.258414E-07, 2.067536E-07, 1.00E+00>,
      <-3.195804E-07, 1.950905E-01, 9.807853E-01>,
      <-3.010385E-07, 3.826813E-01, 9.238805E-01>,
      <-2.709268E-07, 5.55572E-01, 8.314685E-01>,
      <-1.543815E-07, 7.071074E-01, 7.071064E-01>,
      <1.737604E-07, 8.314698E-01, 5.555702E-01>,
      <2.987719E-07, 9.238789E-01, 3.826853E-01>,
      <2.331789E-07, 9.807855E-01, 1.950901E-01>,
      <1.67539E-15, 1.00E+00, 2.065869E-15>,
      <3.676611E-07, 9.807855E-01, -1.950903E-01>,
      <5.881826E-07, 9.238788E-01, -3.826856E-01>,
      <6.69845E-07, 8.314698E-01, -5.555702E-01>,
      <5.436733E-07, 7.071075E-01, -7.071062E-01>,
      <4.828423E-07, 5.55572E-01, -8.314685E-01>,
      <3.989722E-07, 3.826813E-01, -9.238805E-01>,
      <3.41491E-07, 1.950906E-01, -9.807853E-01>,
      <3.258414E-07, 2.067536E-07, -1.00E+00>,
      <3.195804E-07, -1.950901E-01, -9.807853E-01>,
      <3.770616E-07, -3.826809E-01, -9.238805E-01>,
      <4.321149E-07, -5.555717E-01, -8.314685E-01>,
      <4.376813E-07, -7.071071E-01, -7.071063E-01>,
      <4.42522E-07, -8.314693E-01, -5.555704E-01>,
      <4.124513E-07, -9.238785E-01, -3.826854E-01>,
      <3.636056E-07, -9.807851E-01, -1.950901E-01>
   }
 
   uv_vectors { 
      41, 
      <0.00E+00, 0.00E+00>,
      <-3.000003E-02, 1.855E-01>,
      <-6.00E-02, 1.855E-01>,
      <-6.00E-02, 1.175E-01>,
      <-3.000003E-02, 1.175E-01>,
      <-6.00E-02, 1.514999E-01>,
      <-3.000003E-02, 1.514999E-01>,
      <-8.017893E-01, 6.754E-01>,
      <-8.017893E-01, 5.006E-01>,
      <-8.3395E-01, 5.006E-01>,
      <-8.3395E-01, 6.754E-01>,
      <-7.708645E-01, 6.754E-01>,
      <-7.708645E-01, 5.006E-01>,
      <-7.423645E-01, 6.754E-01>,
      <-7.423645E-01, 5.006E-01>,
      <-7.173835E-01, 6.754E-01>,
      <-7.173835E-01, 5.006E-01>,
      <-6.968824E-01, 6.754E-01>,
      <-6.968824E-01, 5.006E-01>,
      <-6.816484E-01, 6.754E-01>,
      <-6.816484E-01, 5.006E-01>,
      <-6.722679E-01, 6.754E-01>,
      <-6.722679E-01, 5.006E-01>,
      <-6.691E-01, 6.754E-01>,
      <-6.691E-01, 5.006E-01>,
      <-8.661107E-01, 6.754E-01>,
      <-8.661107E-01, 5.006E-01>,
      <-8.970354E-01, 6.754E-01>,
      <-8.970354E-01, 5.006E-01>,
      <-9.255355E-01, 6.754E-01>,
      <-9.255355E-01, 5.006E-01>,
      <-9.505165E-01, 6.754E-01>,
      <-9.505165E-01, 5.006E-01>,
      <-9.710175E-01, 6.754E-01>,
      <-9.710175E-01, 5.006E-01>,
      <-9.862515E-01, 6.754E-01>,
      <-9.862515E-01, 5.006E-01>,
      <-9.956321E-01, 6.754E-01>,
      <-9.956321E-01, 5.006E-01>,
      <-9.988E-01, 6.754E-01>,
      <-9.988E-01, 5.006E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      64, 
      <3, 2, 0>, 0,
      <3, 0, 1>, 0,
      <5, 4, 2>, 0,
      <5, 2, 3>, 0,
      <7, 6, 4>, 0,
      <7, 4, 5>, 0,
      <9, 8, 6>, 0,
      <9, 6, 7>, 0,
      <11, 10, 8>, 0,
      <11, 8, 9>, 0,
      <13, 12, 10>, 0,
      <13, 10, 11>, 0,
      <15, 14, 12>, 0,
      <15, 12, 13>, 0,
      <17, 16, 14>, 0,
      <17, 14, 15>, 0,
      <19, 18, 16>, 0,
      <19, 16, 17>, 0,
      <21, 20, 18>, 0,
      <21, 18, 19>, 0,
      <23, 22, 20>, 0,
      <23, 20, 21>, 0,
      <25, 24, 22>, 0,
      <25, 22, 23>, 0,
      <27, 26, 24>, 0,
      <27, 24, 25>, 0,
      <29, 28, 26>, 0,
      <29, 26, 27>, 0,
      <31, 30, 28>, 0,
      <31, 28, 29>, 0,
      <33, 32, 30>, 0,
      <33, 30, 31>, 0,
      <35, 34, 32>, 0,
      <35, 32, 33>, 0,
      <37, 36, 34>, 0,
      <37, 34, 35>, 0,
      <39, 38, 36>, 0,
      <39, 36, 37>, 0,
      <41, 40, 38>, 0,
      <41, 38, 39>, 0,
      <43, 42, 40>, 0,
      <43, 40, 41>, 0,
      <45, 44, 42>, 0,
      <45, 42, 43>, 0,
      <47, 46, 44>, 0,
      <47, 44, 45>, 0,
      <49, 48, 46>, 0,
      <49, 46, 47>, 0,
      <51, 50, 48>, 0,
      <51, 48, 49>, 0,
      <53, 52, 50>, 0,
      <53, 50, 51>, 0,
      <55, 54, 52>, 0,
      <55, 52, 53>, 0,
      <57, 56, 54>, 0,
      <57, 54, 55>, 0,
      <59, 58, 56>, 0,
      <59, 56, 57>, 0,
      <61, 60, 58>, 0,
      <61, 58, 59>, 0,
      <63, 62, 60>, 0,
      <63, 60, 61>, 0,
      <1, 0, 62>, 0,
      <1, 62, 63>, 0
   }
 
   normal_indices { 
      64, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 2, 0>,
      <2, 0, 0>,
      <3, 3, 2>,
      <3, 2, 2>,
      <4, 4, 3>,
      <4, 3, 3>,
      <5, 5, 4>,
      <5, 4, 4>,
      <6, 6, 5>,
      <6, 5, 5>,
      <7, 7, 6>,
      <7, 6, 6>,
      <8, 8, 7>,
      <8, 7, 7>,
      <9, 9, 8>,
      <9, 8, 8>,
      <10, 10, 9>,
      <10, 9, 9>,
      <11, 11, 10>,
      <11, 10, 10>,
      <12, 12, 11>,
      <12, 11, 11>,
      <13, 13, 12>,
      <13, 12, 12>,
      <14, 14, 13>,
      <14, 13, 13>,
      <15, 15, 14>,
      <15, 14, 14>,
      <16, 16, 15>,
      <16, 15, 15>,
      <17, 17, 16>,
      <17, 16, 16>,
      <18, 18, 17>,
      <18, 17, 17>,
      <19, 19, 18>,
      <19, 18, 18>,
      <20, 20, 19>,
      <20, 19, 19>,
      <21, 21, 20>,
      <21, 20, 20>,
      <22, 22, 21>,
      <22, 21, 21>,
      <23, 23, 22>,
      <23, 22, 22>,
      <24, 24, 23>,
      <24, 23, 23>,
      <25, 25, 24>,
      <25, 24, 24>,
      <26, 26, 25>,
      <26, 25, 25>,
      <27, 27, 26>,
      <27, 26, 26>,
      <28, 28, 27>,
      <28, 27, 27>,
      <29, 29, 28>,
      <29, 28, 28>,
      <30, 30, 29>,
      <30, 29, 29>,
      <31, 31, 30>,
      <31, 30, 30>,
      <1, 1, 31>,
      <1, 31, 31>
   }
 
   uv_indices { 
      64, 
      <7, 8, 9>,
      <7, 9, 10>,
      <11, 12, 8>,
      <11, 8, 7>,
      <13, 14, 12>,
      <13, 12, 11>,
      <15, 16, 14>,
      <15, 14, 13>,
      <17, 18, 16>,
      <17, 16, 15>,
      <19, 20, 18>,
      <19, 18, 17>,
      <21, 22, 20>,
      <21, 20, 19>,
      <23, 24, 22>,
      <23, 22, 21>,
      <21, 22, 24>,
      <21, 24, 23>,
      <19, 20, 22>,
      <19, 22, 21>,
      <17, 18, 20>,
      <17, 20, 19>,
      <15, 16, 18>,
      <15, 18, 17>,
      <13, 14, 16>,
      <13, 16, 15>,
      <11, 12, 14>,
      <11, 14, 13>,
      <7, 8, 12>,
      <7, 12, 11>,
      <10, 9, 8>,
      <10, 8, 7>,
      <25, 26, 9>,
      <25, 9, 10>,
      <27, 28, 26>,
      <27, 26, 25>,
      <29, 30, 28>,
      <29, 28, 27>,
      <31, 32, 30>,
      <31, 30, 29>,
      <33, 34, 32>,
      <33, 32, 31>,
      <35, 36, 34>,
      <35, 34, 33>,
      <37, 38, 36>,
      <37, 36, 35>,
      <39, 40, 38>,
      <39, 38, 37>,
      <37, 38, 40>,
      <37, 40, 39>,
      <35, 36, 38>,
      <35, 38, 37>,
      <33, 34, 36>,
      <33, 36, 35>,
      <31, 32, 34>,
      <31, 34, 33>,
      <29, 30, 32>,
      <29, 32, 31>,
      <27, 28, 30>,
      <27, 30, 29>,
      <25, 26, 28>,
      <25, 28, 27>,
      <10, 9, 26>,
      <10, 26, 25>
   }
   uv_mapping
}
 
// Faces
mesh2 {
 
   vertex_vectors { 
      8, 
      <4.07663E+00, 4.454475E+00, -2.643604E+01>,
      <4.07663E+00, 1.458225E+00, -2.643604E+01>,
      <4.076629E+00, 1.458225E+00, -2.343979E+01>,
      <4.076629E+00, 4.454475E+00, -2.343979E+01>,
      <3.682628E+00, 1.458225E+00, -2.343979E+01>,
      <3.682628E+00, 4.454475E+00, -2.343979E+01>,
      <3.682629E+00, 4.454475E+00, -2.643604E+01>,
      <3.682629E+00, 1.458225E+00, -2.643604E+01>
   }
 
   normal_vectors { 
      2, 
      <1.00E+00, 2.067536E-07, 3.258414E-07>,
      <-1.00E+00, 2.067536E-07, -3.258414E-07>
   }
 
   uv_vectors { 
      19, 
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <-1.00E+00, 0.00E+00>,
      <-1.00E+00, 2.50E-01>,
      <-7.50E-01, 2.50E-01>,
      <-7.50E-01, 0.00E+00>,
      <-1.00E+00, 5.00E-01>,
      <-5.00E-01, 0.00E+00>,
      <-5.00E-01, 5.00E-01>,
      <-5.00E-01, 0.00E+00>,
      <-5.00E-01, 5.00E-01>,
      <0.00E+00, 5.00E-01>,
      <-5.00E-01, 5.00E-01>,
      <-5.00E-01, 0.00E+00>,
      <0.00E+00, 1.00E+00>,
      <0.00E+00, -2.308219E-09>,
      <-1.00E+00, 1.00E+00>,
      <-5.00E-01, 5.00E-01>,
      <-5.00E-01, 8.940697E-08>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      4, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0
   }
 
   normal_indices { 
      4, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>
   }
 
   uv_indices { 
      4, 
      <17, 18, 2>,
      <17, 2, 6>,
      <18, 17, 6>,
      <18, 6, 2>
   }
   uv_mapping
}
 
// Flange
mesh2 {
 
   vertex_vectors { 
      4, 
      <3.682629E+00, 4.647224E+00, -2.662879E+01>,
      <3.682629E+00, 1.265476E+00, -2.662879E+01>,
      <3.682628E+00, 1.265476E+00, -2.324704E+01>,
      <3.682628E+00, 4.647224E+00, -2.324704E+01>
   }
 
   normal_vectors { 
      1, 
      <1.00E+00, 2.067536E-07, 3.258414E-07>
   }
 
   uv_vectors { 
      9, 
      <0.00E+00, 0.00E+00>,
      <-7.50E-01, 2.50E-01>,
      <-7.50E-01, 0.00E+00>,
      <-1.00E+00, 0.00E+00>,
      <-1.00E+00, 2.50E-01>,
      <-1.00E+00, 4.999999E-01>,
      <-1.00E+00, 0.00E+00>,
      <-5.000001E-01, 0.00E+00>,
      <-5.000001E-01, 5.00E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      2, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0
   }
 
   normal_indices { 
      2, 
      <0, 0, 0>,
      <0, 0, 0>
   }
 
   uv_indices { 
      2, 
      <5, 6, 7>,
      <5, 7, 8>
   }
   uv_mapping
}
 
// axle
mesh2 {
 
   vertex_vectors { 
      12, 
      <3.682629E+00, 2.95635E+00, -2.540792E+01>,
      <-1.025371E+00, 2.95635E+00, -2.540792E+01>,
      <3.682629E+00, 3.363382E+00, -2.517292E+01>,
      <-1.025371E+00, 3.363382E+00, -2.517292E+01>,
      <3.682629E+00, 3.363382E+00, -2.470292E+01>,
      <-1.025372E+00, 3.363382E+00, -2.470292E+01>,
      <3.682628E+00, 2.95635E+00, -2.446791E+01>,
      <-1.025372E+00, 2.95635E+00, -2.446792E+01>,
      <3.682629E+00, 2.549318E+00, -2.470292E+01>,
      <-1.025372E+00, 2.549318E+00, -2.470292E+01>,
      <3.682629E+00, 2.549318E+00, -2.517292E+01>,
      <-1.025371E+00, 2.549318E+00, -2.517292E+01>
   }
 
   normal_vectors { 
      8, 
      <1.629205E-07, 8.66026E-01, -4.999993E-01>,
      <2.821866E-07, 5.000016E-01, -8.660246E-01>,
      <-1.629205E-07, 8.66026E-01, 4.999993E-01>,
      <-2.821866E-07, 5.000016E-01, 8.660246E-01>,
      <-1.629205E-07, -8.660256E-01, 4.999993E-01>,
      <-2.821866E-07, -5.000013E-01, 8.660246E-01>,
      <1.629205E-07, -8.660256E-01, -4.999993E-01>,
      <2.821866E-07, -5.000013E-01, -8.660246E-01>
   }
 
   uv_vectors { 
      49, 
      <0.00E+00, 0.00E+00>,
      <-2.08447E-01, 2.929997E-02>,
      <-2.007531E-01, 2.929997E-02>,
      <-2.005589E-01, 2.244997E-02>,
      <-2.086411E-01, 2.244997E-02>,
      <-2.080531E-01, 2.929997E-02>,
      <-2.01147E-01, 2.929997E-02>,
      <-2.078589E-01, 2.244997E-02>,
      <-2.013412E-01, 2.244997E-02>,
      <-2.080531E-01, 1.559997E-02>,
      <-2.01147E-01, 1.559997E-02>,
      <-2.08447E-01, 1.559997E-02>,
      <-2.007531E-01, 1.559997E-02>,
      <-8.506777E-01, 2.10E-01>,
      <-8.788224E-01, 2.10E-01>,
      <-8.780311E-01, 2.007E-01>,
      <-8.514689E-01, 2.007E-01>,
      <-8.490724E-01, 2.10E-01>,
      <-8.804277E-01, 2.10E-01>,
      <-8.482811E-01, 2.007E-01>,
      <-8.81219E-01, 2.007E-01>,
      <-8.490724E-01, 1.914E-01>,
      <-8.804277E-01, 1.914E-01>,
      <-8.506777E-01, 1.914E-01>,
      <-8.788224E-01, 1.914E-01>,
      <-2.514114E-01, 6.716E-01>,
      <-8.298867E-02, 6.716E-01>,
      <-7.873844E-02, 5.886E-01>,
      <-2.556616E-01, 5.886E-01>,
      <-2.427887E-01, 6.716E-01>,
      <-9.161132E-02, 6.716E-01>,
      <-2.385384E-01, 5.886E-01>,
      <-9.586161E-02, 5.886E-01>,
      <-2.427887E-01, 5.056E-01>,
      <-9.161132E-02, 5.056E-01>,
      <-2.514114E-01, 5.056E-01>,
      <-8.298867E-02, 5.056E-01>,
      <-1.907546E-01, 6.741E-01>,
      <-1.124454E-01, 6.741E-01>,
      <-1.104693E-01, 5.9045E-01>,
      <-1.927308E-01, 5.9045E-01>,
      <-1.867455E-01, 6.741E-01>,
      <-1.164546E-01, 6.741E-01>,
      <-1.847693E-01, 5.9045E-01>,
      <-1.184308E-01, 5.9045E-01>,
      <-1.867455E-01, 5.068E-01>,
      <-1.164546E-01, 5.068E-01>,
      <-1.907546E-01, 5.068E-01>,
      <-1.124454E-01, 5.068E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      12, 
      <3, 2, 0>, 0,
      <3, 0, 1>, 0,
      <5, 4, 2>, 0,
      <5, 2, 3>, 0,
      <7, 6, 4>, 0,
      <7, 4, 5>, 0,
      <9, 8, 6>, 0,
      <9, 6, 7>, 0,
      <11, 10, 8>, 0,
      <11, 8, 9>, 0,
      <1, 0, 10>, 0,
      <1, 10, 11>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 2, 0>,
      <2, 0, 0>,
      <3, 3, 2>,
      <3, 2, 2>,
      <4, 4, 5>,
      <4, 5, 5>,
      <6, 6, 4>,
      <6, 4, 4>,
      <7, 7, 6>,
      <7, 6, 6>
   }
 
   uv_indices { 
      12, 
      <37, 38, 39>,
      <37, 39, 40>,
      <41, 42, 38>,
      <41, 38, 37>,
      <43, 44, 42>,
      <43, 42, 41>,
      <45, 46, 44>,
      <45, 44, 43>,
      <47, 48, 46>,
      <47, 46, 45>,
      <40, 39, 48>,
      <40, 48, 47>
   }
   uv_mapping
}
 
// Rim-Outer
mesh2 {
 
   vertex_vectors { 
      64, 
      <-1.025371E+00, 2.95635E+00, -2.152454E+01>,
      <-1.41937E+00, 2.95635E+00, -2.152454E+01>,
      <-1.025371E+00, 3.24862E+00, -2.149575E+01>,
      <-1.41937E+00, 3.24862E+00, -2.149575E+01>,
      <-1.025371E+00, 3.529657E+00, -2.141051E+01>,
      <-1.41937E+00, 3.529657E+00, -2.141051E+01>,
      <-1.025371E+00, 3.788663E+00, -2.127206E+01>,
      <-1.41937E+00, 3.788663E+00, -2.127206E+01>,
      <-1.025371E+00, 4.015684E+00, -2.108575E+01>,
      <-1.41937E+00, 4.015684E+00, -2.108575E+01>,
      <-1.025371E+00, 4.201995E+00, -2.085873E+01>,
      <-1.41937E+00, 4.201995E+00, -2.085873E+01>,
      <-1.025371E+00, 4.340436E+00, -2.059973E+01>,
      <-1.41937E+00, 4.340436E+00, -2.059973E+01>,
      <-1.025371E+00, 4.425689E+00, -2.031869E+01>,
      <-1.419371E+00, 4.425689E+00, -2.031869E+01>,
      <-1.025372E+00, 4.454475E+00, -2.002641E+01>,
      <-1.419371E+00, 4.454475E+00, -2.002641E+01>,
      <-1.025372E+00, 4.425689E+00, -1.973414E+01>,
      <-1.419371E+00, 4.425689E+00, -1.973414E+01>,
      <-1.025372E+00, 4.340436E+00, -1.94531E+01>,
      <-1.419371E+00, 4.340436E+00, -1.94531E+01>,
      <-1.025372E+00, 4.201995E+00, -1.91941E+01>,
      <-1.419371E+00, 4.201995E+00, -1.91941E+01>,
      <-1.025372E+00, 4.015684E+00, -1.896708E+01>,
      <-1.419371E+00, 4.015684E+00, -1.896708E+01>,
      <-1.025372E+00, 3.788663E+00, -1.878077E+01>,
      <-1.419371E+00, 3.788663E+00, -1.878077E+01>,
      <-1.025372E+00, 3.529657E+00, -1.864232E+01>,
      <-1.419371E+00, 3.529657E+00, -1.864232E+01>,
      <-1.025372E+00, 3.24862E+00, -1.855708E+01>,
      <-1.419371E+00, 3.24862E+00, -1.855708E+01>,
      <-1.025372E+00, 2.95635E+00, -1.852829E+01>,
      <-1.419371E+00, 2.95635E+00, -1.852829E+01>,
      <-1.025372E+00, 2.66408E+00, -1.855708E+01>,
      <-1.419371E+00, 2.66408E+00, -1.855708E+01>,
      <-1.025372E+00, 2.383042E+00, -1.864232E+01>,
      <-1.419371E+00, 2.383042E+00, -1.864232E+01>,
      <-1.025372E+00, 2.124036E+00, -1.878077E+01>,
      <-1.419371E+00, 2.124036E+00, -1.878077E+01>,
      <-1.025372E+00, 1.897016E+00, -1.896708E+01>,
      <-1.419371E+00, 1.897016E+00, -1.896708E+01>,
      <-1.025372E+00, 1.710705E+00, -1.91941E+01>,
      <-1.419371E+00, 1.710705E+00, -1.91941E+01>,
      <-1.025372E+00, 1.572263E+00, -1.94531E+01>,
      <-1.419371E+00, 1.572263E+00, -1.94531E+01>,
      <-1.025372E+00, 1.487011E+00, -1.973414E+01>,
      <-1.419371E+00, 1.487011E+00, -1.973414E+01>,
      <-1.025372E+00, 1.458225E+00, -2.002641E+01>,
      <-1.419371E+00, 1.458225E+00, -2.002641E+01>,
      <-1.025371E+00, 1.487011E+00, -2.031869E+01>,
      <-1.419371E+00, 1.487011E+00, -2.031869E+01>,
      <-1.025371E+00, 1.572263E+00, -2.059973E+01>,
      <-1.41937E+00, 1.572263E+00, -2.059973E+01>,
      <-1.025371E+00, 1.710705E+00, -2.085873E+01>,
      <-1.41937E+00, 1.710705E+00, -2.085873E+01>,
      <-1.025371E+00, 1.897015E+00, -2.108575E+01>,
      <-1.41937E+00, 1.897015E+00, -2.108575E+01>,
      <-1.025371E+00, 2.124036E+00, -2.127206E+01>,
      <-1.41937E+00, 2.124036E+00, -2.127206E+01>,
      <-1.025371E+00, 2.383042E+00, -2.141051E+01>,
      <-1.41937E+00, 2.383042E+00, -2.141051E+01>,
      <-1.025371E+00, 2.66408E+00, -2.149575E+01>,
      <-1.41937E+00, 2.66408E+00, -2.149575E+01>
   }
 
   normal_vectors { 
      32, 
      <3.195804E-07, 1.950906E-01, -9.807853E-01>,
      <3.258414E-07, 2.067536E-07, -1.00E+00>,
      <3.010385E-07, 3.826814E-01, -9.238805E-01>,
      <2.709268E-07, 5.555722E-01, -8.314685E-01>,
      <2.304045E-07, 7.071075E-01, -7.071063E-01>,
      <1.810278E-07, 8.314698E-01, -5.555702E-01>,
      <1.246948E-07, 9.238788E-01, -3.826857E-01>,
      <6.356853E-08, 9.807855E-01, -1.950904E-01>,
      <-1.641179E-15, 1.00E+00, -3.531288E-16>,
      <-6.356848E-08, 9.807855E-01, 1.950902E-01>,
      <-1.246948E-07, 9.238788E-01, 3.826855E-01>,
      <-1.810277E-07, 8.314698E-01, 5.555701E-01>,
      <-2.304045E-07, 7.071075E-01, 7.071063E-01>,
      <-2.709268E-07, 5.555721E-01, 8.314685E-01>,
      <-3.010385E-07, 3.826814E-01, 9.238805E-01>,
      <-3.195804E-07, 1.950907E-01, 9.807853E-01>,
      <-3.258414E-07, 2.067536E-07, 1.00E+00>,
      <-3.195804E-07, -1.950902E-01, 9.807853E-01>,
      <-3.010385E-07, -3.826809E-01, 9.238805E-01>,
      <-2.709268E-07, -5.555718E-01, 8.314685E-01>,
      <-2.304045E-07, -7.071071E-01, 7.071064E-01>,
      <-1.810278E-07, -8.314694E-01, 5.555703E-01>,
      <-1.246946E-07, -9.238786E-01, 3.826851E-01>,
      <-6.356841E-08, -9.807852E-01, 1.950901E-01>,
      <1.641179E-15, -9.999998E-01, 3.531288E-16>,
      <6.356844E-08, -9.807851E-01, -1.950901E-01>,
      <1.246947E-07, -9.238786E-01, -3.826851E-01>,
      <1.810278E-07, -8.314694E-01, -5.555703E-01>,
      <2.304045E-07, -7.071071E-01, -7.071064E-01>,
      <2.709268E-07, -5.555717E-01, -8.314685E-01>,
      <3.010385E-07, -3.826809E-01, -9.238805E-01>,
      <3.195804E-07, -1.950902E-01, -9.807853E-01>
   }
 
   uv_vectors { 
      65, 
      <0.00E+00, 0.00E+00>,
      <-5.92646E-02, 1.175E-01>,
      <-3.073543E-02, 1.175E-01>,
      <-3.073543E-02, 1.855E-01>,
      <-5.92646E-02, 1.855E-01>,
      <-6.000006E-02, 1.175E-01>,
      <-3.000009E-02, 1.175E-01>,
      <-3.000009E-02, 1.855E-01>,
      <-6.000006E-02, 1.855E-01>,
      <-5.999994E-02, 1.174999E-01>,
      <-2.999991E-02, 1.174999E-01>,
      <-5.999994E-02, 1.175E-01>,
      <-2.999997E-02, 1.175E-01>,
      <-5.999994E-02, 1.175E-01>,
      <-2.999997E-02, 1.175E-01>,
      <-6.00E-02, 1.175E-01>,
      <-3.000003E-02, 1.175E-01>,
      <-5.999994E-02, 1.515E-01>,
      <-2.999997E-02, 1.515E-01>,
      <-5.999994E-02, 1.175006E-01>,
      <-2.999997E-02, 1.175E-01>,
      <-6.00E-02, 1.175E-01>,
      <-3.000003E-02, 1.175E-01>,
      <-5.999994E-02, 1.175E-01>,
      <-2.999997E-02, 1.175E-01>,
      <-3.000009E-02, 1.175E-01>,
      <-6.000006E-02, 1.175E-01>,
      <-2.999991E-02, 1.175E-01>,
      <-5.999994E-02, 1.175E-01>,
      <-3.000009E-02, 1.175001E-01>,
      <-6.000006E-02, 1.175001E-01>,
      <-9.956321E-01, 6.754004E-01>,
      <-9.956321E-01, 5.006004E-01>,
      <-9.988E-01, 5.006004E-01>,
      <-9.988E-01, 6.754004E-01>,
      <-9.862515E-01, 6.754004E-01>,
      <-9.862515E-01, 5.006004E-01>,
      <-9.710175E-01, 6.754004E-01>,
      <-9.710175E-01, 5.006004E-01>,
      <-9.505165E-01, 6.754004E-01>,
      <-9.505165E-01, 5.006004E-01>,
      <-9.255355E-01, 6.754004E-01>,
      <-9.255355E-01, 5.006004E-01>,
      <-8.970354E-01, 6.754004E-01>,
      <-8.970354E-01, 5.006004E-01>,
      <-8.661107E-01, 6.754004E-01>,
      <-8.661107E-01, 5.006004E-01>,
      <-8.3395E-01, 6.754004E-01>,
      <-8.3395E-01, 5.006004E-01>,
      <-8.017893E-01, 6.754004E-01>,
      <-8.017893E-01, 5.006004E-01>,
      <-7.708645E-01, 6.754004E-01>,
      <-7.708645E-01, 5.006004E-01>,
      <-7.423645E-01, 6.754004E-01>,
      <-7.423645E-01, 5.006004E-01>,
      <-7.173835E-01, 6.754004E-01>,
      <-7.173835E-01, 5.006004E-01>,
      <-6.968824E-01, 6.754004E-01>,
      <-6.968824E-01, 5.006004E-01>,
      <-6.816484E-01, 6.754004E-01>,
      <-6.816484E-01, 5.006004E-01>,
      <-6.722679E-01, 6.754004E-01>,
      <-6.722679E-01, 5.006004E-01>,
      <-6.691E-01, 6.754004E-01>,
      <-6.691E-01, 5.006004E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      64, 
      <3, 2, 0>, 0,
      <3, 0, 1>, 0,
      <5, 4, 2>, 0,
      <5, 2, 3>, 0,
      <7, 6, 4>, 0,
      <7, 4, 5>, 0,
      <9, 8, 6>, 0,
      <9, 6, 7>, 0,
      <11, 10, 8>, 0,
      <11, 8, 9>, 0,
      <13, 12, 10>, 0,
      <13, 10, 11>, 0,
      <15, 14, 12>, 0,
      <15, 12, 13>, 0,
      <17, 16, 14>, 0,
      <17, 14, 15>, 0,
      <19, 18, 16>, 0,
      <19, 16, 17>, 0,
      <21, 20, 18>, 0,
      <21, 18, 19>, 0,
      <23, 22, 20>, 0,
      <23, 20, 21>, 0,
      <25, 24, 22>, 0,
      <25, 22, 23>, 0,
      <27, 26, 24>, 0,
      <27, 24, 25>, 0,
      <29, 28, 26>, 0,
      <29, 26, 27>, 0,
      <31, 30, 28>, 0,
      <31, 28, 29>, 0,
      <33, 32, 30>, 0,
      <33, 30, 31>, 0,
      <35, 34, 32>, 0,
      <35, 32, 33>, 0,
      <37, 36, 34>, 0,
      <37, 34, 35>, 0,
      <39, 38, 36>, 0,
      <39, 36, 37>, 0,
      <41, 40, 38>, 0,
      <41, 38, 39>, 0,
      <43, 42, 40>, 0,
      <43, 40, 41>, 0,
      <45, 44, 42>, 0,
      <45, 42, 43>, 0,
      <47, 46, 44>, 0,
      <47, 44, 45>, 0,
      <49, 48, 46>, 0,
      <49, 46, 47>, 0,
      <51, 50, 48>, 0,
      <51, 48, 49>, 0,
      <53, 52, 50>, 0,
      <53, 50, 51>, 0,
      <55, 54, 52>, 0,
      <55, 52, 53>, 0,
      <57, 56, 54>, 0,
      <57, 54, 55>, 0,
      <59, 58, 56>, 0,
      <59, 56, 57>, 0,
      <61, 60, 58>, 0,
      <61, 58, 59>, 0,
      <63, 62, 60>, 0,
      <63, 60, 61>, 0,
      <1, 0, 62>, 0,
      <1, 62, 63>, 0
   }
 
   normal_indices { 
      64, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 2, 0>,
      <2, 0, 0>,
      <3, 3, 2>,
      <3, 2, 2>,
      <4, 4, 3>,
      <4, 3, 3>,
      <5, 5, 4>,
      <5, 4, 4>,
      <6, 6, 5>,
      <6, 5, 5>,
      <7, 7, 6>,
      <7, 6, 6>,
      <8, 8, 7>,
      <8, 7, 7>,
      <9, 9, 8>,
      <9, 8, 8>,
      <10, 10, 9>,
      <10, 9, 9>,
      <11, 11, 10>,
      <11, 10, 10>,
      <12, 12, 11>,
      <12, 11, 11>,
      <13, 13, 12>,
      <13, 12, 12>,
      <14, 14, 13>,
      <14, 13, 13>,
      <15, 15, 14>,
      <15, 14, 14>,
      <16, 16, 15>,
      <16, 15, 15>,
      <17, 17, 16>,
      <17, 16, 16>,
      <18, 18, 17>,
      <18, 17, 17>,
      <19, 19, 18>,
      <19, 18, 18>,
      <20, 20, 19>,
      <20, 19, 19>,
      <21, 21, 20>,
      <21, 20, 20>,
      <22, 22, 21>,
      <22, 21, 21>,
      <23, 23, 22>,
      <23, 22, 22>,
      <24, 24, 23>,
      <24, 23, 23>,
      <25, 25, 24>,
      <25, 24, 24>,
      <26, 26, 25>,
      <26, 25, 25>,
      <27, 27, 26>,
      <27, 26, 26>,
      <28, 28, 27>,
      <28, 27, 27>,
      <29, 29, 28>,
      <29, 28, 28>,
      <30, 30, 29>,
      <30, 29, 29>,
      <31, 31, 30>,
      <31, 30, 30>,
      <1, 1, 31>,
      <1, 31, 31>
   }
 
   uv_indices { 
      64, 
      <31, 32, 33>,
      <31, 33, 34>,
      <35, 36, 32>,
      <35, 32, 31>,
      <37, 38, 36>,
      <37, 36, 35>,
      <39, 40, 38>,
      <39, 38, 37>,
      <41, 42, 40>,
      <41, 40, 39>,
      <43, 44, 42>,
      <43, 42, 41>,
      <45, 46, 44>,
      <45, 44, 43>,
      <47, 48, 46>,
      <47, 46, 45>,
      <49, 50, 48>,
      <49, 48, 47>,
      <51, 52, 50>,
      <51, 50, 49>,
      <53, 54, 52>,
      <53, 52, 51>,
      <55, 56, 54>,
      <55, 54, 53>,
      <57, 58, 56>,
      <57, 56, 55>,
      <59, 60, 58>,
      <59, 58, 57>,
      <61, 62, 60>,
      <61, 60, 59>,
      <63, 64, 62>,
      <63, 62, 61>,
      <61, 62, 64>,
      <61, 64, 63>,
      <59, 60, 62>,
      <59, 62, 61>,
      <57, 58, 60>,
      <57, 60, 59>,
      <55, 56, 58>,
      <55, 58, 57>,
      <53, 54, 56>,
      <53, 56, 55>,
      <51, 52, 54>,
      <51, 54, 53>,
      <49, 50, 52>,
      <49, 52, 51>,
      <47, 48, 50>,
      <47, 50, 49>,
      <45, 46, 48>,
      <45, 48, 47>,
      <43, 44, 46>,
      <43, 46, 45>,
      <41, 42, 44>,
      <41, 44, 43>,
      <39, 40, 42>,
      <39, 42, 41>,
      <37, 38, 40>,
      <37, 40, 39>,
      <35, 36, 38>,
      <35, 38, 37>,
      <31, 32, 36>,
      <31, 36, 35>,
      <34, 33, 32>,
      <34, 32, 31>
   }
   uv_mapping
}
 
// Faces
mesh2 {
 
   vertex_vectors { 
      8, 
      <-1.419371E+00, 1.458225E+00, -1.852829E+01>,
      <-1.41937E+00, 1.458225E+00, -2.152454E+01>,
      <-1.41937E+00, 4.454475E+00, -2.152454E+01>,
      <-1.419371E+00, 4.454475E+00, -1.852829E+01>,
      <-1.025371E+00, 4.454475E+00, -2.152454E+01>,
      <-1.025372E+00, 4.454475E+00, -1.852829E+01>,
      <-1.025372E+00, 1.458225E+00, -1.852829E+01>,
      <-1.025371E+00, 1.458225E+00, -2.152454E+01>
   }
 
   normal_vectors { 
      2, 
      <-1.00E+00, 2.067536E-07, -3.258414E-07>,
      <1.00E+00, 2.067536E-07, 3.258414E-07>
   }
 
   uv_vectors { 
      15, 
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <-1.00E+00, 2.50E-01>,
      <-7.50E-01, 2.50E-01>,
      <-7.50E-01, 0.00E+00>,
      <-1.00E+00, 0.00E+00>,
      <-5.00E-01, 2.50E-01>,
      <-5.00E-01, 0.00E+00>,
      <-5.00E-01, 5.00E-01>,
      <-1.00E+00, 5.00E-01>,
      <-1.00E+00, 0.00E+00>,
      <0.00E+00, 5.00E-01>,
      <-5.00E-01, 5.00E-01>,
      <-1.00E+00, 0.00E+00>,
      <-5.00E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      4, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0
   }
 
   normal_indices { 
      4, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>
   }
 
   uv_indices { 
      4, 
      <12, 9, 13>,
      <12, 13, 14>,
      <11, 12, 14>,
      <11, 14, 0>
   }
   uv_mapping
}
 
// Flange
mesh2 {
 
   vertex_vectors { 
      4, 
      <-1.025372E+00, 1.265476E+00, -1.833554E+01>,
      <-1.025371E+00, 1.265476E+00, -2.171729E+01>,
      <-1.025371E+00, 4.647224E+00, -2.171729E+01>,
      <-1.025372E+00, 4.647224E+00, -1.833554E+01>
   }
 
   normal_vectors { 
      1, 
      <-1.00E+00, 2.067536E-07, -3.258414E-07>
   }
 
   uv_vectors { 
      10, 
      <0.00E+00, 0.00E+00>,
      <-1.00E+00, 2.50E-01>,
      <-7.50E-01, 2.50E-01>,
      <-7.50E-01, 0.00E+00>,
      <-1.00E+00, 0.00E+00>,
      <-5.00E-01, 2.50E-01>,
      <-5.00E-01, 0.00E+00>,
      <-5.000001E-01, 5.00E-01>,
      <-1.00E+00, 5.00E-01>,
      <-1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      2, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0
   }
 
   normal_indices { 
      2, 
      <0, 0, 0>,
      <0, 0, 0>
   }
 
   uv_indices { 
      2, 
      <7, 8, 9>,
      <7, 9, 6>
   }
   uv_mapping
}
 
// Rim-Outer
mesh2 {
 
   vertex_vectors { 
      64, 
      <3.682629E+00, 1.458225E+00, -2.002641E+01>,
      <4.07663E+00, 1.458225E+00, -2.002641E+01>,
      <3.682629E+00, 1.487011E+00, -1.973414E+01>,
      <4.07663E+00, 1.487011E+00, -1.973414E+01>,
      <3.682628E+00, 1.572263E+00, -1.94531E+01>,
      <4.07663E+00, 1.572263E+00, -1.94531E+01>,
      <3.682628E+00, 1.710704E+00, -1.91941E+01>,
      <4.076629E+00, 1.710705E+00, -1.91941E+01>,
      <3.682628E+00, 1.897015E+00, -1.896708E+01>,
      <4.076629E+00, 1.897015E+00, -1.896708E+01>,
      <3.682628E+00, 2.124036E+00, -1.878077E+01>,
      <4.076629E+00, 2.124036E+00, -1.878077E+01>,
      <3.682628E+00, 2.383042E+00, -1.864232E+01>,
      <4.076629E+00, 2.383042E+00, -1.864232E+01>,
      <3.682628E+00, 2.66408E+00, -1.855708E+01>,
      <4.076629E+00, 2.66408E+00, -1.855708E+01>,
      <3.682628E+00, 2.95635E+00, -1.852829E+01>,
      <4.076629E+00, 2.95635E+00, -1.852829E+01>,
      <3.682628E+00, 3.24862E+00, -1.855708E+01>,
      <4.076629E+00, 3.24862E+00, -1.855708E+01>,
      <3.682628E+00, 3.529657E+00, -1.864232E+01>,
      <4.076629E+00, 3.529657E+00, -1.864232E+01>,
      <3.682628E+00, 3.788663E+00, -1.878077E+01>,
      <4.076629E+00, 3.788663E+00, -1.878077E+01>,
      <3.682628E+00, 4.015684E+00, -1.896708E+01>,
      <4.076629E+00, 4.015684E+00, -1.896708E+01>,
      <3.682628E+00, 4.201995E+00, -1.91941E+01>,
      <4.076629E+00, 4.201995E+00, -1.91941E+01>,
      <3.682628E+00, 4.340437E+00, -1.94531E+01>,
      <4.07663E+00, 4.340436E+00, -1.94531E+01>,
      <3.682629E+00, 4.425689E+00, -1.973414E+01>,
      <4.07663E+00, 4.425689E+00, -1.973414E+01>,
      <3.682629E+00, 4.454475E+00, -2.002641E+01>,
      <4.07663E+00, 4.454475E+00, -2.002641E+01>,
      <3.682629E+00, 4.425689E+00, -2.031868E+01>,
      <4.07663E+00, 4.425689E+00, -2.031868E+01>,
      <3.682629E+00, 4.340437E+00, -2.059972E+01>,
      <4.07663E+00, 4.340436E+00, -2.059972E+01>,
      <3.682629E+00, 4.201995E+00, -2.085873E+01>,
      <4.07663E+00, 4.201995E+00, -2.085873E+01>,
      <3.682629E+00, 4.015685E+00, -2.108575E+01>,
      <4.07663E+00, 4.015684E+00, -2.108575E+01>,
      <3.682629E+00, 3.788664E+00, -2.127206E+01>,
      <4.07663E+00, 3.788664E+00, -2.127206E+01>,
      <3.682629E+00, 3.529657E+00, -2.14105E+01>,
      <4.07663E+00, 3.529657E+00, -2.14105E+01>,
      <3.682629E+00, 3.24862E+00, -2.149575E+01>,
      <4.07663E+00, 3.24862E+00, -2.149575E+01>,
      <3.682629E+00, 2.95635E+00, -2.152454E+01>,
      <4.07663E+00, 2.95635E+00, -2.152454E+01>,
      <3.682629E+00, 2.66408E+00, -2.149575E+01>,
      <4.07663E+00, 2.66408E+00, -2.149575E+01>,
      <3.682629E+00, 2.383042E+00, -2.14105E+01>,
      <4.07663E+00, 2.383042E+00, -2.14105E+01>,
      <3.682629E+00, 2.124036E+00, -2.127206E+01>,
      <4.07663E+00, 2.124036E+00, -2.127206E+01>,
      <3.682629E+00, 1.897015E+00, -2.108575E+01>,
      <4.07663E+00, 1.897016E+00, -2.108575E+01>,
      <3.682629E+00, 1.710704E+00, -2.085873E+01>,
      <4.07663E+00, 1.710705E+00, -2.085873E+01>,
      <3.682629E+00, 1.572263E+00, -2.059972E+01>,
      <4.07663E+00, 1.572263E+00, -2.059972E+01>,
      <3.682629E+00, 1.487011E+00, -2.031868E+01>,
      <4.07663E+00, 1.487011E+00, -2.031868E+01>
   }
 
   normal_vectors { 
      32, 
      <2.40907E-07, -9.807851E-01, 1.950902E-01>,
      <1.641179E-15, -9.999998E-01, 3.531288E-16>,
      <1.834553E-07, -9.238785E-01, 3.826854E-01>,
      <6.338081E-08, -8.314694E-01, 5.555703E-01>,
      <-5.072557E-08, -7.071071E-01, 7.071063E-01>,
      <-1.221962E-07, -5.555717E-01, 8.314685E-01>,
      <-1.943313E-07, -3.826808E-01, 9.238805E-01>,
      <-2.706134E-07, -1.950902E-01, 9.807853E-01>,
      <-3.258414E-07, 2.067536E-07, 1.00E+00>,
      <-3.195804E-07, 1.950905E-01, 9.807853E-01>,
      <-3.010385E-07, 3.826813E-01, 9.238805E-01>,
      <-2.709268E-07, 5.55572E-01, 8.314685E-01>,
      <-1.543815E-07, 7.071074E-01, 7.071064E-01>,
      <1.737604E-07, 8.314698E-01, 5.555702E-01>,
      <2.987719E-07, 9.238789E-01, 3.826853E-01>,
      <2.331789E-07, 9.807855E-01, 1.950901E-01>,
      <-1.641179E-15, 1.00E+00, -3.531288E-16>,
      <3.676611E-07, 9.807855E-01, -1.950903E-01>,
      <5.881826E-07, 9.238788E-01, -3.826856E-01>,
      <6.69845E-07, 8.314698E-01, -5.555702E-01>,
      <5.436733E-07, 7.071075E-01, -7.071062E-01>,
      <4.828423E-07, 5.55572E-01, -8.314685E-01>,
      <3.989722E-07, 3.826813E-01, -9.238805E-01>,
      <3.41491E-07, 1.950906E-01, -9.807853E-01>,
      <3.258414E-07, 2.067536E-07, -1.00E+00>,
      <3.195804E-07, -1.950901E-01, -9.807853E-01>,
      <3.770616E-07, -3.826809E-01, -9.238805E-01>,
      <4.321149E-07, -5.555717E-01, -8.314685E-01>,
      <4.376813E-07, -7.071071E-01, -7.071063E-01>,
      <4.42522E-07, -8.314693E-01, -5.555704E-01>,
      <4.124513E-07, -9.238785E-01, -3.826854E-01>,
      <3.636056E-07, -9.807851E-01, -1.950901E-01>
   }
 
   uv_vectors { 
      41, 
      <0.00E+00, 0.00E+00>,
      <-3.000003E-02, 1.855E-01>,
      <-6.00E-02, 1.855E-01>,
      <-6.00E-02, 1.175E-01>,
      <-3.000003E-02, 1.175E-01>,
      <-6.00E-02, 1.515E-01>,
      <-3.000003E-02, 1.515E-01>,
      <-8.017893E-01, 6.754E-01>,
      <-8.017893E-01, 5.006E-01>,
      <-8.3395E-01, 5.006E-01>,
      <-8.3395E-01, 6.754E-01>,
      <-7.708645E-01, 6.754E-01>,
      <-7.708645E-01, 5.006E-01>,
      <-7.423645E-01, 6.754E-01>,
      <-7.423645E-01, 5.006E-01>,
      <-7.173835E-01, 6.754E-01>,
      <-7.173835E-01, 5.006E-01>,
      <-6.968824E-01, 6.754E-01>,
      <-6.968824E-01, 5.006E-01>,
      <-6.816484E-01, 6.754E-01>,
      <-6.816484E-01, 5.006E-01>,
      <-6.722679E-01, 6.754E-01>,
      <-6.722679E-01, 5.006E-01>,
      <-6.691E-01, 6.754E-01>,
      <-6.691E-01, 5.006E-01>,
      <-8.661107E-01, 6.754E-01>,
      <-8.661107E-01, 5.006E-01>,
      <-8.970354E-01, 6.754E-01>,
      <-8.970354E-01, 5.006E-01>,
      <-9.255355E-01, 6.754E-01>,
      <-9.255355E-01, 5.006E-01>,
      <-9.505165E-01, 6.754E-01>,
      <-9.505165E-01, 5.006E-01>,
      <-9.710175E-01, 6.754E-01>,
      <-9.710175E-01, 5.006E-01>,
      <-9.862515E-01, 6.754E-01>,
      <-9.862515E-01, 5.006E-01>,
      <-9.956321E-01, 6.754E-01>,
      <-9.956321E-01, 5.006E-01>,
      <-9.988E-01, 6.754E-01>,
      <-9.988E-01, 5.006E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      64, 
      <3, 2, 0>, 0,
      <3, 0, 1>, 0,
      <5, 4, 2>, 0,
      <5, 2, 3>, 0,
      <7, 6, 4>, 0,
      <7, 4, 5>, 0,
      <9, 8, 6>, 0,
      <9, 6, 7>, 0,
      <11, 10, 8>, 0,
      <11, 8, 9>, 0,
      <13, 12, 10>, 0,
      <13, 10, 11>, 0,
      <15, 14, 12>, 0,
      <15, 12, 13>, 0,
      <17, 16, 14>, 0,
      <17, 14, 15>, 0,
      <19, 18, 16>, 0,
      <19, 16, 17>, 0,
      <21, 20, 18>, 0,
      <21, 18, 19>, 0,
      <23, 22, 20>, 0,
      <23, 20, 21>, 0,
      <25, 24, 22>, 0,
      <25, 22, 23>, 0,
      <27, 26, 24>, 0,
      <27, 24, 25>, 0,
      <29, 28, 26>, 0,
      <29, 26, 27>, 0,
      <31, 30, 28>, 0,
      <31, 28, 29>, 0,
      <33, 32, 30>, 0,
      <33, 30, 31>, 0,
      <35, 34, 32>, 0,
      <35, 32, 33>, 0,
      <37, 36, 34>, 0,
      <37, 34, 35>, 0,
      <39, 38, 36>, 0,
      <39, 36, 37>, 0,
      <41, 40, 38>, 0,
      <41, 38, 39>, 0,
      <43, 42, 40>, 0,
      <43, 40, 41>, 0,
      <45, 44, 42>, 0,
      <45, 42, 43>, 0,
      <47, 46, 44>, 0,
      <47, 44, 45>, 0,
      <49, 48, 46>, 0,
      <49, 46, 47>, 0,
      <51, 50, 48>, 0,
      <51, 48, 49>, 0,
      <53, 52, 50>, 0,
      <53, 50, 51>, 0,
      <55, 54, 52>, 0,
      <55, 52, 53>, 0,
      <57, 56, 54>, 0,
      <57, 54, 55>, 0,
      <59, 58, 56>, 0,
      <59, 56, 57>, 0,
      <61, 60, 58>, 0,
      <61, 58, 59>, 0,
      <63, 62, 60>, 0,
      <63, 60, 61>, 0,
      <1, 0, 62>, 0,
      <1, 62, 63>, 0
   }
 
   normal_indices { 
      64, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 2, 0>,
      <2, 0, 0>,
      <3, 3, 2>,
      <3, 2, 2>,
      <4, 4, 3>,
      <4, 3, 3>,
      <5, 5, 4>,
      <5, 4, 4>,
      <6, 6, 5>,
      <6, 5, 5>,
      <7, 7, 6>,
      <7, 6, 6>,
      <8, 8, 7>,
      <8, 7, 7>,
      <9, 9, 8>,
      <9, 8, 8>,
      <10, 10, 9>,
      <10, 9, 9>,
      <11, 11, 10>,
      <11, 10, 10>,
      <12, 12, 11>,
      <12, 11, 11>,
      <13, 13, 12>,
      <13, 12, 12>,
      <14, 14, 13>,
      <14, 13, 13>,
      <15, 15, 14>,
      <15, 14, 14>,
      <16, 16, 15>,
      <16, 15, 15>,
      <17, 17, 16>,
      <17, 16, 16>,
      <18, 18, 17>,
      <18, 17, 17>,
      <19, 19, 18>,
      <19, 18, 18>,
      <20, 20, 19>,
      <20, 19, 19>,
      <21, 21, 20>,
      <21, 20, 20>,
      <22, 22, 21>,
      <22, 21, 21>,
      <23, 23, 22>,
      <23, 22, 22>,
      <24, 24, 23>,
      <24, 23, 23>,
      <25, 25, 24>,
      <25, 24, 24>,
      <26, 26, 25>,
      <26, 25, 25>,
      <27, 27, 26>,
      <27, 26, 26>,
      <28, 28, 27>,
      <28, 27, 27>,
      <29, 29, 28>,
      <29, 28, 28>,
      <30, 30, 29>,
      <30, 29, 29>,
      <31, 31, 30>,
      <31, 30, 30>,
      <1, 1, 31>,
      <1, 31, 31>
   }
 
   uv_indices { 
      64, 
      <7, 8, 9>,
      <7, 9, 10>,
      <11, 12, 8>,
      <11, 8, 7>,
      <13, 14, 12>,
      <13, 12, 11>,
      <15, 16, 14>,
      <15, 14, 13>,
      <17, 18, 16>,
      <17, 16, 15>,
      <19, 20, 18>,
      <19, 18, 17>,
      <21, 22, 20>,
      <21, 20, 19>,
      <23, 24, 22>,
      <23, 22, 21>,
      <21, 22, 24>,
      <21, 24, 23>,
      <19, 20, 22>,
      <19, 22, 21>,
      <17, 18, 20>,
      <17, 20, 19>,
      <15, 16, 18>,
      <15, 18, 17>,
      <13, 14, 16>,
      <13, 16, 15>,
      <11, 12, 14>,
      <11, 14, 13>,
      <7, 8, 12>,
      <7, 12, 11>,
      <10, 9, 8>,
      <10, 8, 7>,
      <25, 26, 9>,
      <25, 9, 10>,
      <27, 28, 26>,
      <27, 26, 25>,
      <29, 30, 28>,
      <29, 28, 27>,
      <31, 32, 30>,
      <31, 30, 29>,
      <33, 34, 32>,
      <33, 32, 31>,
      <35, 36, 34>,
      <35, 34, 33>,
      <37, 38, 36>,
      <37, 36, 35>,
      <39, 40, 38>,
      <39, 38, 37>,
      <37, 38, 40>,
      <37, 40, 39>,
      <35, 36, 38>,
      <35, 38, 37>,
      <33, 34, 36>,
      <33, 36, 35>,
      <31, 32, 34>,
      <31, 34, 33>,
      <29, 30, 32>,
      <29, 32, 31>,
      <27, 28, 30>,
      <27, 30, 29>,
      <25, 26, 28>,
      <25, 28, 27>,
      <10, 9, 26>,
      <10, 26, 25>
   }
   uv_mapping
}
 
// Faces
mesh2 {
 
   vertex_vectors { 
      8, 
      <4.07663E+00, 4.454475E+00, -2.152454E+01>,
      <4.07663E+00, 1.458225E+00, -2.152454E+01>,
      <4.076629E+00, 1.458225E+00, -1.852829E+01>,
      <4.076629E+00, 4.454475E+00, -1.852829E+01>,
      <3.682628E+00, 1.458225E+00, -1.852829E+01>,
      <3.682628E+00, 4.454475E+00, -1.852829E+01>,
      <3.682629E+00, 4.454475E+00, -2.152454E+01>,
      <3.682629E+00, 1.458225E+00, -2.152454E+01>
   }
 
   normal_vectors { 
      2, 
      <1.00E+00, 2.067536E-07, 3.258414E-07>,
      <-1.00E+00, 2.067536E-07, -3.258414E-07>
   }
 
   uv_vectors { 
      16, 
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <-1.00E+00, 0.00E+00>,
      <-1.00E+00, 2.50E-01>,
      <-7.50E-01, 2.50E-01>,
      <-7.50E-01, 0.00E+00>,
      <-5.00E-01, 2.50E-01>,
      <-5.00E-01, 0.00E+00>,
      <-7.50E-01, 2.50E-01>,
      <0.00E+00, 1.00E+00>,
      <0.00E+00, -2.308219E-09>,
      <-1.00E+00, 1.00E+00>,
      <-1.00E+00, 5.00E-01>,
      <-5.00E-01, 0.00E+00>,
      <-5.00E-01, 5.00E-01>,
      <0.00E+00, 5.00E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      4, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0
   }
 
   normal_indices { 
      4, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>
   }
 
   uv_indices { 
      4, 
      <12, 2, 13>,
      <12, 13, 14>,
      <0, 15, 14>,
      <0, 14, 13>
   }
   uv_mapping
}
 
// Flange
mesh2 {
 
   vertex_vectors { 
      4, 
      <3.682629E+00, 4.647224E+00, -2.171729E+01>,
      <3.682629E+00, 1.265476E+00, -2.171729E+01>,
      <3.682628E+00, 1.265476E+00, -1.833554E+01>,
      <3.682628E+00, 4.647224E+00, -1.833554E+01>
   }
 
   normal_vectors { 
      1, 
      <1.00E+00, 2.067536E-07, 3.258414E-07>
   }
 
   uv_vectors { 
      13, 
      <0.00E+00, 0.00E+00>,
      <-7.50E-01, 2.50E-01>,
      <-7.50E-01, 0.00E+00>,
      <-1.00E+00, 0.00E+00>,
      <-1.00E+00, 2.50E-01>,
      <-5.00E-01, 2.50E-01>,
      <-5.00E-01, 0.00E+00>,
      <-1.00E+00, 4.999999E-01>,
      <-1.00E+00, 0.00E+00>,
      <-5.000001E-01, 5.00E-01>,
      <-1.00E+00, 0.00E+00>,
      <-5.000001E-01, 0.00E+00>,
      <-5.000001E-01, 5.00E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      2, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0
   }
 
   normal_indices { 
      2, 
      <0, 0, 0>,
      <0, 0, 0>
   }
 
   uv_indices { 
      2, 
      <7, 10, 11>,
      <7, 11, 12>
   }
   uv_mapping
}
 
// axle
mesh2 {
 
   vertex_vectors { 
      12, 
      <3.682629E+00, 2.95635E+00, -2.049641E+01>,
      <-1.025371E+00, 2.95635E+00, -2.049642E+01>,
      <3.682629E+00, 3.363382E+00, -2.026141E+01>,
      <-1.025371E+00, 3.363382E+00, -2.026142E+01>,
      <3.682629E+00, 3.363382E+00, -1.979141E+01>,
      <-1.025372E+00, 3.363382E+00, -1.979141E+01>,
      <3.682628E+00, 2.95635E+00, -1.955641E+01>,
      <-1.025372E+00, 2.95635E+00, -1.955641E+01>,
      <3.682629E+00, 2.549318E+00, -1.979141E+01>,
      <-1.025372E+00, 2.549318E+00, -1.979141E+01>,
      <3.682629E+00, 2.549318E+00, -2.026141E+01>,
      <-1.025371E+00, 2.549318E+00, -2.026142E+01>
   }
 
   normal_vectors { 
      8, 
      <1.629205E-07, 8.66026E-01, -4.999993E-01>,
      <2.821866E-07, 5.000016E-01, -8.660246E-01>,
      <-1.629205E-07, 8.66026E-01, 4.999993E-01>,
      <-2.821866E-07, 5.000016E-01, 8.660246E-01>,
      <-1.629205E-07, -8.660256E-01, 4.999993E-01>,
      <-2.821866E-07, -5.000013E-01, 8.660246E-01>,
      <1.629205E-07, -8.660256E-01, -4.999993E-01>,
      <2.821866E-07, -5.000013E-01, -8.660246E-01>
   }
 
   uv_vectors { 
      55, 
      <0.00E+00, 0.00E+00>,
      <-2.08447E-01, 2.929997E-02>,
      <-2.007531E-01, 2.929997E-02>,
      <-2.005589E-01, 2.244997E-02>,
      <-2.086411E-01, 2.244997E-02>,
      <-2.080531E-01, 2.929997E-02>,
      <-2.01147E-01, 2.929997E-02>,
      <-2.078589E-01, 2.244997E-02>,
      <-2.013412E-01, 2.244997E-02>,
      <-2.080531E-01, 1.559997E-02>,
      <-2.01147E-01, 1.559997E-02>,
      <-2.08447E-01, 1.559997E-02>,
      <-2.007531E-01, 1.559997E-02>,
      <-2.01147E-01, 2.929997E-02>,
      <-2.080531E-01, 2.929997E-02>,
      <-2.078589E-01, 2.244997E-02>,
      <-2.007531E-01, 1.559997E-02>,
      <-2.08447E-01, 1.559997E-02>,
      <-2.080531E-01, 1.559997E-02>,
      <-8.506777E-01, 2.10E-01>,
      <-8.788224E-01, 2.10E-01>,
      <-8.780311E-01, 2.007E-01>,
      <-8.514689E-01, 2.007E-01>,
      <-8.490724E-01, 2.10E-01>,
      <-8.804277E-01, 2.10E-01>,
      <-8.482811E-01, 2.007E-01>,
      <-8.81219E-01, 2.007E-01>,
      <-8.490724E-01, 1.914E-01>,
      <-8.804277E-01, 1.914E-01>,
      <-8.506777E-01, 1.914E-01>,
      <-8.788224E-01, 1.914E-01>,
      <-2.514114E-01, 6.716E-01>,
      <-8.298867E-02, 6.716E-01>,
      <-7.873844E-02, 5.886E-01>,
      <-2.556616E-01, 5.886E-01>,
      <-2.427887E-01, 6.716E-01>,
      <-9.161132E-02, 6.716E-01>,
      <-2.385384E-01, 5.886E-01>,
      <-9.586161E-02, 5.886E-01>,
      <-2.427887E-01, 5.056E-01>,
      <-9.161132E-02, 5.056E-01>,
      <-2.514114E-01, 5.056E-01>,
      <-8.298867E-02, 5.056E-01>,
      <-1.907546E-01, 6.741E-01>,
      <-1.124454E-01, 6.741E-01>,
      <-1.104693E-01, 5.9045E-01>,
      <-1.927308E-01, 5.9045E-01>,
      <-1.867455E-01, 6.741E-01>,
      <-1.164546E-01, 6.741E-01>,
      <-1.847693E-01, 5.9045E-01>,
      <-1.184308E-01, 5.9045E-01>,
      <-1.867455E-01, 5.068E-01>,
      <-1.164546E-01, 5.068E-01>,
      <-1.907546E-01, 5.068E-01>,
      <-1.124454E-01, 5.068E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      12, 
      <3, 2, 0>, 0,
      <3, 0, 1>, 0,
      <5, 4, 2>, 0,
      <5, 2, 3>, 0,
      <7, 6, 4>, 0,
      <7, 4, 5>, 0,
      <9, 8, 6>, 0,
      <9, 6, 7>, 0,
      <11, 10, 8>, 0,
      <11, 8, 9>, 0,
      <1, 0, 10>, 0,
      <1, 10, 11>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 2, 0>,
      <2, 0, 0>,
      <3, 3, 2>,
      <3, 2, 2>,
      <4, 4, 5>,
      <4, 5, 5>,
      <6, 6, 4>,
      <6, 4, 4>,
      <7, 7, 6>,
      <7, 6, 6>
   }
 
   uv_indices { 
      12, 
      <43, 44, 45>,
      <43, 45, 46>,
      <47, 48, 44>,
      <47, 44, 43>,
      <49, 50, 48>,
      <49, 48, 47>,
      <51, 52, 50>,
      <51, 50, 49>,
      <53, 54, 52>,
      <53, 52, 51>,
      <46, 45, 54>,
      <46, 54, 53>
   }
   uv_mapping
}
 
// Rim-Outer
mesh2 {
 
   vertex_vectors { 
      64, 
      <-1.025371E+00, 2.95635E+00, -1.661304E+01>,
      <-1.41937E+00, 2.95635E+00, -1.661304E+01>,
      <-1.025371E+00, 3.24862E+00, -1.658426E+01>,
      <-1.41937E+00, 3.24862E+00, -1.658426E+01>,
      <-1.025371E+00, 3.529657E+00, -1.6499E+01>,
      <-1.41937E+00, 3.529657E+00, -1.6499E+01>,
      <-1.025371E+00, 3.788663E+00, -1.636056E+01>,
      <-1.41937E+00, 3.788663E+00, -1.636056E+01>,
      <-1.025371E+00, 4.015684E+00, -1.617425E+01>,
      <-1.41937E+00, 4.015684E+00, -1.617425E+01>,
      <-1.025371E+00, 4.201995E+00, -1.594723E+01>,
      <-1.41937E+00, 4.201995E+00, -1.594723E+01>,
      <-1.025371E+00, 4.340436E+00, -1.568822E+01>,
      <-1.41937E+00, 4.340436E+00, -1.568822E+01>,
      <-1.025371E+00, 4.425689E+00, -1.540718E+01>,
      <-1.419371E+00, 4.425689E+00, -1.540718E+01>,
      <-1.025372E+00, 4.454475E+00, -1.511492E+01>,
      <-1.419371E+00, 4.454475E+00, -1.511492E+01>,
      <-1.025372E+00, 4.425689E+00, -1.482265E+01>,
      <-1.419371E+00, 4.425689E+00, -1.482265E+01>,
      <-1.025372E+00, 4.340436E+00, -1.454161E+01>,
      <-1.419371E+00, 4.340436E+00, -1.454161E+01>,
      <-1.025372E+00, 4.201995E+00, -1.42826E+01>,
      <-1.419371E+00, 4.201995E+00, -1.42826E+01>,
      <-1.025372E+00, 4.015684E+00, -1.405558E+01>,
      <-1.419371E+00, 4.015684E+00, -1.405558E+01>,
      <-1.025372E+00, 3.788663E+00, -1.386927E+01>,
      <-1.419371E+00, 3.788663E+00, -1.386927E+01>,
      <-1.025372E+00, 3.529657E+00, -1.373083E+01>,
      <-1.419371E+00, 3.529657E+00, -1.373083E+01>,
      <-1.025372E+00, 3.24862E+00, -1.364558E+01>,
      <-1.419371E+00, 3.24862E+00, -1.364558E+01>,
      <-1.025372E+00, 2.95635E+00, -1.361679E+01>,
      <-1.419371E+00, 2.95635E+00, -1.361679E+01>,
      <-1.025372E+00, 2.66408E+00, -1.364558E+01>,
      <-1.419371E+00, 2.66408E+00, -1.364558E+01>,
      <-1.025372E+00, 2.383042E+00, -1.373083E+01>,
      <-1.419371E+00, 2.383042E+00, -1.373083E+01>,
      <-1.025372E+00, 2.124036E+00, -1.386927E+01>,
      <-1.419371E+00, 2.124036E+00, -1.386927E+01>,
      <-1.025372E+00, 1.897015E+00, -1.405558E+01>,
      <-1.419371E+00, 1.897015E+00, -1.405558E+01>,
      <-1.025372E+00, 1.710705E+00, -1.42826E+01>,
      <-1.419371E+00, 1.710705E+00, -1.42826E+01>,
      <-1.025372E+00, 1.572263E+00, -1.454161E+01>,
      <-1.419371E+00, 1.572263E+00, -1.454161E+01>,
      <-1.025372E+00, 1.487011E+00, -1.482265E+01>,
      <-1.419371E+00, 1.487011E+00, -1.482265E+01>,
      <-1.025372E+00, 1.458225E+00, -1.511492E+01>,
      <-1.419371E+00, 1.458225E+00, -1.511492E+01>,
      <-1.025371E+00, 1.487011E+00, -1.540718E+01>,
      <-1.419371E+00, 1.487011E+00, -1.540718E+01>,
      <-1.025371E+00, 1.572263E+00, -1.568822E+01>,
      <-1.41937E+00, 1.572263E+00, -1.568822E+01>,
      <-1.025371E+00, 1.710705E+00, -1.594723E+01>,
      <-1.41937E+00, 1.710705E+00, -1.594723E+01>,
      <-1.025371E+00, 1.897015E+00, -1.617425E+01>,
      <-1.41937E+00, 1.897015E+00, -1.617425E+01>,
      <-1.025371E+00, 2.124036E+00, -1.636056E+01>,
      <-1.41937E+00, 2.124036E+00, -1.636056E+01>,
      <-1.025371E+00, 2.383042E+00, -1.6499E+01>,
      <-1.41937E+00, 2.383042E+00, -1.6499E+01>,
      <-1.025371E+00, 2.66408E+00, -1.658426E+01>,
      <-1.41937E+00, 2.66408E+00, -1.658426E+01>
   }
 
   normal_vectors { 
      32, 
      <3.195804E-07, 1.950904E-01, -9.807853E-01>,
      <3.258414E-07, 2.067536E-07, -1.00E+00>,
      <3.01038E-07, 3.826849E-01, -9.23879E-01>,
      <2.709274E-07, 5.555693E-01, -8.314704E-01>,
      <2.304045E-07, 7.071075E-01, -7.071063E-01>,
      <1.810273E-07, 8.314708E-01, -5.555688E-01>,
      <1.246943E-07, 9.238795E-01, -3.82684E-01>,
      <6.356863E-08, 9.807854E-01, -1.950908E-01>,
      <-4.280104E-16, 1.00E+00, 4.31381E-16>,
      <-6.356859E-08, 9.807854E-01, 1.950906E-01>,
      <-1.246942E-07, 9.238795E-01, 3.826839E-01>,
      <-1.810272E-07, 8.314709E-01, 5.555686E-01>,
      <-2.304045E-07, 7.071075E-01, 7.071063E-01>,
      <-2.709274E-07, 5.555693E-01, 8.314703E-01>,
      <-3.01038E-07, 3.82685E-01, 9.23879E-01>,
      <-3.195804E-07, 1.950904E-01, 9.807853E-01>,
      <-3.258414E-07, 2.067536E-07, 1.00E+00>,
      <-3.195804E-07, -1.9509E-01, 9.807853E-01>,
      <-3.01038E-07, -3.826844E-01, 9.23879E-01>,
      <-2.709274E-07, -5.555689E-01, 8.314704E-01>,
      <-2.304045E-07, -7.071071E-01, 7.071064E-01>,
      <-1.810273E-07, -8.314704E-01, 5.555688E-01>,
      <-1.246941E-07, -9.238793E-01, 3.826835E-01>,
      <-6.356853E-08, -9.807851E-01, 1.950904E-01>,
      <4.280104E-16, -9.999998E-01, -4.31381E-16>,
      <6.356855E-08, -9.807851E-01, -1.950905E-01>,
      <1.246941E-07, -9.238793E-01, -3.826835E-01>,
      <1.810273E-07, -8.314704E-01, -5.555688E-01>,
      <2.304045E-07, -7.071071E-01, -7.071064E-01>,
      <2.709274E-07, -5.555689E-01, -8.314703E-01>,
      <3.01038E-07, -3.826845E-01, -9.23879E-01>,
      <3.195804E-07, -1.9509E-01, -9.807853E-01>
   }
 
   uv_vectors { 
      41, 
      <0.00E+00, 0.00E+00>,
      <-2.999997E-02, 1.855E-01>,
      <-5.999994E-02, 1.855E-01>,
      <-5.999994E-02, 1.175E-01>,
      <-2.999997E-02, 1.175E-01>,
      <-6.000012E-02, 1.515E-01>,
      <-3.000009E-02, 1.515E-01>,
      <-9.956325E-01, 6.754004E-01>,
      <-9.956325E-01, 5.006004E-01>,
      <-9.988E-01, 5.006004E-01>,
      <-9.988E-01, 6.754004E-01>,
      <-9.862515E-01, 6.754004E-01>,
      <-9.862515E-01, 5.006004E-01>,
      <-9.710177E-01, 6.754004E-01>,
      <-9.710177E-01, 5.006004E-01>,
      <-9.505166E-01, 6.754004E-01>,
      <-9.505166E-01, 5.006004E-01>,
      <-9.255356E-01, 6.754004E-01>,
      <-9.255356E-01, 5.006004E-01>,
      <-8.970353E-01, 6.754004E-01>,
      <-8.970353E-01, 5.006004E-01>,
      <-8.661105E-01, 6.754004E-01>,
      <-8.661105E-01, 5.006004E-01>,
      <-8.3395E-01, 6.754004E-01>,
      <-8.3395E-01, 5.006004E-01>,
      <-8.017895E-01, 6.754004E-01>,
      <-8.017895E-01, 5.006004E-01>,
      <-7.708647E-01, 6.754004E-01>,
      <-7.708647E-01, 5.006004E-01>,
      <-7.423643E-01, 6.754004E-01>,
      <-7.423643E-01, 5.006004E-01>,
      <-7.173833E-01, 6.754004E-01>,
      <-7.173833E-01, 5.006004E-01>,
      <-6.968822E-01, 6.754004E-01>,
      <-6.968822E-01, 5.006004E-01>,
      <-6.816484E-01, 6.754004E-01>,
      <-6.816484E-01, 5.006004E-01>,
      <-6.722674E-01, 6.754004E-01>,
      <-6.722674E-01, 5.006004E-01>,
      <-6.691E-01, 6.754004E-01>,
      <-6.691E-01, 5.006004E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      64, 
      <3, 2, 0>, 0,
      <3, 0, 1>, 0,
      <5, 4, 2>, 0,
      <5, 2, 3>, 0,
      <7, 6, 4>, 0,
      <7, 4, 5>, 0,
      <9, 8, 6>, 0,
      <9, 6, 7>, 0,
      <11, 10, 8>, 0,
      <11, 8, 9>, 0,
      <13, 12, 10>, 0,
      <13, 10, 11>, 0,
      <15, 14, 12>, 0,
      <15, 12, 13>, 0,
      <17, 16, 14>, 0,
      <17, 14, 15>, 0,
      <19, 18, 16>, 0,
      <19, 16, 17>, 0,
      <21, 20, 18>, 0,
      <21, 18, 19>, 0,
      <23, 22, 20>, 0,
      <23, 20, 21>, 0,
      <25, 24, 22>, 0,
      <25, 22, 23>, 0,
      <27, 26, 24>, 0,
      <27, 24, 25>, 0,
      <29, 28, 26>, 0,
      <29, 26, 27>, 0,
      <31, 30, 28>, 0,
      <31, 28, 29>, 0,
      <33, 32, 30>, 0,
      <33, 30, 31>, 0,
      <35, 34, 32>, 0,
      <35, 32, 33>, 0,
      <37, 36, 34>, 0,
      <37, 34, 35>, 0,
      <39, 38, 36>, 0,
      <39, 36, 37>, 0,
      <41, 40, 38>, 0,
      <41, 38, 39>, 0,
      <43, 42, 40>, 0,
      <43, 40, 41>, 0,
      <45, 44, 42>, 0,
      <45, 42, 43>, 0,
      <47, 46, 44>, 0,
      <47, 44, 45>, 0,
      <49, 48, 46>, 0,
      <49, 46, 47>, 0,
      <51, 50, 48>, 0,
      <51, 48, 49>, 0,
      <53, 52, 50>, 0,
      <53, 50, 51>, 0,
      <55, 54, 52>, 0,
      <55, 52, 53>, 0,
      <57, 56, 54>, 0,
      <57, 54, 55>, 0,
      <59, 58, 56>, 0,
      <59, 56, 57>, 0,
      <61, 60, 58>, 0,
      <61, 58, 59>, 0,
      <63, 62, 60>, 0,
      <63, 60, 61>, 0,
      <1, 0, 62>, 0,
      <1, 62, 63>, 0
   }
 
   normal_indices { 
      64, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 2, 0>,
      <2, 0, 0>,
      <3, 3, 2>,
      <3, 2, 2>,
      <4, 4, 3>,
      <4, 3, 3>,
      <5, 5, 4>,
      <5, 4, 4>,
      <6, 6, 5>,
      <6, 5, 5>,
      <7, 7, 6>,
      <7, 6, 6>,
      <8, 8, 7>,
      <8, 7, 7>,
      <9, 9, 8>,
      <9, 8, 8>,
      <10, 10, 9>,
      <10, 9, 9>,
      <11, 11, 10>,
      <11, 10, 10>,
      <12, 12, 11>,
      <12, 11, 11>,
      <13, 13, 12>,
      <13, 12, 12>,
      <14, 14, 13>,
      <14, 13, 13>,
      <15, 15, 14>,
      <15, 14, 14>,
      <16, 16, 15>,
      <16, 15, 15>,
      <17, 17, 16>,
      <17, 16, 16>,
      <18, 18, 17>,
      <18, 17, 17>,
      <19, 19, 18>,
      <19, 18, 18>,
      <20, 20, 19>,
      <20, 19, 19>,
      <21, 21, 20>,
      <21, 20, 20>,
      <22, 22, 21>,
      <22, 21, 21>,
      <23, 23, 22>,
      <23, 22, 22>,
      <24, 24, 23>,
      <24, 23, 23>,
      <25, 25, 24>,
      <25, 24, 24>,
      <26, 26, 25>,
      <26, 25, 25>,
      <27, 27, 26>,
      <27, 26, 26>,
      <28, 28, 27>,
      <28, 27, 27>,
      <29, 29, 28>,
      <29, 28, 28>,
      <30, 30, 29>,
      <30, 29, 29>,
      <31, 31, 30>,
      <31, 30, 30>,
      <1, 1, 31>,
      <1, 31, 31>
   }
 
   uv_indices { 
      64, 
      <7, 8, 9>,
      <7, 9, 10>,
      <11, 12, 8>,
      <11, 8, 7>,
      <13, 14, 12>,
      <13, 12, 11>,
      <15, 16, 14>,
      <15, 14, 13>,
      <17, 18, 16>,
      <17, 16, 15>,
      <19, 20, 18>,
      <19, 18, 17>,
      <21, 22, 20>,
      <21, 20, 19>,
      <23, 24, 22>,
      <23, 22, 21>,
      <25, 26, 24>,
      <25, 24, 23>,
      <27, 28, 26>,
      <27, 26, 25>,
      <29, 30, 28>,
      <29, 28, 27>,
      <31, 32, 30>,
      <31, 30, 29>,
      <33, 34, 32>,
      <33, 32, 31>,
      <35, 36, 34>,
      <35, 34, 33>,
      <37, 38, 36>,
      <37, 36, 35>,
      <39, 40, 38>,
      <39, 38, 37>,
      <37, 38, 40>,
      <37, 40, 39>,
      <35, 36, 38>,
      <35, 38, 37>,
      <33, 34, 36>,
      <33, 36, 35>,
      <31, 32, 34>,
      <31, 34, 33>,
      <29, 30, 32>,
      <29, 32, 31>,
      <27, 28, 30>,
      <27, 30, 29>,
      <25, 26, 28>,
      <25, 28, 27>,
      <23, 24, 26>,
      <23, 26, 25>,
      <21, 22, 24>,
      <21, 24, 23>,
      <19, 20, 22>,
      <19, 22, 21>,
      <17, 18, 20>,
      <17, 20, 19>,
      <15, 16, 18>,
      <15, 18, 17>,
      <13, 14, 16>,
      <13, 16, 15>,
      <11, 12, 14>,
      <11, 14, 13>,
      <7, 8, 12>,
      <7, 12, 11>,
      <10, 9, 8>,
      <10, 8, 7>
   }
   uv_mapping
}
 
// Faces
mesh2 {
 
   vertex_vectors { 
      8, 
      <-1.419371E+00, 1.458225E+00, -1.361679E+01>,
      <-1.41937E+00, 1.458225E+00, -1.661304E+01>,
      <-1.41937E+00, 4.454475E+00, -1.661304E+01>,
      <-1.419371E+00, 4.454475E+00, -1.361679E+01>,
      <-1.025371E+00, 4.454475E+00, -1.661304E+01>,
      <-1.025372E+00, 4.454475E+00, -1.361679E+01>,
      <-1.025372E+00, 1.458225E+00, -1.361679E+01>,
      <-1.025371E+00, 1.458225E+00, -1.661304E+01>
   }
 
   normal_vectors { 
      2, 
      <-1.00E+00, 2.067536E-07, -3.258414E-07>,
      <1.00E+00, 2.067536E-07, 3.258414E-07>
   }
 
   uv_vectors { 
      15, 
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <-1.00E+00, 2.50E-01>,
      <-7.50E-01, 2.50E-01>,
      <-7.50E-01, 0.00E+00>,
      <-1.00E+00, 0.00E+00>,
      <-5.00E-01, 5.00E-01>,
      <-1.00E+00, 5.00E-01>,
      <-1.00E+00, 0.00E+00>,
      <-5.00E-01, 0.00E+00>,
      <-5.00E-01, 5.00E-01>,
      <0.00E+00, 5.00E-01>,
      <-5.00E-01, 5.00E-01>,
      <-1.00E+00, 0.00E+00>,
      <-5.00E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      4, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0
   }
 
   normal_indices { 
      4, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>
   }
 
   uv_indices { 
      4, 
      <12, 7, 13>,
      <12, 13, 14>,
      <11, 12, 14>,
      <11, 14, 0>
   }
   uv_mapping
}
 
// Flange
mesh2 {
 
   vertex_vectors { 
      4, 
      <-1.025372E+00, 1.265476E+00, -1.342404E+01>,
      <-1.025371E+00, 1.265476E+00, -1.680579E+01>,
      <-1.025371E+00, 4.647224E+00, -1.680579E+01>,
      <-1.025372E+00, 4.647224E+00, -1.342404E+01>
   }
 
   normal_vectors { 
      1, 
      <-1.00E+00, 2.067536E-07, -3.258414E-07>
   }
 
   uv_vectors { 
      9, 
      <0.00E+00, 0.00E+00>,
      <-1.00E+00, 2.50E-01>,
      <-7.50E-01, 2.50E-01>,
      <-7.50E-01, 0.00E+00>,
      <-1.00E+00, 0.00E+00>,
      <-5.000001E-01, 5.00E-01>,
      <-1.00E+00, 5.00E-01>,
      <-1.00E+00, 0.00E+00>,
      <-5.000001E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      2, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0
   }
 
   normal_indices { 
      2, 
      <0, 0, 0>,
      <0, 0, 0>
   }
 
   uv_indices { 
      2, 
      <5, 6, 7>,
      <5, 7, 8>
   }
   uv_mapping
}
 
// Rim-Outer
mesh2 {
 
   vertex_vectors { 
      64, 
      <3.682629E+00, 1.458225E+00, -1.511491E+01>,
      <4.07663E+00, 1.458225E+00, -1.511491E+01>,
      <3.682629E+00, 1.487011E+00, -1.482265E+01>,
      <4.07663E+00, 1.487011E+00, -1.482265E+01>,
      <3.682628E+00, 1.572263E+00, -1.454161E+01>,
      <4.07663E+00, 1.572263E+00, -1.454161E+01>,
      <3.682628E+00, 1.710704E+00, -1.42826E+01>,
      <4.076629E+00, 1.710705E+00, -1.42826E+01>,
      <3.682628E+00, 1.897015E+00, -1.405558E+01>,
      <4.076629E+00, 1.897016E+00, -1.405558E+01>,
      <3.682628E+00, 2.124036E+00, -1.386927E+01>,
      <4.076629E+00, 2.124036E+00, -1.386927E+01>,
      <3.682628E+00, 2.383042E+00, -1.373083E+01>,
      <4.076629E+00, 2.383042E+00, -1.373083E+01>,
      <3.682628E+00, 2.66408E+00, -1.364557E+01>,
      <4.076629E+00, 2.66408E+00, -1.364557E+01>,
      <3.682628E+00, 2.95635E+00, -1.361679E+01>,
      <4.076629E+00, 2.95635E+00, -1.361679E+01>,
      <3.682628E+00, 3.24862E+00, -1.364557E+01>,
      <4.076629E+00, 3.24862E+00, -1.364557E+01>,
      <3.682628E+00, 3.529657E+00, -1.373083E+01>,
      <4.076629E+00, 3.529657E+00, -1.373083E+01>,
      <3.682628E+00, 3.788663E+00, -1.386927E+01>,
      <4.076629E+00, 3.788663E+00, -1.386927E+01>,
      <3.682628E+00, 4.015684E+00, -1.405558E+01>,
      <4.076629E+00, 4.015684E+00, -1.405558E+01>,
      <3.682628E+00, 4.201995E+00, -1.42826E+01>,
      <4.076629E+00, 4.201995E+00, -1.42826E+01>,
      <3.682628E+00, 4.340437E+00, -1.454161E+01>,
      <4.07663E+00, 4.340436E+00, -1.454161E+01>,
      <3.682629E+00, 4.425689E+00, -1.482264E+01>,
      <4.07663E+00, 4.425689E+00, -1.482264E+01>,
      <3.682629E+00, 4.454475E+00, -1.511491E+01>,
      <4.07663E+00, 4.454475E+00, -1.511491E+01>,
      <3.682629E+00, 4.425689E+00, -1.540718E+01>,
      <4.07663E+00, 4.425689E+00, -1.540718E+01>,
      <3.682629E+00, 4.340437E+00, -1.568822E+01>,
      <4.07663E+00, 4.340436E+00, -1.568822E+01>,
      <3.682629E+00, 4.201995E+00, -1.594723E+01>,
      <4.07663E+00, 4.201995E+00, -1.594723E+01>,
      <3.682629E+00, 4.015685E+00, -1.617425E+01>,
      <4.07663E+00, 4.015684E+00, -1.617425E+01>,
      <3.682629E+00, 3.788664E+00, -1.636056E+01>,
      <4.07663E+00, 3.788664E+00, -1.636056E+01>,
      <3.682629E+00, 3.529657E+00, -1.6499E+01>,
      <4.07663E+00, 3.529657E+00, -1.6499E+01>,
      <3.682629E+00, 3.24862E+00, -1.658425E+01>,
      <4.07663E+00, 3.24862E+00, -1.658425E+01>,
      <3.682629E+00, 2.95635E+00, -1.661304E+01>,
      <4.07663E+00, 2.95635E+00, -1.661304E+01>,
      <3.682629E+00, 2.66408E+00, -1.658425E+01>,
      <4.07663E+00, 2.66408E+00, -1.658425E+01>,
      <3.682629E+00, 2.383042E+00, -1.6499E+01>,
      <4.07663E+00, 2.383042E+00, -1.6499E+01>,
      <3.682629E+00, 2.124036E+00, -1.636056E+01>,
      <4.07663E+00, 2.124036E+00, -1.636056E+01>,
      <3.682629E+00, 1.897015E+00, -1.617425E+01>,
      <4.07663E+00, 1.897015E+00, -1.617425E+01>,
      <3.682629E+00, 1.710704E+00, -1.594723E+01>,
      <4.07663E+00, 1.710705E+00, -1.594723E+01>,
      <3.682629E+00, 1.572263E+00, -1.568822E+01>,
      <4.07663E+00, 1.572263E+00, -1.568822E+01>,
      <3.682629E+00, 1.487011E+00, -1.540718E+01>,
      <4.07663E+00, 1.487011E+00, -1.540718E+01>
   }
 
   normal_vectors { 
      32, 
      <2.409085E-07, -9.807851E-01, 1.950905E-01>,
      <4.280104E-16, -9.999998E-01, -4.31381E-16>,
      <1.834558E-07, -9.238793E-01, 3.826836E-01>,
      <6.33808E-08, -8.314705E-01, 5.555688E-01>,
      <-5.072557E-08, -7.071071E-01, 7.071063E-01>,
      <-1.982199E-07, -5.555689E-01, 8.314704E-01>,
      <-2.70354E-07, -3.826845E-01, 9.23879E-01>,
      <-2.706133E-07, -1.950898E-01, 9.807854E-01>,
      <-3.258414E-07, 2.067536E-07, 1.00E+00>,
      <-3.195804E-07, 1.950901E-01, 9.807854E-01>,
      <-3.01038E-07, 3.826849E-01, 9.23879E-01>,
      <-2.709275E-07, 5.555692E-01, 8.314705E-01>,
      <6.058507E-07, 7.071065E-01, 7.071072E-01>,
      <1.477715E-06, 8.314707E-01, 5.555689E-01>,
      <8.424934E-07, 9.238797E-01, 3.826836E-01>,
      <2.331784E-07, 9.807853E-01, 1.950911E-01>,
      <-4.280104E-16, 1.00E+00, 4.31381E-16>,
      <3.676623E-07, 9.807854E-01, -1.950906E-01>,
      <5.881808E-07, 9.238796E-01, -3.826838E-01>,
      <6.698435E-07, 8.314709E-01, -5.555686E-01>,
      <5.436733E-07, 7.071075E-01, -7.071062E-01>,
      <4.068199E-07, 5.555693E-01, -8.314704E-01>,
      <3.229491E-07, 3.826849E-01, -9.23879E-01>,
      <3.414915E-07, 1.950902E-01, -9.807854E-01>,
      <3.258414E-07, 2.067536E-07, -1.00E+00>,
      <3.195804E-07, -1.950897E-01, -9.807854E-01>,
      <3.770613E-07, -3.826844E-01, -9.23879E-01>,
      <4.321159E-07, -5.555689E-01, -8.314704E-01>,
      <1.197914E-06, -7.071062E-01, -7.071072E-01>,
      <1.746477E-06, -8.314703E-01, -5.55569E-01>,
      <9.561732E-07, -9.238793E-01, -3.826837E-01>,
      <3.636063E-07, -9.80785E-01, -1.950911E-01>
   }
 
   uv_vectors { 
      41, 
      <0.00E+00, 0.00E+00>,
      <-6.00E-02, 1.175E-01>,
      <-3.000003E-02, 1.175E-01>,
      <-3.000003E-02, 1.855E-01>,
      <-6.00E-02, 1.855E-01>,
      <-6.00E-02, 1.515E-01>,
      <-3.000003E-02, 1.515E-01>,
      <-8.017895E-01, 6.754E-01>,
      <-8.017895E-01, 5.006E-01>,
      <-8.3395E-01, 5.006E-01>,
      <-8.3395E-01, 6.754E-01>,
      <-7.708647E-01, 6.754E-01>,
      <-7.708647E-01, 5.006E-01>,
      <-7.423643E-01, 6.754E-01>,
      <-7.423643E-01, 5.006E-01>,
      <-7.173833E-01, 6.754E-01>,
      <-7.173833E-01, 5.006E-01>,
      <-6.968822E-01, 6.754E-01>,
      <-6.968822E-01, 5.006E-01>,
      <-6.816484E-01, 6.754E-01>,
      <-6.816484E-01, 5.006E-01>,
      <-6.722674E-01, 6.754E-01>,
      <-6.722674E-01, 5.006E-01>,
      <-6.691E-01, 6.754E-01>,
      <-6.691E-01, 5.006E-01>,
      <-8.661105E-01, 6.754E-01>,
      <-8.661105E-01, 5.006E-01>,
      <-8.970353E-01, 6.754E-01>,
      <-8.970353E-01, 5.006E-01>,
      <-9.255356E-01, 6.754E-01>,
      <-9.255356E-01, 5.006E-01>,
      <-9.505166E-01, 6.754E-01>,
      <-9.505166E-01, 5.006E-01>,
      <-9.710177E-01, 6.754E-01>,
      <-9.710177E-01, 5.006E-01>,
      <-9.862515E-01, 6.754E-01>,
      <-9.862515E-01, 5.006E-01>,
      <-9.956325E-01, 6.754E-01>,
      <-9.956325E-01, 5.006E-01>,
      <-9.988E-01, 6.754E-01>,
      <-9.988E-01, 5.006E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      64, 
      <3, 2, 0>, 0,
      <3, 0, 1>, 0,
      <5, 4, 2>, 0,
      <5, 2, 3>, 0,
      <7, 6, 4>, 0,
      <7, 4, 5>, 0,
      <9, 8, 6>, 0,
      <9, 6, 7>, 0,
      <11, 10, 8>, 0,
      <11, 8, 9>, 0,
      <13, 12, 10>, 0,
      <13, 10, 11>, 0,
      <15, 14, 12>, 0,
      <15, 12, 13>, 0,
      <17, 16, 14>, 0,
      <17, 14, 15>, 0,
      <19, 18, 16>, 0,
      <19, 16, 17>, 0,
      <21, 20, 18>, 0,
      <21, 18, 19>, 0,
      <23, 22, 20>, 0,
      <23, 20, 21>, 0,
      <25, 24, 22>, 0,
      <25, 22, 23>, 0,
      <27, 26, 24>, 0,
      <27, 24, 25>, 0,
      <29, 28, 26>, 0,
      <29, 26, 27>, 0,
      <31, 30, 28>, 0,
      <31, 28, 29>, 0,
      <33, 32, 30>, 0,
      <33, 30, 31>, 0,
      <35, 34, 32>, 0,
      <35, 32, 33>, 0,
      <37, 36, 34>, 0,
      <37, 34, 35>, 0,
      <39, 38, 36>, 0,
      <39, 36, 37>, 0,
      <41, 40, 38>, 0,
      <41, 38, 39>, 0,
      <43, 42, 40>, 0,
      <43, 40, 41>, 0,
      <45, 44, 42>, 0,
      <45, 42, 43>, 0,
      <47, 46, 44>, 0,
      <47, 44, 45>, 0,
      <49, 48, 46>, 0,
      <49, 46, 47>, 0,
      <51, 50, 48>, 0,
      <51, 48, 49>, 0,
      <53, 52, 50>, 0,
      <53, 50, 51>, 0,
      <55, 54, 52>, 0,
      <55, 52, 53>, 0,
      <57, 56, 54>, 0,
      <57, 54, 55>, 0,
      <59, 58, 56>, 0,
      <59, 56, 57>, 0,
      <61, 60, 58>, 0,
      <61, 58, 59>, 0,
      <63, 62, 60>, 0,
      <63, 60, 61>, 0,
      <1, 0, 62>, 0,
      <1, 62, 63>, 0
   }
 
   normal_indices { 
      64, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 2, 0>,
      <2, 0, 0>,
      <3, 3, 2>,
      <3, 2, 2>,
      <4, 4, 3>,
      <4, 3, 3>,
      <5, 5, 4>,
      <5, 4, 4>,
      <6, 6, 5>,
      <6, 5, 5>,
      <7, 7, 6>,
      <7, 6, 6>,
      <8, 8, 7>,
      <8, 7, 7>,
      <9, 9, 8>,
      <9, 8, 8>,
      <10, 10, 9>,
      <10, 9, 9>,
      <11, 11, 10>,
      <11, 10, 10>,
      <12, 12, 11>,
      <12, 11, 11>,
      <13, 13, 12>,
      <13, 12, 12>,
      <14, 14, 13>,
      <14, 13, 13>,
      <15, 15, 14>,
      <15, 14, 14>,
      <16, 16, 15>,
      <16, 15, 15>,
      <17, 17, 16>,
      <17, 16, 16>,
      <18, 18, 17>,
      <18, 17, 17>,
      <19, 19, 18>,
      <19, 18, 18>,
      <20, 20, 19>,
      <20, 19, 19>,
      <21, 21, 20>,
      <21, 20, 20>,
      <22, 22, 21>,
      <22, 21, 21>,
      <23, 23, 22>,
      <23, 22, 22>,
      <24, 24, 23>,
      <24, 23, 23>,
      <25, 25, 24>,
      <25, 24, 24>,
      <26, 26, 25>,
      <26, 25, 25>,
      <27, 27, 26>,
      <27, 26, 26>,
      <28, 28, 27>,
      <28, 27, 27>,
      <29, 29, 28>,
      <29, 28, 28>,
      <30, 30, 29>,
      <30, 29, 29>,
      <31, 31, 30>,
      <31, 30, 30>,
      <1, 1, 31>,
      <1, 31, 31>
   }
 
   uv_indices { 
      64, 
      <7, 8, 9>,
      <7, 9, 10>,
      <11, 12, 8>,
      <11, 8, 7>,
      <13, 14, 12>,
      <13, 12, 11>,
      <15, 16, 14>,
      <15, 14, 13>,
      <17, 18, 16>,
      <17, 16, 15>,
      <19, 20, 18>,
      <19, 18, 17>,
      <21, 22, 20>,
      <21, 20, 19>,
      <23, 24, 22>,
      <23, 22, 21>,
      <21, 22, 24>,
      <21, 24, 23>,
      <19, 20, 22>,
      <19, 22, 21>,
      <17, 18, 20>,
      <17, 20, 19>,
      <15, 16, 18>,
      <15, 18, 17>,
      <13, 14, 16>,
      <13, 16, 15>,
      <11, 12, 14>,
      <11, 14, 13>,
      <7, 8, 12>,
      <7, 12, 11>,
      <10, 9, 8>,
      <10, 8, 7>,
      <25, 26, 9>,
      <25, 9, 10>,
      <27, 28, 26>,
      <27, 26, 25>,
      <29, 30, 28>,
      <29, 28, 27>,
      <31, 32, 30>,
      <31, 30, 29>,
      <33, 34, 32>,
      <33, 32, 31>,
      <35, 36, 34>,
      <35, 34, 33>,
      <37, 38, 36>,
      <37, 36, 35>,
      <39, 40, 38>,
      <39, 38, 37>,
      <37, 38, 40>,
      <37, 40, 39>,
      <35, 36, 38>,
      <35, 38, 37>,
      <33, 34, 36>,
      <33, 36, 35>,
      <31, 32, 34>,
      <31, 34, 33>,
      <29, 30, 32>,
      <29, 32, 31>,
      <27, 28, 30>,
      <27, 30, 29>,
      <25, 26, 28>,
      <25, 28, 27>,
      <10, 9, 26>,
      <10, 26, 25>
   }
   uv_mapping
}
 
// Faces
mesh2 {
 
   vertex_vectors { 
      8, 
      <4.07663E+00, 4.454475E+00, -1.661304E+01>,
      <4.07663E+00, 1.458225E+00, -1.661304E+01>,
      <4.076629E+00, 1.458225E+00, -1.361679E+01>,
      <4.076629E+00, 4.454475E+00, -1.361679E+01>,
      <3.682628E+00, 1.458225E+00, -1.361679E+01>,
      <3.682628E+00, 4.454475E+00, -1.361679E+01>,
      <3.682629E+00, 4.454475E+00, -1.661304E+01>,
      <3.682629E+00, 1.458225E+00, -1.661304E+01>
   }
 
   normal_vectors { 
      2, 
      <1.00E+00, 2.067536E-07, 3.258414E-07>,
      <-1.00E+00, 2.067536E-07, -3.258414E-07>
   }
 
   uv_vectors { 
      12, 
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <-1.00E+00, 0.00E+00>,
      <-1.00E+00, 2.50E-01>,
      <-7.50E-01, 2.50E-01>,
      <-7.50E-01, 0.00E+00>,
      <-1.00E+00, 5.00E-01>,
      <-5.00E-01, 0.00E+00>,
      <-5.00E-01, 5.00E-01>,
      <0.00E+00, 5.00E-01>,
      <-5.00E-01, 0.00E+00>,
      <-5.00E-01, 5.00E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      4, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0
   }
 
   normal_indices { 
      4, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>
   }
 
   uv_indices { 
      4, 
      <6, 2, 10>,
      <6, 10, 11>,
      <0, 9, 11>,
      <0, 11, 10>
   }
   uv_mapping
}
 
// Flange
mesh2 {
 
   vertex_vectors { 
      4, 
      <3.682629E+00, 4.647224E+00, -1.680579E+01>,
      <3.682629E+00, 1.265476E+00, -1.680579E+01>,
      <3.682628E+00, 1.265476E+00, -1.342404E+01>,
      <3.682628E+00, 4.647224E+00, -1.342404E+01>
   }
 
   normal_vectors { 
      1, 
      <1.00E+00, 2.067536E-07, 3.258414E-07>
   }
 
   uv_vectors { 
      12, 
      <0.00E+00, 0.00E+00>,
      <-7.50E-01, 2.50E-01>,
      <-7.50E-01, 0.00E+00>,
      <-1.00E+00, 0.00E+00>,
      <-1.00E+00, 2.50E-01>,
      <-1.00E+00, 4.999999E-01>,
      <-1.00E+00, 0.00E+00>,
      <-5.000001E-01, 0.00E+00>,
      <-5.000001E-01, 5.00E-01>,
      <-1.00E+00, 0.00E+00>,
      <-5.000001E-01, 0.00E+00>,
      <-5.000001E-01, 5.00E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      2, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0
   }
 
   normal_indices { 
      2, 
      <0, 0, 0>,
      <0, 0, 0>
   }
 
   uv_indices { 
      2, 
      <5, 9, 10>,
      <5, 10, 11>
   }
   uv_mapping
}
 
// axle
mesh2 {
 
   vertex_vectors { 
      12, 
      <3.682629E+00, 2.95635E+00, -1.558492E+01>,
      <-1.025371E+00, 2.95635E+00, -1.558492E+01>,
      <3.682629E+00, 3.363382E+00, -1.534991E+01>,
      <-1.025371E+00, 3.363382E+00, -1.534992E+01>,
      <3.682629E+00, 3.363382E+00, -1.487991E+01>,
      <-1.025372E+00, 3.363382E+00, -1.487992E+01>,
      <3.682628E+00, 2.95635E+00, -1.464491E+01>,
      <-1.025372E+00, 2.95635E+00, -1.464491E+01>,
      <3.682629E+00, 2.549318E+00, -1.487991E+01>,
      <-1.025372E+00, 2.549318E+00, -1.487992E+01>,
      <3.682629E+00, 2.549318E+00, -1.534991E+01>,
      <-1.025371E+00, 2.549318E+00, -1.534992E+01>
   }
 
   normal_vectors { 
      8, 
      <1.629205E-07, 8.66026E-01, -4.999993E-01>,
      <2.821866E-07, 5.000016E-01, -8.660246E-01>,
      <-1.629205E-07, 8.66026E-01, 4.999993E-01>,
      <-2.821866E-07, 5.000016E-01, 8.660246E-01>,
      <-1.629205E-07, -8.660256E-01, 4.999993E-01>,
      <-2.821866E-07, -5.000013E-01, 8.660246E-01>,
      <1.629205E-07, -8.660256E-01, -4.999993E-01>,
      <2.821866E-07, -5.000013E-01, -8.660246E-01>
   }
 
   uv_vectors { 
      49, 
      <0.00E+00, 0.00E+00>,
      <-2.08447E-01, 2.929997E-02>,
      <-2.007531E-01, 2.929997E-02>,
      <-2.005589E-01, 2.244997E-02>,
      <-2.086411E-01, 2.244997E-02>,
      <-2.080531E-01, 2.929997E-02>,
      <-2.01147E-01, 2.929997E-02>,
      <-2.078589E-01, 2.244997E-02>,
      <-2.013412E-01, 2.244997E-02>,
      <-2.080531E-01, 1.559997E-02>,
      <-2.01147E-01, 1.559997E-02>,
      <-2.08447E-01, 1.559997E-02>,
      <-2.007531E-01, 1.559997E-02>,
      <-8.506777E-01, 2.10E-01>,
      <-8.788224E-01, 2.10E-01>,
      <-8.780311E-01, 2.007E-01>,
      <-8.514689E-01, 2.007E-01>,
      <-8.490724E-01, 2.10E-01>,
      <-8.804277E-01, 2.10E-01>,
      <-8.482811E-01, 2.007E-01>,
      <-8.81219E-01, 2.007E-01>,
      <-8.490724E-01, 1.914E-01>,
      <-8.804277E-01, 1.914E-01>,
      <-8.506777E-01, 1.914E-01>,
      <-8.788224E-01, 1.914E-01>,
      <-2.514114E-01, 6.716E-01>,
      <-8.298867E-02, 6.716E-01>,
      <-7.873844E-02, 5.886E-01>,
      <-2.556616E-01, 5.886E-01>,
      <-2.427887E-01, 6.716E-01>,
      <-9.161132E-02, 6.716E-01>,
      <-2.385384E-01, 5.886E-01>,
      <-9.586161E-02, 5.886E-01>,
      <-2.427887E-01, 5.056E-01>,
      <-9.161132E-02, 5.056E-01>,
      <-2.514114E-01, 5.056E-01>,
      <-8.298867E-02, 5.056E-01>,
      <-1.907546E-01, 6.741E-01>,
      <-1.124454E-01, 6.741E-01>,
      <-1.104693E-01, 5.9045E-01>,
      <-1.927308E-01, 5.9045E-01>,
      <-1.867455E-01, 6.741E-01>,
      <-1.164546E-01, 6.741E-01>,
      <-1.847693E-01, 5.9045E-01>,
      <-1.184308E-01, 5.9045E-01>,
      <-1.867455E-01, 5.068E-01>,
      <-1.164546E-01, 5.068E-01>,
      <-1.907546E-01, 5.068E-01>,
      <-1.124454E-01, 5.068E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      12, 
      <3, 2, 0>, 0,
      <3, 0, 1>, 0,
      <5, 4, 2>, 0,
      <5, 2, 3>, 0,
      <7, 6, 4>, 0,
      <7, 4, 5>, 0,
      <9, 8, 6>, 0,
      <9, 6, 7>, 0,
      <11, 10, 8>, 0,
      <11, 8, 9>, 0,
      <1, 0, 10>, 0,
      <1, 10, 11>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 2, 0>,
      <2, 0, 0>,
      <3, 3, 2>,
      <3, 2, 2>,
      <4, 4, 5>,
      <4, 5, 5>,
      <6, 6, 4>,
      <6, 4, 4>,
      <7, 7, 6>,
      <7, 6, 6>
   }
 
   uv_indices { 
      12, 
      <37, 38, 39>,
      <37, 39, 40>,
      <41, 42, 38>,
      <41, 38, 37>,
      <43, 44, 42>,
      <43, 42, 41>,
      <45, 46, 44>,
      <45, 44, 43>,
      <47, 48, 46>,
      <47, 46, 45>,
      <40, 39, 48>,
      <40, 48, 47>
   }
   uv_mapping
}
 
// Bogie
mesh2 {
 
   vertex_vectors { 
      40, 
      <4.526381E-01, 4.657869E+00, 5.987204E+00>,
      <2.204603E+00, 4.657869E+00, 5.987205E+00>,
      <2.204604E+00, 4.657869E+00, 3.089837E+00>,
      <4.526391E-01, 4.657869E+00, 3.089837E+00>,
      <4.526381E-01, 3.61461E+00, 5.987204E+00>,
      <4.526391E-01, 3.61461E+00, 3.089837E+00>,
      <2.204604E+00, 3.61461E+00, 3.089837E+00>,
      <2.204603E+00, 3.61461E+00, 5.987205E+00>,
      <1.92862E+00, 3.482869E+00, 7.984706E+00>,
      <1.92862E+00, 4.657869E+00, 7.984706E+00>,
      <7.286194E-01, 4.657869E+00, 7.984706E+00>,
      <7.286194E-01, 3.482869E+00, 7.984706E+00>,
      <7.286201E-01, 3.482869E+00, 5.987205E+00>,
      <7.286201E-01, 4.657869E+00, 5.987205E+00>,
      <1.928621E+00, 4.657869E+00, 5.987205E+00>,
      <1.928621E+00, 3.482869E+00, 5.987205E+00>,
      <-1.67138E+00, 3.659119E+00, 7.784955E+00>,
      <-1.67138E+00, 4.481619E+00, 7.784955E+00>,
      <-1.67138E+00, 4.481619E+00, 6.186954E+00>,
      <-1.67138E+00, 3.659119E+00, 6.186954E+00>,
      <4.32862E+00, 3.659119E+00, 6.186956E+00>,
      <4.32862E+00, 4.481619E+00, 6.186956E+00>,
      <4.32862E+00, 4.481619E+00, 7.784957E+00>,
      <4.32862E+00, 3.659119E+00, 7.784957E+00>,
      <1.928622E+00, 3.482869E+00, 3.089837E+00>,
      <1.928622E+00, 4.657869E+00, 3.089837E+00>,
      <7.28621E-01, 4.657869E+00, 3.089837E+00>,
      <7.28621E-01, 3.482869E+00, 3.089837E+00>,
      <7.286217E-01, 3.482869E+00, 1.092335E+00>,
      <7.286217E-01, 4.657869E+00, 1.092335E+00>,
      <1.928622E+00, 4.657869E+00, 1.092336E+00>,
      <1.928622E+00, 3.482869E+00, 1.092336E+00>,
      <-1.671378E+00, 3.659119E+00, 2.890085E+00>,
      <-1.671378E+00, 4.481619E+00, 2.890085E+00>,
      <-1.671378E+00, 4.481619E+00, 1.292086E+00>,
      <-1.671378E+00, 3.659119E+00, 1.292086E+00>,
      <4.328622E+00, 3.659119E+00, 1.292088E+00>,
      <4.328622E+00, 4.481619E+00, 1.292088E+00>,
      <4.328621E+00, 4.481619E+00, 2.890087E+00>,
      <4.328621E+00, 3.659119E+00, 2.890087E+00>
   }
 
   normal_vectors { 
      20, 
      <-1.104931E-16, 9.999999E-01, -2.459337E-16>,
      <1.104931E-16, -1.00E+00, 2.459337E-16>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <3.534994E-02, -3.166497E-08, 9.99375E-01>,
      <-3.535059E-02, -3.166497E-08, 9.99375E-01>,
      <-3.534994E-02, -3.166497E-08, -9.99375E-01>,
      <3.535059E-02, -3.166497E-08, -9.99375E-01>,
      <3.120436E-02, 9.99513E-01, 1.016767E-08>,
      <-3.120436E-02, 9.99513E-01, -1.016767E-08>,
      <-3.120436E-02, -9.995131E-01, -1.016767E-08>,
      <3.120436E-02, -9.995131E-01, 1.016767E-08>,
      <-7.065667E-02, -3.166497E-08, 9.975007E-01>,
      <-6.237834E-02, 9.980525E-01, -2.032544E-08>,
      <-7.0656E-02, -3.166497E-08, -9.975008E-01>,
      <-6.237833E-02, -9.980527E-01, -2.032544E-08>,
      <7.065667E-02, -3.166497E-08, -9.975007E-01>,
      <6.237834E-02, 9.980525E-01, 2.032544E-08>,
      <7.065601E-02, -3.166497E-08, 9.975008E-01>,
      <6.237834E-02, -9.980527E-01, 2.032544E-08>
   }
 
   uv_vectors { 
      40, 
      <-1.26E-01, 1.847E-01>,
      <-2.459E-01, 1.847E-01>,
      <-1.26E-01, 1.31E-01>,
      <-2.459E-01, 1.31E-01>,
      <-1.9794E-01, 1.31E-01>,
      <-1.9794E-01, 1.847E-01>,
      <-1.7396E-01, 1.847E-01>,
      <-1.7396E-01, 1.31E-01>,
      <-1.26E-01, 1.390551E-01>,
      <-1.26E-01, 1.76645E-01>,
      <-2.459E-01, 1.390551E-01>,
      <-2.459E-01, 1.76645E-01>,
      <-6.919007E-01, 9.938E-01>,
      <-5.901992E-01, 9.938E-01>,
      <-6.919007E-01, 6.523212E-01>,
      <-5.901992E-01, 6.523212E-01>,
      <-6.062199E-01, 6.092E-01>,
      <-6.062199E-01, 9.938E-01>,
      <-6.7588E-01, 9.938E-01>,
      <-6.7588E-01, 6.092E-01>,
      <-8.152E-01, 6.6689E-01>,
      <-8.152E-01, 9.3611E-01>,
      <-4.668999E-01, 6.6689E-01>,
      <-4.668999E-01, 9.3611E-01>,
      <-5.901992E-01, 7.206622E-01>,
      <-6.919007E-01, 7.206622E-01>,
      <-6.919007E-01, 8.823378E-01>,
      <-5.901992E-01, 8.823378E-01>,
      <-6.7588E-01, 7.206622E-01>,
      <-6.062199E-01, 7.206622E-01>,
      <-4.669E-01, 6.203462E-01>,
      <-4.669E-01, 7.09516E-01>,
      <-8.151999E-01, 7.095159E-01>,
      <-8.151999E-01, 6.203461E-01>,
      <-6.7588E-01, 8.823378E-01>,
      <-6.062199E-01, 8.823378E-01>,
      <-4.669E-01, 8.934841E-01>,
      <-4.669001E-01, 9.826539E-01>,
      <-8.152E-01, 9.826537E-01>,
      <-8.151999E-01, 8.934839E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      64, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <4, 0, 3>, 0,
      <4, 3, 5>, 0,
      <6, 2, 1>, 0,
      <6, 1, 7>, 0,
      <8, 9, 10>, 0,
      <8, 10, 11>, 0,
      <12, 13, 14>, 0,
      <12, 14, 15>, 0,
      <9, 14, 13>, 0,
      <9, 13, 10>, 0,
      <11, 12, 15>, 0,
      <11, 15, 8>, 0,
      <16, 17, 18>, 0,
      <16, 18, 19>, 0,
      <16, 11, 10>, 0,
      <16, 10, 17>, 0,
      <17, 10, 13>, 0,
      <17, 13, 18>, 0,
      <18, 13, 12>, 0,
      <18, 12, 19>, 0,
      <19, 12, 11>, 0,
      <19, 11, 16>, 0,
      <20, 21, 22>, 0,
      <20, 22, 23>, 0,
      <20, 15, 14>, 0,
      <20, 14, 21>, 0,
      <21, 14, 9>, 0,
      <21, 9, 22>, 0,
      <22, 9, 8>, 0,
      <22, 8, 23>, 0,
      <23, 8, 15>, 0,
      <23, 15, 20>, 0,
      <24, 25, 26>, 0,
      <24, 26, 27>, 0,
      <28, 29, 30>, 0,
      <28, 30, 31>, 0,
      <25, 30, 29>, 0,
      <25, 29, 26>, 0,
      <27, 28, 31>, 0,
      <27, 31, 24>, 0,
      <32, 33, 34>, 0,
      <32, 34, 35>, 0,
      <32, 27, 26>, 0,
      <32, 26, 33>, 0,
      <33, 26, 29>, 0,
      <33, 29, 34>, 0,
      <34, 29, 28>, 0,
      <34, 28, 35>, 0,
      <35, 28, 27>, 0,
      <35, 27, 32>, 0,
      <36, 37, 38>, 0,
      <36, 38, 39>, 0,
      <36, 31, 30>, 0,
      <36, 30, 37>, 0,
      <37, 30, 25>, 0,
      <37, 25, 38>, 0,
      <38, 25, 24>, 0,
      <38, 24, 39>, 0,
      <39, 24, 31>, 0,
      <39, 31, 36>, 0
   }
 
   normal_indices { 
      64, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 5>,
      <4, 5, 5>,
      <6, 6, 7>,
      <6, 7, 7>,
      <8, 8, 9>,
      <8, 9, 9>,
      <10, 10, 11>,
      <10, 11, 11>,
      <2, 2, 2>,
      <2, 2, 2>,
      <12, 5, 5>,
      <12, 5, 12>,
      <13, 9, 9>,
      <13, 9, 13>,
      <14, 6, 6>,
      <14, 6, 14>,
      <15, 10, 10>,
      <15, 10, 15>,
      <3, 3, 3>,
      <3, 3, 3>,
      <16, 7, 7>,
      <16, 7, 16>,
      <17, 8, 8>,
      <17, 8, 17>,
      <18, 4, 4>,
      <18, 4, 18>,
      <19, 11, 11>,
      <19, 11, 19>,
      <4, 4, 5>,
      <4, 5, 5>,
      <6, 6, 7>,
      <6, 7, 7>,
      <8, 8, 9>,
      <8, 9, 9>,
      <10, 10, 11>,
      <10, 11, 11>,
      <2, 2, 2>,
      <2, 2, 2>,
      <12, 5, 5>,
      <12, 5, 12>,
      <13, 9, 9>,
      <13, 9, 13>,
      <14, 6, 6>,
      <14, 6, 14>,
      <15, 10, 10>,
      <15, 10, 15>,
      <3, 3, 3>,
      <3, 3, 3>,
      <16, 7, 7>,
      <16, 7, 16>,
      <17, 8, 8>,
      <17, 8, 17>,
      <18, 4, 4>,
      <18, 4, 18>,
      <19, 11, 11>,
      <19, 11, 19>
   }
 
   uv_indices { 
      64, 
      <24, 25, 26>,
      <24, 26, 27>,
      <14, 14, 15>,
      <14, 15, 15>,
      <14, 12, 12>,
      <14, 12, 14>,
      <15, 13, 13>,
      <15, 13, 15>,
      <16, 17, 18>,
      <16, 18, 19>,
      <19, 18, 17>,
      <19, 17, 16>,
      <19, 28, 29>,
      <19, 29, 16>,
      <19, 19, 16>,
      <19, 16, 16>,
      <20, 21, 21>,
      <20, 21, 20>,
      <20, 19, 18>,
      <20, 18, 21>,
      <30, 16, 29>,
      <30, 29, 31>,
      <21, 18, 19>,
      <21, 19, 20>,
      <20, 19, 19>,
      <20, 19, 20>,
      <22, 23, 23>,
      <22, 23, 22>,
      <22, 16, 17>,
      <22, 17, 23>,
      <32, 28, 19>,
      <32, 19, 33>,
      <23, 17, 16>,
      <23, 16, 22>,
      <22, 16, 16>,
      <22, 16, 22>,
      <16, 17, 18>,
      <16, 18, 19>,
      <19, 18, 17>,
      <19, 17, 16>,
      <34, 18, 17>,
      <34, 17, 35>,
      <19, 19, 16>,
      <19, 16, 16>,
      <20, 21, 21>,
      <20, 21, 20>,
      <20, 19, 18>,
      <20, 18, 21>,
      <36, 35, 17>,
      <36, 17, 37>,
      <21, 18, 19>,
      <21, 19, 20>,
      <20, 19, 19>,
      <20, 19, 20>,
      <22, 23, 23>,
      <22, 23, 22>,
      <22, 16, 17>,
      <22, 17, 23>,
      <38, 18, 34>,
      <38, 34, 39>,
      <23, 17, 16>,
      <23, 16, 22>,
      <22, 16, 16>,
      <22, 16, 22>
   }
   uv_mapping
}
 
// AxleCap4
mesh2 {
 
   vertex_vectors { 
      16, 
      <-2.111739E+00, 2.242231E+00, 1.230748E-01>,
      <-2.552754E+00, 2.242231E+00, 1.230747E-01>,
      <-2.552754E+00, 2.242231E+00, -9.344271E-01>,
      <-2.111738E+00, 2.242231E+00, -9.34427E-01>,
      <-2.111739E+00, 2.946012E+00, 1.230748E-01>,
      <-2.344622E+00, 2.939211E+00, 1.230748E-01>,
      <-2.111738E+00, 3.393731E+00, -2.176763E-01>,
      <-2.191807E+00, 3.393731E+00, -2.176764E-01>,
      <-2.344622E+00, 2.939211E+00, -9.34427E-01>,
      <-2.111738E+00, 2.946012E+00, -9.34427E-01>,
      <-2.111738E+00, 3.393731E+00, -5.936763E-01>,
      <-2.191805E+00, 3.393731E+00, -5.936763E-01>,
      <-2.552754E+00, 2.637721E+00, 1.230747E-01>,
      <-2.552754E+00, 2.637721E+00, -9.349359E-01>,
      <-2.111739E+00, 2.641122E+00, 1.230748E-01>,
      <-2.111738E+00, 2.641122E+00, -9.34427E-01>
   }
 
   normal_vectors { 
      11, 
      <1.104931E-16, -1.00E+00, 2.459337E-16>,
      <-5.894902E-03, 3.186717E-01, 9.478468E-01>,
      <-6.238606E-03, 8.955734E-01, 4.4487E-01>,
      <-6.237908E-03, 8.955734E-01, -4.4487E-01>,
      <-5.55838E-03, 3.189478E-01, -9.47756E-01>,
      <-9.425033E-01, 3.341968E-01, -3.071066E-07>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-8.633783E-01, 5.045571E-01, -9.944127E-07>,
      <-9.300555E-01, 3.67419E-01, -1.712646E-06>
   }
 
   uv_vectors { 
      32, 
      <-3.32E-01, 7.800042E-03>,
      <-3.662E-01, 7.800042E-03>,
      <-3.662E-01, 2.636737E-02>,
      <-3.662E-01, 2.61603E-02>,
      <-3.5518E-01, 4.000002E-02>,
      <-3.32E-01, 2.61603E-02>,
      <-3.32E-01, 2.636737E-02>,
      <-3.4302E-01, 4.000002E-02>,
      <-3.662E-01, 1.698017E-02>,
      <-2.196466E-01, 8.262624E-03>,
      <-1.905533E-01, 8.262624E-03>,
      <-2.196465E-01, 1.66088E-02>,
      <-2.196465E-01, 2.495497E-02>,
      <-2.106276E-01, 3.753743E-02>,
      <-1.995721E-01, 3.753743E-02>,
      <-1.905532E-01, 2.495497E-02>,
      <-3.32E-01, 1.698017E-02>,
      <-1.905532E-01, 1.66088E-02>,
      <-3.662E-01, 1.70837E-02>,
      <-3.32E-01, 1.70837E-02>,
      <-8.377002E-01, 5.168E-01>,
      <-9.824305E-01, 5.168E-01>,
      <-8.377002E-01, 5.954258E-01>,
      <-8.377002E-01, 5.961931E-01>,
      <-8.843356E-01, 6.467E-01>,
      <-9.357951E-01, 6.467E-01>,
      <-9.824305E-01, 5.961931E-01>,
      <-9.824305E-01, 5.954258E-01>,
      <-9.825002E-01, 5.61415E-01>,
      <-8.377002E-01, 5.61415E-01>,
      <-8.377002E-01, 5.617986E-01>,
      <-9.824305E-01, 5.617986E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      22, 
      <1, 2, 3>, 0,
      <1, 3, 0>, 0,
      <7, 5, 4>, 0,
      <7, 4, 6>, 0,
      <6, 10, 11>, 0,
      <6, 11, 7>, 0,
      <11, 10, 9>, 0,
      <11, 9, 8>, 0,
      <13, 2, 1>, 0,
      <13, 1, 12>, 0,
      <14, 4, 5>, 0,
      <14, 5, 12>, 0,
      <12, 1, 0>, 0,
      <12, 0, 14>, 0,
      <8, 9, 15>, 0,
      <8, 15, 13>, 0,
      <13, 15, 3>, 0,
      <13, 3, 2>, 0,
      <5, 7, 11>, 0,
      <5, 11, 8>, 0,
      <8, 13, 12>, 0,
      <8, 12, 5>, 0
   }
 
   normal_indices { 
      22, 
      <0, 0, 0>,
      <0, 0, 0>,
      <2, 1, 1>,
      <2, 1, 2>,
      <2, 3, 3>,
      <2, 3, 2>,
      <3, 3, 4>,
      <3, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <4, 4, 8>,
      <4, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 10, 10>,
      <9, 10, 9>,
      <9, 5, 5>,
      <9, 5, 9>
   }
 
   uv_indices { 
      22, 
      <20, 21, 21>,
      <20, 21, 20>,
      <24, 22, 23>,
      <24, 23, 24>,
      <24, 25, 25>,
      <24, 25, 24>,
      <25, 25, 26>,
      <25, 26, 27>,
      <28, 21, 20>,
      <28, 20, 29>,
      <30, 23, 22>,
      <30, 22, 29>,
      <29, 20, 20>,
      <29, 20, 30>,
      <27, 26, 31>,
      <27, 31, 28>,
      <28, 31, 21>,
      <28, 21, 21>,
      <22, 24, 25>,
      <22, 25, 27>,
      <27, 28, 29>,
      <27, 29, 22>
   }
   uv_mapping
}
 
// AxleCap5
mesh2 {
 
   vertex_vectors { 
      16, 
      <-2.11174E+00, 2.242231E+00, 5.058347E+00>,
      <-2.552756E+00, 2.242231E+00, 5.058346E+00>,
      <-2.552755E+00, 2.242231E+00, 4.000844E+00>,
      <-2.11174E+00, 2.242231E+00, 4.000845E+00>,
      <-2.11174E+00, 2.946012E+00, 5.058347E+00>,
      <-2.344624E+00, 2.939211E+00, 5.058346E+00>,
      <-2.11174E+00, 3.393731E+00, 4.717596E+00>,
      <-2.191809E+00, 3.393731E+00, 4.717596E+00>,
      <-2.344623E+00, 2.939211E+00, 4.000844E+00>,
      <-2.11174E+00, 2.946012E+00, 4.000845E+00>,
      <-2.11174E+00, 3.393731E+00, 4.341596E+00>,
      <-2.191807E+00, 3.393731E+00, 4.341596E+00>,
      <-2.552756E+00, 2.637721E+00, 5.058346E+00>,
      <-2.552755E+00, 2.637721E+00, 4.000336E+00>,
      <-2.11174E+00, 2.641122E+00, 5.058347E+00>,
      <-2.11174E+00, 2.641122E+00, 4.000845E+00>
   }
 
   normal_vectors { 
      11, 
      <1.104931E-16, -1.00E+00, 2.459337E-16>,
      <-5.894302E-03, 3.186715E-01, 9.478469E-01>,
      <-6.238163E-03, 8.955734E-01, 4.448699E-01>,
      <-6.23791E-03, 8.955733E-01, -4.448701E-01>,
      <-5.558221E-03, 3.189482E-01, -9.477559E-01>,
      <-9.425033E-01, 3.341968E-01, -3.071066E-07>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-8.633783E-01, 5.045571E-01, -9.944127E-07>,
      <-9.300554E-01, 3.674193E-01, -1.712646E-06>
   }
 
   uv_vectors { 
      32, 
      <-3.32E-01, 7.800042E-03>,
      <-3.662E-01, 7.800042E-03>,
      <-3.662E-01, 2.636737E-02>,
      <-3.662E-01, 2.61603E-02>,
      <-3.5518E-01, 4.000002E-02>,
      <-3.32E-01, 2.61603E-02>,
      <-3.32E-01, 2.636737E-02>,
      <-3.4302E-01, 4.000002E-02>,
      <-3.662E-01, 1.698017E-02>,
      <-2.196466E-01, 8.262624E-03>,
      <-1.905533E-01, 8.262624E-03>,
      <-2.196465E-01, 1.66088E-02>,
      <-2.196465E-01, 2.495497E-02>,
      <-2.106276E-01, 3.753743E-02>,
      <-1.995721E-01, 3.753743E-02>,
      <-1.905532E-01, 2.495497E-02>,
      <-3.32E-01, 1.698017E-02>,
      <-1.905532E-01, 1.66088E-02>,
      <-3.662E-01, 1.70837E-02>,
      <-3.32E-01, 1.70837E-02>,
      <-8.377E-01, 5.168E-01>,
      <-9.824304E-01, 5.168E-01>,
      <-8.377E-01, 5.954258E-01>,
      <-8.377E-01, 5.961931E-01>,
      <-8.843354E-01, 6.467E-01>,
      <-9.357949E-01, 6.467E-01>,
      <-9.824304E-01, 5.961931E-01>,
      <-9.824304E-01, 5.954258E-01>,
      <-9.825E-01, 5.61415E-01>,
      <-8.377E-01, 5.61415E-01>,
      <-8.377E-01, 5.617986E-01>,
      <-9.824304E-01, 5.617986E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      22, 
      <1, 2, 3>, 0,
      <1, 3, 0>, 0,
      <7, 5, 4>, 0,
      <7, 4, 6>, 0,
      <6, 10, 11>, 0,
      <6, 11, 7>, 0,
      <11, 10, 9>, 0,
      <11, 9, 8>, 0,
      <13, 2, 1>, 0,
      <13, 1, 12>, 0,
      <14, 4, 5>, 0,
      <14, 5, 12>, 0,
      <12, 1, 0>, 0,
      <12, 0, 14>, 0,
      <8, 9, 15>, 0,
      <8, 15, 13>, 0,
      <13, 15, 3>, 0,
      <13, 3, 2>, 0,
      <5, 7, 11>, 0,
      <5, 11, 8>, 0,
      <8, 13, 12>, 0,
      <8, 12, 5>, 0
   }
 
   normal_indices { 
      22, 
      <0, 0, 0>,
      <0, 0, 0>,
      <2, 1, 1>,
      <2, 1, 2>,
      <2, 3, 3>,
      <2, 3, 2>,
      <3, 3, 4>,
      <3, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <4, 4, 8>,
      <4, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 10, 10>,
      <9, 10, 9>,
      <9, 5, 5>,
      <9, 5, 9>
   }
 
   uv_indices { 
      22, 
      <20, 21, 21>,
      <20, 21, 20>,
      <24, 22, 23>,
      <24, 23, 24>,
      <24, 25, 25>,
      <24, 25, 24>,
      <25, 25, 26>,
      <25, 26, 27>,
      <28, 21, 20>,
      <28, 20, 29>,
      <30, 23, 22>,
      <30, 22, 29>,
      <29, 20, 20>,
      <29, 20, 30>,
      <27, 26, 31>,
      <27, 31, 28>,
      <28, 31, 21>,
      <28, 21, 21>,
      <22, 24, 25>,
      <22, 25, 27>,
      <27, 28, 29>,
      <27, 29, 22>
   }
   uv_mapping
}
 
// AxleCap6
mesh2 {
 
   vertex_vectors { 
      16, 
      <-2.111742E+00, 2.242231E+00, 1.001412E+01>,
      <-2.552757E+00, 2.242231E+00, 1.001412E+01>,
      <-2.552757E+00, 2.242231E+00, 8.956614E+00>,
      <-2.111742E+00, 2.242231E+00, 8.956614E+00>,
      <-2.111742E+00, 2.946012E+00, 1.001412E+01>,
      <-2.344625E+00, 2.939211E+00, 1.001412E+01>,
      <-2.111742E+00, 3.393731E+00, 9.673366E+00>,
      <-2.19181E+00, 3.393731E+00, 9.673366E+00>,
      <-2.344625E+00, 2.939211E+00, 8.956614E+00>,
      <-2.111742E+00, 2.946012E+00, 8.956614E+00>,
      <-2.111742E+00, 3.393731E+00, 9.297366E+00>,
      <-2.191808E+00, 3.393731E+00, 9.297366E+00>,
      <-2.552757E+00, 2.637721E+00, 1.001412E+01>,
      <-2.552757E+00, 2.637721E+00, 8.956105E+00>,
      <-2.111742E+00, 2.641122E+00, 1.001412E+01>,
      <-2.111742E+00, 2.641122E+00, 8.956614E+00>
   }
 
   normal_vectors { 
      11, 
      <1.104931E-16, -1.00E+00, 2.459337E-16>,
      <-5.894302E-03, 3.186713E-01, 9.478469E-01>,
      <-6.238163E-03, 8.955734E-01, 4.4487E-01>,
      <-6.237913E-03, 8.955732E-01, -4.448704E-01>,
      <-5.558382E-03, 3.18948E-01, -9.477559E-01>,
      <-9.425033E-01, 3.341967E-01, -3.071066E-07>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-8.633783E-01, 5.04557E-01, -9.944127E-07>,
      <-9.300555E-01, 3.674191E-01, -1.712646E-06>
   }
 
   uv_vectors { 
      32, 
      <-3.32E-01, 7.800042E-03>,
      <-3.662E-01, 7.800042E-03>,
      <-3.662E-01, 2.636737E-02>,
      <-3.662E-01, 2.61603E-02>,
      <-3.5518E-01, 4.000002E-02>,
      <-3.32E-01, 2.61603E-02>,
      <-3.32E-01, 2.636737E-02>,
      <-3.4302E-01, 4.000002E-02>,
      <-3.662E-01, 1.698017E-02>,
      <-2.196466E-01, 8.262624E-03>,
      <-1.905533E-01, 8.262624E-03>,
      <-2.196465E-01, 1.66088E-02>,
      <-2.196465E-01, 2.495497E-02>,
      <-2.106276E-01, 3.753743E-02>,
      <-1.995721E-01, 3.753743E-02>,
      <-1.905532E-01, 2.495497E-02>,
      <-3.32E-01, 1.698017E-02>,
      <-1.905532E-01, 1.66088E-02>,
      <-3.662E-01, 1.70837E-02>,
      <-3.32E-01, 1.70837E-02>,
      <-8.377E-01, 5.168E-01>,
      <-9.824304E-01, 5.168E-01>,
      <-8.377E-01, 5.954258E-01>,
      <-8.377E-01, 5.961931E-01>,
      <-8.843354E-01, 6.467E-01>,
      <-9.357949E-01, 6.467E-01>,
      <-9.824304E-01, 5.961931E-01>,
      <-9.824304E-01, 5.954258E-01>,
      <-9.825E-01, 5.61415E-01>,
      <-8.377E-01, 5.61415E-01>,
      <-8.377E-01, 5.617986E-01>,
      <-9.824304E-01, 5.617986E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      22, 
      <1, 2, 3>, 0,
      <1, 3, 0>, 0,
      <7, 5, 4>, 0,
      <7, 4, 6>, 0,
      <6, 10, 11>, 0,
      <6, 11, 7>, 0,
      <11, 10, 9>, 0,
      <11, 9, 8>, 0,
      <13, 2, 1>, 0,
      <13, 1, 12>, 0,
      <14, 4, 5>, 0,
      <14, 5, 12>, 0,
      <12, 1, 0>, 0,
      <12, 0, 14>, 0,
      <8, 9, 15>, 0,
      <8, 15, 13>, 0,
      <13, 15, 3>, 0,
      <13, 3, 2>, 0,
      <5, 7, 11>, 0,
      <5, 11, 8>, 0,
      <8, 13, 12>, 0,
      <8, 12, 5>, 0
   }
 
   normal_indices { 
      22, 
      <0, 0, 0>,
      <0, 0, 0>,
      <2, 1, 1>,
      <2, 1, 2>,
      <2, 3, 3>,
      <2, 3, 2>,
      <3, 3, 4>,
      <3, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <4, 4, 8>,
      <4, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 10, 10>,
      <9, 10, 9>,
      <9, 5, 5>,
      <9, 5, 9>
   }
 
   uv_indices { 
      22, 
      <20, 21, 21>,
      <20, 21, 20>,
      <24, 22, 23>,
      <24, 23, 24>,
      <24, 25, 25>,
      <24, 25, 24>,
      <25, 25, 26>,
      <25, 26, 27>,
      <28, 21, 20>,
      <28, 20, 29>,
      <30, 23, 22>,
      <30, 22, 29>,
      <29, 20, 20>,
      <29, 20, 30>,
      <27, 26, 31>,
      <27, 31, 28>,
      <28, 31, 21>,
      <28, 21, 21>,
      <22, 24, 25>,
      <22, 25, 27>,
      <27, 28, 29>,
      <27, 29, 22>
   }
   uv_mapping
}
 
// TruckFrameP
mesh2 {
 
   vertex_vectors { 
      76, 
      <4.75374E+00, 4.559963E+00, 4.527686E+00>,
      <4.187965E+00, 4.560885E+00, 4.527686E+00>,
      <4.743511E+00, 2.06753E+00, 4.53267E+00>,
      <4.177742E+00, 2.068451E+00, 4.53267E+00>,
      <4.743498E+00, 2.063881E+00, 3.669619E+00>,
      <4.177727E+00, 2.064803E+00, 3.669619E+00>,
      <4.745659E+00, 2.590235E+00, 3.666611E+00>,
      <4.179884E+00, 2.591156E+00, 3.666611E+00>,
      <4.747532E+00, 3.046329E+00, 3.252185E+00>,
      <4.181752E+00, 3.047252E+00, 3.252185E+00>,
      <4.748677E+00, 3.325817E+00, 2.735904E+00>,
      <4.182906E+00, 3.326739E+00, 2.735904E+00>,
      <4.74866E+00, 3.321397E+00, 1.554951E+00>,
      <4.182885E+00, 3.322318E+00, 1.554951E+00>,
      <4.747506E+00, 3.040791E+00, 8.968956E-01>,
      <4.181733E+00, 3.041713E+00, 8.968954E-01>,
      <4.745616E+00, 2.579175E+00, 5.480053E-01>,
      <4.179838E+00, 2.580096E+00, 5.480051E-01>,
      <4.743402E+00, 2.040132E+00, 4.792649E-01>,
      <4.177631E+00, 2.041054E+00, 4.792647E-01>,
      <4.743383E+00, 2.035189E+00, -1.1967E+00>,
      <4.17761E+00, 2.03611E+00, -1.196701E+00>,
      <4.744394E+00, 2.281816E+00, -1.197212E+00>,
      <4.178617E+00, 2.282736E+00, -1.197212E+00>,
      <4.745993E+00, 2.671327E+00, -1.30553E+00>,
      <4.180218E+00, 2.672248E+00, -1.30553E+00>,
      <4.747126E+00, 2.947657E+00, -1.552987E+00>,
      <4.181356E+00, 2.948579E+00, -1.552983E+00>,
      <4.748232E+00, 3.217361E+00, -1.940744E+00>,
      <4.182459E+00, 3.218283E+00, -1.940744E+00>,
      <4.748227E+00, 3.21507E+00, -2.527455E+00>,
      <4.182452E+00, 3.215992E+00, -2.527455E+00>,
      <4.750803E+00, 3.843968E+00, -2.529593E+00>,
      <4.18503E+00, 3.844889E+00, -2.529593E+00>,
      <4.751807E+00, 4.087497E+00, -2.332422E+00>,
      <4.186032E+00, 4.088418E+00, -2.332422E+00>,
      <4.753412E+00, 4.480069E+00, -1.367193E+00>,
      <4.187645E+00, 4.48099E+00, -1.367193E+00>,
      <4.753673E+00, 4.542963E+00, -3.833297E-01>,
      <4.187898E+00, 4.543885E+00, -3.833299E-01>,
      <4.743497E+00, 2.063881E+00, 5.395722E+00>,
      <4.177726E+00, 2.064803E+00, 5.395722E+00>,
      <4.745658E+00, 2.590235E+00, 5.39873E+00>,
      <4.179883E+00, 2.591156E+00, 5.39873E+00>,
      <4.747531E+00, 3.046329E+00, 5.813156E+00>,
      <4.181751E+00, 3.047252E+00, 5.813156E+00>,
      <4.748676E+00, 3.325817E+00, 6.329437E+00>,
      <4.182905E+00, 3.326739E+00, 6.329437E+00>,
      <4.748658E+00, 3.321397E+00, 7.510392E+00>,
      <4.182883E+00, 3.322318E+00, 7.510392E+00>,
      <4.747504E+00, 3.040791E+00, 8.168445E+00>,
      <4.181731E+00, 3.041713E+00, 8.168445E+00>,
      <4.745614E+00, 2.579175E+00, 8.517336E+00>,
      <4.179835E+00, 2.580096E+00, 8.517336E+00>,
      <4.743399E+00, 2.040132E+00, 8.586076E+00>,
      <4.177628E+00, 2.041054E+00, 8.586076E+00>,
      <4.74338E+00, 2.035189E+00, 1.026204E+01>,
      <4.177607E+00, 2.03611E+00, 1.026204E+01>,
      <4.74439E+00, 2.281816E+00, 1.026255E+01>,
      <4.178614E+00, 2.282736E+00, 1.026255E+01>,
      <4.745989E+00, 2.671327E+00, 1.037087E+01>,
      <4.180214E+00, 2.672248E+00, 1.037087E+01>,
      <4.747122E+00, 2.947657E+00, 1.061833E+01>,
      <4.181353E+00, 2.948579E+00, 1.061832E+01>,
      <4.748228E+00, 3.217361E+00, 1.100609E+01>,
      <4.182455E+00, 3.218283E+00, 1.100609E+01>,
      <4.748222E+00, 3.21507E+00, 1.15928E+01>,
      <4.182447E+00, 3.215992E+00, 1.15928E+01>,
      <4.750799E+00, 3.843968E+00, 1.159493E+01>,
      <4.185026E+00, 3.844889E+00, 1.159493E+01>,
      <4.751802E+00, 4.087497E+00, 1.139776E+01>,
      <4.186027E+00, 4.088418E+00, 1.139776E+01>,
      <4.753408E+00, 4.480069E+00, 1.043254E+01>,
      <4.187641E+00, 4.48099E+00, 1.043254E+01>,
      <4.75367E+00, 4.542963E+00, 9.44867E+00>,
      <4.187895E+00, 4.543885E+00, 9.44867E+00>
   }
 
   normal_vectors { 
      36, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <1.104931E-16, -1.00E+00, 2.459337E-16>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-5.032992E-04, -3.631432E-01, -9.317332E-01>,
      <-1.091363E-03, -7.870984E-01, -6.168266E-01>,
      <-1.344556E-03, -9.698404E-01, -2.437374E-01>,
      <-1.357511E-03, -9.793831E-01, 2.020076E-01>,
      <-1.092247E-03, -7.879434E-01, 6.157468E-01>,
      <-5.234125E-04, -3.774298E-01, 9.260381E-01>,
      <-1.75726E-04, -1.264974E-01, 9.91967E-01>,
      <-1.882797E-04, -1.362276E-01, -9.906776E-01>,
      <-6.6646E-04, -4.801079E-01, -8.772092E-01>,
      <-1.040839E-03, -7.49093E-01, -6.624641E-01>,
      <-1.324484E-03, -9.547682E-01, -2.973481E-01>,
      <4.605402E-04, 3.321614E-01, -9.432225E-01>,
      <1.113014E-03, 8.031417E-01, -5.957869E-01>,
      <1.351239E-03, 9.747794E-01, -2.231661E-01>,
      <1.386171E-03, 9.994329E-01, -3.36444E-02>,
      <-1.104931E-16, 9.999999E-01, -2.459337E-16>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <-5.039287E-04, -3.631431E-01, 9.317332E-01>,
      <-1.091815E-03, -7.870984E-01, 6.168266E-01>,
      <-1.344767E-03, -9.698404E-01, 2.437373E-01>,
      <-1.357423E-03, -9.793829E-01, -2.020083E-01>,
      <-1.091836E-03, -7.87943E-01, -6.157473E-01>,
      <-5.228091E-04, -3.774298E-01, -9.260381E-01>,
      <-1.750795E-04, -1.264974E-01, -9.919669E-01>,
      <-1.888265E-04, -1.362254E-01, 9.906779E-01>,
      <-6.670167E-04, -4.801102E-01, 8.772079E-01>,
      <-1.040969E-03, -7.49094E-01, 6.624629E-01>,
      <-1.324596E-03, -9.547687E-01, 2.973469E-01>,
      <4.599238E-04, 3.321643E-01, 9.432214E-01>,
      <1.112625E-03, 8.03143E-01, 5.957852E-01>,
      <1.351099E-03, 9.747792E-01, 2.231669E-01>,
      <1.386155E-03, 9.99433E-01, 3.364083E-02>
   }
 
   uv_vectors { 
      414, 
      <-2.046E-01, 9.50455E-04>,
      <-2.044556E-01, 7.419997E-02>,
      <-6.747044E-01, 1.152495E-01>,
      <-4.011471E-01, 1.145969E-01>,
      <-3.606242E-01, 6.020861E-02>,
      <-1.579244E-01, 2.517338E-02>,
      <-1.453434E-01, 7.10662E-02>,
      <-3.173649E-03, 2.092282E-01>,
      <-2.607399E-02, 2.379216E-01>,
      <-1.381813E-01, 2.841752E-01>,
      <-2.524532E-01, 2.915855E-01>,
      <-7.20838E-01, 6.151171E-02>,
      <-6.197401E-01, 1.511789E-01>,
      <-4.645773E-01, 1.506583E-01>,
      <-1.246028E-01, 1.036236E-01>,
      <-7.156575E-02, 1.404006E-01>,
      <-3.421843E-03, 1.401306E-01>,
      <-5.641788E-01, 5.883074E-01>,
      <-6.759159E-01, 5.810612E-01>,
      <-6.970152E-01, 4.04516E-01>,
      <-6.689128E-01, 3.726806E-01>,
      <-6.566107E-01, 3.278061E-01>,
      <-6.565531E-01, 2.993928E-01>,
      <-4.662144E-01, 2.999625E-01>,
      <-4.584077E-01, 3.620643E-01>,
      <-4.18784E-01, 4.152457E-01>,
      <-3.440497E-01, 4.475738E-01>,
      <-2.09929E-01, 4.480829E-01>,
      <-1.512954E-01, 4.158841E-01>,
      <-1.042293E-01, 3.633384E-01>,
      <-5.871534E-03, 3.031187E-01>,
      <-5.305231E-03, 5.902659E-01>,
      <-8.165E-01, 9.252285E-01>,
      <-8.125838E-01, 9.57226E-01>,
      <-4.76269E-01, 9.570976E-01>,
      <-4.801807E-01, 9.251E-01>,
      <-8.094193E-01, 9.875E-01>,
      <-4.731E-01, 9.873715E-01>,
      <-8.056706E-01, 9.251E-01>,
      <-8.165004E-01, 9.865987E-01>,
      <-4.839258E-01, 9.875E-01>,
      <-4.731004E-01, 9.260013E-01>,
      <-8.138481E-01, 9.251E-01>,
      <-8.165005E-01, 9.87354E-01>,
      <-4.757576E-01, 9.875E-01>,
      <-4.731005E-01, 9.252461E-01>,
      <-8.143413E-01, 9.251E-01>,
      <-8.158955E-01, 9.667082E-01>,
      <-4.746559E-01, 9.667693E-01>,
      <-4.752599E-01, 9.875E-01>,
      <-8.149452E-01, 9.667693E-01>,
      <-4.737057E-01, 9.667083E-01>,
      <-4.752599E-01, 9.251E-01>,
      <-8.143413E-01, 9.875E-01>,
      <-4.79441E-01, 9.71815E-01>,
      <-8.15111E-01, 9.717873E-01>,
      <-4.779892E-01, 9.608642E-01>,
      <-8.13658E-01, 9.608366E-01>,
      <-4.764569E-01, 9.525719E-01>,
      <-8.121303E-01, 9.525443E-01>,
      <-4.750684E-01, 9.473768E-01>,
      <-8.107361E-01, 9.473491E-01>,
      <-6.093669E-01, 9.875E-01>,
      <-4.731E-01, 9.358639E-01>,
      <-6.802346E-01, 9.251E-01>,
      <-8.165E-01, 9.767362E-01>,
      <-6.511039E-01, 9.925E-01>,
      <-4.656E-01, 9.366999E-01>,
      <-6.221966E-01, 9.263E-01>,
      <-8.077E-01, 9.821002E-01>,
      <-6.366501E-01, 9.924985E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.656E-01, 9.26301E-01>,
      <-6.366501E-01, 9.263001E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.077E-01, 9.925001E-01>,
      <-4.656E-01, 9.820999E-01>,
      <-6.511061E-01, 9.263E-01>,
      <-8.076999E-01, 9.367001E-01>,
      <-6.221933E-01, 9.925E-01>,
      <-8.047949E-01, 9.263E-01>,
      <-4.685062E-01, 9.925E-01>,
      <-8.053998E-01, 9.334068E-01>,
      <-4.662043E-01, 9.334333E-01>,
      <-8.063581E-01, 9.472352E-01>,
      <-4.671637E-01, 9.472617E-01>,
      <-8.070373E-01, 9.611779E-01>,
      <-4.678464E-01, 9.612043E-01>,
      <-8.077005E-01, 9.783284E-01>,
      <-4.685073E-01, 9.783549E-01>,
      <-8.045977E-01, 9.263E-01>,
      <-8.058926E-01, 9.445296E-01>,
      <-4.668931E-01, 9.445614E-01>,
      <-8.070148E-01, 9.703102E-01>,
      <-4.680119E-01, 9.70342E-01>,
      <-4.687034E-01, 9.925E-01>,
      <-4.656E-01, 9.810792E-01>,
      <-6.013628E-01, 9.263E-01>,
      <-8.077E-01, 9.377209E-01>,
      <-6.719353E-01, 9.925E-01>,
      <-8.070968E-01, 9.366705E-01>,
      <-4.679013E-01, 9.36632E-01>,
      <-4.685073E-01, 9.263E-01>,
      <-8.061374E-01, 9.554002E-01>,
      <-4.669431E-01, 9.553617E-01>,
      <-8.054547E-01, 9.72515E-01>,
      <-4.662638E-01, 9.724765E-01>,
      <-8.047938E-01, 9.925E-01>,
      <-5.472026E-01, 9.925E-01>,
      <-4.656E-01, 9.45287E-01>,
      <-7.260988E-01, 9.263E-01>,
      <-8.076999E-01, 9.73513E-01>,
      <-8.064069E-01, 9.445614E-01>,
      <-4.674074E-01, 9.445295E-01>,
      <-4.687022E-01, 9.263E-01>,
      <-8.05288E-01, 9.70342E-01>,
      <-4.662851E-01, 9.703102E-01>,
      <-8.045966E-01, 9.925E-01>,
      <-4.662919E-01, 9.678896E-01>,
      <-8.052427E-01, 9.679187E-01>,
      <-4.674243E-01, 9.449727E-01>,
      <-8.063785E-01, 9.450018E-01>,
      <-7.89536E-01, 5.358341E-01>,
      <-8.119286E-01, 5.077778E-01>,
      <-8.116856E-01, 4.483239E-01>,
      <-7.410533E-01, 4.395881E-01>,
      <-9.688789E-02, 3.026984E-01>,
      <-8.208482E-01, 2.935884E-01>,
      <-8.21427E-01, 1.00E-03>,
      <-7.211874E-01, 1.00E-03>,
      <-3.526406E-01, 1.00E-03>,
      <-1.579831E-01, 1.00E-03>,
      <-8.152E-01, 9.215873E-01>,
      <-6.40607E-01, 9.202015E-01>,
      <-6.405473E-01, 9.949143E-01>,
      <-8.151404E-01, 9.963001E-01>,
      <-4.656E-01, 9.935129E-01>,
      <-4.656596E-01, 9.188001E-01>,
      <-1.874804E-03, 3.024706E-01>,
      <-9.998667E-02, 3.625397E-01>,
      <-1.469352E-01, 4.14954E-01>,
      <-2.054224E-01, 4.470723E-01>,
      <-3.392073E-01, 4.465645E-01>,
      <-4.137549E-01, 4.143173E-01>,
      <-4.532796E-01, 3.612688E-01>,
      <-4.610668E-01, 2.993222E-01>,
      <-9.464604E-02, 3.021559E-01>,
      <-6.559296E-01, 2.98754E-01>,
      <-6.559871E-01, 3.270963E-01>,
      <-6.682582E-01, 3.718586E-01>,
      <-6.962906E-01, 4.036143E-01>,
      <-7.462181E-01, 4.416088E-01>,
      <-8.106839E-01, 4.483452E-01>,
      <-8.10926E-01, 5.06618E-01>,
      <-7.885892E-01, 5.346041E-01>,
      <-2.530497E-01, 2.93377E-01>,
      <-1.399122E-01, 2.860404E-01>,
      <-2.891767E-02, 2.40246E-01>,
      <-6.244719E-03, 2.118375E-01>,
      <-6.489635E-03, 1.384754E-01>,
      <-7.395738E-02, 1.387428E-01>,
      <-1.185479E-01, 1.072811E-01>,
      <-1.470027E-01, 7.504681E-02>,
      <-1.594592E-01, 2.960964E-02>,
      <-1.595172E-01, 8.400737E-04>,
      <-3.522428E-01, 1.416883E-03>,
      <-3.601472E-01, 6.429716E-02>,
      <-4.002675E-01, 1.181454E-01>,
      <-4.75939E-01, 1.508787E-01>,
      <-6.117408E-01, 1.513942E-01>,
      <-6.7111E-01, 1.187916E-01>,
      <-7.187657E-01, 6.558718E-02>,
      <-7.191114E-01, 4.187306E-03>,
      <-8.183562E-01, 4.612735E-03>,
      <-8.177832E-01, 2.953604E-01>,
      <-1.31005E-03, 5.938998E-01>,
      <-6.702439E-01, 5.847182E-01>,
      <-5.587863E-01, 5.919462E-01>,
      <-6.366501E-01, 9.924985E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.656E-01, 9.26301E-01>,
      <-6.366501E-01, 9.263001E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.064069E-01, 9.445614E-01>,
      <-4.674074E-01, 9.445295E-01>,
      <-4.687022E-01, 9.263E-01>,
      <-8.064069E-01, 9.445614E-01>,
      <-8.05288E-01, 9.70342E-01>,
      <-4.662851E-01, 9.703102E-01>,
      <-4.674074E-01, 9.445295E-01>,
      <-8.05288E-01, 9.70342E-01>,
      <-8.045966E-01, 9.925E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.662851E-01, 9.703102E-01>,
      <-6.093669E-01, 9.875E-01>,
      <-4.731E-01, 9.358639E-01>,
      <-6.802346E-01, 9.251E-01>,
      <-8.165E-01, 9.767362E-01>,
      <-4.79441E-01, 9.71815E-01>,
      <-4.779892E-01, 9.608642E-01>,
      <-8.13658E-01, 9.608366E-01>,
      <-8.15111E-01, 9.717873E-01>,
      <-4.779892E-01, 9.608642E-01>,
      <-4.764569E-01, 9.525719E-01>,
      <-8.121303E-01, 9.525443E-01>,
      <-8.13658E-01, 9.608366E-01>,
      <-4.764569E-01, 9.525719E-01>,
      <-4.750684E-01, 9.473768E-01>,
      <-8.107361E-01, 9.473491E-01>,
      <-8.121303E-01, 9.525443E-01>,
      <-6.511039E-01, 9.925E-01>,
      <-4.656E-01, 9.366999E-01>,
      <-6.221966E-01, 9.263E-01>,
      <-8.077E-01, 9.821002E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.070968E-01, 9.366705E-01>,
      <-4.679013E-01, 9.36632E-01>,
      <-4.685073E-01, 9.263E-01>,
      <-8.070968E-01, 9.366705E-01>,
      <-8.061374E-01, 9.554002E-01>,
      <-4.669431E-01, 9.553617E-01>,
      <-4.679013E-01, 9.36632E-01>,
      <-8.061374E-01, 9.554002E-01>,
      <-8.054547E-01, 9.72515E-01>,
      <-4.662638E-01, 9.724765E-01>,
      <-4.669431E-01, 9.553617E-01>,
      <-8.054547E-01, 9.72515E-01>,
      <-8.047938E-01, 9.925E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.662638E-01, 9.724765E-01>,
      <-5.472026E-01, 9.925E-01>,
      <-4.656E-01, 9.45287E-01>,
      <-7.260988E-01, 9.263E-01>,
      <-8.076999E-01, 9.73513E-01>,
      <-8.165E-01, 9.252285E-01>,
      <-8.149452E-01, 9.667693E-01>,
      <-4.737057E-01, 9.667083E-01>,
      <-4.752599E-01, 9.251E-01>,
      <-8.149452E-01, 9.667693E-01>,
      <-8.143413E-01, 9.875E-01>,
      <-4.731E-01, 9.873715E-01>,
      <-4.737057E-01, 9.667083E-01>,
      <-8.165E-01, 9.252285E-01>,
      <-8.125838E-01, 9.57226E-01>,
      <-4.76269E-01, 9.570976E-01>,
      <-4.801807E-01, 9.251E-01>,
      <-8.125838E-01, 9.57226E-01>,
      <-8.094193E-01, 9.875E-01>,
      <-4.731E-01, 9.873715E-01>,
      <-4.76269E-01, 9.570976E-01>,
      <-8.152E-01, 9.215873E-01>,
      <-6.40607E-01, 9.202015E-01>,
      <-6.405473E-01, 9.949143E-01>,
      <-8.151404E-01, 9.963001E-01>,
      <-8.208482E-01, 2.935884E-01>,
      <-8.21427E-01, 1.00E-03>,
      <-7.211874E-01, 1.00E-03>,
      <-7.20838E-01, 6.151171E-02>,
      <-6.747044E-01, 1.152495E-01>,
      <-6.197401E-01, 1.511789E-01>,
      <-4.645773E-01, 1.506583E-01>,
      <-4.011471E-01, 1.145969E-01>,
      <-3.606242E-01, 6.020861E-02>,
      <-3.526406E-01, 1.00E-03>,
      <-1.579831E-01, 1.00E-03>,
      <-1.579244E-01, 2.517338E-02>,
      <-1.453434E-01, 7.10662E-02>,
      <-1.246028E-01, 1.036236E-01>,
      <-7.156575E-02, 1.404006E-01>,
      <-3.421843E-03, 1.401306E-01>,
      <-3.173649E-03, 2.092282E-01>,
      <-2.607399E-02, 2.379216E-01>,
      <-1.381813E-01, 2.841752E-01>,
      <-2.524532E-01, 2.915855E-01>,
      <-2.530497E-01, 2.93377E-01>,
      <-1.399122E-01, 2.860404E-01>,
      <-2.891767E-02, 2.40246E-01>,
      <-6.244719E-03, 2.118375E-01>,
      <-6.489635E-03, 1.384754E-01>,
      <-7.395738E-02, 1.387428E-01>,
      <-1.185479E-01, 1.072811E-01>,
      <-1.470027E-01, 7.504681E-02>,
      <-1.594592E-01, 2.960964E-02>,
      <-1.595172E-01, 8.400737E-04>,
      <-3.522428E-01, 1.416883E-03>,
      <-3.601472E-01, 6.429716E-02>,
      <-4.002675E-01, 1.181454E-01>,
      <-4.75939E-01, 1.508787E-01>,
      <-6.117408E-01, 1.513942E-01>,
      <-6.7111E-01, 1.187916E-01>,
      <-7.187657E-01, 6.558718E-02>,
      <-7.191114E-01, 4.187306E-03>,
      <-8.183562E-01, 4.612735E-03>,
      <-8.177832E-01, 2.953604E-01>,
      <-2.044556E-01, 7.419997E-02>,
      <-2.046E-01, 9.50455E-04>,
      <-2.046E-01, 9.50455E-04>,
      <-2.044556E-01, 7.419997E-02>,
      <-6.366501E-01, 9.263001E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.077E-01, 9.925001E-01>,
      <-6.366501E-01, 9.924985E-01>,
      <-8.045977E-01, 9.263E-01>,
      <-8.058926E-01, 9.445296E-01>,
      <-4.668931E-01, 9.445614E-01>,
      <-4.656E-01, 9.26301E-01>,
      <-8.058926E-01, 9.445296E-01>,
      <-8.070148E-01, 9.703102E-01>,
      <-4.680119E-01, 9.70342E-01>,
      <-4.668931E-01, 9.445614E-01>,
      <-8.070148E-01, 9.703102E-01>,
      <-8.077E-01, 9.925001E-01>,
      <-4.687034E-01, 9.925E-01>,
      <-4.680119E-01, 9.70342E-01>,
      <-4.656E-01, 9.810792E-01>,
      <-6.013628E-01, 9.263E-01>,
      <-8.077E-01, 9.377209E-01>,
      <-6.719353E-01, 9.925E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.662919E-01, 9.678896E-01>,
      <-8.052427E-01, 9.679187E-01>,
      <-8.045966E-01, 9.925E-01>,
      <-4.662919E-01, 9.678896E-01>,
      <-4.674243E-01, 9.449727E-01>,
      <-8.063785E-01, 9.450018E-01>,
      <-8.052427E-01, 9.679187E-01>,
      <-4.674243E-01, 9.449727E-01>,
      <-4.687022E-01, 9.263E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.063785E-01, 9.450018E-01>,
      <-4.656E-01, 9.820999E-01>,
      <-6.511061E-01, 9.263E-01>,
      <-8.076999E-01, 9.367001E-01>,
      <-6.221933E-01, 9.925E-01>,
      <-8.047949E-01, 9.263E-01>,
      <-8.053998E-01, 9.334068E-01>,
      <-4.662043E-01, 9.334333E-01>,
      <-4.656E-01, 9.26301E-01>,
      <-8.053998E-01, 9.334068E-01>,
      <-8.063581E-01, 9.472352E-01>,
      <-4.671637E-01, 9.472617E-01>,
      <-4.662043E-01, 9.334333E-01>,
      <-8.063581E-01, 9.472352E-01>,
      <-8.070373E-01, 9.611779E-01>,
      <-4.678464E-01, 9.612043E-01>,
      <-4.671637E-01, 9.472617E-01>,
      <-8.070373E-01, 9.611779E-01>,
      <-8.077005E-01, 9.783284E-01>,
      <-4.685073E-01, 9.783549E-01>,
      <-4.678464E-01, 9.612043E-01>,
      <-8.077005E-01, 9.783284E-01>,
      <-8.077E-01, 9.925001E-01>,
      <-4.685062E-01, 9.925E-01>,
      <-4.685073E-01, 9.783549E-01>,
      <-8.143413E-01, 9.251E-01>,
      <-8.158955E-01, 9.667082E-01>,
      <-4.746559E-01, 9.667693E-01>,
      <-4.731005E-01, 9.252461E-01>,
      <-8.158955E-01, 9.667082E-01>,
      <-8.165005E-01, 9.87354E-01>,
      <-4.752599E-01, 9.875E-01>,
      <-4.746559E-01, 9.667693E-01>,
      <-8.138481E-01, 9.251E-01>,
      <-8.165005E-01, 9.87354E-01>,
      <-4.757576E-01, 9.875E-01>,
      <-4.731005E-01, 9.252461E-01>,
      <-8.056706E-01, 9.251E-01>,
      <-8.165004E-01, 9.865987E-01>,
      <-4.839258E-01, 9.875E-01>,
      <-4.731004E-01, 9.260013E-01>,
      <-4.656E-01, 9.935129E-01>,
      <-6.405473E-01, 9.949143E-01>,
      <-6.40607E-01, 9.202015E-01>,
      <-4.656596E-01, 9.188001E-01>,
      <-5.641788E-01, 5.883074E-01>,
      <-6.759159E-01, 5.810612E-01>,
      <-7.89536E-01, 5.358341E-01>,
      <-8.119286E-01, 5.077778E-01>,
      <-8.116856E-01, 4.483239E-01>,
      <-7.410533E-01, 4.395881E-01>,
      <-6.970152E-01, 4.04516E-01>,
      <-6.689128E-01, 3.726806E-01>,
      <-6.566107E-01, 3.278061E-01>,
      <-6.565531E-01, 2.993928E-01>,
      <-4.662144E-01, 2.999625E-01>,
      <-4.584077E-01, 3.620643E-01>,
      <-4.18784E-01, 4.152457E-01>,
      <-3.440497E-01, 4.475738E-01>,
      <-2.09929E-01, 4.480829E-01>,
      <-1.512954E-01, 4.158841E-01>,
      <-1.042293E-01, 3.633384E-01>,
      <-9.688789E-02, 3.026984E-01>,
      <-5.871534E-03, 3.031187E-01>,
      <-5.305231E-03, 5.902659E-01>,
      <-1.31005E-03, 5.938998E-01>,
      <-1.874804E-03, 3.024706E-01>,
      <-9.464604E-02, 3.021559E-01>,
      <-9.998667E-02, 3.625397E-01>,
      <-1.469352E-01, 4.14954E-01>,
      <-2.054224E-01, 4.470723E-01>,
      <-3.392073E-01, 4.465645E-01>,
      <-4.137549E-01, 4.143173E-01>,
      <-4.532796E-01, 3.612688E-01>,
      <-4.610668E-01, 2.993222E-01>,
      <-6.559296E-01, 2.98754E-01>,
      <-6.559871E-01, 3.270963E-01>,
      <-6.682582E-01, 3.718586E-01>,
      <-6.962906E-01, 4.036143E-01>,
      <-7.462181E-01, 4.416088E-01>,
      <-8.106839E-01, 4.483452E-01>,
      <-8.10926E-01, 5.06618E-01>,
      <-7.885892E-01, 5.346041E-01>,
      <-6.702439E-01, 5.847182E-01>,
      <-5.587863E-01, 5.919462E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      152, 
      <1, 3, 2>, 0,
      <1, 2, 0>, 0,
      <3, 5, 4>, 0,
      <3, 4, 2>, 0,
      <5, 7, 6>, 0,
      <5, 6, 4>, 0,
      <7, 9, 8>, 0,
      <7, 8, 6>, 0,
      <9, 11, 10>, 0,
      <9, 10, 8>, 0,
      <11, 13, 12>, 0,
      <11, 12, 10>, 0,
      <13, 15, 14>, 0,
      <13, 14, 12>, 0,
      <15, 17, 16>, 0,
      <15, 16, 14>, 0,
      <17, 19, 18>, 0,
      <17, 18, 16>, 0,
      <19, 21, 20>, 0,
      <19, 20, 18>, 0,
      <21, 23, 22>, 0,
      <21, 22, 20>, 0,
      <23, 25, 24>, 0,
      <23, 24, 22>, 0,
      <25, 27, 26>, 0,
      <25, 26, 24>, 0,
      <27, 29, 28>, 0,
      <27, 28, 26>, 0,
      <29, 31, 30>, 0,
      <29, 30, 28>, 0,
      <31, 33, 32>, 0,
      <31, 32, 30>, 0,
      <33, 35, 34>, 0,
      <33, 34, 32>, 0,
      <35, 37, 36>, 0,
      <35, 36, 34>, 0,
      <37, 39, 38>, 0,
      <37, 38, 36>, 0,
      <39, 1, 0>, 0,
      <39, 0, 38>, 0,
      <0, 2, 4>, 0,
      <0, 4, 6>, 0,
      <0, 6, 8>, 0,
      <0, 8, 10>, 0,
      <0, 10, 12>, 0,
      <16, 18, 20>, 0,
      <16, 20, 22>, 0,
      <16, 22, 24>, 0,
      <16, 24, 26>, 0,
      <16, 26, 28>, 0,
      <28, 30, 32>, 0,
      <28, 32, 34>, 0,
      <28, 34, 36>, 0,
      <28, 36, 38>, 0,
      <28, 38, 0>, 0,
      <28, 0, 12>, 0,
      <28, 12, 14>, 0,
      <14, 16, 28>, 0,
      <1, 39, 37>, 0,
      <1, 37, 35>, 0,
      <1, 35, 33>, 0,
      <1, 33, 31>, 0,
      <1, 31, 29>, 0,
      <1, 29, 27>, 0,
      <1, 27, 25>, 0,
      <23, 21, 19>, 0,
      <23, 19, 17>, 0,
      <23, 17, 15>, 0,
      <23, 15, 13>, 0,
      <7, 5, 3>, 0,
      <7, 3, 1>, 0,
      <25, 23, 13>, 0,
      <9, 7, 1>, 0,
      <1, 25, 13>, 0,
      <1, 13, 11>, 0,
      <11, 9, 1>, 0,
      <0, 2, 3>, 0,
      <0, 3, 1>, 0,
      <2, 40, 41>, 0,
      <2, 41, 3>, 0,
      <40, 42, 43>, 0,
      <40, 43, 41>, 0,
      <42, 44, 45>, 0,
      <42, 45, 43>, 0,
      <44, 46, 47>, 0,
      <44, 47, 45>, 0,
      <46, 48, 49>, 0,
      <46, 49, 47>, 0,
      <48, 50, 51>, 0,
      <48, 51, 49>, 0,
      <50, 52, 53>, 0,
      <50, 53, 51>, 0,
      <52, 54, 55>, 0,
      <52, 55, 53>, 0,
      <54, 56, 57>, 0,
      <54, 57, 55>, 0,
      <56, 58, 59>, 0,
      <56, 59, 57>, 0,
      <58, 60, 61>, 0,
      <58, 61, 59>, 0,
      <60, 62, 63>, 0,
      <60, 63, 61>, 0,
      <62, 64, 65>, 0,
      <62, 65, 63>, 0,
      <64, 66, 67>, 0,
      <64, 67, 65>, 0,
      <66, 68, 69>, 0,
      <66, 69, 67>, 0,
      <68, 70, 71>, 0,
      <68, 71, 69>, 0,
      <70, 72, 73>, 0,
      <70, 73, 71>, 0,
      <72, 74, 75>, 0,
      <72, 75, 73>, 0,
      <74, 0, 1>, 0,
      <74, 1, 75>, 0,
      <0, 74, 72>, 0,
      <0, 72, 70>, 0,
      <0, 70, 68>, 0,
      <0, 68, 66>, 0,
      <0, 66, 64>, 0,
      <0, 64, 62>, 0,
      <0, 62, 60>, 0,
      <58, 56, 54>, 0,
      <58, 54, 52>, 0,
      <58, 52, 50>, 0,
      <58, 50, 48>, 0,
      <42, 40, 2>, 0,
      <42, 2, 0>, 0,
      <60, 58, 48>, 0,
      <44, 42, 0>, 0,
      <0, 60, 48>, 0,
      <0, 48, 46>, 0,
      <46, 44, 0>, 0,
      <1, 3, 41>, 0,
      <1, 41, 43>, 0,
      <1, 43, 45>, 0,
      <1, 45, 47>, 0,
      <1, 47, 49>, 0,
      <53, 55, 57>, 0,
      <53, 57, 59>, 0,
      <53, 59, 61>, 0,
      <53, 61, 63>, 0,
      <53, 63, 65>, 0,
      <65, 67, 69>, 0,
      <65, 69, 71>, 0,
      <65, 71, 73>, 0,
      <65, 73, 75>, 0,
      <65, 75, 1>, 0,
      <65, 1, 49>, 0,
      <65, 49, 51>, 0,
      <51, 53, 65>, 0
   }
 
   normal_indices { 
      152, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 3, 3>,
      <2, 3, 2>,
      <3, 4, 4>,
      <3, 4, 3>,
      <4, 5, 5>,
      <4, 5, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <6, 7, 7>,
      <6, 7, 6>,
      <7, 8, 8>,
      <7, 8, 7>,
      <8, 9, 9>,
      <8, 9, 8>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 10, 10>,
      <2, 10, 2>,
      <10, 11, 11>,
      <10, 11, 10>,
      <11, 12, 12>,
      <11, 12, 11>,
      <12, 13, 13>,
      <12, 13, 12>,
      <13, 1, 1>,
      <13, 1, 13>,
      <2, 14, 14>,
      <2, 14, 2>,
      <14, 15, 15>,
      <14, 15, 14>,
      <15, 16, 16>,
      <15, 16, 15>,
      <16, 17, 17>,
      <16, 17, 16>,
      <17, 18, 18>,
      <17, 18, 17>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <2, 2, 2>,
      <2, 2, 2>,
      <1, 1, 1>,
      <1, 1, 1>,
      <0, 21, 21>,
      <0, 21, 0>,
      <21, 22, 22>,
      <21, 22, 21>,
      <22, 23, 23>,
      <22, 23, 22>,
      <23, 24, 24>,
      <23, 24, 23>,
      <24, 25, 25>,
      <24, 25, 24>,
      <25, 26, 26>,
      <25, 26, 25>,
      <26, 27, 27>,
      <26, 27, 26>,
      <1, 1, 1>,
      <1, 1, 1>,
      <0, 28, 28>,
      <0, 28, 0>,
      <28, 29, 29>,
      <28, 29, 28>,
      <29, 30, 30>,
      <29, 30, 29>,
      <30, 31, 31>,
      <30, 31, 30>,
      <31, 1, 1>,
      <31, 1, 31>,
      <0, 32, 32>,
      <0, 32, 0>,
      <32, 33, 33>,
      <32, 33, 32>,
      <33, 34, 34>,
      <33, 34, 33>,
      <34, 35, 35>,
      <34, 35, 34>,
      <35, 18, 18>,
      <35, 18, 35>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>
   }
 
   uv_indices { 
      152, 
      <127, 128, 128>,
      <127, 128, 127>,
      <178, 179, 180>,
      <178, 180, 181>,
      <182, 183, 184>,
      <182, 184, 185>,
      <186, 187, 188>,
      <186, 188, 189>,
      <190, 191, 192>,
      <190, 192, 193>,
      <194, 195, 196>,
      <194, 196, 197>,
      <198, 199, 200>,
      <198, 200, 201>,
      <202, 203, 204>,
      <202, 204, 205>,
      <206, 207, 208>,
      <206, 208, 209>,
      <210, 211, 212>,
      <210, 212, 213>,
      <214, 215, 216>,
      <214, 216, 217>,
      <218, 219, 220>,
      <218, 220, 221>,
      <222, 223, 224>,
      <222, 224, 225>,
      <226, 227, 228>,
      <226, 228, 229>,
      <230, 231, 232>,
      <230, 232, 233>,
      <234, 235, 236>,
      <234, 236, 237>,
      <238, 239, 240>,
      <238, 240, 241>,
      <242, 243, 244>,
      <242, 244, 245>,
      <246, 247, 248>,
      <246, 248, 249>,
      <250, 251, 252>,
      <250, 252, 253>,
      <254, 255, 256>,
      <254, 256, 257>,
      <254, 257, 258>,
      <254, 258, 259>,
      <254, 259, 260>,
      <262, 263, 264>,
      <262, 264, 265>,
      <262, 265, 266>,
      <262, 266, 267>,
      <262, 267, 268>,
      <268, 269, 270>,
      <268, 270, 271>,
      <268, 271, 272>,
      <268, 272, 273>,
      <268, 273, 254>,
      <268, 254, 260>,
      <268, 260, 261>,
      <261, 262, 268>,
      <293, 274, 275>,
      <293, 275, 276>,
      <293, 276, 277>,
      <293, 277, 278>,
      <293, 278, 279>,
      <293, 279, 280>,
      <293, 280, 281>,
      <282, 283, 284>,
      <282, 284, 285>,
      <282, 285, 286>,
      <282, 286, 287>,
      <290, 291, 292>,
      <290, 292, 293>,
      <281, 282, 287>,
      <289, 290, 293>,
      <293, 281, 287>,
      <293, 287, 288>,
      <288, 289, 293>,
      <294, 295, 296>,
      <294, 296, 297>,
      <298, 299, 300>,
      <298, 300, 301>,
      <302, 303, 304>,
      <302, 304, 305>,
      <306, 307, 308>,
      <306, 308, 309>,
      <310, 311, 312>,
      <310, 312, 313>,
      <314, 315, 316>,
      <314, 316, 317>,
      <318, 319, 320>,
      <318, 320, 321>,
      <322, 323, 324>,
      <322, 324, 325>,
      <326, 327, 328>,
      <326, 328, 329>,
      <330, 331, 332>,
      <330, 332, 333>,
      <334, 335, 336>,
      <334, 336, 337>,
      <338, 339, 340>,
      <338, 340, 341>,
      <342, 343, 344>,
      <342, 344, 345>,
      <346, 347, 348>,
      <346, 348, 349>,
      <350, 351, 352>,
      <350, 352, 353>,
      <354, 355, 356>,
      <354, 356, 357>,
      <358, 359, 360>,
      <358, 360, 361>,
      <362, 363, 364>,
      <362, 364, 365>,
      <366, 367, 368>,
      <366, 368, 369>,
      <370, 371, 372>,
      <370, 372, 373>,
      <393, 374, 375>,
      <393, 375, 376>,
      <393, 376, 377>,
      <393, 377, 378>,
      <393, 378, 379>,
      <393, 379, 380>,
      <393, 380, 381>,
      <382, 383, 384>,
      <382, 384, 385>,
      <382, 385, 386>,
      <382, 386, 387>,
      <390, 391, 392>,
      <390, 392, 393>,
      <381, 382, 387>,
      <389, 390, 393>,
      <393, 381, 387>,
      <393, 387, 388>,
      <388, 389, 393>,
      <394, 395, 396>,
      <394, 396, 397>,
      <394, 397, 398>,
      <394, 398, 399>,
      <394, 399, 400>,
      <402, 403, 404>,
      <402, 404, 405>,
      <402, 405, 406>,
      <402, 406, 407>,
      <402, 407, 408>,
      <408, 409, 410>,
      <408, 410, 411>,
      <408, 411, 412>,
      <408, 412, 413>,
      <408, 413, 394>,
      <408, 394, 400>,
      <408, 400, 401>,
      <401, 402, 408>
   }
   uv_mapping
}
 
// AxleCap1
mesh2 {
 
   vertex_vectors { 
      16, 
      <4.753742E+00, 2.242231E+00, -9.344247E-01>,
      <5.194757E+00, 2.242231E+00, -9.344246E-01>,
      <5.194757E+00, 2.242231E+00, 1.230772E-01>,
      <4.753742E+00, 2.242231E+00, 1.230771E-01>,
      <4.753742E+00, 2.946012E+00, -9.344247E-01>,
      <4.986626E+00, 2.939211E+00, -9.344246E-01>,
      <4.753742E+00, 3.393731E+00, -5.93674E-01>,
      <4.833811E+00, 3.393731E+00, -5.93674E-01>,
      <4.986625E+00, 2.939211E+00, 1.230772E-01>,
      <4.753742E+00, 2.946012E+00, 1.230771E-01>,
      <4.753742E+00, 3.393731E+00, -2.176741E-01>,
      <4.833808E+00, 3.393731E+00, -2.176741E-01>,
      <5.194757E+00, 2.637721E+00, -9.344246E-01>,
      <5.194757E+00, 2.637721E+00, 1.235855E-01>,
      <4.753742E+00, 2.641122E+00, -9.344247E-01>,
      <4.753742E+00, 2.641122E+00, 1.230771E-01>
   }
 
   normal_vectors { 
      11, 
      <1.104931E-16, -1.00E+00, 2.459337E-16>,
      <5.894303E-03, 3.186712E-01, -9.47847E-01>,
      <6.238162E-03, 8.955734E-01, -4.448699E-01>,
      <6.238351E-03, 8.955734E-01, 4.4487E-01>,
      <5.558798E-03, 3.189484E-01, 9.477558E-01>,
      <9.425034E-01, 3.341967E-01, 3.071066E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <8.633782E-01, 5.045573E-01, 9.944129E-07>,
      <9.300554E-01, 3.674194E-01, 1.712647E-06>
   }
 
   uv_vectors { 
      32, 
      <-3.32E-01, 7.800042E-03>,
      <-3.662E-01, 7.800042E-03>,
      <-3.662E-01, 2.636737E-02>,
      <-3.662E-01, 2.61603E-02>,
      <-3.5518E-01, 4.000002E-02>,
      <-3.32E-01, 2.61603E-02>,
      <-3.32E-01, 2.636737E-02>,
      <-3.4302E-01, 4.000002E-02>,
      <-3.662E-01, 1.698017E-02>,
      <-2.196466E-01, 8.262624E-03>,
      <-1.905533E-01, 8.262624E-03>,
      <-2.196465E-01, 1.66088E-02>,
      <-2.196465E-01, 2.495497E-02>,
      <-2.106276E-01, 3.753743E-02>,
      <-1.995721E-01, 3.753743E-02>,
      <-1.905532E-01, 2.495497E-02>,
      <-3.32E-01, 1.698017E-02>,
      <-1.905532E-01, 1.66088E-02>,
      <-3.662E-01, 1.70837E-02>,
      <-3.32E-01, 1.70837E-02>,
      <-8.377002E-01, 5.168E-01>,
      <-9.824305E-01, 5.168E-01>,
      <-8.377002E-01, 5.954258E-01>,
      <-8.377002E-01, 5.961931E-01>,
      <-8.843356E-01, 6.467E-01>,
      <-9.357951E-01, 6.467E-01>,
      <-9.824305E-01, 5.961931E-01>,
      <-9.824305E-01, 5.954258E-01>,
      <-9.825002E-01, 5.61415E-01>,
      <-8.377002E-01, 5.61415E-01>,
      <-8.377002E-01, 5.617986E-01>,
      <-9.824305E-01, 5.617986E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      22, 
      <1, 2, 3>, 0,
      <1, 3, 0>, 0,
      <7, 5, 4>, 0,
      <7, 4, 6>, 0,
      <6, 10, 11>, 0,
      <6, 11, 7>, 0,
      <11, 10, 9>, 0,
      <11, 9, 8>, 0,
      <13, 2, 1>, 0,
      <13, 1, 12>, 0,
      <14, 4, 5>, 0,
      <14, 5, 12>, 0,
      <12, 1, 0>, 0,
      <12, 0, 14>, 0,
      <8, 9, 15>, 0,
      <8, 15, 13>, 0,
      <13, 15, 3>, 0,
      <13, 3, 2>, 0,
      <5, 7, 11>, 0,
      <5, 11, 8>, 0,
      <8, 13, 12>, 0,
      <8, 12, 5>, 0
   }
 
   normal_indices { 
      22, 
      <0, 0, 0>,
      <0, 0, 0>,
      <2, 1, 1>,
      <2, 1, 2>,
      <2, 3, 3>,
      <2, 3, 2>,
      <3, 3, 4>,
      <3, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <4, 4, 8>,
      <4, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 10, 10>,
      <9, 10, 9>,
      <9, 5, 5>,
      <9, 5, 9>
   }
 
   uv_indices { 
      22, 
      <20, 21, 21>,
      <20, 21, 20>,
      <24, 22, 23>,
      <24, 23, 24>,
      <24, 25, 25>,
      <24, 25, 24>,
      <25, 25, 26>,
      <25, 26, 27>,
      <28, 21, 20>,
      <28, 20, 29>,
      <30, 23, 22>,
      <30, 22, 29>,
      <29, 20, 20>,
      <29, 20, 30>,
      <27, 26, 31>,
      <27, 31, 28>,
      <28, 31, 21>,
      <28, 21, 21>,
      <22, 24, 25>,
      <22, 25, 27>,
      <27, 28, 29>,
      <27, 29, 22>
   }
   uv_mapping
}
 
// AxleCap2
mesh2 {
 
   vertex_vectors { 
      16, 
      <4.75374E+00, 2.242231E+00, 4.000847E+00>,
      <5.194756E+00, 2.242231E+00, 4.000847E+00>,
      <5.194756E+00, 2.242231E+00, 5.058349E+00>,
      <4.75374E+00, 2.242231E+00, 5.058349E+00>,
      <4.75374E+00, 2.946012E+00, 4.000847E+00>,
      <4.986624E+00, 2.939211E+00, 4.000847E+00>,
      <4.75374E+00, 3.393731E+00, 4.341598E+00>,
      <4.833809E+00, 3.393731E+00, 4.341598E+00>,
      <4.986624E+00, 2.939211E+00, 5.058349E+00>,
      <4.75374E+00, 2.946012E+00, 5.058349E+00>,
      <4.75374E+00, 3.393731E+00, 4.717598E+00>,
      <4.833807E+00, 3.393731E+00, 4.717598E+00>,
      <5.194756E+00, 2.637721E+00, 4.000847E+00>,
      <5.194756E+00, 2.637721E+00, 5.058857E+00>,
      <4.75374E+00, 2.641122E+00, 4.000847E+00>,
      <4.75374E+00, 2.641122E+00, 5.058349E+00>
   }
 
   normal_vectors { 
      11, 
      <1.104931E-16, -1.00E+00, 2.459337E-16>,
      <5.894301E-03, 3.186717E-01, -9.478468E-01>,
      <6.238161E-03, 8.955734E-01, -4.448698E-01>,
      <6.237909E-03, 8.955734E-01, 4.4487E-01>,
      <5.55822E-03, 3.189483E-01, 9.477558E-01>,
      <9.425034E-01, 3.341966E-01, 3.071066E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <8.633783E-01, 5.045571E-01, 9.944126E-07>,
      <9.300555E-01, 3.67419E-01, 1.712646E-06>
   }
 
   uv_vectors { 
      32, 
      <-3.32E-01, 7.800042E-03>,
      <-3.662E-01, 7.800042E-03>,
      <-3.662E-01, 2.636737E-02>,
      <-3.662E-01, 2.61603E-02>,
      <-3.5518E-01, 4.000002E-02>,
      <-3.32E-01, 2.61603E-02>,
      <-3.32E-01, 2.636737E-02>,
      <-3.4302E-01, 4.000002E-02>,
      <-3.662E-01, 1.698017E-02>,
      <-2.196466E-01, 8.262624E-03>,
      <-1.905533E-01, 8.262624E-03>,
      <-2.196465E-01, 1.66088E-02>,
      <-2.196465E-01, 2.495497E-02>,
      <-2.106276E-01, 3.753743E-02>,
      <-1.995721E-01, 3.753743E-02>,
      <-1.905532E-01, 2.495497E-02>,
      <-3.32E-01, 1.698017E-02>,
      <-1.905532E-01, 1.66088E-02>,
      <-3.662E-01, 1.70837E-02>,
      <-3.32E-01, 1.70837E-02>,
      <-8.377E-01, 5.168E-01>,
      <-9.824304E-01, 5.168E-01>,
      <-8.377E-01, 5.954258E-01>,
      <-8.377E-01, 5.961931E-01>,
      <-8.843354E-01, 6.467E-01>,
      <-9.357949E-01, 6.467E-01>,
      <-9.824304E-01, 5.961931E-01>,
      <-9.824304E-01, 5.954258E-01>,
      <-9.825E-01, 5.61415E-01>,
      <-8.377E-01, 5.61415E-01>,
      <-8.377E-01, 5.617986E-01>,
      <-9.824304E-01, 5.617986E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      22, 
      <1, 2, 3>, 0,
      <1, 3, 0>, 0,
      <7, 5, 4>, 0,
      <7, 4, 6>, 0,
      <6, 10, 11>, 0,
      <6, 11, 7>, 0,
      <11, 10, 9>, 0,
      <11, 9, 8>, 0,
      <13, 2, 1>, 0,
      <13, 1, 12>, 0,
      <14, 4, 5>, 0,
      <14, 5, 12>, 0,
      <12, 1, 0>, 0,
      <12, 0, 14>, 0,
      <8, 9, 15>, 0,
      <8, 15, 13>, 0,
      <13, 15, 3>, 0,
      <13, 3, 2>, 0,
      <5, 7, 11>, 0,
      <5, 11, 8>, 0,
      <8, 13, 12>, 0,
      <8, 12, 5>, 0
   }
 
   normal_indices { 
      22, 
      <0, 0, 0>,
      <0, 0, 0>,
      <2, 1, 1>,
      <2, 1, 2>,
      <2, 3, 3>,
      <2, 3, 2>,
      <3, 3, 4>,
      <3, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <4, 4, 8>,
      <4, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 10, 10>,
      <9, 10, 9>,
      <9, 5, 5>,
      <9, 5, 9>
   }
 
   uv_indices { 
      22, 
      <20, 21, 21>,
      <20, 21, 20>,
      <24, 22, 23>,
      <24, 23, 24>,
      <24, 25, 25>,
      <24, 25, 24>,
      <25, 25, 26>,
      <25, 26, 27>,
      <28, 21, 20>,
      <28, 20, 29>,
      <30, 23, 22>,
      <30, 22, 29>,
      <29, 20, 20>,
      <29, 20, 30>,
      <27, 26, 31>,
      <27, 31, 28>,
      <28, 31, 21>,
      <28, 21, 21>,
      <22, 24, 25>,
      <22, 25, 27>,
      <27, 28, 29>,
      <27, 29, 22>
   }
   uv_mapping
}
 
// AxleCap3
mesh2 {
 
   vertex_vectors { 
      16, 
      <4.753739E+00, 2.242231E+00, 8.956616E+00>,
      <5.194754E+00, 2.242231E+00, 8.956616E+00>,
      <5.194754E+00, 2.242231E+00, 1.001412E+01>,
      <4.753738E+00, 2.242231E+00, 1.001412E+01>,
      <4.753739E+00, 2.946012E+00, 8.956616E+00>,
      <4.986622E+00, 2.939211E+00, 8.956616E+00>,
      <4.753739E+00, 3.393731E+00, 9.297368E+00>,
      <4.833807E+00, 3.393731E+00, 9.297368E+00>,
      <4.986622E+00, 2.939211E+00, 1.001412E+01>,
      <4.753738E+00, 2.946012E+00, 1.001412E+01>,
      <4.753738E+00, 3.393731E+00, 9.673368E+00>,
      <4.833805E+00, 3.393731E+00, 9.673368E+00>,
      <5.194754E+00, 2.637721E+00, 8.956616E+00>,
      <5.194754E+00, 2.637721E+00, 1.001463E+01>,
      <4.753739E+00, 2.641122E+00, 8.956616E+00>,
      <4.753738E+00, 2.641122E+00, 1.001412E+01>
   }
 
   normal_vectors { 
      11, 
      <1.104931E-16, -1.00E+00, 2.459337E-16>,
      <5.894302E-03, 3.186716E-01, -9.478469E-01>,
      <6.238162E-03, 8.955734E-01, -4.448699E-01>,
      <6.237908E-03, 8.955734E-01, 4.4487E-01>,
      <5.558379E-03, 3.189484E-01, 9.477558E-01>,
      <9.425034E-01, 3.341965E-01, 3.071066E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <8.633783E-01, 5.045571E-01, 9.944126E-07>,
      <9.300554E-01, 3.674192E-01, 1.712646E-06>
   }
 
   uv_vectors { 
      32, 
      <-3.32E-01, 7.800042E-03>,
      <-3.662E-01, 7.800042E-03>,
      <-3.662E-01, 2.636737E-02>,
      <-3.662E-01, 2.61603E-02>,
      <-3.5518E-01, 4.000002E-02>,
      <-3.32E-01, 2.61603E-02>,
      <-3.32E-01, 2.636737E-02>,
      <-3.4302E-01, 4.000002E-02>,
      <-3.662E-01, 1.698017E-02>,
      <-2.196466E-01, 8.262624E-03>,
      <-1.905533E-01, 8.262624E-03>,
      <-2.196465E-01, 1.66088E-02>,
      <-2.196465E-01, 2.495497E-02>,
      <-2.106276E-01, 3.753743E-02>,
      <-1.995721E-01, 3.753743E-02>,
      <-1.905532E-01, 2.495497E-02>,
      <-3.32E-01, 1.698017E-02>,
      <-1.905532E-01, 1.66088E-02>,
      <-3.662E-01, 1.70837E-02>,
      <-3.32E-01, 1.70837E-02>,
      <-8.377E-01, 5.168E-01>,
      <-9.824304E-01, 5.168E-01>,
      <-8.377E-01, 5.954258E-01>,
      <-8.377E-01, 5.961931E-01>,
      <-8.843354E-01, 6.467E-01>,
      <-9.357949E-01, 6.467E-01>,
      <-9.824304E-01, 5.961931E-01>,
      <-9.824304E-01, 5.954258E-01>,
      <-9.825E-01, 5.61415E-01>,
      <-8.377E-01, 5.61415E-01>,
      <-8.377E-01, 5.617986E-01>,
      <-9.824304E-01, 5.617986E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      22, 
      <1, 2, 3>, 0,
      <1, 3, 0>, 0,
      <7, 5, 4>, 0,
      <7, 4, 6>, 0,
      <6, 10, 11>, 0,
      <6, 11, 7>, 0,
      <11, 10, 9>, 0,
      <11, 9, 8>, 0,
      <13, 2, 1>, 0,
      <13, 1, 12>, 0,
      <14, 4, 5>, 0,
      <14, 5, 12>, 0,
      <12, 1, 0>, 0,
      <12, 0, 14>, 0,
      <8, 9, 15>, 0,
      <8, 15, 13>, 0,
      <13, 15, 3>, 0,
      <13, 3, 2>, 0,
      <5, 7, 11>, 0,
      <5, 11, 8>, 0,
      <8, 13, 12>, 0,
      <8, 12, 5>, 0
   }
 
   normal_indices { 
      22, 
      <0, 0, 0>,
      <0, 0, 0>,
      <2, 1, 1>,
      <2, 1, 2>,
      <2, 3, 3>,
      <2, 3, 2>,
      <3, 3, 4>,
      <3, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <4, 4, 8>,
      <4, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 10, 10>,
      <9, 10, 9>,
      <9, 5, 5>,
      <9, 5, 9>
   }
 
   uv_indices { 
      22, 
      <20, 21, 21>,
      <20, 21, 20>,
      <24, 22, 23>,
      <24, 23, 24>,
      <24, 25, 25>,
      <24, 25, 24>,
      <25, 25, 26>,
      <25, 26, 27>,
      <28, 21, 20>,
      <28, 20, 29>,
      <30, 23, 22>,
      <30, 22, 29>,
      <29, 20, 20>,
      <29, 20, 30>,
      <27, 26, 31>,
      <27, 31, 28>,
      <28, 31, 21>,
      <28, 21, 21>,
      <22, 24, 25>,
      <22, 25, 27>,
      <27, 28, 29>,
      <27, 29, 22>
   }
   uv_mapping
}
 
// Brakes
mesh2 {
 
   vertex_vectors { 
      208, 
      <3.78066E+00, 2.328146E+00, 6.179818E+00>,
      <3.778579E+00, 3.010154E+00, 6.175218E+00>,
      <3.97858E+00, 3.010154E+00, 6.175218E+00>,
      <3.980661E+00, 2.328146E+00, 6.179818E+00>,
      <3.978582E+00, 2.875196E+00, 6.366045E+00>,
      <3.778581E+00, 2.875196E+00, 6.366045E+00>,
      <3.980661E+00, 2.445646E+00, 6.370644E+00>,
      <3.78066E+00, 2.445646E+00, 6.370644E+00>,
      <3.980661E+00, 2.328146E+00, 6.297318E+00>,
      <3.78066E+00, 2.328146E+00, 6.297319E+00>,
      <3.778579E+00, 3.597655E+00, 6.708152E+00>,
      <3.778581E+00, 3.597655E+00, 6.994391E+00>,
      <3.978582E+00, 3.597655E+00, 6.994391E+00>,
      <3.97858E+00, 3.597655E+00, 6.708152E+00>,
      <3.978581E+00, 2.328146E+00, 7.815948E+00>,
      <3.980662E+00, 3.010154E+00, 7.820548E+00>,
      <3.780662E+00, 3.010154E+00, 7.820548E+00>,
      <3.778581E+00, 2.328146E+00, 7.815948E+00>,
      <3.78066E+00, 2.875196E+00, 7.629721E+00>,
      <3.98066E+00, 2.875196E+00, 7.629721E+00>,
      <3.778581E+00, 2.445646E+00, 7.625122E+00>,
      <3.978581E+00, 2.445646E+00, 7.625122E+00>,
      <3.778581E+00, 2.328146E+00, 7.698449E+00>,
      <3.978581E+00, 2.328146E+00, 7.698446E+00>,
      <3.980662E+00, 3.597655E+00, 7.287614E+00>,
      <3.980661E+00, 3.597655E+00, 7.001374E+00>,
      <3.78066E+00, 3.597655E+00, 7.001374E+00>,
      <3.780662E+00, 3.597655E+00, 7.287614E+00>,
      <4.02962E+00, 2.121756E+00, 8.28835E+00>,
      <4.02962E+00, 3.061756E+00, 8.28835E+00>,
      <3.729621E+00, 3.061756E+00, 8.28835E+00>,
      <3.729621E+00, 2.121756E+00, 8.28835E+00>,
      <3.729621E+00, 2.944256E+00, 7.818351E+00>,
      <4.02962E+00, 2.944256E+00, 7.818351E+00>,
      <4.02962E+00, 3.061756E+00, 7.935851E+00>,
      <3.729621E+00, 3.061756E+00, 7.935851E+00>,
      <3.729621E+00, 2.121756E+00, 7.935851E+00>,
      <4.02962E+00, 2.121756E+00, 7.935851E+00>,
      <3.729621E+00, 2.239256E+00, 7.818351E+00>,
      <4.02962E+00, 2.239256E+00, 7.818351E+00>,
      <3.729621E+00, 2.121756E+00, 5.707416E+00>,
      <3.729621E+00, 3.061756E+00, 5.707416E+00>,
      <4.029621E+00, 3.061756E+00, 5.707416E+00>,
      <4.029621E+00, 2.121756E+00, 5.707416E+00>,
      <4.029621E+00, 2.944256E+00, 6.177415E+00>,
      <3.729621E+00, 2.944256E+00, 6.177415E+00>,
      <3.729621E+00, 3.061756E+00, 6.059915E+00>,
      <4.029621E+00, 3.061756E+00, 6.059915E+00>,
      <4.029621E+00, 2.121756E+00, 6.059915E+00>,
      <3.729621E+00, 2.121756E+00, 6.059915E+00>,
      <4.029621E+00, 2.239256E+00, 6.177415E+00>,
      <3.729621E+00, 2.239256E+00, 6.177415E+00>,
      <4.029622E+00, 2.121756E+00, 3.368788E+00>,
      <4.029622E+00, 3.061756E+00, 3.368788E+00>,
      <3.729622E+00, 3.061756E+00, 3.368788E+00>,
      <3.729622E+00, 2.121756E+00, 3.368788E+00>,
      <3.729622E+00, 2.944256E+00, 2.898787E+00>,
      <4.029622E+00, 2.944256E+00, 2.898787E+00>,
      <4.029622E+00, 3.061756E+00, 3.016289E+00>,
      <3.729622E+00, 3.061756E+00, 3.016289E+00>,
      <3.729622E+00, 2.121756E+00, 3.016289E+00>,
      <4.029622E+00, 2.121756E+00, 3.016289E+00>,
      <3.729622E+00, 2.239256E+00, 2.898787E+00>,
      <4.029622E+00, 2.239256E+00, 2.898787E+00>,
      <3.978583E+00, 2.328146E+00, 2.896385E+00>,
      <3.980664E+00, 3.010154E+00, 2.900986E+00>,
      <3.780663E+00, 3.010154E+00, 2.900985E+00>,
      <3.778582E+00, 2.328146E+00, 2.896385E+00>,
      <3.780661E+00, 2.875196E+00, 2.710158E+00>,
      <3.980662E+00, 2.875196E+00, 2.710158E+00>,
      <3.778582E+00, 2.445646E+00, 2.705559E+00>,
      <3.978583E+00, 2.445646E+00, 2.70556E+00>,
      <3.778582E+00, 2.328146E+00, 2.778886E+00>,
      <3.978583E+00, 2.328146E+00, 2.778884E+00>,
      <3.980664E+00, 3.597655E+00, 2.368052E+00>,
      <3.980662E+00, 3.597655E+00, 2.081811E+00>,
      <3.780661E+00, 3.597655E+00, 2.081811E+00>,
      <3.780663E+00, 3.597655E+00, 2.368051E+00>,
      <3.729623E+00, 2.121756E+00, 7.878531E-01>,
      <3.729623E+00, 3.061756E+00, 7.878531E-01>,
      <4.029623E+00, 3.061756E+00, 7.878532E-01>,
      <4.029623E+00, 2.121756E+00, 7.878532E-01>,
      <4.029622E+00, 2.944256E+00, 1.257852E+00>,
      <3.729623E+00, 2.944256E+00, 1.257852E+00>,
      <3.729623E+00, 3.061756E+00, 1.140352E+00>,
      <4.029622E+00, 3.061756E+00, 1.140352E+00>,
      <4.029622E+00, 2.121756E+00, 1.140352E+00>,
      <3.729623E+00, 2.121756E+00, 1.140352E+00>,
      <4.029622E+00, 2.239256E+00, 1.257852E+00>,
      <3.729623E+00, 2.239256E+00, 1.257852E+00>,
      <3.780662E+00, 2.328146E+00, 1.260255E+00>,
      <3.778581E+00, 3.010154E+00, 1.255655E+00>,
      <3.978581E+00, 3.010154E+00, 1.255655E+00>,
      <3.980662E+00, 2.328146E+00, 1.260255E+00>,
      <3.978583E+00, 2.875196E+00, 1.446483E+00>,
      <3.778583E+00, 2.875196E+00, 1.446483E+00>,
      <3.980662E+00, 2.445646E+00, 1.451081E+00>,
      <3.780662E+00, 2.445646E+00, 1.451081E+00>,
      <3.980662E+00, 2.328146E+00, 1.377755E+00>,
      <3.780662E+00, 2.328146E+00, 1.377757E+00>,
      <3.778581E+00, 3.597655E+00, 1.788589E+00>,
      <3.778582E+00, 3.597655E+00, 2.074829E+00>,
      <3.978583E+00, 3.597655E+00, 2.074829E+00>,
      <3.978581E+00, 3.597655E+00, 1.788589E+00>,
      <-1.321341E+00, 2.328146E+00, 6.179816E+00>,
      <-1.323422E+00, 3.010154E+00, 6.175216E+00>,
      <-1.123421E+00, 3.010154E+00, 6.175216E+00>,
      <-1.12134E+00, 2.328146E+00, 6.179816E+00>,
      <-1.123419E+00, 2.875196E+00, 6.366043E+00>,
      <-1.32342E+00, 2.875196E+00, 6.366043E+00>,
      <-1.12134E+00, 2.445646E+00, 6.370642E+00>,
      <-1.321341E+00, 2.445646E+00, 6.370642E+00>,
      <-1.12134E+00, 2.328146E+00, 6.297316E+00>,
      <-1.321341E+00, 2.328146E+00, 6.297318E+00>,
      <-1.323422E+00, 3.597655E+00, 6.70815E+00>,
      <-1.32342E+00, 3.597655E+00, 6.99439E+00>,
      <-1.12342E+00, 3.597655E+00, 6.99439E+00>,
      <-1.123421E+00, 3.597655E+00, 6.70815E+00>,
      <-1.12342E+00, 2.328146E+00, 7.815946E+00>,
      <-1.121339E+00, 3.010154E+00, 7.820546E+00>,
      <-1.32134E+00, 3.010154E+00, 7.820546E+00>,
      <-1.323421E+00, 2.328146E+00, 7.815946E+00>,
      <-1.321342E+00, 2.875196E+00, 7.629719E+00>,
      <-1.121341E+00, 2.875196E+00, 7.629719E+00>,
      <-1.323421E+00, 2.445646E+00, 7.62512E+00>,
      <-1.12342E+00, 2.445646E+00, 7.62512E+00>,
      <-1.323421E+00, 2.328146E+00, 7.698447E+00>,
      <-1.12342E+00, 2.328146E+00, 7.698444E+00>,
      <-1.121339E+00, 3.597655E+00, 7.287612E+00>,
      <-1.121341E+00, 3.597655E+00, 7.001372E+00>,
      <-1.321341E+00, 3.597655E+00, 7.001372E+00>,
      <-1.32134E+00, 3.597655E+00, 7.287612E+00>,
      <-1.072381E+00, 2.121756E+00, 8.288348E+00>,
      <-1.072381E+00, 3.061756E+00, 8.288348E+00>,
      <-1.37238E+00, 3.061756E+00, 8.288348E+00>,
      <-1.37238E+00, 2.121756E+00, 8.288348E+00>,
      <-1.37238E+00, 2.944256E+00, 7.818349E+00>,
      <-1.072381E+00, 2.944256E+00, 7.818349E+00>,
      <-1.072381E+00, 3.061756E+00, 7.935849E+00>,
      <-1.37238E+00, 3.061756E+00, 7.935849E+00>,
      <-1.37238E+00, 2.121756E+00, 7.935849E+00>,
      <-1.072381E+00, 2.121756E+00, 7.935849E+00>,
      <-1.37238E+00, 2.239256E+00, 7.818349E+00>,
      <-1.072381E+00, 2.239256E+00, 7.818349E+00>,
      <-1.37238E+00, 2.121756E+00, 5.707414E+00>,
      <-1.37238E+00, 3.061756E+00, 5.707414E+00>,
      <-1.07238E+00, 3.061756E+00, 5.707414E+00>,
      <-1.07238E+00, 2.121756E+00, 5.707414E+00>,
      <-1.072381E+00, 2.944256E+00, 6.177413E+00>,
      <-1.37238E+00, 2.944256E+00, 6.177413E+00>,
      <-1.37238E+00, 3.061756E+00, 6.059913E+00>,
      <-1.072381E+00, 3.061756E+00, 6.059913E+00>,
      <-1.072381E+00, 2.121756E+00, 6.059913E+00>,
      <-1.37238E+00, 2.121756E+00, 6.059913E+00>,
      <-1.072381E+00, 2.239256E+00, 6.177413E+00>,
      <-1.37238E+00, 2.239256E+00, 6.177413E+00>,
      <-1.07238E+00, 2.121756E+00, 3.368786E+00>,
      <-1.07238E+00, 3.061756E+00, 3.368786E+00>,
      <-1.372379E+00, 3.061756E+00, 3.368786E+00>,
      <-1.372379E+00, 2.121756E+00, 3.368786E+00>,
      <-1.372379E+00, 2.944256E+00, 2.898786E+00>,
      <-1.07238E+00, 2.944256E+00, 2.898786E+00>,
      <-1.07238E+00, 3.061756E+00, 3.016287E+00>,
      <-1.372379E+00, 3.061756E+00, 3.016287E+00>,
      <-1.372379E+00, 2.121756E+00, 3.016287E+00>,
      <-1.07238E+00, 2.121756E+00, 3.016287E+00>,
      <-1.372379E+00, 2.239256E+00, 2.898786E+00>,
      <-1.07238E+00, 2.239256E+00, 2.898786E+00>,
      <-1.123418E+00, 2.328146E+00, 2.896384E+00>,
      <-1.121337E+00, 3.010154E+00, 2.900984E+00>,
      <-1.321338E+00, 3.010154E+00, 2.900984E+00>,
      <-1.323419E+00, 2.328146E+00, 2.896383E+00>,
      <-1.32134E+00, 2.875196E+00, 2.710156E+00>,
      <-1.121339E+00, 2.875196E+00, 2.710157E+00>,
      <-1.323419E+00, 2.445646E+00, 2.705558E+00>,
      <-1.123418E+00, 2.445646E+00, 2.705558E+00>,
      <-1.323419E+00, 2.328146E+00, 2.778884E+00>,
      <-1.123418E+00, 2.328146E+00, 2.778882E+00>,
      <-1.121337E+00, 3.597655E+00, 2.36805E+00>,
      <-1.121339E+00, 3.597655E+00, 2.081809E+00>,
      <-1.32134E+00, 3.597655E+00, 2.081809E+00>,
      <-1.321338E+00, 3.597655E+00, 2.36805E+00>,
      <-1.372378E+00, 2.121756E+00, 7.878514E-01>,
      <-1.372378E+00, 3.061756E+00, 7.878514E-01>,
      <-1.072379E+00, 3.061756E+00, 7.878515E-01>,
      <-1.072379E+00, 2.121756E+00, 7.878515E-01>,
      <-1.072379E+00, 2.944256E+00, 1.257851E+00>,
      <-1.372378E+00, 2.944256E+00, 1.257851E+00>,
      <-1.372378E+00, 3.061756E+00, 1.14035E+00>,
      <-1.072379E+00, 3.061756E+00, 1.14035E+00>,
      <-1.072379E+00, 2.121756E+00, 1.14035E+00>,
      <-1.372378E+00, 2.121756E+00, 1.14035E+00>,
      <-1.072379E+00, 2.239256E+00, 1.257851E+00>,
      <-1.372378E+00, 2.239256E+00, 1.257851E+00>,
      <-1.321339E+00, 2.328146E+00, 1.260253E+00>,
      <-1.32342E+00, 3.010154E+00, 1.255654E+00>,
      <-1.12342E+00, 3.010154E+00, 1.255654E+00>,
      <-1.121339E+00, 2.328146E+00, 1.260253E+00>,
      <-1.123418E+00, 2.875196E+00, 1.446481E+00>,
      <-1.323419E+00, 2.875196E+00, 1.446481E+00>,
      <-1.121339E+00, 2.445646E+00, 1.451079E+00>,
      <-1.32134E+00, 2.445646E+00, 1.451079E+00>,
      <-1.121339E+00, 2.328146E+00, 1.377753E+00>,
      <-1.321339E+00, 2.328146E+00, 1.377755E+00>,
      <-1.323421E+00, 3.597655E+00, 1.788588E+00>,
      <-1.323419E+00, 3.597655E+00, 2.074827E+00>,
      <-1.123418E+00, 3.597655E+00, 2.074827E+00>,
      <-1.12342E+00, 3.597655E+00, 1.788588E+00>
   }
 
   normal_vectors { 
      26, 
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <3.043767E-07, 3.569452E-01, -9.341254E-01>,
      <1.685267E-06, -2.702032E-01, 9.628034E-01>,
      <-3.057987E-07, -3.453079E-01, 9.384894E-01>,
      <1.104931E-16, -1.00E+00, 2.459337E-16>,
      <2.036103E-06, -8.744764E-01, 4.850683E-01>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.31981E-07, 9.142959E-01, -4.050469E-01>,
      <-1.104931E-16, 9.999999E-01, -2.459337E-16>,
      <-2.458612E-07, -6.562511E-01, 7.545426E-01>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <-3.043767E-07, 3.569452E-01, 9.341254E-01>,
      <-1.849896E-06, -2.702029E-01, -9.628034E-01>,
      <3.057987E-07, -3.453079E-01, -9.384894E-01>,
      <-2.216806E-06, -8.744762E-01, -4.850685E-01>,
      <-1.319811E-07, 9.142958E-01, 4.050471E-01>,
      <2.458612E-07, -6.562511E-01, -7.545427E-01>,
      <1.246938E-07, 9.238799E-01, -3.826824E-01>,
      <3.01038E-07, 3.826844E-01, -9.238791E-01>,
      <1.246939E-07, -9.238799E-01, -3.826828E-01>,
      <3.010381E-07, -3.826841E-01, -9.238793E-01>,
      <-1.246938E-07, 9.238798E-01, 3.826826E-01>,
      <-3.010381E-07, 3.826842E-01, 9.238791E-01>,
      <-1.24694E-07, -9.238797E-01, 3.826831E-01>,
      <-3.010381E-07, -3.826838E-01, 9.238794E-01>
   }
 
   uv_vectors { 
      293, 
      <-2.870832E-01, 2.00517E-01>,
      <-2.866292E-01, 2.402044E-01>,
      <-3.022715E-01, 2.323509E-01>,
      <-3.027897E-01, 2.073545E-01>,
      <-2.966274E-01, 2.00517E-01>,
      <-2.568087E-01, 1.885E-01>,
      <-2.569676E-01, 2.432E-01>,
      <-2.826042E-01, 2.432E-01>,
      <-2.917815E-01, 2.363624E-01>,
      <-2.916605E-01, 1.953375E-01>,
      <-2.824453E-01, 1.885E-01>,
      <-2.897405E-01, 1.953298E-01>,
      <-2.897405E-01, 2.36342E-01>,
      <-2.540077E-01, 1.88517E-01>,
      <-2.540244E-01, 2.432E-01>,
      <-2.811793E-01, 2.431831E-01>,
      <-2.811772E-01, 1.885E-01>,
      <-2.920796E-01, 2.005062E-01>,
      <-2.918376E-01, 2.401814E-01>,
      <-3.05342E-01, 2.323212E-01>,
      <-3.055632E-01, 2.073324E-01>,
      <-3.004656E-01, 2.005006E-01>,
      <-2.826931E-01, 1.885E-01>,
      <-2.918977E-01, 1.953375E-01>,
      <-2.568102E-01, 2.432E-01>,
      <-2.569697E-01, 1.885E-01>,
      <-3.025332E-01, 2.323369E-01>,
      <-2.867925E-01, 2.401903E-01>,
      <-2.98243E-01, 2.005029E-01>,
      <-2.904445E-01, 2.401903E-01>,
      <-2.907769E-01, 2.005029E-01>,
      <-2.809801E-01, 1.885E-01>,
      <-2.886077E-01, 1.953375E-01>,
      <-2.88656E-01, 2.363625E-01>,
      <-2.810414E-01, 2.432E-01>,
      <-2.83767E-01, 2.432E-01>,
      <-2.921331E-01, 2.363625E-01>,
      <-2.920739E-01, 1.953375E-01>,
      <-2.836906E-01, 1.885E-01>,
      <-2.899423E-01, 2.00517E-01>,
      <-2.895832E-01, 2.402044E-01>,
      <-2.979359E-01, 2.00517E-01>,
      <-2.898375E-01, 2.00517E-01>,
      <-2.977242E-01, 2.00517E-01>,
      <-2.77679E-01, 2.432E-01>,
      <-2.852388E-01, 2.363625E-01>,
      <-2.853488E-01, 1.953375E-01>,
      <-2.778236E-01, 1.885E-01>,
      <-2.838095E-01, 1.885E-01>,
      <-2.921899E-01, 1.953375E-01>,
      <-2.776135E-01, 1.885E-01>,
      <-2.851501E-01, 1.953375E-01>,
      <-2.894589E-01, 2.401903E-01>,
      <-3.033977E-01, 1.914E-01>,
      <-3.033048E-01, 2.158E-01>,
      <-2.933024E-01, 2.158E-01>,
      <-2.934205E-01, 1.914E-01>,
      <-2.935308E-01, 1.914E-01>,
      <-3.031693E-01, 1.914E-01>,
      <-3.031693E-01, 2.158E-01>,
      <-2.935308E-01, 2.158E-01>,
      <-2.933036E-01, 1.914E-01>,
      <-3.032923E-01, 1.914E-01>,
      <-2.934076E-01, 2.158E-01>,
      <-2.710937E-01, 2.119E-01>,
      <-2.710937E-01, 2.344E-01>,
      <-2.602062E-01, 2.344E-01>,
      <-2.602062E-01, 2.119E-01>,
      <-2.696328E-01, 2.119E-01>,
      <-2.696328E-01, 2.344E-01>,
      <-2.616671E-01, 2.344E-01>,
      <-2.616671E-01, 2.119E-01>,
      <-2.604513E-01, 2.119E-01>,
      <-2.708487E-01, 2.119E-01>,
      <-2.708487E-01, 2.344E-01>,
      <-2.604513E-01, 2.344E-01>,
      <-2.672777E-01, 1.943298E-01>,
      <-2.671208E-01, 2.35342E-01>,
      <-3.008191E-01, 2.353759E-01>,
      <-3.009888E-01, 1.943637E-01>,
      <-2.814578E-01, 1.875E-01>,
      <-2.889387E-01, 1.943375E-01>,
      <-2.889851E-01, 2.353625E-01>,
      <-2.815191E-01, 2.422E-01>,
      <-2.578042E-01, 2.422E-01>,
      <-2.577541E-01, 1.875E-01>,
      <-2.983882E-01, 1.995029E-01>,
      <-3.028474E-01, 2.063405E-01>,
      <-3.025168E-01, 2.313369E-01>,
      <-2.907402E-01, 2.391903E-01>,
      <-2.910652E-01, 1.995029E-01>,
      <-2.968236E-01, 1.995029E-01>,
      <-2.871597E-01, 2.391903E-01>,
      <-2.87433E-01, 1.995029E-01>,
      <-2.831362E-01, 1.875E-01>,
      <-2.921662E-01, 1.943375E-01>,
      <-2.920486E-01, 2.353624E-01>,
      <-2.829806E-01, 2.422E-01>,
      <-2.577541E-01, 2.422E-01>,
      <-2.579097E-01, 1.875E-01>,
      <-2.902485E-01, 1.99517E-01>,
      <-2.898951E-01, 2.392044E-01>,
      <-2.980875E-01, 1.99517E-01>,
      <-2.841897E-01, 2.422E-01>,
      <-2.923954E-01, 2.353625E-01>,
      <-2.923362E-01, 1.943375E-01>,
      <-2.841152E-01, 1.875E-01>,
      <-2.782199E-01, 2.422E-01>,
      <-2.856349E-01, 2.353625E-01>,
      <-2.857417E-01, 1.943375E-01>,
      <-2.783645E-01, 1.875E-01>,
      <-2.901455E-01, 1.99517E-01>,
      <-3.026463E-01, 2.313509E-01>,
      <-2.978779E-01, 1.99517E-01>,
      <-2.579076E-01, 2.422E-01>,
      <-2.919319E-01, 1.943375E-01>,
      <-2.828943E-01, 1.875E-01>,
      <-2.869989E-01, 2.392044E-01>,
      <-3.02339E-01, 2.31351E-01>,
      <-2.897745E-01, 2.391903E-01>,
      <-2.781572E-01, 1.875E-01>,
      <-2.855501E-01, 1.943375E-01>,
      <-2.842312E-01, 1.875E-01>,
      <-2.924508E-01, 1.943375E-01>,
      <-3.039145E-01, 1.807E-01>,
      <-2.704007E-01, 1.318E-01>,
      <-2.614856E-01, 1.409348E-01>,
      <-2.878132E-01, 1.807E-01>,
      <-2.751589E-01, 1.807E-01>,
      <-3.039145E-01, 1.409348E-01>,
      <-2.931169E-01, 1.318E-01>,
      <-2.614856E-01, 1.807E-01>,
      <-2.775854E-01, 1.807E-01>,
      <-2.949989E-01, 1.318E-01>,
      <-2.722836E-01, 1.318E-01>,
      <-2.902416E-01, 1.807E-01>,
      <-3.251603E-01, 1.777E-01>,
      <-3.251603E-01, 1.328E-01>,
      <-3.632395E-01, 1.328E-01>,
      <-3.632395E-01, 1.777E-01>,
      <-3.586777E-01, 1.777E-01>,
      <-3.586777E-01, 1.328E-01>,
      <-3.297222E-01, 1.328E-01>,
      <-3.297222E-01, 1.777E-01>,
      <-3.297222E-01, 1.549796E-01>,
      <-3.584057E-01, 1.549796E-01>,
      <-3.584057E-01, 1.328E-01>,
      <-3.632962E-01, 1.328E-01>,
      <-2.944577E-01, 1.914E-01>,
      <-2.944577E-01, 2.119E-01>,
      <-3.012422E-01, 2.119E-01>,
      <-3.012422E-01, 1.914E-01>,
      <-2.744908E-01, 2.158E-01>,
      <-2.744908E-01, 2.354E-01>,
      <-2.597093E-01, 2.354E-01>,
      <-2.597093E-01, 2.158E-01>,
      <-2.725074E-01, 2.354E-01>,
      <-2.725074E-01, 2.158E-01>,
      <-2.616927E-01, 2.158E-01>,
      <-2.616927E-01, 2.354E-01>,
      <-2.854056E-01, 1.797E-01>,
      <-2.586418E-01, 1.368448E-01>,
      <-2.67663E-01, 1.27E-01>,
      <-3.019583E-01, 1.797E-01>,
      <-2.586418E-01, 1.797E-01>,
      <-2.908235E-01, 1.27E-01>,
      <-3.019583E-01, 1.368448E-01>,
      <-2.724729E-01, 1.797E-01>,
      <-2.929372E-01, 1.27E-01>,
      <-2.751923E-01, 1.797E-01>,
      <-2.881289E-01, 1.797E-01>,
      <-2.697774E-01, 1.27E-01>,
      <-3.073763E-01, 1.797E-01>,
      <-2.683928E-01, 1.299E-01>,
      <-2.580239E-01, 1.392028E-01>,
      <-2.886475E-01, 1.797E-01>,
      <-2.739303E-01, 1.797E-01>,
      <-3.073763E-01, 1.392028E-01>,
      <-2.948157E-01, 1.299E-01>,
      <-2.580239E-01, 1.797E-01>,
      <-2.705862E-01, 1.299E-01>,
      <-2.914728E-01, 1.797E-01>,
      <-2.767513E-01, 1.797E-01>,
      <-2.97007E-01, 1.299E-01>,
      <-2.94078E-01, 1.934E-01>,
      <-2.93995E-01, 2.148E-01>,
      <-3.016295E-01, 2.148E-01>,
      <-3.017049E-01, 1.934E-01>,
      <-1.831359E-01, 8.28275E-01>,
      <-2.059E-01, 8.557749E-01>,
      <-2.044722E-01, 9.56309E-01>,
      <-1.452293E-01, 9.878951E-01>,
      <-1.466572E-01, 8.28275E-01>,
      <-1.094349E-01, 7.80E-01>,
      <-1.459129E-01, 8.075E-01>,
      <-1.459129E-01, 9.725E-01>,
      <-1.094349E-01, 9.999999E-01>,
      <-5.680246E-08, 9.999999E-01>,
      <-5.680246E-08, 7.80E-01>,
      <6.951416E-09, 9.999999E-01>,
      <-1.491213E-01, 8.282881E-01>,
      <-1.481163E-01, 9.878594E-01>,
      <-2.04895E-01, 9.562462E-01>,
      <-1.840821E-01, 8.282653E-01>,
      <-1.398458E-01, 8.074688E-01>,
      <-1.398458E-01, 9.724176E-01>,
      <-1.922984E-01, 9.725538E-01>,
      <-1.922984E-01, 8.07605E-01>,
      <-1.048841E-01, 9.999318E-01>,
      <-1.048841E-01, 7.80E-01>,
      <-1.398458E-01, 9.724177E-01>,
      <-1.922975E-01, 8.07605E-01>,
      <-1.481163E-01, 9.878594E-01>,
      <-2.04895E-01, 9.562462E-01>,
      <-1.840821E-01, 8.282653E-01>,
      <-1.522E-01, 7.865E-01>,
      <-1.522E-01, 8.602E-01>,
      <-1.947E-01, 8.602E-01>,
      <-1.947E-01, 7.865E-01>,
      <-1.522E-01, 8.602E-01>,
      <-1.947E-01, 8.602E-01>,
      <-9.80E-01, 2.359E-01>,
      <-9.80E-01, 1.859999E-02>,
      <-8.489E-01, 1.859999E-02>,
      <-8.489E-01, 2.359E-01>,
      <-9.80E-01, 1.859998E-02>,
      <-9.799988E-01, 1.859999E-02>,
      <-9.80E-01, 1.859998E-02>,
      <-9.80E-01, 1.859999E-02>,
      <-9.80E-01, 1.859999E-02>,
      <-9.875E-01, 4.806E-01>,
      <-8.65846E-01, 2.609E-01>,
      <-8.289E-01, 3.019411E-01>,
      <-9.320811E-01, 4.806E-01>,
      <-8.843188E-01, 4.806E-01>,
      <-9.875E-01, 3.019411E-01>,
      <-9.50554E-01, 2.609E-01>,
      <-8.289E-01, 4.806E-01>,
      <-8.289E-01, 3.019411E-01>,
      <-9.50554E-01, 2.609E-01>,
      <-9.50554E-01, 2.609E-01>,
      <-1.859999E-02, 8.801E-01>,
      <-1.859999E-02, 9.788E-01>,
      <-9.48E-02, 9.788E-01>,
      <-9.48E-02, 8.801E-01>,
      <-1.859999E-02, 9.788E-01>,
      <-9.48E-02, 8.801E-01>,
      <-1.859999E-02, 9.788E-01>,
      <-9.48E-02, 8.801E-01>,
      <-1.859999E-02, 9.788E-01>,
      <-9.48E-02, 8.801E-01>,
      <-1.859999E-02, 9.788E-01>,
      <-9.48E-02, 8.801E-01>,
      <-1.859999E-02, 9.788E-01>,
      <-9.48E-02, 8.801E-01>,
      <-9.48E-02, 8.801E-01>,
      <-1.859999E-02, 9.788E-01>,
      <-9.48E-02, 8.801E-01>,
      <-1.859999E-02, 9.788E-01>,
      <-1.547E-01, 8.714E-01>,
      <-1.947001E-01, 8.714E-01>,
      <-1.947001E-01, 8.412189E-01>,
      <-1.547E-01, 8.412189E-01>,
      <-1.881713E-01, 8.314894E-01>,
      <-1.881713E-01, 8.136888E-01>,
      <-1.615046E-01, 8.136883E-01>,
      <-1.615046E-01, 8.314894E-01>,
      <-1.881713E-01, 7.902E-01>,
      <-1.615046E-01, 7.902E-01>,
      <-1.547E-01, 7.902E-01>,
      <-1.551111E-01, 8.714E-01>,
      <-1.94289E-01, 7.902E-01>,
      <-1.947001E-01, 7.902E-01>,
      <-1.763408E-01, 7.902E-01>,
      <-1.763408E-01, 8.714E-01>,
      <-1.547E-01, 8.056884E-01>,
      <-1.947001E-01, 8.056884E-01>,
      <-1.947001E-01, 7.902E-01>,
      <-1.547E-01, 8.274691E-01>,
      <-1.947001E-01, 8.274696E-01>,
      <-1.551111E-01, 8.714E-01>,
      <-1.547E-01, 8.099973E-01>,
      <-1.94289E-01, 8.099974E-01>,
      <-1.947001E-01, 8.395845E-01>,
      <-1.551127E-01, 8.395845E-01>,
      <-1.947001E-01, 8.602017E-01>,
      <-1.551127E-01, 8.602014E-01>,
      <-1.947001E-01, 7.902E-01>,
      <-1.547E-01, 8.220153E-01>,
      <-1.551127E-01, 8.714E-01>,
      <-1.942874E-01, 8.220153E-01>,
      <-1.547E-01, 8.013983E-01>,
      <-1.942874E-01, 8.013985E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      352, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <6, 4, 5>, 0,
      <6, 5, 7>, 0,
      <3, 8, 9>, 0,
      <3, 9, 0>, 0,
      <6, 7, 9>, 0,
      <6, 9, 8>, 0,
      <8, 3, 2>, 0,
      <8, 2, 4>, 0,
      <4, 6, 8>, 0,
      <0, 9, 7>, 0,
      <0, 7, 5>, 0,
      <5, 1, 0>, 0,
      <10, 11, 12>, 0,
      <10, 12, 13>, 0,
      <10, 1, 5>, 0,
      <10, 5, 11>, 0,
      <11, 5, 4>, 0,
      <11, 4, 12>, 0,
      <12, 4, 2>, 0,
      <12, 2, 13>, 0,
      <13, 2, 1>, 0,
      <13, 1, 10>, 0,
      <14, 15, 16>, 0,
      <14, 16, 17>, 0,
      <20, 18, 19>, 0,
      <20, 19, 21>, 0,
      <17, 22, 23>, 0,
      <17, 23, 14>, 0,
      <20, 21, 23>, 0,
      <20, 23, 22>, 0,
      <22, 17, 16>, 0,
      <22, 16, 18>, 0,
      <18, 20, 22>, 0,
      <14, 23, 21>, 0,
      <14, 21, 19>, 0,
      <19, 15, 14>, 0,
      <24, 25, 26>, 0,
      <24, 26, 27>, 0,
      <24, 15, 19>, 0,
      <24, 19, 25>, 0,
      <25, 19, 18>, 0,
      <25, 18, 26>, 0,
      <26, 18, 16>, 0,
      <26, 16, 27>, 0,
      <27, 16, 15>, 0,
      <27, 15, 24>, 0,
      <28, 29, 30>, 0,
      <28, 30, 31>, 0,
      <29, 34, 35>, 0,
      <29, 35, 30>, 0,
      <33, 32, 35>, 0,
      <33, 35, 34>, 0,
      <31, 36, 37>, 0,
      <31, 37, 28>, 0,
      <38, 32, 33>, 0,
      <38, 33, 39>, 0,
      <37, 36, 38>, 0,
      <37, 38, 39>, 0,
      <31, 30, 35>, 0,
      <31, 35, 32>, 0,
      <31, 32, 38>, 0,
      <31, 38, 36>, 0,
      <37, 39, 33>, 0,
      <37, 33, 34>, 0,
      <37, 34, 29>, 0,
      <37, 29, 28>, 0,
      <40, 41, 42>, 0,
      <40, 42, 43>, 0,
      <41, 46, 47>, 0,
      <41, 47, 42>, 0,
      <45, 44, 47>, 0,
      <45, 47, 46>, 0,
      <43, 48, 49>, 0,
      <43, 49, 40>, 0,
      <50, 44, 45>, 0,
      <50, 45, 51>, 0,
      <49, 48, 50>, 0,
      <49, 50, 51>, 0,
      <43, 42, 47>, 0,
      <43, 47, 44>, 0,
      <43, 44, 50>, 0,
      <43, 50, 48>, 0,
      <49, 51, 45>, 0,
      <49, 45, 46>, 0,
      <49, 46, 41>, 0,
      <49, 41, 40>, 0,
      <52, 53, 54>, 0,
      <52, 54, 55>, 0,
      <53, 58, 59>, 0,
      <53, 59, 54>, 0,
      <57, 56, 59>, 0,
      <57, 59, 58>, 0,
      <55, 60, 61>, 0,
      <55, 61, 52>, 0,
      <62, 56, 57>, 0,
      <62, 57, 63>, 0,
      <61, 60, 62>, 0,
      <61, 62, 63>, 0,
      <55, 54, 59>, 0,
      <55, 59, 56>, 0,
      <55, 56, 62>, 0,
      <55, 62, 60>, 0,
      <61, 63, 57>, 0,
      <61, 57, 58>, 0,
      <61, 58, 53>, 0,
      <61, 53, 52>, 0,
      <64, 65, 66>, 0,
      <64, 66, 67>, 0,
      <70, 68, 69>, 0,
      <70, 69, 71>, 0,
      <67, 72, 73>, 0,
      <67, 73, 64>, 0,
      <70, 71, 73>, 0,
      <70, 73, 72>, 0,
      <72, 67, 66>, 0,
      <72, 66, 68>, 0,
      <68, 70, 72>, 0,
      <64, 73, 71>, 0,
      <64, 71, 69>, 0,
      <69, 65, 64>, 0,
      <74, 75, 76>, 0,
      <74, 76, 77>, 0,
      <74, 65, 69>, 0,
      <74, 69, 75>, 0,
      <75, 69, 68>, 0,
      <75, 68, 76>, 0,
      <76, 68, 66>, 0,
      <76, 66, 77>, 0,
      <77, 66, 65>, 0,
      <77, 65, 74>, 0,
      <78, 79, 80>, 0,
      <78, 80, 81>, 0,
      <79, 84, 85>, 0,
      <79, 85, 80>, 0,
      <83, 82, 85>, 0,
      <83, 85, 84>, 0,
      <81, 86, 87>, 0,
      <81, 87, 78>, 0,
      <88, 82, 83>, 0,
      <88, 83, 89>, 0,
      <87, 86, 88>, 0,
      <87, 88, 89>, 0,
      <81, 80, 85>, 0,
      <81, 85, 82>, 0,
      <81, 82, 88>, 0,
      <81, 88, 86>, 0,
      <87, 89, 83>, 0,
      <87, 83, 84>, 0,
      <87, 84, 79>, 0,
      <87, 79, 78>, 0,
      <90, 91, 92>, 0,
      <90, 92, 93>, 0,
      <96, 94, 95>, 0,
      <96, 95, 97>, 0,
      <93, 98, 99>, 0,
      <93, 99, 90>, 0,
      <96, 97, 99>, 0,
      <96, 99, 98>, 0,
      <98, 93, 92>, 0,
      <98, 92, 94>, 0,
      <94, 96, 98>, 0,
      <90, 99, 97>, 0,
      <90, 97, 95>, 0,
      <95, 91, 90>, 0,
      <100, 101, 102>, 0,
      <100, 102, 103>, 0,
      <100, 91, 95>, 0,
      <100, 95, 101>, 0,
      <101, 95, 94>, 0,
      <101, 94, 102>, 0,
      <102, 94, 92>, 0,
      <102, 92, 103>, 0,
      <103, 92, 91>, 0,
      <103, 91, 100>, 0,
      <104, 105, 106>, 0,
      <104, 106, 107>, 0,
      <110, 108, 109>, 0,
      <110, 109, 111>, 0,
      <107, 112, 113>, 0,
      <107, 113, 104>, 0,
      <110, 111, 113>, 0,
      <110, 113, 112>, 0,
      <112, 107, 106>, 0,
      <112, 106, 108>, 0,
      <108, 110, 112>, 0,
      <104, 113, 111>, 0,
      <104, 111, 109>, 0,
      <109, 105, 104>, 0,
      <114, 115, 116>, 0,
      <114, 116, 117>, 0,
      <114, 105, 109>, 0,
      <114, 109, 115>, 0,
      <115, 109, 108>, 0,
      <115, 108, 116>, 0,
      <116, 108, 106>, 0,
      <116, 106, 117>, 0,
      <117, 106, 105>, 0,
      <117, 105, 114>, 0,
      <118, 119, 120>, 0,
      <118, 120, 121>, 0,
      <124, 122, 123>, 0,
      <124, 123, 125>, 0,
      <121, 126, 127>, 0,
      <121, 127, 118>, 0,
      <124, 125, 127>, 0,
      <124, 127, 126>, 0,
      <126, 121, 120>, 0,
      <126, 120, 122>, 0,
      <122, 124, 126>, 0,
      <118, 127, 125>, 0,
      <118, 125, 123>, 0,
      <123, 119, 118>, 0,
      <128, 129, 130>, 0,
      <128, 130, 131>, 0,
      <128, 119, 123>, 0,
      <128, 123, 129>, 0,
      <129, 123, 122>, 0,
      <129, 122, 130>, 0,
      <130, 122, 120>, 0,
      <130, 120, 131>, 0,
      <131, 120, 119>, 0,
      <131, 119, 128>, 0,
      <132, 133, 134>, 0,
      <132, 134, 135>, 0,
      <133, 138, 139>, 0,
      <133, 139, 134>, 0,
      <137, 136, 139>, 0,
      <137, 139, 138>, 0,
      <135, 140, 141>, 0,
      <135, 141, 132>, 0,
      <142, 136, 137>, 0,
      <142, 137, 143>, 0,
      <141, 140, 142>, 0,
      <141, 142, 143>, 0,
      <135, 134, 139>, 0,
      <135, 139, 136>, 0,
      <135, 136, 142>, 0,
      <135, 142, 140>, 0,
      <141, 143, 137>, 0,
      <141, 137, 138>, 0,
      <141, 138, 133>, 0,
      <141, 133, 132>, 0,
      <144, 145, 146>, 0,
      <144, 146, 147>, 0,
      <145, 150, 151>, 0,
      <145, 151, 146>, 0,
      <149, 148, 151>, 0,
      <149, 151, 150>, 0,
      <147, 152, 153>, 0,
      <147, 153, 144>, 0,
      <154, 148, 149>, 0,
      <154, 149, 155>, 0,
      <153, 152, 154>, 0,
      <153, 154, 155>, 0,
      <147, 146, 151>, 0,
      <147, 151, 148>, 0,
      <147, 148, 154>, 0,
      <147, 154, 152>, 0,
      <153, 155, 149>, 0,
      <153, 149, 150>, 0,
      <153, 150, 145>, 0,
      <153, 145, 144>, 0,
      <156, 157, 158>, 0,
      <156, 158, 159>, 0,
      <157, 162, 163>, 0,
      <157, 163, 158>, 0,
      <161, 160, 163>, 0,
      <161, 163, 162>, 0,
      <159, 164, 165>, 0,
      <159, 165, 156>, 0,
      <166, 160, 161>, 0,
      <166, 161, 167>, 0,
      <165, 164, 166>, 0,
      <165, 166, 167>, 0,
      <159, 158, 163>, 0,
      <159, 163, 160>, 0,
      <159, 160, 166>, 0,
      <159, 166, 164>, 0,
      <165, 167, 161>, 0,
      <165, 161, 162>, 0,
      <165, 162, 157>, 0,
      <165, 157, 156>, 0,
      <168, 169, 170>, 0,
      <168, 170, 171>, 0,
      <174, 172, 173>, 0,
      <174, 173, 175>, 0,
      <171, 176, 177>, 0,
      <171, 177, 168>, 0,
      <174, 175, 177>, 0,
      <174, 177, 176>, 0,
      <176, 171, 170>, 0,
      <176, 170, 172>, 0,
      <172, 174, 176>, 0,
      <168, 177, 175>, 0,
      <168, 175, 173>, 0,
      <173, 169, 168>, 0,
      <178, 179, 180>, 0,
      <178, 180, 181>, 0,
      <178, 169, 173>, 0,
      <178, 173, 179>, 0,
      <179, 173, 172>, 0,
      <179, 172, 180>, 0,
      <180, 172, 170>, 0,
      <180, 170, 181>, 0,
      <181, 170, 169>, 0,
      <181, 169, 178>, 0,
      <182, 183, 184>, 0,
      <182, 184, 185>, 0,
      <183, 188, 189>, 0,
      <183, 189, 184>, 0,
      <187, 186, 189>, 0,
      <187, 189, 188>, 0,
      <185, 190, 191>, 0,
      <185, 191, 182>, 0,
      <192, 186, 187>, 0,
      <192, 187, 193>, 0,
      <191, 190, 192>, 0,
      <191, 192, 193>, 0,
      <185, 184, 189>, 0,
      <185, 189, 186>, 0,
      <185, 186, 192>, 0,
      <185, 192, 190>, 0,
      <191, 193, 187>, 0,
      <191, 187, 188>, 0,
      <191, 188, 183>, 0,
      <191, 183, 182>, 0,
      <194, 195, 196>, 0,
      <194, 196, 197>, 0,
      <200, 198, 199>, 0,
      <200, 199, 201>, 0,
      <197, 202, 203>, 0,
      <197, 203, 194>, 0,
      <200, 201, 203>, 0,
      <200, 203, 202>, 0,
      <202, 197, 196>, 0,
      <202, 196, 198>, 0,
      <198, 200, 202>, 0,
      <194, 203, 201>, 0,
      <194, 201, 199>, 0,
      <199, 195, 194>, 0,
      <204, 205, 206>, 0,
      <204, 206, 207>, 0,
      <204, 195, 199>, 0,
      <204, 199, 205>, 0,
      <205, 199, 198>, 0,
      <205, 198, 206>, 0,
      <206, 198, 196>, 0,
      <206, 196, 207>, 0,
      <207, 196, 195>, 0,
      <207, 195, 204>, 0
   }
 
   normal_indices { 
      352, 
      <0, 1, 1>,
      <0, 1, 0>,
      <2, 3, 3>,
      <2, 3, 2>,
      <4, 5, 5>,
      <4, 5, 4>,
      <2, 2, 5>,
      <2, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <8, 9, 9>,
      <8, 9, 8>,
      <7, 7, 7>,
      <7, 7, 7>,
      <10, 3, 3>,
      <10, 3, 10>,
      <6, 6, 6>,
      <6, 6, 6>,
      <8, 1, 1>,
      <8, 1, 8>,
      <11, 12, 12>,
      <11, 12, 11>,
      <13, 14, 14>,
      <13, 14, 13>,
      <4, 15, 15>,
      <4, 15, 4>,
      <13, 13, 15>,
      <13, 15, 15>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <16, 9, 9>,
      <16, 9, 16>,
      <6, 6, 6>,
      <6, 6, 6>,
      <17, 14, 14>,
      <17, 14, 17>,
      <7, 7, 7>,
      <7, 7, 7>,
      <16, 12, 12>,
      <16, 12, 16>,
      <11, 11, 11>,
      <11, 11, 11>,
      <9, 18, 18>,
      <9, 18, 9>,
      <19, 19, 18>,
      <19, 18, 18>,
      <4, 20, 20>,
      <4, 20, 4>,
      <21, 19, 19>,
      <21, 19, 21>,
      <20, 20, 21>,
      <20, 21, 21>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <0, 0, 0>,
      <0, 0, 0>,
      <9, 22, 22>,
      <9, 22, 9>,
      <23, 23, 22>,
      <23, 22, 22>,
      <4, 24, 24>,
      <4, 24, 4>,
      <25, 23, 23>,
      <25, 23, 25>,
      <24, 24, 25>,
      <24, 25, 25>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <11, 11, 11>,
      <11, 11, 11>,
      <9, 18, 18>,
      <9, 18, 9>,
      <19, 19, 18>,
      <19, 18, 18>,
      <4, 20, 20>,
      <4, 20, 4>,
      <21, 19, 19>,
      <21, 19, 21>,
      <20, 20, 21>,
      <20, 21, 21>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <11, 12, 12>,
      <11, 12, 11>,
      <13, 14, 14>,
      <13, 14, 13>,
      <4, 15, 15>,
      <4, 15, 4>,
      <13, 13, 15>,
      <13, 15, 15>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <16, 9, 9>,
      <16, 9, 16>,
      <6, 6, 6>,
      <6, 6, 6>,
      <17, 14, 14>,
      <17, 14, 17>,
      <7, 7, 7>,
      <7, 7, 7>,
      <16, 12, 12>,
      <16, 12, 16>,
      <0, 0, 0>,
      <0, 0, 0>,
      <9, 22, 22>,
      <9, 22, 9>,
      <23, 23, 22>,
      <23, 22, 22>,
      <4, 24, 24>,
      <4, 24, 4>,
      <25, 23, 23>,
      <25, 23, 25>,
      <24, 24, 25>,
      <24, 25, 25>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <0, 1, 1>,
      <0, 1, 0>,
      <2, 3, 3>,
      <2, 3, 2>,
      <4, 5, 5>,
      <4, 5, 4>,
      <2, 2, 5>,
      <2, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <8, 9, 9>,
      <8, 9, 8>,
      <7, 7, 7>,
      <7, 7, 7>,
      <10, 3, 3>,
      <10, 3, 10>,
      <6, 6, 6>,
      <6, 6, 6>,
      <8, 1, 1>,
      <8, 1, 8>,
      <0, 1, 1>,
      <0, 1, 0>,
      <2, 3, 3>,
      <2, 3, 2>,
      <4, 5, 5>,
      <4, 5, 4>,
      <2, 2, 5>,
      <2, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <8, 9, 9>,
      <8, 9, 8>,
      <7, 7, 7>,
      <7, 7, 7>,
      <10, 3, 3>,
      <10, 3, 10>,
      <6, 6, 6>,
      <6, 6, 6>,
      <8, 1, 1>,
      <8, 1, 8>,
      <11, 12, 12>,
      <11, 12, 11>,
      <13, 14, 14>,
      <13, 14, 13>,
      <4, 15, 15>,
      <4, 15, 4>,
      <13, 13, 15>,
      <13, 15, 15>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <16, 9, 9>,
      <16, 9, 16>,
      <6, 6, 6>,
      <6, 6, 6>,
      <17, 14, 14>,
      <17, 14, 17>,
      <7, 7, 7>,
      <7, 7, 7>,
      <16, 12, 12>,
      <16, 12, 16>,
      <11, 11, 11>,
      <11, 11, 11>,
      <9, 18, 18>,
      <9, 18, 9>,
      <19, 19, 18>,
      <19, 18, 18>,
      <4, 20, 20>,
      <4, 20, 4>,
      <21, 19, 19>,
      <21, 19, 21>,
      <20, 20, 21>,
      <20, 21, 21>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <0, 0, 0>,
      <0, 0, 0>,
      <9, 22, 22>,
      <9, 22, 9>,
      <23, 23, 22>,
      <23, 22, 22>,
      <4, 24, 24>,
      <4, 24, 4>,
      <25, 23, 23>,
      <25, 23, 25>,
      <24, 24, 25>,
      <24, 25, 25>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <11, 11, 11>,
      <11, 11, 11>,
      <9, 18, 18>,
      <9, 18, 9>,
      <19, 19, 18>,
      <19, 18, 18>,
      <4, 20, 20>,
      <4, 20, 4>,
      <21, 19, 19>,
      <21, 19, 21>,
      <20, 20, 21>,
      <20, 21, 21>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <11, 12, 12>,
      <11, 12, 11>,
      <13, 14, 14>,
      <13, 14, 13>,
      <4, 15, 15>,
      <4, 15, 4>,
      <13, 13, 15>,
      <13, 15, 15>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <16, 9, 9>,
      <16, 9, 16>,
      <6, 6, 6>,
      <6, 6, 6>,
      <17, 14, 14>,
      <17, 14, 17>,
      <7, 7, 7>,
      <7, 7, 7>,
      <16, 12, 12>,
      <16, 12, 16>,
      <0, 0, 0>,
      <0, 0, 0>,
      <9, 22, 22>,
      <9, 22, 9>,
      <23, 23, 22>,
      <23, 22, 22>,
      <4, 24, 24>,
      <4, 24, 4>,
      <25, 23, 23>,
      <25, 23, 25>,
      <24, 24, 25>,
      <24, 25, 25>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <0, 1, 1>,
      <0, 1, 0>,
      <2, 3, 3>,
      <2, 3, 2>,
      <4, 5, 5>,
      <4, 5, 4>,
      <2, 2, 5>,
      <2, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <8, 9, 9>,
      <8, 9, 8>,
      <7, 7, 7>,
      <7, 7, 7>,
      <10, 3, 3>,
      <10, 3, 10>,
      <6, 6, 6>,
      <6, 6, 6>,
      <8, 1, 1>,
      <8, 1, 8>
   }
 
   uv_indices { 
      352, 
      <187, 186, 185>,
      <187, 185, 184>,
      <269, 270, 260>,
      <269, 260, 271>,
      <272, 273, 274>,
      <272, 274, 260>,
      <269, 259, 274>,
      <269, 274, 273>,
      <188, 192, 191>,
      <188, 191, 190>,
      <190, 189, 188>,
      <192, 188, 189>,
      <192, 189, 190>,
      <190, 191, 192>,
      <221, 222, 223>,
      <221, 223, 224>,
      <234, 235, 239>,
      <234, 239, 237>,
      <221, 228, 223>,
      <221, 223, 224>,
      <230, 231, 232>,
      <230, 232, 233>,
      <221, 222, 223>,
      <221, 223, 224>,
      <184, 185, 186>,
      <184, 186, 187>,
      <269, 280, 260>,
      <269, 260, 271>,
      <269, 278, 279>,
      <269, 279, 277>,
      <259, 260, 279>,
      <259, 279, 278>,
      <203, 200, 201>,
      <203, 201, 202>,
      <202, 189, 203>,
      <192, 188, 189>,
      <192, 189, 190>,
      <190, 191, 192>,
      <223, 224, 221>,
      <223, 221, 222>,
      <234, 235, 236>,
      <234, 236, 237>,
      <221, 229, 223>,
      <221, 223, 224>,
      <230, 231, 238>,
      <230, 238, 233>,
      <221, 222, 223>,
      <221, 223, 224>,
      <241, 249, 243>,
      <241, 243, 250>,
      <241, 253, 243>,
      <241, 243, 254>,
      <73, 72, 75>,
      <73, 75, 74>,
      <241, 258, 243>,
      <241, 243, 257>,
      <204, 205, 206>,
      <204, 206, 207>,
      <277, 269, 259>,
      <277, 259, 260>,
      <198, 199, 208>,
      <198, 208, 205>,
      <198, 205, 204>,
      <198, 204, 209>,
      <193, 194, 195>,
      <193, 195, 196>,
      <193, 196, 197>,
      <193, 197, 198>,
      <241, 242, 243>,
      <241, 243, 244>,
      <243, 255, 241>,
      <243, 241, 256>,
      <72, 73, 74>,
      <72, 74, 75>,
      <243, 257, 241>,
      <243, 241, 258>,
      <269, 259, 260>,
      <269, 260, 272>,
      <272, 269, 259>,
      <272, 259, 260>,
      <198, 197, 196>,
      <198, 196, 195>,
      <198, 195, 194>,
      <198, 194, 193>,
      <193, 194, 195>,
      <193, 195, 196>,
      <193, 196, 199>,
      <193, 199, 198>,
      <241, 247, 243>,
      <241, 243, 248>,
      <241, 253, 243>,
      <241, 243, 254>,
      <72, 73, 74>,
      <72, 74, 75>,
      <241, 256, 243>,
      <241, 243, 255>,
      <215, 219, 220>,
      <215, 220, 218>,
      <287, 269, 259>,
      <287, 259, 260>,
      <198, 199, 196>,
      <198, 196, 195>,
      <198, 195, 194>,
      <198, 194, 193>,
      <193, 194, 195>,
      <193, 195, 196>,
      <193, 196, 197>,
      <193, 197, 198>,
      <187, 186, 185>,
      <187, 185, 184>,
      <288, 289, 260>,
      <288, 260, 290>,
      <269, 291, 292>,
      <269, 292, 271>,
      <288, 290, 292>,
      <288, 292, 291>,
      <188, 192, 191>,
      <188, 191, 190>,
      <190, 189, 188>,
      <192, 188, 189>,
      <192, 189, 190>,
      <190, 191, 192>,
      <223, 224, 221>,
      <223, 221, 226>,
      <234, 235, 236>,
      <234, 236, 237>,
      <221, 228, 223>,
      <221, 223, 224>,
      <230, 231, 238>,
      <230, 238, 233>,
      <221, 226, 223>,
      <221, 223, 224>,
      <241, 245, 243>,
      <241, 243, 246>,
      <243, 255, 241>,
      <243, 241, 256>,
      <73, 72, 75>,
      <73, 75, 74>,
      <243, 255, 241>,
      <243, 241, 256>,
      <215, 216, 217>,
      <215, 217, 218>,
      <259, 260, 261>,
      <259, 261, 262>,
      <198, 199, 196>,
      <198, 196, 195>,
      <198, 195, 194>,
      <198, 194, 193>,
      <193, 194, 195>,
      <193, 195, 196>,
      <193, 196, 199>,
      <193, 199, 198>,
      <184, 185, 186>,
      <184, 186, 187>,
      <269, 270, 260>,
      <269, 260, 271>,
      <263, 264, 265>,
      <263, 265, 266>,
      <267, 268, 265>,
      <267, 265, 264>,
      <188, 192, 191>,
      <188, 191, 190>,
      <190, 189, 188>,
      <192, 188, 189>,
      <192, 189, 190>,
      <190, 191, 192>,
      <221, 225, 223>,
      <221, 223, 224>,
      <234, 235, 240>,
      <234, 240, 237>,
      <221, 228, 223>,
      <221, 223, 224>,
      <230, 231, 232>,
      <230, 232, 233>,
      <221, 225, 223>,
      <221, 223, 224>,
      <187, 186, 185>,
      <187, 185, 184>,
      <283, 271, 269>,
      <283, 269, 284>,
      <260, 285, 286>,
      <260, 286, 280>,
      <283, 284, 286>,
      <283, 286, 285>,
      <188, 192, 191>,
      <188, 191, 190>,
      <190, 189, 188>,
      <192, 188, 189>,
      <192, 189, 190>,
      <190, 191, 192>,
      <221, 222, 223>,
      <221, 223, 224>,
      <234, 235, 239>,
      <234, 239, 237>,
      <221, 228, 223>,
      <221, 223, 224>,
      <230, 231, 232>,
      <230, 232, 233>,
      <221, 222, 223>,
      <221, 223, 224>,
      <184, 185, 186>,
      <184, 186, 187>,
      <288, 289, 260>,
      <288, 260, 290>,
      <269, 291, 292>,
      <269, 292, 271>,
      <288, 290, 292>,
      <288, 292, 291>,
      <188, 192, 191>,
      <188, 191, 190>,
      <190, 189, 188>,
      <192, 188, 189>,
      <192, 189, 190>,
      <190, 191, 192>,
      <223, 224, 221>,
      <223, 221, 222>,
      <234, 235, 236>,
      <234, 236, 237>,
      <221, 228, 223>,
      <221, 223, 224>,
      <230, 231, 238>,
      <230, 238, 233>,
      <221, 222, 223>,
      <221, 223, 224>,
      <241, 249, 243>,
      <241, 243, 250>,
      <241, 253, 243>,
      <241, 243, 254>,
      <73, 72, 75>,
      <73, 75, 74>,
      <241, 258, 243>,
      <241, 243, 257>,
      <215, 219, 220>,
      <215, 220, 218>,
      <287, 269, 259>,
      <287, 259, 260>,
      <198, 199, 196>,
      <198, 196, 195>,
      <198, 195, 194>,
      <198, 194, 193>,
      <193, 194, 195>,
      <193, 195, 196>,
      <193, 196, 199>,
      <193, 199, 198>,
      <241, 242, 243>,
      <241, 243, 244>,
      <243, 255, 241>,
      <243, 241, 256>,
      <72, 73, 74>,
      <72, 74, 75>,
      <243, 257, 241>,
      <243, 241, 258>,
      <215, 219, 220>,
      <215, 220, 218>,
      <277, 269, 259>,
      <277, 259, 260>,
      <198, 197, 196>,
      <198, 196, 195>,
      <198, 195, 194>,
      <198, 194, 193>,
      <193, 194, 195>,
      <193, 195, 196>,
      <193, 196, 197>,
      <193, 197, 198>,
      <241, 249, 243>,
      <241, 243, 250>,
      <241, 251, 243>,
      <241, 243, 252>,
      <72, 73, 74>,
      <72, 74, 75>,
      <68, 69, 70>,
      <68, 70, 71>,
      <215, 219, 220>,
      <215, 220, 218>,
      <287, 269, 259>,
      <287, 259, 260>,
      <198, 197, 196>,
      <198, 196, 195>,
      <198, 195, 194>,
      <198, 194, 193>,
      <193, 194, 195>,
      <193, 195, 196>,
      <193, 196, 197>,
      <193, 197, 198>,
      <187, 186, 185>,
      <187, 185, 184>,
      <288, 289, 260>,
      <288, 260, 290>,
      <269, 291, 292>,
      <269, 292, 271>,
      <288, 290, 292>,
      <288, 292, 291>,
      <188, 192, 191>,
      <188, 191, 190>,
      <190, 189, 188>,
      <192, 188, 189>,
      <192, 189, 190>,
      <190, 191, 192>,
      <223, 224, 221>,
      <223, 221, 226>,
      <234, 235, 236>,
      <234, 236, 237>,
      <221, 227, 223>,
      <221, 223, 224>,
      <230, 231, 232>,
      <230, 232, 233>,
      <221, 227, 223>,
      <221, 223, 224>,
      <241, 247, 243>,
      <241, 243, 248>,
      <243, 255, 241>,
      <243, 241, 256>,
      <73, 72, 75>,
      <73, 75, 74>,
      <243, 255, 241>,
      <243, 241, 256>,
      <215, 216, 217>,
      <215, 217, 218>,
      <287, 269, 259>,
      <287, 259, 260>,
      <198, 199, 208>,
      <198, 208, 210>,
      <198, 210, 204>,
      <198, 204, 209>,
      <193, 194, 195>,
      <193, 195, 196>,
      <193, 196, 197>,
      <193, 197, 198>,
      <184, 185, 186>,
      <184, 186, 187>,
      <269, 289, 260>,
      <269, 260, 271>,
      <287, 273, 274>,
      <287, 274, 260>,
      <269, 259, 274>,
      <269, 274, 273>,
      <214, 200, 212>,
      <214, 212, 213>,
      <213, 189, 214>,
      <192, 188, 189>,
      <192, 189, 190>,
      <190, 191, 192>,
      <221, 226, 223>,
      <221, 223, 224>,
      <234, 235, 236>,
      <234, 236, 237>,
      <221, 227, 223>,
      <221, 223, 224>,
      <230, 231, 232>,
      <230, 232, 233>,
      <221, 226, 223>,
      <221, 223, 224>
   }
   uv_mapping
}
 
// BrakePis
mesh2 {
 
   vertex_vectors { 
      104, 
      <-6.65881E-01, 2.189703E+00, 6.992271E+00>,
      <-1.01229E+00, 2.424703E+00, 6.99227E+00>,
      <-1.01229E+00, 2.894703E+00, 6.99227E+00>,
      <-6.65881E-01, 3.129703E+00, 6.992271E+00>,
      <-3.194722E-01, 2.894703E+00, 6.992271E+00>,
      <-3.194722E-01, 2.424703E+00, 6.992271E+00>,
      <-6.658814E-01, 2.358903E+00, 8.167271E+00>,
      <-8.875821E-01, 2.509303E+00, 8.167271E+00>,
      <-8.875821E-01, 2.810103E+00, 8.167271E+00>,
      <-6.658814E-01, 2.960504E+00, 8.167271E+00>,
      <-4.441807E-01, 2.810103E+00, 8.167271E+00>,
      <-4.441807E-01, 2.509303E+00, 8.167271E+00>,
      <-6.658806E-01, 2.358903E+00, 5.817272E+00>,
      <-8.875813E-01, 2.509303E+00, 5.817271E+00>,
      <-8.875813E-01, 2.810103E+00, 5.817271E+00>,
      <-6.658806E-01, 2.960503E+00, 5.817272E+00>,
      <-4.4418E-01, 2.810103E+00, 5.817272E+00>,
      <-4.4418E-01, 2.509303E+00, 5.817272E+00>,
      <-2.158803E-01, 2.072203E+00, 7.168523E+00>,
      <-2.158803E-01, 3.247203E+00, 7.168523E+00>,
      <-1.115882E+00, 3.247203E+00, 7.168523E+00>,
      <-1.115882E+00, 2.072203E+00, 7.168523E+00>,
      <-1.115882E+00, 2.072203E+00, 6.816019E+00>,
      <-1.115882E+00, 3.247203E+00, 6.816019E+00>,
      <-2.158802E-01, 3.247203E+00, 6.81602E+00>,
      <-2.158802E-01, 2.072203E+00, 6.81602E+00>,
      <-6.658794E-01, 2.189703E+00, 2.058978E+00>,
      <-1.012288E+00, 2.424703E+00, 2.058978E+00>,
      <-1.012288E+00, 2.894703E+00, 2.058978E+00>,
      <-6.658794E-01, 3.129703E+00, 2.058978E+00>,
      <-3.194706E-01, 2.894703E+00, 2.058979E+00>,
      <-3.194706E-01, 2.424703E+00, 2.058979E+00>,
      <-6.658798E-01, 2.358903E+00, 3.233979E+00>,
      <-8.875805E-01, 2.509303E+00, 3.233979E+00>,
      <-8.875805E-01, 2.810103E+00, 3.233979E+00>,
      <-6.658798E-01, 2.960504E+00, 3.233979E+00>,
      <-4.441791E-01, 2.810103E+00, 3.233979E+00>,
      <-4.441791E-01, 2.509303E+00, 3.233979E+00>,
      <-6.65879E-01, 2.358903E+00, 8.839782E-01>,
      <-8.875797E-01, 2.509303E+00, 8.839781E-01>,
      <-8.875797E-01, 2.810103E+00, 8.839781E-01>,
      <-6.65879E-01, 2.960503E+00, 8.839782E-01>,
      <-4.441783E-01, 2.810103E+00, 8.839782E-01>,
      <-4.441783E-01, 2.509303E+00, 8.839782E-01>,
      <-2.158787E-01, 2.072203E+00, 2.23523E+00>,
      <-2.158787E-01, 3.247203E+00, 2.23523E+00>,
      <-1.11588E+00, 3.247203E+00, 2.23523E+00>,
      <-1.11588E+00, 2.072203E+00, 2.23523E+00>,
      <-1.11588E+00, 2.072203E+00, 1.882726E+00>,
      <-1.11588E+00, 3.247203E+00, 1.882726E+00>,
      <-2.158786E-01, 3.247203E+00, 1.882726E+00>,
      <-2.158786E-01, 2.072203E+00, 1.882726E+00>,
      <3.328077E+00, 2.189703E+00, 6.992272E+00>,
      <2.981668E+00, 2.424703E+00, 6.992272E+00>,
      <2.981668E+00, 2.894703E+00, 6.992272E+00>,
      <3.328077E+00, 3.129703E+00, 6.992272E+00>,
      <3.674485E+00, 2.894703E+00, 6.992272E+00>,
      <3.674485E+00, 2.424703E+00, 6.992272E+00>,
      <3.328076E+00, 2.358903E+00, 8.167273E+00>,
      <3.106375E+00, 2.509303E+00, 8.167273E+00>,
      <3.106375E+00, 2.810103E+00, 8.167273E+00>,
      <3.328076E+00, 2.960504E+00, 8.167273E+00>,
      <3.549777E+00, 2.810103E+00, 8.167273E+00>,
      <3.549777E+00, 2.509303E+00, 8.167273E+00>,
      <3.328077E+00, 2.358903E+00, 5.817273E+00>,
      <3.106376E+00, 2.509303E+00, 5.817273E+00>,
      <3.106376E+00, 2.810103E+00, 5.817273E+00>,
      <3.328077E+00, 2.960503E+00, 5.817273E+00>,
      <3.549778E+00, 2.810103E+00, 5.817273E+00>,
      <3.549778E+00, 2.509303E+00, 5.817273E+00>,
      <3.778077E+00, 2.072203E+00, 7.168525E+00>,
      <3.778077E+00, 3.247203E+00, 7.168525E+00>,
      <2.878076E+00, 3.247203E+00, 7.168524E+00>,
      <2.878076E+00, 2.072203E+00, 7.168524E+00>,
      <2.878076E+00, 2.072203E+00, 6.81602E+00>,
      <2.878076E+00, 3.247203E+00, 6.81602E+00>,
      <3.778077E+00, 3.247203E+00, 6.816021E+00>,
      <3.778077E+00, 2.072203E+00, 6.816021E+00>,
      <3.328078E+00, 2.189703E+00, 2.05898E+00>,
      <2.981669E+00, 2.424703E+00, 2.05898E+00>,
      <2.981669E+00, 2.894703E+00, 2.05898E+00>,
      <3.328078E+00, 3.129703E+00, 2.05898E+00>,
      <3.674487E+00, 2.894703E+00, 2.05898E+00>,
      <3.674487E+00, 2.424703E+00, 2.05898E+00>,
      <3.328078E+00, 2.358903E+00, 3.23398E+00>,
      <3.106377E+00, 2.509303E+00, 3.23398E+00>,
      <3.106377E+00, 2.810103E+00, 3.23398E+00>,
      <3.328078E+00, 2.960504E+00, 3.23398E+00>,
      <3.549778E+00, 2.810103E+00, 3.23398E+00>,
      <3.549778E+00, 2.509303E+00, 3.23398E+00>,
      <3.328079E+00, 2.358903E+00, 8.839795E-01>,
      <3.106378E+00, 2.509303E+00, 8.839794E-01>,
      <3.106378E+00, 2.810103E+00, 8.839794E-01>,
      <3.328079E+00, 2.960503E+00, 8.839795E-01>,
      <3.549779E+00, 2.810103E+00, 8.839796E-01>,
      <3.549779E+00, 2.509303E+00, 8.839796E-01>,
      <3.778079E+00, 2.072203E+00, 2.235231E+00>,
      <3.778079E+00, 3.247203E+00, 2.235231E+00>,
      <2.878077E+00, 3.247203E+00, 2.235231E+00>,
      <2.878077E+00, 2.072203E+00, 2.235231E+00>,
      <2.878078E+00, 2.072203E+00, 1.882727E+00>,
      <2.878078E+00, 3.247203E+00, 1.882727E+00>,
      <3.778079E+00, 3.247203E+00, 1.882728E+00>,
      <3.778079E+00, 2.072203E+00, 1.882728E+00>
   }
 
   normal_vectors { 
      42, 
      <-1.887738E-01, -9.808913E-01, 4.708293E-02>,
      <-2.009061E-07, -9.897905E-01, 1.425303E-01>,
      <-8.571844E-01, -4.948941E-01, 1.425299E-01>,
      <-7.550918E-01, -6.539264E-01, 4.708277E-02>,
      <-9.438635E-01, -3.269632E-01, 4.708254E-02>,
      <-8.571844E-01, 4.948941E-01, 1.425298E-01>,
      <-9.438635E-01, 3.269631E-01, 4.708247E-02>,
      <-7.550918E-01, 6.539263E-01, 4.708268E-02>,
      <-2.927952E-08, 9.897904E-01, 1.4253E-01>,
      <-1.887737E-01, 9.808912E-01, 4.708274E-02>,
      <1.887738E-01, 9.808912E-01, 4.708285E-02>,
      <8.571842E-01, 4.948941E-01, 1.425303E-01>,
      <7.550918E-01, 6.539262E-01, 4.708312E-02>,
      <9.438635E-01, 3.269632E-01, 4.708307E-02>,
      <8.571842E-01, -4.948943E-01, 1.425304E-01>,
      <9.438635E-01, -3.269633E-01, 4.708318E-02>,
      <7.550915E-01, -6.539266E-01, 4.708324E-02>,
      <1.887733E-01, -9.808914E-01, 4.708304E-02>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-2.796482E-07, -9.897906E-01, -1.425301E-01>,
      <-1.887739E-01, -9.808913E-01, -4.708289E-02>,
      <-7.550918E-01, -6.539264E-01, -4.708314E-02>,
      <-8.571842E-01, -4.948941E-01, -1.425303E-01>,
      <-9.438635E-01, -3.269632E-01, -4.70831E-02>,
      <-9.438635E-01, 3.269631E-01, -4.708312E-02>,
      <-8.571842E-01, 4.948941E-01, -1.425304E-01>,
      <-7.550918E-01, 6.539263E-01, -4.708324E-02>,
      <-1.887736E-01, 9.808913E-01, -4.708301E-02>,
      <2.009062E-07, 9.897904E-01, -1.425302E-01>,
      <1.887738E-01, 9.808912E-01, -4.70829E-02>,
      <7.550918E-01, 6.539262E-01, -4.708276E-02>,
      <8.571845E-01, 4.94894E-01, -1.425298E-01>,
      <9.438635E-01, 3.26963E-01, -4.708249E-02>,
      <9.438635E-01, -3.269634E-01, -4.708249E-02>,
      <8.571842E-01, -4.948944E-01, -1.425298E-01>,
      <7.550915E-01, -6.539266E-01, -4.708265E-02>,
      <1.887734E-01, -9.808914E-01, -4.708277E-02>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104931E-16, 9.999999E-01, -2.459337E-16>,
      <1.104931E-16, -1.00E+00, 2.459337E-16>
   }
 
   uv_vectors { 
      274, 
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <-1.441447E-01, 1.2916E-01>,
      <-1.476822E-01, 1.380304E-01>,
      <-1.467621E-01, 1.459152E-01>,
      <-1.426424E-01, 1.4148E-01>,
      <-1.467621E-01, 1.616848E-01>,
      <-1.426424E-01, 1.661201E-01>,
      <-1.476822E-01, 1.695696E-01>,
      <-1.441447E-01, 1.7844E-01>,
      <-1.486642E-01, 1.616848E-01>,
      <-1.459154E-01, 1.6612E-01>,
      <-1.486642E-01, 1.459152E-01>,
      <-1.459154E-01, 1.4148E-01>,
      <-1.383663E-01, 1.380304E-01>,
      <-1.375538E-01, 1.459152E-01>,
      <-1.375538E-01, 1.616848E-01>,
      <-1.383663E-01, 1.695696E-01>,
      <-1.393299E-01, 1.616848E-01>,
      <-1.393299E-01, 1.459152E-01>,
      <-1.471163E-01, 1.23E-01>,
      <-1.471163E-01, 1.846E-01>,
      <-1.428835E-01, 1.846E-01>,
      <-1.428835E-01, 1.23E-01>,
      <-1.415543E-01, 1.23E-01>,
      <-1.415543E-01, 1.846E-01>,
      <-1.458302E-01, 1.846E-01>,
      <-1.458302E-01, 1.23E-01>,
      <-2.318553E-01, 1.2916E-01>,
      <-2.376337E-01, 1.380304E-01>,
      <-2.384462E-01, 1.459152E-01>,
      <-2.333577E-01, 1.4148E-01>,
      <-2.384462E-01, 1.616848E-01>,
      <-2.333577E-01, 1.661201E-01>,
      <-2.376337E-01, 1.695696E-01>,
      <-2.318553E-01, 1.7844E-01>,
      <-2.366701E-01, 1.616848E-01>,
      <-2.300846E-01, 1.6612E-01>,
      <-2.366701E-01, 1.459152E-01>,
      <-2.300846E-01, 1.4148E-01>,
      <-2.283177E-01, 1.380304E-01>,
      <-2.292379E-01, 1.459152E-01>,
      <-2.292379E-01, 1.616848E-01>,
      <-2.283177E-01, 1.695696E-01>,
      <-2.273358E-01, 1.616848E-01>,
      <-2.273358E-01, 1.459152E-01>,
      <-2.301699E-01, 1.23E-01>,
      <-2.301699E-01, 1.846E-01>,
      <-2.344457E-01, 1.846E-01>,
      <-2.344457E-01, 1.23E-01>,
      <-2.331165E-01, 1.23E-01>,
      <-2.331165E-01, 1.846E-01>,
      <-2.288837E-01, 1.846E-01>,
      <-2.288837E-01, 1.23E-01>,
      <-1.727553E-01, 1.2916E-01>,
      <-1.692178E-01, 1.380304E-01>,
      <-1.682357E-01, 1.459152E-01>,
      <-1.709846E-01, 1.4148E-01>,
      <-1.682357E-01, 1.616848E-01>,
      <-1.709846E-01, 1.661201E-01>,
      <-1.692178E-01, 1.695696E-01>,
      <-1.727553E-01, 1.7844E-01>,
      <-1.701379E-01, 1.616848E-01>,
      <-1.742576E-01, 1.6612E-01>,
      <-1.701379E-01, 1.459152E-01>,
      <-1.742576E-01, 1.4148E-01>,
      <-1.785337E-01, 1.380304E-01>,
      <-1.7757E-01, 1.459152E-01>,
      <-1.7757E-01, 1.616848E-01>,
      <-1.785337E-01, 1.695696E-01>,
      <-1.793462E-01, 1.616848E-01>,
      <-1.793462E-01, 1.459152E-01>,
      <-1.740165E-01, 1.23E-01>,
      <-1.740165E-01, 1.846E-01>,
      <-1.697837E-01, 1.846E-01>,
      <-1.697837E-01, 1.23E-01>,
      <-1.710699E-01, 1.23E-01>,
      <-1.710699E-01, 1.846E-01>,
      <-1.753457E-01, 1.846E-01>,
      <-1.753457E-01, 1.23E-01>,
      <-2.032447E-01, 1.2916E-01>,
      <-1.974663E-01, 1.380304E-01>,
      <-1.984299E-01, 1.459152E-01>,
      <-2.050154E-01, 1.4148E-01>,
      <-1.984299E-01, 1.616848E-01>,
      <-2.050154E-01, 1.661201E-01>,
      <-1.974663E-01, 1.695696E-01>,
      <-2.032447E-01, 1.7844E-01>,
      <-1.966538E-01, 1.616848E-01>,
      <-2.017424E-01, 1.6612E-01>,
      <-1.966538E-01, 1.459152E-01>,
      <-2.017424E-01, 1.4148E-01>,
      <-2.067822E-01, 1.380304E-01>,
      <-2.077643E-01, 1.459152E-01>,
      <-2.077643E-01, 1.616848E-01>,
      <-2.067822E-01, 1.695696E-01>,
      <-2.05862E-01, 1.616848E-01>,
      <-2.05862E-01, 1.459152E-01>,
      <-2.006543E-01, 1.23E-01>,
      <-2.006543E-01, 1.846E-01>,
      <-2.049301E-01, 1.846E-01>,
      <-2.049301E-01, 1.23E-01>,
      <-2.062163E-01, 1.23E-01>,
      <-2.062163E-01, 1.846E-01>,
      <-2.019835E-01, 1.846E-01>,
      <-2.019835E-01, 1.23E-01>,
      <-2.349674E-01, 1.73512E-01>,
      <-1.6415E-01, 1.846E-01>,
      <-1.34075E-01, 1.691999E-01>,
      <-2.165477E-01, 1.63656E-01>,
      <-1.34075E-01, 1.384E-01>,
      <-2.165477E-01, 1.43944E-01>,
      <-1.6415E-01, 1.23E-01>,
      <-2.349674E-01, 1.34088E-01>,
      <-2.419251E-01, 1.846E-01>,
      <-1.534707E-01, 1.73512E-01>,
      <-1.410326E-01, 1.63656E-01>,
      <-2.189276E-01, 1.691999E-01>,
      <-1.410326E-01, 1.43944E-01>,
      <-2.189276E-01, 1.384E-01>,
      <-1.534707E-01, 1.34088E-01>,
      <-2.419251E-01, 1.23E-01>,
      <-2.361122E-01, 1.73512E-01>,
      <-1.352198E-01, 1.846E-01>,
      <-1.352198E-01, 1.23E-01>,
      <-2.361122E-01, 1.34088E-01>,
      <-1.6415E-01, 1.846E-01>,
      <-1.34075E-01, 1.384E-01>,
      <-2.165477E-01, 1.43944E-01>,
      <-1.6415E-01, 1.23E-01>,
      <-2.349674E-01, 1.34088E-01>,
      <-1.534707E-01, 1.73512E-01>,
      <-1.410326E-01, 1.43944E-01>,
      <-2.189276E-01, 1.384E-01>,
      <-1.534707E-01, 1.34088E-01>,
      <-1.6415E-01, 1.846E-01>,
      <-1.34075E-01, 1.384E-01>,
      <-2.165477E-01, 1.43944E-01>,
      <-1.6415E-01, 1.23E-01>,
      <-2.349674E-01, 1.34088E-01>,
      <-2.225293E-01, 1.73512E-01>,
      <-1.34075E-01, 1.846E-01>,
      <-1.570725E-01, 1.691999E-01>,
      <-2.349674E-01, 1.63656E-01>,
      <-1.570725E-01, 1.384E-01>,
      <-2.349674E-01, 1.43944E-01>,
      <-1.34075E-01, 1.23E-01>,
      <-2.225293E-01, 1.34088E-01>,
      <-2.1185E-01, 1.846E-01>,
      <-1.410326E-01, 1.73512E-01>,
      <-1.594535E-01, 1.63656E-01>,
      <-2.419251E-01, 1.691999E-01>,
      <-1.594535E-01, 1.43944E-01>,
      <-2.419251E-01, 1.384E-01>,
      <-1.410326E-01, 1.34088E-01>,
      <-2.1185E-01, 1.23E-01>,
      <-1.350578E-01, 1.23E-01>,
      <-2.231417E-01, 1.267712E-01>,
      <-2.343971E-01, 1.466167E-01>,
      <-1.521848E-01, 1.540088E-01>,
      <-2.270997E-01, 1.661951E-01>,
      <-1.384602E-01, 1.846001E-01>,
      <-2.225302E-01, 1.34088E-01>,
      <-2.349674E-01, 1.43944E-01>,
      <-2.349674E-01, 1.63656E-01>,
      <-1.570725E-01, 1.692E-01>,
      <-2.225302E-01, 1.73512E-01>,
      <-1.34075E-01, 1.846E-01>,
      <-2.1185E-01, 1.23E-01>,
      <-2.41925E-01, 1.384E-01>,
      <-1.594535E-01, 1.43944E-01>,
      <-2.41925E-01, 1.692E-01>,
      <-1.594535E-01, 1.63656E-01>,
      <-2.1185E-01, 1.846E-01>,
      <-1.410326E-01, 1.73512E-01>,
      <-1.534707E-01, 1.34088E-01>,
      <-2.189275E-01, 1.384E-01>,
      <-1.410326E-01, 1.43944E-01>,
      <-1.534707E-01, 1.73512E-01>,
      <-1.641508E-01, 1.23E-01>,
      <-2.349674E-01, 1.34088E-01>,
      <-2.165468E-01, 1.43944E-01>,
      <-1.34075E-01, 1.384E-01>,
      <-1.641508E-01, 1.846E-01>,
      <-3.045952E-01, 1.289E-01>,
      <-3.045952E-01, 1.836E-01>,
      <-2.579048E-01, 1.836E-01>,
      <-2.579048E-01, 1.289E-01>,
      <-2.976465E-01, 1.289E-01>,
      <-2.976465E-01, 1.836E-01>,
      <-2.648535E-01, 1.836E-01>,
      <-2.648535E-01, 1.289E-01>,
      <-2.579048E-01, 1.289E-01>,
      <-2.976465E-01, 1.289E-01>,
      <-2.648535E-01, 1.289E-01>,
      <-3.206885E-01, 1.309E-01>,
      <-3.206885E-01, 1.836E-01>,
      <-3.639115E-01, 1.836E-01>,
      <-3.639115E-01, 1.309E-01>,
      <-2.660337E-01, 1.299E-01>,
      <-2.660337E-01, 1.797E-01>,
      <-2.993664E-01, 1.797E-01>,
      <-2.993664E-01, 1.299E-01>,
      <-8.364E-01, 2.646E-01>,
      <-8.364E-01, 4.694E-01>,
      <-9.90E-01, 4.694E-01>,
      <-9.90E-01, 2.646E-01>,
      <-8.364E-01, 2.646E-01>,
      <-8.364E-01, 4.694E-01>,
      <-9.90E-01, 4.694E-01>,
      <-9.90E-01, 2.646E-01>,
      <-8.364E-01, 2.646E-01>,
      <-8.364E-01, 4.694E-01>,
      <-9.900001E-01, 4.694E-01>,
      <-9.900001E-01, 2.646E-01>,
      <-8.364001E-01, 2.646E-01>,
      <-8.364001E-01, 4.694E-01>,
      <-9.900001E-01, 4.694E-01>,
      <-9.900001E-01, 2.646E-01>,
      <-8.364E-01, 2.646E-01>,
      <-8.364E-01, 4.694E-01>,
      <-9.900001E-01, 4.694E-01>,
      <-9.900001E-01, 2.646E-01>,
      <-8.364E-01, 2.646E-01>,
      <-8.364E-01, 4.694E-01>,
      <-9.900001E-01, 4.694E-01>,
      <-9.900001E-01, 2.646E-01>,
      <-8.389E-01, 3.109998E-02>,
      <-8.389E-01, 2.121999E-01>,
      <-9.675E-01, 2.121999E-01>,
      <-9.675E-01, 3.109998E-02>,
      <-9.675E-01, 2.121999E-01>,
      <-9.675E-01, 2.121999E-01>,
      <-9.675E-01, 2.121999E-01>,
      <-2.395033E-02, 7.715E-01>,
      <-2.022001E-01, 7.4117E-01>,
      <-1.948081E-01, 7.1421E-01>,
      <-1.240002E-02, 7.293749E-01>,
      <-1.948081E-01, 6.6029E-01>,
      <-1.240002E-02, 6.45125E-01>,
      <-2.022001E-01, 6.3333E-01>,
      <-2.395033E-02, 6.03E-01>,
      <-1.240003E-02, 7.4117E-01>,
      <-1.906493E-01, 7.715E-01>,
      <-2.022E-01, 7.293749E-01>,
      <-1.979241E-02, 7.142099E-01>,
      <-2.022E-01, 6.45125E-01>,
      <-1.979241E-02, 6.602899E-01>,
      <-1.906493E-01, 6.03E-01>,
      <-1.240003E-02, 6.3333E-01>,
      <-1.906493E-01, 6.03E-01>,
      <-1.906497E-01, 6.03E-01>,
      <-6.485498E-01, 7.553E-01>,
      <-5.63E-01, 7.937E-01>,
      <-5.63E-01, 8.704999E-01>,
      <-6.485498E-01, 9.089E-01>,
      <-7.341E-01, 8.705E-01>,
      <-7.341E-01, 7.937E-01>,
      <-6.485498E-01, 7.553E-01>,
      <-5.63E-01, 7.936999E-01>,
      <-5.63E-01, 8.705E-01>,
      <-6.485498E-01, 9.089E-01>,
      <-7.341E-01, 7.936999E-01>,
      <-6.4855E-01, 7.553E-01>,
      <-5.63E-01, 7.936999E-01>,
      <-5.63E-01, 8.705E-01>,
      <-6.4855E-01, 9.089E-01>,
      <-7.341E-01, 7.936999E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      176, 
      <0, 6, 7>, 0,
      <0, 7, 1>, 0,
      <1, 7, 8>, 0,
      <1, 8, 2>, 0,
      <2, 8, 9>, 0,
      <2, 9, 3>, 0,
      <3, 9, 10>, 0,
      <3, 10, 4>, 0,
      <4, 10, 11>, 0,
      <4, 11, 5>, 0,
      <5, 11, 6>, 0,
      <5, 6, 0>, 0,
      <6, 11, 10>, 0,
      <6, 10, 9>, 0,
      <6, 9, 8>, 0,
      <6, 8, 7>, 0,
      <12, 13, 14>, 0,
      <12, 14, 15>, 0,
      <12, 15, 16>, 0,
      <12, 16, 17>, 0,
      <12, 0, 1>, 0,
      <12, 1, 13>, 0,
      <13, 1, 2>, 0,
      <13, 2, 14>, 0,
      <14, 2, 3>, 0,
      <14, 3, 15>, 0,
      <15, 3, 4>, 0,
      <15, 4, 16>, 0,
      <16, 4, 5>, 0,
      <16, 5, 17>, 0,
      <17, 5, 0>, 0,
      <17, 0, 12>, 0,
      <18, 19, 20>, 0,
      <18, 20, 21>, 0,
      <22, 23, 24>, 0,
      <22, 24, 25>, 0,
      <21, 20, 23>, 0,
      <21, 23, 22>, 0,
      <25, 24, 19>, 0,
      <25, 19, 18>, 0,
      <19, 24, 23>, 0,
      <19, 23, 20>, 0,
      <21, 22, 25>, 0,
      <21, 25, 18>, 0,
      <26, 32, 33>, 0,
      <26, 33, 27>, 0,
      <27, 33, 34>, 0,
      <27, 34, 28>, 0,
      <28, 34, 35>, 0,
      <28, 35, 29>, 0,
      <29, 35, 36>, 0,
      <29, 36, 30>, 0,
      <30, 36, 37>, 0,
      <30, 37, 31>, 0,
      <31, 37, 32>, 0,
      <31, 32, 26>, 0,
      <32, 37, 36>, 0,
      <32, 36, 35>, 0,
      <32, 35, 34>, 0,
      <32, 34, 33>, 0,
      <38, 39, 40>, 0,
      <38, 40, 41>, 0,
      <38, 41, 42>, 0,
      <38, 42, 43>, 0,
      <38, 26, 27>, 0,
      <38, 27, 39>, 0,
      <39, 27, 28>, 0,
      <39, 28, 40>, 0,
      <40, 28, 29>, 0,
      <40, 29, 41>, 0,
      <41, 29, 30>, 0,
      <41, 30, 42>, 0,
      <42, 30, 31>, 0,
      <42, 31, 43>, 0,
      <43, 31, 26>, 0,
      <43, 26, 38>, 0,
      <44, 45, 46>, 0,
      <44, 46, 47>, 0,
      <48, 49, 50>, 0,
      <48, 50, 51>, 0,
      <47, 46, 49>, 0,
      <47, 49, 48>, 0,
      <51, 50, 45>, 0,
      <51, 45, 44>, 0,
      <45, 50, 49>, 0,
      <45, 49, 46>, 0,
      <47, 48, 51>, 0,
      <47, 51, 44>, 0,
      <52, 58, 59>, 0,
      <52, 59, 53>, 0,
      <53, 59, 60>, 0,
      <53, 60, 54>, 0,
      <54, 60, 61>, 0,
      <54, 61, 55>, 0,
      <55, 61, 62>, 0,
      <55, 62, 56>, 0,
      <56, 62, 63>, 0,
      <56, 63, 57>, 0,
      <57, 63, 58>, 0,
      <57, 58, 52>, 0,
      <58, 63, 62>, 0,
      <58, 62, 61>, 0,
      <58, 61, 60>, 0,
      <58, 60, 59>, 0,
      <64, 65, 66>, 0,
      <64, 66, 67>, 0,
      <64, 67, 68>, 0,
      <64, 68, 69>, 0,
      <64, 52, 53>, 0,
      <64, 53, 65>, 0,
      <65, 53, 54>, 0,
      <65, 54, 66>, 0,
      <66, 54, 55>, 0,
      <66, 55, 67>, 0,
      <67, 55, 56>, 0,
      <67, 56, 68>, 0,
      <68, 56, 57>, 0,
      <68, 57, 69>, 0,
      <69, 57, 52>, 0,
      <69, 52, 64>, 0,
      <70, 71, 72>, 0,
      <70, 72, 73>, 0,
      <74, 75, 76>, 0,
      <74, 76, 77>, 0,
      <73, 72, 75>, 0,
      <73, 75, 74>, 0,
      <77, 76, 71>, 0,
      <77, 71, 70>, 0,
      <71, 76, 75>, 0,
      <71, 75, 72>, 0,
      <73, 74, 77>, 0,
      <73, 77, 70>, 0,
      <78, 84, 85>, 0,
      <78, 85, 79>, 0,
      <79, 85, 86>, 0,
      <79, 86, 80>, 0,
      <80, 86, 87>, 0,
      <80, 87, 81>, 0,
      <81, 87, 88>, 0,
      <81, 88, 82>, 0,
      <82, 88, 89>, 0,
      <82, 89, 83>, 0,
      <83, 89, 84>, 0,
      <83, 84, 78>, 0,
      <84, 89, 88>, 0,
      <84, 88, 87>, 0,
      <84, 87, 86>, 0,
      <84, 86, 85>, 0,
      <90, 91, 92>, 0,
      <90, 92, 93>, 0,
      <90, 93, 94>, 0,
      <90, 94, 95>, 0,
      <90, 78, 79>, 0,
      <90, 79, 91>, 0,
      <91, 79, 80>, 0,
      <91, 80, 92>, 0,
      <92, 80, 81>, 0,
      <92, 81, 93>, 0,
      <93, 81, 82>, 0,
      <93, 82, 94>, 0,
      <94, 82, 83>, 0,
      <94, 83, 95>, 0,
      <95, 83, 78>, 0,
      <95, 78, 90>, 0,
      <96, 97, 98>, 0,
      <96, 98, 99>, 0,
      <100, 101, 102>, 0,
      <100, 102, 103>, 0,
      <99, 98, 101>, 0,
      <99, 101, 100>, 0,
      <103, 102, 97>, 0,
      <103, 97, 96>, 0,
      <97, 102, 101>, 0,
      <97, 101, 98>, 0,
      <99, 100, 103>, 0,
      <99, 103, 96>, 0
   }
 
   normal_indices { 
      176, 
      <0, 1, 2>,
      <0, 2, 3>,
      <4, 2, 5>,
      <4, 5, 6>,
      <7, 5, 8>,
      <7, 8, 9>,
      <10, 8, 11>,
      <10, 11, 12>,
      <13, 11, 14>,
      <13, 14, 15>,
      <16, 14, 1>,
      <16, 1, 17>,
      <18, 18, 18>,
      <18, 18, 18>,
      <18, 18, 18>,
      <18, 18, 18>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <20, 21, 22>,
      <20, 22, 23>,
      <23, 24, 25>,
      <23, 25, 26>,
      <26, 27, 28>,
      <26, 28, 29>,
      <29, 30, 31>,
      <29, 31, 32>,
      <32, 33, 34>,
      <32, 34, 35>,
      <35, 36, 37>,
      <35, 37, 20>,
      <18, 18, 18>,
      <18, 18, 18>,
      <19, 19, 19>,
      <19, 19, 19>,
      <38, 38, 38>,
      <38, 38, 38>,
      <39, 39, 39>,
      <39, 39, 39>,
      <40, 40, 40>,
      <40, 40, 40>,
      <41, 41, 41>,
      <41, 41, 41>,
      <0, 1, 2>,
      <0, 2, 3>,
      <4, 2, 5>,
      <4, 5, 6>,
      <7, 5, 8>,
      <7, 8, 9>,
      <10, 8, 11>,
      <10, 11, 12>,
      <13, 11, 14>,
      <13, 14, 15>,
      <16, 14, 1>,
      <16, 1, 17>,
      <18, 18, 18>,
      <18, 18, 18>,
      <18, 18, 18>,
      <18, 18, 18>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <20, 21, 22>,
      <20, 22, 23>,
      <23, 24, 25>,
      <23, 25, 26>,
      <26, 27, 28>,
      <26, 28, 29>,
      <29, 30, 31>,
      <29, 31, 32>,
      <32, 33, 34>,
      <32, 34, 35>,
      <35, 36, 37>,
      <35, 37, 20>,
      <18, 18, 18>,
      <18, 18, 18>,
      <19, 19, 19>,
      <19, 19, 19>,
      <38, 38, 38>,
      <38, 38, 38>,
      <39, 39, 39>,
      <39, 39, 39>,
      <40, 40, 40>,
      <40, 40, 40>,
      <41, 41, 41>,
      <41, 41, 41>,
      <0, 1, 2>,
      <0, 2, 3>,
      <4, 2, 5>,
      <4, 5, 6>,
      <7, 5, 8>,
      <7, 8, 9>,
      <10, 8, 11>,
      <10, 11, 12>,
      <13, 11, 14>,
      <13, 14, 15>,
      <16, 14, 1>,
      <16, 1, 17>,
      <18, 18, 18>,
      <18, 18, 18>,
      <18, 18, 18>,
      <18, 18, 18>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <20, 21, 22>,
      <20, 22, 23>,
      <23, 24, 25>,
      <23, 25, 26>,
      <26, 27, 28>,
      <26, 28, 29>,
      <29, 30, 31>,
      <29, 31, 32>,
      <32, 33, 34>,
      <32, 34, 35>,
      <35, 36, 37>,
      <35, 37, 20>,
      <18, 18, 18>,
      <18, 18, 18>,
      <19, 19, 19>,
      <19, 19, 19>,
      <38, 38, 38>,
      <38, 38, 38>,
      <39, 39, 39>,
      <39, 39, 39>,
      <40, 40, 40>,
      <40, 40, 40>,
      <41, 41, 41>,
      <41, 41, 41>,
      <0, 1, 2>,
      <0, 2, 3>,
      <4, 2, 5>,
      <4, 5, 6>,
      <7, 5, 8>,
      <7, 8, 9>,
      <10, 8, 11>,
      <10, 11, 12>,
      <13, 11, 14>,
      <13, 14, 15>,
      <16, 14, 1>,
      <16, 1, 17>,
      <18, 18, 18>,
      <18, 18, 18>,
      <18, 18, 18>,
      <18, 18, 18>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <20, 21, 22>,
      <20, 22, 23>,
      <23, 24, 25>,
      <23, 25, 26>,
      <26, 27, 28>,
      <26, 28, 29>,
      <29, 30, 31>,
      <29, 31, 32>,
      <32, 33, 34>,
      <32, 34, 35>,
      <35, 36, 37>,
      <35, 37, 20>,
      <18, 18, 18>,
      <18, 18, 18>,
      <19, 19, 19>,
      <19, 19, 19>,
      <38, 38, 38>,
      <38, 38, 38>,
      <39, 39, 39>,
      <39, 39, 39>,
      <40, 40, 40>,
      <40, 40, 40>,
      <41, 41, 41>,
      <41, 41, 41>
   }
 
   uv_indices { 
      176, 
      <257, 255, 253>,
      <257, 253, 252>,
      <252, 253, 251>,
      <252, 251, 250>,
      <250, 251, 248>,
      <250, 248, 249>,
      <240, 241, 242>,
      <240, 242, 243>,
      <243, 242, 244>,
      <243, 244, 245>,
      <245, 244, 246>,
      <245, 246, 247>,
      <258, 259, 260>,
      <258, 260, 261>,
      <258, 261, 262>,
      <258, 262, 263>,
      <269, 270, 271>,
      <269, 271, 272>,
      <269, 272, 262>,
      <269, 262, 273>,
      <246, 247, 245>,
      <246, 245, 244>,
      <244, 245, 243>,
      <244, 243, 242>,
      <242, 243, 240>,
      <242, 240, 241>,
      <248, 249, 250>,
      <248, 250, 251>,
      <251, 250, 252>,
      <251, 252, 253>,
      <253, 252, 254>,
      <253, 254, 255>,
      <233, 234, 239>,
      <233, 239, 236>,
      <233, 234, 238>,
      <233, 238, 236>,
      <213, 214, 215>,
      <213, 215, 216>,
      <225, 226, 227>,
      <225, 227, 228>,
      <225, 226, 227>,
      <225, 227, 228>,
      <217, 218, 219>,
      <217, 219, 220>,
      <257, 255, 253>,
      <257, 253, 252>,
      <252, 253, 251>,
      <252, 251, 250>,
      <250, 251, 248>,
      <250, 248, 249>,
      <240, 241, 242>,
      <240, 242, 243>,
      <243, 242, 244>,
      <243, 244, 245>,
      <245, 244, 246>,
      <245, 246, 247>,
      <258, 259, 260>,
      <258, 260, 261>,
      <258, 261, 262>,
      <258, 262, 263>,
      <264, 265, 266>,
      <264, 266, 267>,
      <264, 267, 262>,
      <264, 262, 268>,
      <246, 247, 245>,
      <246, 245, 244>,
      <244, 245, 243>,
      <244, 243, 242>,
      <242, 243, 240>,
      <242, 240, 241>,
      <248, 249, 250>,
      <248, 250, 251>,
      <251, 250, 252>,
      <251, 252, 253>,
      <253, 252, 256>,
      <253, 256, 255>,
      <233, 234, 239>,
      <233, 239, 236>,
      <233, 234, 237>,
      <233, 237, 236>,
      <209, 210, 211>,
      <209, 211, 212>,
      <217, 218, 219>,
      <217, 219, 220>,
      <217, 218, 219>,
      <217, 219, 220>,
      <209, 210, 211>,
      <209, 211, 212>,
      <257, 255, 253>,
      <257, 253, 252>,
      <252, 253, 251>,
      <252, 251, 250>,
      <250, 251, 248>,
      <250, 248, 249>,
      <240, 241, 242>,
      <240, 242, 243>,
      <243, 242, 244>,
      <243, 244, 245>,
      <245, 244, 246>,
      <245, 246, 247>,
      <258, 259, 260>,
      <258, 260, 261>,
      <258, 261, 262>,
      <258, 262, 263>,
      <264, 265, 266>,
      <264, 266, 267>,
      <264, 267, 262>,
      <264, 262, 268>,
      <246, 247, 245>,
      <246, 245, 244>,
      <244, 245, 243>,
      <244, 243, 242>,
      <242, 243, 240>,
      <242, 240, 241>,
      <248, 249, 250>,
      <248, 250, 251>,
      <251, 250, 252>,
      <251, 252, 253>,
      <253, 252, 254>,
      <253, 254, 255>,
      <233, 234, 239>,
      <233, 239, 236>,
      <233, 234, 239>,
      <233, 239, 236>,
      <213, 214, 215>,
      <213, 215, 216>,
      <229, 230, 231>,
      <229, 231, 232>,
      <229, 230, 231>,
      <229, 231, 232>,
      <213, 214, 215>,
      <213, 215, 216>,
      <257, 255, 253>,
      <257, 253, 252>,
      <252, 253, 251>,
      <252, 251, 250>,
      <250, 251, 248>,
      <250, 248, 249>,
      <240, 241, 242>,
      <240, 242, 243>,
      <243, 242, 244>,
      <243, 244, 245>,
      <245, 244, 246>,
      <245, 246, 247>,
      <258, 259, 260>,
      <258, 260, 261>,
      <258, 261, 262>,
      <258, 262, 263>,
      <269, 270, 271>,
      <269, 271, 272>,
      <269, 272, 262>,
      <269, 262, 273>,
      <246, 247, 245>,
      <246, 245, 244>,
      <244, 245, 243>,
      <244, 243, 242>,
      <242, 243, 240>,
      <242, 240, 241>,
      <248, 249, 250>,
      <248, 250, 251>,
      <251, 250, 252>,
      <251, 252, 253>,
      <253, 252, 256>,
      <253, 256, 255>,
      <233, 234, 239>,
      <233, 239, 236>,
      <233, 234, 235>,
      <233, 235, 236>,
      <213, 214, 215>,
      <213, 215, 216>,
      <221, 222, 223>,
      <221, 223, 224>,
      <221, 222, 223>,
      <221, 223, 224>,
      <213, 214, 215>,
      <213, 215, 216>
   }
   uv_mapping
}
 
// Shock_Cyl_b21
mesh2 {
 
   vertex_vectors { 
      12, 
      <4.465678E+00, 3.392359E+00, -2.070082E+00>,
      <4.249172E+00, 3.392359E+00, -1.923207E+00>,
      <4.249172E+00, 3.392359E+00, -1.629457E+00>,
      <4.465677E+00, 3.392359E+00, -1.482582E+00>,
      <4.682182E+00, 3.392359E+00, -1.629457E+00>,
      <4.682182E+00, 3.392359E+00, -1.923207E+00>,
      <4.465678E+00, 2.217359E+00, -2.070082E+00>,
      <4.249172E+00, 2.217359E+00, -1.923207E+00>,
      <4.249172E+00, 2.217359E+00, -1.629457E+00>,
      <4.465677E+00, 2.217359E+00, -1.482582E+00>,
      <4.682182E+00, 2.217359E+00, -1.629457E+00>,
      <4.682182E+00, 2.217359E+00, -1.923207E+00>
   }
 
   normal_vectors { 
      10, 
      <-5.000014E-01, -3.166497E-08, -8.660246E-01>,
      <-8.660257E-01, -3.166496E-08, -4.999994E-01>,
      <-8.660261E-01, -3.166497E-08, 4.999989E-01>,
      <-5.00002E-01, -3.166497E-08, 8.660242E-01>,
      <5.000013E-01, -3.166496E-08, 8.660247E-01>,
      <8.660257E-01, -3.166497E-08, 4.999995E-01>,
      <8.66026E-01, -3.166497E-08, -4.99999E-01>,
      <5.000018E-01, -3.166497E-08, -8.660244E-01>,
      <1.104931E-16, -1.00E+00, 2.459337E-16>,
      <-1.104931E-16, 9.999999E-01, -2.459337E-16>
   }
 
   uv_vectors { 
      25, 
      <0.00E+00, 0.00E+00>,
      <-1.09625E-01, 1.865001E-01>,
      <-1.09625E-01, 1.152E-01>,
      <-1.205416E-01, 1.152E-01>,
      <-1.205416E-01, 1.865001E-01>,
      <-6.595832E-02, 1.152E-01>,
      <-6.595832E-02, 1.865001E-01>,
      <-7.687497E-02, 1.152E-01>,
      <-7.687497E-02, 1.865001E-01>,
      <-8.779162E-02, 1.152E-01>,
      <-8.779162E-02, 1.865001E-01>,
      <-9.870833E-02, 1.152E-01>,
      <-9.870833E-02, 1.865001E-01>,
      <-3.888E-01, 1.00E+00>,
      <-3.888E-01, 7.091E-01>,
      <-4.266666E-01, 7.091E-01>,
      <-4.266666E-01, 1.00E+00>,
      <-2.373334E-01, 7.091E-01>,
      <-2.373334E-01, 1.00E+00>,
      <-2.751999E-01, 7.091E-01>,
      <-2.751999E-01, 1.00E+00>,
      <-3.130665E-01, 7.091E-01>,
      <-3.130665E-01, 1.00E+00>,
      <-3.509334E-01, 7.091E-01>,
      <-3.509334E-01, 1.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      20, 
      <0, 6, 7>, 0,
      <0, 7, 1>, 0,
      <1, 7, 8>, 0,
      <1, 8, 2>, 0,
      <2, 8, 9>, 0,
      <2, 9, 3>, 0,
      <3, 9, 10>, 0,
      <3, 10, 4>, 0,
      <4, 10, 11>, 0,
      <4, 11, 5>, 0,
      <5, 11, 6>, 0,
      <5, 6, 0>, 0,
      <6, 11, 10>, 0,
      <6, 10, 9>, 0,
      <6, 9, 8>, 0,
      <6, 8, 7>, 0,
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <0, 3, 4>, 0,
      <0, 4, 5>, 0
   }
 
   normal_indices { 
      20, 
      <0, 0, 1>,
      <0, 1, 1>,
      <1, 1, 2>,
      <1, 2, 2>,
      <2, 2, 3>,
      <2, 3, 3>,
      <4, 4, 5>,
      <4, 5, 5>,
      <5, 5, 6>,
      <5, 6, 6>,
      <6, 6, 7>,
      <6, 7, 7>,
      <8, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>
   }
 
   uv_indices { 
      20, 
      <13, 14, 15>,
      <13, 15, 16>,
      <16, 15, 17>,
      <16, 17, 18>,
      <18, 17, 19>,
      <18, 19, 20>,
      <20, 19, 21>,
      <20, 21, 22>,
      <22, 21, 23>,
      <22, 23, 24>,
      <24, 23, 14>,
      <24, 14, 13>,
      <14, 23, 21>,
      <14, 21, 19>,
      <14, 19, 17>,
      <14, 17, 15>,
      <13, 16, 18>,
      <13, 18, 20>,
      <13, 20, 22>,
      <13, 22, 24>
   }
   uv_mapping
}
 
// Shock_Cube_b21
mesh2 {
 
   vertex_vectors { 
      24, 
      <4.565676E+00, 2.209742E+00, -2.148575E+00>,
      <4.565676E+00, 3.267242E+00, -2.148575E+00>,
      <4.365679E+00, 3.267242E+00, -2.148575E+00>,
      <4.365679E+00, 2.209742E+00, -2.148575E+00>,
      <4.365679E+00, 2.209742E+00, -2.374903E+00>,
      <4.365679E+00, 3.267242E+00, -2.374903E+00>,
      <4.565676E+00, 3.267242E+00, -2.374903E+00>,
      <4.565676E+00, 2.209742E+00, -2.374903E+00>,
      <4.365677E+00, 2.022695E+00, -2.022399E+00>,
      <4.365677E+00, 2.022695E+00, -2.374903E+00>,
      <4.565678E+00, 2.022695E+00, -2.374903E+00>,
      <4.565678E+00, 2.022695E+00, -2.022399E+00>,
      <4.565678E+00, 2.022695E+00, -1.6699E+00>,
      <4.565676E+00, 2.209742E+00, -1.6699E+00>,
      <4.365679E+00, 2.209742E+00, -1.6699E+00>,
      <4.365677E+00, 2.022695E+00, -1.6699E+00>,
      <4.365677E+00, 2.022695E+00, -2.257405E+00>,
      <4.565678E+00, 2.022695E+00, -2.257405E+00>,
      <4.365679E+00, 2.140195E+00, -2.374903E+00>,
      <4.565676E+00, 2.140195E+00, -2.374903E+00>,
      <4.565676E+00, 2.140195E+00, -1.6699E+00>,
      <4.365679E+00, 2.140195E+00, -1.6699E+00>,
      <4.365677E+00, 2.022695E+00, -1.787399E+00>,
      <4.565678E+00, 2.022695E+00, -1.787399E+00>
   }
 
   normal_vectors { 
      10, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104931E-16, 9.999999E-01, -2.459337E-16>,
      <1.104931E-16, -1.00E+00, 2.459337E-16>,
      <1.246954E-07, -9.238779E-01, -3.826876E-01>,
      <3.010387E-07, -3.826793E-01, -9.238812E-01>,
      <-3.010387E-07, -3.826795E-01, 9.238812E-01>,
      <-1.246954E-07, -9.23878E-01, 3.826874E-01>
   }
 
   uv_vectors { 
      92, 
      <0.00E+00, 0.00E+00>,
      <-2.781919E-01, 4.623127E-02>,
      <-2.781919E-01, 6.449997E-02>,
      <-2.832E-01, 4.623127E-02>,
      <-2.832E-01, 6.449997E-02>,
      <-2.676E-01, 4.623127E-02>,
      <-2.754E-01, 4.299998E-02>,
      <-2.806001E-01, 4.299998E-02>,
      <-2.832E-01, 4.502982E-02>,
      <-2.676E-01, 4.502982E-02>,
      <-2.702E-01, 4.299998E-02>,
      <-2.04565E-01, 1.769602E-02>,
      <-2.04565E-01, 3.52E-02>,
      <-2.08E-01, 1.769602E-02>,
      <-2.08E-01, 3.52E-02>,
      <-1.973E-01, 1.769602E-02>,
      <-2.0265E-01, 1.459998E-02>,
      <-2.062167E-01, 1.459998E-02>,
      <-2.08E-01, 1.654488E-02>,
      <-1.973E-01, 1.654488E-02>,
      <-1.990833E-01, 1.459998E-02>,
      <-2.795769E-01, 1.318E-01>,
      <-2.932338E-01, 1.807E-01>,
      <-3.003542E-01, 1.807E-01>,
      <-3.003542E-01, 1.625181E-01>,
      <-2.979939E-01, 1.318E-01>,
      <-2.588001E-01, 1.807E-01>,
      <-2.611606E-01, 1.318E-01>,
      <-2.588001E-01, 1.625181E-01>,
      <-2.588001E-01, 1.318E-01>,
      <-3.003542E-01, 1.318E-01>,
      <-3.218501E-01, 1.328E-01>,
      <-3.218501E-01, 1.777E-01>,
      <-3.665498E-01, 1.777E-01>,
      <-3.665498E-01, 1.328E-01>,
      <-3.207791E-01, 1.328E-01>,
      <-3.207791E-01, 1.777E-01>,
      <-3.676208E-01, 1.777E-01>,
      <-3.676208E-01, 1.328E-01>,
      <-3.206382E-01, 1.777E-01>,
      <-3.677617E-01, 1.777E-01>,
      <-3.677617E-01, 1.363867E-01>,
      <-3.206382E-01, 1.363867E-01>,
      <-3.665498E-01, 1.328E-01>,
      <-3.25088E-01, 1.552498E-01>,
      <-3.25088E-01, 1.702168E-01>,
      <-3.633119E-01, 1.702168E-01>,
      <-3.633119E-01, 1.552498E-01>,
      <-3.207791E-01, 1.777E-01>,
      <-3.676208E-01, 1.777E-01>,
      <-3.25088E-01, 1.402832E-01>,
      <-3.633119E-01, 1.402832E-01>,
      <-3.676208E-01, 1.328E-01>,
      <-3.207791E-01, 1.328E-01>,
      <-3.258846E-01, 1.648718E-01>,
      <-3.243587E-01, 1.777E-01>,
      <-3.640411E-01, 1.777E-01>,
      <-3.625149E-01, 1.648718E-01>,
      <-3.666089E-01, 1.342221E-01>,
      <-3.21791E-01, 1.342221E-01>,
      <-2.62165E-01, 1.299E-01>,
      <-2.62165E-01, 1.797E-01>,
      <-3.104998E-01, 1.797E-01>,
      <-3.104998E-01, 1.299E-01>,
      <-2.649105E-01, 1.299E-01>,
      <-2.62165E-01, 1.611837E-01>,
      <-2.704474E-01, 1.797E-01>,
      <-2.863327E-01, 1.299E-01>,
      <-3.104998E-01, 1.611837E-01>,
      <-3.077542E-01, 1.299E-01>,
      <-8.427014E-01, 4.931485E-02>,
      <-8.427014E-01, 2.371E-01>,
      <-9.874986E-01, 2.371E-01>,
      <-9.874986E-01, 4.931485E-02>,
      <-9.875E-01, 1.609999E-02>,
      <-8.427E-01, 1.609999E-02>,
      <-9.874986E-01, 3.696501E-02>,
      <-8.427014E-01, 3.696501E-02>,
      <-9.925E-01, 2.954225E-01>,
      <-9.925E-01, 4.906E-01>,
      <-9.399793E-01, 4.906E-01>,
      <-9.399793E-01, 2.954225E-01>,
      <-9.652339E-01, 2.609E-01>,
      <-9.925E-01, 2.825865E-01>,
      <-9.106995E-01, 2.609E-01>,
      <-8.289E-01, 2.825865E-01>,
      <-8.561661E-01, 2.609E-01>,
      <-8.289E-01, 2.954225E-01>,
      <-8.439E-01, 1.120002E-02>,
      <-8.439E-01, 2.371E-01>,
      <-9.80E-01, 2.371E-01>,
      <-9.80E-01, 1.120002E-02>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      36, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <13, 0, 3>, 0,
      <13, 3, 14>, 0,
      <8, 16, 17>, 0,
      <8, 17, 11>, 0,
      <18, 4, 7>, 0,
      <18, 7, 19>, 0,
      <17, 16, 18>, 0,
      <17, 18, 19>, 0,
      <8, 3, 4>, 0,
      <8, 4, 18>, 0,
      <8, 18, 16>, 0,
      <17, 19, 7>, 0,
      <17, 7, 0>, 0,
      <17, 0, 11>, 0,
      <20, 13, 14>, 0,
      <20, 14, 21>, 0,
      <22, 8, 11>, 0,
      <22, 11, 23>, 0,
      <20, 21, 22>, 0,
      <20, 22, 23>, 0,
      <20, 23, 11>, 0,
      <20, 11, 0>, 0,
      <20, 0, 13>, 0,
      <14, 3, 8>, 0,
      <14, 8, 22>, 0,
      <14, 22, 21>, 0
   }
 
   normal_indices { 
      36, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <6, 6, 7>,
      <6, 7, 7>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <8, 0, 0>,
      <8, 0, 8>,
      <9, 5, 5>,
      <9, 5, 9>,
      <8, 8, 9>,
      <8, 9, 9>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 2>
   }
 
   uv_indices { 
      36, 
      <88, 89, 90>,
      <88, 90, 91>,
      <73, 72, 71>,
      <73, 71, 70>,
      <73, 72, 72>,
      <73, 72, 73>,
      <78, 79, 80>,
      <78, 80, 81>,
      <71, 71, 72>,
      <71, 72, 72>,
      <88, 89, 90>,
      <88, 90, 91>,
      <74, 74, 75>,
      <74, 75, 75>,
      <76, 73, 70>,
      <76, 70, 77>,
      <75, 74, 76>,
      <75, 76, 77>,
      <74, 73, 73>,
      <74, 73, 76>,
      <74, 76, 74>,
      <82, 83, 78>,
      <82, 78, 81>,
      <82, 81, 84>,
      <88, 89, 90>,
      <88, 90, 91>,
      <74, 74, 75>,
      <74, 75, 75>,
      <77, 76, 74>,
      <77, 74, 75>,
      <85, 86, 84>,
      <85, 84, 81>,
      <85, 81, 87>,
      <73, 73, 74>,
      <73, 74, 74>,
      <73, 74, 76>
   }
   uv_mapping
}
 
// Shock_Cyl_b22
mesh2 {
 
   vertex_vectors { 
      12, 
      <4.465673E+00, 3.392359E+00, 1.1214E+01>,
      <4.682178E+00, 3.392359E+00, 1.106713E+01>,
      <4.682178E+00, 3.392359E+00, 1.077338E+01>,
      <4.465673E+00, 3.392359E+00, 1.06265E+01>,
      <4.249168E+00, 3.392359E+00, 1.077338E+01>,
      <4.249168E+00, 3.392359E+00, 1.106713E+01>,
      <4.465673E+00, 2.217359E+00, 1.1214E+01>,
      <4.682178E+00, 2.217359E+00, 1.106713E+01>,
      <4.682178E+00, 2.217359E+00, 1.077338E+01>,
      <4.465673E+00, 2.217359E+00, 1.06265E+01>,
      <4.249168E+00, 2.217359E+00, 1.077338E+01>,
      <4.249168E+00, 2.217359E+00, 1.106713E+01>
   }
 
   normal_vectors { 
      10, 
      <5.000013E-01, -3.166496E-08, 8.660247E-01>,
      <8.660257E-01, -3.166497E-08, 4.999995E-01>,
      <8.66026E-01, -3.166497E-08, -4.99999E-01>,
      <5.000018E-01, -3.166497E-08, -8.660244E-01>,
      <-5.000014E-01, -3.166497E-08, -8.660246E-01>,
      <-8.660257E-01, -3.166496E-08, -4.999994E-01>,
      <-8.660261E-01, -3.166497E-08, 4.999989E-01>,
      <-5.00002E-01, -3.166497E-08, 8.660242E-01>,
      <1.104931E-16, -1.00E+00, 2.459337E-16>,
      <-1.104931E-16, 9.999999E-01, -2.459337E-16>
   }
 
   uv_vectors { 
      25, 
      <0.00E+00, 0.00E+00>,
      <-7.687497E-02, 1.865001E-01>,
      <-7.687497E-02, 1.152E-01>,
      <-8.779162E-02, 1.152E-01>,
      <-8.779162E-02, 1.865001E-01>,
      <-9.870833E-02, 1.152E-01>,
      <-9.870833E-02, 1.865001E-01>,
      <-1.09625E-01, 1.152E-01>,
      <-1.09625E-01, 1.865001E-01>,
      <-1.205416E-01, 1.152E-01>,
      <-1.205416E-01, 1.865001E-01>,
      <-6.595832E-02, 1.152E-01>,
      <-6.595832E-02, 1.865001E-01>,
      <-2.751999E-01, 1.00E+00>,
      <-2.751999E-01, 7.091E-01>,
      <-3.130665E-01, 7.091E-01>,
      <-3.130665E-01, 1.00E+00>,
      <-3.509334E-01, 7.091E-01>,
      <-3.509334E-01, 1.00E+00>,
      <-3.888E-01, 7.091E-01>,
      <-3.888E-01, 1.00E+00>,
      <-4.266666E-01, 7.091E-01>,
      <-4.266666E-01, 1.00E+00>,
      <-2.373334E-01, 7.091E-01>,
      <-2.373334E-01, 1.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      20, 
      <0, 6, 7>, 0,
      <0, 7, 1>, 0,
      <1, 7, 8>, 0,
      <1, 8, 2>, 0,
      <2, 8, 9>, 0,
      <2, 9, 3>, 0,
      <3, 9, 10>, 0,
      <3, 10, 4>, 0,
      <4, 10, 11>, 0,
      <4, 11, 5>, 0,
      <5, 11, 6>, 0,
      <5, 6, 0>, 0,
      <6, 11, 10>, 0,
      <6, 10, 9>, 0,
      <6, 9, 8>, 0,
      <6, 8, 7>, 0,
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <0, 3, 4>, 0,
      <0, 4, 5>, 0
   }
 
   normal_indices { 
      20, 
      <0, 0, 1>,
      <0, 1, 1>,
      <1, 1, 2>,
      <1, 2, 2>,
      <2, 2, 3>,
      <2, 3, 3>,
      <4, 4, 5>,
      <4, 5, 5>,
      <5, 5, 6>,
      <5, 6, 6>,
      <6, 6, 7>,
      <6, 7, 7>,
      <8, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>
   }
 
   uv_indices { 
      20, 
      <13, 14, 15>,
      <13, 15, 16>,
      <16, 15, 17>,
      <16, 17, 18>,
      <18, 17, 19>,
      <18, 19, 20>,
      <20, 19, 21>,
      <20, 21, 22>,
      <22, 21, 23>,
      <22, 23, 24>,
      <24, 23, 14>,
      <24, 14, 13>,
      <14, 23, 21>,
      <14, 21, 19>,
      <14, 19, 17>,
      <14, 17, 15>,
      <13, 16, 18>,
      <13, 18, 20>,
      <13, 20, 22>,
      <13, 22, 24>
   }
   uv_mapping
}
 
// Shock_Cube_b22
mesh2 {
 
   vertex_vectors { 
      24, 
      <4.365674E+00, 2.209742E+00, 1.12925E+01>,
      <4.365674E+00, 3.267242E+00, 1.12925E+01>,
      <4.565671E+00, 3.267242E+00, 1.12925E+01>,
      <4.565671E+00, 2.209742E+00, 1.12925E+01>,
      <4.565671E+00, 2.209742E+00, 1.151882E+01>,
      <4.565671E+00, 3.267242E+00, 1.151882E+01>,
      <4.365674E+00, 3.267242E+00, 1.151882E+01>,
      <4.365674E+00, 2.209742E+00, 1.151882E+01>,
      <4.565673E+00, 2.022695E+00, 1.116632E+01>,
      <4.565673E+00, 2.022695E+00, 1.151882E+01>,
      <4.365673E+00, 2.022695E+00, 1.151882E+01>,
      <4.365673E+00, 2.022695E+00, 1.116632E+01>,
      <4.365673E+00, 2.022695E+00, 1.081382E+01>,
      <4.365675E+00, 2.209742E+00, 1.081382E+01>,
      <4.565672E+00, 2.209742E+00, 1.081382E+01>,
      <4.565674E+00, 2.022695E+00, 1.081382E+01>,
      <4.565673E+00, 2.022695E+00, 1.140133E+01>,
      <4.365673E+00, 2.022695E+00, 1.140133E+01>,
      <4.565671E+00, 2.140195E+00, 1.151882E+01>,
      <4.365674E+00, 2.140195E+00, 1.151882E+01>,
      <4.365675E+00, 2.140195E+00, 1.081382E+01>,
      <4.565672E+00, 2.140195E+00, 1.081382E+01>,
      <4.565674E+00, 2.022695E+00, 1.093132E+01>,
      <4.365673E+00, 2.022695E+00, 1.093132E+01>
   }
 
   normal_vectors { 
      10, 
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <-1.104931E-16, 9.999999E-01, -2.459337E-16>,
      <1.104931E-16, -1.00E+00, 2.459337E-16>,
      <-1.246952E-07, -9.238783E-01, 3.826867E-01>,
      <-3.010386E-07, -3.826802E-01, 9.238809E-01>,
      <3.010387E-07, -3.826795E-01, -9.238812E-01>,
      <1.246954E-07, -9.23878E-01, -3.826874E-01>
   }
 
   uv_vectors { 
      94, 
      <0.00E+00, 0.00E+00>,
      <-2.726081E-01, 4.623127E-02>,
      <-2.726081E-01, 6.449997E-02>,
      <-2.676E-01, 4.623127E-02>,
      <-2.676E-01, 6.449997E-02>,
      <-2.832E-01, 4.623127E-02>,
      <-2.754001E-01, 4.299998E-02>,
      <-2.702E-01, 4.299998E-02>,
      <-2.676E-01, 4.502982E-02>,
      <-2.832E-01, 4.502982E-02>,
      <-2.806001E-01, 4.299998E-02>,
      <-2.00735E-01, 1.769602E-02>,
      <-2.00735E-01, 3.52E-02>,
      <-1.973E-01, 1.769602E-02>,
      <-1.973E-01, 3.52E-02>,
      <-2.08E-01, 1.769602E-02>,
      <-2.0265E-01, 1.459998E-02>,
      <-1.990833E-01, 1.459998E-02>,
      <-1.973E-01, 1.654488E-02>,
      <-2.08E-01, 1.654488E-02>,
      <-2.062167E-01, 1.459998E-02>,
      <-2.650457E-01, 1.318E-01>,
      <-2.650457E-01, 1.807E-01>,
      <-3.065999E-01, 1.807E-01>,
      <-3.065999E-01, 1.318E-01>,
      <-2.674062E-01, 1.318E-01>,
      <-2.650457E-01, 1.625181E-01>,
      <-2.721663E-01, 1.807E-01>,
      <-2.858232E-01, 1.318E-01>,
      <-3.065999E-01, 1.625181E-01>,
      <-3.042395E-01, 1.318E-01>,
      <-3.633119E-01, 1.552501E-01>,
      <-3.633119E-01, 1.402832E-01>,
      <-3.25088E-01, 1.402832E-01>,
      <-3.25088E-01, 1.552501E-01>,
      <-3.676208E-01, 1.328E-01>,
      <-3.207791E-01, 1.328E-01>,
      <-3.633119E-01, 1.702168E-01>,
      <-3.25088E-01, 1.702168E-01>,
      <-3.207791E-01, 1.777E-01>,
      <-3.676208E-01, 1.777E-01>,
      <-3.218501E-01, 1.328E-01>,
      <-3.218501E-01, 1.777E-01>,
      <-3.665498E-01, 1.777E-01>,
      <-3.665498E-01, 1.328E-01>,
      <-3.673387E-01, 1.35506E-01>,
      <-3.210612E-01, 1.35506E-01>,
      <-3.210618E-01, 1.777E-01>,
      <-3.67338E-01, 1.777E-01>,
      <-3.258846E-01, 1.648718E-01>,
      <-3.243587E-01, 1.777E-01>,
      <-3.640411E-01, 1.777E-01>,
      <-3.625149E-01, 1.648718E-01>,
      <-3.666089E-01, 1.342221E-01>,
      <-3.21791E-01, 1.342221E-01>,
      <-3.255043E-01, 1.299E-01>,
      <-3.255043E-01, 1.787E-01>,
      <-3.658957E-01, 1.787E-01>,
      <-3.658957E-01, 1.299E-01>,
      <-2.790673E-01, 1.299E-01>,
      <-2.949527E-01, 1.797E-01>,
      <-3.032351E-01, 1.797E-01>,
      <-3.032351E-01, 1.611837E-01>,
      <-3.004895E-01, 1.299E-01>,
      <-2.549002E-01, 1.797E-01>,
      <-2.576458E-01, 1.299E-01>,
      <-2.549002E-01, 1.611837E-01>,
      <-2.549002E-01, 1.299E-01>,
      <-3.032351E-01, 1.299E-01>,
      <-3.638663E-01, 1.768E-01>,
      <-3.638663E-01, 1.279E-01>,
      <-3.216336E-01, 1.279E-01>,
      <-3.216336E-01, 1.768E-01>,
      <-8.427014E-01, 4.931485E-02>,
      <-8.427014E-01, 2.371E-01>,
      <-9.874986E-01, 2.371E-01>,
      <-9.874986E-01, 4.931485E-02>,
      <-9.875E-01, 1.609999E-02>,
      <-8.427E-01, 1.609999E-02>,
      <-9.874986E-01, 3.696501E-02>,
      <-8.427014E-01, 3.696501E-02>,
      <-9.925E-01, 2.954225E-01>,
      <-9.925E-01, 4.906E-01>,
      <-9.399793E-01, 4.906E-01>,
      <-9.399793E-01, 2.954225E-01>,
      <-9.652339E-01, 2.609E-01>,
      <-9.925E-01, 2.825865E-01>,
      <-9.106995E-01, 2.609E-01>,
      <-8.289E-01, 2.825865E-01>,
      <-8.561661E-01, 2.609E-01>,
      <-8.289E-01, 2.954225E-01>,
      <-8.814207E-01, 2.954225E-01>,
      <-8.814207E-01, 4.906E-01>,
      <-8.289E-01, 4.906E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      36, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <13, 0, 3>, 0,
      <13, 3, 14>, 0,
      <8, 16, 17>, 0,
      <8, 17, 11>, 0,
      <18, 4, 7>, 0,
      <18, 7, 19>, 0,
      <17, 16, 18>, 0,
      <17, 18, 19>, 0,
      <8, 3, 4>, 0,
      <8, 4, 18>, 0,
      <8, 18, 16>, 0,
      <17, 19, 7>, 0,
      <17, 7, 0>, 0,
      <17, 0, 11>, 0,
      <20, 13, 14>, 0,
      <20, 14, 21>, 0,
      <22, 8, 11>, 0,
      <22, 11, 23>, 0,
      <20, 21, 22>, 0,
      <20, 22, 23>, 0,
      <20, 23, 11>, 0,
      <20, 11, 0>, 0,
      <20, 0, 13>, 0,
      <14, 3, 8>, 0,
      <14, 8, 22>, 0,
      <14, 22, 21>, 0
   }
 
   normal_indices { 
      36, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <6, 6, 7>,
      <6, 7, 7>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <8, 0, 0>,
      <8, 0, 8>,
      <9, 5, 5>,
      <9, 5, 9>,
      <8, 8, 9>,
      <8, 9, 9>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 2>
   }
 
   uv_indices { 
      36, 
      <73, 74, 75>,
      <73, 75, 76>,
      <76, 75, 74>,
      <76, 74, 73>,
      <91, 92, 93>,
      <91, 93, 90>,
      <81, 82, 83>,
      <81, 83, 84>,
      <74, 74, 75>,
      <74, 75, 75>,
      <73, 73, 76>,
      <73, 76, 76>,
      <77, 77, 78>,
      <77, 78, 78>,
      <79, 76, 73>,
      <79, 73, 80>,
      <78, 77, 79>,
      <78, 79, 80>,
      <87, 91, 90>,
      <87, 90, 88>,
      <87, 88, 89>,
      <85, 86, 81>,
      <85, 81, 84>,
      <85, 84, 87>,
      <80, 73, 76>,
      <80, 76, 79>,
      <77, 77, 78>,
      <77, 78, 78>,
      <80, 79, 77>,
      <80, 77, 78>,
      <88, 89, 87>,
      <88, 87, 84>,
      <88, 84, 90>,
      <81, 91, 87>,
      <81, 87, 85>,
      <81, 85, 86>
   }
   uv_mapping
}
 
// Shock_Cyl_b23
mesh2 {
 
   vertex_vectors { 
      12, 
      <-1.823671E+00, 3.392359E+00, -2.070084E+00>,
      <-2.040176E+00, 3.392359E+00, -1.923209E+00>,
      <-2.040176E+00, 3.392359E+00, -1.629459E+00>,
      <-1.823671E+00, 3.392359E+00, -1.482584E+00>,
      <-1.607166E+00, 3.392359E+00, -1.629459E+00>,
      <-1.607166E+00, 3.392359E+00, -1.923209E+00>,
      <-1.823671E+00, 2.217359E+00, -2.070084E+00>,
      <-2.040176E+00, 2.217359E+00, -1.923209E+00>,
      <-2.040176E+00, 2.217359E+00, -1.629459E+00>,
      <-1.823671E+00, 2.217359E+00, -1.482584E+00>,
      <-1.607166E+00, 2.217359E+00, -1.629459E+00>,
      <-1.607166E+00, 2.217359E+00, -1.923209E+00>
   }
 
   normal_vectors { 
      10, 
      <-5.000013E-01, -3.166497E-08, -8.660247E-01>,
      <-8.660257E-01, -3.166496E-08, -4.999995E-01>,
      <-8.66026E-01, -3.166497E-08, 4.99999E-01>,
      <-5.000018E-01, -3.166497E-08, 8.660244E-01>,
      <5.000014E-01, -3.166497E-08, 8.660246E-01>,
      <8.660257E-01, -3.166497E-08, 4.999994E-01>,
      <8.660261E-01, -3.166497E-08, -4.999989E-01>,
      <5.00002E-01, -3.166496E-08, -8.660242E-01>,
      <1.104931E-16, -1.00E+00, 2.459337E-16>,
      <-1.104931E-16, 9.999999E-01, -2.459337E-16>
   }
 
   uv_vectors { 
      25, 
      <0.00E+00, 0.00E+00>,
      <-7.687497E-02, 1.865001E-01>,
      <-7.687497E-02, 1.152E-01>,
      <-8.779162E-02, 1.152E-01>,
      <-8.779162E-02, 1.865001E-01>,
      <-9.870833E-02, 1.152E-01>,
      <-9.870833E-02, 1.865001E-01>,
      <-1.09625E-01, 1.152E-01>,
      <-1.09625E-01, 1.865001E-01>,
      <-1.205416E-01, 1.152E-01>,
      <-1.205416E-01, 1.865001E-01>,
      <-6.595832E-02, 1.152E-01>,
      <-6.595832E-02, 1.865001E-01>,
      <-2.751999E-01, 1.00E+00>,
      <-2.751999E-01, 7.091E-01>,
      <-3.130665E-01, 7.091E-01>,
      <-3.130665E-01, 1.00E+00>,
      <-3.509334E-01, 7.091E-01>,
      <-3.509334E-01, 1.00E+00>,
      <-3.888E-01, 7.091E-01>,
      <-3.888E-01, 1.00E+00>,
      <-4.266666E-01, 7.091E-01>,
      <-4.266666E-01, 1.00E+00>,
      <-2.373334E-01, 7.091E-01>,
      <-2.373334E-01, 1.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      20, 
      <0, 6, 7>, 0,
      <0, 7, 1>, 0,
      <1, 7, 8>, 0,
      <1, 8, 2>, 0,
      <2, 8, 9>, 0,
      <2, 9, 3>, 0,
      <3, 9, 10>, 0,
      <3, 10, 4>, 0,
      <4, 10, 11>, 0,
      <4, 11, 5>, 0,
      <5, 11, 6>, 0,
      <5, 6, 0>, 0,
      <6, 11, 10>, 0,
      <6, 10, 9>, 0,
      <6, 9, 8>, 0,
      <6, 8, 7>, 0,
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <0, 3, 4>, 0,
      <0, 4, 5>, 0
   }
 
   normal_indices { 
      20, 
      <0, 0, 1>,
      <0, 1, 1>,
      <1, 1, 2>,
      <1, 2, 2>,
      <2, 2, 3>,
      <2, 3, 3>,
      <4, 4, 5>,
      <4, 5, 5>,
      <5, 5, 6>,
      <5, 6, 6>,
      <6, 6, 7>,
      <6, 7, 7>,
      <8, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>
   }
 
   uv_indices { 
      20, 
      <13, 14, 15>,
      <13, 15, 16>,
      <16, 15, 17>,
      <16, 17, 18>,
      <18, 17, 19>,
      <18, 19, 20>,
      <20, 19, 21>,
      <20, 21, 22>,
      <22, 21, 23>,
      <22, 23, 24>,
      <24, 23, 14>,
      <24, 14, 13>,
      <14, 23, 21>,
      <14, 21, 19>,
      <14, 19, 17>,
      <14, 17, 15>,
      <13, 16, 18>,
      <13, 18, 20>,
      <13, 20, 22>,
      <13, 22, 24>
   }
   uv_mapping
}
 
// Shock_Cube_b23
mesh2 {
 
   vertex_vectors { 
      24, 
      <-1.723673E+00, 2.209742E+00, -2.148577E+00>,
      <-1.723673E+00, 3.267242E+00, -2.148577E+00>,
      <-1.92367E+00, 3.267242E+00, -2.148577E+00>,
      <-1.92367E+00, 2.209742E+00, -2.148577E+00>,
      <-1.923669E+00, 2.209742E+00, -2.374905E+00>,
      <-1.923669E+00, 3.267242E+00, -2.374905E+00>,
      <-1.723673E+00, 3.267242E+00, -2.374905E+00>,
      <-1.723673E+00, 2.209742E+00, -2.374905E+00>,
      <-1.923671E+00, 2.022695E+00, -2.022401E+00>,
      <-1.923671E+00, 2.022695E+00, -2.374905E+00>,
      <-1.723671E+00, 2.022695E+00, -2.374905E+00>,
      <-1.723671E+00, 2.022695E+00, -2.022401E+00>,
      <-1.723671E+00, 2.022695E+00, -1.669902E+00>,
      <-1.723673E+00, 2.209742E+00, -1.669902E+00>,
      <-1.92367E+00, 2.209742E+00, -1.669902E+00>,
      <-1.923672E+00, 2.022695E+00, -1.669902E+00>,
      <-1.923671E+00, 2.022695E+00, -2.257407E+00>,
      <-1.723671E+00, 2.022695E+00, -2.257407E+00>,
      <-1.923669E+00, 2.140195E+00, -2.374905E+00>,
      <-1.723673E+00, 2.140195E+00, -2.374905E+00>,
      <-1.723673E+00, 2.140195E+00, -1.669902E+00>,
      <-1.92367E+00, 2.140195E+00, -1.669902E+00>,
      <-1.923672E+00, 2.022695E+00, -1.787401E+00>,
      <-1.723671E+00, 2.022695E+00, -1.787401E+00>
   }
 
   normal_vectors { 
      10, 
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.104931E-16, 9.999999E-01, -2.459337E-16>,
      <1.104931E-16, -1.00E+00, 2.459337E-16>,
      <1.246954E-07, -9.238779E-01, -3.826876E-01>,
      <3.010387E-07, -3.826793E-01, -9.238812E-01>,
      <-3.010388E-07, -3.826786E-01, 9.238815E-01>,
      <-1.246957E-07, -9.238776E-01, 3.826883E-01>
   }
 
   uv_vectors { 
      87, 
      <0.00E+00, 0.00E+00>,
      <-2.00735E-01, 1.769602E-02>,
      <-2.00735E-01, 3.52E-02>,
      <-1.973E-01, 1.769602E-02>,
      <-1.973E-01, 3.52E-02>,
      <-2.08E-01, 1.769602E-02>,
      <-2.0265E-01, 1.459998E-02>,
      <-1.990833E-01, 1.459998E-02>,
      <-1.973E-01, 1.654488E-02>,
      <-2.08E-01, 1.654488E-02>,
      <-2.062167E-01, 1.459998E-02>,
      <-2.588001E-01, 1.318E-01>,
      <-2.588001E-01, 1.807E-01>,
      <-3.003542E-01, 1.807E-01>,
      <-3.003542E-01, 1.318E-01>,
      <-2.890204E-01, 1.506661E-01>,
      <-2.959947E-01, 1.806999E-01>,
      <-3.041812E-01, 1.806999E-01>,
      <-3.033229E-01, 1.695328E-01>,
      <-2.986461E-01, 1.506661E-01>,
      <-2.79395E-01, 1.506661E-01>,
      <-2.890203E-01, 1.318E-01>,
      <-2.726424E-01, 1.318E-01>,
      <-2.738599E-01, 1.806999E-01>,
      <-2.747181E-01, 1.695328E-01>,
      <-3.25088E-01, 1.552498E-01>,
      <-3.25088E-01, 1.702168E-01>,
      <-3.633119E-01, 1.702168E-01>,
      <-3.633119E-01, 1.552498E-01>,
      <-3.207791E-01, 1.777E-01>,
      <-3.676208E-01, 1.777E-01>,
      <-3.25088E-01, 1.402832E-01>,
      <-3.633119E-01, 1.402832E-01>,
      <-3.676208E-01, 1.328E-01>,
      <-3.207791E-01, 1.328E-01>,
      <-3.218501E-01, 1.328E-01>,
      <-3.218501E-01, 1.777E-01>,
      <-3.665498E-01, 1.777E-01>,
      <-3.665498E-01, 1.328E-01>,
      <-3.258846E-01, 1.648718E-01>,
      <-3.243587E-01, 1.777E-01>,
      <-3.640411E-01, 1.777E-01>,
      <-3.625149E-01, 1.648718E-01>,
      <-3.666089E-01, 1.342221E-01>,
      <-3.21791E-01, 1.342221E-01>,
      <-2.62165E-01, 1.299E-01>,
      <-2.62165E-01, 1.797E-01>,
      <-3.104998E-01, 1.797E-01>,
      <-3.104998E-01, 1.299E-01>,
      <-2.62165E-01, 1.373846E-01>,
      <-2.704474E-01, 1.797E-01>,
      <-2.704474E-01, 1.373846E-01>,
      <-2.649105E-01, 1.299E-01>,
      <-2.62165E-01, 1.346017E-01>,
      <-2.863327E-01, 1.299E-01>,
      <-3.104998E-01, 1.346017E-01>,
      <-3.077542E-01, 1.299E-01>,
      <-3.104998E-01, 1.373846E-01>,
      <-8.427014E-01, 4.931485E-02>,
      <-8.427014E-01, 2.371E-01>,
      <-9.874986E-01, 2.371E-01>,
      <-9.874986E-01, 4.931485E-02>,
      <-9.875E-01, 1.609999E-02>,
      <-8.427E-01, 1.609999E-02>,
      <-9.874986E-01, 3.696501E-02>,
      <-8.427014E-01, 3.696501E-02>,
      <-8.814207E-01, 2.954225E-01>,
      <-8.814207E-01, 4.906E-01>,
      <-8.289E-01, 4.906E-01>,
      <-8.289E-01, 2.954225E-01>,
      <-9.107005E-01, 2.609E-01>,
      <-8.289E-01, 2.825865E-01>,
      <-8.561661E-01, 2.609E-01>,
      <-9.925E-01, 2.954225E-01>,
      <-9.652339E-01, 2.609E-01>,
      <-9.925E-01, 2.825865E-01>,
      <-9.925E-01, 4.906E-01>,
      <-9.399793E-01, 4.906E-01>,
      <-9.399793E-01, 2.954225E-01>,
      <-9.652339E-01, 2.609E-01>,
      <-8.561661E-01, 2.609E-01>,
      <-8.439E-01, 1.12E-02>,
      <-8.439E-01, 2.371E-01>,
      <-9.80E-01, 2.371E-01>,
      <-9.80E-01, 1.12E-02>,
      <-8.439E-01, 1.120001E-02>,
      <-8.439E-01, 2.371E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      36, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <13, 0, 3>, 0,
      <13, 3, 14>, 0,
      <8, 16, 17>, 0,
      <8, 17, 11>, 0,
      <18, 4, 7>, 0,
      <18, 7, 19>, 0,
      <17, 16, 18>, 0,
      <17, 18, 19>, 0,
      <8, 3, 4>, 0,
      <8, 4, 18>, 0,
      <8, 18, 16>, 0,
      <17, 19, 7>, 0,
      <17, 7, 0>, 0,
      <17, 0, 11>, 0,
      <20, 13, 14>, 0,
      <20, 14, 21>, 0,
      <22, 8, 11>, 0,
      <22, 11, 23>, 0,
      <20, 21, 22>, 0,
      <20, 22, 23>, 0,
      <20, 23, 11>, 0,
      <20, 11, 0>, 0,
      <20, 0, 13>, 0,
      <14, 3, 8>, 0,
      <14, 8, 22>, 0,
      <14, 22, 21>, 0
   }
 
   normal_indices { 
      36, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <6, 6, 7>,
      <6, 7, 7>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <8, 0, 0>,
      <8, 0, 8>,
      <9, 5, 5>,
      <9, 5, 9>,
      <8, 8, 9>,
      <8, 9, 9>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 2>
   }
 
   uv_indices { 
      36, 
      <81, 82, 83>,
      <81, 83, 84>,
      <61, 60, 59>,
      <61, 59, 58>,
      <66, 67, 68>,
      <66, 68, 69>,
      <73, 76, 77>,
      <73, 77, 78>,
      <85, 86, 83>,
      <85, 83, 84>,
      <85, 86, 83>,
      <85, 83, 84>,
      <62, 62, 63>,
      <62, 63, 63>,
      <64, 61, 58>,
      <64, 58, 65>,
      <63, 62, 64>,
      <63, 64, 65>,
      <70, 66, 69>,
      <70, 69, 71>,
      <70, 71, 72>,
      <79, 75, 73>,
      <79, 73, 78>,
      <79, 78, 70>,
      <65, 58, 61>,
      <65, 61, 64>,
      <62, 62, 63>,
      <62, 63, 63>,
      <65, 64, 62>,
      <65, 62, 63>,
      <71, 80, 70>,
      <71, 70, 78>,
      <71, 78, 69>,
      <73, 66, 70>,
      <73, 70, 74>,
      <73, 74, 75>
   }
   uv_mapping
}
 
// Shock_Cyl_b24
mesh2 {
 
   vertex_vectors { 
      12, 
      <-1.823675E+00, 3.392359E+00, 1.1214E+01>,
      <-1.60717E+00, 3.392359E+00, 1.106713E+01>,
      <-1.60717E+00, 3.392359E+00, 1.077338E+01>,
      <-1.823675E+00, 3.392359E+00, 1.06265E+01>,
      <-2.04018E+00, 3.392359E+00, 1.077338E+01>,
      <-2.04018E+00, 3.392359E+00, 1.106713E+01>,
      <-1.823675E+00, 2.217359E+00, 1.1214E+01>,
      <-1.60717E+00, 2.217359E+00, 1.106713E+01>,
      <-1.60717E+00, 2.217359E+00, 1.077338E+01>,
      <-1.823675E+00, 2.217359E+00, 1.06265E+01>,
      <-2.04018E+00, 2.217359E+00, 1.077338E+01>,
      <-2.04018E+00, 2.217359E+00, 1.106713E+01>
   }
 
   normal_vectors { 
      10, 
      <5.000014E-01, -3.166497E-08, 8.660246E-01>,
      <8.660257E-01, -3.166497E-08, 4.999994E-01>,
      <8.660261E-01, -3.166497E-08, -4.999989E-01>,
      <5.00002E-01, -3.166496E-08, -8.660242E-01>,
      <-5.000013E-01, -3.166497E-08, -8.660247E-01>,
      <-8.660257E-01, -3.166496E-08, -4.999995E-01>,
      <-8.66026E-01, -3.166497E-08, 4.99999E-01>,
      <-5.000018E-01, -3.166497E-08, 8.660244E-01>,
      <1.104931E-16, -1.00E+00, 2.459337E-16>,
      <-1.104931E-16, 9.999999E-01, -2.459337E-16>
   }
 
   uv_vectors { 
      25, 
      <0.00E+00, 0.00E+00>,
      <-1.09625E-01, 1.865001E-01>,
      <-1.09625E-01, 1.152E-01>,
      <-1.205416E-01, 1.152E-01>,
      <-1.205416E-01, 1.865001E-01>,
      <-6.595832E-02, 1.152E-01>,
      <-6.595832E-02, 1.865001E-01>,
      <-7.687497E-02, 1.152E-01>,
      <-7.687497E-02, 1.865001E-01>,
      <-8.779162E-02, 1.152E-01>,
      <-8.779162E-02, 1.865001E-01>,
      <-9.870833E-02, 1.152E-01>,
      <-9.870833E-02, 1.865001E-01>,
      <-3.888E-01, 1.00E+00>,
      <-3.888E-01, 7.091E-01>,
      <-4.266666E-01, 7.091E-01>,
      <-4.266666E-01, 1.00E+00>,
      <-2.373334E-01, 7.091E-01>,
      <-2.373334E-01, 1.00E+00>,
      <-2.751999E-01, 7.091E-01>,
      <-2.751999E-01, 1.00E+00>,
      <-3.130665E-01, 7.091E-01>,
      <-3.130665E-01, 1.00E+00>,
      <-3.509334E-01, 7.091E-01>,
      <-3.509334E-01, 1.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      20, 
      <0, 6, 7>, 0,
      <0, 7, 1>, 0,
      <1, 7, 8>, 0,
      <1, 8, 2>, 0,
      <2, 8, 9>, 0,
      <2, 9, 3>, 0,
      <3, 9, 10>, 0,
      <3, 10, 4>, 0,
      <4, 10, 11>, 0,
      <4, 11, 5>, 0,
      <5, 11, 6>, 0,
      <5, 6, 0>, 0,
      <6, 11, 10>, 0,
      <6, 10, 9>, 0,
      <6, 9, 8>, 0,
      <6, 8, 7>, 0,
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <0, 3, 4>, 0,
      <0, 4, 5>, 0
   }
 
   normal_indices { 
      20, 
      <0, 0, 1>,
      <0, 1, 1>,
      <1, 1, 2>,
      <1, 2, 2>,
      <2, 2, 3>,
      <2, 3, 3>,
      <4, 4, 5>,
      <4, 5, 5>,
      <5, 5, 6>,
      <5, 6, 6>,
      <6, 6, 7>,
      <6, 7, 7>,
      <8, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <8, 8, 8>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>,
      <9, 9, 9>
   }
 
   uv_indices { 
      20, 
      <13, 14, 15>,
      <13, 15, 16>,
      <16, 15, 17>,
      <16, 17, 18>,
      <18, 17, 19>,
      <18, 19, 20>,
      <20, 19, 21>,
      <20, 21, 22>,
      <22, 21, 23>,
      <22, 23, 24>,
      <24, 23, 14>,
      <24, 14, 13>,
      <14, 23, 21>,
      <14, 21, 19>,
      <14, 19, 17>,
      <14, 17, 15>,
      <13, 16, 18>,
      <13, 18, 20>,
      <13, 20, 22>,
      <13, 22, 24>
   }
   uv_mapping
}
 
// Shock_Cube_b24
mesh2 {
 
   vertex_vectors { 
      24, 
      <-1.923674E+00, 2.209742E+00, 1.129249E+01>,
      <-1.923674E+00, 3.267242E+00, 1.129249E+01>,
      <-1.723677E+00, 3.267242E+00, 1.129249E+01>,
      <-1.723677E+00, 2.209742E+00, 1.129249E+01>,
      <-1.723677E+00, 2.209742E+00, 1.151882E+01>,
      <-1.723677E+00, 3.267242E+00, 1.151882E+01>,
      <-1.923674E+00, 3.267242E+00, 1.151882E+01>,
      <-1.923674E+00, 2.209742E+00, 1.151882E+01>,
      <-1.723675E+00, 2.022695E+00, 1.116632E+01>,
      <-1.723675E+00, 2.022695E+00, 1.151882E+01>,
      <-1.923676E+00, 2.022695E+00, 1.151882E+01>,
      <-1.923676E+00, 2.022695E+00, 1.116632E+01>,
      <-1.923676E+00, 2.022695E+00, 1.081382E+01>,
      <-1.923674E+00, 2.209742E+00, 1.081382E+01>,
      <-1.723677E+00, 2.209742E+00, 1.081382E+01>,
      <-1.723675E+00, 2.022695E+00, 1.081382E+01>,
      <-1.723675E+00, 2.022695E+00, 1.140132E+01>,
      <-1.923676E+00, 2.022695E+00, 1.140132E+01>,
      <-1.723677E+00, 2.140195E+00, 1.151882E+01>,
      <-1.923674E+00, 2.140195E+00, 1.151882E+01>,
      <-1.923674E+00, 2.140195E+00, 1.081382E+01>,
      <-1.723677E+00, 2.140195E+00, 1.081382E+01>,
      <-1.723675E+00, 2.022695E+00, 1.093132E+01>,
      <-1.923676E+00, 2.022695E+00, 1.093132E+01>
   }
 
   normal_vectors { 
      10, 
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <-1.104931E-16, 9.999999E-01, -2.459337E-16>,
      <1.104931E-16, -1.00E+00, 2.459337E-16>,
      <-1.246952E-07, -9.238782E-01, 3.826869E-01>,
      <-3.010386E-07, -3.8268E-01, 9.238809E-01>,
      <3.010387E-07, -3.826793E-01, -9.238812E-01>,
      <1.246954E-07, -9.238779E-01, -3.826876E-01>
   }
 
   uv_vectors { 
      114, 
      <0.00E+00, 0.00E+00>,
      <-2.04565E-01, 1.769602E-02>,
      <-2.04565E-01, 3.52E-02>,
      <-2.08E-01, 1.769602E-02>,
      <-2.08E-01, 3.52E-02>,
      <-1.973E-01, 1.769602E-02>,
      <-2.0265E-01, 1.459998E-02>,
      <-2.062167E-01, 1.459998E-02>,
      <-2.08E-01, 1.654488E-02>,
      <-1.973E-01, 1.654488E-02>,
      <-1.990833E-01, 1.459998E-02>,
      <-2.650457E-01, 1.318E-01>,
      <-2.650457E-01, 1.807E-01>,
      <-3.065999E-01, 1.807E-01>,
      <-3.065999E-01, 1.318E-01>,
      <-2.697666E-01, 1.318E-01>,
      <-2.650457E-01, 1.625181E-01>,
      <-2.792866E-01, 1.807E-01>,
      <-3.065999E-01, 1.625181E-01>,
      <-3.037514E-01, 1.318E-01>,
      <-2.815267E-01, 1.318E-01>,
      <-2.674062E-01, 1.318E-01>,
      <-2.721663E-01, 1.807E-01>,
      <-2.858232E-01, 1.318E-01>,
      <-3.042395E-01, 1.318E-01>,
      <-3.633119E-01, 1.552501E-01>,
      <-3.633119E-01, 1.402832E-01>,
      <-3.25088E-01, 1.402832E-01>,
      <-3.25088E-01, 1.552501E-01>,
      <-3.676208E-01, 1.328E-01>,
      <-3.207791E-01, 1.328E-01>,
      <-3.633119E-01, 1.702168E-01>,
      <-3.25088E-01, 1.702168E-01>,
      <-3.207791E-01, 1.777E-01>,
      <-3.676208E-01, 1.777E-01>,
      <-3.218501E-01, 1.328E-01>,
      <-3.218501E-01, 1.777E-01>,
      <-3.665498E-01, 1.777E-01>,
      <-3.665498E-01, 1.328E-01>,
      <-3.676208E-01, 1.328E-01>,
      <-3.258846E-01, 1.648718E-01>,
      <-3.243587E-01, 1.777E-01>,
      <-3.640411E-01, 1.777E-01>,
      <-3.625149E-01, 1.648718E-01>,
      <-3.666089E-01, 1.342221E-01>,
      <-3.21791E-01, 1.342221E-01>,
      <-2.559001E-01, 1.27E-01>,
      <-2.559001E-01, 1.797E-01>,
      <-2.983236E-01, 1.797E-01>,
      <-2.983236E-01, 1.27E-01>,
      <-2.771116E-01, 1.27E-01>,
      <-2.910541E-01, 1.797E-01>,
      <-2.983236E-01, 1.601051E-01>,
      <-2.959139E-01, 1.27E-01>,
      <-2.583099E-01, 1.27E-01>,
      <-2.559001E-01, 1.601051E-01>,
      <-3.255043E-01, 1.299E-01>,
      <-3.255043E-01, 1.787E-01>,
      <-3.658957E-01, 1.787E-01>,
      <-3.658957E-01, 1.299E-01>,
      <-3.638663E-01, 1.768E-01>,
      <-3.638663E-01, 1.279E-01>,
      <-3.216336E-01, 1.279E-01>,
      <-3.216336E-01, 1.768E-01>,
      <-9.340202E-01, 4.931485E-02>,
      <-9.340202E-01, 2.371E-01>,
      <-9.685799E-01, 2.371E-01>,
      <-9.685799E-01, 4.931485E-02>,
      <-9.587148E-01, 4.931485E-02>,
      <-9.587148E-01, 2.371E-01>,
      <-9.438852E-01, 2.371E-01>,
      <-9.438852E-01, 4.931485E-02>,
      <-8.863148E-01, 4.931485E-02>,
      <-8.714852E-01, 4.931485E-02>,
      <-8.427004E-01, 1.609999E-02>,
      <-9.61985E-01, 1.609999E-02>,
      <-9.406151E-01, 1.609999E-02>,
      <-9.150996E-01, 1.609999E-02>,
      <-9.587148E-01, 3.696501E-02>,
      <-9.438852E-01, 3.696501E-02>,
      <-8.863148E-01, 3.696501E-02>,
      <-8.714852E-01, 3.696501E-02>,
      <-8.68215E-01, 1.609999E-02>,
      <-8.89585E-01, 1.609999E-02>,
      <-8.427014E-01, 4.931485E-02>,
      <-8.427014E-01, 2.371E-01>,
      <-9.874986E-01, 2.371E-01>,
      <-9.874986E-01, 4.931485E-02>,
      <-9.875E-01, 1.609999E-02>,
      <-9.874986E-01, 3.696501E-02>,
      <-8.427014E-01, 3.696501E-02>,
      <-9.925E-01, 2.954225E-01>,
      <-9.925E-01, 4.906E-01>,
      <-9.761403E-01, 4.906E-01>,
      <-9.761403E-01, 2.954225E-01>,
      <-9.288717E-01, 4.906E-01>,
      <-9.288717E-01, 2.954225E-01>,
      <-9.516005E-01, 2.609E-01>,
      <-9.761403E-01, 2.825865E-01>,
      <-9.025195E-01, 2.609E-01>,
      <-8.289003E-01, 2.825865E-01>,
      <-8.534395E-01, 2.609E-01>,
      <-8.289003E-01, 2.954225E-01>,
      <-8.814207E-01, 2.954225E-01>,
      <-8.814207E-01, 4.906E-01>,
      <-8.289E-01, 4.906E-01>,
      <-9.107005E-01, 2.609E-01>,
      <-8.561661E-01, 2.609E-01>,
      <-9.652339E-01, 2.609E-01>,
      <-9.925E-01, 2.825865E-01>,
      <-8.439E-01, 1.12E-02>,
      <-8.439E-01, 2.371E-01>,
      <-9.80E-01, 2.371E-01>,
      <-9.80E-01, 1.12E-02>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      36, 
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <1, 6, 5>, 0,
      <1, 5, 2>, 0,
      <13, 0, 3>, 0,
      <13, 3, 14>, 0,
      <8, 16, 17>, 0,
      <8, 17, 11>, 0,
      <18, 4, 7>, 0,
      <18, 7, 19>, 0,
      <17, 16, 18>, 0,
      <17, 18, 19>, 0,
      <8, 3, 4>, 0,
      <8, 4, 18>, 0,
      <8, 18, 16>, 0,
      <17, 19, 7>, 0,
      <17, 7, 0>, 0,
      <17, 0, 11>, 0,
      <20, 13, 14>, 0,
      <20, 14, 21>, 0,
      <22, 8, 11>, 0,
      <22, 11, 23>, 0,
      <20, 21, 22>, 0,
      <20, 22, 23>, 0,
      <20, 23, 11>, 0,
      <20, 11, 0>, 0,
      <20, 0, 13>, 0,
      <14, 3, 8>, 0,
      <14, 8, 22>, 0,
      <14, 22, 21>, 0
   }
 
   normal_indices { 
      36, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <7, 1, 1>,
      <7, 1, 7>,
      <6, 6, 7>,
      <6, 7, 7>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <8, 0, 0>,
      <8, 0, 8>,
      <9, 5, 5>,
      <9, 5, 9>,
      <8, 8, 9>,
      <8, 9, 9>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 2>
   }
 
   uv_indices { 
      36, 
      <84, 85, 86>,
      <84, 86, 87>,
      <110, 111, 112>,
      <110, 112, 113>,
      <103, 104, 105>,
      <103, 105, 102>,
      <94, 93, 95>,
      <94, 95, 96>,
      <85, 85, 86>,
      <85, 86, 86>,
      <84, 84, 87>,
      <84, 87, 87>,
      <88, 88, 74>,
      <88, 74, 74>,
      <89, 87, 84>,
      <89, 84, 90>,
      <74, 88, 89>,
      <74, 89, 90>,
      <106, 103, 102>,
      <106, 102, 100>,
      <106, 100, 107>,
      <97, 98, 94>,
      <97, 94, 96>,
      <97, 96, 99>,
      <90, 84, 87>,
      <90, 87, 89>,
      <88, 88, 74>,
      <88, 74, 74>,
      <90, 89, 88>,
      <90, 88, 74>,
      <100, 101, 99>,
      <100, 99, 96>,
      <100, 96, 102>,
      <91, 103, 106>,
      <91, 106, 108>,
      <91, 108, 109>
   }
   uv_mapping
}
 
// TruckFrameP
mesh2 {
 
   vertex_vectors { 
      76, 
      <-2.111742E+00, 4.559963E+00, 4.541915E+00>,
      <-1.545967E+00, 4.560885E+00, 4.541918E+00>,
      <-2.101513E+00, 2.06753E+00, 4.536931E+00>,
      <-1.535744E+00, 2.068451E+00, 4.536933E+00>,
      <-2.1015E+00, 2.063881E+00, 5.399983E+00>,
      <-1.535729E+00, 2.064803E+00, 5.399985E+00>,
      <-2.103661E+00, 2.590235E+00, 5.40299E+00>,
      <-1.537886E+00, 2.591156E+00, 5.402993E+00>,
      <-2.105534E+00, 3.046329E+00, 5.817416E+00>,
      <-1.539753E+00, 3.047252E+00, 5.817419E+00>,
      <-2.106678E+00, 3.325817E+00, 6.333698E+00>,
      <-1.540908E+00, 3.326739E+00, 6.3337E+00>,
      <-2.106662E+00, 3.321397E+00, 7.514651E+00>,
      <-1.540887E+00, 3.322318E+00, 7.514651E+00>,
      <-2.10551E+00, 3.040791E+00, 8.172707E+00>,
      <-1.539737E+00, 3.041713E+00, 8.172707E+00>,
      <-2.10362E+00, 2.579175E+00, 8.521598E+00>,
      <-1.537841E+00, 2.580096E+00, 8.521598E+00>,
      <-2.101406E+00, 2.040132E+00, 8.590338E+00>,
      <-1.535634E+00, 2.041054E+00, 8.590338E+00>,
      <-2.101387E+00, 2.035189E+00, 1.02663E+01>,
      <-1.535614E+00, 2.03611E+00, 1.02663E+01>,
      <-2.102398E+00, 2.281816E+00, 1.026681E+01>,
      <-1.536621E+00, 2.282736E+00, 1.026681E+01>,
      <-2.103996E+00, 2.671327E+00, 1.037513E+01>,
      <-1.538221E+00, 2.672248E+00, 1.037513E+01>,
      <-2.105129E+00, 2.947657E+00, 1.062259E+01>,
      <-1.53936E+00, 2.948579E+00, 1.062258E+01>,
      <-2.106236E+00, 3.217361E+00, 1.101035E+01>,
      <-1.540463E+00, 3.218283E+00, 1.101035E+01>,
      <-2.10623E+00, 3.21507E+00, 1.159706E+01>,
      <-1.540455E+00, 3.215992E+00, 1.159706E+01>,
      <-2.108807E+00, 3.843968E+00, 1.15992E+01>,
      <-1.543034E+00, 3.844889E+00, 1.15992E+01>,
      <-2.10981E+00, 4.087497E+00, 1.140202E+01>,
      <-1.544035E+00, 4.088418E+00, 1.140202E+01>,
      <-2.111416E+00, 4.480069E+00, 1.04368E+01>,
      <-1.545649E+00, 4.48099E+00, 1.04368E+01>,
      <-2.111677E+00, 4.542963E+00, 9.452933E+00>,
      <-1.545902E+00, 4.543885E+00, 9.452933E+00>,
      <-2.101499E+00, 2.063881E+00, 3.673878E+00>,
      <-1.535728E+00, 2.064803E+00, 3.673882E+00>,
      <-2.10366E+00, 2.590235E+00, 3.670871E+00>,
      <-1.537885E+00, 2.591156E+00, 3.670874E+00>,
      <-2.105533E+00, 3.046329E+00, 3.256446E+00>,
      <-1.539752E+00, 3.047252E+00, 3.256448E+00>,
      <-2.106678E+00, 3.325817E+00, 2.740164E+00>,
      <-1.540906E+00, 3.326739E+00, 2.740167E+00>,
      <-2.10666E+00, 3.321397E+00, 1.55921E+00>,
      <-1.540885E+00, 3.322318E+00, 1.559212E+00>,
      <-2.105504E+00, 3.040791E+00, 9.011562E-01>,
      <-1.539731E+00, 3.041713E+00, 9.011583E-01>,
      <-2.103614E+00, 2.579175E+00, 5.52265E-01>,
      <-1.537835E+00, 2.580096E+00, 5.52268E-01>,
      <-2.101399E+00, 2.040132E+00, 4.835251E-01>,
      <-1.535628E+00, 2.041054E+00, 4.835277E-01>,
      <-2.101379E+00, 2.035189E+00, -1.19244E+00>,
      <-1.535606E+00, 2.03611E+00, -1.192438E+00>,
      <-2.10239E+00, 2.281816E+00, -1.192948E+00>,
      <-1.536613E+00, 2.282736E+00, -1.192946E+00>,
      <-2.103989E+00, 2.671327E+00, -1.30127E+00>,
      <-1.538214E+00, 2.672248E+00, -1.301267E+00>,
      <-2.105122E+00, 2.947657E+00, -1.548727E+00>,
      <-1.539352E+00, 2.948579E+00, -1.54872E+00>,
      <-2.106228E+00, 3.217361E+00, -1.936485E+00>,
      <-1.540455E+00, 3.218283E+00, -1.936483E+00>,
      <-2.106222E+00, 3.21507E+00, -2.523195E+00>,
      <-1.540447E+00, 3.215992E+00, -2.523192E+00>,
      <-2.108799E+00, 3.843968E+00, -2.525332E+00>,
      <-1.543026E+00, 3.844889E+00, -2.52533E+00>,
      <-2.109802E+00, 4.087497E+00, -2.32816E+00>,
      <-1.544027E+00, 4.088418E+00, -2.328157E+00>,
      <-2.111408E+00, 4.480069E+00, -1.362934E+00>,
      <-1.545641E+00, 4.48099E+00, -1.362932E+00>,
      <-2.11167E+00, 4.542963E+00, -3.790695E-01>,
      <-1.545895E+00, 4.543885E+00, -3.790669E-01>
   }
 
   normal_vectors { 
      36, 
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <1.104931E-16, -1.00E+00, 2.459337E-16>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>,
      <5.000974E-04, -3.631431E-01, 9.317333E-01>,
      <1.089234E-03, -7.870983E-01, 6.168267E-01>,
      <1.343685E-03, -9.698404E-01, 2.437373E-01>,
      <1.357506E-03, -9.793831E-01, -2.020077E-01>,
      <1.092297E-03, -7.879434E-01, -6.157468E-01>,
      <5.233501E-04, -3.774298E-01, -9.260381E-01>,
      <1.754982E-04, -1.264974E-01, -9.919669E-01>,
      <1.882797E-04, -1.362277E-01, 9.906775E-01>,
      <6.6646E-04, -4.801079E-01, 8.772092E-01>,
      <1.040707E-03, -7.49093E-01, 6.62464E-01>,
      <1.324347E-03, -9.547682E-01, 2.973482E-01>,
      <-4.605404E-04, 3.321612E-01, 9.432225E-01>,
      <-1.113014E-03, 8.031417E-01, 5.957869E-01>,
      <-1.351239E-03, 9.747794E-01, 2.23166E-01>,
      <-1.386164E-03, 9.994329E-01, 3.364441E-02>,
      <-1.104931E-16, 9.999999E-01, -2.459337E-16>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <5.070676E-04, -3.631431E-01, -9.317332E-01>,
      <1.093838E-03, -7.870983E-01, -6.168266E-01>,
      <1.345475E-03, -9.698404E-01, -2.437374E-01>,
      <1.356696E-03, -9.793829E-01, 2.020084E-01>,
      <1.089826E-03, -7.879429E-01, 6.157473E-01>,
      <5.197127E-04, -3.774298E-01, 9.260381E-01>,
      <1.716625E-04, -1.264974E-01, 9.919669E-01>,
      <1.923973E-04, -1.362256E-01, -9.906778E-01>,
      <6.699598E-04, -4.8011E-01, -8.772081E-01>,
      <1.043236E-03, -7.490941E-01, -6.624629E-01>,
      <1.325502E-03, -9.547687E-01, -2.973468E-01>,
      <-4.567847E-04, 3.321643E-01, -9.432214E-01>,
      <-1.110523E-03, 8.03143E-01, -5.957852E-01>,
      <-1.350327E-03, 9.747792E-01, -2.231669E-01>,
      <-1.386034E-03, 9.99433E-01, -3.364084E-02>
   }
 
   uv_vectors { 
      414, 
      <-2.046E-01, 9.50455E-04>,
      <-2.044556E-01, 7.419997E-02>,
      <-6.747044E-01, 1.152495E-01>,
      <-4.011471E-01, 1.145969E-01>,
      <-3.606242E-01, 6.020861E-02>,
      <-1.579244E-01, 2.517338E-02>,
      <-1.453434E-01, 7.10662E-02>,
      <-3.173649E-03, 2.092282E-01>,
      <-2.607399E-02, 2.379216E-01>,
      <-1.381813E-01, 2.841752E-01>,
      <-2.524532E-01, 2.915855E-01>,
      <-7.20838E-01, 6.151171E-02>,
      <-6.197401E-01, 1.511789E-01>,
      <-4.645773E-01, 1.506583E-01>,
      <-1.246028E-01, 1.036236E-01>,
      <-7.156575E-02, 1.404006E-01>,
      <-3.421843E-03, 1.401306E-01>,
      <-5.641788E-01, 5.883074E-01>,
      <-6.759159E-01, 5.810612E-01>,
      <-6.970152E-01, 4.04516E-01>,
      <-6.689128E-01, 3.726806E-01>,
      <-6.566107E-01, 3.278061E-01>,
      <-6.565531E-01, 2.993928E-01>,
      <-4.662144E-01, 2.999625E-01>,
      <-4.584077E-01, 3.620643E-01>,
      <-4.18784E-01, 4.152457E-01>,
      <-3.440497E-01, 4.475738E-01>,
      <-2.09929E-01, 4.480829E-01>,
      <-1.512954E-01, 4.158841E-01>,
      <-1.042293E-01, 3.633384E-01>,
      <-5.871534E-03, 3.031187E-01>,
      <-5.305231E-03, 5.902659E-01>,
      <-8.165E-01, 9.252285E-01>,
      <-8.125838E-01, 9.57226E-01>,
      <-4.76269E-01, 9.570976E-01>,
      <-4.801807E-01, 9.251E-01>,
      <-8.094193E-01, 9.875E-01>,
      <-4.731E-01, 9.873715E-01>,
      <-8.056706E-01, 9.251E-01>,
      <-8.165004E-01, 9.865987E-01>,
      <-4.839258E-01, 9.875E-01>,
      <-4.731004E-01, 9.260013E-01>,
      <-8.138481E-01, 9.251E-01>,
      <-8.165005E-01, 9.87354E-01>,
      <-4.757576E-01, 9.875E-01>,
      <-4.731005E-01, 9.252461E-01>,
      <-8.143413E-01, 9.251E-01>,
      <-8.158955E-01, 9.667082E-01>,
      <-4.746559E-01, 9.667693E-01>,
      <-4.752599E-01, 9.875E-01>,
      <-8.149452E-01, 9.667693E-01>,
      <-4.737057E-01, 9.667083E-01>,
      <-4.752599E-01, 9.251E-01>,
      <-8.143413E-01, 9.875E-01>,
      <-4.79441E-01, 9.71815E-01>,
      <-8.15111E-01, 9.717873E-01>,
      <-4.779892E-01, 9.608642E-01>,
      <-8.13658E-01, 9.608366E-01>,
      <-4.764569E-01, 9.525719E-01>,
      <-8.121303E-01, 9.525443E-01>,
      <-4.750684E-01, 9.473768E-01>,
      <-8.107361E-01, 9.473491E-01>,
      <-6.093669E-01, 9.875E-01>,
      <-4.731E-01, 9.358639E-01>,
      <-6.802346E-01, 9.251E-01>,
      <-8.165E-01, 9.767362E-01>,
      <-6.511039E-01, 9.925E-01>,
      <-4.656E-01, 9.366999E-01>,
      <-6.221966E-01, 9.263E-01>,
      <-8.077E-01, 9.821002E-01>,
      <-6.366501E-01, 9.924985E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.656E-01, 9.26301E-01>,
      <-6.366501E-01, 9.263001E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.077E-01, 9.925001E-01>,
      <-4.656E-01, 9.820999E-01>,
      <-6.511061E-01, 9.263E-01>,
      <-8.076999E-01, 9.367001E-01>,
      <-6.221933E-01, 9.925E-01>,
      <-8.047949E-01, 9.263E-01>,
      <-4.685062E-01, 9.925E-01>,
      <-8.053998E-01, 9.334068E-01>,
      <-4.662043E-01, 9.334333E-01>,
      <-8.063581E-01, 9.472352E-01>,
      <-4.671637E-01, 9.472617E-01>,
      <-8.070373E-01, 9.611779E-01>,
      <-4.678464E-01, 9.612043E-01>,
      <-8.077005E-01, 9.783284E-01>,
      <-4.685073E-01, 9.783549E-01>,
      <-8.045977E-01, 9.263E-01>,
      <-8.058926E-01, 9.445296E-01>,
      <-4.668931E-01, 9.445614E-01>,
      <-8.070148E-01, 9.703102E-01>,
      <-4.680119E-01, 9.70342E-01>,
      <-4.687034E-01, 9.925E-01>,
      <-4.656E-01, 9.810792E-01>,
      <-6.013628E-01, 9.263E-01>,
      <-8.077E-01, 9.377209E-01>,
      <-6.719353E-01, 9.925E-01>,
      <-8.070968E-01, 9.366705E-01>,
      <-4.679013E-01, 9.36632E-01>,
      <-4.685073E-01, 9.263E-01>,
      <-8.061374E-01, 9.554002E-01>,
      <-4.669431E-01, 9.553617E-01>,
      <-8.054547E-01, 9.72515E-01>,
      <-4.662638E-01, 9.724765E-01>,
      <-8.047938E-01, 9.925E-01>,
      <-5.472026E-01, 9.925E-01>,
      <-4.656E-01, 9.45287E-01>,
      <-7.260988E-01, 9.263E-01>,
      <-8.076999E-01, 9.73513E-01>,
      <-8.064069E-01, 9.445614E-01>,
      <-4.674074E-01, 9.445295E-01>,
      <-4.687022E-01, 9.263E-01>,
      <-8.05288E-01, 9.70342E-01>,
      <-4.662851E-01, 9.703102E-01>,
      <-8.045966E-01, 9.925E-01>,
      <-4.662919E-01, 9.678896E-01>,
      <-8.052427E-01, 9.679187E-01>,
      <-4.674243E-01, 9.449727E-01>,
      <-8.063785E-01, 9.450018E-01>,
      <-7.89536E-01, 5.358341E-01>,
      <-8.119286E-01, 5.077778E-01>,
      <-8.116856E-01, 4.483239E-01>,
      <-7.410533E-01, 4.395881E-01>,
      <-9.688789E-02, 3.026984E-01>,
      <-8.208482E-01, 2.935884E-01>,
      <-8.21427E-01, 1.00E-03>,
      <-7.211874E-01, 1.00E-03>,
      <-3.526406E-01, 1.00E-03>,
      <-1.579831E-01, 1.00E-03>,
      <-8.152E-01, 9.215873E-01>,
      <-6.40607E-01, 9.202015E-01>,
      <-6.405473E-01, 9.949143E-01>,
      <-8.151404E-01, 9.963001E-01>,
      <-4.656E-01, 9.935129E-01>,
      <-4.656596E-01, 9.188001E-01>,
      <-1.874804E-03, 3.024706E-01>,
      <-9.998667E-02, 3.625397E-01>,
      <-1.469352E-01, 4.14954E-01>,
      <-2.054224E-01, 4.470723E-01>,
      <-3.392073E-01, 4.465645E-01>,
      <-4.137549E-01, 4.143173E-01>,
      <-4.532796E-01, 3.612688E-01>,
      <-4.610668E-01, 2.993222E-01>,
      <-9.464604E-02, 3.021559E-01>,
      <-6.559296E-01, 2.98754E-01>,
      <-6.559871E-01, 3.270963E-01>,
      <-6.682582E-01, 3.718586E-01>,
      <-6.962906E-01, 4.036143E-01>,
      <-7.462181E-01, 4.416088E-01>,
      <-8.106839E-01, 4.483452E-01>,
      <-8.10926E-01, 5.06618E-01>,
      <-7.885892E-01, 5.346041E-01>,
      <-2.530497E-01, 2.93377E-01>,
      <-1.399122E-01, 2.860404E-01>,
      <-2.891767E-02, 2.40246E-01>,
      <-6.244719E-03, 2.118375E-01>,
      <-6.489635E-03, 1.384754E-01>,
      <-7.395738E-02, 1.387428E-01>,
      <-1.185479E-01, 1.072811E-01>,
      <-1.470027E-01, 7.504681E-02>,
      <-1.594592E-01, 2.960964E-02>,
      <-1.595172E-01, 8.400737E-04>,
      <-3.522428E-01, 1.416883E-03>,
      <-3.601472E-01, 6.429716E-02>,
      <-4.002675E-01, 1.181454E-01>,
      <-4.75939E-01, 1.508787E-01>,
      <-6.117408E-01, 1.513942E-01>,
      <-6.7111E-01, 1.187916E-01>,
      <-7.187657E-01, 6.558718E-02>,
      <-7.191114E-01, 4.187306E-03>,
      <-8.183562E-01, 4.612735E-03>,
      <-8.177832E-01, 2.953604E-01>,
      <-1.31005E-03, 5.938998E-01>,
      <-6.702439E-01, 5.847182E-01>,
      <-5.587863E-01, 5.919462E-01>,
      <-6.366501E-01, 9.924985E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.656E-01, 9.26301E-01>,
      <-6.366501E-01, 9.263001E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.064069E-01, 9.445614E-01>,
      <-4.674074E-01, 9.445295E-01>,
      <-4.687022E-01, 9.263E-01>,
      <-8.064069E-01, 9.445614E-01>,
      <-8.05288E-01, 9.70342E-01>,
      <-4.662851E-01, 9.703102E-01>,
      <-4.674074E-01, 9.445295E-01>,
      <-8.05288E-01, 9.70342E-01>,
      <-8.045966E-01, 9.925E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.662851E-01, 9.703102E-01>,
      <-6.093669E-01, 9.875E-01>,
      <-4.731E-01, 9.358639E-01>,
      <-6.802346E-01, 9.251E-01>,
      <-8.165E-01, 9.767362E-01>,
      <-4.79441E-01, 9.71815E-01>,
      <-4.779892E-01, 9.608642E-01>,
      <-8.13658E-01, 9.608366E-01>,
      <-8.15111E-01, 9.717873E-01>,
      <-4.779892E-01, 9.608642E-01>,
      <-4.764569E-01, 9.525719E-01>,
      <-8.121303E-01, 9.525443E-01>,
      <-8.13658E-01, 9.608366E-01>,
      <-4.764569E-01, 9.525719E-01>,
      <-4.750684E-01, 9.473768E-01>,
      <-8.107361E-01, 9.473491E-01>,
      <-8.121303E-01, 9.525443E-01>,
      <-6.511039E-01, 9.925E-01>,
      <-4.656E-01, 9.366999E-01>,
      <-6.221966E-01, 9.263E-01>,
      <-8.077E-01, 9.821002E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.070968E-01, 9.366705E-01>,
      <-4.679013E-01, 9.36632E-01>,
      <-4.685073E-01, 9.263E-01>,
      <-8.070968E-01, 9.366705E-01>,
      <-8.061374E-01, 9.554002E-01>,
      <-4.669431E-01, 9.553617E-01>,
      <-4.679013E-01, 9.36632E-01>,
      <-8.061374E-01, 9.554002E-01>,
      <-8.054547E-01, 9.72515E-01>,
      <-4.662638E-01, 9.724765E-01>,
      <-4.669431E-01, 9.553617E-01>,
      <-8.054547E-01, 9.72515E-01>,
      <-8.047938E-01, 9.925E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.662638E-01, 9.724765E-01>,
      <-5.472026E-01, 9.925E-01>,
      <-4.656E-01, 9.45287E-01>,
      <-7.260988E-01, 9.263E-01>,
      <-8.076999E-01, 9.73513E-01>,
      <-8.165E-01, 9.252285E-01>,
      <-8.149452E-01, 9.667693E-01>,
      <-4.737057E-01, 9.667083E-01>,
      <-4.752599E-01, 9.251E-01>,
      <-8.149452E-01, 9.667693E-01>,
      <-8.143413E-01, 9.875E-01>,
      <-4.731E-01, 9.873715E-01>,
      <-4.737057E-01, 9.667083E-01>,
      <-8.165E-01, 9.252285E-01>,
      <-8.125838E-01, 9.57226E-01>,
      <-4.76269E-01, 9.570976E-01>,
      <-4.801807E-01, 9.251E-01>,
      <-8.125838E-01, 9.57226E-01>,
      <-8.094193E-01, 9.875E-01>,
      <-4.731E-01, 9.873715E-01>,
      <-4.76269E-01, 9.570976E-01>,
      <-8.152E-01, 9.215873E-01>,
      <-6.40607E-01, 9.202015E-01>,
      <-6.405473E-01, 9.949143E-01>,
      <-8.151404E-01, 9.963001E-01>,
      <-8.208482E-01, 2.935884E-01>,
      <-8.21427E-01, 1.00E-03>,
      <-7.211874E-01, 1.00E-03>,
      <-7.20838E-01, 6.151171E-02>,
      <-6.747044E-01, 1.152495E-01>,
      <-6.197401E-01, 1.511789E-01>,
      <-4.645773E-01, 1.506583E-01>,
      <-4.011471E-01, 1.145969E-01>,
      <-3.606242E-01, 6.020861E-02>,
      <-3.526406E-01, 1.00E-03>,
      <-1.579831E-01, 1.00E-03>,
      <-1.579244E-01, 2.517338E-02>,
      <-1.453434E-01, 7.10662E-02>,
      <-1.246028E-01, 1.036236E-01>,
      <-7.156575E-02, 1.404006E-01>,
      <-3.421843E-03, 1.401306E-01>,
      <-3.173649E-03, 2.092282E-01>,
      <-2.607399E-02, 2.379216E-01>,
      <-1.381813E-01, 2.841752E-01>,
      <-2.524532E-01, 2.915855E-01>,
      <-2.530497E-01, 2.93377E-01>,
      <-1.399122E-01, 2.860404E-01>,
      <-2.891767E-02, 2.40246E-01>,
      <-6.244719E-03, 2.118375E-01>,
      <-6.489635E-03, 1.384754E-01>,
      <-7.395738E-02, 1.387428E-01>,
      <-1.185479E-01, 1.072811E-01>,
      <-1.470027E-01, 7.504681E-02>,
      <-1.594592E-01, 2.960964E-02>,
      <-1.595172E-01, 8.400737E-04>,
      <-3.522428E-01, 1.416883E-03>,
      <-3.601472E-01, 6.429716E-02>,
      <-4.002675E-01, 1.181454E-01>,
      <-4.75939E-01, 1.508787E-01>,
      <-6.117408E-01, 1.513942E-01>,
      <-6.7111E-01, 1.187916E-01>,
      <-7.187657E-01, 6.558718E-02>,
      <-7.191114E-01, 4.187306E-03>,
      <-8.183562E-01, 4.612735E-03>,
      <-8.177832E-01, 2.953604E-01>,
      <-2.044556E-01, 7.419997E-02>,
      <-2.046E-01, 9.50455E-04>,
      <-2.046E-01, 9.50455E-04>,
      <-2.044556E-01, 7.419997E-02>,
      <-6.366501E-01, 9.263001E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.077E-01, 9.925001E-01>,
      <-6.366501E-01, 9.924985E-01>,
      <-8.045977E-01, 9.263E-01>,
      <-8.058926E-01, 9.445296E-01>,
      <-4.668931E-01, 9.445614E-01>,
      <-4.656E-01, 9.26301E-01>,
      <-8.058926E-01, 9.445296E-01>,
      <-8.070148E-01, 9.703102E-01>,
      <-4.680119E-01, 9.70342E-01>,
      <-4.668931E-01, 9.445614E-01>,
      <-8.070148E-01, 9.703102E-01>,
      <-8.077E-01, 9.925001E-01>,
      <-4.687034E-01, 9.925E-01>,
      <-4.680119E-01, 9.70342E-01>,
      <-4.656E-01, 9.810792E-01>,
      <-6.013628E-01, 9.263E-01>,
      <-8.077E-01, 9.377209E-01>,
      <-6.719353E-01, 9.925E-01>,
      <-4.656E-01, 9.924999E-01>,
      <-4.662919E-01, 9.678896E-01>,
      <-8.052427E-01, 9.679187E-01>,
      <-8.045966E-01, 9.925E-01>,
      <-4.662919E-01, 9.678896E-01>,
      <-4.674243E-01, 9.449727E-01>,
      <-8.063785E-01, 9.450018E-01>,
      <-8.052427E-01, 9.679187E-01>,
      <-4.674243E-01, 9.449727E-01>,
      <-4.687022E-01, 9.263E-01>,
      <-8.077E-01, 9.263012E-01>,
      <-8.063785E-01, 9.450018E-01>,
      <-4.656E-01, 9.820999E-01>,
      <-6.511061E-01, 9.263E-01>,
      <-8.076999E-01, 9.367001E-01>,
      <-6.221933E-01, 9.925E-01>,
      <-8.047949E-01, 9.263E-01>,
      <-8.053998E-01, 9.334068E-01>,
      <-4.662043E-01, 9.334333E-01>,
      <-4.656E-01, 9.26301E-01>,
      <-8.053998E-01, 9.334068E-01>,
      <-8.063581E-01, 9.472352E-01>,
      <-4.671637E-01, 9.472617E-01>,
      <-4.662043E-01, 9.334333E-01>,
      <-8.063581E-01, 9.472352E-01>,
      <-8.070373E-01, 9.611779E-01>,
      <-4.678464E-01, 9.612043E-01>,
      <-4.671637E-01, 9.472617E-01>,
      <-8.070373E-01, 9.611779E-01>,
      <-8.077005E-01, 9.783284E-01>,
      <-4.685073E-01, 9.783549E-01>,
      <-4.678464E-01, 9.612043E-01>,
      <-8.077005E-01, 9.783284E-01>,
      <-8.077E-01, 9.925001E-01>,
      <-4.685062E-01, 9.925E-01>,
      <-4.685073E-01, 9.783549E-01>,
      <-8.143413E-01, 9.251E-01>,
      <-8.158955E-01, 9.667082E-01>,
      <-4.746559E-01, 9.667693E-01>,
      <-4.731005E-01, 9.252461E-01>,
      <-8.158955E-01, 9.667082E-01>,
      <-8.165005E-01, 9.87354E-01>,
      <-4.752599E-01, 9.875E-01>,
      <-4.746559E-01, 9.667693E-01>,
      <-8.138481E-01, 9.251E-01>,
      <-8.165005E-01, 9.87354E-01>,
      <-4.757576E-01, 9.875E-01>,
      <-4.731005E-01, 9.252461E-01>,
      <-8.056706E-01, 9.251E-01>,
      <-8.165004E-01, 9.865987E-01>,
      <-4.839258E-01, 9.875E-01>,
      <-4.731004E-01, 9.260013E-01>,
      <-4.656E-01, 9.935129E-01>,
      <-6.405473E-01, 9.949143E-01>,
      <-6.40607E-01, 9.202015E-01>,
      <-4.656596E-01, 9.188001E-01>,
      <-5.641788E-01, 5.883074E-01>,
      <-6.759159E-01, 5.810612E-01>,
      <-7.89536E-01, 5.358341E-01>,
      <-8.119286E-01, 5.077778E-01>,
      <-8.116856E-01, 4.483239E-01>,
      <-7.410533E-01, 4.395881E-01>,
      <-6.970152E-01, 4.04516E-01>,
      <-6.689128E-01, 3.726806E-01>,
      <-6.566107E-01, 3.278061E-01>,
      <-6.565531E-01, 2.993928E-01>,
      <-4.662144E-01, 2.999625E-01>,
      <-4.584077E-01, 3.620643E-01>,
      <-4.18784E-01, 4.152457E-01>,
      <-3.440497E-01, 4.475738E-01>,
      <-2.09929E-01, 4.480829E-01>,
      <-1.512954E-01, 4.158841E-01>,
      <-1.042293E-01, 3.633384E-01>,
      <-9.688789E-02, 3.026984E-01>,
      <-5.871534E-03, 3.031187E-01>,
      <-5.305231E-03, 5.902659E-01>,
      <-1.31005E-03, 5.938998E-01>,
      <-1.874804E-03, 3.024706E-01>,
      <-9.464604E-02, 3.021559E-01>,
      <-9.998667E-02, 3.625397E-01>,
      <-1.469352E-01, 4.14954E-01>,
      <-2.054224E-01, 4.470723E-01>,
      <-3.392073E-01, 4.465645E-01>,
      <-4.137549E-01, 4.143173E-01>,
      <-4.532796E-01, 3.612688E-01>,
      <-4.610668E-01, 2.993222E-01>,
      <-6.559296E-01, 2.98754E-01>,
      <-6.559871E-01, 3.270963E-01>,
      <-6.682582E-01, 3.718586E-01>,
      <-6.962906E-01, 4.036143E-01>,
      <-7.462181E-01, 4.416088E-01>,
      <-8.106839E-01, 4.483452E-01>,
      <-8.10926E-01, 5.06618E-01>,
      <-7.885892E-01, 5.346041E-01>,
      <-6.702439E-01, 5.847182E-01>,
      <-5.587863E-01, 5.919462E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex28}
   }
 
   face_indices { 
      152, 
      <1, 3, 2>, 0,
      <1, 2, 0>, 0,
      <3, 5, 4>, 0,
      <3, 4, 2>, 0,
      <5, 7, 6>, 0,
      <5, 6, 4>, 0,
      <7, 9, 8>, 0,
      <7, 8, 6>, 0,
      <9, 11, 10>, 0,
      <9, 10, 8>, 0,
      <11, 13, 12>, 0,
      <11, 12, 10>, 0,
      <13, 15, 14>, 0,
      <13, 14, 12>, 0,
      <15, 17, 16>, 0,
      <15, 16, 14>, 0,
      <17, 19, 18>, 0,
      <17, 18, 16>, 0,
      <19, 21, 20>, 0,
      <19, 20, 18>, 0,
      <21, 23, 22>, 0,
      <21, 22, 20>, 0,
      <23, 25, 24>, 0,
      <23, 24, 22>, 0,
      <25, 27, 26>, 0,
      <25, 26, 24>, 0,
      <27, 29, 28>, 0,
      <27, 28, 26>, 0,
      <29, 31, 30>, 0,
      <29, 30, 28>, 0,
      <31, 33, 32>, 0,
      <31, 32, 30>, 0,
      <33, 35, 34>, 0,
      <33, 34, 32>, 0,
      <35, 37, 36>, 0,
      <35, 36, 34>, 0,
      <37, 39, 38>, 0,
      <37, 38, 36>, 0,
      <39, 1, 0>, 0,
      <39, 0, 38>, 0,
      <0, 2, 4>, 0,
      <0, 4, 6>, 0,
      <0, 6, 8>, 0,
      <0, 8, 10>, 0,
      <0, 10, 12>, 0,
      <16, 18, 20>, 0,
      <16, 20, 22>, 0,
      <16, 22, 24>, 0,
      <16, 24, 26>, 0,
      <16, 26, 28>, 0,
      <28, 30, 32>, 0,
      <28, 32, 34>, 0,
      <28, 34, 36>, 0,
      <28, 36, 38>, 0,
      <28, 38, 0>, 0,
      <28, 0, 12>, 0,
      <28, 12, 14>, 0,
      <14, 16, 28>, 0,
      <1, 39, 37>, 0,
      <1, 37, 35>, 0,
      <1, 35, 33>, 0,
      <1, 33, 31>, 0,
      <1, 31, 29>, 0,
      <1, 29, 27>, 0,
      <1, 27, 25>, 0,
      <23, 21, 19>, 0,
      <23, 19, 17>, 0,
      <23, 17, 15>, 0,
      <23, 15, 13>, 0,
      <7, 5, 3>, 0,
      <7, 3, 1>, 0,
      <25, 23, 13>, 0,
      <9, 7, 1>, 0,
      <1, 25, 13>, 0,
      <1, 13, 11>, 0,
      <11, 9, 1>, 0,
      <0, 2, 3>, 0,
      <0, 3, 1>, 0,
      <2, 40, 41>, 0,
      <2, 41, 3>, 0,
      <40, 42, 43>, 0,
      <40, 43, 41>, 0,
      <42, 44, 45>, 0,
      <42, 45, 43>, 0,
      <44, 46, 47>, 0,
      <44, 47, 45>, 0,
      <46, 48, 49>, 0,
      <46, 49, 47>, 0,
      <48, 50, 51>, 0,
      <48, 51, 49>, 0,
      <50, 52, 53>, 0,
      <50, 53, 51>, 0,
      <52, 54, 55>, 0,
      <52, 55, 53>, 0,
      <54, 56, 57>, 0,
      <54, 57, 55>, 0,
      <56, 58, 59>, 0,
      <56, 59, 57>, 0,
      <58, 60, 61>, 0,
      <58, 61, 59>, 0,
      <60, 62, 63>, 0,
      <60, 63, 61>, 0,
      <62, 64, 65>, 0,
      <62, 65, 63>, 0,
      <64, 66, 67>, 0,
      <64, 67, 65>, 0,
      <66, 68, 69>, 0,
      <66, 69, 67>, 0,
      <68, 70, 71>, 0,
      <68, 71, 69>, 0,
      <70, 72, 73>, 0,
      <70, 73, 71>, 0,
      <72, 74, 75>, 0,
      <72, 75, 73>, 0,
      <74, 0, 1>, 0,
      <74, 1, 75>, 0,
      <0, 74, 72>, 0,
      <0, 72, 70>, 0,
      <0, 70, 68>, 0,
      <0, 68, 66>, 0,
      <0, 66, 64>, 0,
      <0, 64, 62>, 0,
      <0, 62, 60>, 0,
      <58, 56, 54>, 0,
      <58, 54, 52>, 0,
      <58, 52, 50>, 0,
      <58, 50, 48>, 0,
      <42, 40, 2>, 0,
      <42, 2, 0>, 0,
      <60, 58, 48>, 0,
      <44, 42, 0>, 0,
      <0, 60, 48>, 0,
      <0, 48, 46>, 0,
      <46, 44, 0>, 0,
      <1, 3, 41>, 0,
      <1, 41, 43>, 0,
      <1, 43, 45>, 0,
      <1, 45, 47>, 0,
      <1, 47, 49>, 0,
      <53, 55, 57>, 0,
      <53, 57, 59>, 0,
      <53, 59, 61>, 0,
      <53, 61, 63>, 0,
      <53, 63, 65>, 0,
      <65, 67, 69>, 0,
      <65, 69, 71>, 0,
      <65, 71, 73>, 0,
      <65, 73, 75>, 0,
      <65, 75, 1>, 0,
      <65, 1, 49>, 0,
      <65, 49, 51>, 0,
      <51, 53, 65>, 0
   }
 
   normal_indices { 
      152, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 3, 3>,
      <2, 3, 2>,
      <3, 4, 4>,
      <3, 4, 3>,
      <4, 5, 5>,
      <4, 5, 4>,
      <5, 6, 6>,
      <5, 6, 5>,
      <6, 7, 7>,
      <6, 7, 6>,
      <7, 8, 8>,
      <7, 8, 7>,
      <8, 9, 9>,
      <8, 9, 8>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 10, 10>,
      <2, 10, 2>,
      <10, 11, 11>,
      <10, 11, 10>,
      <11, 12, 12>,
      <11, 12, 11>,
      <12, 13, 13>,
      <12, 13, 12>,
      <13, 1, 1>,
      <13, 1, 13>,
      <2, 14, 14>,
      <2, 14, 2>,
      <14, 15, 15>,
      <14, 15, 14>,
      <15, 16, 16>,
      <15, 16, 15>,
      <16, 17, 17>,
      <16, 17, 16>,
      <17, 18, 18>,
      <17, 18, 17>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <2, 2, 2>,
      <2, 2, 2>,
      <1, 1, 1>,
      <1, 1, 1>,
      <0, 21, 21>,
      <0, 21, 0>,
      <21, 22, 22>,
      <21, 22, 21>,
      <22, 23, 23>,
      <22, 23, 22>,
      <23, 24, 24>,
      <23, 24, 23>,
      <24, 25, 25>,
      <24, 25, 24>,
      <25, 26, 26>,
      <25, 26, 25>,
      <26, 27, 27>,
      <26, 27, 26>,
      <1, 1, 1>,
      <1, 1, 1>,
      <0, 28, 28>,
      <0, 28, 0>,
      <28, 29, 29>,
      <28, 29, 28>,
      <29, 30, 30>,
      <29, 30, 29>,
      <30, 31, 31>,
      <30, 31, 30>,
      <31, 1, 1>,
      <31, 1, 31>,
      <0, 32, 32>,
      <0, 32, 0>,
      <32, 33, 33>,
      <32, 33, 32>,
      <33, 34, 34>,
      <33, 34, 33>,
      <34, 35, 35>,
      <34, 35, 34>,
      <35, 18, 18>,
      <35, 18, 35>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <19, 19, 19>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>,
      <20, 20, 20>
   }
 
   uv_indices { 
      152, 
      <127, 128, 128>,
      <127, 128, 127>,
      <178, 179, 180>,
      <178, 180, 181>,
      <182, 183, 184>,
      <182, 184, 185>,
      <186, 187, 188>,
      <186, 188, 189>,
      <190, 191, 192>,
      <190, 192, 193>,
      <194, 195, 196>,
      <194, 196, 197>,
      <198, 199, 200>,
      <198, 200, 201>,
      <202, 203, 204>,
      <202, 204, 205>,
      <206, 207, 208>,
      <206, 208, 209>,
      <210, 211, 212>,
      <210, 212, 213>,
      <214, 215, 216>,
      <214, 216, 217>,
      <218, 219, 220>,
      <218, 220, 221>,
      <222, 223, 224>,
      <222, 224, 225>,
      <226, 227, 228>,
      <226, 228, 229>,
      <230, 231, 232>,
      <230, 232, 233>,
      <234, 235, 236>,
      <234, 236, 237>,
      <238, 239, 240>,
      <238, 240, 241>,
      <242, 243, 244>,
      <242, 244, 245>,
      <246, 247, 248>,
      <246, 248, 249>,
      <250, 251, 252>,
      <250, 252, 253>,
      <254, 255, 256>,
      <254, 256, 257>,
      <254, 257, 258>,
      <254, 258, 259>,
      <254, 259, 260>,
      <262, 263, 264>,
      <262, 264, 265>,
      <262, 265, 266>,
      <262, 266, 267>,
      <262, 267, 268>,
      <268, 269, 270>,
      <268, 270, 271>,
      <268, 271, 272>,
      <268, 272, 273>,
      <268, 273, 254>,
      <268, 254, 260>,
      <268, 260, 261>,
      <261, 262, 268>,
      <293, 274, 275>,
      <293, 275, 276>,
      <293, 276, 277>,
      <293, 277, 278>,
      <293, 278, 279>,
      <293, 279, 280>,
      <293, 280, 281>,
      <282, 283, 284>,
      <282, 284, 285>,
      <282, 285, 286>,
      <282, 286, 287>,
      <290, 291, 292>,
      <290, 292, 293>,
      <281, 282, 287>,
      <289, 290, 293>,
      <293, 281, 287>,
      <293, 287, 288>,
      <288, 289, 293>,
      <294, 295, 296>,
      <294, 296, 297>,
      <298, 299, 300>,
      <298, 300, 301>,
      <302, 303, 304>,
      <302, 304, 305>,
      <306, 307, 308>,
      <306, 308, 309>,
      <310, 311, 312>,
      <310, 312, 313>,
      <314, 315, 316>,
      <314, 316, 317>,
      <318, 319, 320>,
      <318, 320, 321>,
      <322, 323, 324>,
      <322, 324, 325>,
      <326, 327, 328>,
      <326, 328, 329>,
      <330, 331, 332>,
      <330, 332, 333>,
      <334, 335, 336>,
      <334, 336, 337>,
      <338, 339, 340>,
      <338, 340, 341>,
      <342, 343, 344>,
      <342, 344, 345>,
      <346, 347, 348>,
      <346, 348, 349>,
      <350, 351, 352>,
      <350, 352, 353>,
      <354, 355, 356>,
      <354, 356, 357>,
      <358, 359, 360>,
      <358, 360, 361>,
      <362, 363, 364>,
      <362, 364, 365>,
      <366, 367, 368>,
      <366, 368, 369>,
      <370, 371, 372>,
      <370, 372, 373>,
      <393, 374, 375>,
      <393, 375, 376>,
      <393, 376, 377>,
      <393, 377, 378>,
      <393, 378, 379>,
      <393, 379, 380>,
      <393, 380, 381>,
      <382, 383, 384>,
      <382, 384, 385>,
      <382, 385, 386>,
      <382, 386, 387>,
      <390, 391, 392>,
      <390, 392, 393>,
      <381, 382, 387>,
      <389, 390, 393>,
      <393, 381, 387>,
      <393, 387, 388>,
      <388, 389, 393>,
      <394, 395, 396>,
      <394, 396, 397>,
      <394, 397, 398>,
      <394, 398, 399>,
      <394, 399, 400>,
      <402, 403, 404>,
      <402, 404, 405>,
      <402, 405, 406>,
      <402, 406, 407>,
      <402, 407, 408>,
      <408, 409, 410>,
      <408, 410, 411>,
      <408, 411, 412>,
      <408, 412, 413>,
      <408, 413, 394>,
      <408, 394, 400>,
      <408, 400, 401>,
      <401, 402, 408>
   }
   uv_mapping
}
 
// Rim-Outer
mesh2 {
 
   vertex_vectors { 
      64, 
      <-1.025379E+00, 2.955485E+00, -1.86902E+00>,
      <-1.419378E+00, 2.955485E+00, -1.86902E+00>,
      <-1.025379E+00, 3.247755E+00, -1.840235E+00>,
      <-1.419378E+00, 3.247755E+00, -1.840235E+00>,
      <-1.025379E+00, 3.528792E+00, -1.754982E+00>,
      <-1.419378E+00, 3.528792E+00, -1.754982E+00>,
      <-1.025379E+00, 3.787798E+00, -1.61654E+00>,
      <-1.419378E+00, 3.787798E+00, -1.616541E+00>,
      <-1.025379E+00, 4.014819E+00, -1.43023E+00>,
      <-1.419378E+00, 4.014819E+00, -1.43023E+00>,
      <-1.025379E+00, 4.20113E+00, -1.20321E+00>,
      <-1.419378E+00, 4.20113E+00, -1.20321E+00>,
      <-1.025379E+00, 4.339571E+00, -9.442024E-01>,
      <-1.419378E+00, 4.339571E+00, -9.442025E-01>,
      <-1.025379E+00, 4.424824E+00, -6.631641E-01>,
      <-1.419378E+00, 4.424824E+00, -6.631643E-01>,
      <-1.025379E+00, 4.45361E+00, -3.708954E-01>,
      <-1.419378E+00, 4.45361E+00, -3.708955E-01>,
      <-1.025379E+00, 4.424824E+00, -7.862663E-02>,
      <-1.419378E+00, 4.424824E+00, -7.862676E-02>,
      <-1.025379E+00, 4.339571E+00, 2.024117E-01>,
      <-1.419379E+00, 4.339571E+00, 2.024115E-01>,
      <-1.025379E+00, 4.20113E+00, 4.614196E-01>,
      <-1.419379E+00, 4.20113E+00, 4.614195E-01>,
      <-1.02538E+00, 4.014819E+00, 6.884375E-01>,
      <-1.419379E+00, 4.014819E+00, 6.884373E-01>,
      <-1.02538E+00, 3.787798E+00, 8.747492E-01>,
      <-1.419379E+00, 3.787798E+00, 8.747491E-01>,
      <-1.02538E+00, 3.528792E+00, 1.013191E+00>,
      <-1.419379E+00, 3.528792E+00, 1.013191E+00>,
      <-1.02538E+00, 3.247755E+00, 1.098444E+00>,
      <-1.419379E+00, 3.247755E+00, 1.098444E+00>,
      <-1.02538E+00, 2.955485E+00, 1.127229E+00>,
      <-1.419379E+00, 2.955485E+00, 1.127229E+00>,
      <-1.02538E+00, 2.663215E+00, 1.098444E+00>,
      <-1.419379E+00, 2.663215E+00, 1.098444E+00>,
      <-1.02538E+00, 2.382177E+00, 1.013191E+00>,
      <-1.419379E+00, 2.382177E+00, 1.013191E+00>,
      <-1.02538E+00, 2.123171E+00, 8.747492E-01>,
      <-1.419379E+00, 2.123171E+00, 8.747491E-01>,
      <-1.02538E+00, 1.89615E+00, 6.884375E-01>,
      <-1.419379E+00, 1.89615E+00, 6.884373E-01>,
      <-1.025379E+00, 1.70984E+00, 4.614196E-01>,
      <-1.419379E+00, 1.70984E+00, 4.614195E-01>,
      <-1.025379E+00, 1.571398E+00, 2.024117E-01>,
      <-1.419379E+00, 1.571398E+00, 2.024115E-01>,
      <-1.025379E+00, 1.486146E+00, -7.862663E-02>,
      <-1.419378E+00, 1.486146E+00, -7.862676E-02>,
      <-1.025379E+00, 1.45736E+00, -3.708954E-01>,
      <-1.419378E+00, 1.45736E+00, -3.708955E-01>,
      <-1.025379E+00, 1.486146E+00, -6.631641E-01>,
      <-1.419378E+00, 1.486146E+00, -6.631643E-01>,
      <-1.025379E+00, 1.571398E+00, -9.442024E-01>,
      <-1.419378E+00, 1.571398E+00, -9.442025E-01>,
      <-1.025379E+00, 1.70984E+00, -1.20321E+00>,
      <-1.419378E+00, 1.70984E+00, -1.20321E+00>,
      <-1.025379E+00, 1.89615E+00, -1.43023E+00>,
      <-1.419378E+00, 1.89615E+00, -1.43023E+00>,
      <-1.025379E+00, 2.123171E+00, -1.61654E+00>,
      <-1.419378E+00, 2.123171E+00, -1.616541E+00>,
      <-1.025379E+00, 2.382177E+00, -1.754982E+00>,
      <-1.419378E+00, 2.382177E+00, -1.754982E+00>,
      <-1.025379E+00, 2.663215E+00, -1.840235E+00>,
      <-1.419378E+00, 2.663215E+00, -1.840235E+00>
   }
 
   normal_vectors { 
      32, 
      <3.195804E-07, 1.950904E-01, -9.807853E-01>,
      <3.258414E-07, 2.067536E-07, -1.00E+00>,
      <3.01038E-07, 3.826849E-01, -9.23879E-01>,
      <2.709274E-07, 5.555693E-01, -8.314704E-01>,
      <2.30405E-07, 7.071058E-01, -7.07108E-01>,
      <1.810274E-07, 8.314704E-01, -5.555692E-01>,
      <1.246937E-07, 9.238802E-01, -3.826823E-01>,
      <6.356863E-08, 9.807854E-01, -1.950908E-01>,
      <-3.797453E-16, 1.00E+00, 2.550416E-16>,
      <-6.356859E-08, 9.807854E-01, 1.950906E-01>,
      <-1.246937E-07, 9.238802E-01, 3.826822E-01>,
      <-1.810281E-07, 8.314692E-01, 5.555712E-01>,
      <-2.304049E-07, 7.071061E-01, 7.071076E-01>,
      <-2.709269E-07, 5.555717E-01, 8.314688E-01>,
      <-3.01038E-07, 3.82685E-01, 9.23879E-01>,
      <-3.195804E-07, 1.950904E-01, 9.807853E-01>,
      <-3.258414E-07, 2.067536E-07, 1.00E+00>,
      <-3.195804E-07, -1.9509E-01, 9.807853E-01>,
      <-3.01038E-07, -3.826844E-01, 9.23879E-01>,
      <-2.709269E-07, -5.555713E-01, 8.314688E-01>,
      <-2.304049E-07, -7.071057E-01, 7.071077E-01>,
      <-1.810281E-07, -8.314688E-01, 5.555713E-01>,
      <-1.246936E-07, -9.2388E-01, 3.826818E-01>,
      <-6.356853E-08, -9.807851E-01, 1.950904E-01>,
      <3.797453E-16, -9.999998E-01, -2.550416E-16>,
      <6.356855E-08, -9.807851E-01, -1.950905E-01>,
      <1.246936E-07, -9.2388E-01, -3.826818E-01>,
      <1.810275E-07, -8.3147E-01, -5.555694E-01>,
      <2.304051E-07, -7.071053E-01, -7.071081E-01>,
      <2.709274E-07, -5.555689E-01, -8.314703E-01>,
      <3.01038E-07, -3.826845E-01, -9.23879E-01>,
      <3.195804E-07, -1.9509E-01, -9.807853E-01>
   }
 
   uv_vectors { 
      43, 
      <0.00E+00, 0.00E+00>,
      <-6.000006E-02, 1.855E-01>,
      <-3.000009E-02, 1.855E-01>,
      <-3.000009E-02, 1.175E-01>,
      <-6.000006E-02, 1.175E-01>,
      <-5.999994E-02, 1.514999E-01>,
      <-2.999991E-02, 1.514999E-01>,
      <-4.500002E-02, 1.175002E-01>,
      <-4.500002E-02, 1.855002E-01>,
      <-9.956325E-01, 6.754004E-01>,
      <-9.956325E-01, 5.006004E-01>,
      <-9.988E-01, 5.006004E-01>,
      <-9.988E-01, 6.754004E-01>,
      <-9.862515E-01, 6.754004E-01>,
      <-9.862515E-01, 5.006004E-01>,
      <-9.710177E-01, 6.754004E-01>,
      <-9.710177E-01, 5.006004E-01>,
      <-9.505166E-01, 6.754004E-01>,
      <-9.505166E-01, 5.006004E-01>,
      <-9.255359E-01, 6.754004E-01>,
      <-9.255359E-01, 5.006004E-01>,
      <-8.970353E-01, 6.754004E-01>,
      <-8.970353E-01, 5.006004E-01>,
      <-8.661105E-01, 6.754004E-01>,
      <-8.661105E-01, 5.006004E-01>,
      <-8.3395E-01, 6.754004E-01>,
      <-8.3395E-01, 5.006004E-01>,
      <-8.017895E-01, 6.754004E-01>,
      <-8.017895E-01, 5.006004E-01>,
      <-7.708647E-01, 6.754004E-01>,
      <-7.708647E-01, 5.006004E-01>,
      <-7.423641E-01, 6.754004E-01>,
      <-7.423641E-01, 5.006004E-01>,
      <-7.173836E-01, 6.754004E-01>,
      <-7.173836E-01, 5.006004E-01>,
      <-6.968822E-01, 6.754004E-01>,
      <-6.968822E-01, 5.006004E-01>,
      <-6.816484E-01, 6.754004E-01>,
      <-6.816484E-01, 5.006004E-01>,
      <-6.722674E-01, 6.754004E-01>,
      <-6.722674E-01, 5.006004E-01>,
      <-6.691E-01, 6.754004E-01>,
      <-6.691E-01, 5.006004E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      64, 
      <3, 2, 0>, 0,
      <3, 0, 1>, 0,
      <5, 4, 2>, 0,
      <5, 2, 3>, 0,
      <7, 6, 4>, 0,
      <7, 4, 5>, 0,
      <9, 8, 6>, 0,
      <9, 6, 7>, 0,
      <11, 10, 8>, 0,
      <11, 8, 9>, 0,
      <13, 12, 10>, 0,
      <13, 10, 11>, 0,
      <15, 14, 12>, 0,
      <15, 12, 13>, 0,
      <17, 16, 14>, 0,
      <17, 14, 15>, 0,
      <19, 18, 16>, 0,
      <19, 16, 17>, 0,
      <21, 20, 18>, 0,
      <21, 18, 19>, 0,
      <23, 22, 20>, 0,
      <23, 20, 21>, 0,
      <25, 24, 22>, 0,
      <25, 22, 23>, 0,
      <27, 26, 24>, 0,
      <27, 24, 25>, 0,
      <29, 28, 26>, 0,
      <29, 26, 27>, 0,
      <31, 30, 28>, 0,
      <31, 28, 29>, 0,
      <33, 32, 30>, 0,
      <33, 30, 31>, 0,
      <35, 34, 32>, 0,
      <35, 32, 33>, 0,
      <37, 36, 34>, 0,
      <37, 34, 35>, 0,
      <39, 38, 36>, 0,
      <39, 36, 37>, 0,
      <41, 40, 38>, 0,
      <41, 38, 39>, 0,
      <43, 42, 40>, 0,
      <43, 40, 41>, 0,
      <45, 44, 42>, 0,
      <45, 42, 43>, 0,
      <47, 46, 44>, 0,
      <47, 44, 45>, 0,
      <49, 48, 46>, 0,
      <49, 46, 47>, 0,
      <51, 50, 48>, 0,
      <51, 48, 49>, 0,
      <53, 52, 50>, 0,
      <53, 50, 51>, 0,
      <55, 54, 52>, 0,
      <55, 52, 53>, 0,
      <57, 56, 54>, 0,
      <57, 54, 55>, 0,
      <59, 58, 56>, 0,
      <59, 56, 57>, 0,
      <61, 60, 58>, 0,
      <61, 58, 59>, 0,
      <63, 62, 60>, 0,
      <63, 60, 61>, 0,
      <1, 0, 62>, 0,
      <1, 62, 63>, 0
   }
 
   normal_indices { 
      64, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 2, 0>,
      <2, 0, 0>,
      <3, 3, 2>,
      <3, 2, 2>,
      <4, 4, 3>,
      <4, 3, 3>,
      <5, 5, 4>,
      <5, 4, 4>,
      <6, 6, 5>,
      <6, 5, 5>,
      <7, 7, 6>,
      <7, 6, 6>,
      <8, 8, 7>,
      <8, 7, 7>,
      <9, 9, 8>,
      <9, 8, 8>,
      <10, 10, 9>,
      <10, 9, 9>,
      <11, 11, 10>,
      <11, 10, 10>,
      <12, 12, 11>,
      <12, 11, 11>,
      <13, 13, 12>,
      <13, 12, 12>,
      <14, 14, 13>,
      <14, 13, 13>,
      <15, 15, 14>,
      <15, 14, 14>,
      <16, 16, 15>,
      <16, 15, 15>,
      <17, 17, 16>,
      <17, 16, 16>,
      <18, 18, 17>,
      <18, 17, 17>,
      <19, 19, 18>,
      <19, 18, 18>,
      <20, 20, 19>,
      <20, 19, 19>,
      <21, 21, 20>,
      <21, 20, 20>,
      <22, 22, 21>,
      <22, 21, 21>,
      <23, 23, 22>,
      <23, 22, 22>,
      <24, 24, 23>,
      <24, 23, 23>,
      <25, 25, 24>,
      <25, 24, 24>,
      <26, 26, 25>,
      <26, 25, 25>,
      <27, 27, 26>,
      <27, 26, 26>,
      <28, 28, 27>,
      <28, 27, 27>,
      <29, 29, 28>,
      <29, 28, 28>,
      <30, 30, 29>,
      <30, 29, 29>,
      <31, 31, 30>,
      <31, 30, 30>,
      <1, 1, 31>,
      <1, 31, 31>
   }
 
   uv_indices { 
      64, 
      <9, 10, 11>,
      <9, 11, 12>,
      <13, 14, 10>,
      <13, 10, 9>,
      <15, 16, 14>,
      <15, 14, 13>,
      <17, 18, 16>,
      <17, 16, 15>,
      <19, 20, 18>,
      <19, 18, 17>,
      <21, 22, 20>,
      <21, 20, 19>,
      <23, 24, 22>,
      <23, 22, 21>,
      <25, 26, 24>,
      <25, 24, 23>,
      <27, 28, 26>,
      <27, 26, 25>,
      <29, 30, 28>,
      <29, 28, 27>,
      <31, 32, 30>,
      <31, 30, 29>,
      <33, 34, 32>,
      <33, 32, 31>,
      <35, 36, 34>,
      <35, 34, 33>,
      <37, 38, 36>,
      <37, 36, 35>,
      <39, 40, 38>,
      <39, 38, 37>,
      <41, 42, 40>,
      <41, 40, 39>,
      <39, 40, 42>,
      <39, 42, 41>,
      <37, 38, 40>,
      <37, 40, 39>,
      <35, 36, 38>,
      <35, 38, 37>,
      <33, 34, 36>,
      <33, 36, 35>,
      <31, 32, 34>,
      <31, 34, 33>,
      <29, 30, 32>,
      <29, 32, 31>,
      <27, 28, 30>,
      <27, 30, 29>,
      <25, 26, 28>,
      <25, 28, 27>,
      <23, 24, 26>,
      <23, 26, 25>,
      <21, 22, 24>,
      <21, 24, 23>,
      <19, 20, 22>,
      <19, 22, 21>,
      <17, 18, 20>,
      <17, 20, 19>,
      <15, 16, 18>,
      <15, 18, 17>,
      <13, 14, 16>,
      <13, 16, 15>,
      <9, 10, 14>,
      <9, 14, 13>,
      <12, 11, 10>,
      <12, 10, 9>
   }
   uv_mapping
}
 
// Faces
mesh2 {
 
   vertex_vectors { 
      8, 
      <-1.419379E+00, 1.45736E+00, 1.127229E+00>,
      <-1.419378E+00, 1.45736E+00, -1.86902E+00>,
      <-1.419378E+00, 4.45361E+00, -1.86902E+00>,
      <-1.419379E+00, 4.45361E+00, 1.127229E+00>,
      <-1.025379E+00, 4.45361E+00, -1.86902E+00>,
      <-1.02538E+00, 4.45361E+00, 1.127229E+00>,
      <-1.02538E+00, 1.45736E+00, 1.127229E+00>,
      <-1.025379E+00, 1.45736E+00, -1.86902E+00>
   }
 
   normal_vectors { 
      2, 
      <-1.00E+00, 2.067536E-07, -3.258414E-07>,
      <1.00E+00, 2.067536E-07, 3.258414E-07>
   }
 
   uv_vectors { 
      15, 
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <-1.00E+00, 2.50E-01>,
      <-7.500001E-01, 2.50E-01>,
      <-7.500001E-01, 0.00E+00>,
      <-1.00E+00, 0.00E+00>,
      <-5.00E-01, 5.00E-01>,
      <0.00E+00, 5.00E-01>,
      <-5.00E-01, 0.00E+00>,
      <-1.00E+00, 5.00E-01>,
      <-1.00E+00, 0.00E+00>,
      <1.192093E-07, 5.00E-01>,
      <-4.999999E-01, 5.00E-01>,
      <-4.999999E-01, 0.00E+00>,
      <1.192093E-07, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      4, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0
   }
 
   normal_indices { 
      4, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>
   }
 
   uv_indices { 
      4, 
      <6, 9, 10>,
      <6, 10, 8>,
      <11, 12, 13>,
      <11, 13, 14>
   }
   uv_mapping
}
 
// Flange
mesh2 {
 
   vertex_vectors { 
      4, 
      <-1.02538E+00, 1.264611E+00, 1.319979E+00>,
      <-1.025379E+00, 1.264611E+00, -2.061769E+00>,
      <-1.025379E+00, 4.646359E+00, -2.061769E+00>,
      <-1.02538E+00, 4.646359E+00, 1.319979E+00>
   }
 
   normal_vectors { 
      1, 
      <-1.00E+00, 2.067536E-07, -3.258414E-07>
   }
 
   uv_vectors { 
      9, 
      <0.00E+00, 0.00E+00>,
      <-1.00E+00, 2.50E-01>,
      <-7.50E-01, 2.50E-01>,
      <-7.50E-01, 0.00E+00>,
      <-1.00E+00, 0.00E+00>,
      <-4.999999E-01, 5.00E-01>,
      <-9.999999E-01, 5.00E-01>,
      <-9.999999E-01, 0.00E+00>,
      <-4.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      2, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0
   }
 
   normal_indices { 
      2, 
      <0, 0, 0>,
      <0, 0, 0>
   }
 
   uv_indices { 
      2, 
      <5, 6, 7>,
      <5, 7, 8>
   }
   uv_mapping
}
 
// Rim-Outer
mesh2 {
 
   vertex_vectors { 
      64, 
      <3.682621E+00, 1.45736E+00, -3.708939E-01>,
      <4.076622E+00, 1.45736E+00, -3.708937E-01>,
      <3.682621E+00, 1.486146E+00, -7.86251E-02>,
      <4.076622E+00, 1.486146E+00, -7.862497E-02>,
      <3.682621E+00, 1.571398E+00, 2.024132E-01>,
      <4.076622E+00, 1.571398E+00, 2.024133E-01>,
      <3.682621E+00, 1.709839E+00, 4.614211E-01>,
      <4.076622E+00, 1.70984E+00, 4.614213E-01>,
      <3.682621E+00, 1.89615E+00, 6.88439E-01>,
      <4.076622E+00, 1.89615E+00, 6.884391E-01>,
      <3.682621E+00, 2.123171E+00, 8.747517E-01>,
      <4.076622E+00, 2.123171E+00, 8.747518E-01>,
      <3.682621E+00, 2.382177E+00, 1.013193E+00>,
      <4.076622E+00, 2.382177E+00, 1.013193E+00>,
      <3.682621E+00, 2.663215E+00, 1.098446E+00>,
      <4.076622E+00, 2.663215E+00, 1.098446E+00>,
      <3.682621E+00, 2.955485E+00, 1.12723E+00>,
      <4.076622E+00, 2.955485E+00, 1.127231E+00>,
      <3.682621E+00, 3.247755E+00, 1.098446E+00>,
      <4.076622E+00, 3.247755E+00, 1.098446E+00>,
      <3.682621E+00, 3.528792E+00, 1.013193E+00>,
      <4.076622E+00, 3.528792E+00, 1.013193E+00>,
      <3.682621E+00, 3.787798E+00, 8.747507E-01>,
      <4.076622E+00, 3.787798E+00, 8.747509E-01>,
      <3.682621E+00, 4.014819E+00, 6.884409E-01>,
      <4.076622E+00, 4.014819E+00, 6.884391E-01>,
      <3.682621E+00, 4.20113E+00, 4.614211E-01>,
      <4.076622E+00, 4.20113E+00, 4.614213E-01>,
      <3.682621E+00, 4.339572E+00, 2.024132E-01>,
      <4.076622E+00, 4.339571E+00, 2.024133E-01>,
      <3.682621E+00, 4.424824E+00, -7.86251E-02>,
      <4.076622E+00, 4.424824E+00, -7.862497E-02>,
      <3.682621E+00, 4.45361E+00, -3.708939E-01>,
      <4.076622E+00, 4.45361E+00, -3.708937E-01>,
      <3.682621E+00, 4.424824E+00, -6.631626E-01>,
      <4.076622E+00, 4.424824E+00, -6.631625E-01>,
      <3.682621E+00, 4.339572E+00, -9.442009E-01>,
      <4.076622E+00, 4.339571E+00, -9.442008E-01>,
      <3.682621E+00, 4.20113E+00, -1.203209E+00>,
      <4.076622E+00, 4.20113E+00, -1.203209E+00>,
      <3.682621E+00, 4.01482E+00, -1.430229E+00>,
      <4.076622E+00, 4.014819E+00, -1.430228E+00>,
      <3.682621E+00, 3.787799E+00, -1.616539E+00>,
      <4.076622E+00, 3.787799E+00, -1.616539E+00>,
      <3.682621E+00, 3.528792E+00, -1.75498E+00>,
      <4.076622E+00, 3.528792E+00, -1.75498E+00>,
      <3.682621E+00, 3.247755E+00, -1.840233E+00>,
      <4.076622E+00, 3.247755E+00, -1.840233E+00>,
      <3.682621E+00, 2.955485E+00, -1.869018E+00>,
      <4.076622E+00, 2.955485E+00, -1.869018E+00>,
      <3.682621E+00, 2.663215E+00, -1.840233E+00>,
      <4.076622E+00, 2.663215E+00, -1.840233E+00>,
      <3.682621E+00, 2.382177E+00, -1.75498E+00>,
      <4.076622E+00, 2.382177E+00, -1.75498E+00>,
      <3.682621E+00, 2.123171E+00, -1.616539E+00>,
      <4.076622E+00, 2.123171E+00, -1.616539E+00>,
      <3.682621E+00, 1.896151E+00, -1.430229E+00>,
      <4.076622E+00, 1.896151E+00, -1.430228E+00>,
      <3.682621E+00, 1.70984E+00, -1.203209E+00>,
      <4.076622E+00, 1.70984E+00, -1.203209E+00>,
      <3.682621E+00, 1.571398E+00, -9.442009E-01>,
      <4.076622E+00, 1.571398E+00, -9.442008E-01>,
      <3.682621E+00, 1.486146E+00, -6.631626E-01>,
      <4.076622E+00, 1.486146E+00, -6.631625E-01>
   }
 
   normal_vectors { 
      32, 
      <2.409085E-07, -9.807851E-01, 1.950905E-01>,
      <3.797453E-16, -9.999998E-01, -2.550416E-16>,
      <1.074323E-07, -9.2388E-01, 3.826819E-01>,
      <6.338056E-08, -8.314688E-01, 5.555713E-01>,
      <2.529803E-08, -7.071057E-01, 7.071077E-01>,
      <-1.982195E-07, -5.555713E-01, 8.314688E-01>,
      <-2.70354E-07, -3.826845E-01, 9.23879E-01>,
      <-2.706133E-07, -1.950898E-01, 9.807854E-01>,
      <-3.258414E-07, 2.067536E-07, 1.00E+00>,
      <-3.195804E-07, 1.950901E-01, 9.807854E-01>,
      <-3.01038E-07, 3.826849E-01, 9.23879E-01>,
      <7.173755E-07, 5.555704E-01, 8.314696E-01>,
      <1.616972E-06, 7.071058E-01, 7.07108E-01>,
      <8.807863E-07, 8.314698E-01, 5.555702E-01>,
      <2.227462E-07, 9.238803E-01, 3.82682E-01>,
      <2.331787E-07, 9.807854E-01, 1.950905E-01>,
      <-3.797453E-16, 1.00E+00, 2.550416E-16>,
      <3.676623E-07, 9.807854E-01, -1.950906E-01>,
      <5.121551E-07, 9.238803E-01, -3.82682E-01>,
      <6.698421E-07, 8.314705E-01, -5.555691E-01>,
      <6.196972E-07, 7.071058E-01, -7.07108E-01>,
      <4.068199E-07, 5.555693E-01, -8.314704E-01>,
      <3.229491E-07, 3.826849E-01, -9.23879E-01>,
      <3.414915E-07, 1.950902E-01, -9.807854E-01>,
      <3.258414E-07, 2.067536E-07, -1.00E+00>,
      <3.195804E-07, -1.950897E-01, -9.807854E-01>,
      <3.770614E-07, -3.826844E-01, -9.23879E-01>,
      <4.321159E-07, -5.555689E-01, -8.314704E-01>,
      <4.376826E-07, -7.071054E-01, -7.07108E-01>,
      <3.664983E-07, -8.3147E-01, -5.555693E-01>,
      <3.364254E-07, -9.238799E-01, -3.826821E-01>,
      <3.636057E-07, -9.807851E-01, -1.950905E-01>
   }
 
   uv_vectors { 
      41, 
      <0.00E+00, 0.00E+00>,
      <-3.000003E-02, 1.175E-01>,
      <-6.00E-02, 1.175E-01>,
      <-6.00E-02, 1.855E-01>,
      <-3.000003E-02, 1.855E-01>,
      <-6.00E-02, 1.514999E-01>,
      <-3.000003E-02, 1.514999E-01>,
      <-8.017895E-01, 6.754E-01>,
      <-8.017895E-01, 5.006E-01>,
      <-8.3395E-01, 5.006E-01>,
      <-8.3395E-01, 6.754E-01>,
      <-7.708647E-01, 6.754E-01>,
      <-7.708647E-01, 5.006E-01>,
      <-7.423641E-01, 6.754E-01>,
      <-7.423641E-01, 5.006E-01>,
      <-7.173836E-01, 6.754E-01>,
      <-7.173836E-01, 5.006E-01>,
      <-6.968822E-01, 6.754E-01>,
      <-6.968822E-01, 5.006E-01>,
      <-6.816484E-01, 6.754E-01>,
      <-6.816484E-01, 5.006E-01>,
      <-6.722674E-01, 6.754E-01>,
      <-6.722674E-01, 5.006E-01>,
      <-6.691E-01, 6.754E-01>,
      <-6.691E-01, 5.006E-01>,
      <-8.661105E-01, 6.754E-01>,
      <-8.661105E-01, 5.006E-01>,
      <-8.970353E-01, 6.754E-01>,
      <-8.970353E-01, 5.006E-01>,
      <-9.255359E-01, 6.754E-01>,
      <-9.255359E-01, 5.006E-01>,
      <-9.505166E-01, 6.754E-01>,
      <-9.505166E-01, 5.006E-01>,
      <-9.710177E-01, 6.754E-01>,
      <-9.710177E-01, 5.006E-01>,
      <-9.862515E-01, 6.754E-01>,
      <-9.862515E-01, 5.006E-01>,
      <-9.956325E-01, 6.754E-01>,
      <-9.956325E-01, 5.006E-01>,
      <-9.988E-01, 6.754E-01>,
      <-9.988E-01, 5.006E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      64, 
      <3, 2, 0>, 0,
      <3, 0, 1>, 0,
      <5, 4, 2>, 0,
      <5, 2, 3>, 0,
      <7, 6, 4>, 0,
      <7, 4, 5>, 0,
      <9, 8, 6>, 0,
      <9, 6, 7>, 0,
      <11, 10, 8>, 0,
      <11, 8, 9>, 0,
      <13, 12, 10>, 0,
      <13, 10, 11>, 0,
      <15, 14, 12>, 0,
      <15, 12, 13>, 0,
      <17, 16, 14>, 0,
      <17, 14, 15>, 0,
      <19, 18, 16>, 0,
      <19, 16, 17>, 0,
      <21, 20, 18>, 0,
      <21, 18, 19>, 0,
      <23, 22, 20>, 0,
      <23, 20, 21>, 0,
      <25, 24, 22>, 0,
      <25, 22, 23>, 0,
      <27, 26, 24>, 0,
      <27, 24, 25>, 0,
      <29, 28, 26>, 0,
      <29, 26, 27>, 0,
      <31, 30, 28>, 0,
      <31, 28, 29>, 0,
      <33, 32, 30>, 0,
      <33, 30, 31>, 0,
      <35, 34, 32>, 0,
      <35, 32, 33>, 0,
      <37, 36, 34>, 0,
      <37, 34, 35>, 0,
      <39, 38, 36>, 0,
      <39, 36, 37>, 0,
      <41, 40, 38>, 0,
      <41, 38, 39>, 0,
      <43, 42, 40>, 0,
      <43, 40, 41>, 0,
      <45, 44, 42>, 0,
      <45, 42, 43>, 0,
      <47, 46, 44>, 0,
      <47, 44, 45>, 0,
      <49, 48, 46>, 0,
      <49, 46, 47>, 0,
      <51, 50, 48>, 0,
      <51, 48, 49>, 0,
      <53, 52, 50>, 0,
      <53, 50, 51>, 0,
      <55, 54, 52>, 0,
      <55, 52, 53>, 0,
      <57, 56, 54>, 0,
      <57, 54, 55>, 0,
      <59, 58, 56>, 0,
      <59, 56, 57>, 0,
      <61, 60, 58>, 0,
      <61, 58, 59>, 0,
      <63, 62, 60>, 0,
      <63, 60, 61>, 0,
      <1, 0, 62>, 0,
      <1, 62, 63>, 0
   }
 
   normal_indices { 
      64, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 2, 0>,
      <2, 0, 0>,
      <3, 3, 2>,
      <3, 2, 2>,
      <4, 4, 3>,
      <4, 3, 3>,
      <5, 5, 4>,
      <5, 4, 4>,
      <6, 6, 5>,
      <6, 5, 5>,
      <7, 7, 6>,
      <7, 6, 6>,
      <8, 8, 7>,
      <8, 7, 7>,
      <9, 9, 8>,
      <9, 8, 8>,
      <10, 10, 9>,
      <10, 9, 9>,
      <11, 11, 10>,
      <11, 10, 10>,
      <12, 12, 11>,
      <12, 11, 11>,
      <13, 13, 12>,
      <13, 12, 12>,
      <14, 14, 13>,
      <14, 13, 13>,
      <15, 15, 14>,
      <15, 14, 14>,
      <16, 16, 15>,
      <16, 15, 15>,
      <17, 17, 16>,
      <17, 16, 16>,
      <18, 18, 17>,
      <18, 17, 17>,
      <19, 19, 18>,
      <19, 18, 18>,
      <20, 20, 19>,
      <20, 19, 19>,
      <21, 21, 20>,
      <21, 20, 20>,
      <22, 22, 21>,
      <22, 21, 21>,
      <23, 23, 22>,
      <23, 22, 22>,
      <24, 24, 23>,
      <24, 23, 23>,
      <25, 25, 24>,
      <25, 24, 24>,
      <26, 26, 25>,
      <26, 25, 25>,
      <27, 27, 26>,
      <27, 26, 26>,
      <28, 28, 27>,
      <28, 27, 27>,
      <29, 29, 28>,
      <29, 28, 28>,
      <30, 30, 29>,
      <30, 29, 29>,
      <31, 31, 30>,
      <31, 30, 30>,
      <1, 1, 31>,
      <1, 31, 31>
   }
 
   uv_indices { 
      64, 
      <7, 8, 9>,
      <7, 9, 10>,
      <11, 12, 8>,
      <11, 8, 7>,
      <13, 14, 12>,
      <13, 12, 11>,
      <15, 16, 14>,
      <15, 14, 13>,
      <17, 18, 16>,
      <17, 16, 15>,
      <19, 20, 18>,
      <19, 18, 17>,
      <21, 22, 20>,
      <21, 20, 19>,
      <23, 24, 22>,
      <23, 22, 21>,
      <21, 22, 24>,
      <21, 24, 23>,
      <19, 20, 22>,
      <19, 22, 21>,
      <17, 18, 20>,
      <17, 20, 19>,
      <15, 16, 18>,
      <15, 18, 17>,
      <13, 14, 16>,
      <13, 16, 15>,
      <11, 12, 14>,
      <11, 14, 13>,
      <7, 8, 12>,
      <7, 12, 11>,
      <10, 9, 8>,
      <10, 8, 7>,
      <25, 26, 9>,
      <25, 9, 10>,
      <27, 28, 26>,
      <27, 26, 25>,
      <29, 30, 28>,
      <29, 28, 27>,
      <31, 32, 30>,
      <31, 30, 29>,
      <33, 34, 32>,
      <33, 32, 31>,
      <35, 36, 34>,
      <35, 34, 33>,
      <37, 38, 36>,
      <37, 36, 35>,
      <39, 40, 38>,
      <39, 38, 37>,
      <37, 38, 40>,
      <37, 40, 39>,
      <35, 36, 38>,
      <35, 38, 37>,
      <33, 34, 36>,
      <33, 36, 35>,
      <31, 32, 34>,
      <31, 34, 33>,
      <29, 30, 32>,
      <29, 32, 31>,
      <27, 28, 30>,
      <27, 30, 29>,
      <25, 26, 28>,
      <25, 28, 27>,
      <10, 9, 26>,
      <10, 26, 25>
   }
   uv_mapping
}
 
// Faces
mesh2 {
 
   vertex_vectors { 
      8, 
      <4.076622E+00, 4.45361E+00, -1.869018E+00>,
      <4.076622E+00, 1.45736E+00, -1.869018E+00>,
      <4.076622E+00, 1.45736E+00, 1.127231E+00>,
      <4.076622E+00, 4.45361E+00, 1.12723E+00>,
      <3.682621E+00, 1.45736E+00, 1.127231E+00>,
      <3.682621E+00, 4.45361E+00, 1.12723E+00>,
      <3.682621E+00, 4.45361E+00, -1.869018E+00>,
      <3.682621E+00, 1.45736E+00, -1.869018E+00>
   }
 
   normal_vectors { 
      2, 
      <1.00E+00, 2.067536E-07, 3.258414E-07>,
      <-1.00E+00, 2.067536E-07, -3.258414E-07>
   }
 
   uv_vectors { 
      13, 
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <-9.999999E-01, 0.00E+00>,
      <-9.999999E-01, 2.50E-01>,
      <-7.499999E-01, 2.50E-01>,
      <-7.499999E-01, 0.00E+00>,
      <-7.499999E-01, 2.50E-01>,
      <0.00E+00, 5.00E-01>,
      <-5.00E-01, 0.00E+00>,
      <-5.00E-01, 5.00E-01>,
      <-1.00E+00, 5.00E-01>,
      <-1.00E+00, 0.00E+00>,
      <-1.192093E-07, 5.00E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      4, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0
   }
 
   normal_indices { 
      4, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>
   }
 
   uv_indices { 
      4, 
      <10, 11, 8>,
      <10, 8, 9>,
      <0, 12, 9>,
      <0, 9, 8>
   }
   uv_mapping
}
 
// Flange
mesh2 {
 
   vertex_vectors { 
      4, 
      <3.682621E+00, 4.646359E+00, -2.061767E+00>,
      <3.682621E+00, 1.264611E+00, -2.061767E+00>,
      <3.682621E+00, 1.264611E+00, 1.31998E+00>,
      <3.682621E+00, 4.646359E+00, 1.31998E+00>
   }
 
   normal_vectors { 
      1, 
      <1.00E+00, 2.067536E-07, 3.258414E-07>
   }
 
   uv_vectors { 
      9, 
      <0.00E+00, 0.00E+00>,
      <-7.499999E-01, 2.50E-01>,
      <-7.499999E-01, 0.00E+00>,
      <-9.999999E-01, 0.00E+00>,
      <-9.999999E-01, 2.50E-01>,
      <-1.00E+00, 4.999999E-01>,
      <-1.00E+00, 0.00E+00>,
      <-5.000001E-01, 0.00E+00>,
      <-5.000001E-01, 5.00E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      2, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0
   }
 
   normal_indices { 
      2, 
      <0, 0, 0>,
      <0, 0, 0>
   }
 
   uv_indices { 
      2, 
      <5, 6, 7>,
      <5, 7, 8>
   }
   uv_mapping
}
 
// axle
mesh2 {
 
   vertex_vectors { 
      12, 
      <3.682621E+00, 2.955485E+00, -8.408931E-01>,
      <-1.025379E+00, 2.955485E+00, -8.408947E-01>,
      <3.682621E+00, 3.362517E+00, -6.058949E-01>,
      <-1.025379E+00, 3.362517E+00, -6.058965E-01>,
      <3.682621E+00, 3.362517E+00, -1.358928E-01>,
      <-1.025379E+00, 3.362517E+00, -1.358943E-01>,
      <3.682621E+00, 2.955485E+00, 9.910546E-02>,
      <-1.025379E+00, 2.955485E+00, 9.910393E-02>,
      <3.682621E+00, 2.548453E+00, -1.358928E-01>,
      <-1.025379E+00, 2.548453E+00, -1.358943E-01>,
      <3.682621E+00, 2.548453E+00, -6.058949E-01>,
      <-1.025379E+00, 2.548453E+00, -6.058965E-01>
   }
 
   normal_vectors { 
      8, 
      <2.821873E-07, 4.999981E-01, -8.660266E-01>,
      <3.258414E-07, 2.067536E-07, -1.00E+00>,
      <-3.797453E-16, 1.00E+00, 2.550416E-16>,
      <-3.258414E-07, 2.067536E-07, 1.00E+00>,
      <-2.821873E-07, 4.999981E-01, 8.660266E-01>,
      <-2.821873E-07, -4.999977E-01, 8.660266E-01>,
      <3.797453E-16, -9.999998E-01, -2.550416E-16>,
      <2.821873E-07, -4.999976E-01, -8.660266E-01>
   }
 
   uv_vectors { 
      61, 
      <0.00E+00, 0.00E+00>,
      <-2.08447E-01, 2.929997E-02>,
      <-2.007531E-01, 2.929997E-02>,
      <-2.005589E-01, 2.244997E-02>,
      <-2.086411E-01, 2.244997E-02>,
      <-2.080531E-01, 2.929997E-02>,
      <-2.01147E-01, 2.929997E-02>,
      <-2.078589E-01, 2.244997E-02>,
      <-2.013412E-01, 2.244997E-02>,
      <-2.080531E-01, 1.559997E-02>,
      <-2.01147E-01, 1.559997E-02>,
      <-2.08447E-01, 1.559997E-02>,
      <-2.007531E-01, 1.559997E-02>,
      <-2.01147E-01, 2.929997E-02>,
      <-2.080531E-01, 2.929997E-02>,
      <-2.078589E-01, 2.244997E-02>,
      <-2.007531E-01, 1.559997E-02>,
      <-2.08447E-01, 1.559997E-02>,
      <-2.080531E-01, 1.559997E-02>,
      <-2.01147E-01, 2.929997E-02>,
      <-2.080531E-01, 2.929997E-02>,
      <-2.078589E-01, 2.244997E-02>,
      <-2.007531E-01, 1.559997E-02>,
      <-2.08447E-01, 1.559997E-02>,
      <-2.080531E-01, 1.559997E-02>,
      <-8.506777E-01, 2.10E-01>,
      <-8.788224E-01, 2.10E-01>,
      <-8.780311E-01, 2.007E-01>,
      <-8.514689E-01, 2.007E-01>,
      <-8.490724E-01, 2.10E-01>,
      <-8.804277E-01, 2.10E-01>,
      <-8.482811E-01, 2.007E-01>,
      <-8.812189E-01, 2.007E-01>,
      <-8.490724E-01, 1.914E-01>,
      <-8.804277E-01, 1.914E-01>,
      <-8.506777E-01, 1.914E-01>,
      <-8.788224E-01, 1.914E-01>,
      <-2.514114E-01, 6.716E-01>,
      <-8.298873E-02, 6.716E-01>,
      <-7.87385E-02, 5.886E-01>,
      <-2.556615E-01, 5.886E-01>,
      <-2.427887E-01, 6.716E-01>,
      <-9.161132E-02, 6.716E-01>,
      <-2.385385E-01, 5.886E-01>,
      <-9.586155E-02, 5.886E-01>,
      <-2.427887E-01, 5.056E-01>,
      <-9.161132E-02, 5.056E-01>,
      <-2.514114E-01, 5.056E-01>,
      <-8.298873E-02, 5.056E-01>,
      <-1.907546E-01, 6.741E-01>,
      <-1.124454E-01, 6.741E-01>,
      <-1.104693E-01, 5.9045E-01>,
      <-1.927307E-01, 5.9045E-01>,
      <-1.867454E-01, 6.741E-01>,
      <-1.164546E-01, 6.741E-01>,
      <-1.847693E-01, 5.9045E-01>,
      <-1.184307E-01, 5.9045E-01>,
      <-1.867454E-01, 5.068E-01>,
      <-1.164546E-01, 5.068E-01>,
      <-1.907546E-01, 5.068E-01>,
      <-1.124454E-01, 5.068E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      12, 
      <3, 2, 0>, 0,
      <3, 0, 1>, 0,
      <5, 4, 2>, 0,
      <5, 2, 3>, 0,
      <7, 6, 4>, 0,
      <7, 4, 5>, 0,
      <9, 8, 6>, 0,
      <9, 6, 7>, 0,
      <11, 10, 8>, 0,
      <11, 8, 9>, 0,
      <1, 0, 10>, 0,
      <1, 10, 11>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 4>,
      <3, 4, 4>,
      <5, 5, 3>,
      <5, 3, 3>,
      <6, 6, 6>,
      <6, 6, 6>,
      <1, 1, 7>,
      <1, 7, 7>
   }
 
   uv_indices { 
      12, 
      <49, 50, 51>,
      <49, 51, 52>,
      <53, 54, 50>,
      <53, 50, 49>,
      <55, 56, 54>,
      <55, 54, 53>,
      <57, 58, 56>,
      <57, 56, 55>,
      <59, 60, 58>,
      <59, 58, 57>,
      <52, 51, 60>,
      <52, 60, 59>
   }
   uv_mapping
}
 
// Rim-Outer
mesh2 {
 
   vertex_vectors { 
      64, 
      <-1.025379E+00, 2.955485E+00, 3.042483E+00>,
      <-1.419378E+00, 2.955485E+00, 3.042483E+00>,
      <-1.025379E+00, 3.247755E+00, 3.071268E+00>,
      <-1.419378E+00, 3.247755E+00, 3.071268E+00>,
      <-1.025379E+00, 3.528792E+00, 3.156521E+00>,
      <-1.419378E+00, 3.528792E+00, 3.156521E+00>,
      <-1.025379E+00, 3.787798E+00, 3.294962E+00>,
      <-1.419378E+00, 3.787798E+00, 3.294962E+00>,
      <-1.025379E+00, 4.014819E+00, 3.481274E+00>,
      <-1.419378E+00, 4.014819E+00, 3.481273E+00>,
      <-1.025379E+00, 4.20113E+00, 3.708294E+00>,
      <-1.419378E+00, 4.20113E+00, 3.708294E+00>,
      <-1.025379E+00, 4.339571E+00, 3.967299E+00>,
      <-1.419378E+00, 4.339571E+00, 3.967299E+00>,
      <-1.025379E+00, 4.424824E+00, 4.248338E+00>,
      <-1.419378E+00, 4.424824E+00, 4.248338E+00>,
      <-1.025379E+00, 4.45361E+00, 4.540607E+00>,
      <-1.419378E+00, 4.45361E+00, 4.540607E+00>,
      <-1.025379E+00, 4.424824E+00, 4.832877E+00>,
      <-1.419378E+00, 4.424824E+00, 4.832877E+00>,
      <-1.025379E+00, 4.339571E+00, 5.113915E+00>,
      <-1.419379E+00, 4.339571E+00, 5.113915E+00>,
      <-1.025379E+00, 4.20113E+00, 5.372921E+00>,
      <-1.419379E+00, 4.20113E+00, 5.372921E+00>,
      <-1.02538E+00, 4.014819E+00, 5.599941E+00>,
      <-1.419379E+00, 4.014819E+00, 5.599941E+00>,
      <-1.02538E+00, 3.787798E+00, 5.786253E+00>,
      <-1.419379E+00, 3.787798E+00, 5.786253E+00>,
      <-1.02538E+00, 3.528792E+00, 5.924694E+00>,
      <-1.419379E+00, 3.528792E+00, 5.924694E+00>,
      <-1.02538E+00, 3.247755E+00, 6.009947E+00>,
      <-1.419379E+00, 3.247755E+00, 6.009947E+00>,
      <-1.02538E+00, 2.955485E+00, 6.038732E+00>,
      <-1.419379E+00, 2.955485E+00, 6.038732E+00>,
      <-1.02538E+00, 2.663215E+00, 6.009947E+00>,
      <-1.419379E+00, 2.663215E+00, 6.009947E+00>,
      <-1.02538E+00, 2.382177E+00, 5.924694E+00>,
      <-1.419379E+00, 2.382177E+00, 5.924694E+00>,
      <-1.02538E+00, 2.123171E+00, 5.786253E+00>,
      <-1.419379E+00, 2.123171E+00, 5.786253E+00>,
      <-1.02538E+00, 1.89615E+00, 5.599941E+00>,
      <-1.419379E+00, 1.896151E+00, 5.599941E+00>,
      <-1.025379E+00, 1.70984E+00, 5.372921E+00>,
      <-1.419379E+00, 1.70984E+00, 5.372921E+00>,
      <-1.025379E+00, 1.571398E+00, 5.113915E+00>,
      <-1.419379E+00, 1.571398E+00, 5.113915E+00>,
      <-1.025379E+00, 1.486146E+00, 4.832877E+00>,
      <-1.419378E+00, 1.486146E+00, 4.832877E+00>,
      <-1.025379E+00, 1.45736E+00, 4.540607E+00>,
      <-1.419378E+00, 1.45736E+00, 4.540607E+00>,
      <-1.025379E+00, 1.486146E+00, 4.248338E+00>,
      <-1.419378E+00, 1.486146E+00, 4.248338E+00>,
      <-1.025379E+00, 1.571398E+00, 3.967299E+00>,
      <-1.419378E+00, 1.571398E+00, 3.967299E+00>,
      <-1.025379E+00, 1.70984E+00, 3.708294E+00>,
      <-1.419378E+00, 1.70984E+00, 3.708294E+00>,
      <-1.025379E+00, 1.896151E+00, 3.481274E+00>,
      <-1.419378E+00, 1.896151E+00, 3.481273E+00>,
      <-1.025379E+00, 2.123171E+00, 3.294962E+00>,
      <-1.419378E+00, 2.123171E+00, 3.294962E+00>,
      <-1.025379E+00, 2.382177E+00, 3.156521E+00>,
      <-1.419378E+00, 2.382177E+00, 3.156521E+00>,
      <-1.025379E+00, 2.663215E+00, 3.071268E+00>,
      <-1.419378E+00, 2.663215E+00, 3.071268E+00>
   }
 
   normal_vectors { 
      32, 
      <3.195804E-07, 1.950904E-01, -9.807853E-01>,
      <3.258414E-07, 2.067536E-07, -1.00E+00>,
      <3.01038E-07, 3.826849E-01, -9.23879E-01>,
      <2.709272E-07, 5.555704E-01, -8.314696E-01>,
      <2.304047E-07, 7.071068E-01, -7.071069E-01>,
      <1.810279E-07, 8.314695E-01, -5.555707E-01>,
      <1.246943E-07, 9.238794E-01, -3.82684E-01>,
      <6.356859E-08, 9.807854E-01, -1.950906E-01>,
      <-2.904597E-17, 1.00E+00, -9.595038E-16>,
      <-6.356854E-08, 9.807854E-01, 1.950904E-01>,
      <-1.246943E-07, 9.238795E-01, 3.826839E-01>,
      <-1.810279E-07, 8.314695E-01, 5.555707E-01>,
      <-2.304047E-07, 7.071068E-01, 7.071069E-01>,
      <-2.709272E-07, 5.555704E-01, 8.314696E-01>,
      <-3.01038E-07, 3.82685E-01, 9.23879E-01>,
      <-3.195804E-07, 1.950904E-01, 9.807853E-01>,
      <-3.258414E-07, 2.067536E-07, 1.00E+00>,
      <-3.195804E-07, -1.9509E-01, 9.807853E-01>,
      <-3.01038E-07, -3.826844E-01, 9.23879E-01>,
      <-2.709272E-07, -5.5557E-01, 8.314697E-01>,
      <-2.304047E-07, -7.071064E-01, 7.071071E-01>,
      <-1.810279E-07, -8.314691E-01, 5.555708E-01>,
      <-1.246941E-07, -9.238793E-01, 3.826835E-01>,
      <-6.356847E-08, -9.807851E-01, 1.950902E-01>,
      <2.904597E-17, -9.999998E-01, 9.595038E-16>,
      <6.356849E-08, -9.807851E-01, -1.950903E-01>,
      <1.246941E-07, -9.238793E-01, -3.826835E-01>,
      <1.810279E-07, -8.314691E-01, -5.555708E-01>,
      <2.304047E-07, -7.071064E-01, -7.071071E-01>,
      <2.709272E-07, -5.555701E-01, -8.314696E-01>,
      <3.01038E-07, -3.826845E-01, -9.23879E-01>,
      <3.195804E-07, -1.9509E-01, -9.807853E-01>
   }
 
   uv_vectors { 
      41, 
      <0.00E+00, 0.00E+00>,
      <-6.000006E-02, 1.855E-01>,
      <-3.000009E-02, 1.855E-01>,
      <-3.000009E-02, 1.175E-01>,
      <-6.000006E-02, 1.175E-01>,
      <-5.999994E-02, 1.515E-01>,
      <-2.999997E-02, 1.515E-01>,
      <-9.956325E-01, 6.754004E-01>,
      <-9.956325E-01, 5.006004E-01>,
      <-9.988E-01, 5.006004E-01>,
      <-9.988E-01, 6.754004E-01>,
      <-9.862515E-01, 6.754004E-01>,
      <-9.862515E-01, 5.006004E-01>,
      <-9.710177E-01, 6.754004E-01>,
      <-9.710177E-01, 5.006004E-01>,
      <-9.505165E-01, 6.754004E-01>,
      <-9.505165E-01, 5.006004E-01>,
      <-9.255358E-01, 6.754004E-01>,
      <-9.255358E-01, 5.006004E-01>,
      <-8.970354E-01, 6.754004E-01>,
      <-8.970354E-01, 5.006004E-01>,
      <-8.661106E-01, 6.754004E-01>,
      <-8.661106E-01, 5.006004E-01>,
      <-8.3395E-01, 6.754004E-01>,
      <-8.3395E-01, 5.006004E-01>,
      <-8.017893E-01, 6.754004E-01>,
      <-8.017893E-01, 5.006004E-01>,
      <-7.708645E-01, 6.754004E-01>,
      <-7.708645E-01, 5.006004E-01>,
      <-7.423642E-01, 6.754004E-01>,
      <-7.423642E-01, 5.006004E-01>,
      <-7.173834E-01, 6.754004E-01>,
      <-7.173834E-01, 5.006004E-01>,
      <-6.968822E-01, 6.754004E-01>,
      <-6.968822E-01, 5.006004E-01>,
      <-6.816484E-01, 6.754004E-01>,
      <-6.816484E-01, 5.006004E-01>,
      <-6.722674E-01, 6.754004E-01>,
      <-6.722674E-01, 5.006004E-01>,
      <-6.691E-01, 6.754004E-01>,
      <-6.691E-01, 5.006004E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      64, 
      <3, 2, 0>, 0,
      <3, 0, 1>, 0,
      <5, 4, 2>, 0,
      <5, 2, 3>, 0,
      <7, 6, 4>, 0,
      <7, 4, 5>, 0,
      <9, 8, 6>, 0,
      <9, 6, 7>, 0,
      <11, 10, 8>, 0,
      <11, 8, 9>, 0,
      <13, 12, 10>, 0,
      <13, 10, 11>, 0,
      <15, 14, 12>, 0,
      <15, 12, 13>, 0,
      <17, 16, 14>, 0,
      <17, 14, 15>, 0,
      <19, 18, 16>, 0,
      <19, 16, 17>, 0,
      <21, 20, 18>, 0,
      <21, 18, 19>, 0,
      <23, 22, 20>, 0,
      <23, 20, 21>, 0,
      <25, 24, 22>, 0,
      <25, 22, 23>, 0,
      <27, 26, 24>, 0,
      <27, 24, 25>, 0,
      <29, 28, 26>, 0,
      <29, 26, 27>, 0,
      <31, 30, 28>, 0,
      <31, 28, 29>, 0,
      <33, 32, 30>, 0,
      <33, 30, 31>, 0,
      <35, 34, 32>, 0,
      <35, 32, 33>, 0,
      <37, 36, 34>, 0,
      <37, 34, 35>, 0,
      <39, 38, 36>, 0,
      <39, 36, 37>, 0,
      <41, 40, 38>, 0,
      <41, 38, 39>, 0,
      <43, 42, 40>, 0,
      <43, 40, 41>, 0,
      <45, 44, 42>, 0,
      <45, 42, 43>, 0,
      <47, 46, 44>, 0,
      <47, 44, 45>, 0,
      <49, 48, 46>, 0,
      <49, 46, 47>, 0,
      <51, 50, 48>, 0,
      <51, 48, 49>, 0,
      <53, 52, 50>, 0,
      <53, 50, 51>, 0,
      <55, 54, 52>, 0,
      <55, 52, 53>, 0,
      <57, 56, 54>, 0,
      <57, 54, 55>, 0,
      <59, 58, 56>, 0,
      <59, 56, 57>, 0,
      <61, 60, 58>, 0,
      <61, 58, 59>, 0,
      <63, 62, 60>, 0,
      <63, 60, 61>, 0,
      <1, 0, 62>, 0,
      <1, 62, 63>, 0
   }
 
   normal_indices { 
      64, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 2, 0>,
      <2, 0, 0>,
      <3, 3, 2>,
      <3, 2, 2>,
      <4, 4, 3>,
      <4, 3, 3>,
      <5, 5, 4>,
      <5, 4, 4>,
      <6, 6, 5>,
      <6, 5, 5>,
      <7, 7, 6>,
      <7, 6, 6>,
      <8, 8, 7>,
      <8, 7, 7>,
      <9, 9, 8>,
      <9, 8, 8>,
      <10, 10, 9>,
      <10, 9, 9>,
      <11, 11, 10>,
      <11, 10, 10>,
      <12, 12, 11>,
      <12, 11, 11>,
      <13, 13, 12>,
      <13, 12, 12>,
      <14, 14, 13>,
      <14, 13, 13>,
      <15, 15, 14>,
      <15, 14, 14>,
      <16, 16, 15>,
      <16, 15, 15>,
      <17, 17, 16>,
      <17, 16, 16>,
      <18, 18, 17>,
      <18, 17, 17>,
      <19, 19, 18>,
      <19, 18, 18>,
      <20, 20, 19>,
      <20, 19, 19>,
      <21, 21, 20>,
      <21, 20, 20>,
      <22, 22, 21>,
      <22, 21, 21>,
      <23, 23, 22>,
      <23, 22, 22>,
      <24, 24, 23>,
      <24, 23, 23>,
      <25, 25, 24>,
      <25, 24, 24>,
      <26, 26, 25>,
      <26, 25, 25>,
      <27, 27, 26>,
      <27, 26, 26>,
      <28, 28, 27>,
      <28, 27, 27>,
      <29, 29, 28>,
      <29, 28, 28>,
      <30, 30, 29>,
      <30, 29, 29>,
      <31, 31, 30>,
      <31, 30, 30>,
      <1, 1, 31>,
      <1, 31, 31>
   }
 
   uv_indices { 
      64, 
      <7, 8, 9>,
      <7, 9, 10>,
      <11, 12, 8>,
      <11, 8, 7>,
      <13, 14, 12>,
      <13, 12, 11>,
      <15, 16, 14>,
      <15, 14, 13>,
      <17, 18, 16>,
      <17, 16, 15>,
      <19, 20, 18>,
      <19, 18, 17>,
      <21, 22, 20>,
      <21, 20, 19>,
      <23, 24, 22>,
      <23, 22, 21>,
      <25, 26, 24>,
      <25, 24, 23>,
      <27, 28, 26>,
      <27, 26, 25>,
      <29, 30, 28>,
      <29, 28, 27>,
      <31, 32, 30>,
      <31, 30, 29>,
      <33, 34, 32>,
      <33, 32, 31>,
      <35, 36, 34>,
      <35, 34, 33>,
      <37, 38, 36>,
      <37, 36, 35>,
      <39, 40, 38>,
      <39, 38, 37>,
      <37, 38, 40>,
      <37, 40, 39>,
      <35, 36, 38>,
      <35, 38, 37>,
      <33, 34, 36>,
      <33, 36, 35>,
      <31, 32, 34>,
      <31, 34, 33>,
      <29, 30, 32>,
      <29, 32, 31>,
      <27, 28, 30>,
      <27, 30, 29>,
      <25, 26, 28>,
      <25, 28, 27>,
      <23, 24, 26>,
      <23, 26, 25>,
      <21, 22, 24>,
      <21, 24, 23>,
      <19, 20, 22>,
      <19, 22, 21>,
      <17, 18, 20>,
      <17, 20, 19>,
      <15, 16, 18>,
      <15, 18, 17>,
      <13, 14, 16>,
      <13, 16, 15>,
      <11, 12, 14>,
      <11, 14, 13>,
      <7, 8, 12>,
      <7, 12, 11>,
      <10, 9, 8>,
      <10, 8, 7>
   }
   uv_mapping
}
 
// Faces
mesh2 {
 
   vertex_vectors { 
      8, 
      <-1.419379E+00, 1.45736E+00, 6.038732E+00>,
      <-1.419378E+00, 1.45736E+00, 3.042483E+00>,
      <-1.419378E+00, 4.45361E+00, 3.042483E+00>,
      <-1.419379E+00, 4.45361E+00, 6.038732E+00>,
      <-1.025379E+00, 4.45361E+00, 3.042483E+00>,
      <-1.02538E+00, 4.45361E+00, 6.038732E+00>,
      <-1.02538E+00, 1.45736E+00, 6.038732E+00>,
      <-1.025379E+00, 1.45736E+00, 3.042483E+00>
   }
 
   normal_vectors { 
      2, 
      <-1.00E+00, 2.067536E-07, -3.258414E-07>,
      <1.00E+00, 2.067536E-07, 3.258414E-07>
   }
 
   uv_vectors { 
      15, 
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <-1.00E+00, 1.00E+00>,
      <0.00E+00, 1.00E+00>,
      <0.00E+00, -2.308219E-09>,
      <-1.00E+00, -2.308219E-09>,
      <-1.00E+00, 2.50E-01>,
      <-7.50E-01, 2.50E-01>,
      <-7.50E-01, 0.00E+00>,
      <-5.00E-01, 2.50E-01>,
      <-5.00E-01, 0.00E+00>,
      <-5.00E-01, 5.00E-01>,
      <0.00E+00, 5.00E-01>,
      <-1.00E+00, 5.00E-01>,
      <-1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      4, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0
   }
 
   normal_indices { 
      4, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>
   }
 
   uv_indices { 
      4, 
      <11, 13, 14>,
      <11, 14, 10>,
      <12, 11, 10>,
      <12, 10, 0>
   }
   uv_mapping
}
 
// Flange
mesh2 {
 
   vertex_vectors { 
      4, 
      <-1.02538E+00, 1.264611E+00, 6.231482E+00>,
      <-1.025379E+00, 1.264611E+00, 2.849733E+00>,
      <-1.025379E+00, 4.646359E+00, 2.849733E+00>,
      <-1.02538E+00, 4.646359E+00, 6.231482E+00>
   }
 
   normal_vectors { 
      1, 
      <-1.00E+00, 2.067536E-07, -3.258414E-07>
   }
 
   uv_vectors { 
      13, 
      <0.00E+00, 0.00E+00>,
      <-1.00E+00, 1.00E+00>,
      <0.00E+00, 1.00E+00>,
      <0.00E+00, 1.047078E-08>,
      <-1.00E+00, 1.047078E-08>,
      <-1.00E+00, 2.50E-01>,
      <-7.50E-01, 2.50E-01>,
      <-7.50E-01, 0.00E+00>,
      <-5.00E-01, 2.50E-01>,
      <-5.00E-01, 0.00E+00>,
      <-5.00E-01, 5.00E-01>,
      <-1.00E+00, 5.00E-01>,
      <-1.00E+00, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      2, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0
   }
 
   normal_indices { 
      2, 
      <0, 0, 0>,
      <0, 0, 0>
   }
 
   uv_indices { 
      2, 
      <10, 11, 12>,
      <10, 12, 9>
   }
   uv_mapping
}
 
// Rim-Outer
mesh2 {
 
   vertex_vectors { 
      64, 
      <3.682621E+00, 1.45736E+00, 4.540609E+00>,
      <4.076622E+00, 1.45736E+00, 4.540609E+00>,
      <3.682621E+00, 1.486146E+00, 4.832879E+00>,
      <4.076622E+00, 1.486146E+00, 4.832879E+00>,
      <3.682621E+00, 1.571398E+00, 5.113917E+00>,
      <4.076622E+00, 1.571398E+00, 5.113917E+00>,
      <3.682621E+00, 1.709839E+00, 5.372922E+00>,
      <4.076622E+00, 1.70984E+00, 5.372922E+00>,
      <3.682621E+00, 1.89615E+00, 5.599943E+00>,
      <4.076622E+00, 1.89615E+00, 5.599943E+00>,
      <3.682621E+00, 2.123171E+00, 5.786254E+00>,
      <4.076622E+00, 2.123171E+00, 5.786254E+00>,
      <3.682621E+00, 2.382177E+00, 5.924695E+00>,
      <4.076622E+00, 2.382177E+00, 5.924695E+00>,
      <3.682621E+00, 2.663215E+00, 6.009948E+00>,
      <4.076622E+00, 2.663215E+00, 6.009948E+00>,
      <3.682621E+00, 2.955485E+00, 6.038733E+00>,
      <4.076622E+00, 2.955485E+00, 6.038733E+00>,
      <3.682621E+00, 3.247755E+00, 6.009948E+00>,
      <4.076622E+00, 3.247755E+00, 6.009948E+00>,
      <3.682621E+00, 3.528792E+00, 5.924695E+00>,
      <4.076622E+00, 3.528792E+00, 5.924695E+00>,
      <3.682621E+00, 3.787798E+00, 5.786254E+00>,
      <4.076622E+00, 3.787798E+00, 5.786254E+00>,
      <3.682621E+00, 4.014819E+00, 5.599944E+00>,
      <4.076622E+00, 4.014819E+00, 5.599943E+00>,
      <3.682621E+00, 4.20113E+00, 5.372922E+00>,
      <4.076622E+00, 4.20113E+00, 5.372922E+00>,
      <3.682621E+00, 4.339572E+00, 5.113917E+00>,
      <4.076622E+00, 4.339571E+00, 5.113917E+00>,
      <3.682621E+00, 4.424824E+00, 4.832879E+00>,
      <4.076622E+00, 4.424824E+00, 4.832879E+00>,
      <3.682621E+00, 4.45361E+00, 4.540609E+00>,
      <4.076622E+00, 4.45361E+00, 4.540609E+00>,
      <3.682621E+00, 4.424824E+00, 4.248339E+00>,
      <4.076622E+00, 4.424824E+00, 4.248339E+00>,
      <3.682621E+00, 4.339572E+00, 3.967301E+00>,
      <4.076622E+00, 4.339571E+00, 3.967301E+00>,
      <3.682621E+00, 4.20113E+00, 3.708295E+00>,
      <4.076622E+00, 4.20113E+00, 3.708296E+00>,
      <3.682621E+00, 4.01482E+00, 3.481275E+00>,
      <4.076622E+00, 4.014819E+00, 3.481275E+00>,
      <3.682621E+00, 3.787799E+00, 3.294963E+00>,
      <4.076622E+00, 3.787799E+00, 3.294964E+00>,
      <3.682621E+00, 3.528792E+00, 3.156522E+00>,
      <4.076622E+00, 3.528792E+00, 3.156523E+00>,
      <3.682621E+00, 3.247755E+00, 3.07127E+00>,
      <4.076622E+00, 3.247755E+00, 3.07127E+00>,
      <3.682621E+00, 2.955485E+00, 3.042485E+00>,
      <4.076622E+00, 2.955485E+00, 3.042485E+00>,
      <3.682621E+00, 2.663215E+00, 3.07127E+00>,
      <4.076622E+00, 2.663215E+00, 3.07127E+00>,
      <3.682621E+00, 2.382177E+00, 3.156522E+00>,
      <4.076622E+00, 2.382177E+00, 3.156523E+00>,
      <3.682621E+00, 2.123171E+00, 3.294963E+00>,
      <4.076622E+00, 2.123171E+00, 3.294964E+00>,
      <3.682621E+00, 1.89615E+00, 3.481274E+00>,
      <4.076622E+00, 1.89615E+00, 3.481275E+00>,
      <3.682621E+00, 1.709839E+00, 3.708295E+00>,
      <4.076622E+00, 1.70984E+00, 3.708296E+00>,
      <3.682621E+00, 1.571398E+00, 3.967301E+00>,
      <4.076622E+00, 1.571398E+00, 3.967301E+00>,
      <3.682621E+00, 1.486146E+00, 4.248339E+00>,
      <4.076622E+00, 1.486146E+00, 4.248339E+00>
   }
 
   normal_vectors { 
      32, 
      <2.409078E-07, -9.807851E-01, 1.950904E-01>,
      <2.904602E-17, -9.999998E-01, 9.595038E-16>,
      <1.834552E-07, -9.238793E-01, 3.826835E-01>,
      <6.338015E-08, -8.314692E-01, 5.555707E-01>,
      <-1.26749E-07, -7.071065E-01, 7.071069E-01>,
      <-2.74243E-07, -5.555702E-01, 8.314695E-01>,
      <-2.70354E-07, -3.826845E-01, 9.23879E-01>,
      <-2.706133E-07, -1.950898E-01, 9.807854E-01>,
      <-3.258414E-07, 2.067536E-07, 1.00E+00>,
      <-3.195804E-07, 1.950901E-01, 9.807854E-01>,
      <-3.01038E-07, 3.826849E-01, 9.23879E-01>,
      <2.612363E-07, 5.555698E-01, 8.3147E-01>,
      <7.693058E-07, 7.071066E-01, 7.071072E-01>,
      <5.652829E-07, 8.314698E-01, 5.555702E-01>,
      <2.987704E-07, 9.238796E-01, 3.826836E-01>,
      <2.331788E-07, 9.807855E-01, 1.950903E-01>,
      <-2.904602E-17, 1.00E+00, -9.595038E-16>,
      <3.676617E-07, 9.807854E-01, -1.950905E-01>,
      <5.881801E-07, 9.238796E-01, -3.826837E-01>,
      <7.458674E-07, 8.314696E-01, -5.555705E-01>,
      <5.436742E-07, 7.071069E-01, -7.071068E-01>,
      <3.307966E-07, 5.555705E-01, -8.314695E-01>,
      <3.229491E-07, 3.826849E-01, -9.23879E-01>,
      <3.414915E-07, 1.950902E-01, -9.807854E-01>,
      <3.258414E-07, 2.067536E-07, -1.00E+00>,
      <3.195804E-07, -1.950897E-01, -9.807854E-01>,
      <3.770614E-07, -3.826844E-01, -9.23879E-01>,
      <8.88256E-07, -5.555695E-01, -8.3147E-01>,
      <1.285346E-06, -7.071063E-01, -7.071071E-01>,
      <8.340452E-07, -8.314693E-01, -5.555704E-01>,
      <4.124497E-07, -9.238792E-01, -3.826837E-01>,
      <3.636056E-07, -9.807851E-01, -1.950903E-01>
   }
 
   uv_vectors { 
      41, 
      <0.00E+00, 0.00E+00>,
      <-6.00E-02, 1.855E-01>,
      <-3.000003E-02, 1.855E-01>,
      <-3.000003E-02, 1.175E-01>,
      <-6.00E-02, 1.175E-01>,
      <-6.00E-02, 1.514999E-01>,
      <-3.000003E-02, 1.514999E-01>,
      <-8.017893E-01, 6.754E-01>,
      <-8.017893E-01, 5.006E-01>,
      <-8.3395E-01, 5.006E-01>,
      <-8.3395E-01, 6.754E-01>,
      <-7.708645E-01, 6.754E-01>,
      <-7.708645E-01, 5.006E-01>,
      <-7.423642E-01, 6.754E-01>,
      <-7.423642E-01, 5.006E-01>,
      <-7.173834E-01, 6.754E-01>,
      <-7.173834E-01, 5.006E-01>,
      <-6.968822E-01, 6.754E-01>,
      <-6.968822E-01, 5.006E-01>,
      <-6.816484E-01, 6.754E-01>,
      <-6.816484E-01, 5.006E-01>,
      <-6.722674E-01, 6.754E-01>,
      <-6.722674E-01, 5.006E-01>,
      <-6.691E-01, 6.754E-01>,
      <-6.691E-01, 5.006E-01>,
      <-8.661106E-01, 6.754E-01>,
      <-8.661106E-01, 5.006E-01>,
      <-8.970354E-01, 6.754E-01>,
      <-8.970354E-01, 5.006E-01>,
      <-9.255358E-01, 6.754E-01>,
      <-9.255358E-01, 5.006E-01>,
      <-9.505165E-01, 6.754E-01>,
      <-9.505165E-01, 5.006E-01>,
      <-9.710177E-01, 6.754E-01>,
      <-9.710177E-01, 5.006E-01>,
      <-9.862515E-01, 6.754E-01>,
      <-9.862515E-01, 5.006E-01>,
      <-9.956325E-01, 6.754E-01>,
      <-9.956325E-01, 5.006E-01>,
      <-9.988E-01, 6.754E-01>,
      <-9.988E-01, 5.006E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      64, 
      <3, 2, 0>, 0,
      <3, 0, 1>, 0,
      <5, 4, 2>, 0,
      <5, 2, 3>, 0,
      <7, 6, 4>, 0,
      <7, 4, 5>, 0,
      <9, 8, 6>, 0,
      <9, 6, 7>, 0,
      <11, 10, 8>, 0,
      <11, 8, 9>, 0,
      <13, 12, 10>, 0,
      <13, 10, 11>, 0,
      <15, 14, 12>, 0,
      <15, 12, 13>, 0,
      <17, 16, 14>, 0,
      <17, 14, 15>, 0,
      <19, 18, 16>, 0,
      <19, 16, 17>, 0,
      <21, 20, 18>, 0,
      <21, 18, 19>, 0,
      <23, 22, 20>, 0,
      <23, 20, 21>, 0,
      <25, 24, 22>, 0,
      <25, 22, 23>, 0,
      <27, 26, 24>, 0,
      <27, 24, 25>, 0,
      <29, 28, 26>, 0,
      <29, 26, 27>, 0,
      <31, 30, 28>, 0,
      <31, 28, 29>, 0,
      <33, 32, 30>, 0,
      <33, 30, 31>, 0,
      <35, 34, 32>, 0,
      <35, 32, 33>, 0,
      <37, 36, 34>, 0,
      <37, 34, 35>, 0,
      <39, 38, 36>, 0,
      <39, 36, 37>, 0,
      <41, 40, 38>, 0,
      <41, 38, 39>, 0,
      <43, 42, 40>, 0,
      <43, 40, 41>, 0,
      <45, 44, 42>, 0,
      <45, 42, 43>, 0,
      <47, 46, 44>, 0,
      <47, 44, 45>, 0,
      <49, 48, 46>, 0,
      <49, 46, 47>, 0,
      <51, 50, 48>, 0,
      <51, 48, 49>, 0,
      <53, 52, 50>, 0,
      <53, 50, 51>, 0,
      <55, 54, 52>, 0,
      <55, 52, 53>, 0,
      <57, 56, 54>, 0,
      <57, 54, 55>, 0,
      <59, 58, 56>, 0,
      <59, 56, 57>, 0,
      <61, 60, 58>, 0,
      <61, 58, 59>, 0,
      <63, 62, 60>, 0,
      <63, 60, 61>, 0,
      <1, 0, 62>, 0,
      <1, 62, 63>, 0
   }
 
   normal_indices { 
      64, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 2, 0>,
      <2, 0, 0>,
      <3, 3, 2>,
      <3, 2, 2>,
      <4, 4, 3>,
      <4, 3, 3>,
      <5, 5, 4>,
      <5, 4, 4>,
      <6, 6, 5>,
      <6, 5, 5>,
      <7, 7, 6>,
      <7, 6, 6>,
      <8, 8, 7>,
      <8, 7, 7>,
      <9, 9, 8>,
      <9, 8, 8>,
      <10, 10, 9>,
      <10, 9, 9>,
      <11, 11, 10>,
      <11, 10, 10>,
      <12, 12, 11>,
      <12, 11, 11>,
      <13, 13, 12>,
      <13, 12, 12>,
      <14, 14, 13>,
      <14, 13, 13>,
      <15, 15, 14>,
      <15, 14, 14>,
      <16, 16, 15>,
      <16, 15, 15>,
      <17, 17, 16>,
      <17, 16, 16>,
      <18, 18, 17>,
      <18, 17, 17>,
      <19, 19, 18>,
      <19, 18, 18>,
      <20, 20, 19>,
      <20, 19, 19>,
      <21, 21, 20>,
      <21, 20, 20>,
      <22, 22, 21>,
      <22, 21, 21>,
      <23, 23, 22>,
      <23, 22, 22>,
      <24, 24, 23>,
      <24, 23, 23>,
      <25, 25, 24>,
      <25, 24, 24>,
      <26, 26, 25>,
      <26, 25, 25>,
      <27, 27, 26>,
      <27, 26, 26>,
      <28, 28, 27>,
      <28, 27, 27>,
      <29, 29, 28>,
      <29, 28, 28>,
      <30, 30, 29>,
      <30, 29, 29>,
      <31, 31, 30>,
      <31, 30, 30>,
      <1, 1, 31>,
      <1, 31, 31>
   }
 
   uv_indices { 
      64, 
      <7, 8, 9>,
      <7, 9, 10>,
      <11, 12, 8>,
      <11, 8, 7>,
      <13, 14, 12>,
      <13, 12, 11>,
      <15, 16, 14>,
      <15, 14, 13>,
      <17, 18, 16>,
      <17, 16, 15>,
      <19, 20, 18>,
      <19, 18, 17>,
      <21, 22, 20>,
      <21, 20, 19>,
      <23, 24, 22>,
      <23, 22, 21>,
      <21, 22, 24>,
      <21, 24, 23>,
      <19, 20, 22>,
      <19, 22, 21>,
      <17, 18, 20>,
      <17, 20, 19>,
      <15, 16, 18>,
      <15, 18, 17>,
      <13, 14, 16>,
      <13, 16, 15>,
      <11, 12, 14>,
      <11, 14, 13>,
      <7, 8, 12>,
      <7, 12, 11>,
      <10, 9, 8>,
      <10, 8, 7>,
      <25, 26, 9>,
      <25, 9, 10>,
      <27, 28, 26>,
      <27, 26, 25>,
      <29, 30, 28>,
      <29, 28, 27>,
      <31, 32, 30>,
      <31, 30, 29>,
      <33, 34, 32>,
      <33, 32, 31>,
      <35, 36, 34>,
      <35, 34, 33>,
      <37, 38, 36>,
      <37, 36, 35>,
      <39, 40, 38>,
      <39, 38, 37>,
      <37, 38, 40>,
      <37, 40, 39>,
      <35, 36, 38>,
      <35, 38, 37>,
      <33, 34, 36>,
      <33, 36, 35>,
      <31, 32, 34>,
      <31, 34, 33>,
      <29, 30, 32>,
      <29, 32, 31>,
      <27, 28, 30>,
      <27, 30, 29>,
      <25, 26, 28>,
      <25, 28, 27>,
      <10, 9, 26>,
      <10, 26, 25>
   }
   uv_mapping
}
 
// Faces
mesh2 {
 
   vertex_vectors { 
      8, 
      <4.076622E+00, 4.45361E+00, 3.042485E+00>,
      <4.076622E+00, 1.45736E+00, 3.042485E+00>,
      <4.076622E+00, 1.45736E+00, 6.038733E+00>,
      <4.076622E+00, 4.45361E+00, 6.038733E+00>,
      <3.682621E+00, 1.45736E+00, 6.038733E+00>,
      <3.682621E+00, 4.45361E+00, 6.038733E+00>,
      <3.682621E+00, 4.45361E+00, 3.042485E+00>,
      <3.682621E+00, 1.45736E+00, 3.042485E+00>
   }
 
   normal_vectors { 
      2, 
      <1.00E+00, 2.067536E-07, 3.258414E-07>,
      <-1.00E+00, 2.067536E-07, -3.258414E-07>
   }
 
   uv_vectors { 
      15, 
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <-1.00E+00, 0.00E+00>,
      <-1.00E+00, 2.50E-01>,
      <-7.50E-01, 2.50E-01>,
      <-7.50E-01, 0.00E+00>,
      <-7.50E-01, 2.50E-01>,
      <-5.00E-01, 2.50E-01>,
      <-5.00E-01, 0.00E+00>,
      <0.00E+00, 5.00E-01>,
      <-5.00E-01, 5.00E-01>,
      <-1.00E+00, 5.00E-01>,
      <-5.00E-01, 0.00E+00>,
      <-5.00E-01, 5.00E-01>,
      <0.00E+00, 5.00E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      4, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0
   }
 
   normal_indices { 
      4, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>
   }
 
   uv_indices { 
      4, 
      <11, 2, 12>,
      <11, 12, 13>,
      <0, 14, 13>,
      <0, 13, 12>
   }
   uv_mapping
}
 
// axle
mesh2 {
 
   vertex_vectors { 
      12, 
      <3.682621E+00, 2.955485E+00, 4.07061E+00>,
      <-1.025379E+00, 2.955485E+00, 4.070608E+00>,
      <3.682621E+00, 3.362517E+00, 4.305608E+00>,
      <-1.025379E+00, 3.362517E+00, 4.305607E+00>,
      <3.682621E+00, 3.362517E+00, 4.775609E+00>,
      <-1.025379E+00, 3.362517E+00, 4.775608E+00>,
      <3.682621E+00, 2.955485E+00, 5.010608E+00>,
      <-1.025379E+00, 2.955485E+00, 5.010607E+00>,
      <3.682621E+00, 2.548453E+00, 4.775609E+00>,
      <-1.025379E+00, 2.548453E+00, 4.775608E+00>,
      <3.682621E+00, 2.548453E+00, 4.305608E+00>,
      <-1.025379E+00, 2.548453E+00, 4.305607E+00>
   }
 
   normal_vectors { 
      8, 
      <2.821873E-07, 4.999981E-01, -8.660266E-01>,
      <3.258414E-07, 2.067536E-07, -1.00E+00>,
      <-2.904605E-17, 1.00E+00, -9.595038E-16>,
      <-3.258414E-07, 2.067536E-07, 1.00E+00>,
      <-2.821873E-07, 4.999981E-01, 8.660266E-01>,
      <-2.821873E-07, -4.999977E-01, 8.660266E-01>,
      <2.904605E-17, -9.999998E-01, 9.595038E-16>,
      <2.821873E-07, -4.999976E-01, -8.660266E-01>
   }
 
   uv_vectors { 
      67, 
      <0.00E+00, 0.00E+00>,
      <-2.08447E-01, 2.929997E-02>,
      <-2.007531E-01, 2.929997E-02>,
      <-2.005589E-01, 2.244997E-02>,
      <-2.086411E-01, 2.244997E-02>,
      <-2.080531E-01, 2.929997E-02>,
      <-2.01147E-01, 2.929997E-02>,
      <-2.078589E-01, 2.244997E-02>,
      <-2.013412E-01, 2.244997E-02>,
      <-2.080531E-01, 1.559997E-02>,
      <-2.01147E-01, 1.559997E-02>,
      <-2.08447E-01, 1.559997E-02>,
      <-2.007531E-01, 1.559997E-02>,
      <-8.506777E-01, 2.10E-01>,
      <-8.788224E-01, 2.10E-01>,
      <-8.780311E-01, 2.007E-01>,
      <-8.514689E-01, 2.007E-01>,
      <-8.490724E-01, 2.10E-01>,
      <-8.804277E-01, 2.10E-01>,
      <-8.482811E-01, 2.007E-01>,
      <-8.812189E-01, 2.007E-01>,
      <-8.490724E-01, 1.914E-01>,
      <-8.804277E-01, 1.914E-01>,
      <-8.506777E-01, 1.914E-01>,
      <-8.788224E-01, 1.914E-01>,
      <-2.471004E-01, 6.716E-01>,
      <-3.27E-01, 5.886E-01>,
      <-8.729964E-02, 6.716E-01>,
      <-7.400038E-03, 5.886E-01>,
      <-8.729964E-02, 5.056E-01>,
      <-2.471004E-01, 5.056E-01>,
      <-1.715114E-01, 6.716E-01>,
      <-3.226887E-01, 6.716E-01>,
      <-3.184385E-01, 5.886E-01>,
      <-1.757616E-01, 5.886E-01>,
      <-1.628887E-01, 6.716E-01>,
      <-1.171135E-02, 6.716E-01>,
      <-1.586385E-01, 5.886E-01>,
      <-1.596152E-02, 5.886E-01>,
      <-1.628887E-01, 5.056E-01>,
      <-1.171135E-02, 5.056E-01>,
      <-1.715114E-01, 5.056E-01>,
      <-3.226887E-01, 5.056E-01>,
      <-2.514114E-01, 6.716E-01>,
      <-8.298867E-02, 6.716E-01>,
      <-7.873844E-02, 5.886E-01>,
      <-2.556615E-01, 5.886E-01>,
      <-2.427887E-01, 6.716E-01>,
      <-9.161132E-02, 6.716E-01>,
      <-2.385385E-01, 5.886E-01>,
      <-9.586155E-02, 5.886E-01>,
      <-2.427887E-01, 5.056E-01>,
      <-9.161132E-02, 5.056E-01>,
      <-2.514114E-01, 5.056E-01>,
      <-8.298867E-02, 5.056E-01>,
      <-1.907546E-01, 6.741E-01>,
      <-1.124454E-01, 6.741E-01>,
      <-1.104693E-01, 5.9045E-01>,
      <-1.927307E-01, 5.9045E-01>,
      <-1.867455E-01, 6.741E-01>,
      <-1.164546E-01, 6.741E-01>,
      <-1.847693E-01, 5.9045E-01>,
      <-1.184307E-01, 5.9045E-01>,
      <-1.867455E-01, 5.068E-01>,
      <-1.164546E-01, 5.068E-01>,
      <-1.907546E-01, 5.068E-01>,
      <-1.124454E-01, 5.068E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      12, 
      <3, 2, 0>, 0,
      <3, 0, 1>, 0,
      <5, 4, 2>, 0,
      <5, 2, 3>, 0,
      <7, 6, 4>, 0,
      <7, 4, 5>, 0,
      <9, 8, 6>, 0,
      <9, 6, 7>, 0,
      <11, 10, 8>, 0,
      <11, 8, 9>, 0,
      <1, 0, 10>, 0,
      <1, 10, 11>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 4>,
      <3, 4, 4>,
      <5, 5, 3>,
      <5, 3, 3>,
      <6, 6, 6>,
      <6, 6, 6>,
      <1, 1, 7>,
      <1, 7, 7>
   }
 
   uv_indices { 
      12, 
      <55, 56, 57>,
      <55, 57, 58>,
      <59, 60, 56>,
      <59, 56, 55>,
      <61, 62, 60>,
      <61, 60, 59>,
      <63, 64, 62>,
      <63, 62, 61>,
      <65, 66, 64>,
      <65, 64, 63>,
      <58, 57, 66>,
      <58, 66, 65>
   }
   uv_mapping
}
 
// Flange
mesh2 {
 
   vertex_vectors { 
      4, 
      <3.682621E+00, 4.646359E+00, 2.849736E+00>,
      <3.682621E+00, 1.264611E+00, 2.849736E+00>,
      <3.682621E+00, 1.264611E+00, 6.231482E+00>,
      <3.682621E+00, 4.646359E+00, 6.231482E+00>
   }
 
   normal_vectors { 
      1, 
      <1.00E+00, 2.067536E-07, 3.258414E-07>
   }
 
   uv_vectors { 
      9, 
      <0.00E+00, 0.00E+00>,
      <-7.499999E-01, 2.50E-01>,
      <-7.499999E-01, 0.00E+00>,
      <-9.999999E-01, 0.00E+00>,
      <-9.999999E-01, 2.50E-01>,
      <-1.00E+00, 4.999999E-01>,
      <-1.00E+00, 0.00E+00>,
      <-5.000001E-01, 0.00E+00>,
      <-5.000001E-01, 5.00E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      2, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0
   }
 
   normal_indices { 
      2, 
      <0, 0, 0>,
      <0, 0, 0>
   }
 
   uv_indices { 
      2, 
      <5, 6, 7>,
      <5, 7, 8>
   }
   uv_mapping
}
 
// Rim-Outer
mesh2 {
 
   vertex_vectors { 
      64, 
      <-1.025379E+00, 2.955485E+00, 7.953981E+00>,
      <-1.419378E+00, 2.955485E+00, 7.953981E+00>,
      <-1.025379E+00, 3.247755E+00, 7.982767E+00>,
      <-1.419378E+00, 3.247755E+00, 7.982767E+00>,
      <-1.025379E+00, 3.528792E+00, 8.06802E+00>,
      <-1.419378E+00, 3.528792E+00, 8.06802E+00>,
      <-1.025379E+00, 3.787798E+00, 8.206461E+00>,
      <-1.419378E+00, 3.787798E+00, 8.206461E+00>,
      <-1.025379E+00, 4.014819E+00, 8.392772E+00>,
      <-1.419378E+00, 4.014819E+00, 8.392772E+00>,
      <-1.025379E+00, 4.20113E+00, 8.619793E+00>,
      <-1.419378E+00, 4.20113E+00, 8.619793E+00>,
      <-1.025379E+00, 4.339571E+00, 8.878799E+00>,
      <-1.419378E+00, 4.339571E+00, 8.878799E+00>,
      <-1.025379E+00, 4.424824E+00, 9.159836E+00>,
      <-1.419378E+00, 4.424824E+00, 9.159836E+00>,
      <-1.025379E+00, 4.45361E+00, 9.452106E+00>,
      <-1.419378E+00, 4.45361E+00, 9.452106E+00>,
      <-1.025379E+00, 4.424824E+00, 9.744377E+00>,
      <-1.419378E+00, 4.424824E+00, 9.744375E+00>,
      <-1.025379E+00, 4.339571E+00, 1.002541E+01>,
      <-1.419379E+00, 4.339571E+00, 1.002541E+01>,
      <-1.025379E+00, 4.20113E+00, 1.028442E+01>,
      <-1.419379E+00, 4.20113E+00, 1.028442E+01>,
      <-1.02538E+00, 4.014819E+00, 1.051144E+01>,
      <-1.419379E+00, 4.014819E+00, 1.051144E+01>,
      <-1.02538E+00, 3.787798E+00, 1.069775E+01>,
      <-1.419379E+00, 3.787798E+00, 1.069775E+01>,
      <-1.02538E+00, 3.528792E+00, 1.083619E+01>,
      <-1.419379E+00, 3.528792E+00, 1.083619E+01>,
      <-1.02538E+00, 3.247755E+00, 1.092145E+01>,
      <-1.419379E+00, 3.247755E+00, 1.092145E+01>,
      <-1.02538E+00, 2.955485E+00, 1.095023E+01>,
      <-1.419379E+00, 2.955485E+00, 1.095023E+01>,
      <-1.02538E+00, 2.663215E+00, 1.092145E+01>,
      <-1.419379E+00, 2.663215E+00, 1.092145E+01>,
      <-1.02538E+00, 2.382177E+00, 1.083619E+01>,
      <-1.419379E+00, 2.382177E+00, 1.083619E+01>,
      <-1.02538E+00, 2.123171E+00, 1.069775E+01>,
      <-1.419379E+00, 2.123171E+00, 1.069775E+01>,
      <-1.02538E+00, 1.89615E+00, 1.051144E+01>,
      <-1.419379E+00, 1.89615E+00, 1.051144E+01>,
      <-1.025379E+00, 1.70984E+00, 1.028442E+01>,
      <-1.419379E+00, 1.70984E+00, 1.028442E+01>,
      <-1.025379E+00, 1.571398E+00, 1.002541E+01>,
      <-1.419379E+00, 1.571398E+00, 1.002541E+01>,
      <-1.025379E+00, 1.486146E+00, 9.744377E+00>,
      <-1.419378E+00, 1.486146E+00, 9.744377E+00>,
      <-1.025379E+00, 1.45736E+00, 9.452106E+00>,
      <-1.419378E+00, 1.45736E+00, 9.452106E+00>,
      <-1.025379E+00, 1.486146E+00, 9.159836E+00>,
      <-1.419378E+00, 1.486146E+00, 9.159836E+00>,
      <-1.025379E+00, 1.571398E+00, 8.878799E+00>,
      <-1.419378E+00, 1.571398E+00, 8.878799E+00>,
      <-1.025379E+00, 1.70984E+00, 8.619793E+00>,
      <-1.419378E+00, 1.70984E+00, 8.619793E+00>,
      <-1.025379E+00, 1.89615E+00, 8.392772E+00>,
      <-1.419378E+00, 1.89615E+00, 8.392772E+00>,
      <-1.025379E+00, 2.123171E+00, 8.206461E+00>,
      <-1.419378E+00, 2.123171E+00, 8.206461E+00>,
      <-1.025379E+00, 2.382177E+00, 8.06802E+00>,
      <-1.419378E+00, 2.382177E+00, 8.06802E+00>,
      <-1.025379E+00, 2.663215E+00, 7.982767E+00>,
      <-1.419378E+00, 2.663215E+00, 7.982767E+00>
   }
 
   normal_vectors { 
      32, 
      <3.195804E-07, 1.950904E-01, -9.807853E-01>,
      <3.258414E-07, 2.067536E-07, -1.00E+00>,
      <3.01038E-07, 3.826849E-01, -9.23879E-01>,
      <2.709274E-07, 5.555693E-01, -8.314704E-01>,
      <2.304048E-07, 7.071066E-01, -7.071071E-01>,
      <1.810273E-07, 8.314706E-01, -5.555689E-01>,
      <1.246942E-07, 9.238796E-01, -3.826837E-01>,
      <6.356876E-08, 9.807853E-01, -1.950911E-01>,
      <-1.104931E-16, 1.00E+00, -2.459337E-16>,
      <-6.356871E-08, 9.807854E-01, 1.95091E-01>,
      <-1.246941E-07, 9.238797E-01, 3.826836E-01>,
      <-1.810275E-07, 8.314704E-01, 5.555694E-01>,
      <-2.304047E-07, 7.071066E-01, 7.071071E-01>,
      <-2.709273E-07, 5.555698E-01, 8.3147E-01>,
      <-3.010381E-07, 3.826842E-01, 9.238793E-01>,
      <-3.195804E-07, 1.950914E-01, 9.807851E-01>,
      <-3.258414E-07, 2.067536E-07, 1.00E+00>,
      <-3.195804E-07, -1.950909E-01, 9.807851E-01>,
      <-3.010381E-07, -3.826836E-01, 9.238794E-01>,
      <-2.709273E-07, -5.555695E-01, 8.3147E-01>,
      <-2.304047E-07, -7.071063E-01, 7.071071E-01>,
      <-1.810275E-07, -8.314699E-01, 5.555695E-01>,
      <-1.24694E-07, -9.238795E-01, 3.826832E-01>,
      <-6.356864E-08, -9.80785E-01, 1.950908E-01>,
      <1.104931E-16, -9.999998E-01, 2.459337E-16>,
      <6.356866E-08, -9.80785E-01, -1.950908E-01>,
      <1.24694E-07, -9.238795E-01, -3.826832E-01>,
      <1.810274E-07, -8.314703E-01, -5.555691E-01>,
      <2.304048E-07, -7.071062E-01, -7.071072E-01>,
      <2.709274E-07, -5.555689E-01, -8.314703E-01>,
      <3.01038E-07, -3.826845E-01, -9.23879E-01>,
      <3.195804E-07, -1.9509E-01, -9.807853E-01>
   }
 
   uv_vectors { 
      41, 
      <0.00E+00, 0.00E+00>,
      <-3.000009E-02, 1.175E-01>,
      <-6.000006E-02, 1.175E-01>,
      <-6.000006E-02, 1.855E-01>,
      <-3.000009E-02, 1.855E-01>,
      <-6.000006E-02, 1.514999E-01>,
      <-3.000009E-02, 1.514999E-01>,
      <-9.956325E-01, 6.754004E-01>,
      <-9.956325E-01, 5.006004E-01>,
      <-9.987999E-01, 5.006004E-01>,
      <-9.987999E-01, 6.754004E-01>,
      <-9.862515E-01, 6.754004E-01>,
      <-9.862515E-01, 5.006004E-01>,
      <-9.710177E-01, 6.754004E-01>,
      <-9.710177E-01, 5.006004E-01>,
      <-9.505166E-01, 6.754004E-01>,
      <-9.505166E-01, 5.006004E-01>,
      <-9.255357E-01, 6.754004E-01>,
      <-9.255357E-01, 5.006004E-01>,
      <-8.970353E-01, 6.754004E-01>,
      <-8.970353E-01, 5.006004E-01>,
      <-8.661106E-01, 6.754004E-01>,
      <-8.661106E-01, 5.006004E-01>,
      <-8.3395E-01, 6.754004E-01>,
      <-8.3395E-01, 5.006004E-01>,
      <-8.017893E-01, 6.754004E-01>,
      <-8.017893E-01, 5.006004E-01>,
      <-7.708647E-01, 6.754004E-01>,
      <-7.708647E-01, 5.006004E-01>,
      <-7.423642E-01, 6.754004E-01>,
      <-7.423642E-01, 5.006004E-01>,
      <-7.173834E-01, 6.754004E-01>,
      <-7.173834E-01, 5.006004E-01>,
      <-6.968822E-01, 6.754004E-01>,
      <-6.968822E-01, 5.006004E-01>,
      <-6.816485E-01, 6.754004E-01>,
      <-6.816485E-01, 5.006004E-01>,
      <-6.722676E-01, 6.754004E-01>,
      <-6.722676E-01, 5.006004E-01>,
      <-6.691E-01, 6.754004E-01>,
      <-6.691E-01, 5.006004E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      64, 
      <3, 2, 0>, 0,
      <3, 0, 1>, 0,
      <5, 4, 2>, 0,
      <5, 2, 3>, 0,
      <7, 6, 4>, 0,
      <7, 4, 5>, 0,
      <9, 8, 6>, 0,
      <9, 6, 7>, 0,
      <11, 10, 8>, 0,
      <11, 8, 9>, 0,
      <13, 12, 10>, 0,
      <13, 10, 11>, 0,
      <15, 14, 12>, 0,
      <15, 12, 13>, 0,
      <17, 16, 14>, 0,
      <17, 14, 15>, 0,
      <19, 18, 16>, 0,
      <19, 16, 17>, 0,
      <21, 20, 18>, 0,
      <21, 18, 19>, 0,
      <23, 22, 20>, 0,
      <23, 20, 21>, 0,
      <25, 24, 22>, 0,
      <25, 22, 23>, 0,
      <27, 26, 24>, 0,
      <27, 24, 25>, 0,
      <29, 28, 26>, 0,
      <29, 26, 27>, 0,
      <31, 30, 28>, 0,
      <31, 28, 29>, 0,
      <33, 32, 30>, 0,
      <33, 30, 31>, 0,
      <35, 34, 32>, 0,
      <35, 32, 33>, 0,
      <37, 36, 34>, 0,
      <37, 34, 35>, 0,
      <39, 38, 36>, 0,
      <39, 36, 37>, 0,
      <41, 40, 38>, 0,
      <41, 38, 39>, 0,
      <43, 42, 40>, 0,
      <43, 40, 41>, 0,
      <45, 44, 42>, 0,
      <45, 42, 43>, 0,
      <47, 46, 44>, 0,
      <47, 44, 45>, 0,
      <49, 48, 46>, 0,
      <49, 46, 47>, 0,
      <51, 50, 48>, 0,
      <51, 48, 49>, 0,
      <53, 52, 50>, 0,
      <53, 50, 51>, 0,
      <55, 54, 52>, 0,
      <55, 52, 53>, 0,
      <57, 56, 54>, 0,
      <57, 54, 55>, 0,
      <59, 58, 56>, 0,
      <59, 56, 57>, 0,
      <61, 60, 58>, 0,
      <61, 58, 59>, 0,
      <63, 62, 60>, 0,
      <63, 60, 61>, 0,
      <1, 0, 62>, 0,
      <1, 62, 63>, 0
   }
 
   normal_indices { 
      64, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 2, 0>,
      <2, 0, 0>,
      <3, 3, 2>,
      <3, 2, 2>,
      <4, 4, 3>,
      <4, 3, 3>,
      <5, 5, 4>,
      <5, 4, 4>,
      <6, 6, 5>,
      <6, 5, 5>,
      <7, 7, 6>,
      <7, 6, 6>,
      <8, 8, 7>,
      <8, 7, 7>,
      <9, 9, 8>,
      <9, 8, 8>,
      <10, 10, 9>,
      <10, 9, 9>,
      <11, 11, 10>,
      <11, 10, 10>,
      <12, 12, 11>,
      <12, 11, 11>,
      <13, 13, 12>,
      <13, 12, 12>,
      <14, 14, 13>,
      <14, 13, 13>,
      <15, 15, 14>,
      <15, 14, 14>,
      <16, 16, 15>,
      <16, 15, 15>,
      <17, 17, 16>,
      <17, 16, 16>,
      <18, 18, 17>,
      <18, 17, 17>,
      <19, 19, 18>,
      <19, 18, 18>,
      <20, 20, 19>,
      <20, 19, 19>,
      <21, 21, 20>,
      <21, 20, 20>,
      <22, 22, 21>,
      <22, 21, 21>,
      <23, 23, 22>,
      <23, 22, 22>,
      <24, 24, 23>,
      <24, 23, 23>,
      <25, 25, 24>,
      <25, 24, 24>,
      <26, 26, 25>,
      <26, 25, 25>,
      <27, 27, 26>,
      <27, 26, 26>,
      <28, 28, 27>,
      <28, 27, 27>,
      <29, 29, 28>,
      <29, 28, 28>,
      <30, 30, 29>,
      <30, 29, 29>,
      <31, 31, 30>,
      <31, 30, 30>,
      <1, 1, 31>,
      <1, 31, 31>
   }
 
   uv_indices { 
      64, 
      <7, 8, 9>,
      <7, 9, 10>,
      <11, 12, 8>,
      <11, 8, 7>,
      <13, 14, 12>,
      <13, 12, 11>,
      <15, 16, 14>,
      <15, 14, 13>,
      <17, 18, 16>,
      <17, 16, 15>,
      <19, 20, 18>,
      <19, 18, 17>,
      <21, 22, 20>,
      <21, 20, 19>,
      <23, 24, 22>,
      <23, 22, 21>,
      <25, 26, 24>,
      <25, 24, 23>,
      <27, 28, 26>,
      <27, 26, 25>,
      <29, 30, 28>,
      <29, 28, 27>,
      <31, 32, 30>,
      <31, 30, 29>,
      <33, 34, 32>,
      <33, 32, 31>,
      <35, 36, 34>,
      <35, 34, 33>,
      <37, 38, 36>,
      <37, 36, 35>,
      <39, 40, 38>,
      <39, 38, 37>,
      <37, 38, 40>,
      <37, 40, 39>,
      <35, 36, 38>,
      <35, 38, 37>,
      <33, 34, 36>,
      <33, 36, 35>,
      <31, 32, 34>,
      <31, 34, 33>,
      <29, 30, 32>,
      <29, 32, 31>,
      <27, 28, 30>,
      <27, 30, 29>,
      <25, 26, 28>,
      <25, 28, 27>,
      <23, 24, 26>,
      <23, 26, 25>,
      <21, 22, 24>,
      <21, 24, 23>,
      <19, 20, 22>,
      <19, 22, 21>,
      <17, 18, 20>,
      <17, 20, 19>,
      <15, 16, 18>,
      <15, 18, 17>,
      <13, 14, 16>,
      <13, 16, 15>,
      <11, 12, 14>,
      <11, 14, 13>,
      <7, 8, 12>,
      <7, 12, 11>,
      <10, 9, 8>,
      <10, 8, 7>
   }
   uv_mapping
}
 
// Faces
mesh2 {
 
   vertex_vectors { 
      8, 
      <-1.419379E+00, 1.45736E+00, 1.095023E+01>,
      <-1.419378E+00, 1.45736E+00, 7.953981E+00>,
      <-1.419378E+00, 4.45361E+00, 7.953981E+00>,
      <-1.419379E+00, 4.45361E+00, 1.095023E+01>,
      <-1.025379E+00, 4.45361E+00, 7.953981E+00>,
      <-1.02538E+00, 4.45361E+00, 1.095023E+01>,
      <-1.02538E+00, 1.45736E+00, 1.095023E+01>,
      <-1.025379E+00, 1.45736E+00, 7.953981E+00>
   }
 
   normal_vectors { 
      2, 
      <-1.00E+00, 2.067536E-07, -3.258414E-07>,
      <1.00E+00, 2.067536E-07, 3.258414E-07>
   }
 
   uv_vectors { 
      13, 
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <-1.00E+00, 2.50E-01>,
      <-7.50E-01, 2.50E-01>,
      <-7.50E-01, 0.00E+00>,
      <-1.00E+00, 0.00E+00>,
      <-5.00E-01, 5.00E-01>,
      <-2.980233E-08, 5.00E-01>,
      <-5.00E-01, 0.00E+00>,
      <-4.999999E-01, 5.00E-01>,
      <-9.999999E-01, 5.00E-01>,
      <-9.999999E-01, 0.00E+00>,
      <-4.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      4, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0
   }
 
   normal_indices { 
      4, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>
   }
 
   uv_indices { 
      4, 
      <9, 10, 11>,
      <9, 11, 12>,
      <7, 6, 8>,
      <7, 8, 0>
   }
   uv_mapping
}
 
// Flange
mesh2 {
 
   vertex_vectors { 
      4, 
      <-1.02538E+00, 1.264611E+00, 1.114298E+01>,
      <-1.025379E+00, 1.264611E+00, 7.761232E+00>,
      <-1.025379E+00, 4.646359E+00, 7.761232E+00>,
      <-1.02538E+00, 4.646359E+00, 1.114298E+01>
   }
 
   normal_vectors { 
      1, 
      <-1.00E+00, 2.067536E-07, -3.258414E-07>
   }
 
   uv_vectors { 
      9, 
      <0.00E+00, 0.00E+00>,
      <-1.00E+00, 2.50E-01>,
      <-7.50E-01, 2.50E-01>,
      <-7.50E-01, 0.00E+00>,
      <-1.00E+00, 0.00E+00>,
      <-5.00E-01, 5.00E-01>,
      <-1.00E+00, 5.00E-01>,
      <-1.00E+00, 0.00E+00>,
      <-5.00E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      2, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0
   }
 
   normal_indices { 
      2, 
      <0, 0, 0>,
      <0, 0, 0>
   }
 
   uv_indices { 
      2, 
      <5, 6, 7>,
      <5, 7, 8>
   }
   uv_mapping
}
 
// Rim-Outer
mesh2 {
 
   vertex_vectors { 
      64, 
      <3.682621E+00, 1.45736E+00, 9.452108E+00>,
      <4.076622E+00, 1.45736E+00, 9.452108E+00>,
      <3.682621E+00, 1.486146E+00, 9.744379E+00>,
      <4.076622E+00, 1.486146E+00, 9.744379E+00>,
      <3.682621E+00, 1.571398E+00, 1.002542E+01>,
      <4.076622E+00, 1.571398E+00, 1.002542E+01>,
      <3.682621E+00, 1.70984E+00, 1.028442E+01>,
      <4.076622E+00, 1.70984E+00, 1.028442E+01>,
      <3.682621E+00, 1.896151E+00, 1.051144E+01>,
      <4.076622E+00, 1.896151E+00, 1.051144E+01>,
      <3.682621E+00, 2.123171E+00, 1.069775E+01>,
      <4.076622E+00, 2.123171E+00, 1.069775E+01>,
      <3.682621E+00, 2.382177E+00, 1.083619E+01>,
      <4.076622E+00, 2.382177E+00, 1.083619E+01>,
      <3.682621E+00, 2.663215E+00, 1.092145E+01>,
      <4.076622E+00, 2.663215E+00, 1.092145E+01>,
      <3.682621E+00, 2.955485E+00, 1.095023E+01>,
      <4.076622E+00, 2.955485E+00, 1.095023E+01>,
      <3.682621E+00, 3.247755E+00, 1.092145E+01>,
      <4.076622E+00, 3.247755E+00, 1.092145E+01>,
      <3.682621E+00, 3.528792E+00, 1.083619E+01>,
      <4.076622E+00, 3.528792E+00, 1.083619E+01>,
      <3.682621E+00, 3.787798E+00, 1.069775E+01>,
      <4.076622E+00, 3.787798E+00, 1.069775E+01>,
      <3.682621E+00, 4.014819E+00, 1.051144E+01>,
      <4.076622E+00, 4.014819E+00, 1.051144E+01>,
      <3.682621E+00, 4.20113E+00, 1.028442E+01>,
      <4.076622E+00, 4.20113E+00, 1.028442E+01>,
      <3.682621E+00, 4.339572E+00, 1.002542E+01>,
      <4.076622E+00, 4.339571E+00, 1.002542E+01>,
      <3.682621E+00, 4.424824E+00, 9.744379E+00>,
      <4.076622E+00, 4.424824E+00, 9.744379E+00>,
      <3.682621E+00, 4.45361E+00, 9.452108E+00>,
      <4.076622E+00, 4.45361E+00, 9.452108E+00>,
      <3.682621E+00, 4.424824E+00, 9.15984E+00>,
      <4.076622E+00, 4.424824E+00, 9.15984E+00>,
      <3.682621E+00, 4.339572E+00, 8.878801E+00>,
      <4.076622E+00, 4.339571E+00, 8.878801E+00>,
      <3.682621E+00, 4.20113E+00, 8.619795E+00>,
      <4.076622E+00, 4.20113E+00, 8.619795E+00>,
      <3.682621E+00, 4.01482E+00, 8.392774E+00>,
      <4.076622E+00, 4.014819E+00, 8.392774E+00>,
      <3.682621E+00, 3.787799E+00, 8.206463E+00>,
      <4.076622E+00, 3.787799E+00, 8.206464E+00>,
      <3.682621E+00, 3.528792E+00, 8.068022E+00>,
      <4.076622E+00, 3.528792E+00, 8.068022E+00>,
      <3.682621E+00, 3.247755E+00, 7.982769E+00>,
      <4.076622E+00, 3.247755E+00, 7.982769E+00>,
      <3.682621E+00, 2.955485E+00, 7.953984E+00>,
      <4.076622E+00, 2.955485E+00, 7.953984E+00>,
      <3.682621E+00, 2.663215E+00, 7.982769E+00>,
      <4.076622E+00, 2.663215E+00, 7.982769E+00>,
      <3.682621E+00, 2.382177E+00, 8.068022E+00>,
      <4.076622E+00, 2.382177E+00, 8.068022E+00>,
      <3.682621E+00, 2.123171E+00, 8.206464E+00>,
      <4.076622E+00, 2.123171E+00, 8.206464E+00>,
      <3.682621E+00, 1.89615E+00, 8.392774E+00>,
      <4.076622E+00, 1.896151E+00, 8.392774E+00>,
      <3.682621E+00, 1.709839E+00, 8.619795E+00>,
      <4.076622E+00, 1.70984E+00, 8.619795E+00>,
      <3.682621E+00, 1.571398E+00, 8.878801E+00>,
      <4.076622E+00, 1.571398E+00, 8.878801E+00>,
      <3.682621E+00, 1.486146E+00, 9.15984E+00>,
      <4.076622E+00, 1.486146E+00, 9.15984E+00>
   }
 
   normal_vectors { 
      32, 
      <2.409081E-07, -9.80785E-01, 1.950909E-01>,
      <1.104931E-16, -9.999998E-01, 2.459337E-16>,
      <1.834556E-07, -9.238794E-01, 3.826832E-01>,
      <6.338014E-08, -8.3147E-01, 5.555695E-01>,
      <1.773443E-07, -7.071066E-01, 7.071068E-01>,
      <6.634007E-07, -5.555698E-01, 8.314698E-01>,
      <5.765742E-07, -3.826832E-01, 9.238795E-01>,
      <-5.723528E-08, -1.950905E-01, 9.807852E-01>,
      <-3.258414E-07, 2.067536E-07, 1.00E+00>,
      <-1.548728E-08, 1.950909E-01, 9.807853E-01>,
      <5.499105E-07, 3.826837E-01, 9.238795E-01>,
      <4.786344E-07, 5.555701E-01, 8.314698E-01>,
      <4.83249E-08, 7.071068E-01, 7.071069E-01>,
      <1.737588E-07, 8.314703E-01, 5.555695E-01>,
      <2.987695E-07, 9.238798E-01, 3.826832E-01>,
      <2.331786E-07, 9.807854E-01, 1.950908E-01>,
      <-1.104931E-16, 1.00E+00, -2.459337E-16>,
      <3.676624E-07, 9.807854E-01, -1.95091E-01>,
      <5.8818E-07, 9.238797E-01, -3.826833E-01>,
      <6.698424E-07, 8.314707E-01, -5.555688E-01>,
      <5.436735E-07, 7.071066E-01, -7.071071E-01>,
      <4.068199E-07, 5.555693E-01, -8.314704E-01>,
      <3.229491E-07, 3.826849E-01, -9.23879E-01>,
      <3.414915E-07, 1.950902E-01, -9.807854E-01>,
      <3.258414E-07, 2.067536E-07, -1.00E+00>,
      <3.195804E-07, -1.950897E-01, -9.807854E-01>,
      <3.770614E-07, -3.826844E-01, -9.23879E-01>,
      <4.321159E-07, -5.555689E-01, -8.314704E-01>,
      <4.37682E-07, -7.071062E-01, -7.071072E-01>,
      <4.425209E-07, -8.314702E-01, -5.555691E-01>,
      <4.124493E-07, -9.238794E-01, -3.826834E-01>,
      <3.636061E-07, -9.80785E-01, -1.950908E-01>
   }
 
   uv_vectors { 
      73, 
      <0.00E+00, 0.00E+00>,
      <-6.00E-02, 1.855E-01>,
      <-3.000003E-02, 1.855E-01>,
      <-3.000003E-02, 1.175E-01>,
      <-6.00E-02, 1.175E-01>,
      <-6.00E-02, 1.514999E-01>,
      <-3.000003E-02, 1.514999E-01>,
      <-9.988E-01, 5.022793E-01>,
      <-6.691E-01, 5.022793E-01>,
      <-6.691E-01, 5.006E-01>,
      <-9.988E-01, 5.006E-01>,
      <-9.988E-01, 5.072529E-01>,
      <-6.691E-01, 5.072529E-01>,
      <-9.988E-01, 5.153295E-01>,
      <-6.691E-01, 5.153295E-01>,
      <-9.988E-01, 5.261989E-01>,
      <-6.691E-01, 5.261989E-01>,
      <-9.988E-01, 5.394431E-01>,
      <-6.691E-01, 5.394431E-01>,
      <-9.988E-01, 5.545534E-01>,
      <-6.691E-01, 5.545534E-01>,
      <-9.988E-01, 5.709491E-01>,
      <-6.691E-01, 5.709491E-01>,
      <-9.988E-01, 5.88E-01>,
      <-6.691E-01, 5.88E-01>,
      <-9.988E-01, 6.050509E-01>,
      <-6.691E-01, 6.050509E-01>,
      <-9.988E-01, 6.214465E-01>,
      <-6.691E-01, 6.214465E-01>,
      <-9.988E-01, 6.365568E-01>,
      <-6.691E-01, 6.365568E-01>,
      <-9.988E-01, 6.498011E-01>,
      <-6.691E-01, 6.498011E-01>,
      <-9.988E-01, 6.606704E-01>,
      <-6.691E-01, 6.606704E-01>,
      <-9.988E-01, 6.687471E-01>,
      <-6.691E-01, 6.687471E-01>,
      <-9.988E-01, 6.737206E-01>,
      <-6.691E-01, 6.737206E-01>,
      <-9.988E-01, 6.754E-01>,
      <-6.691E-01, 6.754E-01>,
      <-8.017893E-01, 6.754E-01>,
      <-8.017893E-01, 5.006E-01>,
      <-8.3395E-01, 5.006E-01>,
      <-8.3395E-01, 6.754E-01>,
      <-7.708647E-01, 6.754E-01>,
      <-7.708647E-01, 5.006E-01>,
      <-7.423642E-01, 6.754E-01>,
      <-7.423642E-01, 5.006E-01>,
      <-7.173834E-01, 6.754E-01>,
      <-7.173834E-01, 5.006E-01>,
      <-6.968822E-01, 6.754E-01>,
      <-6.968822E-01, 5.006E-01>,
      <-6.816485E-01, 6.754E-01>,
      <-6.816484E-01, 5.006E-01>,
      <-6.722676E-01, 6.754E-01>,
      <-6.722676E-01, 5.006E-01>,
      <-6.691E-01, 5.006E-01>,
      <-8.661106E-01, 6.754E-01>,
      <-8.661106E-01, 5.006E-01>,
      <-8.970353E-01, 6.754E-01>,
      <-8.970353E-01, 5.006E-01>,
      <-9.255357E-01, 6.754E-01>,
      <-9.255357E-01, 5.006E-01>,
      <-9.505166E-01, 6.754E-01>,
      <-9.505166E-01, 5.006E-01>,
      <-9.710177E-01, 6.754E-01>,
      <-9.710177E-01, 5.006E-01>,
      <-9.862515E-01, 6.754E-01>,
      <-9.862515E-01, 5.006E-01>,
      <-9.956325E-01, 6.754E-01>,
      <-9.956325E-01, 5.006E-01>,
      <-9.987999E-01, 6.754E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      64, 
      <3, 2, 0>, 0,
      <3, 0, 1>, 0,
      <5, 4, 2>, 0,
      <5, 2, 3>, 0,
      <7, 6, 4>, 0,
      <7, 4, 5>, 0,
      <9, 8, 6>, 0,
      <9, 6, 7>, 0,
      <11, 10, 8>, 0,
      <11, 8, 9>, 0,
      <13, 12, 10>, 0,
      <13, 10, 11>, 0,
      <15, 14, 12>, 0,
      <15, 12, 13>, 0,
      <17, 16, 14>, 0,
      <17, 14, 15>, 0,
      <19, 18, 16>, 0,
      <19, 16, 17>, 0,
      <21, 20, 18>, 0,
      <21, 18, 19>, 0,
      <23, 22, 20>, 0,
      <23, 20, 21>, 0,
      <25, 24, 22>, 0,
      <25, 22, 23>, 0,
      <27, 26, 24>, 0,
      <27, 24, 25>, 0,
      <29, 28, 26>, 0,
      <29, 26, 27>, 0,
      <31, 30, 28>, 0,
      <31, 28, 29>, 0,
      <33, 32, 30>, 0,
      <33, 30, 31>, 0,
      <35, 34, 32>, 0,
      <35, 32, 33>, 0,
      <37, 36, 34>, 0,
      <37, 34, 35>, 0,
      <39, 38, 36>, 0,
      <39, 36, 37>, 0,
      <41, 40, 38>, 0,
      <41, 38, 39>, 0,
      <43, 42, 40>, 0,
      <43, 40, 41>, 0,
      <45, 44, 42>, 0,
      <45, 42, 43>, 0,
      <47, 46, 44>, 0,
      <47, 44, 45>, 0,
      <49, 48, 46>, 0,
      <49, 46, 47>, 0,
      <51, 50, 48>, 0,
      <51, 48, 49>, 0,
      <53, 52, 50>, 0,
      <53, 50, 51>, 0,
      <55, 54, 52>, 0,
      <55, 52, 53>, 0,
      <57, 56, 54>, 0,
      <57, 54, 55>, 0,
      <59, 58, 56>, 0,
      <59, 56, 57>, 0,
      <61, 60, 58>, 0,
      <61, 58, 59>, 0,
      <63, 62, 60>, 0,
      <63, 60, 61>, 0,
      <1, 0, 62>, 0,
      <1, 62, 63>, 0
   }
 
   normal_indices { 
      64, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 2, 0>,
      <2, 0, 0>,
      <3, 3, 2>,
      <3, 2, 2>,
      <4, 4, 3>,
      <4, 3, 3>,
      <5, 5, 4>,
      <5, 4, 4>,
      <6, 6, 5>,
      <6, 5, 5>,
      <7, 7, 6>,
      <7, 6, 6>,
      <8, 8, 7>,
      <8, 7, 7>,
      <9, 9, 8>,
      <9, 8, 8>,
      <10, 10, 9>,
      <10, 9, 9>,
      <11, 11, 10>,
      <11, 10, 10>,
      <12, 12, 11>,
      <12, 11, 11>,
      <13, 13, 12>,
      <13, 12, 12>,
      <14, 14, 13>,
      <14, 13, 13>,
      <15, 15, 14>,
      <15, 14, 14>,
      <16, 16, 15>,
      <16, 15, 15>,
      <17, 17, 16>,
      <17, 16, 16>,
      <18, 18, 17>,
      <18, 17, 17>,
      <19, 19, 18>,
      <19, 18, 18>,
      <20, 20, 19>,
      <20, 19, 19>,
      <21, 21, 20>,
      <21, 20, 20>,
      <22, 22, 21>,
      <22, 21, 21>,
      <23, 23, 22>,
      <23, 22, 22>,
      <24, 24, 23>,
      <24, 23, 23>,
      <25, 25, 24>,
      <25, 24, 24>,
      <26, 26, 25>,
      <26, 25, 25>,
      <27, 27, 26>,
      <27, 26, 26>,
      <28, 28, 27>,
      <28, 27, 27>,
      <29, 29, 28>,
      <29, 28, 28>,
      <30, 30, 29>,
      <30, 29, 29>,
      <31, 31, 30>,
      <31, 30, 30>,
      <1, 1, 31>,
      <1, 31, 31>
   }
 
   uv_indices { 
      64, 
      <41, 42, 43>,
      <41, 43, 44>,
      <45, 46, 42>,
      <45, 42, 41>,
      <47, 48, 46>,
      <47, 46, 45>,
      <49, 50, 48>,
      <49, 48, 47>,
      <51, 52, 50>,
      <51, 50, 49>,
      <53, 54, 52>,
      <53, 52, 51>,
      <55, 56, 54>,
      <55, 54, 53>,
      <40, 57, 56>,
      <40, 56, 55>,
      <55, 56, 57>,
      <55, 57, 40>,
      <53, 54, 56>,
      <53, 56, 55>,
      <51, 52, 54>,
      <51, 54, 53>,
      <49, 50, 52>,
      <49, 52, 51>,
      <47, 48, 50>,
      <47, 50, 49>,
      <45, 46, 48>,
      <45, 48, 47>,
      <41, 42, 46>,
      <41, 46, 45>,
      <44, 43, 42>,
      <44, 42, 41>,
      <58, 59, 43>,
      <58, 43, 44>,
      <60, 61, 59>,
      <60, 59, 58>,
      <62, 63, 61>,
      <62, 61, 60>,
      <64, 65, 63>,
      <64, 63, 62>,
      <66, 67, 65>,
      <66, 65, 64>,
      <68, 69, 67>,
      <68, 67, 66>,
      <70, 71, 69>,
      <70, 69, 68>,
      <72, 10, 71>,
      <72, 71, 70>,
      <70, 71, 10>,
      <70, 10, 72>,
      <68, 69, 71>,
      <68, 71, 70>,
      <66, 67, 69>,
      <66, 69, 68>,
      <64, 65, 67>,
      <64, 67, 66>,
      <62, 63, 65>,
      <62, 65, 64>,
      <60, 61, 63>,
      <60, 63, 62>,
      <58, 59, 61>,
      <58, 61, 60>,
      <44, 43, 59>,
      <44, 59, 58>
   }
   uv_mapping
}
 
// Faces
mesh2 {
 
   vertex_vectors { 
      8, 
      <4.076622E+00, 4.45361E+00, 7.953983E+00>,
      <4.076622E+00, 1.45736E+00, 7.953984E+00>,
      <4.076622E+00, 1.45736E+00, 1.095023E+01>,
      <4.076622E+00, 4.45361E+00, 1.095023E+01>,
      <3.682621E+00, 1.45736E+00, 1.095023E+01>,
      <3.682621E+00, 4.45361E+00, 1.095023E+01>,
      <3.682621E+00, 4.45361E+00, 7.953983E+00>,
      <3.682621E+00, 1.45736E+00, 7.953984E+00>
   }
 
   normal_vectors { 
      2, 
      <1.00E+00, 2.067536E-07, 3.258414E-07>,
      <-1.00E+00, 2.067536E-07, -3.258414E-07>
   }
 
   uv_vectors { 
      13, 
      <0.00E+00, 0.00E+00>,
      <0.00E+00, 0.00E+00>,
      <-1.00E+00, 0.00E+00>,
      <-1.00E+00, 2.50E-01>,
      <-7.50E-01, 2.50E-01>,
      <-7.50E-01, 0.00E+00>,
      <-7.50E-01, 2.50E-01>,
      <-7.105427E-15, 5.00E-01>,
      <-4.999999E-01, 0.00E+00>,
      <-4.999999E-01, 5.00E-01>,
      <-1.00E+00, 5.00E-01>,
      <-5.000001E-01, 0.00E+00>,
      <-5.000001E-01, 5.00E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      4, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0
   }
 
   normal_indices { 
      4, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>
   }
 
   uv_indices { 
      4, 
      <10, 2, 11>,
      <10, 11, 12>,
      <0, 7, 9>,
      <0, 9, 8>
   }
   uv_mapping
}
 
// axle
mesh2 {
 
   vertex_vectors { 
      12, 
      <3.682621E+00, 2.955485E+00, 8.982109E+00>,
      <-1.025379E+00, 2.955485E+00, 8.982107E+00>,
      <3.682621E+00, 3.362517E+00, 9.21711E+00>,
      <-1.025379E+00, 3.362517E+00, 9.217106E+00>,
      <3.682621E+00, 3.362517E+00, 9.687109E+00>,
      <-1.025379E+00, 3.362517E+00, 9.687107E+00>,
      <3.682621E+00, 2.955485E+00, 9.922108E+00>,
      <-1.025379E+00, 2.955485E+00, 9.922106E+00>,
      <3.682621E+00, 2.548453E+00, 9.687109E+00>,
      <-1.025379E+00, 2.548453E+00, 9.687107E+00>,
      <3.682621E+00, 2.548453E+00, 9.21711E+00>,
      <-1.025379E+00, 2.548453E+00, 9.217106E+00>
   }
 
   normal_vectors { 
      8, 
      <2.82187E-07, 4.999999E-01, -8.660256E-01>,
      <3.258414E-07, 2.067536E-07, -1.00E+00>,
      <-1.104931E-16, 1.00E+00, -2.459337E-16>,
      <-3.258414E-07, 2.067536E-07, 1.00E+00>,
      <-2.82187E-07, 4.999999E-01, 8.660256E-01>,
      <-2.82187E-07, -4.999994E-01, 8.660256E-01>,
      <1.104931E-16, -9.999998E-01, 2.459337E-16>,
      <2.82187E-07, -4.999994E-01, -8.660256E-01>
   }
 
   uv_vectors { 
      67, 
      <0.00E+00, 0.00E+00>,
      <-2.08447E-01, 2.929997E-02>,
      <-2.007531E-01, 2.929997E-02>,
      <-2.005589E-01, 2.244997E-02>,
      <-2.086411E-01, 2.244997E-02>,
      <-2.080531E-01, 2.929997E-02>,
      <-2.01147E-01, 2.929997E-02>,
      <-2.078589E-01, 2.244997E-02>,
      <-2.013412E-01, 2.244997E-02>,
      <-2.080531E-01, 1.559997E-02>,
      <-2.01147E-01, 1.559997E-02>,
      <-2.08447E-01, 1.559997E-02>,
      <-2.007531E-01, 1.559997E-02>,
      <-8.506777E-01, 2.10E-01>,
      <-8.788224E-01, 2.10E-01>,
      <-8.780311E-01, 2.007E-01>,
      <-8.514689E-01, 2.007E-01>,
      <-8.490724E-01, 2.10E-01>,
      <-8.804277E-01, 2.10E-01>,
      <-8.482811E-01, 2.007E-01>,
      <-8.812189E-01, 2.007E-01>,
      <-8.490724E-01, 1.914E-01>,
      <-8.804277E-01, 1.914E-01>,
      <-8.506777E-01, 1.914E-01>,
      <-8.788224E-01, 1.914E-01>,
      <-2.471001E-01, 6.716E-01>,
      <-3.27E-01, 5.886E-01>,
      <-8.730006E-02, 6.716E-01>,
      <-7.400038E-03, 5.886E-01>,
      <-8.730006E-02, 5.056E-01>,
      <-2.471001E-01, 5.056E-01>,
      <-1.715114E-01, 6.716E-01>,
      <-3.226887E-01, 6.716E-01>,
      <-3.184385E-01, 5.886E-01>,
      <-1.757616E-01, 5.886E-01>,
      <-1.628887E-01, 6.716E-01>,
      <-1.17113E-02, 6.716E-01>,
      <-1.586385E-01, 5.886E-01>,
      <-1.596153E-02, 5.886E-01>,
      <-1.628887E-01, 5.056E-01>,
      <-1.17113E-02, 5.056E-01>,
      <-1.715114E-01, 5.056E-01>,
      <-3.226887E-01, 5.056E-01>,
      <-2.514113E-01, 6.716E-01>,
      <-8.298867E-02, 6.716E-01>,
      <-7.873844E-02, 5.886E-01>,
      <-2.556615E-01, 5.886E-01>,
      <-2.427887E-01, 6.716E-01>,
      <-9.161132E-02, 6.716E-01>,
      <-2.385385E-01, 5.886E-01>,
      <-9.586155E-02, 5.886E-01>,
      <-2.427887E-01, 5.056E-01>,
      <-9.161132E-02, 5.056E-01>,
      <-2.514113E-01, 5.056E-01>,
      <-8.298867E-02, 5.056E-01>,
      <-1.907546E-01, 6.741E-01>,
      <-1.124454E-01, 6.741E-01>,
      <-1.104693E-01, 5.9045E-01>,
      <-1.927307E-01, 5.9045E-01>,
      <-1.867455E-01, 6.741E-01>,
      <-1.164545E-01, 6.741E-01>,
      <-1.847693E-01, 5.9045E-01>,
      <-1.184307E-01, 5.9045E-01>,
      <-1.867455E-01, 5.068E-01>,
      <-1.164545E-01, 5.068E-01>,
      <-1.907546E-01, 5.068E-01>,
      <-1.124454E-01, 5.068E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      12, 
      <3, 2, 0>, 0,
      <3, 0, 1>, 0,
      <5, 4, 2>, 0,
      <5, 2, 3>, 0,
      <7, 6, 4>, 0,
      <7, 4, 5>, 0,
      <9, 8, 6>, 0,
      <9, 6, 7>, 0,
      <11, 10, 8>, 0,
      <11, 8, 9>, 0,
      <1, 0, 10>, 0,
      <1, 10, 11>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 4>,
      <3, 4, 4>,
      <5, 5, 3>,
      <5, 3, 3>,
      <6, 6, 6>,
      <6, 6, 6>,
      <1, 1, 7>,
      <1, 7, 7>
   }
 
   uv_indices { 
      12, 
      <55, 56, 57>,
      <55, 57, 58>,
      <59, 60, 56>,
      <59, 56, 55>,
      <61, 62, 60>,
      <61, 60, 59>,
      <63, 64, 62>,
      <63, 62, 61>,
      <65, 66, 64>,
      <65, 64, 63>,
      <58, 57, 66>,
      <58, 66, 65>
   }
   uv_mapping
}
 
// Flange
mesh2 {
 
   vertex_vectors { 
      4, 
      <3.682621E+00, 4.646359E+00, 7.761235E+00>,
      <3.682621E+00, 1.264611E+00, 7.761235E+00>,
      <3.682621E+00, 1.264611E+00, 1.114298E+01>,
      <3.682621E+00, 4.646359E+00, 1.114298E+01>
   }
 
   normal_vectors { 
      1, 
      <1.00E+00, 2.067536E-07, 3.258414E-07>
   }
 
   uv_vectors { 
      9, 
      <0.00E+00, 0.00E+00>,
      <-7.499999E-01, 2.50E-01>,
      <-7.499999E-01, 0.00E+00>,
      <-9.999999E-01, 0.00E+00>,
      <-9.999999E-01, 2.50E-01>,
      <-1.00E+00, 4.999999E-01>,
      <-1.00E+00, 0.00E+00>,
      <-5.000001E-01, 0.00E+00>,
      <-5.000001E-01, 5.00E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex29}
   }
 
   face_indices { 
      2, 
      <3, 2, 1>, 0,
      <3, 1, 0>, 0
   }
 
   normal_indices { 
      2, 
      <0, 0, 0>,
      <0, 0, 0>
   }
 
   uv_indices { 
      2, 
      <5, 6, 7>,
      <5, 7, 8>
   }
   uv_mapping
}
 
// Handrail
mesh2 {
 
   vertex_vectors { 
      8, 
      <6.028619E+00, 1.355267E+01, 1.166323E+01>,
      <6.028625E+00, 1.355267E+01, -7.336773E+00>,
      <5.972619E+00, 1.349667E+01, 1.166323E+01>,
      <5.972625E+00, 1.349667E+01, -7.336773E+00>,
      <5.916619E+00, 1.355267E+01, 1.166323E+01>,
      <5.916625E+00, 1.355267E+01, -7.336773E+00>,
      <5.972619E+00, 1.360867E+01, 1.166323E+01>,
      <5.972625E+00, 1.360867E+01, -7.336773E+00>
   }
 
   normal_vectors { 
      6, 
      <7.071068E-01, -7.071068E-01, 2.304046E-07>,
      <-7.071068E-01, -7.071068E-01, -2.304046E-07>,
      <-7.071068E-01, 7.071067E-01, -2.304046E-07>,
      <7.071066E-01, 7.071068E-01, 2.304046E-07>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      12, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <1, 3, 5>, 0,
      <1, 5, 7>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Sta0
mesh2 {
 
   vertex_vectors { 
      8, 
      <6.042619E+00, 1.363267E+01, 1.161323E+01>,
      <6.042619E+00, 1.283267E+01, 1.161323E+01>,
      <5.972619E+00, 1.363267E+01, 1.168323E+01>,
      <5.972619E+00, 1.283267E+01, 1.168323E+01>,
      <5.902619E+00, 1.363267E+01, 1.161323E+01>,
      <5.902619E+00, 1.283267E+01, 1.161323E+01>,
      <5.972619E+00, 1.363267E+01, 1.154323E+01>,
      <5.972619E+00, 1.283267E+01, 1.154323E+01>
   }
 
   normal_vectors { 
      5, 
      <7.071083E-01, -3.166497E-08, 7.071053E-01>,
      <-7.071088E-01, 1.607939E-08, 7.071048E-01>,
      <-7.071083E-01, -3.166497E-08, -7.071053E-01>,
      <7.071088E-01, -7.940932E-08, -7.071048E-01>,
      <0.00E+00, 9.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Sta1
mesh2 {
 
   vertex_vectors { 
      8, 
      <6.04262E+00, 1.363267E+01, 7.833227E+00>,
      <6.04262E+00, 1.283267E+01, 7.833227E+00>,
      <5.97262E+00, 1.363267E+01, 7.903228E+00>,
      <5.97262E+00, 1.283267E+01, 7.903228E+00>,
      <5.90262E+00, 1.363267E+01, 7.833227E+00>,
      <5.90262E+00, 1.283267E+01, 7.833227E+00>,
      <5.97262E+00, 1.363267E+01, 7.763227E+00>,
      <5.97262E+00, 1.283267E+01, 7.763227E+00>
   }
 
   normal_vectors { 
      5, 
      <7.071062E-01, -3.166497E-08, 7.071074E-01>,
      <-7.071067E-01, -1.083854E-07, 7.071069E-01>,
      <-7.071062E-01, -3.166497E-08, -7.071074E-01>,
      <7.071067E-01, 4.50555E-08, -7.071069E-01>,
      <0.00E+00, 9.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Sta2
mesh2 {
 
   vertex_vectors { 
      8, 
      <6.042621E+00, 1.363267E+01, 4.053227E+00>,
      <6.042621E+00, 1.283267E+01, 4.053227E+00>,
      <5.972621E+00, 1.363267E+01, 4.123227E+00>,
      <5.972621E+00, 1.283267E+01, 4.123227E+00>,
      <5.902622E+00, 1.363267E+01, 4.053227E+00>,
      <5.902622E+00, 1.283267E+01, 4.053227E+00>,
      <5.972621E+00, 1.363267E+01, 3.983227E+00>,
      <5.972621E+00, 1.283267E+01, 3.983227E+00>
   }
 
   normal_vectors { 
      5, 
      <7.071068E-01, -3.166497E-08, 7.071068E-01>,
      <-7.071072E-01, -3.528696E-08, 7.071064E-01>,
      <-7.071065E-01, -3.166497E-08, -7.071071E-01>,
      <7.071069E-01, -2.804297E-08, -7.071066E-01>,
      <0.00E+00, 9.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Sta3
mesh2 {
 
   vertex_vectors { 
      8, 
      <6.042622E+00, 1.363267E+01, 2.732268E-01>,
      <6.042622E+00, 1.283267E+01, 2.732268E-01>,
      <5.972622E+00, 1.363267E+01, 3.432274E-01>,
      <5.972622E+00, 1.283267E+01, 3.432274E-01>,
      <5.902623E+00, 1.363267E+01, 2.732267E-01>,
      <5.902623E+00, 1.283267E+01, 2.732267E-01>,
      <5.972622E+00, 1.363267E+01, 2.03227E-01>,
      <5.972622E+00, 1.283267E+01, 2.03227E-01>
   }
 
   normal_vectors { 
      5, 
      <7.071065E-01, -3.166497E-08, 7.071071E-01>,
      <-7.071069E-01, -2.804297E-08, 7.071066E-01>,
      <-7.071068E-01, -3.166497E-08, -7.071068E-01>,
      <7.071072E-01, -3.528696E-08, -7.071064E-01>,
      <0.00E+00, 9.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Sta4
mesh2 {
 
   vertex_vectors { 
      8, 
      <6.042624E+00, 1.363267E+01, -3.506773E+00>,
      <6.042624E+00, 1.283267E+01, -3.506773E+00>,
      <5.972624E+00, 1.363267E+01, -3.436773E+00>,
      <5.972624E+00, 1.283267E+01, -3.436773E+00>,
      <5.902624E+00, 1.363267E+01, -3.506773E+00>,
      <5.902624E+00, 1.283267E+01, -3.506773E+00>,
      <5.972624E+00, 1.363267E+01, -3.576773E+00>,
      <5.972624E+00, 1.283267E+01, -3.576773E+00>
   }
 
   normal_vectors { 
      5, 
      <7.071062E-01, -3.166497E-08, 7.071074E-01>,
      <-7.071067E-01, 4.50555E-08, 7.071069E-01>,
      <-7.071062E-01, -3.166497E-08, -7.071074E-01>,
      <7.071067E-01, -1.083854E-07, -7.071069E-01>,
      <0.00E+00, 9.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Sta5
mesh2 {
 
   vertex_vectors { 
      8, 
      <6.042624E+00, 1.363267E+01, -7.286774E+00>,
      <6.042624E+00, 1.283267E+01, -7.286774E+00>,
      <5.972625E+00, 1.363267E+01, -7.216772E+00>,
      <5.972625E+00, 1.283267E+01, -7.216772E+00>,
      <5.902625E+00, 1.363267E+01, -7.286774E+00>,
      <5.902625E+00, 1.283267E+01, -7.286774E+00>,
      <5.972625E+00, 1.363267E+01, -7.356771E+00>,
      <5.972625E+00, 1.283267E+01, -7.356771E+00>
   }
 
   normal_vectors { 
      5, 
      <7.071083E-01, -3.166497E-08, 7.071053E-01>,
      <-7.071088E-01, -7.940932E-08, 7.071048E-01>,
      <-7.071083E-01, -3.166497E-08, -7.071053E-01>,
      <7.071088E-01, 1.607939E-08, -7.071048E-01>,
      <0.00E+00, 9.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Handrail
mesh2 {
 
   vertex_vectors { 
      8, 
      <-3.28448E+00, 1.355267E+01, 1.166742E+01>,
      <-3.284474E+00, 1.355267E+01, -7.332581E+00>,
      <-3.228481E+00, 1.349667E+01, 1.166742E+01>,
      <-3.228474E+00, 1.349667E+01, -7.332581E+00>,
      <-3.172481E+00, 1.355267E+01, 1.166742E+01>,
      <-3.172475E+00, 1.355267E+01, -7.332581E+00>,
      <-3.228481E+00, 1.360867E+01, 1.166742E+01>,
      <-3.228474E+00, 1.360867E+01, -7.332581E+00>
   }
 
   normal_vectors { 
      6, 
      <-7.071068E-01, -7.071068E-01, -2.304046E-07>,
      <7.071068E-01, -7.071068E-01, 2.304046E-07>,
      <7.071068E-01, 7.071067E-01, 2.304046E-07>,
      <-7.071066E-01, 7.071068E-01, -2.304046E-07>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      12, 
      <1, 3, 2>, 0,
      <1, 2, 0>, 0,
      <3, 5, 4>, 0,
      <3, 4, 2>, 0,
      <5, 7, 6>, 0,
      <5, 6, 4>, 0,
      <7, 1, 0>, 0,
      <7, 0, 6>, 0,
      <1, 7, 5>, 0,
      <1, 5, 3>, 0,
      <6, 0, 2>, 0,
      <6, 2, 4>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Sta0
mesh2 {
 
   vertex_vectors { 
      8, 
      <-3.298482E+00, 1.363267E+01, 1.161742E+01>,
      <-3.298482E+00, 1.283267E+01, 1.161742E+01>,
      <-3.228481E+00, 1.363267E+01, 1.168742E+01>,
      <-3.228481E+00, 1.283267E+01, 1.168742E+01>,
      <-3.158479E+00, 1.363267E+01, 1.161742E+01>,
      <-3.158479E+00, 1.283267E+01, 1.161742E+01>,
      <-3.228481E+00, 1.363267E+01, 1.154742E+01>,
      <-3.228481E+00, 1.283267E+01, 1.154742E+01>
   }
 
   normal_vectors { 
      5, 
      <-7.071088E-01, -3.166497E-08, 7.071048E-01>,
      <7.071083E-01, 1.607939E-08, 7.071053E-01>,
      <7.071088E-01, -3.166497E-08, -7.071048E-01>,
      <-7.071083E-01, -7.940932E-08, -7.071053E-01>,
      <0.00E+00, 9.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 3, 2>, 0,
      <1, 2, 0>, 0,
      <3, 5, 4>, 0,
      <3, 4, 2>, 0,
      <5, 7, 6>, 0,
      <5, 6, 4>, 0,
      <7, 1, 0>, 0,
      <7, 0, 6>, 0,
      <6, 0, 2>, 0,
      <6, 2, 4>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Sta1
mesh2 {
 
   vertex_vectors { 
      8, 
      <-3.298479E+00, 1.363267E+01, 7.83742E+00>,
      <-3.298479E+00, 1.283267E+01, 7.83742E+00>,
      <-3.228479E+00, 1.363267E+01, 7.90742E+00>,
      <-3.228479E+00, 1.283267E+01, 7.90742E+00>,
      <-3.15848E+00, 1.363267E+01, 7.83742E+00>,
      <-3.15848E+00, 1.283267E+01, 7.83742E+00>,
      <-3.228479E+00, 1.363267E+01, 7.767419E+00>,
      <-3.228479E+00, 1.283267E+01, 7.767419E+00>
   }
 
   normal_vectors { 
      5, 
      <-7.071067E-01, -3.166497E-08, 7.071069E-01>,
      <7.071062E-01, -1.083854E-07, 7.071074E-01>,
      <7.071067E-01, -3.166497E-08, -7.071069E-01>,
      <-7.071062E-01, 4.50555E-08, -7.071074E-01>,
      <0.00E+00, 9.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 3, 2>, 0,
      <1, 2, 0>, 0,
      <3, 5, 4>, 0,
      <3, 4, 2>, 0,
      <5, 7, 6>, 0,
      <5, 6, 4>, 0,
      <7, 1, 0>, 0,
      <7, 0, 6>, 0,
      <6, 0, 2>, 0,
      <6, 2, 4>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Sta2
mesh2 {
 
   vertex_vectors { 
      8, 
      <-3.298478E+00, 1.363267E+01, 4.05742E+00>,
      <-3.298478E+00, 1.283267E+01, 4.05742E+00>,
      <-3.228478E+00, 1.363267E+01, 4.127419E+00>,
      <-3.228478E+00, 1.283267E+01, 4.127419E+00>,
      <-3.158478E+00, 1.363267E+01, 4.05742E+00>,
      <-3.158478E+00, 1.283267E+01, 4.05742E+00>,
      <-3.228478E+00, 1.363267E+01, 3.987419E+00>,
      <-3.228478E+00, 1.283267E+01, 3.987419E+00>
   }
 
   normal_vectors { 
      5, 
      <-7.071072E-01, -3.166497E-08, 7.071064E-01>,
      <7.071068E-01, -3.528696E-08, 7.071068E-01>,
      <7.071069E-01, -3.166497E-08, -7.071066E-01>,
      <-7.071065E-01, -2.804297E-08, -7.071071E-01>,
      <0.00E+00, 9.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 3, 2>, 0,
      <1, 2, 0>, 0,
      <3, 5, 4>, 0,
      <3, 4, 2>, 0,
      <5, 7, 6>, 0,
      <5, 6, 4>, 0,
      <7, 1, 0>, 0,
      <7, 0, 6>, 0,
      <6, 0, 2>, 0,
      <6, 2, 4>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Sta3
mesh2 {
 
   vertex_vectors { 
      8, 
      <-3.298476E+00, 1.363267E+01, 2.774191E-01>,
      <-3.298476E+00, 1.283267E+01, 2.774191E-01>,
      <-3.228477E+00, 1.363267E+01, 3.474197E-01>,
      <-3.228477E+00, 1.283267E+01, 3.474197E-01>,
      <-3.158477E+00, 1.363267E+01, 2.774191E-01>,
      <-3.158477E+00, 1.283267E+01, 2.774191E-01>,
      <-3.228477E+00, 1.363267E+01, 2.074194E-01>,
      <-3.228477E+00, 1.283267E+01, 2.074194E-01>
   }
 
   normal_vectors { 
      5, 
      <-7.071069E-01, -3.166497E-08, 7.071066E-01>,
      <7.071065E-01, -2.804297E-08, 7.071071E-01>,
      <7.071072E-01, -3.166497E-08, -7.071064E-01>,
      <-7.071068E-01, -3.528696E-08, -7.071068E-01>,
      <0.00E+00, 9.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 3, 2>, 0,
      <1, 2, 0>, 0,
      <3, 5, 4>, 0,
      <3, 4, 2>, 0,
      <5, 7, 6>, 0,
      <5, 6, 4>, 0,
      <7, 1, 0>, 0,
      <7, 0, 6>, 0,
      <6, 0, 2>, 0,
      <6, 2, 4>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Sta4
mesh2 {
 
   vertex_vectors { 
      8, 
      <-3.298475E+00, 1.363267E+01, -3.502581E+00>,
      <-3.298475E+00, 1.283267E+01, -3.502581E+00>,
      <-3.228476E+00, 1.363267E+01, -3.432581E+00>,
      <-3.228476E+00, 1.283267E+01, -3.432581E+00>,
      <-3.158476E+00, 1.363267E+01, -3.502581E+00>,
      <-3.158476E+00, 1.283267E+01, -3.502581E+00>,
      <-3.228476E+00, 1.363267E+01, -3.57258E+00>,
      <-3.228476E+00, 1.283267E+01, -3.57258E+00>
   }
 
   normal_vectors { 
      5, 
      <-7.071067E-01, -3.166497E-08, 7.071069E-01>,
      <7.071062E-01, 4.50555E-08, 7.071074E-01>,
      <7.071067E-01, -3.166497E-08, -7.071069E-01>,
      <-7.071062E-01, -1.083854E-07, -7.071074E-01>,
      <0.00E+00, 9.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 3, 2>, 0,
      <1, 2, 0>, 0,
      <3, 5, 4>, 0,
      <3, 4, 2>, 0,
      <5, 7, 6>, 0,
      <5, 6, 4>, 0,
      <7, 1, 0>, 0,
      <7, 0, 6>, 0,
      <6, 0, 2>, 0,
      <6, 2, 4>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Sta5
mesh2 {
 
   vertex_vectors { 
      8, 
      <-3.298474E+00, 1.363267E+01, -7.282581E+00>,
      <-3.298474E+00, 1.283267E+01, -7.282581E+00>,
      <-3.228474E+00, 1.363267E+01, -7.21258E+00>,
      <-3.228474E+00, 1.283267E+01, -7.21258E+00>,
      <-3.158475E+00, 1.363267E+01, -7.282581E+00>,
      <-3.158475E+00, 1.283267E+01, -7.282581E+00>,
      <-3.228474E+00, 1.363267E+01, -7.352579E+00>,
      <-3.228474E+00, 1.283267E+01, -7.352579E+00>
   }
 
   normal_vectors { 
      5, 
      <-7.071088E-01, -3.166497E-08, 7.071048E-01>,
      <7.071083E-01, -7.940932E-08, 7.071053E-01>,
      <7.071088E-01, -3.166497E-08, -7.071048E-01>,
      <-7.071083E-01, 1.607939E-08, -7.071053E-01>,
      <0.00E+00, 9.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 3, 2>, 0,
      <1, 2, 0>, 0,
      <3, 5, 4>, 0,
      <3, 4, 2>, 0,
      <5, 7, 6>, 0,
      <5, 6, 4>, 0,
      <7, 1, 0>, 0,
      <7, 0, 6>, 0,
      <6, 0, 2>, 0,
      <6, 2, 4>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Handrail
mesh2 {
 
   vertex_vectors { 
      8, 
      <6.072615E+00, 1.355267E+01, 1.156143E+01>,
      <-3.273849E-01, 1.355267E+01, 1.156142E+01>,
      <6.072615E+00, 1.349667E+01, 1.161743E+01>,
      <-3.27383E-01, 1.349667E+01, 1.161742E+01>,
      <6.072617E+00, 1.355267E+01, 1.167343E+01>,
      <-3.27383E-01, 1.355267E+01, 1.167342E+01>,
      <6.072615E+00, 1.360867E+01, 1.161743E+01>,
      <-3.27383E-01, 1.360867E+01, 1.161742E+01>
   }
 
   normal_vectors { 
      6, 
      <1.461109E-07, -7.071069E-01, -7.071067E-01>,
      <-1.461109E-07, -7.071069E-01, 7.071067E-01>,
      <-1.461109E-07, 7.071069E-01, 7.071066E-01>,
      <1.461109E-07, 7.071069E-01, -7.071066E-01>,
      <-1.00E+00, -3.166497E-08, -2.066321E-07>,
      <1.00E+00, -3.166497E-08, 2.066321E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      12, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <1, 3, 5>, 0,
      <1, 5, 7>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Sta1
mesh2 {
 
   vertex_vectors { 
      8, 
      <2.95595E+00, 1.363267E+01, 1.154743E+01>,
      <2.95595E+00, 1.283267E+01, 1.154743E+01>,
      <3.025949E+00, 1.363267E+01, 1.161742E+01>,
      <3.025949E+00, 1.283267E+01, 1.161742E+01>,
      <2.95595E+00, 1.363267E+01, 1.168742E+01>,
      <2.95595E+00, 1.283267E+01, 1.168742E+01>,
      <2.88595E+00, 1.363267E+01, 1.161742E+01>,
      <2.88595E+00, 1.283267E+01, 1.161742E+01>
   }
 
   normal_vectors { 
      5, 
      <7.071069E-01, 3.418949E-08, -7.071066E-01>,
      <7.071067E-01, 2.046981E-08, 7.071068E-01>,
      <-7.071067E-01, -3.166497E-08, 7.071069E-01>,
      <-7.071065E-01, -1.79453E-08, -7.071071E-01>,
      <0.00E+00, 9.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Sta2
mesh2 {
 
   vertex_vectors { 
      8, 
      <-2.107181E-01, 1.363267E+01, 1.154742E+01>,
      <-2.107181E-01, 1.283267E+01, 1.154742E+01>,
      <-1.407185E-01, 1.363267E+01, 1.161742E+01>,
      <-1.407185E-01, 1.283267E+01, 1.161742E+01>,
      <-2.107182E-01, 1.363267E+01, 1.168742E+01>,
      <-2.107182E-01, 1.283267E+01, 1.168742E+01>,
      <-2.807178E-01, 1.363267E+01, 1.161742E+01>,
      <-2.807178E-01, 1.283267E+01, 1.161742E+01>
   }
 
   normal_vectors { 
      5, 
      <7.071067E-01, -3.166497E-08, -7.071069E-01>,
      <7.071065E-01, -1.79453E-08, 7.071071E-01>,
      <-7.071069E-01, 3.418949E-08, 7.071066E-01>,
      <-7.071067E-01, 2.046981E-08, -7.071068E-01>,
      <0.00E+00, 9.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Sta2
mesh2 {
 
   vertex_vectors { 
      8, 
      <-2.210718E+00, 1.363267E+01, 1.154742E+01>,
      <-2.210718E+00, 1.283267E+01, 1.154742E+01>,
      <-2.140718E+00, 1.363267E+01, 1.161742E+01>,
      <-2.140718E+00, 1.283267E+01, 1.161742E+01>,
      <-2.210718E+00, 1.363267E+01, 1.168742E+01>,
      <-2.210718E+00, 1.283267E+01, 1.168742E+01>,
      <-2.280718E+00, 1.363267E+01, 1.161742E+01>,
      <-2.280718E+00, 1.283267E+01, 1.161742E+01>
   }
 
   normal_vectors { 
      5, 
      <7.071067E-01, -3.166497E-08, -7.071069E-01>,
      <7.071065E-01, -1.79453E-08, 7.071071E-01>,
      <-7.071069E-01, 3.418949E-08, 7.071066E-01>,
      <-7.071067E-01, 2.046981E-08, -7.071068E-01>,
      <0.00E+00, 9.999999E-01, 0.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Handrail
mesh2 {
 
   vertex_vectors { 
      8, 
      <-2.077385E+00, 1.355267E+01, 1.156142E+01>,
      <-3.347382E+00, 1.355267E+01, 1.156142E+01>,
      <-2.077385E+00, 1.349667E+01, 1.161742E+01>,
      <-3.347382E+00, 1.349667E+01, 1.161742E+01>,
      <-2.077383E+00, 1.355267E+01, 1.167342E+01>,
      <-3.347382E+00, 1.355267E+01, 1.167342E+01>,
      <-2.077385E+00, 1.360867E+01, 1.161742E+01>,
      <-3.347382E+00, 1.360867E+01, 1.161742E+01>
   }
 
   normal_vectors { 
      6, 
      <1.461109E-07, -7.071069E-01, -7.071067E-01>,
      <-1.461109E-07, -7.071069E-01, 7.071067E-01>,
      <-1.461109E-07, 7.071069E-01, 7.071066E-01>,
      <1.461109E-07, 7.071069E-01, -7.071066E-01>,
      <-1.00E+00, -3.166497E-08, -2.066321E-07>,
      <1.00E+00, -3.166497E-08, 2.066321E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      12, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <1, 3, 5>, 0,
      <1, 5, 7>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
#declare Tex30 =
texture {
   pigment {rgbf <1.00E+00, 1.00E+00, 1.00E+00, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 6.40E-01 brilliance 1.00E+00 specular 6.25E-02 roughness 1.25E-01}
}
 
// Coupler
mesh2 {
 
   vertex_vectors { 
      66, 
      <1.639137E+00, 4.566185E+00, 1.481809E+01>,
      <1.608539E+00, 4.566184E+00, 1.478008E+01>,
      <1.560809E+00, 4.566183E+00, 1.472078E+01>,
      <1.576291E+00, 4.566182E+00, 1.459276E+01>,
      <1.540834E+00, 4.566181E+00, 1.449298E+01>,
      <1.396543E+00, 4.566179E+00, 1.444335E+01>,
      <1.208284E+00, 4.566177E+00, 1.445807E+01>,
      <1.129915E+00, 4.566177E+00, 1.449319E+01>,
      <1.005369E+00, 4.566178E+00, 1.470011E+01>,
      <9.22788E-01, 4.566177E+00, 1.469889E+01>,
      <9.073691E-01, 4.566175E+00, 1.440341E+01>,
      <9.757476E-01, 4.566173E+00, 1.420576E+01>,
      <1.182632E+00, 4.566173E+00, 1.395396E+01>,
      <1.221615E+00, 4.329922E+00, 1.365965E+01>,
      <1.635883E+00, 4.329924E+00, 1.36594E+01>,
      <1.688701E+00, 4.566177E+00, 1.395396E+01>,
      <1.733871E+00, 4.566178E+00, 1.409157E+01>,
      <1.867567E+00, 4.56618E+00, 1.416533E+01>,
      <1.908208E+00, 4.566181E+00, 1.425564E+01>,
      <1.910249E+00, 4.566183E+00, 1.435719E+01>,
      <1.854318E+00, 4.566184E+00, 1.450214E+01>,
      <1.850463E+00, 4.566185E+00, 1.464738E+01>,
      <1.8173E+00, 4.566185E+00, 1.476868E+01>,
      <1.761535E+00, 4.566185E+00, 1.481773E+01>,
      <1.688703E+00, 3.621178E+00, 1.395396E+01>,
      <1.733873E+00, 3.621178E+00, 1.409158E+01>,
      <1.867568E+00, 3.62118E+00, 1.416533E+01>,
      <1.90821E+00, 3.621181E+00, 1.425564E+01>,
      <1.910251E+00, 3.621183E+00, 1.435719E+01>,
      <1.85432E+00, 3.621184E+00, 1.450214E+01>,
      <1.850465E+00, 3.621185E+00, 1.464738E+01>,
      <1.817302E+00, 3.621185E+00, 1.476868E+01>,
      <1.761537E+00, 3.621185E+00, 1.481773E+01>,
      <1.639139E+00, 3.621185E+00, 1.481809E+01>,
      <1.608541E+00, 3.621184E+00, 1.478008E+01>,
      <1.560811E+00, 3.621183E+00, 1.472078E+01>,
      <1.576293E+00, 3.621182E+00, 1.459276E+01>,
      <1.540836E+00, 3.621181E+00, 1.449299E+01>,
      <1.396545E+00, 3.621179E+00, 1.444335E+01>,
      <1.208286E+00, 3.621178E+00, 1.445808E+01>,
      <1.129917E+00, 3.621178E+00, 1.449319E+01>,
      <1.00537E+00, 3.621178E+00, 1.470011E+01>,
      <9.227899E-01, 3.621178E+00, 1.46989E+01>,
      <9.07371E-01, 3.621175E+00, 1.440341E+01>,
      <9.757495E-01, 3.621173E+00, 1.420576E+01>,
      <1.182634E+00, 3.621173E+00, 1.395396E+01>,
      <1.221617E+00, 3.857422E+00, 1.365965E+01>,
      <1.635885E+00, 3.857423E+00, 1.36594E+01>,
      <1.221008E+00, 3.857417E+00, 1.265965E+01>,
      <1.221006E+00, 4.329917E+00, 1.265965E+01>,
      <1.635275E+00, 4.329918E+00, 1.26594E+01>,
      <1.635277E+00, 3.857419E+00, 1.26594E+01>,
      <1.768167E+00, 4.450449E+00, 1.46537E+01>,
      <1.768167E+00, 3.730449E+00, 1.46537E+01>,
      <1.372413E+00, 4.450449E+00, 1.486466E+01>,
      <1.372413E+00, 3.730449E+00, 1.486466E+01>,
      <1.272415E+00, 3.730449E+00, 1.47949E+01>,
      <1.272415E+00, 4.450449E+00, 1.47949E+01>,
      <1.768167E+00, 4.450449E+00, 1.47937E+01>,
      <1.768167E+00, 3.730449E+00, 1.47937E+01>,
      <1.668168E+00, 3.730449E+00, 1.486394E+01>,
      <1.668168E+00, 4.450449E+00, 1.486394E+01>,
      <1.322414E+00, 3.730449E+00, 1.465478E+01>,
      <1.322414E+00, 4.450449E+00, 1.465478E+01>,
      <1.272415E+00, 4.450449E+00, 1.47049E+01>,
      <1.272415E+00, 3.730449E+00, 1.47049E+01>
   }
 
   normal_vectors { 
      38, 
      <-9.77559E-05, 9.433848E-01, -3.317002E-01>,
      <0.00E+00, 9.999999E-01, 0.00E+00>,
      <-8.347719E-05, -9.4339E-01, -3.316859E-01>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <9.695799E-01, 1.746329E-06, -2.44775E-01>,
      <7.700329E-01, 4.274801E-07, -6.380041E-01>,
      <7.35245E-01, 1.9742E-07, -6.778015E-01>,
      <9.755722E-01, 1.469128E-06, -2.19679E-01>,
      <9.848849E-01, 2.283157E-06, 1.732103E-01>,
      <9.805793E-01, 2.306477E-06, 1.961229E-01>,
      <9.892583E-01, 2.304675E-06, 1.46178E-01>,
      <8.482526E-01, 3.031945E-06, 5.295919E-01>,
      <3.543085E-01, 3.042284E-06, 9.351286E-01>,
      <-4.305023E-01, 7.712624E-07, 9.025895E-01>,
      <-7.789819E-01, -7.506147E-07, 6.270464E-01>,
      <-9.614161E-01, -1.538251E-06, 2.750987E-01>,
      <-9.938949E-01, -1.805015E-06, 1.103313E-01>,
      <-7.03518E-01, 3.464813E-07, 7.106775E-01>,
      <-1.262928E-01, 2.564531E-06, 9.91993E-01>,
      <2.470724E-01, 3.058989E-06, 9.68997E-01>,
      <6.632187E-01, 3.181276E-06, 7.484257E-01>,
      <4.856629E-01, 4.334821E-06, 8.741462E-01>,
      <-1.47367E-02, 4.174098E-06, 9.998915E-01>,
      <-9.986413E-01, -1.866802E-06, 5.211089E-02>,
      <-9.901505E-01, -2.251695E-06, -1.400068E-01>,
      <-8.725361E-01, -2.66049E-06, -4.885496E-01>,
      <-9.172262E-01, -2.962846E-06, -3.983668E-01>,
      <-9.97853E-01, -3.550148E-06, -6.549347E-02>,
      <9.960405E-01, 3.080596E-06, -8.890048E-02>,
      <3.258414E-07, -3.166497E-08, -1.00E+00>,
      <-1.00E+00, -3.166497E-08, -3.258414E-07>,
      <1.00E+00, -3.166497E-08, 3.258414E-07>,
      <-2.987115E-01, -3.166497E-08, 9.543434E-01>,
      <-8.866047E-01, -3.166497E-08, 4.62528E-01>,
      <8.873546E-01, -3.166497E-08, 4.610877E-01>,
      <3.025711E-01, -3.166497E-08, 9.531268E-01>,
      <-3.843624E-01, -3.166497E-08, -9.231823E-01>,
      <-9.241117E-01, -3.166497E-08, -3.821225E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex30}
   }
 
   face_indices { 
      122, 
      <15, 14, 13>, 0,
      <15, 13, 12>, 0,
      <15, 12, 11>, 0,
      <15, 11, 10>, 0,
      <10, 9, 8>, 0,
      <10, 8, 7>, 0,
      <10, 7, 6>, 0,
      <10, 6, 5>, 0,
      <3, 2, 0>, 0,
      <3, 0, 23>, 0,
      <3, 23, 22>, 0,
      <3, 22, 21>, 0,
      <3, 21, 20>, 0,
      <3, 20, 19>, 0,
      <3, 19, 18>, 0,
      <3, 18, 17>, 0,
      <3, 17, 16>, 0,
      <3, 16, 15>, 0,
      <15, 10, 5>, 0,
      <15, 5, 4>, 0,
      <4, 3, 15>, 0,
      <45, 24, 25>, 0,
      <45, 25, 26>, 0,
      <45, 26, 27>, 0,
      <45, 27, 28>, 0,
      <45, 28, 29>, 0,
      <45, 29, 30>, 0,
      <45, 30, 31>, 0,
      <31, 32, 33>, 0,
      <31, 33, 35>, 0,
      <31, 35, 36>, 0,
      <31, 36, 37>, 0,
      <40, 41, 42>, 0,
      <40, 42, 43>, 0,
      <40, 43, 44>, 0,
      <40, 44, 45>, 0,
      <45, 31, 37>, 0,
      <45, 37, 38>, 0,
      <45, 38, 39>, 0,
      <39, 40, 45>, 0,
      <46, 47, 24>, 0,
      <46, 24, 45>, 0,
      <24, 15, 16>, 0,
      <24, 16, 25>, 0,
      <25, 16, 17>, 0,
      <25, 17, 26>, 0,
      <26, 17, 18>, 0,
      <26, 18, 27>, 0,
      <27, 18, 19>, 0,
      <27, 19, 28>, 0,
      <28, 19, 20>, 0,
      <28, 20, 29>, 0,
      <29, 20, 21>, 0,
      <29, 21, 30>, 0,
      <30, 21, 22>, 0,
      <30, 22, 31>, 0,
      <31, 22, 23>, 0,
      <31, 23, 32>, 0,
      <32, 23, 0>, 0,
      <32, 0, 33>, 0,
      <33, 0, 1>, 0,
      <33, 1, 34>, 0,
      <34, 1, 2>, 0,
      <34, 2, 35>, 0,
      <35, 2, 3>, 0,
      <35, 3, 36>, 0,
      <36, 3, 4>, 0,
      <36, 4, 37>, 0,
      <37, 4, 5>, 0,
      <37, 5, 38>, 0,
      <38, 5, 6>, 0,
      <38, 6, 39>, 0,
      <39, 6, 7>, 0,
      <39, 7, 40>, 0,
      <40, 7, 8>, 0,
      <40, 8, 41>, 0,
      <41, 8, 9>, 0,
      <41, 9, 42>, 0,
      <42, 9, 10>, 0,
      <42, 10, 43>, 0,
      <43, 10, 11>, 0,
      <43, 11, 44>, 0,
      <44, 11, 12>, 0,
      <44, 12, 45>, 0,
      <45, 12, 13>, 0,
      <45, 13, 46>, 0,
      <47, 14, 15>, 0,
      <47, 15, 24>, 0,
      <48, 49, 50>, 0,
      <48, 50, 51>, 0,
      <48, 46, 13>, 0,
      <48, 13, 49>, 0,
      <49, 13, 14>, 0,
      <49, 14, 50>, 0,
      <50, 14, 47>, 0,
      <50, 47, 51>, 0,
      <51, 47, 46>, 0,
      <51, 46, 48>, 0,
      <55, 54, 57>, 0,
      <55, 57, 56>, 0,
      <53, 52, 58>, 0,
      <53, 58, 59>, 0,
      <60, 61, 54>, 0,
      <60, 54, 55>, 0,
      <59, 58, 61>, 0,
      <59, 61, 60>, 0,
      <62, 63, 52>, 0,
      <62, 52, 53>, 0,
      <56, 57, 64>, 0,
      <56, 64, 65>, 0,
      <63, 62, 65>, 0,
      <63, 65, 64>, 0,
      <55, 56, 65>, 0,
      <55, 65, 62>, 0,
      <55, 62, 53>, 0,
      <55, 53, 59>, 0,
      <55, 59, 60>, 0,
      <61, 58, 52>, 0,
      <61, 52, 63>, 0,
      <61, 63, 64>, 0,
      <61, 64, 57>, 0,
      <61, 57, 54>, 0
   }
 
   normal_indices { 
      122, 
      <0, 0, 0>,
      <0, 0, 0>,
      <0, 0, 1>,
      <0, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 0>,
      <0, 1, 1>,
      <0, 1, 1>,
      <1, 1, 0>,
      <2, 2, 3>,
      <2, 3, 3>,
      <2, 3, 3>,
      <2, 3, 3>,
      <2, 3, 3>,
      <2, 3, 3>,
      <2, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 2>,
      <2, 3, 3>,
      <2, 3, 3>,
      <2, 3, 3>,
      <3, 3, 2>,
      <2, 2, 2>,
      <2, 2, 2>,
      <4, 4, 5>,
      <4, 5, 5>,
      <5, 5, 6>,
      <5, 6, 6>,
      <6, 6, 7>,
      <6, 7, 7>,
      <7, 7, 8>,
      <7, 8, 8>,
      <8, 8, 9>,
      <8, 9, 9>,
      <9, 9, 10>,
      <9, 10, 10>,
      <10, 10, 11>,
      <10, 11, 11>,
      <11, 11, 12>,
      <11, 12, 12>,
      <12, 12, 13>,
      <12, 13, 13>,
      <13, 13, 14>,
      <13, 14, 14>,
      <14, 14, 15>,
      <14, 15, 15>,
      <15, 15, 16>,
      <15, 16, 16>,
      <16, 16, 17>,
      <16, 17, 17>,
      <17, 17, 18>,
      <17, 18, 18>,
      <18, 18, 19>,
      <18, 19, 19>,
      <19, 19, 20>,
      <19, 20, 20>,
      <20, 20, 21>,
      <20, 21, 21>,
      <21, 21, 22>,
      <21, 22, 22>,
      <23, 23, 24>,
      <23, 24, 24>,
      <24, 24, 25>,
      <24, 25, 25>,
      <25, 25, 26>,
      <25, 26, 26>,
      <26, 26, 27>,
      <26, 27, 27>,
      <28, 28, 4>,
      <28, 4, 4>,
      <29, 29, 29>,
      <29, 29, 29>,
      <30, 27, 27>,
      <30, 27, 30>,
      <1, 0, 0>,
      <1, 0, 1>,
      <31, 28, 28>,
      <31, 28, 31>,
      <3, 2, 2>,
      <3, 2, 3>,
      <32, 32, 33>,
      <32, 33, 33>,
      <31, 31, 34>,
      <31, 34, 34>,
      <35, 35, 32>,
      <35, 32, 32>,
      <34, 34, 35>,
      <34, 35, 35>,
      <36, 36, 29>,
      <36, 29, 29>,
      <33, 33, 37>,
      <33, 37, 37>,
      <36, 36, 37>,
      <36, 37, 37>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>
   }
}
 
// Pipe2White
mesh2 {
 
   vertex_vectors { 
      24, 
      <1.968527E-02, 3.71734E+00, 8.410792E+00>,
      <1.196837E-01, 3.61734E+00, 8.410735E+00>,
      <1.968527E-02, 3.51734E+00, 8.410792E+00>,
      <-8.031321E-02, 3.61734E+00, 8.410848E+00>,
      <2.282503E-02, 3.71734E+00, 1.345078E+01>,
      <1.228006E-01, 3.617339E+00, 1.339366E+01>,
      <2.279453E-02, 3.51734E+00, 1.338942E+01>,
      <-7.717344E-02, 3.617341E+00, 1.344653E+01>,
      <3.050057E-01, 3.3894E+00, 1.389753E+01>,
      <3.596322E-01, 3.342091E+00, 1.376863E+01>,
      <2.455651E-01, 3.258438E+00, 1.374212E+01>,
      <1.909386E-01, 3.305748E+00, 1.387101E+01>,
      <1.017362E+00, 2.719807E+00, 1.41988E+01>,
      <1.062582E+00, 2.69424E+00, 1.406592E+01>,
      <9.53321E-01, 2.599491E+00, 1.404143E+01>,
      <9.080864E-01, 2.625058E+00, 1.417431E+01>,
      <1.422361E+00, 2.417942E+00, 1.447647E+01>,
      <1.539533E+00, 2.33875E+00, 1.439293E+01>,
      <1.46034E+00, 2.221581E+00, 1.438906E+01>,
      <1.343168E+00, 2.300773E+00, 1.44726E+01>,
      <1.422361E+00, 2.417942E+00, 1.483276E+01>,
      <1.539533E+00, 2.338751E+00, 1.483277E+01>,
      <1.46034E+00, 2.221581E+00, 1.483277E+01>,
      <1.343168E+00, 2.300772E+00, 1.483276E+01>
   }
 
   normal_vectors { 
      25, 
      <7.070901E-01, 7.071232E-01, -4.413517E-04>,
      <7.142966E-01, 6.993691E-01, 2.575004E-02>,
      <7.071022E-01, -7.071113E-01, -4.419875E-04>,
      <6.636034E-01, -6.477461E-01, -3.742398E-01>,
      <-7.07104E-01, -7.071095E-01, 4.413026E-04>,
      <-7.143082E-01, -6.993577E-01, -2.574243E-02>,
      <-7.071146E-01, 7.070988E-01, 4.406058E-04>,
      <-6.636146E-01, 6.477324E-01, 3.742436E-01>,
      <6.956014E-01, 7.166538E-01, 5.045763E-02>,
      <4.270674E-01, -3.11037E-01, -8.490403E-01>,
      <-6.971409E-01, -7.150828E-01, -5.149204E-02>,
      <-4.267416E-01, 3.105352E-01, 8.493878E-01>,
      <6.253163E-01, 7.790867E-01, 4.475933E-02>,
      <3.592918E-01, -1.795566E-01, -9.157886E-01>,
      <-6.269835E-01, -7.776834E-01, -4.582793E-02>,
      <-3.589117E-01, 1.790432E-01, 9.160382E-01>,
      <5.697114E-01, 8.215958E-01, 2.022433E-02>,
      <4.134381E-01, -2.505482E-01, -8.753825E-01>,
      <-5.697045E-01, -8.216003E-01, -2.024062E-02>,
      <-4.134174E-01, 2.505648E-01, 8.753875E-01>,
      <5.59958E-01, 8.285209E-01, -8.763064E-07>,
      <8.28508E-01, -5.599773E-01, 8.662307E-07>,
      <-5.599592E-01, -8.285202E-01, -1.165516E-06>,
      <-8.285078E-01, 5.599774E-01, 4.653734E-07>,
      <-3.258414E-07, -3.166497E-08, 1.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex30}
   }
 
   face_indices { 
      42, 
      <1, 0, 4>, 0,
      <1, 4, 5>, 0,
      <2, 1, 5>, 0,
      <2, 5, 6>, 0,
      <3, 2, 6>, 0,
      <3, 6, 7>, 0,
      <0, 3, 7>, 0,
      <0, 7, 4>, 0,
      <5, 4, 8>, 0,
      <5, 8, 9>, 0,
      <6, 5, 9>, 0,
      <6, 9, 10>, 0,
      <7, 6, 10>, 0,
      <7, 10, 11>, 0,
      <4, 7, 11>, 0,
      <4, 11, 8>, 0,
      <9, 8, 12>, 0,
      <9, 12, 13>, 0,
      <9, 13, 14>, 0,
      <9, 14, 10>, 0,
      <10, 14, 15>, 0,
      <10, 15, 11>, 0,
      <8, 11, 15>, 0,
      <8, 15, 12>, 0,
      <13, 12, 16>, 0,
      <13, 16, 17>, 0,
      <14, 13, 17>, 0,
      <14, 17, 18>, 0,
      <15, 14, 18>, 0,
      <15, 18, 19>, 0,
      <12, 15, 19>, 0,
      <12, 19, 16>, 0,
      <17, 16, 20>, 0,
      <17, 20, 21>, 0,
      <18, 17, 21>, 0,
      <18, 21, 22>, 0,
      <19, 18, 22>, 0,
      <19, 22, 23>, 0,
      <16, 19, 23>, 0,
      <16, 23, 20>, 0,
      <23, 22, 21>, 0,
      <21, 20, 23>, 0
   }
 
   normal_indices { 
      42, 
      <0, 0, 1>,
      <0, 1, 1>,
      <2, 2, 3>,
      <2, 3, 3>,
      <4, 4, 5>,
      <4, 5, 5>,
      <6, 6, 7>,
      <6, 7, 7>,
      <1, 1, 8>,
      <1, 8, 8>,
      <3, 3, 9>,
      <3, 9, 9>,
      <5, 5, 10>,
      <5, 10, 10>,
      <7, 7, 11>,
      <7, 11, 11>,
      <8, 8, 12>,
      <8, 12, 12>,
      <9, 13, 13>,
      <9, 13, 9>,
      <10, 14, 14>,
      <10, 14, 10>,
      <11, 11, 15>,
      <11, 15, 15>,
      <12, 12, 16>,
      <12, 16, 16>,
      <13, 13, 17>,
      <13, 17, 17>,
      <14, 14, 18>,
      <14, 18, 18>,
      <15, 15, 19>,
      <15, 19, 19>,
      <16, 16, 20>,
      <16, 20, 20>,
      <21, 21, 21>,
      <21, 21, 21>,
      <18, 18, 22>,
      <18, 22, 22>,
      <23, 23, 23>,
      <23, 23, 23>,
      <24, 24, 24>,
      <24, 24, 24>
   }
}
 
// Handrail
mesh2 {
 
   vertex_vectors { 
      8, 
      <6.530642E+00, 5.190989E+00, 1.217239E+01>,
      <6.530642E+00, 1.269099E+01, 1.217239E+01>,
      <6.445809E+00, 5.190989E+00, 1.217426E+01>,
      <6.445809E+00, 1.269099E+01, 1.217426E+01>,
      <6.447676E+00, 5.190989E+00, 1.225909E+01>,
      <6.447676E+00, 1.269099E+01, 1.225909E+01>,
      <6.532509E+00, 5.190989E+00, 1.225722E+01>,
      <6.532509E+00, 1.269099E+01, 1.225722E+01>
   }
 
   normal_vectors { 
      6, 
      <-2.200205E-02, -9.125519E-08, -9.997579E-01>,
      <-9.997579E-01, -3.035353E-08, 2.2002E-02>,
      <2.200205E-02, 2.792525E-08, 9.997579E-01>,
      <9.99758E-01, -3.29764E-08, -2.200188E-02>,
      <1.953221E-14, 9.999999E-01, -5.960465E-08>,
      <-1.953221E-14, -1.00E+00, 5.960465E-08>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      12, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <1, 3, 5>, 0,
      <1, 5, 7>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Sta0
mesh2 {
 
   vertex_vectors { 
      8, 
      <6.587819E+00, 5.24099E+00, 1.219942E+01>,
      <6.298821E+00, 5.240989E+00, 1.192287E+01>,
      <6.532509E+00, 5.16099E+00, 1.225722E+01>,
      <6.243511E+00, 5.160989E+00, 1.198067E+01>,
      <6.477199E+00, 5.24099E+00, 1.231502E+01>,
      <6.188201E+00, 5.24099E+00, 1.203847E+01>,
      <6.532509E+00, 5.32099E+00, 1.225722E+01>,
      <6.243511E+00, 5.32099E+00, 1.198067E+01>
   }
 
   normal_vectors { 
      5, 
      <4.888777E-01, -7.071074E-01, -5.108796E-01>,
      <-4.888776E-01, -7.071074E-01, 5.108796E-01>,
      <-4.888776E-01, 7.071074E-01, 5.108795E-01>,
      <4.888776E-01, 7.071074E-01, -5.108795E-01>,
      <7.224934E-01, 9.544353E-09, 6.913779E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Sta1
mesh2 {
 
   vertex_vectors { 
      8, 
      <6.587819E+00, 1.264099E+01, 1.219942E+01>,
      <6.298821E+00, 1.264099E+01, 1.192287E+01>,
      <6.532509E+00, 1.256099E+01, 1.225722E+01>,
      <6.243511E+00, 1.256099E+01, 1.198067E+01>,
      <6.477199E+00, 1.264099E+01, 1.231502E+01>,
      <6.188201E+00, 1.264099E+01, 1.203847E+01>,
      <6.532509E+00, 1.272099E+01, 1.225722E+01>,
      <6.243511E+00, 1.272099E+01, 1.198067E+01>
   }
 
   normal_vectors { 
      5, 
      <4.888777E-01, -7.071074E-01, -5.108796E-01>,
      <-4.888776E-01, -7.071074E-01, 5.108796E-01>,
      <-4.888776E-01, 7.071074E-01, 5.108795E-01>,
      <4.888776E-01, 7.071074E-01, -5.108795E-01>,
      <7.224934E-01, 9.544353E-09, 6.913779E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Handrail
mesh2 {
 
   vertex_vectors { 
      8, 
      <-3.710654E+00, 5.19099E+00, 1.225908E+01>,
      <-3.710656E+00, 1.269099E+01, 1.225908E+01>,
      <-3.708787E+00, 5.19099E+00, 1.217425E+01>,
      <-3.708788E+00, 1.269099E+01, 1.217425E+01>,
      <-3.793619E+00, 5.19099E+00, 1.217238E+01>,
      <-3.793621E+00, 1.269099E+01, 1.217238E+01>,
      <-3.795486E+00, 5.19099E+00, 1.225721E+01>,
      <-3.795488E+00, 1.269099E+01, 1.225721E+01>
   }
 
   normal_vectors { 
      6, 
      <9.997578E-01, 1.425148E-07, 2.200634E-02>,
      <2.200639E-02, 1.808358E-07, -9.997579E-01>,
      <-9.997578E-01, -2.058448E-07, -2.200634E-02>,
      <-2.200651E-02, -2.441657E-07, 9.997578E-01>,
      <-1.78814E-07, 9.999999E-01, 2.086162E-07>,
      <1.78814E-07, -1.00E+00, -2.086162E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      12, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <1, 3, 5>, 0,
      <1, 5, 7>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Sta0
mesh2 {
 
   vertex_vectors { 
      8, 
      <-3.740177E+00, 5.24099E+00, 1.231501E+01>,
      <-3.451178E+00, 5.24099E+00, 1.203846E+01>,
      <-3.795486E+00, 5.16099E+00, 1.225721E+01>,
      <-3.506488E+00, 5.16099E+00, 1.198066E+01>,
      <-3.850797E+00, 5.24099E+00, 1.219941E+01>,
      <-3.561798E+00, 5.240991E+00, 1.192286E+01>,
      <-3.795486E+00, 5.32099E+00, 1.225721E+01>,
      <-3.506488E+00, 5.320991E+00, 1.198066E+01>
   }
 
   normal_vectors { 
      5, 
      <4.888754E-01, -7.071074E-01, 5.108816E-01>,
      <-4.888752E-01, -7.071074E-01, -5.108819E-01>,
      <-4.888754E-01, 7.071074E-01, -5.108815E-01>,
      <4.888752E-01, 7.071074E-01, 5.108818E-01>,
      <-7.224964E-01, -3.050894E-07, 6.913747E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Sta1
mesh2 {
 
   vertex_vectors { 
      8, 
      <-3.740178E+00, 1.264099E+01, 1.231501E+01>,
      <-3.45118E+00, 1.264099E+01, 1.203846E+01>,
      <-3.795488E+00, 1.256099E+01, 1.225721E+01>,
      <-3.506489E+00, 1.256099E+01, 1.198066E+01>,
      <-3.850798E+00, 1.264099E+01, 1.219942E+01>,
      <-3.5618E+00, 1.264099E+01, 1.192286E+01>,
      <-3.795488E+00, 1.272099E+01, 1.225721E+01>,
      <-3.506489E+00, 1.272099E+01, 1.198066E+01>
   }
 
   normal_vectors { 
      5, 
      <4.888754E-01, -7.071074E-01, 5.108816E-01>,
      <-4.888752E-01, -7.071074E-01, -5.108819E-01>,
      <-4.888754E-01, 7.071074E-01, -5.108815E-01>,
      <4.888752E-01, 7.071074E-01, 5.108818E-01>,
      <-7.224964E-01, -3.050894E-07, 6.913747E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Handrail
mesh2 {
 
   vertex_vectors { 
      8, 
      <-3.818614E+00, 5.190989E+00, -2.768593E+01>,
      <-3.81861E+00, 1.269099E+01, -2.768592E+01>,
      <-3.733781E+00, 5.190989E+00, -2.76878E+01>,
      <-3.733778E+00, 1.269099E+01, -2.76878E+01>,
      <-3.735651E+00, 5.190989E+00, -2.777263E+01>,
      <-3.735647E+00, 1.269099E+01, -2.777263E+01>,
      <-3.820483E+00, 5.19099E+00, -2.777076E+01>,
      <-3.820479E+00, 1.269099E+01, -2.777076E+01>
   }
 
   normal_vectors { 
      6, 
      <2.203307E-02, -4.00369E-07, 9.997572E-01>,
      <9.997573E-01, -5.303017E-07, -2.203303E-02>,
      <-2.203307E-02, 3.37039E-07, -9.997572E-01>,
      <-9.997572E-01, 4.669718E-07, 2.20329E-02>,
      <5.066394E-07, 9.999999E-01, 3.576281E-07>,
      <-5.066394E-07, -1.00E+00, -3.576281E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      12, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <1, 3, 5>, 0,
      <1, 5, 7>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Sta0
mesh2 {
 
   vertex_vectors { 
      8, 
      <-3.875792E+00, 5.24099E+00, -2.771296E+01>,
      <-3.586785E+00, 5.24099E+00, -2.743642E+01>,
      <-3.820483E+00, 5.16099E+00, -2.777076E+01>,
      <-3.531477E+00, 5.16099E+00, -2.749422E+01>,
      <-3.765174E+00, 5.24099E+00, -2.782856E+01>,
      <-3.476169E+00, 5.240989E+00, -2.755202E+01>,
      <-3.820483E+00, 5.32099E+00, -2.777076E+01>,
      <-3.531477E+00, 5.320989E+00, -2.749422E+01>
   }
 
   normal_vectors { 
      5, 
      <-4.888622E-01, -7.071073E-01, 5.108945E-01>,
      <4.888614E-01, -7.071075E-01, -5.10895E-01>,
      <4.888621E-01, 7.071073E-01, -5.108945E-01>,
      <-4.888614E-01, 7.071075E-01, 5.108949E-01>,
      <-7.225148E-01, 5.816376E-07, -6.913555E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Sta1
mesh2 {
 
   vertex_vectors { 
      8, 
      <-3.875788E+00, 1.264099E+01, -2.771296E+01>,
      <-3.586782E+00, 1.264099E+01, -2.743641E+01>,
      <-3.820479E+00, 1.256099E+01, -2.777076E+01>,
      <-3.531473E+00, 1.256099E+01, -2.749422E+01>,
      <-3.765171E+00, 1.264099E+01, -2.782856E+01>,
      <-3.476165E+00, 1.264099E+01, -2.755202E+01>,
      <-3.820479E+00, 1.272099E+01, -2.777076E+01>,
      <-3.531473E+00, 1.272099E+01, -2.749422E+01>
   }
 
   normal_vectors { 
      5, 
      <-4.888622E-01, -7.071073E-01, 5.108945E-01>,
      <4.888614E-01, -7.071075E-01, -5.10895E-01>,
      <4.888621E-01, 7.071073E-01, -5.108945E-01>,
      <-4.888614E-01, 7.071075E-01, 5.108949E-01>,
      <-7.225148E-01, 5.816376E-07, -6.913555E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Handrail
mesh2 {
 
   vertex_vectors { 
      8, 
      <6.472693E+00, 5.190989E+00, -2.777263E+01>,
      <6.472692E+00, 1.269099E+01, -2.777263E+01>,
      <6.470825E+00, 5.190989E+00, -2.76878E+01>,
      <6.470824E+00, 1.269099E+01, -2.76878E+01>,
      <6.555658E+00, 5.190989E+00, -2.768593E+01>,
      <6.555656E+00, 1.269099E+01, -2.768593E+01>,
      <6.557526E+00, 5.190989E+00, -2.777076E+01>,
      <6.557525E+00, 1.269099E+01, -2.777076E+01>
   }
 
   normal_vectors { 
      6, 
      <-9.997578E-01, -1.727673E-07, -2.20152E-02>,
      <-2.201524E-02, -3.924867E-07, 9.997578E-01>,
      <9.997578E-01, 1.094374E-07, 2.20152E-02>,
      <2.201536E-02, 3.291567E-07, -9.997578E-01>,
      <-1.490117E-07, 9.999999E-01, 3.576278E-07>,
      <1.490117E-07, -1.00E+00, -3.576278E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      12, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <1, 3, 5>, 0,
      <1, 5, 7>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Sta0
mesh2 {
 
   vertex_vectors { 
      8, 
      <6.502216E+00, 5.24099E+00, -2.782856E+01>,
      <6.213215E+00, 5.24099E+00, -2.755202E+01>,
      <6.557526E+00, 5.16099E+00, -2.777076E+01>,
      <6.268525E+00, 5.16099E+00, -2.749422E+01>,
      <6.612835E+00, 5.24099E+00, -2.771296E+01>,
      <6.323834E+00, 5.240989E+00, -2.743641E+01>,
      <6.557526E+00, 5.32099E+00, -2.777076E+01>,
      <6.268525E+00, 5.320989E+00, -2.749422E+01>
   }
 
   normal_vectors { 
      5, 
      <-4.888707E-01, -7.071073E-01, -5.108864E-01>,
      <4.88871E-01, -7.071075E-01, 5.108859E-01>,
      <4.888707E-01, 7.071073E-01, 5.108864E-01>,
      <-4.888709E-01, 7.071075E-01, -5.108858E-01>,
      <7.225026E-01, 3.232489E-07, -6.913683E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Sta1
mesh2 {
 
   vertex_vectors { 
      8, 
      <6.502215E+00, 1.264099E+01, -2.782856E+01>,
      <6.213214E+00, 1.264099E+01, -2.755201E+01>,
      <6.557525E+00, 1.256099E+01, -2.777076E+01>,
      <6.268524E+00, 1.256099E+01, -2.749421E+01>,
      <6.612834E+00, 1.264099E+01, -2.771296E+01>,
      <6.323833E+00, 1.264099E+01, -2.743641E+01>,
      <6.557525E+00, 1.272099E+01, -2.777076E+01>,
      <6.268524E+00, 1.272099E+01, -2.749421E+01>
   }
 
   normal_vectors { 
      5, 
      <-4.888707E-01, -7.071073E-01, -5.108864E-01>,
      <4.88871E-01, -7.071075E-01, 5.108859E-01>,
      <4.888707E-01, 7.071073E-01, 5.108864E-01>,
      <-4.888709E-01, 7.071075E-01, -5.108858E-01>,
      <7.225026E-01, 3.232489E-07, -6.913683E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Handrail
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.567738E+00, 9.536508E+00, 1.245129E+01>,
      <1.567737E+00, 9.536508E+00, 1.245129E+01>,
      <5.567738E+00, 9.476508E+00, 1.23913E+01>,
      <1.567737E+00, 9.476508E+00, 1.239129E+01>,
      <5.567738E+00, 9.416508E+00, 1.245129E+01>,
      <1.567737E+00, 9.416508E+00, 1.245129E+01>,
      <5.567738E+00, 9.476508E+00, 1.25113E+01>,
      <1.567737E+00, 9.476508E+00, 1.251129E+01>
   }
 
   normal_vectors { 
      6, 
      <5.465057E-07, 7.071071E-01, -7.071064E-01>,
      <5.886531E-07, -7.071065E-01, -7.071071E-01>,
      <-5.465057E-07, -7.071072E-01, 7.071064E-01>,
      <-5.886531E-07, 7.071065E-01, 7.071071E-01>,
      <-1.00E+00, -6.146729E-08, -8.026785E-07>,
      <1.00E+00, -1.862645E-09, 8.026785E-07>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      12, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <1, 3, 5>, 0,
      <1, 5, 7>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      12, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>
   }
}
 
// Sta0
mesh2 {
 
   vertex_vectors { 
      8, 
      <5.517737E+00, 9.556508E+00, 1.25113E+01>,
      <5.517737E+00, 9.556508E+00, 1.21113E+01>,
      <5.597737E+00, 9.476508E+00, 1.25113E+01>,
      <5.597737E+00, 9.476508E+00, 1.21113E+01>,
      <5.517737E+00, 9.396508E+00, 1.25113E+01>,
      <5.517738E+00, 9.396508E+00, 1.211129E+01>,
      <5.437737E+00, 9.476508E+00, 1.25113E+01>,
      <5.437737E+00, 9.476508E+00, 1.211129E+01>
   }
 
   normal_vectors { 
      5, 
      <7.071074E-01, 7.071062E-01, 9.047545E-07>,
      <7.071074E-01, -7.071062E-01, 2.304053E-07>,
      <-7.071071E-01, -7.071065E-01, -9.047544E-07>,
      <-7.071071E-01, 7.071064E-01, -2.30405E-07>,
      <-8.026785E-07, -5.085022E-07, 1.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
// Sta1
mesh2 {
 
   vertex_vectors { 
      8, 
      <1.617737E+00, 9.556508E+00, 1.251129E+01>,
      <1.617738E+00, 9.556508E+00, 1.211129E+01>,
      <1.697737E+00, 9.476508E+00, 1.251129E+01>,
      <1.697738E+00, 9.476508E+00, 1.211129E+01>,
      <1.617737E+00, 9.396508E+00, 1.251129E+01>,
      <1.617738E+00, 9.396508E+00, 1.211129E+01>,
      <1.537737E+00, 9.476508E+00, 1.251129E+01>,
      <1.537738E+00, 9.476508E+00, 1.211129E+01>
   }
 
   normal_vectors { 
      5, 
      <7.071067E-01, 7.071069E-01, 9.047543E-07>,
      <7.071067E-01, -7.071069E-01, 2.304045E-07>,
      <-7.071074E-01, -7.071062E-01, -9.047545E-07>,
      <-7.071074E-01, 7.071061E-01, -2.304054E-07>,
      <-8.026785E-07, -5.085022E-07, 1.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex17}
   }
 
   face_indices { 
      10, 
      <1, 0, 2>, 0,
      <1, 2, 3>, 0,
      <3, 2, 4>, 0,
      <3, 4, 5>, 0,
      <5, 4, 6>, 0,
      <5, 6, 7>, 0,
      <7, 6, 0>, 0,
      <7, 0, 1>, 0,
      <6, 4, 2>, 0,
      <6, 2, 0>, 0
   }
 
   normal_indices { 
      10, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
#declare Tex31 =
texture {
   pigment {rgbf <7.921569E-01, 9.764706E-01, 8.156863E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// CowCatcher
mesh2 {
 
   vertex_vectors { 
      107, 
      <5.083345E+00, 2.293326E+00, -8.635233E+01>,
      <5.083345E+00, 2.393328E+00, -8.635233E+01>,
      <3.883348E+00, 2.393328E+00, -8.635233E+01>,
      <3.883348E+00, 2.293326E+00, -8.635233E+01>,
      <5.083345E+00, 2.293326E+00, -8.625233E+01>,
      <5.083345E+00, 2.393328E+00, -8.625233E+01>,
      <3.883348E+00, 2.393328E+00, -8.625233E+01>,
      <3.883348E+00, 2.293326E+00, -8.625233E+01>,
      <5.083345E+00, 2.693328E+00, -8.625233E+01>,
      <5.083345E+00, 2.693328E+00, -8.635233E+01>,
      <3.883348E+00, 2.693328E+00, -8.635233E+01>,
      <3.883348E+00, 2.693328E+00, -8.625233E+01>,
      <5.083345E+00, 2.293326E+00, -8.715234E+01>,
      <5.083345E+00, 2.393328E+00, -8.715234E+01>,
      <4.883344E+00, 2.393328E+00, -8.735233E+01>,
      <4.883344E+00, 2.293326E+00, -8.735233E+01>,
      <4.083349E+00, 2.293326E+00, -8.735233E+01>,
      <4.083349E+00, 2.393328E+00, -8.735233E+01>,
      <3.883348E+00, 2.393328E+00, -8.715234E+01>,
      <3.883348E+00, 2.293326E+00, -8.715234E+01>,
      <4.509809E+00, 4.434647E+00, -8.546736E+01>,
      <3.509812E+00, 4.434645E+00, -8.546736E+01>,
      <3.509874E+00, 1.634642E+00, -8.627182E+01>,
      <3.509881E+00, 4.43464E+00, -8.627222E+01>,
      <4.509881E+00, 4.434641E+00, -8.627221E+01>,
      <4.509912E+00, 1.634647E+00, -8.627182E+01>,
      <4.509824E+00, 2.124647E+00, -8.546736E+01>,
      <3.509824E+00, 2.124649E+00, -8.546736E+01>,
      <3.509805E+00, 1.634641E+00, -8.595736E+01>,
      <4.509824E+00, 1.634644E+00, -8.595736E+01>,
      <-7.937726E-01, 4.434639E+00, -8.546737E+01>,
      <-1.793773E+00, 4.434644E+00, -8.546736E+01>,
      <-1.793772E+00, 1.634647E+00, -8.627203E+01>,
      <-1.793772E+00, 4.434636E+00, -8.627203E+01>,
      <-7.937762E-01, 4.434641E+00, -8.627203E+01>,
      <-7.937723E-01, 1.634642E+00, -8.627203E+01>,
      <-7.937765E-01, 2.124642E+00, -8.546737E+01>,
      <-1.793776E+00, 2.124651E+00, -8.546737E+01>,
      <-1.793772E+00, 1.634644E+00, -8.595737E+01>,
      <-7.937725E-01, 1.634643E+00, -8.595736E+01>,
      <1.370981E+00, 4.434643E+00, -8.627222E+01>,
      <6.707746E+00, 5.234653E+00, -8.508249E+01>,
      <-3.892249E+00, 5.234648E+00, -8.508249E+01>,
      <-3.892245E+00, 4.434636E+00, -8.508249E+01>,
      <6.707749E+00, 4.434646E+00, -8.508249E+01>,
      <6.707754E+00, 4.434652E+00, -8.607182E+01>,
      <6.707754E+00, 5.234648E+00, -8.607182E+01>,
      <6.507761E+00, 5.234652E+00, -8.627222E+01>,
      <6.507749E+00, 4.43464E+00, -8.627222E+01>,
      <-3.892245E+00, 5.23465E+00, -8.607183E+01>,
      <-3.892245E+00, 4.434652E+00, -8.607183E+01>,
      <-3.692248E+00, 4.434648E+00, -8.627223E+01>,
      <-3.692256E+00, 5.234646E+00, -8.627223E+01>,
      <1.370981E+00, 5.234652E+00, -8.627223E+01>,
      <-7.937342E-01, 2.575405E+00, -8.627183E+01>,
      <3.509877E+00, 2.578695E+00, -8.627182E+01>,
      <1.033269E+00, 4.437582E+00, -8.627223E+01>,
      <1.03327E+00, 1.634647E+00, -8.826164E+01>,
      <1.684824E+00, 1.634647E+00, -8.826163E+01>,
      <1.684831E+00, 4.437582E+00, -8.627222E+01>,
      <-1.089583E+00, 2.293326E+00, -8.635234E+01>,
      <-1.089583E+00, 2.393328E+00, -8.635234E+01>,
      <-2.28958E+00, 2.393328E+00, -8.635234E+01>,
      <-2.28958E+00, 2.293326E+00, -8.635234E+01>,
      <-1.089583E+00, 2.293326E+00, -8.625234E+01>,
      <-1.089583E+00, 2.393328E+00, -8.625234E+01>,
      <-2.28958E+00, 2.393328E+00, -8.625234E+01>,
      <-2.28958E+00, 2.293326E+00, -8.625234E+01>,
      <-1.089583E+00, 2.693328E+00, -8.625234E+01>,
      <-1.089583E+00, 2.693328E+00, -8.635234E+01>,
      <-2.28958E+00, 2.693328E+00, -8.635234E+01>,
      <-2.28958E+00, 2.693328E+00, -8.625234E+01>,
      <-2.083815E+00, 2.293326E+00, -8.735464E+01>,
      <-2.083815E+00, 2.393328E+00, -8.735464E+01>,
      <-2.284968E+00, 2.393328E+00, -8.715511E+01>,
      <-2.284968E+00, 2.293326E+00, -8.715511E+01>,
      <-1.289583E+00, 2.393328E+00, -8.735281E+01>,
      <-1.289583E+00, 2.293326E+00, -8.735281E+01>,
      <-1.089583E+00, 2.293326E+00, -8.715234E+01>,
      <-1.089583E+00, 2.393328E+00, -8.715234E+01>,
      <-3.892246E+00, 5.084636E+00, -8.398249E+01>,
      <6.707749E+00, 5.084646E+00, -8.398248E+01>,
      <6.707745E+00, 5.234653E+00, -8.398248E+01>,
      <-3.89225E+00, 5.234648E+00, -8.398249E+01>,
      <1.68482E+00, 1.634647E+00, -8.816798E+01>,
      <1.684827E+00, 4.402522E+00, -8.617857E+01>,
      <1.370977E+00, 4.399582E+00, -8.617857E+01>,
      <1.033265E+00, 4.402522E+00, -8.617858E+01>,
      <1.033266E+00, 1.634647E+00, -8.816799E+01>,
      <-7.9378E-01, 4.39958E+00, -8.617838E+01>,
      <-7.937381E-01, 2.540345E+00, -8.617818E+01>,
      <3.509874E+00, 2.543635E+00, -8.617817E+01>,
      <3.509877E+00, 4.39958E+00, -8.617857E+01>,
      <-1.793776E+00, 1.634647E+00, -8.617838E+01>,
      <4.509908E+00, 1.634647E+00, -8.617817E+01>,
      <-3.892246E+00, 5.084636E+00, -8.158249E+01>,
      <6.707748E+00, 5.084646E+00, -8.158249E+01>,
      <6.707744E+00, 5.234653E+00, -8.158249E+01>,
      <-3.89225E+00, 5.234648E+00, -8.158249E+01>,
      <-3.742246E+00, 5.084637E+00, -8.158249E+01>,
      <-3.74225E+00, 5.234648E+00, -8.158249E+01>,
      <-3.89225E+00, 5.234648E+00, -8.173249E+01>,
      <-3.892246E+00, 5.084636E+00, -8.173249E+01>,
      <6.707748E+00, 5.084646E+00, -8.173248E+01>,
      <6.707745E+00, 5.234653E+00, -8.173248E+01>,
      <6.557748E+00, 5.084646E+00, -8.158249E+01>,
      <6.557744E+00, 5.234653E+00, -8.158249E+01>
   }
 
   normal_vectors { 
      61, 
      <-3.258414E-07, 0.00E+00, 1.00E+00>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <9.238793E-01, 0.00E+00, -3.82684E-01>,
      <3.826829E-01, 0.00E+00, -9.238797E-01>,
      <-3.826824E-01, 0.00E+00, -9.238799E-01>,
      <-9.238791E-01, 0.00E+00, -3.826844E-01>,
      <-7.463636E-04, 9.840032E-01, 1.781493E-01>,
      <7.66233E-04, 9.840031E-01, 1.781499E-01>,
      <-1.784996E-01, 3.875213E-01, -9.044142E-01>,
      <-5.152257E-01, 5.215922E-01, -6.800618E-01>,
      <-3.713171E-01, 5.559343E-01, -7.436805E-01>,
      <-2.575726E-01, 5.593669E-01, -7.878864E-01>,
      <-2.693264E-01, 2.716669E-01, -9.239374E-01>,
      <-3.831554E-01, -1.533108E-06, -9.236839E-01>,
      <3.168151E-07, 2.014408E-01, -9.795007E-01>,
      <-9.240744E-01, -2.996089E-06, -3.822127E-01>,
      <1.785781E-01, 3.874699E-01, -9.044208E-01>,
      <5.154898E-01, 5.213945E-01, -6.800133E-01>,
      <2.577383E-01, 5.593411E-01, -7.878506E-01>,
      <3.714767E-01, 5.558272E-01, -7.436809E-01>,
      <2.69522E-01, 2.715521E-01, -9.239141E-01>,
      <3.831474E-01, -3.581275E-06, -9.236872E-01>,
      <9.240726E-01, -1.274548E-06, -3.82217E-01>,
      <-9.207813E-01, 3.834231E-01, 7.175409E-02>,
      <-1.22283E-06, -3.826801E-01, 9.238809E-01>,
      <-9.192887E-01, -3.6858E-01, -1.380474E-01>,
      <9.208453E-01, 3.832581E-01, 7.181329E-02>,
      <9.193652E-01, -3.684434E-01, -1.379023E-01>,
      <2.222643E-06, -9.238793E-01, 3.826839E-01>,
      <4.92525E-07, -9.646056E-01, 2.636967E-01>,
      <-9.219948E-01, 0.00E+00, -3.872022E-01>,
      <-3.797422E-01, 0.00E+00, -9.250923E-01>,
      <3.842883E-01, 0.00E+00, -9.232131E-01>,
      <-2.568519E-01, -5.641609E-01, 7.846971E-01>,
      <-1.781174E-01, -3.911473E-01, 9.029275E-01>,
      <-2.645403E-07, -5.838407E-01, 8.118683E-01>,
      <1.780399E-01, -3.911985E-01, 9.029205E-01>,
      <2.566863E-01, -5.641869E-01, 7.847326E-01>,
      <4.961722E-01, -5.067267E-01, 7.050114E-01>,
      <-4.964693E-01, -5.066271E-01, 7.04874E-01>,
      <2.462774E-01, 9.222421E-01, 2.980219E-01>,
      <-3.091339E-04, 9.365228E-01, 3.506065E-01>,
      <-2.463676E-01, 9.222307E-01, 2.979824E-01>,
      <6.904579E-01, -6.774657E-01, -2.535904E-01>,
      <-1.468996E-03, 9.365232E-01, 3.506026E-01>,
      <1.509579E-03, 9.365218E-01, 3.506061E-01>,
      <-6.901978E-01, -6.776773E-01, -2.537334E-01>,
      <-3.5917E-01, 9.324919E-01, 3.815367E-02>,
      <-8.537023E-01, 4.701973E-01, -2.238456E-01>,
      <-6.956762E-01, 7.06097E-01, 1.321424E-01>,
      <6.959248E-01, 7.058496E-01, 1.32155E-01>,
      <8.538334E-01, 4.70017E-01, -2.23724E-01>,
      <3.591968E-01, 9.324796E-01, 3.820484E-02>,
      <-9.238793E-01, -2.399837E-05, 3.826841E-01>,
      <-3.826828E-01, -1.02361E-05, 9.238798E-01>,
      <9.238786E-01, 2.258411E-05, 3.826856E-01>,
      <3.826813E-01, 8.82144E-06, 9.238804E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex31}
   }
 
   face_indices { 
      190, 
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <4, 0, 1>, 0,
      <4, 1, 5>, 0,
      <6, 2, 3>, 0,
      <6, 3, 7>, 0,
      <7, 3, 0>, 0,
      <7, 0, 4>, 0,
      <8, 9, 10>, 0,
      <8, 10, 11>, 0,
      <8, 5, 1>, 0,
      <8, 1, 9>, 0,
      <9, 1, 2>, 0,
      <9, 2, 10>, 0,
      <10, 2, 6>, 0,
      <10, 6, 11>, 0,
      <11, 6, 5>, 0,
      <11, 5, 8>, 0,
      <12, 13, 1>, 0,
      <12, 1, 0>, 0,
      <13, 12, 15>, 0,
      <13, 15, 14>, 0,
      <16, 17, 14>, 0,
      <16, 14, 15>, 0,
      <3, 2, 18>, 0,
      <3, 18, 19>, 0,
      <17, 16, 19>, 0,
      <17, 19, 18>, 0,
      <3, 19, 16>, 0,
      <3, 16, 15>, 0,
      <3, 15, 12>, 0,
      <3, 12, 0>, 0,
      <1, 13, 14>, 0,
      <1, 14, 17>, 0,
      <1, 17, 18>, 0,
      <1, 18, 2>, 0,
      <42, 41, 46>, 0,
      <42, 46, 47>, 0,
      <42, 47, 52>, 0,
      <52, 49, 42>, 0,
      <30, 34, 33>, 0,
      <30, 33, 31>, 0,
      <20, 24, 23>, 0,
      <20, 23, 21>, 0,
      <56, 54, 34>, 0,
      <32, 56, 57>, 0,
      <32, 33, 34>, 0,
      <34, 35, 32>, 0,
      <51, 52, 53>, 0,
      <51, 53, 40>, 0,
      <50, 49, 52>, 0,
      <50, 52, 51>, 0,
      <59, 23, 55>, 0,
      <25, 58, 59>, 0,
      <22, 23, 24>, 0,
      <24, 25, 22>, 0,
      <47, 48, 40>, 0,
      <47, 40, 53>, 0,
      <46, 45, 48>, 0,
      <46, 48, 47>, 0,
      <38, 37, 31>, 0,
      <38, 31, 33>, 0,
      <38, 33, 32>, 0,
      <36, 30, 31>, 0,
      <36, 31, 37>, 0,
      <22, 28, 27>, 0,
      <22, 27, 21>, 0,
      <21, 23, 22>, 0,
      <26, 20, 21>, 0,
      <26, 21, 27>, 0,
      <29, 25, 24>, 0,
      <29, 24, 20>, 0,
      <20, 26, 29>, 0,
      <39, 35, 34>, 0,
      <39, 34, 30>, 0,
      <30, 36, 39>, 0,
      <28, 22, 25>, 0,
      <28, 25, 29>, 0,
      <38, 32, 35>, 0,
      <38, 35, 39>, 0,
      <44, 43, 50>, 0,
      <44, 50, 51>, 0,
      <44, 51, 48>, 0,
      <48, 45, 44>, 0,
      <26, 27, 28>, 0,
      <26, 28, 29>, 0,
      <36, 37, 38>, 0,
      <36, 38, 39>, 0,
      <64, 65, 66>, 0,
      <64, 66, 67>, 0,
      <64, 60, 61>, 0,
      <64, 61, 65>, 0,
      <66, 62, 63>, 0,
      <66, 63, 67>, 0,
      <67, 63, 60>, 0,
      <67, 60, 64>, 0,
      <68, 69, 70>, 0,
      <68, 70, 71>, 0,
      <68, 65, 61>, 0,
      <68, 61, 69>, 0,
      <69, 61, 62>, 0,
      <69, 62, 70>, 0,
      <70, 62, 66>, 0,
      <70, 66, 71>, 0,
      <71, 66, 65>, 0,
      <71, 65, 68>, 0,
      <63, 62, 74>, 0,
      <63, 74, 75>, 0,
      <73, 72, 75>, 0,
      <73, 75, 74>, 0,
      <72, 73, 76>, 0,
      <72, 76, 77>, 0,
      <78, 79, 61>, 0,
      <78, 61, 60>, 0,
      <77, 76, 79>, 0,
      <77, 79, 78>, 0,
      <63, 75, 72>, 0,
      <63, 72, 77>, 0,
      <63, 77, 78>, 0,
      <63, 78, 60>, 0,
      <61, 79, 76>, 0,
      <61, 76, 73>, 0,
      <61, 73, 74>, 0,
      <61, 74, 62>, 0,
      <42, 49, 50>, 0,
      <42, 50, 43>, 0,
      <44, 45, 46>, 0,
      <44, 46, 41>, 0,
      <80, 43, 44>, 0,
      <80, 44, 81>, 0,
      <81, 44, 41>, 0,
      <81, 41, 82>, 0,
      <82, 41, 42>, 0,
      <82, 42, 83>, 0,
      <83, 42, 43>, 0,
      <83, 43, 80>, 0,
      <58, 57, 56>, 0,
      <58, 56, 40>, 0,
      <40, 59, 58>, 0,
      <88, 84, 85>, 0,
      <88, 85, 86>, 0,
      <86, 87, 88>, 0,
      <89, 90, 87>, 0,
      <91, 92, 85>, 0,
      <88, 87, 93>, 0,
      <85, 84, 94>, 0,
      <85, 59, 40>, 0,
      <85, 40, 86>, 0,
      <86, 40, 56>, 0,
      <86, 56, 87>, 0,
      <88, 57, 58>, 0,
      <88, 58, 84>, 0,
      <89, 34, 54>, 0,
      <89, 54, 90>, 0,
      <90, 54, 56>, 0,
      <90, 56, 87>, 0,
      <87, 56, 34>, 0,
      <87, 34, 89>, 0,
      <91, 55, 23>, 0,
      <91, 23, 92>, 0,
      <92, 23, 59>, 0,
      <92, 59, 85>, 0,
      <85, 59, 55>, 0,
      <85, 55, 91>, 0,
      <32, 93, 87>, 0,
      <32, 87, 56>, 0,
      <93, 32, 57>, 0,
      <93, 57, 88>, 0,
      <84, 58, 25>, 0,
      <84, 25, 94>, 0,
      <94, 25, 59>, 0,
      <94, 59, 85>, 0,
      <101, 83, 80>, 0,
      <101, 80, 102>, 0,
      <99, 100, 101>, 0,
      <99, 101, 102>, 0,
      <103, 81, 82>, 0,
      <103, 82, 104>, 0,
      <99, 105, 106>, 0,
      <99, 106, 100>, 0,
      <103, 104, 106>, 0,
      <103, 106, 105>, 0,
      <99, 102, 80>, 0,
      <99, 80, 81>, 0,
      <99, 81, 103>, 0,
      <99, 103, 105>, 0,
      <106, 104, 82>, 0,
      <106, 82, 83>, 0,
      <106, 83, 101>, 0,
      <106, 101, 100>, 0
   }
 
   normal_indices { 
      190, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <1, 1, 1>,
      <1, 1, 1>,
      <5, 5, 5>,
      <5, 5, 5>,
      <2, 2, 2>,
      <2, 2, 2>,
      <0, 0, 0>,
      <0, 0, 0>,
      <6, 6, 1>,
      <6, 1, 1>,
      <6, 6, 7>,
      <6, 7, 7>,
      <8, 8, 7>,
      <8, 7, 7>,
      <2, 2, 9>,
      <2, 9, 9>,
      <8, 8, 9>,
      <8, 9, 9>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 10, 4>,
      <4, 4, 4>,
      <4, 4, 11>,
      <4, 11, 4>,
      <12, 5, 5>,
      <13, 14, 15>,
      <16, 5, 5>,
      <5, 5, 16>,
      <17, 17, 5>,
      <17, 5, 18>,
      <19, 19, 17>,
      <19, 17, 17>,
      <20, 5, 5>,
      <21, 22, 23>,
      <5, 5, 5>,
      <5, 24, 5>,
      <25, 25, 18>,
      <25, 18, 5>,
      <26, 26, 25>,
      <26, 25, 25>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 27>,
      <28, 0, 0>,
      <28, 0, 28>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 2>,
      <28, 0, 0>,
      <28, 0, 28>,
      <1, 30, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <1, 1, 1>,
      <32, 3, 3>,
      <32, 3, 32>,
      <32, 3, 3>,
      <32, 3, 32>,
      <33, 33, 3>,
      <33, 3, 3>,
      <33, 3, 3>,
      <3, 3, 33>,
      <28, 28, 32>,
      <28, 32, 32>,
      <28, 28, 32>,
      <28, 32, 32>,
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <1, 1, 1>,
      <1, 1, 1>,
      <5, 5, 5>,
      <5, 5, 5>,
      <2, 2, 2>,
      <2, 2, 2>,
      <0, 0, 0>,
      <0, 0, 0>,
      <2, 2, 34>,
      <2, 34, 34>,
      <35, 35, 34>,
      <35, 34, 34>,
      <35, 35, 36>,
      <35, 36, 36>,
      <26, 26, 1>,
      <26, 1, 1>,
      <36, 36, 26>,
      <36, 26, 26>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <2, 19, 19>,
      <2, 19, 2>,
      <1, 26, 26>,
      <1, 26, 1>,
      <33, 33, 33>,
      <33, 33, 33>,
      <1, 1, 1>,
      <1, 1, 1>,
      <4, 4, 4>,
      <4, 4, 4>,
      <2, 2, 2>,
      <2, 2, 2>,
      <22, 15, 12>,
      <22, 12, 18>,
      <18, 20, 22>,
      <41, 37, 38>,
      <41, 38, 39>,
      <39, 40, 41>,
      <0, 0, 40>,
      <0, 0, 38>,
      <41, 40, 42>,
      <38, 37, 43>,
      <44, 44, 45>,
      <44, 45, 45>,
      <45, 45, 46>,
      <45, 46, 46>,
      <3, 3, 3>,
      <3, 3, 3>,
      <2, 2, 2>,
      <2, 2, 2>,
      <47, 31, 47>,
      <47, 47, 47>,
      <46, 46, 10>,
      <46, 10, 48>,
      <1, 1, 1>,
      <1, 1, 1>,
      <49, 11, 44>,
      <49, 44, 44>,
      <50, 50, 29>,
      <50, 29, 50>,
      <52, 53, 46>,
      <52, 46, 51>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <54, 55, 56>,
      <54, 56, 44>,
      <57, 2, 2>,
      <57, 2, 57>,
      <58, 58, 57>,
      <58, 57, 57>,
      <59, 1, 1>,
      <59, 1, 59>,
      <58, 60, 60>,
      <58, 60, 58>,
      <59, 59, 60>,
      <59, 60, 60>,
      <3, 3, 33>,
      <3, 33, 33>,
      <3, 33, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>
   }
}
 
#declare Tex32 =
texture {
   pigment {rgbf <8.941177E-01, 8.392157E-01, 8.941177E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// CompCoverP
mesh2 {
 
   vertex_vectors { 
      19, 
      <4.09911E+00, 9.887682E+00, -8.42509E+01>,
      <3.488934E+00, 9.638632E+00, -8.414758E+01>,
      <4.707318E+00, 9.638723E+00, -8.413786E+01>,
      <4.64224E+00, 9.638632E+00, -8.454563E+01>,
      <4.322164E+00, 9.638632E+00, -8.481781E+01>,
      <3.898473E+00, 9.638632E+00, -8.482269E+01>,
      <3.569394E+00, 9.638632E+00, -8.4558E+01>,
      <3.211056E+00, 9.037775E+00, -8.409064E+01>,
      <5.014317E+00, 9.037775E+00, -8.408886E+01>,
      <4.900044E+00, 9.037775E+00, -8.471297E+01>,
      <4.480451E+00, 9.147776E+00, -8.512067E+01>,
      <3.854177E+00, 9.147776E+00, -8.51213E+01>,
      <3.314282E+00, 9.037775E+00, -8.471455E+01>,
      <3.854177E+00, 5.234644E+00, -8.51213E+01>,
      <3.314282E+00, 5.237776E+00, -8.471455E+01>,
      <3.211056E+00, 5.237776E+00, -8.409064E+01>,
      <5.014317E+00, 5.237776E+00, -8.408886E+01>,
      <4.900044E+00, 5.237776E+00, -8.471297E+01>,
      <4.480451E+00, 5.234644E+00, -8.512067E+01>
   }
 
   normal_vectors { 
      38, 
      <6.817585E-01, 7.223736E-01, -1.156801E-01>,
      <5.86052E-01, 7.511581E-01, -3.038167E-01>,
      <2.379488E-03, 9.698845E-01, -2.43554E-01>,
      <2.419836E-01, 7.74235E-01, -5.848112E-01>,
      <-2.237342E-01, 7.602634E-01, -6.09871E-01>,
      <-5.823109E-01, 7.395731E-01, -3.375583E-01>,
      <-6.893907E-01, 7.133003E-01, -1.26266E-01>,
      <9.598727E-01, 2.218536E-01, -1.71538E-01>,
      <8.59954E-01, 2.503164E-01, -4.447705E-01>,
      <3.704866E-01, 2.845027E-01, -8.841934E-01>,
      <-3.216703E-01, 2.637543E-01, -9.093745E-01>,
      <-8.383754E-01, 2.336113E-01, -4.92496E-01>,
      <-9.636033E-01, 2.103408E-01, -1.650016E-01>,
      <-3.167824E-01, 0.00E+00, -9.484982E-01>,
      <-8.553623E-01, 0.00E+00, -5.180302E-01>,
      <-9.865875E-01, 0.00E+00, -1.63233E-01>,
      <9.836479E-01, 0.00E+00, -1.801021E-01>,
      <8.821297E-01, 0.00E+00, -4.710067E-01>,
      <3.764964E-01, 0.00E+00, -9.264181E-01>,
      <-2.379803E-03, -9.698843E-01, 2.435542E-01>,
      <-5.860522E-01, -7.511578E-01, 3.038169E-01>,
      <-6.817587E-01, -7.223733E-01, 1.156799E-01>,
      <-2.419838E-01, -7.74235E-01, 5.848113E-01>,
      <2.237346E-01, -7.602634E-01, 6.098709E-01>,
      <5.823113E-01, -7.395728E-01, 3.375583E-01>,
      <6.893908E-01, -7.133002E-01, 1.262665E-01>,
      <-8.599538E-01, -2.503166E-01, 4.447708E-01>,
      <-9.598727E-01, -2.218536E-01, 1.715382E-01>,
      <-3.704864E-01, -2.845029E-01, 8.841934E-01>,
      <3.216706E-01, -2.637545E-01, 9.093743E-01>,
      <8.383757E-01, -2.336111E-01, 4.924957E-01>,
      <9.636033E-01, -2.103405E-01, 1.650016E-01>,
      <8.553623E-01, 0.00E+00, 5.180302E-01>,
      <3.167824E-01, 0.00E+00, 9.484982E-01>,
      <9.865876E-01, 0.00E+00, 1.632329E-01>,
      <-8.821296E-01, 0.00E+00, 4.710068E-01>,
      <-9.836479E-01, 0.00E+00, 1.801021E-01>,
      <-3.764963E-01, 0.00E+00, 9.264181E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex32}
   }
 
   face_indices { 
      50, 
      <2, 3, 0>, 0,
      <3, 4, 0>, 0,
      <4, 5, 0>, 0,
      <5, 6, 0>, 0,
      <6, 1, 0>, 0,
      <3, 2, 8>, 0,
      <3, 8, 9>, 0,
      <4, 3, 9>, 0,
      <4, 9, 10>, 0,
      <4, 10, 11>, 0,
      <4, 11, 5>, 0,
      <5, 11, 12>, 0,
      <5, 12, 6>, 0,
      <1, 6, 12>, 0,
      <1, 12, 7>, 0,
      <11, 13, 14>, 0,
      <11, 14, 12>, 0,
      <12, 14, 15>, 0,
      <12, 15, 7>, 0,
      <8, 16, 17>, 0,
      <8, 17, 9>, 0,
      <9, 17, 18>, 0,
      <9, 18, 10>, 0,
      <10, 18, 13>, 0,
      <10, 13, 11>, 0,
      <0, 3, 2>, 0,
      <0, 4, 3>, 0,
      <0, 5, 4>, 0,
      <0, 6, 5>, 0,
      <0, 1, 6>, 0,
      <3, 9, 8>, 0,
      <3, 8, 2>, 0,
      <4, 10, 9>, 0,
      <4, 9, 3>, 0,
      <4, 5, 11>, 0,
      <4, 11, 10>, 0,
      <5, 6, 12>, 0,
      <5, 12, 11>, 0,
      <1, 7, 12>, 0,
      <1, 12, 6>, 0,
      <12, 14, 13>, 0,
      <12, 13, 11>, 0,
      <7, 15, 14>, 0,
      <7, 14, 12>, 0,
      <9, 17, 16>, 0,
      <9, 16, 8>, 0,
      <10, 18, 17>, 0,
      <10, 17, 9>, 0,
      <11, 13, 18>, 0,
      <11, 18, 10>, 0
   }
 
   normal_indices { 
      50, 
      <0, 1, 2>,
      <1, 3, 2>,
      <3, 4, 2>,
      <4, 5, 2>,
      <5, 6, 2>,
      <1, 0, 7>,
      <1, 7, 8>,
      <3, 1, 8>,
      <3, 8, 9>,
      <3, 9, 10>,
      <3, 10, 4>,
      <4, 10, 11>,
      <4, 11, 5>,
      <6, 5, 11>,
      <6, 11, 12>,
      <10, 13, 14>,
      <10, 14, 11>,
      <11, 14, 15>,
      <11, 15, 12>,
      <7, 16, 17>,
      <7, 17, 8>,
      <8, 17, 18>,
      <8, 18, 9>,
      <9, 18, 13>,
      <9, 13, 10>,
      <19, 20, 21>,
      <19, 22, 20>,
      <19, 23, 22>,
      <19, 24, 23>,
      <19, 25, 24>,
      <20, 26, 27>,
      <20, 27, 21>,
      <22, 28, 26>,
      <22, 26, 20>,
      <22, 23, 29>,
      <22, 29, 28>,
      <23, 24, 30>,
      <23, 30, 29>,
      <25, 31, 30>,
      <25, 30, 24>,
      <30, 32, 33>,
      <30, 33, 29>,
      <31, 34, 32>,
      <31, 32, 30>,
      <26, 35, 36>,
      <26, 36, 27>,
      <28, 37, 35>,
      <28, 35, 26>,
      <29, 33, 37>,
      <29, 37, 28>
   }
}
 
// CompCoverS
mesh2 {
 
   vertex_vectors { 
      19, 
      <-1.341983E+00, 9.887682E+00, -8.42509E+01>,
      <-1.952159E+00, 9.638632E+00, -8.414758E+01>,
      <-7.337755E-01, 9.638723E+00, -8.413786E+01>,
      <-7.988541E-01, 9.638632E+00, -8.454564E+01>,
      <-1.11893E+00, 9.638632E+00, -8.481782E+01>,
      <-1.542621E+00, 9.638632E+00, -8.48227E+01>,
      <-1.8717E+00, 9.638632E+00, -8.455801E+01>,
      <-2.230037E+00, 9.037775E+00, -8.409064E+01>,
      <-4.267763E-01, 9.037775E+00, -8.408886E+01>,
      <-5.410492E-01, 9.037775E+00, -8.471297E+01>,
      <-9.606429E-01, 9.147776E+00, -8.512067E+01>,
      <-1.586917E+00, 9.14762E+00, -8.51213E+01>,
      <-2.126811E+00, 9.03762E+00, -8.471455E+01>,
      <-1.586917E+00, 5.234488E+00, -8.51213E+01>,
      <-2.126811E+00, 5.23762E+00, -8.471455E+01>,
      <-2.230037E+00, 5.237776E+00, -8.409064E+01>,
      <-4.267763E-01, 5.237776E+00, -8.408886E+01>,
      <-5.410492E-01, 5.237776E+00, -8.471297E+01>,
      <-9.606429E-01, 5.234644E+00, -8.512067E+01>
   }
 
   normal_vectors { 
      38, 
      <6.817585E-01, 7.223738E-01, -1.156784E-01>,
      <5.860522E-01, 7.511582E-01, -3.038161E-01>,
      <2.380056E-03, 9.698846E-01, -2.435532E-01>,
      <2.419673E-01, 7.742257E-01, -5.848303E-01>,
      <-2.237646E-01, 7.602274E-01, -6.099046E-01>,
      <-5.823296E-01, 7.395425E-01, -3.375933E-01>,
      <-6.894026E-01, 7.132826E-01, -1.263005E-01>,
      <9.598727E-01, 2.218539E-01, -1.715375E-01>,
      <8.599541E-01, 2.503166E-01, -4.447703E-01>,
      <3.704641E-01, 2.844839E-01, -8.842088E-01>,
      <-3.216923E-01, 2.637013E-01, -9.09382E-01>,
      <-8.383729E-01, 2.335677E-01, -4.925211E-01>,
      <-9.636032E-01, 2.103165E-01, -1.650329E-01>,
      <-3.167832E-01, 0.00E+00, -9.48498E-01>,
      <-8.553611E-01, 0.00E+00, -5.180322E-01>,
      <-9.865875E-01, 0.00E+00, -1.632331E-01>,
      <9.83648E-01, 0.00E+00, -1.801019E-01>,
      <8.821297E-01, 0.00E+00, -4.710067E-01>,
      <3.764933E-01, 0.00E+00, -9.264194E-01>,
      <-2.380157E-03, -9.698846E-01, 2.435533E-01>,
      <-5.860525E-01, -7.51158E-01, 3.038161E-01>,
      <-6.817589E-01, -7.223734E-01, 1.156784E-01>,
      <-2.419668E-01, -7.742255E-01, 5.848306E-01>,
      <2.237646E-01, -7.602271E-01, 6.099051E-01>,
      <5.823289E-01, -7.395427E-01, 3.37594E-01>,
      <6.894021E-01, -7.13283E-01, 1.263014E-01>,
      <-8.599539E-01, -2.503166E-01, 4.447705E-01>,
      <-9.598728E-01, -2.218536E-01, 1.715376E-01>,
      <-3.704638E-01, -2.844838E-01, 8.84209E-01>,
      <3.21692E-01, -2.637011E-01, 9.093822E-01>,
      <8.383725E-01, -2.33568E-01, 4.925216E-01>,
      <9.63603E-01, -2.103171E-01, 1.650333E-01>,
      <8.553611E-01, 0.00E+00, 5.180322E-01>,
      <3.167832E-01, 0.00E+00, 9.48498E-01>,
      <9.865875E-01, 0.00E+00, 1.632331E-01>,
      <-8.821297E-01, 0.00E+00, 4.710067E-01>,
      <-9.83648E-01, 0.00E+00, 1.801019E-01>,
      <-3.764934E-01, 0.00E+00, 9.264193E-01>
   }
 
   texture_list { 
      1, 
      texture {Tex32}
   }
 
   face_indices { 
      50, 
      <2, 3, 0>, 0,
      <3, 4, 0>, 0,
      <4, 5, 0>, 0,
      <5, 6, 0>, 0,
      <6, 1, 0>, 0,
      <3, 2, 8>, 0,
      <3, 8, 9>, 0,
      <4, 3, 9>, 0,
      <4, 9, 10>, 0,
      <4, 10, 11>, 0,
      <4, 11, 5>, 0,
      <5, 11, 12>, 0,
      <5, 12, 6>, 0,
      <1, 6, 12>, 0,
      <1, 12, 7>, 0,
      <11, 13, 14>, 0,
      <11, 14, 12>, 0,
      <12, 14, 15>, 0,
      <12, 15, 7>, 0,
      <8, 16, 17>, 0,
      <8, 17, 9>, 0,
      <9, 17, 18>, 0,
      <9, 18, 10>, 0,
      <10, 18, 13>, 0,
      <10, 13, 11>, 0,
      <0, 3, 2>, 0,
      <0, 4, 3>, 0,
      <0, 5, 4>, 0,
      <0, 6, 5>, 0,
      <0, 1, 6>, 0,
      <3, 9, 8>, 0,
      <3, 8, 2>, 0,
      <4, 10, 9>, 0,
      <4, 9, 3>, 0,
      <4, 5, 11>, 0,
      <4, 11, 10>, 0,
      <5, 6, 12>, 0,
      <5, 12, 11>, 0,
      <1, 7, 12>, 0,
      <1, 12, 6>, 0,
      <12, 14, 13>, 0,
      <12, 13, 11>, 0,
      <7, 15, 14>, 0,
      <7, 14, 12>, 0,
      <9, 17, 16>, 0,
      <9, 16, 8>, 0,
      <10, 18, 17>, 0,
      <10, 17, 9>, 0,
      <11, 13, 18>, 0,
      <11, 18, 10>, 0
   }
 
   normal_indices { 
      50, 
      <0, 1, 2>,
      <1, 3, 2>,
      <3, 4, 2>,
      <4, 5, 2>,
      <5, 6, 2>,
      <1, 0, 7>,
      <1, 7, 8>,
      <3, 1, 8>,
      <3, 8, 9>,
      <3, 9, 10>,
      <3, 10, 4>,
      <4, 10, 11>,
      <4, 11, 5>,
      <6, 5, 11>,
      <6, 11, 12>,
      <10, 13, 14>,
      <10, 14, 11>,
      <11, 14, 15>,
      <11, 15, 12>,
      <7, 16, 17>,
      <7, 17, 8>,
      <8, 17, 18>,
      <8, 18, 9>,
      <9, 18, 13>,
      <9, 13, 10>,
      <19, 20, 21>,
      <19, 22, 20>,
      <19, 23, 22>,
      <19, 24, 23>,
      <19, 25, 24>,
      <20, 26, 27>,
      <20, 27, 21>,
      <22, 28, 26>,
      <22, 26, 20>,
      <22, 23, 29>,
      <22, 29, 28>,
      <23, 24, 30>,
      <23, 30, 29>,
      <25, 31, 30>,
      <25, 30, 24>,
      <30, 32, 33>,
      <30, 33, 29>,
      <31, 34, 32>,
      <31, 32, 30>,
      <26, 35, 36>,
      <26, 36, 27>,
      <28, 37, 35>,
      <28, 35, 26>,
      <29, 33, 37>,
      <29, 37, 28>
   }
}
 
#declare Tex33 =
texture {
   pigment {rgbf <7.803922E-01, 8.00E-01, 9.607843E-01, 0.00E+00>}
   finish {ambient 4.472136E-01 diffuse 4.80E-01 brilliance 1.00E+00}
}
 
// LadderS
mesh2 {
 
   vertex_vectors { 
      40, 
      <-2.290912E+00, 5.214119E+00, -8.464554E+01>,
      <-2.290913E+00, 9.61412E+00, -8.192918E+01>,
      <-2.370919E+00, 9.61412E+00, -8.192918E+01>,
      <-2.370914E+00, 5.214119E+00, -8.464554E+01>,
      <-2.370914E+00, 5.214119E+00, -8.534554E+01>,
      <-2.370914E+00, 9.61412E+00, -8.262918E+01>,
      <-2.290913E+00, 9.61412E+00, -8.262918E+01>,
      <-2.290912E+00, 5.214119E+00, -8.534554E+01>,
      <-2.370914E+00, 6.190093E+00, -8.41378E+01>,
      <-2.370914E+00, 6.290087E+00, -8.413779E+01>,
      <-3.570911E+00, 6.290087E+00, -8.413779E+01>,
      <-3.570911E+00, 6.190093E+00, -8.41378E+01>,
      <-3.570911E+00, 6.190092E+00, -8.463779E+01>,
      <-3.570911E+00, 6.29009E+00, -8.46378E+01>,
      <-2.370914E+00, 6.290089E+00, -8.46378E+01>,
      <-2.370914E+00, 6.190093E+00, -8.463779E+01>,
      <-2.370914E+00, 7.296453E+00, -8.343141E+01>,
      <-2.370914E+00, 7.396449E+00, -8.343141E+01>,
      <-3.570911E+00, 7.396449E+00, -8.343141E+01>,
      <-3.570911E+00, 7.296453E+00, -8.343141E+01>,
      <-3.570911E+00, 7.296452E+00, -8.393141E+01>,
      <-3.570911E+00, 7.396449E+00, -8.39314E+01>,
      <-2.370914E+00, 7.396449E+00, -8.39314E+01>,
      <-2.370914E+00, 7.296451E+00, -8.393141E+01>,
      <-2.37091E+00, 8.414282E+00, -8.274543E+01>,
      <-2.37091E+00, 8.514286E+00, -8.274543E+01>,
      <-3.570907E+00, 8.514286E+00, -8.274543E+01>,
      <-3.570907E+00, 8.414282E+00, -8.274543E+01>,
      <-3.570915E+00, 8.414285E+00, -8.324543E+01>,
      <-3.570915E+00, 8.514287E+00, -8.324543E+01>,
      <-2.37091E+00, 8.514287E+00, -8.324543E+01>,
      <-2.37091E+00, 8.414285E+00, -8.324543E+01>,
      <-3.570911E+00, 5.214118E+00, -8.464554E+01>,
      <-3.570912E+00, 9.61412E+00, -8.192918E+01>,
      <-3.650913E+00, 9.61412E+00, -8.192918E+01>,
      <-3.650913E+00, 5.214118E+00, -8.464554E+01>,
      <-3.651988E+00, 5.214119E+00, -8.534999E+01>,
      <-3.651989E+00, 9.61412E+00, -8.263364E+01>,
      <-3.571987E+00, 9.61412E+00, -8.263364E+01>,
      <-3.571986E+00, 5.214119E+00, -8.534999E+01>
   }
 
   normal_vectors { 
      8, 
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <-1.816531E-05, 5.253112E-01, -8.509102E-01>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <-2.772614E-07, -5.253129E-01, 8.509092E-01>,
      <-3.258414E-07, 0.00E+00, 1.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex33}
   }
 
   face_indices { 
      40, 
      <11, 12, 15>, 0,
      <11, 15, 8>, 0,
      <9, 14, 13>, 0,
      <9, 13, 10>, 0,
      <19, 20, 23>, 0,
      <19, 23, 16>, 0,
      <17, 22, 21>, 0,
      <17, 21, 18>, 0,
      <27, 28, 31>, 0,
      <27, 31, 24>, 0,
      <25, 30, 29>, 0,
      <25, 29, 26>, 0,
      <35, 34, 37>, 0,
      <35, 37, 36>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <39, 38, 33>, 0,
      <39, 33, 32>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <36, 37, 38>, 0,
      <36, 38, 39>, 0,
      <28, 29, 30>, 0,
      <28, 30, 31>, 0,
      <20, 21, 22>, 0,
      <20, 22, 23>, 0,
      <12, 13, 14>, 0,
      <12, 14, 15>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <32, 33, 34>, 0,
      <32, 34, 35>, 0,
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <24, 25, 26>, 0,
      <24, 26, 27>, 0,
      <16, 17, 18>, 0,
      <16, 18, 19>, 0,
      <8, 9, 10>, 0,
      <8, 10, 11>, 0
   }
 
   normal_indices { 
      40, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>,
      <5, 5, 5>,
      <5, 5, 5>,
      <5, 5, 5>,
      <5, 5, 5>,
      <4, 4, 4>,
      <4, 4, 4>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>
   }
}
 
// LadderP
mesh2 {
 
   vertex_vectors { 
      40, 
      <5.15344E+00, 5.223876E+00, -8.459215E+01>,
      <5.153439E+00, 9.623878E+00, -8.187579E+01>,
      <5.073437E+00, 9.623878E+00, -8.187579E+01>,
      <5.073438E+00, 5.223876E+00, -8.459215E+01>,
      <5.073438E+00, 5.223875E+00, -8.529214E+01>,
      <5.073437E+00, 9.623878E+00, -8.257579E+01>,
      <5.153439E+00, 9.623878E+00, -8.257579E+01>,
      <5.15344E+00, 5.223875E+00, -8.529214E+01>,
      <6.354595E+00, 8.424038E+00, -8.269204E+01>,
      <6.354595E+00, 8.524042E+00, -8.269204E+01>,
      <5.154598E+00, 8.524042E+00, -8.269204E+01>,
      <5.154598E+00, 8.424039E+00, -8.269204E+01>,
      <5.154599E+00, 8.424039E+00, -8.319204E+01>,
      <5.154599E+00, 8.524039E+00, -8.319204E+01>,
      <6.354596E+00, 8.524039E+00, -8.319204E+01>,
      <6.354596E+00, 8.424039E+00, -8.319204E+01>,
      <6.372166E+00, 7.306206E+00, -8.337801E+01>,
      <6.372166E+00, 7.406205E+00, -8.337801E+01>,
      <5.172169E+00, 7.406205E+00, -8.337801E+01>,
      <5.172169E+00, 7.306206E+00, -8.337801E+01>,
      <5.172169E+00, 7.306206E+00, -8.387802E+01>,
      <5.172169E+00, 7.406205E+00, -8.387802E+01>,
      <6.372166E+00, 7.406205E+00, -8.387802E+01>,
      <6.372166E+00, 7.306206E+00, -8.387802E+01>,
      <6.361187E+00, 6.199843E+00, -8.40844E+01>,
      <6.361187E+00, 6.299842E+00, -8.40844E+01>,
      <5.161191E+00, 6.299841E+00, -8.40844E+01>,
      <5.161191E+00, 6.199844E+00, -8.40844E+01>,
      <5.161191E+00, 6.199843E+00, -8.45844E+01>,
      <5.161191E+00, 6.299845E+00, -8.45844E+01>,
      <6.361188E+00, 6.299845E+00, -8.45844E+01>,
      <6.361188E+00, 6.199842E+00, -8.45844E+01>,
      <6.44119E+00, 5.223875E+00, -8.459215E+01>,
      <6.441189E+00, 9.623878E+00, -8.187579E+01>,
      <6.361187E+00, 9.623878E+00, -8.187579E+01>,
      <6.361188E+00, 5.223875E+00, -8.459215E+01>,
      <6.361188E+00, 5.223875E+00, -8.529214E+01>,
      <6.361187E+00, 9.623878E+00, -8.257579E+01>,
      <6.441189E+00, 9.623878E+00, -8.257579E+01>,
      <6.44119E+00, 5.223875E+00, -8.529214E+01>
   }
 
   normal_vectors { 
      8, 
      <0.00E+00, -1.00E+00, 0.00E+00>,
      <0.00E+00, 1.00E+00, 0.00E+00>,
      <1.00E+00, 0.00E+00, 3.258414E-07>,
      <-1.00E+00, 0.00E+00, -3.258414E-07>,
      <2.772617E-07, 5.253115E-01, -8.5091E-01>,
      <3.258414E-07, 0.00E+00, -1.00E+00>,
      <-2.772614E-07, -5.253129E-01, 8.509092E-01>,
      <-3.258414E-07, 0.00E+00, 1.00E+00>
   }
 
   texture_list { 
      1, 
      texture {Tex33}
   }
 
   face_indices { 
      40, 
      <11, 12, 15>, 0,
      <11, 15, 8>, 0,
      <9, 14, 13>, 0,
      <9, 13, 10>, 0,
      <19, 20, 23>, 0,
      <19, 23, 16>, 0,
      <17, 22, 21>, 0,
      <17, 21, 18>, 0,
      <27, 28, 31>, 0,
      <27, 31, 24>, 0,
      <25, 30, 29>, 0,
      <25, 29, 26>, 0,
      <39, 38, 33>, 0,
      <39, 33, 32>, 0,
      <35, 34, 37>, 0,
      <35, 37, 36>, 0,
      <7, 6, 1>, 0,
      <7, 1, 0>, 0,
      <3, 2, 5>, 0,
      <3, 5, 4>, 0,
      <4, 5, 6>, 0,
      <4, 6, 7>, 0,
      <36, 37, 38>, 0,
      <36, 38, 39>, 0,
      <28, 29, 30>, 0,
      <28, 30, 31>, 0,
      <20, 21, 22>, 0,
      <20, 22, 23>, 0,
      <12, 13, 14>, 0,
      <12, 14, 15>, 0,
      <32, 33, 34>, 0,
      <32, 34, 35>, 0,
      <0, 1, 2>, 0,
      <0, 2, 3>, 0,
      <8, 9, 10>, 0,
      <8, 10, 11>, 0,
      <16, 17, 18>, 0,
      <16, 18, 19>, 0,
      <24, 25, 26>, 0,
      <24, 26, 27>, 0
   }
 
   normal_indices { 
      40, 
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <0, 0, 0>,
      <0, 0, 0>,
      <1, 1, 1>,
      <1, 1, 1>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <2, 2, 2>,
      <2, 2, 2>,
      <3, 3, 3>,
      <3, 3, 3>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <4, 4, 4>,
      <5, 5, 5>,
      <5, 5, 5>,
      <5, 5, 5>,
      <5, 5, 5>,
      <5, 5, 5>,
      <5, 5, 5>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <6, 6, 6>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>,
      <7, 7, 7>
   }
}
 
// DomeBig
mesh2 {
 
   vertex_vectors { 
      56, 
      <4.559019E+00, 1.21075E+01, -6.411658E+01>,
      <-1.740977E+00, 1.21075E+01, -6.411659E+01>,
      <-1.740975E+00, 1.21075E+01, -6.951659E+01>,
      <4.559021E+00, 1.21075E+01, -6.951659E+01>,
      <1.408817E+00, 1.662389E+01, -6.951672E+01>,
      <1.408815E+00, 1.662389E+01, -6.411671E+01>,
      <-8.259851E-01, 1.24075E+01, -7.021659E+01>,
      <-8.259889E-01, 1.589349E+01, -7.021659E+01>,
      <1.409023E+00, 1.632384E+01, -7.021659E+01>,
      <3.646528E+00, 1.589348E+01, -7.022061E+01>,
      <3.650196E+00, 1.240749E+01, -7.021808E+01>,
      <3.64402E+00, 1.240751E+01, -6.341658E+01>,
      <3.644033E+00, 1.589349E+01, -6.341658E+01>,
      <1.409025E+00, 1.632383E+01, -6.341659E+01>,
      <-8.259835E-01, 1.589349E+01, -6.341658E+01>,
      <-8.259835E-01, 1.24075E+01, -6.341658E+01>,
      <4.558609E+00, 1.561794E+01, -6.951685E+01>,
      <4.559019E+00, 1.56175E+01, -6.411658E+01>,
      <3.472606E+00, 1.626694E+01, -6.411684E+01>,
      <3.46894E+00, 1.626694E+01, -6.951938E+01>,
      <-6.544956E-01, 1.626698E+01, -6.951659E+01>,
      <-6.544974E-01, 1.626698E+01, -6.411659E+01>,
      <-1.740977E+00, 1.56175E+01, -6.411659E+01>,
      <-1.740982E+00, 1.56175E+01, -6.951659E+01>,
      <4.910555E+00, 1.21075E+01, -6.633208E+01>,
      <4.910611E+00, 1.561795E+01, -6.633184E+01>,
      <4.910607E+00, 1.561794E+01, -6.730084E+01>,
      <4.910552E+00, 1.21075E+01, -6.730109E+01>,
      <-2.143266E+00, 1.21075E+01, -6.729944E+01>,
      <-2.143266E+00, 1.561751E+01, -6.729944E+01>,
      <-2.143266E+00, 1.56175E+01, -6.633375E+01>,
      <-2.143266E+00, 1.210749E+01, -6.633375E+01>,
      <-1.254495E+00, 1.626698E+01, -6.729908E+01>,
      <-1.254499E+00, 1.626698E+01, -6.633277E+01>,
      <4.072611E+00, 1.626694E+01, -6.633184E+01>,
      <4.072608E+00, 1.626694E+01, -6.730085E+01>,
      <-2.264933E+00, 1.129281E+01, -6.481659E+01>,
      <-1.344297E+00, 1.518542E+01, -6.481659E+01>,
      <-1.83087E+00, 1.53005E+01, -6.481659E+01>,
      <-1.830868E+00, 1.53005E+01, -6.881659E+01>,
      <-1.344296E+00, 1.518542E+01, -6.881659E+01>,
      <-2.264931E+00, 1.12928E+01, -6.881659E+01>,
      <-2.705477E+00, 1.160251E+01, -6.481659E+01>,
      <-2.705475E+00, 1.160252E+01, -6.881659E+01>,
      <-2.556883E+00, 1.136185E+01, -6.481659E+01>,
      <-2.556874E+00, 1.136186E+01, -6.881659E+01>,
      <5.013031E+00, 1.129281E+01, -6.481658E+01>,
      <4.0924E+00, 1.518542E+01, -6.481658E+01>,
      <4.578966E+00, 1.53005E+01, -6.481658E+01>,
      <4.578966E+00, 1.53005E+01, -6.881658E+01>,
      <4.092391E+00, 1.518542E+01, -6.881658E+01>,
      <5.013032E+00, 1.12928E+01, -6.881658E+01>,
      <5.453575E+00, 1.160252E+01, -6.481658E+01>,
      <5.453575E+00, 1.160252E+01, -6.881658E+01>,
      <5.304974E+00, 1.136185E+01, -6.481658E+01>,
      <5.304977E+00, 1.136185E+01, -6.881658E+01>
   }
 
   normal_vectors { 
      46, 
      <-9.871542E-01, -1.597708E-01, -1.209061E-06>,
      <-9.731529E-01, 2.301594E-01, -2.543518E-07>,
      <-5.850515E-01,