// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.6
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.6;

#include "colors.inc"

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <0.0, 3, -8.0>
  direction 3 * z
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  0.0>
  rotate -20 * y
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <+30, 30, -30>
}

// ----------------------------------------

plane {
  y, -1
  pigment { color rgbt <0.7,0.5,0.3, 0.7> }
}


#include "functions.inc"


#declare fn_drop = function{
   pigment{
                image_map {
                  png "drops2.png"
//                ================
      
                  map_type 1            // 1=spherical
                  interpolate 4         // 4=normalized distance
//                                         =====================                  
                }
   }
}



isosurface {      
        function { f_sphere (x, y, z, 1) - fn_drop (x,y,z).blue * 0.1  }
//      ================================================================
                
        contained_by { sphere {0, 1.5} }
        
        open
        max_gradient 4 

        texture {
                pigment  { color rgb<1,0,0> } 
                finish {
                        specular 0.5
                        roughness 0.001
                }
        }

}

