// DO_Tree4.inc
// The following object is defined in this file:
//    DO_Tree4
//       A tree with lots of green leaves
//       height: approx. 3.  scale to your liking
//       bottom center is at <0,0,0>
//       Note: with NumLevels = 4, NumBranches = 5, Num = 15, and End = 25,
//       this scene will require 57MB of memory

#ifndef (DO_TREE4_INC)
#declare DO_TREE4_INC = version
#version 3

#declare NumLevels = 4
#declare Height = 2
#declare NumBranches = 5
#declare BranchAngle = 30
#declare ScaleFactor = .6
#declare Radius = Height*.02
#declare R = seed(1)

#declare BranchTexture = texture {
   pigment { color rgb <.6, .5, .4> }
   normal { bumps .3 scale .01 }
   }

#declare LeafTexture = texture { pigment { color rgb <0,.5,0> } }

#declare Leaf = difference {
   sphere { <0,-.70,0>, Height/3 scale <.5,.2,.2> }
   sphere { <0, -.80, 0> Height/3*1.05 scale <.5,.2,.2> }
   texture { LeafTexture }
   translate <.3,0,0>
   //scale .5
   }

#declare Branch = union {
cone { <0,0,0>, Radius, <0,Height,0>, Radius*.2
   texture { BranchTexture } }


// the leaves
#declare Num = 15
#declare End = 25
#declare Angle = 0
#while (Num<End)
   object { Leaf
      rotate z*30 rotate y*Angle
      translate <0,(Num+1)*Height/(End+1),0>
      texture { pigment { color rgb <0,.5,0> } }
   }
   #declare Angle = Angle + 90 + 30*rand(R)
   #declare Num = Num + 1
#end

}

// make the tree
#declare Count = 0
#while (Count<NumLevels)
   #declare Group = union {
      #declare N = 0
      #declare Angle = 0
      #while (N<NumBranches)
         object { Branch
            scale ScaleFactor
            rotate <BranchAngle, 0, 0>
            rotate <0,Angle-rand(R)*40,0>
            translate <0,(N+2)*Height/(NumBranches+2),0>
            }
         #declare N = N + 1
         #declare Angle = Angle + 140
      #end
      cone { <0,0,0>, Radius, <0,Height*1.05,0>, Radius*.3
         texture { BranchTexture } }
      }
   #declare Branch = object { Group }
#declare Count = Count + 1
#end

#declare DO_Tree4 = object { Branch }

// uncomment the section below to render an image of the tree
/*
object { DO_Tree4 }
camera { location <0,Height,-2.5*Height> look_at <0,Height,0> }
light_source { <-50,50,-50> color rgb <1,1,1> }
light_source { <25,5,-50> color rgb <1,1,1> }

// the ground
plane { <0,1,0> 0
   texture {
      pigment { color rgb <.4,.6,.2> }
      finish { ambient .5 }
      }
   }
// the sky
plane { <0,-1,0>, -1000 rotate x*5
   texture {
      pigment { color rgb <.5,.7,.9> }
      finish { ambient .3 }
   }
}
*/

#version DO_TREE4_INC
#end

