// DO_Tulips.inc
// some tulips, .58 tall

// The following objects are defined in this file:
//    DO_TulipRed - a red tulip plant, height = .58
//    DO_TulipWhite
//    DO_TulipYellow
//    DO_TulipRedLeaning
//    DO_TulipWhiteLeaning
//    DO_TulipYellowLeaning

//  bottom center of each plant is at <0,0,0>

#ifndef (DO_TULIP_INC)
#declare DO_TULIP_INC = version
#version 3

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

#declare R1 = seed(0)

#declare BulbPt1 = intersection {
   difference {
      sphere { <0,0,0>, 1 translate y*1 }
      sphere { <0,0,0>, 0.99 translate y*.99 }
      }
   box { <-2,-2,-2>, <0,0,2> rotate z*45 scale <1,2,1> translate y*1.8 }
   scale <.05,.08,.05>
   }

#declare Bulb = union {
   object { BulbPt1 rotate y*0 }
   object { BulbPt1 scale .95 rotate y*60 }
   object { BulbPt1 scale .90 rotate y*120 }
   }

#declare Leaf1 = difference {
   torus { 1, .2 rotate x*90 translate <1.2,0,0> }
   sphere { <1.3,-.2,0>, 1.33333 }
   texture { pigment { color rgb <0,.5,0> } }
   scale .1
   }

// the straight stem
#declare Stem1 = union {
   cone {
      <0,0,0>, 0.005, <0,.5,0>, 0.0035
      texture { pigment { color rgb <0,.5,0> } }
      }
   #declare Numleaves = 6
   #declare Count = 0
   #declare Rotate = 0
   #while ( Count < Numleaves )
      #object {
         Leaf1
         #declare Rotate = Rotate + 180 + rand(R1)*20+10
         rotate y*Rotate
         translate y*(0.5*(Count+1)/(Numleaves+2))
         }
      #declare Count = Count + 1
   #end
   }

// the tulips on the straight stems
#declare DO_TulipRed = union {
   object {
      Bulb translate y*.5
      texture { pigment { color rgb <.8,0,0> } }
      }
   object { Stem1 }
   }

#declare DO_TulipWhite = union {
   object {
      Bulb translate y*.5
      texture { pigment { color rgb <.98,.98,.98> } }
      }
   object { Stem1 }
   }

#declare DO_TulipYellow = union {
   object {
      Bulb translate y*.5
      texture { pigment { color rgb <1,.9,.1> } }
      }
   object { Stem1 }
   }

// The leaning stem.  The stem leans in the positive x direction
#declare Stem2 = union {
   difference {
      torus { 2, .008 rotate x*90 }
      box { <-2.1, -2.1, -.1>, <2.1, 0, .1> }
      box { <0, -2.1, -.1>, <2.1, 2.1, .1> rotate z*60 }
      translate x*2
      }
   #declare Numleaves = 5
   #declare Count = 0
   #declare Rotate = 0
   #while ( Count < Numleaves )
      #object {
         Leaf1 scale 2
         #declare Rotate = Rotate + 180 + rand(R1)*20+10
         rotate y*Rotate
         translate x*-2
         rotate z*(-30*(Count+1)/(Numleaves+2))
         translate x*2
         }
      #declare Count = Count + 1
   #end
   scale .5
   }

// The tulips on the leaning stems
// They lean in the positive x direction
#declare DO_TulipRedLeaning = union {
   object {
      Bulb translate x*-1 rotate z*-30 translate x
      texture { pigment { color rgb <.8,0,0> } }
      }
   object { Stem2 }
   }

#declare DO_TulipWhiteLeaning = union {
   object {
      Bulb translate x*-1 rotate z*-30 translate x
      texture { pigment { color rgb <.98,.98,.98> } }
      }
   object { Stem2 }
   }

#declare DO_TulipYellowLeaning = union {
   object {
      Bulb translate x*-1 rotate z*-30 translate x
      texture { pigment { color rgb <1,.9,.1> } }
      }
   object { Stem2 }
   }


// uncomment the section below to render a view of the tulips
/*
torus { .5,.05 texture { T_Stone13 scale .5 } }
cylinder { <0,0,0>, <0,.01,0> 0.5 texture { pigment { color Black } } }
object { DO_TulipRed           scale 1.1  rotate y*200 translate <-0.25,  0.00,  0.25> }
object { DO_TulipWhite         scale 0.9  rotate y*10  translate < 0.10,  0.00,  0.00> }
object { DO_TulipYellowLeaning scale 0.6  rotate y*200 translate <-0.20,  0.00, -0.20> }
object { DO_TulipYellow        scale 0.8  rotate y*90  translate < 0.25,  0.00,  0.20> }
object { DO_TulipRedLeaning    scale 0.7  rotate y*20  translate < 0.25,  0.00, -0.25> }
object { DO_TulipWhite         scale .65  rotate y*120  translate <-0.05,  0.00, -0.25> }
plane {  y,  0 texture { pigment { color <.7,.7,.7> } } }
plane {  x, -5 texture { pigment { color <.7,.7,.7> } } rotate y*35 }
plane { -z, -5 texture { pigment { color <.7,.7,.7> } } rotate y*35 }
light_source { <-20,50,-20> color rgb <1,1,1> }
light_source { <10,12,-20> color rgb <1,1,1> }
camera { location <0,.4,-1.7> look_at <0,.4,0> }
*/

#version DO_TULIP_INC
#end

