// Persistence of Vision Ray Tracer Scene Description File
// File: BinTree.inc (include file for BinTree.inc)
// Vers: 3
// Desc: Simple recursive binary tree example
// Date: 11/7/96
// Auth: Eduard Schwan
//

/*
How does this work?
The first call to this include file creates a vertically pointing cone (1),
and then alters the start and endpoints to point off the top of this cone (1a),
and the include then includes itself to create sub-cone branches (2) and (3).
Then it restores the start/end variable values to what they were when
the first cone was made (4) and returns.  It is because of the magic of (4)
that we are able to continually call ourselves and change the positions of
the cones, and then as we back out of each level we restore the position
back to that particular level.  
*/

#if (RecursionLevel <= 0)

  #if (DO_DEBUG)
    // dumps recursion progress information to the status window
    // Note: Using the recursion level for # of digits gives us auto-indenting based on recursion level!
    #debug concat("\n## ", str(RecursionLevel,(RecursionStart-RecursionLevel+1)*2,0)," ")
    #debug concat("EndPoint<", str(LPoint.x,4,2), ",", str(LPoint.y,4,2), ",", str(LPoint.z,4,2), ">")
  #end

  // We have recursed down to the leaf, draw the end object
  sphere { LPoint, LBase*2 texture {LeafTex} }

#else

  #if (DO_DEBUG)
   #debug concat("\n## ", str(RecursionLevel,(RecursionStart-RecursionLevel+1)*2,0)," ")
   #debug concat("LPoint<", str(LPoint.x,4,2), ",", str(LPoint.y,4,2), ",", str(LPoint.z,4,2), ">")
  #end

  // (1) draw this level's stem
  #declare LPoint2 = LPoint + LLength*LDirection // calculate far endpoint of cone
  cone { LPoint, LBase, LPoint2, LBase*LBaseTaper texture {BranchTex} }

  // (1a) go to next level down
  #declare RecursionLevel = RecursionLevel-1
  #declare LPoint = LPoint2    // move up to top of current stem
  #declare LBase = LBase*LBaseTaper // shrink base to value at top
  #declare LLength = LLength*LLengthTaper // shorten next branches too

  // (2) do left side at next level
  #declare LDirection = vrotate(LDirection, LRot)  // point one way
  #include "bintree.inc"

  // (3) do right side at next level
  #declare LDirection = vrotate(LDirection, -2*LRot) // point back the other way
  #include "bintree.inc"

  // (4) return variables to state (1)
  #declare LDirection = vrotate(LDirection, LRot)   // point back original way
  #declare LLength = LLength/LLengthTaper    // lengthen back
  #declare LBase = LBase/LBaseTaper     // expand the base back
  #declare LPoint = LPoint-LLength*LDirection  // move point back to bottom of stem
  #declare RecursionLevel = RecursionLevel+1  // back up a level

#end
