// Persistence of Vision Ray Tracer Scene Description File
// File: BinTree.pov
// Vers: 3
// Desc: Simple recursive binary tree example,
//       Best viewed at 2x1 aspect ratio (like 600x300),
//       see BinTree.inc for theory of operation.
// Date: 11/7/96
// Auth: Eduard Schwan
//

#version 3

global_settings
  {
  assumed_gamma 1.0
  }


// --- the camera

camera
  {
  location  <0.0, 2.0, -6.0>
  direction 1.5*z
  right     2*x              // note 2x1 aspect ratio
  look_at   <0.0, 1.5,  0.0>
  }


// --- the sky

sky_sphere
  {
  pigment
    {
    gradient y              // darkening sky
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
    }
  }


// --- the sun

light_source
  {
  0*x
  color rgb 1  // white light
  translate <-60, 30, -60>
  }


// --- the ground

plane
  {
  y, 0
  texture
    {
    pigment
      {
      crackle turbulence 0.1
      color_map { [0.05 rgb <0.0,0.4,0.1>] [0.15 rgb <0.3,0.5,0.1>] [0.20 rgb <0.8,0.6,0.3>] }
      }
    normal { crackle turbulence 0.12 bump_size 0.5 } // purposeful slight turb difference
    finish { ambient 0.2 specular 0.3 roughness 0.1 }
    scale 0.5
    }
  }


// --- Set up initial values

// Set this line to 1 to enable debugging status information, 0 to turn off
#declare DO_DEBUG = 0

// How many levels of recursion to do, can change from 0 to 8
#declare RecursionLevel = 7     // increase this to add levels of branches

// Cone's initial base diameter and taper amount
#declare LBase        = 0.3     // current diameter of cone's base
#declare LBaseTaper   = 0.6     // how much to taper cone at each level

// Cone's initial length and amount to shorten at each level
#declare LLength      = 1.0     // current length of cone
#declare LLengthTaper = 0.7     // how much to shrink LLength at each level

// Initial direction of first cone, and angle to sprout next level cone
#declare LUp          = y       // initial unit direction
#declare LRot         = 50*z    // how far to rotate each branch in degrees

// Initial starting point of first cone, and initial growth direction.
// These are the actual running variables that change at each level.
#declare LPoint       = <0,0,0> // base of current cone
#declare LDirection   = LUp     // current unit direction of cone
#declare RecursionStart = RecursionLevel // for debugging display


// --- define the recursive tree object

// The texture of the cone
#declare BranchTex = texture
  {
  pigment { rgb <0.7,0.1,0.2> }  // Manzanita color
  finish { specular 0.4 roughness 0.05 }
  }

#declare LeafTex = texture
  {
  pigment { rgbf <0.8,0.8,1.0,0.9> }
  finish { ambient 0.1 diffuse 0.8 specular 0.3 reflection 0.2 refraction 1 ior 1.4 }
  }

#declare Tree = union
  {
  // include the recursive definition of cones
  #include "bintree.inc"
  }


// make some trees

object { Tree }                                    // center
object { Tree  rotate -30*y  translate <-7,0,8> }  // left rear
object { Tree  rotate +30*y  translate <+7,0,8> }  // right rear

