# -----------------------------------------------------------------------------
#!/usr/bin/perl
# -----------------------------------------------------------------------------
#
# perl Analyser.pl FULL_PATH_TO_FILE 
#
# -----------------------------------------------------------------------------
use strict;
use warnings;
use File::Basename;



# --- Processing command line arguments - @ARGV -------------------------------
my $fullPath = shift;
print "\n\n\n\n";


my ($name, $dir, $ext) = fileparse($fullPath,'\..*');
#printf ("name = $name\n");
#printf ("dir  = $dir\n");
#printf ("ext  = $ext\n\n");
chdir ($dir) or die "chdir error : $!\n";


# --- The source file name ----------------------------------------------------
my $SourceFile = "$name$ext";
print "Find variables in $SourceFile...\n\n";


# --- Some variables ----------------------------------------------------------
my $line;
my $lnum=1;
my @VarArray;
my $var;


# --- Open file ---------------------------------------------------------------
open(FILE,"<",$SourceFile) or die(" >> Error openning $SourceFile : $!\n");

# --- Analyse file ------------------------------------------------------------
while($line = <FILE>){
	chomp($line);
	printf("%04d : %s\n",$lnum,$line); 
	if ($line =~ /#declare|#local/) {
		#printf("%04d : %s\n",$lnum,$line); 
		my @m = split('\s|=',$line);
		for my $i (0 .. $#m) {
			if ($m[$i] =~ /declare|local/) {
				#print "       var : $m[$i+1]\n";
				# --- Store variables in @VarArray ----------------------------
				push @VarArray,$m[$i+1];
				}
			}		
		}
	$lnum++;
	}
# --- Close file --------------------------------------------------------------
close FILE;



# --- Remove duplicate variables names and sort the array ---------------------
@VarArray = remove_duplicates(sort @VarArray);


# --- Display variables names -------------------------------------------------
my $NbVar = $#VarArray+1;
my $n=1;
print "\nList of variables ($NbVar) :\n\n";
foreach $var ( @VarArray  ) {
	printf ("- %04d : %s\n",$n++,$var);
	}




# https://perl.mines-albi.fr/DocFr/perldsc.html#hachage%20de%20tableaux
my %VarReference;
print "\nFind variables references for each var...\n\n";


# --- Open file ---------------------------------------------------------------
open(FILE,"<",$SourceFile) or die(" >> Error openning $SourceFile : $!\n");
# --- Analyse file ------------------------------------------------------------
$lnum = 1;
while($line = <FILE>){
	chomp($line);
	foreach $var (@VarArray) {
		if ($line =~ /$var/) {
			push @{$VarReference{$var}}, $lnum;
			}
		}
	$lnum++;
	}
# --- Close file --------------------------------------------------------------
close FILE;




# --- Display Hash of VarReference --------------------------------------------
foreach $var ( sort keys %VarReference ) {
	my $t = "$var : "; my $lt = length($t); my $space = " " x $lt;
	print "$t";
	my $NbyL = 1;
	foreach my $i ( 0 .. $#{$VarReference{$var} } ) {
		print "$VarReference{$var}[$i]";
		if ( $NbyL == 16 ) {
			print "\n$space";
			$NbyL = 1;
			}
		else {
			print ", ";
			$NbyL++;
			}
		}
	print "\n\n";
	}





# -----------------------------------------------------------------------------
# --- ANALYSES (), [], {} -----------------------------------------------------
# -----------------------------------------------------------------------------

my @Lines;

# --- Open file ---------------------------------------------------------------
open(FILE,"<",$SourceFile) or die(" >> Error openning $SourceFile : $!\n");
# --- Analyse file ------------------------------------------------------------
$lnum = 1;

my $Parenthesis = 0;	# ( )
my $Bracket = 0;		# [ ]
my $Brace = 0;			# { }
#my $AngleBracket = 0;	# < >

my $o;
my $c;

while($line = <FILE>){
	chomp($line);
#	if($line =~ /^\/\//) { $lnum++;  next; }
	printf("%04d : %s\n",$lnum,$line); 

#	$ParenthesisOpen = count_char("(",$line);
#	$ParenthesisClose = count_char(")",$line);
	$o = count_char("(",$line);
	$c = count_char(")",$line);
	$Parenthesis = $Parenthesis + $o - $c;
	
#	$BracketOpen = count_char("[",$line);
#	$BracketClose =count_char("]",$line);
	$o = count_char("[",$line);
	$c = count_char("]",$line);
	$Bracket = $Bracket + $o - $c;


#	$BraceOpen =count_char("{",$line);
#	$BraceClose =count_char("}",$line);
	$o = count_char("{",$line);
	$c = count_char("}",$line);
	$Brace = $Brace + $o - $c;


#	$LessThan = count_char("<",$line);
#	$GreaterThan = count_char(">",$line);
# 	$o = count_char("<",$line);
#	$c = count_char(">",$line);
#	$AngleBracket = $AngleBracket + $o - $c;

	push @Lines,[$line,$Parenthesis,$Bracket,$Brace];

#	printf (
#		"       |%2d|%2d|%2d|\n\n",
#		$Parenthesis,$Bracket,$Brace,#$AngleBracket
#		);
	$lnum++;
	}
	printf (
		"       |%2d|%2d|%2d|\n\n",
		$Parenthesis,$Bracket,$Brace,#$AngleBracket
		);
	
# --- Close file --------------------------------------------------------------
close FILE;
print "\n\n\n";

# --- Analyse -----------------------------------------------------------------
my $ArraySize = @Lines;


# --- Check parenthesis () ----------------------------------------------------
if ($Lines[-1][1]==0){
	print ("Parenthesis balance OK\n");
	}
else {
	print ("Parenthesis balance is wrong\n");
	};


# --- Check bracket [] --------------------------------------------------------
if ($Lines[-1][2]==0){
	print ("Bracket balance OK\n");
	}
else {
	print ("Bracket balance is wrong\n");
	};


# --- Check brace {} ----------------------------------------------------------
if ($Lines[-1][3]==0){
	print ("Brace balance OK\n");
	}
else {
	print ("Brace balance is WRONG\n");
	my $v = $Lines[-1][3];
	my $wrongLine = -1;
	for (my $i=$ArraySize-1; $i>0 ; $i--) {
		if ( $Lines[$i][3] != $v ) {
			$wrongLine = $i+1;
			last;
			}
		}
	print ("Brace missing in line $wrongLine\n");
	};




# -----------------------------------------------------------------------------
# --- SUBROUTINES -------------------------------------------------------------
# -----------------------------------------------------------------------------

sub remove_duplicates { my %AlreadySeen; grep !$AlreadySeen{$_}++, @_; }


sub count_char {
	my ($theChar,$theString) = @_;
	my $number = 0;
	$number = $theString =~ s/\Q$theChar//g;
	return $number;
	}

