// c2s3_imp.inc -- macros for importing mesh data

#ifndef(C2S3_IMP_INC)
#declare C2S3_IMP_INC=true;

#macro c2s3_AddSharpData(aSharp)
  #ifndef(c2s3cE) c2s3_BuildEdges() #end
  #local iI=0;#while(iI<dimension_size(aSharp,1))
    #local sS=aSharp[iI][2];
    #if(sS<0) #local sS=256;#end
    #local iA=min(aSharp[iI][0],aSharp[iI][1]);
    #local iB=max(aSharp[iI][0],aSharp[iI][1]);
    #local iE=0;#while(iE<c2s3cE)
      #if(iA=c2s3aEA[iE] & iB=c2s3aEB[iE])
        #declare c2s3aES[iE]=sS;
      #end
    #local iE=iE+1;#end
  #local iI=iI+1;#end
  #debug "Sharp data added to mesh.\n"
#end

#macro c2s3_AddTextureMapping(aU,aFU)
  c2s3_DeleteMapping()

  #declare c2s3cU=dimension_size(aU,1);
  #declare c2s3aU=array[c2s3cU];
  #local iI=0;#while(iI<c2s3cU)
    #declare c2s3aU[iI]=aU[iI];
  #local iI=iI+1;#end

  #local cT=dimension_size(aFU,1);
  #local cF=0;
  #local iR=0;#while(iR<cT)
    #local cV=aFU[iR];
    #local cF=cF+1;
  #local iR=iR+cV+1;#end

  #declare c2s3aFU=array[cT+c2s3cF-cF];
  #local iI=0;#while(iI<cT)
    #declare c2s3aFU[iI]=aFU[iI];
  #local iI=iI+1;#end
  #while(iI<cT+c2s3cF-cF)
    #declare c2s3aFU[iI]=0;
  #local iI=iI+1;#end
  #debug "Texture mapping added to mesh.\n"
  c2s3_BuildMapEdges()
#end

// runs in O(N) time, N is number of faces
#macro c2s3_AddTextures(aiT)
  #if(dimension_size(aiT,1)>c2s3cF)
    #error "c2s3_AddTextures() error:  Supplied array has too many members.\n"
  #end
  
  c2s3_BuildDefaultTextures()

  #local iF=0;#while(iF<c2s3cF) #declare c2s3aFT[iF]=-1; #local iF=iF+1;#end
  
  #local iF=0;#while(iF<dimension_size(aiT,1))
    #declare c2s3aFT[iF]=aiT[iF];
  #local iF=iF+1;#end
  #debug "Texture definitions added.\n"
#end

// runs in O(N) time
#macro c2s3_BuildDefaultMapping()
  #declare c2s3aFU=array[c2s3cF];
  #local iF=0;#while(iF<c2s3cF)
    #declare c2s3aFU[iF]=0;
  #local iF=iF+1;#end
  #declare c2s3cU=0;
#end

// runs in O(N) time
#macro c2s3_BuildDefaultTextures()
  c2s3_DeleteTextures()
  
  #declare c2s3aFT=array[c2s3cF];
  
  #local iF=0;#while(iF<c2s3cF)
    #declare c2s3aFT[iF]=-1;
  #local iF=iF+1;#end
#end

// this macro builds c2s3aEA,c2s3aEB,c2s3aEL,c2s3aER, and c2s3aFE
// runs in O(N log N) time
#macro c2s3_BuildEdges()

  c2s3_DeleteEdges()
  #debug "Building edge data.\n"
  #local qcE=dimension_size(c2s3aFV,1)-c2s3cF; // total possible number of sides

  #local qaEA=array[qcE];
  #local qaEB=array[qcE];
  #local qaEF=array[qcE];
  
  #local iE=0;
  #local iF=0;
  #local iR=0;#while(iR<dimension_size(c2s3aFV,1))
    #local cV=c2s3aFV[iR];
    #local iR=iR+1;
    #local iI=0;#while(iI<cV-1)
      #local qaEA[iE]=c2s3aFV[iR+iI];
      #local qaEB[iE]=c2s3aFV[iR+iI+1];
      #local qaEF[iE]=iF;
      #local iE=iE+1;
    #local iI=iI+1;#end
    #local qaEA[iE]=c2s3aFV[iR+cV-1];
    #local qaEB[iE]=c2s3aFV[iR];
    #local qaEF[iE]=iF;
    #local iE=iE+1;
    #local iF=iF+1;
  #local iR=iR+cV;#end

  #if(iE!=qcE) #error "Edge count and edge estimate came out different!\n" #end

  #local iE=0;#while(iE<qcE)
    #local iA=min(qaEA[iE],qaEB[iE]);
    #local iB=max(qaEA[iE],qaEB[iE]);
    #local qaEA[iE]=iA;
    #local qaEB[iE]=iB;
  #local iE=iE+1;#end

  // sort the array, ascending by smaller of qaEA and qaEB, then larger
  // using a binary sort

  #local qaSS=array[qcE];
  #local qaSE=array[qcE];
  
  #local iP=0;
  #local qaSS[0]=0;
  #local qaSE[0]=qcE-1;
  
  #while(iP>=0)
    #local iS=qaSS[iP];
    #local iE=qaSE[iP];
    #if(iE>iS)
      #local iM=floor((iS+iE)/2);

      #local iA=qaEA[iM];
      #local iB=qaEB[iM];

      #local iI=iS;#while(iI<iM)
        #local iAI=qaEA[iI];
        #local iBI=qaEB[iI];

        #if(iA<iAI | (iA=iAI & iB< iBI) ) // current item belongs after middle
          // code to put iI at iM, iM at iM-1, iM-1 at iI
          #local qS=iAI;     #local qaEA[iI]=qaEA[iM-1];#local qaEA[iM-1]=qaEA[iM];#local qaEA[iM]=qS;
          #local qS=iBI;     #local qaEB[iI]=qaEB[iM-1];#local qaEB[iM-1]=qaEB[iM];#local qaEB[iM]=qS;
          #local qS=qaEF[iI];#local qaEF[iI]=qaEF[iM-1];#local qaEF[iM-1]=qaEF[iM];#local qaEF[iM]=qS;
          #local iM=iM-1;
        #else
          #local iI=iI+1;
        #end
      #end // either iM gets lower or iI gets higher with each pass, so loop eventually ends

      #local iI=iE;#while(iI>iM)
        #local iAI=qaEA[iI];
        #local iBI=qaEB[iI];

        #if(iA>iAI | (iA=iAI & iB> iBI) ) // current item belongs after middle
          // code to put iI at iM, iM at iM+1, iM-1 at iI
          #local qS=iAI;     #local qaEA[iI]=qaEA[iM+1];#local qaEA[iM+1]=qaEA[iM];#local qaEA[iM]=qS;
          #local qS=iBI;     #local qaEB[iI]=qaEB[iM+1];#local qaEB[iM+1]=qaEB[iM];#local qaEB[iM]=qS;
          #local qS=qaEF[iI];#local qaEF[iI]=qaEF[iM+1];#local qaEF[iM+1]=qaEF[iM];#local qaEF[iM]=qS;
          #local iM=iM+1;
        #else
          #local iI=iI-1;
        #end
      #end // either iM gets higher or iI gets lower with each pass, so loop eventually ends

// when all is split
      #local qaSS[iP]=iS;
      #local qaSE[iP]=iM-1;
      #local iP=iP+1;
      #local qaSS[iP]=iM+1;
      #local qaSE[iP]=iE;
    #else // if iE<=iS, there is either one item to sort or none at all
      #local iP=iP-1;
    #end
  #end

// done sorting, don't need these array
  #undef qaSS
  #undef qaSE

  // eliminate duplicated edges, merge data

  // count the total number of edges
  #declare c2s3cE=0;
  #local iE=0;#while(iE<qcE)
    #if(iE=0)
      #declare c2s3cE=c2s3cE+1;
    #else
      #if(qaEA[iE]!=qaEA[iE-1] | qaEB[iE]!=qaEB[iE-1])
        #declare c2s3cE=c2s3cE+1;
      #end
    #end
  #local iE=iE+1;#end

  // c2s3cE now contains the number of edges
  // copy qaEA to c2s3aEA
  // copy qaEB to c2s3aEB
  // copy qaEF to c2s3aEL and c2s3aFR

  #local qaEU=array[qcE];
  
  #declare c2s3aEA=array[c2s3cE];
  #declare c2s3aEB=array[c2s3cE];
  #declare c2s3aES=array[c2s3cE];
  #declare c2s3aEL=array[c2s3cE];
  #declare c2s3aER=array[c2s3cE];

  #local iE=0;#while(iE<c2s3cE)
    #declare c2s3aEL[iE]=-1;
    #declare c2s3aER[iE]=-1;
  #local iE=iE+1;#end

  #local iEN=0;
  #local iE=0;#while(iE<qcE)
    #declare c2s3aEA[iEN]=qaEA[iE];
    #declare c2s3aEB[iEN]=qaEB[iE];
    #declare c2s3aEL[iEN]=qaEF[iE];
    #declare c2s3aES[iEN]=0;  // smooth by default
    #local qaEU[iE]=iEN;
    #if(iE<qcE-1)
      #if(qaEA[iE]=qaEA[iE+1] & qaEB[iE]=qaEB[iE+1])
        #declare c2s3aER[iEN]=qaEF[iE+1];
        #local iE=iE+1;
        #local qaEU[iE]=iEN;
      #end
    #end
    #local iEN=iEN+1;
  #local iE=iE+1;#end

  #if(iEN<c2s3cE)
    #error "Something wrong happened when building the edge arrays.\n"
  #end

  // build c2s3aFE from qaEA, qaEB, qaEF, and c2s3aFV
  // its size is not difficult to guess
  #declare c2s3aFE=array[dimension_size(c2s3aFV,1)];
  //build an indexing array we'll only use here
  #local qaFI=array[c2s3cF];
  #local iR=0;
  #local iF=0;#while(iF<c2s3cF)
    #local qaFI[iF]=iR;
    #declare c2s3aFE[iR]=c2s3aFV[iR];
    #local iR=iR+c2s3aFV[iR]+1;
  #local iF=iF+1;#end

  #local iE=0;#while(iE<qcE)
    #local iF=qaEF[iE];
    #local iR=qaFI[iF];
    #local cV=c2s3aFE[iR];
    #local iR=iR+1;
    #local iI=0;#while(iI<cV)
      #local iJ=mod(iI+1,cV);
      #if( (c2s3aFV[iR+iI]=qaEA[iE] & c2s3aFV[iR+iJ]=qaEB[iE]) | (c2s3aFV[iR+iI]=qaEB[iE] & c2s3aFV[iR+iJ]=qaEA[iE]) )
        #declare c2s3aFE[iR+iI]=qaEU[iE];
      #end
    #local iI=iI+1;#end
  #local iE=iE+1;#end
  
  #undef qaEA
  #undef qaEB
  #undef qaEF
  #undef qaEU
  #undef qaFI
  
  #local qaEC=array[c2s3cE];
  #local iE=0;#while(iE<c2s3cE)
    #local qaEC[iE]=0;
  #local iE=iE+1;#end
  
  #debug "Verifying edge borders.\n"
  #local iR=0;
  #local iF=0;#while(iF<c2s3cF)
    #local cE=c2s3aFE[iR];
    #local iR=iR+1;
    #local iI=0;#while(iI<cE)
      #local iE=c2s3aFE[iR+iI];
      #local qaEC[iE]=qaEC[iE]+1;
      #if(qaEC[iE]>2)
        #debug concat("Face ",str(iF,0,0)," is the ",str(qaEC[iE]),"th face bordering on edge ",str(iE,0,0),"\n")
      #end
    #local iI=iI+1;#end
    #local iR=iR+cE;
  #local iF=iF+1;#end
  #debug "Verification passed.\n"
 
#end

// this macro builds c2s3aMA,c2s3aMB,c2s3aML,c2s3aMR, and c2s3aFM
// runs in O(N log N) time
#macro c2s3_BuildMapEdges()

  c2s3_DeleteMapEdges()
  #debug "Building texture map border data.\n"
  #local qcM=dimension_size(c2s3aFU,1)-c2s3cF; // total possible number of sides

  #local qaMA=array[qcM];
  #local qaMB=array[qcM];
  #local qaMF=array[qcM];
  
  #local iM=0;
  #local iF=0;
  #local iR=0;#while(iR<dimension_size(c2s3aFU,1))
    #local cU=c2s3aFU[iR];
    #local iR=iR+1;
    #local iI=0;#while(iI<cU)
      #local qaMA[iM]=c2s3aFU[iR+iI];
      #local qaMB[iM]=c2s3aFU[iR+mod(iI+1,cU)];
      #local qaMF[iM]=iF;
      #local iM=iM+1;
    #local iI=iI+1;#end
//    #local iM=iM+1;
    #local iF=iF+1;
  #local iR=iR+cU;#end

  #if(iM!=qcM) #error "Map edge count and map edge estimate came out different!\n" #end

  #local iM=0;#while(iM<qcM)
    #local iA=min(qaMA[iM],qaMB[iM]);
    #local iB=max(qaMA[iM],qaMB[iM]);
    #local qaMA[iM]=iA;
    #local qaMB[iM]=iB;
  #local iM=iM+1;#end

  // sort the array, ascending by smaller of qaMA and qaMB, then larger
  // using a binary sort

  #local qaSS=array[qcM];
  #local qaSE=array[qcM];
  
  #local iP=0;
  #local qaSS[0]=0;
  #local qaSE[0]=qcM-1;
  
  #while(iP>=0)
    #local iS=qaSS[iP];
    #local iE=qaSE[iP];
    #if(iE>iS)
      #local iM=floor((iS+iE)/2);

      #local iA=qaMA[iM];
      #local iB=qaMB[iM];

      #local iI=iS;#while(iI<iM)
        #local iAI=qaMA[iI];
        #local iBI=qaMB[iI];

        #if(iA<iAI | (iA=iAI & iB< iBI) ) // current item belongs after middle
          // code to put iI at iM, iM at iM-1, iM-1 at iI
          #local qS=iAI;     #local qaMA[iI]=qaMA[iM-1];#local qaMA[iM-1]=qaMA[iM];#local qaMA[iM]=qS;
          #local qS=iBI;     #local qaMB[iI]=qaMB[iM-1];#local qaMB[iM-1]=qaMB[iM];#local qaMB[iM]=qS;
          #local qS=qaMF[iI];#local qaMF[iI]=qaMF[iM-1];#local qaMF[iM-1]=qaMF[iM];#local qaMF[iM]=qS;
          #local iM=iM-1;
        #else
          #local iI=iI+1;
        #end
      #end // either iM gets lower or iI gets higher with each pass, so loop eventually ends

      #local iI=iE;#while(iI>iM)
        #local iAI=qaMA[iI];
        #local iBI=qaMB[iI];

        #if(iA>iAI | (iA=iAI & iB> iBI) ) // current item belongs after middle
          // code to put iI at iM, iM at iM+1, iM-1 at iI
          #local qS=iAI;     #local qaMA[iI]=qaMA[iM+1];#local qaMA[iM+1]=qaMA[iM];#local qaMA[iM]=qS;
          #local qS=iBI;     #local qaMB[iI]=qaMB[iM+1];#local qaMB[iM+1]=qaMB[iM];#local qaMB[iM]=qS;
          #local qS=qaMF[iI];#local qaMF[iI]=qaMF[iM+1];#local qaMF[iM+1]=qaMF[iM];#local qaMF[iM]=qS;
          #local iM=iM+1;
        #else
          #local iI=iI-1;
        #end
      #end // either iM gets higher or iI gets lower with each pass, so loop eventually ends

// when all is  split
      #local qaSS[iP]=iS;
      #local qaSE[iP]=iM-1;
      #local iP=iP+1;
      #local qaSS[iP]=iM+1;
      #local qaSE[iP]=iE;
    #else // if iE<=iS, there is either one item to sort or none at all
      #local iP=iP-1;
    #end
  #end

// done sorting, don't need these array
  #undef qaSS
  #undef qaSE

  // eliminate duplicated edges, merge data

  // count the total number of edges
  #declare c2s3cM=0;
  #local iM=0;#while(iM<qcM)
    #if(iM=0)
      #declare c2s3cM=c2s3cM+1;
    #else
      #if(qaMA[iM]!=qaMA[iM-1] | qaMB[iM]!=qaMB[iM-1])
        #declare c2s3cM=c2s3cM+1;
      #end
    #end
  #local iM=iM+1;#end

  // c2s3cM now contains the number of edges
  // copy qaMA to c2s3aMA
  // copy qaMB to c2s3aMB
  // copy qaMF to c2s3aML and c2s3aMR

  #local qaMU=array[qcM];
  
  #declare c2s3aMA=array[c2s3cM];
  #declare c2s3aMB=array[c2s3cM];
  #declare c2s3aML=array[c2s3cM];
  #declare c2s3aMR=array[c2s3cM];

  #local iM=0;#while(iM<c2s3cM)
    #declare c2s3aML[iM]=-1;
    #declare c2s3aMR[iM]=-1;
  #local iM=iM+1;#end

  #local iMN=0;
  #local iM=0;#while(iM<qcM)
    #declare c2s3aMA[iMN]=qaMA[iM];
    #declare c2s3aMB[iMN]=qaMB[iM];
    #declare c2s3aML[iMN]=qaMF[iM];
    #local qaMU[iM]=iMN;
    #if(iM<qcM-1)
      #if(qaMA[iM]=qaMA[iM+1] & qaMB[iM]=qaMB[iM+1])
        #declare c2s3aMR[iMN]=qaMF[iM+1];
        #local iM=iM+1;
        #local qaMU[iM]=iMN;
      #end
    #end
    #local iMN=iMN+1;
  #local iM=iM+1;#end

  #if(iMN<c2s3cM)
    #error "Something wrong happened when building the edge arrays.\n"
  #end

  // build c2s3aFM from qaMA, qaMB, qaMF, and c2s3aFU
  // its size is not difficult to guess
  #declare c2s3aFM=array[dimension_size(c2s3aFU,1)]; // xyzzy
  //build an indexing array we'll only use here
  #local qaFI=array[c2s3cF];
  #local iR=0;
  #local iF=0;#while(iF<c2s3cF)
    #local qaFI[iF]=iR;
    #declare c2s3aFM[iR]=c2s3aFU[iR];
    #local iR=iR+c2s3aFU[iR]+1;
  #local iF=iF+1;#end

  #local iM=0;#while(iM<qcM)
    #local iF=qaMF[iM];
    #local iR=qaFI[iF];
    #local cU=c2s3aFM[iR];
    #local iR=iR+1;
    #local iI=0;#while(iI<cU)
      #local iJ=mod(iI+1,cU);
      #if( (c2s3aFU[iR+iI]=qaMA[iM] & c2s3aFU[iR+iJ]=qaMB[iM]) | (c2s3aFU[iR+iI]=qaMB[iM] & c2s3aFU[iR+iJ]=qaMA[iM]) )
        #declare c2s3aFM[iR+iI]
          =
        qaMU[iM];
      #end
    #local iI=iI+1;#end
  #local iM=iM+1;#end
  
  #undef qaMA
  #undef qaMB
  #undef qaMF
  #undef qaMU
  #undef qaFI
#end

// runs in O(1) time
#macro c2s3_DeleteEdges()
  #local fDel=false;
  #while(defined(c2s3cE)) #undef c2s3cE #local fDel=true; #end
  #while(defined(c2s3aEA)) #undef c2s3aEA #local fDel=true; #end
  #while(defined(c2s3aEB)) #undef c2s3aEB #local fDel=true; #end
  #while(defined(c2s3aES)) #undef c2s3aES #local fDel=true; #end
  #while(defined(c2s3aEL)) #undef c2s3aEL #local fDel=true; #end
  #while(defined(c2s3aER)) #undef c2s3aER #local fDel=true; #end
  #while(defined(c2s3aFE)) #undef c2s3aFE #local fDel=true; #end
  #if(fDel=true) #debug "Edge data deleted.\n" #end
#end

// runs in O(1) time
#macro c2s3_DeleteGeometry()
  c2s3_DeleteEdges()
  #local fDel=false;
  #while(defined(c2s3cV)) #undef c2s3cV #local fDel=true; #end
  #while(defined(c2s3aV)) #undef c2s3aV #local fDel=true; #end

  #while(defined(c2s3cF)) #undef c2s3cF #local fDel=true; #end
  #while(defined(c2s3aFV)) #undef c2s3aFV #local fDel=true; #end
  #if(fDel=true) #debug "Texturing mapping data deleted.\n" #end
#end

// runs in O(1) time
#macro c2s3_DeleteMapEdges()
  #local fDel=false;
  #while(defined(c2s3cM)) #undef c2s3cM #local fDel=true; #end
  #while(defined(c2s3aMA)) #undef c2s3aMA #local fDel=true; #end
  #while(defined(c2s3aMB)) #undef c2s3aMB #local fDel=true; #end
  #while(defined(c2s3aML)) #undef c2s3aML #local fDel=true; #end
  #while(defined(c2s3aMR)) #undef c2s3aMR #local fDel=true; #end
  #while(defined(c2s3aFM)) #undef c2s3aFM #local fDel=true; #end
  #if(fDel=true) #debug "Texture map borders deleted.\n" #end
#end

// runs in O(1) time
#macro c2s3_DeleteMapping()
  c2s3_DeleteMapEdges()
  #local fDel=false;
  #while(defined(c2s3aFU)) #undef c2s3aFU #local fDel=true; #end
  #while(defined(c2s3cU)) #undef c2s3cU #local fDel=true; #end
  #while(defined(c2s3aU)) #undef c2s3aU #local fDel=true; #end
  #if(fDel=true) #debug "Texture map vertices deleted.\n" #end
#end

#macro c2s3_DeleteNormals()
  #local fDel=false;
  #while(defined(c2s3cN)) #undef c2s3cN #local fDel=true; #end
  #while(defined(c2s3aN)) #undef c2s3aN #local fDel=true; #end

  #while(defined(c2s3aFN)) #undef c2s3aFN #local fDel=true; #end
  #if(fDel=true) #debug "Smoothing normals deleted.\n" #end
#end

// runs in O(1) time
#macro c2s3_DeleteTextures()
  #local fDel=false;
  #while(defined(c2s3aFT)) #undef c2s3aFT #local fDel=true; #end
  #if(fDel=true) #debug "Texturing data deleted.\n" #end
#end

// runs in O(N) time, N is number of faces and vertices
#macro c2s3_ImportBasicMesh(aV,aFV)

c2s3_DeleteGeometry()
c2s3_DeleteTextures()
c2s3_DeleteMapping()
c2s3_DeleteNormals()
c2s3_ResetFlags()

#declare c2s3cV=dimension_size(aV,1);
#declare c2s3aV=array[c2s3cV];
#local iI=0;#while(iI<c2s3cV)
  #declare c2s3aV[iI]=aV[iI];
#local iI=iI+1;#end

#local cT=dimension_size(aFV,1);
#declare c2s3aFV=array[cT];
#local iI=0;#while(iI<cT)
  #declare c2s3aFV[iI]=aFV[iI];
#local iI=iI+1;#end

#local cF=0;
#local iI=0;#while(iI<cT)
  #local cF=cF+1;
#local iI=iI+c2s3aFV[iI]+1;#end

#declare c2s3cF=cF;
// #declare c2s3fO=false;  //faces are not necessarily ordered, this is the default setting

// also, no index array exists, either
#while(defined(c2s3aFI)) #undef c2s3aFI #end

#end

#macro c2s3_ResetFlags()
  #while(defined(c2s3fO)) #undef c2s3fO #end
  #declare c2s3fO=false;  //faces are not necessarily ordered
#end

#macro c2s3_DumpData()
  #local iR=0;
  #local iF=0;#while(iF<c2s3cF)
    #debug concat("Face ",str(iF,0,0),":\n")

    #debug "  Uses vertices"
    #local cV=c2s3aFV[iR];
    #local iR=iR+1;
    #local iI=0;#while(iI<cV)
      #debug concat(" ",str(c2s3aFV[iR+iI],0,0))
    #local iI=iI+1;#end
    #debug "\n"

    #debug "  Uses edges"
    #local iI=0;#while(iI<cV)
      #debug concat(" ",str(c2s3aFE[iR+iI],0,0))
    #local iI=iI+1;#end
    #debug "\n"

    #local iR=iR+cV;
  #local iF=iF+1;#end

  #local iE=0;#while(iE<c2s3cE)
    #debug concat("Edge ",str(iE,0,0)," uses vertices ",str(c2s3aEA[iE],0,0)," and ",str(c2s3aEB[iE],0,0),"\n")
  #local iE=iE+1;#end
#end

#macro c2s3_JitterVertices(rS,sAmount)
  #local iV=0;#while(iV<c2s3cV)
    #declare c2s3aV[iV]=c2s3aV[iV] +
       <rand(rS)+rand(rS)+rand(rS)+rand(rS)+rand(rS)+rand(rS)
       +rand(rS)+rand(rS)+rand(rS)+rand(rS)+rand(rS)+rand(rS)-6,
        rand(rS)+rand(rS)+rand(rS)+rand(rS)+rand(rS)+rand(rS)
       +rand(rS)+rand(rS)+rand(rS)+rand(rS)+rand(rS)+rand(rS)-6,
        rand(rS)+rand(rS)+rand(rS)+rand(rS)+rand(rS)+rand(rS)
       +rand(rS)+rand(rS)+rand(rS)+rand(rS)+rand(rS)+rand(rS)-6>*sAmount;
  #local iV=iV+1;#end
#end

#macro c2s3_NukeData()

c2s3_DeleteNormals()
c2s3_DeleteMapping()
c2s3_DeleteTextures()
c2s3_DeleteGeometry()
c2s3_ResetFlags()
#end

#end