// the macros for dealing with normals
#ifndef(C2S3_NOR_INC)
#declare C2S3_NOR_INC = true;

// runs in O(N) time, N= number of edges
#macro c2s3_BuildNormals()
  #if(c2s3fO=false) c2s3_OrientFaces() #end
  #while(defined(c2s3aN)) #undef c2s3aN #end
  #debug "Building normals.\n"
  #ifndef(c2s3aFI) c2s3_BuildIndexArray() #end
  
  #local qcN=dimension_size(c2s3aFV,1)-c2s3cF;
  #local qaNF=array[qcN];
  #declare c2s3aFN=array[dimension_size(c2s3aFV,1)];

// initial normal assignment
  #local iN=0;
  #local iI=0;#while(iI<dimension_size(c2s3aFV,1))
    #local cV=c2s3aFV[iI];
    #declare c2s3aFN[iI]=cV;
    #local iI=iI+1;
    #local iV=0;#while(iV<cV)
      #declare c2s3aFN[iI+iV]=iN;
      #local iN=iN+1;
    #local iV=iV+1;#end
  #local iI=iI+cV;#end

// each normal will originally feed only into itself
  #local iN=0;#while(iN<qcN)
    #local qaNF[iN]=iN;
  #local iN=iN+1;#end

// go through each edge; if edge is smooth, combine the normals by having
// the ultimate destination of one normal feed to the other;

  #local iE=0;#while(iE<c2s3cE)
    #if(c2s3aES[iE]=0) // smooth edge only check
      #local iFL=c2s3aEL[iE];
      #local iFR=c2s3aER[iE];
      #if(iFL>-1 & iFR>-1) // interior edge only check
// get indices into face arrays
        #local iRL=c2s3aFI[iFL];
        #local cVL=c2s3aFV[iRL];
        #local iRL=iRL+1;
        #local iRR=c2s3aFI[iFR];
        #local cVR=c2s3aFV[iRR];
        #local iRR=iRR+1;
// process first vertex
        #local iV=c2s3aEA[iE];
        #local iI=0;#while(iI<cVL)
          #if(iV=c2s3aFV[iRL+iI])
            #local iNL=c2s3aFN[iRL+iI];
          #end
        #local iI=iI+1;#end
        #local iI=0;#while(iI<cVR)
          #if(iV=c2s3aFV[iRR+iI])
            #local iNR=c2s3aFN[iRR+iI];
          #end
        #local iI=iI+1;#end
        #while(iNL!=qaNF[iNL]) #local iNL=qaNF[iNL]; #end
        #while(iNR!=qaNF[iNR]) #local iNR=qaNF[iNR]; #end
        #local qaNF[iNL]=min(iNL,iNR);
        #local qaNF[iNR]=min(iNL,iNR);
// process second vertex
        #local iV=c2s3aEB[iE];
        #local iI=0;#while(iI<cVL)
          #if(iV=c2s3aFV[iRL+iI])
            #local iNL=c2s3aFN[iRL+iI];
          #end
        #local iI=iI+1;#end
        #local iI=0;#while(iI<cVR)
          #if(iV=c2s3aFV[iRR+iI])
            #local iNR=c2s3aFN[iRR+iI];
          #end
        #local iI=iI+1;#end
        #while(iNL!=qaNF[iNL]) #local iNL=qaNF[iNL]; #end
        #while(iNR!=qaNF[iNR]) #local iNR=qaNF[iNR]; #end
        #local qaNF[iNL]=min(iNL,iNR);
        #local qaNF[iNR]=min(iNL,iNR);
      #end // end of interior edge only check
    #end // end of smooth edge only check
  #local iE=iE+1;#end

// set up the array for doing replacements
  #local qaNU=array[qcN];

// count the number of unique normals (ones that feed into themselves)
// and point the starting numbers to the renumbered normals
  #declare c2s3cN=0;
  #local iN=0;#while(iN<qcN)
    #if(qaNF[iN]=iN)
      #local qaNU[iN]=c2s3cN;
      #declare c2s3cN=c2s3cN+1;
    #end
  #local iN=iN+1;#end

  #local iR=0;
  #local iF=0;#while(iF<c2s3cF)
    #local cV=c2s3aFN[iR];
    #local iR=iR+1;
    #local iI=0;#while(iI<cV)
      #local iN=c2s3aFN[iR+iI];
      #while(iN!=qaNF[iN]) #local iN=qaNF[iN]; #end
      #declare c2s3aFN[iR+iI]=qaNU[iN];
    #local iI=iI+1;#end
    #local iR=iR+cV;
  #local iF=iF+1;#end
#end // end of c2s3_BuildNormals() macro

#macro c2s3_BuildIndexArray()
  #declare c2s3aFI=array[c2s3cF];
  #local iR=0;
  #local iF=0;#while(iF<c2s3cF)
    #declare c2s3aFI[iF]=iR;
    #local cV=c2s3aFV[iR];
    #local iR=iR+1+cV;
  #local iF=iF+1;#end
#end // of c2s3_BuildIndexArray()

#macro c2s3_BuildMapIndexArray()
  #declare c2s3aFJ=array[c2s3cF];
  #local iR=0;
  #local iF=0;#while(iF<c2s3cF)
    #declare c2s3aFJ[iF]=iR;
    #local cU=c2s3aFU[iR];
    #local iR=iR+1+cU;
  #local iF=iF+1;#end
#end // of c2s3_BuildIndexArray()

#macro c2s3_OrientFaces()
  #debug "Orienting faces.\n"
  #ifndef(c2s3cE) c2s3_BuildEdges() #end
  #ifdef(c2s3cU)
    #ifndef(c2s3cM) c2s3_BuildMapEdges() #end
  #end
  #ifndef(c2s3aFI) c2s3_BuildIndexArray() #end

//  #local qaEP=array[c2s3cE];
  #local qaFP=array[c2s3cF];
//  #local iE=0;#while(iE<c2s3cE)
//    #local qaEP[iE]=false;
//  #local iE=iE+1;#end
  #local iF=0;#while(iF<c2s3cF)
    #local qaFP[iF]=0;
  #local iF=iF+1;#end

//  #local cFP=0;

  #local fRepeat1=true;
  #while(fRepeat1)
    #local fRepeat1=false;
// find the unprocessed face that is farthest from the origin
    #local sD=0;
    #local iFF=-1;
    #local iF=0;#while(iF<c2s3cF)
      #if(qaFP[iF]=0)
        #local iR=c2s3aFI[iF];
        #local cV=c2s3aFV[iR];
        #local iR=iR+1;
        #local vX=<0,0,0>;
        #local vY=<0,0,0>;
        #local iI=0;#while(iI<cV)
          #local pV=c2s3aV[c2s3aFV[iR+iI]];
          #local vX=vX+pV*cos(2*pi*iI/cV);
          #local vY=vY+pV*sin(2*pi*iI/cV);
        #local iI=iI+1;#end // of (iI<cV)
        #local sQ=vdot(vnormalize(vcross(vX,vY)),pV);
        #if( abs(sQ) > abs(sD) | iFF<0 )
          #local sD=sQ;
          #local iFF=iF;
        #end
      #end // of (qaFP[iF]=false)
    #local iF=iF+1;#end // of (iF<c2s3cF) loop

    #if(iFF>=0)
//      #debug "Seeding...\n"
      #local qaFP[iFF]=1;
      #local fRepeat1=true;
//      #local cFP=cFP+1;
      #if(sD<0)
        c2s3_ReverseWinding(iFF)
//        #debug concat("Reversing face ",str(iFF,0,0),".\n")
        #declare c2s3aFT[iFF]=-1;
      #end // of (sD<0) check
    #end // of (iFF>0) check

    #if(fRepeat1) // there is processing to be done
      #local fRepeat2=true;
      #while(fRepeat2)
        #local fRepeat2=false;
//        #debug "Looping...\n"
        #local iE=0;#while(iE<c2s3cE)
          #local iFL=c2s3aEL[iE];
          #local iFR=c2s3aER[iE];
          #if(iFL>=0 & iFR>=0)
            #if(qaFP[iFL]+qaFP[iFR]=1)
              #if(qaFP[iFL]=0)
                #local qF=iFL;
                #local iFL=iFR;
                #local iFR=qF;
              #end // of (qaFP[iFL]=0) check
              #local iEL=-1;
              #local iRL=c2s3aFI[iFL];
              #local cE=c2s3aFE[iRL];
              #local iRL=iRL+1;
              #local iI=0;#while(iI<cE)
                #if(c2s3aFE[iRL+iI]=iE) #local iEL=iI; #end
              #local iI=iI+1;#end // of (iI<cE) loop
//              #if(iEL<0) #debug "Serious internal integrity error found.\n" #end

              #local iER=-1;
              #local iRR=c2s3aFI[iFR];
              #local cE=c2s3aFE[iRR];
              #local iRR=iRR+1;
              #local iI=0;#while(iI<cE)
                #if(c2s3aFE[iRR+iI]=iE) #local iER=iI; #end
              #local iI=iI+1;#end // of (iI<cE) loop
//              #if(iER<0) #debug "Serious internal integrity error found.\n" #end
              
              #if(c2s3aFV[iRL+iEL]=c2s3aFV[iRR+iER])
                c2s3_ReverseWinding(iFR)
//              #debug concat("Reversing face #",str(iFR,0,0),".\n")
              #end // of (c2s3aFV[iRL+iEL]=c2s3aFV[iRR+iER]) check
              #local qaFP[iFR]=1;
              #local fRepeat2=true;
            #end // of (qaFP[iFL]+qaFP[iFR]=2) check
          #end // of (iFL>=0 & iFR>=0 check)
        #local iE=iE+1;#end // of (iE<c2s3cE) loop
      #end // of while(fRepeat2) loop
    #end // of if(fRepeat1) check
  #end // of (fRepeat1) loop
//  #local iF=0;#while(iF<c2s3cF)
//    #if(qaFP[iF]=0)
//      #debug concat("Face #",str(iF,0,0)," not processed.\n")
//    #end
//  #local iF=iF+1;#end
      
// for each face
// if the face is flagged
  #declare c2s3fO=true; // faces are now ordered
#end // of c2s3_OrientFaces() macro

#macro c2s3_CalcNormals()
  #ifndef(c2s3aFN) c2s3_BuildNormals() #end
  #debug "Calculating normals.\n"

  #declare c2s3cN=0;
  #local iR=0;
  #local iF=0;#while(iF<c2s3cF)
    #local cV=c2s3aFN[iR];
    #local iR=iR+1;
    #local iI=0;#while(iI<cV)
      #declare c2s3cN=max(c2s3cN,c2s3aFN[iR+iI]);
    #local iI=iI+1;#end
    #local iR=iR+cV;
  #local iF=iF+1;#end

  #declare c2s3cN=c2s3cN+1;
  
  #declare c2s3aN=array[c2s3cN];
  #local iN=0;#while(iN<c2s3cN)
    #declare c2s3aN[iN]=<0,0,0>;
  #local iN=iN+1;#end
  
  #local iR=0;
  #local iF=0;#while(iF<c2s3cF)
    #local cV=c2s3aFV[iR];
    #local iR=iR+1;
    #local vX=<0,0,0>;
    #local vY=<0,0,0>;
    #local iI=0;#while(iI<cV)
      #local pV=c2s3aV[c2s3aFV[iR+iI]];
      #local vX=vX+pV*cos(2*pi*iI/cV);
      #local vY=vY+pV*sin(2*pi*iI/cV);
    #local iI=iI+1;#end
    #local vN=vnormalize(vcross(vX,vY));
    #local iI=0;#while(iI<cV)
      #local iN=c2s3aFN[iR+iI];
      #declare c2s3aN[iN]=c2s3aN[iN]+vN;
    #local iI=iI+1;#end
    #local iR=iR+cV;
  #local iF=iF+1;#end
#end

#macro c2s3_OtherSide(iE,iF)
  #if(c2s3aEL[iE]=iF)
    #local qF=c2s3aER[iE];
  #else
    #local qF=c2s3aEL[iE];
  #end
  (qF)
#end // of c2s3_OtherSide() macro

#macro c2s3_ReverseWinding(iF)
  #ifndef(c2s3aFE) c2s3_BuildEdges() #end
  #ifndef(c2s3aFI) c2s3_BuildIndexArray() #end

  #local iR=c2s3aFI[iF];
  #local cV=c2s3aFV[iR];
  #local iR=iR+1;
  #local iI=1;#while(iI<cV/2)
    #local qV=c2s3aFV[iR+iI];
    #declare c2s3aFV[iR+iI]=c2s3aFV[iR+cV-iI];
    #declare c2s3aFV[iR+cV-iI]=qV;
    #ifdef(c2s3aFN)
      #local qI=c2s3aFN[iR+iI];
      #declare c2s3aFN[iR+iI]=c2s3aFN[iR+cV-iI];
      #declare c2s3aFN[iR+cV-iI]=qI;
    #end
  #local iI=iI+1;#end
  #ifdef(c2s3aFE)
    #local iI=0;#while(iI<(cV-1)/2)
      #local qE=c2s3aFE[iR+iI];
      #declare c2s3aFE[iR+iI]=c2s3aFE[iR+cV-iI-1];
      #declare c2s3aFE[iR+cV-iI-1]=qE;
    #local iI=iI+1;#end
  #end
  #ifdef(c2s3cU) // texture-mapping is defined
    #ifndef(c2s3aFJ) c2s3_BuildMapIndexArray() #end
    #local iR=c2s3aFJ[iF];
    #local cU=c2s3aFU[iR];
    #if(cU>0)
      #local iR=iR+1;
      #local iI=1;#while(iI<cU/2)
        #local qU=c2s3aFU[iR+iI];
        #declare c2s3aFU[iR+iI]=c2s3aFU[iR+cU-iI];
        #declare c2s3aFU[iR+cU-iI]=qU;
      #local iI=iI+1;#end
      #local iI=0;#while(iI<(cU-1)/2)
        #local qM=c2s3aFM[iR+iI];
        #declare c2s3aFM[iR+iI]=c2s3aFM[iR+cU-iI-1];
        #declare c2s3aFM[iR+cV-iI-1]=qM;
      #local iI=iI+1;#end
    #end
  #end // of #ifdef(c2s3cU) block
#end // end of c2s3_ReverseWinding() macro

#end // #ifdef(C2S3_NOR_INC)
