//*************************************************************************************
// File creating a CSG ashtray object
//*************************************************************************************

#ifndef(AshTray_Included)
	#declare AshTray_Included=true;
	
	#include "Colors.inc"

	#ifdef(View_POV_Include_Stack)
	#   debug "including AshTray.inc\n"
	#end

//*************************************************************************************
// Polar array macro
#macro polar_array(Object,Axis,Count)
  #local i=0;
  union{  
    #while (i<Count)
      object{
        Object 
        #if(strcmp(Axis,"y")=0)
          rotate <0,i*(360/Count),0>
        #end
        #if(strcmp(Axis,"x")=0)
          rotate <i*(360/Count),0,0>
        #end
        #if(strcmp(Axis,"z")=0)
          rotate <0,0,i*(360/Count)>
        #end      
      }     
      #local i=i+1;
    #end
  }
#end

//*************************************************************************************
// Cylinder macro 
#macro Cylinder(Axis, Length, Radius, Color)
    cylinder{
      <0,0,0>
      <0,1,0>
      Radius
      pigment{Color}
      scale <1,Length,1>
      #if (strcmp(Axis,"x")=0)
        rotate <0,0,-90>     
      #end
      #if (strcmp(Axis,"z")=0)
        rotate <90,0,0>        
      #end
    }
#end

//*************************************************************************************
// The ashtray with cigarette CSG object

#declare cig_hole=object{Cylinder("x",1,0.1,White)translate<0,0.3,0>}

#declare AshTrayWCigarette=union{
  // The ashtray
  difference
  {
    difference{
      Cylinder("y",0.3,1,White)
      object{Cylinder("y",0.3,0.9 ,White)translate <0,0.1,0>}
    }
    polar_array(cig_hole,"y",4)  
    translate <0,-1,0>
  }
  // The cigarette
  union{
    Cylinder("x",1.4,0.09,White)
    object{Cylinder("x",0.4,0.095,Orange)translate<1.2,0,0>}
    rotate<0,0,7>
    translate<0.2,-0.79,0>    
  }
  rotate y*35
}

//****************************************************************************************************************************************
#end // end #ifdef(AshTray_Included)
// EOF