//*********************************************************************************
//*********************************************************************************
//
// SmokeGen version 1.2(M) by Mikael Carneholm, UCB
// April 2000
//
//*********************************************************************************
//*********************************************************************************
//
// New (Since v1.0): 
//			SceneStartClock and Pulverization implemented.
//     (Since v1.1): 
//			Rewritten structure with #macro:s
// 			SourceID (unlimited number of smoke sources) 
//			Centrifugal force simulation
//			"SmokeDancing" implemented (sin() based transformation)
//			Elapsed time simulation implemented
//			PreviewMode2 implemented
//			Debugging works differently
// 			MinSamples implemented
//			Some name changes:
//				Pulverization -> Roughness, 
//				SmokeColor1&2 -> Main&Secondary, 
//				MxTrLvl -> TraceLevel)
//	(Since v1.2):	Changed names on some variables to be compatible with MegaPov
//			
//
//*********************************************************************************
//*********************************************************************************
// TABSIZE: 2

#ifdef(View_POV_Include_Stack)
  #debug "including SmokeGen.inc\n"
#end

//---------------------------------------------------------------------------------
#macro IfDebug(aString)
  #ifdef(Debugging)
    #if(Debugging)
      #debug aString
    #end
  #end
#end

//---------------------------------------------------------------------------------
// Does the debugging to the message window and defines defaults
#macro SetDefaults()

	#ifndef(Debugging)
		#declare Debugging=true;
	#end
		
	#ifndef(DoNotWriteEmptyLine)		
    #if(Debugging)
      #debug "\n*SmokeGen is echoing to the message window as Debugging is on (default)*\n"
    #end		
    #declare DoNotWriteEmptyLine=1;
	#end
	
	#ifndef(obj_pos)
	  #debug "\nNo new smoke elements added.\n"
	#end
	
	#ifndef(SourceID)   		
		 #if(Debugging)
		    #debug "SourceID is not declared. Assuming only one source is used (source1)\n"
		 #end		
		#declare SourceID=1;
	#end
	
	#ifndef(SceneStartClock)
		 #if(Debugging)
		    #debug "SceneStartClock is not declared. Using default value of 0.\n"
		 #end
		#declare SceneStartClock=0;
	#end                                               
	
	#ifndef(PreviewMode)
		 #if(Debugging)
			#debug concat("PreviewMode is not declared for source ",str(SourceID,0,0),". ","Using PreviewMode 0.\n")
		 #end
		#declare PreviewMode=0;
	#end                                               

	#ifndef(SmokeDens)
		#if(Debugging)
			#debug concat("SmokeDens is not declared for source ",str(SourceID,0,0),". ","Using default value of 1.\n")
		#end
		#declare SmokeDens=1;
	#end                                               
	
	#ifndef(InitialSize)
		 #if(Debugging)
			#debug concat("InitialSize is not declared for source ",str(SourceID,0,0),". ","Using default value of 0.5.\n")
		 #end
	   #declare InitialSize=0.5;
	#end                                                                  
	
	#ifndef(MaxSizeInc)
		 #if(Debugging)
	        #debug concat("MaxSizeInc is not declared for source ",str(SourceID,0,0),". ","Using default value of 0.\n")
		 #end
	   #declare MaxSizeInc=0;
	#end
	
	#ifndef(InitEmiss)
		 #if(Debugging)
	        #debug concat("InitEmiss is not declared for source ",str(SourceID,0,0),". ","Using default value of 1.0.\n")
		 #end
	   #declare InitEmiss=1.0;
	#end
	
	#ifndef(MinEmiss)
		 #if(Debugging)
			#debug concat("MinEmiss is not declared for source ",str(SourceID,0,0),". ","Using default value of 0.\n")
		 #end
	   #declare MinEmiss=0;
	#end
	
	#ifndef(MaxEmiss)
		 #if(Debugging)
			#debug concat("MaxEmiss is not declared for source ",str(SourceID,0,0),". ","Using default value of 10.","\n")
		 #end
	   #declare MaxEmiss=10;
	#end
	
	#ifndef(Trend)
		#if(Debugging)
			#debug concat("Trend is not declared for source ",str(SourceID,0,0),". ","Using default value of 0","\n")
		#end
		#declare Trend=0;	
	#end
	
	#ifndef(MainColor)
		#if(Debugging)
			#debug concat("MainColor is not declared for source ",str(SourceID,0,0),". ","Using default value of <1,1,1>.","\n")
		#end
		#declare MainColor=<1,1,1>;
	#end	
	
	#ifndef(SecondaryColor)
		#if(Debugging)
			#debug concat("SecondaryColor is not declared for source ",str(SourceID,0,0),". ","Using default value of <0,0,0>.","\n")
	 	#end			
		#declare SecondaryColor=<0,0,0>;   	
	#end	
	
	#ifndef(Roughness)
		#if(Debugging)
			#debug concat("Roughness is not declared for source ",str(SourceID,0,0),". ","Using default value of 1","\n")
		#end
		#declare Roughness=1;	
	#end
	
	#ifndef(SmokeDelay)
		 #if(Debugging)
			#debug concat("SmokeDelay is not declared for source ",str(SourceID,0,0),". ","Using default value of 0.","\n")
		 #end
	   #declare SmokeDelay=0;
	#end          
	
	#ifndef(ConstAscendRate)
		 #if(Debugging)
			#debug concat("ConstAscendRate is not declared for source ",str(SourceID,0,0),". ","Using default value of 0.","\n")
		 #end
	   #declare ConstAscendRate=0;
	#end
	
	#ifndef(MaxRandAscend)
		 #if(Debugging)
			#debug concat("MaxRandAscend is not declared for source ",str(SourceID,0,0),". ","Using default value of 0.","\n")
		 #end
	   #declare MaxRandAscend=0;
	#end
	
	#ifndef(WindDir)
		 #if(Debugging)
			#debug concat("WindDir is not declared for source ",str(SourceID,0,0),". ","Using default value of <0,0,0>","\n")
		 #end
	   #declare WindDir=<0,0,0>;
	#end
	
	#ifndef(WindStrength)
		 #if(Debugging)
			#debug concat("WindStrength is not declared for source ",str(SourceID,0,0),". ","Using default value of 0. \n (Declared wind for source ",str(SourceID,0,0)," does not have effect).","\n")
		 #end
	   #declare WindStrength=0;
	#end
	
	#ifndef(DanceStrength)
	  #declare DanceStrength=0;
		 #if(Debugging)
			#debug concat("DanceStrength is not declared for source ",str(SourceID,0,0),". ","Using default value of 0.\n")
		 #end	  
	#end
	
	#ifndef(ConstRotation)
		 #if(Debugging)
			#debug concat("ConstRotation is not declared for source ",str(SourceID,0,0),". ","Using default value of 0.","\n")
		 #end
	   #declare ConstRotation=0;
	#end
	
	#ifndef(MaxRandRot)
		#if(Debugging)
			#debug concat("MaxRandRot is not declared for source ",str(SourceID,0,0),". ","Using default value of 0.","\n")
		#end
		#declare MaxRandRot=0;
	#end
	
	#ifndef(StartTurb)
		#if(Debugging)
			#debug concat("StartTurb is not declared for source ",str(SourceID,0,0),". ","Using default value of 3.5.","\n")
		#end
		#declare StartTurb=3.5;
	#end
	
	#ifndef(TurbIncRate)
		#if(Debugging)
			#debug concat("TurbIncRate is not declared for source ",str(SourceID,0,0),". ","Using default value of 0","\n")		
		#end
		#declare TurbIncRate=0;
	#end
	
	#ifndef(TraceLevel)
		#if(Debugging)
			#debug "TraceLevel is not declared. Using default value of 100.\n"
		#end
		#declare TraceLevel=100;
	#end
	
	#ifndef(CastShadows)
		#if(Debugging)
			#debug concat("CastShadows is not declared for source ",str(SourceID,0,0),". ","Using default value of CastShadows=1.","\n")
		#end
		#declare CastShadows=1;                    
	#end
#end // #macro Debug


//---------------------------------------------------------------------------------
// Creates an error if one or more parameters are incorrectly declared. 
// Global variables are also defined here.

#macro CheckParams()
 	#ifdef(Roughness)
 		#if(Roughness>=11)
 			#error "Message from SmokeGen: Roughness must not greater or equal to 11." 			
 		#end	
 	#end
 	
 	// To avoid multiple printouts in SimulateElapsedTime
 	#declare NotDoneYet=true; 	
 	
#end


//---------------------------------------------------------------------------------
// Re-writes the element file If this frame is the first in a series 
// (or creates the file if it doesnt exist).

#macro CreateFileIfNewSession()	
	#if(clock=SceneStartClock)
		#fopen LmntFile concat("source",str(SourceID,0,0),".txt") write
		#fclose LmntFile
	#else
		#fopen LmntFile concat("source",str(SourceID,0,0),".txt") append		
		#fclose LmntFile							
	#end
#end // #macro EraseFileIfNewSession()


//---------------------------------------------------------------------------------
// Adds a new element at the obj_pos position

#macro AddElement()
  #ifdef(obj_pos)
  	#fopen LmntFile concat("source",str(SourceID,0,0),".txt") append			
  	#local tempint=1;	
      #write (LmntFile,tempint,", ",obj_pos,", ",InitialSize,", ","<0,0,0>",", ","0",", ",StartTurb,", ",InitEmiss,", ")
  	#fclose LmntFile
  #end
#end // #macro AddElement()

//---------------------------------------------------------------------------------
// Adds a new element at the obj_pos position
#macro AddElement_nofile()
  #ifdef(obj_pos)
		#declare PositionArray[number_of_elements]=obj_pos;				
		#declare SizeArray[number_of_elements]=InitialSize;
		#declare VectorArray[number_of_elements]=<0,0,0>;
		#declare DegRotArray[number_of_elements]=0;
		#declare TurbArray[number_of_elements]=StartTurb;
		#declare EmissArray[number_of_elements]=InitEmiss;		  			  	
  #end
#end // #macro AddElement()        
         

//---------------------------------------------------------------------------------
// Counts the number of elements 
// (Declares the variable number_of_elements)
// NOTE: This is critical - must be done at an early stage
#macro CountTheElements()
	#declare number_of_elements=0;	
	#fopen LmntFile concat("source",str(SourceID,0,0),".txt") read
		#declare FileIsOpen=true;
			#while (FileIsOpen)
				#read (LmntFile,ecount,e_position,e_size,unitvector,rot_degrees,turbulens,opacity)	// Reading all values is necessary to make the counting algorithm work.
				#ifdef(LmntFile)
				    #declare number_of_elements=number_of_elements+1;
				#else						
					#declare FileIsOpen=false;
				#end
			#end
	#fclose LmntFile	
	#undef FileIsOpen
#end // #macro CountTheElements()

//---------------------------------------------------------------------------------
// Creates the separate arrays
#macro CreateTheArrays(dimension)
  #if(number_of_elements+dimension>0)    
    #declare PositionArray=array[number_of_elements+dimension]	// Holds the positions of the elements
    #declare SizeArray=array[number_of_elements+dimension]		// Holds the size of the elements
    #declare VectorArray=array[number_of_elements+dimension]		// Holds the different unit vectors
    #declare DegRotArray=array[number_of_elements+dimension]		// Holds the amount that the different elements have rotated so far
    #declare TurbArray=array[number_of_elements+dimension] 		// Holds the turbulence of the elements
    #declare EmissArray=array[number_of_elements+dimension] 		// Holds the emission of the elements   	
  #end
#end // #macro CreateTheArrays()   

//---------------------------------------------------------------------------------
// Opens the file and reads the values into the corresponding arrays
#macro ReadInAllElements()
	#declare lmntcounter=0;			
	#fopen LmntFile concat("source",str(SourceID,0,0),".txt") read					
		#while(lmntcounter<number_of_elements)				
			#read (LmntFile,ecount,e_position,e_size,unitvector,rot_degrees,turbulens,opacity) // the actual reading	
			#declare PositionArray[lmntcounter]=e_position;				
			#declare SizeArray[lmntcounter]=e_size;
			#declare VectorArray[lmntcounter]=unitvector;
			#declare DegRotArray[lmntcounter]=rot_degrees;
			#declare TurbArray[lmntcounter]=turbulens;
			#declare EmissArray[lmntcounter]=opacity;
			#declare lmntcounter=lmntcounter+1;
		#end
	#fclose LmntFile
#end // #macro ReadInAllElements()

//---------------------------------------------------------------------------------
// The centrifugal effect
#macro AffectWithEffects()
	#ifdef(CenterOfRotation)
		#ifdef(SmokeMass)
			#if(number_of_elements>1)
				#declare lmntcounter=0;
				#while(lmntcounter<(number_of_elements-1))					
					#local fScalProd=vdot(PositionArray[lmntcounter]-CenterOfRotation,PositionArray[lmntcounter+1]-CenterOfRotation);
					#local fVlengthA=vlength(PositionArray[lmntcounter]-CenterOfRotation);
					#local fVlengthB=vlength(PositionArray[lmntcounter+1]-CenterOfRotation);
					#declare fAngle=180/pi*acos(fScalProd/(fVlengthA*fVlengthB));
					//#debug concat(str(fAngle,0,2),"\n")
					#local fUnitDistance=vnormalize(PositionArray[lmntcounter]-CenterOfRotation);
					#declare PositionArray[lmntcounter]=PositionArray[lmntcounter]+fUnitDistance*SmokeMass*(fAngle/45);						
					#declare lmntcounter=lmntcounter+1;
				#end
			#end
		#else
		#if(Debugging & NotDoneYet)
			#debug "SmokeMass is not declared. Centrifugal force simulation will not work.\n"		
			#declare NotDoneYet=false;
		#end		
		#end		
	#else
		#if(Debugging & NotDoneYet)
			#debug "CenterOfRotation is not declared. Centrifugal force simulation will not work.\n"		
			#declare NotDoneYet=false;
		#end
	#end
#end // end #macro AffectWithEffects

//---------------------------------------------------------------------------------
// Create spheres and fill with media alt. give pigment
#ifndef(TrailObject)
  #macro TrailObject(Size,TurbValue,EmissValue,Mode)
    #local PreviewSize=(Size+TurbValue)/8;  
    
    #ifndef(MinSamples)
    	#declare MinSamples=1;
    #end
    
  	#if(EmissValue<0)								// To prevent from negative emission
  		#declare EmissValue=0;
  	#end
    
  	sphere{
  		<0, 0, 0> 
  	 	1						// scaled at the end
  	 	#switch(Mode)
  		  #case(0)  // 0 = "real" media
    	  	#if(CastShadows)
    				pigment { color rgbf <1, 1, 1, 1>}     			
    		  #else                          		
    		    pigment { color rgbt <1, 1, 1, 1> }	  	    			
    	  	#end
    			hollow
    			interior{
    				media{		      
    				  #if(MainColor.x > 0 | MainColor.y > 0 | MainColor.z > 0 )
    					  emission rgb EmissValue*MainColor
    					#end
    				  absorption rgb EmissValue*MainColor // To make the smoke cast shadows
    				  //intervals (11-Roughness)	// New to v1.1  commented out for default method 3 (TdG)
    				  intervals 1
    				  samples MinSamples//, 10				
    				  //confidence 0.9
    				  //variance 1/1000
    					density{
    						spherical
    						ramp_wave		// possibly: implement "SType
    						turbulence TurbValue octaves 6 lambda 4 omega 0.3
    						color_map{ 			// possibly: #ifdef ClrMap #include "smokecolorX.map"
    					    [0.0 color rgb SecondaryColor]
    							[1.0 color rgb MainColor]								
    						}					
    					}								
    					scale 0.5//-3*(Size/10) 					
    				} // media				
    			} // interior
    		#break // case(0)		  		
  		  #case(1) // 1 = "wireframe" mode
      		// REM: []Lines[2] is "normal mode", i.e when smoke fades after x amount of time
      		#if(InitEmiss>1 & Trend<0)	// i.e if you dont want the emission to increase freely, running in "visible-to-faded" mode
      			#declare scalefactor=1/InitEmiss;	  			
      		  #else
      			#declare scalefactor=1;
      		#end  		  		
      		//*************************************************************************************
      		#macro GradientPigment1(axis)
    			pigment{
    				gradient axis
    				color_map{
            	[ 0.02 rgbt <MainColor.x, MainColor.y, MainColor.z, InitEmiss-EmissValue>]
            	[ 0.02 rgbt <1,1,1,1> ]
            	[ 1.00 rgbt <1,1,1,1> ]
    	      }
    			}					  			
      		#end	  		
      		//*************************************************************************************
      		#macro GradientPigment2(axis)
    			pigment{
    				gradient axis
    				color_map{
            	[ 0.02 rgbt <MainColor.x, MainColor.y, MainColor.z, 1-(scalefactor*EmissValue)> ]
            	[ 0.02 rgbt <1,1,1,1> ]
            	[ 1.00 rgbt <1,1,1,1> ]
    	      }		            
    			}					  			
      		#end
      		//*************************************************************************************  		
    			
    			#declare XLines1 = texture{GradientPigment1(x)}	
    			#declare XLines2 = texture{
    				GradientPigment2(x)	
    				//finish{ambient MainColor*0.5}
    			}	
    			
    			#declare YLines1 = texture{GradientPigment1(y)}				
    			#declare YLines2 = texture{
    				GradientPigment1(y)				
    				//finish{ambient MainColor*0.5}
    			}				
    			
    			#declare ZLines1 = texture{GradientPigment1(z)}   
    			#declare ZLines2 = texture{
    				GradientPigment1(z)	
    				//finish{ambient MainColor*0.5}
    			}
    
    	    #if(Trend>0)
    			 	texture{XLines1}
    			 	texture{YLines1}
    			 	texture{ZLines1}
    		  #else
    				texture{XLines2}
    			 	texture{YLines2}
    				texture{ZLines2}			   
    		  #end
    		  
    		  scale PreviewSize  // To make pmode2 equally large as pmode0
    		  
    		  hollow   // may prevent povray from crashing if camera is inside an element		  		  
  		  
  	    #break  // case(1)  	  
        #case(2)          
      		#if(Trend<0)  	  			
      			#declare scalefactor=(1/InitEmiss)/1;
      		  #else
      			#declare scalefactor=1;
      		#end      		
      		#local mltply=1;  //original: 2
    	    #if(Trend>0)
    	    	pigment{color rgbt <mltply*MainColor.x, mltply*MainColor.y, mltply*MainColor.z, 1-(SmokeDens*EmissValue*0.1)>}
    		  #else
    				//pigment{color rgbt <mltply*MainColor.x, mltply*MainColor.y, mltply*MainColor.z, 1-(scalefactor*EmissValue)>} // orginal neg.trend
    				pigment{color rgbt <mltply*MainColor.x, mltply*MainColor.y, mltply*MainColor.z, 1-(SmokeDens*EmissValue*0.1)>}
    			#end	  			    				    			
    			scale PreviewSize  // To make pmode2 equally large as pmode0      
        	hollow	    	      
        #break  // case(2)
      #end // switch
      
      scale Size/2
  	
  	} // sphere
  	
  #end // end #macro TrailObject(Size,TurbValue,EmissValue)
#end // ifndef TrailObject()
//----------------------------------------------------------------------------------------------------------------------------------------
// Creates the POV-Ray objects (spheres) 
#macro CreatePovRayObjects()
  #declare Seed=array[10] 
	#declare Seed[0]=rand(seed(12345));
	#declare Seed[1]=rand(seed(54321));
	#declare Seed[2]=rand(seed(11111));
	#declare Seed[3]=rand(seed(33333));
	#declare Seed[4]=rand(seed(77777));
	#declare Seed[5]=rand(seed(99999));
	#declare Seed[6]=rand(seed(13131));
	#declare Seed[7]=rand(seed(17171));
	#declare Seed[8]=rand(seed(19191));
	#declare Seed[9]=rand(seed(31313));
		
	#declare r1=seed(54321);   // Initializes a pseudo-random stream and names it "r1".
	#declare i=0;	
	
	#while(i<number_of_elements)	// for all elements:	  
		#if((number_of_elements>=SmokeDelay) & (i>=SmokeDelay)) // ..if we passed the delay...		
				#ifdef(TrailLength) // If in "cut-off-the-trail-mode"
					 #if(i>=(number_of_elements-TrailLength))	// If its time to start using the elements
							#if(EmissArray[i]>0)	// eliminates invisible elements
							  #declare k=1;
							  #while(k<SmokeDens+1)							    							  
									object{  									  
										TrailObject(SizeArray[i], TurbArray[i],EmissArray[i],PreviewMode)
										#ifndef(dont_random_rotate)
										  rotate <360*rand(Seed[k-1]),360*rand(Seed[k-1]),360*rand(Seed[k-1])>
										#end
										#ifdef(ConstRotation)
											rotate VectorArray[i]*DegRotArray[i]
										#end				
										#if(SmokeDelay=0)
											translate PositionArray[i]	// If no delay, place at elementposition +/- 0.
										#else
											translate PositionArray[(i-SmokeDelay)]	// Else, place at position [i-delay]
										#end
										scale 1-k*0.01
									}
									#declare k=k+1;								
								#end // end #while(k<SmokeDens)
							#end // end #if(EmissArray[i]>0)
					 #end 	// end #if(i>=(number_of_elements-TrailLength))
					 #else	// if not in "cut-off-the-trail-mode"
					 #if(EmissArray[i]> 0)	// eliminates invisible elements
						 	#declare k=1;						 	
					   	#while(k<SmokeDens+1)					   	  
								object{
									TrailObject(SizeArray[i], TurbArray[i],EmissArray[i],PreviewMode)
									#ifndef(dont_random_rotate)
									  rotate <360*rand(Seed[k-1]),360*rand(Seed[k-1]),360*rand(Seed[k-1])>
									#end
									#ifdef(ConstRotation)
										rotate VectorArray[i]*DegRotArray[i]
									#end				
									#if(SmokeDelay=0)
										translate PositionArray[i]	// If no delay, place at elementposition +/- 0.
									#else
										translate PositionArray[(i-SmokeDelay)]	// Else, place at position [i-delay]
									#end
									scale 1-k*0.01
								}								
								#declare k=k+1;								
							#end // end #while(k<SmokeDens)						
					 #end // end #if(EmissArray[i]>0)
				#end // end #ifdef(TrailLength)
		#end // end #if((number_of_elements>=SmokeDelay) & (i>=SmokeDelay))
		#declare i=i+1;   		
	#end // end #while(i<number_of_elements)

#end // end #macro CreatePovRayObjects()

//----------------------------------------------------------------------------------------------------------------------------------------
// Prepares for the next time the file is included
#macro ComputeChanges()
	#declare r2=seed(1);
	#declare r3=seed(1);
	#declare r4=seed(1);
		                                
	#if(number_of_elements>SmokeDelay)	// fixes the delay bug
		#declare lmntcounter=0;					
		#while(lmntcounter<number_of_elements)			
			#local TempVar=PositionArray[lmntcounter].y + ConstAscendRate + MaxRandAscend*rand(r2);
			#local TempVector=<PositionArray[lmntcounter].x, TempVar, PositionArray[lmntcounter].z>;
			
			#declare PositionArray[lmntcounter]=TempVector;			
						
			#if(DanceStrength>0)
			  #ifdef(DanceRate)
			    #declare PositionArray[lmntcounter]=PositionArray[lmntcounter]+sin(lmntcounter/DanceRate)*DanceStrength*WindDir+(WindStrength*WindDir);	// Wind influence: "Dancing" + Constant dev.
			  #else
			    #ifndef(DanceRateErrorDebugged)			      
			      #debug "DanceRate is not declared. \"SmokeDancing\" effect will not work. \n"
			      #declare DanceRateErrorDebugged=true;
			    #end
			  #end
			  //#debug concat(str(PositionArray[lmntcounter].x,0,4),"\n")
			#end
			
			#declare PositionArray[lmntcounter]=PositionArray[lmntcounter]+(WindStrength*WindDir);	// Wind influence
			
			
			#ifndef(MaxFinalSize)	// if no restriction
				#declare SizeArray[lmntcounter]=SizeArray[lmntcounter]+MaxSizeInc*rand(r3);  // Size transformations
			 #else	
			 	#if(SizeArray[lmntcounter]+MaxSizeInc*rand(r3) <= MaxFinalSize)	// if increment+current size does not exceed MaxTotalSize..
			 		#declare SizeArray[lmntcounter]=SizeArray[lmntcounter]+MaxSizeInc*rand(r3);  // Size transformations			 		
			 	#end
			#end
			
			#declare DegRotArray[lmntcounter]=DegRotArray[lmntcounter]+ConstRotation+MaxRandRot*rand(r4);		// Rotation
			#declare TurbArray[lmntcounter]=TurbArray[lmntcounter]+TurbIncRate;	// Turbulence
	  		#if ( (EmissArray[lmntcounter]>=MinEmiss) & (EmissArray[lmntcounter]<=MaxEmiss) ) // Emission
	  			#declare EmissArray[lmntcounter]=EmissArray[lmntcounter]+Trend; 		
	  		#end		
			
			#declare lmntcounter=lmntcounter+1;			
			
		#end   		
	#end                     	                

  #if(number_of_elements>0)		
  	#if(number_of_elements>1)     //=>if theres at least 2 vectors available =>starts at frame 2 	
  		#declare lmntcounter=0;
  		#while(lmntcounter<(number_of_elements-1))
  			#declare VectorArray[lmntcounter]=vnormalize(PositionArray[lmntcounter+1]-PositionArray[lmntcounter]); // Calculates the normals
  			#declare lmntcounter=lmntcounter+1;				
  		#end         
  		#declare VectorArray[lmntcounter]=<0,0,0>;
  	 #else		
  		#declare VectorArray[0]=<0,0,0>;
  	#end
  #end
#end // #macro ComputeChanges() 

//----------------------------------------------------------------------------------------------------------------------------------------
// Re-writes the element file
#macro WriteTheElementsBackToFile()
	#fopen LmntFile concat("source",str(SourceID,0,0),".txt") write // 
		#write (LmntFile,"// Format: Count, Position , Size(radius) ,  UnitVector ,  Rotation in degrees ,  Turbulence , Emission.","\n","\n")
		#declare lmntcounter=0;
		#while(lmntcounter<number_of_elements)			
			#write (LmntFile, (lmntcounter+1),", ", PositionArray[lmntcounter],", ",SizeArray[lmntcounter],", ",VectorArray[lmntcounter],", ",DegRotArray[lmntcounter],", ",TurbArray[lmntcounter],", ",EmissArray[lmntcounter],", ","\n")
			#declare lmntcounter=lmntcounter+1;
		#end	
	#fclose LmntFile 
#end // #macro WriteTheElementsBackToFile()

//----------------------------------------------------------------------------------------------------------------------------------------
// Creates elements generated during [FramesElapsed] number of frames
#macro SimulateElapsedTime()
		CountTheElements() 
		CreateTheArrays(FramesElapsed+1) // Make room for those generated during [FramesElapsed] frames plus the new one
		ReadInAllElements()				
	  #ifdef(SceneStartClock)
	    // if spline file mode
	    #ifdef(SplineFile)
  	    #ifdef(SplineClockStart)
    	    #ifdef(SplineClockStop)
    	      IfDebug("Time simulation mode 2 used (using splinefile)\n")
    	      #declare spline_clock=SplineClockStart;
    	      #declare clock_increase=(SplineClockStop-SplineClockStart)/FramesElapsed;
    	      #while ((spline_clock<SplineClockStop)&(clock=SceneStartClock))    	
    	        #include SplineFile
    	        #declare obj_pos=spline_pos;
      				AddElement_nofile()	
      				AffectWithEffects()								
      				ComputeChanges()      				
      				#declare number_of_elements=number_of_elements+1;    	            	        
      				#declare spline_clock=spline_clock+clock_increase;
    	      #end    	      
          #end // ifdef(SplineClockStop)
    		#end // ifdef(SplineClockStart)
    	// if static source mode
	    #else	    	      	    
	      IfDebug("Time simulation mode 1 used (using static obj_pos)\n")
  			#declare i=0;	    			
  		  #while((i<FramesElapsed)&(clock=SceneStartClock))	    		  			    
  				AddElement_nofile()	
  				AffectWithEffects()								
  				ComputeChanges()
  				#declare number_of_elements=number_of_elements+1;
  				#declare i=i+1;	  
  			#end  			  			
			#end // ifdef(SplineFile)
			WriteTheElementsBackToFile()			
		#end
#end

//----------------------------------------------------------------------------------------------------------------------------------------
// No comments on this one...
#macro ShowCommercials()
	#if(SourceID=1)                                                             
	   #debug concat("\n","\n","\n")
	   #debug concat("This scene is using SmokeGen 1.2(M) by Mikael Carneholm.","\n")
	   #debug concat("Homepage: http://www.studenter.hb.se/~arch/smokegen","\n")
	#end
#end // #macro ShowCommercials()


//****************************************************************************************************************************************
//****************************************************************************************************************************************
// MAIN	  

	CheckParams()	
	SetDefaults()	
	CreateFileIfNewSession()
	#ifdef(FramesElapsed)
	  SimulateElapsedTime()
	#end
	#ifdef(obj_pos)
	  AddElement()	  
	#end
	CountTheElements()
	CreateTheArrays(0)
	ReadInAllElements()
	AffectWithEffects()	
	CreatePovRayObjects()
	ComputeChanges()
	WriteTheElementsBackToFile()	
	//ShowCommercials()		

  //global_settings { max_trace_level TraceLevel
