
//*************************************************************************************
// SmokeGen 1.2 example file.
// Example showing how to use SmokeGen with a static smoke source
// 
// To animate, render with the following INI settings: (or use Static.ini)
// Antialias_Threshold=0.01	(+a0.01)
// Initial_Clock=0  				(+KI0.0) 
// Final_Clock=1    				(+KF1.0)
// Initial_Frame=1  				(+KFI1)
// Final_Frame=50   				(+KFF50)
//
//*************************************************************************************

#include "Colors.inc"
#include "AshTray.inc"

//*************************************************************************************
// STATIC OBJECTS
//*************************************************************************************                 

// The camera
camera
{
  location  <0.0, 0.5, -5*1.0>
  direction 1.5*z
  right     image_width/image_height*x
  look_at   <0.1, -0.1,  0.0>
}

// A point lightsource
light_source
{
  0*x 
  color red 1.0  green 1.0  blue 1.0
  translate <-30, 30, -30>
}

// A spotlight 
light_source
{
  0*x                     
  color rgb <1,1,1>       
  spotlight               
  translate <30, 30, 0> 
  point_at <0, 0, 0>      
  radius 2                
  tightness 50            
  falloff 8               
}  

// A plane used as table
plane { y, -1 pigment {color rgb <0.7,0.5,0.28>}}

// The CSG ashtray
object{AshTrayWCigarette}

//*************************************************************************************
// SMOKEGEN SPECIFIC
//*************************************************************************************                 

// Include the params for this scene:
#include "Params1.inc"		//Params1 = time simulation is used
//#include "Params2.inc"	//Params2 = time simulation is not used

// Now that the params are set, we are ready to go:
#include "Mikael Carneholm\SmokeGen\SmokeGen.inc"

//*************************************************************************************
// EOF