//*************************************************************************************************
//   As POV-Ray currently doesnt have a "point object", you cant do this:
//
//   #declare CubeWithSmokeSources=
//   union
//   {
//   	MyCube // previously declared object
//	point{"point1", <0.9,0.9,0.9>}	// This would create a point object called point1 at <0.9,0.9,0.9>
//	point{"point2", <-0.9,0.9,0.9>}	// ...point2...
//	...
// 	point{"point8", <-0.9,-0.9,-0.9>}
//
//	rotate clock*360	// this would affect the points as well
//	translate <0,5,0>	// this would affect the points as well
//   }
//
//   Just a little suggestion to the POV-Team from my point ;)! of view.
//*************************************************************************************************

//*************************************************************************************************
// The point-declaring macro. 
//
// So far, this is the most logical way to make the cube 
// with its smoke sources object-oriented. (See above suggestion)

#macro point(index,position,rotation,transformation)
	#declare source_point[index]=vrotate(position,rotation)+transformation;	
#end

//*************************************************************************************************
// EOF
