
//*************************************************************************************
// SmokeGen 1.2 example file.
// Example showing how to use "time simulation" together with a spline file
//
// Render with the following INI settings: (or use SplFile1.ini | SplFile2.ini)
// Initial_Clock=0  (+KI0.0)
// Final_Clock=1    (+KF1.0)
// Initial_Frame=1  (+KFI1)
// Final_Frame=50   (+KFF50)
//
//*************************************************************************************

#include "Colors.inc" // Standard POV color definitions
#include "Autofly.inc" // AutoFly is used to stear the plane
#include "CSGPlane.inc" // File containing the definition of the CSG Biplane
#include "SGMacros.inc" // File containing the macros PointCameraAt() and PointSpotAt()

//*************************************************************************************
// STATIC OBJECTS
//*************************************************************************************                 

// The camera
camera{
  location  <-25, 7, -1>
	direction 1.5*z
	right     4/3*x
	look_at		<0,0,5>
}

// An area_light lightsource:
light_source{
  <0, 1000, 0>
  color rgb <1,1,1>
  area_light <100,0,100>, <-100,0,-100>, 5, 5    
}
 
// A spotlight 
light_source
{
	<0, 50, -50>
	color rgb <1,1,1>       
	spotlight                 
  point_at <10,0,0>
	radius 5
	tightness 0
	falloff 15
}

// A plane used as ground
plane{ y, -3 pigment {color rgb <0.7,0.5,0.3>}} 

//*************************************************************************************
// MOVING OBJECTS
//*************************************************************************************                 

// The CSG Biplane
object{
	BiPlane scale 1.5 rotate y*-90
	AutoFly("Path.spl",clock,0.01,0.01,1,true)
}

//*************************************************************************************
// SMOKEGEN SPECIFIC
//*************************************************************************************                 

// Include the params for this scene:
#include "Params.inc" 
// Now that the params are set, we are ready to go:
#include "SmokeGen.inc"	

//*************************************************************************************
// OPTIONAL
//*************************************************************************************
// As obj_pos previously was declared, we can also use that for aiming the camera, 
// using the PointCameraAt() macro:

//	PointCameraAt(obj_pos+<0,1,0>) 

//*************************************************************************************
// EOF